/*
 * Copyright (c) 2001-2007, TIBCO Software Inc.
 * Use, modification, and distribution subject to terms of license.
 */
jsx3.Package.definePackage("jsx3.chart",function(s){s.q2=s.ADDIN.getVersion();s.qN=s.ADDIN.getPath()+"properties/";s.mK=s.ADDIN.getPath()+"events/";s.LOG=jsx3.util.Logger.getLogger(s.jsxpackage.getName());s.LOG_BENCH=jsx3.util.Logger.getLogger(s.jsxpackage.getName()+".benchmark");s.QTOP="top";s.QRIGHT="right";s.QBOTTOM="bottom";s.QLEFT="left";s.splitBox=function(k,n,i,o,b,l,h){var J=null,zb=null;if(b==s.QTOP){J=[k,n,i,Math.min(h,o-1)];zb=[k,n+J[3],i,o-J[3]];}else{if(b==s.QRIGHT){var H=Math.min(l,i-1);J=[k+i-H,n,H,o];zb=[k,n,i-H,o];}else{if(b==s.QBOTTOM){var x=Math.min(h,o-1);J=[k,n+o-x,i,x];zb=[k,n,i,o-x];}else{if(b==s.QLEFT){J=[k,n,Math.min(l,i-1),o];zb=[k+J[2],n,i-J[2],o];}}}}return [J,zb];};s.isValueAxis=function(n){return s.LinearAxis&&n instanceof s.LinearAxis||s.LogarithmicAxis&&n instanceof s.LogarithmicAxis;};s.isCategoryAxis=function(g){return s.CategoryAxis&&g instanceof s.CategoryAxis;};s.o9=function(m){if(m==null)return null;var v=m.split(/\s*[,;]\s*/);if(v[0]==="")v.shift();if(v.length>0&&v[v.length-1]==="")v.pop();return v;};s.asNumber=function(l){if(l==null)return null;if(typeof(l)=="number")return l;return new Number(l);};s.parseGradient=function(o){if(!o)return null;var Cb=o.split(/\s+/);if(Cb[0]==="")Cb.shift();if(Cb.length>0&&Cb[Cb.length-1]==="")Cb.pop();if(Cb.length==0)return null;if(Cb.length>4)return [Cb[0],Cb[1],Cb[2],Cb.slice(3).join(" ")];return Cb;};s.addGradient=function(a,c){var Zb=s.parseGradient(c);if(a!=null&&Zb!=null){var mc=new jsx3.vector.Fill(a.getColor(),a.getAlpha());mc.setType("gradient");mc.setColor2(Zb[0]);mc.setAngle(Zb[1]);mc.setAlpha2(Zb[2]);mc.setColors(Zb[3]);return mc;}else{return a;}};});if(jsx3.IDE){jsx3.ide.loadTemplateCatalog("prop","properties/catalog.xml",jsx3.chart.ADDIN);jsx3.ide.loadTemplateCatalog("event","events/catalog.xml",jsx3.chart.ADDIN);}jsx3.Package.definePackage("jsx3.vector",function(g){g.n1="px";g.PQ="v";g.eZ=function(e){return typeof(e)=="number"?"#"+(e+16777216).toString(16).substring(1):""+e;};g.x0=function(b,i,j){if(b==null)b=0;if(i==null)i=g.n1;if(typeof(b)=="number"){return b+""+i;}else{b=b.toString();b=b.replace(/^\s*(.*?)\s*$/,"$1");if(j)b=b.replace(/[^\d\.]/g,"");return b.match(/[^\d\.]/)?b:b+""+i;}};g.AP=function(o,n){return g.x0(o)+","+g.x0(n);};g.ZO=function(o,n){return g.x0(o,"",true)+" "+g.x0(n,"",true);};g.F0=function(r){return Math.max(0,Math.min(1,r));};g.degreesToRadians=function(k){return Math.modpos(2*Math.PI/360*(-1*k+90),2*Math.PI);};});jsx3.Class.defineClass("jsx3.html.Tag",null,null,function(g,q){var Kb=jsx3.Exception;g.Jg=[];q.ij=null;q.vo=null;if(jsx3.CLASS_LOADER.VML){q.init=function(e,m){this.ij=m;this.vo=e;this.nD=document.createElement(e?e+":"+m:m);this.vu=null;this.yg=null;};q.appendChild=function(c){if(this._P(c)){if(c instanceof g&&c.getParent()!=null){throw new Kb("can't append "+c+" to "+this+", already has parent "+c.vu);}if(this.yg==null)this.yg=[];this.yg.push(c);c.vu=this;}else{throw new Kb("Illegal to append child "+c+" to parent "+this+".");}};q.removeChild=function(d){if(this.yg){var Pb=this.yg.indexOf(d);if(Pb>=0){this.yg[Pb].vu=null;this.yg.splice(Pb,1);}}};q.replaceChild=function(h,i){if(this.yg){var I=this.yg.indexOf(i);if(I>=0){this.yg[I].vu=null;this.yg[I]=h;h.vu=this;}}};q.removeChildren=function(){if(this.yg)this.yg.splice(0,this.yg.length);};}else{if(jsx3.CLASS_LOADER.SVG){q.init=function(f,n){this.ij=n;this.vo=f;if(n)this.nD=f?document.createElementNS(f,n):document.createElement(n);this.vu=null;this.yg=null;};q.appendChild=function(n){if(this._P(n)){if(n instanceof g&&n.getParent()!=null){throw new Kb("can't append "+n+" to "+this+", already has parent "+n.vu);}if(this.yg==null)this.yg=[];this.yg.push(n);n.vu=this;this.nD.appendChild(n.nD);}else{throw new Kb("Illegal to append child "+n+" to parent "+this+".");}};q.removeChild=function(d){if(this.yg){var wb=this.yg.indexOf(d);if(wb>=0){this.yg[wb].vu=null;this.yg.splice(wb,1);}}this.nD.removeChild(d.nD);};q.replaceChild=function(j,e){if(this.yg){var W=this.yg.indexOf(e);if(W>=0){this.yg[W].vu=null;this.yg[W]=j;j.vu=this;}}this.nD.replaceChild(j.nD,e.nD);};q.removeChildren=function(){if(this.yg)this.yg.splice(0,this.yg.length);var hc=this.nD.childNodes;for(var Kc=hc.length-1;Kc>=0;Kc--)this.nD.removeChild(hc[Kc]);};}}q.getParent=function(){return this.vu;};q.getChildren=function(){return this.yg==null?g.Jg:this.yg;};q.getId=function(){return this.nD.id;};q.setId=function(l){this.setProperty("id",l);};q.getClassName=function(){return this.nD.className;};q.setClassName=function(n){this.setProperty("className",n);};q.setExtraStyles=function(f){try{this.nD.style.cssText+=(";"+f);}catch(Kc){throw new Kb("Error appending '"+f+"' to 'cssText': "+jsx3.NativeError.wrap(Kc));}};q.release=function(){delete this.vu;if(this.yg){for(var gc=this.yg.length-1;gc>=0;gc--){if(this.yg[gc].release)this.yg[gc].release();}delete this.yg;}};q._P=function(n){return true;};q._T=function(o){return true;};q.setProperty=function(j,e){var Ic=arguments;for(var Ec=0;Ec<Ic.length;Ec=Ec+2){j=Ic[Ec];e=Ic[Ec+1];if(e!=null)this.nD.setAttribute(j,e);else this.nD.removeAttribute(j);}};if(jsx3.CLASS_LOADER.SVG){q.setPropertyNS=function(b,a,n){if(n!=null)this.nD.setAttributeNS(b,a,n);else this.nD.removeAttributeNS(b,a);};}q.getProperty=function(i){return this.nD.getAttribute(i);};q.removeProperty=function(l){var S=arguments;for(var ec=0;ec<S.length;ec++)this.nD.removeAttribute(S[ec]);};q.setStyle=function(m,b){var Db=arguments;for(var G=0;G<Db.length;G=G+2){m=Db[G];b=Db[G+1];try{this.nD.style[m]=b==null?"":b;}catch(Kc){throw new Kb("Error setting style '"+m+"' to '"+b+"': "+jsx3.NativeError.wrap(Kc));}}};q.getStyle=function(l){return this.nD.style[l];};q.removeStyle=function(s){var lb=arguments;for(var Jc=0;Jc<lb.length;Jc++)this.nD.style[lb[Jc]]="";};q.getTagName=function(){return this.ij;};q.getTagNS=function(){return this.vo;};if(jsx3.CLASS_LOADER.VML){q.paint=function(){this.paintUpdate();var ec=[];var D=this.k1(ec,0);return ec.slice(0,D).join("");};q.k1=function(k,s){var gb=this.yg;var ac=jsx3.html.getOuterHTML(this.nD);ac=ac.replace(/^<(\w+(\:\w+)?)\b/,function(d,f){return "<"+f.toLowerCase();});ac=ac.replace(/\b([_a-zA-Z]\w*)=([^\s\"]+) /g,"$1=\"$2\" ");var F=ac.lastIndexOf("</");if(F>=0&&ac.substring(F).indexOf(this.nD.nodeName)!=2)F=-1;if(gb!=null&&gb.length>0){var L=null,T=null;if(F>=0){L=ac.substring(0,F);T=ac.substring(F);}else{L=ac;T="</"+this.nD.nodeName.toLowerCase()+">";}k[s++ ]=L;for(var Wb=0;Wb<gb.length;Wb++){var Zb=gb[Wb];if(typeof(Zb)=="string")k[s++ ]=Zb;else s=Zb.k1(k,s);}k[s++ ]=T;}else{if(F>=0)k[s++ ]=ac.substring(0,F-1);else k[s++ ]=ac.substring(0,ac.length-1);k[s++ ]="/>";}return s;};}else{if(jsx3.CLASS_LOADER.SVG){q.paintDom=function(){this.paintUpdate();return this.nD;};}}q.paintUpdate=function(){var sb=this.yg;if(sb){for(var L=0;L<sb.length;L++)sb[L].paintUpdate();}};q.toString=function(){return "<"+this.getTagName()+"#"+this.getId()+"/>";};q.getFirstChildOfType=function(m){if(typeof(m)=="string")m=jsx3.Class.forName(m).getConstructor();if(this.yg){var tb=this.yg;for(var Fb=0;Fb<tb.length;Fb++){if(tb[Fb] instanceof m)return tb[Fb];}}return null;};});jsx3.Class.defineClass("jsx3.html.Text",jsx3.html.Tag,null,function(q,g){if(jsx3.CLASS_LOADER.VML){g.init=function(p){this.Iw=p;};g.k1=function(a,j){a[j]=this.Iw;return j+1;};g.getText=function(){return this.Iw;};g.setText=function(b){this.Iw=b;};g.paint=function(){return this.Iw;};}else{if(jsx3.CLASS_LOADER.SVG){g.init=function(n){this.nD=document.createTextNode(n!=null?n:"");};g.getText=function(){return this.nD.nodeValue;};g.setText=function(l){this.nD.nodeValue=l;};}}g._P=function(k){return false;};g.toString=function(){return "[jsx3.html.Text \""+this.getText()+"\"]";};});jsx3.Class.defineClass("jsx3.html.BlockTag",jsx3.html.Tag,null,function(b,l){l.init=function(c,q,r,e,h,f){this.jsxsuper(c,q);this.setDimensions(r,e,h,f);};l.getLeft=function(){var Kc=this.getStyle("left");return Kc!=null?parseInt(Kc):null;};l.xi=function(q,m){if(m==null){this.setStyle(q,null);}else{var P=parseInt(m);if(isNaN(P))jsx3.chart.LOG.debug("trying to set "+q+" of "+this+" to "+m);else this.setStyle(q,P+"px");}};l.setLeft=function(a){this.xi("left",a);};l.getTop=function(){var qb=this.getStyle("top");return qb!=null?parseInt(qb):null;};l.setTop=function(r){this.xi("top",r);};l.getWidth=function(){var Ic=this.getStyle("width");return Ic!=null?parseInt(Ic):null;};l.setWidth=function(a){this.xi("width",a);};l.getHeight=function(){var ub=this.getStyle("height");return ub!=null?parseInt(ub):null;};l.setHeight=function(i){this.xi("height",i);};l.getMargin=function(){return this.getStyle("margin");};l.setMargin=function(o){this.setStyle("margin",o);};l.getPadding=function(){return this.getStyle("padding");};l.setPadding=function(a){this.setStyle("padding",a);};l.getPosition=function(){return this.getStyle("position");};l.setPosition=function(j){this.setStyle("position",j);};l.getZIndex=function(){return this.getStyle("zIndex");};l.setZIndex=function(m){this.setStyle("zIndex",m);};l.getBackgroundColor=function(){return this.getStyle("backgroundColor");};l.setBackgroundColor=function(c){this.setStyle("backgroundColor",c);};l.getMarginDimensions=function(){return b.nR(this.getMargin());};l.getPaddingDimensions=function(){return b.nR(this.getPadding());};b.nR=function(c){if(c){if(typeof(c)=="number"){return [c,c,c,c];}else{var v=(""+c).split(/[^\d\-]+/);if(v[0]==="")v.shift();if(v.length>0&&v[v.length]==="")v.pop();if(v.length>=4){return [parseInt(v[0]),parseInt(v[1]),parseInt(v[2]),parseInt(v[3])];}else{if(v.length>=1){var G=parseInt(v[0]);return [G,G,G,G];}}}}return [0,0,0,0];};l.getDimensions=function(){return [this.getLeft(),this.getTop(),this.getWidth(),this.getHeight()];};l.setDimensions=function(k,n,i,o){if(k instanceof Array){this.setLeft(k[0]);this.setTop(k[1]);this.setWidth(k[2]);this.setHeight(k[3]);}else{this.setLeft(k);this.setTop(n);this.setWidth(i);this.setHeight(o);}};});jsx3.Class.defineInterface("jsx3.html.FontTag",null,function(q,s){s.getFontFamily=function(){return this.getStyle("fontFamily");};s.setFontFamily=function(a){this.setStyle("fontFamily",a);};s.getFontSize=function(){return this.getStyle("fontSize");};s.setFontSize=function(h){this.setStyle("fontSize",isNaN(h)?h:h+"px");};s.getFontStyle=function(){return this.getStyle("fontStyle");};s.setFontStyle=function(f){this.setStyle("fontStyle",f);};s.getFontWeight=function(){return this.getStyle("fontWeight");};s.setFontWeight=function(e){this.setStyle("fontWeight",e);};s.getTextAlign=function(){return this.getStyle("textAlign");};s.setTextAlign=function(l){this.setStyle("textAlign",l);};s.getTextDecoration=function(){return this.getStyle("textDecoration");};s.setTextDecoration=function(j){this.setStyle("textDecoration",j);};s.getColor=function(){return this.getStyle("color");};s.setColor=function(r){this.setStyle("color",r);};});jsx3.Class.defineClass("jsx3.vector.Canvas",jsx3.html.BlockTag,null,function(s,a){a.init=function(m,p,g,q){this.jsxsuper(jsx3.vector.PQ,"group",m,p,g,q);this.setProperty("xmlns:v","urn:schemas-microsoft-com:vml");};a.paintUpdate=function(){this.jsxsuper();if(this.getWidth()&&this.getHeight()){this.setProperty("coordsize",jsx3.vector.ZO(parseInt(this.getWidth()),parseInt(this.getHeight())));}else{this.setProperty("coordsize",jsx3.vector.ZO(100,100));}if(this.getPosition()!="absolute"){this.setLeft(null);this.setTop(null);}};});jsx3.Class.defineClass("jsx3.vector.Tag",jsx3.html.BlockTag,null,function(o,f){f.init=function(h,d,g,p,c){this.jsxsuper(jsx3.vector.PQ,h,d,g,p,c);};f.getToolTip=function(){return this.getProperty("title");};f.setToolTip=function(d){this.setProperty("title",d);};f.getRotation=function(){return this.getStyle("rotation");};f.setRotation=function(b){this.setStyle("rotation",b);};f.paintUpdate=function(){this.jsxsuper();var tc=this.getParent();if(this.getWidth()&&this.getHeight()){this.setProperty("coordsize",jsx3.vector.ZO(parseInt(this.getWidth()),parseInt(this.getHeight())));}else{this.removeProperty("coordsize");}};});jsx3.Class.defineClass("jsx3.vector.Stroke",jsx3.html.Tag,null,function(m,s){var gb=jsx3.vector;m.D1="stroke";s.init=function(p,j,h){this.jsxsuper(gb.PQ,m.D1);this.Vt=null;this.iD=p!=null?p:0;this.Ul=j!=null?j:1;this.Vz=h!=null?gb.F0(h):1;};s.getColor=function(){return this.iD;};s.getColorHtml=function(){return gb.eZ(this.iD);};s.setColor=function(e){this.iD=e;};s.getWidth=function(){return this.Ul;};s.setWidth=function(n){this.Ul=n;};s.getAlpha=function(){return this.Vz;};s.setAlpha=function(p){this.Vz=p!=null?gb.F0(p):null;};s._P=function(n){return false;};s.toString=function(){return "<stroke "+this.getColorHtml()+" "+this.Ul+" "+this.Vz+"/>";};s.paint=function(){var qb="<"+gb.PQ+":"+this.getTagName();if(this.getId()!=null)qb=qb+(" id='"+this.getId()+"'");var db=this.getColorHtml();if(this.Vt!=null)qb=qb+(" on='"+this.Vt+"'");if(db!=null)qb=qb+(" color='"+db+"'");if(this.Vz!=null&&this.Vz<1)qb=qb+(" opacity='"+this.Vz+"'");if(this.Ul!=null)qb=qb+(" weight='"+gb.x0(this.Ul)+"'");qb=qb+"/>";return qb;};s.k1=function(i,b){i[b]=this.paint();return b+1;};s.KJ=function(){return this.Vz==1||this.Vz==null;};m.valueOf=function(k){if(jsx3.util.strEmpty(k))return null;if(k instanceof m)return k;var Db=k.toString().split(/\s+/);return new m(Db[0],Db[1],Db[2]);};});jsx3.Class.defineClass("jsx3.vector.Fill",jsx3.html.Tag,null,function(c,b){var gb=jsx3.vector;c.D1="fill";b.init=function(e,m){this.jsxsuper(gb.PQ,c.D1);this.Vt=null;this.iD=e!=null?e:0;this.Vz=m!=null?gb.F0(m):1;this.Se=null;this.Xm=null;this.Tp=null;this.xs=null;this.al=null;};b.getColor=function(){return this.iD;};b.getColorHtml=function(){return gb.eZ(this.iD);};b.setColor=function(s){this.iD=s;};b.getAlpha=function(){return this.Vz;};b.setAlpha=function(l){this.Vz=l!=null?gb.F0(l):null;};b.getType=function(){return this.Se;};b.setType=function(g){this.Se=g;};b.getColor2=function(){return this.Xm;};b.getColor2Html=function(){return gb.eZ(this.Xm);};b.setColor2=function(n){this.Xm=n;};b.getAlpha2=function(){return this.Tp;};b.setAlpha2=function(m){this.Tp=m;};b.getAngle=function(){return this.xs;};b.setAngle=function(l){this.xs=l;};b.getColors=function(){return this.al;};b.setColors=function(l){this.al=l;};b.toString=function(){return "<fill "+this.getColorHtml()+" "+this.getAlpha()+"/>";};b.paint=function(){var O="<"+gb.PQ+":"+this.getTagName();if(this.getId()!=null)O=O+(" id='"+this.getId()+"'");var mb=this.getColorHtml();if(this.Vt!=null)O=O+(" on='"+this.Vt+"'");if(mb!=null)O=O+(" color='"+mb+"'");if(this.Vz!=null&&this.Vz<1)O=O+(" opacity='"+this.Vz+"'");if(this.Se&&this.Se!="solid"){O=O+(" type='"+this.Se+"'");var yb=this.getColor2Html();if(yb!=null)O=O+(" color2='"+yb+"'");if(this.al!=null)O=O+(" colors='"+this.al+"'");if(this.xs!=null)O=O+(" angle='"+this.xs+"'");if(this.Tp!=null)O=O+(" o:opacity2='"+this.Tp+"'");}O=O+"/>";return O;};b.k1=function(i,f){i[f]=this.paint();return f+1;};b.KJ=function(){return (this.Vz==1||this.Vz==null)&&(!this.Se||this.Se=="solid");};c.valueOf=function(l){if(jsx3.util.strEmpty(l))return null;if(l instanceof c)return l;var pc=l.toString().split(/\s+/);return new c(pc[0],pc[1]);};b._P=function(o){return false;};});jsx3.Class.defineClass("jsx3.vector.Group",jsx3.vector.Tag,null,function(i,k){k.init=function(p,s,d,a){this.jsxsuper(i.D1,p,s,d,a);};i.D1="group";k._P=function(a){return a instanceof i||a instanceof jsx3.vector.Shape;};});jsx3.Class.defineClass("jsx3.vector.Shape",jsx3.vector.Tag,null,function(j,n){var _b=jsx3.html.Tag;var lb=jsx3.vector;n.init=function(b,e,h,o,i){this.jsxsuper(b!=null?b:j.D1,e,h,o,i);this.Rl=null;this.sw=null;};n.getPath=function(){return this.getProperty("path");};n.setPath=function(o){this.setProperty("path",o);};n.X6=function(q,p,h){this.vr((h?"t":"m")+" "+q+" "+p);return this;};n.Z7=function(m,l,d){this.vr((d?"r":"l")+" "+m+" "+l);return this;};n.XZ=function(p,o,g,f,i,m,e,l,a){this.vr((a?"wa":"at")+" "+(p-g)+" "+(o-f)+" "+(p+g)+" "+(o+f)+" "+i+" "+m+" "+e+" "+l);return this;};n.w9=function(){this.vr("x");return this;};n.vr=function(m){var sc=this.getPath();if(!sc)this.setPath(m);else this.setPath(sc+" "+m);};j.D1="shape";n.paintUpdate=function(){var Yb=this.getChildren().clone();for(var zb=0;zb<Yb.length;zb++){if(typeof(Yb[zb])=="string")this.removeChild(Yb[zb]);}this.jsxsuper();this.setProperty("filled",this.getFill()==null?"false":null,"stroked",this.getStroke()==null?"false":null);if(this.Rl!=null){if(this.Rl.KJ()){this.setProperty("filled",this.Rl.Vt!=null?this.Rl.Vt?"true":"false":null,"fillcolor",this.Rl.getColorHtml());}else{this.removeProperty("filled","fillcolor");this.appendChild(this.Rl.paint());}}if(this.sw!=null){if(this.sw.KJ()){var Dc=this.sw.getWidth();this.setProperty("stroked",this.sw.Vt!=null?this.sw.Vt?"true":"false":null,"strokecolor",this.sw.getColorHtml(),"strokeweight",Dc!=null?lb.x0(Dc):null);}else{this.removeProperty("stroked","strokecolor","strokeweight");this.appendChild(this.sw.paint());}}};n._P=function(o){return o instanceof lb.TextLine||o instanceof lb.Fill||o instanceof lb.Stroke||typeof(o)=="string";};n.setFill=function(p){this.Rl=p;};n.setStroke=function(i){this.sw=i;};n.getFill=function(){return this.Rl;};n.getStroke=function(){return this.sw;};});jsx3.Class.defineClass("jsx3.vector.Line",jsx3.vector.Shape,null,function(k,n){n.init=function(g,j,f,m,e,l){var Lc=Math.max(g,Math.max(f,e))-Math.min(g,Math.min(f,e));var Hc=Math.max(j,Math.max(m,l))-Math.min(j,Math.min(m,l));this.jsxsuper("line",g,j,Math.max(Lc,16),Math.max(Hc,16));this.IF=f;this.Yu=m;this.iG=e;this.QC=l;};n.fS=function(c,j,b,i){this.IF=c;this.Yu=j;this.iG=b;this.QC=i;var U=this.getLeft();var ic=this.getTop();var Lc=Math.max(U,Math.max(c,b))-Math.min(U,Math.min(c,b));var sc=Math.max(ic,Math.max(j,i))-Math.min(ic,Math.min(j,i));this.setWidth(Lc);this.setHeight(sc);};n.getX1=function(){return this.IF;};n.setX1=function(s){this.IF=s;};n.getY1=function(){return this.Yu;};n.setY1=function(d){this.Yu=d;};n.getX2=function(){return this.iG;};n.setX2=function(c){this.iG=c;};n.getY2=function(){return this.QC;};n.setY2=function(i){this.QC=i;};n.paintUpdate=function(){this.jsxsuper();this.removeProperty("coordsize");this.setProperty("from",jsx3.vector.ZO(this.IF,this.Yu),"to",jsx3.vector.ZO(this.iG,this.QC));};n.toString=function(){return "<line "+this.getId()+" {"+this.getX1()+","+this.getY1()+"} {"+this.getX2()+","+this.getY2()+"}/>";};});jsx3.Class.defineClass("jsx3.vector.Rectangle",jsx3.vector.Shape,null,function(r,i){i.init=function(p,s,d,a){this.jsxsuper("rect",p,s,d,a);};i.bI=function(p){this.ET(p.getLeft(),p.getTop(),p.getWidth(),p.getHeight());};i.ET=function(l,k,m,c){var xb=Math.max(this.getLeft(),l);var T=Math.max(this.getTop(),k);var vc=Math.min(this.getWidth()-(xb-this.getLeft()),l+m-xb);var Fb=Math.min(this.getHeight()-(T-this.getTop()),k+c-T);this.setDimensions(xb,T,vc,Fb);};i.paintUpdate=function(){this.jsxsuper();this.removeProperty("coordsize");};});jsx3.Class.defineClass("jsx3.vector.Oval",jsx3.vector.Shape,null,function(a,b){b.init=function(p,s,d,k){this.jsxsuper(a.D1,p,s,d,k);};a.D1="oval";b.paintUpdate=function(){this.jsxsuper();this.removeProperty("coordsize");};});jsx3.Class.defineClass("jsx3.vector.Polygon",jsx3.vector.Shape,null,function(r,o){o.init=function(k,n,q){this.jsxsuper("polyline",k,n);this.HG=null;this.XG=q;this.vG=q!=null?q.join(" "):null;};o.fS=function(i){this.HG=i;this.XG=null;this.vG=i!=null?i.join(" "):null;};o.OJ=function(b){this.HG=null;this.XG=b;this.vG=b!=null?b.join(" "):null;};o._Q=function(q){this.HG=null;this.XG=null;this.vG=q;};o.paintUpdate=function(){this.jsxsuper();this.setProperty("points",this.vG);};});jsx3.Class.defineClass("jsx3.vector.TextLine",jsx3.vector.Shape,[jsx3.html.FontTag],function(g,b){var bc=jsx3.html.Tag;var Ab=jsx3.app.Browser;var G=jsx3.vector;b.init=function(f,m,e,l,h){var Lc=Math.max(1,Math.max(f,e)-Math.min(f,e));var Hc=Math.max(1,Math.max(m,l)-Math.min(m,l));this.jsxsuper(null,f,m,Lc,Hc);this.setProperty("path","m 0 0 l "+(e-f)+" "+(l-m));this.ur=new bc(G.PQ,"textpath");this.ur.setProperty("on","true");this.Od=new bc(G.PQ,"path");this.Od.setProperty("textpathok","true");this.qu=new bc(G.PQ,"stroke");this.qu.setProperty("on","false");this.setText(h);};var ac="ur";var pb=jsx3.html.FontTag.jsxclass.getInstanceMethods();for(var Sb=0;Sb<pb.length;Sb++){var Ib=pb[Sb];b[Ib.getName()]=new Function("return jsx3.html.FontTag.prototype."+Ib.getName()+".apply(this."+ac+", arguments);");}var B=["getClassName","setClassName","setExtraStyles","setExtraStyles"];for(var Sb=0;Sb<B.length;Sb++){b[B[Sb]]=new Function("return jsx3.html.Tag.prototype."+B[Sb]+".apply(this."+ac+", arguments);");}b.setColor=function(i){if(i!=null&&i!="")this.setFill(new G.Fill(i));this.ur.setStyle("color",i);};b.getTextAlign=function(){return this.ur.getStyle("v-text-align");};b.setTextAlign=function(r){this.ur.setStyle("v-text-align",r);};b.getText=function(){return this.ur.getProperty("string");};b.setText=function(r){this.ur.setProperty("string",r);};b._P=function(h){var H=h.getTagName();return this.jsxsuper(h)||H=="path"||H=="textpath"||H=="stroke";};b.paintUpdate=function(){var Fb=null;if(this.getFill()==null){var tb=this.getColor();if(!tb){if(Fb==null)Fb=Ab.getStyleClass("."+this.getClassName())||Number(0);if(Fb)tb=Fb.color;}this.setFill(new G.Fill(tb||"#000000"));}if(!this.getTextAlign()){var Ec=this.ur.getStyle("textAlign");if(Ec==null){if(Fb==null)Fb=Ab.getStyleClass("."+this.getClassName())||Number(0);if(Fb)Ec=Fb.textAlign;}if(Ec)this.setTextAlign(Ec);}this.jsxsuper();this.setProperty("filled",this.getFill()==null?"false":"true","stroked",this.getStroke()==null?null:"true");if(this.ur.getParent()==null)this.appendChild(this.ur);if(this.Od.getParent()==null)this.appendChild(this.Od);if(this.getStroke()==null){if(this.qu.getParent()==null)this.appendChild(this.qu);}else{this.removeChild(this.qu);}};});jsx3.Class.defineClass("jsx3.vector.LineGroup",jsx3.vector.Shape,null,function(n,m){m.init=function(p,s,d,a){this.jsxsuper(null,p,s,d,a);};m.HS=function(h,o,g,b){this.X6(h,o).Z7(g,b);};m.aT=function(o,c,d,l){this.X6(o,c).Z7(d,l,true);};m.ZM=function(){this.setPath("");};});jsx3.Class.defineClass("jsx3.vector.RectangleGroup",jsx3.vector.Shape,null,function(h,r){r.init=function(p,s,d,a){this.jsxsuper(null,p,s,d,a);};r.C6=function(b,o,g,n){this.X6(b,o).Z7(g,o).Z7(g,n).Z7(b,n).w9();};r.pJ=function(o,c,q,m){this.X6(o,c).Z7(q,0,true).Z7(0,m,true).Z7(-1*q,0,true).w9();};r.OT=function(){this.setPath("");};});jsx3.Class.defineInterface("jsx3.chart.PointRenderer",null,function(i,b){var L=jsx3.vector;b.render=jsx3.Method.newAbstract("x1","y1","x2","y2","fill","stroke");b.areaToRadius=jsx3.Method.newAbstract("area");i.CIRCLE=i.jsxclass.newInnerClass();i.CIRCLE.areaToRadius=function(g){return Math.sqrt(g/Math.PI);};i.CIRCLE.render=function(k,r,j,q,l,h){var P=new L.Oval(k,r,j-k,q-r);P.setFill(l);P.setStroke(h);return P;};i.CROSS=i.jsxclass.newInnerClass();i.CROSS.Bq=0.6;i.CROSS.areaToRadius=function(p){return Math.sqrt(p/(1-this.Bq/Math.SQRT2))/2;};i.CROSS.render=function(k,r,j,q,l,h){var rc=j-k;var mc=this.Bq;var T=Math.round(rc*(1-mc)/2);var jb=Math.round(rc*mc/2);var vc=Math.round(rc-rc*(1-mc)/2);var ib=Math.round(rc/2);var Nc=new L.Polygon(0,0,[k,r,k+T,r,k+ib,r+jb,k+vc,r,j,r,j,r+T,j-jb,r+ib,j,r+vc,j,q,j-T,q,j-ib,q-jb,j-vc,q,k,q,k,q-T,k+jb,q-ib,k,q-vc,k,r]);Nc.setFill(l);Nc.setStroke(h);return Nc;};i.DIAMOND=i.jsxclass.newInnerClass();i.DIAMOND.Wn=1.2;i.DIAMOND.areaToRadius=function(n){return Math.sqrt(n)/2;};i.DIAMOND.render=function(a,h,s,g,r,o){var t=(a+s)/2;var Fb=(h+g)/2;var Xb=(s-a)/this.Wn;var Pb=(g-h)/this.Wn;var gc=new L.Rectangle(Math.round(t-Xb/2),Math.round(Fb-Pb/2),Math.round(Xb),Math.round(Pb));gc.setRotation(45);gc.setFill(r);gc.setStroke(o);return gc;};i.BOX=i.jsxclass.newInnerClass();i.BOX.areaToRadius=function(f){return Math.sqrt(i.DIAMOND.Wn*i.DIAMOND.Wn*f)/2;};i.BOX.render=function(l,s,k,r,m,j){var J=new L.Rectangle(l,s,k-l,r-s);J.setFill(m);J.setStroke(j);return J;};i.TRIANGLE=i.jsxclass.newInnerClass();i.TRIANGLE.areaToRadius=function(l){return Math.sqrt(2*l)/2;};i.TRIANGLE.render=function(d,k,a,h,c,s){var Kb=Math.round((d+a)/2);var E=new L.Polygon(0,0,[Kb,k,a,h,d,h,Kb,k]);E.setFill(c);E.setStroke(s);return E;};});jsx3.chart.Renderers=jsx3.chart.PointRenderer;jsx3.chart.Renderers.Circle=jsx3.chart.PointRenderer.CIRCLE;jsx3.chart.Renderers.Cross=jsx3.chart.PointRenderer.CROSS;jsx3.chart.Renderers.Diamond=jsx3.chart.PointRenderer.DIAMOND;jsx3.chart.Renderers.Box=jsx3.chart.PointRenderer.BOX;jsx3.chart.Renderers.Triangle=jsx3.chart.PointRenderer.TRIANGLE;jsx3.require("jsx3.gui.Block");jsx3.Class.defineClass("jsx3.chart.ChartComponent",jsx3.gui.Block,null,function(n,q){var oc=jsx3.gui.Event;var nc=jsx3.gui.Interactive;var Fb=jsx3.vector;var zb=jsx3.chart;n.Fd={};n.MASK_PROPS_NOEDIT={NN:false,SS:false,EE:false,WW:false,MM:false};n.MASK_PROPS_ALLEDIT={NN:true,SS:true,EE:true,WW:true,MM:true};n.MASK_PROPS_ALLEDITREL={NN:false,SS:true,EE:true,WW:false,MM:false};q.init=function(p){this.jsxsuper(p);this.hC=null;this.pg=null;};q.getChart=function(){return this.findAncestor(function(i){return zb.Chart&&i instanceof zb.Chart;},true);};q.l5=function(){if(this.hC==null)this.updateView();return this.hC;};if(jsx3.CLASS_LOADER.VML){q.paint=function(){var lc=zb.LOG_BENCH.isLoggable(jsx3.util.Logger.TRACE);if(this.hC==null){if(lc)zb.LOG_BENCH.trace("paint() update view - "+this.getId());this.updateView();}if(lc)zb.LOG_BENCH.trace("paint() serializing - "+this.getId());var z=this.hC.paint();if(lc)zb.LOG_BENCH.trace("paint() done - "+this.getId());return z;};q.repaint=function(){this.updateView();var Cb=this.jsxsuper();var Ic=this.getChart();if(Ic!=null){var P=Ic.getRendered();if(P!=null){var Ub=P.style.zIndex;if(Ub==null)Ub=0;P.style.zIndex=Ub+1;P.style.zIndex=Ub;}}return Cb;};}else{if(jsx3.CLASS_LOADER.SVG){q.isDomPaint=function(){return true;};q.paint=function(){throw new jsx3.Exception();};q.paintDom=function(){if(this.hC==null)this.updateView();return this.hC.paintDom();};q.repaint=function(){this.updateView();return this.jsxsuper();};}}q.doClone=function(p){this.hC=null;this.pg=null;return this.jsxsuper(p);};q.updateView=function(){this.applyDynamicProperties();var cc=null,N=null;if(this.hC!=null){N=this.hC;cc=N.getParent();}this.hC=this.lL().newInstance();this.hC.setId(this.getId());this.hC.setDimensions(this.getDimensions());this.hC.setZIndex(this.getZIndex());this.hC.setPosition(this.getRelativePosition()?"relative":"absolute");var xb=this.getAttributes();for(var R in xb)this.hC.setProperty(R,xb[R]);if(cc!=null){cc.replaceChild(this.hC,N);}if(N!=null)N.release();};q.lL=function(){return Fb.Group.jsxclass;};q.A3=function(p){if(p==null)p=this.hC;var mc={};if(this.getMenu()!=null)mc[oc.MOUSEUP]=true;if(this.hasEvent(nc.SELECT))mc[oc.CLICK]=true;if(this.hasEvent(nc.EXECUTE))mc[oc.DOUBLECLICK]=true;if(this.hasEvent(nc.SPYGLASS)){mc[oc.MOUSEOVER]="doSpyOver";mc[oc.MOUSEOUT]="doSpyOut";}this.lM(mc,p);};n.Jn="kE";if(jsx3.CLASS_LOADER.VML){q.lM=function(k,s){for(var x=0;x<nc.s5.length;x++){var Eb=nc.s5[x];var P="on"+Eb;var yc=[];var Jc=this.getAttribute(P);if(Jc){yc.push(Jc.replace(/\"/g,"&quot;"));if(!Jc.match(/;\s*$/))yc.push(";");}var O=k[Eb];if(O){if(typeof(O)!="string")O=nc.F5[Eb];yc.push("jsx3.GO('"+this.getId()+"')."+n.Jn+"(event,this,'"+O+"');");}if(yc.length>0)s.setProperty(P,yc.join(""));}};}else{if(jsx3.CLASS_LOADER.SVG){q.lM=function(h,p){var fc=h[oc.DOUBLECLICK];var ub=false;var Mc="lz";for(var Lb=0;Lb<nc.s5.length;Lb++){var Ob=nc.s5[Lb];if(Ob==oc.DOUBLECLICK)continue;var vc="on"+Ob;var vb=[];var O=this.getAttribute(vc);if(O){vb.push(O.replace(/\"/g,"&quot;"));if(!O.match(/;\s*$/))vb.push(";");}var wb=h[Ob];if(wb){if(Ob==oc.CLICK&&fc){vb.push("jsx3.GO('"+this.getId()+"')."+Mc+"(evt,this,true,true);");ub=true;}else{if(typeof(wb)!="string")wb=nc.F5[Ob];vb.push("jsx3.GO('"+this.getId()+"')."+n.Jn+"(evt,this,'"+wb+"');");}}if(vb.length>0)p.setProperty(vc,vb.join(""));}if(fc&&!ub)p.setProperty("onclick","jsx3.GO('"+this.getId()+"')."+Mc+"(evt,this,false,true);");};n.Cp=200;q.lz=function(k,e,j,d){var Q=k.detail>1;var W=nc.F5[Q?oc.DOUBLECLICK:oc.CLICK];var wc=this[W];var Y=jsx3.gui.Event.wrap(k);if(wc){if(!Q&&d){var rb=this;this._jsxPq=window.setTimeout(function(){delete rb._jsxPq;wc.call(rb,Y,e);},n.Cp);}else{if(this._jsxPq)window.clearTimeout(this._jsxPq);wc.call(this,Y,e);}}else{throw new jsx3.Exception("no bridge method '"+W+"' for event type '"+Y.getType()+"' on DOM object of id "+this.getId());}};}}q.AV=function(c){var mb=this.getBackgroundColor();if(mb!=null&&mb.match(/\S/)){var yc=c.getFirstChildOfType(Fb.Fill);if(yc==null){yc=new Fb.Fill();c.setFill(yc);}yc.setColor(mb);if(typeof(this.getAlpha)=="function")yc.setAlpha(this.getAlpha());}else{c.setFill(null);}};q.E_=function(a){var L=this.getBorderColor();if(L!=null&&L.match(/\S/)){var lc=a.getFirstChildOfType(Fb.Stroke);if(lc==null){lc=new Fb.Stroke();a.setStroke(lc);}lc.setColor(L);if(typeof(this.getBorderAlpha)=="function")lc.setAlpha(this.getBorderAlpha());if(typeof(this.getBorderWidth)=="function")lc.setWidth(this.getBorderWidth());}else{a.setStroke(null);}};q.uR=function(c,r){this[c]=r;this["_"+c+"_eval"]=null;};q.d8=function(a,h){if(h==null)h="object";var Xb="_"+a+"_eval";if(!this[Xb]&&this[a]){try{var bc=this.eval("var f = "+this[a]+"; f;");this[Xb]=bc;if(typeof(this[Xb])!=h){zb.LOG.error("error evaluating '"+a+"', "+this[Xb]+" is not of type "+h);this[Xb]=n.Fd;}}catch(Kc){Kc=jsx3.NativeError.wrap(Kc);this[Xb]=n.Fd;zb.LOG.error("error evaluating "+h+" field '"+a,Kc);}}return this[Xb]!=n.Fd?this[Xb]:null;};q.o_=function(r){return this.d8(r,"function");};q.toString=function(){return "[ChartComponent '"+this.getName()+"']";};q.xI=function(l,g){if(this.pg==null)this.pg={};this.pg[l]=g;};q.Q0=function(e){return this.pg!=null?this.pg[e]:null;};q.qX=function(r){if(this.pg!=null)delete this.pg[r];};q.getMaskProperties=function(){return n.MASK_PROPS_NOEDIT;};q.setLeft=function(k,o){this.jsxsuper(k,o);if(this.hC!=null&&this.getRelativePosition()==jsx3.gui.Block.ABSOLUTE)this.hC.setLeft(k);return this;};q.setTop=function(k,h){this.jsxsuper(k,h);if(this.hC!=null&&this.getRelativePosition()==jsx3.gui.Block.ABSOLUTE)this.hC.setTop(k);return this;};q.setWidth=function(p,d){this.jsxsuper(p);if(this.hC!=null){this.hC.setWidth(p);if(d)this.repaint();}return this;};q.setHeight=function(g,c){this.jsxsuper(g);if(this.hC!=null){this.hC.setHeight(g);if(c)this.repaint();}return this;};q.setRelativePosition=function(b,r){this.jsxsuper(b,r);if(this.hC!=null){if(b==jsx3.gui.Block.RELATIVE){this.hC.setPosition("relative");this.hC.setLeft(0);this.hC.setTop(0);}else{this.hC.setPosition("absolute");this.hC.setLeft(this.getLeft());this.hC.setTop(this.getTop());}}return this;};q.getMarginDimensions=function(){return this.nR(this.getMargin());};q.getPaddingDimensions=function(){return this.nR(this.getPadding());};q.nR=function(h){if(h){if(typeof(h)=="number"){return [h,h,h,h];}else{var N=(""+h).split(/\D+/);if(N[0]==="")N.shift();if(N.length>0&&N[N.length]==="")N.pop();if(N.length>=4){return [parseInt(N[0]),parseInt(N[1]),parseInt(N[2]),parseInt(N[3])];}else{if(N.length>=1){var hb=parseInt(N[0]);return [hb,hb,hb,hb];}}}}return [0,0,0,0];};q.getCanSpy=function(){return true;};n.getVersion=function(){return zb.q2;};});jsx3.require("jsx3.chart.ChartComponent");jsx3.Class.defineClass("jsx3.chart.ChartLabel",jsx3.chart.ChartComponent,null,function(j,p){var mc=jsx3.vector;j.DEFAULT_WIDTH=100;j.ROTATION_NORMAL=0;j.ROTATION_CW=90;j.ROTATION_CCW=270;p.init=function(n,s){this.jsxsuper(n);this.jsxtext=s;this.alpha=null;this.borderStroke=null;this.preferredWidth=null;this.preferredHeight=null;this.labelRotation=j.ROTATION_NORMAL;};p.getText=function(){return this.jsxtext;};p.setText=function(i){this.jsxtext=i;};p.getPreferredWidth=function(){if(this.preferredWidth!=null){return this.preferredWidth;}else{if(this.isRotated()){return this.In();}else{var Dc=this.getPaddingDimensions();return j.DEFAULT_WIDTH+Dc[0]+Dc[2];}}};p.setPreferredWidth=function(m){this.preferredWidth=m;};p.getPreferredHeight=function(){if(this.preferredHeight!=null){return this.preferredHeight;}else{if(this.isRotated()){var Ub=this.getPaddingDimensions();return j.DEFAULT_WIDTH+Ub[1]+Ub[3];}else{return this.In();}}};p.setPreferredHeight=function(c){this.preferredHeight=c;};p.In=function(){var N=this.getPaddingDimensions();var Qb=this.getFontSize()!=null?this.getFontSize():10;return Math.round(Qb*1.5)+(this.isRotated()?N[1]+N[3]:N[0]+N[2]);};p.getAlpha=function(){return this.alpha;};p.setAlpha=function(f){this.alpha=f!=null?mc.F0(f):null;};p.getBorderStroke=function(){return this.borderStroke;};p.setBorderStroke=function(m){this.borderStroke=m;};p.getLabelRotation=function(){return this.labelRotation;};p.setLabelRotation=function(q){this.labelRotation=q;};p.isRotated=function(){return this.labelRotation==j.ROTATION_CW||this.labelRotation==j.ROTATION_CCW;};p.updateView=function(){this.jsxsuper();var Vb=this.l5();var lc=this.getWidth();var Y=this.getHeight();var gb=this.getPaddingDimensions();this.A3();var ib=new mc.Rectangle(0,0,lc,Y);Vb.appendChild(ib);this.AV(ib);var T=ib.getFill();var Eb=mc.Stroke.valueOf(this.borderStroke);if(Eb!=null){ib.setStroke(Eb);}else{if(T!=null&&(this.alpha==null||this.alpha==1)){ib.setStroke(new mc.Stroke(T.getColor()));}}var O=0,Bc=0,Ub=0,hb=0;if(this.isRotated()){Ub=(hb=Math.round(gb[3]+(lc-gb[1]-gb[3])/2));if(this.labelRotation==j.ROTATION_CW){Bc=Y;}else{O=Y;}}else{O=(Bc=Math.round(Y/2));Ub=0;hb=lc;}var Lb=new mc.TextLine(Ub,O,hb,Bc,this.jsxtext);Lb.setColor(this.getColor());Lb.setClassName(this.getClassName());Lb.setFontFamily(this.jsxfontname);Lb.setFontWeight(this.jsxfontweight);Lb.setFontSize(this.jsxfontsize);Lb.setTextAlign(this.jsxtextalign);Vb.appendChild(Lb);};p.onResize=function(){var F=this.getParent();if(F!=null){if(jsx3.chart.Axis&&F instanceof jsx3.chart.Axis)this.getChart().repaint();else F.repaint();}};p.onSetChild=function(){return false;};p.onSetParent=function(r){return r instanceof jsx3.chart.ChartComponent;};p.toString=function(){return "[jsx3.chart.ChartLabel '"+this.getName()+"']";};j.getVersion=function(){return jsx3.chart.q2;};});jsx3.Class.defineClass("jsx3.chart.GridLines",jsx3.chart.ChartComponent,null,function(s,h){var U=jsx3.vector;var B=U.Stroke;h.init=function(l,p,j,d,a){this.jsxsuper(l);this.setDimensions(p,j,d,a);this.useXPrimary=jsx3.Boolean.TRUE;this.useYPrimary=jsx3.Boolean.TRUE;this.horizontalAbove=jsx3.Boolean.TRUE;this.inForeground=jsx3.Boolean.FALSE;this.borderStroke=null;this.fillV=null;this.strokeMajorV=null;this.strokeMinorV=null;this.fillH=null;this.strokeMajorH=null;this.strokeMinorH=null;};h.getUseXPrimary=function(){return this.useXPrimary;};h.setUseXPrimary=function(i){this.useXPrimary=i;};h.getUseYPrimary=function(){return this.useYPrimary;};h.setUseYPrimary=function(k){this.useYPrimary=k;};h.getHorizontalAbove=function(){return this.horizontalAbove;};h.setHorizontalAbove=function(n){this.horizontalAbove=n;};h.getInForeground=function(){return this.inForeground;};h.setInForeground=function(d){this.inForeground=d;};h.getBorderStroke=function(){return this.borderStroke;};h.setBorderStroke=function(m){this.borderStroke=m;};h.getFillV=function(){return this.fillV;};h.setFillV=function(i){this.fillV=i;};h.getStrokeMajorV=function(){return this.strokeMajorV;};h.setStrokeMajorV=function(o){this.strokeMajorV=o;};h.getStrokeMinorV=function(){return this.strokeMinorV;};h.setStrokeMinorV=function(a){this.strokeMinorV=a;};h.getFillH=function(){return this.fillH;};h.setFillH=function(p){this.fillH=p;};h.getStrokeMajorH=function(){return this.strokeMajorH;};h.setStrokeMajorH=function(b){this.strokeMajorH=b;};h.getStrokeMinorH=function(){return this.strokeMinorH;};h.setStrokeMinorH=function(p){this.strokeMinorH=p;};h.getXAxis=function(){var J=this.getChart();if(J==null)return null;return this.useXPrimary?J.getPrimaryXAxis():J.getSecondaryXAxis();};h.getYAxis=function(){var Bc=this.getChart();if(Bc==null)return null;return this.useYPrimary?Bc.getPrimaryYAxis():Bc.getSecondaryYAxis();};h.updateView=function(){this.jsxsuper();var Ub=this.l5();this.A3();var nc=new U.Group();nc.setZIndex(2);Ub.appendChild(nc);var cc=new U.Group();cc.setZIndex(this.horizontalAbove?3:1);Ub.appendChild(cc);var W=this.getWidth();var Ac=this.getHeight();if(this.borderStroke){var Zb=B.valueOf(this.borderStroke);var Mb=new U.Rectangle(0,0,W,Ac);Mb.setZIndex(10);Mb.setStroke(Zb);Ub.appendChild(Mb);}this.Xy(nc,W,Ac,this.getXAxis(),this.fillV,this.strokeMajorV,this.strokeMinorV,false);this.Xy(cc,W,Ac,this.getYAxis(),this.fillH,this.strokeMajorH,this.strokeMinorH,true);};h.Xy=function(j,l,p,c,g,r,e,n){j.setDimensions(0,0,l,p);var Ub=this.tV(g);if(c!=null){var Ib=c.RQ();if(Ib.length==0||Ub==1){this.ry(j,0,0,l,p,this.w6(g,0));}if(Ib.length>0){if(Ub>1)this.td(j,c,Ib,g,null,n);this.S7(j,c,Ib,r,null,n);this.Rk(j,c,Ib,e,n);}}else{this.ry(j,0,0,l,p,this.w6(g,0));}};h.td=function(e,r,q,b,m,o){if(m==null)m=new Array(this.tV(b));if(m.length==0)return;var P=e.getHeight();var S=e.getWidth();var Nb=o?P:S;var vc=o?S:P;for(var w=0;w<=q.length;w++){var Q=m[w%m.length];if(Q==null){Q=m[w%m.length]=new U.RectangleGroup(0,0,S,P);Q.setFill(this.w6(b,w));e.appendChild(Q);}if(w==q.length){if(q[w-1]<Nb)this.C6(Q,q[w-1],0,Nb,vc,o);}else{if(w==0){if(q[w]>0)this.C6(Q,0,0,q[w],vc,o);}else{this.C6(Q,q[w-1],0,q[w],vc,o);}}}};h.C6=function(f,p,d,o,c,l){if(l)f.C6(d,p,c,o);else f.C6(p,d,o,c);};h.S7=function(d,i,g,o,n,p){if(n==null)n=new Array(this.tV(o));if(n.length==0)return;var yb=d.getHeight();var Dc=d.getWidth();for(var N=0;N<g.length;N++){var Ob=n[N%n.length];if(Ob==null){Ob=n[N%n.length]=new U.LineGroup(0,0,Dc,yb);Ob.setStroke(this.GT(o,N));d.appendChild(Ob);}if(p)Ob.aT(0,g[N],Dc,0);else Ob.aT(g[N],0,0,yb);}};h.Rk=function(m,e,k,j,l){var Eb=this.tV(j);if(Eb==0)return;var S=new Array(Eb);for(var z=0;z<k.length;z++){var nc=e.RY(k,z);this.S7(m,e,nc,j,S,l);}};h.ry=function(j,d,o,l,p,k,i){if(k!=null){var qb=new U.Rectangle(d,o,l,p);if(i!=null)qb.setZIndex(i);qb.setFill(k);j.appendChild(qb);}};h.toString=function(){return "[GridLines '"+this.getName()+"']";};h.w6=function(q,f){if(q==null)return null;if(q instanceof Array){if(q.length>0){return U.Fill.valueOf(q[f%q.length]);}else{return null;}}else{return U.Fill.valueOf(q);}};h.GT=function(c,a){if(c==null)return null;if(c instanceof Array){if(c.length>0){return B.valueOf(c[a%c.length]);}else{return null;}}else{return B.valueOf(c);}};h.tV=function(o){if(o==null)return 0;return o instanceof Array?o.length:1;};h.onSetChild=function(){return false;};h.onSetParent=function(l){return jsx3.chart.Chart&&l instanceof jsx3.chart.Chart;};s.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.ChartComponent");jsx3.Class.defineClass("jsx3.chart.Axis",jsx3.chart.ChartComponent,null,function(k,q){var dc=jsx3.vector;var sc=dc.Stroke;var hb=jsx3.chart;k.TICK_INSIDE="inside";k.TICK_OUTSIDE="outside";k.TICK_CROSS="cross";k.TICK_NONE="none";k.LABEL_HIGH="high";k.LABEL_LOW="low";k.LABEL_AXIS="axis";k.Cy={inside:1,outside:1,cross:1};k.Hg={axis:1,high:1,low:1};k.Yj=1;k.fw=2;k.Hw=4;k.Pf=3;k.BF=7;k.Ux=8;k.vk=6;k.Tu=5;k.nz=[k.Pf,k.Hw,k.fw,k.Yj,k.fw,k.Yj,k.Pf,k.Hw,k.Ux,k.vk,k.BF,k.Tu];k.Le=10;k.Tw=50;k.nj=12;k.percent=function(c){return c+"%";};k.scientific=function(l,j){if(l==0)return "0";if(j==null)j=2;var cb=l<0;l=Math.abs(l);var U=Math.floor(Math.log(l)/Math.LN10);var ac=U!=0?l/Math.pow(10,U):l;ac=ac.toString();var oc=ac.indexOf(".");if(oc>=0){if(ac.length-oc-1>j)ac=ac.substring(0,oc+1+j);}return (cb?"-":"")+ac+"e"+U;};q.init=function(l,o,f){this.jsxsuper(l);this.horizontal=o!=null?jsx3.Boolean.valueOf(o):null;this.primary=f!=null?jsx3.Boolean.valueOf(f):null;this.length=100;this.showAxis=jsx3.Boolean.TRUE;this.axisStroke="#000000";this.showLabels=jsx3.Boolean.TRUE;this.labelGap=3;this.labelRotation=0;this.labelPlacement=k.LABEL_AXIS;this.tickLength=3;this.tickPlacement=k.TICK_OUTSIDE;this.tickStroke="#000000";this.minorTickDivisions=4;this.minorTickLength=3;this.minorTickPlacement=k.TICK_NONE;this.minorTickStroke=null;this.labelFunction=null;this.labelClass=null;this.labelStyle=null;this.labelColor=null;this.displayWidth=null;};q.a1=jsx3.Method.newAbstract("index");q.RQ=jsx3.Method.newAbstract();q.vX=jsx3.Method.newAbstract();q.g6=jsx3.Method.newAbstract();q.getHorizontal=function(){return this.horizontal;};q.setHorizontal=function(n){this.horizontal=n;};q.sX=function(){return this.primary;};q.SQ=function(g){this.primary=g;};q.getLength=function(){return this.length;};q.setLength=function(j){this.length=j;};q.getShowAxis=function(){return this.showAxis;};q.setShowAxis=function(e){this.showAxis=e;};q.getLabelFunction=function(){return this.o_("labelFunction");};q.setLabelFunction=function(p){this.uR("labelFunction",p);};q.getAxisStroke=function(){return this.axisStroke;};q.setAxisStroke=function(l){this.axisStroke=l;};q.getShowLabels=function(){return this.showLabels;};q.setShowLabels=function(h){this.showLabels=h;};q.getLabelGap=function(){return this.labelGap;};q.setLabelGap=function(b){this.labelGap=b;};q.getLabelRotation=function(){return this.labelRotation;};q.setLabelRotation=function(r){this.labelRotation=r;};q.getLabelPlacement=function(){return this.labelPlacement;};q.setLabelPlacement=function(p){if(k.Hg[p]){this.labelPlacement=p;}else{throw new jsx3.IllegalArgumentException("labelPlacement",p);}};q.getTickLength=function(){return this.tickLength;};q.setTickLength=function(l){this.tickLength=l;};q.getTickPlacement=function(){return this.tickPlacement;};q.setTickPlacement=function(o){if(k.Cy[o]||o==k.TICK_NONE){this.tickPlacement=o;}else{throw new jsx3.IllegalArgumentException("tickPlacement",o);}};q.getTickStroke=function(){return this.tickStroke;};q.setTickStroke=function(m){this.tickStroke=m;};q.getMinorTickDivisions=function(){return this.minorTickDivisions;};q.setMinorTickDivisions=function(l){this.minorTickDivisions=l;};q.getMinorTickLength=function(){return this.minorTickLength;};q.setMinorTickLength=function(r){this.minorTickLength=r;};q.getMinorTickPlacement=function(){return this.minorTickPlacement;};q.setMinorTickPlacement=function(d){if(k.Cy[d]||d==k.TICK_NONE){this.minorTickPlacement=d;}else{throw new jsx3.IllegalArgumentException("minorTickPlacement",d);}};q.getMinorTickStroke=function(){return this.minorTickStroke;};q.setMinorTickStroke=function(f){this.minorTickStroke=f;};q.getLabelClass=function(){return this.labelClass;};q.setLabelClass=function(s){this.labelClass=s;};q.getLabelStyle=function(){return this.labelStyle;};q.setLabelStyle=function(e){this.labelStyle=e;};q.getLabelColor=function(){return this.labelColor;};q.setLabelColor=function(b){this.labelColor=b;};q.getDisplayWidth=function(){if(this.displayWidth!=null){return this.displayWidth;}else{return this.horizontal?k.nj:k.Tw;}};q.setDisplayWidth=function(p){this.displayWidth=p;};q.updateView=function(){this.jsxsuper();var J=this.l5();var fc=this.getWidth();var rc=this.getHeight();var zc=this.getOpposingAxis();if(zc==null)return;var Mc=this.Uq(zc);this.A3();if(this.showAxis){var z=new dc.Line(0,0,0,0,0,0);J.appendChild(z);var tc=sc.valueOf(this.axisStroke);if(tc==null)tc=new sc();z.setStroke(tc);if(this.horizontal)z.fS(0,Mc,this.length,Mc);else z.fS(Mc,0,Mc,this.length);}var Fc=this.RQ();if(k.Cy[this.tickPlacement]&&this.tickLength>0){var U=new dc.LineGroup(0,0,fc,rc);J.appendChild(U);var tc=sc.valueOf(this.tickStroke);U.setStroke(tc);var N=this.si(this.tickPlacement,this.tickLength);var R=N[0];var C=Mc+N[1];this.S7(U,Fc,C,R);}if(k.Cy[this.minorTickPlacement]&&this.minorTickLength>0){var ub=new dc.LineGroup(0,0,fc,rc);J.appendChild(ub);var tc=sc.valueOf(this.minorTickStroke);ub.setStroke(tc);var N=this.si(this.minorTickPlacement,this.minorTickLength);var R=N[0];var C=Mc+N[1];var Qb=0;for(var Nc=0;Nc<Fc.length;Nc++){var Fb=this.RY(Fc,Nc);this.S7(ub,Fb,C,R);Qb=Fc[Nc];}if(Qb<this.length){var Fb=this.RY(Fc,Fc.length);this.S7(ub,Fb,C,R);}}var _=this.Yh(Mc);var wc=this.getAxisTitle();if(wc!=null&&wc.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){var yb=_[5];var O=this.horizontal&&this.primary||!this.horizontal&&!this.primary?0:-1;if(this.horizontal){var kb=yb+O*wc.getPreferredHeight();wc.setDimensions(0,kb,this.length,wc.getPreferredHeight());}else{var B=yb+O*wc.getPreferredWidth();wc.setDimensions(B,0,wc.getPreferredWidth(),this.length);}wc.updateView();J.appendChild(wc.l5());}if(this.showLabels){var Kc=this.w4();var K=new dc.Group(0,0,fc,rc);J.appendChild(K);var Lb=_[0];var W=_[1];var O=_[2];this._jsxQE=null;for(var Nc=0;Nc<Kc.length;Nc++){var G=Kc[Nc];var Db=null;if(this.horizontal){var Q=Nc>0?(Kc[Nc-1]+Kc[Nc])/2:null;var ob=Nc<Kc.length-1?(Kc[Nc+1]+Kc[Nc])/2:null;if(ob==null&&Q!=null)ob=2*Kc[Nc]-Q;else{if(Q==null&&ob!=null)Q=2*Kc[Nc]-ob;}if(ob==null){Q=Kc[Nc]-50;ob=Kc[Nc]+50;}Db=Math.round(ob-Q);}else{Db=this.getDisplayWidth()-this.mj()-this.labelGap;}if(this.horizontal){var Mb=Math.round(G-Db/2);var Sb=W+O*Math.round(k.Le/2);this.nq(K,Mb,Sb,Mb+Db,Sb,this.Qu(Nc));}else{var Mb=O==1?W:W-Db;this.nq(K,Mb,G,Mb+Db,G,this.Qu(Nc));}}}};q.nq=function(j,n,b,i,p,h){if(!(h&&h.toString().match(/\S/)))return;var Dc=new dc.TextLine(n,b,i,p,h);Dc.setClassName(this.labelClass);Dc.setExtraStyles(this.labelStyle);Dc.setColor(this.labelColor);j.appendChild(Dc);};q.Qu=function(m){var eb=this.a1(m);var jb=this.getLabelFunction();return jb!=null?jb.call(null,eb):eb!=null?eb.toString():"";};q.mj=function(){var lc=this.tickPlacement==k.TICK_OUTSIDE||this.tickPlacement==k.TICK_CROSS?this.tickLength:0;var hc=this.minorTickPlacement==k.TICK_OUTSIDE||this.minorTickPlacement==k.TICK_CROSS?this.minorTickLength:0;return Math.max(lc,hc);};q.Uq=function(r){if(r==null){r=this.getOpposingAxis();if(r==null)return 0;}if(r.vX())return r.getCoordinateFor(0);else{if(this.primary)return this.horizontal?r.getLength():0;else return this.horizontal?0:r.getLength();}};q.si=function(g,h){var K=0;if(g==k.TICK_CROSS){K=-1*h;h=h*2;}else{var Ub=0;if(this.horizontal)Ub++;if(this.primary)Ub++;if(g==k.TICK_INSIDE)Ub++;if(Ub%2==1)K=-1*h;}return [h,K];};q.Yh=function(n){var Eb=this.getOpposingAxis();if(n==null)n=this.Uq(Eb);var lc=0;if(this.horizontal)lc=lc|1;if(this.primary)lc=lc|2;if(this.labelPlacement==k.LABEL_LOW)lc=lc|4;else{if(this.labelPlacement==k.LABEL_AXIS)lc=lc|8;}var Ob=k.nz[lc];var Sb=0;var Lb=0;if(this.tickPlacement==k.TICK_OUTSIDE||this.tickPlacement==k.TICK_CROSS)Sb=this.tickLength;if(this.tickPlacement==k.TICK_INSIDE||this.tickPlacement==k.TICK_CROSS)Lb=this.tickLength;if(this.minorTickPlacement==k.TICK_OUTSIDE||this.minorTickPlacement==k.TICK_CROSS)Sb=Math.max(Sb,this.minorTickLength);if(this.minorTickPlacement==k.TICK_INSIDE||this.minorTickPlacement==k.TICK_CROSS)Lb=Math.max(Lb,this.minorTickLength);var Db=null,y=null,Kb=null;switch(Ob){case k.Yj:case k.Pf:y=-1;Db=-this.labelGap;Db=Db-Math.max(0,Sb-n);break;case k.fw:case k.Hw:y=1;Db=Eb.getLength()+this.labelGap;Db=Db+Math.max(0,Sb+n-Eb.getLength());break;case k.BF:case k.vk:y=-1;Db=n-this.labelGap-Sb;break;case k.Ux:case k.Tu:y=1;Db=n+this.labelGap+Sb;break;default:hb.LOG.error("bad placement value: "+Ob);}if(this.showLabels){if(this.horizontal)Kb=Db+y*k.Le;else Kb=Db+y*this.getDisplayWidth();}else{Kb=Db;}if(this.horizontal&&this.primary||!this.horizontal&&!this.primary){Kb=Math.max(Kb,Eb.getLength());}else{Kb=Math.min(Kb,0);}return [Ob,Db,y,Sb,Lb,Kb];};q.x1=function(){var H=0,Bc=0;var Lc=this.getOpposingAxis();if(Lc==null)return [0,0];var yc=this.Uq(Lc);var Mc=this.Yh(yc);var z=this.getAxisTitle();var fc=Mc[1];var jb=Mc[2];var K=Mc[3];var Ub=Mc[4];if(this.showLabels){if(this.horizontal)fc=fc+jb*k.Le;else fc=fc+jb*this.getDisplayWidth();}if(fc<0){H=-fc;}else{if(fc>Lc.getLength()){Bc=fc-Lc.getLength();}}if(Ub>this.length-yc)Bc=Math.max(Bc,Ub+this.length-yc);if(K>-yc)H=Math.max(H,K-yc);if(z!=null&&z.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){if(this.horizontal)Bc=Bc+z.getPreferredHeight();else H=H+z.getPreferredWidth();}return [H,Bc];};q.S7=function(e,h,o,g){if(this.horizontal){for(var u=0;u<h.length;u++)e.aT(h[u],o,0,g);}else{for(var u=0;u<h.length;u++)e.aT(o,h[u],g,0);}};q.w4=function(){return this.RQ();};q.RY=function(a,o){var Fc=[];if(o==0){return [];}else{if(o==a.length){return [];}else{var Y=a[o-1];var fc=a[o];for(var jc=1;jc<this.minorTickDivisions;jc++){Fc.push(Math.round(Y+jc/this.minorTickDivisions*(fc-Y)));}}}return Fc;};q.getAxisTitle=function(){return hb.ChartLabel?this.getFirstChildOfType(hb.ChartLabel):null;};q.getOpposingAxis=function(){var B=this.getChart();if(B==null)return null;if(this.horizontal){if(this.primary){return B.getPrimaryYAxis();}else{return B.getSecondaryYAxis();}}else{if(this.primary){return B.getPrimaryXAxis();}else{return B.getSecondaryXAxis();}}};q.onSetChild=function(f){if((hb.ChartLabel&&f instanceof hb.ChartLabel)&&this.getAxisTitle()==null){f.setLabelRotation(this.horizontal?hb.ChartLabel.ROTATION_NORMAL:hb.ChartLabel.ROTATION_CCW);return true;}return false;};q.onSetParent=function(c){return hb.Chart&&c instanceof hb.Chart;};q.toString=function(){return "[Axis '"+this.getName()+"']";};k.getVersion=function(){return hb.q2;};});jsx3.require("jsx3.chart.Axis");jsx3.Class.defineClass("jsx3.chart.LinearAxis",jsx3.chart.Axis,null,function(n,d){n.MIN_INTERVALS=5;n.MAX_INTERVALS=11;n.Tf=200;n.Qs=1.1;n.Qc=0;n.fj=100;n.pm=20;d.init=function(e,c,r){this.jsxsuper(e,c,r);this.autoAdjust=jsx3.Boolean.TRUE;this.baseAtZero=jsx3.Boolean.TRUE;this.min=null;this.max=null;this.interval=null;this.xI("a_",n.Qc);this.xI("kU",n.fj);this.xI("G4",n.pm);};d.getAutoAdjust=function(){return this.autoAdjust;};d.setAutoAdjust=function(j){this.autoAdjust=j;};d.getBaseAtZero=function(){return this.baseAtZero;};d.setBaseAtZero=function(i){this.baseAtZero=i;};d.getMin=function(){return this.min;};d.setMin=function(q){this.min=q;};d.getMax=function(){return this.max;};d.setMax=function(k){this.max=k;};d.getInterval=function(){return this.interval;};d.setInterval=function(c){this.interval=c;};d.g6=function(){var ob=false;if(this.autoAdjust)ob=this.Pd();if(!ob){this.xI("a_",this.min!=null?this.min:n.Qc);this.xI("kU",this.max!=null?this.max:n.fj);this.xI("G4",this.interval!=null?this.interval:n.pm);}};d.Pd=function(){var qb=this.getChart();if(qb==null)return false;var Ic=qb.getRangeForAxis(this);var bc,Ab;if(Ic==null){jsx3.chart.LOG.debug("no range for axis "+this+" in chart "+qb);if(this.min!=null||this.max!=null){bc=this.min||n.Qc;Ab=this.max||bc+n.fj;}else{return false;}}else{bc=Ic[0];Ab=Ic[1];}var ic=null,B=null,R=null;if(this.min!=null)ic=this.min;else{if(bc>=0&&this.baseAtZero)ic=0;}if(this.max!=null)B=this.max;else{if(Ab<=0&&this.baseAtZero)B=0;}R=this.interval;if(R==null){var Ub=1;var N=null,Nc=null;if(ic!=null){N=ic;}else{N=bc;Ub=Ub*n.Qs;}if(B!=null){Nc=B;}else{Nc=Ab;Ub=Ub*n.Qs;}var Cb=Nc-N;var tc=Cb*Ub;R=1;if(tc>0){tc=tc/n.MIN_INTERVALS;while(tc<1){R=R/10;tc=tc*10;}while(tc>10){R=R*10;tc=tc/10;}if(tc>5){R=R*5;}else{if(tc>2){R=R*2;}}}}if(ic==null){var Q=bc-(n.Qs-1)*(Ab-bc)/2;ic=R*Math.floor(Q/R);if(B!=null){ic=ic-B%R;}}if(B==null){var S=Ab+(n.Qs-1)*(Ab-bc)/2;B=R*Math.ceil(S/R);if(ic!=null){B=B+ic%R;}}this.xI("a_",ic);this.xI("kU",B);this.xI("G4",R);return true;};d.a1=function(h){return this.Q0("a_")+h*this.Q0("G4");};d.RQ=function(){var Mb=this.Q0("kU");var Yb=this.Q0("a_");var W=this.Q0("G4");var Kb=[];var yc=Yb;while(yc<=Mb&&Kb.length<n.Tf){Kb.push(this.getCoordinateFor(yc));yc=yc+W;}return Kb;};d.vX=function(){return this.Q0("a_")<0&&this.Q0("kU")>0;};d.getCoordinateFor=function(m){var Lc=this.Q0("kU");var Yb=this.Q0("a_");if(m<Yb)return this.horizontal?0:this.length;if(m>Lc)return this.horizontal?this.length:0;var Ac=Math.round(this.length*(m-Yb)/(Lc-Yb));return this.horizontal?Ac:this.length-Ac;};d.getCoordinateForNoClip=function(a){var N=this.Q0("kU");var jb=this.Q0("a_");var ab=Math.round(a*1000)/1000;var Cc=this.length*((ab-jb)/(N-jb));return Math.round(this.horizontal?Cc:this.length-Cc);};d.toString=function(){return "[LinearAxis '"+this.getName()+"' hor:"+this.horizontal+" pri:"+this.primary+"]";};n.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.Axis");jsx3.Class.defineClass("jsx3.chart.LogarithmicAxis",jsx3.chart.Axis,null,function(b,m){b.Tf=200;b.Qs=1;b.eo=0;b.jo=2;m.init=function(k,p,e){this.jsxsuper(k,p,e);this.autoAdjust=jsx3.Boolean.TRUE;this.baseAtZero=jsx3.Boolean.TRUE;this.showNegativeValues=jsx3.Boolean.FALSE;this.minExponent=null;this.maxExponent=null;this.base=10;this.majorDivisions=1;this.xI("wR",b.eo);this.xI("tQ",b.jo);};m.getAutoAdjust=function(){return this.autoAdjust;};m.setAutoAdjust=function(f){this.autoAdjust=f;};m.getBaseAtZero=function(){return this.baseAtZero;};m.setBaseAtZero=function(c){this.baseAtZero=c;};m.getShowNegativeValues=function(){return this.showNegativeValues;};m.setShowNegativeValues=function(o){this.showNegativeValues=o;};m.getMinExponent=function(){return this.minExponent;};m.setMinExponent=function(g){this.minExponent=g;};m.getMaxExponent=function(){return this.maxExponent;};m.setMaxExponent=function(j){this.maxExponent=j;};m.getBase=function(){return this.base;};m.setBase=function(l){this.base=l;};m.getMajorDivisions=function(){return this.majorDivisions;};m.setMajorDivisions=function(a){this.majorDivisions=a;};m.g6=function(){var S=false;if(this.autoAdjust)S=this.Pd();if(!S){this.xI("wR",this.minExponent!=null?this.minExponent:b.eo);this.xI("tQ",this.maxExponent!=null?this.maxExponent:b.jo);}};m.Pd=function(){var u=this.getChart();if(u==null)return false;var Db=u.getRangeForAxis(this);if(Db==null){jsx3.chart.LOG.debug("no range for axis "+this+" in chart "+u);return false;}var wb=Math.max(0,Db[0]);var I=Math.max(0,Db[1]);if(I==0){jsx3.chart.LOG.debug("range of axis "+this+" is all negative "+u);return false;}var qb=null,vb=null;if(this.minExponent!=null){qb=this.minExponent;}else{if(this.baseAtZero){qb=0;}}if(this.maxExponent!=null){vb=this.maxExponent;}wb=wb*b.Qs;I=I*b.Qs;if(qb==null){if(wb==0)qb=0;else qb=Math.floor(Math.log(wb)/Math.log(this.base));}if(vb==null){vb=Math.ceil(Math.log(I)/Math.log(this.base));}this.xI("wR",qb);this.xI("tQ",vb);return true;};m.a1=function(c){var fb=this.Q0("wR");var uc=Math.floor(fb+c/this.majorDivisions);var jb=c%this.majorDivisions;if(jb==0){return Math.pow(this.base,uc);}else{var Bc=Math.pow(this.base,uc);var Mb=Math.pow(this.base,uc+1);return Bc+jb*(Mb-Bc)/this.majorDivisions;}};m.RQ=function(){var S=this.Q0("wR");var fb=this.Q0("tQ");var wc=[];var vb=0;for(var gb=S;gb<=fb&&vb<b.Tf;gb++){var G=Math.pow(this.base,gb);if(gb>S){var Sb=Math.pow(this.base,gb-1);for(var Ic=1;Ic<this.majorDivisions;Ic++){var Cb=Sb+Ic*(G-Sb)/this.majorDivisions;wc.push(this.getCoordinateFor(Cb));vb++;}}wc.push(this.getCoordinateFor(G));vb++;}return wc;};m.RY=function(n,i){var B=[];if(i==0){return [];}else{if(i==n.length){return [];}else{var bc=this.a1(i-1);var rc=this.a1(i);for(var gb=1;gb<this.minorTickDivisions;gb++){var nb=bc+gb*(rc-bc)/this.minorTickDivisions;B.push(this.getCoordinateFor(nb));}}}return B;};m.vX=function(){return false;};m.getCoordinateFor=function(n){var Cc=this.Q0("wR");var hb=this.Q0("tQ");var B=null;if(n<=0){B=0;}else{var Y=Math.log(n)/Math.log(this.base);if(Y<Cc){B=0;}else{if(Y>hb){B=this.length;}else{B=Math.round(this.length*(Y-Cc)/(hb-Cc));}}}return this.horizontal?B:this.length-B;};m.getCoordinateForNoClip=function(o){var Eb=this.Q0("wR");var M=this.Q0("tQ");var E=null;if(o<=0){E=-1;}else{var X=Math.log(o)/Math.log(this.base);E=Math.round(this.length*(X-Eb)/(M-Eb));}return this.horizontal?E:this.length-E;};m.toString=function(){return "[LogarithmicAxis '"+this.getName()+"']";};b.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.Axis");jsx3.Class.defineClass("jsx3.chart.CategoryAxis",jsx3.chart.Axis,null,function(q,b){q.TICKS_ALIGNED="aligned";q.TICKS_BETWEEN="between";q.Tf=200;q.Di={aligned:1,between:1};b.init=function(s,h,m){this.jsxsuper(s,h,m);this.tickAlignment=q.TICKS_BETWEEN;this.categoryField=null;this.paddingLow=null;this.paddingHigh=null;this.xI("dK",0);this.xI("uI",0);};b.getTickAlignment=function(){return this.tickAlignment;};b.setTickAlignment=function(p){if(q.Di[p]){this.tickAlignment=p;}else{throw new jsx3.IllegalArgumentException("tickAlignment",p);}};b.getCategoryField=function(){return this.categoryField;};b.setCategoryField=function(n){this.categoryField=n;};b.getPaddingLow=function(){return this.paddingLow!=null?this.paddingLow:0;};b.setPaddingLow=function(a){this.paddingLow=a;};b.getPaddingHigh=function(){return this.paddingHigh!=null?this.paddingHigh:0;};b.setPaddingHigh=function(c){this.paddingHigh=c;};b.g6=function(){this.qX("Y6");var Kb=this.getChart();if(Kb==null){this.xI("dK",0);this.xI("uI",0);}else{var Cb=Kb.aX(this,true);var rb=Kb.gH();this.xI("uI",Cb.length);this.xI("dK",rb!=null?rb.length:0);}};b.RQ=function(){var wc=this.Q0("Y6");if(wc!=null)return wc;var wb=this.Q0("dK");wc=[];if(wb<1)return wc;var Ec=this.getPaddingLow();var _=this.getPaddingHigh();var ac=this.tickAlignment==q.TICKS_BETWEEN?wb+1:wb;var N=ac-1;var hc=N+Ec+_;var Jb=this.length/hc;var Fb=Ec*Jb;for(var gb=0;gb<ac&&gb<q.Tf;gb++){wc.push(Math.round(Fb+gb*Jb));}this.xI("Y6",wc);return wc;};b.w4=function(){var V=this.Q0("dK");if(this.tickAlignment==q.TICKS_BETWEEN){var cb=this.RQ();var sc=[];for(var E=0;E<V;E++){sc[E]=Math.round((cb[E]+cb[E+1])/2);}return sc;}else{return this.RQ();}};b.a1=function(d){var rb=d;var x=this.getChart();if(this.categoryField&&x!=null){var Z=x.gH();if(Z!=null){var Yb=Z[d];if(Yb!=null)rb=Yb.getAttribute([this.categoryField]);}}return rb;};b.vX=function(){return false;};b.getRangeForCategory=function(f){var Gb=this.RQ();if(this.tickAlignment==q.TICKS_BETWEEN){if(f<0||f>=Gb.length-1)return null;else return [Gb[f],Gb[f+1]];}else{if(f<0||f>=Gb.length||Gb.length<2)return null;var Dc=f==0?Gb[1]-Gb[0]:Gb[f]-Gb[f-1];return [Math.round(Gb[f]-Dc/2),Math.round(Gb[f]+Dc/2)];}};b.getPointForCategory=function(r){var F=this.RQ();if(this.tickAlignment==q.TICKS_BETWEEN){if(r<0||r>=F.length-1)return null;else return Math.round((F[r]+F[r+1])/2);}else{return F[r];}};b.toString=function(){return "[CategoryAxis '"+this.getName()+"' hor:"+this.horizontal+" pri:"+this.primary+"]";};q.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.ChartComponent","jsx3.chart.PointRenderer");jsx3.Class.defineClass("jsx3.chart.Legend",jsx3.chart.ChartComponent,null,function(n,q){var L=jsx3.vector;var Sb=jsx3.chart;n.DEFAULT_WIDTH=100;n.DEFAULT_HEIGHT=100;n.aA=1;n.Nh=3;n.qj=2;n.SHOW_SERIES=1;n.SHOW_CATEGORIES=2;n.yn=8;n.hB=6;q.init=function(k){this.jsxsuper(k);this.boxHeight=10;this.lineHeight=22;this.labelClass=null;this.labelStyle=null;this.backgroundFill=null;this.backgroundStroke=null;this.preferredWidth=null;this.preferredHeight=null;this.setMargin("10 10 10 4");this.setPadding("4 4 0 4");};q.getBoxHeight=function(){return this.boxHeight;};q.setBoxHeight=function(m){this.boxHeight=m;};q.getLineHeight=function(){return this.lineHeight;};q.setLineHeight=function(b){this.lineHeight=b;};q.getLabelClass=function(){return this.labelClass;};q.setLabelClass=function(i){this.labelClass=i;};q.getLabelStyle=function(){return this.labelStyle;};q.setLabelStyle=function(j){this.labelStyle=j;};q.getBackgroundFill=function(){return this.backgroundFill;};q.setBackgroundFill=function(b){this.backgroundFill=b;};q.getBackgroundStroke=function(){return this.backgroundStroke;};q.setBackgroundStroke=function(r){this.backgroundStroke=r;};q.getPreferredWidth=function(){return this.preferredWidth!=null?this.preferredWidth:n.DEFAULT_WIDTH;};q.setPreferredWidth=function(d){this.preferredWidth=d;};q.getPreferredHeight=function(){return this.preferredHeight!=null?this.preferredHeight:n.DEFAULT_HEIGHT;};q.setPreferredHeight=function(b){this.preferredHeight=b;};q.updateView=function(){this.jsxsuper();var Jb=this.l5();this.A3();var sc=this.getChart();var x=sc.getLegendEntryType();var cc=0;if(x==n.SHOW_SERIES){cc=sc.aO().length;}else{if(x==n.SHOW_CATEGORIES){var Cc=sc.gH();if(Cc!=null)cc=Cc.length;}}var B=this.getLegendTitle();var eb=B!=null&&B.getDisplay()!=jsx3.gui.Block.DISPLAYNONE?B.getPreferredHeight()+n.yn:0;var Qb=this.getMarginDimensions();var Lc=this.getPaddingDimensions();var Mc=this.getWidth()-Qb[1]-Qb[3];var Ab=Math.min(this.getHeight()-Qb[0]-Qb[2],eb+this.lineHeight*cc+Lc[0]+Lc[2]);var oc=Qb[3];var qb=Math.max(Qb[0],Math.round((this.getHeight()-Ab)/2));var Bb=new L.Group(oc,qb,Mc,Ab);Jb.appendChild(Bb);Bb.setZIndex(n.qj);if(this.backgroundFill||this.backgroundStroke){if(cc>0||B!=null&&B.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){var ub=new L.Rectangle(oc,qb,Mc,Ab);ub.setZIndex(n.aA);Jb.appendChild(ub);var O=L.Fill.valueOf(this.backgroundFill);var R=L.Stroke.valueOf(this.backgroundStroke);ub.setFill(O);ub.setStroke(R);}}var z=qb+Lc[0];var mc=Mc-Lc[1]-Lc[3];if(B!=null&&B.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){B.setDimensions(oc+Lc[3],z,mc,B.getPreferredHeight());B.setZIndex(n.Nh);B.updateView();Jb.appendChild(B.l5());z=z+eb;}z=z-qb;var S=oc+Lc[3]+this.boxHeight+n.hB;var mb=mc-this.boxHeight-n.hB;if(x==n.SHOW_SERIES&&cc>0){var M=sc.aO();for(var wb=0;wb<M.length;wb++){var bb=M[wb].getLegendRenderer();var Rb=oc+Lc[3];var O=M[wb].D7();var R=M[wb].qT(O);var ab=bb.render(Rb,z,Rb+this.boxHeight,z+this.boxHeight,O,R);ab.setId(this.getId()+"_b"+wb);Bb.appendChild(ab);var uc=this.mD(Bb,M[wb].getSeriesName(),this.labelClass,this.labelStyle,S,Math.round(z+this.boxHeight/2),mb);z=z+this.lineHeight;this.A3(ab,M[wb],null);this.A3(uc,M[wb],null);}}else{if(x==n.SHOW_CATEGORIES&&cc>0){var Cc=sc.gH();var bb=Sb.PointRenderer.BOX;var R=L.Stroke.valueOf(sc.getSeriesStroke());for(var wb=0;wb<Cc.length;wb++){var Rb=oc+Lc[3];var O=sc.t0(Cc[wb],wb);var lb=R==null&&O.KJ()?new L.Stroke(O.getColor()):R;var ab=bb.render(Rb,z,Rb+this.boxHeight,z+this.boxHeight,O,lb);ab.setId(this.getId()+"_b"+wb);Bb.appendChild(ab);var Zb=sc.getCategoryField();var H=Zb?Cc[wb].getAttribute(Zb):"";var uc=this.mD(Bb,H,this.labelClass,this.labelStyle,S,Math.round(z+this.boxHeight/2),mb);z=z+this.lineHeight;this.A3(ab,null,wb);this.A3(uc,null,wb);}}}};q.mD=function(e,h,j,d,p,s,m){var Jc=new L.TextLine(p,s,m,s,h);Jc.setClassName(j);Jc.setExtraStyles(d);if(!Jc.getTextAlign())Jc.setTextAlign("left");e.appendChild(Jc);return Jc;};q.getLegendTitle=function(){return Sb.ChartLabel?this.getFirstChildOfType(Sb.ChartLabel):null;};q.onSetChild=function(c){return (Sb.ChartLabel&&c instanceof Sb.ChartLabel)&&this.getLegendTitle()==null;};q.onSetParent=function(p){return Sb.Chart&&p instanceof Sb.Chart;};q.onResize=function(){var Z=this.getParent();if(Z!=null){Z.repaint();}};q.toString=function(){return "[Legend '"+this.getName()+"']";};n.getVersion=function(){return Sb.q2;};q.A3=function(k,a,r){if(k==null)k=this.l5();if(a!=null)k.setProperty("seriesId",a.getId());if(r!=null)k.setProperty("recordIndex",r);this.jsxsuper(k);};q.IU=function(p,i){var y=i.getAttribute("seriesId");var Db=i.getAttribute("recordIndex");this.doEvent(jsx3.gui.Interactive.SELECT,this.DB(p,y,Db));};q.LH=function(r,p){var Kc=p.getAttribute("seriesId");var G=p.getAttribute("recordIndex");this.doEvent(jsx3.gui.Interactive.EXECUTE,this.DB(r,Kc,G));};q.doSpyOver=function(j,o){var Tb=o.getAttribute("seriesId");var P=o.getAttribute("recordIndex");this.jsxsupermix(j,o,this.DB(j,Tb,P));};q._4=function(k,b){var R=b.getAttribute("seriesId");var Kc=b.getAttribute("recordIndex");var vb;if(k.rightButton()&&(vb=this.getMenu())!=null){var bc=this.getServer().getJSXByName(vb);if(bc!=null){var kc=this.DB(k,R,Kc);kc.objMENU=bc;var Ib=this.doEvent(jsx3.gui.Interactive.MENU,kc);if(Ib!==false){if(Ib instanceof Object&&Ib.objMENU instanceof jsx3.gui.Menu)bc=Ib.objMENU;bc.showContextMenu(k,this);}}}};q.DB=function(c,b,f){var H={objEVENT:c};H.objSERIES=b!=null?this.getServer().getJSXById(b):null;if(f!=null){H.intINDEX=f;var cb=this.getChart().gH()[f];H.strRECORDID=cb?cb.getAttribute("jsxid"):null;}else{H.intINDEX=H.strRECORDID=null;}return H;};});jsx3.require("jsx3.chart.ChartComponent");jsx3.Class.defineClass("jsx3.chart.Series",jsx3.chart.ChartComponent,null,function(m,p){var db=jsx3.gui.Interactive;var Ac=jsx3.vector;var T=jsx3.chart;p.init=function(r,n){this.jsxsuper(r);this.seriesName=n;this.usePrimaryX=jsx3.Boolean.TRUE;this.usePrimaryY=jsx3.Boolean.TRUE;this.stroke=null;this.fill=null;this.fillGradient=null;this.tooltipFunction=null;};p.getSeriesName=function(){return this.seriesName;};p.setSeriesName=function(b){this.seriesName=b;};p.getUsePrimaryX=function(){return this.usePrimaryX;};p.setUsePrimaryX=function(l){this.usePrimaryX=l;};p.getUsePrimaryY=function(){return this.usePrimaryY;};p.setUsePrimaryY=function(d){this.usePrimaryY=d;};p.setTooltipFunction=function(b){this.uR("tooltipFunction",b);};p.getTooltipFunction=function(){return this.o_("tooltipFunction");};p.getIndex=function(){var nb=this.getChart();return nb!=null?nb.getSeriesIndex(this):-1;};p.getStroke=function(){return this.stroke;};p.setStroke=function(r){this.stroke=r;};p.getFill=function(){return this.fill;};p.setFill=function(g){this.fill=g;};p.getFillGradient=function(){return this.fillGradient;};p.setFillGradient=function(q){this.fillGradient=q;};p.getXAxis=function(){var hc=this.getChart();if(hc!=null){return this.usePrimaryX?hc.getPrimaryXAxis():hc.getSecondaryXAxis();}return null;};p.getYAxis=function(){var cc=this.getChart();if(cc!=null){return this.usePrimaryY?cc.getPrimaryYAxis():cc.getSecondaryYAxis();}return null;};p.VT=function(){var sb=Math.max(this.getIndex(),0)%T.Chart.DEFAULT_FILLS.length;return T.Chart.DEFAULT_FILLS[sb];};p.JM=function(){var yb=Math.max(this.getIndex(),0)%T.Chart.DEFAULT_FILLS.length;if(T.Chart.DEFAULT_STROKES[yb]==null){var Cc=this.VT();T.Chart.DEFAULT_STROKES[yb]=new Ac.Stroke(Cc.getColor(),1,Cc.getAlpha());}return T.Chart.DEFAULT_STROKES[yb];};p.D7=function(){var _=this.fill?Ac.Fill.valueOf(this.fill):this.VT();if(_!=null){_=T.addGradient(_,this.fillGradient);}return _;};p.qT=function(h){if(this.stroke){return Ac.Stroke.valueOf(this.stroke);}else{if(this.getColorFunction()!=null){return null;}else{if(h!=null&&h.KJ()){return new Ac.Stroke(h.getColor());}else{if(!this.fill)return this.JM(h);else return null;}}}};p.getColorFunction=function(){return this.o_("colorFunction");};p.setColorFunction=function(k){this.uR("colorFunction",k);};p.getLegendRenderer=function(){return T.PointRenderer.BOX;};p.getLabel=function(){return T.ChartLabel?this.getFirstChildOfType(T.ChartLabel):null;};p.onSetChild=function(f){return (T.ChartLabel&&f instanceof T.ChartLabel)&&this.getLabel()==null;};p.onSetParent=function(c){return T.Chart&&c instanceof T.Chart;};p.A3=function(k,r,h){if(k==null)k=this.l5();if(h!=null)k.setProperty("strRecordId",h);if(r!=null)k.setProperty("recordIndex",r);this.jsxsuper(k);};p.IU=function(l,a){var Sb=a.getAttribute("recordIndex");var u=a.getAttribute("strRecordId");this.doEvent(jsx3.gui.Interactive.SELECT,{objEVENT:l,intINDEX:Sb,strRECORDID:u});};p.LH=function(e,h){var tc=h.getAttribute("recordIndex");var E=h.getAttribute("strRecordId");this.doEvent(jsx3.gui.Interactive.EXECUTE,{objEVENT:e,intINDEX:tc,strRECORDID:E});};p.doSpyOver=function(j,c){var y=c.getAttribute("recordIndex");var V=c.getAttribute("strRecordId");this.jsxsupermix(j,c,{objEVENT:j,intINDEX:y,strRECORDID:V});};p._4=function(h,e){var kb=e.getAttribute("recordIndex");var sc=e.getAttribute("strRecordId");var nb;if(h.rightButton()&&(nb=this.getMenu())!=null){var O=this.getServer().getJSXByName(nb);if(O!=null){var Qb={objEVENT:h,objMENU:O,intINDEX:kb,strRECORDID:sc};var Yb=this.doEvent(db.MENU,Qb);if(Yb!==false){if(Yb instanceof Object&&Yb.objMENU instanceof jsx3.gui.Menu)O=Yb.objMENU;O.showContextMenu(h,this,kb);}}}};p.toString=function(){return "[Series '"+this.getName()+"']";};m.getVersion=function(){return T.q2;};});jsx3.require("jsx3.chart.Series");jsx3.Class.defineClass("jsx3.chart.BCSeries",jsx3.chart.Series,null,function(l,d){d.init=function(c,a){this.jsxsuper(c,a);this.xField=null;this.yField=null;this.minField=null;};d.getParallelValue=jsx3.Method.newAbstract();d.getNormalValue=jsx3.Method.newAbstract();d.getNormalWidth=jsx3.Method.newAbstract();d.getXValue=function(m){if(this.xField)return jsx3.chart.asNumber(m.getAttribute(this.xField));return null;};d.getYValue=function(a){if(this.yField)return jsx3.chart.asNumber(a.getAttribute(this.yField));return null;};d.getMinValue=function(i){if(this.minField)return jsx3.chart.asNumber(i.getAttribute(this.minField));return null;};d.getShownAreas=function(){var lb=this.Q0("OY");if(lb==null){lb=[];this.xI("OY",lb);}return lb;};d.updateView=function(){this.jsxsuper();var nc=this.D7();var uc=this.qT(nc);this.xI("OH",nc);this.xI("f3",uc);var cb=this.getShownAreas();for(var A=0;A<cb.length;A++){var Dc=cb[A];this.ZW(Dc[0],Dc[1],Dc[2],Dc[3],Dc[4],Dc[5],true);}};d.ZW=function(a,k,g,n,f,m,r){if(!r)this.getShownAreas().push([a,k,g,n,f,m]);var C=this.l5();var Ob=this.getWidth();var Kc=this.getHeight();if(g>f){var Rb=g;g=f;f=Rb;}if(n>m){var Rb=n;n=m;m=Rb;}if(g>Ob||f<0)return;if(n>Kc||m<0)return;var gc=new jsx3.vector.Rectangle(g,n,f-g,m-n);gc.setId(this.getId()+"_r"+k);gc.ET(0,0,Ob,Kc);var Dc=this.getColorFunction();var M=Dc!=null?Dc.call(null,a,k):this.Q0("OH");gc.setFill(M);gc.setStroke(this.Q0("f3"));var yc=this.getTooltipFunction();if(yc!=null)gc.setToolTip(yc.call(null,this,a));this.A3(gc,k,a.getAttribute("jsxid"));C.appendChild(gc);};d.MY=function(){var Nc=this.getShownAreas();Nc.splice(0,Nc.length);};d.getXField=function(){return this.xField;};d.setXField=function(b){this.xField=b;};d.getYField=function(){return this.yField;};d.setYField=function(r){this.yField=r;};d.getMinField=function(){return this.minField;};d.setMinField=function(s){this.minField=s;};l.getVersion=function(){return jsx3.chart.q2;};});jsx3.chart.BCSeries.prototype.drawBar=jsx3.chart.BCSeries.prototype.ZW;jsx3.chart.BCSeries.prototype.drawColumn=jsx3.chart.BCSeries.prototype.ZW;jsx3.Class.defineClass("jsx3.chart.BarSeries",jsx3.chart.BCSeries,null,function(b,k){b.DEFAULT_BARHEIGHT=10;k.init=function(o,q){this.jsxsuper(o,q);this.barHeight=null;this.setTooltipFunction("jsx3.chart.BarSeries.tooltip");};k.getParallelValue=function(i){return this.getXValue(i);};k.getNormalValue=function(l){return this.getYValue(l);};k.getNormalWidth=function(){return this.getBarHeight();};k.getBarHeight=function(){return this.barHeight!=null?this.barHeight:b.DEFAULT_BARHEIGHT;};k.setBarHeight=function(l){this.barHeight=l;};k.toString=function(){return "[BarSeries '"+this.getName()+"']";};b.tooltip=function(f,o){var x=f.getXValue(o);var Sb=f.getYValue(o);var Y=f.getMinValue(o);var u=Y!=null?"{"+Y+","+x+"}":x;if(Sb!=null)u=u+(", y = "+Sb);return u;};});jsx3.Class.defineClass("jsx3.chart.ColumnSeries",jsx3.chart.BCSeries,null,function(j,e){j.DEFAULT_COLUMNWIDTH=10;e.init=function(b,k){this.jsxsuper(b,k);this.columnWidth=null;this.setTooltipFunction("jsx3.chart.ColumnSeries.tooltip");};e.getParallelValue=function(d){return this.getYValue(d);};e.getNormalValue=function(c){return this.getXValue(c);};e.getNormalWidth=function(){return this.getColumnWidth();};e.getColumnWidth=function(){return this.columnWidth!=null?this.columnWidth:j.DEFAULT_COLUMNWIDTH;};e.setColumnWidth=function(i){this.columnWidth=i;};e.toString=function(){return "[ColumnSeries '"+this.getName()+"']";};e.ZW=function(q,h,k,p,n,o,g){if(g)this.jsxsuper(q,h,k,p,n,o,g);else this.jsxsuper(q,h,p,n,o,k,g);};j.tooltip=function(q,i){var jb=q.getXValue(i);var y=q.getYValue(i);var yb=q.getMinValue(i);var Lb=yb!=null?"{"+yb+","+y+"}":y;if(jb!=null)Lb=Lb+(", x = "+jb);return Lb;};});jsx3.require("jsx3.chart.Series","jsx3.chart.PointRenderer");jsx3.Class.defineClass("jsx3.chart.PlotSeries",jsx3.chart.Series,null,function(m,g){m.hy=25;g.init=function(c,j){this.jsxsuper(c,j);this.xField=null;this.yField=null;this.magnitude=null;this.renderer="jsx3.chart.PointRenderer.CIRCLE";};g.Xs=function(){var Yb=this.Q0("VX");if(Yb==null){Yb=[];this.xI("VX",Yb);}return Yb;};g.updateView=function(){this.jsxsuper();var Lc=this.D7();var Db=this.qT(Lc);this.xI("OH",Lc);this.xI("f3",Db);var V=this.Xs();for(var fc=0;fc<V.length;fc++){this.LD(V[fc]);}};g.MA=function(b,l,j,f,c){var Kb=this.l5();var Nc=this.getChart();if(Nc==null)return;var _=Nc.getMaxPointRadius();var rb=this.getWidth();var nc=this.getHeight();if(j>rb||j<0)return;if(f>nc||f<0)return;var uc=this.getRenderer();if(uc==null)uc=jsx3.chart.PointRenderer.CIRCLE;var Ic=null,Ib=null,xb=null,x=null;var tb=Nc.getMagnitudeMethod();if(tb==jsx3.chart.PlotChart.MAG_DIAMETER){c=Math.min(_*2,c);Ic=j-Math.round(c/2);Ib=f-Math.round(c/2);xb=Ic+c;x=Ib+c;}else{var z=tb==jsx3.chart.PlotChart.MAG_AREA?uc.areaToRadius(c*m.hy):c;z=Math.min(_,z);Ic=j-Math.round(z);Ib=f-Math.round(z);xb=Ic+Math.round(2*z);x=Ib+Math.round(2*z);}var N=this.getColorFunction();var gb=N!=null?N.call(null,b,l):this.Q0("OH");var nb=uc.render(Ic,Ib,xb,x,gb,this.Q0("f3"));nb.setId(this.getId()+"_p"+l);this.A3(nb,l,b.getAttribute("jsxid"));Kb.appendChild(nb);var F=this.getTooltipFunction();if(F!=null)nb.setToolTip(F.call(null,this,b));};g.BV=function(){var E=this.Xs();E.splice(0,E.length);};g.getXValue=function(d){if(this.xField)return jsx3.chart.asNumber(d.getAttribute(this.xField));return null;};g.getYValue=function(r){if(this.yField)return jsx3.chart.asNumber(r.getAttribute(this.yField));return null;};g.getXField=function(){return this.xField;};g.setXField=function(f){this.xField=f;};g.getYField=function(){return this.yField;};g.setYField=function(n){this.yField=n;};g.getRenderer=function(){return this.d8("renderer");};g.setRenderer=function(h){this.uR("renderer",h);};g.getLegendRenderer=function(){var cb=this.getRenderer();return cb!=null?cb:this.jsxsuper();};m.getVersion=function(){return jsx3.chart.q2;};});jsx3.Class.defineClass("jsx3.chart.PointSeries",jsx3.chart.PlotSeries,null,function(r,j){r.DEFAULT_MAGNITUDE=4;j.init=function(k,b){this.jsxsuper(k,b);this.magnitude=null;this.setTooltipFunction("jsx3.chart.PointSeries.tooltip");};j.PM=function(q,h,k,n){this.Xs().push([q,h,k,n]);};j.LD=function(q){this.MA(q[0],q[1],q[2],q[3],this.getMagnitude());};j.getMagnitude=function(){return this.magnitude!=null?this.magnitude:r.DEFAULT_MAGNITUDE;};j.setMagnitude=function(c){this.magnitude=c;};j.toString=function(){return "[PointSeries '"+this.getName()+"']";};r.tooltip=function(k,o){var x=k.getXValue(o);var Sb=k.getYValue(o);return "{"+x+","+Sb+"}";};});jsx3.Class.defineClass("jsx3.chart.BubbleSeries",jsx3.chart.PlotSeries,null,function(j,d){d.init=function(g,f){this.jsxsuper(g,f);this.magnitudeField=null;this.setTooltipFunction("jsx3.chart.BubbleSeries.tooltip");};d.PM=function(s,p,i,h,c){this.Xs().push([s,p,i,h,c]);};d.LD=function(i){this.MA(i[0],i[1],i[2],i[3],i[4]);};d.toString=function(){return "[BubbleSeries '"+this.getName()+"']";};j.tooltip=function(a,f){var Lb=a.getXValue(f);var Cb=a.getYValue(f);var Fc=a.getMagnitudeValue(f);return "{"+Lb+","+Cb+","+Fc+"}";};d.getMagnitudeField=function(){return this.magnitudeField;};d.setMagnitudeField=function(r){this.magnitudeField=r;};d.getMagnitudeValue=function(m){if(this.magnitudeField)return jsx3.chart.asNumber(m.getAttribute(this.magnitudeField));return null;};});jsx3.require("jsx3.chart.Series","jsx3.chart.PointRenderer");jsx3.Class.defineClass("jsx3.chart.LineSeries",jsx3.chart.Series,null,function(c,h){var Dc=jsx3.vector;c.FORM_SEGMENT="segment";c.FORM_STEP="step";c.FORM_REVSTEP="reverseStep";c.FORM_HORIZONTAL="horizontal";c.FORM_VERTICAL="vertical";c.Ae={segment:1,step:1,reverseStep:1,horizontal:1,vertical:1};c.Xg=4;c.uz=function(o){this.series=o;};c.uz.prototype.render=function(e,l,d,k,f,a){var Mb=d-e;var mc=k-l;var cc=new Dc.Group(e,l,Mb,mc);var ob=this.series.qT();var _=new Dc.Line(0,0,0,Math.round(mc/2),Mb,Math.round(mc/2));_.setStroke(ob);cc.appendChild(_);var Ob=this.series.getPointRenderer();if(Ob!=null){var zc=Math.round(Mb/4);var Lc=this.series.B9();var Gc=this.series.b8();var Xb=Ob.render(zc,zc,Mb-zc,mc-zc,Lc,Gc);cc.appendChild(Xb);}return cc;};h.init=function(f,g){this.jsxsuper(f,g);this.xField=null;this.yField=null;this.form=c.FORM_SEGMENT;this.interpolateValues=jsx3.Boolean.FALSE;this.pointRadius=null;this.pointRenderer=null;this.pointFill=null;this.pointStroke=null;this.pointGradient=null;this.setTooltipFunction("jsx3.chart.LineSeries.tooltip");};h.getXField=function(){return this.xField;};h.setXField=function(r){this.xField=r;};h.getYField=function(){return this.yField;};h.setYField=function(e){this.yField=e;};h.getForm=function(){return this.form;};h.setForm=function(b){if(c.Ae[b]){this.form=b;}else{throw new jsx3.IllegalArgumentException("form",b);}};h.getInterpolateValues=function(){return this.interpolateValues;};h.setInterpolateValues=function(a){this.interpolateValues=a;};h.getPointRadius=function(){return this.pointRadius!=null?this.pointRadius:c.Xg;};h.setPointRadius=function(j){this.pointRadius=j;};h.getPointRenderer=function(){return this.d8("pointRenderer");};h.setPointRenderer=function(f){this.uR("pointRenderer",f);};h.getPointFill=function(){return this.pointFill;};h.setPointFill=function(a){this.pointFill=a;};h.getPointStroke=function(){return this.pointStroke;};h.setPointStroke=function(e){this.pointStroke=e;};h.getPointGradient=function(){return this.pointGradient;};h.setPointGradient=function(o){this.pointGradient=o;};h.B9=function(){var Z=this.Q0("LJ");if(Z==null)this.mG();return this.Q0("LJ");};h.b8=function(){var Ib=this.Q0("PY");if(Ib==null)this.mG();return this.Q0("PY");};h.mG=function(){var Gc=this.qT();var pb=Dc.Fill.valueOf(this.getPointFill());if(pb==null&&Gc!=null)pb=new Dc.Fill(Gc.getColor());if(pb!=null)pb=jsx3.chart.addGradient(pb,this.pointGradient);var Z=Dc.Stroke.valueOf(this.getPointStroke());this.xI("LJ",pb);this.xI("PY",Z);};h.updateView=function(){this.jsxsuper();var ub=this.l5();this.shape=new Dc.Shape(null,0,0,ub.getWidth(),ub.getHeight());this.shape.setId(this.getId()+"_line");ub.appendChild(this.shape);var K=this.qT();this.shape.setStroke(K);this.A3(this.shape);this.mG();var Z=null,Cc=null;var pb=this.Xs();for(var vb=0;vb<pb.length;vb++){var L=pb[vb];if(L==null)continue;var S=null,Y=null,tb=false;if(Z!=null){S=Z[1];Y=Z[2];tb=Cc==vb-1;}this.cf(vb,tb,L[0],L[1],L[2],L[3],S,Y);Z=L;Cc=vb;}};h.cf=function(q,l,p,b,k,g,f,o){var _=this.l5();var tb=this.shape;var xc=this.getPointRenderer();if(xc!=null){var R=this.getPointRadius();var gb=this.getColorFunction();var U=gb!=null?gb.call(null,p,g):this.B9();var O=xc.render(b-R,k-R,b+R,k+R,U,this.b8());O.setId(this.getId()+"_p"+q);this.A3(O,q,p.getAttribute("jsxid"));_.appendChild(O);var yb=this.getTooltipFunction();if(yb!=null)O.setToolTip(yb.call(null,this,p));}var Lc=q==0||!l&&!this.interpolateValues;if(Lc){tb.X6(b,k);}else{if(this.form==c.FORM_SEGMENT){tb.Z7(b,k);}else{if(this.form==c.FORM_HORIZONTAL){tb.X6(f,k).Z7(b,k);}else{if(this.form==c.FORM_VERTICAL){tb.X6(b,o).Z7(b,k);}else{if(this.form==c.FORM_STEP){tb.Z7(b,o).Z7(b,k);}else{if(this.form==c.FORM_REVSTEP){tb.Z7(f,k).Z7(b,k);}else{jsx3.chart.LOG.error("bad LineSeries form: "+this.form);}}}}}}};h.Xs=function(){var ac=this.Q0("VX");if(ac==null){ac=[];this.xI("VX",ac);}return ac;};h.PM=function(m,o,n,d){this.Xs().push([m,o,n,d]);};h.AS=function(o,m,l,f){this.Xs().push(null);};h.clear=function(){var bb=this.Xs();bb.splice(0,bb.length);};h.getXValue=function(a){if(this.xField)return jsx3.chart.asNumber(a.getAttribute(this.xField));return null;};h.getYValue=function(f){if(this.yField)return jsx3.chart.asNumber(f.getAttribute(this.yField));return null;};h.getLegendRenderer=function(){return new c.uz(this);};c.tooltip=function(j,p){var Gc=j.getXValue(p);var E=j.getYValue(p);return Gc!=null?"{"+Gc+","+E+"}":E;};h.toString=function(){return "[LineSeries '"+this.getName()+"']";};c.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.Series");jsx3.Class.defineClass("jsx3.chart.AreaSeries",jsx3.chart.Series,null,function(c,g){var t=jsx3.vector;var Gc=jsx3.chart;c.FORM_SEGMENT="segment";c.FORM_STEP="step";c.FORM_REVSTEP="reverseStep";c.Ae={segment:1,step:1,reverseStep:1};c.Xg=4;g.init=function(s,m){this.jsxsuper(s,m);this.xField=null;this.yField=null;this.minField=null;this.form=c.FORM_SEGMENT;this.pointRadius=null;this.pointRenderer=null;this.pointFill=null;this.pointStroke=null;this.pointGradient=null;this.setTooltipFunction("jsx3.chart.AreaSeries.tooltip");};g.getXField=function(){return this.xField;};g.setXField=function(s){this.xField=s;};g.getYField=function(){return this.yField;};g.setYField=function(j){this.yField=j;};g.getMinField=function(){return this.minField;};g.setMinField=function(b){this.minField=b;};g.getForm=function(){return this.form;};g.setForm=function(p){if(c.Ae[p]){this.form=p;}else{throw new jsx3.IllegalArgumentException("form",p);}};g.getPointRadius=function(){return this.pointRadius!=null?this.pointRadius:c.Xg;};g.setPointRadius=function(q){this.pointRadius=q;};g.getPointRenderer=function(){return this.d8("pointRenderer");};g.setPointRenderer=function(h){this.uR("pointRenderer",h);};g.getPointFill=function(){return this.pointFill;};g.setPointFill=function(q){this.pointFill=q;};g.getPointStroke=function(){return this.pointStroke;};g.setPointStroke=function(b){this.pointStroke=b;};g.getPointGradient=function(){return this.pointGradient;};g.setPointGradient=function(l){this.pointGradient=l;};g.B9=function(){var Cc=this.Q0("LJ");if(Cc==null)this.mG();return this.Q0("LJ");};g.b8=function(){var x=this.Q0("PY");if(x==null)this.mG();return this.Q0("PY");};g.mG=function(){var bb=this.qT();var Mc=t.Fill.valueOf(this.getPointFill());if(Mc==null&&bb!=null)Mc=new t.Fill(bb.getColor());if(Mc!=null)Mc=Gc.addGradient(Mc,this.pointGradient);var u=t.Stroke.valueOf(this.getPointStroke());this.xI("LJ",Mc);this.xI("PY",u);};g.getXValue=function(l){if(this.xField)return Gc.asNumber(l.getAttribute(this.xField));return null;};g.getYValue=function(p){if(this.yField)return Gc.asNumber(p.getAttribute(this.yField));return null;};g.getMinValue=function(s){if(this.minField)return Gc.asNumber(s.getAttribute(this.minField));return null;};g.PM=function(j,r,q,a){var G=this.Q0("ZN");if(G==null){G=[];this.xI("ZN",G);}G.push([j,r,q,a]);};g.YZ=function(m,l){var yb=this.Q0("vJ");if(yb==null){yb=[];this.xI("vJ",yb);}yb.push([m,l]);};g.BV=function(){var fc=this.Q0("ZN");if(fc!=null)fc.splice(0,fc.length);var u=this.Q0("vJ");if(u!=null)u.splice(0,u.length);};g.updateView=function(){this.jsxsuper();var Ob=this.l5();var yb=null,P=null;var F=this.D7();if(F!=null){yb=new t.Shape(null,0,0,Ob.getWidth(),Ob.getHeight());yb.setId(this.getId()+"_fill");Ob.appendChild(yb);yb.setFill(F);}var _=this.qT();if(_!=null){P=new t.Shape(null,0,0,Ob.getWidth(),Ob.getHeight());P.setId(this.getId()+"_stroke");Ob.appendChild(P);P.setStroke(_);}this.mG();var sb=this.Q0("ZN");var sc=this.Q0("vJ");if(sb==null||sb.length==0||sc==null||sc.length==0)return;var ub=this.getPointRenderer();var ib=this.getPointRadius();var R=this.getTooltipFunction();var D=this.B9();var Ic=this.b8();var pc=this.getColorFunction();this.A3(yb);for(var N=0;N<sb.length;N++){var wc=sb[N][0];var Lb=sb[N][1];var zb=sb[N][2];var T=sb[N][3];if(N==0){if(yb!=null)yb.X6(Lb,zb);if(P!=null)P.X6(Lb,zb);}else{var uc=sb[N-1][1];var O=sb[N-1][2];if(this.form==c.FORM_SEGMENT){if(yb!=null)yb.Z7(Lb,zb);if(P!=null)P.Z7(Lb,zb);}else{if(this.form==c.FORM_STEP){if(yb!=null)yb.Z7(Lb,O).Z7(Lb,zb);if(P!=null)P.Z7(Lb,O).Z7(Lb,zb);}else{if(this.form==c.FORM_REVSTEP){if(yb!=null)yb.Z7(uc,zb).Z7(Lb,zb);if(P!=null)P.Z7(uc,zb).Z7(Lb,zb);}else{Gc.LOG.error("bad AreaSeries form: "+this.form);}}}}if(ub!=null){var I=pc!=null?pc.call(null,wc,T):D;var Q=ub.render(Lb-ib,zb-ib,Lb+ib,zb+ib,I,Ic);Q.setId(this.getId()+"_p"+N);this.A3(Q,N,wc.getAttribute("jsxid"));Ob.appendChild(Q);if(R!=null)Q.setToolTip(R.call(null,this,wc));}}for(var N=sc.length-1;N>=0;N--){var Lb=sc[N][0];var zb=sc[N][1];if(N==sc.length-1){yb.Z7(Lb,zb);}else{var uc=sc[N+1][0];var O=sc[N+1][1];if(this.form==c.FORM_SEGMENT){yb.Z7(Lb,zb);}else{if(this.form==c.FORM_STEP){yb.Z7(uc,zb).Z7(Lb,zb);}else{if(this.form==c.FORM_REVSTEP){yb.Z7(Lb,O).Z7(Lb,zb);}else{Gc.LOG.error("bad AreaSeries form: "+this.form);}}}}}yb.w9();};c.tooltip=function(d,e){var wc=d.getXValue(e);var gc=d.getYValue(e);var db=d.getMinValue(e);var hc=db!=null?"{"+db+","+gc+"}":gc;if(wc!=null)hc=hc+(", x = "+wc);return hc;};g.toString=function(){return "[AreaSeries '"+this.getName()+"']";};c.getVersion=function(){return Gc.q2;};});jsx3.require("jsx3.chart.Series");jsx3.Class.defineClass("jsx3.chart.PieSeries",jsx3.chart.Series,null,function(i,h){var G=jsx3.vector;i.LABEL_PLACEMENTS={top:1,right:1,bottom:1,left:1};h.init=function(s,m){this.jsxsuper(s,m);this.field=null;this.totalAngle=null;this.startAngle=null;this.colors=null;this.colorFunction=null;this.stroke=null;this.labelPlacement=jsx3.chart.QBOTTOM;this.labelOffset=10;this.setTooltipFunction("jsx3.chart.PieSeries.tooltip");};h.getTotalAngle=function(){return this.totalAngle;};h.setTotalAngle=function(q){this.totalAngle=q==null?null:Math.max(0,Math.min(360,q));};h.getStartAngle=function(){return this.startAngle;};h.setStartAngle=function(l){this.startAngle=l==null?null:Math.modpos(l,360);};h.getField=function(){return this.field;};h.setField=function(c){this.field=c;};h.getValue=function(p){if(this.field)return jsx3.chart.asNumber(p.getAttribute(this.field));return null;};h.getColors=function(){return this.colors;};h.setColors=function(g){this.colors=g;};h.getLabelPlacement=function(){return this.labelPlacement!=null?this.labelPlacement:jsx3.chart.QBOTTOM;};h.setLabelPlacement=function(o){if(i.LABEL_PLACEMENTS[o]){this.labelPlacement=o;}else{throw new jsx3.IllegalArgumentException("labelPlacement",o);}};h.getLabelOffset=function(){return this.labelOffset!=null?this.labelOffset:0;};h.setLabelOffset=function(m){this.labelOffset=Math.round(m);};h.t0=function(r,j){var Y=this.getColors();if(Y!=null&&Y.length>0)return G.Fill.valueOf(Y[j%Y.length]);var O=this.getColorFunction();if(O!=null)return O.call(null,r,j);var Bb=this.getChart();if(Bb!=null)return Bb.t0(r,j);return new G.Fill();};h._c=function(d){if(this.stroke)return G.Stroke.valueOf(this.stroke);var x=this.getChart();if(x!=null){var sc=x.getSeriesStroke();if(sc)return G.Stroke.valueOf(sc);}return null;};h.YV=function(j,k,g,o,s,r,p,l){var pb=this.Q0("mI");if(pb==null){pb=[];this.xI("mI",pb);}pb.push([j,k,g,o,s,r,p,l]);};h.TJ=function(){this.YV(null);};h.NY=function(){var uc=this.Q0("mI");if(uc!=null)uc.splice(0,uc.length);};h.updateView=function(){this.jsxsuper();var xb=this.l5();var ob=xb.getWidth();var U=xb.getHeight();var R=this.Q0("mI");if(R==null)return;var Y=this.getTooltipFunction();for(var Vb=0;Vb<R.length;Vb++){var eb=R[Vb][0];if(eb==null)continue;var M=R[Vb][1];var D=R[Vb][2];var Mb=R[Vb][3];var Sb=R[Vb][4];var Cb=R[Vb][5];var kb=R[Vb][6];var ic=R[Vb][7];var zc=new G.Shape(null,0,0,ob,U);zc.setId(this.getId()+"_s"+Vb);xb.appendChild(zc);zc.setFill(this.t0(eb,Vb));zc.setStroke(this._c(Vb));this.A3(zc,Vb,eb.getAttribute("jsxid"));var Bc=G.degreesToRadians(Sb);var Hc=G.degreesToRadians(Mb);var _b=Math.round(kb*Math.cos(Bc))+M;var fb=Math.round(-1*kb*Math.sin(Bc))+D;var Ub=Math.round(kb*Math.cos(Hc))+M;var vb=Math.round(-1*kb*Math.sin(Hc))+D;var Rb=_b==Ub&&fb==vb&&Sb-Mb>180;zc.X6(_b,fb);if(Rb||_b!=Ub||fb!=vb){zc.XZ(M,D,kb,kb,_b,fb,Ub,vb,false);}if(Cb>0){var lc=Math.round(Cb*Math.cos(Bc))+M;var Wb=Math.round(-1*Cb*Math.sin(Bc))+D;var Lb=Math.round(Cb*Math.cos(Hc))+M;var wc=Math.round(-1*Cb*Math.sin(Hc))+D;zc.Z7(Lb,wc);if(Rb||lc!=Lb||Wb!=wc){zc.XZ(M,D,Cb,Cb,Lb,wc,lc,Wb,true);}}else{if(!Rb){zc.Z7(M,D);}}zc.w9();if(Y!=null)zc.setToolTip(Y.call(null,this,eb,ic));}var Ab=this.getLabel();if(Ab!=null&&Ab.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){var Pb=[0,0,ob,U];if(R.length>0){Pb=[R[0][1]-R[0][6],R[0][2]-R[0][6],R[0][1]+R[0][6],R[0][2]+R[0][6]];}var nc=Ab.getPreferredWidth();var Nc=Ab.getPreferredHeight();var Yb=0,gb=0;if(this.labelPlacement==jsx3.chart.QTOP){Yb=Math.round(ob/2-nc/2);gb=Pb[1]-this.getLabelOffset()-Nc;}else{if(this.labelPlacement==jsx3.chart.QRIGHT){Yb=Pb[2]+this.getLabelOffset();gb=Math.round(U/2-Nc/2);}else{if(this.labelPlacement==jsx3.chart.QLEFT){Yb=Pb[0]-this.getLabelOffset()-nc;gb=Math.round(U/2-Nc/2);}else{Yb=Math.round(ob/2-nc/2);gb=Pb[3]+this.getLabelOffset();}}}Ab.setDimensions(Yb,gb,nc,Nc);Ab.setText(this.getSeriesName());Ab.updateView();xb.appendChild(Ab.l5());}};i.tooltip=function(q,c,j){var yc=q.getValue(c);return yc+", "+Math.round(j*10)/10+"%";};h.toString=function(){return "[PieSeries '"+this.getName()+"']";};i.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.ChartComponent","jsx3.xml.Cacheable","jsx3.chart.Series");jsx3.Class.defineClass("jsx3.chart.Chart",jsx3.chart.ChartComponent,[jsx3.xml.Cacheable,jsx3.xml.CDF],function(d,f){var _=jsx3.vector;var lc=_.Fill;var M=jsx3.chart;d.tv=1;d.qj=2;d.ZINDEX_DATA=10;d.Xj=990;d.Nh=1000;d.id=20;d.DEFAULT_FILLS=[new lc(3381708,1),new lc(16763904,1),new lc(10079334,1),new lc(13408563,1),new lc(13421772,1),new lc(13382502,1),new lc(16751103,1),new lc(6710886,1)];d.DEFAULT_STROKES=[];d.PART_LEGEND=1<<0;d.Sz={top:1,right:1,bottom:1,left:1};f.init=function(a,e,h,o,i){this.jsxsuper(a);this.setDimensions(e,h,o,i);this.titlePlacement=M.QTOP;this.legendPlacement=M.QRIGHT;this.dataPadding=10;this.borderColor="#999999";this.borderWidth=1;this.borderAlpha=1;this.alpha=1;this.setRelativePosition(jsx3.gui.Block.RELATIVE);};f.getTitlePlacement=function(){return this.titlePlacement;};f.setTitlePlacement=function(r){if(d.Sz[r]){this.titlePlacement=r;}else{throw new jsx3.IllegalArgumentException("titlePlacement",r);}};f.getLegendPlacement=function(){return this.legendPlacement;};f.setLegendPlacement=function(l){if(d.Sz[l]){this.legendPlacement=l;}else{throw new jsx3.IllegalArgumentException("legendPlacement",l);}};f.getDataPadding=function(){return this.dataPadding;};f.setDataPadding=function(a){this.dataPadding=a;};f.getBorderColor=function(){return this.borderColor;};f.setBorderColor=function(l){this.borderColor=l;};f.getBorderWidth=function(){return this.borderWidth;};f.setBorderWidth=function(h){this.borderWidth=h;};f.getBorderAlpha=function(){return this.borderAlpha;};f.setBorderAlpha=function(m){this.borderAlpha=m;};f.getAlpha=function(){return this.alpha;};f.setAlpha=function(o){this.alpha=o!=null?_.F0(o):null;};f.M4=function(){return this.Q0("J4");};f.gH=function(){return this.Q0("RK");};f.xB=function(e){if(e!=null){this.xI("RK",e.selectNodes("/data/record").toArray());}else{this.qX("RK");}};f.getSeries=function(){return this.getDescendantsOfType(M.Series);};f.aO=function(){return this.findDescendants(function(s){return s instanceof M.Series&&s.getDisplay()!=jsx3.gui.Block.DISPLAYNONE;},false,true,false,false);};f.getSeriesIndex=function(o){var Cb=this.getSeries();for(var Cc=0;Cc<Cb.length;Cc++){if(o==Cb[Cc])return Cc;}return -1;};f.getChartTitle=function(){return M.ChartLabel?this.getFirstChildOfType(M.ChartLabel):null;};f.getLegend=function(){return M.Legend?this.getFirstChildOfType(M.Legend):null;};f.VO=function(){return false;};f.wH=jsx3.Method.newAbstract("series");f.getLegendEntryType=function(){jsx3.require("jsx3.chart.Legend");return M.Legend.SHOW_SERIES;};f.Z6=function(q,h){var bc=this.gH();if(bc==null)return null;var Kb=new Array(bc.length);for(var gb=0;gb<bc.length;gb++){Kb[gb]=0;for(var Fc=0;Fc<q.length;Fc++){var Q=q[Fc][h](bc[gb]);if(Q!=null)Kb[gb]+=Math.abs(Q);}}return Kb;};f.tK=function(o,j,h){var P=this.gH();if(P==null)return null;var E=new Array(o.length);for(var v=0;v<o.length;v++){E[v]=0;for(var tc=0;tc<P.length;tc++){var Xb=o[v][j](P[tc]);if(Xb!=null&&(Xb>=0||!h))E[v]+=Math.abs(Xb);}}return E;};f.lL=function(){return _.Canvas.jsxclass;};f.updateView=function(){this.jsxsuper();var ub=this.l5();var Lc=this.getLeft();var Ub=this.getTop();var Sb=this.getWidth();var tb=this.getHeight();if(isNaN(Sb)||isNaN(tb)){var ec=this.getParent().IO(this);if(Sb.toString().indexOf("%")>=0)Sb=Math.round(ec.parentwidth*parseFloat(Sb)/100);if(tb.toString().indexOf("%")>=0)tb=Math.round(ec.parentheight*parseFloat(tb)/100);ub.setWidth(Sb);ub.setHeight(tb);}var R=this.getXML();this.xB(R);var bb=new _.Rectangle(0,0,Sb,tb);ub.appendChild(bb);bb.setZIndex(d.tv);this.AV(bb);this.E_(bb);var dc=this.getPaddingDimensions();var w=this.borderWidth!=null?this.borderWidth:1;Sb=Sb-dc[1]-dc[3]-2*w;tb=tb-dc[0]-dc[2]-2*w;var Nb=new _.Group(dc[3]+w,dc[0]+w,Sb,tb);ub.appendChild(Nb);Nb.setZIndex(d.qj);var kc=this.getChartTitle();if(kc!=null&&kc.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){var zb=M.splitBox(0,0,Sb,tb,this.titlePlacement,kc.getPreferredWidth(),kc.getPreferredHeight());kc.setDimensions(zb[0][0],zb[0][1],zb[0][2],zb[0][3]);kc.setZIndex(d.Nh);kc.updateView();Nb.appendChild(kc.l5());Ub=zb[1][0];Lc=zb[1][1];Sb=zb[1][2];tb=zb[1][3];}else{Ub=0;Lc=0;}var Gc=new _.Group();this.xI("J4",Gc);Nb.appendChild(Gc);var Mc=this.getLegend();if(Mc!=null&&Mc.getDisplay()!=jsx3.gui.Block.DISPLAYNONE){var zb=M.splitBox(Ub,Lc,Sb,tb,this.legendPlacement,Mc.getPreferredWidth(),Mc.getPreferredHeight());Mc.setDimensions(zb[0][0],zb[0][1],zb[0][2],zb[0][3]);Mc.setZIndex(d.Xj);Mc.updateView();Nb.appendChild(Mc.l5());Gc.setDimensions(zb[1][0],zb[1][1],zb[1][2],zb[1][3]);}else{Gc.setDimensions(Ub,Lc,Sb,tb);}var ac=jsx3.html.BlockTag.nR(this.dataPadding);var O=Gc.getDimensions();Gc.setDimensions(O[0]+ac[3],O[1]+ac[0],O[2]-ac[1]-ac[3],O[3]-ac[0]-ac[2]);this.A3();var x=this.aO();for(var sb=0;sb<x.length;sb++){var P=this.VO()?x.length-sb:sb;x[sb].setZIndex(d.id+P);}};f.repaintParts=function(k){if(k&d.PART_LEGEND){var Z=this.getLegend();if(Z!=null)Z.repaint();}};f.toString=function(){return "[Chart '"+this.getName()+"']";};f.onSetChild=function(n){if(M.Legend&&n instanceof M.Legend){if(this.getLegend()!=null){M.LOG.info("can't add legend "+n+" because chart already has a legend");return false;}}else{if(M.ChartLabel&&n instanceof M.ChartLabel){if(this.getChartTitle()!=null){M.LOG.info("can't add title "+n+" because chart already has a title");return false;}}else{if(M.Series&&n instanceof M.Series){if(!this.wH(n)){M.LOG.info("can't add series "+n+" because it isn't of valid type for "+this);return false;}}else{return false;}}}return true;};f.redrawRecord=function(){this.repaint();};f.getMaskProperties=function(){return this.getRelativePosition()==jsx3.gui.Block.ABSOLUTE?M.ChartComponent.MASK_PROPS_ALLEDIT:M.ChartComponent.MASK_PROPS_ALLEDITREL;};f.onDestroy=function(i){this.jsxsuper(i);this.onDestroyCached(i);};f.T5=function(q){if(this.getParent()&&(q==null||isNaN(q.parentwidth)||isNaN(q.parentheight))){q=this.getParent().IO(this);}else{if(q==null){q={};}}var E=this.getRelativePosition()!=jsx3.gui.Block.ABSOLUTE;var sb=E?null:this.getLeft();var Ic=E?null:this.getTop();q.boxtype=E?"relativebox":"box";q.tagname="span";if(q.left==null&&sb!=null)q.left=sb;if(q.top==null&&Ic!=null)q.top=Ic;q.width=this.getWidth();q.height=this.getHeight();return new jsx3.gui.Painted.Box(q);};f.k7=function(a,q,s){if(s.isPositional()){this.B_(a,q,s,3);}else{var bc=this.getWidth();var X=this.getHeight();if(bc.toString().indexOf("%")>=0||X.toString().indexOf("%")>=0){bc=Math.round(a.parentwidth*parseFloat(bc)/100);X=Math.round(a.parentheight*parseFloat(X)/100);var Tb=this.l5();if(q!=null&&(bc!=Tb.getWidth()||X!=Tb.getHeight())&&bc>0&&X>0)s.addRepaint(this);}}};d.getVersion=function(){return M.q2;};});jsx3.require("jsx3.chart.Chart","jsx3.chart.Axis","jsx3.chart.GridLines");jsx3.Class.defineClass("jsx3.chart.CartesianChart",jsx3.chart.Chart,null,function(g,b){var vb=jsx3.chart;var Zb=vb.Chart;var Tb=vb.GridLines;var qb=vb.Axis;g.XPRIMARY_FILTER=function(l){return l instanceof qb&&l.sX()&&l.getHorizontal();};g.XSECONDARY_FILTER=function(c){return c instanceof qb&&!c.sX()&&c.getHorizontal();};g.YPRIMARY_FILTER=function(n){return n instanceof qb&&n.sX()&&!n.getHorizontal();};g.YSECONDARY_FILTER=function(m){return m instanceof qb&&!m.sX()&&!m.getHorizontal();};g.ZINDEX_GRIDLINES=Zb.ZINDEX_DATA+1;g.ZINDEX_GRIDLINES_FOREGROUND=Zb.ZINDEX_DATA+90;g.ZINDEX_AXIS=Zb.ZINDEX_DATA+100;g.PART_GRIDLINES=1<<8;b.init=function(c,j,m,d,k){this.jsxsuper(c,j,m,d,k);};b.getGridLines=function(){return Tb?this.getDescendantsOfType(Tb):[];};b.aX=function(l,r){var Qb=[];var Gc=r?this.aO():this.getSeries();for(var w=0;w<Gc.length;w++){if(l.getHorizontal()&&l.sX()==Gc[w].getUsePrimaryX()||!l.getHorizontal()&&l.sX()==Gc[w].getUsePrimaryY())Qb.push(Gc[w]);}return Qb;};b.getPrimaryXAxis=function(){return this.findDescendants(g.XPRIMARY_FILTER,false,false,true);};b.getSecondaryXAxis=function(){return this.findDescendants(g.XSECONDARY_FILTER,false,false,true);};b.getPrimaryYAxis=function(){return this.findDescendants(g.YPRIMARY_FILTER,false,false,true);};b.getSecondaryYAxis=function(){return this.findDescendants(g.YSECONDARY_FILTER,false,false,true);};b.getRangeForAxis=function(p){var I=this.aX(p,true);return p.getHorizontal()?this.getXRange(I):this.getYRange(I);};b.getXRange=jsx3.Method.newAbstract("series");b.getYRange=jsx3.Method.newAbstract("series");b.getRangeForField=function(c,j){var hb=this.gH();if(hb==null){vb.LOG.debug("no data provider for chart: "+this);return null;}var ob=Number.NEGATIVE_INFINITY;var Q=Number.POSITIVE_INFINITY;for(var S=0;S<hb.length;S++){var jb=hb[S];for(var Y=0;Y<c.length;Y++){var L=c[Y];var Bb=L[j](jb);if(Bb!=null){Q=Math.min(Q,Bb);ob=Math.max(ob,Bb);}}}if(ob==Number.NEGATIVE_INFINITY||Q==Number.POSITIVE_INFINITY)return null;return [Q,ob];};b.getStackedRangeForField=function(m,l){var nc=this.gH();if(nc==null){vb.LOG.debug("no data provider for chart: "+this);return null;}var hc=Number.NEGATIVE_INFINITY;var cb=Number.POSITIVE_INFINITY;for(var Cc=0;Cc<nc.length;Cc++){var ec=nc[Cc];var O=0,Nb=0;for(var R=0;R<m.length;R++){var hb=m[R];var yc=hb[l](ec);if(yc==null)continue;if(yc>=0)O=O+yc;else Nb=Nb+yc;}cb=Math.min(cb,Nb);hc=Math.max(hc,O);}if(hc==Number.NEGATIVE_INFINITY||cb==Number.POSITIVE_INFINITY)return null;return [cb,hc];};b.getStacked100RangeForField=function(p,i){var I=this.gH();if(I==null){vb.LOG.debug("no data provider for chart: "+this);return null;}var C=Number.NEGATIVE_INFINITY;var X=Number.POSITIVE_INFINITY;for(var ac=0;ac<I.length;ac++){var y=I[ac];var ec=0,gb=0,M=0;for(var pc=0;pc<p.length;pc++){var rc=p[pc];var fb=rc[i](y);if(fb==null)continue;M=M+Math.abs(fb);if(fb>=0)ec=ec+fb;else gb=gb+fb;}var kb=M==0?0:100*gb/M;var sc=M==0?0:100*ec/M;X=Math.min(X,kb);C=Math.max(C,sc);}if(C==Number.NEGATIVE_INFINITY||X==Number.POSITIVE_INFINITY)return null;return [X,C];};b.getCombinedRange=function(f){var Wb=Number.NEGATIVE_INFINITY;var E=Number.POSITIVE_INFINITY;for(var mb=0;mb<f.length;mb++){if(f[mb]!=null){E=Math.min(E,f[mb][0]);Wb=Math.max(Wb,f[mb][1]);}}if(Wb==Number.NEGATIVE_INFINITY||E==Number.POSITIVE_INFINITY)return null;return [E,Wb];};b.updateView=function(){this.jsxsuper();var Ab=this.M4();var Ob=this.getPrimaryXAxis();var Cc=this.getPrimaryYAxis();var Dc=this.getSecondaryXAxis();var E=this.getSecondaryYAxis();var Ec=Ab.getWidth();var z=Ab.getHeight();var zc=Ab.getPaddingDimensions();var tb=null;for(var kb=1;kb<=2;kb++){var W=null;if(kb==1){W=[Dc!=null?Dc.getDisplayWidth():0,E!=null?E.getDisplayWidth():0,Ob!=null?Ob.getDisplayWidth():0,Cc!=null?Cc.getDisplayWidth():0];}else{W=this.getAxisMetrics(Dc,E,Ob,Cc);}tb=[zc[3]+W[3],zc[0]+W[0],Ec-(zc[3]+W[3]+zc[1]+W[1]),z-(zc[0]+W[0]+zc[2]+W[2])];this.prepareAxis(Ob,tb[2]);this.prepareAxis(Cc,tb[3]);this.prepareAxis(Dc,tb[2]);this.prepareAxis(E,tb[3]);}var sc=this.getGridLines();for(var kb=0;kb<sc.length;kb++){var Xb=sc[kb];if(Xb.getDisplay()==jsx3.gui.Block.DISPLAYNONE)continue;Xb.setDimensions(tb);Xb.setZIndex(Xb.getInForeground()?g.ZINDEX_GRIDLINES_FOREGROUND:g.ZINDEX_GRIDLINES);Xb.updateView();Ab.appendChild(Xb.l5());}this.updateAxisView(Ob,tb[0],tb[1]);this.updateAxisView(Cc,tb[0],tb[1]);this.updateAxisView(Dc,tb[0],tb[1]);this.updateAxisView(E,tb[0],tb[1]);var Z=this.aO();for(var kb=0;kb<Z.length;kb++){Z[kb].setDimensions(tb);}};b.prepareAxis=function(l,k){if(l!=null){l.setLength(k);l.g6();}};b.updateAxisView=function(i,q,r){var Gb=this.M4();if(i!=null){i.setDimensions(q,r,Gb.getWidth(),Gb.getHeight());i.setZIndex(g.ZINDEX_AXIS);i.updateView();Gb.appendChild(i.l5());}};b.getAxisMetrics=function(q,j,r,f){var Z=0,Ab=0,Nb=0,wc=0;if(q!=null){var lb=q.x1();Ab=lb[1];wc=lb[0];}if(j!=null){var lb=j.x1();Nb=Nb+lb[0];Z=Z+lb[1];}if(r!=null){var lb=r.x1();wc=Math.max(wc,lb[1]);Ab=Math.max(Ab,lb[0]);}if(f!=null){var lb=f.x1();Z=Math.max(Z,lb[0]);Nb=Math.max(Nb,lb[1]);}return [Ab,Nb,wc,Z];};b.repaintParts=function(e){if(e&g.PART_GRIDLINES){var Nb=this.getGridLines();for(var y=0;y<Nb.length;y++){var Z=Nb[y];if(Z.getDisplay()==jsx3.gui.Block.DISPLAYNONE)continue;Z.setZIndex(Z.getInForeground()?g.ZINDEX_GRIDLINES_FOREGROUND:g.ZINDEX_GRIDLINES);Z.repaint();}}this.jsxsuper(e);};b.onSetChild=function(r){if(Tb&&r instanceof Tb){return true;}else{if(qb&&r instanceof qb){return true;}else{return this.jsxsuper(r);}}};b.toString=function(){return "[CartesianChart '"+this.getName()+"']";};g.getVersion=function(){return vb.q2;};});jsx3.require("jsx3.chart.CartesianChart","jsx3.chart.BarSeries");jsx3.Class.defineClass("jsx3.chart.BCChart",jsx3.chart.CartesianChart,null,function(q,e){q.TYPE_CLUSTERED="clustered";q.TYPE_STACKED="stacked";q.TYPE_STACKED100="stacked100";q.jv={clustered:1,stacked:1,stacked100:1};e.init=function(c,g,j,m,k){this.jsxsuper(c,g,j,m,k);this.type=q.TYPE_CLUSTERED;this.seriesOverlap=0;this.categoryCoverage=0.65;};e.getType=function(){return this.type;};e.setType=function(r){if(q.jv[r])this.type=r;else throw new jsx3.IllegalArgumentException("type",r);};e.getSeriesOverlap=function(){return !isNaN(this.seriesOverlap)?this.seriesOverlap:0;};e.setSeriesOverlap=function(h){this.seriesOverlap=h;};e.getCategoryCoverage=function(){return !isNaN(this.categoryCoverage)?this.categoryCoverage:1;};e.setCategoryCoverage=function(m){this.categoryCoverage=m;};e.pC=jsx3.Method.newAbstract();e.Wh=jsx3.Method.newAbstract();e.Td=function(b,a,p,r,l,m){if(this.type==q.TYPE_STACKED||this.type==q.TYPE_STACKED100){p=0;r=1;}var Dc=a-b;var lb=Dc*m;var ic=(b+a)/2;var Wb=lb/(r-r*l+l);var nc=Wb*(p-(r-1)/2)*(1-l);var Mc=null;if(p>0&&l==0){var cb=Wb*(p-1-(r-1)/2)*(1-l);Mc=Math.round(ic+cb+Wb/2);}else{Mc=Math.round(ic+nc-Wb/2);}var U=Math.round(ic+nc+Wb/2)-1;return [Mc,U];};e.Ns=function(a){if(this.type==q.TYPE_CLUSTERED){var ec=this.getRangeForField(a,"getParallelValue");var J=this.getRangeForField(a,"getMinValue");return this.getCombinedRange([ec,J]);}else{if(this.type==q.TYPE_STACKED){return this.getStackedRangeForField(a,"getParallelValue");}else{if(this.type==q.TYPE_STACKED100){return this.getStacked100RangeForField(a,"getParallelValue");}else{jsx3.chart.LOG.error("unsupported Bar/Column Chart type: "+this.type);return null;}}}};e.We=function(p){return this.getRangeForField(p,"getNormalValue");};e.updateView=function(){this.jsxsuper();this.JJ();};e.JJ=function(){var J=this.M4();var pb=this.aO();var nc=pb.length;if(nc==0)return;var vc=this.gH();var yc=this.pC();var nb=this.Wh();if(vc==null||yc==null||nb==null)return;if(!jsx3.chart.isValueAxis(yc)){jsx3.chart.LOG.error("bad parallel axis type: "+yc.getClass());return;}var W=this.getSeriesOverlap();var _=this.getCategoryCoverage();var Bb=null;if(this.type==q.TYPE_STACKED100)Bb=this.Z6(pb,"getParallelValue");var xb=null,A=null;if(this.type==q.TYPE_STACKED||this.type==q.TYPE_STACKED100){xb=new Array(vc.length);A=new Array(vc.length);for(var Fc=0;Fc<vc.length;Fc++){xb[Fc]=A[Fc]=0;}}for(var Fc=0;Fc<nc;Fc++){var jc=pb[Fc];jc.MY();for(var Qb=0;Qb<vc.length;Qb++){var H=vc[Qb];var ab=null,hc=null;if(jsx3.chart.isValueAxis(yc)){var db=jc.getParallelValue(H);if(this.type==q.TYPE_CLUSTERED){ab=jc.getMinValue(H);if(ab==null)ab=0;hc=db;if(hc==null){continue;}}else{if(this.type==q.TYPE_STACKED||this.type==q.TYPE_STACKED100){var rb=this.type==q.TYPE_STACKED?db:100*(db/Bb[Qb]);if(rb>=0){ab=xb[Qb];hc=xb[Qb]+rb;xb[Qb]=hc;}else{ab=A[Qb]+rb;hc=A[Qb];A[Qb]=ab;}}}}var Jc=yc.getCoordinateForNoClip(ab);if(ab!=0)Jc=Jc+(yc.getHorizontal()?1:-1);var w=yc.getCoordinateForNoClip(hc);var cb=null,wc=null;if(jsx3.chart.isValueAxis(nb)){var _b=jc.getNormalValue(H);if(_b==null)continue;var xc=nb.getCoordinateForNoClip(_b);var L=jc.getNormalWidth();cb=xc-Math.ceil(L/2);wc=xc+Math.floor(L/2);}else{if(jsx3.chart.isCategoryAxis(nb)){var Q=nb.getRangeForCategory(Qb);var Ec=this.Td(Q[0],Q[1],Fc,nc,W,_);cb=Ec[0];wc=Ec[1];}}jc.ZW(H,Qb,Jc,cb,w,wc);}jc.updateView();J.appendChild(jc.l5());}};q.getVersion=function(){return jsx3.chart.q2;};});jsx3.Class.defineClass("jsx3.chart.BarChart",jsx3.chart.BCChart,null,function(f,m){m.init=function(e,i,l,k,g){this.jsxsuper(e,i,l,k,g);};m.wH=function(k){return k instanceof jsx3.chart.BarSeries;};m.getXRange=function(h){return this.Ns(h);};m.getYRange=function(o){return this.We(o);};m.pC=function(){return this.getPrimaryXAxis();};m.Wh=function(){return this.getPrimaryYAxis();};m.toString=function(){return "[BarChart '"+this.getName()+"']";};});jsx3.Class.defineClass("jsx3.chart.ColumnChart",jsx3.chart.BCChart,null,function(s,e){e.init=function(r,c,f,q,g){this.jsxsuper(r,c,f,q,g);};e.wH=function(i){return i instanceof jsx3.chart.ColumnSeries;};e.getXRange=function(o){return this.We(o);};e.getYRange=function(b){return this.Ns(b);};e.pC=function(){return this.getPrimaryYAxis();};e.Wh=function(){return this.getPrimaryXAxis();};e.toString=function(){return "[ColumnChart '"+this.getName()+"']";};});jsx3.require("jsx3.chart.CartesianChart","jsx3.chart.PointSeries");jsx3.Class.defineClass("jsx3.chart.PlotChart",jsx3.chart.CartesianChart,null,function(p,d){p.MAG_RADIUS="radius";p.MAG_DIAMETER="diameter";p.MAG_AREA="area";p.DEFAULT_MAX_POINT_RADIUS=30;p.iu={radius:1,diameter:1,area:1};d.init=function(i,m,k,g,q){this.jsxsuper(i,m,k,g,q);this.maxPointRadius=p.DEFAULT_MAX_POINT_RADIUS;this.magnitudeMethod=p.MAG_RADIUS;};d.getMaxPointRadius=function(){return this.maxPointRadius!=null?this.maxPointRadius:Number.POSITIVE_INFINITY;};d.setMaxPointRadius=function(r){this.maxPointRadius=r;};d.getMagnitudeMethod=function(){return this.magnitudeMethod;};d.setMagnitudeMethod=function(j){if(p.iu[j]){this.magnitudeMethod=j;}else{throw new jsx3.IllegalArgumentException("magnitudeMethod",j);}};d.getXRange=function(m){return this.getRangeForField(m,"getXValue");};d.getYRange=function(q){return this.getRangeForField(q,"getYValue");};d.updateView=function(){this.jsxsuper();this.JJ();};d.JJ=function(){var xb=this.M4();var bb=this.aO();var Vb=this.gH();var W=this.getPrimaryXAxis();var G=this.getPrimaryYAxis();if(W==null||G==null||bb.length==0||Vb==null)return;if(!jsx3.chart.isValueAxis(W)){jsx3.chart.LOG.error("bad x axis type: "+W.getClass());return;}if(!jsx3.chart.isValueAxis(G)){jsx3.chart.LOG.error("bad y axis type: "+G.getClass());return;}for(var wb=0;wb<bb.length;wb++){var yc=bb[wb];yc.BV();for(var M=0;M<Vb.length;M++){var rc=Vb[M];var R=yc.getXValue(rc);var Nc=yc.getYValue(rc);if(R==null||Nc==null)continue;R=W.getCoordinateForNoClip(R);Nc=G.getCoordinateForNoClip(Nc);if(yc instanceof jsx3.chart.PointSeries){yc.PM(rc,M,R,Nc);}else{var ob=yc.getMagnitudeValue(rc);if(ob!=null)yc.PM(rc,M,R,Nc,ob);}}yc.updateView();xb.appendChild(yc.l5());}};d.wH=function(b){return b instanceof jsx3.chart.PlotSeries;};d.toString=function(){return "[PlotChart '"+this.getName()+"']";};p.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.CartesianChart","jsx3.chart.LineSeries");jsx3.Class.defineClass("jsx3.chart.LineChart",jsx3.chart.CartesianChart,null,function(e,n){e.TYPE_OVERLAY="overlay";e.TYPE_STACKED="stacked";e.TYPE_STACKED100="stacked100";e.jv={overlay:1,stacked:1,stacked100:1};n.init=function(h,l,o,r,p){this.jsxsuper(h,l,o,r,p);this.type=e.TYPE_OVERLAY;};n.getType=function(){return this.type;};n.setType=function(r){if(e.jv[r]){this.type=r;}else{throw new jsx3.IllegalArgumentException("type",r);}};n.getYRange=function(h){if(this.type==e.TYPE_OVERLAY){return this.getRangeForField(h,"getYValue");}else{if(this.type==e.TYPE_STACKED){return this.getStackedRangeForField(h,"getYValue");}else{if(this.type==e.TYPE_STACKED100){return this.getStacked100RangeForField(h,"getYValue");}else{jsx3.chart.LOG.error("unsupported Line Chart type: "+this.type);return null;}}}};n.getXRange=function(i){return this.getRangeForField(i,"getXValue");};n.updateView=function(){this.jsxsuper();this.JJ();};n.JJ=function(){var Zb=this.M4();var Db=this.aO();var hb=this.gH();var Cc=this.getPrimaryXAxis();var L=this.getPrimaryYAxis();if(Cc==null||L==null||Db.length==0||hb==null)return;if(!jsx3.chart.isValueAxis(L)){jsx3.chart.LOG.error("bad y axis type: "+L.getClass());return;}var kb=null;if(this.type==e.TYPE_STACKED100)kb=this.Z6(Db,"getYValue");var _=null,rb=null;if(this.type==e.TYPE_STACKED||this.type==e.TYPE_STACKED100){_=new Array(hb.length);rb=new Array(hb.length);for(var X=0;X<hb.length;X++){_[X]=rb[X]=0;}}for(var Bb=0;Bb<Db.length;Bb++){var qc=Db[Bb];qc.clear();for(var X=0;X<hb.length;X++){var Gc=hb[X];var uc=null,ab=null;var P=qc.getYValue(Gc);if(P!=null&&(this.type==e.TYPE_STACKED||this.type==e.TYPE_STACKED100)){if(P>=0)P=_[X]=_[X]+P;else P=rb[X]=rb[X]+P;if(this.type==e.TYPE_STACKED100)P=100*(P/kb[X]);}if(P!=null)ab=L.getCoordinateForNoClip(P);if(jsx3.chart.isValueAxis(Cc)){var C=qc.getXValue(Gc);if(C!=null)uc=Cc.getCoordinateForNoClip(C);}else{if(jsx3.chart.isCategoryAxis(Cc)){uc=Cc.getPointForCategory(X);}}if(uc!=null&&ab!=null)qc.PM(Gc,uc,ab,X);else qc.AS(Gc,uc,ab,X);}qc.updateView();Zb.appendChild(qc.l5());}};n.VO=function(){return this.type==e.TYPE_STACKED||this.type==e.TYPE_STACKED100;};n.wH=function(o){return o instanceof jsx3.chart.LineSeries;};n.toString=function(){return "[LineChart '"+this.getName()+"']";};e.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.CartesianChart","jsx3.chart.AreaSeries");jsx3.Class.defineClass("jsx3.chart.AreaChart",jsx3.chart.CartesianChart,null,function(r,q){r.TYPE_OVERLAY="overlay";r.TYPE_STACKED="stacked";r.TYPE_STACKED100="stacked100";q.init=function(n,s,b,a,c){this.jsxsuper(n,s,b,a,c);this.type=r.TYPE_OVERLAY;};q.getType=function(){return this.type;};q.setType=function(n){if(r.ALLOWED_TYPES[n]){this.type=n;}else{throw new jsx3.IllegalArgumentException("type",n);}};q.getYRange=function(d){if(this.type==r.TYPE_OVERLAY){return this.getRangeForField(d,"getYValue");}else{if(this.type==r.TYPE_STACKED){return this.getStackedRangeForField(d,"getYValue");}else{if(this.type==r.TYPE_STACKED100){return this.getStacked100RangeForField(d,"getYValue");}else{jsx3.chart.LOG.error("unsupported Line Chart type: "+this.type);return null;}}}};q.getXRange=function(m){return this.getRangeForField(m,"getXValue");};q.updateView=function(){this.jsxsuper();this.JJ();};q.JJ=function(){var ac=this.M4();var Lc=this.aO();var jb=this.gH();var wb=this.getPrimaryXAxis();var kc=this.getPrimaryYAxis();if(wb==null||kc==null||Lc.length==0||jb==null)return;if(!jsx3.chart.isValueAxis(kc)){jsx3.chart.LOG.error("bad y axis type: "+kc.getClass());return;}var mc=null;if(this.type==r.TYPE_STACKED100)mc=this.Z6(Lc,"getYValue");var Kc=null,Vb=null;if(this.type==r.TYPE_STACKED||this.type==r.TYPE_STACKED100){Kc=new Array(jb.length);Vb=new Array(jb.length);for(var xb=0;xb<jb.length;xb++){Kc[xb]=Vb[xb]=0;}}for(var L=0;L<Lc.length;L++){var bb=Lc[L];bb.BV();for(var xb=0;xb<jb.length;xb++){var S=jb[xb];var wc=null,gc=null,db=null;var Zb=bb.getYValue(S);var Ic=bb.getMinValue(S);if(Zb==null)continue;if(this.type==r.TYPE_STACKED||this.type==r.TYPE_STACKED100){if(Zb>=0){Ic=Kc[xb];Zb=Kc[xb]+Zb;Kc[xb]=Zb;}else{Ic=Vb[xb];Zb=Vb[xb]+Zb;Vb[xb]=Zb;}if(this.type==r.TYPE_STACKED100){Zb=100*(Zb/mc[xb]);Ic=100*(Ic/mc[xb]);}}if(Ic==null)Ic=0;gc=kc.getCoordinateForNoClip(Zb);db=kc.getCoordinateFor(Ic);if(jsx3.chart.isValueAxis(wb)){var _=bb.getXValue(S);if(_!=null)wc=wb.getCoordinateForNoClip(_);}else{if(jsx3.chart.isCategoryAxis(wb)){wc=wb.getPointForCategory(xb);}}if(wc==null)continue;bb.PM(S,wc,gc,xb);bb.YZ(wc,db);}bb.updateView();ac.appendChild(bb.l5());}};q.VO=function(){return this.type==r.TYPE_STACKED||this.type==r.TYPE_STACKED100;};q.wH=function(j){return j instanceof jsx3.chart.AreaSeries;};q.toString=function(){return "[AreaChart '"+this.getName()+"']";};r.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.Chart");jsx3.Class.defineClass("jsx3.chart.RadialChart",jsx3.chart.Chart,null,function(m,a){a.init=function(c,g,j,d,k){this.jsxsuper(c,g,j,d,k);};a.updateView=function(){this.jsxsuper();var uc=this.M4();var ic=uc.getWidth();var nc=uc.getHeight();var Tb=uc.getPaddingDimensions();var Hb=[Tb[3],Tb[0],ic-(Tb[3]+Tb[1]),nc-(Tb[0]+Tb[2])];var Mb=this.aO();for(var sc=0;sc<Mb.length;sc++){Mb[sc].setDimensions(Hb);}};m.degreesToRadians=function(f){return Math.modpos(2*Math.PI/360*(-1*f+90),2*Math.PI);};m.getVersion=function(){return jsx3.chart.q2;};});jsx3.require("jsx3.chart.RadialChart","jsx3.chart.PieSeries");jsx3.Class.defineClass("jsx3.chart.PieChart",jsx3.chart.RadialChart,null,function(n,g){g.init=function(r,c,f,q,i){this.jsxsuper(r,c,f,q,i);this.innerRadius=0;this.seriesPadding=0.1;this.totalAngle=360;this.startAngle=0;this.categoryField=null;this.colors=null;this.colorFunction="jsx3.chart.PieChart.defaultColoring";this.seriesStroke=null;};g.getInnerRadius=function(){return this.innerRadius!=null?this.innerRadius:0;};g.setInnerRadius=function(c){this.innerRadius=c==null?null:Math.max(0,Math.min(1,c));};g.getSeriesPadding=function(){return this.seriesPadding!=null?this.seriesPadding:0.1;};g.setSeriesPadding=function(c){this.seriesPadding=c;};g.getTotalAngle=function(){return this.totalAngle!=null?this.totalAngle:360;};g.setTotalAngle=function(h){this.totalAngle=h==null?null:Math.max(0,Math.min(360,h));};g.getStartAngle=function(){return this.startAngle!=null?this.startAngle:0;};g.setStartAngle=function(m){this.startAngle=m;};g.getCategoryField=function(){return this.categoryField;};g.setCategoryField=function(c){this.categoryField=c;};g.getColors=function(){return this.colors;};g.setColors=function(j){this.colors=j;};g.getColorFunction=function(){return this.o_("colorFunction");};g.setColorFunction=function(r){this.uR("colorFunction",r);};g.getSeriesStroke=function(){return this.seriesStroke;};g.setSeriesStroke=function(h){this.seriesStroke=h;};g.t0=function(e,o){var qc=this.getColors();if(qc!=null&&qc.length>0)return jsx3.vector.Fill.valueOf(qc[o%qc.length]);var Jc=this.getColorFunction();if(Jc!=null)return Jc.call(null,e,o);return new jsx3.vector.Fill();};g.updateView=function(){this.jsxsuper();var _=this.M4();var bc=this.aO();var Bc=this.gH();if(bc.length<1)return;if(Bc==null||Bc.length<1)return;var Fb=bc[0].getWidth();var vb=bc[0].getHeight();var J=Math.round(Fb/2);var xc=Math.round(vb/2);var Bb=Math.floor(Math.min(Fb,vb)/2);var G=this.tK(bc,"getValue",true);var t=Bb*(1-this.getInnerRadius())/(bc.length+(bc.length-1)*this.getSeriesPadding());var fc=Bb*this.getInnerRadius();for(var ac=0;ac<bc.length;ac++){var Sb=bc[ac];Sb.NY();var u=Sb.getStartAngle();if(u==null)u=this.getStartAngle();var uc=Sb.getTotalAngle();if(uc==null)uc=this.getTotalAngle();var ub=fc+t;for(var P=0;P<Bc.length;P++){var D=Bc[P];var W=Sb.getValue(D);if(W==null||W<=0){Sb.TJ();continue;}var tb=uc*W/G[ac];Sb.YV(D,J,xc,u,u+tb,Math.round(fc),Math.round(ub),100*W/G[ac]);u=u+tb;}Sb.updateView();_.appendChild(Sb.l5());fc=fc+t*(1+this.getSeriesPadding());}};g.VO=function(){return true;};g.wH=function(a){return a instanceof jsx3.chart.PieSeries;};g.getLegendEntryType=function(){jsx3.require("jsx3.chart.Legend");return jsx3.chart.Legend.SHOW_CATEGORIES;};g.toString=function(){return "[PieChart '"+this.getName()+"']";};n.defaultColoring=function(s,j){return jsx3.chart.Chart.DEFAULT_FILLS[j%jsx3.chart.Chart.DEFAULT_FILLS.length];};n.getVersion=function(){return jsx3.chart.q2;};});
