<?php

//    include/functions.inc.php
//    General functions
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: functions.inc.php,v 1.13 2004/06/29 11:00:39 angusgb Exp $

if ( defined( '__FUNCTIONS_INC' ) ) return;
define( '__FUNCTIONS_INC', 1 );

include ("./include/global.inc.php");

// Get the translation table for characters
$XSS_table = get_html_translation_table(HTML_ENTITIES);
$XSS_table['('] = '&#40;';
$XSS_table[')'] = '&#41;';

// Function for XSS safe writing (www.cgisecurity.com)
function WriteHTML($str)
{
   global $XSS_table;
   return strtr($str, $XSS_table);
}

function DisplayErrMsg($errmsg)
{

?>
   <B><?php echo WriteHTML($errmsg); ?></B><BR>
<?php

}


///////
   // Page Management
///////

function WritePageLink($initpage,$pagesize,$count,$dbname,$otherinfo="")
{
  if ($count !=0)
  {
   $nextoffset=$initpage+$pagesize;

   $pag=ceil($count/$pagesize);
   $numpag = floor(($initpage * $pag)/$count) +1;

   $justone=false;
   global $PHP_SELF;
   global $strNext;
   global $strPrevious;
   global $strAll;

   if ($pag >= 1)
   {
      $justone=true;
      
      if ($initpage != 0)
      {
        // Show the first page Link
        global $strFirst;
        ?>
        | <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=0&amp;pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strFirst; ?></A>
        <?php
      }
      $i = $numpag - 4;
      if ($i < 1)
	$i = 1;
      for (; $i < $numpag; ++$i)
      {
	?>
	| <a href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=<?php echo $pagesize * ($i - 1); ?>&amp;pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>">
	<?php echo $i; ?></a>
	<?php
      }
   }
   if ($pag > 1)
   {
      echo ' | <strong>' . $numpag . '</strong>';
   }
   else
      $justone=false;

   if ($count > ($initpage + $pagesize))
   {
      $max = $numpag + 4;
      if ($max > $pag)
        $max = $pag;
      for ($i = $numpag + 1; $i <= $max ; ++$i)
      {
        ?>
   	| <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=<?php echo $pagesize * ($i - 1); ?>&amp;pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>">
	<?php echo $i; ?></A><?php
      }

      global $strLast;
      $lastoffset=((int)((int)($count-1)/$pagesize))*$pagesize;
      ?>
      | <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=<?php echo $lastoffset; ?>&pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strLast; ?></A>
      <?php
   }

   if ($justone)
   {
      echo " | ";
      if ($pag > 1)
      {
         // Show the full list Link
         ?>
         <a href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=0&amp;pagesize=<?php echo $count; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strAll; ?></a>
<?php
      }
   }
  }
}


function GetTextString($str)
{
   if (empty($str))
      $str='Unknown';

   $str2 = "\$str" . (string) $str;
   eval("global $str2;");
   eval("\$tmp=$str2;");
   return $tmp;
}

function GetURL($url)
{
   global $MaxURLStrLength;
   if ($MaxURLStrLength > 0 && strlen($url) > $MaxURLStrLength)
      return WriteHTML(substr($url, 0, $MaxURLStrLength) . '[...]');
   else return WriteHTML($url);
}

?>
