#!/usr/bin/env python3
"""
Plots intensity data difference stored in BornAgain "*.int" or "*.int.gz" format
Usage: python plot_dif.py reference.int.gz new.int.gz
"""

import sys
import bornagain as ba
from bornagain import ba_plot as bp


if __name__ == '__main__':
    if len(sys.argv) != 3:
        exit("Usage: plot_diff_int.py reference.int.gz other.int.gz")

    filename1, filename2 = sys.argv[1], sys.argv[2]

    df_ref = ba.readData2D(filename1)
    df_new = ba.readData2D(filename2)

    assert(df_new.size() == df_ref.size())
    for i in range(df_ref.size()):
        df_new.setAt(i, 2 * abs(df_new.valAt(i)-df_ref.valAt(i)) / (df_new.valAt(i)+df_ref.valAt(i)))

    bp.plot_datafield(df_new)
    bp.plt.show()
