/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_minion_ip_h__
#define __ls10_dev_minion_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_CMINION_FALCON                                0x000006ff:0x00000000 /* RW--D */
#define NV_CMINION_RISCV                                 0x00000fff:0x00000700 /* RW--D */
#define NV_MINION                                        0x00003FFF:0x00002000 /* RW--D */
#define NV_CMINION_FALCON_IRQSCLR                                                                        0x00000004     /* -W-4R */
#define NV_CMINION_FALCON_IRQSCLR_GPTMR                                                                  0:0            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_GPTMR_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_WDTMR                                                                  1:1            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_WDTMR_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_MTHD                                                                   2:2            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_MTHD_SET                                                               0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_CTXSW                                                                  3:3            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_CTXSW_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_HALT                                                                   4:4            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_HALT_SET                                                               0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXTERR                                                                 5:5            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXTERR_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN0                                                                 6:6            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN0_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN1                                                                 7:7            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_SWGEN1_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ1                                                            8:8            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ1_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ2                                                            9:9            /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ2_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ3                                                            10:10          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ3_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ4                                                            11:11          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ4_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ5                                                            12:12          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ5_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ6                                                            13:13          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ6_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ7                                                            14:14          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ7_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ8                                                            15:15          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_EXT_EXTIRQ8_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_DMA                                                                    16:16          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_DMA_SET                                                                0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_SHA                                                                    17:17          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_SHA_SET                                                                0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_MEMERR                                                                 18:18          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_MEMERR_SET                                                             0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_CTXSW_ERROR                                                            19:19          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_CTXSW_ERROR_SET                                                        0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_ICD                                                                    22:22          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_ICD_SET                                                                0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSCLR_IOPMP                                                                  23:23          /* -WXVF */
#define NV_CMINION_FALCON_IRQSCLR_IOPMP_SET                                                              0x00000001     /* -W--V */
#define NV_CMINION_FALCON_IRQSTAT                                                                        0x00000008     /* R--4R */
#define NV_CMINION_FALCON_IRQSTAT_GPTMR                                                                  0:0            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_GPTMR_FALSE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_GPTMR_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_WDTMR                                                                  1:1            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_WDTMR_FALSE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_WDTMR_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_MTHD                                                                   2:2            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_MTHD_FALSE                                                             0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_MTHD_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW                                                                  3:3            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_FALSE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_HALT                                                                   4:4            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_HALT_FALSE                                                             0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_HALT_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXTERR                                                                 5:5            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXTERR_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXTERR_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN0                                                                 6:6            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN0_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN0_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN1                                                                 7:7            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN1_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_SWGEN1_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ1                                                            8:8            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ1_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ1_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ2                                                            9:9            /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ2_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ2_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ3                                                            10:10          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ3_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ3_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ4                                                            11:11          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ4_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ4_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ5                                                            12:12          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ5_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ5_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ6                                                            13:13          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ6_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ6_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ7                                                            14:14          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ7_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ7_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ8                                                            15:15          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ8_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_EXT_EXTIRQ8_FALSE                                                      0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_DMA                                                                    16:16          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_DMA_TRUE                                                               0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_DMA_FALSE                                                              0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_SHA                                                                    17:17          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_SHA_TRUE                                                               0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_SHA_FALSE                                                              0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_MEMERR                                                                 18:18          /* R-IVF */
#define NV_CMINION_FALCON_IRQSTAT_MEMERR_TRUE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_MEMERR_FALSE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_ERROR                                                            19:19          /* R-XVF */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_ERROR_TRUE                                                       0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_CTXSW_ERROR_FALSE                                                      0x00000000     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_ICD                                                                    22:22          /* R-XVF */
#define NV_CMINION_FALCON_IRQSTAT_ICD_TRUE                                                               0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_ICD_FALSE                                                              0x00000000     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_IOPMP                                                                  23:23          /* R-XVF */
#define NV_CMINION_FALCON_IRQSTAT_IOPMP_TRUE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQSTAT_IOPMP_FALSE                                                            0x00000000     /* R---V */
#define NV_CMINION_FALCON_IRQMASK                                                                        0x00000018     /* R--4R */
#define NV_CMINION_FALCON_IRQMASK_GPTMR                                                                  0:0            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_GPTMR_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_GPTMR_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_WDTMR                                                                  1:1            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_WDTMR_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_WDTMR_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_MTHD                                                                   2:2            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_MTHD_DISABLE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_MTHD_ENABLE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_CTXSW                                                                  3:3            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_HALT                                                                   4:4            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_HALT_DISABLE                                                           0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_HALT_ENABLE                                                            0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXTERR                                                                 5:5            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXTERR_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXTERR_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN0                                                                 6:6            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_SWGEN0_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN0_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN1                                                                 7:7            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_SWGEN1_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_SWGEN1_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT                                                                    15:8           /*       */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ1                                                            8:8            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ1_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ1_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ2                                                            9:9            /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ2_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ2_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ3                                                            10:10          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ3_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ3_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ4                                                            11:11          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ4_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ4_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ5                                                            12:12          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ5_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ5_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ6                                                            13:13          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ6_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ6_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ7                                                            14:14          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ7_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ7_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ8                                                            15:15          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ8_ENABLE                                                     0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_EXT_EXTIRQ8_DISABLE                                                    0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_DMA                                                                    16:16          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_DMA_ENABLE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_DMA_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_SHA                                                                    17:17          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_SHA_ENABLE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_SHA_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_MEMERR                                                                 18:18          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_MEMERR_ENABLE                                                          0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_MEMERR_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_ERROR                                                            19:19          /* R-IVF */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_ERROR_ENABLE                                                     0x00000001     /* R-I-V */
#define NV_CMINION_FALCON_IRQMASK_CTXSW_ERROR_DISABLE                                                    0x00000000     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_ICD                                                                    22:22          /* R-XVF */
#define NV_CMINION_FALCON_IRQMASK_ICD_ENABLE                                                             0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_ICD_DISABLE                                                            0x00000000     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_IOPMP                                                                  23:23          /* R-XVF */
#define NV_CMINION_FALCON_IRQMASK_IOPMP_ENABLE                                                           0x00000001     /* R---V */
#define NV_CMINION_FALCON_IRQMASK_IOPMP_DISABLE                                                          0x00000000     /* R---V */
#define NV_CMINION_RISCV_CPUCTL                                                                          0x00000788     /* RW-4R */
#define NV_CMINION_RISCV_CPUCTL_STARTCPU                                                                 0:0            /* -WIVF */
#define NV_CMINION_RISCV_CPUCTL_STARTCPU_FALSE                                                           0x00000000     /* -WI-V */
#define NV_CMINION_RISCV_CPUCTL_STARTCPU_TRUE                                                            0x00000001     /* -W--V */
#define NV_CMINION_RISCV_CPUCTL_HALTED                                                                   4:4            /* R-IVF */
#define NV_CMINION_RISCV_CPUCTL_HALTED_INIT                                                              0x00000001     /* R-I-V */
#define NV_CMINION_RISCV_CPUCTL_HALTED_TRUE                                                              0x00000001     /* R---V */
#define NV_CMINION_RISCV_CPUCTL_HALTED_FALSE                                                             0x00000000     /* R---V */
#define NV_CMINION_RISCV_CPUCTL_STOPPED                                                                  5:5            /* R-IVF */
#define NV_CMINION_RISCV_CPUCTL_STOPPED_INIT                                                             0x00000000     /* R-I-V */
#define NV_CMINION_RISCV_CPUCTL_ACTIVE_STAT                                                              7:7            /* R-IVF */
#define NV_CMINION_RISCV_CPUCTL_ACTIVE_STAT_INACTIVE                                                     0x00000000     /* R-I-V */
#define NV_CMINION_RISCV_CPUCTL_ACTIVE_STAT_ACTIVE                                                       0x00000001     /* R---V */
#define NV_MINION_MINION_INTR                                 0x00002810      /* RW-4R */
#define NV_MINION_MINION_INTR_FATAL                           0:0             /* RWEVF */
#define NV_MINION_MINION_INTR_FATAL_INIT                      0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONFATAL                        1:1             /* RWEVF */
#define NV_MINION_MINION_INTR_NONFATAL_INIT                   0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_FALCON_STALL                    2:2             /* R-EVF */
#define NV_MINION_MINION_INTR_FALCON_STALL_INIT               0x00000000      /* R-E-V */
#define NV_MINION_MINION_INTR_FALCON_NOSTALL                  3:3             /* R-EVF */
#define NV_MINION_MINION_INTR_FALCON_NOSTALL_INIT             0x00000000      /* R-E-V */
#define NV_MINION_MINION_INTR_LINK                            31:16           /* R-EVF */
#define NV_MINION_MINION_INTR_LINK_INIT                       0x00000000      /* R-E-V */
#define NV_MINION_MINION_INTR_STALL_EN                        0x00002818      /* RW-4R */
#define NV_MINION_MINION_INTR_STALL_EN_FATAL                  0:0             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_FATAL_DISABLE          0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_FATAL_ENABLE           0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_NONFATAL               1:1             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_NONFATAL_DISABLE       0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_NONFATAL_ENABLE        0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_STALL           2:2             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_STALL_DISABLE   0x00000000      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_STALL_ENABLE    0x00000001      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_NOSTALL         3:3             /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_NOSTALL_DISABLE 0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_FALCON_NOSTALL_ENABLE  0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_STALL_EN_LINK                   31:16           /* RWEVF */
#define NV_MINION_MINION_INTR_STALL_EN_LINK_DISABLE_ALL       0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_STALL_EN_LINK_ENABLE_ALL        0x0000ffff      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN                     0x0000281c      /* RW-4R */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FATAL               0:0             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FATAL_DISABLE       0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FATAL_ENABLE        0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_NONFATAL            1:1             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_NONFATAL_DISABLE    0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_NONFATAL_ENABLE     0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_STALL        2:2             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_STALL_DISABLE 0x00000000     /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_STALL_ENABLE 0x00000001      /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_NOSTALL      3:3             /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_NOSTALL_DISABLE 0x00000000   /* RW--V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_FALCON_NOSTALL_ENABLE 0x00000001    /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_LINK                31:16           /* RWEVF */
#define NV_MINION_MINION_INTR_NONSTALL_EN_LINK_DISABLE_ALL    0x00000000      /* RWE-V */
#define NV_MINION_MINION_INTR_NONSTALL_EN_LINK_ENABLE_ALL     0x0000ffff      /* RW--V */
#define NV_MINION_MINION_STATUS                               0x00002830      /* RW-4R */
#define NV_MINION_MINION_STATUS_STATUS                        7:0             /* RWEVF */
#define NV_MINION_MINION_STATUS_STATUS_INIT                   0x00000000      /* RW--V */
#define NV_MINION_MINION_STATUS_STATUS_NOTBOOT                0x00000000      /* RWE-V */
#define NV_MINION_MINION_STATUS_STATUS_BOOT                   0x00000001      /* RW--V */
#define NV_MINION_MINION_STATUS_INTR_CODE                     31:8            /* RWEVF */
#define NV_MINION_MINION_STATUS_INTR_CODE_INIT                0x00000000      /* RWE-V */
#define NV_MINION_MISC_0                                      0x000028b0      /* RW-4R */
#define NV_MINION_MISC_0_SCRATCH_SWRW_0                       31:0            /* RWEVF */
#define NV_MINION_MISC_0_SCRATCH_SWRW_0_INIT                  0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD(i)                            (0x00002900+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_CMD__SIZE_1                       4               /*       */
#define NV_MINION_NVLINK_DL_CMD_COMMAND                       7:0             /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_NOP                   0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPHY               0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SWINTR                0x00000002      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITLANEENABLE        0x00000003      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITDLPL              0x00000004      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITRXTERM            0x00000005      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITTL                0x00000006      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPLL               0x00000007      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_LANEDISABLE           0x00000008      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_LANESHUTDOWN          0x0000000c      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPHASE1            0x0000000d      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITNEGOTIATE         0x0000000e      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITOPTIMIZE          0x0000000f      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_ENABLEPM              0x00000010      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DISABLEPM             0x00000011      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_TXCLKSWITCH_PLL       0x00000014      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_TXCLKSWITCH_ALT       0x00000015      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_CLEARRESTORESTATE     0x00000017      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SAVESTATE             0x00000018      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_READ_PHY_TRAINING_PARAMS 0x00000020   /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_WRITE_PHY_TRAINING_PARAMS 0x00000021  /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_INITPHASE5A           0x00000022      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED1             0x00000023      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED2             0x00000024      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED3             0x00000025      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_READ_RX_BUFFER_START  0x00000030      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_READ_RX_BUFFER_MIDDLE 0x00000031      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_READ_RX_BUFFER_END    0x00000032      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_WRITE_TX_BUFFER_START 0x00000033      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_WRITE_TX_BUFFER_MIDDLE 0x00000034     /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_WRITE_TX_BUFFER_END   0x00000035      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_CLEAR_RX_BUFFER       0x00000036      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_CLEAR_TX_BUFFER       0x00000037      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_CONFIGEOM             0x00000040      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SETNEA                0x00000041      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SETNEDR               0x00000042      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SETNEDW               0x00000043      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_STARTEOM              0x00000044      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_ENDEOM                0x00000045      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_XAVIER_PLLOVERRIDE_ON 0x00000050      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_XAVIER_PLLOVERRIDE_OFF 0x00000051     /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_XAVIER_CALIBRATEPLL   0x00000052      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_TURING_RXDET          0x00000058      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_ABORTRXDET            0x00000059      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_SET_BUFFER_READY      0x00000060      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_DLERRCNT   0x00000070      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_DLLPCNT    0x00000071      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_DLTHROUGHPUTCNT 0x00000072 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DLSTAT_CLR_MINION_MISCCNT 0x00000073  /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED4             0x00000074      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED5             0x00000075      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_FAST   0x00000080      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_MEDIUM 0x00000081      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SLOW   0x00000082      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_DEFAULT 0x00000083     /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_RXCAL_EN_ALARM 0x00000084 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_INIT_CAL_DONE 0x00000085 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SMF_VALUES_SLOW 0x00000086 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SMF_VALUES_MEDIUM 0x00000087 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SMF_VALUES_MEDIUM_SERIAL 0x00000088 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SMF_VALUES_FAST 0x00000089 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SMF_VALUES_FAST_ERRORS 0x0000008a /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_PLL_TIMEOUT 0x0000008b /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_UPHY_TABLES_DEFAULT 0x0000008c /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_UPHY_TABLES_SHORT 0x0000008d /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_UPHY_TABLES_FAST 0x0000008e /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_IOBIST_ECC 0x0000008f  /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED6             0x00000090      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_RESERVED7             0x00000091      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE_SET_TIEBREAK_GT 0x00000092 /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_PROTECTIONS_OFF   0x000000f0      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_DBG_SETSIMMODE        0x000000f1      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_COMMAND_ALWAYSFAULT           0x000000ff      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_FAULT                         30:30           /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_FAULT_FAULT_CLEAR             0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_FAULT_NOFAULT_NOCLEAR         0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD_READY                         31:31           /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_READY_TRUE                    0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_READY_FALSE                   0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD_DATA(i)                       (0x00002920+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_CMD_DATA__SIZE_1                  4               /*       */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA                     31:0            /* RWEVF */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA_INIT                0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA_SET_BUFFER_READY_TX 0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA_SET_BUFFER_READY_RX 0x00000002      /* RW--V */
#define NV_MINION_NVLINK_DL_CMD_DATA_DATA_SET_BUFFER_READY_TX_AND_RX 0x00000003 /* RW--V */
#define NV_MINION_NVLINK_DL_STAT(i)                           (0x00002980+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_STAT__SIZE_1                      4               /*       */
#define NV_MINION_NVLINK_DL_STAT_ARGS                         15:0            /* RWEVF */
#define NV_MINION_NVLINK_DL_STAT_ARGS_INIT                    0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_STAT_STATUSIDX                    23:16           /* RWEVF */
#define NV_MINION_NVLINK_DL_STAT_STATUSIDX_INIT               0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_STAT_READY                        31:31           /* RWEVF */
#define NV_MINION_NVLINK_DL_STAT_READY_TRUE                   0x00000001      /* RW--V */
#define NV_MINION_NVLINK_DL_STAT_READY_FALSE                  0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_DL_STATDATA(i)                       (0x000029c0+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_DL_STATDATA__SIZE_1                  4               /*       */
#define NV_MINION_NVLINK_DL_STATDATA_DATA                     31:0            /* RWEVF */
#define NV_MINION_NVLINK_DL_STATDATA_DATA_INIT                0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_LINK_INTR(i)                         (0x00002a00+(i)*0x4) /* RW-4A */
#define NV_MINION_NVLINK_LINK_INTR__SIZE_1                    4               /*       */
#define NV_MINION_NVLINK_LINK_INTR_CODE                       7:0             /* RWEVF */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NA                    0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_SWREQ                 0x00000001      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_DLREQ                 0x00000002      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_PMDISABLED            0x00000003      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_DLCMDFAULT            0x00000004      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_TLREQ                 0x00000005      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NOINIT                0x00000010      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NOTIFY                0x00000017      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_LOCAL_CONFIG_ERR      0x00000018      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_NEGOTIATION_CONFIG_ERR 0x00000019     /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_BADINIT               0x00000020      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_PMFAIL                0x00000021      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_INBAND_BUFFER_AVAILABLE 0x00000022    /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_INBAND_BUFFER_COMPLETE 0x00000023     /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_CODE_INBAND_BUFFER_FAIL    0x00000024      /* RW--V */
#define NV_MINION_NVLINK_LINK_INTR_SUBCODE                    15:8            /* RWEVF */
#define NV_MINION_NVLINK_LINK_INTR_SUBCODE_INIT               0x00000000      /* RWE-V */
#define NV_MINION_NVLINK_LINK_INTR_STATE                      31:31           /* RWEVF */
#define NV_MINION_NVLINK_LINK_INTR_STATE_INIT                 0x00000000      /* RWE-V */

#define NV_MINION_ERR_STATUS_0                                0x00002d00      /* RW-4R */
#define NV_MINION_ERR_STATUS_0_MINION_IMEM_PARITY_ERR         0:0             /* RWIVF */
#define NV_MINION_ERR_STATUS_0_MINION_IMEM_PARITY_ERR__ONWRITE "oneToClear"   /*       */
#define NV_MINION_ERR_STATUS_0_MINION_IMEM_PARITY_ERR_NONE    0x00000000      /* RWI-V */
#define NV_MINION_ERR_STATUS_0_MINION_IMEM_PARITY_ERR_CLEAR   0x00000001      /* RW--V */
#define NV_MINION_ERR_STATUS_0_MINION_DMEM_PARITY_ERR         4:4             /* RWIVF */
#define NV_MINION_ERR_STATUS_0_MINION_DMEM_PARITY_ERR__ONWRITE "oneToClear"   /*       */
#define NV_MINION_ERR_STATUS_0_MINION_DMEM_PARITY_ERR_NONE    0x00000000      /* RWI-V */
#define NV_MINION_ERR_STATUS_0_MINION_DMEM_PARITY_ERR_CLEAR   0x00000001      /* RW--V */
#define NV_MINION_ERR_STATUS_0_MINION_MPU_PARITY_ERR          8:8             /* RWIVF */
#define NV_MINION_ERR_STATUS_0_MINION_MPU_PARITY_ERR__ONWRITE "oneToClear"    /*       */
#define NV_MINION_ERR_STATUS_0_MINION_MPU_PARITY_ERR_NONE     0x00000000      /* RWI-V */
#define NV_MINION_ERR_STATUS_0_MINION_MPU_PARITY_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_MINION_ERR_STATUS_0_MINION_REG_PARITY_ERR          12:12           /* RWIVF */
#define NV_MINION_ERR_STATUS_0_MINION_REG_PARITY_ERR__ONWRITE "oneToClear"    /*       */
#define NV_MINION_ERR_STATUS_0_MINION_REG_PARITY_ERR_NONE     0x00000000      /* RWI-V */
#define NV_MINION_ERR_STATUS_0_MINION_REG_PARITY_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_MINION_ERR_LOG_EN_0                                0x00002d04      /* RW-4R */
#define NV_MINION_ERR_LOG_EN_0_MINION_IMEM_PARITY_ERR         0:0             /* RWEVF */
#define NV_MINION_ERR_LOG_EN_0_MINION_IMEM_PARITY_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_MINION_ERR_LOG_EN_0_MINION_IMEM_PARITY_ERR_ENABLE  0x00000001      /* RW--V */
#define NV_MINION_ERR_LOG_EN_0_MINION_DMEM_PARITY_ERR         4:4             /* RWEVF */
#define NV_MINION_ERR_LOG_EN_0_MINION_DMEM_PARITY_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_MINION_ERR_LOG_EN_0_MINION_DMEM_PARITY_ERR_ENABLE  0x00000001      /* RW--V */
#define NV_MINION_ERR_LOG_EN_0_MINION_MPU_PARITY_ERR          8:8             /* RWEVF */
#define NV_MINION_ERR_LOG_EN_0_MINION_MPU_PARITY_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_MINION_ERR_LOG_EN_0_MINION_MPU_PARITY_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_MINION_ERR_LOG_EN_0_MINION_REG_PARITY_ERR          12:12           /* RWEVF */
#define NV_MINION_ERR_LOG_EN_0_MINION_REG_PARITY_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_MINION_ERR_LOG_EN_0_MINION_REG_PARITY_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0                       0x00002d08      /* RW-4R */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_IMEM_PARITY_ERR 0:0            /* RWEVF */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_IMEM_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_IMEM_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_DMEM_PARITY_ERR 4:4            /* RWEVF */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_DMEM_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_DMEM_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_MPU_PARITY_ERR 8:8             /* RWEVF */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_MPU_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_MPU_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_REG_PARITY_ERR 12:12           /* RWEVF */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_REG_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_FATAL_REPORT_EN_0_MINION_REG_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0                   0x00002d0c      /* RW-4R */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_IMEM_PARITY_ERR 0:0        /* RWEVF */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_IMEM_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_IMEM_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_DMEM_PARITY_ERR 4:4        /* RWEVF */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_DMEM_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_DMEM_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_MPU_PARITY_ERR 8:8         /* RWEVF */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_MPU_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_MPU_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_REG_PARITY_ERR 12:12       /* RWEVF */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_REG_PARITY_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_MINION_ERR_NON_FATAL_REPORT_EN_0_MINION_REG_PARITY_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_MINION_ERR_CORRECTABLE_REPORT_EN_0                 0x00002d10      /* RW-4R */
#define NV_MINION_ERR_CONTAIN_EN_0                            0x00002d14      /* RW-4R */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_IMEM_PARITY_ERR     0:0             /* RWEVF */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_IMEM_PARITY_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_IMEM_PARITY_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_DMEM_PARITY_ERR     4:4             /* RWEVF */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_DMEM_PARITY_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_DMEM_PARITY_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_MPU_PARITY_ERR      8:8             /* RWEVF */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_MPU_PARITY_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_MPU_PARITY_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_REG_PARITY_ERR      12:12           /* RWEVF */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_REG_PARITY_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_MINION_ERR_CONTAIN_EN_0_MINION_REG_PARITY_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_MINION_ERR_FIRST_0                                 0x00002d1c      /* RW-4R */
#define NV_MINION_ERR_FIRST_0_MINION_IMEM_PARITY_ERR          0:0             /* RWIVF */
#define NV_MINION_ERR_FIRST_0_MINION_IMEM_PARITY_ERR__ONWRITE "oneToClear"    /*       */
#define NV_MINION_ERR_FIRST_0_MINION_IMEM_PARITY_ERR_NONE     0x00000000      /* RWI-V */
#define NV_MINION_ERR_FIRST_0_MINION_IMEM_PARITY_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_MINION_ERR_FIRST_0_MINION_DMEM_PARITY_ERR          4:4             /* RWIVF */
#define NV_MINION_ERR_FIRST_0_MINION_DMEM_PARITY_ERR__ONWRITE "oneToClear"    /*       */
#define NV_MINION_ERR_FIRST_0_MINION_DMEM_PARITY_ERR_NONE     0x00000000      /* RWI-V */
#define NV_MINION_ERR_FIRST_0_MINION_DMEM_PARITY_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_MINION_ERR_FIRST_0_MINION_MPU_PARITY_ERR           8:8             /* RWIVF */
#define NV_MINION_ERR_FIRST_0_MINION_MPU_PARITY_ERR__ONWRITE  "oneToClear"    /*       */
#define NV_MINION_ERR_FIRST_0_MINION_MPU_PARITY_ERR_NONE      0x00000000      /* RWI-V */
#define NV_MINION_ERR_FIRST_0_MINION_MPU_PARITY_ERR_CLEAR     0x00000001      /* RW--V */
#define NV_MINION_ERR_FIRST_0_MINION_REG_PARITY_ERR           12:12           /* RWIVF */
#define NV_MINION_ERR_FIRST_0_MINION_REG_PARITY_ERR__ONWRITE  "oneToClear"    /*       */
#define NV_MINION_ERR_FIRST_0_MINION_REG_PARITY_ERR_NONE      0x00000000      /* RWI-V */
#define NV_MINION_ERR_FIRST_0_MINION_REG_PARITY_ERR_CLEAR     0x00000001      /* RW--V */
#define NV_MINION_ERR_IMEM_ERROR_ADDRESS                      0x00002d20      /* R--4R */
#define NV_MINION_ERR_IMEM_ERROR_ADDRESS_ERROR_ADDRESS        15:0            /* R-IVF */
#define NV_MINION_ERR_IMEM_ERROR_ADDRESS_ERROR_ADDRESS_INIT   0x00000000      /* R-I-V */
#define NV_MINION_ERR_DMEM_ERROR_ADDRESS                      0x00002d24      /* R--4R */
#define NV_MINION_ERR_DMEM_ERROR_ADDRESS_ERROR_ADDRESS        15:0            /* R-IVF */
#define NV_MINION_ERR_DMEM_ERROR_ADDRESS_ERROR_ADDRESS_INIT   0x00000000      /* R-I-V */
#define NV_MINION_ERR_MPU_ERROR_ADDRESS                       0x00002d28      /* R--4R */
#define NV_MINION_ERR_MPU_ERROR_ADDRESS_ERROR_ADDRESS         15:0            /* R-IVF */
#define NV_MINION_ERR_MPU_ERROR_ADDRESS_ERROR_ADDRESS_INIT    0x00000000      /* R-I-V */

#endif // __ls10_dev_minion_ip_h__
