# Clean Longwave IR Window - Band 13

As stated in the *Band 13 - ABI Quick Information Guide* by Bachmeier et al. [1], the 10.3 µm (Band 13) band, referred to as "clean" infrared window band, when compared to other infrared bands, is less sensitive to water vapor.

Therefore, this composite, is useful for detecting clouds during day and night time, being especially useful for the estimation of the cloud top height.

### Appearance

Intensifying storms (enhanced-vs) are shown in tons of red and it might have overshoots in black.

Thermal couplets (overshooting tops) will have their cold regions shown in black and warm regions ranging from yellow to green.

According to Bachmeier et al. [1], the Intensifying storms and/or overshooting tops "are associated with thunderstorms that are or will (usually within 20-30 minutes) be producing either winds, large hail, or tornadoes" Bachmeier et al. [1].

This composite has a LUT that is shown below, with a temperature range of 163 K to 330 K.

![Scale](lut/cal/abi_ir_11-15.png)

### Limitations

For Bachmeier et al. [1], The temperatures shown, especially during day time, are not necessarily a representation of 2 meter air temperatures. Due to the absorption of some of the upwelling energy by the atmospheric water vapor, the brightness temperatures don't represent the skin temperature on a 1:1 basis.


### References

1. S. Bachmeier, T. Schmit and J. Gerth "Band 13 - ABI Quick Information Guide", UW-Madison CIMSS/NOAA, Aug. 2017, https://cimss.ssec.wisc.edu/goes/OCLOFactSheetPDFs/ABIQuickGuide_Band13.pdf. [View Article](https://cimss.ssec.wisc.edu/goes/OCLOFactSheetPDFs/ABIQuickGuide_Band13.pdf)
