# 2023-01-31 Triage Log

Overall a positive week, with relatively few regressions overall and a number of improvements.

Triage done by **@simulacrum**.
Revision range: [c8e6a9e8b6251bbc8276cb78cabe1998deecbed7..a64ef7d07d0411315be85a646586cb85eeb9c136](https://perf.rust-lang.org/?start=c8e6a9e8b6251bbc8276cb78cabe1998deecbed7&end=a64ef7d07d0411315be85a646586cb85eeb9c136&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.0%, -0.2%] | 27    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.9%, -0.5%] | 11    |
| All ❌✅ (primary)                 | -0.8% | [-2.0%, 0.6%]  | 28    |


2 Regressions, 4 Improvements, 6 Mixed; 2 of them in rollups
44 artifact comparisons made in total

#### Regressions

Fix thin archive reading [#107360](https://github.com/rust-lang/rust/pull/107360) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6cd6bad51fb34a0d89e97c27814041fe4d0838b5&end=252741673b9c2b06267cd3a036d77489e92f963a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.3%, 0.6%] | 13    |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.4%, 0.5%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.3%, 0.6%] | 13    |

Revert of previous PR to fix behavior. Regressions are minor and hopefully the
relanding of the original PR will fix them too.

Use stable metric for const eval limit instead of current terminator-based logic [#106227](https://github.com/rust-lang/rust/pull/106227) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bcb064a7f4aee705c97ce1b74beb9af0f9b5adb2&end=3cdd0197e78e2ca3403157617709bbfe18a3f0b5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.4%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.5%, 1.0%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.4%] | 3     |

The new metric adds new MIR instructions, which increases the size of MIR and
slightly hurts performance. However, this is in service of a concrete feature,
so acceptable.


#### Improvements

use `LocalDefId` instead of `HirId` in trait resolution to simplify the obligation clause resolution [#103902](https://github.com/rust-lang/rust/pull/103902) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=95b61d16d4bd2e46b0a110c1bda703f026f0a94f&end=027c8507b4265dcf285b0b503e2a49214b929f7b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 4     |


InstCombine away intrinsic validity assertions [#105582](https://github.com/rust-lang/rust/pull/105582) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2a17174ee639f8e0a3cee307d5685d38beb474ba&end=885bf628879310b885721e1fdd91ea2cbca9311f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.3%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 6     |


Only compute mir_generator_witnesses query in drop_tracking_mir mode. [#107406](https://github.com/rust-lang/rust/pull/107406) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9f82651a5fa4b1d96f55ce5507dd2aa204c7fb61&end=bcb064a7f4aee705c97ce1b74beb9af0f9b5adb2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -3.7% | [-5.7%, -1.1%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Test drop_tracking_mir before querying generator. [#107443](https://github.com/rust-lang/rust/pull/107443) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=487e83b711b96d84ce2edfc4cb4ba792c10b589e&end=dc3e59cb3fe05ebd752d3a2269f501c00327be22&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.2%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.4%] | 8     |
| All ❌✅ (primary)                 | -0.5% | [-0.6%, -0.2%] | 14    |


#### Mixed

Move format_args!() into AST (and expand it during AST lowering) [#106745](https://github.com/rust-lang/rust/pull/106745) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=40fda7b3fe2b10c6e1a0568b59516f5e7f381886&end=3e977638728922d3a6cc7bea34a2fdb8ae97f7c0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 0.8%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.3%, 1.3%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-2.3%, -0.2%] | 51    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.8%, -0.7%] | 6     |
| All ❌✅ (primary)                 | -0.6% | [-2.3%, 0.8%]  | 55    |

Overall mostly an improvement, not worth further investigation.

Rollup of 8 pull requests [#107343](https://github.com/rust-lang/rust/pull/107343) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=db137ba7d4415ac77e2b7601ef017ff2ca41b335&end=18890f05f6cea40fd25bb4bb9aa6f7372b69f641&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.5%, 0.8%]   | 7     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | 0.7%  | [0.5%, 0.8%]   | 7     |

Regressions are limited to a single primary benchmark (bitmaps), and don't seem
large enough to warrant spending further time investigating.

rustdoc: Collect "rustdoc-reachable" items during early doc link resolution [#107054](https://github.com/rust-lang/rust/pull/107054) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=18890f05f6cea40fd25bb4bb9aa6f7372b69f641&end=6874f4e3fc2a16be7c78e702d068bbc1daa90e16&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.0%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.9%, -0.2%] | 14    |
| All ❌✅ (primary)                 | -0.2% | [-1.0%, 0.4%]  | 6     |

Wins generally outweigh small regressions.

Compute generator saved locals on MIR [#101692](https://github.com/rust-lang/rust/pull/101692) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7d4df2d30eb342af1ef136d83d70d281f34adcd7&end=6cd6bad51fb34a0d89e97c27814041fe4d0838b5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.4%, 0.6%]   | 14    |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [0.3%, 6.0%]   | 22    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 12    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.7%, 0.6%]  | 26    |

Follow-up in #107406 has resolved 5% regression here, leaving ~1% regressions,
but those are likely overall OK.

Rollup of 9 pull requests [#107408](https://github.com/rust-lang/rust/pull/107408) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d8da51366817317d19be9bd138943eafb30bc987&end=bca8b4dc32ec20f9a4e0ca55f54e5b2a531936fc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.8%  | [1.5%, 2.1%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.8%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 1.2%  | [-0.6%, 2.1%]  | 8     |


Remove HirId -> LocalDefId map from HIR. [#107206](https://github.com/rust-lang/rust/pull/107206) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bca8b4dc32ec20f9a4e0ca55f54e5b2a531936fc&end=d6f0642827e21a088b0130c84857d84f5433301d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 7     |
