# 2022-11-02 Triage Log

Noise continues to make triaging a bit tedious. We've become good at identifying noise, but we may need to invest in trying to reduce it or automate some of the triaging needed to identify it. In terms of performance, this week ending up being positive albeit with improvements only outweighing regressions by a little. Some of the largest improvements were in reverts of previous regressions as well.

Triage done by **@rylev**.
Revision range: [629a414d..822f8](https://perf.rust-lang.org/?start=629a414d7ba4caa3ca28b0a46c478e2ecb4c0059&end=822f8c22f540b12f296d844ad5bf39aaa47bfeb4&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [0.2%, 7.9%]   | 28    |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [0.2%, 7.0%]   | 97    |
| Improvements ✅ <br /> (primary)   | -1.2% | [-4.6%, -0.2%] | 73    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.6%, -0.3%] | 61    |
| All ❌✅ (primary)                 | -0.4% | [-4.6%, 7.9%]  | 101   |

13 Regressions, 9 Improvements, 5 Mixed; 9 of them in rollups
41 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#103572](https://github.com/rust-lang/rust/pull/103572) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43dd3d514b6b11c5195de2fd8e665828801d0972&end=0a6b941df354c59b546ec4c0d27f2b9b0cb1162c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.3%, 0.3%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 3     |
- Small number and severity of regressions means that we don't need to follow up on this.


Rollup of 5 pull requests [#103671](https://github.com/rust-lang/rust/pull/103671) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=898f463c93e72dac9b7a28ae662dd12fd71be0b7&end=a9ef10019fd3be6e03afb4b213368f4af1917f9b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.5%] | 14    |
| Regressions ❌ <br /> (secondary)  | 2.0% | [0.5%, 4.1%] | 18    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.5%] | 14    |
- Most of the secondary regressions seem to be noise, but the primary regressions are unlikely to be.
- A perf run was done for #103641, but nothing showed up. 
- A new attempt for #103550 was kicked off. 

Fix line numbers for MIR inlined code [#103071](https://github.com/rust-lang/rust/pull/103071) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5237c4d83db0a04a0119918b174ee642acd82d9c&end=77e7b74ad5c0c449fa378faf5edf33dd2e6fed87&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0% | [0.6%, 2.2%] | 8     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.0% | [0.6%, 2.2%] | 8     |
- Perf regression seems real and @wesleywiser has committed to investigate.

poll_fn and Unpin: fix pinning [#102737](https://github.com/rust-lang/rust/pull/102737) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9565dfeb4e6225177bbe78f18cd48a7982f34401&end=7174231ae66aa3e938cbe0b84e23e79d867fec20&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 2.0% | [0.4%, 4.1%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/102737#issuecomment-1295789750).

Introduce UnordMap, UnordSet, and UnordBag (MCP 533) [#102698](https://github.com/rust-lang/rust/pull/102698) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=33b55ac39fa633d0983fad014469e1036669bf28&end=607878d069267e1402ad792c9331b426e4c6d0f9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 1.8% | [0.4%, 4.1%] | 14    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/102698#issuecomment-1295802732).

Rollup of 8 pull requests [#103727](https://github.com/rust-lang/rust/pull/103727) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=33b530e04099465a8029ef581202d52f4075558e&end=68c836a904e5a421712db311421c5266f9ce71c0&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 1.9% | [0.4%, 4.1%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/103727#issuecomment-1296095218).

Bump to 1.67.0 [#103731](https://github.com/rust-lang/rust/pull/103731) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5e9772042948002f9c6f60c4c81603170035fffa&end=15ee24a2fab6a29dd2235d7c4e383c9011f5900f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 2.1% | [0.5%, 4.1%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/103731#issuecomment-1296094665).

update Miri [#103721](https://github.com/rust-lang/rust/pull/103721) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4827ceecb9ee9bc0508fecf7059bcc134ca187d0&end=b03502b35d111bef0399a66ab3cc765f0802e8ba&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 3.1% | [0.4%, 4.1%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/103721#issuecomment-1296185580).

ci: Bring back ninja for dist builders [#103295](https://github.com/rust-lang/rust/pull/103295) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fab0432952b24df769459d4c973dbb8d08561a83&end=5ab74459b86465e751fc8f6fa9934687423ce2a6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.5%  | [0.2%, 7.2%]   | 22    |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.2%, 6.5%]   | 68    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.0%, -1.0%] | 1     |
| All ❌✅ (primary)                 | 1.5%  | [0.2%, 7.2%]   | 22    |
- Currently unclear why this would cause regressions, but it seems real.
- A PR reverting this one was filed and [improvements in performance were clear](https://github.com/rust-lang/rust/pull/103846#issuecomment-1299483877).
- A [call to revert has been made](https://github.com/rust-lang/rust/pull/103295#issuecomment-1300333035).

Don't use usub.with.overflow intrinsic [#103299](https://github.com/rust-lang/rust/pull/103299) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5ab74459b86465e751fc8f6fa9934687423ce2a6&end=f42b6fa7cad0d221b0c5407dca70b085784b1b5e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 3.6% | [3.2%, 4.1%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/103299#issuecomment-1296371614).

Include both benchmarks and tests in the numbers given to `TeFiltered{,Out}` [#103795](https://github.com/rust-lang/rust/pull/103795) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2afca78a0b03db144c5d8b9f8868feebfe096309&end=95a3a7277b44bbd2dd3485703d9a05f64652b60e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 3.6% | [3.2%, 4.1%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.3% | [1.2%, 1.4%] | 2     |
- This is very likely noise as [described here](https://github.com/rust-lang/rust/pull/103795#issuecomment-1298008230).

(almost) Always use `ObligationCtxt` when dealing with canonical queries [#103590](https://github.com/rust-lang/rust/pull/103590) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c493bae0d8efd75723460ce5c371f726efa93f15&end=e70cbef0c5db81079f4b5643380d6047ccd34a10&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 2.2% | [1.6%, 2.9%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- This could be noise, but it might not be - either way it's too small of a regression to worry about [as discussed here](https://github.com/rust-lang/rust/pull/103590#issuecomment-1299184031).

Track where diagnostics were created. [#103217](https://github.com/rust-lang/rust/pull/103217) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ab5a2bc7316012ee9b2a4a4f3821673f2677f3d5&end=11ebe6512b4c77633c59f8dcdd421df3b79d1a9f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 2.2% | [1.6%, 2.8%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- The likelihood that this is noise is pretty high as you can see from the end of [this graph](https://perf.rust-lang.org/index.html?start=2022-10-29&end=11ebe6512b4c77633c59f8dcdd421df3b79d1a9f&benchmark=deeply-nested-multi&profile=check&scenario=full&stat=instructions%3Au&kind=percentrelative).

#### Improvements

Revert "Unify tcx.constness and param env constness checks" [#103284](https://github.com/rust-lang/rust/pull/103284) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=629a414d7ba4caa3ca28b0a46c478e2ecb4c0059&end=43dd3d514b6b11c5195de2fd8e665828801d0972&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.0%, -0.2%] | 43    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.7%, -0.1%] | 36    |
| All ❌✅ (primary)                 | -0.4% | [-1.0%, -0.2%] | 43    |


privacy: Rename "accessibility levels" to "effective visibilities" [#102233](https://github.com/rust-lang/rust/pull/102233) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7174231ae66aa3e938cbe0b84e23e79d867fec20&end=33b55ac39fa633d0983fad014469e1036669bf28&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-4.0%, -0.4%] | 12    |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |


Do not consider repeated lifetime params for elision. [#103450](https://github.com/rust-lang/rust/pull/103450) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=68c836a904e5a421712db311421c5266f9ce71c0&end=5e9772042948002f9c6f60c4c81603170035fffa&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.4%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -1.9% | [-4.0%, -0.4%] | 13    |
| All ❌✅ (primary)                 | -0.9% | [-1.4%, -0.2%] | 3     |


Rollup of 8 pull requests [#103745](https://github.com/rust-lang/rust/pull/103745) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=15ee24a2fab6a29dd2235d7c4e383c9011f5900f&end=4827ceecb9ee9bc0508fecf7059bcc134ca187d0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-4.0%, -0.5%] | 12    |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |


Rollup of 5 pull requests [#103755](https://github.com/rust-lang/rust/pull/103755) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b03502b35d111bef0399a66ab3cc765f0802e8ba&end=e96c330af5e3baebe7a80999744e2e082b279d0a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.5% | [-4.0%, -3.1%] | 6     |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |


rustdoc: Simplify modifications of effective visibility table [#103010](https://github.com/rust-lang/rust/pull/103010) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e96c330af5e3baebe7a80999744e2e082b279d0a&end=fab0432952b24df769459d4c973dbb8d08561a83&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.3%, -0.3%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.5%, -0.3%] | 21    |
| All ❌✅ (primary)                 | -0.6% | [-1.3%, -0.3%] | 21    |


Update LLVM submodule [#103479](https://github.com/rust-lang/rust/pull/103479) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f42b6fa7cad0d221b0c5407dca70b085784b1b5e&end=77e57db384aca99444c3b5f6a9c86bc58a804d89&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.4% | [-3.9%, -3.1%] | 6     |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |


Use `br` instead of `switch` in more cases. [#103331](https://github.com/rust-lang/rust/pull/103331) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=77e57db384aca99444c3b5f6a9c86bc58a804d89&end=d726c8467c06088d5d4488edf6b015ec9698c1ea&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.0% | [-4.6%, -0.4%] | 34    |
| Improvements ✅ <br /> (secondary) | -2.2% | [-3.3%, -1.0%] | 12    |
| All ❌✅ (primary)                 | -2.0% | [-4.6%, -0.4%] | 34    |


Enable `x.py check` for miri [#102950](https://github.com/rust-lang/rust/pull/102950) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=95a3a7277b44bbd2dd3485703d9a05f64652b60e&end=024207ab43aceb49f2ca957509c503ccf12089d7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.5% | [-4.0%, -3.1%] | 6     |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |


#### Mixed

Remove allow(rustc::potential_query_instability) in rustc_const_eval [#102674](https://github.com/rust-lang/rust/pull/102674) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a9ef10019fd3be6e03afb4b213368f4af1917f9b&end=5237c4d83db0a04a0119918b174ee642acd82d9c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.3%, 0.8%]   | 18    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.4%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -2.7% | [-3.9%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.5% | [-1.4%, 0.4%]  | 6     |
- A mix of noise and some accetpable regressions [as described here](https://github.com/rust-lang/rust/pull/102674#issuecomment-1296373084).

Rollup of 7 pull requests [#103714](https://github.com/rust-lang/rust/pull/103714) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=607878d069267e1402ad792c9331b426e4c6d0f9&end=33b530e04099465a8029ef581202d52f4075558e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.4%, 0.7%]   | 5     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.9% | [-4.0%, -0.4%] | 12    |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |
- A mix of noise and some accetpable regressions [as described here](https://github.com/rust-lang/rust/pull/103714#issuecomment-1300409938).


Rollup of 10 pull requests [#103829](https://github.com/rust-lang/rust/pull/103829) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=024207ab43aceb49f2ca957509c503ccf12089d7&end=dc05f60c1ff4e2cb2e6eb80c9b3afa612ce28c7f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [1.2%, 1.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 3.6%  | [3.2%, 4.1%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.0%, -0.2%] | 13    |
| All ❌✅ (primary)                 | 1.3%  | [1.2%, 1.4%]   | 2     |
- A mix of noise and some accetpable regressions [as described here](https://github.com/rust-lang/rust/pull/103829#issuecomment-1298313603).


Rollup of 6 pull requests [#103832](https://github.com/rust-lang/rust/pull/103832) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dc05f60c1ff4e2cb2e6eb80c9b3afa612ce28c7f&end=c493bae0d8efd75723460ce5c371f726efa93f15&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [0.4%, 2.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.3%, 0.9%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.9% | [-3.9%, -0.3%] | 14    |
| All ❌✅ (primary)                 | 0.0%  | [-1.4%, 2.2%]  | 4     |
- A mix of noise and some accetpable regressions [as described here](https://github.com/rust-lang/rust/pull/103832#issuecomment-1299188855).


Rollup of 5 pull requests [#103841](https://github.com/rust-lang/rust/pull/103841) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4c736a21ae317086871094b1671d6535be593502&end=ab5a2bc7316012ee9b2a4a4f3821673f2677f3d5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.6%]   | 8     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.1% | [-2.8%, -1.7%] | 7     |
| All ❌✅ (primary)                 | 0.5%  | [0.4%, 0.6%]   | 8     |
- Seems like [#103760](https://github.com/rust-lang/rust/commit/e418a044dfe47ef6422a4b0bbc28279af757add2) is the culprit.
