% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dup.R
\name{str_dup}
\alias{str_dup}
\title{Duplicate a string}
\usage{
str_dup(string, times, sep = NULL)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{times}{Number of times to duplicate each string.}

\item{sep}{String to insert between each duplicate.}
}
\value{
A character vector the same length as \code{string}/\code{times}.
}
\description{
\code{str_dup()} duplicates the characters within a string, e.g.
\code{str_dup("xy", 3)} returns \code{"xyxyxy"}.
}
\examples{
fruit <- c("apple", "pear", "banana")
str_dup(fruit, 2)
str_dup(fruit, 2, sep = " ")
str_dup(fruit, 1:3)
str_c("ba", str_dup("na", 0:5))
}
