% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commands.R
\name{registerCommandCallback}
\alias{registerCommandCallback}
\title{Register Command Callback}
\usage{
registerCommandCallback(commandId, callback)
}
\arguments{
\item{commandId}{The ID of the command to listen for.}

\item{callback}{A function to execute when the command is invoked.}
}
\value{
A handle representing the registration. Pass this handle
to \code{\link{unregisterCommandCallback}} to unregister the callback.
}
\description{
Registers a callback to be executed when an RStudio command is invoked.
}
\details{
RStudio commands can be invoked from menus, toolbars, keyboard shortcuts,
and the Command Palette, as well as the RStudio API. The callback will
be executed whenever the command is invoked, regardless of how the
invocation was triggered.

See the RStudio Server Professional Administration Guide appendix for a list
of supported command IDs.

The callback is executed \emph{after} the command has been run, but as
some commands initiate asynchronous processes, there is no guarantee that
the command has finished its work when the callback is invoked.

If you're having trouble figuring out the ID of a command you want to listen
for, it can be helpful to discover it by listening to the full command stream;
see the example in \code{\link{registerCommandStreamCallback}} for details.

Note that no error will be raised if you use a command ID that does not exist.
}
\note{
The \code{registerCommandCallback} function was introduced in RStudio 1.4.1589.
}
\examples{

\dontrun{
# Set up a callback to display an encouraging dialog whenever 
# the user knits a document
handle <- rstudioapi::registerCommandCallback(
  "knitDocument", 
  function() {
    rstudioapi::showDialog(
      "Achievement",
      "Congratulations, you have knitted a document. Well done."
    )
  })

# Knit the document interactively and observe the dialog

# Later: Unregister the callback
rstudioapi::unregisterCommandCallback(handle)
}

}
\seealso{
\code{\link{unregisterCommandCallback}} to unregister the callback, and
\code{\link{registerCommandStreamCallback}} to be notified whenever \emph{any} command
is executed.
}
