# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessKeysAuthentication(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property can be Enabled/Disabled to allow or deny access with the current access keys. Can
    be updated even after database is created.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class AccessKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Which access key to regenerate."""

    PRIMARY = "Primary"
    SECONDARY = "Secondary"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AofFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sets the frequency at which data is written to disk. Defaults to '1s', meaning 'every second'.
    Note that the 'always' setting is deprecated, because of its performance impact.
    """

    ONE_S = "1s"
    ALWAYS = "always"


class ClusteringPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Clustering policy - default is OSSCluster. This property can be updated only if the current
    value is NoCluster. If the value is OSSCluster or EnterpriseCluster, it cannot be updated
    without deleting the database.
    """

    ENTERPRISE_CLUSTER = "EnterpriseCluster"
    """Enterprise clustering policy uses only the classic redis protocol, which does not support redis
    cluster commands."""
    OSS_CLUSTER = "OSSCluster"
    """OSS clustering policy follows the redis cluster specification, and requires all clients to
    support redis clustering."""
    NO_CLUSTER = "NoCluster"
    """The NoCluster policy is used for non-clustered Redis instances that do not require clustering
    features."""


class CmkIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Only userAssignedIdentity is supported in this API version; other types may be supported in the
    future.
    """

    SYSTEM_ASSIGNED_IDENTITY = "systemAssignedIdentity"
    USER_ASSIGNED_IDENTITY = "userAssignedIdentity"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DeferUpgradeSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Option to defer upgrade when newest version is released - default is NotDeferred. Learn more:
    https://aka.ms/redisversionupgrade.
    """

    DEFERRED = "Deferred"
    NOT_DEFERRED = "NotDeferred"


class EvictionPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Redis eviction policy - default is VolatileLRU."""

    ALL_KEYS_LFU = "AllKeysLFU"
    ALL_KEYS_LRU = "AllKeysLRU"
    ALL_KEYS_RANDOM = "AllKeysRandom"
    VOLATILE_LRU = "VolatileLRU"
    VOLATILE_LFU = "VolatileLFU"
    VOLATILE_TTL = "VolatileTTL"
    VOLATILE_RANDOM = "VolatileRandom"
    NO_EVICTION = "NoEviction"


class HighAvailability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enabled by default. If highAvailability is disabled, the data set is not replicated. This
    affects the availability SLA, and increases the risk of data loss.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Distinguishes the kind of cluster. Read-only."""

    V1 = "v1"
    V2 = "v2"


class LinkState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the link between the database resources."""

    LINKED = "Linked"
    LINKING = "Linking"
    UNLINKING = "Unlinking"
    LINK_FAILED = "LinkFailed"
    UNLINK_FAILED = "UnlinkFailed"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols.
    Default is TLS-encrypted.
    """

    ENCRYPTED = "Encrypted"
    PLAINTEXT = "Plaintext"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current provisioning status."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"


class RdbFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sets the frequency at which a snapshot of the database is created."""

    ONE_H = "1h"
    SIX_H = "6h"
    TWELVE_H = "12h"


class RedundancyMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Explains the current redundancy strategy of the cluster, which affects the expected SLA."""

    NONE = "None"
    """No redundancy. Availability loss will occur."""
    LR = "LR"
    """Local redundancy with high availability."""
    ZR = "ZR"
    """Zone redundant. Higher availability."""


class ResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current resource status."""

    RUNNING = "Running"
    CREATING = "Creating"
    CREATE_FAILED = "CreateFailed"
    UPDATING = "Updating"
    UPDATE_FAILED = "UpdateFailed"
    DELETING = "Deleting"
    DELETE_FAILED = "DeleteFailed"
    ENABLING = "Enabling"
    ENABLE_FAILED = "EnableFailed"
    DISABLING = "Disabling"
    DISABLE_FAILED = "DisableFailed"
    DISABLED = "Disabled"
    SCALING = "Scaling"
    SCALING_FAILED = "ScalingFailed"
    MOVING = "Moving"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The level of Redis Enterprise cluster to deploy. Possible values: ('Balanced_B5',
    'MemoryOptimized_M10', 'ComputeOptimized_X5', etc.). For more information on SKUs see the
    latest pricing documentation. Note that additional SKUs may become supported in the future.
    """

    ENTERPRISE_E1 = "Enterprise_E1"
    ENTERPRISE_E5 = "Enterprise_E5"
    ENTERPRISE_E10 = "Enterprise_E10"
    ENTERPRISE_E20 = "Enterprise_E20"
    ENTERPRISE_E50 = "Enterprise_E50"
    ENTERPRISE_E100 = "Enterprise_E100"
    ENTERPRISE_E200 = "Enterprise_E200"
    ENTERPRISE_E400 = "Enterprise_E400"
    ENTERPRISE_FLASH_F300 = "EnterpriseFlash_F300"
    ENTERPRISE_FLASH_F700 = "EnterpriseFlash_F700"
    ENTERPRISE_FLASH_F1500 = "EnterpriseFlash_F1500"
    BALANCED_B0 = "Balanced_B0"
    BALANCED_B1 = "Balanced_B1"
    BALANCED_B3 = "Balanced_B3"
    BALANCED_B5 = "Balanced_B5"
    BALANCED_B10 = "Balanced_B10"
    BALANCED_B20 = "Balanced_B20"
    BALANCED_B50 = "Balanced_B50"
    BALANCED_B100 = "Balanced_B100"
    BALANCED_B150 = "Balanced_B150"
    BALANCED_B250 = "Balanced_B250"
    BALANCED_B350 = "Balanced_B350"
    BALANCED_B500 = "Balanced_B500"
    BALANCED_B700 = "Balanced_B700"
    BALANCED_B1000 = "Balanced_B1000"
    MEMORY_OPTIMIZED_M10 = "MemoryOptimized_M10"
    MEMORY_OPTIMIZED_M20 = "MemoryOptimized_M20"
    MEMORY_OPTIMIZED_M50 = "MemoryOptimized_M50"
    MEMORY_OPTIMIZED_M100 = "MemoryOptimized_M100"
    MEMORY_OPTIMIZED_M150 = "MemoryOptimized_M150"
    MEMORY_OPTIMIZED_M250 = "MemoryOptimized_M250"
    MEMORY_OPTIMIZED_M350 = "MemoryOptimized_M350"
    MEMORY_OPTIMIZED_M500 = "MemoryOptimized_M500"
    MEMORY_OPTIMIZED_M700 = "MemoryOptimized_M700"
    MEMORY_OPTIMIZED_M1000 = "MemoryOptimized_M1000"
    MEMORY_OPTIMIZED_M1500 = "MemoryOptimized_M1500"
    MEMORY_OPTIMIZED_M2000 = "MemoryOptimized_M2000"
    COMPUTE_OPTIMIZED_X3 = "ComputeOptimized_X3"
    COMPUTE_OPTIMIZED_X5 = "ComputeOptimized_X5"
    COMPUTE_OPTIMIZED_X10 = "ComputeOptimized_X10"
    COMPUTE_OPTIMIZED_X20 = "ComputeOptimized_X20"
    COMPUTE_OPTIMIZED_X50 = "ComputeOptimized_X50"
    COMPUTE_OPTIMIZED_X100 = "ComputeOptimized_X100"
    COMPUTE_OPTIMIZED_X150 = "ComputeOptimized_X150"
    COMPUTE_OPTIMIZED_X250 = "ComputeOptimized_X250"
    COMPUTE_OPTIMIZED_X350 = "ComputeOptimized_X350"
    COMPUTE_OPTIMIZED_X500 = "ComputeOptimized_X500"
    COMPUTE_OPTIMIZED_X700 = "ComputeOptimized_X700"
    FLASH_OPTIMIZED_A250 = "FlashOptimized_A250"
    FLASH_OPTIMIZED_A500 = "FlashOptimized_A500"
    FLASH_OPTIMIZED_A700 = "FlashOptimized_A700"
    FLASH_OPTIMIZED_A1000 = "FlashOptimized_A1000"
    FLASH_OPTIMIZED_A1500 = "FlashOptimized_A1500"
    FLASH_OPTIMIZED_A2000 = "FlashOptimized_A2000"
    FLASH_OPTIMIZED_A4500 = "FlashOptimized_A4500"


class TlsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The minimum TLS version for the cluster to support, e.g. '1.2'. Newer versions can be added in
    the future. Note that TLS 1.0 and TLS 1.1 are now completely obsolete -- you cannot use them.
    They are mentioned only for the sake of consistency with old API versions.
    """

    ONE0 = "1.0"
    ONE1 = "1.1"
    ONE2 = "1.2"
