"""
Rauch, H. and Waschkowski, W. (2003) Neutron Scattering Lengths in ILL Neutron Data Booklet (second edition),
A.-J. Dianoux, G. Lander, Eds. Old City Publishing, Philidelphia, PA. pp 1.1-1 to 1.1-17.
(https://www.ill.eu/fileadmin/user_upload/ILL/1_About_ILL/Documentation/NeutronDataBooklet.pdf)
Imported from python periodictable package
"""

# flake8: noqa
# fmt: off
NEUTRON_SCATTERING_LENGTHS = {
    'n':       (-37+0j),
    (0, 1):    (-37+0j),
    'H':       (-3.7409-9.2491656376e-05j),
    (1, 1):    (-3.7423-9.2491656376e-05j),
    (1, 2):    (6.674-1.4432702844e-07j),
    'He':      (3.26-2.0773080971999998e-06j),
    (2, 3):    (5.74-1.48303669108j),
    (2, 4):    (3.26+0j),
    'Li':      (-1.9-0.019605116579999998j),
    (3, 6):    (2-0.26140155439999996j),
    (3, 7):    (-2.22-1.2625138904e-05j),
    'Be':      (7.79-2.1134593759999998e-06j),
    (4, 9):    (7.79-2.1134593759999998e-06j),
    'B':       (5.3-0.21329254492j),
    (5, 10):   (-0.2-1.0664627246j),
    (5, 11):   (6.65-1.5294771799999997e-06j),
    'C':       (6.6484-9.7330366e-07j),
    (6, 12):   (6.6535-9.816462628e-07j),
    (6, 13):   (6.19-3.8097886119999995e-07j),
    'N':       (9.36-0.0005283648439999999j),
    (7, 14):   (9.37-0.0005311457116j),
    (7, 15):   (6.44-6.67408224e-09j),
    'O':       (5.805-5.28364844e-08j),
    (8, 16):   (5.805-2.7808676e-08j),
    (8, 17):   (5.6-6.562847536e-05j),
    (8, 18):   (5.84-4.44938816e-08j),
    'F':       (5.654-2.6696328959999997e-06j),
    (9, 19):   (5.654-2.6696328959999997e-06j),
    'Ne':      (4.566-1.0845383639999999e-05j),
    (10, 20):  (4.631-1.0011123359999998e-05j),
    (10, 21):  (6.66-0.0001863181292j),
    (10, 22):  (3.87-1.2791990959999998e-05j),
    'Na':      (3.63-0.0001473859828j),
    (11, 23):  (3.63-0.0001473859828j),
    'Mg':      (5.375-1.751946588e-05j),
    (12, 24):  (5.49-1.3904337999999999e-05j),
    (12, 25):  (3.62-5.28364844e-05j),
    (12, 26):  (4.89-1.0622914231999998e-05j),
    'Al':      (3.449-6.423804155999999e-05j),
    (13, 27):  (3.449-6.423804155999999e-05j),
    'Si':      (4.15071-4.755283596e-05j),
    (14, 28):  (4.106-4.922135651999999e-05j),
    (14, 29):  (4.7-2.808676276e-05j),
    (14, 30):  (4.58-2.9755283319999997e-05j),
    'P':       (5.13-4.783092271999999e-05j),
    (15, 31):  (5.13-4.783092271999999e-05j),
    'S':       (2.847-0.0001473859828j),
    (16, 32):  (2.804-0.0001501668504j),
    (16, 33):  (4.74-0.0001501668504j),
    (16, 34):  (3.48-6.312569452e-05j),
    (16, 36):  (3-4.1713014e-05j),
    'Cl':      (9.5792-0.009315906459999999j),
    (17, 35):  (11.7-0.012263626116j),
    (17, 37):  (3.08-0.00012041156707999999j),
    'Ar':      (1.909-0.000187708563j),
    (18, 36):  (24.9-0.0014460511519999999j),
    (18, 38):  (3.5-0.00022246940799999998j),
    (18, 40):  (1.7-0.0001835372616j),
    'K':       (3.67-0.000583982196j),
    (19, 39):  (3.79-0.000583982196j),
    (19, 40):  (3.1-0.0097330366j),
    (19, 41):  (2.69-0.00040600666959999995j),
    'Ca':      (4.7-0.0001195773068j),
    (20, 40):  (4.78-0.00011401557159999998j),
    (20, 42):  (3.36-0.0001890989968j),
    (20, 43):  (-1.56-0.001724137912j),
    (20, 44):  (1.42-0.00024471634879999997j),
    (20, 46):  (3.55-0.00020578420239999998j),
    (20, 48):  (0.39-0.0003031145684j),
    'Sc':      (12.1-0.0076473858999999995j),
    (21, 45):  (12.1-0.0076473858999999995j),
    'Ti':      (-3.37-0.0016935483683999998j),
    (22, 46):  (4.72-0.00016407118839999998j),
    (22, 47):  (3.53-0.00047274749199999996j),
    (22, 48):  (-5.86-0.0021802001983999997j),
    (22, 49):  (0.98-0.000611790872j),
    (22, 50):  (5.88-4.977753004e-05j),
    'V':       (-0.443-0.0014126807407999998j),
    (23, 50):  (7.6-0.0166852056j),
    (23, 51):  (-0.402-0.001362625124j),
    'Cr':      (3.635-0.0008481646179999999j),
    (24, 50):  (-4.5-0.004393770808j),
    (24, 52):  (4.914-0.0002113459376j),
    (24, 53):  (-4.2-0.005033370356j),
    (24, 54):  (4.55-0.00010011123359999998j),
    'Mn':      (-3.75-0.003698553908j),
    (25, 55):  (-3.75-0.003698553908j),
    'Fe':      (9.45-0.0007119021055999999j),
    (26, 54):  (4.2-0.0006256952099999999j),
    (26, 56):  (10.1-0.0007202447083999999j),
    (26, 57):  (2.3-0.0006896551648j),
    (26, 58):  (15-0.00035595105279999996j),
    'Co':      (2.49-0.0103392657368j),
    (27, 59):  (2.49-0.0103392657368j),
    'Ni':      (10.3-0.0012486095524j),
    (28, 58):  (14.4-0.0012791990959999998j),
    (28, 60):  (2.8-0.0008064516039999999j),
    (28, 61):  (7.6-0.0006952168999999999j),
    (28, 62):  (-8.7-0.004032258019999999j),
    (28, 64):  (-0.37-0.0004226918752j),
    'Cu':      (7.718-0.0010511679528j),
    (29, 63):  (6.477-0.0012513904199999999j),
    (29, 65):  (10.204-0.0006034482691999999j),
    'Zn':      (5.68-0.0003086763036j),
    (30, 64):  (5.23-0.0002586206868j),
    (30, 66):  (5.98-0.0001724137912j),
    (30, 67):  (7.58-0.0018909899679999999j),
    (30, 68):  (6.04-0.000305895436j),
    (30, 70):  (6.9-2.5583981919999996e-05j),
    'Ga':      (7.288-0.00076473859j),
    (31, 69):  (8.043-0.0006062291368j),
    (31, 71):  (6.17-0.0010038932036j),
    'Ge':      (8.185-0.000611790872j),
    (32, 70):  (10-0.0008342602799999999j),
    (32, 72):  (8.51-0.00022246940799999998j),
    (32, 73):  (5.02-0.0041991100759999995j),
    (32, 74):  (7.58-0.00011123470399999999j),
    (32, 76):  (8.2-4.4493881599999995e-05j),
    'As':      (6.58-0.0012513904199999999j),
    (33, 75):  (6.58-0.0012513904199999999j),
    'Se':      (7.97-0.0032536150919999997j),
    (34, 74):  (0.8-0.014404894167999997j),
    (34, 76):  (12.2-0.023637374599999997j),
    (34, 77):  (8.25-0.01167964392j),
    (34, 78):  (8.24-0.0001195773068j),
    (34, 80):  (7.48-0.0001696329236j),
    (34, 82):  (6.34-1.2235817439999998e-05j),
    'Br':      (6.79-0.001918798644j),
    (35, 79):  (6.79-0.00305895436j),
    (35, 81):  (6.78-0.000750834252j),
    'Kr':      (7.81-0.006952168999999999j),
    (36, 86):  (8.07-8.342602799999999e-07j),
    'Rb':      (7.08-0.0001056729688j),
    (37, 85):  (7.07-0.00013348164479999998j),
    (37, 87):  (7.27-3.3370411199999995e-05j),
    'Sr':      (7.02-0.00035595105279999996j),
    (38, 84):  (5-0.0002419354812j),
    (38, 86):  (5.68-0.0002892102304j),
    (38, 87):  (7.41-0.00444938816j),
    (38, 88):  (7.16-1.612903208e-05j),
    'Y':       (7.75-0.00035595105279999996j),
    (39, 89):  (7.75-0.00035595105279999996j),
    'Zr':      (7.16-5.1446050599999995e-05j),
    (40, 90):  (6.5-3.0589543599999995e-06j),
    (40, 91):  (8.8-0.00032536150919999996j),
    (40, 92):  (7.5-6.117908719999999e-05j),
    (40, 94):  (8.3-1.3876529323999998e-05j),
    (40, 96):  (5.5-6.3681868039999994e-06j),
    'Nb':      (7.054-0.00031979977399999995j),
    (41, 93):  (7.054-0.00031979977399999995j),
    'Mo':      (6.715-0.0006896551648j),
    (42, 92):  (6.93-5.283648439999999e-06j),
    (42, 94):  (6.82-4.171301399999999e-06j),
    (42, 95):  (6.93-0.0036429365559999998j),
    (42, 96):  (6.22-0.00013904338j),
    (42, 97):  (7.26-0.0006952168999999999j),
    (42, 98):  (6.6-3.531701852e-05j),
    (42, 100): (6.75-0.00011123470399999999j),
    'Tc':      (6.8-0.005561735199999999j),
    'Ru':      (7.02-0.0007119021055999999j),
    'Rh':      (5.9-0.040266962848j),
    (45, 103): (5.9-0.040266962848j),
    'Pd':      (5.91-0.001918798644j),
    (46, 102): (7.7-0.0009454949839999999j),
    (46, 104): (7.7-0.000166852056j),
    (46, 105): (5.5-0.005561735199999999j),
    (46, 106): (6.4-8.453837503999999e-05j),
    (46, 108): (4.1-0.0023637374599999998j),
    (46, 110): (7.7-6.284760775999999e-05j),
    'Ag':      (5.922-0.017602891907999997j),
    (47, 107): (7.555-0.010456062176j),
    (47, 109): (4.165-0.025305895159999998j),
    'Cd':      (4.83-0.7007786351999999j),
    (48, 106): (5-0.00027808676j),
    (48, 108): (5.31-0.000305895436j),
    (48, 110): (5.78-0.00305895436j),
    (48, 111): (6.47-0.0066740822399999995j),
    (48, 112): (6.34-0.000611790872j),
    (48, 113): (-8-5.728587256j),
    (48, 114): (7.48-9.45494984e-05j),
    (48, 116): (6.26-2.0856507e-05j),
    'In':      (4.065-0.053893214088j),
    (49, 113): (5.39-0.0033370411199999997j),
    (49, 115): (4-0.056173525519999996j),
    'Sn':      (6.225-0.00017408231176j),
    (50, 112): (6-0.00027808676j),
    (50, 114): (6-3.170189064e-05j),
    (50, 115): (6-0.0083426028j),
    (50, 116): (6.1-3.89321464e-05j),
    (50, 117): (6.59-0.0006395995479999999j),
    (50, 118): (6.23-6.117908719999999e-05j),
    (50, 119): (6.28-0.000611790872j),
    (50, 120): (6.67-3.89321464e-05j),
    (50, 122): (5.93-5.005561679999999e-05j),
    (50, 124): (6.15-3.698553908e-05j),
    'Sb':      (5.57-0.0013654059916j),
    (51, 121): (5.71-0.00159899887j),
    (51, 123): (5.38-0.0010567296879999998j),
    'Te':      (5.68-0.001307007772j),
    (52, 120): (5.3-0.0006395995479999999j),
    (52, 122): (3.8-0.0009454949839999999j),
    (52, 123): (-0.05-0.11624026568j),
    (52, 124): (7.95-0.0018909899679999999j),
    (52, 125): (5.01-0.000431034478j),
    (52, 126): (5.55-0.0002892102304j),
    (52, 128): (5.88-5.97886534e-05j),
    (52, 130): (6.01-8.064516039999999e-05j),
    'I':       (5.28-0.001710233574j),
    (53, 127): (5.28-0.001710233574j),
    'Xe':      (4.69-0.006646273563999999j),
    'Cs':      (5.42-0.008064516039999999j),
    (55, 133): (5.42-0.008064516039999999j),
    'Ba':      (5.07-0.000305895436j),
    (56, 130): (-3.6-0.0083426028j),
    (56, 132): (7.8-0.00194660732j),
    (56, 134): (5.7-0.00055617352j),
    (56, 135): (4.66-0.0016129032079999998j),
    (56, 136): (4.9-0.0001890989968j),
    (56, 137): (6.82-0.001001112336j),
    (56, 138): (4.83-7.50834252e-05j),
    'La':      (8.24-0.0024944382372j),
    (57, 138): (8-0.01585094532j),
    (57, 139): (8.24-0.0024833147667999997j),
    'Ce':      (4.84-0.00017519465879999998j),
    (58, 136): (5.76-0.002030033348j),
    (58, 138): (6.65-0.000305895436j),
    (58, 140): (4.81-0.00015850945319999997j),
    (58, 142): (4.72-0.00026418242199999995j),
    'Pr':      (4.58-0.00319799774j),
    (59, 141): (4.58-0.00319799774j),
    'Nd':      (7.69-0.014043381379999999j),
    (60, 142): (7.7-0.005200222411999999j),
    (60, 143): (14-0.09371523811999999j),
    (60, 144): (2.8-0.001001112336j),
    (60, 145): (14-0.01167964392j),
    (60, 146): (8.7-0.00038932146399999997j),
    (60, 148): (5.7-0.0006952168999999999j),
    (60, 150): (5.28-0.000333704112j),
    'Pm':      (12.6-0.046829810384j),
    'Sm':      -1.64682979272j,
    (62, 144): (-3-0.00019466073199999999j),
    (62, 147): (14-0.01585094532j),
    (62, 148): (-3-0.000667408224j),
    (62, 149): (18.7-11.701890860799999j),
    (62, 150): (14-0.028921023039999997j),
    (62, 152): (-5-0.05728587255999999j),
    (62, 154): (8-0.002335928784j),
    'Eu':      (5.3-1.2597330227999999j),
    (63, 153): (8.22-0.08676306912j),
    'Gd':      (9.5-13.820911972j),
    (64, 152): (10-0.2043937686j),
    (64, 154): (10-0.023637374599999997j),
    (64, 155): (13.8-16.991101036j),
    (64, 156): (6.3-0.00041713013999999997j),
    (64, 157): (4-72.02447083999999j),
    (64, 158): (9-0.000611790872j),
    (64, 160): (9.15-0.0002141268052j),
    'Tb':      (7.34-0.006507230183999999j),
    (65, 159): (7.34-0.006507230183999999j),
    'Dy':      (16.9-0.27641823944j),
    (66, 156): (6.1-0.00917686308j),
    (66, 158): (6-0.011957730679999999j),
    (66, 160): (6.7-0.01557285856j),
    (66, 161): (10.3-0.166852056j),
    (66, 162): (-1.4-0.05394883144j),
    (66, 163): (5-0.034482758239999994j),
    (66, 164): (49.4-0.7897663984j),
    'Ho':      (8.44-0.017992213372j),
    (67, 165): (8.44-0.017992213372j),
    'Er':      (7.79-0.044215794839999996j),
    (68, 162): (9.01-0.005283648439999999j),
    (68, 164): (7.95-0.0036151278799999996j),
    (68, 166): (10.51-0.005450500496j),
    (68, 167): (3.06-0.18325917483999998j),
    (68, 168): (7.43-0.0007619577224j),
    (68, 170): (9.61-0.0016129032079999998j),
    'Tm':      (7.07-0.027808675999999997j),
    (69, 169): (7.07-0.027808675999999997j),
    'Yb':      (12.41-0.009677419247999999j),
    (70, 168): (-4.07-0.6201334747999999j),
    (70, 170): (6.8-0.0031701890639999997j),
    (70, 171): (9.7-0.013515016535999999j),
    (70, 172): (9.5-0.00022246940799999998j),
    (70, 173): (9.56-0.004755283596j),
    (70, 174): (19.2-0.019299221144j),
    (70, 176): (8.7-0.0007925472659999999j),
    'Lu':      (7.21-0.02057842024j),
    (71, 175): (7.28-0.00583982196j),
    (71, 176): (6.1-0.5742491594j),
    'Hf':      (7.77-0.028948831715999997j),
    (72, 174): (10.9-0.15600667236j),
    (72, 176): (6.61-0.006535038859999999j),
    (72, 177): (0.8-0.10372636147999999j),
    (72, 178): (5.9-0.02335928784j),
    (72, 179): (7.46-0.011401557159999999j),
    (72, 180): (13.2-0.0036262513503999994j),
    'Ta':      (6.91-0.005728587256j),
    (73, 180): (7-0.15656284588j),
    (73, 181): (6.91-0.0057007785799999995j),
    'W':       (4.755-0.0050889877079999995j),
    (74, 180): (5-0.0083426028j),
    (74, 182): (7.04-0.005756395931999999j),
    (74, 183): (6.59-0.0028086762759999997j),
    (74, 184): (7.55-0.00047274749199999996j),
    (74, 186): (-0.73-0.010539488203999999j),
    'Re':      (9.2-0.024944382371999998j),
    (75, 185): (9-0.03114571712j),
    (75, 187): (9.3-0.021245828464j),
    'Os':      (10.7-0.00444938816j),
    (76, 184): (10-0.83426028j),
    (76, 186): (12-0.022246940799999997j),
    (76, 187): (10-0.08898776319999999j),
    (76, 188): (7.8-0.001307007772j),
    (76, 189): (11-0.006952168999999999j),
    (76, 190): (11.4-0.0036429365559999998j),
    (76, 192): (11.9-0.00055617352j),
    'Ir':      (10.6-0.118186873j),
    'Pt':      (9.6-0.002864293628j),
    (78, 190): (9-0.042269187519999994j),
    (78, 192): (9.9-0.0027808675999999996j),
    (78, 194): (10.55-0.00040044493439999994j),
    (78, 195): (8.91-0.0076473858999999995j),
    (78, 196): (9.89-0.00020022246719999997j),
    (78, 198): (7.8-0.0010177975416j),
    'Au':      (7.9-0.027433258874j),
    (79, 197): (7.9-0.027433258874j),
    'Hg':      (12.595-0.103531700748j),
    (80, 196): (30.3-0.8565072208j),
    (80, 199): (16.9-0.5978865339999999j),
    (80, 202): (11.002-0.0013598442563999998j),
    'Tl':      (8.776-0.0009538375868j),
    (81, 203): (8.51-0.0031701890639999997j),
    (81, 205): (8.87-2.8921023039999995e-05j),
    'Pb':      (9.401-4.755283596e-05j),
    (82, 204): (10.893-0.00018075639399999999j),
    (82, 206): (9.221-8.342602799999999e-06j),
    (82, 207): (9.286-0.00019438264523999996j),
    (82, 208): (9.494-1.334816448e-07j),
    'Bi':      (8.532-9.399332487999998e-06j),
    (83, 209): (8.532-9.399332487999998e-06j),
    'Ra':      (10-0.0035595105279999997j),
    'Th':      (10.31-0.0020494994212j),
    (90, 232): (10.31-0.0020494994212j),
    'Pa':      (9.1-0.05578420405599999j),
    (91, 231): (9.1-0.05578420405599999j),
    'U':       (8.417-0.0021051167732j),
    (92, 234): (12.4-0.027836484675999997j),
    (92, 235): (10.5-0.18934927488399997j),
    (92, 238): (8.407-0.0007452725168j),
    'Np':      (10.55-0.048915461083999995j),
    'Pu':      (7.7-0.28289766094799995j),
    'Am':      (8.3-0.020939933028j),
    'Cm':      (9.5-0.004505005511999999j)
    }
