/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

#include "test.h"
#include <agent.h>

#define REDIRECT_BUF f = freopen("/dev/null", "a", stderr); assert(f); setbuf(stderr, buf);
#define REDIRECT_OUT setbuf(stderr, NULL);

int main(void)
{
	char name[] = PACKAGE_NAME " version";
	char buf[BUFSIZ];
	state_t state = {
		.verb = VERB_VERSION,
	};
	FILE *f;
	int rc;

	test_name(name);

	memset(buf, 0, sizeof buf);
	REDIRECT_BUF
	rc = agent_run(&state);
	REDIRECT_OUT
	test_assert(rc == 0, "agent_run() returned %i", rc);

	char expected[] = PACKAGE_NAME " " PACKAGE_VERSION "\n";
	test_expect(expected, buf);

	return test_status;
}
