/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2024-2025 Brett Sheffield <bacs@librecast.net> */

#ifndef _AGENT_H
#define _AGENT_H

#include <config.h>
#include <state.h>
#include <key.h>
#include <librecast/crypto.h>
#include <librecast/net.h>
#include <time.h>

#define AGENT_ERR_ISRUNNING "%s already running (pid: %i)"
#define AGENT_ERR_NOACTION "command requires an action"
#define AGENT_ERR_NOCHANNEL "command requires a channel"
#define AGENT_ERR_NOSUCHCHANNEL "channel '%s' is not defined in rcfile"
#define AGENT_ERR_NOKEY "command requires key"

/* fallback to CLOCK_REALTIME on non-Linux */
#ifndef CLOCK_TAI
#define CLOCK_TAI CLOCK_REALTIME
#endif

enum {
	AGENT_EOF = 1,
};

typedef struct agent_datahead_s {
	uint8_t  flags;
	uint64_t ts;
} __attribute__((__packed__)) agent_datahead_t;

extern int lineno;

int agent_run(state_t *state);

int agent_load_config(state_t *state, int argc, char *argv[], char *home);

int agent(state_t *state, int argc, char *argv[]);

#endif /* _AGENT_H */
