
/*** DO NOT EDIT THIS FILE DIRECTLY (use 'headers' to generate) ***/

#ifndef hypre_STRUCT_LS_HEADER
#define hypre_STRUCT_LS_HEADER

#include "_hypre_utilities.h"
#include "HYPRE_struct_ls.h"
#include "_hypre_struct_mv.h"
#include "_hypre_krylov.h"

#include "_hypre_lobpcg_temp_multivector.h"
 /* ... needed to make sense of functions in HYPRE_parcsr_int.c */

#ifdef HYPRE_MIXED_PRECISION
#include "_hypre_struct_ls_mup_def.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/

/* cyclic_reduction.c */
void *hypre_CyclicReductionCreate ( MPI_Comm comm );
hypre_StructMatrix *hypre_CycRedCreateCoarseOp ( hypre_StructMatrix *A,
                                                 hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
HYPRE_Int hypre_CycRedSetupCoarseOp ( hypre_StructMatrix *A, hypre_StructMatrix *Ac,
                                      hypre_Index cindex, hypre_Index cstride, HYPRE_Int cdir );
HYPRE_Int hypre_CyclicReductionSetup ( void *cyc_red_vdata, hypre_StructMatrix *A,
                                       hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int hypre_CyclicReduction ( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                                  hypre_StructVector *x );
HYPRE_Int hypre_CyclicReductionSetCDir ( void *cyc_red_vdata, HYPRE_Int cdir );
HYPRE_Int hypre_CyclicReductionSetBase ( void *cyc_red_vdata, hypre_Index base_index,
                                         hypre_Index base_stride );
HYPRE_Int hypre_CyclicReductionDestroy ( void *cyc_red_vdata );

/* hybrid.c */
void *hypre_HybridCreate ( MPI_Comm comm );
HYPRE_Int hypre_HybridDestroy ( void *hybrid_vdata );
HYPRE_Int hypre_HybridSetTol ( void *hybrid_vdata, HYPRE_Real tol );
HYPRE_Int hypre_HybridSetConvergenceTol ( void *hybrid_vdata, HYPRE_Real cf_tol );
HYPRE_Int hypre_HybridSetDSCGMaxIter ( void *hybrid_vdata, HYPRE_Int dscg_max_its );
HYPRE_Int hypre_HybridSetPCGMaxIter ( void *hybrid_vdata, HYPRE_Int pcg_max_its );
HYPRE_Int hypre_HybridSetPCGAbsoluteTolFactor ( void *hybrid_vdata, HYPRE_Real pcg_atolf );
HYPRE_Int hypre_HybridSetTwoNorm ( void *hybrid_vdata, HYPRE_Int two_norm );
HYPRE_Int hypre_HybridSetStopCrit ( void *hybrid_vdata, HYPRE_Int stop_crit );
HYPRE_Int hypre_HybridSetRelChange ( void *hybrid_vdata, HYPRE_Int rel_change );
HYPRE_Int hypre_HybridSetSolverType ( void *hybrid_vdata, HYPRE_Int solver_type );
HYPRE_Int hypre_HybridSetRecomputeResidual( void *hybrid_vdata, HYPRE_Int recompute_residual );
HYPRE_Int hypre_HybridGetRecomputeResidual( void *hybrid_vdata, HYPRE_Int *recompute_residual );
HYPRE_Int hypre_HybridSetRecomputeResidualP( void *hybrid_vdata, HYPRE_Int recompute_residual_p );
HYPRE_Int hypre_HybridGetRecomputeResidualP( void *hybrid_vdata, HYPRE_Int *recompute_residual_p );
HYPRE_Int hypre_HybridSetKDim ( void *hybrid_vdata, HYPRE_Int k_dim );
HYPRE_Int hypre_HybridSetPrecond ( void *pcg_vdata, HYPRE_Int (*pcg_precond_solve )(void*, void*,
                                                                                    void*, void*), HYPRE_Int (*pcg_precond_setup )(void*, void*, void*, void*), void *pcg_precond );
HYPRE_Int hypre_HybridSetLogging ( void *hybrid_vdata, HYPRE_Int logging );
HYPRE_Int hypre_HybridSetPrintLevel ( void *hybrid_vdata, HYPRE_Int print_level );
HYPRE_Int hypre_HybridGetNumIterations ( void *hybrid_vdata, HYPRE_Int *num_its );
HYPRE_Int hypre_HybridGetDSCGNumIterations ( void *hybrid_vdata, HYPRE_Int *dscg_num_its );
HYPRE_Int hypre_HybridGetPCGNumIterations ( void *hybrid_vdata, HYPRE_Int *pcg_num_its );
HYPRE_Int hypre_HybridGetFinalRelativeResidualNorm ( void *hybrid_vdata,
                                                     HYPRE_Real *final_rel_res_norm );
HYPRE_Int hypre_HybridSetup ( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                              hypre_StructVector *x );
HYPRE_Int hypre_HybridSolve ( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                              hypre_StructVector *x );

/* diag_scale.c */
HYPRE_Int hypre_StructDiagScale( hypre_StructMatrix *A, hypre_StructVector *y,
                                 hypre_StructVector *x );

/* jacobi.c */
void *hypre_StructJacobiCreate ( MPI_Comm comm );
HYPRE_Int hypre_StructJacobiDestroy ( void *jacobi_vdata );
HYPRE_Int hypre_StructJacobiSetup ( void *jacobi_vdata, hypre_StructMatrix *A,
                                    hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int hypre_StructJacobiSolve ( void *jacobi_vdata, hypre_StructMatrix *A,
                                    hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int hypre_StructJacobiSetTol ( void *jacobi_vdata, HYPRE_Real tol );
HYPRE_Int hypre_StructJacobiGetTol ( void *jacobi_vdata, HYPRE_Real *tol );
HYPRE_Int hypre_StructJacobiSetMaxIter ( void *jacobi_vdata, HYPRE_Int max_iter );
HYPRE_Int hypre_StructJacobiGetMaxIter ( void *jacobi_vdata, HYPRE_Int *max_iter );
HYPRE_Int hypre_StructJacobiSetZeroGuess ( void *jacobi_vdata, HYPRE_Int zero_guess );
HYPRE_Int hypre_StructJacobiGetZeroGuess ( void *jacobi_vdata, HYPRE_Int *zero_guess );
HYPRE_Int hypre_StructJacobiGetNumIterations ( void *jacobi_vdata, HYPRE_Int *num_iterations );
HYPRE_Int hypre_StructJacobiSetWeight ( void *jacobi_vdata, HYPRE_Real weight );
HYPRE_Int hypre_StructJacobiSetTempVec ( void *jacobi_vdata, hypre_StructVector *t );
HYPRE_Int hypre_StructJacobiGetFinalRelativeResidualNorm ( void *jacobi_vdata, HYPRE_Real *norm );

/* pcg_struct.c */
void *hypre_StructKrylovCAlloc ( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
HYPRE_Int hypre_StructKrylovFree ( void *ptr );
void *hypre_StructKrylovCreateVector ( void *vvector );
void *hypre_StructKrylovCreateVectorArray ( HYPRE_Int n, void *vvector );
HYPRE_Int hypre_StructKrylovDestroyVector ( void *vvector );
void *hypre_StructKrylovMatvecCreate ( void *A, void *x );
HYPRE_Int hypre_StructKrylovMatvec ( void *matvec_data, HYPRE_Complex alpha, void *A, void *x,
                                     HYPRE_Complex beta, void *y );
HYPRE_Int hypre_StructKrylovMatvecDestroy ( void *matvec_data );
HYPRE_Real hypre_StructKrylovInnerProd ( void *x, void *y );
HYPRE_Int hypre_StructKrylovInnerProdTagged ( void *x, void *y, HYPRE_Int *num_tags_ptr,
                                              HYPRE_Complex **iprod_ptr );
HYPRE_Int hypre_StructKrylovCopyVector ( void *x, void *y );
HYPRE_Int hypre_StructKrylovClearVector ( void *x );
HYPRE_Int hypre_StructKrylovSetRandomValues ( void *x, HYPRE_Int seed );
HYPRE_Int hypre_StructKrylovScaleVector ( HYPRE_Complex alpha, void *x );
HYPRE_Int hypre_StructKrylovAxpy ( HYPRE_Complex alpha, void *x, void *y );
HYPRE_Int hypre_StructKrylovIdentitySetup ( void *vdata, void *A, void *b, void *x );
HYPRE_Int hypre_StructKrylovIdentity ( void *vdata, void *A, void *b, void *x );
HYPRE_Int hypre_StructKrylovCommInfo ( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );

/* pfmg2_setup_rap.c */
hypre_StructMatrix *hypre_PFMG2CreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                             hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
HYPRE_Int hypre_PFMG2BuildRAPSym ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                   hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride,
                                   hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPSym_onebox_FSS5_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                   hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                   hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPSym_onebox_FSS5_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                   hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                   hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPSym_onebox_FSS9_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                   hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                   hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPSym_onebox_FSS9_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                   hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                   hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPNoSym ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                     hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride,
                                     hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                     hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                     hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                     hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                     hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                     hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                     hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                     hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                     hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

/* pfmg3_setup_rap.c */
hypre_StructMatrix *hypre_PFMG3CreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                             hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
HYPRE_Int hypre_PFMG3BuildRAPSym ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                   hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride,
                                   hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPSym_onebox_FSS07_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                    hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                    hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPSym_onebox_FSS07_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                    hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                    hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPSym_onebox_FSS19_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                    hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                    hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPSym_onebox_FSS19_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                    hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                    hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPSym_onebox_FSS27_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                    hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                    hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPSym_onebox_FSS27_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                    hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                    hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                     hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride,
                                     hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                      hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                      hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                      hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                      hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                      hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                      hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                      hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                      hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC0 ( HYPRE_Int ci, HYPRE_Int fi,
                                                      hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                      hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC1 ( HYPRE_Int ci, HYPRE_Int fi,
                                                      hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir,
                                                      hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

/* pfmg.c */
void *hypre_PFMGCreate ( MPI_Comm comm );
HYPRE_Int hypre_PFMGDestroy ( void *pfmg_vdata );
HYPRE_Int hypre_PFMGSetTol ( void *pfmg_vdata, HYPRE_Real tol );
HYPRE_Int hypre_PFMGGetTol ( void *pfmg_vdata, HYPRE_Real *tol );
HYPRE_Int hypre_PFMGSetMaxIter ( void *pfmg_vdata, HYPRE_Int max_iter );
HYPRE_Int hypre_PFMGGetMaxIter ( void *pfmg_vdata, HYPRE_Int *max_iter );
HYPRE_Int hypre_PFMGSetMaxLevels ( void *pfmg_vdata, HYPRE_Int max_levels );
HYPRE_Int hypre_PFMGGetMaxLevels ( void *pfmg_vdata, HYPRE_Int *max_levels );
HYPRE_Int hypre_PFMGSetRelChange ( void *pfmg_vdata, HYPRE_Int rel_change );
HYPRE_Int hypre_PFMGGetRelChange ( void *pfmg_vdata, HYPRE_Int *rel_change );
HYPRE_Int hypre_PFMGSetZeroGuess ( void *pfmg_vdata, HYPRE_Int zero_guess );
HYPRE_Int hypre_PFMGGetZeroGuess ( void *pfmg_vdata, HYPRE_Int *zero_guess );
HYPRE_Int hypre_PFMGSetRelaxType ( void *pfmg_vdata, HYPRE_Int relax_type );
HYPRE_Int hypre_PFMGGetRelaxType ( void *pfmg_vdata, HYPRE_Int *relax_type );
HYPRE_Int hypre_PFMGSetJacobiWeight ( void *pfmg_vdata, HYPRE_Real weight );
HYPRE_Int hypre_PFMGGetJacobiWeight ( void *pfmg_vdata, HYPRE_Real *weight );
HYPRE_Int hypre_PFMGSetRAPType ( void *pfmg_vdata, HYPRE_Int rap_type );
HYPRE_Int hypre_PFMGGetRAPType ( void *pfmg_vdata, HYPRE_Int *rap_type );
HYPRE_Int hypre_PFMGSetMatmultType ( void *pfmg_vdata, HYPRE_Int matmult_type );
HYPRE_Int hypre_PFMGGetMatmultType ( void *pfmg_vdata, HYPRE_Int *matmult_type );
HYPRE_Int hypre_PFMGSetNumPreRelax ( void *pfmg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int hypre_PFMGGetNumPreRelax ( void *pfmg_vdata, HYPRE_Int *num_pre_relax );
HYPRE_Int hypre_PFMGSetNumPostRelax ( void *pfmg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int hypre_PFMGGetNumPostRelax ( void *pfmg_vdata, HYPRE_Int *num_post_relax );
HYPRE_Int hypre_PFMGSetSkipRelax ( void *pfmg_vdata, HYPRE_Int skip_relax );
HYPRE_Int hypre_PFMGGetSkipRelax ( void *pfmg_vdata, HYPRE_Int *skip_relax );
HYPRE_Int hypre_PFMGSetDxyz ( void *pfmg_vdata, HYPRE_Real *dxyz );
HYPRE_Int hypre_PFMGSetLogging ( void *pfmg_vdata, HYPRE_Int logging );
HYPRE_Int hypre_PFMGGetLogging ( void *pfmg_vdata, HYPRE_Int *logging );
HYPRE_Int hypre_PFMGSetPrintLevel ( void *pfmg_vdata, HYPRE_Int print_level );
HYPRE_Int hypre_PFMGGetPrintLevel ( void *pfmg_vdata, HYPRE_Int *print_level );
HYPRE_Int hypre_PFMGSetPrintFreq ( void *pfmg_vdata, HYPRE_Int print_freq );
HYPRE_Int hypre_PFMGGetPrintFreq ( void *pfmg_vdata, HYPRE_Int *print_freq );
HYPRE_Int hypre_PFMGGetNumIterations ( void *pfmg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int hypre_PFMGPrintLogging ( void *pfmg_vdata );
HYPRE_Int hypre_PFMGGetFinalRelativeResidualNorm ( void *pfmg_vdata,
                                                   HYPRE_Real *relative_residual_norm );

/* pfmg_coarsen.c */
HYPRE_Int hypre_PFMGComputeMaxLevels ( hypre_StructGrid *grid, HYPRE_Int *max_levels_ptr );
HYPRE_Int hypre_PFMGComputeCxyz ( hypre_StructMatrix *A, HYPRE_Real *cxyz, HYPRE_Real *sqcxyz );
HYPRE_Int hypre_PFMGComputeDxyz ( hypre_StructMatrix *A, HYPRE_Real *dxyz, HYPRE_Int *dxyz_flag );
HYPRE_Int hypre_PFMGCoarsen ( hypre_Box *cbox, hypre_Index periodic, HYPRE_Int max_levels,
                              HYPRE_Int dxyz_flag, HYPRE_Real *dxyz, HYPRE_Int **cdir_l_ptr,
                              HYPRE_Int **active_l_ptr, HYPRE_Real **relax_weights_ptr,
                              HYPRE_Int *num_levels );

/* pfmg_relax.c */
void *hypre_PFMGRelaxCreate ( MPI_Comm comm );
HYPRE_Int hypre_PFMGRelaxDestroy ( void *pfmg_relax_vdata );
HYPRE_Int hypre_PFMGRelax ( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                            hypre_StructVector *x );
HYPRE_Int hypre_PFMGRelaxSetup ( void *pfmg_relax_vdata, hypre_StructMatrix *A,
                                 hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int hypre_PFMGRelaxSetType ( void *pfmg_relax_vdata, HYPRE_Int relax_type );
HYPRE_Int hypre_PFMGRelaxSetJacobiWeight ( void *pfmg_relax_vdata, HYPRE_Real weight );
HYPRE_Int hypre_PFMGRelaxSetPreRelax ( void *pfmg_relax_vdata );
HYPRE_Int hypre_PFMGRelaxSetPostRelax ( void *pfmg_relax_vdata );
HYPRE_Int hypre_PFMGRelaxSetTol ( void *pfmg_relax_vdata, HYPRE_Real tol );
HYPRE_Int hypre_PFMGRelaxSetMaxIter ( void *pfmg_relax_vdata, HYPRE_Int max_iter );
HYPRE_Int hypre_PFMGRelaxSetZeroGuess ( void *pfmg_relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int hypre_PFMGRelaxSetTempVec ( void *pfmg_relax_vdata, hypre_StructVector *t );

/* pfmg_setup.c */
HYPRE_Int hypre_PFMGSetup ( void *pfmg_vdata, hypre_StructMatrix *A,
                            hypre_StructVector *b, hypre_StructVector *x );

/* pfmg_setup_interp.c */
hypre_StructMatrix *hypre_PFMGCreateInterpOp ( hypre_StructMatrix *A, HYPRE_Int cdir,
                                               hypre_Index stride, HYPRE_Int rap_type );
HYPRE_Int hypre_PFMGSetupInterpOp ( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir );
HYPRE_Int hypre_PFMGSetupInterpOp_core_CC( hypre_StructMatrix *P, hypre_StructMatrix *A,
                                           HYPRE_Int cdir, HYPRE_Complex *Pconst0_ptr,
                                           HYPRE_Complex *Pconst1_ptr, HYPRE_Complex *Pconst2_ptr );
HYPRE_Int hypre_PFMGSetupInterpOp_core_VC( hypre_StructMatrix *P, hypre_StructMatrix *A,
                                           HYPRE_Int cdir, HYPRE_Complex Pconst0,
                                           HYPRE_Complex Pconst1, HYPRE_Complex Pconst2 );

/* pfmg_setup_rap5.c */
hypre_StructMatrix *hypre_PFMGCreateCoarseOp5 ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                                hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
HYPRE_Int hypre_PFMGBuildCoarseOp5 ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                     hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride,
                                     hypre_StructMatrix *RAP );

/* pfmg_setup_rap7.c */
hypre_StructMatrix *hypre_PFMGCreateCoarseOp7 ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                                hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
HYPRE_Int hypre_PFMGBuildCoarseOp7 ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                     hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride,
                                     hypre_StructMatrix *RAP );

/* pfmg_setup_rap.c */
hypre_StructMatrix *hypre_PFMGCreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                            hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int rap_type );
HYPRE_Int hypre_PFMGSetupRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                 hypre_StructMatrix *P, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int rap_type,
                                 hypre_StructMatrix *Ac );

/* pfmg_solve.c */
HYPRE_Int hypre_PFMGSolve ( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                            hypre_StructVector *x );

/* red_black_constantcoef_gs.c */
HYPRE_Int hypre_RedBlackConstantCoefGS ( void *relax_vdata, hypre_StructMatrix *A,
                                         hypre_StructVector *b, hypre_StructVector *x );

/* red_black_gs.c */
void *hypre_RedBlackGSCreate ( MPI_Comm comm );
HYPRE_Int hypre_RedBlackGSDestroy ( void *relax_vdata );
HYPRE_Int hypre_RedBlackGSSetup ( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                                  hypre_StructVector *x );
HYPRE_Int hypre_RedBlackGS ( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                             hypre_StructVector *x );
HYPRE_Int hypre_RedBlackGSSetTol ( void *relax_vdata, HYPRE_Real tol );
HYPRE_Int hypre_RedBlackGSSetMaxIter ( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int hypre_RedBlackGSSetZeroGuess ( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int hypre_RedBlackGSSetStartRed ( void *relax_vdata );
HYPRE_Int hypre_RedBlackGSSetStartBlack ( void *relax_vdata );

/* semi.c */
HYPRE_Int hypre_StructInterpAssemble ( hypre_StructMatrix *A, hypre_StructMatrix *P,
                                       HYPRE_Int P_stored_as_transpose, HYPRE_Int cdir, hypre_Index index, hypre_Index stride );

/* semi_interp.c */
void *hypre_SemiInterpCreate ( void );
HYPRE_Int hypre_SemiInterpSetup ( void *interp_vdata, hypre_StructMatrix *P,
                                  HYPRE_Int P_stored_as_transpose, hypre_StructVector *xc, hypre_StructVector *e, hypre_Index cindex,
                                  hypre_Index findex, hypre_Index stride );
HYPRE_Int hypre_SemiInterp ( void *interp_vdata, hypre_StructMatrix *P, hypre_StructVector *xc,
                             hypre_StructVector *e );
HYPRE_Int hypre_SemiInterpDestroy ( void *interp_vdata );

/* semi_restrict.c */
void *hypre_SemiRestrictCreate ( void );
HYPRE_Int hypre_SemiRestrictSetup ( void *restrict_vdata, hypre_StructMatrix *R,
                                    HYPRE_Int R_stored_as_transpose, hypre_StructVector *r, hypre_StructVector *rc, hypre_Index cindex,
                                    hypre_Index findex, hypre_Index stride );
HYPRE_Int hypre_SemiRestrict ( void *restrict_vdata, hypre_StructMatrix *R, hypre_StructVector *r,
                               hypre_StructVector *rc );
HYPRE_Int hypre_SemiRestrictDestroy ( void *restrict_vdata );

/* semi_setup_rap.c */
hypre_StructMatrix *hypre_SemiCreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                            hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir,
                                            HYPRE_Int P_stored_as_transpose );
HYPRE_Int hypre_SemiBuildRAP ( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R,
                               HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int P_stored_as_transpose,
                               hypre_StructMatrix *RAP );

/* smg2_setup_rap.c */
hypre_StructMatrix *hypre_SMG2CreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                            hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
HYPRE_Int hypre_SMG2BuildRAPSym ( hypre_StructMatrix *A, hypre_StructMatrix *PT,
                                  hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int hypre_SMG2BuildRAPNoSym ( hypre_StructMatrix *A, hypre_StructMatrix *PT,
                                    hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int hypre_SMG2RAPPeriodicSym ( hypre_StructMatrix *RAP, hypre_Index cindex,
                                     hypre_Index cstride );
HYPRE_Int hypre_SMG2RAPPeriodicNoSym ( hypre_StructMatrix *RAP, hypre_Index cindex,
                                       hypre_Index cstride );

/* smg3_setup_rap.c */
hypre_StructMatrix *hypre_SMG3CreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                            hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
HYPRE_Int hypre_SMG3BuildRAPSym ( hypre_StructMatrix *A, hypre_StructMatrix *PT,
                                  hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int hypre_SMG3BuildRAPNoSym ( hypre_StructMatrix *A, hypre_StructMatrix *PT,
                                    hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int hypre_SMG3RAPPeriodicSym ( hypre_StructMatrix *RAP, hypre_Index cindex,
                                     hypre_Index cstride );
HYPRE_Int hypre_SMG3RAPPeriodicNoSym ( hypre_StructMatrix *RAP, hypre_Index cindex,
                                       hypre_Index cstride );

/* smg_axpy.c */
HYPRE_Int hypre_SMGAxpy ( HYPRE_Real alpha, hypre_StructVector *x, hypre_StructVector *y,
                          hypre_Index base_index, hypre_Index base_stride );

/* smg.c */
void *hypre_SMGCreate ( MPI_Comm comm );
HYPRE_Int hypre_SMGDestroy ( void *smg_vdata );
HYPRE_Int hypre_SMGSetMemoryUse ( void *smg_vdata, HYPRE_Int memory_use );
HYPRE_Int hypre_SMGGetMemoryUse ( void *smg_vdata, HYPRE_Int *memory_use );
HYPRE_Int hypre_SMGSetTol ( void *smg_vdata, HYPRE_Real tol );
HYPRE_Int hypre_SMGGetTol ( void *smg_vdata, HYPRE_Real *tol );
HYPRE_Int hypre_SMGSetMaxIter ( void *smg_vdata, HYPRE_Int max_iter );
HYPRE_Int hypre_SMGGetMaxIter ( void *smg_vdata, HYPRE_Int *max_iter );
HYPRE_Int hypre_SMGSetRelChange ( void *smg_vdata, HYPRE_Int rel_change );
HYPRE_Int hypre_SMGGetRelChange ( void *smg_vdata, HYPRE_Int *rel_change );
HYPRE_Int hypre_SMGSetZeroGuess ( void *smg_vdata, HYPRE_Int zero_guess );
HYPRE_Int hypre_SMGGetZeroGuess ( void *smg_vdata, HYPRE_Int *zero_guess );
HYPRE_Int hypre_SMGSetNumPreRelax ( void *smg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int hypre_SMGGetNumPreRelax ( void *smg_vdata, HYPRE_Int *num_pre_relax );
HYPRE_Int hypre_SMGSetNumPostRelax ( void *smg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int hypre_SMGGetNumPostRelax ( void *smg_vdata, HYPRE_Int *num_post_relax );
HYPRE_Int hypre_SMGSetBase ( void *smg_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int hypre_SMGSetLogging ( void *smg_vdata, HYPRE_Int logging );
HYPRE_Int hypre_SMGGetLogging ( void *smg_vdata, HYPRE_Int *logging );
HYPRE_Int hypre_SMGSetPrintLevel ( void *smg_vdata, HYPRE_Int print_level );
HYPRE_Int hypre_SMGGetPrintLevel ( void *smg_vdata, HYPRE_Int *print_level );
HYPRE_Int hypre_SMGGetNumIterations ( void *smg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int hypre_SMGPrintLogging ( void *smg_vdata );
HYPRE_Int hypre_SMGGetFinalRelativeResidualNorm ( void *smg_vdata,
                                                  HYPRE_Real *relative_residual_norm );
HYPRE_Int hypre_SMGSetStructVectorConstantValues ( hypre_StructVector *vector, HYPRE_Real values,
                                                   hypre_BoxArray *box_array, hypre_Index stride );
HYPRE_Int hypre_SMGSetMaxLevel ( void *smg_vdata, HYPRE_Int max_level );

/* smg_relax.c */
void *hypre_SMGRelaxCreate ( MPI_Comm comm );
HYPRE_Int hypre_SMGRelaxDestroyTempVec ( void *relax_vdata );
HYPRE_Int hypre_SMGRelaxDestroyARem ( void *relax_vdata );
HYPRE_Int hypre_SMGRelaxDestroyASol ( void *relax_vdata );
HYPRE_Int hypre_SMGRelaxDestroy ( void *relax_vdata );
HYPRE_Int hypre_SMGRelax ( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                           hypre_StructVector *x );
HYPRE_Int hypre_SMGRelaxSetup ( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                                hypre_StructVector *x );
HYPRE_Int hypre_SMGRelaxSetupTempVec ( void *relax_vdata, hypre_StructMatrix *A,
                                       hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int hypre_SMGRelaxSetupARem ( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                                    hypre_StructVector *x );
HYPRE_Int hypre_SMGRelaxSetupASol ( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                                    hypre_StructVector *x );
HYPRE_Int hypre_SMGRelaxSetTempVec ( void *relax_vdata, hypre_StructVector *temp_vec );
HYPRE_Int hypre_SMGRelaxSetMemoryUse ( void *relax_vdata, HYPRE_Int memory_use );
HYPRE_Int hypre_SMGRelaxSetTol ( void *relax_vdata, HYPRE_Real tol );
HYPRE_Int hypre_SMGRelaxSetMaxIter ( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int hypre_SMGRelaxSetZeroGuess ( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int hypre_SMGRelaxSetNumSpaces ( void *relax_vdata, HYPRE_Int num_spaces );
HYPRE_Int hypre_SMGRelaxSetNumPreSpaces ( void *relax_vdata, HYPRE_Int num_pre_spaces );
HYPRE_Int hypre_SMGRelaxSetNumRegSpaces ( void *relax_vdata, HYPRE_Int num_reg_spaces );
HYPRE_Int hypre_SMGRelaxSetSpace ( void *relax_vdata, HYPRE_Int i, HYPRE_Int space_index,
                                   HYPRE_Int space_stride );
HYPRE_Int hypre_SMGRelaxSetRegSpaceRank ( void *relax_vdata, HYPRE_Int i,
                                          HYPRE_Int reg_space_rank );
HYPRE_Int hypre_SMGRelaxSetPreSpaceRank ( void *relax_vdata, HYPRE_Int i,
                                          HYPRE_Int pre_space_rank );
HYPRE_Int hypre_SMGRelaxSetBase ( void *relax_vdata, hypre_Index base_index,
                                  hypre_Index base_stride );
HYPRE_Int hypre_SMGRelaxSetNumPreRelax ( void *relax_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int hypre_SMGRelaxSetNumPostRelax ( void *relax_vdata, HYPRE_Int num_post_relax );
HYPRE_Int hypre_SMGRelaxSetNewMatrixStencil ( void *relax_vdata,
                                              hypre_StructStencil *diff_stencil );
HYPRE_Int hypre_SMGRelaxSetupBaseBoxArray ( void *relax_vdata, hypre_StructMatrix *A,
                                            hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int hypre_SMGRelaxSetMaxLevel( void *relax_vdata, HYPRE_Int   num_max_level );

/* smg_residual.c */
void *hypre_SMGResidualCreate ( void );
HYPRE_Int hypre_SMGResidualSetup ( void *residual_vdata, hypre_StructMatrix *A,
                                   hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );
HYPRE_Int hypre_SMGResidual ( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x,
                              hypre_StructVector *b, hypre_StructVector *r );
HYPRE_Int hypre_SMGResidualSetBase ( void *residual_vdata, hypre_Index base_index,
                                     hypre_Index base_stride );
HYPRE_Int hypre_SMGResidualDestroy ( void *residual_vdata );

/* smg_setup.c */
HYPRE_Int hypre_SMGSetup ( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                           hypre_StructVector *x );

/* smg_setup_interp.c */
hypre_StructMatrix *hypre_SMGCreateInterpOp ( hypre_StructMatrix *A, hypre_StructGrid *cgrid,
                                              HYPRE_Int cdir );
HYPRE_Int hypre_SMGSetupInterpOp ( void *relax_data, hypre_StructMatrix *A, hypre_StructVector *b,
                                   hypre_StructVector *x, hypre_StructMatrix *PT, HYPRE_Int cdir, hypre_Index cindex,
                                   hypre_Index findex, hypre_Index stride );

/* smg_setup_rap.c */
hypre_StructMatrix *hypre_SMGCreateRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                           hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
HYPRE_Int hypre_SMGSetupRAPOp ( hypre_StructMatrix *R, hypre_StructMatrix *A,
                                hypre_StructMatrix *PT, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride );

/* smg_setup_restrict.c */
hypre_StructMatrix *hypre_SMGCreateRestrictOp ( hypre_StructMatrix *A, hypre_StructGrid *cgrid,
                                                HYPRE_Int cdir );
HYPRE_Int hypre_SMGSetupRestrictOp ( hypre_StructMatrix *A, hypre_StructMatrix *R,
                                     hypre_StructVector *temp_vec, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride );

/* smg_solve.c */
HYPRE_Int hypre_SMGSolve ( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b,
                           hypre_StructVector *x );

#ifdef __cplusplus
}
#endif

#ifdef HYPRE_MIXED_PRECISION
/* The following is for user compiles and the order is important.  The first
 * header ensures that we do not change prototype names in user files or in the
 * second header file.  The second header contains all the prototypes needed by
 * users for mixed precision. */
#ifndef hypre_MP_BUILD
#include "_hypre_struct_ls_mup_undef.h"
#include "_hypre_struct_ls_mup.h"
#endif
#endif

#endif

