// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the contents of a SageMaker hub for a ModelReference resource. A
// ModelReference allows you to access public SageMaker JumpStart models from
// within your private hub.
//
// When using this API, you can update the MinVersion field for additional
// flexibility in the model version. You shouldn't update any additional fields
// when using this API, because the metadata in your private hub should match the
// public JumpStart model's metadata.
//
// If you want to update a Model or Notebook resource in your hub, use the
// UpdateHubContent API instead.
//
// For more information about adding model references to your hub, see [Add models to a private hub].
//
// [Add models to a private hub]: https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-curated-hubs-admin-guide-add-models.html
func (c *Client) UpdateHubContentReference(ctx context.Context, params *UpdateHubContentReferenceInput, optFns ...func(*Options)) (*UpdateHubContentReferenceOutput, error) {
	if params == nil {
		params = &UpdateHubContentReferenceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateHubContentReference", params, optFns, c.addOperationUpdateHubContentReferenceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateHubContentReferenceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateHubContentReferenceInput struct {

	// The name of the hub content resource that you want to update.
	//
	// This member is required.
	HubContentName *string

	// The content type of the resource that you want to update. Only specify a
	// ModelReference resource for this API. To update a Model or Notebook resource,
	// use the UpdateHubContent API instead.
	//
	// This member is required.
	HubContentType types.HubContentType

	// The name of the SageMaker hub that contains the hub content you want to update.
	// You can optionally use the hub ARN instead.
	//
	// This member is required.
	HubName *string

	// The minimum hub content version of the referenced model that you want to use.
	// The minimum version must be older than the latest available version of the
	// referenced model. To support all versions of a model, set the value to 1.0.0 .
	MinVersion *string

	noSmithyDocumentSerde
}

type UpdateHubContentReferenceOutput struct {

	// The ARN of the private model hub that contains the updated hub content.
	//
	// This member is required.
	HubArn *string

	// The ARN of the hub content resource that was updated.
	//
	// This member is required.
	HubContentArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateHubContentReferenceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateHubContentReference{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateHubContentReference{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateHubContentReference"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateHubContentReferenceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateHubContentReference(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateHubContentReference(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateHubContentReference",
	}
}
