// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes the properties of an application.
type ApplicationDescription struct {

	// The Amazon Resource Name (ARN) of the application.
	ApplicationArn *string

	// The name of the application.
	ApplicationName *string

	// The names of the configuration templates associated with this application.
	ConfigurationTemplates []string

	// The date when the application was created.
	DateCreated *time.Time

	// The date when the application was last modified.
	DateUpdated *time.Time

	// User-defined description of the application.
	Description *string

	// The lifecycle settings for the application.
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig

	// The names of the versions for this application.
	Versions []string

	noSmithyDocumentSerde
}

// Application request metrics for an AWS Elastic Beanstalk environment.
type ApplicationMetrics struct {

	// The amount of time that the metrics cover (usually 10 seconds). For example,
	// you might have 5 requests ( request_count ) within the most recent time slice of
	// 10 seconds ( duration ).
	Duration *int32

	// Represents the average latency for the slowest X percent of requests over the
	// last 10 seconds. Latencies are in seconds with one millisecond resolution.
	Latency *Latency

	// Average number of requests handled by the web server per second over the last
	// 10 seconds.
	RequestCount int32

	// Represents the percentage of requests over the last 10 seconds that resulted in
	// each type of status code response.
	StatusCodes *StatusCodes

	noSmithyDocumentSerde
}

// The resource lifecycle configuration for an application. Defines lifecycle
// settings for resources that belong to the application, and the service role that
// AWS Elastic Beanstalk assumes in order to apply lifecycle settings. The version
// lifecycle configuration defines lifecycle settings for application versions.
type ApplicationResourceLifecycleConfig struct {

	// The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
	//
	// The ServiceRole property is required the first time that you provide a
	// VersionLifecycleConfig for the application in one of the supporting calls (
	// CreateApplication or UpdateApplicationResourceLifecycle ). After you provide it
	// once, in either one of the calls, Elastic Beanstalk persists the Service Role
	// with the application, and you don't need to specify it again in subsequent
	// UpdateApplicationResourceLifecycle calls. You can, however, specify it in
	// subsequent calls to change the Service Role to another value.
	ServiceRole *string

	// Defines lifecycle settings for application versions.
	VersionLifecycleConfig *ApplicationVersionLifecycleConfig

	noSmithyDocumentSerde
}

// Describes the properties of an application version.
type ApplicationVersionDescription struct {

	// The name of the application to which the application version belongs.
	ApplicationName *string

	// The Amazon Resource Name (ARN) of the application version.
	ApplicationVersionArn *string

	// Reference to the artifact from the AWS CodeBuild build.
	BuildArn *string

	// The creation date of the application version.
	DateCreated *time.Time

	// The last modified date of the application version.
	DateUpdated *time.Time

	// The description of the application version.
	Description *string

	// If the version's source code was retrieved from AWS CodeCommit, the location of
	// the source code for the application version.
	SourceBuildInformation *SourceBuildInformation

	// The storage location of the application version's source bundle in Amazon S3.
	SourceBundle *S3Location

	// The processing status of the application version. Reflects the state of the
	// application version during its creation. Many of the values are only applicable
	// if you specified True for the Process parameter of the CreateApplicationVersion
	// action. The following list describes the possible values.
	//
	//   - Unprocessed – Application version wasn't pre-processed or validated. Elastic
	//   Beanstalk will validate configuration files during deployment of the application
	//   version to an environment.
	//
	//   - Processing – Elastic Beanstalk is currently processing the application
	//   version.
	//
	//   - Building – Application version is currently undergoing an AWS CodeBuild
	//   build.
	//
	//   - Processed – Elastic Beanstalk was successfully pre-processed and validated.
	//
	//   - Failed – Either the AWS CodeBuild build failed or configuration files didn't
	//   pass validation. This application version isn't usable.
	Status ApplicationVersionStatus

	// A unique identifier for the application version.
	VersionLabel *string

	noSmithyDocumentSerde
}

// The application version lifecycle settings for an application. Defines the
// rules that Elastic Beanstalk applies to an application's versions in order to
// avoid hitting the per-region limit for application versions.
//
// When Elastic Beanstalk deletes an application version from its database, you
// can no longer deploy that version to an environment. The source bundle remains
// in S3 unless you configure the rule to delete it.
type ApplicationVersionLifecycleConfig struct {

	// Specify a max age rule to restrict the length of time that application versions
	// are retained for an application.
	MaxAgeRule *MaxAgeRule

	// Specify a max count rule to restrict the number of application versions that
	// are retained for an application.
	MaxCountRule *MaxCountRule

	noSmithyDocumentSerde
}

// Describes an Auto Scaling launch configuration.
type AutoScalingGroup struct {

	// The name of the AutoScalingGroup .
	Name *string

	noSmithyDocumentSerde
}

// Settings for an AWS CodeBuild build.
type BuildConfiguration struct {

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM)
	// role that enables AWS CodeBuild to interact with dependent AWS services on
	// behalf of the AWS account.
	//
	// This member is required.
	CodeBuildServiceRole *string

	// The ID of the Docker image to use for this build project.
	//
	// This member is required.
	Image *string

	// The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk
	// stores the build artifact in the S3 location
	// S3-bucket/resources/application-name/codebuild/codebuild-version-label-artifact-name.zip.
	// If not provided, Elastic Beanstalk stores the build artifact in the S3 location
	// S3-bucket/resources/application-name/codebuild/codebuild-version-label.zip.
	ArtifactName *string

	// Information about the compute resources the build project will use.
	//
	//   - BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds
	//
	//   - BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds
	//
	//   - BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds
	ComputeType ComputeType

	// How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until
	// timing out any related build that does not get marked as completed. The default
	// is 60 minutes.
	TimeoutInMinutes *int32

	noSmithyDocumentSerde
}

// The builder used to build the custom platform.
type Builder struct {

	// The ARN of the builder.
	ARN *string

	noSmithyDocumentSerde
}

// Describes the possible values for a configuration option.
type ConfigurationOptionDescription struct {

	// An indication of which action is required if the value for this configuration
	// option changes:
	//
	//   - NoInterruption : There is no interruption to the environment or application
	//   availability.
	//
	//   - RestartEnvironment : The environment is entirely restarted, all AWS
	//   resources are deleted and recreated, and the environment is unavailable during
	//   the process.
	//
	//   - RestartApplicationServer : The environment is available the entire time.
	//   However, a short application outage occurs when the application servers on the
	//   running Amazon EC2 instances are restarted.
	ChangeSeverity *string

	// The default value for this configuration option.
	DefaultValue *string

	// If specified, the configuration option must be a string value no longer than
	// this value.
	MaxLength *int32

	// If specified, the configuration option must be a numeric value less than this
	// value.
	MaxValue *int32

	// If specified, the configuration option must be a numeric value greater than
	// this value.
	MinValue *int32

	// The name of the configuration option.
	Name *string

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string

	// If specified, the configuration option must be a string value that satisfies
	// this regular expression.
	Regex *OptionRestrictionRegex

	// An indication of whether the user defined this configuration option:
	//
	//   - true : This configuration option was defined by the user. It is a valid
	//   choice for specifying if this as an Option to Remove when updating
	//   configuration settings.
	//
	//   - false : This configuration was not defined by the user.
	//
	// Constraint: You can remove only UserDefined options from a configuration.
	//
	// Valid Values: true | false
	UserDefined *bool

	// If specified, values for the configuration option are selected from this list.
	ValueOptions []string

	// An indication of which type of values this option has and whether it is
	// allowable to select one or more than one of the possible values:
	//
	//   - Scalar : Values for this option are a single selection from the possible
	//   values, or an unformatted string, or numeric value governed by the
	//   MIN/MAX/Regex constraints.
	//
	//   - List : Values for this option are multiple selections from the possible
	//   values.
	//
	//   - Boolean : Values for this option are either true or false .
	//
	//   - Json : Values for this option are a JSON representation of a ConfigDocument .
	ValueType ConfigurationOptionValueType

	noSmithyDocumentSerde
}

// A specification identifying an individual configuration option along with its
// current value. For a list of possible namespaces and option values, see [Option Values]in the
// AWS Elastic Beanstalk Developer Guide.
//
// [Option Values]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html
type ConfigurationOptionSetting struct {

	// A unique namespace that identifies the option's associated AWS resource.
	Namespace *string

	// The name of the configuration option.
	OptionName *string

	// A unique resource name for the option setting. Use it for a time–based scaling
	// configuration option.
	ResourceName *string

	// The current value for the configuration option.
	Value *string

	noSmithyDocumentSerde
}

// Describes the settings for a configuration set.
type ConfigurationSettingsDescription struct {

	// The name of the application associated with this configuration set.
	ApplicationName *string

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time

	//  If this configuration set is associated with an environment, the
	// DeploymentStatus parameter indicates the deployment status of this configuration
	// set:
	//
	//   - null : This configuration is not associated with a running environment.
	//
	//   - pending : This is a draft configuration that is not deployed to the
	//   associated environment but is in the process of deploying.
	//
	//   - deployed : This is the configuration that is currently deployed to the
	//   associated running environment.
	//
	//   - failed : This is a draft configuration that failed to successfully deploy.
	DeploymentStatus ConfigurationDeploymentStatus

	// Describes this configuration set.
	Description *string

	//  If not null , the name of the environment for this configuration set.
	EnvironmentName *string

	// A list of the configuration options and their values in this configuration set.
	OptionSettings []ConfigurationOptionSetting

	// The ARN of the platform version.
	PlatformArn *string

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string

	//  If not null , the name of the configuration template for this configuration
	// set.
	TemplateName *string

	noSmithyDocumentSerde
}

// CPU utilization metrics for an instance.
type CPUUtilization struct {

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the I/O Wait state over the last
	// 10 seconds.
	IOWait *float64

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the IRQ state over the last 10
	// seconds.
	IRQ *float64

	// Percentage of time that the CPU has spent in the Idle state over the last 10
	// seconds.
	Idle *float64

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the Nice state over the last 10
	// seconds.
	Nice *float64

	// Available on Windows environments only.
	//
	// Percentage of time that the CPU has spent in the Privileged state over the last
	// 10 seconds.
	Privileged *float64

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the SoftIRQ state over the last 10
	// seconds.
	SoftIRQ *float64

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the System state over the last 10
	// seconds.
	System *float64

	// Percentage of time that the CPU has spent in the User state over the last 10
	// seconds.
	User *float64

	noSmithyDocumentSerde
}

// A custom AMI available to platforms.
type CustomAmi struct {

	// THe ID of the image used to create the custom AMI.
	ImageId *string

	// The type of virtualization used to create the custom AMI.
	VirtualizationType *string

	noSmithyDocumentSerde
}

// Information about an application version deployment.
type Deployment struct {

	// The ID of the deployment. This number increases by one each time that you
	// deploy source code or change instance configuration settings.
	DeploymentId *int64

	// For in-progress deployments, the time that the deployment started.
	//
	// For completed deployments, the time that the deployment ended.
	DeploymentTime *time.Time

	// The status of the deployment:
	//
	//   - In Progress : The deployment is in progress.
	//
	//   - Deployed : The deployment succeeded.
	//
	//   - Failed : The deployment failed.
	Status *string

	// The version label of the application version in the deployment.
	VersionLabel *string

	noSmithyDocumentSerde
}

// Describes the properties of an environment.
type EnvironmentDescription struct {

	// Indicates if there is an in-progress environment configuration update or
	// application version deployment that you can cancel.
	//
	// true: There is an update in progress.
	//
	// false: There are no updates currently in progress.
	AbortableOperationInProgress *bool

	// The name of the application associated with this environment.
	ApplicationName *string

	// The URL to the CNAME for this environment.
	CNAME *string

	// The creation date for this environment.
	DateCreated *time.Time

	// The last modified date for this environment.
	DateUpdated *time.Time

	// Describes this environment.
	Description *string

	// For load-balanced, autoscaling environments, the URL to the LoadBalancer. For
	// single-instance environments, the IP address of the instance.
	EndpointURL *string

	// The environment's Amazon Resource Name (ARN), which can be used in other API
	// requests that require an ARN.
	EnvironmentArn *string

	// The ID of this environment.
	EnvironmentId *string

	// A list of links to other environments in the same group.
	EnvironmentLinks []EnvironmentLink

	// The name of this environment.
	EnvironmentName *string

	// Describes the health status of the environment. AWS Elastic Beanstalk indicates
	// the failure levels for a running environment:
	//
	//   - Red : Indicates the environment is not responsive. Occurs when three or more
	//   consecutive failures occur for an environment.
	//
	//   - Yellow : Indicates that something is wrong. Occurs when two consecutive
	//   failures occur for an environment.
	//
	//   - Green : Indicates the environment is healthy and fully functional.
	//
	//   - Grey : Default health for a new environment. The environment is not fully
	//   launched and health checks have not started or health checks are suspended
	//   during an UpdateEnvironment or RestartEnvironment request.
	//
	// Default: Grey
	Health EnvironmentHealth

	// Returns the health status of the application running in your environment. For
	// more information, see [Health Colors and Statuses].
	//
	// [Health Colors and Statuses]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html
	HealthStatus EnvironmentHealthStatus

	// The Amazon Resource Name (ARN) of the environment's operations role. For more
	// information, see [Operations roles]in the AWS Elastic Beanstalk Developer Guide.
	//
	// [Operations roles]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html
	OperationsRole *string

	// The ARN of the platform version.
	PlatformArn *string

	// The description of the AWS resources used by this environment.
	Resources *EnvironmentResourcesDescription

	//  The name of the SolutionStack deployed with this environment.
	SolutionStackName *string

	// The current operational status of the environment:
	//
	//   - Launching : Environment is in the process of initial deployment.
	//
	//   - Updating : Environment is in the process of updating its configuration
	//   settings or application version.
	//
	//   - Ready : Environment is available to have an action performed on it, such as
	//   update or terminate.
	//
	//   - Terminating : Environment is in the shut-down process.
	//
	//   - Terminated : Environment is not running.
	Status EnvironmentStatus

	// The name of the configuration template used to originally launch this
	// environment.
	TemplateName *string

	// Describes the current tier of this environment.
	Tier *EnvironmentTier

	// The application version deployed in this environment.
	VersionLabel *string

	noSmithyDocumentSerde
}

// The information retrieved from the Amazon EC2 instances.
type EnvironmentInfoDescription struct {

	// The Amazon EC2 Instance ID for this information.
	Ec2InstanceId *string

	// The type of information retrieved.
	InfoType EnvironmentInfoType

	// The retrieved information. Currently contains a presigned Amazon S3 URL. The
	// files are deleted after 15 minutes.
	//
	// Anyone in possession of this URL can access the files before they are deleted.
	// Make the URL available only to trusted parties.
	Message *string

	// The time stamp when this information was retrieved.
	SampleTimestamp *time.Time

	noSmithyDocumentSerde
}

// A link to another environment, defined in the environment's manifest. Links
// provide connection information in system properties that can be used to connect
// to another environment in the same group. See [Environment Manifest (env.yaml)]for details.
//
// [Environment Manifest (env.yaml)]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html
type EnvironmentLink struct {

	// The name of the linked environment (the dependency).
	EnvironmentName *string

	// The name of the link.
	LinkName *string

	noSmithyDocumentSerde
}

// Describes the AWS resources in use by this environment. This data is live.
type EnvironmentResourceDescription struct {

	//  The AutoScalingGroups used by this environment.
	AutoScalingGroups []AutoScalingGroup

	// The name of the environment.
	EnvironmentName *string

	// The Amazon EC2 instances used by this environment.
	Instances []Instance

	// The Auto Scaling launch configurations in use by this environment.
	LaunchConfigurations []LaunchConfiguration

	// The Amazon EC2 launch templates in use by this environment.
	LaunchTemplates []LaunchTemplate

	// The LoadBalancers in use by this environment.
	LoadBalancers []LoadBalancer

	// The queues used by this environment.
	Queues []Queue

	// The AutoScaling triggers in use by this environment.
	Triggers []Trigger

	noSmithyDocumentSerde
}

// Describes the AWS resources in use by this environment. This data is not live
// data.
type EnvironmentResourcesDescription struct {

	// Describes the LoadBalancer.
	LoadBalancer *LoadBalancerDescription

	noSmithyDocumentSerde
}

// Describes the properties of an environment tier
type EnvironmentTier struct {

	// The name of this environment tier.
	//
	// Valid values:
	//
	//   - For Web server tier – WebServer
	//
	//   - For Worker tier – Worker
	Name *string

	// The type of this environment tier.
	//
	// Valid values:
	//
	//   - For Web server tier – Standard
	//
	//   - For Worker tier – SQS/HTTP
	Type *string

	// The version of this environment tier. When you don't set a value to it, Elastic
	// Beanstalk uses the latest compatible worker tier version.
	//
	// This member is deprecated. Any specific version that you set may become out of
	// date. We recommend leaving it unspecified.
	Version *string

	noSmithyDocumentSerde
}

// Describes an event.
type EventDescription struct {

	// The application associated with the event.
	ApplicationName *string

	// The name of the environment associated with this event.
	EnvironmentName *string

	// The date when the event occurred.
	EventDate *time.Time

	// The event message.
	Message *string

	// The ARN of the platform version.
	PlatformArn *string

	// The web service request ID for the activity of this event.
	RequestId *string

	// The severity level of this event.
	Severity EventSeverity

	// The name of the configuration associated with this event.
	TemplateName *string

	// The release label for the application version associated with this event.
	VersionLabel *string

	noSmithyDocumentSerde
}

// The description of an Amazon EC2 instance.
type Instance struct {

	// The ID of the Amazon EC2 instance.
	Id *string

	noSmithyDocumentSerde
}

// Represents summary information about the health of an instance. For more
// information, see [Health Colors and Statuses].
//
// [Health Colors and Statuses]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html
type InstanceHealthSummary struct {

	//  Red. The health agent is reporting a high number of request failures or other
	// issues for an instance or environment.
	Degraded *int32

	//  Green. An operation is in progress on an instance.
	Info *int32

	//  Grey. AWS Elastic Beanstalk and the health agent are reporting no data on an
	// instance.
	NoData *int32

	//  Green. An instance is passing health checks and the health agent is not
	// reporting any problems.
	Ok *int32

	//  Grey. An operation is in progress on an instance within the command timeout.
	Pending *int32

	//  Red. The health agent is reporting a very high number of request failures or
	// other issues for an instance or environment.
	Severe *int32

	//  Grey. AWS Elastic Beanstalk and the health agent are reporting an insufficient
	// amount of data on an instance.
	Unknown *int32

	//  Yellow. The health agent is reporting a moderate number of request failures or
	// other issues for an instance or environment.
	Warning *int32

	noSmithyDocumentSerde
}

// Represents the average latency for the slowest X percent of requests over the
// last 10 seconds.
type Latency struct {

	// The average latency for the slowest 90 percent of requests over the last 10
	// seconds.
	P10 *float64

	// The average latency for the slowest 50 percent of requests over the last 10
	// seconds.
	P50 *float64

	// The average latency for the slowest 25 percent of requests over the last 10
	// seconds.
	P75 *float64

	// The average latency for the slowest 15 percent of requests over the last 10
	// seconds.
	P85 *float64

	// The average latency for the slowest 10 percent of requests over the last 10
	// seconds.
	P90 *float64

	// The average latency for the slowest 5 percent of requests over the last 10
	// seconds.
	P95 *float64

	// The average latency for the slowest 1 percent of requests over the last 10
	// seconds.
	P99 *float64

	// The average latency for the slowest 0.1 percent of requests over the last 10
	// seconds.
	P999 *float64

	noSmithyDocumentSerde
}

// Describes an Auto Scaling launch configuration.
type LaunchConfiguration struct {

	// The name of the launch configuration.
	Name *string

	noSmithyDocumentSerde
}

// Describes an Amazon EC2 launch template.
type LaunchTemplate struct {

	// The ID of the launch template.
	Id *string

	noSmithyDocumentSerde
}

// Describes the properties of a Listener for the LoadBalancer.
type Listener struct {

	// The port that is used by the Listener.
	Port int32

	// The protocol that is used by the Listener.
	Protocol *string

	noSmithyDocumentSerde
}

// Describes a LoadBalancer.
type LoadBalancer struct {

	// The name of the LoadBalancer.
	Name *string

	noSmithyDocumentSerde
}

// Describes the details of a LoadBalancer.
type LoadBalancerDescription struct {

	// The domain name of the LoadBalancer.
	Domain *string

	// A list of Listeners used by the LoadBalancer.
	Listeners []Listener

	// The name of the LoadBalancer.
	LoadBalancerName *string

	noSmithyDocumentSerde
}

// The record of an upcoming or in-progress managed action.
type ManagedAction struct {

	// A description of the managed action.
	ActionDescription *string

	// A unique identifier for the managed action.
	ActionId *string

	// The type of managed action.
	ActionType ActionType

	// The status of the managed action. If the action is Scheduled , you can apply it
	// immediately with ApplyEnvironmentManagedAction.
	Status ActionStatus

	// The start time of the maintenance window in which the managed action will
	// execute.
	WindowStartTime *time.Time

	noSmithyDocumentSerde
}

// The record of a completed or failed managed action.
type ManagedActionHistoryItem struct {

	// A description of the managed action.
	ActionDescription *string

	// A unique identifier for the managed action.
	ActionId *string

	// The type of the managed action.
	ActionType ActionType

	// The date and time that the action started executing.
	ExecutedTime *time.Time

	// If the action failed, a description of the failure.
	FailureDescription *string

	// If the action failed, the type of failure.
	FailureType FailureType

	// The date and time that the action finished executing.
	FinishedTime *time.Time

	// The status of the action.
	Status ActionHistoryStatus

	noSmithyDocumentSerde
}

// A lifecycle rule that deletes application versions after the specified number
// of days.
type MaxAgeRule struct {

	// Specify true to apply the rule, or false to disable it.
	//
	// This member is required.
	Enabled *bool

	// Set to true to delete a version's source bundle from Amazon S3 when Elastic
	// Beanstalk deletes the application version.
	DeleteSourceFromS3 *bool

	// Specify the number of days to retain an application versions.
	MaxAgeInDays *int32

	noSmithyDocumentSerde
}

// A lifecycle rule that deletes the oldest application version when the maximum
// count is exceeded.
type MaxCountRule struct {

	// Specify true to apply the rule, or false to disable it.
	//
	// This member is required.
	Enabled *bool

	// Set to true to delete a version's source bundle from Amazon S3 when Elastic
	// Beanstalk deletes the application version.
	DeleteSourceFromS3 *bool

	// Specify the maximum number of application versions to retain.
	MaxCount *int32

	noSmithyDocumentSerde
}

// A regular expression representing a restriction on a string configuration
// option value.
type OptionRestrictionRegex struct {

	// A unique name representing this regular expression.
	Label *string

	// The regular expression pattern that a string configuration option value with
	// this restriction must match.
	Pattern *string

	noSmithyDocumentSerde
}

// A specification identifying an individual configuration option.
type OptionSpecification struct {

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string

	// The name of the configuration option.
	OptionName *string

	// A unique resource name for a time-based scaling configuration option.
	ResourceName *string

	noSmithyDocumentSerde
}

// Summary information about a platform branch.
type PlatformBranchSummary struct {

	// The name of the platform branch.
	BranchName *string

	// An ordinal number that designates the order in which platform branches have
	// been added to a platform. This can be helpful, for example, if your code calls
	// the ListPlatformBranches action and then displays a list of platform branches.
	//
	// A larger BranchOrder value designates a newer platform branch within the
	// platform.
	BranchOrder int32

	// The support life cycle state of the platform branch.
	//
	// Possible values: beta | supported | deprecated | retired
	LifecycleState *string

	// The name of the platform to which this platform branch belongs.
	PlatformName *string

	// The environment tiers that platform versions in this branch support.
	//
	// Possible values: WebServer/Standard | Worker/SQS/HTTP
	SupportedTierList []string

	noSmithyDocumentSerde
}

// Detailed information about a platform version.
type PlatformDescription struct {

	// The custom AMIs supported by the platform version.
	CustomAmiList []CustomAmi

	// The date when the platform version was created.
	DateCreated *time.Time

	// The date when the platform version was last updated.
	DateUpdated *time.Time

	// The description of the platform version.
	Description *string

	// The frameworks supported by the platform version.
	Frameworks []PlatformFramework

	// Information about the maintainer of the platform version.
	Maintainer *string

	// The operating system used by the platform version.
	OperatingSystemName *string

	// The version of the operating system used by the platform version.
	OperatingSystemVersion *string

	// The ARN of the platform version.
	PlatformArn *string

	// The state of the platform version's branch in its lifecycle.
	//
	// Possible values: Beta | Supported | Deprecated | Retired
	PlatformBranchLifecycleState *string

	// The platform branch to which the platform version belongs.
	PlatformBranchName *string

	// The category of the platform version.
	PlatformCategory *string

	// The state of the platform version in its lifecycle.
	//
	// Possible values: Recommended | null
	//
	// If a null value is returned, the platform version isn't the recommended one for
	// its branch. Each platform branch has a single recommended platform version,
	// typically the most recent one.
	PlatformLifecycleState *string

	// The name of the platform version.
	PlatformName *string

	// The AWS account ID of the person who created the platform version.
	PlatformOwner *string

	// The status of the platform version.
	PlatformStatus PlatformStatus

	// The version of the platform version.
	PlatformVersion *string

	// The programming languages supported by the platform version.
	ProgrammingLanguages []PlatformProgrammingLanguage

	// The name of the solution stack used by the platform version.
	SolutionStackName *string

	// The additions supported by the platform version.
	SupportedAddonList []string

	// The tiers supported by the platform version.
	SupportedTierList []string

	noSmithyDocumentSerde
}

// Describes criteria to restrict the results when listing platform versions.
//
// The filter is evaluated as follows: Type Operator Values[1]
type PlatformFilter struct {

	// The operator to apply to the Type with each of the Values .
	//
	// Valid values: = | != | < | <= | > | >= | contains | begins_with | ends_with
	Operator *string

	// The platform version attribute to which the filter values are applied.
	//
	// Valid values: PlatformName | PlatformVersion | PlatformStatus |
	// PlatformBranchName | PlatformLifecycleState | PlatformOwner | SupportedTier |
	// SupportedAddon | ProgrammingLanguageName | OperatingSystemName
	Type *string

	// The list of values applied to the filtering platform version attribute. Only
	// one value is supported for all current operators.
	//
	// The following list shows valid filter values for some filter attributes.
	//
	//   - PlatformStatus : Creating | Failed | Ready | Deleting | Deleted
	//
	//   - PlatformLifecycleState : recommended
	//
	//   - SupportedTier : WebServer/Standard | Worker/SQS/HTTP
	//
	//   - SupportedAddon : Log/S3 | Monitoring/Healthd | WorkerDaemon/SQSD
	Values []string

	noSmithyDocumentSerde
}

// A framework supported by the platform.
type PlatformFramework struct {

	// The name of the framework.
	Name *string

	// The version of the framework.
	Version *string

	noSmithyDocumentSerde
}

// A programming language supported by the platform.
type PlatformProgrammingLanguage struct {

	// The name of the programming language.
	Name *string

	// The version of the programming language.
	Version *string

	noSmithyDocumentSerde
}

// Summary information about a platform version.
type PlatformSummary struct {

	// The operating system used by the platform version.
	OperatingSystemName *string

	// The version of the operating system used by the platform version.
	OperatingSystemVersion *string

	// The ARN of the platform version.
	PlatformArn *string

	// The state of the platform version's branch in its lifecycle.
	//
	// Possible values: beta | supported | deprecated | retired
	PlatformBranchLifecycleState *string

	// The platform branch to which the platform version belongs.
	PlatformBranchName *string

	// The category of platform version.
	PlatformCategory *string

	// The state of the platform version in its lifecycle.
	//
	// Possible values: recommended | empty
	//
	// If an empty value is returned, the platform version is supported but isn't the
	// recommended one for its branch.
	PlatformLifecycleState *string

	// The AWS account ID of the person who created the platform version.
	PlatformOwner *string

	// The status of the platform version. You can create an environment from the
	// platform version once it is ready.
	PlatformStatus PlatformStatus

	// The version string of the platform version.
	PlatformVersion *string

	// The additions associated with the platform version.
	SupportedAddonList []string

	// The tiers in which the platform version runs.
	SupportedTierList []string

	noSmithyDocumentSerde
}

// Describes a queue.
type Queue struct {

	// The name of the queue.
	Name *string

	// The URL of the queue.
	URL *string

	noSmithyDocumentSerde
}

// The AWS Elastic Beanstalk quota information for a single resource type in an
// AWS account. It reflects the resource's limits for this account.
type ResourceQuota struct {

	// The maximum number of instances of this Elastic Beanstalk resource type that an
	// AWS account can use.
	Maximum *int32

	noSmithyDocumentSerde
}

// A set of per-resource AWS Elastic Beanstalk quotas associated with an AWS
// account. They reflect Elastic Beanstalk resource limits for this account.
type ResourceQuotas struct {

	// The quota for applications in the AWS account.
	ApplicationQuota *ResourceQuota

	// The quota for application versions in the AWS account.
	ApplicationVersionQuota *ResourceQuota

	// The quota for configuration templates in the AWS account.
	ConfigurationTemplateQuota *ResourceQuota

	// The quota for custom platforms in the AWS account.
	CustomPlatformQuota *ResourceQuota

	// The quota for environments in the AWS account.
	EnvironmentQuota *ResourceQuota

	noSmithyDocumentSerde
}

// The bucket and key of an item stored in Amazon S3.
type S3Location struct {

	// The Amazon S3 bucket where the data is located.
	S3Bucket *string

	// The Amazon S3 key where the data is located.
	S3Key *string

	noSmithyDocumentSerde
}

// Describes criteria to restrict a list of results.
//
// For operators that apply a single value to the attribute, the filter is
// evaluated as follows: Attribute Operator Values[1]
//
// Some operators, e.g. in , can apply multiple values. In this case, the filter is
// evaluated as a logical union (OR) of applications of the operator to the
// attribute with each one of the values: (Attribute Operator Values[1]) OR
// (Attribute Operator Values[2]) OR ...
//
// The valid values for attributes of SearchFilter depend on the API action. For
// valid values, see the reference page for the API action you're calling that
// takes a SearchFilter parameter.
type SearchFilter struct {

	// The result attribute to which the filter values are applied. Valid values vary
	// by API action.
	Attribute *string

	// The operator to apply to the Attribute with each of the Values . Valid values
	// vary by Attribute .
	Operator *string

	// The list of values applied to the Attribute and Operator attributes. Number of
	// values and valid values vary by Attribute .
	Values []string

	noSmithyDocumentSerde
}

// Detailed health information about an Amazon EC2 instance in your Elastic
// Beanstalk environment.
type SingleInstanceHealth struct {

	// Request metrics from your application.
	ApplicationMetrics *ApplicationMetrics

	// The availability zone in which the instance runs.
	AvailabilityZone *string

	// Represents the causes, which provide more information about the current health
	// status.
	Causes []string

	// Represents the color indicator that gives you information about the health of
	// the EC2 instance. For more information, see [Health Colors and Statuses].
	//
	// [Health Colors and Statuses]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html
	Color *string

	// Information about the most recent deployment to an instance.
	Deployment *Deployment

	// Returns the health status of the specified instance. For more information, see [Health Colors and Statuses].
	//
	// [Health Colors and Statuses]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html
	HealthStatus *string

	// The ID of the Amazon EC2 instance.
	InstanceId *string

	// The instance's type.
	InstanceType *string

	// The time at which the EC2 instance was launched.
	LaunchedAt *time.Time

	// Operating system metrics from the instance.
	System *SystemStatus

	noSmithyDocumentSerde
}

// Describes the solution stack.
type SolutionStackDescription struct {

	// The permitted file types allowed for a solution stack.
	PermittedFileTypes []string

	// The name of the solution stack.
	SolutionStackName *string

	noSmithyDocumentSerde
}

// Location of the source code for an application version.
type SourceBuildInformation struct {

	// The location of the source code, as a formatted string, depending on the value
	// of SourceRepository
	//
	//   - For CodeCommit , the format is the repository name and commit ID, separated
	//   by a forward slash. For example,
	//   my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a .
	//
	//   - For S3 , the format is the S3 bucket name and object key, separated by a
	//   forward slash. For example, my-s3-bucket/Folders/my-source-file .
	//
	// This member is required.
	SourceLocation *string

	// Location where the repository is stored.
	//
	//   - CodeCommit
	//
	//   - S3
	//
	// This member is required.
	SourceRepository SourceRepository

	// The type of repository.
	//
	//   - Git
	//
	//   - Zip
	//
	// This member is required.
	SourceType SourceType

	noSmithyDocumentSerde
}

// A specification for an environment configuration.
type SourceConfiguration struct {

	// The name of the application associated with the configuration.
	ApplicationName *string

	// The name of the configuration template.
	TemplateName *string

	noSmithyDocumentSerde
}

// Represents the percentage of requests over the last 10 seconds that resulted in
// each type of status code response. For more information, see [Status Code Definitions].
//
// [Status Code Definitions]: http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
type StatusCodes struct {

	// The percentage of requests over the last 10 seconds that resulted in a 2xx
	// (200, 201, etc.) status code.
	Status2xx *int32

	// The percentage of requests over the last 10 seconds that resulted in a 3xx
	// (300, 301, etc.) status code.
	Status3xx *int32

	// The percentage of requests over the last 10 seconds that resulted in a 4xx
	// (400, 401, etc.) status code.
	Status4xx *int32

	// The percentage of requests over the last 10 seconds that resulted in a 5xx
	// (500, 501, etc.) status code.
	Status5xx *int32

	noSmithyDocumentSerde
}

// CPU utilization and load average metrics for an Amazon EC2 instance.
type SystemStatus struct {

	// CPU utilization metrics for the instance.
	CPUUtilization *CPUUtilization

	// Load average in the last 1-minute, 5-minute, and 15-minute periods. For more
	// information, see [Operating System Metrics].
	//
	// [Operating System Metrics]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os
	LoadAverage []float64

	noSmithyDocumentSerde
}

// Describes a tag applied to a resource in an environment.
type Tag struct {

	// The key of the tag.
	Key *string

	// The value of the tag.
	Value *string

	noSmithyDocumentSerde
}

// Describes a trigger.
type Trigger struct {

	// The name of the trigger.
	Name *string

	noSmithyDocumentSerde
}

// An error or warning for a desired configuration option value.
type ValidationMessage struct {

	// A message describing the error or warning.
	Message *string

	// The namespace to which the option belongs.
	Namespace *string

	// The name of the option.
	OptionName *string

	// An indication of the severity of this message:
	//
	//   - error : This message indicates that this is not a valid setting for an
	//   option.
	//
	//   - warning : This message is providing information you should take into account.
	Severity ValidationSeverity

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
