# This script was generated by crazy-complete.
# crazy-complete: A tool that creates robust and reliable autocompletion scripts for Bash, Fish and Zsh.
# For more information, visit: https://github.com/crazy-complete/crazy-complete

function _pylint__--fail-on
  printf "%s\n" \
    invalid-name \
    disallowed-name \
    typevar-name-incorrect-variance \
    empty-docstring \
    missing-module-docstring \
    missing-class-docstring \
    missing-function-docstring \
    unnecessary-negation \
    singleton-comparison \
    unidiomatic-typecheck \
    typevar-double-variance \
    typevar-name-mismatch \
    consider-using-enumerate \
    consider-iterating-dictionary \
    bad-classmethod-argument \
    bad-mcs-method-argument \
    bad-mcs-classmethod-argument \
    single-string-used-for-slots \
    consider-using-dict-items \
    use-maxsplit-arg \
    use-sequence-for-iteration \
    consider-using-f-string \
    line-too-long \
    too-many-lines \
    trailing-whitespace \
    missing-final-newline \
    trailing-newlines \
    multiple-statements \
    superfluous-parens \
    mixed-line-endings \
    unexpected-line-ending-format \
    wrong-spelling-in-comment \
    wrong-spelling-in-docstring \
    invalid-characters-in-docstring \
    multiple-imports \
    wrong-import-order \
    ungrouped-imports \
    wrong-import-position \
    useless-import-alias \
    import-outside-toplevel \
    use-implicit-booleaness-not-len \
    use-implicit-booleaness-not-comparison \
    use-implicit-booleaness-not-comparison-to-string \
    use-implicit-booleaness-not-comparison-to-zero \
    non-ascii-name \
    non-ascii-module-import \
    bad-file-encoding \
    unnecessary-dunder-call \
    unnecessary-lambda-assignment \
    unnecessary-direct-lambda-call \
    syntax-error \
    unrecognized-inline-option \
    bad-plugin-value \
    bad-configuration-section \
    unrecognized-option \
    init-is-generator \
    return-in-init \
    function-redefined \
    not-in-loop \
    return-outside-function \
    yield-outside-function \
    nonexistent-operator \
    duplicate-argument-name \
    abstract-class-instantiated \
    bad-reversed-sequence \
    too-many-star-expressions \
    invalid-star-assignment-target \
    star-needs-assignment-target \
    nonlocal-and-global \
    continue-in-finally \
    nonlocal-without-binding \
    used-prior-global-declaration \
    misplaced-format-function \
    method-hidden \
    access-member-before-definition \
    no-method-argument \
    no-self-argument \
    invalid-slots-object \
    assigning-non-slot \
    invalid-slots \
    inherit-non-class \
    inconsistent-mro \
    duplicate-bases \
    class-variable-slots-conflict \
    invalid-class-object \
    invalid-enum-extension \
    declare-non-slot \
    non-iterator-returned \
    unexpected-special-method-signature \
    invalid-length-returned \
    invalid-bool-returned \
    invalid-index-returned \
    invalid-repr-returned \
    invalid-str-returned \
    invalid-bytes-returned \
    invalid-hash-returned \
    invalid-length-hint-returned \
    invalid-format-returned \
    invalid-getnewargs-returned \
    invalid-getnewargs-ex-returned \
    import-error \
    relative-beyond-top-level \
    used-before-assignment \
    undefined-variable \
    undefined-all-variable \
    invalid-all-object \
    invalid-all-format \
    possibly-used-before-assignment \
    no-name-in-module \
    unpacking-non-sequence \
    potential-index-error \
    bad-except-order \
    raising-bad-type \
    misplaced-bare-raise \
    bad-exception-cause \
    raising-non-exception \
    notimplemented-raised \
    catching-non-exception \
    bad-super-call \
    no-member \
    not-callable \
    assignment-from-no-return \
    no-value-for-parameter \
    too-many-function-args \
    unexpected-keyword-arg \
    redundant-keyword-arg \
    missing-kwoa \
    invalid-sequence-index \
    invalid-slice-index \
    assignment-from-none \
    not-context-manager \
    invalid-unary-operand-type \
    unsupported-binary-operation \
    repeated-keyword \
    not-an-iterable \
    not-a-mapping \
    unsupported-membership-test \
    unsubscriptable-object \
    unsupported-assignment-operation \
    unsupported-delete-operation \
    invalid-metaclass \
    dict-iter-missing-items \
    await-outside-async \
    unhashable-member \
    invalid-slice-step \
    logging-unsupported-format \
    logging-format-truncated \
    logging-too-many-args \
    logging-too-few-args \
    bad-format-character \
    truncated-format-string \
    mixed-format-string \
    format-needs-mapping \
    missing-format-string-key \
    too-many-format-args \
    too-few-format-args \
    bad-string-format-type \
    bad-str-strip-call \
    invalid-envvar-value \
    singledispatch-method \
    singledispatchmethod-function \
    yield-inside-async-function \
    not-async-context-manager \
    invalid-unicode-codec \
    bidirectional-unicode \
    invalid-character-backspace \
    invalid-character-carriage-return \
    invalid-character-sub \
    invalid-character-esc \
    invalid-character-nul \
    invalid-character-zero-width-space \
    positional-only-arguments-expected \
    invalid-field-call \
    modified-iterating-dict \
    modified-iterating-set \
    fatal \
    astroid-error \
    parse-error \
    config-parse-error \
    method-check-failed \
    raw-checker-failed \
    bad-inline-option \
    locally-disabled \
    file-ignored \
    suppressed-message \
    useless-suppression \
    deprecated-pragma \
    use-symbolic-message-instead \
    c-extension-no-member \
    useless-option-value \
    literal-comparison \
    comparison-with-itself \
    comparison-of-constants \
    no-classmethod-decorator \
    no-staticmethod-decorator \
    useless-object-inheritance \
    property-with-parameters \
    cyclic-import \
    consider-using-from-import \
    duplicate-code \
    too-many-ancestors \
    too-many-instance-attributes \
    too-few-public-methods \
    too-many-public-methods \
    too-many-return-statements \
    too-many-branches \
    too-many-arguments \
    too-many-locals \
    too-many-statements \
    too-many-boolean-expressions \
    too-many-positional-arguments \
    consider-merging-isinstance \
    too-many-nested-blocks \
    simplifiable-if-statement \
    redefined-argument-from-local \
    no-else-return \
    consider-using-ternary \
    trailing-comma-tuple \
    stop-iteration-return \
    simplify-boolean-expression \
    inconsistent-return-statements \
    useless-return \
    consider-swap-variables \
    consider-using-join \
    consider-using-in \
    consider-using-get \
    chained-comparison \
    consider-using-dict-comprehension \
    consider-using-set-comprehension \
    simplifiable-if-expression \
    no-else-raise \
    unnecessary-comprehension \
    consider-using-sys-exit \
    no-else-break \
    no-else-continue \
    super-with-arguments \
    simplifiable-condition \
    condition-evals-to-constant \
    consider-using-generator \
    use-a-generator \
    consider-using-min-builtin \
    consider-using-max-builtin \
    consider-using-with \
    unnecessary-dict-index-lookup \
    use-list-literal \
    use-dict-literal \
    unnecessary-list-index-lookup \
    use-yield-from \
    unknown-option-value \
    unreachable \
    dangerous-default-value \
    pointless-statement \
    pointless-string-statement \
    expression-not-assigned \
    unnecessary-pass \
    unnecessary-lambda \
    duplicate-key \
    useless-else-on-loop \
    exec-used \
    eval-used \
    confusing-with-statement \
    using-constant-test \
    missing-parentheses-for-call-in-test \
    self-assigning-variable \
    redeclared-assigned-name \
    assert-on-string-literal \
    duplicate-value \
    named-expr-without-context \
    pointless-exception-statement \
    return-in-finally \
    contextmanager-generator-missing-cleanup \
    comparison-with-callable \
    lost-exception \
    nan-comparison \
    assert-on-tuple \
    attribute-defined-outside-init \
    bad-staticmethod-argument \
    protected-access \
    implicit-flag-alias \
    arguments-differ \
    signature-differs \
    abstract-method \
    super-init-not-called \
    non-parent-init-called \
    invalid-overridden-method \
    arguments-renamed \
    unused-private-member \
    overridden-final-method \
    subclassed-final-class \
    redefined-slots-in-subclass \
    super-without-brackets \
    useless-parent-delegation \
    unnecessary-semicolon \
    bad-indentation \
    wildcard-import \
    reimported \
    import-self \
    preferred-module \
    misplaced-future \
    shadowed-import \
    fixme \
    global-variable-undefined \
    global-variable-not-assigned \
    global-statement \
    global-at-module-level \
    unused-import \
    unused-variable \
    unused-argument \
    unused-wildcard-import \
    redefined-outer-name \
    redefined-builtin \
    undefined-loop-variable \
    unbalanced-tuple-unpacking \
    cell-var-from-loop \
    possibly-unused-variable \
    self-cls-assignment \
    unbalanced-dict-unpacking \
    bare-except \
    duplicate-except \
    try-except-raise \
    raise-missing-from \
    binary-op-exception \
    raising-format-tuple \
    wrong-exception-operation \
    broad-exception-caught \
    broad-exception-raised \
    keyword-arg-before-vararg \
    arguments-out-of-order \
    non-str-assignment-to-dunder-name \
    isinstance-second-argument-not-valid-type \
    kwarg-superseded-by-positional-arg \
    logging-not-lazy \
    logging-format-interpolation \
    logging-fstring-interpolation \
    bad-format-string-key \
    unused-format-string-key \
    bad-format-string \
    missing-format-argument-key \
    unused-format-string-argument \
    format-combined-specification \
    missing-format-attribute \
    invalid-format-index \
    duplicate-string-formatting-argument \
    f-string-without-interpolation \
    format-string-without-interpolation \
    anomalous-backslash-in-string \
    anomalous-unicode-escape-in-string \
    implicit-str-concat \
    inconsistent-quotes \
    redundant-u-string-prefix \
    bad-open-mode \
    redundant-unittest-assert \
    bad-thread-instantiation \
    shallow-copy-environ \
    invalid-envvar-default \
    subprocess-popen-preexec-fn \
    subprocess-run-check \
    unspecified-encoding \
    forgotten-debug-statement \
    method-cache-max-size-none \
    useless-with-lock \
    unnecessary-ellipsis \
    non-ascii-file-name \
    using-f-string-in-unsupported-version \
    using-final-decorator-in-unsupported-version \
    using-exception-groups-in-unsupported-version \
    using-generic-type-syntax-in-unsupported-version \
    using-assignment-expression-in-unsupported-version \
    using-positional-only-args-in-unsupported-version \
    missing-timeout \
    nested-min-max \
    bad-chained-comparison \
    modified-iterating-list \
    deprecated-module \
    deprecated-method \
    deprecated-argument \
    deprecated-class \
    deprecated-decorator \
    deprecated-attribute \
    return-arg-in-generator \
    boolean-datetime
end

function _pylint_fish_query
  # ===========================================================================
  #
  # This function implements the parsing of options and positionals in the Fish shell.
  #
  # Usage: __fish_query <OPTIONS> <COMMAND> [ARGS...]
  #
  # The first argument is a comma-separated list of options that the parser should know about.
  # Short options (-o), long options (--option), and old-style options (-option) are supported.
  #
  # If an option takes an argument, it is suffixed by '='.
  # If an option takes an optional argument, it is suffixed by '=?'.
  #
  # For example:
  #   __fish_query '-f,--flag,-old-style,--with-arg=,--with-optional=?' [...]
  #
  #   Here, -f, --flag and -old-style don't take options, --with-arg requires an
  #   argument and --with-optional takes an optional argument.
  #
  # COMMANDS
  #   positional_contains <NUM> <WORDS...>
  #     Checks if the positional argument number NUM is one of WORDS.
  #     NUM counts from one.
  #
  #   has_option <OPTIONS...>
  #     Checks if an option given in OPTIONS is passed on commandline.
  #
  #   option_is <OPTIONS...> -- <VALUES...>
  #     Checks if any option in OPTIONS has a value of VALUES.
  #
  #   num_of_positionals [<OPERATOR> <NUMBER>]
  #     Checks the number of positional arguments.
  #     If no arguments are provided, print the total count of positional arguments.
  #     If two arguments are provided, the first argument should be one of
  #     the comparison operators: '-lt', '-le', '-eq', '-ne', '-gt', '-ge'.
  #     Returns 0 if the count of positional arguments matches the
  #     specified NUMBER according to the comparison operator, otherwise returns 1.
  #
  # ===========================================================================

  set -l positionals
  set -l having_options
  set -l option_values

  set -l options $argv[1]
  set -e argv[1]

  set -l cmd $argv[1]
  set -e argv[1]

  set -l my_cache_key "$(commandline -b) $options"

  if test "$__QUERY_CACHE_KEY" = "$my_cache_key"
    set positionals    $__QUERY_CACHE_POSITIONALS
    set having_options $__QUERY_CACHE_HAVING_OPTIONS
    set option_values  $__QUERY_CACHE_OPTION_VALUES
  else
    # =========================================================================
    # Parsing of OPTIONS argument
    # =========================================================================

    set -l short_opts_with_arg
    set -l short_opts_without_arg
    set -l short_opts_with_optional_arg
    set -l long_opts_with_arg
    set -l long_opts_without_arg
    set -l long_opts_with_optional_arg

    set -l option

    if test -n "$options"
      for option in (string split -- ',' $options)
        # Using one big switch case is the fastest way
        switch $option
          case '--?*=';   set -a long_opts_with_arg           (string replace -- '='  '' $option)
          case '--?*=\?'; set -a long_opts_with_optional_arg  (string replace -- '=?' '' $option)
          case '--?*';    set -a long_opts_without_arg        $option
          case '-?=';     set -a short_opts_with_arg          (string replace -- '='  '' $option)
          case '-?=\?';   set -a short_opts_with_optional_arg (string replace -- '=?' '' $option)
          case '-?';      set -a short_opts_without_arg       $option
        end
      end
    end

    # =========================================================================
    # Parsing of options and positionals
    # =========================================================================

    set -l cmdline (commandline -poc)
    set -l cmdline_count (count $cmdline)

    set -l argi 2 # cmdline[1] is command name
    while test $argi -le $cmdline_count
      set -l arg "$cmdline[$argi]"
      set -l have_trailing_arg (test $argi -lt $cmdline_count && echo true || echo false)

      switch $arg
        case '-'
          set -a positionals -
        case '--'
          for argi in (seq (math $argi + 1) $cmdline_count)
            set -a positionals $cmdline[$argi]
          end
          break
        case '--*=*'
          set -l split (string split -m 1 -- '=' $arg)
          set -a having_options $split[1]
          set -a option_values "$split[2]"
        case '--*'
          if contains -- $arg $long_opts_with_arg
            if $have_trailing_arg
              set -a having_options $arg
              set -a option_values $cmdline[(math $argi + 1)]
              set argi (math $argi + 1)
            end
          else
            set -a having_options $arg
            set -a option_values ""
          end
        case '-*'
          set -l end_of_parsing false

          set -l arg_length (string length -- $arg)
          set -l i 2
          while not $end_of_parsing; and test $i -le $arg_length
            set -l option "-$(string sub -s $i -l 1 -- $arg)"
            set -l trailing_chars "$(string sub -s (math $i + 1) -- $arg)"

            if contains -- $option $short_opts_without_arg
              set -a having_options $option
              set -a option_values ""
            else if contains -- $option $short_opts_with_arg
              set end_of_parsing true

              if test -n "$trailing_chars"
                set -a having_options $option
                set -a option_values $trailing_chars
              else if $have_trailing_arg
                set -a having_options $option
                set -a option_values $cmdline[(math $argi + 1)]
                set argi (math $argi + 1)
              end
            else if contains -- $option $short_opts_with_optional_arg
              set -a having_options $option
              set end_of_parsing true
              set -a option_values "$trailing_chars" # may be empty
            end

            set i (math $i + 1)
          end
        case '*'
          set -a positionals $arg
      end

      set argi (math $argi + 1)
    end

    set -g __QUERY_CACHE_POSITIONALS    $positionals
    set -g __QUERY_CACHE_HAVING_OPTIONS $having_options
    set -g __QUERY_CACHE_OPTION_VALUES  $option_values
    set -g __QUERY_CACHE_KEY            $my_cache_key
  end

  # ===========================================================================
  # Commands
  # ===========================================================================

  switch $cmd
    case 'has_option'
      for option in $having_options
        contains -- $option $argv && return 0
      end

      return 1
    case 'num_of_positionals'
      switch (count $argv)
        case 0
          count $positionals
        case 1
          echo "_pylint_fish_query: num_of_positionals: $argv[1]: missing operand" >&2
          return 1
        case 2
          if contains -- $argv[1] -lt -le -eq -ne -gt -ge;
            test (count $positionals) $argv[1] $argv[2] && return 0 || return 1
          else
            echo "_pylint_fish_query: num_of_positionals: $argv[1]: unknown operator" >&2
            return 1
          end
        case '*'
          echo "_pylint_fish_query: num_of_positionals: too many arguments" >&2
          return 1
      end
  end
end

set -l prog "pylint"
set -l query "_pylint_fish_query"

# Generally disable file completion
complete -c $prog -x

# command pylint
set -l opts "-h,--help,--rcfile=,--output=,--help-msg=,--list-msgs,--list-msgs-enabled,--list-groups,--list-conf-levels,--list-extensions,--full-documentation,--generate-rcfile,--generate-toml-config,--long-help,--init-hook=,--errors-only,-E,--verbose,-v,--enable-all-extensions,--ignore=,--ignore-patterns=,--ignore-paths=,--persistent=,--load-plugins=,--fail-under=,--fail-on=,--jobs=,-j=,--limit-inference-results=,--extension-pkg-allow-list=,--extension-pkg-whitelist=,--suggestion-mode=,--exit-zero,--from-stdin,--source-roots=,--recursive=,--py-version=,--ignored-modules=,--analyse-fallback-blocks=,--clear-cache-post-run=,--prefer-stubs=,--output-format=,-f=,--reports=,-r=,--evaluation=,--score=,-s=,--msg-template=,--confidence=,--enable=,-e=,--disable=,-d=,--min-similarity-lines=,--ignore-comments=,--ignore-docstrings=,--ignore-imports=,--ignore-signatures=,--ignore-on-opaque-inference=,--mixin-class-rgx=,--ignore-mixin-members=,--ignored-checks-for-mixins=,--ignore-none=,--ignored-classes=,--generated-members=,--contextmanager-decorators=,--missing-member-hint-distance=,--missing-member-max-choices=,--missing-member-hint=,--signature-mutators=,--notes=,--notes-rgx=,--timeout-methods=,--spelling-dict=,--spelling-ignore-words=,--spelling-private-dict-file=,--spelling-store-unknown-words=,--max-spelling-suggestions=,--spelling-ignore-comment-directives=,--max-nested-blocks=,--never-returning-functions=,--suggest-join-with-non-empty-separator=,--check-str-concat-over-line-jumps=,--check-quote-consistency=,--max-args=,--max-positional-arguments=,--max-locals=,--max-returns=,--max-branches=,--max-statements=,--max-parents=,--ignored-parents=,--max-attributes=,--min-public-methods=,--max-public-methods=,--max-bool-expr=,--exclude-too-few-public-methods=,--overgeneral-exceptions=,--defining-attr-methods=,--valid-classmethod-first-arg=,--valid-metaclass-classmethod-first-arg=,--exclude-protected=,--check-protected-access-in-special-methods=,--max-line-length=,--ignore-long-lines=,--single-line-if-stmt=,--single-line-class-stmt=,--max-module-lines=,--indent-string=,--indent-after-paren=,--expected-line-ending-format=,--good-names=,--good-names-rgxs=,--bad-names=,--bad-names-rgxs=,--name-group=,--include-naming-hint=,--property-classes=,--argument-naming-style=,--argument-rgx=,--attr-naming-style=,--attr-rgx=,--class-naming-style=,--class-rgx=,--class-attribute-naming-style=,--class-attribute-rgx=,--class-const-naming-style=,--class-const-rgx=,--const-naming-style=,--const-rgx=,--function-naming-style=,--function-rgx=,--inlinevar-naming-style=,--inlinevar-rgx=,--method-naming-style=,--method-rgx=,--module-naming-style=,--module-rgx=,--typealias-rgx=,--typevar-rgx=,--variable-naming-style=,--variable-rgx=,--no-docstring-rgx=,--docstring-min-length=,--init-import=,--dummy-variables-rgx=,--additional-builtins=,--callbacks=,--redefining-builtins-modules=,--ignored-argument-names=,--allow-global-unused-variables=,--allowed-redefined-builtins=,--deprecated-modules=,--preferred-modules=,--import-graph=,--ext-import-graph=,--int-import-graph=,--known-standard-library=,--known-third-party=,--allow-any-import-level=,--allow-wildcard-with-all=,--allow-reexport-from-package=,--logging-modules=,--logging-format-style="
set -l C000 "not $query '$opts' has_option --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C001 "not $query '$opts' has_option -h --help --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C002 "not $query '$opts' has_option -h --help --rcfile --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C003 "not $query '$opts' has_option -h --help --rcfile --output --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C004 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C005 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C006 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C007 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-extensions --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C008 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --full-documentation --generate-rcfile --generate-toml-config --long-help"
set -l C009 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --generate-rcfile --generate-toml-config --long-help"
set -l C010 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-toml-config --long-help"
set -l C011 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --long-help"
set -l C012 "not $query '$opts' has_option -h --help --rcfile --output --help-msg --list-msgs --list-msgs-enabled --list-groups --list-conf-levels --list-extensions --full-documentation --generate-rcfile --generate-toml-config"
set -l C013 "$query '$opts' num_of_positionals -ge 0"
complete -c $prog -n $C000 -s h -l help -d 'show this help message and exit' -f
complete -c $prog -n $C001 -l rcfile -d 'Specify a configuration file to load.' -Fr
complete -c $prog -n $C002 -l output -d 'Specify an output file.' -Fr
complete -c $prog -n $C003 -l help-msg -d 'Display a help message for the given message id and exit. The value may be a comma separated list of message ids.' -x
complete -c $prog -n $C004 -l list-msgs -d "Display a list of all pylint's messages divided by whether they are emittable with the given interpreter." -f
complete -c $prog -n $C005 -l list-msgs-enabled -d 'Display a list of what messages are enabled, disabled and non-emittable with the given configuration.' -f
complete -c $prog -n $C006 -l list-groups -d "List pylint's message groups." -f
complete -c $prog -n $C007 -l list-conf-levels -d "Generate pylint's confidence levels." -f
complete -c $prog -n $C008 -l list-extensions -d 'List available extensions.' -f
complete -c $prog -n $C009 -l full-documentation -d "Generate pylint's full documentation." -f
complete -c $prog -n $C010 -l generate-rcfile -d 'Generate a sample configuration file according to the current configuration. You can put other options before this one to get them in the generated configuration.' -f
complete -c $prog -n $C011 -l generate-toml-config -d 'Generate a sample configuration file according to the current configuration. You can put other options before this one to get them in the generated configuration. The config is in the .toml format.' -f
complete -c $prog -n $C012 -l long-help -d 'Show more verbose help.' -f
complete -c $prog -l init-hook -d 'Python code to execute, usually for sys.path manipulation such as pygtk.require().' -x
complete -c $prog -s E -l errors-only -d 'In error mode, messages with a category besides ERROR or FATAL are suppressed, and no reports are done by default. Error mode is compatible with disabling specific errors.' -f
complete -c $prog -s v -l verbose -d 'In verbose mode, extra non-checker-related info will be displayed.' -f
complete -c $prog -l enable-all-extensions -d 'Load and enable all available extensions. Use --list-extensions to see a list all available extensions.' -f
complete -c $prog -l ignore -d "Files or directories to be skipped. They should be base names, not paths. (default: ('CVS',))" -x
complete -c $prog -l ignore-patterns -d "Files or directories matching the regular expression patterns are skipped. The regex matches against base names, not paths. The default value ignores Emacs file locks (default: (re.compile('^\\\\.#'),))" -x
complete -c $prog -l ignore-paths -d "Add files or directories matching the regular expressions patterns to the ignore-list. The regex matches against paths and can be in Posix or Windows format. Because '\\\\' represents the directory delimiter on Windows systems, it can't be used as an escape character. (default: [])" -x
complete -c $prog -l persistent -d 'Pickle collected data for later comparisons. (default: True)' -x -a 'y n'
complete -c $prog -l load-plugins -d 'List of plugins (as comma separated values of python module names) to load, usually to register additional checkers. (default: ())' -x
complete -c $prog -l fail-under -d 'Specify a score threshold under which the program will exit with error. (default: 10)' -x
complete -c $prog -l fail-on -d 'Return non-zero exit code if any of these messages/categories are detected, even if score is above --fail-under value. Syntax same as enable. Messages specified are enabled, while categories only check already-enabled messages. (default: )' -x -a '(__fish_complete_list , _pylint__--fail-on)'
complete -c $prog -s j -l jobs -d 'Use multiple processes to speed up Pylint. Specifying 0 will auto-detect the number of processors available to use, and will cap the count on Windows to avoid hangs. (default: 1)' -x
complete -c $prog -l limit-inference-results -d 'Control the amount of potential inferred values when inferring a single object. This can help the performance when dealing with large functions or complex, nested conditions. (default: 100)' -x
complete -c $prog -l extension-pkg-allow-list -d 'A comma-separated list of package or module names from where C extensions may be loaded. Extensions are loading into the active Python interpreter and may run arbitrary code. (default: [])' -x
complete -c $prog -l extension-pkg-whitelist -d 'A comma-separated list of package or module names from where C extensions may be loaded. Extensions are loading into the active Python interpreter and may run arbitrary code. (This is an alternative name to extension-pkg-allow-list for backward compatibility.) (default: [])' -x
complete -c $prog -l suggestion-mode -d 'When enabled, pylint would attempt to guess common misconfiguration and emit user-friendly hints instead of false-positive error messages. (default: True)' -x -a 'y n'
complete -c $prog -l exit-zero -d 'Always return a 0 (non-error) status code, even if lint errors are found. This is primarily useful in continuous integration scripts. (default: False)' -f
complete -c $prog -l from-stdin -d 'Interpret the stdin as a python script, whose filename needs to be passed as the module_or_package argument. (default: False)' -f
complete -c $prog -l source-roots -d 'Add paths to the list of the source roots. Supports globbing patterns. The source root is an absolute path or a path relative to the current working directory used to determine a package namespace for modules located under the source root. (default: ())' -x
complete -c $prog -l recursive -d 'Discover python modules and packages in the file system subtree. (default: False)' -x -a 'y n'
complete -c $prog -l py-version -d 'Minimum Python version to use for version dependent checks. Will default to the version used to run pylint. (default: (3, 12))' -x
complete -c $prog -l ignored-modules -d 'List of module names for which member attributes should not be checked and will not be imported (useful for modules/projects where namespaces are manipulated during runtime and thus existing member attributes cannot be deduced by static analysis). It supports qualified module names, as well as Unix pattern matching. (default: ())' -x
complete -c $prog -l analyse-fallback-blocks -d 'Analyse import fallback blocks. This can be used to support both Python 2 and 3 compatible code, which means that the block might have code that exists only in one or another interpreter, leading to false positives when analysed. (default: False)' -x -a 'y n'
complete -c $prog -l clear-cache-post-run -d 'Clear in-memory caches upon conclusion of linting. Useful if running pylint in a server-like mode. (default: False)' -x -a 'y n'
complete -c $prog -l prefer-stubs -d 'Resolve imports to .pyi stubs if available. May reduce no-member messages and increase not-an-iterable messages. (default: False)' -x -a 'y n'
complete -c $prog -s f -l output-format -d 'Set the output format. Available formats are: text, parseable, colorized, json2 (improved json format), json (old json format) and msvs (visual studio). You can also give a reporter class, e.g. mypackage.mymodule.MyReporterClass.' -x
complete -c $prog -s r -l reports -d 'Tells whether to display a full report or only the messages. (default: False)' -x -a 'y n'
complete -c $prog -l evaluation -d "Python expression which should return a score less than or equal to 10. You have access to the variables 'fatal', 'error', 'warning', 'refactor', 'convention', and 'info' which contain the number of messages in each category, as well as 'statement' which is the total number of statements analyzed. This score is used by the global evaluation report (RP0004). (default: max(0, 0 if fatal else 10.0 - ((float(5 * error + warning + refactor + convention) / statement) * 10)))" -x
complete -c $prog -s s -l score -d 'Activate the evaluation score. (default: True)' -x -a 'y n'
complete -c $prog -l msg-template -d 'Template used to display messages. This is a python new-style format string used to format the message information. See doc for all details. (default: )' -x
complete -c $prog -l confidence -d "Only show warnings with the listed confidence levels. Leave empty to show all. Valid levels: HIGH, CONTROL_FLOW, INFERENCE, INFERENCE_FAILURE, UNDEFINED. (default: ['HIGH', 'CONTROL_FLOW', 'INFERENCE', 'INFERENCE_FAILURE', 'UNDEFINED'])" -x
complete -c $prog -s e -l enable -d 'Enable the message, report, category or checker with the given id(s). You can either give multiple identifier separated by comma (,) or put this option multiple time (only on the command line, not in the configuration file where it should appear only once). See also the "--disable" option for examples.' -x -a '(__fish_complete_list , _pylint__--fail-on)'
complete -c $prog -s d -l disable -d 'Disable the message, report, category or checker with the given id(s). You can either give multiple identifiers separated by comma (,) or put this option multiple times (only on the command line, not in the configuration file where it should appear only once). You can also use "--disable=all" to disable everything first and then re-enable specific checks. For example, if you want to run only the similarities checker, you can use "--disable=all --enable=similarities". If you want to run only the classes checker, but have no Warning level messages displayed, use "--disable=all --enable=classes --disable=W".' -x -a '(__fish_complete_list , _pylint__--fail-on)'
complete -c $prog -l min-similarity-lines -d 'Minimum lines number of a similarity. (default: 4)' -x
complete -c $prog -l ignore-comments -d 'Comments are removed from the similarity computation (default: True)' -x -a 'y n'
complete -c $prog -l ignore-docstrings -d 'Docstrings are removed from the similarity computation (default: True)' -x -a 'y n'
complete -c $prog -l ignore-imports -d 'Imports are removed from the similarity computation (default: True)' -x -a 'y n'
complete -c $prog -l ignore-signatures -d 'Signatures are removed from the similarity computation (default: True)' -x -a 'y n'
complete -c $prog -l ignore-on-opaque-inference -d 'This flag controls whether pylint should warn about no-member and similar checks whenever an opaque object is returned when inferring. The inference can return multiple potential results while evaluating a Python object, but some branches might not be evaluated, which results in partial inference. In that case, it might be useful to still emit no-member and other checks for the rest of the inferred objects. (default: True)' -x -a 'y n'
complete -c $prog -l mixin-class-rgx -d 'Regex pattern to define which classes are considered mixins. (default: .*[Mm]ixin)' -x
complete -c $prog -l ignore-mixin-members -d 'Tells whether missing members accessed in mixin class should be ignored. A class is considered mixin if its name matches the mixin-class-rgx option. (default: True)' -x -a 'y n'
complete -c $prog -l ignored-checks-for-mixins -d "List of symbolic message names to ignore for Mixin members. (default: ['no-member', 'not-async-context-manager', 'not-context-manager', 'attribute-defined-outside-init'])" -x
complete -c $prog -l ignore-none -d 'Tells whether to warn about missing members when the owner of the attribute is inferred to be None. (default: True)' -x -a 'y n'
complete -c $prog -l ignored-classes -d "List of class names for which member attributes should not be checked (useful for classes with dynamically set attributes). This supports the use of qualified names. (default: ('optparse.Values', 'thread._local', '_thread._local', 'argparse.Namespace'))" -x
complete -c $prog -l generated-members -d "List of members which are set dynamically and missed by pylint inference system, and so shouldn't trigger E1101 when accessed. Python regular expressions are accepted. (default: ())" -x
complete -c $prog -l contextmanager-decorators -d "List of decorators that produce context managers, such as contextlib.contextmanager. Add to this list to register other decorators that produce valid context managers. (default: ['contextlib.contextmanager'])" -x
complete -c $prog -l missing-member-hint-distance -d 'The minimum edit distance a name should have in order to be considered a similar match for a missing member name. (default: 1)' -x
complete -c $prog -l missing-member-max-choices -d 'The total number of similar names that should be taken in consideration when showing a hint for a missing member. (default: 1)' -x
complete -c $prog -l missing-member-hint -d 'Show a hint with possible names when a member name was not found. The aspect of finding the hint is based on edit distance. (default: True)' -x
complete -c $prog -l signature-mutators -d 'List of decorators that change the signature of a decorated function. (default: [])' -x
complete -c $prog -l notes -d "List of note tags to take in consideration, separated by a comma. (default: ('FIXME', 'XXX', 'TODO'))" -x
complete -c $prog -l notes-rgx -d 'Regular expression of note tags to take in consideration. (default: )' -x
complete -c $prog -l timeout-methods -d "List of qualified names (i.e., library.method) which require a timeout parameter e.g. 'requests.api.get,requests.api.post' (default: ('requests.api.delete', 'requests.api.get', 'requests.api.head', 'requests.api.options', 'requests.api.patch', 'requests.api.post', 'requests.api.put', 'requests.api.request'))" -x
complete -c $prog -l spelling-dict -d 'Spelling dictionary name. No available dictionaries : You need to install both the python package and the system dependency for enchant to work. (default: )' -x
complete -c $prog -l spelling-ignore-words -d 'List of comma separated words that should not be checked. (default: )' -x
complete -c $prog -l spelling-private-dict-file -d 'A path to a file that contains the private dictionary; one word per line. (default: )' -Fr
complete -c $prog -l spelling-store-unknown-words -d 'Tells whether to store unknown words to the private dictionary (see the --spelling-private-dict-file option) instead of raising a message. (default: n)' -x -a 'y n'
complete -c $prog -l max-spelling-suggestions -d 'Limits count of emitted suggestions for spelling mistakes. (default: 4)' -x
complete -c $prog -l spelling-ignore-comment-directives -d 'List of comma separated words that should be considered directives if they appear at the beginning of a comment and should not be checked. (default: fmt: on,fmt: off,noqa:,noqa,nosec,isort:skip,mypy:)' -x
complete -c $prog -l max-nested-blocks -d 'Maximum number of nested blocks for function / method body (default: 5)' -x
complete -c $prog -l never-returning-functions -d "Complete name of functions that never returns. When checking for inconsistent-return-statements if a never returning function is called then it will be considered as an explicit return statement and no message will be printed. (default: ('sys.exit', 'argparse.parse_error'))" -x
complete -c $prog -l suggest-join-with-non-empty-separator -d 'Let '"'"'consider-using-join'"'"' be raised when the separator to join on would be non-empty (resulting in expected fixes of the type: ``"- " + " - ".join(items)``) (default: True)' -x -a 'y n'
complete -c $prog -l check-str-concat-over-line-jumps -d 'This flag controls whether the implicit-str-concat should generate a warning on implicit string concatenation in sequences defined over several lines. (default: False)' -x -a 'y n'
complete -c $prog -l check-quote-consistency -d 'This flag controls whether inconsistent-quotes generates a warning when the character used as a quote delimiter is used inconsistently within a module. (default: False)' -x -a 'y n'
complete -c $prog -l max-args -d 'Maximum number of arguments for function / method. (default: 5)' -x
complete -c $prog -l max-positional-arguments -d 'Maximum number of positional arguments for function / method. (default: 5)' -x
complete -c $prog -l max-locals -d 'Maximum number of locals for function / method body. (default: 15)' -x
complete -c $prog -l max-returns -d 'Maximum number of return / yield for function / method body. (default: 6)' -x
complete -c $prog -l max-branches -d 'Maximum number of branch for function / method body. (default: 12)' -x
complete -c $prog -l max-statements -d 'Maximum number of statements in function / method body. (default: 50)' -x
complete -c $prog -l max-parents -d 'Maximum number of parents for a class (see R0901). (default: 7)' -x
complete -c $prog -l ignored-parents -d 'List of qualified class names to ignore when counting class parents (see R0901) (default: ())' -x
complete -c $prog -l max-attributes -d 'Maximum number of attributes for a class (see R0902). (default: 7)' -x
complete -c $prog -l min-public-methods -d 'Minimum number of public methods for a class (see R0903). (default: 2)' -x
complete -c $prog -l max-public-methods -d 'Maximum number of public methods for a class (see R0904). (default: 20)' -x
complete -c $prog -l max-bool-expr -d 'Maximum number of boolean expressions in an if statement (see R0916). (default: 5)' -x
complete -c $prog -l exclude-too-few-public-methods -d 'List of regular expressions of class ancestor names to ignore when counting public methods (see R0903) (default: [])' -x
complete -c $prog -l overgeneral-exceptions -d "Exceptions that will emit a warning when caught. (default: ('builtins.BaseException', 'builtins.Exception'))" -x
complete -c $prog -l defining-attr-methods -d "List of method names used to declare (i.e. assign) instance attributes. (default: ('__init__', '__new__', 'setUp', 'asyncSetUp', '__post_init__'))" -x
complete -c $prog -l valid-classmethod-first-arg -d "List of valid names for the first argument in a class method. (default: ('cls',))" -x
complete -c $prog -l valid-metaclass-classmethod-first-arg -d "List of valid names for the first argument in a metaclass class method. (default: ('mcs',))" -x
complete -c $prog -l exclude-protected -d "List of member names, which should be excluded from the protected access warning. (default: ('_asdict', '_fields', '_replace', '_source', '_make', 'os._exit'))" -x
complete -c $prog -l check-protected-access-in-special-methods -d 'Warn about protected attribute access inside special methods (default: False)' -x -a 'y n'
complete -c $prog -l max-line-length -d 'Maximum number of characters on a single line. (default: 100)' -x
complete -c $prog -l ignore-long-lines -d 'Regexp for a line that is allowed to be longer than the limit. (default: ^\s*(# )?<?https?://\S+>?$)' -x
complete -c $prog -l single-line-if-stmt -d 'Allow the body of an if to be on the same line as the test if there is no else. (default: False)' -x -a 'y n'
complete -c $prog -l single-line-class-stmt -d 'Allow the body of a class to be on the same line as the declaration if body contains single statement. (default: False)' -x -a 'y n'
complete -c $prog -l max-module-lines -d 'Maximum number of lines in a module. (default: 1000)' -x
complete -c $prog -l indent-string -d 'String used as indentation unit. This is usually " " (4 spaces) or "\t" (1 tab). (default: )' -x
complete -c $prog -l indent-after-paren -d 'Number of spaces of indent required inside a hanging or continued line. (default: 4)' -x
complete -c $prog -l expected-line-ending-format -d 'Expected format of line ending, e.g. empty (any line ending), LF or CRLF. (default: )' -x
complete -c $prog -l good-names -d "Good variable names which should always be accepted, separated by a comma. (default: ('i', 'j', 'k', 'ex', 'Run', '_'))" -x
complete -c $prog -l good-names-rgxs -d 'Good variable names regexes, separated by a comma. If names match any regex, they will always be accepted (default: )' -x
complete -c $prog -l bad-names -d "Bad variable names which should always be refused, separated by a comma. (default: ('foo', 'bar', 'baz', 'toto', 'tutu', 'tata'))" -x
complete -c $prog -l bad-names-rgxs -d 'Bad variable names regexes, separated by a comma. If names match any regex, they will always be refused (default: )' -x
complete -c $prog -l name-group -d "Colon-delimited sets of names that determine each other's naming style when the name regexes allow several styles. (default: ())" -x
complete -c $prog -l include-naming-hint -d 'Include a hint for the correct naming format with invalid-name. (default: False)' -x -a 'y n'
complete -c $prog -l property-classes -d "List of decorators that produce properties, such as abc.abstractproperty. Add to this list to register other decorators that produce valid properties. These decorators are taken in consideration only for invalid-name. (default: ('abc.abstractproperty',))" -x
complete -c $prog -l argument-naming-style -d 'Naming style matching correct argument names. (default: snake_case)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l argument-rgx -d 'Regular expression matching correct argument names. Overrides argument-naming-style. If left empty, argument names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l attr-naming-style -d 'Naming style matching correct attribute names. (default: snake_case)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l attr-rgx -d 'Regular expression matching correct attribute names. Overrides attr-naming-style. If left empty, attribute names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l class-naming-style -d 'Naming style matching correct class names. (default: PascalCase)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l class-rgx -d 'Regular expression matching correct class names. Overrides class-naming-style. If left empty, class names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l class-attribute-naming-style -d 'Naming style matching correct class attribute names. (default: any)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l class-attribute-rgx -d 'Regular expression matching correct class attribute names. Overrides class-attribute-naming-style. If left empty, class attribute names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l class-const-naming-style -d 'Naming style matching correct class constant names. (default: UPPER_CASE)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l class-const-rgx -d 'Regular expression matching correct class constant names. Overrides class-const-naming-style. If left empty, class constant names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l const-naming-style -d 'Naming style matching correct constant names. (default: UPPER_CASE)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l const-rgx -d 'Regular expression matching correct constant names. Overrides const-naming-style. If left empty, constant names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l function-naming-style -d 'Naming style matching correct function names. (default: snake_case)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l function-rgx -d 'Regular expression matching correct function names. Overrides function-naming-style. If left empty, function names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l inlinevar-naming-style -d 'Naming style matching correct inline iteration names. (default: any)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l inlinevar-rgx -d 'Regular expression matching correct inline iteration names. Overrides inlinevar-naming-style. If left empty, inline iteration names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l method-naming-style -d 'Naming style matching correct method names. (default: snake_case)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l method-rgx -d 'Regular expression matching correct method names. Overrides method-naming-style. If left empty, method names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l module-naming-style -d 'Naming style matching correct module names. (default: snake_case)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l module-rgx -d 'Regular expression matching correct module names. Overrides module-naming-style. If left empty, module names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l typealias-rgx -d 'Regular expression matching correct type alias names. If left empty, type alias names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l typevar-rgx -d 'Regular expression matching correct type variable names. If left empty, type variable names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l variable-naming-style -d 'Naming style matching correct variable names. (default: snake_case)' -x -a 'snake_case camelCase PascalCase UPPER_CASE any'
complete -c $prog -l variable-rgx -d 'Regular expression matching correct variable names. Overrides variable-naming-style. If left empty, variable names will be checked with the set naming style. (default: None)' -x
complete -c $prog -l no-docstring-rgx -d "Regular expression which should only match function or class names that do not require a docstring. (default: re.compile('^_'))" -x
complete -c $prog -l docstring-min-length -d 'Minimum line length for functions/classes that require docstrings, shorter ones are exempt. (default: -1)' -x
complete -c $prog -l init-import -d 'Tells whether we should check for unused import in __init__ files. (default: False)' -x -a 'y n'
complete -c $prog -l dummy-variables-rgx -d 'A regular expression matching the name of dummy variables (i.e. expected to not be used). (default: _+$|(_[a-zA-Z0-9_]*[a-zA-Z0-9]+?$)|dummy|^ignored_|^unused_)' -x
complete -c $prog -l additional-builtins -d 'List of additional names supposed to be defined in builtins. Remember that you should avoid defining new builtins when possible. (default: ())' -x
complete -c $prog -l callbacks -d "List of strings which can identify a callback function by name. A callback name must start or end with one of those strings. (default: ('cb_', '_cb'))" -x
complete -c $prog -l redefining-builtins-modules -d "List of qualified module names which can have objects that can redefine builtins. (default: ('six.moves', 'past.builtins', 'future.builtins', 'builtins', 'io'))" -x
complete -c $prog -l ignored-argument-names -d "Argument names that match this expression will be ignored. (default: re.compile('_.*|^ignored_|^unused_'))" -x
complete -c $prog -l allow-global-unused-variables -d 'Tells whether unused global variables should be treated as a violation. (default: True)' -x -a 'y n'
complete -c $prog -l allowed-redefined-builtins -d 'List of names allowed to shadow builtins (default: ())' -x
complete -c $prog -l deprecated-modules -d 'Deprecated modules which should not be used, separated by a comma. (default: ())' -x
complete -c $prog -l preferred-modules -d 'Couples of modules and preferred modules, separated by a comma. (default: ())' -x
complete -c $prog -l import-graph -d 'Output a graph (.gv or any supported image format) of all (i.e. internal and external) dependencies to the given file (report RP0402 must not be disabled). (default: )' -Fr
complete -c $prog -l ext-import-graph -d 'Output a graph (.gv or any supported image format) of external dependencies to the given file (report RP0402 must not be disabled). (default: )' -Fr
complete -c $prog -l int-import-graph -d 'Output a graph (.gv or any supported image format) of internal dependencies to the given file (report RP0402 must not be disabled). (default: )' -Fr
complete -c $prog -l known-standard-library -d 'Force import order to recognize a module as part of the standard compatibility libraries. (default: ())' -x
complete -c $prog -l known-third-party -d "Force import order to recognize a module as part of a third party library. (default: ('enchant',))" -x
complete -c $prog -l allow-any-import-level -d 'List of modules that can be imported at any level, not just the top level one. (default: ())' -x
complete -c $prog -l allow-wildcard-with-all -d 'Allow wildcard imports from modules that define __all__. (default: False)' -x -a 'y n'
complete -c $prog -l allow-reexport-from-package -d 'Allow explicit reexports by alias from a package __init__. (default: False)' -x -a 'y n'
complete -c $prog -l logging-modules -d "Logging modules to check that the string format arguments are in logging function parameter format. (default: ('logging',))" -x
complete -c $prog -l logging-format-style -d 'The type of string formatting that logging methods do. `old` means using % formatting, `new` is for `{}` formatting. (default: old)' -x -a 'new old'
complete -c $prog -n $C013 -Fr

# vim: ft=fish ts=2 sts=2 sw=2 et