# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Show(AAZCommand):
    """Get the status of a VM scale set instance.
    """

    _aaz_info = {
        "version": "2024-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/virtualmachinescalesets/{}/instanceview", "2024-11-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.vm_scale_set_name = AAZStrArg(
            options=["--vm-scale-set-name"],
            help="The name of the VM scale set.",
            required=True,
            id_part="name",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualMachineScaleSetsGetInstanceView(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualMachineScaleSetsGetInstanceView(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/instanceView",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "vmScaleSetName", self.ctx.args.vm_scale_set_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2024-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.extensions = AAZListType(
                flags={"read_only": True},
            )
            _schema_on_200.orchestration_services = AAZListType(
                serialized_name="orchestrationServices",
                flags={"read_only": True},
            )
            _schema_on_200.statuses = AAZListType()
            _schema_on_200.virtual_machine = AAZObjectType(
                serialized_name="virtualMachine",
                flags={"read_only": True},
            )

            extensions = cls._schema_on_200.extensions
            extensions.Element = AAZObjectType()

            _element = cls._schema_on_200.extensions.Element
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.statuses_summary = AAZListType(
                serialized_name="statusesSummary",
                flags={"read_only": True},
            )

            statuses_summary = cls._schema_on_200.extensions.Element.statuses_summary
            statuses_summary.Element = AAZObjectType()
            _ShowHelper._build_schema_virtual_machine_status_code_count_read(statuses_summary.Element)

            orchestration_services = cls._schema_on_200.orchestration_services
            orchestration_services.Element = AAZObjectType()

            _element = cls._schema_on_200.orchestration_services.Element
            _element.service_name = AAZStrType(
                serialized_name="serviceName",
                flags={"read_only": True},
            )
            _element.service_state = AAZStrType(
                serialized_name="serviceState",
                flags={"read_only": True},
            )

            statuses = cls._schema_on_200.statuses
            statuses.Element = AAZObjectType()

            _element = cls._schema_on_200.statuses.Element
            _element.code = AAZStrType()
            _element.display_status = AAZStrType(
                serialized_name="displayStatus",
            )
            _element.level = AAZStrType()
            _element.message = AAZStrType()
            _element.time = AAZStrType()

            virtual_machine = cls._schema_on_200.virtual_machine
            virtual_machine.statuses_summary = AAZListType(
                serialized_name="statusesSummary",
                flags={"read_only": True},
            )

            statuses_summary = cls._schema_on_200.virtual_machine.statuses_summary
            statuses_summary.Element = AAZObjectType()
            _ShowHelper._build_schema_virtual_machine_status_code_count_read(statuses_summary.Element)

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""

    _schema_virtual_machine_status_code_count_read = None

    @classmethod
    def _build_schema_virtual_machine_status_code_count_read(cls, _schema):
        if cls._schema_virtual_machine_status_code_count_read is not None:
            _schema.code = cls._schema_virtual_machine_status_code_count_read.code
            _schema.count = cls._schema_virtual_machine_status_code_count_read.count
            return

        cls._schema_virtual_machine_status_code_count_read = _schema_virtual_machine_status_code_count_read = AAZObjectType()

        virtual_machine_status_code_count_read = _schema_virtual_machine_status_code_count_read
        virtual_machine_status_code_count_read.code = AAZStrType(
            flags={"read_only": True},
        )
        virtual_machine_status_code_count_read.count = AAZIntType(
            flags={"read_only": True},
        )

        _schema.code = cls._schema_virtual_machine_status_code_count_read.code
        _schema.count = cls._schema_virtual_machine_status_code_count_read.count


__all__ = ["Show"]
