# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher flow-log create",
)
class Create(AAZCommand):
    """Create a flow log on a network security group.

    :example: Create a flow log with Network Security Group name
        az network watcher flow-log create --location westus --resource-group MyResourceGroup --name MyFlowLog --nsg MyNetworkSecurityGroupName --storage-account account

    :example: Create a flow log with VNet name
        az network watcher flow-log create --location westus --resource-group MyResourceGroup --name MyFlowLog --vnet MyVNetName --storage-account account

    :example: Create a flow log with Subnet name
        az network watcher flow-log create --location westus --resource-group MyResourceGroup --name MyFlowLog --vnet MyVNetName --subnet MySubnetName --storage-account account

    :example: Create a flow log with NIC name
        az network watcher flow-log create --location westus --resource-group MyResourceGroup --name MyFlowLog --nic MyNICName --storage-account account

    :example: Create a flow log with Network Security Group ID (could be in other resource group)
        az network watcher flow-log create --location westus --name MyFlowLog --nsg MyNetworkSecurityGroupID --storage-account account

    :example: Create a flow log with Virtual Network ID (could be in other resource group)
        az network watcher flow-log create --location westus --name MyFlowLog --vnet MyVNetID --storage-account account

    :example: Create a flow log with Subnet ID (could be in other resource group)
        az network watcher flow-log create --location westus --name MyFlowLog --subnet SubnetID --storage-account account

    :example: Create a flow log with Network Interface ID (could be in other resource group)
        az network watcher flow-log create --location westus --name MyFlowLog --nic MyNetworkInterfaceID --storage-account account

    :example: Create or update flow log
        az network watcher flow-log create --location westus --resource-group MtRGContainingVNet --name MyVNetName-flowlog --vnet MyVNetName --storage-account MyStorageAccountName  --filtering-criteria "dstip=20.252.145.59 || DstPort=443"

    :example: Create flow log with recordtypes filtering
        az network watcher flow-log create --resource-group rg1 --network-watcher-name nw1 --name fl --location centraluseuap --target-resource-id /subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg --storage-account /subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe --filtering-criteria srcIP=158.255.7.8 || dstPort=56891 --record-types B,E --enabled True --format JSON --log-version 1 --identity "{type:UserAssigned,user-assigned-identities:{/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1:{}}}"
    """

    _aaz_info = {
        "version": "2025-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/flowlogs/{}", "2025-03-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the flow logger.",
            required=True,
        )
        _args_schema.network_watcher_name = AAZStrArg(
            options=["--network-watcher-name"],
            help="The name of the network watcher.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location to identify the exclusive Network Watcher under a region. Only one Network Watcher can be existed per subscription and region.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.enabled = AAZBoolArg(
            options=["--enabled"],
            help="Enable logging. Default: true.",
        )
        _args_schema.storage_account = AAZStrArg(
            options=["--storage-account"],
            help="Name or ID of the storage account in which to save the flow logs.                                Must be in the same region of flow log.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use \"\" to clear                                existing tags.",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Format"

        _args_schema = cls._args_schema
        _args_schema.format = AAZStrArg(
            options=["--format"],
            arg_group="Format",
            help="File type of the flow log.",
            enum={"JSON": "JSON"},
        )
        _args_schema.log_version = AAZIntArg(
            options=["--log-version"],
            arg_group="Format",
            help="Version (revision) of the flow log.",
            default=0,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.identity = AAZObjectArg(
            options=["--identity"],
            arg_group="Parameters",
            help="FlowLog resource Managed Identity",
        )

        identity = cls._args_schema.identity
        identity.mi_system_assigned = AAZStrArg(
            options=["system-assigned", "mi-system-assigned"],
            help="Set the system managed identity.",
            blank="True",
        )
        identity.type = AAZStrArg(
            options=["type"],
            help="The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.",
            enum={"None": "None", "SystemAssigned": "SystemAssigned", "SystemAssigned, UserAssigned": "SystemAssigned, UserAssigned", "UserAssigned": "UserAssigned"},
        )
        identity.mi_user_assigned = AAZListArg(
            options=["user-assigned", "mi-user-assigned"],
            help="Set the user managed identities.",
            blank=[],
        )
        identity.user_assigned_identities = AAZDictArg(
            options=["user-assigned-identities"],
            help="The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.",
        )

        mi_user_assigned = cls._args_schema.identity.mi_user_assigned
        mi_user_assigned.Element = AAZStrArg()

        user_assigned_identities = cls._args_schema.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectArg(
            blank={},
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.filtering_criteria = AAZStrArg(
            options=["--filtering-criteria"],
            arg_group="Properties",
            help="Optional field to filter flowlogs based on SrcIP, SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all flowlogs will be logged.",
        )
        _args_schema.flow_analytics_configuration = AAZObjectArg(
            options=["--flow-analytics-configuration"],
            arg_group="Properties",
            help="Parameters that define the configuration of traffic analytics.",
        )
        _args_schema.record_types = AAZStrArg(
            options=["--record-types"],
            arg_group="Properties",
            help="Optional field to filter network traffic logs based on flow states. Value of this field could be any comma separated combination string of letters B,C,E or D. B represents Begin, when a flow is created. C represents Continue for an ongoing flow generated at every five-minute interval. E represents End, when a flow is terminated. D represents Deny, when a flow is denied. If not specified, all network traffic will be logged.",
        )
        _args_schema.retention_policy = AAZObjectArg(
            options=["--retention-policy"],
            arg_group="Properties",
            help="Parameters that define the retention policy for flow log.",
        )
        _args_schema.target_resource_id = AAZStrArg(
            options=["--target-resource-id"],
            arg_group="Properties",
            help="ID of network security group to which flow log will be applied.",
        )

        flow_analytics_configuration = cls._args_schema.flow_analytics_configuration
        flow_analytics_configuration.enabled = AAZBoolArg(
            options=["enabled"],
            help="Flag to enable/disable traffic analytics.",
        )
        flow_analytics_configuration.traffic_analytics_interval = AAZIntArg(
            options=["traffic-analytics-interval"],
            help="The interval in minutes which would decide how frequently TA service should do flow analytics.",
        )
        flow_analytics_configuration.workspace_id = AAZStrArg(
            options=["workspace-id"],
            help="The resource guid of the attached workspace.",
        )
        flow_analytics_configuration.workspace_region = AAZStrArg(
            options=["workspace-region"],
            help="The location of the attached workspace.",
        )
        flow_analytics_configuration.workspace_resource_id = AAZStrArg(
            options=["workspace-resource-id"],
            help="Resource Id of the attached workspace.",
        )

        retention_policy = cls._args_schema.retention_policy
        retention_policy.days = AAZIntArg(
            options=["days"],
            help="Number of days to retain flow log records.",
            default=0,
        )
        retention_policy.enabled = AAZBoolArg(
            options=["enabled"],
            help="Flag to enable/disable retention.",
            default=False,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.FlowLogsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class FlowLogsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "flowLogName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.network_watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("identity", AAZIdentityObjectType, ".identity")
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            identity = _builder.get(".identity")
            if identity is not None:
                identity.set_prop("type", AAZStrType, ".type")
                identity.set_prop("userAssignedIdentities", AAZDictType, ".user_assigned_identities")
                identity.set_prop("userAssigned", AAZListType, ".mi_user_assigned", typ_kwargs={"flags": {"action": "create"}})
                identity.set_prop("systemAssigned", AAZStrType, ".mi_system_assigned", typ_kwargs={"flags": {"action": "create"}})

            user_assigned_identities = _builder.get(".identity.userAssignedIdentities")
            if user_assigned_identities is not None:
                user_assigned_identities.set_elements(AAZObjectType, ".")

            user_assigned = _builder.get(".identity.userAssigned")
            if user_assigned is not None:
                user_assigned.set_elements(AAZStrType, ".")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("enabled", AAZBoolType, ".enabled")
                properties.set_prop("enabledFilteringCriteria", AAZStrType, ".filtering_criteria")
                properties.set_prop("flowAnalyticsConfiguration", AAZObjectType, ".flow_analytics_configuration")
                properties.set_prop("format", AAZObjectType)
                properties.set_prop("recordTypes", AAZStrType, ".record_types")
                properties.set_prop("retentionPolicy", AAZObjectType, ".retention_policy")
                properties.set_prop("storageId", AAZStrType, ".storage_account", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("targetResourceId", AAZStrType, ".target_resource_id", typ_kwargs={"flags": {"required": True}})

            flow_analytics_configuration = _builder.get(".properties.flowAnalyticsConfiguration")
            if flow_analytics_configuration is not None:
                flow_analytics_configuration.set_prop("networkWatcherFlowAnalyticsConfiguration", AAZObjectType)

            network_watcher_flow_analytics_configuration = _builder.get(".properties.flowAnalyticsConfiguration.networkWatcherFlowAnalyticsConfiguration")
            if network_watcher_flow_analytics_configuration is not None:
                network_watcher_flow_analytics_configuration.set_prop("enabled", AAZBoolType, ".enabled")
                network_watcher_flow_analytics_configuration.set_prop("trafficAnalyticsInterval", AAZIntType, ".traffic_analytics_interval")
                network_watcher_flow_analytics_configuration.set_prop("workspaceId", AAZStrType, ".workspace_id")
                network_watcher_flow_analytics_configuration.set_prop("workspaceRegion", AAZStrType, ".workspace_region")
                network_watcher_flow_analytics_configuration.set_prop("workspaceResourceId", AAZStrType, ".workspace_resource_id")

            format = _builder.get(".properties.format")
            if format is not None:
                format.set_prop("type", AAZStrType, ".format")
                format.set_prop("version", AAZIntType, ".log_version")

            retention_policy = _builder.get(".properties.retentionPolicy")
            if retention_policy is not None:
                retention_policy.set_prop("days", AAZIntType, ".days")
                retention_policy.set_prop("enabled", AAZBoolType, ".enabled")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.identity = AAZIdentityObjectType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200_201.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200_201.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200_201.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.enabled = AAZBoolType()
            properties.enabled_filtering_criteria = AAZStrType(
                serialized_name="enabledFilteringCriteria",
            )
            properties.flow_analytics_configuration = AAZObjectType(
                serialized_name="flowAnalyticsConfiguration",
            )
            properties.format = AAZObjectType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.record_types = AAZStrType(
                serialized_name="recordTypes",
            )
            properties.retention_policy = AAZObjectType(
                serialized_name="retentionPolicy",
            )
            properties.storage_id = AAZStrType(
                serialized_name="storageId",
                flags={"required": True},
            )
            properties.target_resource_guid = AAZStrType(
                serialized_name="targetResourceGuid",
                flags={"read_only": True},
            )
            properties.target_resource_id = AAZStrType(
                serialized_name="targetResourceId",
                flags={"required": True},
            )

            flow_analytics_configuration = cls._schema_on_200_201.properties.flow_analytics_configuration
            flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
                serialized_name="networkWatcherFlowAnalyticsConfiguration",
            )

            network_watcher_flow_analytics_configuration = cls._schema_on_200_201.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
            network_watcher_flow_analytics_configuration.enabled = AAZBoolType()
            network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
                serialized_name="trafficAnalyticsInterval",
            )
            network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
                serialized_name="workspaceId",
            )
            network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
                serialized_name="workspaceRegion",
            )
            network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
                serialized_name="workspaceResourceId",
            )

            format = cls._schema_on_200_201.properties.format
            format.type = AAZStrType()
            format.version = AAZIntType()

            retention_policy = cls._schema_on_200_201.properties.retention_policy
            retention_policy.days = AAZIntType()
            retention_policy.enabled = AAZBoolType()

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
