/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.HuffEntry;
import com.jcraft.jogg.Buffer;

public class Huffman {
    public static final int NUM_HUFF_TABLES = 80;
    public static final int DC_HUFF_OFFSET = 0;
    public static final int AC_HUFF_OFFSET = 16;
    public static final int AC_TABLE_2_THRESH = 5;
    public static final int AC_TABLE_3_THRESH = 14;
    public static final int AC_TABLE_4_THRESH = 27;
    public static final int DC_HUFF_CHOICES = 16;
    public static final int DC_HUFF_CHOICE_BITS = 4;
    public static final int AC_HUFF_CHOICES = 16;
    public static final int AC_HUFF_CHOICE_BITS = 4;
    public static final int MAX_SINGLE_TOKEN_VALUE = 6;
    public static final int DCT_VAL_CAT2_MIN = 3;
    public static final int DCT_VAL_CAT3_MIN = 7;
    public static final int DCT_VAL_CAT4_MIN = 9;
    public static final int DCT_VAL_CAT5_MIN = 13;
    public static final int DCT_VAL_CAT6_MIN = 21;
    public static final int DCT_VAL_CAT7_MIN = 37;
    public static final int DCT_VAL_CAT8_MIN = 69;
    public static final int DCT_EOB_TOKEN = 0;
    public static final int DCT_EOB_PAIR_TOKEN = 1;
    public static final int DCT_EOB_TRIPLE_TOKEN = 2;
    public static final int DCT_REPEAT_RUN_TOKEN = 3;
    public static final int DCT_REPEAT_RUN2_TOKEN = 4;
    public static final int DCT_REPEAT_RUN3_TOKEN = 5;
    public static final int DCT_REPEAT_RUN4_TOKEN = 6;
    public static final int DCT_SHORT_ZRL_TOKEN = 7;
    public static final int DCT_ZRL_TOKEN = 8;
    public static final int ONE_TOKEN = 9;
    public static final int MINUS_ONE_TOKEN = 10;
    public static final int TWO_TOKEN = 11;
    public static final int MINUS_TWO_TOKEN = 12;
    public static final int LOW_VAL_TOKENS = 13;
    public static final int DCT_VAL_CATEGORY3 = 17;
    public static final int DCT_VAL_CATEGORY4 = 18;
    public static final int DCT_VAL_CATEGORY5 = 19;
    public static final int DCT_VAL_CATEGORY6 = 20;
    public static final int DCT_VAL_CATEGORY7 = 21;
    public static final int DCT_VAL_CATEGORY8 = 22;
    public static final int DCT_RUN_CATEGORY1 = 23;
    public static final int DCT_RUN_CATEGORY1B = 28;
    public static final int DCT_RUN_CATEGORY1C = 29;
    public static final int DCT_RUN_CATEGORY2 = 30;
    public static final int MAX_ENTROPY_TOKENS = 32;

    private static void createHuffmanList(HuffEntry[] huffEntryArray, int n, short[] sArray) {
        huffEntryArray[n] = new HuffEntry();
        huffEntryArray[n].previous = null;
        huffEntryArray[n].next = null;
        huffEntryArray[n].Child[0] = null;
        huffEntryArray[n].Child[1] = null;
        huffEntryArray[n].value = 0;
        huffEntryArray[n].frequency = sArray[0];
        if (huffEntryArray[n].frequency == 0) {
            huffEntryArray[n].frequency = 1;
        }
        int n2 = 1;
        while (n2 < 32) {
            HuffEntry huffEntry = new HuffEntry();
            huffEntry.value = n2;
            huffEntry.frequency = sArray[n2];
            huffEntry.Child[0] = null;
            huffEntry.Child[1] = null;
            if (huffEntry.frequency == 0) {
                huffEntry.frequency = 1;
            }
            if (huffEntry.frequency <= huffEntryArray[n].frequency) {
                huffEntry.next = huffEntryArray[n];
                huffEntryArray[n].previous = huffEntry;
                huffEntry.previous = null;
                huffEntryArray[n] = huffEntry;
            } else {
                HuffEntry huffEntry2 = huffEntryArray[n];
                while (huffEntry2.next != null && huffEntry2.frequency < huffEntry.frequency) {
                    huffEntry2 = huffEntry2.next;
                }
                if (huffEntry2.frequency < huffEntry.frequency) {
                    huffEntry.next = null;
                    huffEntry.previous = huffEntry2;
                    huffEntry2.next = huffEntry;
                } else {
                    huffEntry.next = huffEntry2;
                    huffEntry.previous = huffEntry2.previous;
                    huffEntry2.previous.next = huffEntry;
                    huffEntry2.previous = huffEntry;
                }
            }
            ++n2;
        }
    }

    private static void createCodeArray(HuffEntry huffEntry, int[] nArray, byte[] byArray, int n, byte by) {
        if (huffEntry.Child[0] == null && huffEntry.Child[1] == null) {
            nArray[huffEntry.value] = n;
            byArray[huffEntry.value] = by;
        } else {
            by = (byte)(by + 1);
            Huffman.createCodeArray(huffEntry.Child[0], nArray, byArray, (n << 1) + 0, by);
            Huffman.createCodeArray(huffEntry.Child[1], nArray, byArray, (n << 1) + 1, by);
        }
    }

    public static void buildHuffmanTree(HuffEntry[] huffEntryArray, int[] nArray, byte[] byArray, int n, short[] sArray) {
        Huffman.createHuffmanList(huffEntryArray, n, sArray);
        while (huffEntryArray[n].next != null) {
            HuffEntry huffEntry = new HuffEntry();
            huffEntry.value = -1;
            huffEntry.frequency = huffEntryArray[n].frequency + huffEntryArray[n].next.frequency;
            huffEntry.Child[0] = huffEntryArray[n];
            huffEntry.Child[1] = huffEntryArray[n].next;
            if (huffEntry.Child[1].next != null) {
                huffEntryArray[n] = huffEntry.Child[1].next;
                huffEntryArray[n].previous = null;
                if (huffEntry.frequency <= huffEntryArray[n].frequency) {
                    huffEntry.next = huffEntryArray[n];
                    huffEntryArray[n].previous = huffEntry;
                    huffEntry.previous = null;
                    huffEntryArray[n] = huffEntry;
                } else {
                    HuffEntry huffEntry2 = huffEntryArray[n];
                    while (huffEntry2.next != null && huffEntry2.frequency < huffEntry.frequency) {
                        huffEntry2 = huffEntry2.next;
                    }
                    if (huffEntry2.frequency < huffEntry.frequency) {
                        huffEntry.next = null;
                        huffEntry.previous = huffEntry2;
                        huffEntry2.next = huffEntry;
                    } else {
                        huffEntry.next = huffEntry2;
                        huffEntry.previous = huffEntry2.previous;
                        huffEntry2.previous.next = huffEntry;
                        huffEntry2.previous = huffEntry;
                    }
                }
            } else {
                huffEntry.next = null;
                huffEntry.previous = null;
                huffEntryArray[n] = huffEntry;
            }
            huffEntry.Child[0].next = null;
            huffEntry.Child[0].previous = null;
            huffEntry.Child[1].next = null;
            huffEntry.Child[1].previous = null;
        }
        Huffman.createCodeArray(huffEntryArray[n], nArray, byArray, 0, (byte)0);
    }

    public static int readHuffmanTrees(HuffEntry[] huffEntryArray, Buffer buffer) {
        int n = 0;
        while (n < 80) {
            huffEntryArray[n] = new HuffEntry();
            int n2 = huffEntryArray[n].read(0, buffer);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public static void clearHuffmanTrees(HuffEntry[] huffEntryArray) {
        int n = 0;
        while (n < 80) {
            huffEntryArray[n] = null;
            ++n;
        }
    }
}

