#ifndef ACE_CONFIG_INTEGRITY_COMMON_H
#define ACE_CONFIG_INTEGRITY_COMMON_H

#define ACE_INTEGRITY

#define ACE_LACKS_GETPGID
#define ACE_LACKS_SETPGID
#define ACE_LACKS_SETREUID
#define ACE_LACKS_SETREGID
#define ACE_LACKS_SETSID
#define ACE_LACKS_GETEGID
#define ACE_LACKS_SETEGID
#define ACE_LACKS_GETUID
#define ACE_LACKS_SETUID
#define ACE_LACKS_GETEUID
#define ACE_LACKS_SETEUID
#define ACE_LACKS_GETGID

#define ACE_MT_SAFE 1
#define ACE_HAS_THREADS
#define ACE_MAX_NUM_THREADS 64

#define ACE_HAS_STRERROR
#define ACE_HAS_SIG_ATOMIC_T

#define ACE_HAS_SIGINFO_T
#define ACE_LACKS_SIGINFO_H
#define ACE_LACKS_UCONTEXT_H
#define ACE_HAS_SIG_C_FUNC
#define ACE_LACKS_SI_ADDR

#ifndef ACE_LACKS_POSIX
# define ACE_HAS_POSIX_NONBLOCK
#endif
#define ACE_HAS_DIRENT

#define ACE_PAGE_SIZE 4096
#define ACE_IOCTL_TYPE_ARG2 unsigned long

#define ACE_LACKS_KEY_T

#define ACE_LACKS_ISCTYPE
#define ACE_LACKS_WCSICMP
#define ACE_LACKS_WCSNICMP
#define ACE_LACKS_WCSDUP
#define ACE_LACKS_WCSTOK
#define ACE_LACKS_ALPHASORT
#define ACE_LACKS_ITOW
#define ACE_LACKS_SUSECONDS_T
#define ACE_LACKS_USECONDS_T
#define ACE_HAS_POSIX_TIME
#define ACE_HAS_STRDUP_EMULATION
#define ACE_HAS_MSG
#define ACE_LACKS_CONDATTR_PSHARED
#define ACE_LACKS_MUTEXATTR_PSHARED
#define ACE_LACKS_RLIMIT
#define ACE_LACKS_COND_T
#define ACE_LACKS_RWLOCK_T
#define ACE_LACKS_SEMBUF_T
#define ACE_LACKS_UNIX_DOMAIN_SOCKETS
#define ACE_LACKS_NETDB_REENTRANT_FUNCTIONS
#define ACE_LACKS_PIPE
#define ACE_LACKS_SYS_PARAM_H
#define ACE_LACKS_SYS_MSG_H
#define ACE_LACKS_PWD_FUNCTIONS
#define ACE_LACKS_UNIX_SIGNALS
#define ACE_LACKS_SYSV_SHMEM
#define ACE_LACKS_PUTENV
#define ACE_HAS_4_4BSD_SENDMSG_RECVMSG
#define ACE_LACKS_THREAD_PROCESS_SCOPING
#define ACE_LACKS_SETSCHED
#define ACE_LACKS_STRRECVFD
#define ACE_LACKS_SYSCONF

#define ACE_LACKS_REALPATH
#define ACE_LACKS_SWAB
#define ACE_HAS_CONSISTENT_SIGNAL_PROTOTYPES

/***** Not tied to standards AFAIK ****/
#define ACE_LACKS_MADVISE /* paging optimization not needed with INTEGRITY */
#define ACE_LACKS_INTTYPES_H
#define ACE_LACKS_SYS_RESOURCE_H
#define ACE_LACKS_SEARCH_H
#define ACE_LACKS_SYS_IPC_H
#define ACE_LACKS_SYS_SEM_H
#define ACE_LACKS_STROPTS_H
#define ACE_LACKS_SYS_SHM_H

#define ACE_LACKS_IOSTREAM_TOTALLY

#include <INTEGRITY.h>

typedef void (*__sighandler_t) (int);

#ifdef ppc
# define ACE_HAS_POWERPC_TIMER
#endif

#define ACE_HAS_NONCONST_SELECT_TIMEVAL
#define ACE_LACKS_READLINK
#define ACE_LACKS_GETPPID
#define ACE_LACKS_CUSERID

#define ACE_DEFAULT_THREAD_PRIORITY 127
#define PRI_FIFO_MIN 1
#define PRI_FIFO_MAX 127
#define ACE_THR_PRI_FIFO_DEF 127
#define PRI_RR_MIN 1
#define PRI_RR_MAX 127
#define ACE_THR_PRI_RR_DEF 127
#define PRI_OTHER_MIN 1
#define PRI_OTHER_MAX 127
#define ACE_THR_PRI_OTHER_DEF 127
#undef ACE_LACKS_UNLINK

#define ACE_HAS_TIMED_MESSAGE_BLOCKS

#define ACE_LACKS_UNIX_SYSLOG
#define ACE_LACKS_TELLDIR
#define ACE_LACKS_SEEKDIR
#define ACE_LACKS_GETHOSTENT

#if !_HAS_EXCEPTIONS
# define ACE_STD_ALLOCATOR_NOTHROW
#endif

// When config.h defines ACE_NO_GHS_LIBIO, the functions provided by the
// INTEGRITY-178 Low-Level I/O Library (libio_178b_be.a) are not called by ACE.
#ifdef ACE_NO_GHS_LIBIO
# define ACE_LACKS_ACCESS
# define ACE_LACKS_CHDIR
# define ACE_LACKS_CLOSE
# define ACE_LACKS_CLOSEDIR
# define ACE_LACKS_CREAT
# define ACE_LACKS_FSYNC
# define ACE_LACKS_GETCWD
# define ACE_LACKS_LSEEK
# define ACE_LACKS_MKDIR
# define ACE_LACKS_OPEN
# define ACE_LACKS_OPENDIR
# define ACE_LACKS_READ
# define ACE_LACKS_READDIR
# define ACE_LACKS_READDIR_R
# define ACE_LACKS_RENAME
# define ACE_LACKS_REWINDDIR
# define ACE_LACKS_RMDIR
# define ACE_LACKS_UNLINK
# define ACE_LACKS_WRITE
#endif

#endif
