/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import uk.me.nxg.unity.FunctionDefinitionInSyntax;
import uk.me.nxg.unity.FunctionDefinitionMap;

public class FunctionDefinition
implements Comparable<FunctionDefinition> {
    private final String description;
    private final String latexForm;
    private final String name;

    FunctionDefinition(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("FunctionDefinition must have non-null initialisers: " + string + "/" + string2 + "/" + string3);
        }
        this.description = string;
        this.latexForm = string2;
        this.name = string3;
        assert (string != null && string2 != null);
    }

    public String description() {
        return this.description;
    }

    public String latexForm() {
        return this.latexForm;
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public String toString() {
        return '<' + this.description + '>';
    }

    public String name() {
        return null;
    }

    public String fallbackName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof FunctionDefinition) {
            return this.compareTo((FunctionDefinition)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(FunctionDefinition functionDefinition) {
        assert (this.description != null);
        assert (functionDefinition.description != null);
        return this.description.compareTo(functionDefinition.description);
    }

    static class Maker {
        final FunctionDefinitionMap.Resolver functionResolver;

        Maker(FunctionDefinitionMap.Resolver resolver) {
            this.functionResolver = resolver;
        }

        public FunctionDefinition make(String string) {
            FunctionDefinition functionDefinition = this.functionResolver.getFunctionDefinition(string);
            if (functionDefinition == null) {
                return null;
            }
            String string2 = this.functionResolver.getFunctionName(functionDefinition);
            if (string2 == null) {
                return functionDefinition;
            }
            return new FunctionDefinitionInSyntax(functionDefinition.description(), functionDefinition.latexForm(), string2);
        }
    }
}

