/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management;

import org.jboss.managed.api.ComponentType;

/**
 * A collection of enums for the well known component types.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 75075 $
 */
public interface KnownComponentTypes
{
   /**
    * Enums for the DataSource types
    */
   public enum DataSourceTypes
   {
      XA("DataSource", "XA"), LocalTx("DataSource", "LocalTx"), NoTx("DataSource", "NoTx");

      private final String type;
      private final String subtype;
      private DataSourceTypes(String type, String subtype)
      {
         this.type = type;
         this.subtype = subtype;
      }

      public String type()
      {
         return type;
      }
      public String subtype()
      {
         return subtype;
      }
      public ComponentType getType()
      {
         return new ComponentType(type, subtype);
      }
   };

   /**
    * Enums for generic ConnectionFactory types
    */
   public enum ConnectionFactoryTypes
   {
      XA("ConnectionFactory", "XA"), NoTx("ConnectionFactory", "NoTx");

      private final String type;
      private final String subtype;
      private ConnectionFactoryTypes(String type, String subtype)
      {
         this.type = type;
         this.subtype = subtype;
      }

      public String type()
      {
         return type;
      }
      public String subtype()
      {
         return subtype;
      }
      public ComponentType getType()
      {
         return new ComponentType(type, subtype);
      }
   };

   /**
    * Enums for the JMSDestination/{Queue,Topic,DurableTopic} types
    */
   public enum JMSDestination
   {
      Queue("JMSDestination", "Queue"), Topic("JMSDestination", "Topic"),
      DurableTopic("DataSource", "DurableTopic");

      private final String type;
      private final String subtype;
      private JMSDestination(String type, String subtype)
      {
         this.type = type;
         this.subtype = subtype;
      }

      public String type()
      {
         return type;
      }
      public String subtype()
      {
         return subtype;
      }
      public ComponentType getType()
      {
         return new ComponentType(type, subtype);
      }
   };

   /**
    * Enums for the EJB/{StatelessSession,StatefulSession,Entity,MDB} types
    */
   public enum EJB
   {
      StatelessSession("EJB", "StatelessSession"),
      StatefulSession("EJB", "StatefulSession"),
      Entity("EJB", "Entity"),
      MDB("EJB", "MDB");

      private final String type;
      private final String subtype;
      private EJB(String type, String subtype)
      {
         this.type = type;
         this.subtype = subtype;
      }

      public String type()
      {
         return type;
      }
      public String subtype()
      {
         return subtype;
      }
      public ComponentType getType()
      {
         return new ComponentType(type, subtype);
      }
   };

   /**
    * Enums for the MBean/{Dynamic,Standard,Model,Open,Persistent,XMBean} types
    */
   public enum MBean
   {
      Dynamic("MBean", "StatelessSession"),
      Standard("MBean", "Standard"),
      Model("MBean", "Model"),
      Open("MBean", "Open"),
      Persistent("MBean", "Persistent"),
      XMBean("MBean", "XMBean");

      private final String type;
      private final String subtype;
      private MBean(String type, String subtype)
      {
         this.type = type;
         this.subtype = subtype;
      }

      public String type()
      {
         return type;
      }
      public String subtype()
      {
         return subtype;
      }
      public ComponentType getType()
      {
         return new ComponentType(type, subtype);
      }
   };

   /**
    * Enums for the MCBean types
    */
   public enum MCBean
   {
      Any("MCBean", "*");

      private final String type;
      private final String subtype;
      private MCBean(String type, String subtype)
      {
         this.type = type;
         this.subtype = subtype;
      }

      public String type()
      {
         return type;
      }
      public String subtype()
      {
         return subtype;
      }
      public ComponentType getType()
      {
         return new ComponentType(type, subtype);
      }
   }
}
