/* SPDX-License-Identifier: GPL-2.0-or-later OR BSD-3-Clause */
/*
 * Copyright (C) 2022, STMicroelectronics - All Rights Reserved
 *
 * Configuration settings for the STM32MP13x CPU
 */

#ifndef STM32MP13_RCC_H
#define STM32MP13_RCC_H

/* RCC registers */
#define RCC_SECCFGR			0x0
#define RCC_MP_SREQSETR			0x100
#define RCC_MP_SREQCLRR			0x104
#define RCC_MP_APRSTCR			0x108
#define RCC_MP_APRSTSR			0x10c
#define RCC_PWRLPDLYCR			0x110
#define RCC_MP_GRSTCSETR		0x114
#define RCC_BR_RSTSCLRR			0x118
#define RCC_MP_RSTSSETR			0x11c
#define RCC_MP_RSTSCLRR			0x120
#define RCC_MP_IWDGFZSETR		0x124
#define RCC_MP_IWDGFZCLRR		0x128
#define RCC_MP_CIER			0x200
#define RCC_MP_CIFR			0x204
#define RCC_BDCR			0x400
#define RCC_RDLSICR			0x404
#define RCC_OCENSETR			0x420
#define RCC_OCENCLRR			0x424
#define RCC_OCRDYR			0x428
#define RCC_HSICFGR			0x440
#define RCC_CSICFGR			0x444
#define RCC_MCO1CFGR			0x460
#define RCC_MCO2CFGR			0x464
#define RCC_DBGCFGR			0x468
#define RCC_RCK12SELR			0x480
#define RCC_RCK3SELR			0x484
#define RCC_RCK4SELR			0x488
#define RCC_PLL1CR			0x4a0
#define RCC_PLL1CFGR1			0x4a4
#define RCC_PLL1CFGR2			0x4a8
#define RCC_PLL1FRACR			0x4ac
#define RCC_PLL1CSGR			0x4b0
#define RCC_PLL2CR			0x4d0
#define RCC_PLL2CFGR1			0x4d4
#define RCC_PLL2CFGR2			0x4d8
#define RCC_PLL2FRACR			0x4dc
#define RCC_PLL2CSGR			0x4e0
#define RCC_PLL3CR			0x500
#define RCC_PLL3CFGR1			0x504
#define RCC_PLL3CFGR2			0x508
#define RCC_PLL3FRACR			0x50c
#define RCC_PLL3CSGR			0x510
#define RCC_PLL4CR			0x520
#define RCC_PLL4CFGR1			0x524
#define RCC_PLL4CFGR2			0x528
#define RCC_PLL4FRACR			0x52c
#define RCC_PLL4CSGR			0x530
#define RCC_MPCKSELR			0x540
#define RCC_ASSCKSELR			0x544
#define RCC_MSSCKSELR			0x548
#define RCC_CPERCKSELR			0x54c
#define RCC_RTCDIVR			0x560
#define RCC_MPCKDIVR			0x564
#define RCC_AXIDIVR			0x568
#define RCC_MLAHBDIVR			0x56c
#define RCC_APB1DIVR			0x570
#define RCC_APB2DIVR			0x574
#define RCC_APB3DIVR			0x578
#define RCC_APB4DIVR			0x57c
#define RCC_APB5DIVR			0x580
#define RCC_APB6DIVR			0x584
#define RCC_TIMG1PRER			0x5a0
#define RCC_TIMG2PRER			0x5a4
#define RCC_TIMG3PRER			0x5a8
#define RCC_DDRITFCR			0x5c0
#define RCC_I2C12CKSELR			0x600
#define RCC_I2C345CKSELR		0x604
#define RCC_SPI2S1CKSELR		0x608
#define RCC_SPI2S23CKSELR		0x60c
#define RCC_SPI45CKSELR			0x610
#define RCC_UART12CKSELR		0x614
#define RCC_UART35CKSELR		0x618
#define RCC_UART4CKSELR			0x61c
#define RCC_UART6CKSELR			0x620
#define RCC_UART78CKSELR		0x624
#define RCC_LPTIM1CKSELR		0x628
#define RCC_LPTIM23CKSELR		0x62c
#define RCC_LPTIM45CKSELR		0x630
#define RCC_SAI1CKSELR			0x634
#define RCC_SAI2CKSELR			0x638
#define RCC_FDCANCKSELR			0x63c
#define RCC_SPDIFCKSELR			0x640
#define RCC_ADC12CKSELR			0x644
#define RCC_SDMMC12CKSELR		0x648
#define RCC_ETH12CKSELR			0x64c
#define RCC_USBCKSELR			0x650
#define RCC_QSPICKSELR			0x654
#define RCC_FMCCKSELR			0x658
#define RCC_RNG1CKSELR			0x65c
#define RCC_STGENCKSELR			0x660
#define RCC_DCMIPPCKSELR		0x664
#define RCC_SAESCKSELR			0x668
#define RCC_APB1RSTSETR			0x6a0
#define RCC_APB1RSTCLRR			0x6a4
#define RCC_APB2RSTSETR			0x6a8
#define RCC_APB2RSTCLRR			0x6ac
#define RCC_APB3RSTSETR			0x6b0
#define RCC_APB3RSTCLRR			0x6b4
#define RCC_APB4RSTSETR			0x6b8
#define RCC_APB4RSTCLRR			0x6bc
#define RCC_APB5RSTSETR			0x6c0
#define RCC_APB5RSTCLRR			0x6c4
#define RCC_APB6RSTSETR			0x6c8
#define RCC_APB6RSTCLRR			0x6cc
#define RCC_AHB2RSTSETR			0x6d0
#define RCC_AHB2RSTCLRR			0x6d4
#define RCC_AHB4RSTSETR			0x6e0
#define RCC_AHB4RSTCLRR			0x6e4
#define RCC_AHB5RSTSETR			0x6e8
#define RCC_AHB5RSTCLRR			0x6ec
#define RCC_AHB6RSTSETR			0x6f0
#define RCC_AHB6RSTCLRR			0x6f4
#define RCC_MP_APB1ENSETR		0x700
#define RCC_MP_APB1ENCLRR		0x704
#define RCC_MP_APB2ENSETR		0x708
#define RCC_MP_APB2ENCLRR		0x70c
#define RCC_MP_APB3ENSETR		0x710
#define RCC_MP_APB3ENCLRR		0x714
#define RCC_MP_S_APB3ENSETR		0x718
#define RCC_MP_S_APB3ENCLRR		0x71c
#define RCC_MP_NS_APB3ENSETR		0x720
#define RCC_MP_NS_APB3ENCLRR		0x724
#define RCC_MP_APB4ENSETR		0x728
#define RCC_MP_APB4ENCLRR		0x72c
#define RCC_MP_S_APB4ENSETR		0x730
#define RCC_MP_S_APB4ENCLRR		0x734
#define RCC_MP_NS_APB4ENSETR		0x738
#define RCC_MP_NS_APB4ENCLRR		0x73c
#define RCC_MP_APB5ENSETR		0x740
#define RCC_MP_APB5ENCLRR		0x744
#define RCC_MP_APB6ENSETR		0x748
#define RCC_MP_APB6ENCLRR		0x74c
#define RCC_MP_AHB2ENSETR		0x750
#define RCC_MP_AHB2ENCLRR		0x754
#define RCC_MP_AHB4ENSETR		0x760
#define RCC_MP_AHB4ENCLRR		0x764
#define RCC_MP_S_AHB4ENSETR		0x768
#define RCC_MP_S_AHB4ENCLRR		0x76c
#define RCC_MP_NS_AHB4ENSETR		0x770
#define RCC_MP_NS_AHB4ENCLRR		0x774
#define RCC_MP_AHB5ENSETR		0x778
#define RCC_MP_AHB5ENCLRR		0x77c
#define RCC_MP_AHB6ENSETR		0x780
#define RCC_MP_AHB6ENCLRR		0x784
#define RCC_MP_S_AHB6ENSETR		0x788
#define RCC_MP_S_AHB6ENCLRR		0x78c
#define RCC_MP_NS_AHB6ENSETR		0x790
#define RCC_MP_NS_AHB6ENCLRR		0x794
#define RCC_MP_APB1LPENSETR		0x800
#define RCC_MP_APB1LPENCLRR		0x804
#define RCC_MP_APB2LPENSETR		0x808
#define RCC_MP_APB2LPENCLRR		0x80c
#define RCC_MP_APB3LPENSETR		0x810
#define RCC_MP_APB3LPENCLRR		0x814
#define RCC_MP_S_APB3LPENSETR		0x818
#define RCC_MP_S_APB3LPENCLRR		0x81c
#define RCC_MP_NS_APB3LPENSETR		0x820
#define RCC_MP_NS_APB3LPENCLRR		0x824
#define RCC_MP_APB4LPENSETR		0x828
#define RCC_MP_APB4LPENCLRR		0x82c
#define RCC_MP_S_APB4LPENSETR		0x830
#define RCC_MP_S_APB4LPENCLRR		0x834
#define RCC_MP_NS_APB4LPENSETR		0x838
#define RCC_MP_NS_APB4LPENCLRR		0x83c
#define RCC_MP_APB5LPENSETR		0x840
#define RCC_MP_APB5LPENCLRR		0x844
#define RCC_MP_APB6LPENSETR		0x848
#define RCC_MP_APB6LPENCLRR		0x84c
#define RCC_MP_AHB2LPENSETR		0x850
#define RCC_MP_AHB2LPENCLRR		0x854
#define RCC_MP_AHB4LPENSETR		0x858
#define RCC_MP_AHB4LPENCLRR		0x85c
#define RCC_MP_S_AHB4LPENSETR		0x868
#define RCC_MP_S_AHB4LPENCLRR		0x86c
#define RCC_MP_NS_AHB4LPENSETR		0x870
#define RCC_MP_NS_AHB4LPENCLRR		0x874
#define RCC_MP_AHB5LPENSETR		0x878
#define RCC_MP_AHB5LPENCLRR		0x87c
#define RCC_MP_AHB6LPENSETR		0x880
#define RCC_MP_AHB6LPENCLRR		0x884
#define RCC_MP_S_AHB6LPENSETR		0x888
#define RCC_MP_S_AHB6LPENCLRR		0x88c
#define RCC_MP_NS_AHB6LPENSETR		0x890
#define RCC_MP_NS_AHB6LPENCLRR		0x894
#define RCC_MP_S_AXIMLPENSETR		0x898
#define RCC_MP_S_AXIMLPENCLRR		0x89c
#define RCC_MP_NS_AXIMLPENSETR		0x8a0
#define RCC_MP_NS_AXIMLPENCLRR		0x8a4
#define RCC_MP_MLAHBLPENSETR		0x8a8
#define RCC_MP_MLAHBLPENCLRR		0x8ac
#define RCC_APB3SECSR			0x8c0
#define RCC_APB4SECSR			0x8c4
#define RCC_APB5SECSR			0x8c8
#define RCC_APB6SECSR			0x8cc
#define RCC_AHB2SECSR			0x8d0
#define RCC_AHB4SECSR			0x8d4
#define RCC_AHB5SECSR			0x8d8
#define RCC_AHB6SECSR			0x8dc
#define RCC_VERR			0xff4
#define RCC_IDR				0xff8
#define RCC_SIDR			0xffc

/* RCC_SECCFGR register fields */
#define RCC_SECCFGR_MCO1SECF		22
#define RCC_SECCFGR_MCO2SECF		23

/* RCC_APB3SECSR register fields */
#define RCC_APB3SECSR_LPTIM2SECF	0
#define RCC_APB3SECSR_LPTIM3SECF	1
#define RCC_APB3SECSR_VREFSECF		13

/* RCC_APB4SECSR register fields */
#define RCC_APB4SECSR_DCMIPPSECF	1
#define RCC_APB4SECSR_USBPHYSECF	16

/* RCC_APB5SECSR register fields */
#define RCC_APB5SECSR_RTCSECF		8
#define RCC_APB5SECSR_TZCSECF		11
#define RCC_APB5SECSR_ETZPCSECF		13
#define RCC_APB5SECSR_IWDG1SECF		15
#define RCC_APB5SECSR_BSECSECF		16
#define RCC_APB5SECSR_STGENCSECF	20
#define RCC_APB5SECSR_STGENROSECF	21

/* RCC_APB6SECSR register fields */
#define RCC_APB6SECSR_USART1SECF        0
#define RCC_APB6SECSR_USART2SECF	1
#define RCC_APB6SECSR_SPI4SECF		2
#define RCC_APB6SECSR_SPI5SECF		3
#define RCC_APB6SECSR_I2C3SECF		4
#define RCC_APB6SECSR_I2C4SECF		5
#define RCC_APB6SECSR_I2C5SECF		6
#define RCC_APB6SECSR_TIM12SECF		7
#define RCC_APB6SECSR_TIM13SECF		8
#define RCC_APB6SECSR_TIM14SECF		9
#define RCC_APB6SECSR_TIM15SECF		10
#define RCC_APB6SECSR_TIM16SECF		11
#define RCC_APB6SECSR_TIM17SECF		12

/* RCC_AHB2SECSR register fields */
#define RCC_AHB2SECSR_DMA3SECF		3
#define RCC_AHB2SECSR_DMAMUX2SECF	4
#define RCC_AHB2SECSR_ADC1SECF		5
#define RCC_AHB2SECSR_ADC2SECF		6
#define RCC_AHB2SECSR_USBOSECF		8

/* RCC_AHB4SECSR register fields */
#define RCC_AHB4SECSR_TSCSECF		15

/* RCC_AHB5SECSR register fields */
#define RCC_AHB5SECSR_PKASECF		2
#define RCC_AHB5SECSR_SAESSECF		3
#define RCC_AHB5SECSR_CRYP1SECF		4
#define RCC_AHB5SECSR_HASH1SECF		5
#define RCC_AHB5SECSR_RNG1SECF		6
#define RCC_AHB5SECSR_BKPSRAMSECF	8

/* RCC_AHB6SECSR register fields */
#define RCC_AHB6SECSR_MCESECF		1
#define RCC_AHB6SECSR_FMCSECF		12
#define RCC_AHB6SECSR_QSPISECF		14
#define RCC_AHB6SECSR_SDMMC1SECF	16
#define RCC_AHB6SECSR_SDMMC2SECF	17

#define RCC_AHB6SECSR_ETH1CKSECF	7
#define RCC_AHB6SECSR_ETH1TXSECF	8
#define RCC_AHB6SECSR_ETH1RXSECF	9
#define RCC_AHB6SECSR_ETH1MACSECF	10
#define RCC_AHB6SECSR_ETH1STPSECF	11

#define RCC_AHB6SECSR_ETH2CKSECF	27
#define RCC_AHB6SECSR_ETH2TXSECF	28
#define RCC_AHB6SECSR_ETH2RXSECF	29
#define RCC_AHB6SECSR_ETH2MACSECF	30
#define RCC_AHB6SECSR_ETH2STPSECF	31

/* Fields of RCC_BDCR register */
#define RCC_BDCR_LSEON			BIT(0)
#define RCC_BDCR_LSEBYP			BIT(1)
#define RCC_BDCR_LSERDY			BIT(2)
#define RCC_BDCR_DIGBYP			BIT(3)
#define RCC_BDCR_LSEDRV_MASK		GENMASK(5, 4)
#define RCC_BDCR_LSEDRV_SHIFT		4
#define RCC_BDCR_LSECSSON		BIT(8)
#define RCC_BDCR_RTCCKEN		BIT(20)
#define RCC_BDCR_RTCSRC_MASK		GENMASK(17, 16)
#define RCC_BDCR_RTCSRC_SHIFT		16

/* Fields of RCC_RDLSICR register */
#define RCC_RDLSICR_LSION		BIT(0)
#define RCC_RDLSICR_LSIRDY		BIT(1)

/* used for ALL PLLNCR registers */
#define RCC_PLLNCR_PLLON		BIT(0)
#define RCC_PLLNCR_PLLRDY		BIT(1)
#define RCC_PLLNCR_SSCG_CTRL		BIT(2)
#define RCC_PLLNCR_DIVPEN		BIT(4)
#define RCC_PLLNCR_DIVQEN		BIT(5)
#define RCC_PLLNCR_DIVREN		BIT(6)
#define RCC_PLLNCR_DIVEN_SHIFT		4

/* used for ALL PLLNCFGR1 registers */
#define RCC_PLLNCFGR1_DIVM_SHIFT	16
#define RCC_PLLNCFGR1_DIVM_MASK		GENMASK(21, 16)
#define RCC_PLLNCFGR1_DIVN_SHIFT	0
#define RCC_PLLNCFGR1_DIVN_MASK		GENMASK(8, 0)
/* only for PLL3 and PLL4 */
#define RCC_PLLNCFGR1_IFRGE_SHIFT	24
#define RCC_PLLNCFGR1_IFRGE_MASK	GENMASK(25, 24)

/* used for ALL PLLNCFGR2 registers , using stm32mp1_div_id */
#define RCC_PLLNCFGR2_SHIFT(div_id)	((div_id) * 8)
#define RCC_PLLNCFGR2_DIVX_MASK		GENMASK(6, 0)
#define RCC_PLLNCFGR2_DIVP_SHIFT	RCC_PLLNCFGR2_SHIFT(_DIV_P)
#define RCC_PLLNCFGR2_DIVP_MASK		GENMASK(6, 0)
#define RCC_PLLNCFGR2_DIVQ_SHIFT	RCC_PLLNCFGR2_SHIFT(_DIV_Q)
#define RCC_PLLNCFGR2_DIVQ_MASK		GENMASK(14, 8)
#define RCC_PLLNCFGR2_DIVR_SHIFT	RCC_PLLNCFGR2_SHIFT(_DIV_R)
#define RCC_PLLNCFGR2_DIVR_MASK		GENMASK(22, 16)

/* used for ALL PLLNFRACR registers */
#define RCC_PLLNFRACR_FRACV_SHIFT	3
#define RCC_PLLNFRACR_FRACV_MASK	GENMASK(15, 3)
#define RCC_PLLNFRACR_FRACLE		BIT(16)

/* used for ALL PLLNCSGR registers */
#define RCC_PLLNCSGR_INC_STEP_SHIFT	16
#define RCC_PLLNCSGR_INC_STEP_MASK	GENMASK(30, 16)
#define RCC_PLLNCSGR_MOD_PER_SHIFT	0
#define RCC_PLLNCSGR_MOD_PER_MASK	GENMASK(12, 0)
#define RCC_PLLNCSGR_SSCG_MODE_SHIFT	15
#define RCC_PLLNCSGR_SSCG_MODE_MASK	BIT(15)

/* used for RCC_OCENSETR and RCC_OCENCLRR registers */
#define RCC_OCENR_HSION			BIT(0)
#define RCC_OCENR_CSION			BIT(4)
#define RCC_OCENR_DIGBYP		BIT(7)
#define RCC_OCENR_HSEON			BIT(8)
#define RCC_OCENR_HSEBYP		BIT(10)
#define RCC_OCENR_HSECSSON		BIT(11)

/* Fields of RCC_OCRDYR register */
#define RCC_OCRDYR_HSIRDY		BIT(0)
#define RCC_OCRDYR_HSIDIVRDY		BIT(2)
#define RCC_OCRDYR_CSIRDY		BIT(4)
#define RCC_OCRDYR_HSERDY		BIT(8)

/* Fields of DDRITFCR register */
#define RCC_DDRITFCR_DDRCKMOD_MASK	GENMASK(22, 20)
#define RCC_DDRITFCR_DDRCKMOD_SHIFT	20
#define RCC_DDRITFCR_DDRCKMOD_SSR	0

/* Fields of RCC_HSICFGR register */
#define RCC_HSICFGR_HSIDIV_MASK		GENMASK(1, 0)

/* used for MCO related operations */
#define RCC_MCOCFG_MCOON		BIT(12)
#define RCC_MCOCFG_MCODIV_MASK		GENMASK(7, 4)
#define RCC_MCOCFG_MCODIV_SHIFT		4
#define RCC_MCOCFG_MCOSRC_MASK		GENMASK(2, 0)

/* used for most of SELR register */
#define RCC_SELR_SRC_MASK	GENMASK(2, 0)
#define RCC_SELR_SRCRDY		BIT(31)

/* used for most of DIVR register : max div for RTC */
#define RCC_DIVR_DIV_MASK	GENMASK(5, 0)
#define RCC_DIVR_DIVRDY		BIT(31)

#endif /* STM32MP13_RCC_H */
