//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that operators may be (directly) recursive.

struct base {
	int i;
};

base base_variable;

base operator+ (base& left, base& right)
{
	base ret_val;

	ret_val.i = left.i + right.i;
	return ret_val;
}

base operator- (base& left, int right)
{
	base ret_val;

	ret_val.i = left.i - right;
	return ret_val;
}

// Define the unary ! operator for class base to be the fibonachi
// operator.

base operator! (base& right)
{
	if (right.i < 2)
		return right;
	else
		return ((!(right-1)) + (!(right-2)));
}

int main ()
{
	base k;

	k.i = 15;
	k = !k;		// fib it!
	return (k.i != 610);
}
