//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to create an object of a given type
// vai an (explicitly or implicitly) call to the "default" constructor
// for the type if that default constructor was declared within the
// private part of the type.
//
// Cases:
//	constructor with no arguments
//	constructor with all defautable arguments

class class1 {
	int member;
	class1 ();
public:
	class1 (int i);
};

class class2 {
	int member;
	class2 (int i = 22, int j = 33);
public:
	class2 (float f, float g);
};

class1 global_class1_object;			// ERROR
class2 global_class2_object;			// ERROR

class1* c1p;
class2* c2p;

int test ()
{
	class1 local_class1_object;		// ERROR
	class2 local_class2_object;		// ERROR

	c1p = new class1;			// ERROR
	c2p = new class2;			// ERROR

	c1p = &local_class1_object;		// avoid warnings
	c2p = &local_class2_object;		// avoid warnings

	return 0;
}
