//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that attempts to get the address of overloaded functions
// and member functions are illegal if the type of the value required
// by the context of of the address expression is *not* sufficient
// to disambiguate (i.e. to specify) a particular one of the overloaded
// instances.

overload function;

int function (int i, int j);
int function (float x, float y);

class base {
public:
	int member (int i, int j);
	int member (float i, float j);
	int test ();
};

int test ()
{
	void* vp;

	vp = (void*) function;		// ERROR
	vp = (void*) &function;		// ERROR

	vp = function;			// ERROR
	vp = &function;			// ERROR

	return 0;
}

int base::test ()
{
	void* vp;

	vp = (void*) member;		// ERROR
	vp = (void*) &member;		// ERROR

	vp = member;			// ERROR
	vp = &member;			// ERROR

	return 0;
}
