//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that the scope of types defined within formal parameter
// lists is "file scope".
//
// Note that this conflicts with ANSI C, wherein such types are
// assigned "function prototype scope".

void function_1a (enum E_1a { Evalue_1a } p) {		// OK - E_1a has file scope
							//  this differs from ANSI C
	p = p;
}

void function_1b (struct S_1b { int Sfield_1b; } p) {	// OK - S_1b has file scope
							//  this differs from ANSI C
	p = p;
}

void function_1c (union U_1c { int Ufield_1c; } p) {	// OK - U_1c has file scope
							//  this differs from ANSI C
	p = p;
}

void function_2a (enum { Evalue_2a } p) {		// OK ??
	p = p;
}

void function_2b (struct { int Sfield_2b; } p) {	// OK - but calls are impossible
	p = p;
}

void function_2c (union { int Ufield_2c; } p) {		// OK - but calls are impossible
	p = p;
}

int main ()
{
	enum E_1a e_1a;					// OK
	struct S_1b s_1b;				// OK
	union U_1c u_1c;				// OK

	function_1a (e_1a);				// OK
	function_1b (s_1b);				// OK
	function_1c (u_1c);				// OK

	function_2a (Evalue_2a);			// OK
	return 0;
}
