//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that goto's can be used even if they would cause transfers into,
// out of, or around blocks.
//
// Note that these tests assume that the following rules (not yet
// approved) apply to goto statements.  These rules are designed to
// assure that a one-to-one correspondence between constructor executions
// and destructor executions is maintained.  The rules are also designed
// to insure that initializations for all types of objects are never "skipped".
//  
//  -----------------------------------------------------------------------
//  DEFINITION:  The block which most closely contains both a given goto
//  statement and its destination label is known as the "containment" block
//  of the given goto statement.
//  
//  DEFINITION: An "auto initialization" is an object declaration for a local
//  (storage class auto) object (either a const or a variable) which includes
//  (either explicitly or implicitly) an initialization.  The initialization
//  may consist of an (explicit or implicit) invocation of a constructor
//  (either explicitly called for by an actual argument list or implicitly
//  called for in the case of a call to a default constructor) or it may consist
//  of equal sign followed by an initializer list.
//  
//  DEFINITION: An item is said to be "contained directly" within a given block
//  if the item is within that block but not within any other blocks which are
//  themselves also completely contained within the given block.
//  
//  Two special restrictions apply to goto statements:
//  
//  1)	If a goto statement references a given destination label and if
//  	if the execution of the goto statement would cause control to be
//  	transfered into one or more blocks (from the outside) at a point
//  	which is past one or more auto initializations which are contained
//  	directly within the block(s) entered, then the given goto statement
//  	is illegal.
//  
//  2)	If a goto statement references a given destination label and if the
//  	execution of the goto statement would cause control to be transfered
//  	around one or more auto initializations contained directly within
//  	the containment block of the goto statement, then the given goto
//  	statement is illegal.
//
//  Any other goto statement whose target label is in the same function as the
//  goto statement itself and which does not violate either of the above
//  restrictions is considered to be legal.
//  -----------------------------------------------------------------------
//
// Cases:
//	declarations of objects which have explicit destructors
//	declaration of objects which have no (explicit or implicit) destructors
//	declarations of builtin type objects with initializer lists.
//
// Cases:
//	declarations of objects without default constructors
//	declarations of objects with default constructors
//
// Cases:
//	jumping down
//	jumping up
//
// Cases:
//	jumping to within the same block
//	jumping into a nested block
//	jumping out of a nested block
//	jumping both out of a block and into another block

struct base1 {
	int data_member;

	base1 (int i) { data_member = i; }
	~base1 () {}
};

struct base2 {
	int data_member;

	base2 (int i) { data_member = i; }
};

struct base3 {
	int data_member;

	base3 () { data_member = 1; }
};

base1* b1p;
base2* b2p;
base3* b3p;
int*   ip;

int f ();

void test ()
{
	base1 base1_outer_object1(1);
	base2 base2_outer_object1(1);
	base3 base3_outer_object1;
	int int_outer_object1 = 1;

	b1p = &base1_outer_object1;			// prevent warnings
	b2p = &base2_outer_object1;			// prevent warnings
	b3p = &base3_outer_object1;			// prevent warnings
	ip =  &int_outer_object1;			// prevent warnings

	if (f())
		goto inner_top1;
	else
		{ if (f()) goto inner_top2; }
	if (f())
		goto outer_bottom1;
	else
		{ if (f()) goto outer_bottom2; }

outer_top1:
{ outer_top2: ; }

	if (f())
	{
		if (f())
			goto outer_top1;
		else
			{ if (f()) goto outer_top2; }
inner_top1:
{ inner_top2: ; }

		base1 base1_inner_object1(1);
		base2 base2_inner_object1(1);
		base3 base3_inner_object1;
		int int_inner_object1 = 1;

		b1p = &base1_inner_object1;			// prevent warnings
		b2p = &base2_inner_object1;			// prevent warnings
		b3p = &base3_inner_object1;			// prevent warnings
		ip = &int_inner_object1;			// prevent warnings

		if (f())
			goto outer_top1;		// jump out past nested constructor
		else
			{ if (f()) goto outer_top2; }

inner_middle1:
{ inner_middle2: ; }

		if (f())
			goto inner_bottom1;
		else
			{ if (f()) goto inner_bottom2; }
		if (f())
			goto inner_middle1;
		else
			{ if (f()) goto inner_middle2; }
		if (f())
			goto outer_bottom1;
		else
			{ if (f()) goto outer_bottom2; }
inner_bottom1:
{ inner_bottom2: ; }

		base1 base1_inner_object2(1);
		base2 base2_inner_object2(1);
		base3 base3_inner_object2;
		int int_inner_object2 = 1;

		b1p = &base1_inner_object2;			// prevent warnings
		b2p = &base2_inner_object2;			// prevent warnings
		b3p = &base3_inner_object2;			// prevent warnings
		ip = &int_inner_object2;			// prevent warnings

inner_final1:
{ inner_final2: ; }

		if (f())
			goto inner_final1;
		else
			{ if (f()) goto inner_final2; }
	}

outer_bottom1:
{ outer_bottom2: ; }

	if (f())
		goto outer_top1;
	else
		{ if (f()) goto outer_top2; }
	if (f())
		goto inner_top1;
	else
		{ if (f()) goto inner_top2; }
	if (f())
		goto outer_bottom1;
	else
		{ if (f()) goto outer_bottom2; }

	base1 base1_outer_object2 (1);
	base2 base2_outer_object2 (1);
	base3 base3_outer_object2;
	int int_outer_object2 = 1;

	b1p = &base1_outer_object2;			// prevent warnings
	b2p = &base2_outer_object2;			// prevent warnings
	b3p = &base3_outer_object2;			// prevent warnings
	ip = &int_outer_object2;			// prevent warnings

outer_final1:
{ outer_final2: ; }

	if (f())
		goto outer_final1;
	else
		{ if (f()) goto outer_final2; }
}

int f ()
{
	return 1;
}

int main ()
{
	return 0;
}
