#ifndef COOL_FCN_H
#define COOL_FCN_H

#include <octave/oct.h>
#include <octave/oct-map.h>

class Cool_fcn
{
private:
  double init_temp;
  double cooling_factor;
  octave_idx_type total_steps;
  octave_idx_type succ_steps;
  octave_idx_type min_steps;
  double goal_of_cost;


  // init vars
  octave_idx_type ntot;
  octave_idx_type nsucc;
  octave_idx_type it_init_temp;
  octave_idx_type it_cooling_factor;

  // other
  double temp;
public:
  Cool_fcn (const octave_scalar_map &params)
  {
    if (params.isfield (std::string ("init_temp"))
        && params.isfield (std::string ("cooling_factor"))
        && params.isfield (std::string ("total"))
        && params.isfield (std::string ("succ"))
        && params.isfield (std::string ("min"))
        && params.isfield (std::string ("goal")))
      {
        init_temp      = params.getfield (std::string ("init_temp"))
                                .double_value ();
        cooling_factor = params.getfield (std::string ("cooling_factor"))
                                .double_value ();
        total_steps    = params.getfield (std::string ("total"))
                                .idx_type_value ();
        succ_steps     = params.getfield (std::string ("succ"))
                                .idx_type_value ();
        min_steps      = params.getfield (std::string ("min"))
                                .idx_type_value ();
        goal_of_cost   = params.getfield (std::string ("goal"))
                                .double_value ();

        // cool_init ()
        ntot  = 0;
        nsucc = 0;
        it_init_temp = 1;
        if (init_temp == 0)
          {
            init_temp = 1e-4;
            it_init_temp     = 0;
          }
        it_cooling_factor = 1;
        if (cooling_factor == 0)
          {
            cooling_factor    = 0.5;
            it_cooling_factor = 0;
          }

        temp      = init_temp;
      }
    else
      {
        error_with_id ("Octave:tisean", "Cool function constructor did not "
                                        "receive correct parameters");
      }

  }

  // "API" functions
  double get_temp () const { return temp; }
  void set_temp (double _temp) { this->temp = _temp; }

  double cool (double cost, bool accept, bool &end);


};


#endif
