
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2015
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('ult', 'b', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('f2f16', ('f2f32', 'a@16')) => a
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => a
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('f2f32', ('f2f64', 'a@32')) => a
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a')
 *    ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0)
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a')) => 0
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('find_lsb', ('bitfield_reverse', 'a')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a')) => ('find_lsb', 'a')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('i2b', ('ubfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('i2b', ('ibfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ufind_msb', 'value') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('pack_32_2x16_split', 'a@16', 'b@16') => ('ior', ('ishl', ('u2u32', 'b'), 16), ('u2u32', 'a'))
 *    ('unpack_32_2x16_split_x', 'a@32') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a@32') => ('u2u16', ('ushr', 'a', 16))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80 /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 6, 7 },
      -1,
   } },

   /* replace1_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7 /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 9 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000 /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 11, 12 },
      -1,
   } },

   /* replace2_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xf /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 14 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000 /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 17 },
      -1,
   } },

   /* replace3_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1f /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 19 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 22 },
      -1,
   } },

   /* replace4_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3f /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 24 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search5_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 26 },
      -1,
   } },

   /* replace5_0_0 -> 0 in the cache */
   /* replace5_0_1_0_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 28 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 30 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 33 },
      -1,
   } },

   /* replace6_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 35, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 37 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search7_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 39 },
      -1,
   } },

   /* replace7_0_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 42 },
      -1,
   } },
   /* replace7_1_0 -> 21 in the cache */
   /* replace7_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 43, 45 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search8_0_0 -> 16 in the cache */
   /* search8_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 47 },
      -1,
   } },

   /* replace8_0 -> 16 in the cache */
   /* replace8_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search9_0_0 -> 16 in the cache */
   /* search9_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 50 },
      -1,
   } },

   /* replace9_0 -> 16 in the cache */
   /* replace9_1 -> 36 in the cache */
   /* replace9 -> 49 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search10_0 -> 16 in the cache */
   /* search10_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace10_0_0 -> 16 in the cache */
   /* replace10_0_1 -> 36 in the cache */
   /* replace10_0 -> 49 in the cache */
   /* replace10_1_0 -> 16 in the cache */
   /* replace10_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 53 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search11_0 -> 16 in the cache */
   /* search11_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace11_0_0 -> 16 in the cache */
   /* replace11_0_1 -> 36 in the cache */
   /* replace11_0 -> 49 in the cache */
   /* replace11_1_0 -> 16 in the cache */
   /* replace11_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 56 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search12_0 -> 32 in the cache */
   /* search12_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace12 -> 32 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search13_0 -> 32 in the cache */
   /* search13_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace13 -> 32 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search14_0 -> 32 in the cache */
   /* search14_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0 /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search15_0 -> 32 in the cache */
   /* search15_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace15 -> 61 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search16_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace16 -> 61 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search17_0 -> 32 in the cache */
   /* search17_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace17 -> 61 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search18_0 -> 32 in the cache */
   /* search18_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace18 -> 61 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search19_0 -> 0 in the cache */
   /* search19_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace19_0 -> 0 in the cache */
   /* replace19_1_0 -> 3 in the cache */
   /* replace19_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search20_0 -> 0 in the cache */
   /* search20_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace20_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_1_0 -> 3 in the cache */
   /* replace20_1_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 72 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search21_0 -> 0 in the cache */
   /* search21_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace21_0_0_0 -> 0 in the cache */
   /* replace21_0_0 -> 70 in the cache */
   /* replace21_0_1_0_0 -> 0 in the cache */
   /* replace21_0_1_0 -> 71 in the cache */
   /* replace21_0_1_1_0_0 -> 3 in the cache */
   /* replace21_0_1_1_0 -> 28 in the cache */
   /* replace21_0_1_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 75 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 76 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search22_0 -> 0 in the cache */
   /* search22_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace22_0 -> 0 in the cache */
   /* replace22_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 3, 79 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 80 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 3 in the cache */
   /* replace23_1_1 -> 79 in the cache */
   /* replace23_1 -> 80 in the cache */
   /* replace23 -> 81 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace24_0_0_0 -> 0 in the cache */
   /* replace24_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace24_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 84, 3 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   /* replace24_2_0 -> 0 in the cache */
   /* replace24_2_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 85, 86, 87 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace25_0 -> 0 in the cache */
   /* replace25_1_0_0_0 -> 0 in the cache */
   /* replace25_1_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 86 },
      -1,
   } },
   /* replace25_1_0_1_0 -> 0 in the cache */
   /* replace25_1_0_1_1_0 -> 3 in the cache */
   /* replace25_1_0_1_1_1 -> 79 in the cache */
   /* replace25_1_0_1_1 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 80 },
      -1,
   } },
   /* replace25_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 90, 91, 0 },
      -1,
   } },
   /* replace25_1_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 92, 93 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 94 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 3 in the cache */
   /* replace26_1 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 28 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search27_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace27 -> 32 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search28_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace28 -> 32 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search29_0_0 -> 32 in the cache */
   /* search29_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace29_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search30_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 104 },
      -1,
   } },

   /* replace30_0 -> 32 in the cache */
   /* replace30 -> 104 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search31_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 106 },
      -1,
   } },

   /* replace31_0 -> 32 in the cache */
   /* replace31 -> 106 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search32_0_0 -> 32 in the cache */
   /* search32_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace32_0 -> 32 in the cache */
   /* replace32 -> 106 in the cache */

   /* ('f2b', ('fneg', 'a')) => ('f2b', 'a') */
   /* search33_0_0 -> 32 in the cache */
   /* search33_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace33_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2b', ('ineg', 'a')) => ('i2b', 'a') */
   /* search34_0_0 -> 32 in the cache */
   /* search34_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace34_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fadd', 'a', 0.0) => a */
   /* search35_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace35 -> 32 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a */
   /* search36_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 115 },
      1,
   } },

   /* replace36 -> 11 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a */
   /* search37_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 117 },
      1,
   } },

   /* replace37 -> 16 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search38_0 -> 32 in the cache */
   /* search38_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace38 -> 32 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search39_0 -> 32 in the cache */
   /* search39_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace39 -> 32 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search40_0 -> 32 in the cache */
   /* search40_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_isub_sat,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* replace40 -> 32 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search41_0 -> 32 in the cache */
   /* search41_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace41 -> 32 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search42_0 -> 32 in the cache */
   /* search42_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_usub_sat,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* replace42 -> 32 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search43_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 124 },
      -1,
   } },

   /* replace43 -> 16 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search44_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 126 },
      -1,
   } },

   /* replace44 -> 126 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search45_1_0 -> 128 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 130, 132 },
      -1,
   } },

   /* replace45_0 -> 128 in the cache */
   /* replace45_1_0 -> 129 in the cache */
   /* replace45_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 128, 134 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search46_0_0 -> 16 in the cache */
   /* search46_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* search46_1_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 16, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 136, 138 },
      -1,
   } },

   /* replace46_0 -> 16 in the cache */
   /* replace46_1_0 -> 36 in the cache */
   /* replace46_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 16, 140 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search47_0 -> 0 in the cache */
   /* search47_1 -> 3 in the cache */
   /* search47_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 142, 143 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 144 },
      -1,
   } },

   /* replace47_0 -> 0 in the cache */
   /* replace47_1_0 -> 3 in the cache */
   /* replace47_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 3, 142 },
      -1,
   } },
   /* replace47_2 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 146, 143 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search48_0 -> 0 in the cache */
   /* search48_1 -> 3 in the cache */
   /* search48_2_0 -> 0 in the cache */
   /* search48_2_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 142 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 148 },
      -1,
   } },

   /* replace48_0 -> 0 in the cache */
   /* replace48_1_0 -> 3 in the cache */
   /* replace48_1_1 -> 142 in the cache */
   /* replace48_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 146 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 151, 152 },
      0,
   } },
   /* search49_1_0 -> 151 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 151, 154, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 153, 156 },
      -1,
   } },

   /* replace49_0 -> 151 in the cache */
   /* replace49_1_0 -> 152 in the cache */
   /* replace49_1_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 152, 154 },
      -1,
   } },
   /* replace49_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 151, 158, 155 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search50_0 -> 151 in the cache */
   /* search50_1_0 -> 152 in the cache */
   /* search50_1_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 152, 154 },
      0,
   } },
   /* search50_2_0 -> 152 in the cache */
   /* search50_2_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 152, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 151, 160, 161 },
      -1,
   } },

   /* replace50_0 -> 152 in the cache */
   /* replace50_1_0 -> 151 in the cache */
   /* replace50_1_1 -> 154 in the cache */
   /* replace50_1_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 151, 154, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 152, 163 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search51_0 -> 16 in the cache */
   /* search51_1 -> 36 in the cache */
   /* search51_2_0 -> 16 in the cache */
   /* search51_2_1 -> 137 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 137, 165 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 166 },
      -1,
   } },

   /* replace51_0 -> 16 in the cache */
   /* replace51_1_0 -> 36 in the cache */
   /* replace51_1_1 -> 137 in the cache */
   /* replace51_1 -> 140 in the cache */
   /* replace51_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 140, 165 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search52_0 -> 16 in the cache */
   /* search52_1 -> 36 in the cache */
   /* search52_2_0 -> 16 in the cache */
   /* search52_2_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 137 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 169 },
      -1,
   } },

   /* replace52_0 -> 16 in the cache */
   /* replace52_1_0 -> 36 in the cache */
   /* replace52_1_1 -> 137 in the cache */
   /* replace52_1 -> 140 in the cache */
   /* replace52 -> 141 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search53_0_0 -> 16 in the cache */
   /* search53_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      0,
   } },
   /* search53_1_0 -> 16 in the cache */
   /* search53_1_1 -> 137 in the cache */
   /* search53_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 16, 137, 165 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 171, 172 },
      -1,
   } },

   /* replace53_0 -> 16 in the cache */
   /* replace53_1_0 -> 36 in the cache */
   /* replace53_1_1 -> 137 in the cache */
   /* replace53_1 -> 140 in the cache */
   /* replace53_2 -> 165 in the cache */
   /* replace53 -> 168 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search54_0 -> 16 in the cache */
   /* search54_1_0 -> 36 in the cache */
   /* search54_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 36, 137 },
      0,
   } },
   /* search54_2_0 -> 36 in the cache */
   /* search54_2_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 36, 165 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 16, 174, 175 },
      -1,
   } },

   /* replace54_0 -> 36 in the cache */
   /* replace54_1_0 -> 16 in the cache */
   /* replace54_1_1 -> 137 in the cache */
   /* replace54_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 137, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 36, 177 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search55_0_0 -> 128 in the cache */
   /* search55_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search55_1_0 -> 128 in the cache */
   /* search55_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 179, 180 },
      -1,
   } },

   /* replace55_0 -> 128 in the cache */
   /* replace55_1_0 -> 129 in the cache */
   /* replace55_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 128, 182 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 184, 185 },
      -1,
   } },
   /* search56_1_0 -> 131 in the cache */
   /* search56_1_1 -> 185 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 131, 185 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 186, 187 },
      -1,
   } },

   /* replace56_0_0 -> 184 in the cache */
   /* replace56_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 184, 131 },
      -1,
   } },
   /* replace56_1 -> 185 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 189, 185 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search57_0_0 -> 128 in the cache */
   /* search57_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search57_1_0 -> 128 in the cache */
   /* search57_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 191, 192 },
      -1,
   } },

   /* replace57_0 -> 128 in the cache */
   /* replace57_1_0 -> 129 in the cache */
   /* replace57_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 128, 194 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search58_0_0 -> 128 in the cache */
   /* search58_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search58_1_0 -> 128 in the cache */
   /* search58_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 196, 197 },
      -1,
   } },

   /* replace58_0 -> 128 in the cache */
   /* replace58_1_0 -> 129 in the cache */
   /* replace58_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 128, 199 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search59_0_0 -> 0 in the cache */
   /* search59_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search59_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 201, 3 },
      -1,
   } },

   /* replace59_0_0 -> 0 in the cache */
   /* replace59_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace59_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 203, 86 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search60_0_0 -> 0 in the cache */
   /* search60_0_1 -> 1 in the cache */
   /* search60_0 -> 201 in the cache */
   /* search60_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 201, 3 },
      -1,
   } },

   /* replace60_0_0 -> 0 in the cache */
   /* replace60_0_1 -> 3 in the cache */
   /* replace60_0 -> 203 in the cache */
   /* replace60_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 203, 86 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search61_0_0 -> 32 in the cache */
   /* search61_0 -> 98 in the cache */
   /* search61_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace61 -> 113 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search62_0_0 -> 32 in the cache */
   /* search62_0 -> 100 in the cache */
   /* search62_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 100, 32 },
      -1,
   } },

   /* replace62 -> 61 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search63_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search63_1_0 -> 0 in the cache */
   /* search63_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 209, 210 },
      -1,
   } },

   /* replace63 -> 3 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search64_0 -> 0 in the cache */
   /* search64_1_0_0 -> 0 in the cache */
   /* search64_1_0 -> 209 in the cache */
   /* search64_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 209, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 212 },
      -1,
   } },

   /* replace64 -> 3 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search65_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search65_1_0 -> 0 in the cache */
   /* search65_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 214, 215 },
      -1,
   } },

   /* replace65 -> 3 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search66_0 -> 0 in the cache */
   /* search66_1_0_0 -> 0 in the cache */
   /* search66_1_0 -> 214 in the cache */
   /* search66_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 214, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 217 },
      -1,
   } },

   /* replace66 -> 3 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search67_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search67_1_0_0 -> 32 in the cache */
   /* search67_1_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 219, 220 },
      -1,
   } },

   /* replace67_0_0 -> 32 in the cache */
   /* replace67_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 103 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search68_0 -> 32 in the cache */
   /* search68_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace68 -> 113 in the cache */

   /* ('fmul', 'a@16', 0.0) => 0.0 */
   /* search69_0 -> 11 in the cache */
   /* search69_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 115 },
      -1,
   } },

   /* replace69 -> 115 in the cache */

   /* ('fmul', 'a@32', 0.0) => 0.0 */
   /* search70_0 -> 16 in the cache */
   /* search70_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace70 -> 117 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search71_0 -> 16 in the cache */
   /* search71_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace71 -> 117 in the cache */

   /* ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search72_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 227 },
      -1,
   } },

   /* replace72_0 -> 16 in the cache */
   /* replace72_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 230, 231 },
      -1,
   } },

   /* replace73_0 -> 16 in the cache */
   /* replace73_1 -> 36 in the cache */
   /* replace73 -> 229 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search74_0 -> 16 in the cache */
   /* search74_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* replace74_0 -> 16 in the cache */
   /* replace74_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search75_0 -> 16 in the cache */
   /* search75_1 -> 227 in the cache */
   /* search75_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 227, 137 },
      -1,
   } },

   /* replace75_0 -> 16 in the cache */
   /* replace75_1 -> 36 in the cache */
   /* replace75_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search76_0 -> 230 in the cache */
   /* search76_1 -> 231 in the cache */
   /* search76_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 230, 231, 137 },
      -1,
   } },

   /* replace76_0 -> 16 in the cache */
   /* replace76_1 -> 36 in the cache */
   /* replace76_2 -> 137 in the cache */
   /* replace76 -> 236 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search77_0 -> 16 in the cache */
   /* search77_1 -> 16 in the cache */
   /* search77_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* replace77_0 -> 16 in the cache */
   /* replace77_1 -> 16 in the cache */
   /* replace77_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search78_0 -> 32 in the cache */
   /* search78_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace78 -> 61 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search79_0 -> 16 in the cache */
   /* search79_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 124 },
      -1,
   } },

   /* replace79 -> 124 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search80_0 -> 16 in the cache */
   /* search80_1 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 126 },
      -1,
   } },

   /* replace80 -> 16 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search81_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 243 },
      -1,
   } },

   /* replace81 -> 32 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search82_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 245 },
      -1,
   } },

   /* replace82 -> 16 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search83_0 -> 32 in the cache */
   /* search83_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 243 },
      1,
   } },

   /* replace83 -> 32 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search84_0 -> 32 in the cache */
   /* search84_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 35 },
      -1,
   } },

   /* replace84 -> 32 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search85_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 249 },
      -1,
   } },

   /* replace85_0 -> 32 in the cache */
   /* replace85 -> 98 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search86_0 -> 32 in the cache */
   /* search86_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace86_0 -> 32 in the cache */
   /* replace86 -> 100 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search87_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search87_1_0 -> 32 in the cache */
   /* search87_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 252, 253 },
      -1,
   } },

   /* replace87_0_0 -> 32 in the cache */
   /* replace87_0 -> 103 in the cache */
   /* replace87_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 103, 32 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search88_0_0_0 -> 32 in the cache */
   /* search88_0_0 -> 252 in the cache */
   /* search88_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 252, 32 },
      -1,
   } },
   /* search88_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 256, 32 },
      -1,
   } },

   /* replace88_0_0 -> 32 in the cache */
   /* replace88_0 -> 103 in the cache */
   /* replace88_1 -> 32 in the cache */
   /* replace88 -> 255 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search89_1 -> 0 in the cache */
   /* search89_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 258, 0, 3 },
      -1,
   } },

   /* replace89 -> 3 in the cache */

   /* ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search90_0 -> 115 in the cache */
   /* search90_1 -> 11 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 115, 11, 260 },
      1,
   } },

   /* replace90 -> 260 in the cache */

   /* ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search91_0 -> 117 in the cache */
   /* search91_1 -> 16 in the cache */
   /* search91_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 117, 16, 36 },
      1,
   } },

   /* replace91 -> 36 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search92_0 -> 117 in the cache */
   /* search92_1 -> 16 in the cache */
   /* search92_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 117, 16, 36 },
      -1,
   } },

   /* replace92_0 -> 117 in the cache */
   /* replace92_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 117, 36 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search93_0 -> 0 in the cache */
   /* search93_1 -> 3 in the cache */
   /* search93_2 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 3, 258 },
      -1,
   } },

   /* replace93_0 -> 0 in the cache */
   /* replace93_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search94_0 -> 11 in the cache */
   /* search94_1 -> 260 in the cache */
   /* search94_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 260, 115 },
      -1,
   } },

   /* replace94_0 -> 11 in the cache */
   /* replace94_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 260 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search95_0 -> 16 in the cache */
   /* search95_1 -> 36 in the cache */
   /* search95_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace95_0 -> 16 in the cache */
   /* replace95_1 -> 36 in the cache */
   /* replace95 -> 229 in the cache */

   /* ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search96_0 -> 16 in the cache */
   /* search96_1 -> 36 in the cache */
   /* search96_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace96_0 -> 16 in the cache */
   /* replace96_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search97_1 -> 0 in the cache */
   /* search97_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 272, 0, 3 },
      -1,
   } },

   /* replace97_0 -> 0 in the cache */
   /* replace97_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search98_0 -> 245 in the cache */
   /* search98_1 -> 16 in the cache */
   /* search98_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 245, 16, 36 },
      -1,
   } },

   /* replace98_0 -> 16 in the cache */
   /* replace98_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search99_1 -> 0 in the cache */
   /* search99_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 277, 0, 3 },
      -1,
   } },

   /* replace99_0_0 -> 0 in the cache */
   /* replace99_0 -> 214 in the cache */
   /* replace99_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 214, 3 },
      -1,
   } },

   /* ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search100_1 -> 16 in the cache */
   /* search100_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 280, 16, 36 },
      -1,
   } },

   /* replace100_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 16 },
      -1,
   } },
   /* replace100_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 282, 36 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search101_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 284, 285, 131 },
      -1,
   } },

   /* replace101_0_0 -> 128 in the cache */
   /* replace101_0_1 -> 129 in the cache */
   /* replace101_0 -> 130 in the cache */
   /* replace101_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 130, 131 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search102_1 -> 33 in the cache */
   /* search102_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 288, 33, 137 },
      -1,
   } },

   /* replace102_0_0 -> 16 in the cache */
   /* replace102_0_1 -> 36 in the cache */
   /* replace102_0 -> 136 in the cache */
   /* replace102_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 136, 137 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search103_0 -> 0 in the cache */
   /* search103_1 -> 3 in the cache */
   /* search103_2 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 258 },
      -1,
   } },

   /* replace103 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search104_0 -> 0 in the cache */
   /* search104_1 -> 3 in the cache */
   /* search104_2 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 272 },
      -1,
   } },

   /* replace104 -> 3 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search105_0 -> 0 in the cache */
   /* search105_1 -> 0 in the cache */
   /* search105_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 3 },
      -1,
   } },

   /* replace105 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search106_0 -> 258 in the cache */
   /* search106_1 -> 0 in the cache */
   /* search106_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 258, 0, 3 },
      -1,
   } },

   /* replace106_0 -> 0 in the cache */
   /* replace106_1 -> 3 in the cache */
   /* replace106 -> 266 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search107_0 -> 128 in the cache */
   /* search107_1_0 -> 128 in the cache */
   /* search107_1_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 128, 129 },
      0,
   } },
   /* search107_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 128, 295, 131 },
      -1,
   } },

   /* replace107_0_0 -> 129 in the cache */
   /* replace107_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 129, 131 },
      -1,
   } },
   /* replace107_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 297, 128 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search108_0 -> 16 in the cache */
   /* search108_1 -> 124 in the cache */
   /* search108_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace108 -> 36 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search109_0 -> 16 in the cache */
   /* search109_1 -> 124 in the cache */
   /* search109_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace109 -> 36 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search110_0 -> 16 in the cache */
   /* search110_1 -> 124 in the cache */
   /* search110_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace110 -> 36 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search111_0 -> 16 in the cache */
   /* search111_1 -> 124 in the cache */
   /* search111_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace111 -> 36 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search112_0 -> 16 in the cache */
   /* search112_1 -> 124 in the cache */
   /* search112_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace112 -> 36 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search113_0 -> 16 in the cache */
   /* search113_1 -> 124 in the cache */
   /* search113_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace113 -> 36 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search114_0 -> 16 in the cache */
   /* search114_1 -> 124 in the cache */
   /* search114_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace114 -> 36 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search115_0 -> 16 in the cache */
   /* search115_1 -> 124 in the cache */
   /* search115_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace115 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search116_0 -> 16 in the cache */
   /* search116_1 -> 124 in the cache */
   /* search116_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 124, 36 },
      -1,
   } },

   /* replace116 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search117_0 -> 124 in the cache */
   /* search117_1 -> 16 in the cache */
   /* search117_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 124, 16, 36 },
      -1,
   } },

   /* replace117 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search118_0 -> 16 in the cache */
   /* search118_1 -> 124 in the cache */
   /* search118_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 124, 36 },
      -1,
   } },

   /* replace118 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search119_0 -> 124 in the cache */
   /* search119_1 -> 16 in the cache */
   /* search119_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 124, 16, 36 },
      -1,
   } },

   /* replace119 -> 36 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search120_0_0 -> 16 in the cache */
   /* search120_0_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 311 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 312, 313 },
      -1,
   } },

   /* replace120_0 -> 16 in the cache */
   /* replace120_1 -> 36 in the cache */
   /* replace120_2_0 -> 137 in the cache */
   /* replace120_2_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 137, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 16, 36, 315 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search121_0_0 -> 16 in the cache */
   /* search121_0_1 -> 36 in the cache */
   /* search121_0_2 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 311 },
      0,
   } },
   /* search121_1 -> 313 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 317, 313 },
      -1,
   } },

   /* replace121_0 -> 16 in the cache */
   /* replace121_1 -> 36 in the cache */
   /* replace121_2_0 -> 137 in the cache */
   /* replace121_2_1 -> 165 in the cache */
   /* replace121_2 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 16, 36, 315 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search122_0_0 -> 16 in the cache */
   /* search122_0_1 -> 36 in the cache */
   /* search122_0_2 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 311 },
      0,
   } },
   /* search122_1 -> 313 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 320, 313 },
      -1,
   } },

   /* replace122_0 -> 16 in the cache */
   /* replace122_1 -> 36 in the cache */
   /* replace122_2_0 -> 137 in the cache */
   /* replace122_2_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 137, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 16, 36, 322 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search123_0_0 -> 16 in the cache */
   /* search123_0_1 -> 36 in the cache */
   /* search123_0_2 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 311 },
      0,
   } },
   /* search123_1 -> 313 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 324, 313 },
      -1,
   } },

   /* replace123_0 -> 16 in the cache */
   /* replace123_1 -> 36 in the cache */
   /* replace123_2_0 -> 137 in the cache */
   /* replace123_2_1 -> 165 in the cache */
   /* replace123_2 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 16, 36, 315 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search124_0_0 -> 16 in the cache */
   /* search124_0_1 -> 36 in the cache */
   /* search124_0_2 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 311 },
      0,
   } },
   /* search124_1 -> 313 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 327, 313 },
      -1,
   } },

   /* replace124_0 -> 16 in the cache */
   /* replace124_1 -> 36 in the cache */
   /* replace124_2_0 -> 137 in the cache */
   /* replace124_2_1 -> 165 in the cache */
   /* replace124_2 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 16, 36, 315 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search125_0_1 -> 36 in the cache */
   /* search125_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 330, 36, 124 },
      -1,
   } },
   /* search125_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 331, 137 },
      -1,
   } },

   /* replace125_0 -> 16 in the cache */
   /* replace125_1 -> 36 in the cache */
   /* replace125_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search126_0_0 -> 330 in the cache */
   /* search126_0_1 -> 36 in the cache */
   /* search126_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 330, 36, 124 },
      -1,
   } },
   /* search126_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 334, 137 },
      -1,
   } },

   /* replace126_0 -> 16 in the cache */
   /* replace126_1 -> 36 in the cache */
   /* replace126_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search127_0_0 -> 330 in the cache */
   /* search127_0_1 -> 36 in the cache */
   /* search127_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 330, 36, 124 },
      -1,
   } },
   /* search127_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 337, 137 },
      -1,
   } },

   /* replace127_0 -> 16 in the cache */
   /* replace127_1 -> 36 in the cache */
   /* replace127_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search128_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search128_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 340, 124 },
      -1,
   } },
   /* search128_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 341, 137 },
      -1,
   } },

   /* replace128_0 -> 16 in the cache */
   /* replace128_1 -> 36 in the cache */
   /* replace128_2 -> 137 in the cache */
   /* replace128 -> 339 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search129_0_0 -> 330 in the cache */
   /* search129_0_1 -> 36 in the cache */
   /* search129_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 330, 36, 124 },
      -1,
   } },
   /* search129_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 343, 137 },
      -1,
   } },

   /* replace129_0 -> 16 in the cache */
   /* replace129_1 -> 36 in the cache */
   /* replace129_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search130_0_0 -> 330 in the cache */
   /* search130_0_1 -> 36 in the cache */
   /* search130_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 330, 36, 124 },
      -1,
   } },
   /* search130_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 346, 137 },
      -1,
   } },

   /* replace130_0 -> 16 in the cache */
   /* replace130_1 -> 36 in the cache */
   /* replace130_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search131_0 -> 288 in the cache */
   /* search131_1 -> 33 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace131_0_0 -> 16 in the cache */
   /* replace131_0_1 -> 36 in the cache */
   /* replace131_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace131_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 351, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search132_0 -> 288 in the cache */
   /* search132_1 -> 33 in the cache */
   /* search132_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace132_0_0 -> 16 in the cache */
   /* replace132_0_1 -> 36 in the cache */
   /* replace132_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace132_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 354, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search133_0 -> 288 in the cache */
   /* search133_1 -> 33 in the cache */
   /* search133_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 288, 33, 349 },
      -1,
   } },

   /* replace133_0_0 -> 16 in the cache */
   /* replace133_0_1 -> 36 in the cache */
   /* replace133_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 124 },
      -1,
   } },
   /* replace133_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 357, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search134_0 -> 288 in the cache */
   /* search134_1 -> 33 in the cache */
   /* search134_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace134_0_0 -> 16 in the cache */
   /* replace134_0_1 -> 36 in the cache */
   /* replace134_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace134_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 360, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search135_0 -> 288 in the cache */
   /* search135_1 -> 33 in the cache */
   /* search135_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace135_0_0 -> 16 in the cache */
   /* replace135_0_1 -> 36 in the cache */
   /* replace135_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace135_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 363, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search136_0 -> 288 in the cache */
   /* search136_1 -> 33 in the cache */
   /* search136_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace136_0_0 -> 16 in the cache */
   /* replace136_0_1 -> 36 in the cache */
   /* replace136_0_2 -> 124 in the cache */
   /* replace136_0 -> 351 in the cache */
   /* replace136_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 351, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search137_0 -> 288 in the cache */
   /* search137_1 -> 33 in the cache */
   /* search137_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace137_0_0 -> 16 in the cache */
   /* replace137_0_1 -> 36 in the cache */
   /* replace137_0_2 -> 124 in the cache */
   /* replace137_0 -> 354 in the cache */
   /* replace137_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 354, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search138_0 -> 288 in the cache */
   /* search138_1 -> 33 in the cache */
   /* search138_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 288, 33, 349 },
      -1,
   } },

   /* replace138_0_0 -> 16 in the cache */
   /* replace138_0_1 -> 36 in the cache */
   /* replace138_0_2 -> 124 in the cache */
   /* replace138_0 -> 357 in the cache */
   /* replace138_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 357, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search139_0 -> 288 in the cache */
   /* search139_1 -> 33 in the cache */
   /* search139_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace139_0_0 -> 16 in the cache */
   /* replace139_0_1 -> 36 in the cache */
   /* replace139_0_2 -> 124 in the cache */
   /* replace139_0 -> 360 in the cache */
   /* replace139_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 360, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search140_0 -> 288 in the cache */
   /* search140_1 -> 33 in the cache */
   /* search140_2 -> 349 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 288, 33, 349 },
      -1,
   } },

   /* replace140_0_0 -> 16 in the cache */
   /* replace140_0_1 -> 36 in the cache */
   /* replace140_0_2 -> 124 in the cache */
   /* replace140_0 -> 363 in the cache */
   /* replace140_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 363, 137 },
      -1,
   } },

   /* ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search141_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 375, 117 },
      -1,
   } },
   /* search141_0_1 -> 117 in the cache */
   /* search141_0_2 -> 185 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 376, 117, 185 },
      -1,
   } },
   /* search141_1_0_0 -> 185 in the cache */
   /* search141_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      2, 1,
      { 185, 117 },
      -1,
   } },
   /* search141_1_1 -> 117 in the cache */
   /* search141_1_2 -> 375 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 378, 117, 375 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 377, 379 },
      -1,
   } },

   /* replace141_0 -> 185 in the cache */
   /* replace141_1 -> 375 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 185, 375 },
      -1,
   } },

   /* ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search142_0 -> 16 in the cache */
   /* search142_1_0_0 -> 16 in the cache */
   /* search142_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 16, 117 },
      -1,
   } },
   /* search142_1_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 382, 117, 383 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 16, 384 },
      -1,
   } },

   /* replace142_0 -> 16 in the cache */
   /* replace142_1 -> 36 in the cache */
   /* replace142 -> 271 in the cache */

   /* ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search143_0_0_0 -> 375 in the cache */
   /* search143_0_0_1 -> 117 in the cache */
   /* search143_0_0 -> 376 in the cache */
   /* search143_0_1 -> 117 in the cache */
   /* search143_0_2 -> 185 in the cache */
   /* search143_0 -> 377 in the cache */
   /* search143_1_0_0 -> 185 in the cache */
   /* search143_1_0_1 -> 117 in the cache */
   /* search143_1_0 -> 378 in the cache */
   /* search143_1_1 -> 117 in the cache */
   /* search143_1_2 -> 375 in the cache */
   /* search143_1 -> 379 in the cache */
   /* search143_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 377, 379, 137 },
      -1,
   } },

   /* replace143_0 -> 185 in the cache */
   /* replace143_1 -> 375 in the cache */
   /* replace143_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 185, 375, 137 },
      -1,
   } },

   /* ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search144_0 -> 16 in the cache */
   /* search144_1_0_0 -> 16 in the cache */
   /* search144_1_0_1 -> 117 in the cache */
   /* search144_1_0 -> 382 in the cache */
   /* search144_1_1 -> 117 in the cache */
   /* search144_1_2 -> 383 in the cache */
   /* search144_1 -> 384 in the cache */
   /* search144_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 16, 384, 137 },
      -1,
   } },

   /* replace144_0 -> 16 in the cache */
   /* replace144_1 -> 36 in the cache */
   /* replace144_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search145_0_0 -> 375 in the cache */
   /* search145_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      0, 1,
      { 375, 117 },
      -1,
   } },
   /* search145_1 -> 245 in the cache */
   /* search145_2_0_0 -> 185 in the cache */
   /* search145_2_0_1 -> 375 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 185, 375 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 391 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 390, 245, 392 },
      -1,
   } },

   /* replace145_0_0 -> 185 in the cache */
   /* replace145_0_1 -> 375 in the cache */
   /* replace145_0 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 381 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search146_0 -> 16 in the cache */
   /* search146_1 -> 36 in the cache */
   /* search146_2 -> 137 in the cache */
   /* search146 -> 333 in the cache */

   /* replace146_0_0_0_0_0 -> 16 in the cache */
   /* replace146_0_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace146_0_0_0_1_0 -> 36 in the cache */
   /* replace146_0_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 395, 396 },
      -1,
   } },
   /* replace146_0_0_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 398 },
      -1,
   } },
   /* replace146_0_0_1_1_0 -> 36 in the cache */
   /* replace146_0_0_1_1_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 399, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 397, 401 },
      -1,
   } },
   /* replace146_0_1_0_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 403 },
      -1,
   } },
   /* replace146_0_1_0_1_0 -> 36 in the cache */
   /* replace146_0_1_0_1_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 404, 405 },
      -1,
   } },
   /* replace146_0_1_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 407 },
      -1,
   } },
   /* replace146_0_1_1_1_0 -> 36 in the cache */
   /* replace146_0_1_1_1_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 408, 409 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 406, 410 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 402, 411 },
      -1,
   } },
   /* replace146_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 412, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search147_0 -> 16 in the cache */
   /* search147_1 -> 36 in the cache */
   /* search147_2 -> 137 in the cache */
   /* search147 -> 336 in the cache */

   /* replace147_0_0_0_0_0 -> 16 in the cache */
   /* replace147_0_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace147_0_0_0_1_0 -> 36 in the cache */
   /* replace147_0_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 414, 415 },
      -1,
   } },
   /* replace147_0_0_1_0_0 -> 16 in the cache */
   /* replace147_0_0_1_0_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 398 },
      -1,
   } },
   /* replace147_0_0_1_1_0 -> 36 in the cache */
   /* replace147_0_0_1_1_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 417, 418 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 416, 419 },
      -1,
   } },
   /* replace147_0_1_0_0_0 -> 16 in the cache */
   /* replace147_0_1_0_0_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 403 },
      -1,
   } },
   /* replace147_0_1_0_1_0 -> 36 in the cache */
   /* replace147_0_1_0_1_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 421, 422 },
      -1,
   } },
   /* replace147_0_1_1_0_0 -> 16 in the cache */
   /* replace147_0_1_1_0_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 407 },
      -1,
   } },
   /* replace147_0_1_1_1_0 -> 36 in the cache */
   /* replace147_0_1_1_1_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 424, 425 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 423, 426 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 420, 427 },
      -1,
   } },
   /* replace147_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 428, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search148_0 -> 16 in the cache */
   /* search148_1 -> 36 in the cache */
   /* search148_2 -> 137 in the cache */
   /* search148 -> 339 in the cache */

   /* replace148_0_0_0_0_0 -> 16 in the cache */
   /* replace148_0_0_0_0_1 -> 124 in the cache */
   /* replace148_0_0_0_0 -> 395 in the cache */
   /* replace148_0_0_0_1_0 -> 36 in the cache */
   /* replace148_0_0_0_1_1 -> 124 in the cache */
   /* replace148_0_0_0_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 395, 415 },
      -1,
   } },
   /* replace148_0_0_1_0_0 -> 16 in the cache */
   /* replace148_0_0_1_0_1 -> 398 in the cache */
   /* replace148_0_0_1_0 -> 399 in the cache */
   /* replace148_0_0_1_1_0 -> 36 in the cache */
   /* replace148_0_0_1_1_1 -> 398 in the cache */
   /* replace148_0_0_1_1 -> 418 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 399, 418 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 430, 431 },
      -1,
   } },
   /* replace148_0_1_0_0_0 -> 16 in the cache */
   /* replace148_0_1_0_0_1 -> 403 in the cache */
   /* replace148_0_1_0_0 -> 404 in the cache */
   /* replace148_0_1_0_1_0 -> 36 in the cache */
   /* replace148_0_1_0_1_1 -> 403 in the cache */
   /* replace148_0_1_0_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 404, 422 },
      -1,
   } },
   /* replace148_0_1_1_0_0 -> 16 in the cache */
   /* replace148_0_1_1_0_1 -> 407 in the cache */
   /* replace148_0_1_1_0 -> 408 in the cache */
   /* replace148_0_1_1_1_0 -> 36 in the cache */
   /* replace148_0_1_1_1_1 -> 407 in the cache */
   /* replace148_0_1_1_1 -> 425 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 408, 425 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 433, 434 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 432, 435 },
      -1,
   } },
   /* replace148_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 436, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search149_0 -> 16 in the cache */
   /* search149_1 -> 36 in the cache */
   /* search149_2 -> 137 in the cache */
   /* search149 -> 345 in the cache */

   /* replace149_0_0_0_0 -> 16 in the cache */
   /* replace149_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace149_0_0_1_0 -> 36 in the cache */
   /* replace149_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 438, 439 },
      -1,
   } },
   /* replace149_0_1_0_0 -> 16 in the cache */
   /* replace149_0_1_0_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 398 },
      -1,
   } },
   /* replace149_0_1_1_0 -> 36 in the cache */
   /* replace149_0_1_1_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 441, 442 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 440, 443 },
      -1,
   } },
   /* replace149_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 444, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search150_0 -> 16 in the cache */
   /* search150_1 -> 36 in the cache */
   /* search150_2 -> 137 in the cache */
   /* search150 -> 348 in the cache */

   /* replace150_0_0_0_0 -> 16 in the cache */
   /* replace150_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace150_0_0_1_0 -> 36 in the cache */
   /* replace150_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 446, 447 },
      -1,
   } },
   /* replace150_0_1_0_0 -> 16 in the cache */
   /* replace150_0_1_0_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 398 },
      -1,
   } },
   /* replace150_0_1_1_0 -> 36 in the cache */
   /* replace150_0_1_1_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 449, 450 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 448, 451 },
      -1,
   } },
   /* replace150_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 452, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search151_0 -> 16 in the cache */
   /* search151_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 454 },
      -1,
   } },

   /* replace151_0 -> 16 in the cache */
   /* replace151_1 -> 36 in the cache */
   /* replace151_2 -> 137 in the cache */
   /* replace151 -> 336 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search152_0 -> 16 in the cache */
   /* search152_1 -> 36 in the cache */
   /* search152_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace152_0_0_0_0_0 -> 16 in the cache */
   /* replace152_0_0_0_0_1 -> 124 in the cache */
   /* replace152_0_0_0_0 -> 414 in the cache */
   /* replace152_0_0_0_1_0 -> 36 in the cache */
   /* replace152_0_0_0_1_1 -> 124 in the cache */
   /* replace152_0_0_0_1 -> 415 in the cache */
   /* replace152_0_0_0 -> 416 in the cache */
   /* replace152_0_0_1_0_0 -> 16 in the cache */
   /* replace152_0_0_1_0_1 -> 398 in the cache */
   /* replace152_0_0_1_0 -> 417 in the cache */
   /* replace152_0_0_1_1_0 -> 36 in the cache */
   /* replace152_0_0_1_1_1 -> 398 in the cache */
   /* replace152_0_0_1_1 -> 418 in the cache */
   /* replace152_0_0_1 -> 419 in the cache */
   /* replace152_0_0 -> 420 in the cache */
   /* replace152_0_1_0_0_0 -> 16 in the cache */
   /* replace152_0_1_0_0_1 -> 403 in the cache */
   /* replace152_0_1_0_0 -> 421 in the cache */
   /* replace152_0_1_0_1_0 -> 36 in the cache */
   /* replace152_0_1_0_1_1 -> 403 in the cache */
   /* replace152_0_1_0_1 -> 422 in the cache */
   /* replace152_0_1_0 -> 423 in the cache */
   /* replace152_0_1_1_0_0 -> 16 in the cache */
   /* replace152_0_1_1_0_1 -> 407 in the cache */
   /* replace152_0_1_1_0 -> 424 in the cache */
   /* replace152_0_1_1_1_0 -> 36 in the cache */
   /* replace152_0_1_1_1_1 -> 407 in the cache */
   /* replace152_0_1_1_1 -> 425 in the cache */
   /* replace152_0_1_1 -> 426 in the cache */
   /* replace152_0_1 -> 427 in the cache */
   /* replace152_0 -> 428 in the cache */
   /* replace152_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 8,
      { 428, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search153_0 -> 16 in the cache */
   /* search153_1 -> 36 in the cache */
   /* search153_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace153_0_0_0_0_0 -> 16 in the cache */
   /* replace153_0_0_0_0_1 -> 124 in the cache */
   /* replace153_0_0_0_0 -> 395 in the cache */
   /* replace153_0_0_0_1_0 -> 36 in the cache */
   /* replace153_0_0_0_1_1 -> 124 in the cache */
   /* replace153_0_0_0_1 -> 396 in the cache */
   /* replace153_0_0_0 -> 397 in the cache */
   /* replace153_0_0_1_0_0 -> 16 in the cache */
   /* replace153_0_0_1_0_1 -> 398 in the cache */
   /* replace153_0_0_1_0 -> 399 in the cache */
   /* replace153_0_0_1_1_0 -> 36 in the cache */
   /* replace153_0_0_1_1_1 -> 398 in the cache */
   /* replace153_0_0_1_1 -> 400 in the cache */
   /* replace153_0_0_1 -> 401 in the cache */
   /* replace153_0_0 -> 402 in the cache */
   /* replace153_0_1_0_0_0 -> 16 in the cache */
   /* replace153_0_1_0_0_1 -> 403 in the cache */
   /* replace153_0_1_0_0 -> 404 in the cache */
   /* replace153_0_1_0_1_0 -> 36 in the cache */
   /* replace153_0_1_0_1_1 -> 403 in the cache */
   /* replace153_0_1_0_1 -> 405 in the cache */
   /* replace153_0_1_0 -> 406 in the cache */
   /* replace153_0_1_1_0_0 -> 16 in the cache */
   /* replace153_0_1_1_0_1 -> 407 in the cache */
   /* replace153_0_1_1_0 -> 408 in the cache */
   /* replace153_0_1_1_1_0 -> 36 in the cache */
   /* replace153_0_1_1_1_1 -> 407 in the cache */
   /* replace153_0_1_1_1 -> 409 in the cache */
   /* replace153_0_1_1 -> 410 in the cache */
   /* replace153_0_1 -> 411 in the cache */
   /* replace153_0 -> 412 in the cache */
   /* replace153_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 412, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search154_0 -> 16 in the cache */
   /* search154_1 -> 36 in the cache */
   /* search154_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 36, 137 },
      -1,
   } },

   /* replace154_0_0_0_0_0 -> 16 in the cache */
   /* replace154_0_0_0_0_1 -> 124 in the cache */
   /* replace154_0_0_0_0 -> 395 in the cache */
   /* replace154_0_0_0_1_0 -> 36 in the cache */
   /* replace154_0_0_0_1_1 -> 124 in the cache */
   /* replace154_0_0_0_1 -> 415 in the cache */
   /* replace154_0_0_0 -> 430 in the cache */
   /* replace154_0_0_1_0_0 -> 16 in the cache */
   /* replace154_0_0_1_0_1 -> 398 in the cache */
   /* replace154_0_0_1_0 -> 399 in the cache */
   /* replace154_0_0_1_1_0 -> 36 in the cache */
   /* replace154_0_0_1_1_1 -> 398 in the cache */
   /* replace154_0_0_1_1 -> 418 in the cache */
   /* replace154_0_0_1 -> 431 in the cache */
   /* replace154_0_0 -> 432 in the cache */
   /* replace154_0_1_0_0_0 -> 16 in the cache */
   /* replace154_0_1_0_0_1 -> 403 in the cache */
   /* replace154_0_1_0_0 -> 404 in the cache */
   /* replace154_0_1_0_1_0 -> 36 in the cache */
   /* replace154_0_1_0_1_1 -> 403 in the cache */
   /* replace154_0_1_0_1 -> 422 in the cache */
   /* replace154_0_1_0 -> 433 in the cache */
   /* replace154_0_1_1_0_0 -> 16 in the cache */
   /* replace154_0_1_1_0_1 -> 407 in the cache */
   /* replace154_0_1_1_0 -> 408 in the cache */
   /* replace154_0_1_1_1_0 -> 36 in the cache */
   /* replace154_0_1_1_1_1 -> 407 in the cache */
   /* replace154_0_1_1_1 -> 425 in the cache */
   /* replace154_0_1_1 -> 434 in the cache */
   /* replace154_0_1 -> 435 in the cache */
   /* replace154_0 -> 436 in the cache */
   /* replace154_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 436, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search155_0 -> 16 in the cache */
   /* search155_1 -> 36 in the cache */
   /* search155_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace155_0_0_0_0 -> 16 in the cache */
   /* replace155_0_0_0_1 -> 124 in the cache */
   /* replace155_0_0_0 -> 446 in the cache */
   /* replace155_0_0_1_0 -> 36 in the cache */
   /* replace155_0_0_1_1 -> 124 in the cache */
   /* replace155_0_0_1 -> 447 in the cache */
   /* replace155_0_0 -> 448 in the cache */
   /* replace155_0_1_0_0 -> 16 in the cache */
   /* replace155_0_1_0_1 -> 398 in the cache */
   /* replace155_0_1_0 -> 449 in the cache */
   /* replace155_0_1_1_0 -> 36 in the cache */
   /* replace155_0_1_1_1 -> 398 in the cache */
   /* replace155_0_1_1 -> 450 in the cache */
   /* replace155_0_1 -> 451 in the cache */
   /* replace155_0 -> 452 in the cache */
   /* replace155_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 452, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search156_0 -> 16 in the cache */
   /* search156_1 -> 36 in the cache */
   /* search156_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace156_0_0_0_0 -> 16 in the cache */
   /* replace156_0_0_0_1 -> 124 in the cache */
   /* replace156_0_0_0 -> 438 in the cache */
   /* replace156_0_0_1_0 -> 36 in the cache */
   /* replace156_0_0_1_1 -> 124 in the cache */
   /* replace156_0_0_1 -> 439 in the cache */
   /* replace156_0_0 -> 440 in the cache */
   /* replace156_0_1_0_0 -> 16 in the cache */
   /* replace156_0_1_0_1 -> 398 in the cache */
   /* replace156_0_1_0 -> 441 in the cache */
   /* replace156_0_1_1_0 -> 36 in the cache */
   /* replace156_0_1_1_1 -> 398 in the cache */
   /* replace156_0_1_1 -> 442 in the cache */
   /* replace156_0_1 -> 443 in the cache */
   /* replace156_0 -> 444 in the cache */
   /* replace156_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 444, 137 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search157_0 -> 11 in the cache */
   /* search157_1 -> 260 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 260, 467 },
      -1,
   } },

   /* replace157_0 -> 466 in the cache */
   /* replace157_1 -> 260 in the cache */
   /* replace157_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 466, 260, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search158_0 -> 11 in the cache */
   /* search158_1_0 -> 11 in the cache */
   /* search158_1_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 260 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 470, 471 },
      -1,
   } },

   /* replace158_0_0 -> 260 in the cache */
   /* replace158_0_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 260, 471 },
      -1,
   } },
   /* replace158_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 473, 11 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search159_0_0 -> 11 in the cache */
   /* search159_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 260 },
      0,
   } },
   /* search159_1_0 -> 11 in the cache */
   /* search159_1_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 471 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 475, 476, 477 },
      -1,
   } },

   /* replace159_0_0 -> 260 in the cache */
   /* replace159_0_1 -> 471 in the cache */
   /* replace159_0_2 -> 477 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 260, 471, 477 },
      -1,
   } },
   /* replace159_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 479, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search160_0 -> 11 in the cache */
   /* search160_1_0 -> 11 in the cache */
   /* search160_1_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 260 },
      0,
   } },
   /* search160_2 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 481, 471 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace160_0_1 -> 260 in the cache */
   /* replace160_0_2 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 483, 260, 471 },
      -1,
   } },
   /* replace160_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 484, 11 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search161_0_0 -> 11 in the cache */
   /* search161_0_1_0 -> 483 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 486 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 483, 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 488 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search161_1_1 -> 486 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 490, 486 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 489, 491 },
      -1,
   } },

   /* replace161_0 -> 11 in the cache */
   /* replace161_1 -> 490 in the cache */
   /* replace161_2 -> 486 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 490, 486 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search162_0_0 -> 11 in the cache */
   /* search162_0_1_0_0 -> 483 in the cache */
   /* search162_0_1_0_1_0 -> 486 in the cache */
   /* search162_0_1_0_1 -> 487 in the cache */
   /* search162_0_1_0 -> 488 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 488 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 494 },
      -1,
   } },
   /* search162_1_0 -> 490 in the cache */
   /* search162_1_1_0 -> 486 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 486 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 490, 496 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 495, 497 },
      -1,
   } },

   /* replace162_0 -> 11 in the cache */
   /* replace162_1 -> 490 in the cache */
   /* replace162_2_0 -> 486 in the cache */
   /* replace162_2 -> 496 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 490, 496 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search163_0 -> 11 in the cache */
   /* search163_1_0 -> 486 in the cache */
   /* search163_1_1_0 -> 490 in the cache */
   /* search163_1_1_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 490, 500 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 486, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 502 },
      -1,
   } },

   /* replace163_0 -> 11 in the cache */
   /* replace163_1 -> 490 in the cache */
   /* replace163_2 -> 486 in the cache */
   /* replace163 -> 493 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search164_0_0 -> 11 in the cache */
   /* search164_0_1_0 -> 483 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 505 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 483, 506 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 507 },
      -1,
   } },
   /* search164_1_0 -> 490 in the cache */
   /* search164_1_1_0 -> 504 in the cache */
   /* search164_1_1 -> 505 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 490, 505 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 508, 509 },
      -1,
   } },

   /* replace164_0 -> 504 in the cache */
   /* replace164_1 -> 490 in the cache */
   /* replace164_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 504, 490, 11 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search165_0 -> 11 in the cache */
   /* search165_1_0_0 -> 504 in the cache */
   /* search165_1_0 -> 505 in the cache */
   /* search165_1_1_0 -> 490 in the cache */
   /* search165_1_1_1_0 -> 11 in the cache */
   /* search165_1_1_1 -> 500 in the cache */
   /* search165_1_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 505, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 512 },
      -1,
   } },

   /* replace165_0 -> 504 in the cache */
   /* replace165_1 -> 490 in the cache */
   /* replace165_2 -> 11 in the cache */
   /* replace165 -> 511 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search166_0 -> 11 in the cache */
   /* search166_1_0 -> 483 in the cache */
   /* search166_1_1_0_0 -> 504 in the cache */
   /* search166_1_1_0 -> 505 in the cache */
   /* search166_1_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 483, 506 },
      -1,
   } },
   /* search166_2_0 -> 490 in the cache */
   /* search166_2_1_0 -> 504 in the cache */
   /* search166_2_1 -> 505 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 490, 505 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 11, 514, 515 },
      -1,
   } },

   /* replace166_0 -> 504 in the cache */
   /* replace166_1 -> 490 in the cache */
   /* replace166_2 -> 11 in the cache */
   /* replace166 -> 511 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search167_1_0 -> 504 in the cache */
   /* search167_1 -> 505 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 518 },
      -1,
   } },
   /* search167_2_1_0 -> 504 in the cache */
   /* search167_2_1 -> 505 in the cache */
   /* search167_2_2 -> 518 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 519, 505, 518 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 517, 505, 520 },
      -1,
   } },

   /* replace167_0 -> 504 in the cache */
   /* replace167_1 -> 517 in the cache */
   /* replace167_2 -> 518 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 504, 517, 518 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 523 },
      -1,
   } },
   /* search168_1_0 -> 260 in the cache */
   /* search168_1_1_0 -> 518 in the cache */
   /* search168_1_1 -> 519 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 260, 519 },
      -1,
   } },
   /* search168_2 -> 518 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 524, 525, 518 },
      -1,
   } },

   /* replace168_0 -> 523 in the cache */
   /* replace168_1 -> 260 in the cache */
   /* replace168_2 -> 518 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 523, 260, 518 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search169_0_0 -> 523 in the cache */
   /* search169_0 -> 524 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 528 },
      -1,
   } },
   /* search169_1_1 -> 490 in the cache */
   /* search169_1_2 -> 477 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 529, 490, 477 },
      -1,
   } },
   /* search169_2_0 -> 528 in the cache */
   /* search169_2_1 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 528, 490 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 524, 530, 531 },
      -1,
   } },

   /* replace169_0 -> 523 in the cache */
   /* replace169_1 -> 477 in the cache */
   /* replace169_2_0 -> 528 in the cache */
   /* replace169_2_1 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 528, 490 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 523, 477, 533 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search170_0 -> 483 in the cache */
   /* search170_1_0_0_0 -> 483 in the cache */
   /* search170_1_0_0_1_0 -> 11 in the cache */
   /* search170_1_0_0_1 -> 500 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 483, 500 },
      -1,
   } },
   /* search170_1_0_1_0 -> 483 in the cache */
   /* search170_1_0_1_1_0 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 260 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 483, 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 535, 537 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 538 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 483, 539 },
      -1,
   } },

   /* replace170_0 -> 260 in the cache */
   /* replace170_1 -> 483 in the cache */
   /* replace170_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 260, 483, 11 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search171_0 -> 16 in the cache */
   /* search171_1 -> 36 in the cache */
   /* search171_2_0 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 36, 542 },
      -1,
   } },

   /* replace171_0 -> 466 in the cache */
   /* replace171_1 -> 36 in the cache */
   /* replace171_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 466, 36, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search172_0 -> 16 in the cache */
   /* search172_1_0 -> 16 in the cache */
   /* search172_1_1 -> 36 in the cache */
   /* search172_1 -> 276 in the cache */
   /* search172_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 276, 137 },
      -1,
   } },

   /* replace172_0_0 -> 36 in the cache */
   /* replace172_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 36, 137 },
      -1,
   } },
   /* replace172_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 546, 16 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search173_0_0 -> 16 in the cache */
   /* search173_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search173_1_0 -> 16 in the cache */
   /* search173_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 16, 137 },
      0,
   } },
   /* search173_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 548, 549, 165 },
      -1,
   } },

   /* replace173_0_0 -> 36 in the cache */
   /* replace173_0_1 -> 137 in the cache */
   /* replace173_0_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 137, 165 },
      -1,
   } },
   /* replace173_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 551, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search174_0 -> 16 in the cache */
   /* search174_1_0 -> 16 in the cache */
   /* search174_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search174_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 553, 137 },
      -1,
   } },

   /* replace174_0_0 -> 245 in the cache */
   /* replace174_0_1 -> 36 in the cache */
   /* replace174_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 245, 36, 137 },
      -1,
   } },
   /* replace174_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 555, 16 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search175_0_0 -> 16 in the cache */
   /* search175_0_1_0 -> 245 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 245, 558 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 559 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search175_1_1 -> 557 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 561, 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 560, 562 },
      -1,
   } },

   /* replace175_0 -> 16 in the cache */
   /* replace175_1 -> 561 in the cache */
   /* replace175_2 -> 557 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 561, 557 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search176_0_0 -> 16 in the cache */
   /* search176_0_1_0_0 -> 245 in the cache */
   /* search176_0_1_0_1_0 -> 557 in the cache */
   /* search176_0_1_0_1 -> 558 in the cache */
   /* search176_0_1_0 -> 559 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 565 },
      -1,
   } },
   /* search176_1_0 -> 561 in the cache */
   /* search176_1_1_0 -> 557 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 561, 567 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 566, 568 },
      -1,
   } },

   /* replace176_0 -> 16 in the cache */
   /* replace176_1 -> 561 in the cache */
   /* replace176_2_0 -> 557 in the cache */
   /* replace176_2 -> 567 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 561, 567 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search177_0 -> 16 in the cache */
   /* search177_1_0 -> 557 in the cache */
   /* search177_1_1_0 -> 561 in the cache */
   /* search177_1_1_1_0 -> 16 in the cache */
   /* search177_1_1_1 -> 282 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 561, 282 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 557, 571 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 572 },
      -1,
   } },

   /* replace177_0 -> 16 in the cache */
   /* replace177_1 -> 561 in the cache */
   /* replace177_2 -> 557 in the cache */
   /* replace177 -> 564 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search178_0_0 -> 16 in the cache */
   /* search178_0_1_0 -> 245 in the cache */
   /* search178_0_1_1_0_0 -> 504 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 245, 575 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 576 },
      -1,
   } },
   /* search178_1_0 -> 561 in the cache */
   /* search178_1_1_0 -> 504 in the cache */
   /* search178_1_1 -> 574 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 561, 574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 577, 578 },
      -1,
   } },

   /* replace178_0 -> 504 in the cache */
   /* replace178_1 -> 561 in the cache */
   /* replace178_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 504, 561, 16 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search179_0 -> 16 in the cache */
   /* search179_1_0_0 -> 504 in the cache */
   /* search179_1_0 -> 574 in the cache */
   /* search179_1_1_0 -> 561 in the cache */
   /* search179_1_1_1_0 -> 16 in the cache */
   /* search179_1_1_1 -> 282 in the cache */
   /* search179_1_1 -> 571 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 574, 571 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 581 },
      -1,
   } },

   /* replace179_0 -> 504 in the cache */
   /* replace179_1 -> 561 in the cache */
   /* replace179_2 -> 16 in the cache */
   /* replace179 -> 580 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search180_0 -> 16 in the cache */
   /* search180_1_0 -> 245 in the cache */
   /* search180_1_1_0_0 -> 504 in the cache */
   /* search180_1_1_0 -> 574 in the cache */
   /* search180_1_1 -> 575 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 245, 575 },
      -1,
   } },
   /* search180_2_0 -> 561 in the cache */
   /* search180_2_1_0 -> 504 in the cache */
   /* search180_2_1 -> 574 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 561, 574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 16, 583, 584 },
      -1,
   } },

   /* replace180_0 -> 504 in the cache */
   /* replace180_1 -> 561 in the cache */
   /* replace180_2 -> 16 in the cache */
   /* replace180 -> 580 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search181_0 -> 375 in the cache */
   /* search181_1_0 -> 504 in the cache */
   /* search181_1 -> 574 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 586 },
      -1,
   } },
   /* search181_2_1_0 -> 504 in the cache */
   /* search181_2_1 -> 574 in the cache */
   /* search181_2_2 -> 586 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 587, 574, 586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 375, 574, 588 },
      -1,
   } },

   /* replace181_0 -> 504 in the cache */
   /* replace181_1 -> 375 in the cache */
   /* replace181_2 -> 586 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 504, 375, 586 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search182_0_0 -> 523 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 523 },
      -1,
   } },
   /* search182_1_0 -> 36 in the cache */
   /* search182_1_1_0 -> 586 in the cache */
   /* search182_1_1 -> 587 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 587 },
      -1,
   } },
   /* search182_2 -> 586 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 591, 592, 586 },
      -1,
   } },

   /* replace182_0 -> 523 in the cache */
   /* replace182_1 -> 36 in the cache */
   /* replace182_2 -> 586 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 523, 36, 586 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search183_0_0 -> 523 in the cache */
   /* search183_0 -> 591 in the cache */
   /* search183_1_0_0 -> 185 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 185 },
      -1,
   } },
   /* search183_1_1 -> 561 in the cache */
   /* search183_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 595, 561, 165 },
      -1,
   } },
   /* search183_2_0 -> 185 in the cache */
   /* search183_2_1 -> 561 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 185, 561 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 591, 596, 597 },
      -1,
   } },

   /* replace183_0 -> 523 in the cache */
   /* replace183_1 -> 165 in the cache */
   /* replace183_2_0 -> 185 in the cache */
   /* replace183_2_1 -> 561 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 185, 561 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 523, 165, 599 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search184_0 -> 245 in the cache */
   /* search184_1_0_0_0 -> 245 in the cache */
   /* search184_1_0_0_1_0 -> 16 in the cache */
   /* search184_1_0_0_1 -> 282 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 245, 282 },
      -1,
   } },
   /* search184_1_0_1_0 -> 245 in the cache */
   /* search184_1_0_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 245, 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 601, 603 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 604 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 245, 605 },
      -1,
   } },

   /* replace184_0 -> 36 in the cache */
   /* replace184_1 -> 245 in the cache */
   /* replace184_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 245, 16 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search185_0 -> 21 in the cache */
   /* search185_1 -> 41 in the cache */
   /* search185_2_0 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 41, 608 },
      -1,
   } },

   /* replace185_0 -> 466 in the cache */
   /* replace185_1 -> 41 in the cache */
   /* replace185_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 466, 41, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search186_0 -> 21 in the cache */
   /* search186_1_0 -> 21 in the cache */
   /* search186_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 611, 612 },
      -1,
   } },

   /* replace186_0_0 -> 41 in the cache */
   /* replace186_0_1 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 41, 612 },
      -1,
   } },
   /* replace186_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 614, 21 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search187_0_0 -> 21 in the cache */
   /* search187_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search187_1_0 -> 21 in the cache */
   /* search187_1_1 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 21, 612 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 616, 617, 618 },
      -1,
   } },

   /* replace187_0_0 -> 41 in the cache */
   /* replace187_0_1 -> 612 in the cache */
   /* replace187_0_2 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 612, 618 },
      -1,
   } },
   /* replace187_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 620, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search188_0 -> 21 in the cache */
   /* search188_1_0 -> 21 in the cache */
   /* search188_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search188_2 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 622, 612 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace188_0_1 -> 41 in the cache */
   /* replace188_0_2 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 624, 41, 612 },
      -1,
   } },
   /* replace188_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 625, 21 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search189_0_0 -> 21 in the cache */
   /* search189_0_1_0 -> 624 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 627 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 624, 628 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 629 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search189_1_1 -> 627 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 631, 627 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 630, 632 },
      -1,
   } },

   /* replace189_0 -> 21 in the cache */
   /* replace189_1 -> 631 in the cache */
   /* replace189_2 -> 627 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 631, 627 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search190_0_0 -> 21 in the cache */
   /* search190_0_1_0_0 -> 624 in the cache */
   /* search190_0_1_0_1_0 -> 627 in the cache */
   /* search190_0_1_0_1 -> 628 in the cache */
   /* search190_0_1_0 -> 629 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 629 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 635 },
      -1,
   } },
   /* search190_1_0 -> 631 in the cache */
   /* search190_1_1_0 -> 627 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 627 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 631, 637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 636, 638 },
      -1,
   } },

   /* replace190_0 -> 21 in the cache */
   /* replace190_1 -> 631 in the cache */
   /* replace190_2_0 -> 627 in the cache */
   /* replace190_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 631, 637 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search191_0 -> 21 in the cache */
   /* search191_1_0 -> 627 in the cache */
   /* search191_1_1_0 -> 631 in the cache */
   /* search191_1_1_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 631, 641 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 627, 642 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 643 },
      -1,
   } },

   /* replace191_0 -> 21 in the cache */
   /* replace191_1 -> 631 in the cache */
   /* replace191_2 -> 627 in the cache */
   /* replace191 -> 634 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search192_0_0 -> 21 in the cache */
   /* search192_0_1_0 -> 624 in the cache */
   /* search192_0_1_1_0_0 -> 504 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 645 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 624, 646 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 647 },
      -1,
   } },
   /* search192_1_0 -> 631 in the cache */
   /* search192_1_1_0 -> 504 in the cache */
   /* search192_1_1 -> 645 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 631, 645 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 648, 649 },
      -1,
   } },

   /* replace192_0 -> 504 in the cache */
   /* replace192_1 -> 631 in the cache */
   /* replace192_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 504, 631, 21 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search193_0 -> 21 in the cache */
   /* search193_1_0_0 -> 504 in the cache */
   /* search193_1_0 -> 645 in the cache */
   /* search193_1_1_0 -> 631 in the cache */
   /* search193_1_1_1_0 -> 21 in the cache */
   /* search193_1_1_1 -> 641 in the cache */
   /* search193_1_1 -> 642 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 645, 642 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 652 },
      -1,
   } },

   /* replace193_0 -> 504 in the cache */
   /* replace193_1 -> 631 in the cache */
   /* replace193_2 -> 21 in the cache */
   /* replace193 -> 651 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search194_0 -> 21 in the cache */
   /* search194_1_0 -> 624 in the cache */
   /* search194_1_1_0_0 -> 504 in the cache */
   /* search194_1_1_0 -> 645 in the cache */
   /* search194_1_1 -> 646 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 624, 646 },
      -1,
   } },
   /* search194_2_0 -> 631 in the cache */
   /* search194_2_1_0 -> 504 in the cache */
   /* search194_2_1 -> 645 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 631, 645 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 21, 654, 655 },
      -1,
   } },

   /* replace194_0 -> 504 in the cache */
   /* replace194_1 -> 631 in the cache */
   /* replace194_2 -> 21 in the cache */
   /* replace194 -> 651 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search195_1_0 -> 504 in the cache */
   /* search195_1 -> 645 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 658 },
      -1,
   } },
   /* search195_2_1_0 -> 504 in the cache */
   /* search195_2_1 -> 645 in the cache */
   /* search195_2_2 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 659, 645, 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 657, 645, 660 },
      -1,
   } },

   /* replace195_0 -> 504 in the cache */
   /* replace195_1 -> 657 in the cache */
   /* replace195_2 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 504, 657, 658 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search196_0_0 -> 523 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 523 },
      -1,
   } },
   /* search196_1_0 -> 41 in the cache */
   /* search196_1_1_0 -> 658 in the cache */
   /* search196_1_1 -> 659 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 41, 659 },
      -1,
   } },
   /* search196_2 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 663, 664, 658 },
      -1,
   } },

   /* replace196_0 -> 523 in the cache */
   /* replace196_1 -> 41 in the cache */
   /* replace196_2 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 523, 41, 658 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search197_0_0 -> 523 in the cache */
   /* search197_0 -> 663 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 667 },
      -1,
   } },
   /* search197_1_1 -> 631 in the cache */
   /* search197_1_2 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 668, 631, 618 },
      -1,
   } },
   /* search197_2_0 -> 667 in the cache */
   /* search197_2_1 -> 631 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 667, 631 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 663, 669, 670 },
      -1,
   } },

   /* replace197_0 -> 523 in the cache */
   /* replace197_1 -> 618 in the cache */
   /* replace197_2_0 -> 667 in the cache */
   /* replace197_2_1 -> 631 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 667, 631 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 523, 618, 672 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search198_0 -> 624 in the cache */
   /* search198_1_0_0_0 -> 624 in the cache */
   /* search198_1_0_0_1_0 -> 21 in the cache */
   /* search198_1_0_0_1 -> 641 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 624, 641 },
      -1,
   } },
   /* search198_1_0_1_0 -> 624 in the cache */
   /* search198_1_0_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 624, 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 674, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 677 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 624, 678 },
      -1,
   } },

   /* replace198_0 -> 41 in the cache */
   /* replace198_1 -> 624 in the cache */
   /* replace198_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 624, 21 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search199_0_0 -> 151 in the cache */
   /* search199_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 151, 152 },
      0,
   } },
   /* search199_1_0 -> 151 in the cache */
   /* search199_1_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 151, 154 },
      0,
   } },
   /* search199_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 681, 682, 155 },
      -1,
   } },

   /* replace199_0_0 -> 152 in the cache */
   /* replace199_0_1 -> 154 in the cache */
   /* replace199_0_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 152, 154, 155 },
      -1,
   } },
   /* replace199_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 684, 151 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search200_0 -> 0 in the cache */
   /* search200_1 -> 258 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 258, 686 },
      -1,
   } },

   /* replace200_0_0_0 -> 0 in the cache */
   /* replace200_0_0 -> 214 in the cache */
   /* replace200_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 214, 686 },
      -1,
   } },
   /* replace200_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 688, 0 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search201_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 11 },
      -1,
   } },

   /* replace201_0_0 -> 11 in the cache */
   /* replace201_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   /* replace201_1_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 692 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 693 },
      -1,
   } },
   /* replace201_2_0_0 -> 11 in the cache */
   /* replace201_2_0 -> 692 in the cache */
   /* replace201_2 -> 693 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 691, 694, 693 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search202_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 16 },
      -1,
   } },

   /* replace202_0_0 -> 16 in the cache */
   /* replace202_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   /* replace202_1_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 698 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 699 },
      -1,
   } },
   /* replace202_2_0_0 -> 16 in the cache */
   /* replace202_2_0 -> 698 in the cache */
   /* replace202_2 -> 699 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 697, 700, 699 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search203_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 21 },
      -1,
   } },

   /* replace203_0_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 703 },
      -1,
   } },
   /* replace203_1_0_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 705 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 706 },
      -1,
   } },
   /* replace203_2_0_0 -> 21 in the cache */
   /* replace203_2_0 -> 705 in the cache */
   /* replace203_2 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 704, 707, 706 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search204_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 11 },
      -1,
   } },

   /* replace204_0 -> 11 in the cache */
   /* replace204_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 11, 710 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search205_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 16 },
      -1,
   } },

   /* replace205_0 -> 16 in the cache */
   /* replace205_1_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 16, 713 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search206_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 21 },
      -1,
   } },

   /* replace206_0 -> 21 in the cache */
   /* replace206_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 21, 716 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search207_0 -> 11 in the cache */
   /* search207_1_0_0 -> 11 in the cache */
   /* search207_1_0 -> 710 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 718 },
      -1,
   } },

   /* replace207_0 -> 11 in the cache */
   /* replace207 -> 709 in the cache */

   /* ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search208_0 -> 16 in the cache */
   /* search208_1_0_0 -> 16 in the cache */
   /* search208_1_0 -> 713 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 713 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 720 },
      -1,
   } },

   /* replace208_0 -> 16 in the cache */
   /* replace208 -> 712 in the cache */

   /* ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search209_0 -> 21 in the cache */
   /* search209_1_0_0 -> 21 in the cache */
   /* search209_1_0 -> 716 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 716 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 722 },
      -1,
   } },

   /* replace209_0 -> 21 in the cache */
   /* replace209 -> 715 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search210_0 -> 11 in the cache */
   /* search210 -> 710 in the cache */

   /* replace210_0 -> 11 in the cache */
   /* replace210_1_0 -> 11 in the cache */
   /* replace210_1 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 11, 709 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search211_0 -> 16 in the cache */
   /* search211 -> 713 in the cache */

   /* replace211_0 -> 16 in the cache */
   /* replace211_1_0 -> 16 in the cache */
   /* replace211_1 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 16, 712 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search212_0 -> 21 in the cache */
   /* search212 -> 716 in the cache */

   /* replace212_0 -> 21 in the cache */
   /* replace212_1_0 -> 21 in the cache */
   /* replace212_1 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 21, 715 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search213_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace213_0_0_0 -> 32 in the cache */
   /* replace213_0_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 728 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search214_0 -> 11 in the cache */
   /* search214_1 -> 260 in the cache */
   /* search214_2 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 260, 471 },
      -1,
   } },

   /* replace214_0_0 -> 11 in the cache */
   /* replace214_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 11, 260 },
      -1,
   } },
   /* replace214_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 731, 471 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search215_0 -> 16 in the cache */
   /* search215_1 -> 36 in the cache */
   /* search215_2 -> 137 in the cache */
   /* search215 -> 236 in the cache */

   /* replace215_0_0 -> 16 in the cache */
   /* replace215_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace215_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 733, 137 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search216_0 -> 21 in the cache */
   /* search216_1 -> 41 in the cache */
   /* search216_2 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 612 },
      -1,
   } },

   /* replace216_0_0 -> 21 in the cache */
   /* replace216_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace216_1 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 736, 612 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search217_0 -> 16 in the cache */
   /* search217_1 -> 36 in the cache */
   /* search217_2 -> 137 in the cache */
   /* search217 -> 389 in the cache */

   /* replace217_0_0 -> 16 in the cache */
   /* replace217_0_1 -> 36 in the cache */
   /* replace217_0 -> 136 in the cache */
   /* replace217_1 -> 137 in the cache */
   /* replace217 -> 290 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search218_0 -> 11 in the cache */
   /* search218_1 -> 260 in the cache */
   /* search218_2 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 260, 471 },
      -1,
   } },

   /* replace218_0_0 -> 11 in the cache */
   /* replace218_0_1 -> 260 in the cache */
   /* replace218_0 -> 731 in the cache */
   /* replace218_1 -> 471 in the cache */
   /* replace218 -> 732 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search219_0 -> 16 in the cache */
   /* search219_1 -> 36 in the cache */
   /* search219_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace219_0_0 -> 16 in the cache */
   /* replace219_0_1 -> 36 in the cache */
   /* replace219_0 -> 733 in the cache */
   /* replace219_1 -> 137 in the cache */
   /* replace219 -> 734 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search220_0 -> 21 in the cache */
   /* search220_1 -> 41 in the cache */
   /* search220_2 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 612 },
      -1,
   } },

   /* replace220_0_0 -> 21 in the cache */
   /* replace220_0_1 -> 41 in the cache */
   /* replace220_0 -> 736 in the cache */
   /* replace220_1 -> 612 in the cache */
   /* replace220 -> 737 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search221_0 -> 16 in the cache */
   /* search221_1 -> 36 in the cache */
   /* search221_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace221_0_0 -> 16 in the cache */
   /* replace221_0_1 -> 36 in the cache */
   /* replace221_0 -> 136 in the cache */
   /* replace221_1 -> 137 in the cache */
   /* replace221 -> 290 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 742 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 743 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 745, 746 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 744, 747 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 748, 749 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 750, 751 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace222_1_0_0_0 -> 745 in the cache */
   /* replace222_1_0_0_1 -> 746 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 745, 746 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 754, 755 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 756, 757 },
      -1,
   } },
   /* replace222_2_0 -> 755 in the cache */
   /* replace222_2_1 -> 757 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 755, 757 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 753, 758, 759 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search223_0 -> 0 in the cache */
   /* search223_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace223_0_3 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 762, 763, 764, 272 },
      -1,
   } },
   /* replace223_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 765, 3 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search224_0_0 -> 151 in the cache */
   /* search224_0_1 -> 152 in the cache */
   /* search224_0_2 -> 154 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 151, 152, 154, 767 },
      -1,
   } },
   /* search224_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 768, 155 },
      -1,
   } },

   /* replace224_0_0 -> 151 in the cache */
   /* replace224_0_1 -> 152 in the cache */
   /* replace224_0_2 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 151, 152, 154 },
      -1,
   } },
   /* replace224_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 770, 155 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search225_0_0 -> 0 in the cache */
   /* search225_0_1 -> 258 in the cache */
   /* search225_0_2 -> 258 in the cache */
   /* search225_0_3 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 258, 258, 258 },
      -1,
   } },
   /* search225_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 772, 3 },
      -1,
   } },

   /* replace225_0 -> 0 in the cache */
   /* replace225_1 -> 3 in the cache */
   /* replace225 -> 266 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search226_0_0 -> 128 in the cache */
   /* search226_0_1 -> 129 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search226_0_3 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 128, 129, 774, 774 },
      -1,
   } },
   /* search226_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 775, 131 },
      -1,
   } },

   /* replace226_0_0 -> 128 in the cache */
   /* replace226_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace226_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 777, 131 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search227_0_0 -> 151 in the cache */
   /* search227_0_1 -> 152 in the cache */
   /* search227_0_2 -> 154 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 151, 152, 154, 779 },
      -1,
   } },
   /* search227_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 780, 155 },
      -1,
   } },

   /* replace227_0_0 -> 151 in the cache */
   /* replace227_0_1 -> 152 in the cache */
   /* replace227_0_2 -> 154 in the cache */
   /* replace227_0 -> 770 in the cache */
   /* replace227_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 770, 155 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search228_0_0 -> 0 in the cache */
   /* search228_0_1 -> 258 in the cache */
   /* search228_0_2 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 258, 258 },
      -1,
   } },
   /* search228_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 783, 3 },
      -1,
   } },

   /* replace228_0 -> 0 in the cache */
   /* replace228_1 -> 3 in the cache */
   /* replace228 -> 266 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search229_0_0 -> 128 in the cache */
   /* search229_0_1 -> 129 in the cache */
   /* search229_0_2 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 128, 129, 774 },
      -1,
   } },
   /* search229_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 785, 131 },
      -1,
   } },

   /* replace229_0_0 -> 128 in the cache */
   /* replace229_0_1 -> 129 in the cache */
   /* replace229_0 -> 777 in the cache */
   /* replace229_1 -> 131 in the cache */
   /* replace229 -> 778 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search230_0_0 -> 0 in the cache */
   /* search230_0_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 258 },
      -1,
   } },
   /* search230_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 787, 3 },
      -1,
   } },

   /* replace230_0 -> 0 in the cache */
   /* replace230_1 -> 3 in the cache */
   /* replace230 -> 266 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search231_0 -> 32 in the cache */
   /* search231_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 32, 243 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 790, 791 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search232_0 -> 0 in the cache */
   /* search232_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace232_0_0 -> 0 in the cache */
   /* replace232_0_1 -> 3 in the cache */
   /* replace232_0 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 266 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search233_0 -> 0 in the cache */
   /* search233_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace233_0_0 -> 0 in the cache */
   /* replace233_0_1 -> 3 in the cache */
   /* replace233_0 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 266 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search234_0 -> 0 in the cache */
   /* search234_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace234_0_0 -> 0 in the cache */
   /* replace234_0_1 -> 3 in the cache */
   /* replace234_0 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 266 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search235_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace235_0 -> 790 in the cache */
   /* replace235_1 -> 791 in the cache */
   /* replace235 -> 792 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 800 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 801 },
      0,
   } },
   /* search236_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 802, 243 },
      -1,
   } },

   /* replace236_0_0 -> 243 in the cache */
   /* replace236_0_1_0 -> 32 in the cache */
   /* replace236_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 243, 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 804 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search237_0_0_0 -> 128 in the cache */
   /* search237_0_0_1 -> 285 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 285 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 806, 807 },
      -1,
   } },
   /* search237_1 -> 313 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 808, 313 },
      -1,
   } },

   /* replace237_0_0 -> 128 in the cache */
   /* replace237_0_1_0 -> 129 in the cache */
   /* replace237_0_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 129, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 810 },
      -1,
   } },
   /* replace237_1_0 -> 131 in the cache */
   /* replace237_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 131, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 811, 812 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search238_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 814 },
      -1,
   } },
   /* search238_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 815, 311 },
      -1,
   } },

   /* replace238_0 -> 0 in the cache */
   /* replace238_1_0 -> 3 in the cache */
   /* replace238_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 3, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 817 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search239_0_0 -> 6 in the cache */
   /* search239_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search239_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 819, 311 },
      -1,
   } },

   /* replace239_0_0_0_0 -> 36 in the cache */
   /* replace239_0_0_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 9 },
      -1,
   } },
   /* replace239_0_0_1_0 -> 137 in the cache */
   /* replace239_0_0_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 821, 822 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8 /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 823, 824 },
      -1,
   } },
   /* replace239_1_0 -> 6 in the cache */
   /* replace239_1_1_0 -> 36 in the cache */
   /* replace239_1_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 36, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 826 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 825, 827, 828 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search240_0_0 -> 6 in the cache */
   /* search240_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search240_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 830, 311 },
      -1,
   } },

   /* replace240_0_0_0_0 -> 36 in the cache */
   /* replace240_0_0_0_1 -> 9 in the cache */
   /* replace240_0_0_0 -> 821 in the cache */
   /* replace240_0_0_1_0 -> 137 in the cache */
   /* replace240_0_0_1_1 -> 9 in the cache */
   /* replace240_0_0_1 -> 822 in the cache */
   /* replace240_0_0 -> 823 in the cache */
   /* replace240_0_1 -> 824 in the cache */
   /* replace240_0 -> 825 in the cache */
   /* replace240_1_0 -> 6 in the cache */
   /* replace240_1_1_0 -> 36 in the cache */
   /* replace240_1_1_1 -> 137 in the cache */
   /* replace240_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 826 },
      -1,
   } },
   /* replace240_2 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 825, 832, 828 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search241_0_0 -> 6 in the cache */
   /* search241_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search241_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 834, 311 },
      -1,
   } },

   /* replace241_0 -> 6 in the cache */
   /* replace241_1_0_0_0 -> 36 in the cache */
   /* replace241_1_0_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 9 },
      -1,
   } },
   /* replace241_1_0_1_0 -> 137 in the cache */
   /* replace241_1_0_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 836, 837 },
      -1,
   } },
   /* replace241_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 838, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 6, 839 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search242_0_0 -> 11 in the cache */
   /* search242_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search242_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 841, 311 },
      -1,
   } },

   /* replace242_0_0_0_0 -> 36 in the cache */
   /* replace242_0_0_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 14 },
      -1,
   } },
   /* replace242_0_0_1_0 -> 137 in the cache */
   /* replace242_0_0_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 843, 844 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10 /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 845, 846 },
      -1,
   } },
   /* replace242_1_0 -> 11 in the cache */
   /* replace242_1_1_0 -> 36 in the cache */
   /* replace242_1_1_1 -> 137 in the cache */
   /* replace242_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 826 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 847, 848, 849 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search243_0_0 -> 11 in the cache */
   /* search243_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search243_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 851, 311 },
      -1,
   } },

   /* replace243_0_0_0_0 -> 36 in the cache */
   /* replace243_0_0_0_1 -> 14 in the cache */
   /* replace243_0_0_0 -> 843 in the cache */
   /* replace243_0_0_1_0 -> 137 in the cache */
   /* replace243_0_0_1_1 -> 14 in the cache */
   /* replace243_0_0_1 -> 844 in the cache */
   /* replace243_0_0 -> 845 in the cache */
   /* replace243_0_1 -> 846 in the cache */
   /* replace243_0 -> 847 in the cache */
   /* replace243_1_0 -> 11 in the cache */
   /* replace243_1_1_0 -> 36 in the cache */
   /* replace243_1_1_1 -> 137 in the cache */
   /* replace243_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 826 },
      -1,
   } },
   /* replace243_2 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 847, 853, 849 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search244_0_0 -> 11 in the cache */
   /* search244_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search244_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 855, 311 },
      -1,
   } },

   /* replace244_0 -> 11 in the cache */
   /* replace244_1_0_0_0 -> 36 in the cache */
   /* replace244_1_0_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 14 },
      -1,
   } },
   /* replace244_1_0_1_0 -> 137 in the cache */
   /* replace244_1_0_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 857, 858 },
      -1,
   } },
   /* replace244_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 859, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 11, 860 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search245_0_0 -> 16 in the cache */
   /* search245_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search245_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 862, 311 },
      -1,
   } },

   /* replace245_0_0_0_0 -> 36 in the cache */
   /* replace245_0_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 19 },
      -1,
   } },
   /* replace245_0_0_1_0 -> 137 in the cache */
   /* replace245_0_0_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 864, 865 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20 /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 866, 867 },
      -1,
   } },
   /* replace245_1_0 -> 16 in the cache */
   /* replace245_1_1_0 -> 36 in the cache */
   /* replace245_1_1_1 -> 137 in the cache */
   /* replace245_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 826 },
      -1,
   } },
   /* replace245_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 868, 869, 124 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search246_0_0 -> 16 in the cache */
   /* search246_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search246_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 871, 311 },
      -1,
   } },

   /* replace246_0_0_0_0 -> 36 in the cache */
   /* replace246_0_0_0_1 -> 19 in the cache */
   /* replace246_0_0_0 -> 864 in the cache */
   /* replace246_0_0_1_0 -> 137 in the cache */
   /* replace246_0_0_1_1 -> 19 in the cache */
   /* replace246_0_0_1 -> 865 in the cache */
   /* replace246_0_0 -> 866 in the cache */
   /* replace246_0_1 -> 867 in the cache */
   /* replace246_0 -> 868 in the cache */
   /* replace246_1_0 -> 16 in the cache */
   /* replace246_1_1_0 -> 36 in the cache */
   /* replace246_1_1_1 -> 137 in the cache */
   /* replace246_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 826 },
      -1,
   } },
   /* replace246_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 868, 873, 124 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search247_0_0 -> 16 in the cache */
   /* search247_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search247_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 875, 311 },
      -1,
   } },

   /* replace247_0 -> 16 in the cache */
   /* replace247_1_0_0_0 -> 36 in the cache */
   /* replace247_1_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 19 },
      -1,
   } },
   /* replace247_1_0_1_0 -> 137 in the cache */
   /* replace247_1_0_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 877, 878 },
      -1,
   } },
   /* replace247_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 879, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 16, 880 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search248_0_0 -> 21 in the cache */
   /* search248_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search248_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 882, 311 },
      -1,
   } },

   /* replace248_0_0_0_0 -> 36 in the cache */
   /* replace248_0_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 24 },
      -1,
   } },
   /* replace248_0_0_1_0 -> 137 in the cache */
   /* replace248_0_0_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 884, 885 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40 /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 886, 887 },
      -1,
   } },
   /* replace248_1_0 -> 21 in the cache */
   /* replace248_1_1_0 -> 36 in the cache */
   /* replace248_1_1_1 -> 137 in the cache */
   /* replace248_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 826 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 888, 889, 890 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search249_0_0 -> 21 in the cache */
   /* search249_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search249_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 892, 311 },
      -1,
   } },

   /* replace249_0_0_0_0 -> 36 in the cache */
   /* replace249_0_0_0_1 -> 24 in the cache */
   /* replace249_0_0_0 -> 884 in the cache */
   /* replace249_0_0_1_0 -> 137 in the cache */
   /* replace249_0_0_1_1 -> 24 in the cache */
   /* replace249_0_0_1 -> 885 in the cache */
   /* replace249_0_0 -> 886 in the cache */
   /* replace249_0_1 -> 887 in the cache */
   /* replace249_0 -> 888 in the cache */
   /* replace249_1_0 -> 21 in the cache */
   /* replace249_1_1_0 -> 36 in the cache */
   /* replace249_1_1_1 -> 137 in the cache */
   /* replace249_1_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 826 },
      -1,
   } },
   /* replace249_2 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 888, 894, 890 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search250_0_0 -> 21 in the cache */
   /* search250_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search250_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 896, 311 },
      -1,
   } },

   /* replace250_0 -> 21 in the cache */
   /* replace250_1_0_0_0 -> 36 in the cache */
   /* replace250_1_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 24 },
      -1,
   } },
   /* replace250_1_0_1_0 -> 137 in the cache */
   /* replace250_1_0_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 898, 899 },
      -1,
   } },
   /* replace250_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 900, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 21, 901 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search251_0_0 -> 6 in the cache */
   /* search251_0_1 -> 33 in the cache */
   /* search251_0 -> 830 in the cache */
   /* search251_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 830, 36 },
      -1,
   } },

   /* replace251_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   /* replace251_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 904, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 905 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search252_0_0 -> 6 in the cache */
   /* search252_0_1 -> 33 in the cache */
   /* search252_0 -> 834 in the cache */
   /* search252_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 834, 36 },
      -1,
   } },

   /* replace252_0 -> 6 in the cache */
   /* replace252_1_0 -> 904 in the cache */
   /* replace252_1_1 -> 36 in the cache */
   /* replace252_1 -> 905 in the cache */
   /* replace252 -> 906 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search253_0_0 -> 6 in the cache */
   /* search253_0_1 -> 33 in the cache */
   /* search253_0 -> 819 in the cache */
   /* search253_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 819, 36 },
      -1,
   } },

   /* replace253_0 -> 6 in the cache */
   /* replace253_1_0 -> 904 in the cache */
   /* replace253_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 904, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 909 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search254_0_0 -> 11 in the cache */
   /* search254_0_1 -> 33 in the cache */
   /* search254_0 -> 851 in the cache */
   /* search254_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 851, 36 },
      -1,
   } },

   /* replace254_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   /* replace254_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 912, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 913 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search255_0_0 -> 11 in the cache */
   /* search255_0_1 -> 33 in the cache */
   /* search255_0 -> 855 in the cache */
   /* search255_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 855, 36 },
      -1,
   } },

   /* replace255_0 -> 11 in the cache */
   /* replace255_1_0 -> 912 in the cache */
   /* replace255_1_1 -> 36 in the cache */
   /* replace255_1 -> 913 in the cache */
   /* replace255 -> 914 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search256_0_0 -> 11 in the cache */
   /* search256_0_1 -> 33 in the cache */
   /* search256_0 -> 841 in the cache */
   /* search256_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 841, 36 },
      -1,
   } },

   /* replace256_0 -> 11 in the cache */
   /* replace256_1_0 -> 912 in the cache */
   /* replace256_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 912, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 917 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search257_0_0 -> 16 in the cache */
   /* search257_0_1 -> 33 in the cache */
   /* search257_0 -> 871 in the cache */
   /* search257_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 871, 36 },
      -1,
   } },

   /* replace257_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffff /* 4294967295 */ },
   } },
   /* replace257_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 920, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 921 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search258_0_0 -> 16 in the cache */
   /* search258_0_1 -> 33 in the cache */
   /* search258_0 -> 875 in the cache */
   /* search258_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 875, 36 },
      -1,
   } },

   /* replace258_0 -> 16 in the cache */
   /* replace258_1_0 -> 920 in the cache */
   /* replace258_1_1 -> 36 in the cache */
   /* replace258_1 -> 921 in the cache */
   /* replace258 -> 922 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search259_0_0 -> 16 in the cache */
   /* search259_0_1 -> 33 in the cache */
   /* search259_0 -> 862 in the cache */
   /* search259_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 862, 36 },
      -1,
   } },

   /* replace259_0 -> 16 in the cache */
   /* replace259_1_0 -> 920 in the cache */
   /* replace259_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 920, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 925 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search260_0_0 -> 21 in the cache */
   /* search260_0_1 -> 33 in the cache */
   /* search260_0 -> 892 in the cache */
   /* search260_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 892, 36 },
      -1,
   } },

   /* replace260_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   /* replace260_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 928, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 929 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search261_0_0 -> 21 in the cache */
   /* search261_0_1 -> 33 in the cache */
   /* search261_0 -> 896 in the cache */
   /* search261_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 896, 36 },
      -1,
   } },

   /* replace261_0 -> 21 in the cache */
   /* replace261_1_0 -> 928 in the cache */
   /* replace261_1_1 -> 36 in the cache */
   /* replace261_1 -> 929 in the cache */
   /* replace261 -> 930 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search262_0_0 -> 21 in the cache */
   /* search262_0_1 -> 33 in the cache */
   /* search262_0 -> 882 in the cache */
   /* search262_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 882, 36 },
      -1,
   } },

   /* replace262_0 -> 21 in the cache */
   /* replace262_1_0 -> 928 in the cache */
   /* replace262_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 928, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 933 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search263_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 935 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 936, 937 },
      -1,
   } },

   /* replace263_0 -> 16 in the cache */
   /* replace263_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search264_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 940 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 941, 942 },
      -1,
   } },

   /* replace264_0 -> 0 in the cache */
   /* replace264_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search265_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 945 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffe /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 946, 947 },
      -1,
   } },

   /* replace265_0_0 -> 16 in the cache */
   /* replace265_0_1 -> 947 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 947 },
      -1,
   } },
   /* replace265_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 949, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search266_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 951 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffc /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 952, 953 },
      -1,
   } },

   /* replace266_0_0 -> 16 in the cache */
   /* replace266_0_1 -> 953 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 953 },
      -1,
   } },
   /* replace266_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 955, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search267_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 957 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8 /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 958, 959 },
      -1,
   } },

   /* replace267_0_0 -> 16 in the cache */
   /* replace267_0_1 -> 959 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 959 },
      -1,
   } },
   /* replace267_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 961, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search268_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 963 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0 /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 964, 965 },
      -1,
   } },

   /* replace268_0_0 -> 16 in the cache */
   /* replace268_0_1 -> 965 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 965 },
      -1,
   } },
   /* replace268_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 967, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search269_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 969 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0 /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 970, 971 },
      -1,
   } },

   /* replace269_0_0 -> 16 in the cache */
   /* replace269_0_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 971 },
      -1,
   } },
   /* replace269_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 973, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search270_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 975 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0 /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 976, 977 },
      -1,
   } },

   /* replace270_0_0 -> 16 in the cache */
   /* replace270_0_1 -> 977 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 977 },
      -1,
   } },
   /* replace270_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 979, 36 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search271_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffff /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 981 },
      -1,
   } },
   /* search271_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 982, 398 },
      -1,
   } },

   /* replace271_0 -> 16 in the cache */
   /* replace271_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 398 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search272_0_0 -> 16 in the cache */
   /* search272_0_1 -> 398 in the cache */
   /* search272_0 -> 984 in the cache */
   /* search272_1 -> 947 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 984, 947 },
      -1,
   } },

   /* replace272_0 -> 16 in the cache */
   /* replace272_1 -> 398 in the cache */
   /* replace272 -> 984 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search273_0_0 -> 16 in the cache */
   /* search273_0_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 398 },
      -1,
   } },
   /* search273_1 -> 981 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 986, 981 },
      -1,
   } },

   /* replace273_0 -> 16 in the cache */
   /* replace273_1 -> 398 in the cache */
   /* replace273 -> 986 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search274_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffff /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 988 },
      -1,
   } },
   /* search274_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 989, 403 },
      -1,
   } },

   /* replace274_0 -> 16 in the cache */
   /* replace274_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 403 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search275_0_0 -> 16 in the cache */
   /* search275_0_1 -> 403 in the cache */
   /* search275_0 -> 991 in the cache */
   /* search275_1 -> 953 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 991, 953 },
      -1,
   } },

   /* replace275_0 -> 16 in the cache */
   /* replace275_1 -> 403 in the cache */
   /* replace275 -> 991 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search276_0_0 -> 16 in the cache */
   /* search276_0_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 403 },
      -1,
   } },
   /* search276_1 -> 988 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 993, 988 },
      -1,
   } },

   /* replace276_0 -> 16 in the cache */
   /* replace276_1 -> 403 in the cache */
   /* replace276 -> 993 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search277_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 995 },
      -1,
   } },
   /* search277_1 -> 846 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 996, 846 },
      -1,
   } },

   /* replace277_0 -> 16 in the cache */
   /* replace277_1 -> 846 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 846 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search278_0_0 -> 16 in the cache */
   /* search278_0_1 -> 846 in the cache */
   /* search278_0 -> 998 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000 /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 998, 999 },
      -1,
   } },

   /* replace278_0 -> 16 in the cache */
   /* replace278_1 -> 846 in the cache */
   /* replace278 -> 998 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search279_0_0 -> 16 in the cache */
   /* search279_0_1 -> 846 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 846 },
      -1,
   } },
   /* search279_1 -> 995 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1001, 995 },
      -1,
   } },

   /* replace279_0 -> 16 in the cache */
   /* replace279_1 -> 846 in the cache */
   /* replace279 -> 1001 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search280_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1003 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18 /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1004, 1005 },
      -1,
   } },

   /* replace280_0 -> 16 in the cache */
   /* replace280_1 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 1005 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search281_0_0 -> 16 in the cache */
   /* search281_0_1 -> 1005 in the cache */
   /* search281_0 -> 1007 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000 /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1007, 1008 },
      -1,
   } },

   /* replace281_0 -> 16 in the cache */
   /* replace281_1 -> 1005 in the cache */
   /* replace281 -> 1007 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search282_0_0 -> 16 in the cache */
   /* search282_0_1 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 1005 },
      -1,
   } },
   /* search282_1 -> 1003 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1010, 1003 },
      -1,
   } },

   /* replace282_0 -> 16 in the cache */
   /* replace282_1 -> 1005 in the cache */
   /* replace282 -> 1010 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search283_0_0 -> 0 in the cache */
   /* search283_0_1 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 814 },
      -1,
   } },
   /* search283_1 -> 311 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1012, 311 },
      -1,
   } },

   /* replace283_0_0 -> 0 in the cache */
   /* replace283_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 137 },
      -1,
   } },
   /* replace283_1_0 -> 3 in the cache */
   /* replace283_1_1 -> 137 in the cache */
   /* replace283_1 -> 817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1014, 817 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search284_0_0 -> 128 in the cache */
   /* search284_0_1 -> 285 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 128, 285 },
      0,
   } },
   /* search284_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 1016, 807 },
      -1,
   } },

   /* replace284_0_0 -> 128 in the cache */
   /* replace284_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 131 },
      -1,
   } },
   /* replace284_1_0 -> 129 in the cache */
   /* replace284_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1018, 1019 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search285_0_0_0 -> 151 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 151, 1021 },
      0,
   } },
   /* search285_0_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 1022, 154 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 1023, 1024 },
      -1,
   } },

   /* replace285_0_0_0 -> 151 in the cache */
   /* replace285_0_0_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 151, 154 },
      -1,
   } },
   /* replace285_0_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 1026, 155 },
      -1,
   } },
   /* replace285_1_0 -> 152 in the cache */
   /* replace285_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 152, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 1027, 1028 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search286_0_0_0 -> 128 in the cache */
   /* search286_0_0_1 -> 285 in the cache */
   /* search286_0_0 -> 1016 in the cache */
   /* search286_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1016, 131 },
      0,
   } },
   /* search286_1 -> 313 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 1030, 313 },
      -1,
   } },

   /* replace286_0_0_0 -> 128 in the cache */
   /* replace286_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 128, 131 },
      -1,
   } },
   /* replace286_0_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1032, 165 },
      -1,
   } },
   /* replace286_1_0 -> 129 in the cache */
   /* replace286_1_1 -> 165 in the cache */
   /* replace286_1 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1033, 810 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1035, 1036 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1037 },
      -1,
   } },

   /* replace287_0 -> 0 in the cache */
   /* replace287_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search288_0_0 -> 1035 in the cache */
   /* search288_0_1 -> 1036 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1035, 1036 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1040 },
      -1,
   } },

   /* replace288_0 -> 0 in the cache */
   /* replace288_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search289_0_0 -> 0 in the cache */
   /* search289_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1043 },
      -1,
   } },

   /* replace289_0 -> 0 in the cache */
   /* replace289_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search290_0_0 -> 0 in the cache */
   /* search290_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1046 },
      -1,
   } },

   /* replace290_0 -> 0 in the cache */
   /* replace290_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search291_0_0 -> 0 in the cache */
   /* search291_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1049 },
      -1,
   } },

   /* replace291_0 -> 0 in the cache */
   /* replace291_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search292_0_0 -> 0 in the cache */
   /* search292_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1052 },
      -1,
   } },

   /* replace292_0 -> 0 in the cache */
   /* replace292_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search293_0_0 -> 0 in the cache */
   /* search293_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1055 },
      -1,
   } },

   /* replace293_0 -> 0 in the cache */
   /* replace293_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search294_0_0 -> 0 in the cache */
   /* search294_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1058 },
      -1,
   } },

   /* replace294_0 -> 0 in the cache */
   /* replace294_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search295_0_0 -> 0 in the cache */
   /* search295_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1061 },
      -1,
   } },

   /* replace295_0 -> 0 in the cache */
   /* replace295_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search296_0_0 -> 0 in the cache */
   /* search296_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1064 },
      -1,
   } },

   /* replace296_0 -> 0 in the cache */
   /* replace296_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search297_0_0 -> 0 in the cache */
   /* search297_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search297_1_0 -> 0 in the cache */
   /* search297_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1067, 1068 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search298_0_0 -> 0 in the cache */
   /* search298_0_1 -> 3 in the cache */
   /* search298_0 -> 1042 in the cache */
   /* search298_1_0 -> 3 in the cache */
   /* search298_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1042, 1071 },
      -1,
   } },

   /* replace298 -> 1070 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search299_0_0 -> 0 in the cache */
   /* search299_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search299_1_0 -> 0 in the cache */
   /* search299_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1073, 1074 },
      -1,
   } },

   /* replace299 -> 1070 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search300_0_0 -> 0 in the cache */
   /* search300_0_1 -> 3 in the cache */
   /* search300_0 -> 1057 in the cache */
   /* search300_1_0 -> 3 in the cache */
   /* search300_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1057, 1076 },
      -1,
   } },

   /* replace300 -> 1070 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search301_0_0 -> 0 in the cache */
   /* search301_0_1 -> 3 in the cache */
   /* search301_0 -> 1060 in the cache */
   /* search301_1_0 -> 3 in the cache */
   /* search301_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1060, 1078 },
      -1,
   } },

   /* replace301 -> 1070 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search302_0_0 -> 0 in the cache */
   /* search302_0 -> 214 in the cache */
   /* search302_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 214, 1080 },
      -1,
   } },

   /* replace302_0 -> 3 in the cache */
   /* replace302_1 -> 0 in the cache */
   /* replace302 -> 1071 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search303_0_0 -> 0 in the cache */
   /* search303_0 -> 214 in the cache */
   /* search303_1_0 -> 3 in the cache */
   /* search303_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 214, 1080 },
      -1,
   } },

   /* replace303_0 -> 3 in the cache */
   /* replace303_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search304_0_0 -> 0 in the cache */
   /* search304_0 -> 214 in the cache */
   /* search304_1_0 -> 3 in the cache */
   /* search304_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 214, 1080 },
      -1,
   } },

   /* replace304_0 -> 3 in the cache */
   /* replace304_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search305_0_0 -> 0 in the cache */
   /* search305_0 -> 214 in the cache */
   /* search305_1_0 -> 3 in the cache */
   /* search305_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 214, 1080 },
      -1,
   } },

   /* replace305_0 -> 3 in the cache */
   /* replace305_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a') */
   /* search306_0_0 -> 32 in the cache */
   /* search306_0 -> 98 in the cache */
   /* search306_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 98, 249 },
      -1,
   } },

   /* replace306_0 -> 243 in the cache */
   /* replace306_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 243, 32 },
      -1,
   } },

   /* ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0) */
   /* search307_0 -> 249 in the cache */
   /* search307_1_0 -> 32 in the cache */
   /* search307_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 249, 98 },
      -1,
   } },

   /* replace307_0 -> 32 in the cache */
   /* replace307_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 243 },
      -1,
   } },

   /* ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a') */
   /* search308_0_0 -> 32 in the cache */
   /* search308_0 -> 98 in the cache */
   /* search308_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 98, 249 },
      -1,
   } },

   /* replace308_0 -> 243 in the cache */
   /* replace308_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 243, 32 },
      -1,
   } },

   /* ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0) */
   /* search309_0 -> 249 in the cache */
   /* search309_1_0 -> 32 in the cache */
   /* search309_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 249, 98 },
      -1,
   } },

   /* replace309_0 -> 32 in the cache */
   /* replace309_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 243 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a') */
   /* search310_0_0 -> 32 in the cache */
   /* search310_0 -> 98 in the cache */
   /* search310_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 249 },
      -1,
   } },

   /* replace310_0 -> 243 in the cache */
   /* replace310_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 243, 32 },
      -1,
   } },

   /* ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0) */
   /* search311_0 -> 249 in the cache */
   /* search311_1_0 -> 32 in the cache */
   /* search311_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 249, 98 },
      -1,
   } },

   /* replace311_0 -> 32 in the cache */
   /* replace311_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 243 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1101 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1100, 1102 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace312_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1104, 1101 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search313_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1106, 1107 },
      -1,
   } },

   /* replace313_0 -> 0 in the cache */
   /* replace313_1 -> 3 in the cache */
   /* replace313 -> 1039 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search314_0_0 -> 0 in the cache */
   /* search314_0 -> 1106 in the cache */
   /* search314_1 -> 1107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1106, 1107 },
      -1,
   } },

   /* replace314_0 -> 0 in the cache */
   /* replace314_1 -> 3 in the cache */
   /* replace314 -> 1048 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search315_0_0 -> 0 in the cache */
   /* search315_0 -> 1106 in the cache */
   /* search315_1 -> 1107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1106, 1107 },
      -1,
   } },

   /* replace315_0 -> 0 in the cache */
   /* replace315_1 -> 3 in the cache */
   /* replace315 -> 1045 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search316_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      0,
   } },
   /* search316_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1111, 243 },
      -1,
   } },

   /* replace316_0 -> 32 in the cache */
   /* replace316_1 -> 243 in the cache */
   /* replace316 -> 1095 in the cache */

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search317_0 -> 113 in the cache */
   /* search317_1_0 -> 32 in the cache */
   /* search317_1 -> 1111 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 1111 },
      -1,
   } },

   /* replace317_0 -> 113 in the cache */
   /* replace317_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search318_1_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 753 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1115, 1116 },
      -1,
   } },

   /* replace318_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 753 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search319_0_0_0 -> 753 in the cache */
   /* search319_0_0 -> 1116 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1116 },
      -1,
   } },
   /* search319_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1119, 1115 },
      -1,
   } },

   /* replace319_0 -> 753 in the cache */
   /* replace319 -> 1118 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search320_0_0_0 -> 753 in the cache */
   /* search320_0_0 -> 1116 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1116, 1122 },
      -1,
   } },
   /* search320_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1123, 1115 },
      -1,
   } },

   /* replace320_0 -> 753 in the cache */
   /* replace320_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 753, 1121 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search321_0_0 -> 753 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search321_0_2_0 -> 1121 in the cache */
   /* search321_0_2 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1126, 1122 },
      -1,
   } },
   /* search321_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1127, 1115 },
      -1,
   } },

   /* replace321_0 -> 753 in the cache */
   /* replace321_1 -> 1121 in the cache */
   /* replace321 -> 1125 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search322_0_0 -> 753 in the cache */
   /* search322_0 -> 1116 in the cache */
   /* search322_1_0_0 -> 1121 in the cache */
   /* search322_1_0 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1122 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1116, 1129 },
      -1,
   } },

   /* replace322_0 -> 753 in the cache */
   /* replace322_1 -> 1121 in the cache */
   /* replace322 -> 1125 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search323_0_0_0 -> 753 in the cache */
   /* search323_0_0 -> 1116 in the cache */
   /* search323_0_1_0 -> 1121 in the cache */
   /* search323_0_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1116, 1122 },
      -1,
   } },
   /* search323_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1131, 1115 },
      -1,
   } },

   /* replace323_0 -> 753 in the cache */
   /* replace323_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 753, 1121 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search324_0_0 -> 753 in the cache */
   /* search324_0_1_0 -> 1121 in the cache */
   /* search324_0_1 -> 1122 in the cache */
   /* search324_0_2 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1122, 1115 },
      -1,
   } },
   /* search324_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1134, 1115 },
      -1,
   } },

   /* replace324_0 -> 753 in the cache */
   /* replace324_1 -> 1121 in the cache */
   /* replace324 -> 1133 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search325_0_0_0 -> 753 in the cache */
   /* search325_0_0 -> 1116 in the cache */
   /* search325_0_1_0_0 -> 1121 in the cache */
   /* search325_0_1_0 -> 1122 in the cache */
   /* search325_0_1 -> 1129 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1116, 1129 },
      -1,
   } },
   /* search325_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1136, 1115 },
      -1,
   } },

   /* replace325_0 -> 753 in the cache */
   /* replace325_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 753, 1121 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search326_0_0 -> 753 in the cache */
   /* search326_0 -> 1116 in the cache */
   /* search326_1_0 -> 1121 in the cache */
   /* search326_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1116, 1122 },
      -1,
   } },

   /* replace326_0 -> 753 in the cache */
   /* replace326_1 -> 1121 in the cache */
   /* replace326 -> 1138 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search327_0_0_0 -> 753 in the cache */
   /* search327_0_0 -> 1116 in the cache */
   /* search327_0 -> 1119 in the cache */
   /* search327_1_0_0 -> 1121 in the cache */
   /* search327_1_0 -> 1122 in the cache */
   /* search327_1 -> 1129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1119, 1129 },
      -1,
   } },

   /* replace327_0 -> 753 in the cache */
   /* replace327_1 -> 1121 in the cache */
   /* replace327 -> 1138 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search328_0_0_0 -> 753 in the cache */
   /* search328_0_0 -> 1116 in the cache */
   /* search328_0_1_0 -> 1121 in the cache */
   /* search328_0_1 -> 1122 in the cache */
   /* search328_0 -> 1123 in the cache */
   /* search328_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1123, 1115 },
      -1,
   } },

   /* replace328_0_0 -> 753 in the cache */
   /* replace328_0_1 -> 1121 in the cache */
   /* replace328_0 -> 1125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1125 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search329_0_0 -> 753 in the cache */
   /* search329_0_1 -> 1126 in the cache */
   /* search329_0_2_0 -> 1121 in the cache */
   /* search329_0_2 -> 1122 in the cache */
   /* search329_0 -> 1127 in the cache */
   /* search329_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1127, 1115 },
      -1,
   } },

   /* replace329_0_0 -> 753 in the cache */
   /* replace329_0_1 -> 1121 in the cache */
   /* replace329_0 -> 1125 in the cache */
   /* replace329 -> 1142 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search330_0_0 -> 753 in the cache */
   /* search330_0 -> 1116 in the cache */
   /* search330_1_0_0 -> 1121 in the cache */
   /* search330_1_0 -> 1122 in the cache */
   /* search330_1 -> 1129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1116, 1129 },
      -1,
   } },

   /* replace330_0_0 -> 753 in the cache */
   /* replace330_0_1 -> 1121 in the cache */
   /* replace330_0 -> 1125 in the cache */
   /* replace330 -> 1142 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search331_0_0_0 -> 753 in the cache */
   /* search331_0_0 -> 1116 in the cache */
   /* search331_0_1_0 -> 1121 in the cache */
   /* search331_0_1 -> 1122 in the cache */
   /* search331_0 -> 1131 in the cache */
   /* search331_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1131, 1115 },
      -1,
   } },

   /* replace331_0_0 -> 753 in the cache */
   /* replace331_0_1 -> 1121 in the cache */
   /* replace331_0 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1133 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search332_0_0 -> 753 in the cache */
   /* search332_0_1_0 -> 1121 in the cache */
   /* search332_0_1 -> 1122 in the cache */
   /* search332_0_2 -> 1115 in the cache */
   /* search332_0 -> 1134 in the cache */
   /* search332_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1134, 1115 },
      -1,
   } },

   /* replace332_0_0 -> 753 in the cache */
   /* replace332_0_1 -> 1121 in the cache */
   /* replace332_0 -> 1133 in the cache */
   /* replace332 -> 1146 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search333_0_0_0 -> 753 in the cache */
   /* search333_0_0 -> 1116 in the cache */
   /* search333_0_1_0_0 -> 1121 in the cache */
   /* search333_0_1_0 -> 1122 in the cache */
   /* search333_0_1 -> 1129 in the cache */
   /* search333_0 -> 1136 in the cache */
   /* search333_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1136, 1115 },
      -1,
   } },

   /* replace333_0 -> 753 in the cache */
   /* replace333_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 753, 1121 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search334_0_0 -> 753 in the cache */
   /* search334_0 -> 1116 in the cache */
   /* search334_1_0 -> 1121 in the cache */
   /* search334_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1116, 1122 },
      -1,
   } },

   /* replace334_0 -> 753 in the cache */
   /* replace334_1 -> 1121 in the cache */
   /* replace334 -> 1149 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search335_0_0_0 -> 753 in the cache */
   /* search335_0_0 -> 1116 in the cache */
   /* search335_0 -> 1119 in the cache */
   /* search335_1_0_0 -> 1121 in the cache */
   /* search335_1_0 -> 1122 in the cache */
   /* search335_1 -> 1129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1119, 1129 },
      -1,
   } },

   /* replace335_0 -> 753 in the cache */
   /* replace335_1 -> 1121 in the cache */
   /* replace335 -> 1149 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search336_0_0_0_0 -> 753 in the cache */
   /* search336_0_0_0 -> 1116 in the cache */
   /* search336_0_0_1_0 -> 1121 in the cache */
   /* search336_0_0_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1116, 1122 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1152 },
      -1,
   } },
   /* search336_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1153, 1115 },
      -1,
   } },

   /* replace336_0 -> 753 in the cache */
   /* replace336_1 -> 1121 in the cache */
   /* replace336 -> 1125 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search337_0 -> 1115 in the cache */
   /* search337_1_0_0 -> 753 in the cache */
   /* search337_1_0 -> 1116 in the cache */
   /* search337_1_1_0 -> 1121 in the cache */
   /* search337_1_1 -> 1122 in the cache */
   /* search337_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1115, 1152 },
      -1,
   } },

   /* replace337_0 -> 753 in the cache */
   /* replace337_1 -> 1121 in the cache */
   /* replace337 -> 1125 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search338_0_0_0_0 -> 753 in the cache */
   /* search338_0_0_0 -> 1116 in the cache */
   /* search338_0_0_1_0 -> 1121 in the cache */
   /* search338_0_0_1 -> 1122 in the cache */
   /* search338_0_0 -> 1152 in the cache */
   /* search338_0 -> 1153 in the cache */
   /* search338_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1153, 1115 },
      -1,
   } },

   /* replace338_0_0 -> 753 in the cache */
   /* replace338_0_1 -> 1121 in the cache */
   /* replace338_0 -> 1125 in the cache */
   /* replace338 -> 1142 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search339_0 -> 1115 in the cache */
   /* search339_1_0_0 -> 753 in the cache */
   /* search339_1_0 -> 1116 in the cache */
   /* search339_1_1_0 -> 1121 in the cache */
   /* search339_1_1 -> 1122 in the cache */
   /* search339_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1115, 1152 },
      -1,
   } },

   /* replace339_0_0 -> 753 in the cache */
   /* replace339_0_1 -> 1121 in the cache */
   /* replace339_0 -> 1125 in the cache */
   /* replace339 -> 1142 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search340_0 -> 32 in the cache */
   /* search340_1_0 -> 32 in the cache */
   /* search340_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace340_0 -> 32 in the cache */
   /* replace340_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 113 },
      -1,
   } },

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search341_0 -> 32 in the cache */
   /* search341_1_0 -> 32 in the cache */
   /* search341_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace341_0 -> 32 in the cache */
   /* replace341_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 113 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1163 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1164, 1166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1167 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1162, 1168 },
      -1,
   } },
   /* search342_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1169, 113 },
      -1,
   } },

   /* replace342_0_0 -> 1162 in the cache */
   /* replace342_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1162, 113 },
      -1,
   } },
   /* replace342_1_0 -> 1163 in the cache */
   /* replace342_1_1 -> 1165 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1163, 1165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1171, 1172 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search343_0_0 -> 0 in the cache */
   /* search343_0_1 -> 3 in the cache */
   /* search343_0 -> 274 in the cache */
   /* search343_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 274, 0 },
      -1,
   } },

   /* replace343_0 -> 3 in the cache */
   /* replace343_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 258 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search344_0_0 -> 0 in the cache */
   /* search344_0_1 -> 3 in the cache */
   /* search344_0 -> 274 in the cache */
   /* search344_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 274, 0 },
      -1,
   } },

   /* replace344_0 -> 3 in the cache */
   /* replace344_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 258 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search345_0_0 -> 0 in the cache */
   /* search345_0_1 -> 3 in the cache */
   /* search345_0 -> 215 in the cache */
   /* search345_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 215, 0 },
      -1,
   } },

   /* replace345_0 -> 3 in the cache */
   /* replace345_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 258 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search346_0_0 -> 0 in the cache */
   /* search346_0_1 -> 3 in the cache */
   /* search346_0 -> 215 in the cache */
   /* search346_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 215, 0 },
      -1,
   } },

   /* replace346_0 -> 3 in the cache */
   /* replace346_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 258 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search347_0_0 -> 128 in the cache */
   /* search347_0_1 -> 285 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 128, 285 },
      0,
   } },
   /* search347_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1182, 807 },
      -1,
   } },

   /* replace347_0 -> 128 in the cache */
   /* replace347_1_0 -> 131 in the cache */
   /* replace347_1_1_0 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 131, 1184 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 128, 1185 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search348_0_0_0 -> 128 in the cache */
   /* search348_0_0_1 -> 285 in the cache */
   /* search348_0_0 -> 1182 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1182 },
      0,
   } },
   /* search348_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1187, 807 },
      -1,
   } },

   /* replace348_0_0_0 -> 131 in the cache */
   /* replace348_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 131, 129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1189 },
      -1,
   } },
   /* replace348_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1190, 128 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search349_0_0 -> 128 in the cache */
   /* search349_0_1 -> 285 in the cache */
   /* search349_0 -> 1182 in the cache */
   /* search349_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1182, 807 },
      -1,
   } },

   /* replace349_0 -> 128 in the cache */
   /* replace349_1_0 -> 131 in the cache */
   /* replace349_1_1_0 -> 129 in the cache */
   /* replace349_1_1 -> 1184 in the cache */
   /* replace349_1 -> 1185 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 128, 1185 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search350_0_0_0 -> 128 in the cache */
   /* search350_0_0_1 -> 285 in the cache */
   /* search350_0_0 -> 1182 in the cache */
   /* search350_0 -> 1187 in the cache */
   /* search350_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1187, 807 },
      -1,
   } },

   /* replace350_0_0_0 -> 131 in the cache */
   /* replace350_0_0_1 -> 129 in the cache */
   /* replace350_0_0 -> 1189 in the cache */
   /* replace350_0 -> 1190 in the cache */
   /* replace350_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1190, 128 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search351_0_0 -> 128 in the cache */
   /* search351_0_1 -> 285 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 128, 285 },
      0,
   } },
   /* search351_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1196, 807 },
      -1,
   } },

   /* replace351_0 -> 128 in the cache */
   /* replace351_1_0 -> 131 in the cache */
   /* replace351_1_1_0 -> 129 in the cache */
   /* replace351_1_1 -> 1184 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 131, 1184 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 128, 1198 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search352_0_0_0 -> 128 in the cache */
   /* search352_0_0_1 -> 285 in the cache */
   /* search352_0_0 -> 1196 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1196 },
      0,
   } },
   /* search352_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1200, 807 },
      -1,
   } },

   /* replace352_0_0_0 -> 131 in the cache */
   /* replace352_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 131, 129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1202 },
      -1,
   } },
   /* replace352_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1203, 128 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search353_0_0 -> 128 in the cache */
   /* search353_0_1 -> 285 in the cache */
   /* search353_0 -> 1196 in the cache */
   /* search353_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1196, 807 },
      -1,
   } },

   /* replace353_0 -> 128 in the cache */
   /* replace353_1_0 -> 131 in the cache */
   /* replace353_1_1_0 -> 129 in the cache */
   /* replace353_1_1 -> 1184 in the cache */
   /* replace353_1 -> 1198 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 128, 1198 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search354_0_0_0 -> 128 in the cache */
   /* search354_0_0_1 -> 285 in the cache */
   /* search354_0_0 -> 1196 in the cache */
   /* search354_0 -> 1200 in the cache */
   /* search354_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1200, 807 },
      -1,
   } },

   /* replace354_0_0_0 -> 131 in the cache */
   /* replace354_0_0_1 -> 129 in the cache */
   /* replace354_0_0 -> 1202 in the cache */
   /* replace354_0 -> 1203 in the cache */
   /* replace354_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1203, 128 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search355_0_0 -> 0 in the cache */
   /* search355_0_1 -> 3 in the cache */
   /* search355_0 -> 210 in the cache */
   /* search355_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 210, 0 },
      -1,
   } },

   /* replace355_0 -> 3 in the cache */
   /* replace355_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search356_0_0 -> 0 in the cache */
   /* search356_0_1 -> 3 in the cache */
   /* search356_0 -> 210 in the cache */
   /* search356_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 210, 0 },
      -1,
   } },

   /* replace356_0 -> 3 in the cache */
   /* replace356_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search357_0_0 -> 753 in the cache */
   /* search357_0 -> 1116 in the cache */
   /* search357_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1116, 1115 },
      -1,
   } },

   /* replace357_0 -> 753 in the cache */
   /* replace357 -> 1118 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search358_0_0 -> 753 in the cache */
   /* search358_0 -> 1116 in the cache */
   /* search358_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1116, 1115 },
      -1,
   } },

   /* replace358 -> 753 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search359_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 753 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1215, 1216 },
      -1,
   } },

   /* replace359_0 -> 753 in the cache */
   /* replace359 -> 1118 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search360_0_0 -> 753 in the cache */
   /* search360_0 -> 1215 in the cache */
   /* search360_1 -> 1216 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1215, 1216 },
      -1,
   } },

   /* replace360 -> 753 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search361_0_0 -> 32 in the cache */
   /* search361_0 -> 104 in the cache */
   /* search361_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 104, 1115 },
      -1,
   } },

   /* replace361_0 -> 32 in the cache */
   /* replace361_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search362_0_0 -> 32 in the cache */
   /* search362_0 -> 104 in the cache */
   /* search362_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 104, 1115 },
      -1,
   } },

   /* replace362_0 -> 32 in the cache */
   /* replace362_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search363_0_0 -> 32 in the cache */
   /* search363_0 -> 104 in the cache */
   /* search363_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 104, 1115 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search364_0 -> 1115 in the cache */
   /* search364_1_0 -> 32 in the cache */
   /* search364_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1115, 104 },
      -1,
   } },

   /* replace364_0 -> 61 in the cache */
   /* replace364_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search365_0_0 -> 32 in the cache */
   /* search365_0 -> 104 in the cache */
   /* search365_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 104, 1115 },
      -1,
   } },

   /* replace365 -> 1070 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search366_0 -> 1115 in the cache */
   /* search366_1_0 -> 32 in the cache */
   /* search366_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1115, 104 },
      -1,
   } },

   /* replace366_0 -> 61 in the cache */
   /* replace366_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search367_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search367_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1230, 1115 },
      -1,
   } },

   /* replace367_0 -> 32 in the cache */
   /* replace367_1 -> 61 in the cache */
   /* replace367 -> 1220 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search368_0_0 -> 32 in the cache */
   /* search368_0 -> 1230 in the cache */
   /* search368_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1230, 1115 },
      -1,
   } },

   /* replace368_0 -> 32 in the cache */
   /* replace368_1 -> 61 in the cache */
   /* replace368 -> 1222 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search369_0_0 -> 32 in the cache */
   /* search369_0 -> 1230 in the cache */
   /* search369_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1230, 1115 },
      -1,
   } },

   /* replace369_0 -> 32 in the cache */
   /* replace369_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search370_0 -> 1115 in the cache */
   /* search370_1_0 -> 32 in the cache */
   /* search370_1 -> 1230 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1115, 1230 },
      -1,
   } },

   /* replace370_0 -> 61 in the cache */
   /* replace370_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search371_0_0 -> 32 in the cache */
   /* search371_0 -> 1230 in the cache */
   /* search371_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1230, 1115 },
      -1,
   } },

   /* replace371_0 -> 32 in the cache */
   /* replace371_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search372_0 -> 1115 in the cache */
   /* search372_1_0 -> 32 in the cache */
   /* search372_1 -> 1230 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1115, 1230 },
      -1,
   } },

   /* replace372_0 -> 61 in the cache */
   /* replace372_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search373_0 -> 113 in the cache */
   /* search373_1_0 -> 32 in the cache */
   /* search373_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace373_0 -> 32 in the cache */
   /* replace373_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search374_0_0_0 -> 32 in the cache */
   /* search374_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 103 },
      -1,
   } },
   /* search374_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1243, 113 },
      -1,
   } },

   /* replace374_0 -> 32 in the cache */
   /* replace374_1 -> 113 in the cache */
   /* replace374 -> 1242 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search375_0 -> 113 in the cache */
   /* search375_1_0 -> 32 in the cache */
   /* search375_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace375_0 -> 32 in the cache */
   /* replace375_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search376_0_0_0 -> 32 in the cache */
   /* search376_0_0 -> 103 in the cache */
   /* search376_0 -> 1243 in the cache */
   /* search376_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1243, 113 },
      -1,
   } },

   /* replace376_0 -> 32 in the cache */
   /* replace376_1 -> 113 in the cache */
   /* replace376 -> 1246 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search377_0_0 -> 32 in the cache */
   /* search377_0_1 -> 113 in the cache */
   /* search377_0 -> 1161 in the cache */
   /* search377_1_0 -> 243 in the cache */
   /* search377_1_1 -> 32 in the cache */
   /* search377_1 -> 1093 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1161, 1093 },
      -1,
   } },

   /* replace377_0 -> 32 in the cache */
   /* replace377_1_0 -> 32 in the cache */
   /* replace377_1 -> 219 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 219 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search378_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 753 },
      0,
   } },
   /* search378_1_0 -> 1121 in the cache */
   /* search378_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1250, 1122 },
      -1,
   } },

   /* replace378_0_0 -> 753 in the cache */
   /* replace378_0_1 -> 1121 in the cache */
   /* replace378_0 -> 1125 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1125 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search379_0_0_0 -> 753 in the cache */
   /* search379_0_0 -> 1250 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1250 },
      0,
   } },
   /* search379_1_0_0 -> 1121 in the cache */
   /* search379_1_0 -> 1122 in the cache */
   /* search379_1 -> 1129 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1253, 1129 },
      -1,
   } },

   /* replace379_0_0_0 -> 753 in the cache */
   /* replace379_0_0_1 -> 1121 in the cache */
   /* replace379_0_0 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1255 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search380_0_0 -> 753 in the cache */
   /* search380_0 -> 1250 in the cache */
   /* search380_1_0 -> 1121 in the cache */
   /* search380_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1250, 1122 },
      -1,
   } },

   /* replace380_0_0 -> 753 in the cache */
   /* replace380_0_1 -> 1121 in the cache */
   /* replace380_0 -> 1133 in the cache */
   /* replace380 -> 1255 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search381_0_0_0 -> 753 in the cache */
   /* search381_0_0 -> 1250 in the cache */
   /* search381_0 -> 1253 in the cache */
   /* search381_1_0_0 -> 1121 in the cache */
   /* search381_1_0 -> 1122 in the cache */
   /* search381_1 -> 1129 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1253, 1129 },
      -1,
   } },

   /* replace381_0_0_0 -> 753 in the cache */
   /* replace381_0_0_1 -> 1121 in the cache */
   /* replace381_0_0 -> 1125 in the cache */
   /* replace381_0 -> 1252 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1252 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search382_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search382_1 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1260, 814 },
      -1,
   } },

   /* replace382_0 -> 753 in the cache */
   /* replace382_1_0 -> 3 in the cache */
   /* replace382_1_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 3, 272 },
      -1,
   } },
   /* replace382_2_0 -> 3 in the cache */
   /* replace382_2_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 3, 258 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 753, 1262, 1263 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search383_0_0 -> 0 in the cache */
   /* search383_0_1_0 -> 3 in the cache */
   /* search383_0_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1080 },
      0,
   } },
   /* search383_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1265, 258 },
      -1,
   } },

   /* replace383_0 -> 0 in the cache */
   /* replace383_1 -> 3 in the cache */
   /* replace383 -> 1042 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search384_0_0_0 -> 32 in the cache */
   /* search384_0_0 -> 103 in the cache */
   /* search384_0 -> 1243 in the cache */
   /* search384_1 -> 113 in the cache */
   /* search384 -> 1247 in the cache */

   /* replace384_0 -> 32 in the cache */
   /* replace384_1 -> 113 in the cache */
   /* replace384 -> 1246 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search385_0_0 -> 1104 in the cache */
   /* search385_0_1 -> 1101 in the cache */
   /* search385_0 -> 1105 in the cache */
   /* search385_1 -> 1104 in the cache */
   /* search385_2 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1105, 1104, 1101 },
      -1,
   } },

   /* replace385_0 -> 1101 in the cache */
   /* replace385_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1101, 1104 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search386_0_0 -> 0 in the cache */
   /* search386_0_1 -> 3 in the cache */
   /* search386_0 -> 1042 in the cache */
   /* search386_1 -> 3 in the cache */
   /* search386_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1042, 3, 0 },
      -1,
   } },

   /* replace386_0 -> 0 in the cache */
   /* replace386_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search387_0_0 -> 0 in the cache */
   /* search387_0_1 -> 3 in the cache */
   /* search387_0 -> 1039 in the cache */
   /* search387_1 -> 3 in the cache */
   /* search387_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1039, 3, 0 },
      -1,
   } },

   /* replace387_0 -> 0 in the cache */
   /* replace387_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search388_0_0 -> 1104 in the cache */
   /* search388_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1104, 1101 },
      -1,
   } },
   /* search388_1 -> 1104 in the cache */
   /* search388_2 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1273, 1104, 1101 },
      -1,
   } },

   /* replace388_0 -> 1101 in the cache */
   /* replace388_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1101, 1104 },
      -1,
   } },

   /* ('bcsel', ('ult', 'b', 'a'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search389_0_0 -> 1104 in the cache */
   /* search389_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1104, 1101 },
      -1,
   } },
   /* search389_1 -> 1104 in the cache */
   /* search389_2 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1276, 1104, 1101 },
      -1,
   } },

   /* replace389_0 -> 1101 in the cache */
   /* replace389_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 1101, 1104 },
      -1,
   } },

   /* ('bcsel', ('ult', 'a', 'b'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search390_0_0 -> 0 in the cache */
   /* search390_0_1 -> 3 in the cache */
   /* search390_0 -> 1060 in the cache */
   /* search390_1 -> 3 in the cache */
   /* search390_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1060, 3, 0 },
      -1,
   } },

   /* replace390_0 -> 0 in the cache */
   /* replace390_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('bcsel', ('uge', 'a', 'b'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search391_0_0 -> 0 in the cache */
   /* search391_0_1 -> 3 in the cache */
   /* search391_0 -> 1054 in the cache */
   /* search391_1 -> 3 in the cache */
   /* search391_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1054, 3, 0 },
      -1,
   } },

   /* replace391_0 -> 0 in the cache */
   /* replace391_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('bcsel', ('uge', 'b', 'a'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search392_0_0 -> 1104 in the cache */
   /* search392_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1104, 1101 },
      -1,
   } },
   /* search392_1 -> 1104 in the cache */
   /* search392_2 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1283, 1104, 1101 },
      -1,
   } },

   /* replace392_0 -> 1101 in the cache */
   /* replace392_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 1101, 1104 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'b', 'a'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search393_0_0 -> 1104 in the cache */
   /* search393_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1104, 1101 },
      -1,
   } },
   /* search393_1 -> 1104 in the cache */
   /* search393_2 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1286, 1104, 1101 },
      -1,
   } },

   /* replace393_0 -> 1101 in the cache */
   /* replace393_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 1101, 1104 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a', 'b'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search394_0_0 -> 0 in the cache */
   /* search394_0_1 -> 3 in the cache */
   /* search394_0 -> 1057 in the cache */
   /* search394_1 -> 3 in the cache */
   /* search394_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1057, 3, 0 },
      -1,
   } },

   /* replace394_0 -> 0 in the cache */
   /* replace394_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('bcsel', ('ige', 'a', 'b'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search395_0_0 -> 0 in the cache */
   /* search395_0_1 -> 3 in the cache */
   /* search395_0 -> 1051 in the cache */
   /* search395_1 -> 3 in the cache */
   /* search395_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1051, 3, 0 },
      -1,
   } },

   /* replace395_0 -> 0 in the cache */
   /* replace395_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('bcsel', ('ige', 'b', 'a'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search396_0_0 -> 1104 in the cache */
   /* search396_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1104, 1101 },
      -1,
   } },
   /* search396_1 -> 1104 in the cache */
   /* search396_2 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1293, 1104, 1101 },
      -1,
   } },

   /* replace396_0 -> 1101 in the cache */
   /* replace396_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 1101, 1104 },
      -1,
   } },

   /* ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c') */
   /* search397_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search397_1 -> 129 in the cache */
   /* search397_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1296, 129, 131 },
      -1,
   } },

   /* replace397_0_0 -> 32 in the cache */
   /* replace397_0_1 -> 61 in the cache */
   /* replace397_0 -> 1220 in the cache */
   /* replace397_1 -> 129 in the cache */
   /* replace397_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 1220, 129, 131 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search398_0_0 -> 753 in the cache */
   /* search398_0 -> 1118 in the cache */
   /* search398_1 -> 129 in the cache */
   /* search398_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1118, 129, 131 },
      -1,
   } },

   /* replace398_0 -> 753 in the cache */
   /* replace398_1 -> 131 in the cache */
   /* replace398_2 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 131, 129 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search399_0 -> 753 in the cache */
   /* search399_1_0 -> 753 in the cache */
   /* search399_1_1 -> 152 in the cache */
   /* search399_1_2 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 152, 154 },
      -1,
   } },
   /* search399_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1301, 155 },
      -1,
   } },

   /* replace399_0 -> 753 in the cache */
   /* replace399_1 -> 152 in the cache */
   /* replace399_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 152, 155 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search400_0 -> 753 in the cache */
   /* search400_1 -> 152 in the cache */
   /* search400_2_0 -> 753 in the cache */
   /* search400_2_1 -> 154 in the cache */
   /* search400_2_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 154, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 152, 1304 },
      -1,
   } },

   /* replace400_0 -> 753 in the cache */
   /* replace400_1 -> 152 in the cache */
   /* replace400_2 -> 155 in the cache */
   /* replace400 -> 1303 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search401_0 -> 753 in the cache */
   /* search401_1_0 -> 1121 in the cache */
   /* search401_1_1 -> 746 in the cache */
   /* search401_1_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 746, 755 },
      -1,
   } },
   /* search401_2_0 -> 1121 in the cache */
   /* search401_2_1 -> 746 in the cache */
   /* search401_2_2 -> 757 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 746, 757 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1306, 1307 },
      -1,
   } },

   /* replace401_0 -> 1121 in the cache */
   /* replace401_1 -> 746 in the cache */
   /* replace401_2_0 -> 753 in the cache */
   /* replace401_2_1 -> 755 in the cache */
   /* replace401_2_2 -> 757 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 755, 757 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 746, 1309 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search402_0 -> 753 in the cache */
   /* search402_1_0 -> 1121 in the cache */
   /* search402_1_1 -> 746 in the cache */
   /* search402_1_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 746, 755 },
      0,
   } },
   /* search402_2_0 -> 1121 in the cache */
   /* search402_2_1 -> 746 in the cache */
   /* search402_2_2 -> 757 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 746, 757 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1311, 1312 },
      -1,
   } },

   /* replace402_0 -> 1121 in the cache */
   /* replace402_1 -> 746 in the cache */
   /* replace402_2_0 -> 753 in the cache */
   /* replace402_2_1 -> 755 in the cache */
   /* replace402_2_2 -> 757 in the cache */
   /* replace402_2 -> 1309 in the cache */
   /* replace402 -> 1310 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search403_0 -> 753 in the cache */
   /* search403_1_0 -> 1121 in the cache */
   /* search403_1_1 -> 154 in the cache */
   /* search403_1_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 154, 155 },
      -1,
   } },
   /* search403_2_0 -> 1121 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search403_2_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 1315, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1314, 1316 },
      -1,
   } },

   /* replace403_0 -> 1121 in the cache */
   /* replace403_1_0 -> 753 in the cache */
   /* replace403_1_1 -> 154 in the cache */
   /* replace403_1_2 -> 1315 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 154, 1315 },
      -1,
   } },
   /* replace403_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 1318, 155 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search404_0 -> 753 in the cache */
   /* search404_1_0 -> 1121 in the cache */
   /* search404_1_1 -> 154 in the cache */
   /* search404_1_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 154, 155 },
      0,
   } },
   /* search404_2_0 -> 1121 in the cache */
   /* search404_2_1 -> 1315 in the cache */
   /* search404_2_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1121, 1315, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1320, 1321 },
      -1,
   } },

   /* replace404_0 -> 1121 in the cache */
   /* replace404_1_0 -> 753 in the cache */
   /* replace404_1_1 -> 154 in the cache */
   /* replace404_1_2 -> 1315 in the cache */
   /* replace404_1 -> 1318 in the cache */
   /* replace404_2 -> 155 in the cache */
   /* replace404 -> 1319 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search405_0 -> 753 in the cache */
   /* search405_1 -> 1224 in the cache */
   /* search405_2 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1224, 1121 },
      -1,
   } },

   /* replace405_0 -> 753 in the cache */
   /* replace405_1 -> 1121 in the cache */
   /* replace405 -> 1125 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search406_0 -> 753 in the cache */
   /* search406_1 -> 753 in the cache */
   /* search406_2 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 753, 1121 },
      -1,
   } },

   /* replace406_0 -> 753 in the cache */
   /* replace406_1 -> 1121 in the cache */
   /* replace406 -> 1125 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search407_0 -> 753 in the cache */
   /* search407_1 -> 1121 in the cache */
   /* search407_2 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1121, 1070 },
      -1,
   } },

   /* replace407_0 -> 753 in the cache */
   /* replace407_1 -> 1121 in the cache */
   /* replace407 -> 1133 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search408_0 -> 753 in the cache */
   /* search408_1 -> 1121 in the cache */
   /* search408_2 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1121, 753 },
      -1,
   } },

   /* replace408_0 -> 753 in the cache */
   /* replace408_1 -> 1121 in the cache */
   /* replace408 -> 1133 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search409_0 -> 32 in the cache */
   /* search409_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace409 -> 32 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search410_0 -> 32 in the cache */
   /* search410_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace410 -> 32 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search411_0 -> 32 in the cache */
   /* search411_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace411 -> 32 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search412_0 -> 32 in the cache */
   /* search412_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace412 -> 32 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search413_0 -> 32 in the cache */
   /* search413_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace413 -> 32 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search414_0 -> 32 in the cache */
   /* search414_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace414 -> 61 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search415_0 -> 32 in the cache */
   /* search415_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace415 -> 32 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search416_0 -> 32 in the cache */
   /* search416_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace416 -> 32 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search417_0 -> 32 in the cache */
   /* search417_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace417 -> 32 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search418_0 -> 32 in the cache */
   /* search418_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace418 -> 63 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search419_0_0 -> 0 in the cache */
   /* search419_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search419_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1337, 3 },
      -1,
   } },

   /* replace419_0 -> 0 in the cache */
   /* replace419_1 -> 3 in the cache */
   /* replace419 -> 1270 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search420_0_0 -> 0 in the cache */
   /* search420_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search420_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1339, 3 },
      -1,
   } },

   /* replace420_0 -> 0 in the cache */
   /* replace420_1 -> 3 in the cache */
   /* replace420 -> 1280 in the cache */

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search421_0_0 -> 0 in the cache */
   /* search421_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search421_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1341, 3 },
      -1,
   } },

   /* replace421_0 -> 0 in the cache */
   /* replace421_1 -> 3 in the cache */
   /* replace421 -> 1290 in the cache */

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search422_0_0 -> 0 in the cache */
   /* search422_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search422_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1343, 3 },
      -1,
   } },

   /* replace422_0 -> 0 in the cache */
   /* replace422_1 -> 3 in the cache */
   /* replace422 -> 1272 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search423_0_0 -> 0 in the cache */
   /* search423_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search423_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1345, 3 },
      -1,
   } },

   /* replace423_0 -> 0 in the cache */
   /* replace423_1 -> 3 in the cache */
   /* replace423 -> 1282 in the cache */

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search424_0_0 -> 0 in the cache */
   /* search424_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search424_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1347, 3 },
      -1,
   } },

   /* replace424_0 -> 0 in the cache */
   /* replace424_1 -> 3 in the cache */
   /* replace424 -> 1292 in the cache */

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search425_0_0_0 -> 128 in the cache */
   /* search425_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search425_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1349, 131 },
      -1,
   } },
   /* search425_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1350, 128 },
      -1,
   } },

   /* replace425_0_0 -> 128 in the cache */
   /* replace425_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace425_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1352, 131 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search426_0_0_0 -> 128 in the cache */
   /* search426_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search426_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1354, 131 },
      -1,
   } },
   /* search426_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1355, 128 },
      -1,
   } },

   /* replace426_0_0 -> 128 in the cache */
   /* replace426_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace426_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1357, 131 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search427_0_0_0 -> 128 in the cache */
   /* search427_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search427_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1359, 131 },
      -1,
   } },
   /* search427_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1360, 128 },
      -1,
   } },

   /* replace427_0_0 -> 128 in the cache */
   /* replace427_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace427_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1362, 131 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search428_0_0_0 -> 128 in the cache */
   /* search428_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search428_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1364, 131 },
      -1,
   } },
   /* search428_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1365, 128 },
      -1,
   } },

   /* replace428_0_0 -> 128 in the cache */
   /* replace428_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace428_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1367, 131 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search429_0_0_0 -> 128 in the cache */
   /* search429_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search429_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1369, 131 },
      -1,
   } },
   /* search429_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1370, 128 },
      -1,
   } },

   /* replace429_0_0 -> 128 in the cache */
   /* replace429_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace429_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1372, 131 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search430_0_0_0 -> 128 in the cache */
   /* search430_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search430_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1374, 131 },
      -1,
   } },
   /* search430_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1375, 128 },
      -1,
   } },

   /* replace430_0_0 -> 128 in the cache */
   /* replace430_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace430_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1377, 131 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search431_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search431_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1379, 1380 },
      -1,
   } },

   /* replace431_0 -> 753 in the cache */
   /* replace431_1 -> 1121 in the cache */
   /* replace431 -> 1149 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search432_0_0 -> 753 in the cache */
   /* search432_0 -> 1379 in the cache */
   /* search432_1_0 -> 1121 in the cache */
   /* search432_1 -> 1380 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1379, 1380 },
      -1,
   } },

   /* replace432_0 -> 753 in the cache */
   /* replace432_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 753, 1121 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search433_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search433_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1384, 1385 },
      -1,
   } },

   /* replace433_0 -> 753 in the cache */
   /* replace433_1 -> 1121 in the cache */
   /* replace433 -> 1149 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search434_0_0 -> 753 in the cache */
   /* search434_0 -> 1384 in the cache */
   /* search434_1_0 -> 1121 in the cache */
   /* search434_1 -> 1385 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1384, 1385 },
      -1,
   } },

   /* replace434_0 -> 753 in the cache */
   /* replace434_1 -> 1121 in the cache */
   /* replace434 -> 1383 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search435_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search435_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1388, 1389 },
      -1,
   } },

   /* replace435_0 -> 753 in the cache */
   /* replace435_1 -> 1121 in the cache */
   /* replace435 -> 1149 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search436_0_0 -> 753 in the cache */
   /* search436_0 -> 1388 in the cache */
   /* search436_1_0 -> 1121 in the cache */
   /* search436_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1388, 1389 },
      -1,
   } },

   /* replace436_0 -> 753 in the cache */
   /* replace436_1 -> 1121 in the cache */
   /* replace436 -> 1383 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search437_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search437_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1392, 1393 },
      -1,
   } },

   /* replace437_0 -> 753 in the cache */
   /* replace437_1 -> 1121 in the cache */
   /* replace437 -> 1149 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search438_0_0 -> 753 in the cache */
   /* search438_0 -> 1392 in the cache */
   /* search438_1_0 -> 1121 in the cache */
   /* search438_1 -> 1393 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1392, 1393 },
      -1,
   } },

   /* replace438_0 -> 753 in the cache */
   /* replace438_1 -> 1121 in the cache */
   /* replace438 -> 1383 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search439_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search439_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1396, 1397 },
      -1,
   } },

   /* replace439_0 -> 753 in the cache */
   /* replace439_1 -> 1121 in the cache */
   /* replace439 -> 1149 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search440_0_0 -> 753 in the cache */
   /* search440_0 -> 1396 in the cache */
   /* search440_1_0 -> 1121 in the cache */
   /* search440_1 -> 1397 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1396, 1397 },
      -1,
   } },

   /* replace440_0 -> 753 in the cache */
   /* replace440_1 -> 1121 in the cache */
   /* replace440 -> 1383 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search441_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search441_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1400, 1401 },
      -1,
   } },

   /* replace441_0 -> 753 in the cache */
   /* replace441_1 -> 1121 in the cache */
   /* replace441 -> 1149 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search442_0_0 -> 753 in the cache */
   /* search442_0 -> 1400 in the cache */
   /* search442_1_0 -> 1121 in the cache */
   /* search442_1 -> 1401 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1400, 1401 },
      -1,
   } },

   /* replace442_0 -> 753 in the cache */
   /* replace442_1 -> 1121 in the cache */
   /* replace442 -> 1383 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search443_0_0 -> 753 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 753 },
      -1,
   } },
   /* search443_1_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1404, 1405 },
      -1,
   } },

   /* replace443_0 -> 753 in the cache */
   /* replace443_1 -> 1121 in the cache */
   /* replace443 -> 1149 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search444_0_0 -> 753 in the cache */
   /* search444_0 -> 1404 in the cache */
   /* search444_1_0 -> 1121 in the cache */
   /* search444_1 -> 1405 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1404, 1405 },
      -1,
   } },

   /* replace444_0 -> 753 in the cache */
   /* replace444_1 -> 1121 in the cache */
   /* replace444 -> 1383 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search445_0 -> 6 in the cache */
   /* search445_1_0_0 -> 6 in the cache */
   /* search445_1_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 1409 },
      -1,
   } },

   /* replace445_0 -> 6 in the cache */
   /* replace445_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 6, 828 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search446_0_0 -> 6 in the cache */
   /* search446_0_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 6, 7 },
      -1,
   } },
   /* search446_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1412, 828 },
      -1,
   } },

   /* replace446_0 -> 6 in the cache */
   /* replace446_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 6, 828 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search447_0_0 -> 6 in the cache */
   /* search447_0_1 -> 7 in the cache */
   /* search447_0 -> 1412 in the cache */
   /* search447_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1412, 7 },
      -1,
   } },

   /* replace447_0 -> 6 in the cache */
   /* replace447_1 -> 828 in the cache */
   /* replace447 -> 1414 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search448_0_0 -> 6 in the cache */
   /* search448_0_1 -> 7 in the cache */
   /* search448_0 -> 1412 in the cache */
   /* search448_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1412, 828 },
      -1,
   } },

   /* replace448_0 -> 6 in the cache */
   /* replace448_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 6, 828 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search449_0_0 -> 6 in the cache */
   /* search449_0_1 -> 7 in the cache */
   /* search449_0 -> 1412 in the cache */
   /* search449_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1412, 7 },
      -1,
   } },

   /* replace449_0 -> 6 in the cache */
   /* replace449_1 -> 828 in the cache */
   /* replace449 -> 1417 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search450_0_0 -> 6 in the cache */
   /* search450_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   /* search450_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1419, 828 },
      -1,
   } },

   /* replace450_0 -> 6 in the cache */
   /* replace450_1 -> 828 in the cache */
   /* replace450 -> 1417 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search451_0_0 -> 6 in the cache */
   /* search451_0_1 -> 9 in the cache */
   /* search451_0 -> 1419 in the cache */
   /* search451_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1419, 828 },
      -1,
   } },

   /* replace451_0 -> 6 in the cache */
   /* replace451_1 -> 828 in the cache */
   /* replace451 -> 1414 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search452_0_0 -> 6 in the cache */
   /* search452_0_1 -> 9 in the cache */
   /* search452_0 -> 1419 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1419, 1422 },
      -1,
   } },

   /* replace452_0 -> 6 in the cache */
   /* replace452_1 -> 828 in the cache */
   /* replace452 -> 1417 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search453_0_0 -> 6 in the cache */
   /* search453_0_1 -> 9 in the cache */
   /* search453_0 -> 1419 in the cache */
   /* search453_1 -> 1422 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1419, 1422 },
      -1,
   } },

   /* replace453_0 -> 6 in the cache */
   /* replace453_1 -> 828 in the cache */
   /* replace453 -> 1414 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search454_0_0 -> 6 in the cache */
   /* search454_0_1 -> 9 in the cache */
   /* search454_0 -> 1408 in the cache */
   /* search454_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1408, 828 },
      -1,
   } },

   /* replace454_0 -> 6 in the cache */
   /* replace454_1 -> 828 in the cache */
   /* replace454 -> 1417 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search455_0_0 -> 6 in the cache */
   /* search455_0_1 -> 9 in the cache */
   /* search455_0 -> 1408 in the cache */
   /* search455_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1408, 828 },
      -1,
   } },

   /* replace455_0 -> 6 in the cache */
   /* replace455_1 -> 828 in the cache */
   /* replace455 -> 1414 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search456_0_0 -> 6 in the cache */
   /* search456_0_1 -> 9 in the cache */
   /* search456_0 -> 1408 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1408, 1427 },
      -1,
   } },

   /* replace456_0 -> 6 in the cache */
   /* replace456_1 -> 828 in the cache */
   /* replace456 -> 1417 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search457_0_0 -> 6 in the cache */
   /* search457_0_1 -> 9 in the cache */
   /* search457_0 -> 1408 in the cache */
   /* search457_1 -> 1427 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1408, 1427 },
      -1,
   } },

   /* replace457_0 -> 6 in the cache */
   /* replace457_1 -> 828 in the cache */
   /* replace457 -> 1414 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search458_0 -> 11 in the cache */
   /* search458_1_0_0 -> 11 in the cache */
   /* search458_1_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1430 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1431 },
      -1,
   } },

   /* replace458_0 -> 11 in the cache */
   /* replace458_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 11, 849 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search459_0_0 -> 11 in the cache */
   /* search459_0_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 11, 12 },
      -1,
   } },
   /* search459_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1434, 849 },
      -1,
   } },

   /* replace459_0 -> 11 in the cache */
   /* replace459_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 11, 849 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search460_0_0 -> 11 in the cache */
   /* search460_0_1 -> 12 in the cache */
   /* search460_0 -> 1434 in the cache */
   /* search460_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1434, 12 },
      -1,
   } },

   /* replace460_0 -> 11 in the cache */
   /* replace460_1 -> 849 in the cache */
   /* replace460 -> 1436 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search461_0_0 -> 11 in the cache */
   /* search461_0_1 -> 12 in the cache */
   /* search461_0 -> 1434 in the cache */
   /* search461_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1434, 849 },
      -1,
   } },

   /* replace461_0 -> 11 in the cache */
   /* replace461_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 11, 849 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search462_0_0 -> 11 in the cache */
   /* search462_0_1 -> 12 in the cache */
   /* search462_0 -> 1434 in the cache */
   /* search462_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1434, 12 },
      -1,
   } },

   /* replace462_0 -> 11 in the cache */
   /* replace462_1 -> 849 in the cache */
   /* replace462 -> 1439 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search463_0_0 -> 11 in the cache */
   /* search463_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   /* search463_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1441, 849 },
      -1,
   } },

   /* replace463_0 -> 11 in the cache */
   /* replace463_1 -> 849 in the cache */
   /* replace463 -> 1439 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search464_0_0 -> 11 in the cache */
   /* search464_0_1 -> 14 in the cache */
   /* search464_0 -> 1441 in the cache */
   /* search464_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1441, 849 },
      -1,
   } },

   /* replace464_0 -> 11 in the cache */
   /* replace464_1 -> 849 in the cache */
   /* replace464 -> 1436 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search465_0_0 -> 11 in the cache */
   /* search465_0_1 -> 14 in the cache */
   /* search465_0 -> 1441 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1441, 1444 },
      -1,
   } },

   /* replace465_0 -> 11 in the cache */
   /* replace465_1 -> 849 in the cache */
   /* replace465 -> 1439 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search466_0_0 -> 11 in the cache */
   /* search466_0_1 -> 14 in the cache */
   /* search466_0 -> 1441 in the cache */
   /* search466_1 -> 1444 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1441, 1444 },
      -1,
   } },

   /* replace466_0 -> 11 in the cache */
   /* replace466_1 -> 849 in the cache */
   /* replace466 -> 1436 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search467_0_0 -> 11 in the cache */
   /* search467_0_1 -> 14 in the cache */
   /* search467_0 -> 1430 in the cache */
   /* search467_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1430, 849 },
      -1,
   } },

   /* replace467_0 -> 11 in the cache */
   /* replace467_1 -> 849 in the cache */
   /* replace467 -> 1439 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search468_0_0 -> 11 in the cache */
   /* search468_0_1 -> 14 in the cache */
   /* search468_0 -> 1430 in the cache */
   /* search468_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1430, 849 },
      -1,
   } },

   /* replace468_0 -> 11 in the cache */
   /* replace468_1 -> 849 in the cache */
   /* replace468 -> 1436 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search469_0_0 -> 11 in the cache */
   /* search469_0_1 -> 14 in the cache */
   /* search469_0 -> 1430 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1430, 1449 },
      -1,
   } },

   /* replace469_0 -> 11 in the cache */
   /* replace469_1 -> 849 in the cache */
   /* replace469 -> 1439 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search470_0_0 -> 11 in the cache */
   /* search470_0_1 -> 14 in the cache */
   /* search470_0 -> 1430 in the cache */
   /* search470_1 -> 1449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1430, 1449 },
      -1,
   } },

   /* replace470_0 -> 11 in the cache */
   /* replace470_1 -> 849 in the cache */
   /* replace470 -> 1436 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search471_0 -> 16 in the cache */
   /* search471_1_0_0 -> 16 in the cache */
   /* search471_1_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1452 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1453 },
      -1,
   } },

   /* replace471_0 -> 16 in the cache */
   /* replace471_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 16, 124 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search472_0_0 -> 16 in the cache */
   /* search472_0_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 17 },
      -1,
   } },
   /* search472_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1456, 124 },
      -1,
   } },

   /* replace472_0 -> 16 in the cache */
   /* replace472_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 16, 124 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search473_0_0 -> 16 in the cache */
   /* search473_0_1 -> 17 in the cache */
   /* search473_0 -> 1456 in the cache */
   /* search473_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1456, 17 },
      -1,
   } },

   /* replace473_0 -> 16 in the cache */
   /* replace473_1 -> 124 in the cache */
   /* replace473 -> 1458 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search474_0_0 -> 16 in the cache */
   /* search474_0_1 -> 17 in the cache */
   /* search474_0 -> 1456 in the cache */
   /* search474_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1456, 124 },
      -1,
   } },

   /* replace474_0 -> 16 in the cache */
   /* replace474_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 16, 124 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search475_0_0 -> 16 in the cache */
   /* search475_0_1 -> 17 in the cache */
   /* search475_0 -> 1456 in the cache */
   /* search475_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1456, 17 },
      -1,
   } },

   /* replace475_0 -> 16 in the cache */
   /* replace475_1 -> 124 in the cache */
   /* replace475 -> 1461 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search476_0_0 -> 16 in the cache */
   /* search476_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   /* search476_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1463, 124 },
      -1,
   } },

   /* replace476_0 -> 16 in the cache */
   /* replace476_1 -> 124 in the cache */
   /* replace476 -> 1461 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search477_0_0 -> 16 in the cache */
   /* search477_0_1 -> 19 in the cache */
   /* search477_0 -> 1463 in the cache */
   /* search477_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1463, 124 },
      -1,
   } },

   /* replace477_0 -> 16 in the cache */
   /* replace477_1 -> 124 in the cache */
   /* replace477 -> 1458 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search478_0_0 -> 16 in the cache */
   /* search478_0_1 -> 19 in the cache */
   /* search478_0 -> 1463 in the cache */
   /* search478_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1463, 398 },
      -1,
   } },

   /* replace478_0 -> 16 in the cache */
   /* replace478_1 -> 124 in the cache */
   /* replace478 -> 1461 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search479_0_0 -> 16 in the cache */
   /* search479_0_1 -> 19 in the cache */
   /* search479_0 -> 1463 in the cache */
   /* search479_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1463, 398 },
      -1,
   } },

   /* replace479_0 -> 16 in the cache */
   /* replace479_1 -> 124 in the cache */
   /* replace479 -> 1458 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search480_0_0 -> 16 in the cache */
   /* search480_0_1 -> 19 in the cache */
   /* search480_0 -> 1452 in the cache */
   /* search480_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1452, 124 },
      -1,
   } },

   /* replace480_0 -> 16 in the cache */
   /* replace480_1 -> 124 in the cache */
   /* replace480 -> 1461 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search481_0_0 -> 16 in the cache */
   /* search481_0_1 -> 19 in the cache */
   /* search481_0 -> 1452 in the cache */
   /* search481_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1452, 124 },
      -1,
   } },

   /* replace481_0 -> 16 in the cache */
   /* replace481_1 -> 124 in the cache */
   /* replace481 -> 1458 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search482_0_0 -> 16 in the cache */
   /* search482_0_1 -> 19 in the cache */
   /* search482_0 -> 1452 in the cache */
   /* search482_1 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1452, 126 },
      -1,
   } },

   /* replace482_0 -> 16 in the cache */
   /* replace482_1 -> 124 in the cache */
   /* replace482 -> 1461 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search483_0_0 -> 16 in the cache */
   /* search483_0_1 -> 19 in the cache */
   /* search483_0 -> 1452 in the cache */
   /* search483_1 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1452, 126 },
      -1,
   } },

   /* replace483_0 -> 16 in the cache */
   /* replace483_1 -> 124 in the cache */
   /* replace483 -> 1458 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search484_0 -> 21 in the cache */
   /* search484_1_0_0 -> 21 in the cache */
   /* search484_1_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1472 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 1473 },
      -1,
   } },

   /* replace484_0 -> 21 in the cache */
   /* replace484_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 21, 890 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search485_0_0 -> 21 in the cache */
   /* search485_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 21, 22 },
      -1,
   } },
   /* search485_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1476, 890 },
      -1,
   } },

   /* replace485_0 -> 21 in the cache */
   /* replace485_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 21, 890 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search486_0_0 -> 21 in the cache */
   /* search486_0_1 -> 22 in the cache */
   /* search486_0 -> 1476 in the cache */
   /* search486_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1476, 22 },
      -1,
   } },

   /* replace486_0 -> 21 in the cache */
   /* replace486_1 -> 890 in the cache */
   /* replace486 -> 1478 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search487_0_0 -> 21 in the cache */
   /* search487_0_1 -> 22 in the cache */
   /* search487_0 -> 1476 in the cache */
   /* search487_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1476, 890 },
      -1,
   } },

   /* replace487_0 -> 21 in the cache */
   /* replace487_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 21, 890 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search488_0_0 -> 21 in the cache */
   /* search488_0_1 -> 22 in the cache */
   /* search488_0 -> 1476 in the cache */
   /* search488_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1476, 22 },
      -1,
   } },

   /* replace488_0 -> 21 in the cache */
   /* replace488_1 -> 890 in the cache */
   /* replace488 -> 1481 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search489_0_0 -> 21 in the cache */
   /* search489_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   /* search489_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1483, 890 },
      -1,
   } },

   /* replace489_0 -> 21 in the cache */
   /* replace489_1 -> 890 in the cache */
   /* replace489 -> 1481 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search490_0_0 -> 21 in the cache */
   /* search490_0_1 -> 24 in the cache */
   /* search490_0 -> 1483 in the cache */
   /* search490_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1483, 890 },
      -1,
   } },

   /* replace490_0 -> 21 in the cache */
   /* replace490_1 -> 890 in the cache */
   /* replace490 -> 1478 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search491_0_0 -> 21 in the cache */
   /* search491_0_1 -> 24 in the cache */
   /* search491_0 -> 1483 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1483, 1486 },
      -1,
   } },

   /* replace491_0 -> 21 in the cache */
   /* replace491_1 -> 890 in the cache */
   /* replace491 -> 1481 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search492_0_0 -> 21 in the cache */
   /* search492_0_1 -> 24 in the cache */
   /* search492_0 -> 1483 in the cache */
   /* search492_1 -> 1486 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1483, 1486 },
      -1,
   } },

   /* replace492_0 -> 21 in the cache */
   /* replace492_1 -> 890 in the cache */
   /* replace492 -> 1478 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search493_0_0 -> 21 in the cache */
   /* search493_0_1 -> 24 in the cache */
   /* search493_0 -> 1472 in the cache */
   /* search493_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1472, 890 },
      -1,
   } },

   /* replace493_0 -> 21 in the cache */
   /* replace493_1 -> 890 in the cache */
   /* replace493 -> 1481 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search494_0_0 -> 21 in the cache */
   /* search494_0_1 -> 24 in the cache */
   /* search494_0 -> 1472 in the cache */
   /* search494_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1472, 890 },
      -1,
   } },

   /* replace494_0 -> 21 in the cache */
   /* replace494_1 -> 890 in the cache */
   /* replace494 -> 1478 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search495_0_0 -> 21 in the cache */
   /* search495_0_1 -> 24 in the cache */
   /* search495_0 -> 1472 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1472, 1491 },
      -1,
   } },

   /* replace495_0 -> 21 in the cache */
   /* replace495_1 -> 890 in the cache */
   /* replace495 -> 1481 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search496_0_0 -> 21 in the cache */
   /* search496_0_1 -> 24 in the cache */
   /* search496_0 -> 1472 in the cache */
   /* search496_1 -> 1491 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1472, 1491 },
      -1,
   } },

   /* replace496_0 -> 21 in the cache */
   /* replace496_1 -> 890 in the cache */
   /* replace496 -> 1478 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search497_0 -> 32 in the cache */
   /* search497_1_0 -> 32 in the cache */
   /* search497_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace497_0_0 -> 32 in the cache */
   /* replace497_0 -> 103 in the cache */
   /* replace497 -> 1243 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search498_0 -> 32 in the cache */
   /* search498_1_0 -> 32 in the cache */
   /* search498_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace498_0_0 -> 32 in the cache */
   /* replace498_0 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 106 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search499_0 -> 32 in the cache */
   /* search499_1_0_0 -> 32 in the cache */
   /* search499_1_0 -> 103 in the cache */
   /* search499_1 -> 1243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 1243 },
      -1,
   } },

   /* replace499_0_0 -> 32 in the cache */
   /* replace499_0 -> 103 in the cache */
   /* replace499 -> 1243 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search500_0 -> 32 in the cache */
   /* search500_1_0_0 -> 32 in the cache */
   /* search500_1_0 -> 106 in the cache */
   /* search500_1 -> 1496 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 1496 },
      -1,
   } },

   /* replace500_0_0 -> 32 in the cache */
   /* replace500_0 -> 106 in the cache */
   /* replace500 -> 1496 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search501_0 -> 32 in the cache */
   /* search501_1_0 -> 32 in the cache */
   /* search501_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace501 -> 32 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search502_0 -> 32 in the cache */
   /* search502_1_0 -> 32 in the cache */
   /* search502_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace502 -> 32 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search503_0 -> 32 in the cache */
   /* search503_1_0_0 -> 32 in the cache */
   /* search503_1_0 -> 103 in the cache */
   /* search503_1 -> 1243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 1243 },
      -1,
   } },

   /* replace503 -> 32 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search504_0 -> 32 in the cache */
   /* search504_1_0_0 -> 32 in the cache */
   /* search504_1_0 -> 106 in the cache */
   /* search504_1 -> 1496 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 1496 },
      -1,
   } },

   /* replace504 -> 32 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search505_0 -> 32 in the cache */
   /* search505_1_0 -> 32 in the cache */
   /* search505_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace505_0 -> 32 in the cache */
   /* replace505 -> 103 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search506_0 -> 32 in the cache */
   /* search506_1_0 -> 32 in the cache */
   /* search506_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace506_0 -> 32 in the cache */
   /* replace506 -> 106 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search507_0 -> 32 in the cache */
   /* search507_1_0 -> 32 in the cache */
   /* search507_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace507_0 -> 32 in the cache */
   /* replace507 -> 103 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search508_0 -> 32 in the cache */
   /* search508_1_0 -> 32 in the cache */
   /* search508_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace508_0 -> 32 in the cache */
   /* replace508 -> 106 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search509_0_0 -> 32 in the cache */
   /* search509_0 -> 103 in the cache */
   /* search509_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 103, 113 },
      -1,
   } },

   /* replace509_0 -> 32 in the cache */
   /* replace509 -> 103 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search510_0_0 -> 32 in the cache */
   /* search510_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search510_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1508, 243 },
      -1,
   } },

   /* replace510_0 -> 32 in the cache */
   /* replace510 -> 219 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search511_0_0 -> 32 in the cache */
   /* search511_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 243 },
      -1,
   } },
   /* search511_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1510, 113 },
      -1,
   } },

   /* replace511_0 -> 32 in the cache */
   /* replace511 -> 219 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search512_0_0 -> 32 in the cache */
   /* search512_0_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 249 },
      -1,
   } },
   /* search512_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1512, 113 },
      -1,
   } },

   /* replace512_0_0_0 -> 32 in the cache */
   /* replace512_0_0 -> 98 in the cache */
   /* replace512_0 -> 220 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 220 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search513_0_0 -> 32 in the cache */
   /* search513_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search513_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1515, 249 },
      -1,
   } },

   /* replace513_0_0_0 -> 32 in the cache */
   /* replace513_0_0 -> 98 in the cache */
   /* replace513_0 -> 220 in the cache */
   /* replace513 -> 1514 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search514_0_0 -> 32 in the cache */
   /* search514_0 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 252 },
      -1,
   } },

   /* replace514_0_0 -> 113 in the cache */
   /* replace514_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1518 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search515_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1520 },
      -1,
   } },

   /* replace515_0 -> 32 in the cache */
   /* replace515 -> 1520 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search516_0 -> 32 in the cache */
   /* search516 -> 219 in the cache */

   /* replace516_0_0 -> 32 in the cache */
   /* replace516_0_1 -> 113 in the cache */
   /* replace516_0 -> 1508 in the cache */
   /* replace516_1 -> 243 in the cache */
   /* replace516 -> 1509 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search517_0_0 -> 32 in the cache */
   /* search517_0 -> 219 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 219 },
      -1,
   } },

   /* replace517_0 -> 32 in the cache */
   /* replace517 -> 219 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search518_0_0_0 -> 0 in the cache */
   /* search518_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1523 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1524 },
      -1,
   } },

   /* replace518_0_0_0 -> 0 in the cache */
   /* replace518_0_0 -> 214 in the cache */
   /* replace518_0_1_0 -> 3 in the cache */
   /* replace518_0_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 214, 1080 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1526 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search519_0_0_0 -> 0 in the cache */
   /* search519_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1528 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1529 },
      -1,
   } },

   /* replace519_0_0_0 -> 0 in the cache */
   /* replace519_0_0 -> 214 in the cache */
   /* replace519_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 214, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1531 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search520_0_0_0 -> 16 in the cache */
   /* search520_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1533 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1534 },
      -1,
   } },

   /* replace520_0_0_0 -> 16 in the cache */
   /* replace520_0_0 -> 282 in the cache */
   /* replace520_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 282, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1536 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search521_0_0_0 -> 0 in the cache */
   /* search521_0_0_1 -> 3 in the cache */
   /* search521_0_0 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1528 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1538 },
      -1,
   } },

   /* replace521_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace521_0_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1540, 1541 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1542 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search522_0_0_0_0 -> 128 in the cache */
   /* search522_0_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 128, 129 },
      -1,
   } },
   /* search522_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1544, 131 },
      -1,
   } },
   /* search522_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1545, 129 },
      -1,
   } },
   /* search522_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1546, 131 },
      -1,
   } },

   /* replace522_0_0 -> 128 in the cache */
   /* replace522_0_1 -> 129 in the cache */
   /* replace522_0 -> 1352 in the cache */
   /* replace522_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1352, 131 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search523_0_0_0_0 -> 128 in the cache */
   /* search523_0_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 128, 129 },
      -1,
   } },
   /* search523_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1549, 131 },
      -1,
   } },
   /* search523_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1550, 129 },
      -1,
   } },
   /* search523_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1551, 131 },
      -1,
   } },

   /* replace523_0_0 -> 128 in the cache */
   /* replace523_0_1 -> 129 in the cache */
   /* replace523_0 -> 1362 in the cache */
   /* replace523_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1362, 131 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search524_0_0_0_0 -> 128 in the cache */
   /* search524_0_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 128, 129 },
      -1,
   } },
   /* search524_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1554, 131 },
      -1,
   } },
   /* search524_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1555, 129 },
      -1,
   } },
   /* search524_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1556, 131 },
      -1,
   } },

   /* replace524_0_0 -> 128 in the cache */
   /* replace524_0_1 -> 129 in the cache */
   /* replace524_0 -> 1357 in the cache */
   /* replace524_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1357, 131 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search525_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1559, 1560 },
      -1,
   } },

   /* replace525_0_0 -> 0 in the cache */
   /* replace525_0_1 -> 3 in the cache */
   /* replace525_0 -> 1270 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1270 },
      -1,
   } },

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search526_0_0 -> 0 in the cache */
   /* search526_0 -> 1559 in the cache */
   /* search526_1 -> 1560 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1559, 1560 },
      -1,
   } },

   /* replace526_0_0 -> 0 in the cache */
   /* replace526_0_1 -> 3 in the cache */
   /* replace526_0 -> 1272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1272 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search527_0_0_0 -> 1104 in the cache */
   /* search527_0_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1104, 1101 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1565 },
      -1,
   } },
   /* search527_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1566, 1104 },
      -1,
   } },

   /* replace527_0_0 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1104 },
      -1,
   } },
   /* replace527_1_0 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1101 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1568, 1569 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search528_0_0_0 -> 1104 in the cache */
   /* search528_0_0_1 -> 1101 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1104, 1101 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1571 },
      -1,
   } },
   /* search528_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1572, 1104 },
      -1,
   } },

   /* replace528_0_0_0 -> 1104 in the cache */
   /* replace528_0_0 -> 1568 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1568 },
      -1,
   } },
   /* replace528_1_0 -> 1101 in the cache */
   /* replace528_1 -> 1569 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1574, 1569 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1576 },
      -1,
   } },
   /* search529_0_1 -> 1560 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1577, 1560 },
      0,
   } },
   /* search529_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1578, 258 },
      -1,
   } },

   /* replace529_0_0_0 -> 0 in the cache */
   /* replace529_0_0 -> 214 in the cache */
   /* replace529_0_1 -> 3 in the cache */
   /* replace529_0 -> 279 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 279 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search530_0_0_0 -> 32 in the cache */
   /* search530_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 32, 61 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1581, 1582 },
      -1,
   } },
   /* search530_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1583, 61 },
      -1,
   } },

   /* replace530_0_0 -> 32 in the cache */
   /* replace530_0_1 -> 61 in the cache */
   /* replace530_0 -> 1581 in the cache */
   /* replace530_1 -> 1582 in the cache */
   /* replace530 -> 1583 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search531_0_0 -> 128 in the cache */
   /* search531_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search531_1_0 -> 128 in the cache */
   /* search531_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1585, 1586 },
      -1,
   } },

   /* replace531_0 -> 128 in the cache */
   /* replace531_1_0 -> 129 in the cache */
   /* replace531_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 128, 1588 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search532_0_0 -> 0 in the cache */
   /* search532_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 686 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search532_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1591, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1590, 1592 },
      -1,
   } },

   /* replace532_0_0 -> 0 in the cache */
   /* replace532_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace532_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1594, 686 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search533_0_0 -> 128 in the cache */
   /* search533_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search533_1_0 -> 128 in the cache */
   /* search533_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1596, 1597 },
      -1,
   } },

   /* replace533_0 -> 128 in the cache */
   /* replace533_1_0 -> 129 in the cache */
   /* replace533_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 128, 1599 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search534_0_0 -> 0 in the cache */
   /* search534_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 686 },
      0,
   } },
   /* search534_1_0 -> 1591 in the cache */
   /* search534_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1591, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1601, 1602 },
      -1,
   } },

   /* replace534_0_0 -> 0 in the cache */
   /* replace534_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace534_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1604, 686 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search535_0_0 -> 128 in the cache */
   /* search535_0_1 -> 285 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 285 },
      -1,
   } },
   /* search535_1_0 -> 128 in the cache */
   /* search535_1_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 807 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1606, 1607 },
      -1,
   } },

   /* replace535_0 -> 128 in the cache */
   /* replace535_1_0 -> 129 in the cache */
   /* replace535_1_1 -> 131 in the cache */
   /* replace535_1 -> 1588 in the cache */
   /* replace535 -> 1589 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search536_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1609, 686 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search536_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1611, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1610, 1612 },
      -1,
   } },

   /* replace536_0_0 -> 0 in the cache */
   /* replace536_0_1 -> 1591 in the cache */
   /* replace536_0 -> 1594 in the cache */
   /* replace536_1 -> 686 in the cache */
   /* replace536 -> 1595 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search537_0_0 -> 128 in the cache */
   /* search537_0_1 -> 285 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 285 },
      -1,
   } },
   /* search537_1_0 -> 128 in the cache */
   /* search537_1_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 807 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1614, 1615 },
      -1,
   } },

   /* replace537_0 -> 128 in the cache */
   /* replace537_1_0 -> 129 in the cache */
   /* replace537_1_1 -> 131 in the cache */
   /* replace537_1 -> 1599 in the cache */
   /* replace537 -> 1600 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search538_0_0 -> 1609 in the cache */
   /* search538_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1609, 686 },
      -1,
   } },
   /* search538_1_0 -> 1611 in the cache */
   /* search538_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1611, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1617, 1618 },
      -1,
   } },

   /* replace538_0_0 -> 0 in the cache */
   /* replace538_0_1 -> 1591 in the cache */
   /* replace538_0 -> 1604 in the cache */
   /* replace538_1 -> 686 in the cache */
   /* replace538 -> 1605 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search539_0_0 -> 128 in the cache */
   /* search539_0_1 -> 129 in the cache */
   /* search539_0 -> 1585 in the cache */
   /* search539_1_0 -> 128 in the cache */
   /* search539_1_1 -> 131 in the cache */
   /* search539_1 -> 1586 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1585, 1586 },
      -1,
   } },

   /* replace539_0 -> 128 in the cache */
   /* replace539_1_0 -> 129 in the cache */
   /* replace539_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 128, 1621 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search540_0_0 -> 0 in the cache */
   /* search540_0_1 -> 686 in the cache */
   /* search540_0 -> 1590 in the cache */
   /* search540_1_0 -> 1591 in the cache */
   /* search540_1_1 -> 686 in the cache */
   /* search540_1 -> 1592 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1590, 1592 },
      -1,
   } },

   /* replace540_0_0 -> 0 in the cache */
   /* replace540_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace540_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1624, 686 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search541_0_0 -> 128 in the cache */
   /* search541_0_1 -> 129 in the cache */
   /* search541_0 -> 1596 in the cache */
   /* search541_1_0 -> 128 in the cache */
   /* search541_1_1 -> 131 in the cache */
   /* search541_1 -> 1597 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1596, 1597 },
      -1,
   } },

   /* replace541_0 -> 128 in the cache */
   /* replace541_1_0 -> 129 in the cache */
   /* replace541_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 128, 1627 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search542_0_0 -> 0 in the cache */
   /* search542_0_1 -> 686 in the cache */
   /* search542_0 -> 1601 in the cache */
   /* search542_1_0 -> 1591 in the cache */
   /* search542_1_1 -> 686 in the cache */
   /* search542_1 -> 1602 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1601, 1602 },
      -1,
   } },

   /* replace542_0_0 -> 0 in the cache */
   /* replace542_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace542_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1630, 686 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search543_0_0 -> 128 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 1632 },
      -1,
   } },
   /* search543_1_0 -> 128 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 1634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1633, 1635 },
      -1,
   } },

   /* replace543_0 -> 128 in the cache */
   /* replace543_1_0 -> 129 in the cache */
   /* replace543_1_1 -> 131 in the cache */
   /* replace543_1 -> 1621 in the cache */
   /* replace543 -> 1622 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search544_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1637, 686 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search544_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1639, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1638, 1640 },
      -1,
   } },

   /* replace544_0_0 -> 0 in the cache */
   /* replace544_0_1 -> 1591 in the cache */
   /* replace544_0 -> 1624 in the cache */
   /* replace544_1 -> 686 in the cache */
   /* replace544 -> 1625 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search545_0_0 -> 128 in the cache */
   /* search545_0_1 -> 1632 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 1632 },
      -1,
   } },
   /* search545_1_0 -> 128 in the cache */
   /* search545_1_1 -> 1634 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 1634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1642, 1643 },
      -1,
   } },

   /* replace545_0 -> 128 in the cache */
   /* replace545_1_0 -> 129 in the cache */
   /* replace545_1_1 -> 131 in the cache */
   /* replace545_1 -> 1627 in the cache */
   /* replace545 -> 1628 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search546_0_0 -> 1637 in the cache */
   /* search546_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1637, 686 },
      -1,
   } },
   /* search546_1_0 -> 1639 in the cache */
   /* search546_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1639, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1645, 1646 },
      -1,
   } },

   /* replace546_0_0 -> 0 in the cache */
   /* replace546_0_1 -> 1591 in the cache */
   /* replace546_0 -> 1630 in the cache */
   /* replace546_1 -> 686 in the cache */
   /* replace546 -> 1631 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search547_0_0 -> 128 in the cache */
   /* search547_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search547_1_0 -> 128 in the cache */
   /* search547_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1648, 1649 },
      -1,
   } },

   /* replace547_0 -> 128 in the cache */
   /* replace547_1_0 -> 129 in the cache */
   /* replace547_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 128, 1651 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search548_0_0 -> 0 in the cache */
   /* search548_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 686 },
      0,
   } },
   /* search548_1_0 -> 1591 in the cache */
   /* search548_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1591, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1653, 1654 },
      -1,
   } },

   /* replace548_0_0 -> 0 in the cache */
   /* replace548_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace548_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1656, 686 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search549_0_0 -> 128 in the cache */
   /* search549_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search549_1_0 -> 128 in the cache */
   /* search549_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1658, 1659 },
      -1,
   } },

   /* replace549_0 -> 128 in the cache */
   /* replace549_1_0 -> 129 in the cache */
   /* replace549_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 128, 1661 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search550_0_0 -> 0 in the cache */
   /* search550_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 686 },
      0,
   } },
   /* search550_1_0 -> 1591 in the cache */
   /* search550_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1591, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1663, 1664 },
      -1,
   } },

   /* replace550_0_0 -> 0 in the cache */
   /* replace550_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace550_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1666, 686 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search551_0_0 -> 128 in the cache */
   /* search551_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search551_1_0 -> 128 in the cache */
   /* search551_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1668, 1669 },
      -1,
   } },

   /* replace551_0 -> 128 in the cache */
   /* replace551_1_0 -> 129 in the cache */
   /* replace551_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 128, 1671 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search552_0_0 -> 0 in the cache */
   /* search552_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 686 },
      0,
   } },
   /* search552_1_0 -> 1591 in the cache */
   /* search552_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1591, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1673, 1674 },
      -1,
   } },

   /* replace552_0_0 -> 0 in the cache */
   /* replace552_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace552_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1676, 686 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search553_0_0 -> 128 in the cache */
   /* search553_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search553_1_0 -> 128 in the cache */
   /* search553_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1678, 1679 },
      -1,
   } },

   /* replace553_0 -> 128 in the cache */
   /* replace553_1_0 -> 129 in the cache */
   /* replace553_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 128, 1681 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search554_0_0 -> 0 in the cache */
   /* search554_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 686 },
      0,
   } },
   /* search554_1_0 -> 1591 in the cache */
   /* search554_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1591, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1683, 1684 },
      -1,
   } },

   /* replace554_0_0 -> 0 in the cache */
   /* replace554_0_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1591 },
      -1,
   } },
   /* replace554_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1686, 686 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search555_0_0 -> 128 in the cache */
   /* search555_0_1 -> 129 in the cache */
   /* search555_0 -> 1648 in the cache */
   /* search555_1_0 -> 128 in the cache */
   /* search555_1_1 -> 131 in the cache */
   /* search555_1 -> 1649 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1648, 1649 },
      -1,
   } },

   /* replace555_0 -> 128 in the cache */
   /* replace555_1_0 -> 129 in the cache */
   /* replace555_1_1 -> 131 in the cache */
   /* replace555_1 -> 1661 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 128, 1661 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search556_0_0 -> 0 in the cache */
   /* search556_0_1 -> 686 in the cache */
   /* search556_0 -> 1653 in the cache */
   /* search556_1_0 -> 1591 in the cache */
   /* search556_1_1 -> 686 in the cache */
   /* search556_1 -> 1654 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1653, 1654 },
      -1,
   } },

   /* replace556_0_0 -> 0 in the cache */
   /* replace556_0_1 -> 1591 in the cache */
   /* replace556_0 -> 1666 in the cache */
   /* replace556_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1666, 686 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search557_0_0 -> 128 in the cache */
   /* search557_0_1 -> 129 in the cache */
   /* search557_0 -> 1658 in the cache */
   /* search557_1_0 -> 128 in the cache */
   /* search557_1_1 -> 131 in the cache */
   /* search557_1 -> 1659 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1658, 1659 },
      -1,
   } },

   /* replace557_0 -> 128 in the cache */
   /* replace557_1_0 -> 129 in the cache */
   /* replace557_1_1 -> 131 in the cache */
   /* replace557_1 -> 1651 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 128, 1651 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search558_0_0 -> 0 in the cache */
   /* search558_0_1 -> 686 in the cache */
   /* search558_0 -> 1663 in the cache */
   /* search558_1_0 -> 1591 in the cache */
   /* search558_1_1 -> 686 in the cache */
   /* search558_1 -> 1664 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1663, 1664 },
      -1,
   } },

   /* replace558_0_0 -> 0 in the cache */
   /* replace558_0_1 -> 1591 in the cache */
   /* replace558_0 -> 1656 in the cache */
   /* replace558_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1656, 686 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search559_0_0 -> 128 in the cache */
   /* search559_0_1 -> 129 in the cache */
   /* search559_0 -> 1668 in the cache */
   /* search559_1_0 -> 128 in the cache */
   /* search559_1_1 -> 131 in the cache */
   /* search559_1 -> 1669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1668, 1669 },
      -1,
   } },

   /* replace559_0 -> 128 in the cache */
   /* replace559_1_0 -> 129 in the cache */
   /* replace559_1_1 -> 131 in the cache */
   /* replace559_1 -> 1681 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 128, 1681 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search560_0_0 -> 0 in the cache */
   /* search560_0_1 -> 686 in the cache */
   /* search560_0 -> 1673 in the cache */
   /* search560_1_0 -> 1591 in the cache */
   /* search560_1_1 -> 686 in the cache */
   /* search560_1 -> 1674 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1673, 1674 },
      -1,
   } },

   /* replace560_0_0 -> 0 in the cache */
   /* replace560_0_1 -> 1591 in the cache */
   /* replace560_0 -> 1686 in the cache */
   /* replace560_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1686, 686 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search561_0_0 -> 128 in the cache */
   /* search561_0_1 -> 129 in the cache */
   /* search561_0 -> 1678 in the cache */
   /* search561_1_0 -> 128 in the cache */
   /* search561_1_1 -> 131 in the cache */
   /* search561_1 -> 1679 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1678, 1679 },
      -1,
   } },

   /* replace561_0 -> 128 in the cache */
   /* replace561_1_0 -> 129 in the cache */
   /* replace561_1_1 -> 131 in the cache */
   /* replace561_1 -> 1671 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 128, 1671 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search562_0_0 -> 0 in the cache */
   /* search562_0_1 -> 686 in the cache */
   /* search562_0 -> 1683 in the cache */
   /* search562_1_0 -> 1591 in the cache */
   /* search562_1_1 -> 686 in the cache */
   /* search562_1 -> 1684 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1683, 1684 },
      -1,
   } },

   /* replace562_0_0 -> 0 in the cache */
   /* replace562_0_1 -> 1591 in the cache */
   /* replace562_0 -> 1676 in the cache */
   /* replace562_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1676, 686 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search563_0_0_0 -> 0 in the cache */
   /* search563_0_0_1 -> 686 in the cache */
   /* search563_0_0 -> 1590 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1590, 1704 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search563_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1706, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1705, 1707 },
      -1,
   } },

   /* replace563_0_0_0 -> 0 in the cache */
   /* replace563_0_0_1 -> 1706 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1706 },
      -1,
   } },
   /* replace563_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1709, 686 },
      -1,
   } },
   /* replace563_1 -> 1704 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1710, 1704 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search564_0_0_0 -> 0 in the cache */
   /* search564_0_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 686 },
      -1,
   } },
   /* search564_0_1 -> 1704 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1712, 1704 },
      0,
   } },
   /* search564_1_0 -> 1706 in the cache */
   /* search564_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1706, 686 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1713, 1714 },
      -1,
   } },

   /* replace564_0_0_0 -> 0 in the cache */
   /* replace564_0_0_1 -> 1706 in the cache */
   /* replace564_0_0 -> 1709 in the cache */
   /* replace564_0_1 -> 686 in the cache */
   /* replace564_0 -> 1710 in the cache */
   /* replace564_1 -> 1704 in the cache */
   /* replace564 -> 1711 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search565_0_0_0 -> 151 in the cache */
   /* search565_0_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 152 },
      0,
   } },
   /* search565_0_1 -> 1704 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1716, 1704 },
      0,
   } },
   /* search565_1_0 -> 151 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 1718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1717, 1719 },
      -1,
   } },

   /* replace565_0_0 -> 151 in the cache */
   /* replace565_0_1_0 -> 152 in the cache */
   /* replace565_0_1_1 -> 1718 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      nir_op_fmax,
      1, 1,
      { 152, 1718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 151, 1721 },
      -1,
   } },
   /* replace565_1 -> 1704 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1722, 1704 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search566_0_0_0 -> 151 in the cache */
   /* search566_0_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 152 },
      -1,
   } },
   /* search566_0_1 -> 1704 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1724, 1704 },
      0,
   } },
   /* search566_1_0 -> 151 in the cache */
   /* search566_1_1 -> 1718 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 1718 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1725, 1726 },
      -1,
   } },

   /* replace566_0_0 -> 151 in the cache */
   /* replace566_0_1_0 -> 152 in the cache */
   /* replace566_0_1_1 -> 1718 in the cache */
   /* replace566_0_1 -> 1721 in the cache */
   /* replace566_0 -> 1722 in the cache */
   /* replace566_1 -> 1704 in the cache */
   /* replace566 -> 1723 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search567_0_0 -> 1035 in the cache */
   /* search567_0_1 -> 1036 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1035, 1036 },
      -1,
   } },
   /* search567_1_0 -> 3 in the cache */
   /* search567_1_1 -> 0 in the cache */
   /* search567_1 -> 1071 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1728, 1071 },
      -1,
   } },

   /* replace567_0 -> 0 in the cache */
   /* replace567_1 -> 3 in the cache */
   /* replace567 -> 1045 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search568_0_0 -> 115 in the cache */
   /* search568_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search568_1_0 -> 260 in the cache */
   /* search568_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 260, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1730, 1731 },
      -1,
   } },

   /* replace568_0 -> 115 in the cache */
   /* replace568_1_0 -> 11 in the cache */
   /* replace568_1_1_0 -> 260 in the cache */
   /* replace568_1_1 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1733 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search569_0_0 -> 115 in the cache */
   /* search569_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search569_1_0 -> 260 in the cache */
   /* search569_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 260, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1735, 1736 },
      -1,
   } },

   /* replace569_0 -> 115 in the cache */
   /* replace569_1_0 -> 11 in the cache */
   /* replace569_1_1_0 -> 260 in the cache */
   /* replace569_1_1 -> 536 in the cache */
   /* replace569_1 -> 1733 in the cache */
   /* replace569 -> 1734 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search570_0_0 -> 115 in the cache */
   /* search570_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search570_1_0 -> 260 in the cache */
   /* search570_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 260, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1738, 1739 },
      -1,
   } },

   /* replace570_0 -> 115 in the cache */
   /* replace570_1_0 -> 11 in the cache */
   /* replace570_1_1_0 -> 260 in the cache */
   /* replace570_1_1 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 11, 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1741 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search571_0_0 -> 115 in the cache */
   /* search571_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search571_1_0 -> 260 in the cache */
   /* search571_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 260, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1743, 1744 },
      -1,
   } },

   /* replace571_0 -> 115 in the cache */
   /* replace571_1_0 -> 11 in the cache */
   /* replace571_1_1_0 -> 260 in the cache */
   /* replace571_1_1 -> 536 in the cache */
   /* replace571_1 -> 1741 in the cache */
   /* replace571 -> 1742 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search572_0_0 -> 115 in the cache */
   /* search572_0_1 -> 11 in the cache */
   /* search572_0 -> 1730 in the cache */
   /* search572_1_0 -> 260 in the cache */
   /* search572_1_1 -> 115 in the cache */
   /* search572_1 -> 1731 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1730, 1731 },
      -1,
   } },

   /* replace572_0 -> 115 in the cache */
   /* replace572_1_0 -> 11 in the cache */
   /* replace572_1_1_0 -> 260 in the cache */
   /* replace572_1_1 -> 536 in the cache */
   /* replace572_1 -> 1741 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1741 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search573_0_0 -> 115 in the cache */
   /* search573_0_1 -> 11 in the cache */
   /* search573_0 -> 1735 in the cache */
   /* search573_1_0 -> 260 in the cache */
   /* search573_1_1 -> 115 in the cache */
   /* search573_1 -> 1736 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1735, 1736 },
      -1,
   } },

   /* replace573_0 -> 115 in the cache */
   /* replace573_1_0 -> 11 in the cache */
   /* replace573_1_1_0 -> 260 in the cache */
   /* replace573_1_1 -> 536 in the cache */
   /* replace573_1 -> 1741 in the cache */
   /* replace573 -> 1747 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search574_0_0 -> 115 in the cache */
   /* search574_0_1 -> 11 in the cache */
   /* search574_0 -> 1738 in the cache */
   /* search574_1_0 -> 260 in the cache */
   /* search574_1_1 -> 115 in the cache */
   /* search574_1 -> 1739 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1738, 1739 },
      -1,
   } },

   /* replace574_0 -> 115 in the cache */
   /* replace574_1_0 -> 11 in the cache */
   /* replace574_1_1_0 -> 260 in the cache */
   /* replace574_1_1 -> 536 in the cache */
   /* replace574_1 -> 1733 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1733 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search575_0_0 -> 115 in the cache */
   /* search575_0_1 -> 11 in the cache */
   /* search575_0 -> 1743 in the cache */
   /* search575_1_0 -> 260 in the cache */
   /* search575_1_1 -> 115 in the cache */
   /* search575_1 -> 1744 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1743, 1744 },
      -1,
   } },

   /* replace575_0 -> 115 in the cache */
   /* replace575_1_0 -> 11 in the cache */
   /* replace575_1_1_0 -> 260 in the cache */
   /* replace575_1_1 -> 536 in the cache */
   /* replace575_1 -> 1733 in the cache */
   /* replace575 -> 1750 in the cache */

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search576_0_0 -> 11 in the cache */
   /* search576_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 115 },
      -1,
   } },
   /* search576_1 -> 483 in the cache */
   /* search576_2_0_0_0_0 -> 115 in the cache */
   /* search576_2_0_0_0_1 -> 11 in the cache */
   /* search576_2_0_0_0 -> 1735 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1735 },
      -1,
   } },
   /* search576_2_0_1_0_0_0 -> 11 in the cache */
   /* search576_2_0_1_0_0_1 -> 115 in the cache */
   /* search576_2_0_1_0_0 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1754 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1753, 1755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1756 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1752, 483, 1757 },
      -1,
   } },

   /* replace576_0_0_0_0 -> 11 in the cache */
   /* replace576_0_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1759 },
      -1,
   } },
   /* replace576_0_1_0_0_0 -> 11 in the cache */
   /* replace576_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1761 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1762 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1760, 1763 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1764 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search577_0 -> 753 in the cache */
   /* search577_1_0 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 260 },
      0,
   } },
   /* search577_2_0 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1766, 1767 },
      -1,
   } },

   /* replace577_0_0 -> 753 in the cache */
   /* replace577_0_1 -> 260 in the cache */
   /* replace577_0_2 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 260, 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1769 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search578_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1771 },
      -1,
   } },

   /* replace578_0 -> 11 in the cache */
   /* replace578 -> 690 in the cache */

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search579_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1773 },
      -1,
   } },

   /* replace579 -> 11 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search580_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1775 },
      -1,
   } },

   /* replace580 -> 11 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search581_0_0 -> 11 in the cache */
   /* search581_0 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1773 },
      -1,
   } },

   /* replace581 -> 11 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search582_0_0 -> 11 in the cache */
   /* search582_0 -> 1775 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1775 },
      -1,
   } },

   /* replace582 -> 11 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search583_0_0_0 -> 115 in the cache */
   /* search583_0_0_1 -> 11 in the cache */
   /* search583_0_0 -> 1735 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1735 },
      -1,
   } },
   /* search583_1_0_0_0 -> 11 in the cache */
   /* search583_1_0_0_1 -> 115 in the cache */
   /* search583_1_0_0 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1780 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1779, 1781 },
      -1,
   } },

   /* replace583_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search584_0_0_0 -> 849 in the cache */
   /* search584_0_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 849, 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1784 },
      -1,
   } },
   /* search584_1_0_0_0 -> 11 in the cache */
   /* search584_1_0_0_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 849 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1787 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1785, 1788 },
      -1,
   } },

   /* replace584_0_0 -> 11 in the cache */
   /* replace584_0 -> 1783 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1783 },
      -1,
   } },

   /* ('f2f16', ('f2f32', 'a@16')) => a */
   /* search585_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1791 },
      -1,
   } },

   /* replace585 -> 11 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search586_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1793 },
      -1,
   } },

   /* replace586 -> 11 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search587_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1795 },
      -1,
   } },

   /* replace587 -> 11 in the cache */

   /* ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a') */
   /* search588_0_0 -> 753 in the cache */
   /* search588_0 -> 1400 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1400 },
      -1,
   } },

   /* replace588_0 -> 753 in the cache */
   /* replace588 -> 1396 in the cache */

   /* ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search589_0_0 -> 753 in the cache */
   /* search589_0 -> 1388 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1388 },
      -1,
   } },

   /* replace589_0 -> 753 in the cache */
   /* replace589 -> 1384 in the cache */

   /* ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search590_0_0 -> 753 in the cache */
   /* search590_0 -> 1388 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1388 },
      -1,
   } },

   /* replace590_0 -> 753 in the cache */
   /* replace590 -> 1384 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search591_0_0 -> 11 in the cache */
   /* search591_0 -> 1791 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1791 },
      -1,
   } },

   /* replace591_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search592_0_0 -> 11 in the cache */
   /* search592_0 -> 1791 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1791 },
      -1,
   } },

   /* replace592_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search593_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1804 },
      -1,
   } },

   /* replace593_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search594_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1807 },
      -1,
   } },

   /* replace594_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search595_0_0 -> 11 in the cache */
   /* search595_0 -> 1795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 1795 },
      -1,
   } },

   /* replace595_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search596_0_0 -> 11 in the cache */
   /* search596_0 -> 1793 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1793 },
      -1,
   } },

   /* replace596_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('f2f64', 'a@16')) => a */
   /* search597_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1814 },
      -1,
   } },

   /* replace597 -> 11 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search598_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1816 },
      -1,
   } },

   /* replace598 -> 11 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search599_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1818 },
      -1,
   } },

   /* replace599 -> 11 in the cache */

   /* ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a') */
   /* search600_0_0 -> 753 in the cache */
   /* search600_0 -> 1404 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1404 },
      -1,
   } },

   /* replace600_0 -> 753 in the cache */
   /* replace600 -> 1396 in the cache */

   /* ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search601_0_0 -> 753 in the cache */
   /* search601_0 -> 1392 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1392 },
      -1,
   } },

   /* replace601_0 -> 753 in the cache */
   /* replace601 -> 1384 in the cache */

   /* ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search602_0_0 -> 753 in the cache */
   /* search602_0 -> 1392 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1392 },
      -1,
   } },

   /* replace602_0 -> 753 in the cache */
   /* replace602 -> 1384 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search603_0_0 -> 11 in the cache */
   /* search603_0 -> 1814 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1814 },
      -1,
   } },

   /* replace603_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search604_0_0 -> 11 in the cache */
   /* search604_0 -> 1814 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1814 },
      -1,
   } },

   /* replace604_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search605_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1827 },
      -1,
   } },

   /* replace605_0 -> 32 in the cache */
   /* replace605 -> 1806 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search606_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1829 },
      -1,
   } },

   /* replace606_0 -> 32 in the cache */
   /* replace606 -> 1809 in the cache */

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search607_0_0 -> 11 in the cache */
   /* search607_0 -> 1818 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1818 },
      -1,
   } },

   /* replace607_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search608_0_0 -> 11 in the cache */
   /* search608_0 -> 1816 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1816 },
      -1,
   } },

   /* replace608_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search609_0_0 -> 117 in the cache */
   /* search609_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search609_1_0 -> 36 in the cache */
   /* search609_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1835, 1836 },
      -1,
   } },

   /* replace609_0 -> 117 in the cache */
   /* replace609_1_0 -> 16 in the cache */
   /* replace609_1_1_0 -> 36 in the cache */
   /* replace609_1_1 -> 602 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 16, 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1838 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search610_0_0 -> 117 in the cache */
   /* search610_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search610_1_0 -> 36 in the cache */
   /* search610_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1840, 1841 },
      -1,
   } },

   /* replace610_0 -> 117 in the cache */
   /* replace610_1_0 -> 16 in the cache */
   /* replace610_1_1_0 -> 36 in the cache */
   /* replace610_1_1 -> 602 in the cache */
   /* replace610_1 -> 1838 in the cache */
   /* replace610 -> 1839 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search611_0_0 -> 117 in the cache */
   /* search611_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search611_1_0 -> 36 in the cache */
   /* search611_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1843, 1844 },
      -1,
   } },

   /* replace611_0 -> 117 in the cache */
   /* replace611_1_0 -> 16 in the cache */
   /* replace611_1_1_0 -> 36 in the cache */
   /* replace611_1_1 -> 602 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 16, 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1846 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search612_0_0 -> 117 in the cache */
   /* search612_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search612_1_0 -> 36 in the cache */
   /* search612_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1848, 1849 },
      -1,
   } },

   /* replace612_0 -> 117 in the cache */
   /* replace612_1_0 -> 16 in the cache */
   /* replace612_1_1_0 -> 36 in the cache */
   /* replace612_1_1 -> 602 in the cache */
   /* replace612_1 -> 1846 in the cache */
   /* replace612 -> 1847 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search613_0_0 -> 117 in the cache */
   /* search613_0_1 -> 16 in the cache */
   /* search613_0 -> 1835 in the cache */
   /* search613_1_0 -> 36 in the cache */
   /* search613_1_1 -> 117 in the cache */
   /* search613_1 -> 1836 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1835, 1836 },
      -1,
   } },

   /* replace613_0 -> 117 in the cache */
   /* replace613_1_0 -> 16 in the cache */
   /* replace613_1_1_0 -> 36 in the cache */
   /* replace613_1_1 -> 602 in the cache */
   /* replace613_1 -> 1846 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1846 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search614_0_0 -> 117 in the cache */
   /* search614_0_1 -> 16 in the cache */
   /* search614_0 -> 1840 in the cache */
   /* search614_1_0 -> 36 in the cache */
   /* search614_1_1 -> 117 in the cache */
   /* search614_1 -> 1841 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1840, 1841 },
      -1,
   } },

   /* replace614_0 -> 117 in the cache */
   /* replace614_1_0 -> 16 in the cache */
   /* replace614_1_1_0 -> 36 in the cache */
   /* replace614_1_1 -> 602 in the cache */
   /* replace614_1 -> 1846 in the cache */
   /* replace614 -> 1852 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search615_0_0 -> 117 in the cache */
   /* search615_0_1 -> 16 in the cache */
   /* search615_0 -> 1843 in the cache */
   /* search615_1_0 -> 36 in the cache */
   /* search615_1_1 -> 117 in the cache */
   /* search615_1 -> 1844 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1843, 1844 },
      -1,
   } },

   /* replace615_0 -> 117 in the cache */
   /* replace615_1_0 -> 16 in the cache */
   /* replace615_1_1_0 -> 36 in the cache */
   /* replace615_1_1 -> 602 in the cache */
   /* replace615_1 -> 1838 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1838 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search616_0_0 -> 117 in the cache */
   /* search616_0_1 -> 16 in the cache */
   /* search616_0 -> 1848 in the cache */
   /* search616_1_0 -> 36 in the cache */
   /* search616_1_1 -> 117 in the cache */
   /* search616_1 -> 1849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1848, 1849 },
      -1,
   } },

   /* replace616_0 -> 117 in the cache */
   /* replace616_1_0 -> 16 in the cache */
   /* replace616_1_1_0 -> 36 in the cache */
   /* replace616_1_1 -> 602 in the cache */
   /* replace616_1 -> 1838 in the cache */
   /* replace616 -> 1855 in the cache */

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search617_0_0 -> 16 in the cache */
   /* search617_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 16, 117 },
      -1,
   } },
   /* search617_1 -> 245 in the cache */
   /* search617_2_0_0_0_0 -> 117 in the cache */
   /* search617_2_0_0_0_1 -> 16 in the cache */
   /* search617_2_0_0_0 -> 1840 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1840 },
      -1,
   } },
   /* search617_2_0_1_0_0_0 -> 16 in the cache */
   /* search617_2_0_1_0_0_1 -> 117 in the cache */
   /* search617_2_0_1_0_0 -> 697 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 697 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1858, 1860 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1861 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1857, 245, 1862 },
      -1,
   } },

   /* replace617_0_0_0_0 -> 16 in the cache */
   /* replace617_0_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1864 },
      -1,
   } },
   /* replace617_0_1_0_0_0 -> 16 in the cache */
   /* replace617_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1867 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1865, 1868 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1869 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search618_0 -> 753 in the cache */
   /* search618_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 36 },
      0,
   } },
   /* search618_2_0 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1871, 1872 },
      -1,
   } },

   /* replace618_0_0 -> 753 in the cache */
   /* replace618_0_1 -> 36 in the cache */
   /* replace618_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 36, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1874 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search619_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1876 },
      -1,
   } },

   /* replace619_0 -> 16 in the cache */
   /* replace619 -> 696 in the cache */

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search620_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1878 },
      -1,
   } },

   /* replace620 -> 16 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search621_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1880 },
      -1,
   } },

   /* replace621 -> 16 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search622_0_0 -> 16 in the cache */
   /* search622_0 -> 1878 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1878 },
      -1,
   } },

   /* replace622 -> 16 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search623_0_0 -> 16 in the cache */
   /* search623_0 -> 1880 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1880 },
      -1,
   } },

   /* replace623 -> 16 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search624_0_0_0 -> 117 in the cache */
   /* search624_0_0_1 -> 16 in the cache */
   /* search624_0_0 -> 1840 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1840 },
      -1,
   } },
   /* search624_1_0_0_0 -> 16 in the cache */
   /* search624_1_0_0_1 -> 117 in the cache */
   /* search624_1_0_0 -> 697 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 697 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1885 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1884, 1886 },
      -1,
   } },

   /* replace624_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search625_0_0_0 -> 124 in the cache */
   /* search625_0_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1889 },
      -1,
   } },
   /* search625_1_0_0_0 -> 16 in the cache */
   /* search625_1_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1891 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1892 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1890, 1893 },
      -1,
   } },

   /* replace625_0_0 -> 16 in the cache */
   /* replace625_0 -> 1888 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1888 },
      -1,
   } },

   /* ('f2f32', ('f2f64', 'a@32')) => a */
   /* search626_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1896 },
      -1,
   } },

   /* replace626 -> 16 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search627_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1898 },
      -1,
   } },

   /* replace627 -> 16 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search628_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1900 },
      -1,
   } },

   /* replace628 -> 16 in the cache */

   /* ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a') */
   /* search629_0_0 -> 753 in the cache */
   /* search629_0 -> 1404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1404 },
      -1,
   } },

   /* replace629_0 -> 753 in the cache */
   /* replace629 -> 1400 in the cache */

   /* ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search630_0_0 -> 753 in the cache */
   /* search630_0 -> 1392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1392 },
      -1,
   } },

   /* replace630_0 -> 753 in the cache */
   /* replace630 -> 1388 in the cache */

   /* ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search631_0_0 -> 753 in the cache */
   /* search631_0 -> 1392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1392 },
      -1,
   } },

   /* replace631_0 -> 753 in the cache */
   /* replace631 -> 1388 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search632_0_0 -> 16 in the cache */
   /* search632_0 -> 1896 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1896 },
      -1,
   } },

   /* replace632_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search633_0_0 -> 16 in the cache */
   /* search633_0 -> 1896 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1896 },
      -1,
   } },

   /* replace633_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search634_0_0 -> 32 in the cache */
   /* search634_0 -> 1827 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1827 },
      -1,
   } },

   /* replace634_0 -> 32 in the cache */
   /* replace634 -> 1804 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search635_0_0 -> 32 in the cache */
   /* search635_0 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1829 },
      -1,
   } },

   /* replace635_0 -> 32 in the cache */
   /* replace635 -> 1807 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search636_0_0 -> 16 in the cache */
   /* search636_0 -> 1900 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1900 },
      -1,
   } },

   /* replace636_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search637_0_0 -> 16 in the cache */
   /* search637_0 -> 1898 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1898 },
      -1,
   } },

   /* replace637_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search638_0_0 -> 703 in the cache */
   /* search638_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 703, 21 },
      0,
   } },
   /* search638_1_0 -> 41 in the cache */
   /* search638_1_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1915, 1916 },
      -1,
   } },

   /* replace638_0 -> 703 in the cache */
   /* replace638_1_0 -> 21 in the cache */
   /* replace638_1_1_0 -> 41 in the cache */
   /* replace638_1_1 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 21, 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 703, 1918 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search639_0_0 -> 703 in the cache */
   /* search639_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 703, 21 },
      -1,
   } },
   /* search639_1_0 -> 41 in the cache */
   /* search639_1_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 703 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1920, 1921 },
      -1,
   } },

   /* replace639_0 -> 703 in the cache */
   /* replace639_1_0 -> 21 in the cache */
   /* replace639_1_1_0 -> 41 in the cache */
   /* replace639_1_1 -> 675 in the cache */
   /* replace639_1 -> 1918 in the cache */
   /* replace639 -> 1919 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search640_0_0 -> 703 in the cache */
   /* search640_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 703, 21 },
      0,
   } },
   /* search640_1_0 -> 41 in the cache */
   /* search640_1_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1923, 1924 },
      -1,
   } },

   /* replace640_0 -> 703 in the cache */
   /* replace640_1_0 -> 21 in the cache */
   /* replace640_1_1_0 -> 41 in the cache */
   /* replace640_1_1 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 21, 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 703, 1926 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search641_0_0 -> 703 in the cache */
   /* search641_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 703, 21 },
      -1,
   } },
   /* search641_1_0 -> 41 in the cache */
   /* search641_1_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 703 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1928, 1929 },
      -1,
   } },

   /* replace641_0 -> 703 in the cache */
   /* replace641_1_0 -> 21 in the cache */
   /* replace641_1_1_0 -> 41 in the cache */
   /* replace641_1_1 -> 675 in the cache */
   /* replace641_1 -> 1926 in the cache */
   /* replace641 -> 1927 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search642_0_0 -> 703 in the cache */
   /* search642_0_1 -> 21 in the cache */
   /* search642_0 -> 1915 in the cache */
   /* search642_1_0 -> 41 in the cache */
   /* search642_1_1 -> 703 in the cache */
   /* search642_1 -> 1916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1915, 1916 },
      -1,
   } },

   /* replace642_0 -> 703 in the cache */
   /* replace642_1_0 -> 21 in the cache */
   /* replace642_1_1_0 -> 41 in the cache */
   /* replace642_1_1 -> 675 in the cache */
   /* replace642_1 -> 1926 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 703, 1926 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search643_0_0 -> 703 in the cache */
   /* search643_0_1 -> 21 in the cache */
   /* search643_0 -> 1920 in the cache */
   /* search643_1_0 -> 41 in the cache */
   /* search643_1_1 -> 703 in the cache */
   /* search643_1 -> 1921 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1920, 1921 },
      -1,
   } },

   /* replace643_0 -> 703 in the cache */
   /* replace643_1_0 -> 21 in the cache */
   /* replace643_1_1_0 -> 41 in the cache */
   /* replace643_1_1 -> 675 in the cache */
   /* replace643_1 -> 1926 in the cache */
   /* replace643 -> 1932 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search644_0_0 -> 703 in the cache */
   /* search644_0_1 -> 21 in the cache */
   /* search644_0 -> 1923 in the cache */
   /* search644_1_0 -> 41 in the cache */
   /* search644_1_1 -> 703 in the cache */
   /* search644_1 -> 1924 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1923, 1924 },
      -1,
   } },

   /* replace644_0 -> 703 in the cache */
   /* replace644_1_0 -> 21 in the cache */
   /* replace644_1_1_0 -> 41 in the cache */
   /* replace644_1_1 -> 675 in the cache */
   /* replace644_1 -> 1918 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 703, 1918 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search645_0_0 -> 703 in the cache */
   /* search645_0_1 -> 21 in the cache */
   /* search645_0 -> 1928 in the cache */
   /* search645_1_0 -> 41 in the cache */
   /* search645_1_1 -> 703 in the cache */
   /* search645_1 -> 1929 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1928, 1929 },
      -1,
   } },

   /* replace645_0 -> 703 in the cache */
   /* replace645_1_0 -> 21 in the cache */
   /* replace645_1_1_0 -> 41 in the cache */
   /* replace645_1_1 -> 675 in the cache */
   /* replace645_1 -> 1918 in the cache */
   /* replace645 -> 1935 in the cache */

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search646_0_0 -> 21 in the cache */
   /* search646_0_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 21, 703 },
      -1,
   } },
   /* search646_1 -> 624 in the cache */
   /* search646_2_0_0_0_0 -> 703 in the cache */
   /* search646_2_0_0_0_1 -> 21 in the cache */
   /* search646_2_0_0_0 -> 1920 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1920 },
      -1,
   } },
   /* search646_2_0_1_0_0_0 -> 21 in the cache */
   /* search646_2_0_1_0_0_1 -> 703 in the cache */
   /* search646_2_0_1_0_0 -> 704 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1939 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1938, 1940 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1941 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1937, 624, 1942 },
      -1,
   } },

   /* replace646_0_0_0_0 -> 21 in the cache */
   /* replace646_0_0_0_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 21, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1944 },
      -1,
   } },
   /* replace646_0_1_0_0_0 -> 21 in the cache */
   /* replace646_0_1_0_0_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1946 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1947 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1945, 1948 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1949 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search647_0 -> 753 in the cache */
   /* search647_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 41 },
      0,
   } },
   /* search647_2_0 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 612 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 1951, 1952 },
      -1,
   } },

   /* replace647_0_0 -> 753 in the cache */
   /* replace647_0_1 -> 41 in the cache */
   /* replace647_0_2 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 753, 41, 612 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1954 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search648_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1956 },
      -1,
   } },

   /* replace648_0 -> 21 in the cache */
   /* replace648 -> 702 in the cache */

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search649_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1958 },
      -1,
   } },

   /* replace649 -> 21 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search650_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1960 },
      -1,
   } },

   /* replace650 -> 21 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search651_0_0 -> 21 in the cache */
   /* search651_0 -> 1958 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1958 },
      -1,
   } },

   /* replace651 -> 21 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search652_0_0 -> 21 in the cache */
   /* search652_0 -> 1960 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1960 },
      -1,
   } },

   /* replace652 -> 21 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search653_0_0_0 -> 703 in the cache */
   /* search653_0_0_1 -> 21 in the cache */
   /* search653_0_0 -> 1920 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1920 },
      -1,
   } },
   /* search653_1_0_0_0 -> 21 in the cache */
   /* search653_1_0_0_1 -> 703 in the cache */
   /* search653_1_0_0 -> 704 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1965 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1964, 1966 },
      -1,
   } },

   /* replace653_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search654_0_0_0 -> 890 in the cache */
   /* search654_0_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 890, 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1969 },
      -1,
   } },
   /* search654_1_0_0_0 -> 21 in the cache */
   /* search654_1_0_0_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1971 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1972 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1970, 1973 },
      -1,
   } },

   /* replace654_0_0 -> 21 in the cache */
   /* replace654_0 -> 1968 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1968 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search655_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1976 },
      -1,
   } },

   /* replace655_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search656_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1979 },
      -1,
   } },

   /* replace656_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search657_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1982 },
      -1,
   } },

   /* replace657_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search658_0_0 -> 16 in the cache */
   /* search658_0 -> 1982 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1982 },
      -1,
   } },

   /* replace658_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search659_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1987 },
      -1,
   } },

   /* replace659_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search660_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1990 },
      -1,
   } },

   /* replace660_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search661_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 1993 },
      -1,
   } },

   /* replace661_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search662_0_0 -> 16 in the cache */
   /* search662_0 -> 1993 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1993 },
      -1,
   } },

   /* replace662_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search663_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1998 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1999, 2000 },
      -1,
   } },

   /* replace663_0 -> 11 in the cache */
   /* replace663_1_0 -> 260 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 260, 2002 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 11, 2003 },
      -1,
   } },

   /* ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255)) */
   /* search664_0_0_0 -> 11 in the cache */
   /* search664_0_0_1 -> 2000 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 2000 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2005 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 1,
      { 2006 },
      -1,
   } },

   /* replace664_0 -> 11 in the cache */
   /* replace664_1_0 -> 260 in the cache */
   /* replace664_1_1 -> 2002 in the cache */
   /* replace664_1 -> 2003 in the cache */
   /* replace664 -> 2004 in the cache */

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search665_0_0_0_0 -> 11 in the cache */
   /* search665_0_0_0 -> 1998 in the cache */
   /* search665_0_0 -> 1999 in the cache */
   /* search665_0_1_0_0 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 260 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2008 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1999, 2009 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2010 },
      -1,
   } },

   /* replace665_0_0 -> 11 in the cache */
   /* replace665_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 260 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2012 },
      -1,
   } },

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search666_0_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2014 },
      -1,
   } },
   /* search666_0_1_0_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2016 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2015, 2017 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2018 },
      -1,
   } },

   /* replace666_0_0 -> 16 in the cache */
   /* replace666_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2020 },
      -1,
   } },

   /* ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b') */
   /* search667_0_0 -> 0 in the cache */
   /* search667_0_1 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 0, 814 },
      -1,
   } },
   /* search667_1_0 -> 142 in the cache */
   /* search667_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2022, 2023 },
      -1,
   } },

   /* replace667_0_0 -> 0 in the cache */
   /* replace667_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 142 },
      -1,
   } },
   /* replace667_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2025, 3 },
      -1,
   } },

   /* ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b') */
   /* search668_0_0 -> 0 in the cache */
   /* search668_0_1 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 0, 814 },
      -1,
   } },
   /* search668_1_0 -> 142 in the cache */
   /* search668_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2027, 2028 },
      -1,
   } },

   /* replace668_0_0 -> 0 in the cache */
   /* replace668_0_1 -> 142 in the cache */
   /* replace668_0 -> 2025 in the cache */
   /* replace668_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2025, 3 },
      -1,
   } },

   /* ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b') */
   /* search669_0_0 -> 0 in the cache */
   /* search669_0_1 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 0, 814 },
      -1,
   } },
   /* search669_1_0 -> 142 in the cache */
   /* search669_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2031, 2032 },
      -1,
   } },

   /* replace669_0_0 -> 0 in the cache */
   /* replace669_0_1 -> 142 in the cache */
   /* replace669_0 -> 2025 in the cache */
   /* replace669_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2025, 3 },
      -1,
   } },

   /* ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b') */
   /* search670_0_0 -> 0 in the cache */
   /* search670_0_1 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 0, 814 },
      -1,
   } },
   /* search670_1_0 -> 142 in the cache */
   /* search670_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2035, 2036 },
      -1,
   } },

   /* replace670_0_0 -> 0 in the cache */
   /* replace670_0_1 -> 142 in the cache */
   /* replace670_0 -> 2025 in the cache */
   /* replace670_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2025, 3 },
      -1,
   } },

   /* ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b') */
   /* search671_0_0 -> 128 in the cache */
   /* search671_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 128, 33 },
      0,
   } },
   /* search671_1_0 -> 131 in the cache */
   /* search671_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 131, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2039, 2040 },
      -1,
   } },

   /* replace671_0_0 -> 128 in the cache */
   /* replace671_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 128, 131 },
      -1,
   } },
   /* replace671_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2042, 36 },
      -1,
   } },

   /* ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b') */
   /* search672_0_0 -> 128 in the cache */
   /* search672_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 128, 33 },
      0,
   } },
   /* search672_1_0 -> 131 in the cache */
   /* search672_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 131, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2044, 2045 },
      -1,
   } },

   /* replace672_0_0 -> 128 in the cache */
   /* replace672_0_1 -> 131 in the cache */
   /* replace672_0 -> 2042 in the cache */
   /* replace672_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2042, 36 },
      -1,
   } },

   /* ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b') */
   /* search673_0_0 -> 128 in the cache */
   /* search673_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 128, 33 },
      0,
   } },
   /* search673_1_0 -> 131 in the cache */
   /* search673_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 131, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2048, 2049 },
      -1,
   } },

   /* replace673_0_0 -> 128 in the cache */
   /* replace673_0_1 -> 131 in the cache */
   /* replace673_0 -> 2042 in the cache */
   /* replace673_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2042, 36 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search674_0_0_0_0 -> 11 in the cache */
   /* search674_0_0_0 -> 1998 in the cache */
   /* search674_0_0 -> 1999 in the cache */
   /* search674_0_1_0_0 -> 260 in the cache */
   /* search674_0_1_0 -> 2008 in the cache */
   /* search674_0_1 -> 2009 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1999, 2009 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2052 },
      -1,
   } },

   /* replace674_0_0 -> 11 in the cache */
   /* replace674_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 11, 260 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2054 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search675_0_0_0_0 -> 16 in the cache */
   /* search675_0_0_0 -> 2014 in the cache */
   /* search675_0_0 -> 2015 in the cache */
   /* search675_0_1_0_0 -> 36 in the cache */
   /* search675_0_1_0 -> 2016 in the cache */
   /* search675_0_1 -> 2017 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2015, 2017 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2056 },
      -1,
   } },

   /* replace675_0_0 -> 16 in the cache */
   /* replace675_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2058 },
      -1,
   } },

   /* ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b') */
   /* search676_0_0 -> 0 in the cache */
   /* search676_0_1 -> 814 in the cache */
   /* search676_0 -> 2022 in the cache */
   /* search676_1_0 -> 142 in the cache */
   /* search676_1_1 -> 3 in the cache */
   /* search676_1 -> 2023 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2022, 2023 },
      -1,
   } },

   /* replace676_0_0 -> 0 in the cache */
   /* replace676_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 142 },
      -1,
   } },
   /* replace676_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2061, 3 },
      -1,
   } },

   /* ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b') */
   /* search677_0_0 -> 0 in the cache */
   /* search677_0_1 -> 814 in the cache */
   /* search677_0 -> 2027 in the cache */
   /* search677_1_0 -> 142 in the cache */
   /* search677_1_1 -> 3 in the cache */
   /* search677_1 -> 2028 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2027, 2028 },
      -1,
   } },

   /* replace677_0_0 -> 0 in the cache */
   /* replace677_0_1 -> 142 in the cache */
   /* replace677_0 -> 2061 in the cache */
   /* replace677_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2061, 3 },
      -1,
   } },

   /* ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b') */
   /* search678_0_0 -> 0 in the cache */
   /* search678_0_1 -> 814 in the cache */
   /* search678_0 -> 2031 in the cache */
   /* search678_1_0 -> 142 in the cache */
   /* search678_1_1 -> 3 in the cache */
   /* search678_1 -> 2032 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2031, 2032 },
      -1,
   } },

   /* replace678_0_0 -> 0 in the cache */
   /* replace678_0_1 -> 142 in the cache */
   /* replace678_0 -> 2061 in the cache */
   /* replace678_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2061, 3 },
      -1,
   } },

   /* ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b') */
   /* search679_0_0 -> 0 in the cache */
   /* search679_0_1 -> 814 in the cache */
   /* search679_0 -> 2035 in the cache */
   /* search679_1_0 -> 142 in the cache */
   /* search679_1_1 -> 3 in the cache */
   /* search679_1 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2035, 2036 },
      -1,
   } },

   /* replace679_0_0 -> 0 in the cache */
   /* replace679_0_1 -> 142 in the cache */
   /* replace679_0 -> 2061 in the cache */
   /* replace679_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2061, 3 },
      -1,
   } },

   /* ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b') */
   /* search680_0_0 -> 128 in the cache */
   /* search680_0_1 -> 33 in the cache */
   /* search680_0 -> 2039 in the cache */
   /* search680_1_0 -> 131 in the cache */
   /* search680_1_1 -> 36 in the cache */
   /* search680_1 -> 2040 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2039, 2040 },
      -1,
   } },

   /* replace680_0_0 -> 128 in the cache */
   /* replace680_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 128, 131 },
      -1,
   } },
   /* replace680_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2070, 36 },
      -1,
   } },

   /* ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b') */
   /* search681_0_0 -> 128 in the cache */
   /* search681_0_1 -> 33 in the cache */
   /* search681_0 -> 2044 in the cache */
   /* search681_1_0 -> 131 in the cache */
   /* search681_1_1 -> 36 in the cache */
   /* search681_1 -> 2045 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2044, 2045 },
      -1,
   } },

   /* replace681_0_0 -> 128 in the cache */
   /* replace681_0_1 -> 131 in the cache */
   /* replace681_0 -> 2070 in the cache */
   /* replace681_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2070, 36 },
      -1,
   } },

   /* ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b') */
   /* search682_0_0 -> 128 in the cache */
   /* search682_0_1 -> 33 in the cache */
   /* search682_0 -> 2048 in the cache */
   /* search682_1_0 -> 131 in the cache */
   /* search682_1_1 -> 36 in the cache */
   /* search682_1 -> 2049 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2048, 2049 },
      -1,
   } },

   /* replace682_0_0 -> 128 in the cache */
   /* replace682_0_1 -> 131 in the cache */
   /* replace682_0 -> 2070 in the cache */
   /* replace682_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2070, 36 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search683_0_0_0_0 -> 11 in the cache */
   /* search683_0_0_0 -> 1998 in the cache */
   /* search683_0_0 -> 1999 in the cache */
   /* search683_0_1_0_0 -> 260 in the cache */
   /* search683_0_1_0 -> 2008 in the cache */
   /* search683_0_1 -> 2009 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1999, 2009 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2076 },
      -1,
   } },

   /* replace683_0_0 -> 11 in the cache */
   /* replace683_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 11, 260 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2078 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search684_0_0_0_0 -> 16 in the cache */
   /* search684_0_0_0 -> 2014 in the cache */
   /* search684_0_0 -> 2015 in the cache */
   /* search684_0_1_0_0 -> 36 in the cache */
   /* search684_0_1_0 -> 2016 in the cache */
   /* search684_0_1 -> 2017 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2015, 2017 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2080 },
      -1,
   } },

   /* replace684_0_0 -> 16 in the cache */
   /* replace684_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2082 },
      -1,
   } },

   /* ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b') */
   /* search685_0_0 -> 0 in the cache */
   /* search685_0_1 -> 814 in the cache */
   /* search685_0 -> 2022 in the cache */
   /* search685_1_0 -> 142 in the cache */
   /* search685_1_1 -> 3 in the cache */
   /* search685_1 -> 2023 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2022, 2023 },
      -1,
   } },

   /* replace685_0_0 -> 0 in the cache */
   /* replace685_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 0, 142 },
      -1,
   } },
   /* replace685_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2085, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b') */
   /* search686_0_0 -> 0 in the cache */
   /* search686_0_1 -> 814 in the cache */
   /* search686_0 -> 2027 in the cache */
   /* search686_1_0 -> 142 in the cache */
   /* search686_1_1 -> 3 in the cache */
   /* search686_1 -> 2028 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2027, 2028 },
      -1,
   } },

   /* replace686_0_0 -> 0 in the cache */
   /* replace686_0_1 -> 142 in the cache */
   /* replace686_0 -> 2085 in the cache */
   /* replace686_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2085, 3 },
      -1,
   } },

   /* ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b') */
   /* search687_0_0 -> 0 in the cache */
   /* search687_0_1 -> 814 in the cache */
   /* search687_0 -> 2031 in the cache */
   /* search687_1_0 -> 142 in the cache */
   /* search687_1_1 -> 3 in the cache */
   /* search687_1 -> 2032 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2031, 2032 },
      -1,
   } },

   /* replace687_0_0 -> 0 in the cache */
   /* replace687_0_1 -> 142 in the cache */
   /* replace687_0 -> 2085 in the cache */
   /* replace687_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2085, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b') */
   /* search688_0_0 -> 0 in the cache */
   /* search688_0_1 -> 814 in the cache */
   /* search688_0 -> 2035 in the cache */
   /* search688_1_0 -> 142 in the cache */
   /* search688_1_1 -> 3 in the cache */
   /* search688_1 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2035, 2036 },
      -1,
   } },

   /* replace688_0_0 -> 0 in the cache */
   /* replace688_0_1 -> 142 in the cache */
   /* replace688_0 -> 2085 in the cache */
   /* replace688_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2085, 3 },
      -1,
   } },

   /* ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b') */
   /* search689_0_0 -> 128 in the cache */
   /* search689_0_1 -> 33 in the cache */
   /* search689_0 -> 2039 in the cache */
   /* search689_1_0 -> 131 in the cache */
   /* search689_1_1 -> 36 in the cache */
   /* search689_1 -> 2040 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2039, 2040 },
      -1,
   } },

   /* replace689_0_0 -> 128 in the cache */
   /* replace689_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 128, 131 },
      -1,
   } },
   /* replace689_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2094, 36 },
      -1,
   } },

   /* ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b') */
   /* search690_0_0 -> 128 in the cache */
   /* search690_0_1 -> 33 in the cache */
   /* search690_0 -> 2044 in the cache */
   /* search690_1_0 -> 131 in the cache */
   /* search690_1_1 -> 36 in the cache */
   /* search690_1 -> 2045 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2044, 2045 },
      -1,
   } },

   /* replace690_0_0 -> 128 in the cache */
   /* replace690_0_1 -> 131 in the cache */
   /* replace690_0 -> 2094 in the cache */
   /* replace690_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2094, 36 },
      -1,
   } },

   /* ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b') */
   /* search691_0_0 -> 128 in the cache */
   /* search691_0_1 -> 33 in the cache */
   /* search691_0 -> 2048 in the cache */
   /* search691_1_0 -> 131 in the cache */
   /* search691_1_1 -> 36 in the cache */
   /* search691_1 -> 2049 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2048, 2049 },
      -1,
   } },

   /* replace691_0_0 -> 128 in the cache */
   /* replace691_0_1 -> 131 in the cache */
   /* replace691_0 -> 2094 in the cache */
   /* replace691_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2094, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search692_0_0 -> 6 in the cache */
   /* search692_0_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 6, 828 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search692_1_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 2101, 828 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2100, 2102 },
      -1,
   } },

   /* replace692_0_0 -> 6 in the cache */
   /* replace692_0_1 -> 2101 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 6, 2101 },
      -1,
   } },
   /* replace692_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2104, 828 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search693_0_0 -> 6 in the cache */
   /* search693_0_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 6, 828 },
      -1,
   } },
   /* search693_1_0 -> 2101 in the cache */
   /* search693_1_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 2101, 828 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2106, 2107 },
      -1,
   } },

   /* replace693_0_0 -> 6 in the cache */
   /* replace693_0_1 -> 2101 in the cache */
   /* replace693_0 -> 2104 in the cache */
   /* replace693_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2104, 828 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search694_0_0 -> 6 in the cache */
   /* search694_0_1 -> 828 in the cache */
   /* search694_0 -> 2100 in the cache */
   /* search694_1_0 -> 2101 in the cache */
   /* search694_1_1 -> 828 in the cache */
   /* search694_1 -> 2102 in the cache */
   /* search694 -> 2103 in the cache */

   /* replace694_0_0 -> 6 in the cache */
   /* replace694_0_1 -> 2101 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 6, 2101 },
      -1,
   } },
   /* replace694_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2110, 828 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search695_0_0 -> 6 in the cache */
   /* search695_0_1 -> 828 in the cache */
   /* search695_0 -> 2100 in the cache */
   /* search695_1_0 -> 2101 in the cache */
   /* search695_1_1 -> 828 in the cache */
   /* search695_1 -> 2102 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2100, 2102 },
      -1,
   } },

   /* replace695_0_0 -> 6 in the cache */
   /* replace695_0_1 -> 2101 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 6, 2101 },
      -1,
   } },
   /* replace695_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2113, 828 },
      -1,
   } },

   /* ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search696_0_0 -> 6 in the cache */
   /* search696_0_1 -> 828 in the cache */
   /* search696_0 -> 2106 in the cache */
   /* search696_1_0 -> 2101 in the cache */
   /* search696_1_1 -> 828 in the cache */
   /* search696_1 -> 2107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2106, 2107 },
      -1,
   } },

   /* replace696_0_0 -> 6 in the cache */
   /* replace696_0_1 -> 2101 in the cache */
   /* replace696_0 -> 2113 in the cache */
   /* replace696_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2113, 828 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search697_0_0 -> 6 in the cache */
   /* search697_0_1 -> 828 in the cache */
   /* search697_0 -> 2106 in the cache */
   /* search697_1_0 -> 2101 in the cache */
   /* search697_1_1 -> 828 in the cache */
   /* search697_1 -> 2107 in the cache */
   /* search697 -> 2108 in the cache */

   /* replace697_0_0 -> 6 in the cache */
   /* replace697_0_1 -> 2101 in the cache */
   /* replace697_0 -> 2110 in the cache */
   /* replace697_1 -> 828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2110, 828 },
      -1,
   } },

   /* ('ineg', ('b2i8', 'a@8')) => a */
   /* search698_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2118 },
      -1,
   } },

   /* replace698 -> 6 in the cache */

   /* ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b') */
   /* search699_0 -> 6 in the cache */
   /* search699_1_0 -> 9 in the cache */
   /* search699_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 9, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 2120 },
      -1,
   } },

   /* replace699_0 -> 6 in the cache */
   /* replace699_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b') */
   /* search700_0 -> 6 in the cache */
   /* search700_1_0 -> 9 in the cache */
   /* search700_1_1 -> 36 in the cache */
   /* search700_1 -> 2120 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 6, 2120 },
      -1,
   } },

   /* replace700_0 -> 6 in the cache */
   /* replace700_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b') */
   /* search701_0 -> 6 in the cache */
   /* search701_1_0 -> 9 in the cache */
   /* search701_1_1 -> 36 in the cache */
   /* search701_1 -> 2120 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2120 },
      -1,
   } },

   /* replace701_0 -> 6 in the cache */
   /* replace701_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2)) */
   /* search702_0 -> 6 in the cache */
   /* search702_1_0_0 -> 36 in the cache */
   /* search702_1_0_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 36, 398 },
      -1,
   } },
   /* search702_1_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2127, 403 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2128 },
      -1,
   } },

   /* replace702_0 -> 6 in the cache */
   /* replace702_1_0 -> 36 in the cache */
   /* replace702_1_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 2130 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search703_0_0 -> 11 in the cache */
   /* search703_0_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 11, 849 },
      -1,
   } },
   /* search703_1_0 -> 260 in the cache */
   /* search703_1_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 260, 849 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2132, 2133 },
      -1,
   } },

   /* replace703_0_0 -> 11 in the cache */
   /* replace703_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 11, 260 },
      -1,
   } },
   /* replace703_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2135, 849 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search704_0_0 -> 11 in the cache */
   /* search704_0_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 11, 849 },
      -1,
   } },
   /* search704_1_0 -> 260 in the cache */
   /* search704_1_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 260, 849 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2137, 2138 },
      -1,
   } },

   /* replace704_0_0 -> 11 in the cache */
   /* replace704_0_1 -> 260 in the cache */
   /* replace704_0 -> 2135 in the cache */
   /* replace704_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2135, 849 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search705_0_0 -> 11 in the cache */
   /* search705_0_1 -> 849 in the cache */
   /* search705_0 -> 2132 in the cache */
   /* search705_1_0 -> 260 in the cache */
   /* search705_1_1 -> 849 in the cache */
   /* search705_1 -> 2133 in the cache */
   /* search705 -> 2134 in the cache */

   /* replace705_0_0 -> 11 in the cache */
   /* replace705_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 11, 260 },
      -1,
   } },
   /* replace705_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2141, 849 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search706_0_0 -> 11 in the cache */
   /* search706_0_1 -> 849 in the cache */
   /* search706_0 -> 2132 in the cache */
   /* search706_1_0 -> 260 in the cache */
   /* search706_1_1 -> 849 in the cache */
   /* search706_1 -> 2133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2132, 2133 },
      -1,
   } },

   /* replace706_0_0 -> 11 in the cache */
   /* replace706_0_1 -> 260 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 11, 260 },
      -1,
   } },
   /* replace706_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2144, 849 },
      -1,
   } },

   /* ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search707_0_0 -> 11 in the cache */
   /* search707_0_1 -> 849 in the cache */
   /* search707_0 -> 2137 in the cache */
   /* search707_1_0 -> 260 in the cache */
   /* search707_1_1 -> 849 in the cache */
   /* search707_1 -> 2138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2137, 2138 },
      -1,
   } },

   /* replace707_0_0 -> 11 in the cache */
   /* replace707_0_1 -> 260 in the cache */
   /* replace707_0 -> 2144 in the cache */
   /* replace707_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2144, 849 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search708_0_0 -> 11 in the cache */
   /* search708_0_1 -> 849 in the cache */
   /* search708_0 -> 2137 in the cache */
   /* search708_1_0 -> 260 in the cache */
   /* search708_1_1 -> 849 in the cache */
   /* search708_1 -> 2138 in the cache */
   /* search708 -> 2139 in the cache */

   /* replace708_0_0 -> 11 in the cache */
   /* replace708_0_1 -> 260 in the cache */
   /* replace708_0 -> 2141 in the cache */
   /* replace708_1 -> 849 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2141, 849 },
      -1,
   } },

   /* ('ineg', ('b2i16', 'a@16')) => a */
   /* search709_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2149 },
      -1,
   } },

   /* replace709 -> 11 in the cache */

   /* ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b') */
   /* search710_0 -> 11 in the cache */
   /* search710_1_0 -> 14 in the cache */
   /* search710_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 14, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2151 },
      -1,
   } },

   /* replace710_0 -> 11 in the cache */
   /* replace710_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b') */
   /* search711_0 -> 11 in the cache */
   /* search711_1_0 -> 14 in the cache */
   /* search711_1_1 -> 36 in the cache */
   /* search711_1 -> 2151 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 11, 2151 },
      -1,
   } },

   /* replace711_0 -> 11 in the cache */
   /* replace711_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b') */
   /* search712_0 -> 11 in the cache */
   /* search712_1_0 -> 14 in the cache */
   /* search712_1_1 -> 36 in the cache */
   /* search712_1 -> 2151 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2151 },
      -1,
   } },

   /* replace712_0 -> 11 in the cache */
   /* replace712_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3)) */
   /* search713_0 -> 11 in the cache */
   /* search713_1_0_0 -> 36 in the cache */
   /* search713_1_0_1 -> 398 in the cache */
   /* search713_1_0 -> 2127 in the cache */
   /* search713_1_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2127, 407 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2158 },
      -1,
   } },

   /* replace713_0 -> 11 in the cache */
   /* replace713_1_0 -> 36 in the cache */
   /* replace713_1_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2160 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search714_0_0 -> 16 in the cache */
   /* search714_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 16, 124 },
      -1,
   } },
   /* search714_1_0 -> 36 in the cache */
   /* search714_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2162, 2163 },
      -1,
   } },

   /* replace714_0_0 -> 16 in the cache */
   /* replace714_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace714_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2165, 124 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search715_0_0 -> 16 in the cache */
   /* search715_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 16, 124 },
      -1,
   } },
   /* search715_1_0 -> 36 in the cache */
   /* search715_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2167, 2168 },
      -1,
   } },

   /* replace715_0_0 -> 16 in the cache */
   /* replace715_0_1 -> 36 in the cache */
   /* replace715_0 -> 2165 in the cache */
   /* replace715_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2165, 124 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search716_0_0 -> 16 in the cache */
   /* search716_0_1 -> 124 in the cache */
   /* search716_0 -> 2162 in the cache */
   /* search716_1_0 -> 36 in the cache */
   /* search716_1_1 -> 124 in the cache */
   /* search716_1 -> 2163 in the cache */
   /* search716 -> 2164 in the cache */

   /* replace716_0_0 -> 16 in the cache */
   /* replace716_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace716_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2171, 124 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search717_0_0 -> 16 in the cache */
   /* search717_0_1 -> 124 in the cache */
   /* search717_0 -> 2162 in the cache */
   /* search717_1_0 -> 36 in the cache */
   /* search717_1_1 -> 124 in the cache */
   /* search717_1 -> 2163 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2162, 2163 },
      -1,
   } },

   /* replace717_0_0 -> 16 in the cache */
   /* replace717_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace717_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2174, 124 },
      -1,
   } },

   /* ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search718_0_0 -> 16 in the cache */
   /* search718_0_1 -> 124 in the cache */
   /* search718_0 -> 2167 in the cache */
   /* search718_1_0 -> 36 in the cache */
   /* search718_1_1 -> 124 in the cache */
   /* search718_1 -> 2168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2167, 2168 },
      -1,
   } },

   /* replace718_0_0 -> 16 in the cache */
   /* replace718_0_1 -> 36 in the cache */
   /* replace718_0 -> 2174 in the cache */
   /* replace718_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2174, 124 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search719_0_0 -> 16 in the cache */
   /* search719_0_1 -> 124 in the cache */
   /* search719_0 -> 2167 in the cache */
   /* search719_1_0 -> 36 in the cache */
   /* search719_1_1 -> 124 in the cache */
   /* search719_1 -> 2168 in the cache */
   /* search719 -> 2169 in the cache */

   /* replace719_0_0 -> 16 in the cache */
   /* replace719_0_1 -> 36 in the cache */
   /* replace719_0 -> 2171 in the cache */
   /* replace719_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2171, 124 },
      -1,
   } },

   /* ('ineg', ('b2i32', 'a@32')) => a */
   /* search720_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2179 },
      -1,
   } },

   /* replace720 -> 16 in the cache */

   /* ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b') */
   /* search721_0 -> 16 in the cache */
   /* search721_1_0 -> 19 in the cache */
   /* search721_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2181 },
      -1,
   } },

   /* replace721_0 -> 16 in the cache */
   /* replace721_1 -> 36 in the cache */
   /* replace721 -> 939 in the cache */

   /* ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b') */
   /* search722_0 -> 16 in the cache */
   /* search722_1_0 -> 19 in the cache */
   /* search722_1_1 -> 36 in the cache */
   /* search722_1 -> 2181 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 16, 2181 },
      -1,
   } },

   /* replace722_0 -> 16 in the cache */
   /* replace722_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b') */
   /* search723_0 -> 16 in the cache */
   /* search723_1_0 -> 19 in the cache */
   /* search723_1_1 -> 36 in the cache */
   /* search723_1 -> 2181 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2181 },
      -1,
   } },

   /* replace723_0 -> 16 in the cache */
   /* replace723_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4)) */
   /* search724_0 -> 16 in the cache */
   /* search724_1_0_0 -> 36 in the cache */
   /* search724_1_0_1 -> 398 in the cache */
   /* search724_1_0 -> 2127 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x4 /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2127, 2187 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2188 },
      -1,
   } },

   /* replace724_0 -> 16 in the cache */
   /* replace724_1_0 -> 36 in the cache */
   /* replace724_1_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 2187 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2190 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search725_0_0 -> 21 in the cache */
   /* search725_0_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 21, 890 },
      -1,
   } },
   /* search725_1_0 -> 41 in the cache */
   /* search725_1_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 41, 890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2192, 2193 },
      -1,
   } },

   /* replace725_0_0 -> 21 in the cache */
   /* replace725_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace725_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2195, 890 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search726_0_0 -> 21 in the cache */
   /* search726_0_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 21, 890 },
      -1,
   } },
   /* search726_1_0 -> 41 in the cache */
   /* search726_1_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 41, 890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2197, 2198 },
      -1,
   } },

   /* replace726_0_0 -> 21 in the cache */
   /* replace726_0_1 -> 41 in the cache */
   /* replace726_0 -> 2195 in the cache */
   /* replace726_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2195, 890 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search727_0_0 -> 21 in the cache */
   /* search727_0_1 -> 890 in the cache */
   /* search727_0 -> 2192 in the cache */
   /* search727_1_0 -> 41 in the cache */
   /* search727_1_1 -> 890 in the cache */
   /* search727_1 -> 2193 in the cache */
   /* search727 -> 2194 in the cache */

   /* replace727_0_0 -> 21 in the cache */
   /* replace727_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace727_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2201, 890 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search728_0_0 -> 21 in the cache */
   /* search728_0_1 -> 890 in the cache */
   /* search728_0 -> 2192 in the cache */
   /* search728_1_0 -> 41 in the cache */
   /* search728_1_1 -> 890 in the cache */
   /* search728_1 -> 2193 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2192, 2193 },
      -1,
   } },

   /* replace728_0_0 -> 21 in the cache */
   /* replace728_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace728_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2204, 890 },
      -1,
   } },

   /* ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search729_0_0 -> 21 in the cache */
   /* search729_0_1 -> 890 in the cache */
   /* search729_0 -> 2197 in the cache */
   /* search729_1_0 -> 41 in the cache */
   /* search729_1_1 -> 890 in the cache */
   /* search729_1 -> 2198 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2197, 2198 },
      -1,
   } },

   /* replace729_0_0 -> 21 in the cache */
   /* replace729_0_1 -> 41 in the cache */
   /* replace729_0 -> 2204 in the cache */
   /* replace729_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2204, 890 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search730_0_0 -> 21 in the cache */
   /* search730_0_1 -> 890 in the cache */
   /* search730_0 -> 2197 in the cache */
   /* search730_1_0 -> 41 in the cache */
   /* search730_1_1 -> 890 in the cache */
   /* search730_1 -> 2198 in the cache */
   /* search730 -> 2199 in the cache */

   /* replace730_0_0 -> 21 in the cache */
   /* replace730_0_1 -> 41 in the cache */
   /* replace730_0 -> 2201 in the cache */
   /* replace730_1 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2201, 890 },
      -1,
   } },

   /* ('ineg', ('b2i64', 'a@64')) => a */
   /* search731_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2209 },
      -1,
   } },

   /* replace731 -> 21 in the cache */

   /* ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b') */
   /* search732_0 -> 21 in the cache */
   /* search732_1_0 -> 24 in the cache */
   /* search732_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 2211 },
      -1,
   } },

   /* replace732_0 -> 21 in the cache */
   /* replace732_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b') */
   /* search733_0 -> 21 in the cache */
   /* search733_1_0 -> 24 in the cache */
   /* search733_1_1 -> 36 in the cache */
   /* search733_1 -> 2211 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 21, 2211 },
      -1,
   } },

   /* replace733_0 -> 21 in the cache */
   /* replace733_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b') */
   /* search734_0 -> 21 in the cache */
   /* search734_1_0 -> 24 in the cache */
   /* search734_1_1 -> 36 in the cache */
   /* search734_1 -> 2211 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2211 },
      -1,
   } },

   /* replace734_0 -> 21 in the cache */
   /* replace734_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5)) */
   /* search735_0 -> 21 in the cache */
   /* search735_1_0_0 -> 36 in the cache */
   /* search735_1_0_1 -> 398 in the cache */
   /* search735_1_0 -> 2127 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x5 /* 5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2127, 2218 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2219 },
      -1,
   } },

   /* replace735_0 -> 21 in the cache */
   /* replace735_1_0 -> 36 in the cache */
   /* replace735_1_1 -> 2218 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 2218 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 2221 },
      -1,
   } },

   /* ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a') */
   /* search736_0_0 -> 32 in the cache */
   /* search736_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 61 },
      -1,
   } },
   /* search736_1_0 -> 32 in the cache */
   /* search736_1_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 32, 35 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2223, 2224 },
      -1,
   } },

   /* replace736_0 -> 35 in the cache */
   /* replace736_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 35, 32 },
      -1,
   } },

   /* ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a') */
   /* search737_0_0 -> 35 in the cache */
   /* search737_0_1 -> 32 in the cache */
   /* search737_0 -> 2226 in the cache */
   /* search737_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2227 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2226, 2228 },
      -1,
   } },

   /* replace737_0 -> 2227 in the cache */
   /* replace737_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2227, 32 },
      -1,
   } },

   /* ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a') */
   /* search738_0_0 -> 2227 in the cache */
   /* search738_0_1 -> 32 in the cache */
   /* search738_0 -> 2230 in the cache */
   /* search738_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2231 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2230, 2232 },
      -1,
   } },

   /* replace738_0 -> 2231 in the cache */
   /* replace738_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2231, 32 },
      -1,
   } },

   /* ('ior', 'a', ('ieq', 'a', False)) => True */
   /* search739_0 -> 753 in the cache */
   /* search739_1_0 -> 753 in the cache */
   /* search739_1_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 753, 1070 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 753, 2235 },
      -1,
   } },

   /* replace739 -> 1224 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b') */
   /* search740_0_0_0 -> 753 in the cache */
   /* search740_0_0 -> 1215 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1215 },
      -1,
   } },
   /* search740_1_0_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2238 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2237, 2239 },
      -1,
   } },

   /* replace740_0 -> 753 in the cache */
   /* replace740_1 -> 1121 in the cache */
   /* replace740 -> 1383 in the cache */

   /* ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b')) */
   /* search741_0_0 -> 753 in the cache */
   /* search741_0_1 -> 1121 in the cache */
   /* search741_0 -> 1383 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1383 },
      -1,
   } },

   /* replace741_0_0 -> 753 in the cache */
   /* replace741_0_1 -> 1121 in the cache */
   /* replace741_0 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1138 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0)) */
   /* search742_0_0_0_0_0 -> 32 in the cache */
   /* search742_0_0_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 32, 61 },
      -1,
   } },
   /* search742_0_0_0_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      2, 2,
      { 2243, 1121 },
      -1,
   } },
   /* search742_0_0_1 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2244, 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2245 },
      -1,
   } },
   /* search742_1_0 -> 32 in the cache */
   /* search742_1_1 -> 61 in the cache */
   /* search742_1 -> 1238 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2246, 1238 },
      -1,
   } },

   /* replace742_0_0_0 -> 1121 in the cache */
   /* replace742_0_0_1 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 1121, 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2248 },
      -1,
   } },
   /* replace742_1_0 -> 32 in the cache */
   /* replace742_1_1 -> 61 in the cache */
   /* replace742_1 -> 1238 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2249, 1238 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0)) */
   /* search743_0_0_0_0_0 -> 0 in the cache */
   /* search743_0_0_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      3, 1,
      { 0, 3 },
      -1,
   } },
   /* search743_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 2,
      { 2251, 86 },
      -1,
   } },
   /* search743_0_0_1 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2252, 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2253 },
      -1,
   } },
   /* search743_1_0 -> 0 in the cache */
   /* search743_1_1 -> 86 in the cache */
   /* search743_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2254, 90 },
      -1,
   } },

   /* replace743_0_0_0_0 -> 3 in the cache */
   /* replace743_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 3, 86 },
      -1,
   } },
   /* replace743_0_0_1 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 2,
      { 2256, 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 2,
      { 2257 },
      -1,
   } },
   /* replace743_1_0 -> 0 in the cache */
   /* replace743_1_1 -> 86 in the cache */
   /* replace743_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2258, 90 },
      -1,
   } },

   /* ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b') */
   /* search744_0 -> 32 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search744_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2261 },
      -1,
   } },

   /* replace744_0 -> 32 in the cache */
   /* replace744_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 2260 },
      -1,
   } },

   /* ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a') */
   /* search745_0_0 -> 0 in the cache */
   /* search745_0_1 -> 3 in the cache */
   /* search745_0 -> 1272 in the cache */
   /* search745_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1272, 0 },
      -1,
   } },

   /* replace745_0 -> 3 in the cache */
   /* replace745_1 -> 0 in the cache */
   /* replace745 -> 1071 in the cache */

   /* ('~fge', 'a', ('fmin', 'b', 'a')) => True */
   /* search746_0 -> 32 in the cache */
   /* search746_1_0 -> 2260 in the cache */
   /* search746_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2265 },
      -1,
   } },

   /* replace746 -> 1224 in the cache */

   /* ('~fge', ('fmax', 'a', 'b'), 'a') => True */
   /* search747_0_0 -> 0 in the cache */
   /* search747_0_1 -> 3 in the cache */
   /* search747_0 -> 1270 in the cache */
   /* search747_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1270, 0 },
      -1,
   } },

   /* replace747 -> 1224 in the cache */

   /* ('flt', 'a', ('fmin', 'b', 'a')) => False */
   /* search748_0 -> 32 in the cache */
   /* search748_1_0 -> 2260 in the cache */
   /* search748_1_1 -> 32 in the cache */
   /* search748_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2265 },
      -1,
   } },

   /* replace748 -> 1070 in the cache */

   /* ('flt', ('fmax', 'a', 'b'), 'a') => False */
   /* search749_0_0 -> 0 in the cache */
   /* search749_0_1 -> 3 in the cache */
   /* search749_0 -> 1270 in the cache */
   /* search749_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1270, 0 },
      -1,
   } },

   /* replace749 -> 1070 in the cache */

   /* ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b') */
   /* search750_0 -> 32 in the cache */
   /* search750_1_0 -> 2260 in the cache */
   /* search750_1_1 -> 32 in the cache */
   /* search750_1 -> 2261 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2261 },
      -1,
   } },

   /* replace750_0 -> 32 in the cache */
   /* replace750_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 2260 },
      -1,
   } },

   /* ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a') */
   /* search751_0_0 -> 0 in the cache */
   /* search751_0_1 -> 3 in the cache */
   /* search751_0 -> 1272 in the cache */
   /* search751_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1272, 0 },
      -1,
   } },

   /* replace751_0 -> 3 in the cache */
   /* replace751_1 -> 0 in the cache */
   /* replace751 -> 1083 in the cache */

   /* ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b') */
   /* search752_0 -> 32 in the cache */
   /* search752_1_0 -> 2260 in the cache */
   /* search752_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2273 },
      -1,
   } },

   /* replace752_0 -> 32 in the cache */
   /* replace752_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 2260 },
      -1,
   } },

   /* ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a') */
   /* search753_0_0 -> 0 in the cache */
   /* search753_0_1 -> 3 in the cache */
   /* search753_0 -> 1292 in the cache */
   /* search753_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1292, 0 },
      -1,
   } },

   /* replace753_0 -> 3 in the cache */
   /* replace753_1 -> 0 in the cache */
   /* replace753 -> 1076 in the cache */

   /* ('ige', 'a', ('imin', 'b', 'a')) => True */
   /* search754_0 -> 32 in the cache */
   /* search754_1_0 -> 2260 in the cache */
   /* search754_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2277 },
      -1,
   } },

   /* replace754 -> 1224 in the cache */

   /* ('ige', ('imax', 'a', 'b'), 'a') => True */
   /* search755_0_0 -> 0 in the cache */
   /* search755_0_1 -> 3 in the cache */
   /* search755_0 -> 1290 in the cache */
   /* search755_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1290, 0 },
      -1,
   } },

   /* replace755 -> 1224 in the cache */

   /* ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b') */
   /* search756_0 -> 32 in the cache */
   /* search756_1_0 -> 2260 in the cache */
   /* search756_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2280 },
      -1,
   } },

   /* replace756_0 -> 32 in the cache */
   /* replace756_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 2260 },
      -1,
   } },

   /* ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a') */
   /* search757_0_0 -> 0 in the cache */
   /* search757_0_1 -> 3 in the cache */
   /* search757_0 -> 1282 in the cache */
   /* search757_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1282, 0 },
      -1,
   } },

   /* replace757_0 -> 3 in the cache */
   /* replace757_1 -> 0 in the cache */
   /* replace757 -> 1078 in the cache */

   /* ('uge', 'a', ('umin', 'b', 'a')) => True */
   /* search758_0 -> 32 in the cache */
   /* search758_1_0 -> 2260 in the cache */
   /* search758_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2284 },
      -1,
   } },

   /* replace758 -> 1224 in the cache */

   /* ('uge', ('umax', 'a', 'b'), 'a') => True */
   /* search759_0_0 -> 0 in the cache */
   /* search759_0_1 -> 3 in the cache */
   /* search759_0 -> 1280 in the cache */
   /* search759_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1280, 0 },
      -1,
   } },

   /* replace759 -> 1224 in the cache */

   /* ('ilt', 'a', ('imin', 'b', 'a')) => False */
   /* search760_0 -> 32 in the cache */
   /* search760_1_0 -> 2260 in the cache */
   /* search760_1_1 -> 32 in the cache */
   /* search760_1 -> 2277 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2277 },
      -1,
   } },

   /* replace760 -> 1070 in the cache */

   /* ('ilt', ('imax', 'a', 'b'), 'a') => False */
   /* search761_0_0 -> 0 in the cache */
   /* search761_0_1 -> 3 in the cache */
   /* search761_0 -> 1290 in the cache */
   /* search761_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1290, 0 },
      -1,
   } },

   /* replace761 -> 1070 in the cache */

   /* ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b') */
   /* search762_0 -> 32 in the cache */
   /* search762_1_0 -> 2260 in the cache */
   /* search762_1_1 -> 32 in the cache */
   /* search762_1 -> 2273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2273 },
      -1,
   } },

   /* replace762_0 -> 32 in the cache */
   /* replace762_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 2260 },
      -1,
   } },

   /* ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a') */
   /* search763_0_0 -> 0 in the cache */
   /* search763_0_1 -> 3 in the cache */
   /* search763_0 -> 1292 in the cache */
   /* search763_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1292, 0 },
      -1,
   } },

   /* replace763_0 -> 3 in the cache */
   /* replace763_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('umin', 'b', 'a')) => False */
   /* search764_0 -> 32 in the cache */
   /* search764_1_0 -> 2260 in the cache */
   /* search764_1_1 -> 32 in the cache */
   /* search764_1 -> 2284 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2284 },
      -1,
   } },

   /* replace764 -> 1070 in the cache */

   /* ('ult', ('umax', 'a', 'b'), 'a') => False */
   /* search765_0_0 -> 0 in the cache */
   /* search765_0_1 -> 3 in the cache */
   /* search765_0 -> 1280 in the cache */
   /* search765_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1280, 0 },
      -1,
   } },

   /* replace765 -> 1070 in the cache */

   /* ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b') */
   /* search766_0 -> 32 in the cache */
   /* search766_1_0 -> 2260 in the cache */
   /* search766_1_1 -> 32 in the cache */
   /* search766_1 -> 2280 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2280 },
      -1,
   } },

   /* replace766_0 -> 32 in the cache */
   /* replace766_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 2260 },
      -1,
   } },

   /* ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a') */
   /* search767_0_0 -> 0 in the cache */
   /* search767_0_1 -> 3 in the cache */
   /* search767_0 -> 1282 in the cache */
   /* search767_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1282, 0 },
      -1,
   } },

   /* replace767_0 -> 3 in the cache */
   /* replace767_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('iand', 'b', 'a')) => False */
   /* search768_0 -> 32 in the cache */
   /* search768_1_0 -> 2260 in the cache */
   /* search768_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2260, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2299 },
      -1,
   } },

   /* replace768 -> 1070 in the cache */

   /* ('ult', ('ior', 'a', 'b'), 'a') => False */
   /* search769_0_0 -> 0 in the cache */
   /* search769_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 3 },
      -1,
   } },
   /* search769_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2301, 0 },
      -1,
   } },

   /* replace769 -> 1070 in the cache */

   /* ('uge', 'a', ('iand', 'b', 'a')) => True */
   /* search770_0 -> 32 in the cache */
   /* search770_1_0 -> 2260 in the cache */
   /* search770_1_1 -> 32 in the cache */
   /* search770_1 -> 2299 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2299 },
      -1,
   } },

   /* replace770 -> 1224 in the cache */

   /* ('uge', ('ior', 'a', 'b'), 'a') => True */
   /* search771_0_0 -> 0 in the cache */
   /* search771_0_1 -> 3 in the cache */
   /* search771_0 -> 2301 in the cache */
   /* search771_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2301, 0 },
      -1,
   } },

   /* replace771 -> 1224 in the cache */

   /* ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search772_0 -> 284 in the cache */
   /* search772_1_0 -> 285 in the cache */
   /* search772_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 285, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 284, 2305 },
      -1,
   } },

   /* replace772_0_0 -> 128 in the cache */
   /* replace772_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace772_1_0 -> 128 in the cache */
   /* replace772_1_1 -> 131 in the cache */
   /* replace772_1 -> 1649 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2307, 1649 },
      -1,
   } },

   /* ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search773_0_0 -> 284 in the cache */
   /* search773_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 284, 129 },
      -1,
   } },
   /* search773_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2309, 807 },
      -1,
   } },

   /* replace773_0_0 -> 128 in the cache */
   /* replace773_0_1 -> 131 in the cache */
   /* replace773_0 -> 1649 in the cache */
   /* replace773_1_0 -> 129 in the cache */
   /* replace773_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1649, 2311 },
      -1,
   } },

   /* ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search774_0 -> 284 in the cache */
   /* search774_1_0 -> 285 in the cache */
   /* search774_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 285, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 284, 2313 },
      -1,
   } },

   /* replace774_0_0 -> 128 in the cache */
   /* replace774_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace774_1_0 -> 128 in the cache */
   /* replace774_1_1 -> 131 in the cache */
   /* replace774_1 -> 1659 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2315, 1659 },
      -1,
   } },

   /* ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search775_0_0 -> 284 in the cache */
   /* search775_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 284, 129 },
      -1,
   } },
   /* search775_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2317, 807 },
      -1,
   } },

   /* replace775_0_0 -> 128 in the cache */
   /* replace775_0_1 -> 131 in the cache */
   /* replace775_0 -> 1659 in the cache */
   /* replace775_1_0 -> 129 in the cache */
   /* replace775_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1659, 2319 },
      -1,
   } },

   /* ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search776_0 -> 284 in the cache */
   /* search776_1_0 -> 285 in the cache */
   /* search776_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 285, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 284, 2321 },
      -1,
   } },

   /* replace776_0_0 -> 128 in the cache */
   /* replace776_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace776_1_0 -> 128 in the cache */
   /* replace776_1_1 -> 131 in the cache */
   /* replace776_1 -> 1669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2323, 1669 },
      -1,
   } },

   /* ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search777_0_0 -> 284 in the cache */
   /* search777_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 284, 129 },
      -1,
   } },
   /* search777_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2325, 807 },
      -1,
   } },

   /* replace777_0_0 -> 128 in the cache */
   /* replace777_0_1 -> 131 in the cache */
   /* replace777_0 -> 1669 in the cache */
   /* replace777_1_0 -> 129 in the cache */
   /* replace777_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1669, 2327 },
      -1,
   } },

   /* ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search778_0 -> 284 in the cache */
   /* search778_1_0 -> 285 in the cache */
   /* search778_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 285, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 284, 2329 },
      -1,
   } },

   /* replace778_0_0 -> 128 in the cache */
   /* replace778_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace778_1_0 -> 128 in the cache */
   /* replace778_1_1 -> 131 in the cache */
   /* replace778_1 -> 1679 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2331, 1679 },
      -1,
   } },

   /* ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search779_0_0 -> 284 in the cache */
   /* search779_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 284, 129 },
      -1,
   } },
   /* search779_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2333, 807 },
      -1,
   } },

   /* replace779_0_0 -> 128 in the cache */
   /* replace779_0_1 -> 131 in the cache */
   /* replace779_0 -> 1679 in the cache */
   /* replace779_1_0 -> 129 in the cache */
   /* replace779_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1679, 2335 },
      -1,
   } },

   /* ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search780_0 -> 284 in the cache */
   /* search780_1_0 -> 285 in the cache */
   /* search780_1_1 -> 131 in the cache */
   /* search780_1 -> 2313 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 284, 2313 },
      -1,
   } },

   /* replace780_0_0 -> 128 in the cache */
   /* replace780_0_1 -> 129 in the cache */
   /* replace780_0 -> 2307 in the cache */
   /* replace780_1_0 -> 128 in the cache */
   /* replace780_1_1 -> 131 in the cache */
   /* replace780_1 -> 1649 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2307, 1649 },
      -1,
   } },

   /* ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search781_0_0 -> 284 in the cache */
   /* search781_0_1 -> 129 in the cache */
   /* search781_0 -> 2317 in the cache */
   /* search781_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2317, 807 },
      -1,
   } },

   /* replace781_0_0 -> 128 in the cache */
   /* replace781_0_1 -> 131 in the cache */
   /* replace781_0 -> 1649 in the cache */
   /* replace781_1_0 -> 129 in the cache */
   /* replace781_1_1 -> 131 in the cache */
   /* replace781_1 -> 2311 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1649, 2311 },
      -1,
   } },

   /* ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search782_0 -> 284 in the cache */
   /* search782_1_0 -> 285 in the cache */
   /* search782_1_1 -> 131 in the cache */
   /* search782_1 -> 2305 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 284, 2305 },
      -1,
   } },

   /* replace782_0_0 -> 128 in the cache */
   /* replace782_0_1 -> 129 in the cache */
   /* replace782_0 -> 2315 in the cache */
   /* replace782_1_0 -> 128 in the cache */
   /* replace782_1_1 -> 131 in the cache */
   /* replace782_1 -> 1659 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2315, 1659 },
      -1,
   } },

   /* ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search783_0_0 -> 284 in the cache */
   /* search783_0_1 -> 129 in the cache */
   /* search783_0 -> 2309 in the cache */
   /* search783_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2309, 807 },
      -1,
   } },

   /* replace783_0_0 -> 128 in the cache */
   /* replace783_0_1 -> 131 in the cache */
   /* replace783_0 -> 1659 in the cache */
   /* replace783_1_0 -> 129 in the cache */
   /* replace783_1_1 -> 131 in the cache */
   /* replace783_1 -> 2319 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1659, 2319 },
      -1,
   } },

   /* ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search784_0 -> 284 in the cache */
   /* search784_1_0 -> 285 in the cache */
   /* search784_1_1 -> 131 in the cache */
   /* search784_1 -> 2329 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 284, 2329 },
      -1,
   } },

   /* replace784_0_0 -> 128 in the cache */
   /* replace784_0_1 -> 129 in the cache */
   /* replace784_0 -> 2323 in the cache */
   /* replace784_1_0 -> 128 in the cache */
   /* replace784_1_1 -> 131 in the cache */
   /* replace784_1 -> 1669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2323, 1669 },
      -1,
   } },

   /* ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search785_0_0 -> 284 in the cache */
   /* search785_0_1 -> 129 in the cache */
   /* search785_0 -> 2333 in the cache */
   /* search785_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2333, 807 },
      -1,
   } },

   /* replace785_0_0 -> 128 in the cache */
   /* replace785_0_1 -> 131 in the cache */
   /* replace785_0 -> 1669 in the cache */
   /* replace785_1_0 -> 129 in the cache */
   /* replace785_1_1 -> 131 in the cache */
   /* replace785_1 -> 2327 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1669, 2327 },
      -1,
   } },

   /* ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search786_0 -> 284 in the cache */
   /* search786_1_0 -> 285 in the cache */
   /* search786_1_1 -> 131 in the cache */
   /* search786_1 -> 2321 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 284, 2321 },
      -1,
   } },

   /* replace786_0_0 -> 128 in the cache */
   /* replace786_0_1 -> 129 in the cache */
   /* replace786_0 -> 2331 in the cache */
   /* replace786_1_0 -> 128 in the cache */
   /* replace786_1_1 -> 131 in the cache */
   /* replace786_1 -> 1679 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2331, 1679 },
      -1,
   } },

   /* ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search787_0_0 -> 284 in the cache */
   /* search787_0_1 -> 129 in the cache */
   /* search787_0 -> 2325 in the cache */
   /* search787_1 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2325, 807 },
      -1,
   } },

   /* replace787_0_0 -> 128 in the cache */
   /* replace787_0_1 -> 131 in the cache */
   /* replace787_0 -> 1679 in the cache */
   /* replace787_1_0 -> 129 in the cache */
   /* replace787_1_1 -> 131 in the cache */
   /* replace787_1 -> 2335 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1679, 2335 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b')) */
   /* search788_0_0 -> 32 in the cache */
   /* search788_0_1 -> 61 in the cache */
   /* search788_0 -> 1238 in the cache */
   /* search788_1_0_0 -> 32 in the cache */
   /* search788_1_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2353 },
      -1,
   } },
   /* search788_2_0 -> 32 in the cache */
   /* search788_2_1 -> 36 in the cache */
   /* search788_2 -> 2353 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1238, 2354, 2353 },
      -1,
   } },

   /* replace788_0_0 -> 32 in the cache */
   /* replace788_0_1 -> 36 in the cache */
   /* replace788_0 -> 2353 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2353 },
      -1,
   } },

   /* ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b') */
   /* search789_0_0_0 -> 32 in the cache */
   /* search789_0_0 -> 106 in the cache */
   /* search789_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 106, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2357 },
      -1,
   } },

   /* replace789_0_0 -> 32 in the cache */
   /* replace789_0 -> 106 in the cache */
   /* replace789_1 -> 36 in the cache */
   /* replace789 -> 2357 in the cache */

   /* ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b') */
   /* search790_0_0 -> 0 in the cache */
   /* search790_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_slt,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2359 },
      -1,
   } },

   /* replace790_0 -> 0 in the cache */
   /* replace790_1 -> 3 in the cache */
   /* replace790 -> 2359 in the cache */

   /* ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b') */
   /* search791_0_0 -> 0 in the cache */
   /* search791_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sge,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2361 },
      -1,
   } },

   /* replace791_0 -> 0 in the cache */
   /* replace791_1 -> 3 in the cache */
   /* replace791 -> 2361 in the cache */

   /* ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b') */
   /* search792_0_0 -> 0 in the cache */
   /* search792_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2363 },
      -1,
   } },

   /* replace792_0 -> 0 in the cache */
   /* replace792_1 -> 3 in the cache */
   /* replace792 -> 2363 in the cache */

   /* ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b') */
   /* search793_0_0 -> 0 in the cache */
   /* search793_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2365 },
      -1,
   } },

   /* replace793_0 -> 0 in the cache */
   /* replace793_1 -> 3 in the cache */
   /* replace793 -> 2365 in the cache */

   /* ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b')) */
   /* search794_0 -> 0 in the cache */
   /* search794_1 -> 3 in the cache */
   /* search794 -> 2359 in the cache */

   /* replace794_0_0 -> 0 in the cache */
   /* replace794_0_1 -> 3 in the cache */
   /* replace794_0 -> 1042 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1042 },
      -1,
   } },

   /* ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b')) */
   /* search795_0 -> 0 in the cache */
   /* search795_1 -> 3 in the cache */
   /* search795 -> 2361 in the cache */

   /* replace795_0_0 -> 0 in the cache */
   /* replace795_0_1 -> 3 in the cache */
   /* replace795_0 -> 1039 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1039 },
      -1,
   } },

   /* ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b')) */
   /* search796_0 -> 0 in the cache */
   /* search796_1 -> 3 in the cache */
   /* search796 -> 2363 in the cache */

   /* replace796_0_0 -> 0 in the cache */
   /* replace796_0_1 -> 3 in the cache */
   /* replace796_0 -> 1048 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1048 },
      -1,
   } },

   /* ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b')) */
   /* search797_0 -> 0 in the cache */
   /* search797_1 -> 3 in the cache */
   /* search797 -> 2365 in the cache */

   /* replace797_0_0 -> 0 in the cache */
   /* replace797_0_1 -> 3 in the cache */
   /* replace797_0 -> 1045 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1045 },
      -1,
   } },

   /* ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search798_0_0 -> 0 in the cache */
   /* search798_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search798_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2371, 272 },
      -1,
   } },

   /* replace798_0 -> 0 in the cache */
   /* replace798_1 -> 3 in the cache */
   /* replace798 -> 2363 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search799_0_0 -> 0 in the cache */
   /* search799_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search799_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2373, 272 },
      -1,
   } },

   /* replace799_0 -> 0 in the cache */
   /* replace799_1 -> 3 in the cache */
   /* replace799 -> 2365 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search800_0_0 -> 0 in the cache */
   /* search800_0_1 -> 3 in the cache */
   /* search800_0 -> 2359 in the cache */
   /* search800_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2359, 272 },
      -1,
   } },

   /* replace800_0 -> 0 in the cache */
   /* replace800_1 -> 3 in the cache */
   /* replace800 -> 2359 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search801_0_0 -> 0 in the cache */
   /* search801_0_1 -> 3 in the cache */
   /* search801_0 -> 2361 in the cache */
   /* search801_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2361, 272 },
      -1,
   } },

   /* replace801_0 -> 0 in the cache */
   /* replace801_1 -> 3 in the cache */
   /* replace801 -> 2361 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search802_0_0 -> 0 in the cache */
   /* search802_0_1 -> 3 in the cache */
   /* search802_0 -> 2371 in the cache */
   /* search802_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2371, 258 },
      -1,
   } },

   /* replace802_0 -> 0 in the cache */
   /* replace802_1 -> 3 in the cache */
   /* replace802 -> 2363 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search803_0_0 -> 0 in the cache */
   /* search803_0_1 -> 3 in the cache */
   /* search803_0 -> 2373 in the cache */
   /* search803_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2373, 258 },
      -1,
   } },

   /* replace803_0 -> 0 in the cache */
   /* replace803_1 -> 3 in the cache */
   /* replace803 -> 2365 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search804_0_0 -> 0 in the cache */
   /* search804_0_1 -> 3 in the cache */
   /* search804_0 -> 2359 in the cache */
   /* search804_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2359, 258 },
      -1,
   } },

   /* replace804_0 -> 0 in the cache */
   /* replace804_1 -> 3 in the cache */
   /* replace804 -> 2359 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search805_0_0 -> 0 in the cache */
   /* search805_0_1 -> 3 in the cache */
   /* search805_0 -> 2361 in the cache */
   /* search805_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2361, 258 },
      -1,
   } },

   /* replace805_0 -> 0 in the cache */
   /* replace805_1 -> 3 in the cache */
   /* replace805 -> 2361 in the cache */

   /* ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search806_0_0 -> 0 in the cache */
   /* search806_0_1 -> 3 in the cache */
   /* search806_0 -> 2371 in the cache */
   /* search806_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2371, 258 },
      -1,
   } },

   /* replace806_0 -> 0 in the cache */
   /* replace806_1 -> 3 in the cache */
   /* replace806 -> 2365 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search807_0_0 -> 0 in the cache */
   /* search807_0_1 -> 3 in the cache */
   /* search807_0 -> 2373 in the cache */
   /* search807_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2373, 258 },
      -1,
   } },

   /* replace807_0 -> 0 in the cache */
   /* replace807_1 -> 3 in the cache */
   /* replace807 -> 2363 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search808_0_0 -> 0 in the cache */
   /* search808_0_1 -> 3 in the cache */
   /* search808_0 -> 2359 in the cache */
   /* search808_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2359, 258 },
      -1,
   } },

   /* replace808_0 -> 0 in the cache */
   /* replace808_1 -> 3 in the cache */
   /* replace808 -> 2361 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search809_0_0 -> 0 in the cache */
   /* search809_0_1 -> 3 in the cache */
   /* search809_0 -> 2361 in the cache */
   /* search809_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2361, 258 },
      -1,
   } },

   /* replace809_0 -> 0 in the cache */
   /* replace809_1 -> 3 in the cache */
   /* replace809 -> 2359 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search810_0_0 -> 0 in the cache */
   /* search810_0_1 -> 3 in the cache */
   /* search810_0 -> 2371 in the cache */
   /* search810_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2371, 272 },
      -1,
   } },

   /* replace810_0 -> 0 in the cache */
   /* replace810_1 -> 3 in the cache */
   /* replace810 -> 2365 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search811_0_0 -> 0 in the cache */
   /* search811_0_1 -> 3 in the cache */
   /* search811_0 -> 2373 in the cache */
   /* search811_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2373, 272 },
      -1,
   } },

   /* replace811_0 -> 0 in the cache */
   /* replace811_1 -> 3 in the cache */
   /* replace811 -> 2363 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search812_0_0 -> 0 in the cache */
   /* search812_0_1 -> 3 in the cache */
   /* search812_0 -> 2359 in the cache */
   /* search812_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2359, 272 },
      -1,
   } },

   /* replace812_0 -> 0 in the cache */
   /* replace812_1 -> 3 in the cache */
   /* replace812 -> 2361 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search813_0_0 -> 0 in the cache */
   /* search813_0_1 -> 3 in the cache */
   /* search813_0 -> 2361 in the cache */
   /* search813_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2361, 272 },
      -1,
   } },

   /* replace813_0 -> 0 in the cache */
   /* replace813_1 -> 3 in the cache */
   /* replace813 -> 2359 in the cache */

   /* ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y')) */
   /* search814_0 -> 16 in the cache */
   /* search814_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2390, 2391 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 2393, 2394 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      -1, 2,
      { 2392, 2395 },
      -1,
   } },

   /* ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0) */
   /* search815_0 -> 16 in the cache */
   /* search815_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace815_0_0 -> 16 in the cache */
   /* replace815_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace815_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2398, 117 },
      -1,
   } },

   /* ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0) */
   /* search816_0 -> 16 in the cache */
   /* search816_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace816_0_0 -> 16 in the cache */
   /* replace816_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace816_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2401, 117 },
      -1,
   } },

   /* ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0) */
   /* search817_0 -> 16 in the cache */
   /* search817_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal8,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace817_0_0 -> 16 in the cache */
   /* replace817_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal8,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace817_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2404, 117 },
      -1,
   } },

   /* ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0) */
   /* search818_0 -> 16 in the cache */
   /* search818_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal16,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace818_0_0 -> 16 in the cache */
   /* replace818_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal16,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace818_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2407, 117 },
      -1,
   } },

   /* ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y')) */
   /* search819_0 -> 16 in the cache */
   /* search819_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace819_0_0 -> 2390 in the cache */
   /* replace819_0_1 -> 2391 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2390, 2391 },
      -1,
   } },
   /* replace819_1_0 -> 2393 in the cache */
   /* replace819_1_1 -> 2394 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 2393, 2394 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      -1, 2,
      { 2410, 2411 },
      -1,
   } },

   /* ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search820_0 -> 16 in the cache */
   /* search820_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace820_0_0_0 -> 16 in the cache */
   /* replace820_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 16, 36 },
      -1,
   } },
   /* replace820_0_1_0 -> 16 in the cache */
   /* replace820_0_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot3,
      -1, 2,
      { 2414, 2415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2416 },
      -1,
   } },

   /* ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search821_0 -> 16 in the cache */
   /* search821_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace821_0_0_0 -> 16 in the cache */
   /* replace821_0_0_1 -> 36 in the cache */
   /* replace821_0_0 -> 2414 in the cache */
   /* replace821_0_1_0 -> 16 in the cache */
   /* replace821_0_1_1 -> 36 in the cache */
   /* replace821_0_1 -> 2415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot4,
      -1, 2,
      { 2414, 2415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2419 },
      -1,
   } },

   /* ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search822_0 -> 16 in the cache */
   /* search822_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal8,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace822_0_0_0 -> 16 in the cache */
   /* replace822_0_0_1 -> 36 in the cache */
   /* replace822_0_0 -> 2414 in the cache */
   /* replace822_0_1_0 -> 16 in the cache */
   /* replace822_0_1_1 -> 36 in the cache */
   /* replace822_0_1 -> 2415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot8,
      -1, 2,
      { 2414, 2415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2422 },
      -1,
   } },

   /* ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search823_0 -> 16 in the cache */
   /* search823_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal16,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace823_0_0_0 -> 16 in the cache */
   /* replace823_0_0_1 -> 36 in the cache */
   /* replace823_0_0 -> 2414 in the cache */
   /* replace823_0_1_0 -> 16 in the cache */
   /* replace823_0_1_1 -> 36 in the cache */
   /* replace823_0_1 -> 2415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot16,
      -1, 2,
      { 2414, 2415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2425 },
      -1,
   } },

   /* ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')) */
   /* search824_0 -> 0 in the cache */
   /* search824_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace824_0_0 -> 762 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace824_1_0 -> 763 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 763, 2430 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2429, 2431 },
      -1,
   } },

   /* ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z'))) */
   /* search825_0 -> 0 in the cache */
   /* search825_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace825_0_0 -> 762 in the cache */
   /* replace825_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace825_1_0_0 -> 763 in the cache */
   /* replace825_1_0_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 763, 2430 },
      -1,
   } },
   /* replace825_1_1_0 -> 764 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 764, 2436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2435, 2437 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2434, 2438 },
      -1,
   } },

   /* ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w'))) */
   /* search826_0 -> 0 in the cache */
   /* search826_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace826_0_0_0 -> 762 in the cache */
   /* replace826_0_0_1 -> 2428 in the cache */
   /* replace826_0_0 -> 2429 in the cache */
   /* replace826_0_1_0 -> 763 in the cache */
   /* replace826_0_1_1 -> 2430 in the cache */
   /* replace826_0_1 -> 2431 in the cache */
   /* replace826_0 -> 2432 in the cache */
   /* replace826_1_0_0 -> 764 in the cache */
   /* replace826_1_0_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 764, 2436 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 2442, 2443 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2441, 2444 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2432, 2445 },
      -1,
   } },

   /* ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))) */
   /* search827_0 -> 0 in the cache */
   /* search827_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal8,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace827_0_0_0_0 -> 762 in the cache */
   /* replace827_0_0_0_1 -> 2428 in the cache */
   /* replace827_0_0_0 -> 2429 in the cache */
   /* replace827_0_0_1_0 -> 763 in the cache */
   /* replace827_0_0_1_1 -> 2430 in the cache */
   /* replace827_0_0_1 -> 2431 in the cache */
   /* replace827_0_0 -> 2432 in the cache */
   /* replace827_0_1_0_0 -> 764 in the cache */
   /* replace827_0_1_0_1 -> 2436 in the cache */
   /* replace827_0_1_0 -> 2441 in the cache */
   /* replace827_0_1_1_0 -> 2442 in the cache */
   /* replace827_0_1_1_1 -> 2443 in the cache */
   /* replace827_0_1_1 -> 2444 in the cache */
   /* replace827_0_1 -> 2445 in the cache */
   /* replace827_0 -> 2446 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {4},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {4},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      4, 1,
      { 2448, 2449 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {5},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {5},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      5, 1,
      { 2451, 2452 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2450, 2453 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {6},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {6},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      6, 1,
      { 2455, 2456 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {7},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {7},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      7, 1,
      { 2458, 2459 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2457, 2460 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2454, 2461 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 8,
      { 2446, 2462 },
      -1,
   } },

   /* ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p'))))) */
   /* search828_0 -> 0 in the cache */
   /* search828_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal16,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace828_0_0_0_0_0 -> 762 in the cache */
   /* replace828_0_0_0_0_1 -> 2428 in the cache */
   /* replace828_0_0_0_0 -> 2429 in the cache */
   /* replace828_0_0_0_1_0 -> 763 in the cache */
   /* replace828_0_0_0_1_1 -> 2430 in the cache */
   /* replace828_0_0_0_1 -> 2431 in the cache */
   /* replace828_0_0_0 -> 2432 in the cache */
   /* replace828_0_0_1_0_0 -> 764 in the cache */
   /* replace828_0_0_1_0_1 -> 2436 in the cache */
   /* replace828_0_0_1_0 -> 2441 in the cache */
   /* replace828_0_0_1_1_0 -> 2442 in the cache */
   /* replace828_0_0_1_1_1 -> 2443 in the cache */
   /* replace828_0_0_1_1 -> 2444 in the cache */
   /* replace828_0_0_1 -> 2445 in the cache */
   /* replace828_0_0 -> 2446 in the cache */
   /* replace828_0_1_0_0_0 -> 2448 in the cache */
   /* replace828_0_1_0_0_1 -> 2449 in the cache */
   /* replace828_0_1_0_0 -> 2450 in the cache */
   /* replace828_0_1_0_1_0 -> 2451 in the cache */
   /* replace828_0_1_0_1_1 -> 2452 in the cache */
   /* replace828_0_1_0_1 -> 2453 in the cache */
   /* replace828_0_1_0 -> 2454 in the cache */
   /* replace828_0_1_1_0_0 -> 2455 in the cache */
   /* replace828_0_1_1_0_1 -> 2456 in the cache */
   /* replace828_0_1_1_0 -> 2457 in the cache */
   /* replace828_0_1_1_1_0 -> 2458 in the cache */
   /* replace828_0_1_1_1_1 -> 2459 in the cache */
   /* replace828_0_1_1_1 -> 2460 in the cache */
   /* replace828_0_1_1 -> 2461 in the cache */
   /* replace828_0_1 -> 2462 in the cache */
   /* replace828_0 -> 2463 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {8},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {8},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      8, 1,
      { 2465, 2466 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {9},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {9},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      9, 1,
      { 2468, 2469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2467, 2470 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {10},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {10},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      10, 1,
      { 2472, 2473 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {11},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {11},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      11, 1,
      { 2475, 2476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2474, 2477 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2471, 2478 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {12},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {12},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      12, 1,
      { 2480, 2481 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {13},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {13},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      13, 1,
      { 2483, 2484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2482, 2485 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {14},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {14},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      14, 1,
      { 2487, 2488 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      15, 1,
      { 2490, 2491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2489, 2492 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2486, 2493 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 8,
      { 2479, 2494 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 16,
      { 2463, 2495 },
      -1,
   } },

   /* ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')) */
   /* search829_0 -> 0 in the cache */
   /* search829_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace829_0_0 -> 762 in the cache */
   /* replace829_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace829_1_0 -> 763 in the cache */
   /* replace829_1_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 763, 2430 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2498, 2499 },
      -1,
   } },

   /* ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z'))) */
   /* search830_0 -> 0 in the cache */
   /* search830_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace830_0_0 -> 762 in the cache */
   /* replace830_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace830_1_0_0 -> 763 in the cache */
   /* replace830_1_0_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 763, 2430 },
      -1,
   } },
   /* replace830_1_1_0 -> 764 in the cache */
   /* replace830_1_1_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 764, 2436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2503, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2502, 2505 },
      -1,
   } },

   /* ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w'))) */
   /* search831_0 -> 0 in the cache */
   /* search831_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace831_0_0_0 -> 762 in the cache */
   /* replace831_0_0_1 -> 2428 in the cache */
   /* replace831_0_0 -> 2498 in the cache */
   /* replace831_0_1_0 -> 763 in the cache */
   /* replace831_0_1_1 -> 2430 in the cache */
   /* replace831_0_1 -> 2499 in the cache */
   /* replace831_0 -> 2500 in the cache */
   /* replace831_1_0_0 -> 764 in the cache */
   /* replace831_1_0_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 764, 2436 },
      -1,
   } },
   /* replace831_1_1_0 -> 2442 in the cache */
   /* replace831_1_1_1 -> 2443 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 2442, 2443 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2508, 2509 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2500, 2510 },
      -1,
   } },

   /* ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))) */
   /* search832_0 -> 0 in the cache */
   /* search832_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal8,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace832_0_0_0_0 -> 762 in the cache */
   /* replace832_0_0_0_1 -> 2428 in the cache */
   /* replace832_0_0_0 -> 2498 in the cache */
   /* replace832_0_0_1_0 -> 763 in the cache */
   /* replace832_0_0_1_1 -> 2430 in the cache */
   /* replace832_0_0_1 -> 2499 in the cache */
   /* replace832_0_0 -> 2500 in the cache */
   /* replace832_0_1_0_0 -> 764 in the cache */
   /* replace832_0_1_0_1 -> 2436 in the cache */
   /* replace832_0_1_0 -> 2508 in the cache */
   /* replace832_0_1_1_0 -> 2442 in the cache */
   /* replace832_0_1_1_1 -> 2443 in the cache */
   /* replace832_0_1_1 -> 2509 in the cache */
   /* replace832_0_1 -> 2510 in the cache */
   /* replace832_0 -> 2511 in the cache */
   /* replace832_1_0_0_0 -> 2448 in the cache */
   /* replace832_1_0_0_1 -> 2449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      4, 1,
      { 2448, 2449 },
      -1,
   } },
   /* replace832_1_0_1_0 -> 2451 in the cache */
   /* replace832_1_0_1_1 -> 2452 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      5, 1,
      { 2451, 2452 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2513, 2514 },
      -1,
   } },
   /* replace832_1_1_0_0 -> 2455 in the cache */
   /* replace832_1_1_0_1 -> 2456 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      6, 1,
      { 2455, 2456 },
      -1,
   } },
   /* replace832_1_1_1_0 -> 2458 in the cache */
   /* replace832_1_1_1_1 -> 2459 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      7, 1,
      { 2458, 2459 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2516, 2517 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2515, 2518 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 8,
      { 2511, 2519 },
      -1,
   } },

   /* ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p'))))) */
   /* search833_0 -> 0 in the cache */
   /* search833_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal16,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace833_0_0_0_0_0 -> 762 in the cache */
   /* replace833_0_0_0_0_1 -> 2428 in the cache */
   /* replace833_0_0_0_0 -> 2498 in the cache */
   /* replace833_0_0_0_1_0 -> 763 in the cache */
   /* replace833_0_0_0_1_1 -> 2430 in the cache */
   /* replace833_0_0_0_1 -> 2499 in the cache */
   /* replace833_0_0_0 -> 2500 in the cache */
   /* replace833_0_0_1_0_0 -> 764 in the cache */
   /* replace833_0_0_1_0_1 -> 2436 in the cache */
   /* replace833_0_0_1_0 -> 2508 in the cache */
   /* replace833_0_0_1_1_0 -> 2442 in the cache */
   /* replace833_0_0_1_1_1 -> 2443 in the cache */
   /* replace833_0_0_1_1 -> 2509 in the cache */
   /* replace833_0_0_1 -> 2510 in the cache */
   /* replace833_0_0 -> 2511 in the cache */
   /* replace833_0_1_0_0_0 -> 2448 in the cache */
   /* replace833_0_1_0_0_1 -> 2449 in the cache */
   /* replace833_0_1_0_0 -> 2513 in the cache */
   /* replace833_0_1_0_1_0 -> 2451 in the cache */
   /* replace833_0_1_0_1_1 -> 2452 in the cache */
   /* replace833_0_1_0_1 -> 2514 in the cache */
   /* replace833_0_1_0 -> 2515 in the cache */
   /* replace833_0_1_1_0_0 -> 2455 in the cache */
   /* replace833_0_1_1_0_1 -> 2456 in the cache */
   /* replace833_0_1_1_0 -> 2516 in the cache */
   /* replace833_0_1_1_1_0 -> 2458 in the cache */
   /* replace833_0_1_1_1_1 -> 2459 in the cache */
   /* replace833_0_1_1_1 -> 2517 in the cache */
   /* replace833_0_1_1 -> 2518 in the cache */
   /* replace833_0_1 -> 2519 in the cache */
   /* replace833_0 -> 2520 in the cache */
   /* replace833_1_0_0_0_0 -> 2465 in the cache */
   /* replace833_1_0_0_0_1 -> 2466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      8, 1,
      { 2465, 2466 },
      -1,
   } },
   /* replace833_1_0_0_1_0 -> 2468 in the cache */
   /* replace833_1_0_0_1_1 -> 2469 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      9, 1,
      { 2468, 2469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2522, 2523 },
      -1,
   } },
   /* replace833_1_0_1_0_0 -> 2472 in the cache */
   /* replace833_1_0_1_0_1 -> 2473 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      10, 1,
      { 2472, 2473 },
      -1,
   } },
   /* replace833_1_0_1_1_0 -> 2475 in the cache */
   /* replace833_1_0_1_1_1 -> 2476 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      11, 1,
      { 2475, 2476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2525, 2526 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2524, 2527 },
      -1,
   } },
   /* replace833_1_1_0_0_0 -> 2480 in the cache */
   /* replace833_1_1_0_0_1 -> 2481 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      12, 1,
      { 2480, 2481 },
      -1,
   } },
   /* replace833_1_1_0_1_0 -> 2483 in the cache */
   /* replace833_1_1_0_1_1 -> 2484 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      13, 1,
      { 2483, 2484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2529, 2530 },
      -1,
   } },
   /* replace833_1_1_1_0_0 -> 2487 in the cache */
   /* replace833_1_1_1_0_1 -> 2488 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      14, 1,
      { 2487, 2488 },
      -1,
   } },
   /* replace833_1_1_1_1_0 -> 2490 in the cache */
   /* replace833_1_1_1_1_1 -> 2491 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      15, 1,
      { 2490, 2491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2532, 2533 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2531, 2534 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 8,
      { 2528, 2535 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 16,
      { 2520, 2536 },
      -1,
   } },

   /* ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')) */
   /* search834_0 -> 0 in the cache */
   /* search834_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace834_0_0 -> 762 in the cache */
   /* replace834_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace834_1_0 -> 763 in the cache */
   /* replace834_1_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 763, 2430 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2539, 2540 },
      -1,
   } },

   /* ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z'))) */
   /* search835_0 -> 0 in the cache */
   /* search835_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace835_0_0 -> 762 in the cache */
   /* replace835_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace835_1_0_0 -> 763 in the cache */
   /* replace835_1_0_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 763, 2430 },
      -1,
   } },
   /* replace835_1_1_0 -> 764 in the cache */
   /* replace835_1_1_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 764, 2436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2544, 2545 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2543, 2546 },
      -1,
   } },

   /* ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w'))) */
   /* search836_0 -> 0 in the cache */
   /* search836_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace836_0_0_0 -> 762 in the cache */
   /* replace836_0_0_1 -> 2428 in the cache */
   /* replace836_0_0 -> 2539 in the cache */
   /* replace836_0_1_0 -> 763 in the cache */
   /* replace836_0_1_1 -> 2430 in the cache */
   /* replace836_0_1 -> 2540 in the cache */
   /* replace836_0 -> 2541 in the cache */
   /* replace836_1_0_0 -> 764 in the cache */
   /* replace836_1_0_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 764, 2436 },
      -1,
   } },
   /* replace836_1_1_0 -> 2442 in the cache */
   /* replace836_1_1_1 -> 2443 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 2442, 2443 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2549, 2550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2541, 2551 },
      -1,
   } },

   /* ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))) */
   /* search837_0 -> 0 in the cache */
   /* search837_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal8,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace837_0_0_0_0 -> 762 in the cache */
   /* replace837_0_0_0_1 -> 2428 in the cache */
   /* replace837_0_0_0 -> 2539 in the cache */
   /* replace837_0_0_1_0 -> 763 in the cache */
   /* replace837_0_0_1_1 -> 2430 in the cache */
   /* replace837_0_0_1 -> 2540 in the cache */
   /* replace837_0_0 -> 2541 in the cache */
   /* replace837_0_1_0_0 -> 764 in the cache */
   /* replace837_0_1_0_1 -> 2436 in the cache */
   /* replace837_0_1_0 -> 2549 in the cache */
   /* replace837_0_1_1_0 -> 2442 in the cache */
   /* replace837_0_1_1_1 -> 2443 in the cache */
   /* replace837_0_1_1 -> 2550 in the cache */
   /* replace837_0_1 -> 2551 in the cache */
   /* replace837_0 -> 2552 in the cache */
   /* replace837_1_0_0_0 -> 2448 in the cache */
   /* replace837_1_0_0_1 -> 2449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      4, 1,
      { 2448, 2449 },
      -1,
   } },
   /* replace837_1_0_1_0 -> 2451 in the cache */
   /* replace837_1_0_1_1 -> 2452 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      5, 1,
      { 2451, 2452 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2554, 2555 },
      -1,
   } },
   /* replace837_1_1_0_0 -> 2455 in the cache */
   /* replace837_1_1_0_1 -> 2456 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      6, 1,
      { 2455, 2456 },
      -1,
   } },
   /* replace837_1_1_1_0 -> 2458 in the cache */
   /* replace837_1_1_1_1 -> 2459 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      7, 1,
      { 2458, 2459 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2557, 2558 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2556, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 8,
      { 2552, 2560 },
      -1,
   } },

   /* ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p'))))) */
   /* search838_0 -> 0 in the cache */
   /* search838_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal16,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace838_0_0_0_0_0 -> 762 in the cache */
   /* replace838_0_0_0_0_1 -> 2428 in the cache */
   /* replace838_0_0_0_0 -> 2539 in the cache */
   /* replace838_0_0_0_1_0 -> 763 in the cache */
   /* replace838_0_0_0_1_1 -> 2430 in the cache */
   /* replace838_0_0_0_1 -> 2540 in the cache */
   /* replace838_0_0_0 -> 2541 in the cache */
   /* replace838_0_0_1_0_0 -> 764 in the cache */
   /* replace838_0_0_1_0_1 -> 2436 in the cache */
   /* replace838_0_0_1_0 -> 2549 in the cache */
   /* replace838_0_0_1_1_0 -> 2442 in the cache */
   /* replace838_0_0_1_1_1 -> 2443 in the cache */
   /* replace838_0_0_1_1 -> 2550 in the cache */
   /* replace838_0_0_1 -> 2551 in the cache */
   /* replace838_0_0 -> 2552 in the cache */
   /* replace838_0_1_0_0_0 -> 2448 in the cache */
   /* replace838_0_1_0_0_1 -> 2449 in the cache */
   /* replace838_0_1_0_0 -> 2554 in the cache */
   /* replace838_0_1_0_1_0 -> 2451 in the cache */
   /* replace838_0_1_0_1_1 -> 2452 in the cache */
   /* replace838_0_1_0_1 -> 2555 in the cache */
   /* replace838_0_1_0 -> 2556 in the cache */
   /* replace838_0_1_1_0_0 -> 2455 in the cache */
   /* replace838_0_1_1_0_1 -> 2456 in the cache */
   /* replace838_0_1_1_0 -> 2557 in the cache */
   /* replace838_0_1_1_1_0 -> 2458 in the cache */
   /* replace838_0_1_1_1_1 -> 2459 in the cache */
   /* replace838_0_1_1_1 -> 2558 in the cache */
   /* replace838_0_1_1 -> 2559 in the cache */
   /* replace838_0_1 -> 2560 in the cache */
   /* replace838_0 -> 2561 in the cache */
   /* replace838_1_0_0_0_0 -> 2465 in the cache */
   /* replace838_1_0_0_0_1 -> 2466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      8, 1,
      { 2465, 2466 },
      -1,
   } },
   /* replace838_1_0_0_1_0 -> 2468 in the cache */
   /* replace838_1_0_0_1_1 -> 2469 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      9, 1,
      { 2468, 2469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2563, 2564 },
      -1,
   } },
   /* replace838_1_0_1_0_0 -> 2472 in the cache */
   /* replace838_1_0_1_0_1 -> 2473 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      10, 1,
      { 2472, 2473 },
      -1,
   } },
   /* replace838_1_0_1_1_0 -> 2475 in the cache */
   /* replace838_1_0_1_1_1 -> 2476 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      11, 1,
      { 2475, 2476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2566, 2567 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2565, 2568 },
      -1,
   } },
   /* replace838_1_1_0_0_0 -> 2480 in the cache */
   /* replace838_1_1_0_0_1 -> 2481 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      12, 1,
      { 2480, 2481 },
      -1,
   } },
   /* replace838_1_1_0_1_0 -> 2483 in the cache */
   /* replace838_1_1_0_1_1 -> 2484 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      13, 1,
      { 2483, 2484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2570, 2571 },
      -1,
   } },
   /* replace838_1_1_1_0_0 -> 2487 in the cache */
   /* replace838_1_1_1_0_1 -> 2488 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      14, 1,
      { 2487, 2488 },
      -1,
   } },
   /* replace838_1_1_1_1_0 -> 2490 in the cache */
   /* replace838_1_1_1_1_1 -> 2491 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      15, 1,
      { 2490, 2491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2573, 2574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2572, 2575 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 8,
      { 2569, 2576 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 16,
      { 2561, 2577 },
      -1,
   } },

   /* ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')) */
   /* search839_0 -> 0 in the cache */
   /* search839_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace839_0_0 -> 762 in the cache */
   /* replace839_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace839_1_0 -> 763 in the cache */
   /* replace839_1_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 763, 2430 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2580, 2581 },
      -1,
   } },

   /* ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z'))) */
   /* search840_0 -> 0 in the cache */
   /* search840_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace840_0_0 -> 762 in the cache */
   /* replace840_0_1 -> 2428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 762, 2428 },
      -1,
   } },
   /* replace840_1_0_0 -> 763 in the cache */
   /* replace840_1_0_1 -> 2430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 763, 2430 },
      -1,
   } },
   /* replace840_1_1_0 -> 764 in the cache */
   /* replace840_1_1_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 764, 2436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2585, 2586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2584, 2587 },
      -1,
   } },

   /* ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w'))) */
   /* search841_0 -> 0 in the cache */
   /* search841_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace841_0_0_0 -> 762 in the cache */
   /* replace841_0_0_1 -> 2428 in the cache */
   /* replace841_0_0 -> 2580 in the cache */
   /* replace841_0_1_0 -> 763 in the cache */
   /* replace841_0_1_1 -> 2430 in the cache */
   /* replace841_0_1 -> 2581 in the cache */
   /* replace841_0 -> 2582 in the cache */
   /* replace841_1_0_0 -> 764 in the cache */
   /* replace841_1_0_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 764, 2436 },
      -1,
   } },
   /* replace841_1_1_0 -> 2442 in the cache */
   /* replace841_1_1_1 -> 2443 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 2442, 2443 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2590, 2591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2582, 2592 },
      -1,
   } },

   /* ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))) */
   /* search842_0 -> 0 in the cache */
   /* search842_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal8,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace842_0_0_0_0 -> 762 in the cache */
   /* replace842_0_0_0_1 -> 2428 in the cache */
   /* replace842_0_0_0 -> 2580 in the cache */
   /* replace842_0_0_1_0 -> 763 in the cache */
   /* replace842_0_0_1_1 -> 2430 in the cache */
   /* replace842_0_0_1 -> 2581 in the cache */
   /* replace842_0_0 -> 2582 in the cache */
   /* replace842_0_1_0_0 -> 764 in the cache */
   /* replace842_0_1_0_1 -> 2436 in the cache */
   /* replace842_0_1_0 -> 2590 in the cache */
   /* replace842_0_1_1_0 -> 2442 in the cache */
   /* replace842_0_1_1_1 -> 2443 in the cache */
   /* replace842_0_1_1 -> 2591 in the cache */
   /* replace842_0_1 -> 2592 in the cache */
   /* replace842_0 -> 2593 in the cache */
   /* replace842_1_0_0_0 -> 2448 in the cache */
   /* replace842_1_0_0_1 -> 2449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      4, 1,
      { 2448, 2449 },
      -1,
   } },
   /* replace842_1_0_1_0 -> 2451 in the cache */
   /* replace842_1_0_1_1 -> 2452 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      5, 1,
      { 2451, 2452 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2595, 2596 },
      -1,
   } },
   /* replace842_1_1_0_0 -> 2455 in the cache */
   /* replace842_1_1_0_1 -> 2456 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      6, 1,
      { 2455, 2456 },
      -1,
   } },
   /* replace842_1_1_1_0 -> 2458 in the cache */
   /* replace842_1_1_1_1 -> 2459 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      7, 1,
      { 2458, 2459 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2598, 2599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2597, 2600 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 8,
      { 2593, 2601 },
      -1,
   } },

   /* ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p'))))) */
   /* search843_0 -> 0 in the cache */
   /* search843_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal16,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace843_0_0_0_0_0 -> 762 in the cache */
   /* replace843_0_0_0_0_1 -> 2428 in the cache */
   /* replace843_0_0_0_0 -> 2580 in the cache */
   /* replace843_0_0_0_1_0 -> 763 in the cache */
   /* replace843_0_0_0_1_1 -> 2430 in the cache */
   /* replace843_0_0_0_1 -> 2581 in the cache */
   /* replace843_0_0_0 -> 2582 in the cache */
   /* replace843_0_0_1_0_0 -> 764 in the cache */
   /* replace843_0_0_1_0_1 -> 2436 in the cache */
   /* replace843_0_0_1_0 -> 2590 in the cache */
   /* replace843_0_0_1_1_0 -> 2442 in the cache */
   /* replace843_0_0_1_1_1 -> 2443 in the cache */
   /* replace843_0_0_1_1 -> 2591 in the cache */
   /* replace843_0_0_1 -> 2592 in the cache */
   /* replace843_0_0 -> 2593 in the cache */
   /* replace843_0_1_0_0_0 -> 2448 in the cache */
   /* replace843_0_1_0_0_1 -> 2449 in the cache */
   /* replace843_0_1_0_0 -> 2595 in the cache */
   /* replace843_0_1_0_1_0 -> 2451 in the cache */
   /* replace843_0_1_0_1_1 -> 2452 in the cache */
   /* replace843_0_1_0_1 -> 2596 in the cache */
   /* replace843_0_1_0 -> 2597 in the cache */
   /* replace843_0_1_1_0_0 -> 2455 in the cache */
   /* replace843_0_1_1_0_1 -> 2456 in the cache */
   /* replace843_0_1_1_0 -> 2598 in the cache */
   /* replace843_0_1_1_1_0 -> 2458 in the cache */
   /* replace843_0_1_1_1_1 -> 2459 in the cache */
   /* replace843_0_1_1_1 -> 2599 in the cache */
   /* replace843_0_1_1 -> 2600 in the cache */
   /* replace843_0_1 -> 2601 in the cache */
   /* replace843_0 -> 2602 in the cache */
   /* replace843_1_0_0_0_0 -> 2465 in the cache */
   /* replace843_1_0_0_0_1 -> 2466 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      8, 1,
      { 2465, 2466 },
      -1,
   } },
   /* replace843_1_0_0_1_0 -> 2468 in the cache */
   /* replace843_1_0_0_1_1 -> 2469 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      9, 1,
      { 2468, 2469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2604, 2605 },
      -1,
   } },
   /* replace843_1_0_1_0_0 -> 2472 in the cache */
   /* replace843_1_0_1_0_1 -> 2473 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      10, 1,
      { 2472, 2473 },
      -1,
   } },
   /* replace843_1_0_1_1_0 -> 2475 in the cache */
   /* replace843_1_0_1_1_1 -> 2476 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      11, 1,
      { 2475, 2476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2607, 2608 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2606, 2609 },
      -1,
   } },
   /* replace843_1_1_0_0_0 -> 2480 in the cache */
   /* replace843_1_1_0_0_1 -> 2481 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      12, 1,
      { 2480, 2481 },
      -1,
   } },
   /* replace843_1_1_0_1_0 -> 2483 in the cache */
   /* replace843_1_1_0_1_1 -> 2484 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      13, 1,
      { 2483, 2484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2611, 2612 },
      -1,
   } },
   /* replace843_1_1_1_0_0 -> 2487 in the cache */
   /* replace843_1_1_1_0_1 -> 2488 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      14, 1,
      { 2487, 2488 },
      -1,
   } },
   /* replace843_1_1_1_1_0 -> 2490 in the cache */
   /* replace843_1_1_1_1_1 -> 2491 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      15, 1,
      { 2490, 2491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2614, 2615 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2613, 2616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 8,
      { 2610, 2617 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 16,
      { 2602, 2618 },
      -1,
   } },

   /* ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b') */
   /* search844_0_0 -> 0 in the cache */
   /* search844_0_1 -> 3 in the cache */
   /* search844_0 -> 2371 in the cache */
   /* search844_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2371, 272 },
      -1,
   } },

   /* replace844_0 -> 0 in the cache */
   /* replace844_1 -> 3 in the cache */
   /* replace844 -> 1048 in the cache */

   /* ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b') */
   /* search845_0_0 -> 0 in the cache */
   /* search845_0_1 -> 3 in the cache */
   /* search845_0 -> 2373 in the cache */
   /* search845_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2373, 272 },
      -1,
   } },

   /* replace845_0 -> 0 in the cache */
   /* replace845_1 -> 3 in the cache */
   /* replace845 -> 1045 in the cache */

   /* ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b') */
   /* search846_0_0 -> 0 in the cache */
   /* search846_0_1 -> 3 in the cache */
   /* search846_0 -> 2359 in the cache */
   /* search846_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2359, 272 },
      -1,
   } },

   /* replace846_0 -> 0 in the cache */
   /* replace846_1 -> 3 in the cache */
   /* replace846 -> 1042 in the cache */

   /* ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b') */
   /* search847_0_0 -> 0 in the cache */
   /* search847_0_1 -> 3 in the cache */
   /* search847_0 -> 2361 in the cache */
   /* search847_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2361, 272 },
      -1,
   } },

   /* replace847_0 -> 0 in the cache */
   /* replace847_1 -> 3 in the cache */
   /* replace847 -> 1039 in the cache */

   /* ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b') */
   /* search848_0_0 -> 0 in the cache */
   /* search848_0_1 -> 3 in the cache */
   /* search848_0 -> 2371 in the cache */
   /* search848_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2371, 258 },
      -1,
   } },

   /* replace848_0 -> 0 in the cache */
   /* replace848_1 -> 3 in the cache */
   /* replace848 -> 1048 in the cache */

   /* ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b') */
   /* search849_0_0 -> 0 in the cache */
   /* search849_0_1 -> 3 in the cache */
   /* search849_0 -> 2373 in the cache */
   /* search849_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2373, 258 },
      -1,
   } },

   /* replace849_0 -> 0 in the cache */
   /* replace849_1 -> 3 in the cache */
   /* replace849 -> 1045 in the cache */

   /* ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b') */
   /* search850_0_0 -> 0 in the cache */
   /* search850_0_1 -> 3 in the cache */
   /* search850_0 -> 2359 in the cache */
   /* search850_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2359, 258 },
      -1,
   } },

   /* replace850_0 -> 0 in the cache */
   /* replace850_1 -> 3 in the cache */
   /* replace850 -> 1042 in the cache */

   /* ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b') */
   /* search851_0_0 -> 0 in the cache */
   /* search851_0_1 -> 3 in the cache */
   /* search851_0 -> 2361 in the cache */
   /* search851_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2361, 258 },
      -1,
   } },

   /* replace851_0 -> 0 in the cache */
   /* replace851_1 -> 3 in the cache */
   /* replace851 -> 1039 in the cache */

   /* ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b') */
   /* search852_0_0 -> 0 in the cache */
   /* search852_0_1 -> 3 in the cache */
   /* search852_0 -> 2371 in the cache */
   /* search852_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2371, 258 },
      -1,
   } },

   /* replace852_0 -> 0 in the cache */
   /* replace852_1 -> 3 in the cache */
   /* replace852 -> 1045 in the cache */

   /* ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b') */
   /* search853_0_0 -> 0 in the cache */
   /* search853_0_1 -> 3 in the cache */
   /* search853_0 -> 2373 in the cache */
   /* search853_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2373, 258 },
      -1,
   } },

   /* replace853_0 -> 0 in the cache */
   /* replace853_1 -> 3 in the cache */
   /* replace853 -> 1048 in the cache */

   /* ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b') */
   /* search854_0_0 -> 0 in the cache */
   /* search854_0_1 -> 3 in the cache */
   /* search854_0 -> 2359 in the cache */
   /* search854_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2359, 258 },
      -1,
   } },

   /* replace854_0 -> 0 in the cache */
   /* replace854_1 -> 3 in the cache */
   /* replace854 -> 1039 in the cache */

   /* ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b') */
   /* search855_0_0 -> 0 in the cache */
   /* search855_0_1 -> 3 in the cache */
   /* search855_0 -> 2361 in the cache */
   /* search855_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2361, 258 },
      -1,
   } },

   /* replace855_0 -> 0 in the cache */
   /* replace855_1 -> 3 in the cache */
   /* replace855 -> 1042 in the cache */

   /* ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b') */
   /* search856_0_0 -> 0 in the cache */
   /* search856_0_1 -> 3 in the cache */
   /* search856_0 -> 2371 in the cache */
   /* search856_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2371, 272 },
      -1,
   } },

   /* replace856_0 -> 0 in the cache */
   /* replace856_1 -> 3 in the cache */
   /* replace856 -> 1045 in the cache */

   /* ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b') */
   /* search857_0_0 -> 0 in the cache */
   /* search857_0_1 -> 3 in the cache */
   /* search857_0 -> 2373 in the cache */
   /* search857_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2373, 272 },
      -1,
   } },

   /* replace857_0 -> 0 in the cache */
   /* replace857_1 -> 3 in the cache */
   /* replace857 -> 1048 in the cache */

   /* ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b') */
   /* search858_0_0 -> 0 in the cache */
   /* search858_0_1 -> 3 in the cache */
   /* search858_0 -> 2359 in the cache */
   /* search858_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2359, 272 },
      -1,
   } },

   /* replace858_0 -> 0 in the cache */
   /* replace858_1 -> 3 in the cache */
   /* replace858 -> 1039 in the cache */

   /* ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b') */
   /* search859_0_0 -> 0 in the cache */
   /* search859_0_1 -> 3 in the cache */
   /* search859_0 -> 2361 in the cache */
   /* search859_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2361, 272 },
      -1,
   } },

   /* replace859_0 -> 0 in the cache */
   /* replace859_1 -> 3 in the cache */
   /* replace859 -> 1042 in the cache */

   /* ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0) */
   /* search860_0_0 -> 32 in the cache */
   /* search860_0 -> 98 in the cache */
   /* search860_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace860_0 -> 32 in the cache */
   /* replace860_1 -> 113 in the cache */
   /* replace860 -> 1242 in the cache */

   /* ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0) */
   /* search861_0_0 -> 32 in the cache */
   /* search861_0 -> 98 in the cache */
   /* search861_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace861_0 -> 32 in the cache */
   /* replace861_1 -> 113 in the cache */
   /* replace861 -> 1246 in the cache */

   /* ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search862_0_0 -> 753 in the cache */
   /* search862_0 -> 1215 in the cache */
   /* search862_1_0 -> 1121 in the cache */
   /* search862_1 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 1215, 2238 },
      -1,
   } },

   /* replace862_0_0 -> 753 in the cache */
   /* replace862_0_1 -> 1121 in the cache */
   /* replace862_0 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1133 },
      -1,
   } },

   /* ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search863_0_0 -> 753 in the cache */
   /* search863_0 -> 1215 in the cache */
   /* search863_1_0 -> 1121 in the cache */
   /* search863_1 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1215, 2238 },
      -1,
   } },

   /* replace863_0_0 -> 753 in the cache */
   /* replace863_0_1 -> 1121 in the cache */
   /* replace863_0 -> 1133 in the cache */
   /* replace863 -> 2639 in the cache */

   /* ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b')) */
   /* search864_0_0 -> 753 in the cache */
   /* search864_0 -> 1215 in the cache */
   /* search864_1_0 -> 1121 in the cache */
   /* search864_1 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1215, 2238 },
      -1,
   } },

   /* replace864_0_0 -> 753 in the cache */
   /* replace864_0_1 -> 1121 in the cache */
   /* replace864_0 -> 1125 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1125 },
      -1,
   } },

   /* ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search865_0_0 -> 753 in the cache */
   /* search865_0 -> 1116 in the cache */
   /* search865_1_0 -> 1121 in the cache */
   /* search865_1 -> 1122 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1116, 1122 },
      -1,
   } },

   /* replace865_0_0 -> 753 in the cache */
   /* replace865_0_1 -> 1121 in the cache */
   /* replace865_0 -> 1133 in the cache */
   /* replace865 -> 1255 in the cache */

   /* ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b')) */
   /* search866_0_0_0 -> 753 in the cache */
   /* search866_0_0 -> 1116 in the cache */
   /* search866_0_1_0 -> 1121 in the cache */
   /* search866_0_1 -> 1122 in the cache */
   /* search866_0 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1152 },
      -1,
   } },

   /* replace866_0_0 -> 753 in the cache */
   /* replace866_0_1 -> 1121 in the cache */
   /* replace866_0 -> 1125 in the cache */
   /* replace866 -> 1252 in the cache */

   /* ('iand', 'a@bool16', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search867_1 -> 483 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2645, 483 },
      -1,
   } },

   /* replace867_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iand', 'a@bool32', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search868_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2648, 245 },
      -1,
   } },

   /* replace868_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('flt', ('fneg', ('b2f', 'a@1')), 0) => a */
   /* search869_0_0_0 -> 753 in the cache */
   /* search869_0_0 -> 1116 in the cache */
   /* search869_0 -> 1119 in the cache */
   /* search869_1 -> 1216 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1119, 1216 },
      -1,
   } },

   /* replace869 -> 753 in the cache */

   /* ('ilt', 'a', 'a') => False */
   /* search870_0 -> 32 in the cache */
   /* search870_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace870 -> 1070 in the cache */

   /* ('ige', 'a', 'a') => True */
   /* search871_0 -> 32 in the cache */
   /* search871_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace871 -> 1224 in the cache */

   /* ('ieq', 'a', 'a') => True */
   /* search872_0 -> 32 in the cache */
   /* search872_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace872 -> 1224 in the cache */

   /* ('ine', 'a', 'a') => False */
   /* search873_0 -> 32 in the cache */
   /* search873_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace873 -> 1070 in the cache */

   /* ('ult', 'a', 'a') => False */
   /* search874_0 -> 32 in the cache */
   /* search874_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace874 -> 1070 in the cache */

   /* ('uge', 'a', 'a') => True */
   /* search875_0 -> 32 in the cache */
   /* search875_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace875 -> 1224 in the cache */

   /* ('flt', 'a', 'a') => False */
   /* search876_0 -> 32 in the cache */
   /* search876_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace876 -> 1070 in the cache */

   /* ('fge', 'a(is_a_number)', 'a') => True */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search877_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 2659, 32 },
      -1,
   } },

   /* replace877 -> 1224 in the cache */

   /* ('feq', 'a(is_a_number)', 'a') => True */
   /* search878_0 -> 2659 in the cache */
   /* search878_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 2659, 32 },
      -1,
   } },

   /* replace878 -> 1224 in the cache */

   /* ('fneu', 'a(is_a_number)', 'a') => False */
   /* search879_0 -> 2659 in the cache */
   /* search879_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 2659, 32 },
      -1,
   } },

   /* replace879 -> 1070 in the cache */

   /* ('iand', 'a', 'a') => a */
   /* search880_0 -> 32 in the cache */
   /* search880_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace880 -> 32 in the cache */

   /* ('iand', 'a', 0) => 0 */
   /* search881_0 -> 32 in the cache */
   /* search881_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace881 -> 61 in the cache */

   /* ('iand', 'a', -1) => a */
   /* search882_0 -> 32 in the cache */
   /* search882_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace882 -> 32 in the cache */

   /* ('iand', 'a', ('inot', 'a')) => 0 */
   /* search883_0 -> 32 in the cache */
   /* search883_1_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 2666 },
      -1,
   } },

   /* replace883 -> 61 in the cache */

   /* ('ior', 'a', 'a') => a */
   /* search884_0 -> 32 in the cache */
   /* search884_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace884 -> 32 in the cache */

   /* ('ior', 'a', 0) => a */
   /* search885_0 -> 32 in the cache */
   /* search885_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace885 -> 32 in the cache */

   /* ('ior', 'a', -1) => -1 */
   /* search886_0 -> 32 in the cache */
   /* search886_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace886 -> 63 in the cache */

   /* ('ior', 'a', ('inot', 'a')) => -1 */
   /* search887_0 -> 32 in the cache */
   /* search887_1_0 -> 32 in the cache */
   /* search887_1 -> 2666 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 2666 },
      -1,
   } },

   /* replace887 -> 63 in the cache */

   /* ('ixor', 'a', 'a') => 0 */
   /* search888_0 -> 32 in the cache */
   /* search888_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace888 -> 61 in the cache */

   /* ('ixor', 'a', 0) => a */
   /* search889_0 -> 32 in the cache */
   /* search889_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace889 -> 32 in the cache */

   /* ('ixor', 'a', ('ixor', 'a', 'b')) => b */
   /* search890_0 -> 0 in the cache */
   /* search890_1_0 -> 0 in the cache */
   /* search890_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 2,
      { 0, 2674 },
      -1,
   } },

   /* replace890 -> 3 in the cache */

   /* ('ixor', 'a', -1) => ('inot', 'a') */
   /* search891_0 -> 32 in the cache */
   /* search891_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace891_0 -> 32 in the cache */
   /* replace891 -> 2666 in the cache */

   /* ('inot', ('inot', 'a')) => a */
   /* search892_0_0 -> 32 in the cache */
   /* search892_0 -> 2666 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 2666 },
      -1,
   } },

   /* replace892 -> 32 in the cache */

   /* ('ior', ('iand', 'a', 'b'), 'b') => b */
   /* search893_0_0 -> 0 in the cache */
   /* search893_0_1 -> 3 in the cache */
   /* search893_0 -> 203 in the cache */
   /* search893_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 203, 3 },
      -1,
   } },

   /* replace893 -> 3 in the cache */

   /* ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b') */
   /* search894_0_0 -> 0 in the cache */
   /* search894_0_1 -> 3 in the cache */
   /* search894_0 -> 84 in the cache */
   /* search894_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace894_0 -> 0 in the cache */
   /* replace894_1 -> 3 in the cache */
   /* replace894 -> 2301 in the cache */

   /* ('iand', ('ior', 'a', 'b'), 'b') => b */
   /* search895_0_0 -> 0 in the cache */
   /* search895_0_1 -> 3 in the cache */
   /* search895_0 -> 84 in the cache */
   /* search895_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace895 -> 3 in the cache */

   /* ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b') */
   /* search896_0_0 -> 0 in the cache */
   /* search896_0_1 -> 3 in the cache */
   /* search896_0 -> 203 in the cache */
   /* search896_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 203, 3 },
      -1,
   } },

   /* replace896_0 -> 0 in the cache */
   /* replace896_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b')) */
   /* search897_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search897_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2683, 2684 },
      -1,
   } },

   /* replace897_0_0 -> 0 in the cache */
   /* replace897_0_1 -> 3 in the cache */
   /* replace897_0 -> 2301 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2301 },
      -1,
   } },

   /* ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b')) */
   /* search898_0_0 -> 0 in the cache */
   /* search898_0 -> 2683 in the cache */
   /* search898_1_0 -> 3 in the cache */
   /* search898_1 -> 2684 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2683, 2684 },
      -1,
   } },

   /* replace898_0_0 -> 0 in the cache */
   /* replace898_0_1 -> 3 in the cache */
   /* replace898_0 -> 2682 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2682 },
      -1,
   } },

   /* ('ishl', 0, 'a') => 0 */
   /* search899_0 -> 1216 in the cache */
   /* search899_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1216, 16 },
      -1,
   } },

   /* replace899 -> 1216 in the cache */

   /* ('ishl', 'a', 0) => a */
   /* search900_0 -> 32 in the cache */
   /* search900_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 124 },
      -1,
   } },

   /* replace900 -> 32 in the cache */

   /* ('ishr', 0, 'a') => 0 */
   /* search901_0 -> 1216 in the cache */
   /* search901_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1216, 16 },
      -1,
   } },

   /* replace901 -> 1216 in the cache */

   /* ('ishr', -1, 'a') => -1 */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   /* search902_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 2692, 16 },
      -1,
   } },

   /* replace902 -> 2692 in the cache */

   /* ('ishr', 'a', 0) => a */
   /* search903_0 -> 32 in the cache */
   /* search903_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 124 },
      -1,
   } },

   /* replace903 -> 32 in the cache */

   /* ('ushr', 0, 'a') => 0 */
   /* search904_0 -> 1216 in the cache */
   /* search904_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1216, 16 },
      -1,
   } },

   /* replace904 -> 1216 in the cache */

   /* ('ushr', 'a', 0) => a */
   /* search905_0 -> 32 in the cache */
   /* search905_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 32, 124 },
      -1,
   } },

   /* replace905 -> 32 in the cache */

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search906_0_0 -> 11 in the cache */
   /* search906_0_1 -> 36 in the cache */
   /* search906_0 -> 2153 in the cache */
   /* search906_1_0 -> 11 in the cache */
   /* search906_1_1_0 -> 846 in the cache */
   /* search906_1_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 846, 2697 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2698 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2153, 2699 },
      -1,
   } },

   /* replace906_0 -> 11 in the cache */
   /* replace906_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b') */
   /* search907_0_0 -> 11 in the cache */
   /* search907_0_1 -> 36 in the cache */
   /* search907_0 -> 2153 in the cache */
   /* search907_1_0 -> 11 in the cache */
   /* search907_1_1_0 -> 846 in the cache */
   /* search907_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 846, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2153, 2703 },
      -1,
   } },

   /* replace907_0 -> 11 in the cache */
   /* replace907_1 -> 36 in the cache */
   /* replace907 -> 2701 in the cache */

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search908_0_0 -> 16 in the cache */
   /* search908_0_1 -> 36 in the cache */
   /* search908_0 -> 939 in the cache */
   /* search908_1_0 -> 16 in the cache */
   /* search908_1_1_0 -> 867 in the cache */
   /* search908_1_1_1_0 -> 36 in the cache */
   /* search908_1_1_1 -> 2697 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 867, 2697 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2705 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 939, 2706 },
      -1,
   } },

   /* replace908_0 -> 16 in the cache */
   /* replace908_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b') */
   /* search909_0_0 -> 16 in the cache */
   /* search909_0_1 -> 36 in the cache */
   /* search909_0 -> 939 in the cache */
   /* search909_1_0 -> 16 in the cache */
   /* search909_1_1_0 -> 867 in the cache */
   /* search909_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 867, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 939, 2710 },
      -1,
   } },

   /* replace909_0 -> 16 in the cache */
   /* replace909_1 -> 36 in the cache */
   /* replace909 -> 2708 in the cache */

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search910_0_0 -> 11 in the cache */
   /* search910_0_1 -> 36 in the cache */
   /* search910_0 -> 2157 in the cache */
   /* search910_1_0 -> 11 in the cache */
   /* search910_1_1_0 -> 846 in the cache */
   /* search910_1_1_1_0 -> 36 in the cache */
   /* search910_1_1_1 -> 2697 in the cache */
   /* search910_1_1 -> 2698 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2698 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2157, 2712 },
      -1,
   } },

   /* replace910_0 -> 11 in the cache */
   /* replace910_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b') */
   /* search911_0_0 -> 11 in the cache */
   /* search911_0_1 -> 36 in the cache */
   /* search911_0 -> 2157 in the cache */
   /* search911_1_0 -> 11 in the cache */
   /* search911_1_1_0 -> 846 in the cache */
   /* search911_1_1_1 -> 36 in the cache */
   /* search911_1_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2157, 2715 },
      -1,
   } },

   /* replace911_0 -> 11 in the cache */
   /* replace911_1 -> 36 in the cache */
   /* replace911 -> 2714 in the cache */

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search912_0_0 -> 16 in the cache */
   /* search912_0_1 -> 36 in the cache */
   /* search912_0 -> 2186 in the cache */
   /* search912_1_0 -> 16 in the cache */
   /* search912_1_1_0 -> 867 in the cache */
   /* search912_1_1_1_0 -> 36 in the cache */
   /* search912_1_1_1 -> 2697 in the cache */
   /* search912_1_1 -> 2705 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2705 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2186, 2717 },
      -1,
   } },

   /* replace912_0 -> 16 in the cache */
   /* replace912_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b') */
   /* search913_0_0 -> 16 in the cache */
   /* search913_0_1 -> 36 in the cache */
   /* search913_0 -> 2186 in the cache */
   /* search913_1_0 -> 16 in the cache */
   /* search913_1_1_0 -> 867 in the cache */
   /* search913_1_1_1 -> 36 in the cache */
   /* search913_1_1 -> 2709 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 2709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2186, 2720 },
      -1,
   } },

   /* replace913_0 -> 16 in the cache */
   /* replace913_1 -> 36 in the cache */
   /* replace913 -> 2719 in the cache */

   /* ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b'))) */
   /* search914_0 -> 6 in the cache */
   /* search914_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* replace914_0_0 -> 6 in the cache */
   /* replace914_0_1 -> 36 in the cache */
   /* replace914_0 -> 2122 in the cache */
   /* replace914_1_0 -> 6 in the cache */
   /* replace914_1_1_0 -> 824 in the cache */
   /* replace914_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 824, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 2723 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2122, 2724 },
      -1,
   } },

   /* ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b'))) */
   /* search915_0 -> 11 in the cache */
   /* search915_1 -> 36 in the cache */
   /* search915 -> 2701 in the cache */

   /* replace915_0_0 -> 11 in the cache */
   /* replace915_0_1 -> 36 in the cache */
   /* replace915_0 -> 2153 in the cache */
   /* replace915_1_0 -> 11 in the cache */
   /* replace915_1_1_0 -> 846 in the cache */
   /* replace915_1_1_1 -> 36 in the cache */
   /* replace915_1_1 -> 2702 in the cache */
   /* replace915_1 -> 2703 in the cache */
   /* replace915 -> 2704 in the cache */

   /* ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b'))) */
   /* search916_0 -> 16 in the cache */
   /* search916_1 -> 36 in the cache */
   /* search916 -> 2708 in the cache */

   /* replace916_0_0 -> 16 in the cache */
   /* replace916_0_1 -> 36 in the cache */
   /* replace916_0 -> 939 in the cache */
   /* replace916_1_0 -> 16 in the cache */
   /* replace916_1_1_0 -> 867 in the cache */
   /* replace916_1_1_1 -> 36 in the cache */
   /* replace916_1_1 -> 2709 in the cache */
   /* replace916_1 -> 2710 in the cache */
   /* replace916 -> 2711 in the cache */

   /* ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b'))) */
   /* search917_0 -> 21 in the cache */
   /* search917_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* replace917_0_0 -> 21 in the cache */
   /* replace917_0_1 -> 36 in the cache */
   /* replace917_0 -> 2213 in the cache */
   /* replace917_1_0 -> 21 in the cache */
   /* replace917_1_1_0 -> 887 in the cache */
   /* replace917_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 887, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 2727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2213, 2728 },
      -1,
   } },

   /* ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b'))) */
   /* search918_0 -> 6 in the cache */
   /* search918_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* replace918_0_0 -> 6 in the cache */
   /* replace918_0_1 -> 36 in the cache */
   /* replace918_0 -> 2126 in the cache */
   /* replace918_1_0 -> 6 in the cache */
   /* replace918_1_1_0 -> 824 in the cache */
   /* replace918_1_1_1 -> 36 in the cache */
   /* replace918_1_1 -> 2723 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 2723 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2126, 2731 },
      -1,
   } },

   /* ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b'))) */
   /* search919_0 -> 11 in the cache */
   /* search919_1 -> 36 in the cache */
   /* search919 -> 2714 in the cache */

   /* replace919_0_0 -> 11 in the cache */
   /* replace919_0_1 -> 36 in the cache */
   /* replace919_0 -> 2157 in the cache */
   /* replace919_1_0 -> 11 in the cache */
   /* replace919_1_1_0 -> 846 in the cache */
   /* replace919_1_1_1 -> 36 in the cache */
   /* replace919_1_1 -> 2702 in the cache */
   /* replace919_1 -> 2715 in the cache */
   /* replace919 -> 2716 in the cache */

   /* ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b'))) */
   /* search920_0 -> 16 in the cache */
   /* search920_1 -> 36 in the cache */
   /* search920 -> 2719 in the cache */

   /* replace920_0_0 -> 16 in the cache */
   /* replace920_0_1 -> 36 in the cache */
   /* replace920_0 -> 2186 in the cache */
   /* replace920_1_0 -> 16 in the cache */
   /* replace920_1_1_0 -> 867 in the cache */
   /* replace920_1_1_1 -> 36 in the cache */
   /* replace920_1_1 -> 2709 in the cache */
   /* replace920_1 -> 2720 in the cache */
   /* replace920 -> 2721 in the cache */

   /* ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b'))) */
   /* search921_0 -> 21 in the cache */
   /* search921_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* replace921_0_0 -> 21 in the cache */
   /* replace921_0_1 -> 36 in the cache */
   /* replace921_0 -> 2217 in the cache */
   /* replace921_1_0 -> 21 in the cache */
   /* replace921_1_1_0 -> 887 in the cache */
   /* replace921_1_1_1 -> 36 in the cache */
   /* replace921_1_1 -> 2727 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 2727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2217, 2734 },
      -1,
   } },

   /* ('~fexp2', ('flog2', 'a')) => a */
   /* search922_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 2736 },
      -1,
   } },

   /* replace922 -> 32 in the cache */

   /* ('~flog2', ('fexp2', 'a')) => a */
   /* search923_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2738 },
      -1,
   } },

   /* replace923 -> 32 in the cache */

   /* ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b')) */
   /* search924_0 -> 0 in the cache */
   /* search924_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace924_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace924_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2741, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2742 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b') */
   /* search925_0_0_0 -> 0 in the cache */
   /* search925_0_0 -> 2741 in the cache */
   /* search925_0_1 -> 3 in the cache */
   /* search925_0 -> 2742 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2742 },
      -1,
   } },

   /* replace925_0 -> 0 in the cache */
   /* replace925_1 -> 3 in the cache */
   /* replace925 -> 2740 in the cache */

   /* ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd')) */
   /* search926_0_0_0_0 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 151 },
      -1,
   } },
   /* search926_0_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 2745, 152 },
      -1,
   } },
   /* search926_0_1_0_0 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 154 },
      -1,
   } },
   /* search926_0_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 2747, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 2746, 2748 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 3,
      { 2749 },
      -1,
   } },

   /* replace926_0_0 -> 151 in the cache */
   /* replace926_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 151, 152 },
      -1,
   } },
   /* replace926_1_0 -> 154 in the cache */
   /* replace926_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 154, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2751, 2752 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a') */
   /* search927_0_0_0 -> 32 in the cache */
   /* search927_0_0 -> 2736 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2736, 2754 },
      -1,
   } },
   { .expression 