# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=s390x-linux-gnu -mcpu=z14 -timeline -timeline-max-iterations=3 < %s | FileCheck %s

stmg	%r6, %r15, 48(%r15)
lmg	%r6, %r15, 48(%r15)

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      1004
# CHECK-NEXT: Total uOps:        600

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    0.60
# CHECK-NEXT: IPC:               0.20
# CHECK-NEXT: Block RThroughput: 3.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  3      1     1.50           *            stmg	%r6, %r15, 48(%r15)
# CHECK-NEXT:  3      10    2.50    *                   lmg	%r6, %r15, 48(%r15)

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - Z14_FXaUnit
# CHECK-NEXT: [0.1] - Z14_FXaUnit
# CHECK-NEXT: [1.0] - Z14_FXbUnit
# CHECK-NEXT: [1.1] - Z14_FXbUnit
# CHECK-NEXT: [2.0] - Z14_LSUnit
# CHECK-NEXT: [2.1] - Z14_LSUnit
# CHECK-NEXT: [3]   - Z14_MCD
# CHECK-NEXT: [4.0] - Z14_VBUnit
# CHECK-NEXT: [4.1] - Z14_VBUnit
# CHECK-NEXT: [5.0] - Z14_VecFPdUnit
# CHECK-NEXT: [5.1] - Z14_VecFPdUnit
# CHECK-NEXT: [6.0] - Z14_VecUnit
# CHECK-NEXT: [6.1] - Z14_VecUnit

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2.0]  [2.1]  [3]    [4.0]  [4.1]  [5.0]  [5.1]  [6.0]  [6.1]
# CHECK-NEXT:  -      -     1.50   1.50   2.06   4.94    -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2.0]  [2.1]  [3]    [4.0]  [4.1]  [5.0]  [5.1]  [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -     1.50   1.50   1.96   0.04    -      -      -      -      -      -      -     stmg	%r6, %r15, 48(%r15)
# CHECK-NEXT:  -      -      -      -     0.10   4.90    -      -      -      -      -      -      -     lmg	%r6, %r15, 48(%r15)

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123
# CHECK-NEXT: Index     0123456789          0123456789

# CHECK:      [0,0]     DeER .    .    .    .    .    .  .   stmg	%r6, %r15, 48(%r15)
# CHECK-NEXT: [0,1]     .DeeeeeeeeeeER .    .    .    .  .   lmg	%r6, %r15, 48(%r15)
# CHECK-NEXT: [1,0]     . D=========eER.    .    .    .  .   stmg	%r6, %r15, 48(%r15)
# CHECK-NEXT: [1,1]     .  D========eeeeeeeeeeER .    .  .   lmg	%r6, %r15, 48(%r15)
# CHECK-NEXT: [2,0]     .   D=================eER.    .  .   stmg	%r6, %r15, 48(%r15)
# CHECK-NEXT: [2,1]     .    D================eeeeeeeeeeER   lmg	%r6, %r15, 48(%r15)

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     3     9.7    0.3    0.0       stmg	%r6, %r15, 48(%r15)
# CHECK-NEXT: 1.     3     9.0    0.3    0.0       lmg	%r6, %r15, 48(%r15)
# CHECK-NEXT:        3     9.3    0.3    0.0       <total>
