; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64-w64-mingw32 | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64-w64-mingw32 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

@var = external local_unnamed_addr global i32, align 4
@dsolocalvar = external dso_local local_unnamed_addr global i32, align 4
@localvar = dso_local local_unnamed_addr global i32 0, align 4
@localcommon = common dso_local local_unnamed_addr global i32 0, align 4
@extvar = external dllimport local_unnamed_addr global i32, align 4

define dso_local i32 @getVar() {
; CHECK-LABEL: getVar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .refptr.var
; CHECK-NEXT:    ldr x8, [x8, :lo12:.refptr.var]
; CHECK-NEXT:    ldr w0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr @var, align 4
  ret i32 %0
}

define dso_local i32 @getDsoLocalVar() {
; CHECK-LABEL: getDsoLocalVar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, dsolocalvar
; CHECK-NEXT:    ldr w0, [x8, :lo12:dsolocalvar]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr @dsolocalvar, align 4
  ret i32 %0
}

define dso_local i32 @getLocalVar() {
; CHECK-LABEL: getLocalVar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, localvar
; CHECK-NEXT:    ldr w0, [x8, :lo12:localvar]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr @localvar, align 4
  ret i32 %0
}

define dso_local i32 @getLocalCommon() {
; CHECK-LABEL: getLocalCommon:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, localcommon
; CHECK-NEXT:    ldr w0, [x8, :lo12:localcommon]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr @localcommon, align 4
  ret i32 %0
}

define dso_local i32 @getExtVar() {
; CHECK-LABEL: getExtVar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, __imp_extvar
; CHECK-NEXT:    ldr x8, [x8, :lo12:__imp_extvar]
; CHECK-NEXT:    ldr w0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr @extvar, align 4
  ret i32 %0
}

define dso_local void @callFunc() {
; CHECK-LABEL: callFunc:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    b otherFunc
entry:
  tail call void @otherFunc()
  ret void
}

declare dso_local void @otherFunc()

define dso_local void @sspFunc() #0 {
; CHECK-LABEL: sspFunc:
; CHECK:       .seh_proc sspFunc
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    adrp x8, .refptr.__stack_chk_guard
; CHECK-NEXT:    add x0, sp, #7
; CHECK-NEXT:    ldr x8, [x8, :lo12:.refptr.__stack_chk_guard]
; CHECK-NEXT:    ldr x8, [x8]
; CHECK-NEXT:    str x8, [sp, #8]
; CHECK-NEXT:    bl ptrUser
; CHECK-NEXT:    adrp x8, .refptr.__stack_chk_guard
; CHECK-NEXT:    ldr x8, [x8, :lo12:.refptr.__stack_chk_guard]
; CHECK-NEXT:    ldr x9, [sp, #8]
; CHECK-NEXT:    ldr x8, [x8]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB6_2
; CHECK-NEXT:  // %bb.1: // %entry
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 16
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB6_2: // %entry
; CHECK-NEXT:    bl __stack_chk_fail
; CHECK-NEXT:    brk #0x1
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %c = alloca i8, align 1
  call void @llvm.lifetime.start.p0(i64 1, ptr nonnull %c)
  call void @ptrUser(ptr nonnull %c)
  call void @llvm.lifetime.end.p0(i64 1, ptr nonnull %c)
  ret void
}

declare void @llvm.lifetime.start.p0(i64, ptr nocapture)
declare dso_local void @ptrUser(ptr) local_unnamed_addr #2
declare void @llvm.lifetime.end.p0(i64, ptr nocapture)

attributes #0 = { sspstrong }

; CHECK:        .section        .rdata$.refptr.__stack_chk_guard,"dr",discard,.refptr.__stack_chk_guard
; CHECK:        .globl  .refptr.__stack_chk_guard
; CHECK: .refptr.__stack_chk_guard:
; CHECK:        .xword  __stack_chk_guard
; CHECK:        .section        .rdata$.refptr.var,"dr",discard,.refptr.var
; CHECK:        .globl  .refptr.var
; CHECK: .refptr.var:
; CHECK:        .xword  var

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-GI: {{.*}}
; CHECK-SD: {{.*}}
