/* skk.c generated by valac 0.40.8, the Vala compiler
 * generated from skk.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_REPL (repl_get_type ())
#define REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPL, Repl))
#define REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPL, ReplClass))
#define IS_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPL))
#define IS_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPL))
#define REPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPL, ReplClass))

typedef struct _Repl Repl;
typedef struct _ReplClass ReplClass;
typedef struct _ReplPrivate ReplPrivate;
enum  {
	REPL_0_PROPERTY,
	REPL_NUM_PROPERTIES
};
static GParamSpec* repl_properties[REPL_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Repl {
	GObject parent_instance;
	ReplPrivate * priv;
};

struct _ReplClass {
	GObjectClass parent_class;
};

struct _ReplPrivate {
	SkkContext* context;
};


extern gchar* opt_file_dict;
gchar* opt_file_dict = NULL;
extern gchar* opt_user_dict;
gchar* opt_user_dict = NULL;
extern gchar* opt_skkserv;
gchar* opt_skkserv = NULL;
extern gchar* opt_typing_rule;
gchar* opt_typing_rule = NULL;
extern gboolean opt_list_typing_rules;
gboolean opt_list_typing_rules = FALSE;
static gpointer repl_parent_class = NULL;

gint _vala_main (gchar** args,
                 int args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata * array,
                                       gint array_length);
GType repl_get_type (void) G_GNUC_CONST;
Repl* repl_new (SkkContext* context);
Repl* repl_construct (GType object_type,
                      SkkContext* context);
gboolean repl_run (Repl* self);
#define REPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_REPL, ReplPrivate))
static void repl_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const GOptionEntry options[6] = {{"file-dict", 'f', 0, G_OPTION_ARG_STRING, &opt_file_dict, N_ ("Path to a file dictionary"), NULL}, {"user-dict", 'u', 0, G_OPTION_ARG_STRING, &opt_user_dict, N_ ("Path to a user dictionary"), NULL}, {"skkserv", 's', 0, G_OPTION_ARG_STRING, &opt_skkserv, N_ ("Host and port running skkserv (HOST:PORT)"), NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &opt_typing_rule, N_ ("Typing rule (default: \"default\")"), NULL}, {"list-rules", 'l', 0, G_OPTION_ARG_NONE, &opt_list_typing_rules, N_ ("List typing rules"), NULL}, {NULL}};

static void
_vala_SkkRuleMetadata_array_free (SkkRuleMetadata * array,
                                  gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	GOptionContext* option_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	gboolean _tmp8_;
	GeeArrayList* dictionaries = NULL;
	GeeArrayList* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp31_;
	const gchar* _tmp33_;
	const gchar* _tmp52_;
	SkkContext* context = NULL;
	GeeArrayList* _tmp78_;
	gint _tmp79_;
	gpointer* _tmp80_;
	SkkDict** _tmp81_;
	gint _tmp81__length1;
	SkkContext* _tmp82_;
	SkkContext* _tmp83_;
	const gchar* _tmp84_;
	Repl* repl = NULL;
	SkkContext* _tmp95_;
	Repl* _tmp96_;
	Repl* _tmp97_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (_ ("- emulate SKK input method on the command line"));
	option_context = _tmp0_;
	_tmp1_ = option_context;
	g_option_context_add_main_entries (_tmp1_, options, "libskk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option_context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	skk_init ();
	_tmp8_ = opt_list_typing_rules;
	if (_tmp8_) {
		SkkRuleMetadata* rules = NULL;
		gint _tmp9_;
		SkkRuleMetadata* _tmp10_;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = skk_rule_list (&_tmp9_);
		rules = _tmp10_;
		rules_length1 = _tmp9_;
		_rules_size_ = rules_length1;
		_tmp11_ = rules;
		_tmp11__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp11_;
			rule_collection_length1 = _tmp11__length1;
			for (rule_it = 0; rule_it < _tmp11__length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp12_ = {0};
				SkkRuleMetadata rule = {0};
				skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp12_);
				rule = _tmp12_;
				{
					FILE* _tmp13_;
					SkkRuleMetadata _tmp14_;
					const gchar* _tmp15_;
					SkkRuleMetadata _tmp16_;
					const gchar* _tmp17_;
					SkkRuleMetadata _tmp18_;
					const gchar* _tmp19_;
					_tmp13_ = stdout;
					_tmp14_ = rule;
					_tmp15_ = _tmp14_.name;
					_tmp16_ = rule;
					_tmp17_ = _tmp16_.label;
					_tmp18_ = rule;
					_tmp19_ = _tmp18_.description;
					fprintf (_tmp13_, "%s - %s: %s\n", _tmp15_, _tmp17_, _tmp19_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp20_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dictionaries = _tmp20_;
	_tmp21_ = opt_user_dict;
	if (_tmp21_ != NULL) {
		{
			SkkUserDict* _tmp22_ = NULL;
			const gchar* _tmp23_;
			SkkUserDict* _tmp24_;
			GeeArrayList* _tmp25_;
			_tmp23_ = opt_user_dict;
			_tmp24_ = skk_user_dict_new (_tmp23_, "UTF-8", &_inner_error_);
			_tmp22_ = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp25_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (SkkDict*) _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = opt_user_dict;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			fprintf (_tmp26_, "can't open user dict %s: %s", _tmp27_, _tmp29_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp30_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp30_;
		}
	}
	_tmp31_ = opt_file_dict;
	if (_tmp31_ == NULL) {
		gchar* _tmp32_;
		_tmp32_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_file_dict);
		opt_file_dict = _tmp32_;
	}
	_tmp33_ = opt_file_dict;
	if (g_str_has_suffix (_tmp33_, ".cdb")) {
		{
			SkkCdbDict* _tmp34_ = NULL;
			const gchar* _tmp35_;
			SkkCdbDict* _tmp36_;
			GeeArrayList* _tmp37_;
			_tmp35_ = opt_file_dict;
			_tmp36_ = skk_cdb_dict_new (_tmp35_, "EUC-JP", &_inner_error_);
			_tmp34_ = _tmp36_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp37_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (SkkDict*) _tmp34_);
			_g_object_unref0 (_tmp34_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp38_;
			const gchar* _tmp39_;
			GError* _tmp40_;
			const gchar* _tmp41_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp38_ = stderr;
			_tmp39_ = opt_file_dict;
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			fprintf (_tmp38_, "can't open CDB dict %s: %s", _tmp39_, _tmp41_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp42_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp42_;
		}
	} else {
		{
			SkkFileDict* _tmp43_ = NULL;
			const gchar* _tmp44_;
			SkkFileDict* _tmp45_;
			GeeArrayList* _tmp46_;
			_tmp44_ = opt_file_dict;
			_tmp45_ = skk_file_dict_new (_tmp44_, "EUC-JP", &_inner_error_);
			_tmp43_ = _tmp45_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp46_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, (SkkDict*) _tmp43_);
			_g_object_unref0 (_tmp43_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			FILE* _tmp47_;
			const gchar* _tmp48_;
			GError* _tmp49_;
			const gchar* _tmp50_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp47_ = stderr;
			_tmp48_ = opt_file_dict;
			_tmp49_ = e;
			_tmp50_ = _tmp49_->message;
			fprintf (_tmp47_, "can't open file dict %s: %s", _tmp48_, _tmp50_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp51_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp51_;
		}
	}
	_tmp52_ = opt_skkserv;
	if (_tmp52_ != NULL) {
		gint index = 0;
		const gchar* _tmp53_;
		gchar* host = NULL;
		guint16 port = 0U;
		gint _tmp54_;
		_tmp53_ = opt_skkserv;
		index = string_last_index_of (_tmp53_, ":", 0);
		_tmp54_ = index;
		if (_tmp54_ < 0) {
			const gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp55_ = opt_skkserv;
			_tmp56_ = g_strdup (_tmp55_);
			_g_free0 (host);
			host = _tmp56_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp57_;
			gint _tmp58_;
			gchar* _tmp59_;
			const gchar* _tmp60_;
			gint _tmp61_;
			const gchar* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp57_ = opt_skkserv;
			_tmp58_ = index;
			_tmp59_ = string_slice (_tmp57_, (glong) 0, (glong) _tmp58_);
			_g_free0 (host);
			host = _tmp59_;
			_tmp60_ = opt_skkserv;
			_tmp61_ = index;
			_tmp62_ = opt_skkserv;
			_tmp63_ = strlen (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = string_slice (_tmp60_, (glong) (_tmp61_ + 1), (glong) _tmp64_);
			_tmp66_ = _tmp65_;
			port = (guint16) atoi (_tmp66_);
			_g_free0 (_tmp66_);
		}
		{
			SkkSkkServ* _tmp67_ = NULL;
			const gchar* _tmp68_;
			guint16 _tmp69_;
			SkkSkkServ* _tmp70_;
			GeeArrayList* _tmp71_;
			_tmp68_ = host;
			_tmp69_ = port;
			_tmp70_ = skk_skk_serv_new (_tmp68_, _tmp69_, "EUC-JP", &_inner_error_);
			_tmp67_ = _tmp70_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch4_g_error;
			}
			_tmp71_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, (SkkDict*) _tmp67_);
			_g_object_unref0 (_tmp67_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp72_;
			const gchar* _tmp73_;
			guint16 _tmp74_;
			GError* _tmp75_;
			const gchar* _tmp76_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp72_ = stderr;
			_tmp73_ = host;
			_tmp74_ = port;
			_tmp75_ = e;
			_tmp76_ = _tmp75_->message;
			fprintf (_tmp72_, "can't connect to skkserv at %s:%d: %s", _tmp73_, (gint) _tmp74_, _tmp76_);
			result = 1;
			_g_error_free0 (e);
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp77_ = -1;
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp77_;
		}
		_g_free0 (host);
	}
	_tmp78_ = dictionaries;
	_tmp80_ = gee_collection_to_array ((GeeCollection*) _tmp78_, &_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp81__length1 = _tmp79_;
	_tmp82_ = skk_context_new (_tmp81_, _tmp79_);
	_tmp83_ = _tmp82_;
	_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp83_;
	_tmp84_ = opt_typing_rule;
	if (_tmp84_ != NULL) {
		{
			SkkRule* _tmp85_ = NULL;
			const gchar* _tmp86_;
			SkkRule* _tmp87_;
			SkkContext* _tmp89_;
			_tmp86_ = opt_typing_rule;
			_tmp87_ = skk_rule_new (_tmp86_, &_inner_error_);
			_tmp85_ = _tmp87_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp88_ = -1;
				if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch5_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp88_;
			}
			_tmp89_ = context;
			skk_context_set_typing_rule (_tmp89_, _tmp85_);
			_g_object_unref0 (_tmp85_);
		}
		goto __finally5;
		__catch5_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp90_;
			const gchar* _tmp91_;
			GError* _tmp92_;
			const gchar* _tmp93_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp90_ = stderr;
			_tmp91_ = opt_typing_rule;
			_tmp92_ = e;
			_tmp93_ = _tmp92_->message;
			fprintf (_tmp90_, "can't load rule \"%s\": %s\n", _tmp91_, _tmp93_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp94_ = -1;
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp94_;
		}
	}
	_tmp95_ = context;
	_tmp96_ = repl_new (_tmp95_);
	repl = _tmp96_;
	_tmp97_ = repl;
	if (!repl_run (_tmp97_)) {
		result = 1;
		_g_object_unref0 (repl);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	result = 0;
	_g_object_unref0 (repl);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}


static gchar*
g_file_stream_read_line (FILE* self)
{
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		GString* _tmp1_;
		gint _tmp3_;
		GString* _tmp4_;
		gint _tmp5_;
		c = fgetc (self);
		_tmp0_ = c;
		if (!(_tmp0_ != EOF)) {
			break;
		}
		_tmp1_ = ret;
		if (_tmp1_ == NULL) {
			GString* _tmp2_;
			_tmp2_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp2_;
		}
		_tmp3_ = c;
		if (_tmp3_ == ((gint) '\n')) {
			break;
		}
		_tmp4_ = ret;
		_tmp5_ = c;
		g_string_append_c ((GString*) _tmp4_, (gchar) _tmp5_);
	}
	_tmp6_ = ret;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = ret;
		_tmp8_ = ((GString*) _tmp7_)->str;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gboolean
repl_run (Repl* self)
{
	gboolean result = FALSE;
	gchar* line = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		FILE* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		SkkContext* _tmp3_;
		const gchar* _tmp4_;
		gchar* output = NULL;
		SkkContext* _tmp5_;
		gchar* _tmp6_;
		gchar* preedit = NULL;
		SkkContext* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		FILE* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		SkkContext* _tmp21_;
		SkkContext* _tmp22_;
		_tmp0_ = stdin;
		_tmp1_ = g_file_stream_read_line (_tmp0_);
		_g_free0 (line);
		line = _tmp1_;
		_tmp2_ = line;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = self->priv->context;
		_tmp4_ = line;
		skk_context_process_key_events (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->context;
		_tmp6_ = skk_context_poll_output (_tmp5_);
		output = _tmp6_;
		_tmp7_ = self->priv->context;
		_tmp8_ = skk_context_get_preedit (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		preedit = _tmp10_;
		_tmp11_ = stdout;
		_tmp12_ = line;
		_tmp13_ = string_replace (_tmp12_, "\"", "\\\"");
		_tmp14_ = _tmp13_;
		_tmp15_ = output;
		_tmp16_ = string_replace (_tmp15_, "\"", "\\\"");
		_tmp17_ = _tmp16_;
		_tmp18_ = preedit;
		_tmp19_ = string_replace (_tmp18_, "\"", "\\\"");
		_tmp20_ = _tmp19_;
		fprintf (_tmp11_, "{ \"input\": \"%s\", " "\"output\": \"%s\", " "\"preedit\": \"%s\" }\n", _tmp14_, _tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		_tmp21_ = self->priv->context;
		skk_context_reset (_tmp21_);
		_tmp22_ = self->priv->context;
		skk_context_clear_output (_tmp22_);
		_g_free0 (preedit);
		_g_free0 (output);
	}
	result = TRUE;
	_g_free0 (line);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


Repl*
repl_construct (GType object_type,
                SkkContext* context)
{
	Repl * self = NULL;
	SkkContext* _tmp0_;
	g_return_val_if_fail (context != NULL, NULL);
	self = (Repl*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	return self;
}


Repl*
repl_new (SkkContext* context)
{
	return repl_construct (TYPE_REPL, context);
}


static void
repl_class_init (ReplClass * klass)
{
	repl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ReplPrivate));
	G_OBJECT_CLASS (klass)->finalize = repl_finalize;
}


static void
repl_instance_init (Repl * self)
{
	self->priv = REPL_GET_PRIVATE (self);
}


static void
repl_finalize (GObject * obj)
{
	Repl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REPL, Repl);
	_g_object_unref0 (self->priv->context);
	G_OBJECT_CLASS (repl_parent_class)->finalize (obj);
}


GType
repl_get_type (void)
{
	static volatile gsize repl_type_id__volatile = 0;
	if (g_once_init_enter (&repl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ReplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) repl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Repl), 0, (GInstanceInitFunc) repl_instance_init, NULL };
		GType repl_type_id;
		repl_type_id = g_type_register_static (G_TYPE_OBJECT, "Repl", &g_define_type_info, 0);
		g_once_init_leave (&repl_type_id__volatile, repl_type_id);
	}
	return repl_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



