; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i32 @foo(ptr nocapture readnone %match, i32 %cur_match, i32 %best_len, i32 %scan_end, ptr nocapture readonly %prev, i32 %limit, i32 %chain_length, ptr nocapture readonly %win, i32 %wmask) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[IDX_EXT2:%.*]] = zext i32 [[CUR_MATCH:%.*]] to i64
; CHECK-NEXT:    [[ADD_PTR4:%.*]] = getelementptr inbounds nuw i8, ptr [[WIN:%.*]], i64 [[IDX_EXT2]]
; CHECK-NEXT:    [[IDX_EXT1:%.*]] = zext i32 [[BEST_LEN:%.*]] to i64
; CHECK-NEXT:    [[ADD_PTR25:%.*]] = getelementptr inbounds nuw i8, ptr [[ADD_PTR4]], i64 [[IDX_EXT1]]
; CHECK-NEXT:    [[ADD_PTR36:%.*]] = getelementptr inbounds i8, ptr [[ADD_PTR25]], i64 -1
; CHECK-NEXT:    [[I1:%.*]] = load i32, ptr [[ADD_PTR36]], align 4
; CHECK-NEXT:    [[CMP7:%.*]] = icmp eq i32 [[I1]], [[SCAN_END:%.*]]
; CHECK-NEXT:    br i1 [[CMP7]], label [[DO_END:%.*]], label [[IF_THEN_LR_PH:%.*]]
; CHECK:       if.then.lr.ph:
; CHECK-NEXT:    br label [[IF_THEN:%.*]]
; CHECK:       do.body:
; CHECK-NEXT:    [[IDX_EXT:%.*]] = zext i32 [[I4:%.*]] to i64
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds nuw i8, ptr [[WIN]], i64 [[IDX_EXT]]
; CHECK-NEXT:    [[ADD_PTR2:%.*]] = getelementptr inbounds nuw i8, ptr [[ADD_PTR]], i64 [[IDX_EXT1]]
; CHECK-NEXT:    [[ADD_PTR3:%.*]] = getelementptr inbounds i8, ptr [[ADD_PTR2]], i64 -1
; CHECK-NEXT:    [[I3:%.*]] = load i32, ptr [[ADD_PTR3]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[I3]], [[SCAN_END]]
; CHECK-NEXT:    br i1 [[CMP]], label [[DO_END]], label [[IF_THEN]]
; CHECK:       if.then:
; CHECK-NEXT:    [[CUR_MATCH_ADDR_09:%.*]] = phi i32 [ [[CUR_MATCH]], [[IF_THEN_LR_PH]] ], [ [[I4]], [[DO_BODY:%.*]] ]
; CHECK-NEXT:    [[CHAIN_LENGTH_ADDR_08:%.*]] = phi i32 [ [[CHAIN_LENGTH:%.*]], [[IF_THEN_LR_PH]] ], [ [[DEC:%.*]], [[DO_BODY]] ]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[CUR_MATCH_ADDR_09]], [[WMASK:%.*]]
; CHECK-NEXT:    [[IDXPROM:%.*]] = zext i32 [[AND]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[PREV:%.*]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[I4]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[CMP4:%.*]] = icmp ugt i32 [[I4]], [[LIMIT:%.*]]
; CHECK-NEXT:    br i1 [[CMP4]], label [[LAND_LHS_TRUE:%.*]], label [[DO_END]]
; CHECK:       land.lhs.true:
; CHECK-NEXT:    [[DEC]] = add i32 [[CHAIN_LENGTH_ADDR_08]], -1
; CHECK-NEXT:    [[CMP5:%.*]] = icmp eq i32 [[DEC]], 0
; CHECK-NEXT:    br i1 [[CMP5]], label [[DO_END]], label [[DO_BODY]]
; CHECK:       do.end:
; CHECK-NEXT:    [[CONT_0:%.*]] = phi i32 [ 1, [[ENTRY:%.*]] ], [ 0, [[IF_THEN]] ], [ 0, [[LAND_LHS_TRUE]] ], [ 1, [[DO_BODY]] ]
; CHECK-NEXT:    ret i32 [[CONT_0]]
;
entry:
  %idx.ext2 = zext i32 %cur_match to i64
  %add.ptr4 = getelementptr inbounds i8, ptr %win, i64 %idx.ext2
  %idx.ext1 = zext i32 %best_len to i64
  %add.ptr25 = getelementptr inbounds i8, ptr %add.ptr4, i64 %idx.ext1
  %add.ptr36 = getelementptr inbounds i8, ptr %add.ptr25, i64 -1
  %i1 = load i32, ptr %add.ptr36, align 4
  %cmp7 = icmp eq i32 %i1, %scan_end
  br i1 %cmp7, label %do.end, label %if.then.lr.ph

if.then.lr.ph:                                    ; preds = %entry
  br label %if.then

do.body:                                          ; preds = %land.lhs.true
  %chain_length.addr.0 = phi i32 [ %dec, %land.lhs.true ]
  %cur_match.addr.0 = phi i32 [ %i4, %land.lhs.true ]
  %idx.ext = zext i32 %cur_match.addr.0 to i64
  %add.ptr = getelementptr inbounds i8, ptr %win, i64 %idx.ext
  %add.ptr2 = getelementptr inbounds i8, ptr %add.ptr, i64 %idx.ext1
  %add.ptr3 = getelementptr inbounds i8, ptr %add.ptr2, i64 -1
  %i3 = load i32, ptr %add.ptr3, align 4
  %cmp = icmp eq i32 %i3, %scan_end
  br i1 %cmp, label %do.end, label %if.then

if.then:                                          ; preds = %do.body, %if.then.lr.ph
  %cur_match.addr.09 = phi i32 [ %cur_match, %if.then.lr.ph ], [ %cur_match.addr.0, %do.body ]
  %chain_length.addr.08 = phi i32 [ %chain_length, %if.then.lr.ph ], [ %chain_length.addr.0, %do.body ]
  %and = and i32 %cur_match.addr.09, %wmask
  %idxprom = zext i32 %and to i64
  %arrayidx = getelementptr inbounds i32, ptr %prev, i64 %idxprom
  %i4 = load i32, ptr %arrayidx, align 4
  %cmp4 = icmp ugt i32 %i4, %limit
  br i1 %cmp4, label %land.lhs.true, label %do.end

land.lhs.true:                                    ; preds = %if.then
  %dec = add i32 %chain_length.addr.08, -1
  %cmp5 = icmp eq i32 %dec, 0
  br i1 %cmp5, label %do.end, label %do.body

do.end:                                           ; preds = %land.lhs.true, %if.then, %do.body, %entry
  %cont.0 = phi i32 [ 1, %entry ], [ 0, %if.then ], [ 0, %land.lhs.true ], [ 1, %do.body ]
  ret i32 %cont.0
}

declare void @blackhole(<2 x ptr>)

define void @PR37005(ptr %base, ptr %in) {
; CHECK-LABEL: @PR37005(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[E1:%.*]] = getelementptr inbounds ptr, ptr [[IN:%.*]], i64 undef
; CHECK-NEXT:    [[E2:%.*]] = getelementptr inbounds nuw i8, ptr [[E1]], i64 48
; CHECK-NEXT:    [[E4:%.*]] = getelementptr inbounds ptr, ptr [[E2]], <2 x i64> <i64 0, i64 1>
; CHECK-NEXT:    [[PI1:%.*]] = ptrtoint <2 x ptr> [[E4]] to <2 x i64>
; CHECK-NEXT:    [[TMP0:%.*]] = lshr <2 x i64> [[PI1]], splat (i64 14)
; CHECK-NEXT:    [[SL1:%.*]] = and <2 x i64> [[TMP0]], splat (i64 1125899906842496)
; CHECK-NEXT:    [[E5:%.*]] = getelementptr inbounds i8, ptr [[BASE:%.*]], <2 x i64> [[SL1]]
; CHECK-NEXT:    [[E6:%.*]] = getelementptr inbounds i8, <2 x ptr> [[E5]], i64 80
; CHECK-NEXT:    call void @blackhole(<2 x ptr> [[E6]])
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %e1 = getelementptr inbounds ptr, ptr %in, i64 undef
  %e2 = getelementptr inbounds ptr, ptr %e1, i64 6
  %e4 = getelementptr inbounds ptr, ptr %e2, <2 x i64> <i64 0, i64 1>
  %pi1 = ptrtoint <2 x ptr> %e4 to <2 x i64>
  %lr1 = lshr <2 x i64> %pi1, <i64 21, i64 21>
  %sl1 = shl nuw nsw <2 x i64> %lr1, <i64 7, i64 7>
  %e5 = getelementptr inbounds i8, ptr %base, <2 x i64> %sl1
  %e6 = getelementptr inbounds i8, <2 x ptr> %e5, i64 80
  call void @blackhole(<2 x ptr> %e6)
  br label %loop
}

define void @PR37005_2(ptr %base, ptr %in) {
; CHECK-LABEL: @PR37005_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[E1:%.*]] = getelementptr inbounds ptr, ptr [[IN:%.*]], i64 undef
; CHECK-NEXT:    [[E2:%.*]] = getelementptr inbounds nuw i8, ptr [[E1]], i64 48
; CHECK-NEXT:    [[PI1:%.*]] = ptrtoint ptr [[E2]] to i64
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i64 [[PI1]], 14
; CHECK-NEXT:    [[SL1:%.*]] = and i64 [[TMP0]], 1125899906842496
; CHECK-NEXT:    [[E5:%.*]] = getelementptr inbounds nuw i8, ptr [[BASE:%.*]], i64 [[SL1]]
; CHECK-NEXT:    [[E6:%.*]] = getelementptr inbounds i8, ptr [[E5]], <2 x i64> <i64 80, i64 60>
; CHECK-NEXT:    call void @blackhole(<2 x ptr> [[E6]])
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %e1 = getelementptr inbounds ptr, ptr %in, i64 undef
  %e2 = getelementptr inbounds ptr, ptr %e1, i64 6
  %pi1 = ptrtoint ptr %e2 to i64
  %lr1 = lshr i64 %pi1, 21
  %sl1 = shl nuw nsw i64 %lr1, 7
  %e5 = getelementptr inbounds i8, ptr %base, i64 %sl1
  %e6 = getelementptr inbounds i8, ptr %e5, <2 x i64> <i64 80, i64 60>
  call void @blackhole(<2 x ptr> %e6)
  br label %loop
}

define void @PR37005_3(<2 x ptr> %base, ptr %in) {
; CHECK-LABEL: @PR37005_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[E1:%.*]] = getelementptr inbounds ptr, ptr [[IN:%.*]], i64 undef
; CHECK-NEXT:    [[E2:%.*]] = getelementptr inbounds nuw i8, ptr [[E1]], i64 48
; CHECK-NEXT:    [[E4:%.*]] = getelementptr inbounds ptr, ptr [[E2]], <2 x i64> <i64 0, i64 1>
; CHECK-NEXT:    [[PI1:%.*]] = ptrtoint <2 x ptr> [[E4]] to <2 x i64>
; CHECK-NEXT:    [[TMP0:%.*]] = lshr <2 x i64> [[PI1]], splat (i64 14)
; CHECK-NEXT:    [[SL1:%.*]] = and <2 x i64> [[TMP0]], splat (i64 1125899906842496)
; CHECK-NEXT:    [[E5:%.*]] = getelementptr inbounds i8, <2 x ptr> [[BASE:%.*]], <2 x i64> [[SL1]]
; CHECK-NEXT:    [[E6:%.*]] = getelementptr inbounds i8, <2 x ptr> [[E5]], i64 80
; CHECK-NEXT:    call void @blackhole(<2 x ptr> [[E6]])
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %e1 = getelementptr inbounds ptr, ptr %in, i64 undef
  %e2 = getelementptr inbounds ptr, ptr %e1, i64 6
  %e4 = getelementptr inbounds ptr, ptr %e2, <2 x i64> <i64 0, i64 1>
  %pi1 = ptrtoint <2 x ptr> %e4 to <2 x i64>
  %lr1 = lshr <2 x i64> %pi1, <i64 21, i64 21>
  %sl1 = shl nuw nsw <2 x i64> %lr1, <i64 7, i64 7>
  %e5 = getelementptr inbounds i8, <2 x ptr> %base, <2 x i64> %sl1
  %e6 = getelementptr inbounds i8, <2 x ptr> %e5, i64 80
  call void @blackhole(<2 x ptr> %e6)
  br label %loop
}

; This would crash because we did not expect to be able to constant fold a GEP.

define void @PR51485(<2 x i64> %v) {
; CHECK-LABEL: @PR51485(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[SL1:%.*]] = shl nuw nsw <2 x i64> [[V:%.*]], splat (i64 7)
; CHECK-NEXT:    [[E5:%.*]] = getelementptr inbounds i8, ptr @PR51485, <2 x i64> [[SL1]]
; CHECK-NEXT:    [[E6:%.*]] = getelementptr inbounds i8, <2 x ptr> [[E5]], i64 80
; CHECK-NEXT:    call void @blackhole(<2 x ptr> [[E6]])
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %sl1 = shl nuw nsw <2 x i64> %v, <i64 7, i64 7>
  %e5 = getelementptr inbounds i8, ptr @PR51485, <2 x i64> %sl1
  %e6 = getelementptr inbounds i8, <2 x ptr> %e5, i64 80
  call void @blackhole(<2 x ptr> %e6)
  br label %loop
}

; Avoid folding the GEP outside the loop to inside, and increasing loop
; instruction count.
define float @gep_cross_loop(ptr %_arg_, ptr %_arg_3, float %_arg_8) {
; CHECK-LABEL: @gep_cross_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I:%.*]] = load i64, ptr [[_ARG_:%.*]], align 8
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds float, ptr [[_ARG_3:%.*]], i64 [[I]]
; CHECK-NEXT:    br label [[FOR_COND_I:%.*]]
; CHECK:       for.cond.i:
; CHECK-NEXT:    [[IDX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[ADD11_I:%.*]], [[FOR_BODY_I:%.*]] ]
; CHECK-NEXT:    [[SUM:%.*]] = phi float [ 0.000000e+00, [[ENTRY]] ], [ [[ADD_I:%.*]], [[FOR_BODY_I]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp samesign ult i64 [[IDX]], 17
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY_I]], label [[FOR_COND_I_I_I_PREHEADER:%.*]]
; CHECK:       for.cond.i.i.i.preheader:
; CHECK-NEXT:    ret float [[SUM]]
; CHECK:       for.body.i:
; CHECK-NEXT:    [[ARRAYIDX_I84_I:%.*]] = getelementptr inbounds nuw float, ptr [[ADD_PTR]], i64 [[IDX]]
; CHECK-NEXT:    [[I1:%.*]] = load float, ptr [[ARRAYIDX_I84_I]], align 4
; CHECK-NEXT:    [[ADD_I]] = fadd fast float [[SUM]], [[I1]]
; CHECK-NEXT:    [[ADD11_I]] = add nuw nsw i64 [[IDX]], 1
; CHECK-NEXT:    br label [[FOR_COND_I]]
;
entry:
  %i = load i64, ptr %_arg_, align 8
  %add.ptr = getelementptr inbounds float, ptr %_arg_3, i64 %i
  br label %for.cond.i

for.cond.i:                                       ; preds = %for.body.i, %entry
  %idx = phi i64 [ 0, %entry ], [ %add11.i, %for.body.i ]
  %sum = phi float [ 0.000000e+00, %entry ], [ %add.i, %for.body.i ]
  %cmp = icmp ule i64 %idx, 16
  br i1 %cmp, label %for.body.i, label %for.cond.i.i.i.preheader

for.cond.i.i.i.preheader:                         ; preds = %for.cond.i
  ret float %sum

for.body.i:                                       ; preds = %for.cond.i
  %arrayidx.i84.i = getelementptr inbounds float, ptr %add.ptr, i64 %idx
  %i1 = load float, ptr %arrayidx.i84.i, align 4
  %add.i = fadd fast float %sum, %i1
  %add11.i = add nsw i64 %idx, 1
  br label %for.cond.i
}

declare void @use(ptr)

define void @only_one_inbounds(ptr %ptr, i1 %c, i32 noundef %arg1, i32 noundef %arg2) {
; CHECK-LABEL: @only_one_inbounds(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARG2_EXT:%.*]] = zext i32 [[ARG2:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[ARG1_EXT:%.*]] = zext i32 [[ARG1:%.*]] to i64
; CHECK-NEXT:    [[PTR2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR:%.*]], i64 [[ARG1_EXT]]
; CHECK-NEXT:    [[PTR3:%.*]] = getelementptr i8, ptr [[PTR2]], i64 [[ARG2_EXT]]
; CHECK-NEXT:    call void @use(ptr [[PTR3]])
; CHECK-NEXT:    br i1 [[C:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %arg2.ext = zext i32 %arg2 to i64
  br label %loop

loop:                                             ; preds = %loop, %entry
  %arg1.ext = zext i32 %arg1 to i64
  %ptr2 = getelementptr inbounds i8, ptr %ptr, i64 %arg1.ext
  %ptr3 = getelementptr i8, ptr %ptr2, i64 %arg2.ext
  call void @use(ptr %ptr3)
  br i1 %c, label %loop, label %exit

exit:                                             ; preds = %loop
  ret void
}

define void @both_inbounds_one_neg(ptr %ptr, i1 %c, i32 noundef %arg) {
; CHECK-LABEL: @both_inbounds_one_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[ARG_EXT:%.*]] = zext i32 [[ARG:%.*]] to i64
; CHECK-NEXT:    [[PTR2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR:%.*]], i64 [[ARG_EXT]]
; CHECK-NEXT:    [[PTR3:%.*]] = getelementptr inbounds i8, ptr [[PTR2]], i64 -1
; CHECK-NEXT:    call void @use(ptr nonnull [[PTR3]])
; CHECK-NEXT:    br i1 [[C:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %arg.ext = zext i32 %arg to i64
  %ptr2 = getelementptr inbounds i8, ptr %ptr, i64 %arg.ext
  %ptr3 = getelementptr inbounds i8, ptr %ptr2, i64 -1
  call void @use(ptr %ptr3)
  br i1 %c, label %loop, label %exit

exit:                                             ; preds = %loop
  ret void
}

define void @both_inbounds_pos(ptr %ptr, i1 %c, i32 noundef %arg) {
; CHECK-LABEL: @both_inbounds_pos(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[ARG_EXT:%.*]] = zext i32 [[ARG:%.*]] to i64
; CHECK-NEXT:    [[PTR2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR:%.*]], i64 [[ARG_EXT]]
; CHECK-NEXT:    [[PTR3:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR2]], i64 1
; CHECK-NEXT:    call void @use(ptr nonnull [[PTR3]])
; CHECK-NEXT:    br i1 [[C:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %arg.ext = zext i32 %arg to i64
  %ptr2 = getelementptr inbounds i8, ptr %ptr, i64 %arg.ext
  %ptr3 = getelementptr inbounds i8, ptr %ptr2, i64 1
  call void @use(ptr %ptr3)
  br i1 %c, label %loop, label %exit

exit:                                             ; preds = %loop
  ret void
}
