; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV32I %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I %s
; RUN: llc -mtriple=riscv32 -code-model=medium -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV32I-MEDIUM %s
; RUN: llc -mtriple=riscv64 -code-model=medium -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I-MEDIUM %s
;
; integrated-as fails with error: unexpected token
;   sw zero, %lo(eg)(a0) \n sw zero, %lo(eg)(a0)
;                        ^

@eg = external global [4000 x i32], align 4
@ewg = extern_weak global [4000 x i32], align 4

define void @constraint_o_with_multi_operands() nounwind {
; RV32I-LABEL: constraint_o_with_multi_operands:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0) \n sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_multi_operands:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0) \n sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_multi_operands:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi0:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi0)(a0) \n sw zero, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_multi_operands:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi0:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi0)(a0) \n sw zero, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0 \n sw zero, $1", "=*o,=*o"(ptr elementtype(i32) @eg, ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_A_with_multi_operands() nounwind {
; RV32I-LABEL: constraint_A_with_multi_operands:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    addi a0, a0, %lo(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0) \n sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_multi_operands:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    addi a0, a0, %lo(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0) \n sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_multi_operands:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi1:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi1)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0) \n sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_multi_operands:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi1:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi1)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0) \n sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0 \n sw zero, $1", "=*A,=*A"(ptr elementtype(i32) @eg, ptr elementtype(i32) @eg)
  ret void
}
