; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s
; RUN: llc -mattr=+sme2p2 -force-streaming-compatible < %s | FileCheck %s --check-prefix=USE-NEON-NO-GPRS
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

define double @t1(double %x) {
; CHECK-LABEL: t1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; USE-NEON-NO-GPRS-LABEL: t1:
; USE-NEON-NO-GPRS:       // %bb.0: // %entry
; USE-NEON-NO-GPRS-NEXT:    fcvtzs d0, d0
; USE-NEON-NO-GPRS-NEXT:    scvtf d0, d0
; USE-NEON-NO-GPRS-NEXT:    ret
;
; NONEON-NOSVE-LABEL: t1:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    fcvtzs x8, d0
; NONEON-NOSVE-NEXT:    scvtf d0, x8
; NONEON-NOSVE-NEXT:    ret
entry:
  %conv = fptosi double %x to i64
  %conv1 = sitofp i64 %conv to double
  ret double %conv1
}

define float @t2(float %x) {
; CHECK-LABEL: t2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $z0
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; USE-NEON-NO-GPRS-LABEL: t2:
; USE-NEON-NO-GPRS:       // %bb.0: // %entry
; USE-NEON-NO-GPRS-NEXT:    fcvtzs s0, s0
; USE-NEON-NO-GPRS-NEXT:    scvtf s0, s0
; USE-NEON-NO-GPRS-NEXT:    ret
;
; NONEON-NOSVE-LABEL: t2:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    fcvtzs w8, s0
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ret
entry:
  %conv = fptosi float %x to i32
  %conv1 = sitofp i32 %conv to float
  ret float %conv1
}

define half @t3(half %x)  {
; CHECK-LABEL: t3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $z0
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.h
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: t3:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvtzs w8, s0
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
entry:
  %conv = fptosi half %x to i32
  %conv1 = sitofp i32 %conv to half
  ret half %conv1
}

define double @t4(double %x) {
; CHECK-LABEL: t4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fcvtzu z0.d, p0/m, z0.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; USE-NEON-NO-GPRS-LABEL: t4:
; USE-NEON-NO-GPRS:       // %bb.0: // %entry
; USE-NEON-NO-GPRS-NEXT:    fcvtzu d0, d0
; USE-NEON-NO-GPRS-NEXT:    ucvtf d0, d0
; USE-NEON-NO-GPRS-NEXT:    ret
;
; NONEON-NOSVE-LABEL: t4:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    fcvtzu x8, d0
; NONEON-NOSVE-NEXT:    ucvtf d0, x8
; NONEON-NOSVE-NEXT:    ret
entry:
  %conv = fptoui double %x to i64
  %conv1 = uitofp i64 %conv to double
  ret double %conv1
}

define float @t5(float %x) {
; CHECK-LABEL: t5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $z0
; CHECK-NEXT:    fcvtzu z0.s, p0/m, z0.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; USE-NEON-NO-GPRS-LABEL: t5:
; USE-NEON-NO-GPRS:       // %bb.0: // %entry
; USE-NEON-NO-GPRS-NEXT:    fcvtzu s0, s0
; USE-NEON-NO-GPRS-NEXT:    ucvtf s0, s0
; USE-NEON-NO-GPRS-NEXT:    ret
;
; NONEON-NOSVE-LABEL: t5:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    fcvtzu w8, s0
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ret
entry:
  %conv = fptoui float %x to i32
  %conv1 = uitofp i32 %conv to float
  ret float %conv1
}

define half @t6(half %x)  {
; CHECK-LABEL: t6:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $z0
; CHECK-NEXT:    fcvtzu z0.s, p0/m, z0.h
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: t6:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvtzu w8, s0
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
entry:
  %conv = fptoui half %x to i32
  %conv1 = uitofp i32 %conv to half
  ret half %conv1
}
