; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -O3 -mtriple=riscv64 -mattr=+f,+d < %s | FileCheck %s

; Make sure WriteFRM is not hoisted out of loop due to dead implicit-def.

define double @foo(double %0, double %1, i64 %n) strictfp {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x fa5, zero
; CHECK-NEXT:  .LBB0_1: # %loop
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    fsrmi 3
; CHECK-NEXT:    fadd.d fa5, fa5, fa0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    fsrmi 0
; CHECK-NEXT:    fadd.d fa5, fa5, fa1
; CHECK-NEXT:    beqz a0, .LBB0_1
; CHECK-NEXT:  # %bb.2: # %exit
; CHECK-NEXT:    fmv.d fa0, fa5
; CHECK-NEXT:    ret
entry:
    br label %loop
loop:
    %cnt = phi i64 [0, %entry], [%cnt_inc, %loop]
    %acc = phi double [0.0, %entry], [%f2, %loop]
    call void @llvm.set.rounding(i32 2) strictfp
    %f1 = call double @llvm.experimental.constrained.fadd.f64(double %acc, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") strictfp
    call void @llvm.set.rounding(i32 1) strictfp
    %f2 = call double @llvm.experimental.constrained.fadd.f64(double %f1, double %1, metadata !"round.dynamic", metadata !"fpexcept.ignore") strictfp
    %cnt_inc = add i64 %cnt, 1
    %cond = icmp eq i64 %cnt_inc, %n
    br i1 %cond, label %loop, label %exit
exit:
    ret double %f2
}

declare double @baz(double, double)

define double @bar(double %0, double %1, i64 %n) strictfp {
; CHECK-LABEL: bar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    fsd fs0, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    fsd fs1, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset fs0, -24
; CHECK-NEXT:    .cfi_offset fs1, -32
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    fmv.d fs0, fa1
; CHECK-NEXT:    fmv.d fs1, fa0
; CHECK-NEXT:    fmv.d.x fa0, zero
; CHECK-NEXT:  .LBB1_1: # %loop
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    fsrmi 3
; CHECK-NEXT:    fmv.d fa1, fs1
; CHECK-NEXT:    call baz
; CHECK-NEXT:    fsrmi 0
; CHECK-NEXT:    fmv.d fa1, fs0
; CHECK-NEXT:    call baz
; CHECK-NEXT:    addi s0, s0, -1
; CHECK-NEXT:    beqz s0, .LBB1_1
; CHECK-NEXT:  # %bb.2: # %exit
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    fld fs0, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    fld fs1, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    .cfi_restore ra
; CHECK-NEXT:    .cfi_restore s0
; CHECK-NEXT:    .cfi_restore fs0
; CHECK-NEXT:    .cfi_restore fs1
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
entry:
    br label %loop
loop:
    %cnt = phi i64 [0, %entry], [%cnt_inc, %loop]
    %acc = phi double [0.0, %entry], [%f2, %loop]
    call void @llvm.set.rounding(i32 2) strictfp
    %f1 = call double @baz(double %acc, double %0) strictfp
    call void @llvm.set.rounding(i32 1) strictfp
    %f2 = call double @baz(double %f1, double %1) strictfp
    %cnt_inc = add i64 %cnt, 1
    %cond = icmp eq i64 %cnt_inc, %n
    br i1 %cond, label %loop, label %exit
exit:
    ret double %f2
}

define double @foo2(double %0, double %1, i64 %n, i64 %fcsr) strictfp {
; CHECK-LABEL: foo2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x fa5, zero
; CHECK-NEXT:  .LBB2_1: # %loop
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    csrwi fcsr, 0
; CHECK-NEXT:    fadd.d fa5, fa5, fa0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    fscsr a1
; CHECK-NEXT:    fadd.d fa5, fa5, fa1
; CHECK-NEXT:    beqz a0, .LBB2_1
; CHECK-NEXT:  # %bb.2: # %exit
; CHECK-NEXT:    fmv.d fa0, fa5
; CHECK-NEXT:    ret
entry:
    br label %loop
loop:
    %cnt = phi i64 [0, %entry], [%cnt_inc, %loop]
    %acc = phi double [0.0, %entry], [%f2, %loop]
    call void @llvm.set.fpenv(i64 0) strictfp
    %f1 = call double @llvm.experimental.constrained.fadd.f64(double %acc, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") strictfp
    call void @llvm.set.fpenv(i64 %fcsr) strictfp
    %f2 = call double @llvm.experimental.constrained.fadd.f64(double %f1, double %1, metadata !"round.dynamic", metadata !"fpexcept.ignore") strictfp
    %cnt_inc = add i64 %cnt, 1
    %cond = icmp eq i64 %cnt_inc, %n
    br i1 %cond, label %loop, label %exit
exit:
    ret double %f2
}
