/* The data for this test case was provided by Gary Nicholson
 * <gary@imapping.co.nz> who originally created an interactive SVG map
 * of the world as can be seen here:
 *
 * 	http://www.wherearewe.co.nz/svg.html
 *
 * The data is used here by permission from Gary given on 2006-11-08:
 *
 * 	Thanks for asking, I don't need any attribution if you are
 * 	only using the vectors and not the entire map with
 * 	interactivity etc. So feel free to do what you wish with
 * 	the data.
 */

#define N(x,y) { WM_NEW_PATH,    x, y }
#define M(x,y) { WM_MOVE_TO,     x, y }
#define L(x,y) { WM_LINE_TO,     x, y }
#define H(x,y) { WM_HLINE_TO,    x, y }
#define V(x,y) { WM_VLINE_TO,    x, y }
#define l(x,y) { WM_REL_LINE_TO, x, y }
#define E(x,y) { WM_END,         x, y }

static const wm_element_t countries[] = {
N(413.519,90.071),l(.136,-.348),l(-.31,-.204),l(-.017,-.327),l(.213,-.322),l(.245,-.147),l(.142,-.08),l(.225,.072),l(.062,.301),l(.41,.312),l(.466,.096),l(-.044,.288),l(-.248,.144),l(.074,.353),l(-.145,-.063),l(-.568,-.011),l(-.642,-.063),
N(421.683,94.397),l(.193,.336),l(-.266,.274),l(.214,.288),l(-.09,.192),l(.622,.062),l(.008,.144),l(.55,.242),l(.579,-.332),l(.215,.117),l(-.029,.171),l(-.126,.309),l(.112,.212),l(-.038,.192),l(-.315,-.051),l(-.176,-.162),l(-.283,.091),l(-.081,.273),l(.244,.131),l(-.228,.415),l(-.244,-.333),l(-.469,.05),l(-.071,.122),l(-.216,.03),l(-.23,-.142),l(-.143,-.354),l(-.371,.081),l(.019,.333),l(-.425,.384),l(-.018,.535),l(-.285,.151),l(-.385,-.312),l(.098,-.182),l(-.311,-.071),l(-.534,-.363),l(-.016,-.415),l(-.777,.404),l(.103,.212),l(-.349,.432),l(-.275,.16),l(-.629,-.168),l(-.627,.204),l(-.599,-.062),l(-.102,-.424),l(-.312,-.806),l(-.616,.147),l(-.854,.668),l(-.369,-.111),l(.238,-.226),l(.013,-.322),l(-.08,-.137),l(.089,-.294),l(.718,-.418),l(-.038,-.315),l(.575,-.24),l(.012,-.076),l(.528,-.494),l(.173,-.035),l(-.116,-.089),l(-.153,-.028),l(.221,-.302),l(.446,.007),l(-.005,.096),l(.473,.007),l(.385,-.309),l(.271,.089),l(.272,-.117),l(.271,.096),l(.567,-.158),l(.278,.11),l(.354,-.021),l(-.179,-.199),l(.709,-.199),l(.017,.151),l(.199,-.014),l(.149,.089),l(.852,.007),l(.664,.261),
N(421.394,104.558),l(.104,.175),l(.04,.256),l(-.06,.475),l(.118,.054),l(.062,.333),l(-.076,.795),l(-.211,.327),l(-.118,.724),l(-.292,.501),l(-.298,-.043),l(-.057,-.196),l(-.41,-.076),l(-.227,-.152),l(.284,-.207),l(-.07,-.076),l(-.437,-.098),l(.257,-.332),l(-.11,-.071),l(-.291,.071),l(-.053,-.147),l(.115,-.022),l(.175,-.158),l(-.094,-.153),l(-.257,-.082),l(.015,-.164),l(.247,-.12),l(-.284,-.218),l(.241,-.284),l(.6,-.305),l(.27,-.022),l(.04,-.125),l(.292,-.043),l(.195,.104),l(.096,-.142),l(-.022,-.344),l(.072,-.224),l(.143,-.011),M(396.323,103.853),l(.375,-.122),l(.411,-.365),l(.549,-2.299),l(.397,-.091),l(-.21,-.29),l(-.226,.259),l(.125,-1.144),l(.223,-.826),l(.115,.153),l(.496,.306),l(.191,.382),l(.191,.229),l(-.281,-.673),l(-.63,-.582),l(-.242,-.233),l(.024,-.249),l(.359,-.477),l(-.202,-.375),l(-.2,-.274),l(-.326,-.216),l(-.685,-.1),l(-.515,-.571),l(-.416,-.323),l(.278,-.426),l(-.233,-.181),l(-.343,-.131),l(-.511,-.142),l(-.184,-.173),l(.247,-.376),l(-.329,-.173),l(-.509,.179),l(-.489,-.249),l(-.824,-.251),l(-.619,-.181),l(-.325,.014),l(-.215,-.25),l(-.91,.167),l(-.059,-.25),l(-.265,-.125),l(-.367,-.042),l(-.056,-.104),l(.861,-.083),l(-.085,-.229),l(-.526,-.104),l(.442,-.104),l(.086,-.205),l(-.275,.017),l(-.263,-.021),l(-.417,.083),l(.04,-.438),l(.303,.012),l(.305,-.146),l(.526,-.088),l(.562,-.174),l(.215,.188),l(.18,-.167),l(.474,.063),l(.112,-.26),l(.272,-.059),l(.764,-.078),l(.393,.366),l(.275,.26),l(.342,.083),l(.652,-.271),l(.317,.167),l(.276,-.127),l(.457,-.124),l(.029,.23),l(.591,-.065),l(.3,-.103),l(-.265,-.188),l(-.028,-.251),l(.056,-.345),l(-.037,-.428),l(-.131,.021),l(-.562,-.682),l(-.11,-.407),l(.927,.126),l(.607,-.105),l(-.084,.397),l(.248,.419),l(.342,-.146),l(1.241,.104),l(.501,.146),l(.079,-.014),l(.525,-.093),l(.662,-.27),l(-.534,-.124),l(.055,-.204),l(.166,-.175),l(.753,-.322),l(.756,-.181),l(.902,-.215),l(.314,-.235),l(.302,-.264),l(-.053,-.775),l(.135,-.542),l(.521,-.25),l(.46,-.16),l(.916,-.092),l(.177,-.096),l(.208,.447),l(.311,.335),l(.266,.127),l(.141,-.071),l(.41,-.208),l(.153,.17),l(.202,.458),l(.194,.133),l(.518,-.012),l(.159,.301),l(.259,-.012),l(.576,.048),l(.375,.168),l(-.159,.241),l(.091,.175),l(-.072,.198),l(.285,.122),l(.406,-.075),l(.446,-.035),l(.193,-.313),l(.245,-.072),l(-.119,.373),l(.146,.18),l(-.039,.228),l(.529,.048),l(.341,.192),l(.371,.204),l(.127,.228),l(.694,-.174),l(.079,.114),l(.642,.063),l(.568,.011),l(.145,.063),l(.428,.319),l(.337,.277),l(.395,-.055),l(.045,.145),l(.689,-.062),l(.072,-.048),l(.233,.007),l(.095,.186),l(.456,.09),l(.479,-.014),l(.605,.193),l(-.954,.806),l(-.054,.213),l(-.054,.358),l(-.321,.372),l(-.075,.295),l(.091,.076),l(-.216,.701),l(.135,.233),l(-.385,.309),l(-.473,-.007),l(.005,-.096),L(415.96,94.5),l(-.221,.302),l(.153,.028),l(.116,.089),l(-.173,.035),l(-.528,.494),l(-.012,.076),l(-.575,.24),l(.038,.315),l(-.718,.418),l(-.089,.294),l(.08,.137),l(-.013,.322),l(-.238,.226),l(.369,.111),l(.854,-.668),l(.616,-.147),l(.312,.806),l(.102,.424),l(-.624,.301),l(.532,.344),l(.025,.292),l(.43,.192),l(-.199,.272),l(-.541,.353),l(-.183,-.111),l(-.437,.186),l(.352,.358),l(.616,.191),l(.135,.331),l(-.175,.01),l(-.315,.371),l(.193,.442),l(.754,.391),l(.849,-.07),l(.062,.281),l(-.146,.469),l(-.346,.23),l(-.221,.215),l(-.833,.488),l(-.889,.659),l(-.427,.087),l(-.318,.043),l(-.798,.159),l(-.405,-.028),l(-.471,-.156),l(-.851,-.499),l(-.315,-.085),l(-.354,.029),l(-.231,.072),l(-.511,-.056),l(-.752,-.313),l(-.602,.044),l(-.731,.345),l(-.357,.258),l(-.555,.559),l(-.147,.386),l(.099,.514),l(.091,.379),l(-.334,-.091),l(-.75,.137),l(-.039,.136),l(-.485,-.015),l(-.427,-.197),l(-.395,.167),l(-.261,-.015),l(-.036,-.152),l(-.335,-.091),l(-.206,.03),l(-.374,.076),l(-.187,-.076),l(-.035,-.289),l(-.091,-.213),l(-1.252,-.304),l(-.355,0),l(.017,.319),l(-.542,-.015),l(-.337,.061),l(-.037,-.122),l(-.767,.03),l(-.084,-.114),l(-.028,-.038),l(-.431,-.152),l(-.131,.076),l(-.262,-.03),l(-.056,.076),l(-.507,-.395),l(-.15,.061),l(-1.088,-.334),l(-.112,.106),l(-.15,-.03),l(-.094,-.106),l(.205,-.243),l(-.058,-.122),l(-.469,.03),l(-.472,-.243),
N(681.312,116.395),l(.235,-.171),l(.283,-.256),l(.633,-.738),l(.315,-.157),l(.595,.011),l(.579,.068),l(.511,.096),l(.309,-.115),l(.571,-.678),l(.682,.621),l(1.178,1.611),l(.329,.495),l(.269,.664),l(.002,.75),l(-.034,.947),l(-.129,.637),l(.143,.113),l(.5,-.043),l(-.121,.41),l(-.282,.523),l(-.5,.75),l(-.316,.312),l(-.243,.043),l(-.567,-.211),l(-.256,.1),l(-.607,.58),l(-.431,-.083),l(-.289,-.225),l(-.544,.1),l(-.526,.199),l(-1.188,.835),l(-.462,.043),l(-.46,.312),l(-.055,-.564),l(-.056,-.324),l(-.163,-.705),l(-.137,-.395),l(.167,-.453),l(.499,-.468),l(0,-.353),l(.226,-.425),l(-.044,-.141),l(-.378,-.311),l(-.095,-.296),l(.015,-.467),l(-.087,-.339),l(-.289,-.126),l(-.603,-.084),l(.654,-.411),l(.303,-.114),l(.654,.268),l(.254,-.241),l(-.029,-.283),l(-.764,-.89),l(-.113,-.311),l(-.137,-.105),
N(475.646,121.847),l(-.018,.175),l(.338,.391),l(-.295,-.009),l(-.132,.108),l(-.104,-.059),l(-.327,-.021),l(-.121,.33),l(-.783,.257),l(-.384,.046),l(-.099,.053),l(0,.21),l(-.217,.006),l(-.072,-.192),l(-.402,.023),l(-.547,-.146),l(-.191,-.087),l(0,-.21),l(-.161,-.105),l(-.122,-.403),l(.082,-.035),l(.12,.1),l(.147,-.006),l(.405,-.304),l(.253,-.006),l(.328,.092),l(.077,-.086),l(.088,-.286),l(-.053,-.175),l(.627,.093),l(.658,.027),l(.367,-.056),l(.818,-.233),l(.689,-.304),l(.535,-.158),l(-.475,.295),l(-.436,.231),l(-.596,.444),
N(704.404,117.274),l(.197,-.099),l(1.108,-.271),l(.057,.354),l(-.481,.284),l(-.232,.241),l(-.068,.453),l(.139,.367),l(.291,.056),l(.221,-.114),l(.418,-.354),l(.24,-.085),l(1.656,-.697),l(.389,-.213),l(.46,-.326),l(.349,-.638),l(.76,-.412),l(.347,-.327),l(.191,-.269),l(.142,-.51),l(.538,-.582),l(-.01,-.142),l(.344,-.567),l(.159,-.468),l(.139,-.609),l(-.043,-.467),l(-.33,-.198),l(-.128,-.24),l(.234,-.213),l(.166,-.284),l(-.155,-1.023),l(.544,-.343),l(.176,-.242),l(.327,-.328),l(.192,0),l(.21,.355),l(.199,.227),l(.303,-.058),l(.799,-.257),l(-.169,-.526),l(-.311,-.028),l(-.36,-.312),l(.694,-.415),l(.441,.156),l(.336,.227),l(.025,.199),l(-.016,.868),l(.058,.611),l(.22,.127),l(.243,.312),l(.717,1.432),l(.001,.496),l(-.246,.709),l(-.709,.766),l(-.226,.439),l(.064,.368),l(-.15,.071),l(-.737,.285),l(-.161,.113),l(-.164,.199),l(-.174,.453),l(.02,.396),l(.094,.254),l(.131,.792),l(-.04,.693),l(-.686,.751),l(-.242,.736),l(.02,.707),l(.198,.296),l(.422,.353),l(-.617,.298),l(-.193,.127),l(-.166,.17),l(-.174,.834),l(-1.081,.439),l(-.094,-.282),l(.294,-.665),l(.184,-.523),l(-.198,-.126),l(-.514,.241),l(-.578,.623),l(-.476,.001),l(-.346,.312),l(-.066,.748),l(-.354,.269),l(-.188,-.028),l(-.066,-.155),l(.003,-.606),l(-.149,-.155),l(-.211,.042),l(-.309,.156),l(-.344,.311),l(-.325,.523),l(-.866,-.055),l(-.505,.057),l(-.631,.1),l(-.458,-.549),l(-.685,-.323),l(-.26,.254),l(-.067,.184),l(-.177,.353),l(.037,.056),l(.417,.197),l(.416,.323),l(-.293,.198),l(-.829,.129),l(-.433,.241),l(-.463,.622),l(-.522,.847),l(-.688,-.365),l(-.565,-.21),l(-.285,-.197),l(-.014,-.169),l(-.194,-.818),l(.099,-.155),l(.495,-.325),l(.179,-.269),l(-.067,-.282),l(-.18,-.042),l(-.601,.17),l(-.341,-.028),l(-.789,-.167),l(-.475,.128),l(-.427,.227),l(-.437,.184),l(-.269,-.098),l(-.256,-.027),l(-1.647,.398),l(-.814,.298),l(-.21,-.31),l(-.452,-.042),l(-.413,.438),l(-.006,.635),l(-.756,-.238),l(-.579,-.055),l(-1.1,.073),l(-.267,-.14),l(.072,-.339),l(.179,-.283),l(.483,.013),l(.499,-.114),l(.751,-.467),l(2.201,-1.953),l(.28,-.015),l(.427,-.128),l(.056,.424),l(.495,-.128),l(1.278,-.257),l(.933,-.058),l(1.183,-.172),l(.892,-.256),l(.068,.452),l(.377,.268),l(.167,-.085),l(.654,-.199),l(.446,-.34),l(-.003,-.353),l(.114,-.467),l(.465,-.51),l(.698,-.581),l(.371,-.453),l(-.062,-1.117),l(.182,-.213),M(695.464,127.756),l(-.292,-.197),l(-.223,-.268),l(-.101,-.381),l(-.177,-.395),l(-.492,-.535),l(.731,-.382),l(.287,-.269),l(.456,-.593),l(.409,.253),l(.615,-.015),l(.483,-.185),l(.311,-.339),l(.451,-.311),l(.454,-.029),l(.316,.169),l(.862,.224),l(.153,.254),l(-.1,.127),l(-.102,.423),l(-.292,.24),l(-.864,.876),l(-.181,-.211),l(-.424,-.295),l(-.467,-.042),l(-.612,.213),l(-.193,.184),l(-.245,.495),l(-.165,.508),l(-.153,.212),l(-.448,.269),M(691.12,131.448),l(-.366,-.042),l(-.056,-.141),l(.268,-.537),l(.128,-.593),l(-.334,-.112),l(-.239,.198),l(-.155,.466),l(-.381,.452),l(-.326,-.211),l(-.059,-.211),l(.322,-.466),l(.032,-.296),l(-.356,-.917),l(.169,-.113),l(.687,-.58),l(.083,-.141),l(.034,-.466),l(-.532,-.789),l(-.333,-.042),l(-.162,.269),l(-.419,.495),l(-.249,-.112),l(-.23,-.508),l(-.376,-.267),l(-.261,-.366),l(.41,-.325),l(.733,.083),l(.706,-.171),l(.315,-.466),l(.241,-.283),l(.484,-.058),l(.478,.056),l(.249,.38),l(.27,.168),l(.43,.084),l(.628,-.213),l(.225,.395),l(-.569,.438),l(.405,.239),l(.443,.437),l(.079,.254),l(-.596,.58),l(-.242,.41),l(-.104,.367),l(-.085,.621),l(-.109,.649),l(-.242,.353),l(-.194,.099),l(-.165,.071),l(-.197,.184),l(-.479,.678),M(711.938,108.369),l(-.222,-.241),l(-.077,-.271),l(.325,-.642),l(-.055,-.342),l(-.549,-.198),l(-.168,-.171),l(-.146,-.812),l(.583,-.386),l(.522,-.172),l(.646,-.373),l(.037,-.356),l(-.318,-.285),l(.277,-.3),l(.224,-.015),l(.661,.427),l(.373,.085),l(.532,-.201),l(-.004,-1.186),l(.455,-.187),l(.45,-.244),l(.074,-.743),l(.007,-.844),l(-.398,-.758),l(-.098,-.473),l(.166,-.216),l(.618,-.346),l(.063,.072),l(.507,.43),l(.904,.816),l(1.07,.842),l(1.083,.684),l(.627,.285),l(.528,.17),l(1.02,.198),l(.282,.042),l(.304,-.086),l(.866,-.66),l(.461,-.144),l(.002,.1),l(-.308,.358),l(-.335,.558),l(.198,.414),l(.469,.599),l(.197,.356),l(-.561,.272),l(-.447,.244),l(-.534,.158),l(-.365,.015),l(-.488,-.199),l(-.453,.015),l(-.363,.144),l(-.345,.229),l(-.754,.786),l(-.396,.5),l(-.26,.599),l(-.4,-.07),l(-.425,-.241),l(-2.031,-.965),l(-.461,-.085),l(-.72,.044),l(-1.038,.587),l(-.153,-.299),l(-.372,-.356),l(-.339,.029),l(-.266,.115),l(-.439,.272),l(.049,.299),l(1.16,.497),l(.56,.298),l(.302,.27),l(-.391,.214),l(-.303,.029),l(-.305,-.128),l(-.261,.043),l(-.324,.314),l(-.388,.471),l(-.347,.114),
N(597.917,139.685),l(1.251,-1.545),l(.609,-.539),l(.348,-.239),l(.149,-.103),l(.417,-.016),l(.309,.294),l(.479,.208),l(1.659,.047),l(.371,.041),l(.312,.209),l(.329,.619),l(-.07,.156),l(.042,.24),l(.326,.294),l(.313,.069),l(.258,.238),l(.017,.282),l(-.217,.58),l(-.624,.06),l(-1.036,.062),l(-1.238,-.063),l(-.335,-.125),l(-.301,-.055),l(-.531,.313),l(-.544,.074),l(-.085,-.021),l(-.869,-.214),l(-.559,-.081),l(-.637,-.18),l(-.235,-.493),l(.092,-.113),
N(362.764,152.723),l(.072,-.625),l(.395,-.876),l(.52,-.552),l(.488,-.566),l(.244,-.509),l(1.175,-2.559),l(.238,-.241),l(1.404,-1.175),l(.345,-.495),l(.051,-.918),l(.305,-1.088),l(.651,-1.075),l(.399,-.34),l(.404,-.198),l(.838,-.51),l(.361,-.495),l(.334,-.777),l(.428,-.851),l(1.635,-.04),l(2.511,0),l(2.677,-.001),l(1.718,.004),l(1.42,-.008),l(.027,.876),l(-.03,1.752),l(.002,.65),l(-.104,.396),l(-.56,-.011),l(-6.005,-.022),l(-.557,.074),l(-.047,.509),l(-.07,2.261),l(-.099,2.6),l(-.144,.128),l(-.809,.287),l(-.726,.315),l(-.575,.427),l(-.249,.383),l(-.01,.707),l(.164,1.539),l(.051,1.102),l(-.212,-.027),l(-.732,.033),l(-2.396,-.014),l(-5.055,-.056),l(-.474,-.013),
N(514.551,145.841),l(-.374,.027),l(-.336,-.083),l(-.008,-.615),l(-.153,-.437),l(-.108,-.791),l(.187,-.607),l(.188,-.11),l(-.059,-.187),l(.177,-.607),l(.33,-.269),l(.312,.083),l(.069,.315),l(.26,.093),l(.063,.199),l(.116,.326),l(-.106,.42),l(.031,.708),l(.118,.254),l(-.104,.381),l(-.327,.467),l(-.275,.433),
N(514.177,145.868),l(.374,-.027),l(.008,.288),l(.361,.14),l(.153,.128),l(.186,-.093),l(-.046,.443),l(.397,.001),l(.402,.127),l(.687,-.093),l(.103,-.21),l(.183,-.058),l(.218,.117),l(.424,-.042),l(.595,.112),l(.224,-.035),l(.079,-.105),l(1.358,.222),l(.732,-.14),l(-.022,-.292),l(.225,.175),l(.375,-.016),l(.157,-.099),l(.312,-.422),l(.232,-.073),l(.267,-.495),l(.131,-.297),l(.711,-.637),l(.813,-.889),l(.163,.105),l(.229,-.178),l(.85,-.708),l(.313,-.433),l(.15,.161),l(-.248,.42),l(-.107,.299),l(-.004,.176),l(.099,.064),l(.121,-.024),l(.454,.042),l(.09,.324),l(.001,.508),l(-.003,.358),l(-.49,.034),l(-.401,-.083),l(-.107,.396),l(.073,1.326),l(-.199,.34),l(-.536,.596),l(.003,.946),l(.024,2.075),l(.063,.183),l(-.152,.057),l(-.584,.469),l(-.839,-.108),l(-3.387,-.446),l(-3.362,-.375),l(-.261,-.902),l(-.548,-1.154),l(-1.043,-2.198),
N(668.627,151.365),l(-.102,-.056),l(-.107,-.325),l(-.922,-1.212),l(-.332,-.987),l(-.03,-.438),l(.156,-.749),l(.546,-.792),l(1.312,-1.852),l(.259,-.184),l(.425,-.128),l(.229,-.184),l(.358,-.227),l(.228,.127),l(.554,.394),l(-.334,.424),l(-.084,.142),l(.023,.31),l(-.067,.622),l(-.203,.296),l(-.182,.354),l(-.065,.692),l(-.1,.494),l(-.317,.805),l(-.473,.707),l(-.417,.833),l(-.014,.353),l(-.114,.438),l(-.228,.142),
N(389.765,144.543),l(.1,.084),l(.895,.531),l(2.054,1.344),l(.811,.575),l(3.283,2.241),l(1.924,1.26),l(1.292,.824),l(.397,.253),l(2.472,1.469),l(.181,.253),l(-.096,.396),l(.082,.183),l(.393,.28),l(1.111,1.039),l(.229,.027),l(.47,-.314),l(.588,.562),l(.375,.167),l(.748,.024),l(.309,.111),l(.277,.352),l(.099,.522),l(-.161,.679),l(.146,.564),l(2.176,-.408),l(.064,1.017),l(.034,2.203),l(.001,.96),l(-.08,.89),l(-.145,.919),l(-.434,1.246),l(-.596,.794),l(-.339,.271),l(-.29,.129),l(-2.533,.085),l(-1.808,.124),l(-.209,.072),l(-.562,.427),l(-.579,.272),l(-.678,-.053),l(-.581,-.081),l(-1.062,-.173),l(-.36,-.059),l(-.356,-.125),l(-.37,.073),l(-1.22,.713),l(-.947,.458),l(-.304,.228),l(-.314,.793),l(-.274,-.027),l(-.324,-.182),l(-.518,-.209),l(-.272,.101),l(-.638,.625),l(-.492,.667),l(-.393,.822),l(-.174,.227),l(-.45,.102),l(-.551,-.364),l(-.293,-.281),l(-.273,.058),l(-.397,.384),l(-.355,1.217),l(-.292,1.047),l(-.317,.369),l(-.543,.271),l(-.448,.158),l(-.257,.016),l(-.141,.255),l(.058,.749),l(-.133,.876),l(-.261,.92),l(-.172,.326),l(-.046,.156),l(-.08,.043),l(-.159,.1),l(-.604,.399),l(-.352,.059),l(-.148,-.239),l(-.117,-.381),l(-.004,-.297),l(-.147,-.211),l(-.257,-.041),l(-.239,.114),l(-.571,.483),l(-.362,.469),l(-.35,.228),l(-.455,-.436),l(-.566,-.321),l(-.352,.059),l(-.522,.54),l(-.559,-.901),l(-.194,-1.143),l(-.349,-.718),l(-.474,-.478),l(-.265,-.451),l(-.271,-.832),l(-.022,-.339),l(-.246,-.281),l(-.323,-.055),l(-.684,.428),l(-.3,.327),l(-.43,.243),l(-.565,-.152),l(-.356,-.153),l(-.338,-.026),l(-.475,.413),l(-.252,.256),l(-.536,-.265),l(-.882,-.715),l(-.18,-.183),l(-.113,-.028),l(.062,-.142),l(.004,-.565),l(-.082,-.833),l(-.265,-.337),l(-.554,-.322),l(-.181,-.197),l(-.22,-.479),l(-.144,-.663),l(-.251,-1.1),l(.057,-.339),l(.506,-.399),l(.332,-.284),l(.018,-.607),l(.181,-.552),l(.252,-.256),l(.402,-.073),l(.261,.111),l(.568,.83),l(.214,.168),l(.454,.082),l(.107,-.269),l(-.055,-.296),l(.06,-.212),l(.535,.124),l(.713,.137),l(.485,.054),l(.387,-.031),l(.945,-.344),l(1.953,-.026),l(6.457,-.01),l(.379,-1.613),l(-.724,-.787),l(-.186,-1.468),l(-.202,-2.386),l(-.325,-2.753),l(-.178,-1.736),l(-.19,-1.468),l(-.908,-7.962),l(-.049,-.776),l(3.231,-.089),l(.523,-.13),
N(525.37,142.384),l(.312,-.429),l(.155,-.17),l(.084,.833),l(-.423,.707),l(-.118,.156),l(-.121,.024),l(-.099,-.064),l(.004,-.176),l(.107,-.299),l(.248,-.42),l(-.15,-.161),M(525.923,144.712),l(0,.22),l(.456,.762),l(.408,.465),l(.782,.634),l(.677,.394),l(1.008,.52),l(.392,.154),l(.277,.014),l(.576,-.029),l(.364,.112),l(.873,.973),l(.518,.648),l(.46,.422),l(.81,.365),l(.025,.212),l(-.67,1.06),l(-.615,.721),l(-.883,.807),l(-.776,1.541),l(-.242,.142),l(-.562,-.083),l(-.235,-.084),l(-.252,.071),l(-.278,.509),l(-.062,1.115),l(.001,.791),l(.134,.621),l(-.403,.142),l(-1.046,.073),l(-.627,.27),l(-.367,.283),l(-.29,.495),l(-.131,.551),l(-.204,.283),l(-.444,.255),l(-.544,.1),l(-.292,0),l(-.386,-.042),l(-.326,.029),l(-.382,.283),l(-.22,.297),l(-.125,.508),l(.003,.353),l(-.091,.311),l(-.631,.396),l(-.344,.043),l(-.776,-.21),l(-.717,.058),l(-.896,.27),l(-.768,.298),l(-.283,.099),l(-.416,.145),l(-.241,-.306),l(-.483,-.689),l(.006,-.296),l(-.127,-.253),l(-.933,-1.364),l(-.604,-.971),l(-.226,-.634),l(-.092,-.663),l(1.691,-.815),l(2.35,-1.213),l(5.346,-2.982),l(-.155,-1.453),l(-.581,-.914),l(-.063,-.183),l(-.024,-2.075),l(-.003,-.946),l(.536,-.596),l(.199,-.34),l(-.073,-1.326),l(.107,-.396),l(.401,.083),l(.49,-.034),
N(405.733,173.04),l(-.568,-.971),l(-.562,-.025),l(-.37,.044),l(-.516,-.181),l(-.97,-.757),l(-.114,-.226),l(.335,-.439),l(-.018,-.212),l(-.179,-.268),l(-.502,-.42),l(-.389,-.266),l(-.422,-.492),l(-.426,-.93),l(-.019,-.396),l(.173,-.665),l(.581,.081),l(.678,.053),l(.579,-.272),l(.562,-.427),l(.209,-.072),l(1.808,-.124),l(2.533,-.085),l(.29,-.129),l(.339,-.271),l(.596,-.794),l(.434,-1.246),l(.145,-.919),l(.08,-.89),l(-.001,-.96),l(-.034,-2.203),l(-.064,-1.017),l(1.672,-.321),l(1.82,-.364),l(3.084,-2.617),l(.834,-.655),l(2.308,-1.454),l(1.607,-.956),l(4.012,-2.241),l(1.632,-.843),l(.265,-.186),l(.832,.137),l(1.646,.442),l(1.008,.333),l(.258,.182),l(1.192,.911),l(.231,-.157),l(1.519,-.729),l(.364,2.145),l(.169,1.298),l(.42,1.028),l(.554,.802),l(.703,.604),l(-.388,.722),l(-.265,.99),l(-.168,1.088),l(-.084,.989),l(.022,.537),l(-.062,.707),l(-.019,1.045),l(-.034,1.088),l(-.056,.466),l(-2.43,2.613),l(-.591,.78),l(-.87,1.333),l(-.572,.794),l(-.007,.678),l(.123,.719),l(.014,.269),l(-.951,.034),l(-.437,.2),l(-.453,.299),l(-.761,.697),l(-.259,.058),l(-.609,-.208),l(-.724,-.193),l(-.884,-.221),l(-.531,-.04),l(-.709,.047),l(-.628,.103),l(-.774,.287),l(-.403,.327),l(-.629,.399),l(-.273,.059),l(-.934,.005),l(-.965,-.277),l(-1.173,-.742),l(-.354,-.083),l(-.467,.116),l(-1.337,.544),l(-.37,.002),l(-.209,-.098),l(-1.095,-1.223),l(-.821,-.277),l(-1.111,-.121),l(-1.174,.108),l(-1.064,.188),l(-.676,.4),l(-.687,1.614),l(-.353,.482),l(-.158,.849),l(-.092,.961),l(-.902,-.503),l(-.727,-.589),l(-.339,-.28),l(-.321,.073),l(-.577,.3),
N(431.763,171.063),l(-.351,-.407),l(-.575,-.52),l(-.173,-.394),l(-.014,-.269),l(-.123,-.719),l(.007,-.678),l(.572,-.794),l(.87,-1.333),l(.591,-.78),l(2.43,-2.613),l(.056,-.466),l(.034,-1.088),l(.019,-1.045),l(.062,-.707),l(-.022,-.537),l(.084,-.989),l(.168,-1.088),l(.265,-.99),l(.388,-.722),l(-.703,-.604),l(-.554,-.802),l(-.42,-1.028),l(-.169,-1.298),l(-.364,-2.145),l(1.818,-.858),l(.41,-.059),l(5.231,2.554),l(4.941,2.372),l(5.577,2.792),l(1.981,.963),l(-.02,1.045),l(-.016,.946),l(-.036,.636),l(.085,2.5),l(-.038,.749),l(.036,1.002),l(.031,1.229),l(-.04,.283),l(-.839,-.009),l(-1.245,.05),l(-.229,.143),l(-.417,1.245),l(-.583,.809),l(-.122,.438),l(.131,.677),l(-.149,.212),l(-.718,.428),l(-.053,.24),l(.342,.662),l(-.087,.34),l(-.542,.596),l(-.316,.609),l(.219,.352),l(.517,-.088),l(.338,.012),l(.141,.225),l(.221,1.228),l(.137,.522),l(.155,.295),l(.444,.407),l(.266,.465),l(.026,.367),l(-.15,.425),l(-.559,-.208),l(-.321,-.012),l(-.322,.086),l(-.939,.613),l(-.372,.228),l(-.165,.382),l(-.005,.41),l(-.196,.284),l(-2.649,2.275),l(-.386,.087),l(-2.181,.055),l(-.434,.059),l(-.209,.199),l(-.117,.806),l(-.646,1.176),l(-.258,.143),l(-.368,.031),l(-.881,-.009),l(-.818,.273),l(-.754,.386),l(-.466,.271),l(-.224,.03),l(-.225,-.069),l(-.494,-.661),l(-1.363,.686),l(-.449,.158),l(-.24,-.027),l(-.096,-.084),l(-.208,-.183),l(-.382,-1.057),l(-.638,-1.07),l(-1.343,-1.179),l(-1.088,-1.067),l(.323,-.539),l(.29,-.312),l(.24,-.1),l(.481,.082),l(1.187,.191),l(.674,-.032),l(.225,-.143),l(-.047,-.127),l(-.208,-.21),l(-.381,-.633),l(-.205,-.578),l(-.169,-1.228),l(.134,-.651),l(-.119,-1.2),l(-.395,-.887),l(-.923,-1.238),l(-.208,-.083),l(-.627,-.109),
N(627.173,150.012),l(.483,-.229),l(.515,-.13),l(.341,.012),l(.597,.392),l(.325,.097),l(.584,-.413),l(.332,-.115),l(1.595,-.052),l(.807,-.117),l(.341,-.157),l(.696,-.554),l(.521,-.328),l(.298,-.101),l(.623,.575),l(.771,.235),l(.66,.053),l(.777,-.047),l(.237,.21),l(.056,.38),l(-.472,.75),l(.096,.521),l(.273,.365),l(.943,.615),l(.621,.166),l(.909,.107),l(.197,.143),l(-.19,.132),l(-.826,.482),l(.106,.465),l(-.203,.212),l(-1.261,-.054),l(-.136,.198),l(.057,.395),l(-.283,.382),l(-.585,.792),l(-.221,.142),l(-.533,.241),l(-.171,.127),l(-.27,.396),l(-.303,.932),l(-.388,.975),l(.268,.225),l(.469,.563),l(1.112,1.071),l(.023,.24),l(.042,.522),l(.087,.254),l(.42,.493),l(1.096,.83),l(1.282,1.296),l(.26,.197),l(.636,.069),l(.313,.38),l(.282,1.016),l(.302,.578),l(.638,.605),l(.293,.663),l(.341,1.382),l(.524,2.809),l(-.295,.438),l(-.235,.495),l(.05,.819),l(-.095,.41),l(.056,.664),l(-.027,.099),l(-.364,.551),l(-.447,.439),l(-.254,.127),l(-.509,.1),l(-.419,.17),l(-.501,.354),l(-.591,.622),l(-.579,.354),l(-.325,.043),l(-.512,-.197),l(-.404,-.31),l(-.179,-.141),l(-.153,.424),l(.051,.494),l(.048,.353),l(-.205,.721),l(-.388,.424),l(-.326,.071),l(-.235,-.07),l(-.246,.481),l(-.427,.326),l(-.523,.142),l(-.417,.213),l(-.459,.565),l(-.196,.269),l(-.406,.297),l(-.264,.099),l(-.365,-.042),l(.078,-.861),l(.1,-1.313),l(.151,-.494),l(.215,-.283),l(-.02,-.353),l(-.475,-.437),l(-.749,-.238),l(-.091,-.066),l(.3,-.289),l(.646,-.229),l(.915,-.528),l(.599,-.229),l(.497,.011),l(.688,.194),l(.17,-.27),l(-.03,-.197),l(-.568,-.435),l(-.216,-.422),l(.234,-.425),l(.99,-.571),l(.521,-.229),l(.932,-.443),l(.599,-.187),l(.385,-.285),l(.217,-.509),l(-.054,-1.073),l(.05,-.424),l(.076,-.367),l(-.455,-1.014),l(-.029,-.663),l(.215,-.905),l(.155,-.918),l(-.064,-.578),l(-.214,-.437),l(-.529,-.477),l(-.072,-.282),l(.226,-.439),l(-.136,-.395),l(-.358,-.308),l(-.685,-.391),l(-.471,-.52),l(-.57,-.914),l(-1.683,-2.121),l(-.698,-.772),l(-.637,-.646),l(-.632,-.476),l(-1.234,-.741),l(-.162,-.098),l(-.043,-.494),l(.277,-.369),l(.311,-.101),l(.476,.068),l(.287,-.058),l(.261,-.185),l(.255,-.326),l(-.009,-.508),l(-.87,-.968),l(-.434,-.675),l(-.262,-.083),l(-.39,.171),l(-.509,.483),l(-.287,.058),l(-.47,-.195),l(-.607,-.434),l(-.334,-.689),l(-.338,-.929),l(-.543,-.604),l(-.613,-.575),l(-.45,-.745),
N(217.961,150.385),l(.304,-.043),l(.84,-.27),l(-.17,-.254),l(-.312,-.112),l(-.369,-.056),l(-.651,.016),l(-.497,-.042),l(-.645,.157),l(-1.193,.92),l(-.371,.029),l(-.653,.001),l(-.211,.113),l(-.189,.452),l(-.396,.284),l(-.32,.043),l(-.786,.086),l(.259,-.325),l(.473,-.312),l(-.128,-.593),l(.282,-.382),l(.114,-.099),l(1.258,-.61),l(1.625,-.47),l(1.164,-.087),l(.842,-.157),l(.825,.041),l(.566,-.044),l(.73,.168),l(.848,.083),l(.603,.197),l(.557,.112),l(.477,.013),l(.499,.268),l(.573,.536),l(.382,.253),l(.581,.168),l(.768,.111),l(1.229,.351),l(1.02,.492),l(.453,.31),l(.374,.55),l(.33,.141),l(.479,.041),l(1.704,.519),l(1.018,.167),l(.327,.239),l(-.344,.58),l(.233,.155),l(.559,.042),l(.756,-.072),l(.495,.168),l(.507,.38),l(.591,.281),l(.381,.296),l(-.233,.085),l(-.981,.087),l(-1.15,.398),l(-.626,.058),l(-1.054,-.209),l(-.9,-.041),l(-.934,.186),l(-.943,.115),l(-.484,.029),l(-.449,-.07),l(.353,-.382),l(.728,-.623),l(.173,-.396),L(229,154.204),l(-.181,-.127),l(-.622,-.14),l(-.7,.001),l(-.603,-.112),l(-.651,-.338),l(-.141,-.748),l(-.258,-.536),l(-.218,-.155),l(-.396,-.027),l(-1.005,.044),l(-.836,-.139),l(-.621,-.225),l(-.956,-.493),l(-.739,-.238),l(-.615,-.069),l(-1.154,-.068),l(-.489,-.098),l(-.855,-.352),
N(634.036,168.444),l(.808,-.64),l(.121,-.438),l(-.002,-.945),l(-.157,-.507),l(-.419,-.703),l(-.979,-1.279),l(-.255,-.464),l(-.107,-.366),l(-.058,-1.524),l(-.435,-.632),l(-.688,-.659),l(-.285,-.535),l(-.052,-.282),l(-.266,-.153),l(-.893,-.192),l(-.403,-.012),l(-.286,.453),l(-.2,.538),l(-.543,.257),l(-.223,.072),l(-.59,-.265),l(-.835,-.348),l(-.346,.03),l(-1.173,1.178),l(-.37,.411),l(-.481,-.138),l(-.145,-.324),l(.027,-.494),l(.117,-.438),l(.528,-1.569),l(.085,-.41),l(-.249,-1.311),l(-.045,-.113),l(-.414,.045),l(-.489,.2),l(-.423,.003),l(-.186,-.154),l(-.066,-.367),l(.106,-.805),l(-.01,-.423),l(-.118,-.168),l(-.295,-.182),l(-.541,-.166),l(.193,-.185),l(.582,-.455),l(.442,-.581),l(.53,-.61),l(.502,-.355),l(.178,.196),l(.321,.21),l(.769,.08),l(.266,-.213),l(.109,-.339),l(-.119,-.521),l(-.228,-.366),l(-.138,-.592),l(.043,-.325),l(.24,-.241),l(.679,-.314),l(.45,.745),l(.613,.575),l(.543,.604),l(.338,.929),l(.334,.689),l(.607,.434),l(.47,.195),l(.287,-.058),l(.509,-.483),l(.39,-.171),l(.262,.083),l(.434,.675),l(.87,.968),l(.009,.508),l(-.255,.326),l(-.261,.185),l(-.287,.058),l(-.476,-.068),l(-.311,.101),l(-.277,.369),l(.043,.494),l(.162,.098),l(1.234,.741),l(.632,.476),l(.637,.646),l(.698,.772),l(1.683,2.121),l(.57,.914),l(.471,.52),l(.685,.391),l(.358,.308),l(.136,.395),l(-.226,.439),l(.072,.282),l(.529,.477),l(.214,.437),l(.064,.578),l(-.155,.918),l(-.209,.114),l(-.975,.429),l(-.3,.072),l(-.373,-.351),l(-.444,-.181),l(-.476,.186),l(-.392,.285),l(.107,.296),l(.187,.182),l(.103,.211),l(-.095,.24),l(-.248,.058),l(-.469,-.251),l(-.341,-.111),l(-.736,-.165),l(-.533,-.251),
N(60.074,72.607),l(-.099,.228),l(-.491,.472),l(-.395,.183),l(-.462,.062),L(58,73.461),l(-.961,-.362),l(-.153,-.197),l(.169,-.289),l(.54,-.274),l(.341,-.32),l(.716,.364),l(.3,.091),l(.465,-.26),l(.215,-.213),l(.064,-.366),l(.485,-.047),l(1.107,.135),l(.536,.334),l(.133,.213),l(-.756,.062),l(-.429,0),l(-.59,.184),l(-.11,.092),M(40.092,77.571),l(-.729,-.029),l(-.097,-.24),l(.011,-.3),l(.802,-.243),l(.326,-.211),l(.593,-.423),l(.448,-.137),l(.646,-.077),l(1.427,.253),l(.711,.24),l(-.079,.211),l(-.303,.046),l(-.754,-.074),l(-.496,.031),l(-1.077,.183),l(-.269,.226),l(-1.161,.543),M(38.426,77.979),l(-.515,-.209),l(-.139,-.285),l(.381,-.227),l(.674,.27),l(.093,.195),l(-.122,.15),l(-.372,.105),M(37.896,78.449),l(-.256,.084),l(-.558,.151),l(-1.109,-.058),l(-.387,.135),l(-.398,.434),l(-.31,.15),l(-.854,-.207),l(-.135,-.224),l(.497,-.359),l(.5,-.315),l(.955,-.166),l(.863,-.346),l(.39,.089),l(.461,.224),l(.341,.409),M(29.628,81.29),l(-.168,-.594),l(-.324,-.476),l(.839,-.136),l(.424,.088),l(.436,.238),l(-.244,.268),l(-.26,.06),l(-.073,.297),l(-.22,.09),l(-.412,.164),M(27.543,81.591),l(-.39,.031),l(-.741,.165),l(-.311,-.133),l(-.088,-.178),l(.104,-.119),l(.336,-.268),l(.294,-.09),l(.584,.222),l(.212,.371),M(54.394,157.986),l(-.559,-.356),l(-.044,-.884),l(-.243,-.677),l(.482,-.402),l(-.035,-.2),l(-.156,-.26),l(.052,-.149),l(.173,-.046),l(.354,.158),l(.652,.279),l(.593,.425),l(-.015,.275),l(.238,.046),l(.12,.287),l(.306,.149),l(-.062,.161),L(56,156.933),l(-.172,.204),l(-.766,.195),l(-.374,.23),l(-.295,.425),M(23.015,59.92),l(-1.613,-.646),l(-.75,-.205),l(-.792,-.062),l(-.9,.065),l(-.291,-.095),l(-.431,-.222),l(.179,-.287),l(.516,-.049),l(1.135,.221),l(.579,-.001),l(.543,-.081),l(.538,-.001),l(.828,.285),l(1.725,.362),l(.429,.237),l(.046,.111),l(-.569,-.03),l(-.646,.033),l(-.527,.365),M(99.855,70.993),l(.467,.929),l(-.071,.167),l(-.879,-.272),l(-.621,-.075),l(.067,.441),l(-.056,.228),l(-.935,-.607),L(97.03,71.41),l(.396,-.458),l(.263,-.153),l(.612,-.078),l(.784,.38),l(.771,-.108),M(100.975,73.606),l(.128,.272),l(-.086,.273),l(-.318,.483),l(-.559,-.815),l(-.597,-.909),l(-.04,-.228),l(.095,-.213),l(.407,.029),l(.568,.197),l(.402,.91),M(106.858,78.207),l(-1.872,-1.166),l(-.566,-.555),l(.01,-.467),l(-.559,-.843),l(.071,-.106),l(.456,.06),l(.274,.256),l(1.165,.48),l(.086,.196),l(-.059,.136),l(-.149,.226),l(.296,.436),l(.839,.374),l(.007,.974),M(140.191,127.819),l(-.043,-.094),l(-.198,-.36),l(-.049,-.067),l(-.032,.042),l(-.028,.05),l(-.04,-.092),l(.002,-.664),l(-.331,-.604),l(-.472,-.451),l(-.661,-.451),l(-.512,-.197),l(-.114,-.052),l(-.145,.034),l(.002,.092),l(-.088,.025),l(-.1,-.042),l(-.146,-.143),l(.076,-.076),l(-.073,-.202),l(-.228,-.252),l(-.283,-.025),l(-.312,.084),l(-.932,-.336),l(-.286,-.328),l(-.428,-.244),l(-.383,.042),l(-.932,-.16),l(-.721,.051),l(-.12,-.185),l(-.234,-.067),l(-.046,-.177),l(.094,-.117),l(-.157,-.504),l(.133,-.464),l(-.227,-.096),l(-.127,.008),l(-.249,-.134),l(0,-.101),l(.075,-.093),l(-.029,-.219),l(-.347,-.185),l(-.254,-.286),l(-.415,-.219),l(-.391,-.623),l(-.202,-.076),l(-.203,-.311),l(-.409,-.219),l(-.156,-.529),l(-.002,-.227),l(.178,.007),l(.147,-.164),l(.029,-.326),l(-.208,-.251),l(-.192,-.045),l(-.22,.037),l(-.303,-.126),l(-.535,-.514),l(.078,-.21),l(-.091,-.312),l(-.129,-.067),l(-.044,-.463),l(.058,-.152),l(.119,-.025),l(.099,.067),l(.073,.076),l(-.086,.101),l(.153,.202),l(.285,.126),l(.116,.118),l(.203,.017),l(-.385,-.564),l(-.183,-.144),l(-.021,-.236),l(-.184,-.109),l(-.051,-.344),l(-.13,.006),l(-.011,.144),l(.048,.446),l(-.093,.017),l(-.293,-.194),l(-.119,.042),l(-.516,-.404),l(-.136,-.363),l(-.377,-.514),l(-.531,-.379),l(-.624,-.583),l(-.123,-.142),l(.114,-.101),l(-.327,-.751),l(.161,-.43),l(-.254,-.479),l(-.22,-.355),l(-.738,-.782),l(-.104,-.299),l(.099,-.627),l(.252,-.628),l(.166,-.357),l(.059,-.856),l(-.215,-.785),l(-.692,-1.486),l(-.153,-.916),l(.096,-.287),l(.231,-.244),l(.402,-.201),l(.365,-.717),l(-.365,-.573),l(-.066,-.33),l(.424,-1.593),l(.153,-.575),l(.061,-.634),l(.091,-.778),l(.019,-.179),l(-.153,-.16),l(.08,-.231),l(-.103,-.167),l(.157,-.077),l(-.03,-.186),l(-.046,-.186),l(-.031,-.103),l(-.004,-.058),l(.322,.096),l(.209,-.019),l(.062,-.097),l(-.211,.006),l(-.614,-.122),l(.062,-.707),l(-.103,-.328),l(.017,-.277),l(.587,-.225),l(-.345,-.019),l(-.16,-.142),l(-.129,0),l(-.053,.045),l(.042,.116),l(-.12,.052),l(-.133,-.979),l(-.927,-1.463),l(-.017,-.465),l(.129,-.131),l(.544,.086),l(.632,.217),l(.785,.114),l(.641,.028),l(.546,-.044),l(.415,.086),l(.547,.318),l(.039,.435),l(-.42,.407),l(-.413,.347),l(.532,.146),l(.184,.188),l(.251,.169),l(.029,-.228),l(.161,-.232),l(.393,-.305),l(.21,-.581),l(.102,-.465),l(-.064,-.421),l(-.356,-.958),l(-.158,-.305),l(-.655,-.516),l(.194,.013),l(2.579,.001),l(1.335,.022),l(4.588,-.025),l(3.938,.008),l(2.87,-.001),l(1.687,.006),l(5.117,-.028),l(.74,.011),l(4.13,.021),l(1.089,-.035),l(3.821,.023),l(.875,-.005),l(3.617,-.004),l(4.84,.018),l(.601,-.003),l(2.935,.014),l(2.131,-.012),l(2.781,.029),l(2.915,-.016),l(2.105,.003),l(1.348,-.007),l(2.798,.029),l(2.687,-.029),l(.68,.003),l(-.387,-.588),l(-.131,-.347),l(.501,-.036),l(.896,.748),l(.279,.371),l(.468,.46),l(.833,.451),l(.518,-.076),l(1.425,.208),l(.02,.185),l(.271,-.012),l(.338,.48),l(.16,-.247),l(.502,.013),l(.241,.271),l(.469,.086),l(.064,.185),l(.506,.098),l(.573,-.141),l(.219,-.06),l(.412,-.191),l(.373,-.075),l(.028,.282),l(.197,.116),l(.855,-.083),l(.474,.041),l(.156,.115),l(.196,.144),l(.542,-.049),l(.707,.074),l(1.469,-.592),l(.805,-.189),l(.797,.227),l(.977,.386),l(3.975,1.576),l(2.15,1.061),l(.101,.429),l(.46,.465),l(.628,-.024),l(.178,.135),l(.184,.294),l(.916,.181),l(.307,.235),l(-.11,.318),l(.26,.33),l(2.529,1.05),l(.876,3.16),l(.054,.545),l(-.028,.746),l(-.377,.576),l(-.294,.544),l(-.264,.433),l(-.414,.294),l(-.707,.525),l(-.044,.218),l(.012,.33),l(.371,.427),l(.497,.169),l(.573,.068),l(.524,-.117),l(.925,-.506),l(.939,-.478),l(.88,-.262),l(.919,-.062),l(.944,-.163),l(1.464,-.452),l(.875,-.427),l(-.047,-.362),l(-.16,-.471),l(-.018,-.319),l(.162,-.375),l(.47,-.203),l(.93,-.091),l(1.123,.01),l(1.305,.138),l(1.156,-.197),l(.44,-.275),l(.163,-.512),l(.146,-.434),l(.545,-.164),l(1.754,-.814),l(.534,-.305),l(.968,-.523),l(1.76,-.009),l(2.508,.029),l(1.855,.004),l(1.093,.095),l(.174,-.375),l(.363,-.435),l(.402,-.06),l(1.161,.124),l(1.139,-1.45),l(1.139,-2.22),l(.514,-.626),l(.632,-.526),l(.273,.085),l(.505,.36),l(.381,.085),l(.41,-.176),l(.771,.025),l(.488,.288),l(.174,.274),l(.31,2.819),l(-.077,.229),l(.606,.231),l(.224,0),l(.042,.154),l(-.143,.069),l(.02,.256),l(-.192,.077),l(.16,.291),l(.188,-.153),l(.349,.495),l(-.268,.281),l(.299,-.04),l(.171,.093),l(-.511,.374),l(-.509,.093),l(-.297,-.12),l(-.013,.253),l(-.138,.067),l(-.077,-.107),l(-.231,-.08),l(-.277,.133),l(-.101,.28),l(-.171,-.013),l(-.15,.16),l(-.175,-.347),l(-.746,.28),l(-.204,-.093),l(.12,.413),l(-.666,-.213),l(.199,-.48),l(-.149,-.04),l(-.364,.52),l(-.332,.56),l(-.342,.333),l(-.324,-.227),l(-.249,.439),l(-.346,-.08),l(.122,-.307),l(-.325,.253),l(.165,.16),l(-.326,.293),l(-.318,-.133),l(.105,-.226),l(-.654,.253),l(.065,.359),l(-.264,.04),l(-.161,.373),l(-.352,.106),l(-.333,.679),l(-.404,.505),l(.173,.146),l(.068,.212),l(.168,.053),l(.083,-.08),l(.169,.013),l(-.122,.146),l(-.547,.106),l(.053,.093),l(-.392,.292),l(-.068,.159),l(.337,.027),l(.282,.093),l(.599,.704),l(.055,.398),l(.399,.106),l(.691,-.239),l(-.022,-.186),l(-.14,-.027),l(-.254,-.279),l(-.097,-.04),l(-.009,-.066),l(.196,0),l(.23,.133),l(.218,.358),l(.031,.425),l(-1.599,.292),l(-.032,-.385),l(-.124,-.066),l(-.109,.226),l(-.164,.04),l(-.03,.093),l(-.105,-.106),l(-.159,.266),l(-.164,.04),l(-.294,.04),l(-.045,-.332),l(.198,-.332),l(-.443,.119),l(-.154,-.146),l(-.082,.252),l(-.087,.664),l(-1.429,.132),l(-1.694,.159),l(-1.182,.345),l(-.787,.358),l(-.097,.212),l(-.32,.053),l(-.144,.172),l(-.032,-.04),l(.308,-.756),l(.024,-.106),l(-.071,.027),l(-.41,.994),l(-.079,-.08),l(-.406,.292),l(.218,.318),l(.553,.093),l(-.46,1.515),l(-.302,.429),l(-.259,-.092),l(.043,.251),l(-.062,.185),l(-.237,.145),l(-.462,.501),l(-.292,.304),l(-.167,.026),l(-.075,-.119),l(.177,-.31),l(-.113,-.178),l(-.43,.013),l(-.447,-.343),l(-.148,-.053),l(-.329,-.541),l(.315,-.257),l(.151,-.245),l(-.271,.119),l(-.362,.37),l(.489,.845),l(.033,.356),l(.387,.581),l(.28,.066),l(.104,.765),l(-.101,.238),l(-.151,.23),l(-.125,-.013),l(-.487,.666),l(-.396,.798),l(.034,.053),l(-.13,.132),l(-.107,-.125),l(-.374,.725),l(.026,.125),l(-.226,.04),l(-.137,-.263),l(.342,-.864),l(.195,-.29),l(.247,-.119),l(.061,-.237),l(-.093,-.059),l(-.374,.119),l(.226,-.383),l(-.218,.04),l(-.176,-.093),l(.012,-.191),l(.242,-.04),l(-.077,-.33),l(-.439,.296),l(-.241,-.204),l(-.157,.053),l(-.23,-.396),l(.355,-.171),l(.357,-.053),l(-.005,-.06),l(-.604,-.316),l(-.092,.165),l(-.072,0),l(.107,-.323),l(.089,-.02),l(.21,.159),l(.131,-.06),l(-.098,-.224),l(-.353,-.066),l(-.065,-.112),l(.096,-.112),l(.336,.02),l(.193,-.284),l(-.281,.046),l(-.158,-.059),l(.241,-.37),l(.652,-.152),l(-.328,-.06),l(.146,-.409),l(-.28,.093),l(-.096,.132),l(.11,.079),l(-.315,.191),l(-.035,-.224),l(-.093,.053),l(.051,.224),l(-.081,.086),l(-.051,-.158),l(-.097,-.066),l(-.103,.416),l(-.447,-.079),l(.402,.501),l(-.294,.666),l(.07,.237),l(.272,.488),l(-.055,.139),l(-.466,-.317),l(-.1,-.211),l(.026,.205),l(.174,.218),l(.421,.237),l(.132,.508),l(-.631,-.402),l(-.354,-.007),l(-.118,-.283),l(-.155,-.053),l(.066,.25),l(-.541,-.323),l(-.33,.04),l(.015,-.29),l(.427,-.323),l(-.428,.079),l(-.19,.468),l(.204,.231),l(.457,.046),l(.202,.25),l(.954,.297),l(-.047,.092),l(.554,.165),l(.158,.132),l(-.22,.468),l(-.227,.06),l(-1.042,-.804),l(.708,.811),l(.626,.171),l(-.248,.092),l(.323,.079),l(-.045,.079),l(.061,.06),l(-.034,.25),l(-.312,-.191),l(-.071,.073),l(.104,.211),l(-.216,.02),l(-.656,-.56),l(-.023,.026),l(.419,.475),l(.309,.158),l(.182,-.026),l(.191,.21),l(.018,.31),l(-.298,.059),l(-.492,-.534),l(-.474,-.198),l(-.199,.16),l(.046,.044),l(.44,.145),l(.488,.382),l(-.047,.237),l(.442,-.033),l(.031,-.119),l(.748,.119),l(.151,.382),l(.406,1.212),l(.448,.803),l(-.14,-.092),l(-.262,-.349),l(-.059,-.132),l(-.359,-1.172),l(-.147,-.277),l(-.056,.31),l(.135,0),l(.034,.198),l(-.292,-.066),l(.173,.283),l(.144,.099),l(.228,.58),l(-.144,-.053),l(-.211,-.382),l(.002,.224),l(-.52,-.303),l(-.06,.059),l(.266,.303),l(-.247,.119),l(-.526,-.204),l(.225,.204),l(-.375,.211),l(-.173,-.02),l(-.251,-.21),l(-.024,-.217),l(.083,-.158),l(-.081,-.053),l(-.091,.204),l(.044,.23),l(.116,.211),l(-.107,.158),l(.894,.02),l(.571,-.145),l(.125,.165),l(-.113,.191),l(-.072,.369),l(.14,.066),l(.092,-.257),l(.135,-.369),l(.18,-.105),l(.266,.31),l(.047,.296),l(-.166,.25),l(-.163,-.013),l(-.063,-.099),l(-.316,.474),l(-.254,.197),l(-.483,-.053),l(-.203,-.065),l(-.147,-.066),l(-.136,-.245),l(-.151,.014),l(.141,.244),l(-.075,.013),l(-.538,-.125),l(-.436,-.151),l(.162,.185),l(.269,.026),l(.833,.335),l(-.034,.119),l(-.396,.145),l(.247,.007),l(-.19,.25),l(-.281,.138),l(-.149,0),l(-.481,-.375),l(.242,.395),l(.43,.164),l(.302,-.171),l(.292,.026),l(.11,-.204),l(.04,.178),l(.217,.04),l(.048,.079),l(-.428,.322),l(-.013,.085),l(-.261,.072),l(-1.498,.214),l(-.865,.895),l(-.487,.609),l(-.13,.127),l(-.935,.143),l(-.528,.128),l(-.617,.241),l(-.678,.539),l(-.225,.424),l(-.096,.354),l(-.819,.694),l(-.693,.383),l(-.429,.199),l(-.797,.086),l(-.35,.58),l(-.177,.198),l(-.809,1.125),l(-.273,.781),l(-.459,1.249),l(.236,1.455),l(.387,.925),l(.456,.873),l(.934,1.562),l(.352,1.746),l(.486,1.194),l(-.075,.092),l(.287,.276),l(.123,.333),l(.062,.827),l(-.301,1.536),l(-.064,.278),l(-.31,.415),l(.108,.424),l(-.02,.252),l(-.393,.551),l(-.017,-.092),l(.129,-.241),l(-.025,-.138),l(-.256,.035),l(-.38,.137),l(-.291,-.126),l(-.509,.138),l(-.12,-.329),l(.014,-.233),l(-.567,-1.068),l(-.764,-.138),l(-.204,-.352),l(-.113,-.819),l(-.423,-.229),l(-.144,-.702),l(-.373,.093),l(-.608,-1.08),l(-.375,-.482),l(.296,0),l(.375,-.438),l(.048,-.226),l(-.167,-.226),l(-.471,.407),l(-.277,-.208),l(.126,-.573),l(.147,-.758),l(.158,-1.043),l(-.293,-.452),l(-.258,-.169),l(-.496,-.126),l(-.832,-.987),l(-.875,-.804),l(-.528,-.168),l(-.43,.072),l(-.536,.298),l(-.456,.354),l(-1.202,.299),l(-.273,-.213),l(-.131,-.62),l(-.253,-.254),l(-.264,-.113),l(-.752,-.069),l(-.516,-.296),l(-.22,-.233),l(-.504,.138),l(-1.052,.115),l(-.653,-.184),l(-.047,.298),l(-.64,.099),l(-.183,0),l(-.578,-.926),l(-.238,.781),l(-.447,-.135),l(-.65,.001),l(-1.328,-.04),l(-.672,.439),l(-.39,.055),l(-1,-.459),l(-.096,.009),l(-.142,.014),l(-.362,.528),l(.201,.229),l(.303,0),l(.211,0),l(.537,-.207),l(.406,.092),l(.676,.482),l(-.68,.373),l(.02,.254),l(.263,.353),l(.593,.146),l(.229,.217),l(.35,.334),l(-.533,.136),l(-.503,-.084),l(-.276,-.419),l(-.79,-.271),l(-.224,-.211),l(-.265,-.056),l(-.013,.02),l(-.209,.32),l(.209,.154),l(.248,.183),l(-.248,.179),l(-.069,.05),l(-.447,-.459),l(-.476,.192),l(-.287,.291),l(-1.025,-.472),l(-.419,-.494),l(-1.16,-.642),l(-.615,.066),l(.554,.393),l(-.307,.187),l(-1.17,-.083),l(-.886,-.252),l(-.896,-.168),l(-1.547,.173),l(-.632,.328),l(-.392,-.015),l(-.433,-.031),l(-.135,-.49),l(-.333,.057),l(-.112,.184),l(.474,.731),l(-.877,.64),l(-.808,.577),l(-.915,.317),l(-.419,.043),l(-.414,-.056),l(-.728,-.111),l(-.126,.198),l(.437,.437),l(-.239,.396),l(-.327,.199),l(-.631,.114),l(-.737,.27),l(-.268,.17),l(.558,.352),l(.111,.169),l(-.659,.694),l(-.154,.297),l(-.012,.848),l(.144,.636),l(.271,.762),l(.425,.903),l(-.347,-.119),l(-.816,-.377),l(-.296,.001),l(-.416,.116),l(-.264,-.069),l(-1.029,-.56),l(-.921,-.32),l(-.375,-.365),l(-.336,-.592),l(-.332,-.932),l(-.078,-.467),l(-.268,-.253),l(-.657,-.576),l(-.845,-1.042),l(-.744,-1.227),l(-.663,-1.029),l(-.363,-.366),l(-.412,-.252),l(-.783,-.321),l(-.475,-.082),l(-.643,.018),l(-.468,.201),l(-.576,.541),l(-.418,.413),l(-.283,.37),l(-.416,.158),l(-.501,-.011),l(-.337,-.069),l(-1.104,-.503),l(-1.092,-.659),l(-.445,-.549),l(-.318,-.847),l(-.284,-.678),l(-.179,-.226),l(-.708,-.491),l(-.837,-.519),l(-.766,-.632),l(-.631,-.662),l(-.209,-.112),l(-1.892,-.046),l(-1.858,-.003),l(-.096,.892),l(-.213,.101),l(-1.867,.011),l(-.966,-.037),l(-1.544,-.02),l(-1.662,-.019),l(-.338,-.055),l(-3.516,-1.112),l(-2.811,-.933),l(-1.186,-.39),l(-.267,-.154),l(-.316,-.31),l(-2.381,.084),l(-2.367,.155),l(-.34,.017),M(49.818,152.776),l(-.122,.086),l(-.279,.03),l(-.111,-.131),l(-.177,-.005),l(-.324,.051),l(-.304,-.39),l(-.071,-.263),l(.339,-.01),l(.299,-.253),l(.188,.218),l(.106,.294),l(.223,.096),l(.233,.279),M(52.785,154.312),l(-.155,-.081),l(-.085,-.356),l(-.461,-.321),l(.095,-.229),l(.143,-.058),l(.366,.209),l(.344,.055),l(.616,.356),l(-.005,.172),l(-.294,.184),l(-.563,.069),M(111.683,77.224),l(-.138,.415),l(-.45,.067),l(-.324,.113),l(-.295,.247),l(-.321,-.137),l(-.185,-.21),l(.087,-.443),l(.086,-.443),l(-.438,-.675),l(-.463,-.319),l(-.199,-.271),l(-1.281,.055),l(-.437,.098),l(-.153,.161),l(-.496,.097),l(-.019,-.193),l(-.034,-.432),l(.212,-.272),l(.184,-.212),l(-.378,-.347),l(-.641,-.438),l(-.693,-.696),l(-.723,-.317),l(-.453,-.136),l(.132,-.35),l(-.569,-.592),l(-.099,-.213),l(.371,-.229),l(-.068,-.122),l(-.301,-.152),l(-.445,-.076),l(-.392,-.274),l(-.237,-.259),l(-.57,-.305),l(-1,-.411),l(-.479,-.765),l(-.217,-.583),l(-.367,-.399),l(-.357,.016),l(-.101,.814),l(.42,.873),l(.104,.306),l(-.047,.153),l(-.701,-.136),l(-.272,-.076),l(-.511,-.504),l(-.4,-.459),l(-.537,.139),l(-1.219,-.228),l(1.263,.718),l(.032,.214),l(-1.62,.171),l(-1.093,-.35),l(-1.388,-.948),l(-.543,-.292),l(-.664,-.043),l(-.079,0),l(-.933,-.213),l(-1.3,-.536),l(.928,-.248),l(.135,-.169),L(90.8,67.129),l(-.384,-.153),l(-.792,.156),l(-.454,.14),l(-.656,.017),l(-1.058,-.06),l(-1.068,-.245),l(.027,-.247),l(-.148,-.186),l(-.325,-.108),l(-.359,.016),l(-.47,.202),l(-1.036,.049),l(-1.465,-.122),L(80.46,66.64),l(-.786,-.091),l(-.248,-.108),l(-.651,-.387),l(-.427,-.527),l(-.301,.218),l(-.788,.157),l(-.89,-.293),l(-.234,-.326),l(-.417,-.139),l(-.872,-.248),l(-1.538,-.23),l(-.817,-.248),l(-.671,-.342),l(-.553,.235),l(-.675,.079),l(.06,.437),l(-.193,.062),l(-.389,.25),l(-.249,.405),l(1.119,.293),l(.174,.294),l(-.096,.388),l(-.428,.449),l(-.458,.001),l(-.804,-.214),l(-.586,-.061),l(-.568,.094),l(-.978,.603),l(-1.066,.217),l(-.936,.448),l(-1.035,.448),l(-1.095,.109),l(.178,-.308),l(.063,-.123),l(.72,-.401),l(-.093,-.385),l(-.655,-.523),l(.004,-.108),L(64.1,66.19),l(.411,-.482),l(.157,-.42),l(.736,-.312),l(.87,-.235),l(1.165,-.018),l(1.085,.123),l(.239,-.156),l(-1.239,-.466),l(-.971,-.389),l(-1.043,.049),l(-.226,.219),l(-.449,.095),l(-.573,.438),l(-.865,.375),l(-1.019,.282),L(61.553,65.9),l(-.406,.094),l(-.298,.14),l(.131,.325),l(-.177,.526),l(-.563,.34),l(-.564,.078),L(59,67.544),l(-.592,.278),l(-.681,.601),l(-.035,.292),l(.38,.168),l(.36,.03),l(.667,.106),l(.465,.229),l(-.075,.184),l(-.43,.338),l(-.625,.2),l(-.557,.277),l(-.423,.398),l(-.544,.383),l(-.675,.093),l(-1.434,.308),l(-.678,.397),l(-1.036,.337),l(-.7,.367),l(.52,.5),l(-.1,.167),l(-1.106,.412),l(-.897,.153),l(-.778,.168),L(49.51,74.19),l(-1.214,.456),L(48.1,74.828),l(-.274,.394),l(-.753,.439),l(-1.193,.229),l(-1.234,.184),l(-.973,-.345),l(.001,-.181),l(.332,-.348),l(.763,-.273),l(.306,-.212),l(.445,-.364),l(1.171,-.441),l(1.403,.073),l(-.12,-.212),l(.02,-.516),l(.47,-.304),l(.725,-.291),l(.754,-.366),l(.266,-.214),l(.002,-.731),l(.246,-.749),l(.693,-.49),l(.194,-.398),l(.034,-.412),l(-.633,.122),l(-1.251,.186),l(-.676,-.029),l(-.5,-.597),l(-.266,.062),l(-.613,.216),l(-.136,.23),l(.239,.352),l(.021,.352),l(-.169,.046),L(47,70.115),l(-.567,-.32),l(-.487,-.397),l(-.509,-.291),l(-.56,-.03),l(-.812,-.106),l(-.91,.094),l(.028,.138),l(-.644,.338),l(-1.175,.14),l(-.649,-.09),l(-.064,-.123),l(-.082,-.107),l(-.125,-1.028),l(.3,-.508),l(-.142,-.431),l(-.864,-1.002),l(-1.43,.437),l(-.738,.078),l(-.406,.202),l(-1.091,.094),l(-.4,-.23),l(-.394,-.355),l(-.466,-.325),l(-1.007,-.463),l(-.179,-.28),l(.292,-.171),l(.337,-.437),l(.704,.139),l(1.312,.309),l(.69,.03),l(.238,-.234),l(-.375,-.482),l(-.458,-.264),l(-.363,0),l(-.541,.22),l(-.528,-.015),l(-1.342,-.513),l(-.623,-.186),l(-.197,.016),l(-.858,-.029),l(-.024,-.078),l(-.623,-.985),l(.79,-.19),l(.071,-.456),l(.495,-.221),l(.102,-.299),l(.227,-.347),l(.893,-.491),l(.337,-.38),l(.386,-.301),l(.527,-.476),l(.39,-.175),l(.719,.109),l(.98,.268),l(.485,.094),l(.752,-.144),l(.427,-.254),l(.675,-.429),l(1.252,-.257),l(.774,-.033),l(.955,-.049),l(.354,-.175),l(.187,-.478),l(-.259,-.669),l(-.814,-.686),l(.026,-.096),l(.927,-.034),l(.343,-.256),l(-.25,-.384),l(-.497,-.256),l(-.367,-.08),l(-1.88,.389),L(39.33,56.53),l(-.534,.289),l(-.496,.065),l(-1.907,-.333),l(-.848,-.031),L(34.8,56.49),l(-1.27,.162),l(-1.265,-.029),l(-1.349,-.174),l(-.53,-.207),l(-.183,-.788),l(.144,-.146),l(.636,-.033),l(1.008,-.002),l(.446,-.179),l(-1.057,-.241),l(-1.912,-.304),L(28.13,54.31),l(-1.285,-.208),l(.219,-.114),l(.781,-.262),l(1.568,-.214),l(1.325,-.328),l(.958,-.214),l(1.058,-.361),l(.953,-.23),l(1.399,-.281),l(1.513,.128),l(-.158,.523),l(.023,.277),l(1.051,.161),l(1.359,.095),l(1.074,-.019),l(.657,-.099),l(.784,-.246),l(.55,-.295),l(.262,-.083),l(.752,.064),l(.751,.113),l(1.021,-.051),l(.2,-.327),l(.007,-.18),l(-.689,-.064),l(-1.946,-.292),l(-1.283,-.047),l(-.312,-.755),l(-1.473,-.162),l(-.96,-.031),l(-1.573,-.096),l(-.194,-.511),l(-.484,-.312),l(-1.042,-.461),l(-.512,-.148),l(-2.66,-.659),l(-2.008,-.545),l(.317,-.167),l(.812,-.402),l(.086,-.485),l(2.136,-.054),l(.99,-.069),l(1.829,-.288),l(.784,-.354),l(.452,-.623),l(.788,-.575),l(.616,-.525),l(.818,-.41),l(.742,-.224),l(1.066,-.104),l(1.133,-.241),l(1.047,-.036),l(1.804,.065),l(.146,-.188),l(-.156,-.205),L(44.47,42.83),l(.018,-.206),l(1.936,-.089),l(1.143,.032),l(.974,-.054),l(1.344,-.14),l(1.098,-.416),l(.918,-.417),l(.957,-.019),l(.282,.051),l(.675,.241),l(.156,.172),l(-.383,.139),l(.017,.344),l(1.049,.136),l(.424,.034),l(.536,-.293),l(.297,-.208),l(1.419,.187),l(1.534,.049),l(1.062,.049),l(.715,.033),l(.711,.257),l(.359,.274),l(.783,.358),l(.494,.085),l(.421,-.086),l(1.292,.117),l(1.124,.015),l(1.556,-.054),l(1.449,-.088),l(1.213,.1),l(1.377,.254),l(.883,.118),l(3.424,.13),l(1.279,.168),l(.743,.169),l(2.027,-.038),l(2.339,-.141),l(1.123,.236),l(2.441,.791),l(1.206,.301),l(.227,.008),l(.102,.483),l(-.003,2.855),l(.039,2.259),l(.052,2.335),l(.129,2.796),l(-.026,2.183),l(-.043,4.334),l(.026,2.167),l(.089,1.046),l(.196,.279),l(.84,.074),l(2.424,-.122),l(.739,.059),l(.332,.388),l(.173,.387),l(.348,.292),l(2.162,1.318),l(.945,.673),l(.238,-.325),l(.848,-.205),l(1.225,-.67),l(.731,-.498),l(.495,-.126),l(.832,.073),l(.316,.199),l(.371,.492),l(.35,.322),l(2.048,1.175),l(.814,.58),l(1.769,1.768),l(1.67,1.882),l(.512,.393),l(.189,.029),l(.98,.314),l(2.025,.763),l(.402,.255),l(-.163,.788),l(.393,.777),
N(643.755,159.873),l(-1.092,-.52),l(-.637,-.337),l(-.203,-1.284),l(.036,-.282),l(.24,-.241),l(.42,-.241),l(.721,-.623),l(.493,.056),l(.049,-.17),l(.24,-.396),l(.239,.028),l(.573,.225),l(.321,-.312),l(.439,-.001),l(.798,-.171),l(.596,.69),l(-.163,.17),l(-.443,.354),l(-.412,.538),l(-.285,.734),l(.14,.296),l(-.22,.311),l(-.292,.085),l(-1.026,.383),l(-.532,.707),M(627.173,150.012),l(-.679,.314),l(-.24,.241),l(-.043,.325),l(.138,.592),l(.228,.366),l(.119,.521),l(-.109,.339),l(-.266,.213),l(-.769,-.08),l(-.321,-.21),l(-.178,-.196),l(-.153,-.239),l(-.111,-.38),l(-.628,.413),l(-.647,.159),l(-.246,-.083),l(-.378,-.266),l(-.341,-.746),l(-.291,-.379),l(-.481,.045),l(-.507,.003),l(-.228,-.098),l(-.117,-.352),l(.729,-1.584),l(-.033,-.268),l(-.521,-.096),l(-.554,.074),l(-.202,-.324),l(-.277,-1.762),l(-.156,-.126),l(-.479,.017),l(-.771,.089),l(-.819,.442),l(-.312,.086),l(-.216,-.069),l(0,-.268),l(.224,-.58),l(-.163,-.705),l(-.075,-.465),l(.617,-.85),l(.191,-.198),l(.487,-.271),l(.611,-.525),l(.429,-.722),l(.353,-.862),l(-.02,-.875),l(-.195,-1.649),l(-.146,-.14),l(-.504,.031),l(-.287,-.041),l(-.217,-.309),l(-.243,-.901),l(-.397,-.435),l(-.504,-.279),l(-.277,.044),l(-.306,.34),l(-.001,.127),l(-.624,-.081),l(-.73,-.179),l(-.657,-.081),l(-.3,-.055),l(-.102,-.056),l(.138,-.269),l(.354,-.454),l(-.046,-.38),l(-.716,-.715),l(-.455,-.392),l(-1.377,.84),l(-.377,.044),l(-.975,-.319),l(-.286,-.167),l(-.355,.087),l(-.546,.299),l(-1.105,.726),l(-.829,.258),l(-.543,.37),l(-1.123,1.107),l(-.397,.27),l(-.714,.216),l(-.784,.033),l(-.189,.1),l(-.329,-.619),l(-.312,-.209),l(-.371,-.041),l(-1.659,-.047),L(601,137.538),l(-.309,-.294),l(-.417,.016),l(-.149,.103),l(-.348,.239),l(-.609,.539),l(-1.251,1.545),l(-.212,-.662),l(.052,-.861),l(-.139,-.183),l(-.231,-.069),l(-.471,.102),l(-.345,.129),l(-.655,-.159),l(-.339,.281),l(-.341,-.116),l(-.849,.066),l(-.319,-.364),l(-.63,-.281),l(-.407,0),l(-.08,.331),l(-.271,.083),l(-.685,-.38),l(.01,.364),l(-.237,.099),l(-.141,-.463),l(-.54,-.496),l(-.365,.066),l(-.935,-.066),l(-.014,-.265),l(.175,-.396),l(-.326,-.017),l(-.333,.248),l(-1.451,-.893),l(.069,-.281),l(-.178,-.38),l(-.289,-.166),l(-.71,.116),l(-.158,.166),l(-.657,-.794),l(-.454,-.281),l(-.15,.132),l(-.472,-.215),l(-.726,-.595),l(-.867,-.264),l(-.132,-.612),l(-1.079,-.199),l(-.186,.182),l(-.275,-.066),l(-.134,.513),l(-.276,.314),l(-.299,-.05),l(-.24,-.43),l(-.859,-.596),l(-.154,.066),l(-.756,-.248),l(.116,-.364),l(-1.078,-.579),l(-.363,.116),l(-.772,-.843),l(-.383,-.248),l(-.477,.314),l(-.198,-.066),l(-.099,-.43),l(.215,-.215),l(-.272,-.364),l(.104,-.446),l(-.579,-.595),l(-.157,-.694),l(.785,-.198),l(.033,.364),l(.337,.264),l(.368,-.049),l(.376,-.281),l(.578,-.364),l(-.367,-.694),l(.104,-.414),l(-.68,-.099),l(-.044,-.182),l(-.092,-.078),l(-.718,-.096),l(-.294,-.221),l(-.037,-.552),l(-.073,-.589),l(.184,-.184),l(.331,-.221),l(-.221,-.258),l(-.441,-.405),l(-.81,-.11),l(-.221,-.515),l(-.441,-1.03),l(0,-.515),l(-.502,.152),l(-.147,-.126),l(-.305,-.111),l(-1.337,-.104),l(-.565,-.436),l(-.178,-.09),l(-.104,-.199),l(-.239,0),l(-.52,.196),l(-.252,-.281),l(-.198,-.218),l(-.301,-.07),l(.312,-.516),l(-.007,-.501),l(-.213,-.247),l(-.373,-.323),l(-.625,.009),l(-.282,.128),l(-.004,-.456),l(-.554,-.117),l(-.296,-.047),l(-.281,.21),l(-.105,-.112),l(-.313,-.14),l(-.048,-.088),l(-.236,-.012),l(-.01,-.269),l(.574,.059),l(.192,-.145),l(.354,-.136),l(.08,-.249),l(.181,-.185),l(-.2,-.163),l(.152,-.36),l(-.245,-.237),l(.126,-.428),l(-.049,-.123),l(-.152,-.012),l(-.028,-.246),l(.009,-.284),l(-.295,-.494),l(-.273,-.154),l(-.692,-.039),l(-.22,-.06),l(-.229,.162),l(-.463,.045),l(-.325,-.394),l(-.077,-.305),l(.207,-.223),l(-.023,-1.031),l(.011,-.069),l(.139,-.739),l(.129,-.213),l(.274,-.186),l(1.422,-.704),l(1.737,-.734),l(.359,-.03),l(.06,.071),l(.183,.567),l(.344,.055),l(.507,-.145),l(.885,-.132),l(.268,-.243),l(.463,-.784),l(.467,-.472),l(.238,-.03),l(1.248,.235),l(.459,-.017),l(.478,-.102),l(.646,-.345),l(.638,-.701),l(.405,-.301),l(.445,-.145),l(1.338,-.349),l(.97,-.219),l(.325,-.187),l(.051,-.157),l(-.031,-.194),l(-.139,-.86),l(.02,-.399),l(.32,-.401),l(.705,-.546),l(.222,-.33),l(-.119,-.47),l(-.29,-.441),l(-.345,-.627),l(-.03,-1.357),l(-.483,-.141),l(-.366,.06),l(-.232,-.185),l(.068,-.215),l(.215,-.302),l(.393,-.188),l(1.799,-.254),l(1.082,-.207),l(.35,-.06),l(.5,.184),l(1.133,.238),l(.394,-.074),l(.231,-.145),l(.156,-.245),l(-.126,-.286),l(-.622,-.514),l(.137,-.418),l(.286,-.605),l(.438,-.794),l(.516,-1.141),l(.427,-.507),l(1.096,.254),l(.721,.141),l(.594,.141),l(1.402,.079),l(.718,-.062),l(.417,-.103),l(.444,-.392),l(.157,-.39),l(-.213,-.707),l(-.097,-.75),l(.34,-.581),l(.428,-.277),l(1.199,-.093),l(.289,-.06),l(.306,-.219),l(.035,-.478),l(.011,-.275),l(.279,-.262),l(.542,-.148),l(.551,-.034),l(.228,-.014),l(.569,-.003),l(.244,-.074),l(.062,.145),l(.131,.405),l(.24,.563),l(.371,.433),l(1.301,.745),l(.834,.415),l(.614,.069),l(.731,.167),l(.633,.144),l(.354,.143),l(.568,.618),l(1.07,1.451),l(.401,.66),l(-.215,.447),l(-.237,.75),l(-.214,.389),l(-.369,.347),l(-.035,.129),l(.105,.43),l(.233,.229),l(.724,.312),l(1.062,.181),l(1.505,.021),l(.995,.038),l(.668,.083),l(.998,.224),l(.632,.268),l(1.645,.806),l(.839,.31),l(.744,.096),l(.105,.542),l(1.571,2.161),l(.467,.439),l(.444,.254),l(1.979,.018),l(1.241,.207),l(.802,.109),l(1.165,.022),l(2.861,-.059),l(.937,.023),l(1.164,.022),l(1.69,.119),l(.521,.168),l(.815,.551),l(1.006,.365),l(1.599,.433),l(.929,.123),l(.663,-.061),l(.61,.067),l(.253,.297),l(.433,.197),l(.481,-.017),l(.686,-.289),l(1.44,-.534),l(.303,-.101),l(.736,-.274),l(.816,-.289),l(1.204,-.349),l(1.339,-.007),l(1.514,-.065),l(.987,.08),l(.651,-.061),l(1.941,-.737),l(.265,-.172),l(1.111,-1.046),l(.67,-.389),l(1.265,-.292),l(.326,-.259),l(.123,-.271),l(-.188,-.228),l(-.599,-.411),l(-.389,-.569),l(-.003,-.343),l(.214,-.401),l(.539,-.589),l(.457,-.231),l(.316,-.073),l(.718,.154),l(.668,.382),l(.592,.125),l(.982,-.005),l(.744,-.047),l(.742,-.433),l(1.192,-.91),l(.224,.013),l(.438,.012),l(.624,.054),l(.896,-.134),l(.638,-.248),l(.347,-.188),l(.241,-.216),l(.312,-.82),l(.363,-.333),l(.47,-.204),l(.464,-.045),l(.483,.127),l(.353,-.189),l(.831,-.278),l(.539,-.146),l(.937,-.221),l(.854,-.033),l(.432,.099),l(1.074,.008),l(.464,.127),l(.414,-.218),l(.107,-.217),l(-.048,-.273),l(-.599,-.501),l(-.879,-.99),l(-.797,-.5),l(-.538,-.199),l(-.928,-.212),l(-.438,.002),l(-1.191,.786),l(-.292,-.07),l(-.431,-.416),l(-.317,-.085),l(-.576,.018),l(-.754,.062),l(-.929,.395),l(-.342,.045),l(-.051,-.029),l(-.269,-.836),l(.381,-.58),l(1.224,-1.959),l(.687,-1.207),l(.295,-.31),l(.046,.018),l(.452,.172),l(1.126,.574),l(.343,-.016),l(.438,-.089),l(2.44,-.752),l(.779,-.339),l(.123,-.233),l(-.056,-.306),l(-.35,-.348),l(-.062,-.146),l(.103,-.249),l(.422,-.426),l(.416,-.543),l(.667,-.779),l(.599,-.545),l(1.371,-.608),l(.167,-.794),l(-.107,-.249),l(-.465,-.306),l(-.558,-.026),l(-.822,.078),l(.119,-.25),l(.375,-.282),l(1.193,-.787),l(.478,-.165),l(.602,-.136),l(1.854,-.143),l(.836,-.123),l(1.203,-.109),l(.917,-.049),l(1.148,.215),l(1.037,.481),l(.683,.188),l(1.386,-.125),l(.539,.026),l(.763,.467),l(.742,.952),l(1.087,2.384),l(.94,1.588),l(.927,1.903),l(.436,.389),l(.507,.2),l(1.247,.341),l(1.523,.253),l(2.659,.839),l(.205,.144),l(.297,.866),l(.44,1.283),l(.261,.446),l(.68,-.033),l(.649,-.018),l(1.657,-.052),l(.604,-.22),l(.953,-.308),l(1.357,-.31),l(1.181,-.208),l(.902,-.034),l(.246,.114),l(.064,.259),l(.116,.389),l(.017,.504),l(-.566,.407),l(-.66,.393),l(-.291,.707),l(-.278,.893),l(-.538,1.066),l(-.627,1.08),l(-.329,.432),l(-.551,.69),l(-.47,.347),l(-.547,-.098),l(-.679,-.225),l(-.685,-.24),l(-.396,-.041),l(-1.664,.982),l(-.048,.557),l(.332,.897),l(.062,.656),l(-.006,.613),l(-.025,.385),l(-.097,.128),l(.112,.299),l(-.156,.329),l(-.511,.43),l(-1.252,.462),l(-.111,.058),l(-.579,-.68),l(-.247,.001),l(-.253,.129),l(-.383,.358),l(-.23,.713),l(-.955,.532),l(-.62,.259),l(-.538,.017),l(-.452,-.054),l(-.333,-.126),l(-.392,.059),l(-.273,.243),l(-.025,.342),l(.508,.765),l(.046,.113),l(-.527,.159),l(-.975,.048),l(-.508,-.153),l(-.493,-.253),l(-.273,-.396),l(-.448,.017),l(-.386,.13),l(-.686,1.027),l(-.636,.543),l(-1.032,.545),l(-1.533,.604),l(-.52,.329),l(-.415,.442),l(-.379,.528),l(-.066,-.092),l(-.417,.171),l(-1.222,.13),l(-.728,.171),l(-2.248,.925),l(-.632,.37),l(-.566,.469),l(-.604,.271),l(-.336,.015),l(.13,-.255),l(.862,-.682),l(.33,-.354),l(-.47,-.113),l(-.37,.072),l(-.153,-.297),l(.058,-.156),l(.953,-.781),l(.269,-.384),l(.55,-.413),l(.159,-.2),l(-.057,-.298),l(-.73,-.553),l(-.727,-.283),l(-.131,-.014),l(-.628,.03),l(-.166,.015),l(-.494,.371),l(-1.146,1.183),l(-.355,.157),l(-.643,.086),l(-.613,.243),l(-.36,.199),L(665.49,112),l(-.136,.411),l(-.131,.255),l(-.251,.255),l(-.437,.128),l(-.493,-.013),l(-.326,.27),l(-.307,.114),l(-.455,-.565),l(-.355,-.014),l(-.349,.128),l(-.396,.638),l(-.301,.694),l(.088,.34),l(.245,.368),l(.558,.268),l(.8,.268),l(1.21,-.045),l(.29,.254),l(-.019,.538),l(-.123,.581),l(.057,.538),l(.261,.283),l(.733,.069),l(.698,-.157),l(.76,-.525),l(.509,-.497),l(.552,-.228),l(.534,-.128),l(.287,.07),l(.895,.621),l(.543,.197),l(1.023,-.087),l(.361,.027),l(.471,.141),l(.274,0),l(-.248,.708),l(-.057,.552),l(-.612,-.197),l(-.297,-.084),l(-.525,.058),l(-1.677,.555),l(-.707,.44),l(-.072,.735),l(-.522,.157),l(-.146,-.113),l(-.017,-.269),l(-.127,-.084),l(-.501,.114),l(.138,.466),l(-.152,.368),l(-.485,.496),l(-1.397,1.119),l(-.126,.226),l(.039,.55),l(.62,.225),l(.712,.492),l(.785,.521),l(.391,.535),l(.424,1.241),l(.668,.647),l(.175,.437),l(-.13,.677),l(.172,.183),l(.694,.295),l(.399,.592),l(.562,.253),l(.272,.268),l(.087,.31),l(-.049,.155),l(-.789,.369),l(.088,.07),l(.425,.31),l(.314,.79),l(-.019,.296),l(-.141,.184),l(-.534,.043),l(-.651,.213),l(-.948,.552),l(-.849,.213),l(-.629,.297),l(.72,.21),l(.378,.056),l(.944,-.425),l(.488,-.058),l(.162,.056),l(.524,.592),l(.387,.168),l(.456,.027),l(.009,.155),l(-.231,.311),l(-.382,.227),l(-.304,.241),l(.11,.155),l(.326,-.029),l(.202,.084),l(-.184,.325),l(-.298,.749),l(-.192,.649),l(.028,.353),l(-.22,.452),l(-.209,.127),l(-.35,-.338),l(-.146,.142),l(-.569,.763),l(-.401,.622),l(-.215,.622),l(-.127,.296),l(-.595,.425),l(-.251,.438),l(-.254,.184),l(-.569,.029),l(-.382,.227),l(.279,.719),l(-.264,.508),l(.076,.593),l(-.093,.269),l(-.207,.269),l(-.532,.199),l(-.161,.282),l(-.174,.396),l(-.294,.636),l(-.626,.354),l(-.412,.495),l(-.492,-.14),l(-.443,-.069),l(-.142,.113),l(-.145,.198),l(.118,.833),l(-.213,.142),l(-.772,.651),l(-.356,.127),l(-.628,.171),l(-.563,.467),l(-.571,.213),l(-.107,.113),l(-.008,.48),l(-.133,.156),l(-.568,.058),l(-.5,.114),l(-.341,.438),l(-.364,-.126),l(-.52,-.168),l(-.274,.057),l(-.315,.326),l(-.435,.198),l(-.643,.1),l(-.047,-.465),l(-.52,.057),l(-.699,.213),l(-.32,.198),l(-.285,-.042),l(-.401,-.493),l(-.163,-.155),l(-.191,.283),l(.095,.169),l(-.045,.212),l(-.047,.691),l(-.209,.297),l(-.416,.114),l(-.501,-.182),l(-.123,.282),l(-.001,.24),l(-.146,.155),l(-.615,.058),l(-.366,.114),l(-.596,.043),l(-.463,-.211),l(-.217,.1),l(-.439,.48),l(-.227,.071),l(-.774,-.041),l(-.747,.227),l(-.406,.326),l(-.451,-.027),l(-.277,-.084),l(-.011,.057),l(-.069,.353),l(-.29,.396),l(.011,.113),l(.48,.634),l(.269,.126),l(.043,.198),l(-.36,.269),l(-.763,.157),l(-.481,-.719),l(-.241,-.691),l(.012,-.395),l(.396,-.777),l(-.015,-.169),l(-.587,-.253),l(-.226,.071),l(-.206,.297),l(-.454,.072),l(-.676,-.21),l(-.574,-.733),l(-.196,.085),l(-.017,.169),l(-.159,.396),l(-.27,.128),l(-.332,-.056),l(-.481,.043),l(-.055,.038),l(-.197,-.143),l(-.909,-.107),l(-.621,-.166),l(-.943,-.615),l(-.273,-.365),l(-.096,-.521),l(.472,-.75),l(-.056,-.38),l(-.237,-.21),l(-.777,.047),l(-.66,-.053),l(-.771,-.235),l(-.623,-.575),l(-.298,.101),l(-.521,.328),l(-.696,.554),l(-.341,.157),l(-.807,.117),l(-1.595,.052),l(-.332,.115),l(-.584,.413),l(-.325,-.097),l(-.597,-.392),l(-.341,-.012),l(-.515,.13),l(-.483,.229),
N(241.073,156.152),l(.017,.52),l(.098,1.215),l(.012,.212),l(-.379,.455),l(-.011,.17),l(.485,1.358),l(-.669,-.577),l(-.445,-.056),l(-.761,.143),l(-.877,-.012),l(-.666,-.14),l(-.574,-.056),l(-.474,.1),l(-.378,.354),l(-.135,-.042),l(-.993,-.549),l(-.171,-.325),l(.04,-.198),l(.269,-.184),l(1.051,.097),l(.631,.111),l(1.125,.167),l(.654,.041),l(.61,-.185),l(.386,-.156),l(-.198,-.155),l(-.692,-.464),l(-.136,-.296),l(.184,-.707),l(-.202,-.296),l(-.394,-.154),l(-.913,-.14),l(-.305,-.211),l(.04,-.184),l(.119,-.085),l(.344,-.1),l(.724,-.058),l(.781,.125),l(1.081,.294),l(.576,.056),l(.147,-.089),
N(241.295,160.082),l(-.485,-1.358),l(.011,-.17),l(.379,-.455),l(-.012,-.212),l(-.098,-1.215),l(-.017,-.52),l(.503,-.279),l(.393,.14),l(.342,0),l(.384,-.17),l(.369,-.043),l(.14,.198),l(.177,.112),l(1,.309),l(.657,-.072),l(.213,.395),l(.335,.338),l(.528,.324),l(.335,.084),l(.643,.21),l(.916,.45),l(.399,.352),l(.231,.311),l(-.191,.17),l(-.144,.297),l(-.314,.368),l(-.238,-.098),l(-.476,-.592),l(-.378,-.042),l(-.788,.058),l(-.288,-.098),l(-.373,0),l(-.329,.1),l(-.763,.539),l(-.396,-.056),l(-.319,-.494),l(-.166,-.028),l(-.155,.057),l(-.658,.326),l(-.344,.778),l(-.41,.65),l(-.289,-.112),l(-.325,-.551),
N(668.053,167.796),l(-.131,-.099),l(-.74,-.732),l(-.444,-1.255),l(.037,-.424),l(.054,-.706),l(-.292,-.465),l(.18,-.382),l(.978,.704),l(.202,-.424),l(.023,-.41),l(-.101,-.438),l(-.026,-.579),l(.145,-.438),l(.025,-.664),l(.082,-.861),l(.074,-.636),l(.38,-.862),l(.188,-.127),l(.337,-.142),l(.523,.055),l(1.21,.52),l(.576,.042),l(.188,-.212),l(.277,-.17),l(.199,.141),l(.018,.396),l(-.266,.438),l(-.045,.48),l(.14,.79),l(.541,.394),l(.182,.325),l(-.427,1.271),l(-.31,.467),l(-.834,.608),l(-.555,.312),l(-.082,.099),l(.003,.268),l(-.078,.565),l(-.28,.424),l(.127,.211),l(.35,.733),l(.345,1.101),l(.26,.62),l(.093,.028),l(.451,.324),l(.296,.07),l(.161,-.325),l(.485,-.537),l(.197,-.029),l(.418,.112),l(.226,.211),l(.179,.635),l(.286,.353),l(.326,.084),l(.505,-.58),l(.621,.267),l(.141,.028),l(.078,.127),l(-.168,.156),l(-.378,.156),l(-.208,.212),l(.936,1.226),l(-.315,.184),l(-.568,-.196),l(-.404,-.098),l(-.094,-.48),l(-.229,-.31),l(-.599,-.535),l(-.753,-.577),l(-.258,0),l(-.099,.226),l(.371,.776),l(-.218,.283),l(-.727,-.775),l(-.982,-.548),l(-.309,.015),l(-.344,.142),l(-.182,.255),l(-.14,.071),l(-.395,.057),l(-.322,-.225),l(-.591,-.366),l(-.195,-.423),l(.64,-.608),l(.323,.211),l(.358,.084),l(.4,-.199),l(-.151,-.169),l(-.713,-.295),l(-.422,-.395),l(-.522,-.168),l(-.239,.607),M(669.676,172.974),l(-.452,-.366),l(-.349,-.408),l(-.051,-.226),l(-.364,-1.114),l(-.459,-.521),l(.685,-.058),l(.868,.012),l(.314,.169),l(.274,.451),l(.028,.861),l(-.097,.48),l(-.214,.283),l(-.185,.438),M(679.073,175.368),l(-.562,-.267),l(-.178,-.254),l(-.237,-.169),l(-.064,-.127),l(.139,-.339),l(-.091,-.423),l(-.55,-.352),l(-.662,-.479),l(-.147,-.466),l(.513,-.1),l(1.017,-.143),l(.371,.112),l(.283,.409),l(.069,.818),l(.123,.805),l(.257,.79),l(-.112,.127),l(-.167,.057),M(671.406,176.824),l(.022,-.353),l(.186,-1.342),l(.061,-1.172),l(.482,.395),l(.576,.281),l(.366,.028),l(.634,-.185),l(.027,.438),l(-.079,.396),l(-.24,.269),l(-.184,.198),l(-.908,.651),l(-.943,.397),M(664.721,177.812),l(-.366,-.027),l(.127,-.297),l(.202,-.099),l(.314,-.396),l(.265,-.523),l(.082,-.607),l(.138,-.509),l(.326,-.184),l(.14,.183),l(-.16,.283),l(.276,.55),l(.212,.564),l(-.108,.113),l(-.664,.354),l(-.406,.368),l(-.377,.227),M(673.781,179.981),l(-.385,-.366),l(-.828,-.591),l(-.206,-.38),l(.099,-.368),l(.565,-.213),l(.22,-.269),l(.487,-1.822),l(.438,-.185),l(.271,.028),l(.113,.126),l(.049,.282),l(-.373,.905),l(-.089,.226),l(-.315,1.413),l(.165,.296),l(.214,.465),l(-.213,.41),l(-.212,.043),M(661.179,181.308),l(-.317,-.042),l(.215,-.48),l(.343,-.467),l(.35,-.34),l(.592,-.354),l(.636,-.496),l(.933,-1.089),l(.11,.55),l(-.118,.424),l(-.267,.297),l(-.24,.184),l(-.516,.213),l(-.172,.127),l(-.244,.622),l(-.327,.269),l(-.591,.171),l(-.386,.41),M(680.678,185.402),l(-.201,-.098),l(-.098,-.438),l(-.361,-.748),l(-.297,-.112),l(-.381,.608),l(-.361,.82),l(.246,.38),l(.166,.395),l(.148,.677),l(-.158,.495),l(-.383,.509),l(-.305,-.253),l(-.176,-.268),l(.201,-.41),l(-.076,-.325),l(-.363,-.07),l(-.361,.665),l(-.173,-.056),l(-1.114,-.619),l(-.557,-.549),l(-.206,-.508),l(-.037,-.635),l(.466,-.905),l(-.108,-.479),l(-.466,-.409),l(-.778,-.295),l(-.292,.043),l(-.062,.17),l(-.129,.226),l(-.5,.255),l(-.661,.058),l(-.027,-.494),l(-.174,-.24),l(-.399,.199),l(-.504,.961),l(-.525,.863),l(-.219,-.084),l(-.119,-.127),l(-.034,-.197),l(.054,-.311),l(.359,-.749),l(.185,-.537),l(.263,-.283),l(.383,-.184),l(.564,-.044),l(.219,-.127),l(.134,-.466),l(.205,-.156),l(.549,-.241),l(.777,-.101),l(.292,.353),l(.102,.72),l(.317,-.156),l(.485,-.058),l(.207,-.184),l(.207,-.565),l(.358,-.255),l(.479,.21),l(.186,.084),l(.158,-1.087),l(.29,-.015),l(.264,.465),l(.315,-.481),l(.205,-.142),l(.392,.098),l(.133,-.227),l(-.048,-.706),l(-.172,-.564),l(.146,-.353),l(.413,.549),l(.711,.803),l(.229,.48),l(.083,.324),l(-.336,.735),l(.237,.226),l(.537,-.1),l(.076,.423),l(-.114,.424),l(.056,.692),l(.207,.437),l(-.002,.438),l(-.111,.424),l(-.283,.579),l(-.332,.622),
N(251.898,160.229),l(-.547,-.112),l(-.073,-.212),l(.051,-.551),l(-.109,-.24),l(.11,-.17),l(.235,-.071),l(.543,.069),l(.404,-.015),l(1.505,.11),l(.393,.168),l(.113,.141),l(-.188,.354),l(-.07,.099),l(-.283,.227),l(-.335,.043),l(-.739,-.083),l(-.657,.072),l(-.354,.17),
N(228.82,160.519),l(-.299,-.056),l(-.693,-.224),l(-.229,-.268),l(-.47,-.366),l(-.465,-.084),l(-.142,-.211),l(.53,-.284),l(.704,-.072),l(1.364,.251),l(.97,.351),l(.651,.267),l(.279,.282),l(-.04,.198),l(-.332,.071),l(-.751,-.295),l(-.543,.058),l(-.227,.255),l(-.308,.128),
N(400.72,175.499),l(-.595,-.119),l(-.161,-.032),l(-.976,.458),l(-1.429,-.006),l(-.867,-.037),l(-2.119,.041),l(-.271,.157),l(-.125,.34),l(.261,1.934),l(.02,.41),l(-.191,.17),l(-.63,-.434),l(-.644,-.166),l(-.769,.075),l(-.608,.159),l(-.446,.257),l(-.368,.115),l(-.354,-.083),l(-.452,-.223),l(-.52,-.562),l(-.15,-.465),l(-.308,-.252),l(-.545,.003),l(-.259,-.168),l(.08,-.043),l(.046,-.156),l(.172,-.326),l(.261,-.92),l(.133,-.876),l(-.058,-.749),l(.141,-.255),l(.257,-.016),l(.448,-.158),l(.543,-.271),l(.317,-.369),l(.292,-1.047),l(.355,-1.217),l(.397,-.384),l(.273,-.058),l(.293,.281),l(.551,.364),l(.45,-.102),l(.174,-.227),l(.393,-.822),l(.492,-.667),l(.638,-.625),l(.272,-.101),l(.518,.209),l(.324,.182),l(.274,.027),l(.314,-.793),l(.304,-.228),l(.947,-.458),l(1.22,-.713),l(.37,-.073),l(.356,.125),l(.36,.059),l(1.062,.173),l(-.173,.665),l(.019,.396),l(.426,.93),l(.422,.492),l(.389,.266),l(.502,.42),l(.179,.268),l(.018,.212),l(-.335,.439),l(.114,.226),l(.97,.757),l(.516,.181),l(.37,-.044),l(.562,.025),l(.568,.971),l(.131,.367),l(-.237,.764),l(-.415,.468),l(-.337,.158),l(-.739,-.095),l(-.418,.045),l(-.415,.271),l(-.366,.553),l(-.24,.157),l(-.062,.142),l(-.29,-.041),l(-.611,-.166),l(-1.013,-.163),
N(209.823,175.47),l(-.388,-.645),l(-.932,-.888),l(-1.003,-1.085),l(-.837,-.817),l(-.723,-.464),l(-.196,-.183),l(-.023,-.226),l(.625,-.03),l(1.001,-.125),l(.29,-.143),l(.293,-.412),l(.005,-.961),l(.882,-.034),l(.513,-.583),l(.725,.42),l(1.207,-.997),l(.503,-.794),l(.294,-.242),l(.259,.013),l(.328,.182),l(.463,.097),l(.248,-.086),l(.424,-.229),l(1.425,-.486),l(.23,.519),l(.038,.339),l(-.057,.509),l(-.214,.707),l(-.543,.806),l(-.1,.749),l(.042,.904),l(-.245,1.13),l(-.188,.735),l(-.101,1.385),l(.031,.55),l(.184,.466),l(.188,.363),l(-.281,.274),l(-.767,-.149),l(-.241,-.46),l(-.285,.077),l(-.394,-.107),l(-.603,.25),l(-1.651,-.599),l(-.43,.271),
N(634.036,168.444),l(.533,.251),l(.736,.165),l(.341,.111),l(.469,.251),l(.248,-.058),l(.095,-.24),l(-.103,-.211),l(-.187,-.182),l(-.107,-.296),l(.392,-.285),l(.476,-.186),l(.444,.181),l(.373,.351),l(.3,-.072),l(.975,-.429),l(.209,-.114),l(-.215,.905),l(.029,.663),l(.455,1.014),l(-.076,.367),l(-.05,.424),l(.054,1.073),l(-.217,.509),l(-.385,.285),l(-.599,.187),l(-.932,.443),l(-.521,.229),l(-.99,.571),l(-.234,.425),l(.216,.422),l(.568,.435),l(.03,.197),l(-.17,.27),l(-.688,-.194),l(-.497,-.011),l(-.599,.229),l(-.915,.528),l(-.646,.229),l(-.3,.289),l(-.256,-.188),l(-.248,-.268),l(-.35,-.042),l(-.382,.142),l(-.205,-.042),l(-.293,.043),l(-.183,-.113),l(.142,-.311),l(.182,-.226),l(-.04,-.254),l(-.283,-.395),l(-.277,.043),l(-.462,.298),l(-.339,.015),l(-.171,-1.044),l(-.649,-1.488),l(.146,-.176),l(-.16,-.479),l(-.487,-.717),l(-.219,-.648),l(-.026,-.635),l(.076,-.382),l(.146,-.297),l(.92,-1.233),l(.521,-.441),l(.383,-.101),l(1.172,-.091),l(.798,.066),l(.558,-.074),l(.575,.039),l(.599,.109),l(.301,.167),
N(214.474,175.913),l(.821,.884),l(.385,.623),l(.314,.322),l(.225,.046),l(.465,.645),l(.441,.352),l(-.014,.006),l(-.074,.123),l(-.478,-.184),l(-.219,.205),l(-.014,.321),l(0,.58),l(.507,.307),l(-.396,.368),l(.125,.532),l(-.374,.369),l(.243,.184),l(-.204,.609),l(.003,-.466),l(-.296,-.307),l(.01,-.568),l(-.377,-.148),l(-.238,-.102),l(-.111,.082),l(.325,.41),l(.084,.225),l(-.113,.062),l(-.726,-.299),l(-.13,-.282),l(.251,-.339),l(.04,-.382),l(-.182,-.338),l(-.486,-.324),l(-.695,-.287),l(-.079,-.144),l(-.689,-.103),l(-.316,-.327),l(.007,-.421),l(-.146,-.255),l(-.249,-.098),l(-.576,-.353),l(-.416,-.266),l(.225,.512),l(.086,.222),l(.422,.044),l(.181,.266),l(-.544,.573),l(-.144,-.262),l(-.356,-.282),l(-.561,-.211),l(-.323,-.239),l(-.147,-.24),l(-.104,-.494),l(.128,-.421),l(.332,-.225),l(-.008,-.389),l(-.554,-.225),l(.363,-.123),l(-.057,-.227),l(-.238,.017),l(.43,-.271),l(1.651,.599),l(.603,-.25),l(.394,.107),l(.285,-.077),l(.241,.46),l(.767,.149),l(.281,-.274),
N(436.304,195.359),l(-.209,-.451),l(-.194,-.804),l(-.498,-.802),l(-1.217,-1.236),l(-.112,-.324),l(-.064,-.791),l(-.432,-.605),l(-.4,-.661),l(-.207,-.592),l(-.273,-1.185),l(-.112,-.776),l(.064,-.424),l(.144,-.198),l(.528,-.399),l(.4,-.511),l(.866,-1.743),l(.354,-.327),l(.208,-.114),l(.096,.084),l(.24,.027),l(.449,-.158),l(1.363,-.686),l(.494,.661),l(.225,.069),l(.224,-.03),l(.466,-.271),l(.754,-.386),l(.818,-.273),l(.881,.009),l(.368,-.031),l(.258,-.143),l(.646,-1.176),l(.117,-.806),l(.209,-.199),l(.434,-.059),l(2.181,-.055),l(.386,-.087),l(2.649,-2.275),l(.196,-.284),l(.005,-.41),l(.165,-.382),l(.372,-.228),l(.939,-.613),l(.322,-.086),l(.321,.012),l(.559,.208),l(1.342,1.673),l(.347,.549),l(.122,.536),l(-.416,1.472),l(.01,.664),l(.158,.211),l(.802,-.019),l(.272,-.001),l(.207,.126),l(.252,.493),l(.223,.225),l(.797,.447),l(.799,.235),l(.351,.196),l(.223,.267),l(-.148,.481),l(.173,.395),l(.445,.351),l(.558,.378),l(.717,.434),l(.207,.168),l(.206,.366),l(.059,.72),l(.285,.436),l(.367,.224),l(.814,.165),l(.558,.477),l(.157,.352),l(-.083,.679),l(.031,.07),l(-.496,.145),l(-.962,.344),l(-.319,-.026),l(-.287,-.167),l(-.687,-.264),l(-1.15,-.361),l(-.4,.13),l(-.082,.551),l(-.13,.241),l(-.256,.058),l(-.399,-.026),l(-.862,-.207),l(-.593,.102),l(-.93,.373),l(-.93,.486),l(-.271,.016),l(-.559,-.35),l(-.383,-.153),l(-.353,.186),l(-.677,1.36),l(-.176,.157),l(-.591,-.067),l(-1.934,-.511),l(-1.422,-.189),l(-.512,-.322),l(-.159,-.239),l(-.334,-.394),l(-.75,-.518),l(-.432,-.167),l(-.479,.06),l(-.529,.3),l(-.353,.341),l(-.785,.979),l(-.097,.297),l(.096,.452),l(-.017,.353),l(-.063,.594),l(-.16,.058),l(-.751,.287),l(-.895,-.093),l(-.624,-.138),l(-.367,-.054),l(-.975,.175),l(-.479,.102),l(-.255,.228),l(-.222,1.287),l(-.158,.523),l(-.365,.497),l(-.303,.312),
N(371.324,180.419),l(1.088,-1.235),l(.643,-.866),l(.238,-.157),l(.594,.039),l(1.137,-.148),l(.466,.04),l(.42,.224),l(.456,.421),l(.475,.619),l(.252,.761),l(.165,1.369),l(.26,.656),l(-.259,.502),l(-1.184,1.151),l(-.63,.724),l(-.285,.256),l(-.061,.103),l(-.631,-.523),l(-.661,-.408),l(-.483,-.196),l(-.033,-.141),l(.061,-.297),l(-.05,-.184),l(-.531,-.21),l(-.792,-.549),l(-.389,-.366),l(-.375,-.465),l(.494,-.241),l(.174,-.227),l(-.034,-.155),l(-.484,-.211),l(-.065,-.113),l(.022,-.173),
N(579.606,186.906),l(-.493,-.083),l(-.265,-.197),l(-.21,-.353),l(-.246,-.621),l(-.361,-1.256),l(-.034,-.649),l(.005,-.763),l(-.02,-.904),l(-.24,-.696),l(.188,-.513),l(-.298,-.35),l(.068,-.28),l(.423,.023),l(.349,-.43),l(.053,-.367),l(.226,-.369),l(-.152,-.537),l(.529,.48),l(.699,.38),l(.234,.395),l(.549,.776),l(.175,.324),l(-.099,.339),l(.024,.141),l(.592,.338),l(.266,.733),l(.798,1.368),l(.136,.508),l(-.193,.735),l(-.397,.679),l(-.369,.396),l(-.514,.425),l(-.78,.284),l(-.642,.043),
N(217.111,178.792),l(.52,.307),l(.195,.512),l(.02,.374),l(.363,.155),l(.628,.024),l(.244,-.205),l(.398,.43),l(.726,.082),l(.458,-.083),l(1.348,-.751),l(.514,-.046),l(1.387,-.921),l(.373,.144),l(.742,.069),l(.071,.156),l(.789,-.017),l(.767,.21),l(.666,.38),l(.644,.563),l(.406,.666),l(.084,.327),l(.228,.149),l(.509,1.038),l(-.322,.062),l(-.094,.43),l(-.584,.409),l(-.085,-.307),l(-.19,-.082),l(.045,.45),l(-.228,.082),l(-.256,.753),l(-.378,-.825),l(-.441,-.762),l(-.137,-.452),l(.179,-.24),l(.22,-.085),l(.786,.125),l(-.336,-.193),l(-.125,-.164),l(-.096,-.471),l(-.309,.307),l(-.439,.041),l(-.244,-.378),l(-.031,-.269),l(-.193,-.282),l(-.132,.151),l(-.226,-.287),l(-.11,.102),l(-.132,-.266),l(-.456,-.192),l(-.562,-.013),l(-.499,.241),l(-.382,.108),l(-.07,.359),l(.081,.234),l(-.529,.318),l(-.374,.184),l(-.335,.029),l(-.345,.41),l(.049,.296),l(.316,.297),l(.464,.43),l(.178,.386),l(-.011,.146),l(-.281,.081),l(-.243,-.042),l(-.431,.391),l(-.568,.105),l(-.339,-.042),l(-.189,-.146),l(.108,-.164),l(-.349,-.833),l(-.244,-.353),l(-.177,.674),l(-.812,-.409),l(-.227,-.757),l(-.207,.041),l(-.96,-.123),l(-.434,-.266),l(-.599,0),l(-.314,.113),l(-.361,.495),l(.204,-.609),l(-.243,-.184),l(.374,-.369),l(-.125,-.532),l(.396,-.368),l(-.507,-.307),l(0,-.58),l(.014,-.321),l(.219,-.205),l(.478,.184),l(.074,-.123),
N(266.015,188.956),l(-.503,-.647),l(-.732,-.745),l(-.324,-.521),l(.071,-.212),l(.395,-.539),l(-.008,-.58),l(.061,-.452),l(1.032,-.19),l(.41,-.144),l(.308,-.299),l(-.141,-.282),l(-.62,-.604),l(-.074,-.212),l(.101,-.255),l(1.655,-1.239),l(.061,-.41),l(-.095,-.296),l(.072,.049),l(.496,.338),l(.856,.521),l(.695,.521),l(.587,.663),l(.128,.409),l(-.036,.734),l(.148,.945),l(.298,-.593),l(.22,-.099),l(.6,.182),l(.101,.127),l(.507,.295),l(.708,.549),l(.401,.493),l(.374,.649),l(-.015,.339),l(-.142,.496),l(-.082,.862),l(-.183,.27),l(-1.131,.091),l(-.169,.17),l(.078,.777),l(-.095,.467),l(-.328,.694),l(.571,.831),l(.532,.675),l(.561,.067),l(.185,.295),l(.246,.832),l(.49,1.127),l(.332,.563),l(-.06,.212),l(-.943,-.022),l(-.934,.429),l(-1,.331),l(-.505,.314),l(-.694,.513),l(-.686,.075),l(-.613,-.392),l(-1.103,-.897),l(-.15,-.296),l(-.008,-.396),l(.072,-.354),l(-.167,-.31),l(-.281,-.394),l(-.156,-.465),l(.213,-.962),l(.547,-1.416),l(.179,-.368),l(-.435,-.958),l(-.533,-.138),l(-.304,.001),l(.452,-1.09),l(-.04,-.212),l(-.26,-.111),l(-.516,-.124),l(-.302,.058),l(-.375,.257),
N(377.518,182.142),l(.193,-.376),l(.252,-.242),l(.367,-.143),l(.528,-.046),l(.338,.097),l(.165,.366),l(.22,.846),l(.009,.65),l(-.044,.283),l(.277,.323),l(.404,.322),l(.321,.026),l(.756,-.922),l(.143,-.086),l(.337,.097),l(.339,.224),l(-.062,.17),l(.119,.55),l(-.059,.438),l(-.501,.865),l(.05,.183),l(.194,.183),l(.369,.097),l(.592,-.032),l(1.264,1.334),l(.131,.282),l(-.059,.452),l(-.247,.849),l(-.105,.565),l(-.041,.919),l(-1.513,-.643),l(-1.221,-.619),l(-1.012,-.562),l(-.403,-.423),l(-1.129,-1.113),l(-1.111,-.76),l(-.723,-.337),l(-.901,-.535),l(-.66,-.548),l(.061,-.103),l(.285,-.256),l(.63,-.724),l(1.184,-1.151),l(.259,-.502),
N(429.505,210.684),l(.484,.336),l(.177,.013),l(.443,-.271),l(.327,-.581),l(1.495,-.532),l(.054,.424),l(.042,.664),l(.147,.211),l(.57,-.328),l(.554,-.399),l(.931,-.811),l(.364,-.229),l(1.025,-.938),l(.086,-.706),l(-.122,-.72),l(.074,-.396),l(.193,-1.159),l(.343,-.751),l(.47,-.836),l(.41,-.454),l(.809,-.599),l(.525,-.229),l(.459,-.427),l(.139,-.523),l(.169,-.708),l(.115,-.61),l(.254,-1.342),l(.196,-2.021),l(.156,-.764),l(.094,-.551),l(.349,-.821),l(.558,-.837),l(.398,-1.203),l(.031,-.156),l(-.128,-.197),l(.16,-.058),l(.063,-.594),l(.017,-.353),l(-.096,-.452),l(.097,-.297),l(.785,-.979),l(.353,-.341),l(.529,-.3),l(.479,-.06),l(.432,.167),l(.75,.518),l(.334,.394),l(.159,.239),l(.512,.322),l(1.422,.189),l(1.934,.511),l(.591,.067),l(.176,-.157),l(.677,-1.36),l(.353,-.186),l(.383,.153),l(.559,.35),l(.271,-.016),l(.93,-.486),l(.93,-.373),l(.593,-.102),l(.862,.207),l(.399,.026),l(.256,-.058),l(.13,-.241),l(.082,-.551),l(.4,-.13),l(1.15,.361),l(.687,.264),l(.287,.167),l(.319,.026),l(.962,-.344),l(.496,-.145),l(.143,.239),l(.795,.772),l(.348,.493),l(.525,.477),l(.366,.195),l(.352,-.016),l(.258,-.242),l(.529,-.37),l(.384,.012),l(.684,.631),l(.16,-.1),l(.436,-.582),l(.258,-.157),l(.207,.083),l(1.032,.926),l(1.288,1.32),l(.063,.028),l(.159,.183),l(-.018,.424),l(-.26,1.88),l(.128,.253),l(.191,.027),l(.479,.04),l(.271,.182),l(.111,.31),l(-.191,.453),l(-1.195,1.066),l(-1.241,.996),l(-.255,.284),l(-.395,.681),l(-.217,1.02),l(-.107,.507),l(.021,.593),l(-.025,.734),l(.057,.748),l(-.076,.27),l(-.188,.298),l(-.426,.412),l(-.301,.171),l(-.269,.256),l(-.122,.425),l(-.49,1.358),l(.197,.338),l(.689,.999),l(.087,.381),l(-.04,.438),l(.014,.636),l(.237,.634),l(.017,1.329),l(-.064,.762),l(.425,1.439),l(-.102,.848),l(.122,.693),l(.486,.631),l(.936,.898),l(.428,.78),l(.689,1.804),l(-.563,.068),l(-3.015,.499),l(-.347,.214),l(-.154,.198),l(-.797,1.276),l(-.029,.622),l(.372,2.088),l(-.377,1.175),l(-.3,1.02),l(.043,.296),l(.456,.605),l(.837,.843),l(.445,.279),l(.515,.012),l(.448,-.455),l(.362,-.186),l(.136,.183),l(.032,.791),l(.028,1.427),l(-.041,.551),l(-.371,-.012),l(-1.355,-.091),l(-.348,-.21),l(-.381,-.647),l(-.561,-.731),l(-.416,-.351),l(-.477,-.252),l(-.895,-.263),l(-.38,-.28),l(-.728,-1.423),l(-.212,.354),l(-.522,.682),l(-.366,.087),l(-.325,-.111),l(-.922,-.164),l(-.925,-.249),l(-.489,-.194),l(-.58,-1.014),l(-.175,.071),l(-1.146,.289),l(-.195,-.056),l(-.172,-.352),l(-.365,-.379),l(-.678,-.096),l(-1.24,-.147),l(-.991,.146),l(-.859,.26),l(-.61,.004),l(-.199,-.197),l(-.007,-.254),l(.198,-.905),l(.003,-.466),l(-.306,-.62),l(-.844,-.998),l(-.117,-.211),l(-.021,-.212),l(.296,-1.033),l(.07,-1.06),l(-.109,-.607),l(-.303,-.605),l(.057,-.354),l(.177,-.693),l(-.052,-.183),l(-.322,-.098),l(-1.231,.093),l(-.88,.019),l(-.212,-.168),l(.055,-.48),l(-.181,-.225),l(-2.016,.082),l(-.112,.001),l(-.089,.354),l(.027,.593),l(-.286,.892),l(-.184,.411),l(-.993,.006),l(-.899,-.122),l(-1.021,.246),l(-.88,.034),l(-.292,-.168),l(-.64,-.787),l(-.597,-1.07),l(-.537,-1.409),l(-.059,-.579),l(-.121,-.521),l(-.082,-.127),l(-.321,-.111),l(-.385,-.012),l(-1.104,-.008),l(-.88,.034),l(-.624,.003),l(-1.312,-.048),l(-.945,-.052),l(-.783,.02),l(-.432,.03),l(-.318,.101),l(-.896,.062),l(-.699,.314),l(-.56,.06),l(-.112,-.013),l(-.322,-.922),l(.012,-.053),l(.74,-.3),l(-.017,-.085),l(.1,-.89),l(.094,-.143),l(.317,-.199),l(.583,-.568),
N(468.568,202.653),l(1.277,-.05),l(4.659,0),l(1.448,-.033),l(4.663,2.568),l(3.553,1.984),l(.137,.381),l(-.116,.552),l(.07,.239),l(2.427,1.752),l(1.067,.807),l(-.237,.427),l(-.419,1.329),l(-.137,1.017),l(.109,.551),l(.665,.987),l(.768,.577),l(-.024,.282),l(-.263,.354),l(-.371,1.046),l(.037,.17),l(.306,.041),l(.118,.226),l(-.172,.692),l(-.019,.946),l(.411,1.793),l(.18,.564),l(.401,.465),l(.823,.55),l(.396,.268),l(.177,.228),l(-1.157,.836),l(-.515,.342),l(-1.218,.402),l(-1.243,.559),l(-.448,.031),l(-.646,-.42),l(-.276,-.083),l(-.21,.326),l(-.543,.766),l(-.396,.144),l(-.42,-.054),l(-.964,.006),l(-.963,.02),l(-.512,-.294),l(-.323,-.394),l(-.229,-.083),l(-.123,.128),l(-.643,.356),l(-.526,.088),l(-1.019,-.149),l(-.898,-.018),l(-.196,-.559),l(-.135,-.766),l(-.053,-.584),l(-.135,-.946),l(-.448,-.841),l(-.663,-.538),l(-1.014,-.107),l(-.223,.016),l(-.385,-.407),l(-.732,-.349),l(-1.574,-.57),l(-1.269,-.6),l(-.729,-.265),l(-.263,-.21),l(-.703,-.641),l(-.689,-1.804),l(-.428,-.78),l(-.936,-.898),l(-.486,-.631),l(-.122,-.693),l(.102,-.848),l(-.425,-1.439),l(.064,-.762),l(1.252,-.348),l(.388,-.539),l(.645,-1.204),l(.687,-.853),l(.346,-.271),l(.044,-.212),l(-.148,-.239),l(-.273,-.125),l(-.401,-.068),l(-.211,-.211),l(.158,-.976),l(.304,-.016),l(.396,-.158),l(.142,-.17),l(.104,-.481),l(-.167,-.493),l(-.364,-.888),l(-.121,-.748),
N(464.786,206.235),l(-.197,-.338),l(.49,-1.358),l(.122,-.425),l(.269,-.256),l(.301,-.171),l(.426,-.412),l(.064,.042),l(.546,.223),l(.431,-.045),l(.458,-.427),l(.554,-.398),l(.319,-.017),l(.121,.748),l(.364,.888),l(.167,.493),l(-.104,.481),l(-.142,.17),l(-.396,.158),l(-.304,.016),l(-.559,.031),l(-.508,.159),l(-.391,.567),l(-.158,.085),l(-.396,.13),l(-.789,-.32),l(-.688,-.024),
N(465.79,210.652),l(-.017,-1.329),l(-.237,-.634),l(-.014,-.636),l(.04,-.438),l(-.087,-.381),l(-.689,-.999),l(.688,.024),l(.789,.32),l(.396,-.13),l(.158,-.085),l(.391,-.567),l(.508,-.159),l(.559,-.031),l(-.158,.976),l(.211,.211),l(.401,.068),l(.273,.125),l(.148,.239),l(-.044,.212),l(-.346,.271),l(-.687,.853),l(-.645,1.204),l(-.388,.539),l(-1.252,.348),
N(427.243,211.207),l(.536,-.414),l(.68,-.513),l(.351,-.13),l(.695,.533),l(-.583,.568),l(-.317,.199),l(-.094,.143),l(-.1,.89),l(.017,.085),l(-.74,.3),l(.143,-.625),l(-.082,-.24),l(-.505,-.796),M(427.998,213.843),l(.112,.013),l(.56,-.06),l(.699,-.314),l(.896,-.062),l(.318,-.101),l(.432,-.03),l(.783,-.02),l(.945,.052),l(1.312,.048),l(.624,-.003),l(.88,-.034),l(1.104,.008),l(.385,.012),l(.321,.111),l(.082,.127),l(.121,.521),l(.059,.579),l(.537,1.409),l(.597,1.07),l(.64,.787),l(.292,.168),l(.88,-.034),l(1.021,-.246),l(.899,.122),l(.993,-.006),l(.184,-.411),l(.286,-.892),l(-.027,-.593),l(.089,-.354),l(.112,-.001),l(2.016,-.082),l(.181,.225),l(-.055,.48),l(.212,.168),l(.88,-.019),l(1.231,-.093),l(.322,.098),l(.052,.183),l(-.177,.693),l(-.057,.354),l(.303,.605),l(.109,.607),l(-.07,1.06),l(-.296,1.033),l(.021,.212),l(.117,.211),l(.844,.998),l(.306,.62),l(-.003,.466),l(-.198,.905),l(.007,.254),l(.199,.197),l(.61,-.004),l(.859,-.26),l(.991,-.146),l(1.24,.147),l(-.214,1.344),l(.195,1.059),l(.269,.323),l(.089,.254),l(-.132,.368),l(-.436,.44),l(-.124,.594),l(-.125,.086),l(-.517,-.04),l(-3.408,.091),l(-.051,.877),l(.015,1.342),l(-.024,3.249),l(.017,.848),l(.023,.594),l(.099,.438),l(.308,.394),l(.471,.436),l(1.354,1.391),l(.611,.632),l(-.93,.218),l(-1.96,.379),l(-1.044,.203),l(-.717,-.08),l(-1.164,.063),l(-.408,-.083),l(-.349,-.21),l(-2.024,.026),l(-.697,-.024),l(-.622,-.151),l(-.401,-.322),l(-.305,-.366),l(-.408,-.096),l(-.989,-.023),l(-2.59,.016),l(-1.636,-.019),l(-.631,-.011),l(-1.296,-.006),l(-2.201,.013),l(-.636,-.151),l(-.463,-.309),l(-.45,-.478),l(-.294,-.083),l(-.499,.088),l(-.591,.286),l(-.778,.513),l(-.758,-.462),l(-.352,.144),l(-.248,.197),l(.048,-1.809),l(-.017,-.805),l(-.029,-.649),l(.397,-.34),l(.221,-.269),l(.26,-.707),l(.163,-.734),l(.184,-1.398),l(.239,-.976),l(.321,-.918),l(.584,-.665),l(.183,-.565),l(.268,-.354),l(.64,-.228),l(.268,-.325),l(.423,-.679),l(.364,-1.201),l(.053,-.664),l(-.046,-.848),l(-.191,-.959),l(-.201,-.536),l(-.492,-.705),l(-.476,-.776),l(-.268,-.775),l(.139,-.495),l(.476,-.382),l(.158,-.156),l(.107,-.424),l(-.006,-.479),l(-.199,-.579),l(-.489,-.69),l(-.441,-.733),l(-.203,-1.031),l(-.181,-.423),l(-.276,-.366),l(-.666,-.974),l(-.072,-.15),
N(452.198,239.34),l(-.611,-.632),l(-1.354,-1.391),l(-.471,-.436),l(-.308,-.394),l(-.099,-.438),l(-.023,-.594),l(-.017,-.848),l(.024,-3.249),l(-.015,-1.342),l(.051,-.877),l(3.408,-.091),l(.517,.04),l(.125,-.086),l(.124,-.594),l(.436,-.44),l(.132,-.368),l(-.089,-.254),l(-.269,-.323),l(-.195,-1.059),l(.214,-1.344),l(.678,.096),l(.365,.379),l(.172,.352),l(.195,.056),l(1.146,-.289),l(.175,-.071),l(.58,1.014),l(.489,.194),l(.925,.249),l(.922,.164),l(.325,.111),l(.366,-.087),l(.522,-.682),l(.212,-.354),l(.728,1.423),l(.38,.28),l(.895,.263),l(.477,.252),l(.416,.351),l(.561,.731),l(.381,.647),l(.348,.21),l(1.355,.091),l(.371,.012),l(.041,-.551),l(-.028,-1.427),l(-.032,-.791),l(-.136,-.183),l(-.362,.186),l(-.448,.455),l(-.515,-.012),l(-.445,-.279),l(-.837,-.843),l(-.456,-.605),l(-.043,-.296),l(.3,-1.02),l(.377,-1.175),l(-.372,-2.088),l(.029,-.622),l(.797,-1.276),l(.154,-.198),l(.347,-.214),l(3.015,-.499),l(.563,-.068),l(.703,.641),l(.263,.21),l(.729,.265),l(1.269,.6),l(1.574,.57),l(.732,.349),l(.385,.407),l(.559,.887),l(.434,.859),l(.013,.324),l(-.183,.27),l(-.709,.344),l(-.011,.127),l(.04,.594),l(-.091,1.682),l(.08,.353),l(.216,.168),l(.511,.266),l(.072,.197),l(-.197,.241),l(-.472,.258),l(-.792,.259),l(-.146,.34),l(-.094,.764),l(-.3,.807),l(.2,.479),l(.261,.408),l(.394,.125),l(-1.264,.53),l(-1.696,.575),l(-.932,.4),l(-2.165,.578),l(-.187,.128),l(-.009,.495),l(.152,.465),l(.087,.438),l(-.505,-.096),l(-.999,.049),l(-.794,.259),l(-.636,.54),l(-.312,.539),l(-.019,.579),l(-.168,.199),l(-.285,.114),l(-.999,.062),l(-.621,.202),l(-.306,.341),l(-.777,.937),l(-.562,.738),l(-.825,.951),l(-.354,.045),l(-.803,-.165),l(-.421,-.309),l(-.334,.129),l(-.521,.286),l(-.404,.017),l(-.594,-.209),l(-.264,-.097),l(-.154,-.169),l(-.163,-.027),l(-.187,-.154),l(-.456,-.393),l(-.294,-.055),l(-1.089,-.093),l(-.086,-.099),l(-.165,-.056),l(-1.845,.364),
N(477.231,225.874),l(-.224,1.184),l(-.107,.48),l(.252,.917),l(.177,1.017),l(.149,.408),l(.238,.268),l(.803,.588),l(1.189,1.166),l(.454,.661),l(.14,.48),l(-.155,2.346),l(-.04,.41),l(-.214,.213),l(-.432,.073),l(-.322,.017),l(-.229,.213),l(-.076,.622),l(.08,.509),l(.029,.479),l(-.096,.283),l(-.185,-.111),l(-.562,-.463),l(-.763,-1.112),l(-.484,-.548),l(-.234,-.423),l(.036,-.212),l(.499,-.61),l(.116,-.227),l(.025,-.693),l(-.1,-.96),l(-.22,-.479),l(-.261,-.056),l(-.674,.061),l(-.702,.132),l(-.27,-.211),l(-.343,-.407),l(-.382,-.549),l(-.195,-.041),l(-.394,-.125),l(-.261,-.408),l(-.2,-.479),l(.3,-.807),l(.094,-.764),l(.146,-.34),l(.792,-.259),l(.472,-.258),l(.197,-.241),l(-.072,-.197),l(-.511,-.266),l(-.216,-.168),l(-.08,-.353),l(.091,-1.682),l(-.04,-.594),l(.011,-.127),l(.709,-.344),l(.183,-.27),l(-.013,-.324),l(-.434,-.859),l(-.559,-.887),l(.223,-.016),l(1.014,.107),l(.663,.538),l(.448,.841),l(.135,.946),l(.053,.584),l(.135,.766),l(.196,.559),
N(245.934,224.314),l(.939,.136),l(1.122,.304),l(.355,-.03),l(.946,-.824),l(.336,.026),l(.48,.025),l(.415,-.243),l(1.471,-1.109),l(.874,-.485),l(.36,-.158),l(.934,-.076),l(1.283,.021),l(.045,.748),l(-.079,.621),l(-.064,.622),l(.036,.818),l(.141,.635),l(.335,.591),l(.813,.928),l(1.1,.939),l(.316,.097),l(.787,.023),l(.355,-.03),l(.676,.25),l(.688,.307),l(.75,.603),l(.3,.098),l(.882,.037),l(.096,.014),l(.385,.774),l(.398,.308),l(.22,.084),l(1.148,-.077),l(.636,.123),l(.537,.166),l(.403,.237),l(.085,.169),l(-.038,.565),l(.203,1.029),l(.03,.706),l(.138,2.032),l(.249,.944),l(.153,.112),l(.967,.036),l(.5,.012),l(1.615,.019),l(.693,.024),l(.042,.296),l(-.261,.835),l(.067,.563),l(.436,.407),l(.73,.362),l(.316,.479),l(.307,.774),l(.022,.494),l(-.185,1.173),l(-.238,.834),l(-.38,.765),l(-.421,.666),l(-.089,-.084),l(-1.952,-.991),l(-.352,-.054),l(-.928,.02),l(-.843,-.01),l(-.126,.128),l(-1.076,.204),l(-1.104,.162),l(-.784,.202),l(-.33,.044),l(-.332,.383),l(-.698,1.105),l(-.278,.341),l(-.133,.509),l(.016,.635),l(-.385,1.188),l(-.395,1.104),l(-.149,.325),l(-.592,-.109),l(-1.33,-.077),l(-.686,.004),l(-1.034,1.784),l(-.416,-1.084),l(-.341,-.309),l(-.37,-.195),l(-.531,-.067),l(-.527,.045),l(-.901,.034),l(-.615,-.194),l(-.193,-.169),l(-.322,-.181),l(-.292,.27),l(-2.026,2.087),l(-1.047,.006),l(-.272,-.182),l(-.397,-2.144),l(-.278,-.973),l(-.212,-.563),l(-.769,-1.11),l(-.249,-.676),l(.04,-.354),l(.437,-1.555),l(-.017,-.282),l(-.761,-.744),l(-.25,-.521),l(-.193,-1.213),l(-.304,-.647),l(-.555,-.745),l(-.152,-.253),l(-.018,-.142),l(-.132,-.295),l(-.049,-.48),l(.12,-.227),l(.723,-.61),l(.285,-.439),l(-.015,-.522),l(-.604,-1.168),l(-.022,-.48),l(.159,-.34),l(.21,-.368),l(-.347,-.845),l(.102,-.452),l(.532,-.582),l(.221,-.34),l(.156,-.34),l(-.236,-.902),l(-.057,-.522),l(.143,-.848),l(.15,-.523),l(.437,-.736),l(-.08,-.24),l(-.922,-1.646),l(-1.109,-1.843),
N(473.575,260.04),l(-1.331,.011),l(-.192,.058),l(-.068,-.382),l(-.261,-.889),l(.071,-.495),l(-.075,-.296),l(-.095,-.324),l(.03,-.806),l(.057,-1.301),l(-.072,-.763),l(-.147,-.678),l(-.33,-.944),l(-.441,-.689),l(-.181,-.946),l(-.295,-1.199),l(-.159,-.183),l(.448,-.384),l(.396,-.412),l(1.68,-1.706),l(.114,-.227),l(-.09,-.367),l(.075,-.834),l(.229,-.481),l(.736,-.683),l(.205,-.341),l(.168,-.41),l(-.594,-.845),l(-.118,-.805),l(-.113,-.494),l(.128,-.283),l(.448,-.596),l(.201,-.411),l(-.132,-.805),l(-.086,-1.144),l(-.031,-.791),l(-.178,-.818),l(-.441,-.379),l(-.515,-.224),l(-1.167,-.347),l(-1.042,-.445),l(-.658,-.223),l(-1.438,-.006),l(-.137,-.14),l(-.025,-.495),l(-.011,-.212),l(-.087,-.438),l(-.152,-.465),l(.009,-.495),l(.187,-.128),l(2.165,-.578),l(.932,-.4),l(1.696,-.575),l(1.264,-.53),l(.195,.041),l(.382,.549),l(.343,.407),l(.27,.211),l(.702,-.132),l(.674,-.061),l(.261,.056),l(.22,.479),l(.1,.96),l(-.025,.693),l(-.116,.227),l(-.499,.61),l(-.036,.212),l(.234,.423),l(.484,.548),l(.763,1.112),l(.562,.463),l(.185,.111),l(.096,-.283),l(-.029,-.479),l(-.08,-.509),l(.076,-.622),l(.229,-.213),l(.322,-.017),l(.432,-.073),l(.214,-.213),l(.04,-.41),l(.155,-2.346),l(-.14,-.48),l(-.454,-.661),l(-1.189,-1.166),l(-.803,-.588),l(-.238,-.268),l(-.149,-.408),l(-.177,-1.017),l(-.252,-.917),l(.107,-.48),l(.224,-1.184),l(.898,.018),l(1.019,.149),l(.526,-.088),l(.643,-.356),l(.123,-.128),l(.229,.083),l(.323,.394),l(.512,.294),l(.963,-.02),l(.964,-.006),l(.42,.054),l(.396,-.144),l(.543,-.766),l(.21,-.326),l(.276,.083),l(.646,.42),l(.448,-.031),l(1.243,-.559),l(1.218,-.402),l(.515,-.342),l(1.157,-.836),l(.128,.167),l(.212,.479),l(-.185,.579),l(-.302,.453),l(-.198,.255),l(.181,.451),l(.129,.72),l(-.012,.466),l(.182,1.115),l(-.101,.58),l(-.258,.325),l(.374,.705),l(.154,.494),l(-.006,1.115),l(-.004,.819),l(.043,.184),l(.185,.127),l(.327,.084),l(.015,.269),l(-.165,.494),l(-.563,.58),l(.184,.381),l(-.08,.283),l(-.418,.565),l(-.802,.906),l(-.512,.622),l(-.72,.651),l(-1.36,.751),l(-1.48,.653),l(-.73,.228),l(-1.308,.582),l(-.852,.637),l(-1.286,1.443),l(-.886,.85),l(-1.193,.878),l(-1.181,.836),l(-.268,.128),l(-.035,.96),l(-.083,.495),l(.058,.127),l(.719,.535),l(.188,.381),l(-.166,.452),l(-.085,.184),l(.461,1.511),l(.071,.564),l(.06,.155),l(.246,.014),l(.171,-.128),l(.141,-.085),l(.043,.607),l(-.234,2.218),l(-.284,.82),l(.325,.196),l(.152,.057),l(-.025,.325),l(-.157,.311),l(-.516,.566),l(-.699,.538),l(-.664,.34),l(-1.266,.412),l(-.796,.312),l(-.688,.228),l(-.895,.524),l(-.652,.665),l(-.337,.51),l(.292,.338),l(.589,.338),l(.045,.325),l(-.149,1.022),
N(499.85,236.166),l(.544,-.071),l(.622,-.369),l(.18,.028),l(.346,.098),l(.269,-.085),l(.396,-.368),l(.911,-.143),l(.311,.281),l(.305,-.028),l(.101,-.185),l(-.171,-.366),l(.771,-.539),l(.423,-.198),l(.322,.226),l(.389,-.213),l(-.308,-.494),l(.207,-.282),l(.505,-.425),l(.229,.296),l(.229,.056),l(.558,-.594),l(-.158,-.197),l(-.253,-.409),l(.094,-.297),l(.243,.014),l(.27,-.071),l(.172,-.34),l(-.297,-.875),l(.06,-.339),l(.255,-.043),l(.117,.07),l(.253,.438),l(.28,.099),l(.2,-.41),l(.692,-.524),l(.235,-.367),l(.134,-.452),l(.168,-.692),l(-.133,-.354),l(.003,-.226),l(.537,-.468),l(.356,.324),l(.455,.648),l(.612,.281),l(.141,.198),l(.213,.847),l(.294,1.821),l(.093,.663),l(.231,.791),l(.391,.733),l(.163,.466),l(-.038,.367),l(-.069,.155),l(-.058,.099),l(-.537,.807),l(-.22,-.127),l(-.189,-.366),l(-.555,-.748),l(-.297,.143),l(-.05,.424),l(.193,.875),l(.396,.521),l(.079,.396),l(-.307,.636),l(-.746,1.005),l(-.045,.452),l(.041,.89),l(-.18,.946),l(-.709,2.12),l(-.825,2.572),l(-1.254,3.788),l(-1.324,4.48),l(-.518,1.568),l(-.188,.255),l(-.508,.637),l(-.2,.113),l(-1.369,.102),l(-.999,.327),l(-.474,.468),l(-.813,.086),l(-.363,-.465),l(-.196,-.142),l(-.546,-.182),l(-.37,.071),l(-.269,-.057),l(-.863,-.718),l(-.104,-.24),l(-.02,-.565),l(-.104,-.239),l(-.46,-.366),l(-.124,-.282),l(.001,-.721),l(.345,-1.088),l(-.094,-.325),l(-.287,-.479),l(-.62,-.931),l(-.189,-.494),l(.075,-.664),l(.391,-1.37),l(.228,-.213),l(.474,-.185),l(.768,-1.371),l(.686,-1.174),l(.104,-.325),l(.151,-1.103),l(-.11,-.353),l(-.278,-.226),l(-.354,-.366),l(.066,-.184),l(.252,-.509),l(-.521,-.861),l(-.117,-.677),l(-.069,-.494),l(-.231,-.721),l(.024,-.112),l(.517,-.693),l(.362,-.594),l(.163,-.438),l(.007,-1.073),l(.484,-.016),
N(468.138,234.908),l(.011,.212),l(.025,.495),l(.137,.14),l(1.438,.006),l(.658,.223),l(1.042,.445),l(1.167,.347),l(.515,.224),l(.441,.379),l(.178,.818),l(.031,.791),l(.086,1.144),l(.132,.805),l(-.201,.411),l(-.448,.596),l(-.128,.283),l(.113,.494),l(.118,.805),l(.594,.845),l(-.168,.41),l(-.205,.341),l(-.736,.683),l(-.229,.481),l(-.075,.834),l(.09,.367),l(-.114,.227),l(-1.68,1.706),l(-.396,.412),l(-.448,.384),l(-.342,-.225),l(-.547,-.124),l(-.442,-.025),l(-.529,.145),l(-.31,.016),l(-.99,-.403),l(-.597,-.139),l(-.72,-.023),l(-.067,-.042),l(-.186,-.098),l(-.306,-.451),l(-.479,-.35),l(-.549,-.167),l(-.938,-.136),l(-.352,-.153),l(-.524,-.873),l(-.163,-.564),l(.032,-.565),l(-.127,-.239),l(-.78,.019),l(-.201,-.098),l(-.109,-.211),l(.051,-.537),l(-.106,-.169),l(-.552,-.266),l(-.533,-.223),l(-.57,-.321),l(-.563,-.491),l(-.377,-.662),l(-.246,-.96),l(-.469,-.604),l(-.43,-.478),l(-.267,-.451),l(.103,-.227),l(.594,.209),l(.404,-.017),l(.521,-.286),l(.334,-.129),l(.421,.309),l(.803,.165),l(.354,-.045),l(.825,-.951),l(.562,-.738),l(.777,-.937),l(.306,-.341),l(.621,-.202),l(.999,-.062),l(.285,-.114),l(.168,-.199),l(.019,-.579),l(.312,-.539),l(.636,-.54),l(.794,-.259),l(.999,-.049),l(.505,.096),
N(444.673,255.519),l(-.006,3.434),l(.031,1.894),l(.025,2.246),l(-.057,.205),l(-.454,.318),l(-.545,.302),l(-.581,.498),l(-.427,.034),l(-.581,-.166),l(-.745,-.042),l(-.892,.048),l(-.517,-.039),l(-.296,-.212),l(-.055,-.528),l(-.042,-.345),l(-.193,-.222),l(-.637,-.348),l(-.329,-.127),l(-.335,.116),l(-.109,.217),l(-.317,.416),l(-.584,.27),l(-.152,.068),l(-.458,-.491),l(-1.041,-1.001),l(-.458,-.606),l(-.359,-1.03),l(-.345,-.72),l(-.136,-.493),l(.12,-.269),l(.053,-.34),l(-.458,-.719),l(-.231,-.861),l(.148,-.861),l(-.002,-.48),l(-.537,-1.326),l(-.496,-2.244),l(.772,-.02),l(.04,-.678),l(-.077,-.749),l(-.456,-.006),l(.016,-.06),l(-.099,-.522),l(-.26,-.508),l(-1.018,-1.283),l(-.343,-.55),l(-1.102,-2.158),l(-.841,-1.623),l(-.9,-1.509),l(-.988,-1.269),l(-.511,-1.044),l(-.122,-.396),l(-.045,-.551),l(.015,-.578),l(.248,-.197),l(.352,-.144),l(.758,.462),l(.778,-.513),l(.591,-.286),l(.499,-.088),l(.294,.083),l(.45,.478),l(.463,.309),l(.636,.151),l(2.201,-.013),l(1.296,.006),l(.631,.011),l(1.636,.019),l(2.59,-.016),l(.989,.023),l(.408,.096),l(.305,.366),l(.401,.322),l(.622,.151),l(.697,.024),l(2.024,-.026),l(.349,.21),l(.408,.083),l(1.164,-.063),l(.717,.08),l(1.044,-.203),l(1.96,-.379),l(.93,-.218),l(1.845,-.364),l(.165,.056),l(.086,.099),l(1.089,.093),l(.294,.055),l(.456,.393),l(-.811,.315),l(-.891,.02),l(-.284,.143),l(-.993,.938),l(-.209,.029),l(-.62,-.773),l(-1.048,.134),l(-2.962,.47),l(-1.183,.021),l(.005,1.215),l(-.007,1.286),l(-.025,.876),l(-.043,1.201),l(.002,3.561),l(-.586,.046),l(-1.564,.052),l(-.146,.028),l(-.106,2.657),l(-.009,1.201),l(.013,1.624),l(.007,.806),
N(248.453,316.576),l(-.306,.101),l(-.892,-.087),l(-.538,-.293),l(-.236,-.015),l(-.311,.163),l(-.418,.398),l(-.498,.192),l(-1.156,.091),l(-.349,.09),l(-.358,.207),l(-.267,.621),l(-.114,.341),l(.06,.532),l(-.163,.622),l(-.104,.148),l(-.453,.031),l(-.534,.104),l(-.956,-.413),l(.667,-.639),l(.326,-.444),l(.582,-.4),l(.025,-.147),l(-.372,-.177),l(-.273,-.117),l(-1.353,.534),l(-1.01,-.013),l(-.545,.163),l(-.202,-.339),l(.128,-.192),l(.959,-.268),l(.266,.028),l(.792,-.208),l(.441,-.118),l(-.605,-.162),l(-.582,.002),l(-.77,.001),l(-.014,-.413),l(.265,-.31),l(-.007,-.191),l(-.446,-.073),l(-.356,-.44),l(-.66,.384),l(-.669,-.175),l(.292,-.53),l(.041,-.177),l(-.378,.045),l(-.361,.147),l(-.416,-.396),l(-.215,-.117),l(.413,-.279),l(.114,-.177),l(-.091,-.278),l(-.053,-.073),l(-.351,.03),l(-.773,-.424),l(-.135,-.059),l(.844,-.192),l(.253,-.161),l(.1,-.294),l(.396,-.366),l(.049,-.234),l(-.641,.06),l(-.257,.104),l(-.312,-.073),l(-.256,-.672),l(.573,-.395),l(-.565,-.378),l(-.12,-.421),l(.757,-.452),l(-.14,-.421),l(-.686,.422),l(-.091,-1.523),l(.399,-.596),l(-.185,-.825),l(.013,-.218),l(.593,.014),l(.41,.245),l(.711,.071),l(.171,-.246),l(.002,-.159),l(-.896,-.447),l(-.867,.146),l(-.317,-.173),l(-.536,.059),l(-.017,-.231),l(.339,-.333),l(.025,-.246),l(-.067,-.087),l(.186,-.202),l(.536,.014),l(.229,-.377),l(.01,-.216),l(-.722,-.389),l(-.354,-.129),l(-.886,.045),l(-.332,-.101),l(-.024,-.49),l(-.939,.16),l(-.115,-.101),l(.122,-.145),l(1.032,-.521),l(.251,-.116),l(.4,-.404),l(.266,-.389),l(.833,-.06),l(.268,.201),l(.059,.346),l(-.648,.202),l(-.323,.274),l(.11,.505),l(.117,.058),l(.191,-.102),l(.268,-.39),l(.183,-.087),l(.242,.101),l(-.037,.317),l(.057,.504),l(.886,-.996),l(.161,-.678),l(.056,-.647),l(.237,-.375),l(.079,-.058),l(.631,-.217),l(-.201,-.071),l(-.438,-.143),l(-.056,-.158),l(.101,-.273),l(.246,-.072),l(.571,-.245),l(.599,-.431),l(.271,-.459),l(-.061,-.229),l(-.394,-.157),l(-.662,-.399),l(-.053,-.372),l(.139,-.243),l(.105,-.458),l(-.06,-.828),l(.366,-.33),l(.676,-.272),l(-.431,-.585),l(-.053,-.784),l(.133,-.158),l(.554,-.157),l(.054,-.314),l(-.116,-.285),l(-.317,-.085),l(-.272,-.198),l(.233,-.329),l(.087,-.313),l(-.401,-.185),l(-.274,-.014),l(-.161,.101),l(-.476,.414),l(-.548,.058),l(-.087,.001),l(-.289,-.199),l(-.16,-.484),l(-.399,-.726),l(-.133,-.697),l(.188,-.911),l(.137,-.413),l(.722,-.739),l(.535,-.767),l(-.006,-.326),l(-.544,-1.757),l(.001,-.608),l(.088,-.567),l(-.076,-.438),l(-.528,-.891),l(-.04,-.298),l(.236,-.198),l(.499,.098),l(.182,-.085),l(.2,-.142),l(.097,-.143),l(.41,-1.288),l(.252,-.481),l(.304,-.935),l(.18,-.65),l(.664,-.808),l(.363,-.722),l(.201,-.636),l(.252,-.946),l(.311,-.691),l(.187,-.128),l(.273,-.382),l(.013,-.296),l(-.312,-.847),l(.082,-.184),l(.455,-.452),l(.206,-.339),l(.028,-.24),l(-.093,-.226),l(-.166,-.805),l(-.292,-2.088),l(-.098,-.86),l(.031,-.565),l(.412,-.565),l(.37,-.537),l(.207,-.564),l(.007,-.734),l(-.339,-.521),l(-.098,-.409),l(.295,-.96),l(.218,-.941),l(.127,-.556),l(.461,-.594),l(.171,-.918),l(.243,-.975),l(.126,-.805),l(.082,-.565),l(-.063,-1.087),l(.422,-.664),l(.211,-.494),l(-.221,-.932),l(-.048,-.833),l(.148,-.24),l(-.022,-.917),l(.229,-.607),l(-.124,-.297),l(-.365,-.084),l(.06,-.324),l(-.046,-.396),l(.223,-.198),l(.402,-.198),l(.137,-.424),l(-.008,-.819),l(.093,-.593),l(.182,-.918),l(-.004,-2.344),l(-.172,-2.074),l(-.042,-1.539),l(-.194,-.974),l(-.15,-.387),l(.852,-.275),l(.259,-.298),l(.228,-.933),l(.15,-.199),l(.586,-.187),l(.152,.253),l(.555,.745),l(.304,.647),l(.193,1.213),l(.25,.521),l(.761,.744),l(.017,.282),l(-.437,1.555),l(-.04,.354),l(.249,.676),l(.769,1.11),l(.212,.563),l(.278,.973),l(.397,2.144),l(.272,.182),l(1.047,-.006),l(.107,.056),l(.212,.14),l(.161,.154),l(-.093,.636),l(-.541,1.457),l(-.36,.256),l(-1.346,.53),l(-.819,.372),l(-.204,.312),l(.25,.817),l(-.421,.722),l(-.007,.579),l(.113,.437),l(.34,.449),l(.03,.226),l(-.273,.369),l(-.161,.382),l(.114,.507),l(.53,.477),l(.011,.227),l(-.152,.311),l(-.333,.017),l(-.791,.089),l(-.329,.835),l(-.464,.835),l(-.608,.694),l(-.282,.439),l(-.823,1.839),l(.167,1.466),l(.054,.762),l(-.124,.185),l(-.492,.271),l(-.292,.34),l(-.388,1.201),l(-.156,.961),l(.285,.633),l(.408,1.154),l(.784,2.816),l(.055,.69),l(-.075,.41),l(-1.083,1.854),l(-.319,.595),l(.088,.409),l(.189,1.06),l(-.078,.325),l(-1.334,1.11),l(-.231,.312),l(-.142,1.075),l(.014,1.16),l(.249,1.103),l(.437,.932),l(-.202,.143),l(-.951,.529),l(-.126,.17),l(-.053,.312),l(-.511,2.427),l(-.316,.541),l(-.1,.37),l(.123,1.835),l(.231,.867),l(.012,.427),l(-.596,.317),l(-.172,.172),l(-.106,.271),l(.094,1.226),l(.125,.128),l(.555,.111),l(.088,.655),l(-.191,1.458),l(.252,.585),l(.26,.185),l(.789,.11),l(.302,.17),l(-.007,.186),l(-.245,.202),l(-.322,.13),l(-.726,.033),l(-.757,.146),l(.176,.171),l(.586,.298),l(.552,.385),l(.017,.216),l(-.767,.794),l(-.059,1.094),l(.158,1.035),l(-.216,.896),l(-.212,.434),l(-.226,.262),l(-.598,.161),l(-.28,.219),l(-.249,.781),l(.446,.648),l(-.069,.188),l(-.296,1.218),l(-.307,.263),l(-1.729,1.01),l(-.271,.292),l(-.037,.45),l(.28,1.309),l(.508,1.123),l(.218,.043),l(.961,-.283),l(.654,-.121),l(.187,.248),l(.231,2.285),l(.778,.568),l(.669,.041),l(1.41,-.052),l(2.827,.132),l(.841,.217),l(1.385,.36),l(.286,.039),M(236.642,296.773),l(-.394,-.113),l(-.43,-.028),l(-.21,-.171),l(-.133,-.229),l(.21,-.457),l(.15,-.657),l(-.087,-.514),l(.011,-.414),l(.364,-.728),l(.817,-.116),l(.36,.327),l(.044,.328),l(-.688,.443),l(-.146,.229),l(.493,.771),l(-.194,1.058),l(-.167,.271),M(238.177,317.937),l(-.445,-.177),l(.083,-.842),l(-.849,.075),l(-.073,-.368),l(.218,-.354),l(.823,.102),l(.508,-.207),l(.205,.103),l(.054,.812),l(-.267,.34),l(-.257,.518),M(247.801,322.062),l(-1.033,.102),l(-.467,-.118),l(-.55,-.237),l(-.42,.001),l(-.481,.104),l(-.935,.226),l(-.496,.03),l(.125,-.343),l(.202,-.312),l(-.104,-.312),l(.906,-.15),l(1.434,.058),l(.433,.323),l(.706,-.007),l(-.622,-.689),l(-.307,-.163),l(-.56,-.117),l(-.178,-.089),l(-.188,.03),l(-.338,-.341),l(-.229,-.4),l(1.611,-.581),l(-.044,-.296),l(-.165,-.147),l(-1.819,.285),l(-.292,-.222),l(.263,-.474),l(.146,-.163),l(1.074,-.52),l(.868,-.637),l(.414,.28),l(1.153,.062),l(-.008,1.144),l(-.098,3.675),
N(456.133,239.67),l(.187,.154),l(.163,.027),l(.154,.169),l(.264,.097),l(-.103,.227),l(.267,.451),l(.43,.478),l(.469,.604),l(.246,.96),l(.377,.662),l(.563,.491),l(.57,.321),l(.533,.223),l(.552,.266),l(.106,.169),l(-.051,.537),l(.109,.211),l(.201,.098),l(.78,-.019),l(.127,.239),l(-.032,.565),l(.163,.564),l(.524,.873),l(.352,.153),l(.938,.136),l(.549,.167),l(.479,.35),l(.306,.451),l(.186,.098),l(-.317,.411),l(-.388,.327),l(-.507,.243),l(-.747,.075),l(-.304,.115),l(-.7,.823),l(-.586,.583),l(-.362,.229),l(-.747,.357),l(-.388,.355),l(-.107,.636),l(-.222,.666),l(-.247,.241),l(-.634,.357),l(-.98,.33),l(-.249,.214),l(-.217,.708),l(-.345,.963),l(-.288,.354),l(-.237,.129),l(-.584,.116),l(-.43,-.026),l(-.473,.06),l(-.511,-.011),l(-.819,-.193),l(-.744,-.32),l(-.979,-.645),l(-.545,-.039),l(-.333,.186),l(-.084,.24),l(-.585,1.134),l(-.382,.469),l(-.651,.625),l(-.632,.428),l(-.8,.372),l(-.823,.033),l(-.854,.047),l(-.368,-.097),l(-.11,-.183),l(.003,-.48),l(.243,-.609),l(.166,-.538),l(-.21,-.762),l(-.547,-.943),l(-.716,-.787),l(-.528,-.067),l(-.007,-.806),l(-.013,-1.624),l(.009,-1.201),l(.106,-2.657),l(.146,-.028),l(1.564,-.052),l(.586,-.046),l(-.002,-3.561),l(.043,-1.201),l(.025,-.876),l(.007,-1.286),l(-.005,-1.215),l(1.183,-.021),l(2.962,-.47),l(1.048,-.134),l(.62,.773),l(.209,-.029),l(.993,-.938),l(.284,-.143),l(.891,-.02),l(.811,-.315),
N(279.288,257.295),l(.02,.239),l(-.544,1.57),l(-.375,.468),l(-1.007,.74),l(-.301,.27),l(-.352,.51),l(-.609,-.363),l(-.35,-.097),l(-.235,.029),l(-.387,.172),l(-.745,.131),l(-.71,.005),l(-.564,-.096),l(-.992,-.333),l(-.607,-.025),l(-1.187,.332),l(-.19,-.056),l(.064,-.212),l(.425,-.426),l(.486,-.398),l(.11,-.198),l(-.21,-.619),l(.048,-.227),l(.625,-.851),l(.617,-1.203),l(.018,-.268),l(-.939,-.503),l(-.65,-.18),l(-1.448,-.697),l(-1.632,-1.106),l(-.671,-.307),l(-1.173,-.204),l(-.498,-.237),l(-.835,-.588),l(-.576,-.562),l(-1.271,-1.376),l(-.782,-.913),l(-.225,-.337),l(-.19,-.056),l(.149,-.325),l(.395,-1.104),l(.385,-1.188),l(-.016,-.635),l(.133,-.509),l(.278,-.341),l(.698,-1.105),l(.332,-.383),l(.33,-.044),l(.784,-.202),l(1.104,-.162),l(1.076,-.204),l(.126,-.128),l(.843,.01),l(.928,-.02),l(.352,.054),l(1.952,.991),l(.089,.084),l(.253,.408),l(.084,.663),l(.521,.872),l(.104,.959),l(-.132,.862),l(-.086,.721),l(-.006,.72),l(.372,.04),l(.818,.15),l(.925,.221),l(.346,-.03),l(.709,-.413),l(.115,-.001),l(.724,.278),l(.843,.404),l(.121,.437),l(.487,2.524),l(.254,.563),l(.224,.055),l(1.29,-.445),l(.234,.112),l(.491,.336),l(.019,.141),l(-.321,.75),l(-.298,.835),l(-.222,.819),l(-.027,.777),l(.063,.423),
N(444.673,255.519),l(.528,.067),l(.716,.787),l(.547,.943),l(.21,.762),l(-.166,.538),l(-.243,.609),l(-.003,.48),l(.11,.183),l(.368,.097),l(.854,-.047),l(.823,-.033),l(.8,-.372),l(.632,-.428),l(.651,-.625),l(.382,-.469),l(.585,-1.134),l(.084,-.24),l(.333,-.186),l(.545,.039),l(.979,.645),l(.744,.32),l(.819,.193),l(.511,.011),l(.473,-.06),l(.43,.026),l(.584,-.116),l(.237,-.129),l(.288,-.354),l(.345,-.963),l(.217,-.708),l(.249,-.214),l(.98,-.33),l(.634,-.357),l(.247,-.241),l(.222,-.666),l(.107,-.636),l(.388,-.355),l(.747,-.357),l(.362,-.229),l(.586,-.583),l(.7,-.823),l(.304,-.115),l(.747,-.075),l(.507,-.243),l(.388,-.327),l(.317,-.411),l(.067,.042),l(.72,.023),l(.597,.139),l(.99,.403),l(.31,-.016),l(.529,-.145),l(.442,.025),l(.547,.124),l(.342,.225),l(.159,.183),l(.295,1.199),l(.181,.946),l(.441,.689),l(.33,.944),l(.147,.678),l(.072,.763),l(-.057,1.301),l(-.03,.806),l(.095,.324),l(-1.449,-.585),l(-.279,.199),l(-.657,.979),l(-.28,.567),l(-.005,.325),l(.39,.676),l(.307,.465),l(.458,.322),l(.671,.109),l(.595,-.004),l(.076,-.594),l(.064,-.198),l(.312,-.186),l(.131,-.015),l(.192,-.058),l(1.331,-.011),l(-.182,1.195),l(-.352,.849),l(-.182,.184),l(-.404,.1),l(-.093,.24),l(.199,.536),l(-.104,.467),l(-.248,.354),l(-.569,.453),l(-.923,.581),l(-.591,.75),l(-1.383,1.98),l(-.631,.834),l(-1.242,1.373),l(-1.193,1.062),l(-.829,.863),l(-1.434,1.034),l(-1.379,1.091),l(-.552,.382),l(-.989,.638),l(-.676,.298),l(-.782,.101),l(-.98,-.012),l(-.549,.071),l(-.132,.354),l(.013,.127),l(-.109,.085),l(-.449,-.098),l(-.553,-.126),l(-.303,.015),l(-.25,.198),l(-.272,.312),l(-.226,.113),l(-.36,-.056),l(-.768,-.408),l(-.759,-.168),l(-.542,-.013),l(-.31,.113),l(-.38,.27),l(-.482,-.099),l(-.645,-.21),l(-.295,.1),l(-.638,.043),l(-.589,.214),l(-.729,.538),l(-.72,.086),l(-.44,-.013),l(-.667,-.084),l(-.738,.072),l(-.575,.199),l(-.827,.82),l(-1.251,-.576),l(-.092,-.509),l(-.218,-.183),l(-.479,-.056),l(-.28,.085),l(-.257,-.479),l(-.343,-.056),l(-.149,.255),l(-.035,.197),l(-.312,-.112),l(-.119,-.226),l(.267,-.495),l(.103,-.424),l(-.857,-1.354),l(-.323,-.282),l(-.134,-.226),l(.173,-.17),l(.636,-.044),l(.172,-.424),l(.06,-.819),l(-.163,-.663),l(-.186,-.522),l(-.61,-1.143),l(-.75,-1.029),l(-.472,-.903),l(-.612,-1.383),l(-.646,-1.467),l(-.573,-.818),l(-.436,-.467),l(.152,-.068),l(.584,-.27),l(.317,-.416),l(.109,-.217),l(.335,-.116),l(.329,.127),l(.637,.348),l(.193,.222),l(.042,.345),l(.055,.528),l(.296,.212),l(.517,.039),l(.892,-.048),l(.745,.042),l(.581,.166),l(.427,-.034),l(.581,-.498),l(.545,-.302),l(.454,-.318),l(.057,-.205),l(-.025,-2.246),l(-.031,-1.894),l(.006,-3.434),M(462.462,268.501),l(.412,-.044),l(.194,-.553),l(.633,-.343),l(1.035,-.303),l(.263,-.199),l(.582,-1.007),l(.268,-.326),l(.143,-.241),l(-.104,-.226),l(-.967,-.744),l(-.33,-.337),l(-.422,-.266),l(-.308,.086),l(-.995,.359),l(-.65,.329),l(-.513,.567),l(-.275,.44),l(-.691,.611),l(.12,.409),l(.582,.858),l(.285,.366),l(.739,.561),M(432.955,250.661),l(.456,.006),l(.077,.749),l(-.04,.678),l(-.772,.02),l(-.078,-.354),l(-.028,-.396),l(.285,-.297),l(.101,-.406),
N(471.719,258.047),l(.075,.296),l(-.071,.495),l(.261,.889),l(.068,.382),l(-.131,.015),l(-.312,.186),l(-.064,.198),l(-.076,.594),l(-.595,.004),l(-.671,-.109),l(-.458,-.322),l(-.307,-.465),l(-.39,-.676),l(.005,-.325),l(.28,-.567),l(.657,-.979),l(.279,-.199),l(1.449,.585),
N(462.462,268.501),l(-.739,-.561),l(-.285,-.366),l(-.582,-.858),l(-.12,-.409),l(.691,-.611),l(.275,-.44),l(.513,-.567),l(.65,-.329),l(.995,-.359),l(.308,-.086),l(.422,.266),l(.33,.337),l(.967,.744),l(.104,.226),l(-.143,.241),l(-.268,.326),l(-.582,1.007),l(-.263,.199),l(-1.035,.303),l(-.633,.343),l(-.194,.553),l(-.412,.044),
N(790.15,283.022),l(.738,.197),l(.008,-.227),l(-.242,-.524),l(.052,-.284),l(.233,.014),l(.389,.17),l(.37,.751),l(.277,.964),l(.48,.17),l(1.753,.691),l(.506,.113),l(.37,-.072),l(.699,-.483),l(.885,-.343),l(.4,.027),l(.329,.17),l(.066,.454),l(-.022,.198),l(-.402,1.236),l(-.283,.072),l(-.761,.058),l(-.035,.683),l(-.124,.156),l(-.424,.029),l(-.746,.016),l(-.432,.2),l(-.271,.284),l(.041,.384),l(.254,.525),l(-.002,.213),l(-.151,.199),l(-.646,.515),l(-.898,1.129),l(-.847,1.058),l(-.756,.587),l(-.68,.316),l(-.337,-.171),l(-.47,-.313),l(-.237,-.328),l(.056,-.314),l(.288,-.386),l(.307,-.671),l(.398,-.5),l(-.031,-.343),l(-.271,-.128),l(-.761,-.582),l(-.421,-.185),l(-.593,-.184),l(-.98,-.452),l(-.306,-.256),l(-.11,-.17),l(.081,-.128),l(.419,-.157),l(1.389,-.685),l(.209,-.512),l(-.078,-.695),l(.087,-.312),l(.396,-.441),l(.032,-.383),l(-.482,-.837),l(.081,-.567),l(-.156,-.311),l(-.479,-.655),l(-.574,-.678),l(.102,-.164),l(-.145,-.304),l(-.291,-.351),l(-.336,-.188),l(-.29,-.163),l(.117,.233),l(.497,.515),l(.049,.141),l(-.169,0),l(-.211,-.281),l(-.525,-.631),l(-.622,-.771),l(-.518,-.561),l(.001,-.117),l(-.268,-.257),l(.04,-.141),l(.013,-.14),l(-.048,-.188),l(-.197,-.396),l(-.379,-.42),l(-.347,-.257),l(.163,-.046),l(.205,.093),l(.358,-.047),l(.131,-.093),l(.084,.28),l(-.149,.187),l(.186,.303),l(.177,.21),l(.167,.116),l(.228,.164),l(.041,-.141),l(.269,.023),l(.519,.257),l(.42,.117),l(.274,.07),l(.128,.257),l(-.011,.141),l(.185,.023),l(.146,-.188),l(.185,.023),l(-.022,.164),l(.227,.351),l(.249,.187),l(.233,.28),l(-.18,.023),l(-.076,.164),l(.093,.163),l(-.242,-.023),l(-.175,-.047),l(.143,.117),l(.251,.188),l(.23,.233),l(.352,.28),l(.063,.234),l(.019,.21),l(-.261,-.047),l(.096,.164),l(.239,.351),l(.256,.188),l(-.292,.023),l(-.226,0),l(-.205,-.047),l(-.006,.141),l(.306,.14),l(.324,.164),l(-.09,.211),l(.205,.046),l(.265,-.023),l(.226,0),l(.223,.141),l(-.114,.07),l(-.031,.141),l(.025,.141),l(.136,.06),M(782.939,297.694),l(-.088,.158),l(-.558,.13),l(-.309,.288),l(-.322,.101),l(-.246,.244),l(-.692,-.242),l(-.16,.086),l(.15,.216),l(.429,.415),l(-.141,.173),l(.02,.259),l(-.064,.431),l(-.218,-.071),l(-.976,-.099),l(.418,.229),l(.449,.244),l(-.278,.49),l(-.427,.896),l(-.212,.549),l(-.418,.318),l(-.673,.349),l(-.171,.246),l(-.259,.145),l(-.581,.233),l(-.593,.406),l(-.398,.015),l(-1.156,-.258),l(-.628,.112),l(-.585,-.442),l(-.812,-.158),l(-.373,-.066),l(-.162,-.308),l(-.467,-.098),l(-.24,.142),l(-.062,.168),l(-.78,.095),l(-.214,-.166),l(-.515,-.095),l(-.146,-.286),l(.432,-.089),l(-.223,-.216),l(.328,-.116),l(.322,-.001),l(-.452,-.482),l(.82,.266),l(-.464,-.576),l(.121,-.145),l(.946,.156),l(.082,-.13),l(-.141,-.173),l(-.201,-.216),l(-.06,-.288),l(.283,-.303),l(.569,-.246),l(.328,-.374),l(.561,-.375),l(.102,-.302),l(.998,-.575),l(1.106,-.275),l(.713,-.331),l(.544,-.36),l(.377,-.101),l(.685,-.575),l(.066,-.272),l(.48,-.302),l(.373,-.015),l(.787,-.331),l(.664,-.402),l(.126,-.215),l(-.008,-.172),l(.266,-.144),l(.448,-.302),l(-.109,-.501),l(.076,-.214),l(.166,-.44),l(.306,.048),l(.066,-.152),l(.58,-.259),l(.444,-.272),l(.137,-.285),l(.131,-1.187),l(.512,-.647),l(.372,.047),l(.365,.165),l(.032,.259),l(.337,.06),l(.187,.186),l(.231,.799),l(.312,.242),l(.973,-.645),l(.426,-.029),l(.367,.113),l(.222,.5),l(-.197,.399),l(.299,.429),l(.066,.271),l(-.611,.659),l(-.261,.401),l(-.476,.358),l(-.868,.746),l(-.578,.359),l(-.295,.13),l(-.236,.258),l(-.389,.159),l(-.271,.258),l(.416,.407),l(.428,.047),l(.421,.289),l(-.276,.113),l(-.484,.07),l(-.503,-.296),l(-.488,.131),l(-.352,.158),
N(247.899,318.387),l(.008,-1.144),l(.821,.289),l(.06,.206),l(-.354,.312),l(-.534,.337),M(248.453,316.576),l(-.286,-.039),l(-1.385,-.36),l(-.841,-.217),l(-2.827,-.132),l(-1.41,.052),l(-.669,-.041),l(-.778,-.568),l(-.231,-2.285),l(-.187,-.248),l(-.654,.121),l(-.961,.283),l(-.218,-.043),l(-.508,-1.123),l(-.28,-1.309),l(.037,-.45),l(.271,-.292),l(1.729,-1.01),l(.307,-.263),l(.296,-1.218),l(.069,-.188),l(-.446,-.648),l(.249,-.781),l(.28,-.219),l(.598,-.161),l(.226,-.262),l(.212,-.434),l(.216,-.896),l(-.158,-1.035),l(.059,-1.094),l(.767,-.794),l(-.017,-.216),l(-.552,-.385),l(-.586,-.298),l(-.176,-.171),l(.757,-.146),l(.726,-.033),l(.322,-.13),l(.245,-.202),l(.007,-.186),l(-.302,-.17),l(-.789,-.11),l(-.26,-.185),l(-.252,-.585),l(.191,-1.458),l(-.088,-.655),l(-.555,-.111),l(-.125,-.128),l(-.094,-1.226),l(.106,-.271),l(.172,-.172),l(.596,-.317),l(-.012,-.427),l(-.231,-.867),l(-.123,-1.835),l(.1,-.37),l(.316,-.541),l(.511,-2.427),l(.053,-.312),l(.126,-.17),l(.951,-.529),l(.202,-.143),l(-.437,-.932),l(-.249,-1.103),l(-.014,-1.16),l(.142,-1.075),l(.231,-.312),l(1.334,-1.11),l(.078,-.325),l(-.189,-1.06),l(-.088,-.409),l(.319,-.595),l(1.083,-1.854),l(.075,-.41),l(-.055,-.69),l(-.784,-2.816),l(-.408,-1.154),l(-.285,-.633),l(.156,-.961),l(.388,-1.201),l(.292,-.34),l(.492,-.271),l(.124,-.185),l(-.054,-.762),l(-.167,-1.466),l(.823,-1.839),l(.282,-.439),l(.608,-.694),l(.464,-.835),l(.329,-.835),l(.791,-.089),l(.333,-.017),l(.152,-.311),l(-.011,-.227),l(-.53,-.477),l(-.114,-.507),l(.161,-.382),l(.273,-.369),l(-.03,-.226),l(-.34,-.449),l(-.113,-.437),l(.007,-.579),l(.421,-.722),l(-.25,-.817),l(.204,-.312),l(.819,-.372),l(1.346,-.53),l(.36,-.256),l(.541,-1.457),l(.093,-.636),l(-.161,-.154),l(-.212,-.14),l(-.107,-.056),l(2.026,-2.087),l(.292,-.27),l(.322,.181),l(.193,.169),l(.615,.194),l(.901,-.034),l(.527,-.045),l(.531,.067),l(.37,.195),l(.341,.309),l(.416,1.084),l(1.034,-1.784),l(.686,-.004),l(1.33,.077),l(.592,.109),l(.19,.056),l(.225,.337),l(.782,.913),l(1.271,1.376),l(.576,.562),l(.835,.588),l(.498,.237),l(1.173,.204),l(.671,.307),l(1.632,1.106),l(1.448,.697),l(.65,.18),l(.939,.503),l(-.018,.268),l(-.617,1.203),l(-.625,.851),l(-.048,.227),l(.21,.619),l(-.11,.198),l(-.486,.398),l(-.425,.426),l(-.064,.212),l(.19,.056),l(1.187,-.332),l(.607,.025),l(.992,.333),l(.564,.096),l(.71,-.005),l(.745,-.131),l(.387,-.172),l(.235,-.029),l(.35,.097),l(.609,.363),l(.352,-.51),l(.301,-.27),l(1.007,-.74),l(.375,-.468),l(.544,-1.57),l(-.02,-.239),l(.957,-.161),l(.462,-.017),l(.206,.196),l(.517,1.154),l(-.094,1.638),l(-.161,.467),l(-.521,.313),l(-1.754,.744),l(-.348,.242),l(-1.633,1.448),l(-1.435,1.363),l(-1.805,1.816),l(-.833,.88),l(-.214,.27),l(-.443,.524),l(-.065,.452),l(-.595,2.359),l(-.103,.522),l(.049,.847),l(.168,.986),l(-.118,.325),l(-.48,.524),l(-.24,.495),l(-.011,.522),l(.194,.577),l(-.054,.338),l(-.162,.273),l(-.26,.325),l(.015,.226),l(.924,.831),l(.68,.281),l(.715,.281),l(.283,.169),l(.281,.325),l(-.025,.325),l(-.362,.523),l(-.043,.396),l(.105,.339),l(.174,.269),l(.466,.325),l(.522,.168),l(.109,.113),l(.226,.892),l(-.308,.481),l(-.75,.937),l(-.729,.766),l(-.313,.737),l(-.368,.284),l(-.832,.342),l(-1.04,.342),l(-1.92,.401),l(-1.795,.188),l(-1.361,.116),l(-.945,.044),l(-1.175,-.11),l(-.934,-.226),l(-.128,.199),l(.036,.808),l(.322,.312),l(.308,.184),l(-.09,.298),l(-.381,.624),l(-.345,.498),l(-.069,.385),l(.392,.682),l(.066,.285),l(-.208,.214),l(-.105,.057),l(-1.251,.473),l(-1.137,.116),l(-.814,-.069),l(-.967,-.34),l(-1.47,-.396),l(-.246,.057),l(-.23,.271),l(.041,.598),l(.429,.684),l(.037,.398),l(-.242,.643),l(.092,.385),l(.773,.54),l(.796,.084),l(.369,-.2),l(-.387,-.398),l(.872,-.188),l(.383,-.043),l(.234,1.041),l(.052,.3),l(-.144,.157),l(-.299,.101),l(-.448,.072),l(-.261,-.157),l(-.104,-.299),l(-.115,-.071),l(-1.046,.073),l(-.67,.201),l(-.212,.101),l(.151,.214),l(.591,.07),l(.47,.113),l(.452,.113),l(.06,.028),l(-.864,.388),l(-.776,.287),l(-.577,.602),l(.003,.414),l(.161,.787),l(-.081,.258),l(-.815,.817),l(.022,.215),l(.423,.371),l(-.491,.116),l(-1.194,.088),l(-.48,.087),l(-.632,.246),l(-.619,.389),l(-.56,.548),l(-.549,.821),l(-.052,.389),l(.061,.375),l(.312,.591),l(.48,.446),l(.98,.633),l(.657,.244),l(.97,.143),l(.362,.086),l(.14,.274),l(-.151,.796),l(-.128,.348),l(-.342,.464),l(-.189,.145),l(-1.08,.524),l(-1.541,.814),l(-.712,.698),l(-.179,.276),l(-.093,.45),l(.111,.523),l(-.169,.451),l(-.239,.32),l(-.97,.454),l(-.969,.25),l(-.421,.221),l(-.323,.396),l(-.226,.791),l(-.054,.514),l(.2,.777),l(.547,.896),l(.699,.779),l(.235,.339),l(-.101,.032),M(247.899,318.387),l(.18,.182),l(.148,.073),l(.607,-.075),l(.344,.133),l(.648,.725),l(.908,.665),l(.993,.756),l(.525,.222),l(.73,.37),l(.246,.074),l(.42,-.001),l(.483,.163),l(1.283,.027),l(.142,-.016),l(-.006,.224),l(-.19,.209),l(-.492,.06),l(-1.198,.092),l(-.777,.196),l(-.364,0),l(-1.179,-.355),l(-.753,-.088),l(-1.15,-.027),l(-.814,-.014),l(-.831,.081),l(.098,-3.675),
N(346.758,54.457),l(.127,-.162),l(.42,-.179),l(.894,.015),l(.674,-.098),l(-.354,-.227),l(-.405,-.34),l(.317,-.342),l(.277,0),l(.956,.42),l(.67,.048),l(.3,-.163),l(-.191,-.26),l(-.625,-.373),l(.366,-.245),l(1.037,.226),l(.957,.08),l(.746,.275),l(.446,.551),l(-.119,.405),l(-.441,.292),l(.922,.806),l(.553,-.356),l(.352,-.13),l(.63,-.114),l(.49,-.179),l(.061,-.21),l(-.169,-.778),l(.542,-.245),l(.501,.454),l(.426,.307),l(.489,.209),l(.215,.016),l(.185,-.13),l(-.264,-.454),l(.243,-.163),l(.27,-.033),l(.817,-.164),l(.683,.438),l(.536,.242),l(.542,.063),l(.05,-.178),l(-.358,-.535),l(1.006,.145),l(1.439,.079),l(.787,-.115),l(.427,-.229),l(-.021,-.716),l(1.167,.08),l(.635,.471),l(1.118,.323),l(.683,.015),l(.273,.243),l(-.252,.552),l(.786,.29),l(1.674,.159),l(.127,.145),l(.143,.548),l(-.07,.387),l(-.152,.256),l(-.152,.256),l(-.443,.129),l(-.815,.018),l(-.195,.096),l(-.04,.431),l(-.515,.463),l(-.497,.16),l(-.568,-.031),l(-.422,-.159),l(-.817,.495),l(-.539,.144),l(-1.46,.463),l(-.853,.113),l(-.726,.001),l(-.771,.097),l(-.784,.587),l(-.473,.127),l(-1.078,.097),l(-.709,-.03),l(-1.316,-.171),l(-.608,-.142),l(-1.283,-.489),l(-1.058,-.093),l(-.443,.064),l(-1.041,-.014),l(-1.834,-.124),l(-.297,-.206),l(.434,-.191),l(1.127,-.352),l(.701,-.59),l(-.818,-.015),l(-.51,-.126),l(-.428,-.398),l(-.253,-.095),l(-.358,.081),l(-1.564,.115),l(-.557,.033),l(-.37,-.223),l(.141,-.192),l(.388,-.129),l(.669,-.097),l(.794,-.017),l(.729,-.114),l(1.049,-.098),l(.376,-.194),l(.178,-.322),l(-.144,-.258),l(-.358,-.177),l(-.426,-.015),l(-.478,-.145),l(-1.005,-.047),l(-.821,.099),l(-.424,.162),l(-.676,.082),l(-1.041,-.272),l(-.16,-.21),
N(462.829,67.958),l(.145,.053),l(.16,.131),l(-.043,.174),l(-.175,.044),l(-.189,0),l(-.116,0),l(-.088,.043),l(-.058,.131),l(-.175,.277),l(-.219,.204),l(-.319,.131),l(-.204,.131),l(-.088,.16),l(.029,.16),l(.131,.437),l(.073,.189),l(.029,.16),l(-.175,.131),l(0,.175),l(.175,.233),l(.203,.087),l(.088,.073),l(0,.073),l(.015,.087),l(.043,.146),l(.175,.043),l(.059,.059),l(-.175,.073),l(-.262,.043),l(-.16,.058),l(-.059,.102),l(-.087,.116),l(-.131,0),L(461.402,72),l(-.015,.087),l(-.116,.058),l(.081,.106),l(-.125,.025),l(-.087,-.015),l(-.306,-.043),l(-.16,-.058),l(-.175,-.073),l(-.204,-.044),l(-.131,.102),l(-.204,-.029),l(-.131,.044),l(-.16,.087),l(-.146,.014),l(-.146,-.087),l(-.116,-.029),l(-.175,0),l(-.204,-.117),l(-.116,-.174),l(-.203,-.117),l(-.146,-.043),l(-.072,-.117),l(-.189,0),l(-.247,-.043),l(-.204,-.117),l(-.029,0),l(-.276,-.014),l(-.102,-.102),l(-.248,-.043),l(-.116,-.102),l(-.189,-.087),l(0,.073),l(-.116,.087),l(-.131,-.058),l(-.015,-.073),l(-.087,-.029),l(-.103,0),l(-.276,.117),l(-.102,.029),l(-.131,.015),l(-.219,.015),l(-.146,.043),l(-.262,.029),l(-.276,.087),l(-.116,.102),l(-.087,0),l(.156,-.19),l(-.003,-.351),l(.183,-.238),l(-.368,-.21),l(-.605,.437),l(-.334,-.251),l(-.527,-.038),l(.043,-.942),l(-.396,.188),l(-.336,-.415),l(.158,-.202),l(-.209,-.254),l(.265,-.074),l(-.092,-.252),l(.344,-.042),l(1.026,-.084),l(-.006,-.132),l(.561,-.108),l(.133,-.188),l(.436,.101),l(.074,-.113),l(.317,.05),l(.083,-.215),l(1.104,.193),l(.446,-.294),l(.091,.165),l(.514,-.089),l(1.383,.029),l(1.152,.167),l(.305,.12),l(.592,-.045),l(.971,.09),l(.426,-.108),l(.271,-.24),l(-.006,-.009),
N(461.353,72.251),l(.37,-.004),l(-.015,.116),l(0,.117),l(.232,.073),l(.204,.087),l(.087,.073),l(.204,.058),l(-.015,.087),l(-.029,.116),l(-.015,.087),l(-.102,.073),l(-.087,.015),l(-.103,.029),l(.131,.087),l(-.072,.131),l(.029,.117),l(-.073,.087),l(-.102,.073),l(-.044,.102),l(.204,-.059),l(.146,-.015),l(.131,.073),l(.087,.014),l(.073,.044),l(-.059,.087),l(-.043,.073),l(.116,.102),l(.131,.058),l(.029,.16),l(.146,.102),l(.16,.043),l(-.059,.087),l(.131,.117),l(-.015,.189),l(.088,.233),l(-.044,.087),l(-.015,.117),l(-.061,.042),l(-.241,.044),l(-.24,.051),l(-.12,.12),l(-.223,.034),l(-.137,.154),l(-.137,.085),l(-.069,.103),l(-.068,.206),l(-.188,.035),l(-.239,-.035),l(-.24,-.034),l(-.325,-.034),l(-.359,0),l(-.172,.068),l(-.103,.137),l(-.223,.085),l(-.154,0),l(-.103,-.017),l(-.086,.052),l(-.377,-.035),l(-.273,-.068),l(-.154,-.171),l(-.138,-.154),l(-.325,-.137),l(-.497,-.223),l(-.342,-.24),l(-.377,-.034),l(-.583,-.035),l(-.325,-.12),l(-.291,-.188),l(-.086,-.257),l(-.188,.017),l(-.171,.068),l(-.36,.171),l(-.394,.017),l(-.24,0),l(-.273,.085),l(-.24,-.085),l(-.309,-.103),l(-.6,-.017),l(-.291,.069),l(-.359,-.069),l(-.291,-.051),l(-.154,.034),l(-.274,.069),l(-.103,-.052),l(-.12,-.137),l(-.154,0),l(-.257,.068),l(-.188,0),l(-.754,-.017),l(-.445,-.085),l(-.754,.171),l(-.599,.154),l(-.429,.103),l(-.257,.137),l(-.052,.188),l(-.526,.026),l(-.065,-.059),l(.073,-.837),l(.035,-.302),l(.127,-.167),l(.672,-.379),l(.034,-.717),l(.267,-.162),l(.267,-.273),l(.217,-.203),l(.296,-.026),l(1.056,-.199),l(.166,-.046),l(.162,-.066),l(.29,0),l(.049,.237),l(.657,.388),l(.422,.162),l(.23,.473),l(.091,.15),l(.441,.196),l(.785,.059),l(.868,-.244),l(.24,-.122),l(.178,-.288),l(-.052,-.394),l(-.193,-.869),l(.198,-.243),l(.045,-.055),l(.087,0),l(.116,-.102),l(.276,-.087),l(.262,-.029),l(.146,-.043),l(.219,-.015),l(.131,-.015),l(.102,-.029),l(.276,-.117),l(.103,0),l(.087,.029),l(.015,.073),l(.131,.058),l(.116,-.087),l(0,-.073),l(.189,.087),l(.116,.102),l(.248,.043),l(.102,.102),l(.276,.014),l(.029,0),l(.204,.117),l(.247,.043),l(.189,0),l(.072,.117),l(.146,.043),l(.203,.117),l(.116,.174),l(.204,.117),l(.175,0),l(.116,.029),l(.146,.087),l(.146,-.014),l(.16,-.087),l(.131,-.044),l(.204,.029),l(.131,-.102),l(.204,.044),l(.175,.073),l(.16,.058),l(.306,.043),l(.087,.015),l(.125,-.025),
N(451.02,79.165),l(-.029,-.038),l(-.034,-.137),l(-.018,-.171),l(.068,-.206),l(.068,-.154),l(.224,-.12),l(-.052,-.12),l(-.018,-.137),l(-.171,-.069),l(-.188,-.034),l(-.103,-.103),l(-.086,-.137),l(-.223,.017),l(-.257,0),l(-.445,0),l(-.223,.051),l(-.086,-.103),l(-.514,-.068),l(-.257,-.069),l(-.223,-.12),l(-.24,0),l(-.086,-.052),l(-.051,-.154),l(-.12,.034),l(-.353,.096),l(-.043,-.077),l(.128,-.012),l(.034,-.183),l(-.439,-.646),l(-.008,-.14),l(-.042,-.727),l(-.112,-.102),l(.526,-.026),l(.052,-.188),l(.257,-.137),l(.429,-.103),l(.599,-.154),l(.754,-.171),l(.445,.085),l(.754,.017),l(.188,0),l(.257,-.068),l(.154,0),l(.12,.137),l(.103,.052),l(.274,-.069),l(.154,-.034),l(.291,.051),l(.359,.069),l(.291,-.069),l(.6,.017),l(.309,.103),l(.24,.085),l(.273,-.085),l(.24,0),l(.394,-.017),l(.36,-.171),l(.171,-.068),l(.188,-.017),l(.086,.257),l(.291,.188),l(.325,.12),l(.583,.035),l(.377,.034),l(.342,.24),l(.497,.223),l(.325,.137),l(.138,.154),l(.154,.171),l(.273,.068),l(.377,.035),l(-.017,.171),l(-.086,.154),l(-.034,.12),l(-.12,.137),l(-.086,.137),l(.343,.034),l(.274,.052),l(.085,.051),l(-.119,.051),l(-.086,0),l(-.103,.154),l(-.018,.154),l(-.171,.017),l(-.12,-.086),l(-.12,.051),l(-.239,-.034),l(-.154,.034),l(-.086,.154),l(-.103,.154),l(-.257,.068),l(-.429,0),l(-.137,.137),l(-.12,.12),l(-.034,.154),l(-.086,.171),l(.103,.171),l(-.068,.137),l(-.239,.154),l(0,.137),l(-.068,.085),l(-.069,.137),l(.172,.034),l(.205,0),l(.138,.206),l(-.086,.188),l(-.274,.017),l(-.223,-.068),l(0,-.154),l(-.034,-.085),l(-.086,-.069),l(-.171,.051),l(-.12,.086),l(-.291,-.034),l(-.068,.137),l(-.24,.12),l(-.154,0),l(-.188,-.034),l(-.273,.103),l(.086,.171),l(-.069,.12),l(-.171,.034),l(-.137,-.034),l(-.206,.051),l(-.377,.154),l(-.291,0),l(-.068,-.103),l(-.12,-.051),l(-.239,.051),l(-.377,.017),l(-.24,.034),l(-.291,-.034),l(-.154,.034),l(-.093,-.035),l(-.09,-.171),l(-.016,-.029),l(-.099,-.186),l(-.284,-.487),l(-.679,-.243),l(-.04,-.014),l(-.641,.021),
N(452.867,80.273),l(.093,.035),l(.154,-.034),l(.291,.034),l(.24,-.034),l(.377,-.017),l(.239,-.051),l(.12,.051),l(.068,.103),l(.291,0),l(.377,-.154),l(.206,-.051),l(.137,.034),l(.171,-.034),l(.069,-.12),l(-.086,-.171),l(.273,-.103),l(.188,.034),l(.154,0),l(.24,-.12),l(.068,-.137),l(.291,.034),l(.12,-.086),l(.171,-.051),l(.086,.069),l(.034,.085),l(0,.154),l(.223,.068),l(.274,-.017),l(.086,-.188),l(-.138,-.206),l(-.205,0),l(-.172,-.034),l(.069,-.137),l(.068,-.085),l(0,-.137),l(.239,-.154),l(.068,-.137),l(-.103,-.171),l(.086,-.171),l(.034,-.154),l(.12,-.12),l(.137,-.137),l(.429,0),l(.257,-.068),l(.103,-.154),l(.086,-.154),l(.154,-.034),l(.239,.034),l(.12,-.051),l(.12,.086),l(.171,-.017),l(.018,-.154),l(.103,-.154),l(.086,0),l(.119,-.051),l(-.085,-.051),l(-.274,-.052),l(-.343,-.034),l(.086,-.137),l(.12,-.137),l(.034,-.12),l(.086,-.154),l(.017,-.171),l(.086,-.052),l(.103,.017),l(.154,0),l(.223,-.085),l(.103,-.137),l(.172,-.068),l(.359,0),l(.325,.034),l(.24,.034),l(.239,.035),l(.188,-.035),l(.068,-.206),l(.069,-.103),l(.137,-.085),l(.137,-.154),l(.223,-.034),l(.12,-.12),l(.24,-.051),l(.241,-.044),l(.165,.147),l(.229,.066),l(.197,-.131),l(.181,.016),l(.312,.033),l(.132,.148),l(.082,.148),l(.197,-.033),l(.214,-.065),l(.361,-.049),l(.312,.049),l(.296,.065),l(.147,.017),l(0,.115),l(-.164,.099),l(-.017,.099),l(.065,.148),l(.164,.148),l(.197,0),l(.214,-.197),l(.279,-.016),l(.165,0),l(.147,-.099),l(.23,-.083),l(.131,.049),l(.099,.049),l(.247,-.049),l(.542,.115),l(.132,.131),l(.279,.099),l(.099,.099),l(.147,.099),l(.165,.033),l(.147,-.033),l(.049,.115),l(-.065,.115),l(0,.083),l(-.033,.164),l(-.131,.165),l(.197,.247),l(.147,.099),l(.05,.164),l(-.066,.131),l(-.114,0),l(0,.083),l(-.115,.082),l(-.099,.049),l(-.033,.165),l(-.049,.147),l(.345,.049),l(.132,.181),l(.082,.115),l(.181,-.049),l(.132,.033),l(-.099,.115),l(-.066,.131),l(.017,.099),l(.214,.017),l(.164,.263),l(.115,.23),l(.443,.213),l(.23,.066),l(.279,.082),l(.164,.099),l(.066,.148),l(-.099,.197),l(-.066,.181),l(.182,.066),l(.361,-.066),l(.378,.066),l(.361,.099),l(.263,.066),l(-.032,.065),l(-.066,.049),l(-.082,.017),l(.099,.181),l(.296,.148),l(.279,.066),l(.033,.131),l(-.065,.164),l(-.296,0),l(-.148,.083),l(-.049,.065),l(-.444,.247),l(-.525,.099),l(-.51,-.016),l(-.197,-.132),l(-.328,-.049),l(-.362,.017),l(-.131,.165),l(-.099,.131),l(.017,.164),l(.279,.263),l(.296,.164),l(0,.165),l(-.132,.066),l(.099,.148),l(.147,.131),l(-.082,.099),l(.033,.164),l(.033,.23),l(-.033,.099),l(.164,.082),l(.082,.115),l(.165,.066),l(.002,.142),l(-.519,-.005),l(-.522,.056),l(-.112,.131),l(-.205,-.056),l(-.187,-.037),l(-.336,.075),l(-.057,.13),l(-.111,.112),l(-.317,.187),l(-.188,.261),l(-.261,.224),l(-.057,.206),l(.243,.205),l(.056,.149),l(-.131,.206),l(-.261,-.019),l(-.149,-.056),l(-.149,-.206),l(-.112,-.056),l(-.187,-.075),l(-.224,-.037),l(-.225,.037),l(-.242,.075),l(-.299,.019),l(-.149,-.131),l(-.224,.075),l(-.188,.093),l(-.316,.056),l(-.188,-.056),l(-.037,-.205),l(-.112,-.131),l(-.168,-.131),l(-.13,.038),l(-.131,.075),l(-.168,0),l(-.299,.149),l(-.131,.149),l(-.168,0),l(-.094,-.187),l(-.13,-.075),l(-.206,0),l(-.224,.112),l(-.131,-.187),l(-.224,-.093),l(-.131,.112),l(-.354,.056),l(-.262,-.112),l(-.112,0),l(-.019,.205),l(-.168,.093),l(-.093,-.056),l(.056,-.224),l(-.243,-.038),l(-.187,-.056),l(-.541,.112),l(0,-.149),l(-.187,0),l(.019,-.224),l(-.28,-.037),l(-.242,.075),l(-.523,-.112),l(-.578,-.056),l(-.075,-.056),l(-.522,0),l(-.205,-.168),l(-.262,.019),l(-.522,-.093),l(-.467,.075),l(-.485,0),l(-.354,-.056),l(-.355,.056),l(-.354,.056),l(-.485,-.038),l(-.485,.019),l(-.205,.187),l(-.037,.168),l(-.374,.168),l(-.373,.206),l(-.112,-.112),l(-.261,0),l(-.374,-.019),l(-.037,.131),l(0,.045),l(-.126,-.137),l(.315,-.752),l(-.013,-.25),l(-.218,-.146),l(-.149,-.176),l(-.421,-.146),l(-.289,-.012),l(.128,-.292),l(.291,-.328),l(.571,-.244),l(.44,-.03),l(.263,-.208),l(.023,-.236),l(-.172,-.502),l(-.615,-1.5),l(-.16,-.302),
N(400.125,81.146),l(.633,.305),l(.208,.207),l(.208,.37),l(-.038,.193),l(-.545,.563),l(.714,.176),l(.396,-.311),l(.527,-.119),l(.602,.028),l(.807,.176),l(.467,.354),l(.235,.752),l(-.077,.221),l(-.322,.414),l(-1.068,.473),l(-.767,.561),l(-.96,.237),l(1.223,.167),l(.501,.043),l(.354,-.104),l(.39,.117),l(-.066,.516),l(-.997,.308),l(.005,.199),l(-.479,-.084),l(-1.068,.443),l(-.879,-.142),l(-.293,-.048),l(-1.119,.211),l(-.587,-.211),l(-.598,.112),l(-1.584,.141),l(.137,.295),l(-.907,-.168),l(-.264,.168),l(-.911,-.337),l(-.334,.143),l(-.913,.089),l(-.093,.569),l(-.337,.316),l(-.37,.042),l(-.272,-.252),l(-.53,-.172),l(-.135,.151),l(-.527,-.077),l(-.948,.324),l(-.701,.552),l(-.326,-.231),l(-.775,-.147),l(1.2,-.472),l(.492,-.476),l(.447,-.097),l(.468,-.388),l(.118,-.485),l(.242,.063),l(.367,-.211),l(-.008,-.274),l(1.013,-.105),l(.76,.119),l(.927,.007),l(.073,-.338),l(.308,-.142),l(.321,-.556),l(-.939,.394),l(-.725,.016),l(-1.467,-.482),l(-1.866,-.055),l(-.399,-.191),l(-.156,-.162),l(.417,-.325),l(.983,-.194),l(.721,-.237),l(.38,-.384),l(.066,-.827),l(-.119,-.192),l(-.713,.046),l(-.34,-.044),l(.288,-.355),l(.387,-.223),l(.802,-.253),l(1.394,-.062),l(.922,-.076),l(-.316,-.548),l(.172,-.683),l(.253,-.461),l(-.045,-.312),l(-.834,.061),l(-.484,-.296),l(-.2,-.312),l(.309,-.507),l(.617,-.433),l(-.347,-.104),l(-.596,-.088),l(-.735,.3),l(-.476,.061),l(-.753,-.222),l(-.088,.194),l(-.222,.194),l(-.672,-.103),l(-.464,-.133),l(.1,-.343),l(.348,-.36),l(.604,-.706),l(-.293,-.134),l(-.305,-.39),l(.028,-.24),l(.304,-.106),l(.3,-.196),l(-.194,-.496),l(-.306,.076),l(-.636,.453),l(-.442,.031),l(-.526,.287),l(-.14,-.421),l(.302,-.527),l(.438,-.559),l(.065,-.257),l(-.417,-.195),l(-.196,-.045),l(-.218,.302),l(-.394,.257),l(-.493,-.165),l(.299,-.575),l(.54,-.455),l(.09,-.136),l(-.225,-.575),l(.366,-.092),l(.225,-.197),l(-.672,-.515),l(.432,-.351),l(.752,.151),l(.387,-.092),l(-.645,-.759),l(.975,-.169),l(-.457,-.502),l(.416,-.382),l(.924,.365),l(.824,-.093),l(.686,-.139),l(.867,-.047),l(.612,.014),l(.303,.259),l(-.307,.29),l(-1.726,.704),l(-.46,.274),l(-.218,.441),l(.222,.182),l(.784,.029),l(.877,-.078),l(.685,-.001),l(.53,.075),l(1.563,-.064),l(.458,.378),l(-.363,.425),l(-.212,.323),l(.098,.112),l(-.565,.66),l(-.226,.111),l(-.339,.437),l(-.696,.261),l(-.382,.038),l(.451,.186),l(.508,.167),l(-.116,.015),l(-.272,.19),l(-.61,.052),l(-.275,.196),l(-1.337,-.025),l(.404,.223),l(.302,0),l(.492,.093),l(.432,-.006),l(.519,-.223),l(.413,-.025),l(.449,.161),l(.656,.164),l(.673,.566),l(.496,.228),l(.118,.165),l(-.067,.238),l(.312,.78),l(.371,.536),l(.438,.189),l(.714,.107),l(.59,.549),l(.688,.593),l(.135,.52),l(-.188,.49),l(.257,.124),M(387.915,77.13),l(-.128,-.325),l(.149,-.335),l(.38,-.089),l(.079,.501),l(-.307,.251),l(-.173,-.003),M(386.786,80.184),l(-.178,-.272),l(-.967,.072),l(.123,-.256),l(-.364,-.15),l(-.26,-.257),l(-.335,-.107),l(-.253,.364),l(-.751,.257),l(-.778,-.192),l(-.401,-.278),l(-.101,-.278),l(.86,-.278),l(-.483,-.257),l(.817,-.107),l(.385,-.484),l(-.029,-.235),l(.449,-.09),l(.508,-.15),l(.781,-.077),l(.424,.044),l(.389,.104),l(.362,-.046),l(.218,.149),l(.519,.791),l(.047,.179),l(-.081,.298),l(.308,.446),l(-.155,.328),l(-.402,.328),l(-.354,.12),l(-.299,.038),
N(578.943,106.217),l(-.41,-.375),l(-.466,-.098),l(-.663,0),l(-.196,-.27),l(-.27,-.147),l(-.147,-.344),l(-.564,.049),l(-.981,-.246),l(-.662,.074),l(-1.35,-.024),l(-.662,-.098),l(-.712,-.221),l(-.785,.147),l(-.761,0),l(-.858,.024),l(-.441,.27),l(-.54,-.098),l(-.908,-.196),l(-.735,-.246),l(-.761,-.27),l(-.589,-.074),l(-.688,.123),l(-.466,.368),l(-.245,.736),l(.024,.442),l(-.344,-.123),l(-.81,-.123),l(-.688,-.196),l(-.883,-.245),l(-.883,-.147),l(-.663,.098),l(-.736,.123),l(-.318,.368),l(-.393,.442),l(.044,.273),l(-.322,.031),l(-.377,.377),l(-.283,-.126),l(-.22,.063),l(-.346,.283),l(-.534,.471),l(-.755,.189),l(-.943,.377),l(-.282,.188),l(-.221,.472),l(-.439,.188),l(-.504,.44),l(.157,.409),l(-.125,.188),l(-.66,0),l(-.44,-.346),l(.062,-.283),l(-.062,-.283),l(-.44,-.314),l(-.346,0),l(-1.006,.094),l(-.691,.032),l(-.503,-.063),l(-.346,-1.069),l(-.221,-.817),l(-1.006,0),l(-.031,-.754),l(.188,-.409),l(.031,-1.038),l(-.66,.314),l(-.66,-1.006),l(-.597,-.22),l(-.724,-.723),l(-1.1,.409),l(-2.767,-.188),l(-2.578,.346),l(-2.012,-1.666),l(-5.722,-2.986),l(-5.658,1.289),l(-.056,8.174),l(-.158,-.014),l(-.341,.106),l(-.489,.043),l(-.447,-.255),l(-.638,-.703),l(-.256,-.511),l(-.617,-.383),l(-.681,-.383),l(-.512,-.234),l(-.979,.085),l(-1.277,.298),l(-.937,.532),l(-.529,.453),l(.092,-.399),l(-.06,-.18),l(-.12,-.12),l(.14,-.26),l(.2,-.2),l(.14,-.32),l(.04,-.3),l(.18,-.2),l(-.159,-.24),l(-.4,-.16),l(-.459,.06),l(-.18,-.16),l(-.3,.06),l(-.2,.04),l(-.199,-.18),l(-.221,-.32),l(-.319,-.28),l(-.34,0),l(-.359,.02),l(0,-.2),l(.08,-.28),l(-.2,-.379),l(-.239,-.12),l(-.2,-.24),l(-.399,-.799),l(-.08,-.28),l(-.56,-.12),l(-.699,-.08),l(-.14,-.16),l(.02,-.439),l(.16,-.12),l(.3,-.06),l(.399,.02),l(.34,.02),l(.479,.14),l(.539,.18),l(.18,-.08),l(.36,-.08),l(-.2,-.16),l(-.26,-.12),l(-.399,-.2),l(-.2,-.24),l(.26,-.36),l(.28,-.04),l(.08,-.26),l(.18,-.299),l(.12,-.14),l(.26,.04),l(.319,-.08),l(.16,-.1),l(.339,.12),l(.24,0),l(1.119,-.04),l(.999,.14),l(.499,.02),l(-.159,-.08),l(-.34,-.2),l(-.479,-.12),l(-.021,-.3),l(.2,-.2),l(.279,-.22),l(.221,-.28),l(.119,-.52),l(.12,-.28),l(-.16,-.24),l(-.14,-.16),l(.1,-.2),l(.26,-.2),l(-.119,-.12),l(-.101,-.3),l(-.359,-.12),l(-.359,-.04),l(-.68,-.1),l(-.2,.16),l(-.199,.08),l(-.52,.08),l(-.46,-.12),l(-.319,-.26),l(-.26,-.06),l(-.68,-.12),l(-.56,.06),l(-.659,.319),l(-.42,.02),l(-.799,.5),l(-.72,.28),l(-.499,.06),l(-.42,-.02),l(-.279,.24),l(-.213,.18),l(-.616,-.19),l(-.857,-.377),l(-.068,-.308),l(.343,-.103),l(.309,.103),l(.445,.103),l(.138,-.103),l(-.96,-1.131),l(-.343,-.514),l(-.479,-.206),l(-.515,-.445),l(-.514,-.034),l(-.343,.034),l(-.583,-.206),l(-.103,.343),l(-.514,-.514),l(.068,-.309),l(-.138,-.377),l(-1.37,-.343),l(.65,-1.165),l(.446,-.274),l(.239,-.206),l(-.239,-.274),l(-.343,-.171),l(.205,-1.303),l(.823,-.137),l(.343,-.549),l(.103,-.308),l(.411,-.069),l(.514,.24),l(.48,.548),l(.514,.411),l(.651,0),l(.411,-.24),l(.068,-.446),l(-.171,-.411),l(-.068,-.445),l(.479,-.206),l(.891,-.411),l(.172,-.24),l(.309,-.309),l(.514,-.171),l(.549,-.068),l(.788,-.377),l(.548,-.343),l(.515,-.309),l(.651,.069),l(.479,0),l(.309,.274),l(.651,-.137),l(.273,-.137),l(.617,-.24),l(.411,.069),l(.411,.514),l(.788,.035),l(.617,-.069),l(.96,.171),l(0,.343),l(.582,.206),l(.789,.343),l(.411,.274),l(.068,.583),l(.274,.137),l(.239,-.274),l(-.205,-.48),l(-.034,-.24),l(.72,.068),l(.582,.548),l(.686,.137),l(.411,.24),l(.686,-.171),l(.274,-.274),l(.377,-.343),l(.514,-.377),l(.823,.068),l(.65,.035),l(.651,.411),l(.617,-.068),l(.137,-.412),l(1.062,-.103),l(.754,.103),l(.274,.548),l(.926,.309),l(.754,.137),l(.411,.171),l(.651,-.343),l(.171,-.309),l(.24,0),l(.343,.343),l(.959,.034),l(1.577,-.411),l(.137,-.309),l(.138,-.686),l(-.24,-.24),l(-1.165,-.171),l(-.274,-.308),l(-.651,-.069),l(-.377,-.137),l(.068,-.171),l(-.377,-.137),l(-.239,0),l(-.164,-.274),l(.467,-.067),l(.735,-.368),l(.588,-.147),l(.331,-.294),l(-.441,-.478),l(-.146,-.257),l(.662,-.515),l(.698,-.184),l(1.103,.147),l(.515,-.073),l(.11,-.257),l(-.956,-.294),l(-1.065,-.11),l(0,-.331),l(.294,-.074),l(-.294,-.221),l(-.074,-.441),l(.185,-.515),l(.33,-.074),l(1.066,.147),l(.515,0),l(.772,0),l(.368,-.184),l(1.396,-.405),l(1.029,-.037),l(.735,-.11),l(1.545,-.11),l(.588,-.073),l(.331,.073),l(.221,-.331),l(.625,-.331),l(1.177,-.037),l(2.021,-.405),l(1.876,-.073),l(.625,-.074),l(.367,-.368),V(0,77.39),l(.515,-.037),l(.589,-.184),l(.11,-.221),l(.735,-.037),l(.919,.147),l(.515,.11),l(.772,.257),l(.625,-.11),l(.882,-.037),l(.368,.404),l(-.037,.331),l(.147,.221),l(.515,.22),l(-.11,.331),l(-.147,.257),l(.073,.331),l(-.33,.037),l(.184,.257),l(.478,.074),l(.295,-.147),l(.44,.11),l(.368,-.147),l(.367,.074),l(.331,-.221),l(.294,.11),l(.295,.368),l(.367,.221),l(.147,-.147),l(.184,-.147),l(.478,.037),l(.405,.294),l(.478,.11),l(.441,-.221),l(.367,0),l(-.146,.294),l(-.441,.184),l(-.331,.441),l(.331,.184),l(.441,-.11),l(.771,-.073),l(.441,.037),l(.552,.184),l(.294,-.294),l(.772,-.441),l(1.103,-.257),l(.956,-.515),l(.772,-.221),l(.515,-.22),l(.809,-.074),l(0,.441),l(-.515,.11),l(-.11,.368),l(1.104,.588),l(.809,.294),l(1.287,.772),l(1.066,1.029),l(1.69,2.133),l(.846,.882),l(1.104,1.434),l(.515,-.257),l(.331,-.257),l(.367,-.515),l(.92,0),l(.367,.331),l(0,.368),l(.478,0),l(.258,.257),l(.184,.184),l(.589,0),l(.992,0),l(.993,-.221),l(.771,-.221),l(.993,-.037),l(.698,.441),l(.772,.588),l(.331,.625),l(.956,.147),l(.588,.552),l(.662,.699),l(.882,.073),l(.993,.074),l(.478,-.368),l(.625,-.184),l(-.073,.331),l(.441,.331),l(.294,.478),l(.589,0),l(.064,.145),l(-.551,.034),l(-.542,.148),l(-.279,.262),l(-.011,.275),l(-.035,.478),l(-.306,.219),l(-.289,.06),l(-1.199,.093),l(-.428,.277),l(-.34,.581),l(.097,.75),l(.213,.707),l(-.157,.39),l(-.444,.392),l(-.417,.103),l(-.718,.062),l(-1.402,-.079),l(-.594,-.141),l(-.721,-.141),l(-1.096,-.254),l(-.427,.507),l(-.516,1.141),L(584.2,97.43),l(-.286,.605),l(-.137,.418),l(.622,.514),l(.126,.286),l(-.156,.245),l(-.231,.145),l(-.394,.074),l(-1.133,-.238),l(-.5,-.184),l(-.35,.06),l(-1.082,.207),l(-1.799,.254),l(-.393,.188),l(-.215,.302),l(-.068,.215),l(.232,.185),l(.366,-.06),l(.483,.141),l(.03,1.357),l(.345,.627),l(.29,.441),l(.119,.47),l(-.222,.33),l(-.705,.546),l(-.32,.401),l(-.02,.399),l(.139,.86),
N(386.786,80.184),l(-.304,.038),l(-.223,.09),l(.241,.252),l(.361,.771),l(.287,1.213),l(-.061,.281),l(-.359,.341),l(-.242,.414),l(-.145,.473),l(-.185,.044),l(-.284,-.058),l(-.616,.031),l(-.15,.212),l(-.913,.042),l(-.84,.132),l(-.247,.144),l(-.661,.286),l(-.903,.498),l(-.628,.035),l(-.879,.283),l(-1.28,.084),l(.053,-.378),l(-.089,-.441),l(-.848,.1),l(-.171,-.487),l(.734,-.254),l(-1.186,-.021),l(.062,-.233),l(1.286,.027),l(.198,-.104),l(.039,-.222),l(.107,-.31),l(.515,-.134),l(.692,-.031),l(.13,-.281),l(-1.07,.099),l(.387,-.437),l(-.187,-.159),l(.481,-.468),l(.694,-.011),l(.163,-.089),l(-.174,-.311),l(-.348,.177),l(-.309,-.131),l(-.319,.03),l(-.391,-.177),l(-.414,.001),l(-.182,.106),L(378,81.478),l(.309,-.306),l(-.29,-.142),l(.759,-.126),l(-.139,-.301),l(.391,-.235),l(-.481,-.214),l(-.59,.128),L(378,79.792),l(.38,-.268),l(.215,-.16),l(.928,.187),l(.336,-.075),l(.527,.038),l(1.102,.123),l(-.214,-.358),L(382.132,79),l(.198,-.321),l(-1.373,0),l(.154,-.15),l(.569,-.107),l(.061,-.29),l(.291,-.479),l(.505,-.181),l(.804,-.169),l(.22,.302),l(.354,.149),l(.156,-.031),l(.029,.235),l(-.385,.484),l(-.817,.107),l(.483,.257),l(-.86,.278),l(.101,.278),l(.401,.278),l(.778,.192),l(.751,-.257),l(.253,-.364),l(.335,.107),l(.26,.257),l(.364,.15),l(-.123,.256),l(.967,-.072),l(.178,.272),
N(452.998,85.535),V(0,85.49),l(.037,-.131),l(.374,.019),l(.261,0),l(.112,.112),l(.373,-.206),l(.374,-.168),l(.037,-.168),l(.205,-.187),l(.485,-.019),l(.485,.038),l(.354,-.056),l(.355,-.056),l(.354,.056),l(.485,0),l(.467,-.075),l(.522,.093),l(.262,-.019),l(.205,.168),l(.522,0),l(.075,.056),l(.578,.056),l(.523,.112),l(.242,-.075),l(.28,.037),l(-.019,.224),l(.187,0),l(0,.149),l(.541,-.112),l(.187,.056),l(.243,.038),l(-.056,.224),l(.093,.056),l(.168,-.093),l(.019,-.205),l(.112,0),l(.262,.112),l(.354,-.056),l(.131,-.112),l(.224,.093),l(.131,.187),l(.224,-.112),l(.206,0),l(.13,.075),l(.094,.187),l(.168,0),l(.131,-.149),l(.299,-.149),l(.168,0),l(.131,-.075),l(.13,-.038),l(.168,.131),l(.112,.131),l(.037,.205),l(.188,.056),l(.316,-.056),l(.188,-.093),l(.224,-.075),l(.149,.131),l(.299,-.019),l(.242,-.075),l(.225,-.037),l(.224,.037),l(.187,.075),l(.112,.056),l(.149,.206),l(.149,.056),l(.261,.019),l(.131,-.206),l(-.056,-.149),l(-.243,-.205),l(.057,-.206),l(.261,-.224),l(.188,-.261),l(.317,-.187),l(.111,-.112),l(.057,-.13),l(.336,-.075),l(.187,.037),l(.205,.056),l(.112,-.131),l(.522,-.056),l(.519,.005),l(.357,.089),l(.469,.022),l(.313,-.156),l(.179,-.291),l(.134,-.268),l(.536,.246),l(.536,-.022),l(.67,-.223),l(.692,.112),l(.514,-.134),l(.201,.268),l(.312,.134),l(.246,.335),l(.134,.201),l(.246,.156),l(.312,.156),l(0,.268),l(-.312,-.022),l(-.312,.134),l(.134,.291),l(.111,.357),l(.269,.29),l(.647,0),l(.156,.112),l(.514,-.067),l(.38,.022),l(0,.312),l(.402,0),l(0,.357),l(.224,.268),l(.089,.246),l(-.089,.179),l(.089,.224),l(.179,.089),l(.291,.29),l(.268,-.179),l(.47,-.067),l(.268,.067),l(.469,.291),l(.201,-.067),l(.179,.022),l(.179,.156),l(.425,-.112),l(.312,-.112),l(.269,0),l(.536,-.134),l(.357,-.067),l(.111,.156),l(.268,.179),l(0,.134),l(.201,.179),l(.022,.134),l(.402,.044),l(.179,.179),l(.224,.112),l(.29,-.134),l(.045,-.157),l(.224,-.067),l(.29,.268),l(.425,.067),l(.469,.112),l(.268,.112),l(.357,-.067),l(.201,.179),l(.291,.089),l(.469,.022),l(.111,.224),l(.357,.156),l(.269,0),l(.134,-.044),l(.201,-.089),l(.156,.089),l(-.089,.111),l(-.022,.179),l(.111,.089),l(.09,.179),l(-.045,.224),l(-.201,.089),l(-.156,.067),l(-.357,.201),l(-.312,.044),l(.223,.246),l(.269,.089),l(.29,.044),l(-.134,.156),l(-.312,0),l(-.246,0),l(-.045,.179),l(-.044,.224),l(.156,.067),l(.179,.067),l(.044,.134),l(.045,.179),l(.09,.201),l(.066,.067),l(-.156,.491),l(-.156,.291),l(0,.156),l(-.335,.134),l(-.805,-.157),l(-.736,.045),l(-.269,0),l(-.022,.179),l(-.223,.179),l(-.38,.134),l(-.357,.022),l(-.224,.089),l(-.09,.514),l(0,.224),l(-.021,.112),l(-.012,.126),l(-.779,.104),l(-.971,.06),l(-.511,.405),l(-.729,.189),l(-1.135,.075),l(-1.119,.248),l(-.502,.318),l(-.463,.059),l(-.453,-.316),l(-.369,.621),l(-.31,.188),l(-.477,.044),l(-.438,-.057),l(-.959,.031),l(-.5,.16),l(.641,.287),l(1.957,1.004),l(.053,.172),l(-.093,.188),l(.163,.244),l(.562,.042),l(.511,-.13),l(.675,-.146),l(1.052,.013),l(.439,.114),l(-.235,.259),l(-.106,.245),l(-.228,.144),l(-.578,.116),l(-.31,.029),l(-.591,-.157),l(-.473,.044),l(-.71,.489),l(-1.007,.045),l(-.538,.188),l(-.527,.488),l(-.269,.101),l(-.786,-.07),l(-.588,-.171),l(.364,-.746),l(-.096,-.416),l(-.264,-.287),l(-.854,-.286),l(-.193,-.014),l(-.629,.016),l(-.151,.043),l(-.16,-.187),l(.887,-.505),l(.644,-.261),l(.772,-.188),l(.221,-.116),l(-.246,-.46),l(-.435,-.071),l(-.799,.044),l(-1.015,.045),l(-.698,-.1),l(-.195,-.101),l(-.418,-.432),l(.584,-.405),l(-.528,-.605),l(-.378,.361),l(-.541,.001),l(-1.001,.146),l(-.565,.131),l(-.694,.722),l(-1.003,.867),l(-.754,.203),l(-.223,.044),l(-.287,.504),l(.079,.158),l(.178,.093),l(-.706,-.131),l(-.665,.261),l(-.457,0),l(-.033,.189),l(-.609,-.047),l(-.398,-.166),l(-.119,-.249),l(-.15,.02),l(.055,-.077),l(.102,-.025),l(.126,.013),l(.113,.013),l(.189,0),l(.088,-.114),l(0,-.088),l(-.063,-.113),l(.025,-.113),l(.126,-.063),l(.051,-.063),l(.075,-.013),l(.089,-.025),l(.088,-.063),l(.089,-.088),l(.024,-.126),l(-.013,-.114),l(.14,-.013),l(.29,-.063),l(.075,-.076),l(-.025,-.088),l(-.062,-.088),l(.126,-.114),l(.037,-.063),l(-.012,-.088),l(-.114,-.113),l(.051,-.101),l(-.088,-.151),l(-.063,-.101),l(.202,-.151),l(.239,-.025),l(.126,-.088),l(.113,.025),l(.013,.088),l(-.013,.214),l(.063,.013),l(.113,0),V(0,96.92),l(-.013,-.063),l(.101,.038),l(.063,.051),l(.025,-.076),l(.075,-.038),l(.139,-.012),l(0,.075),l(.089,.063),l(.075,0),l(.126,.164),l(.076,-.076),l(.075,-.076),l(.013,-.05),l(.101,-.025),l(.177,0),l(-.037,.189),l(.176,.025),l(.038,-.038),l(.038,-.038),l(.139,.013),l(.227,0),l(.038,-.025),l(.075,-.076),l(-.126,-.013),l(-.164,-.126),l(-.101,-.051),l(-.075,-.05),l(.013,-.038),l(.101,-.063),l(-.025,-.113),l(.038,-.101),l(-.013,-.126),l(-.051,-.139),l(-.101,-.063),l(-.177,-.076),l(-.075,0),l(-.151,-.126),l(-.151,-.063),l(-.151,-.038),l(.051,-.151),l(.037,-.088),l(-.037,-.051),l(-.127,.038),l(-.062,-.114),l(.113,-.038),l(-.013,-.189),l(.089,-.075),l(-.025,-.101),l(-.038,-.088),l(-.113,0),l(-.102,.05),l(-.088,.051),l(-.113,-.088),l(-.089,-.101),l(-.188,-.101),l(-.139,-.025),l(-.102,-.139),l(-.05,-.139),l(.177,-.139),l(0,-.189),l(.024,-.114),l(.051,-.05),l(-.126,-.063),l(.164,-.151),l(-.113,-.025),l(-.076,-.063),l(-.062,-.126),l(-.14,-.013),l(-.062,.101),l(-.126,-.025),l(-.215,-.025),l(-.126,-.189),l(-.05,-.189),l(-.417,-.075),l(-.277,.012),l(-.062,.051),l(-.076,.101),l(-.062,-.05),l(0,-.076),l(-.089,-.025),l(-.101,.038),l(.038,-.05),l(.088,-.101),l(-.025,-.063),l(-.113,0),l(-.177,.038),l(-.126,-.025),l(-.101,.013),l(-.076,-.076),l(-.05,-.063),l(-.101,-.063),l(-.151,-.013),l(-.139,-.05),l(-.14,-.126),l(-.214,-.088),l(-.038,-.013),l(-.126,.025),l(-.05,.025),l(-.114,-.051),l(-.088,-.025),l(-.139,.025),l(-.177,.051),l(-.177,-.025),l(-.062,.038),l(-.126,.114),l(-.202,0),l(-.265,-.038),l(-.126,.051),l(-.315,-.114),l(-.088,.101),l(.012,.113),l(-.126,0),l(-.075,-.063),l(-.126,.114),l(-.06,.052),l(-.634,.08),l(-.151,.311),l(-.278,.178),l(-1.992,.191),l(-.186,.215),l(-.243,.119),l(-.339,.06),l(-.188,-.227),l(-.327,.004),l(-.025,-.231),l(-.363,.045),l(-1.115,-.066),l(-.958,-.193),l(-.241,.107),l(-.787,-.121),l(-.136,.085),l(-.678,-.387),l(-.554,-.2),l(-.668,-.301),l(-.166,.015),l(1.047,-1.471),l(.653,.018),l(-.349,-.383),l(-.044,-.552),l(.082,-.306),l(1.509,-1.218),l(.599,-.398),l(.286,-.181),l(.429,-.013),l(.255,-.24),l(.009,-.314),l(-.328,-.302),l(.085,-.133),l(.298,-.048),l(-.316,-.193),l(-.816,-.835),l(.074,-.242),l(-.161,-.175),
N(660.044,89.132),l(-.295,.31),l(-.687,1.207),l(-1.224,1.959),l(-.381,.58),l(.269,.836),l(.051,.029),l(.342,-.045),l(.929,-.395),l(.754,-.062),l(.576,-.018),l(.317,.085),l(.431,.416),l(.292,.07),l(1.191,-.786),l(.438,-.002),l(.928,.212),l(.538,.199),l(.797,.5),l(.879,.99),l(.599,.501),l(.048,.273),l(-.107,.217),l(-.414,.218),l(-.464,-.127),l(-1.074,-.008),l(-.432,-.099),l(-.854,.033),l(-.937,.221),l(-.539,.146),l(-.831,.278),l(-.353,.189),l(-.483,-.127),l(-.464,.045),l(-.47,.204),l(-.363,.333),l(-.312,.82),l(-.241,.216),l(-.347,.188),l(-.638,.248),l(-.896,.134),l(-.624,-.054),l(-.438,-.012),l(-.224,-.013),l(-1.192,.91),l(-.742,.433),l(-.744,.047),l(-.982,.005),l(-.592,-.125),l(-.668,-.382),l(-.718,-.154),l(-.316,.073),l(-.457,.231),l(-.539,.589),l(-.214,.401),l(.003,.343),l(.389,.569),l(.599,.411),l(.188,.228),l(-.123,.271),l(-.326,.259),l(-1.265,.292),l(-.67,.389),l(-1.111,1.046),l(-.265,.172),l(-1.941,.737),l(-.651,.061),l(-.987,-.08),l(-1.514,.065),l(-1.339,.007),l(-1.204,.349),l(-.816,.289),l(-.736,.274),l(-.303,.101),l(-1.44,.534),l(-.686,.289),l(-.481,.017),l(-.433,-.197),l(-.253,-.297),l(-.61,-.067),l(-.663,.061),l(-.929,-.123),l(-1.599,-.433),l(-1.006,-.365),l(-.815,-.551),l(-.521,-.168),l(-1.69,-.119),l(-1.164,-.022),l(-.937,-.023),l(-2.861,.059),l(-1.165,-.022),l(-.802,-.109),l(-1.241,-.207),l(-1.979,-.018),l(-.444,-.254),l(-.467,-.439),l(-1.571,-2.161),l(-.105,-.542),l(-.744,-.096),l(-.839,-.31),l(-1.645,-.806),l(-.632,-.268),l(-.998,-.224),l(-.668,-.083),l(-.995,-.038),l(-1.505,-.021),l(-1.062,-.181),l(-.724,-.312),l(-.233,-.229),l(-.105,-.43),l(.035,-.129),l(.369,-.347),l(.214,-.389),l(.237,-.75),l(.215,-.447),l(-.401,-.66),l(-1.07,-1.451),l(-.568,-.618),l(-.354,-.143),l(-.633,-.144),l(-.731,-.167),l(-.614,-.069),l(-.834,-.415),l(-1.301,-.745),l(-.371,-.433),l(-.24,-.563),l(-.131,-.405),l(-.062,-.145),l(.154,-.044),l(.799,-.425),l(.599,-.207),l(1.387,-.08),l(.603,-.148),l(.727,-.381),l(.017,-.012),l(.971,-.692),l(.787,-.398),l(1.143,-.341),l(1.512,-.476),l(.84,-.18),l(.953,.097),l(.932,.156),l(1.842,.122),l(.831,.083),l(.694,.755),l(.393,.406),l(.699,.113),l(1.458,-.008),l(.719,.083),l(.85,-.004),l(.875,.068),l(.312,.114),l(.576,.186),l(.562,-.018),l(.755,-.28),l(.31,-.162),l(.744,-.572),l(.163,-.526),l(-.116,-.204),l(-.396,-.304),l(-.409,-.86),l(.098,-.293),l(.905,-.839),l(1.269,-.96),l(.84,.201),l(1.028,.098),l(1.036,.185),l(1.748,.328),l(.702,.231),l(.989,.317),l(.767,.143),l(.145,.204),l(.004,.541),l(.182,.481),l(.408,.451),l(.421,.333),l(1.643,.531),l(.673,.113),l(2.48,-.538),l(.796,-.077),l(1.172,.037),l(1.423,.022),l(.769,.229),l(1.333,.75),l(.623,.331),l(1.132,.313),l(.812,.373),l(1.318,.254),l(.905,.241),l(.984,.082),l(.739,.039),l(1.602,-.11),l(1.018,-.063),l(.532,-.075),l(.867,-.106),l(1.147,-.136),l(.526,-.163),l(.604,-.264),l(.447,-.394),l(.755,-.498),l(1.165,-.487),l(.333,-.002),l(.609,-.047),l(.74,.156),l(.751,.506),l(.34,.129),l(.86,.169),l(1.228,-.297),l(.622,-.018),l(.431,.168),
N(406.183,86.551),l(1.051,-.494),l(.485,-.089),l(.574,.087),l(.465,-.016),l(.209,-.147),l(.477,.098),l(.407,.042),l(.52,-.034),l(-.025,-.157),l(.307,.012),l(.307,0),l(.267,-.182),l(.313,.242),l(.173,-.121),l(.228,.061),l(.292,.375),l(.535,-.109),l(.754,.375),l(-.11,.423),l(-.172,.097),l(.001,.338),l(.672,-.024),l(.344,.177),l(.282,.365),l(.038,.468),l(-.422,.376),l(-.225,-.072),l(-.142,.08),l(-.245,.147),l(-.213,.322),l(.017,.327),l(.31,.204),l(-.136,.348),l(-.079,-.114),l(-.694,.174),l(-.127,-.228),l(-.371,-.204),l(-.341,-.192),l(-.529,-.048),l(.039,-.228),l(-.146,-.18),l(.119,-.373),l(-.245,.072),l(-.193,.313),l(-.446,.035),l(-.406,.075),l(-.285,-.122),l(.072,-.198),l(-.091,-.175),l(.159,-.241),l(-.375,-.168),l(-.576,-.048),l(-.259,.012),l(-.159,-.301),l(-.518,.012),l(-.194,-.133),l(-.202,-.458),l(-.153,-.17),l(-.41,.208),l(-.141,.071),l(-.266,-.127),l(-.311,-.335),l(-.208,-.447),
N(438.22,91.952),l(.039,-.044),l(.065,-.105),l(.014,-.131),l(.092,-.066),l(.146,-.119),l(.026,-.04),l(.171,-.053),l(.093,-.026),l(.092,.053),l(.132,.053),l(.158,0),l(.065,-.026),l(.093,0),l(.065,.026),l(.065,.026),l(.093,-.026),l(.145,-.04),l(.132,0),l(.118,-.053),l(.079,-.053),l(.066,-.026),l(.105,-.026),l(.039,0),l(.053,-.079),l(.04,-.092),l(.079,-.079),l(.092,.026),l(.105,-.04),l(.145,-.066),l(.053,-.105),l(.053,-.079),l(.026,-.132),l(.026,-.092),l(.053,-.092),l(.118,-.013),l(.105,-.013),l(.132,-.079),l(.119,-.053),l(.118,-.092),l(.053,-.079),l(.132,-.066),l(.065,-.04),L(442,89.998),l(.145,.013),l(.105,.026),l(.066,-.04),l(.065,-.066),l(.071,.012),l(.285,.041),l(.03,.228),l(.43,-.048),l(.183,-.24),l(.193,.016),l(.062,-.112),l(.261,-.024),l(.194,.24),l(.073,.169),l(.331,-.025),l(.066,.18),l(-.026,.083),l(.003,.204),l(.389,-.083),l(.18,.12),l(.149,-.135),l(.104,-.177),l(.558,-.204),l(.168,.056),l(.483,-.046),l(.46,.254),l(.373,-.18),l(.073,-.137),l(.508,.041),l(.561,-.076),l(.129,.13),l(.703,.186),l(.104,.216),l(.424,.101),l(.831,.33),l(-1.047,1.471),l(-.629,.076),l(-.437,-.143),l(-.534,-.359),l(-1.062,.035),l(-.717,.047),l(-1.024,.759),L(444.857,93),l(-.59,-.072),l(-.499,.061),l(-.761,.134),l(-.255,.001),l(-.334,.568),l(-1.651,-.036),l(-.414,-.027),l(-.617,-.17),l(-.399,-.172),l(-.245,.146),l(-.761,-.547),l(-.155,-.26),l(.097,-.581),l(-.053,-.093),
N(442.391,98.111),l(-.589,.203),l(-.433,.031),l(-.668,.047),l(-.58,-.098),l(-1.116,-.671),l(-1.412,-.612),l(-.215,-.197),l(-.364,-.333),l(-.304,-.59),l(.346,-.299),l(.154,-.294),l(-.204,-.188),l(.04,-.375),l(.409,-.062),l(.157,-.206),l(-.136,-.196),l(-.452,-.063),l(.223,-.197),l(.325,0),l(.164,.134),l(.701,-.054),l(.019,-.367),l(.636,-.291),l(.245,-.146),l(.399,.172),l(.617,.17),l(.414,.027),l(1.651,.036),l(.334,-.568),l(.255,-.001),l(.761,-.134),l(.499,-.061),l(.59,.072),l(.427,-.063),l(1.024,-.759),l(.717,-.047),l(1.062,-.035),l(.534,.359),l(.437,.143),l(.629,-.076),l(.166,-.015),l(.668,.301),l(.554,.2),l(.678,.387),l(-.45,.338),l(-1.125,.267),l(-.581,.408),l(-.968,1.451),l(-.63,.84),l(-.753,.567),l(-.361,.16),l(-.724,.047),l(-.264,.103),l(-.176,-.002),l(-.907,-.067),l(-.889,.077),l(-1.535,.529),
N(459.717,92.836),l(.06,-.052),l(.126,-.114),l(.075,.063),l(.126,0),l(-.012,-.113),l(.088,-.101),l(.315,.114),l(.126,-.051),l(.265,.038),l(.202,0),l(.126,-.114),l(.062,-.038),l(.177,.025),l(.177,-.051),l(.139,-.025),l(.088,.025),l(.114,.051),l(.05,-.025),l(.126,-.025),l(.038,.013),l(.214,.088),l(.14,.126),l(.139,.05),l(.151,.013),l(.101,.063),l(.05,.063),l(.076,.076),l(.101,-.013),l(.126,.025),l(.177,-.038),l(.113,0),l(.025,.063),l(-.088,.101),l(-.038,.05),l(.101,-.038),l(.089,.025),l(0,.076),l(.062,.05),l(.076,-.101),l(.062,-.051),l(.277,-.012),l(.417,.075),l(.05,.189),l(.126,.189),l(.215,.025),l(.126,.025),l(.062,-.101),l(.14,.013),l(.062,.126),l(.076,.063),l(.113,.025),l(-.164,.151),l(.126,.063),l(-.051,.05),l(-.024,.114),l(0,.189),l(-.177,.139),l(.05,.139),l(.102,.139),l(.139,.025),l(.188,.101),l(.089,.101),l(.113,.088),l(.088,-.051),l(.102,-.05),l(.113,0),l(.038,.088),l(.025,.101),l(-.089,.075),l(.013,.189),l(-.113,.038),l(.062,.114),l(.127,-.038),l(.037,.051),l(-.037,.088),l(-.051,.151),l(.151,.038),l(.151,.063),l(.151,.126),l(.075,0),l(.177,.076),l(.101,.063),l(.051,.139),l(.013,.126),l(-.038,.101),l(.025,.113),l(-.101,.063),l(-.013,.038),l(.075,.05),l(.101,.051),l(.164,.126),l(.126,.013),l(-.075,.076),l(-.038,.025),l(-.227,0),l(-.139,-.013),l(-.038,.038),l(-.038,.038),l(-.176,-.025),l(.037,-.189),l(-.177,0),l(-.101,.025),l(-.013,.05),l(-.075,.076),l(-.076,.076),l(-.126,-.164),l(-.075,0),l(-.089,-.063),l(0,-.075),l(-.139,.012),l(-.075,.038),l(-.025,.076),l(-.063,-.051),l(-.101,-.038),l(.013,.063),l(0,.088),l(-.113,0),l(-.063,-.013),l(.013,-.214),l(-.013,-.088),l(-.113,-.025),l(-.126,.088),l(-.239,.025),l(-.202,.151),l(.063,.101),l(.088,.151),l(-.051,.101),l(.114,.113),l(.012,.088),l(-.037,.063),l(-.126,.114),l(.062,.088),l(.025,.088),l(-.075,.076),l(-.29,.063),l(-.14,.013),l(.013,.114),l(-.024,.126),l(-.089,.088),l(-.088,.063),l(-.089,.025),l(-.075,.013),l(-.051,.063),l(-.126,.063),l(-.025,.113),l(.063,.113),l(0,.088),l(-.088,.114),l(-.189,0),l(-.113,-.013),l(-.126,-.013),l(-.102,.025),l(-.055,.077),l(-.03,.004),l(-.062,-.237),l(-.218,-.106),l(.16,-.071),l(-.021,-.267),l(-.104,-.561),l(.323,-.978),l(.027,-.404),l(-.353,-.856),l(-.604,-.286),l(-1.037,-1.119),L(460.567,93),l(-.626,-.191),l(-.225,.028),
N(445.722,97.573),l(.176,.002),l(.264,-.103),l(.724,-.047),l(.361,-.16),l(.753,-.567),l(.63,-.84),l(.968,-1.451),l(.581,-.408),l(1.125,-.267),l(.45,-.338),l(.136,-.085),l(.787,.121),l(.241,-.107),l(.958,.193),l(1.115,.066),l(.363,-.045),l(.025,.231),l(.327,-.004),l(.188,.227),l(.339,-.06),l(.243,-.119),l(.186,-.215),l(1.992,-.191),l(.278,-.178),l(.151,-.311),l(.634,-.08),l(.225,-.028),L(460.567,93),l(.767,1.17),l(1.037,1.119),l(.604,.286),l(.353,.856),l(-.027,.404),l(-.323,.978),l(.104,.561),l(.021,.267),l(-.16,.071),l(.218,.106),l(.062,.237),l(.03,-.004),l(.15,-.02),l(.119,.249),l(.398,.166),l(.609,.047),l(.033,-.189),l(.457,0),l(.665,-.261),l(.706,.131),l(.149,.079),l(.062,.259),l(-.293,.446),l(-.27,.316),l(-.436,.044),l(-.382,.043),l(-.382,.245),l(-.515,.617),l(-.252,.645),l(-.096,.787),l(-.044,.223),l(-.671,-.12),l(-1.346,-.336),l(-.514,-.226),l(-.295,-.042),l(-.671,-.369),l(-.562,-.04),l(-.618,.218),l(-1.904,.771),l(-.38,.059),l(-1.385,-.35),l(-.3,-.013),l(-.69,.261),l(-.34,.031),l(-1.151,-.395),l(-.506,-.002),l(-.771,.189),l(-.266,.023),l(-.048,-.189),l(.234,-.318),l(-.352,-.106),l(-.392,-.204),l(-.418,-.186),l(-.146,-.33),l(.32,-.201),l(.351,.012),l(-.114,-.13),l(-.625,-.248),l(-.253,.13),l(-.215,.283),l(-.147,.118),l(-.414,-.239),l(-.194,-.139),l(-.594,-.059),l(-.02,-.189),l(-.234,0),l(-.245,-.036),l(-.052,-.165),l(.178,-.094),l(.271,-.071),l(-.239,-.083),l(-.183,-.059),l(.124,-.146),l(.19,-.127),l(-.069,-.142),l(-.306,-.118),l(-.555,-.141),l(-.712,-.471),l(.058,-.088),l(-.104,-.119),l(.075,-.356),l(-.202,-.036),l(-.19,-.237),l(-.569,-.178),l(-.054,-.309),
N(420.177,113.472),l(-.274,-.042),l(-.253,-.155),l(-.367,-.325),l(-.096,-.213),l(.202,-.738),l(.097,-.681),l(-.046,-.583),l(-.133,-.569),l(-.503,-.44),l(-.094,-.271),l(.181,-.157),l(.366,-.015),l(.801,-.001),l(.339,-.172),l(.861,-.543),l(.633,.625),l(.451,.754),l(-.014,.271),l(-.204,.285),l(-.145,.484),l(.149,.894),l(-.11,.525),l(-.377,.695),l(-.405,-.198),l(-.52,.03),l(-.143,.1),l(-.149,.27),l(-.248,.17),M(433.783,118.446),l(-.712,-.084),l(-.902,-.607),l(-.772,-.239),l(-1.904,-.817),l(-.833,-.126),l(-.232,-.127),l(-.173,-.283),l(.139,-.34),l(.328,-.34),l(.264,-.1),l(.629,.112),l(.569,-.341),l(.68,.424),l(.403,.141),l(.722,-.016),l(1.403,-.187),l(1.38,-.329),l(.148,.085),l(.043,.127),l(-.112,.127),l(-.536,.823),l(-.153,.497),l(.009,.382),l(.411,.509),l(-.179,.128),l(-.43,.567),l(-.188,.015),M(431.244,98.829),l(-.281,-.329),l(-.242,-.027),l(-.281,.196),l(-.156,-.125),l(-.47,-.071),l(-.114,.32),l(-.458,.054),l(-1.001,.364),l(.078,-.151),l(-.452,.133),l(-.063,.249),l(-.157,.044),l(-.01,.125),l(.303,.08),l(.021,.302),l(.193,.119),l(.253,.236),l(-.104,.213),l(-.449,.254),l(.016,.272),l(.143,.554),l(.783,.814),l(2.008,.889),l(.29,.357),l(.134,.558),l(.274,.557),l(.395,.585),l(.694,.57),l(.254,.274),l(.446,.195),l(.041,.21),l(.408,.167),l(1.17,.255),l(1.254,-.105),l(.388,.141),l(.024,.212),l(-.465,.247),l(-.258,.294),l(.262,.213),l(.954,.283),l(1.168,.411),l(.829,.366),l(1.589,.739),l(.058,.185),l(.719,.458),l(.31,.475),l(-.198,.435),l(-.152,.337),l(-.455,-.281),l(-.318,-.167),l(-.109,-.486),l(-.263,-.17),l(-.512,-.099),l(-.483,-.009),l(-.439,-.236),l(.086,-.217),l(-.353,-.065),l(-.301,.098),l(-.232,.262),l(-.259,.399),l(-.273,.208),l(.043,.271),l(-.197,.303),l(-.007,.298),l(.76,.342),l(.611,.271),l(-.093,.314),l(.03,.432),l(.133,.142),l(-.191,.238),l(-.659,-.024),l(-.41,.219),l(-.202,.228),l(.11,.595),l(-.536,.303),l(-.617,.866),l(-.595,.048),l(-.167,-.071),l(-.184,-.14),l(-.002,-.508),l(.364,-.141),l(.317,-.542),l(-.236,-.184),l(.361,-.249),l(.361,.074),l(.133,-.17),l(-.077,-.34),l(-.211,-.181),l(-.206,-.924),l(-.367,-.516),l(-.15,-.607),l(-.201,-.352),l(-.334,.058),l(-.187,.171),l(-.899,-.496),l(-.286,-.065),l(.208,-.291),l(-.092,-.398),l(-.461,-.34),l(-.909,.247),l(.034,-.109),l(.322,-.194),l(-.276,-.27),l(-.29,-.003),l(-.42,.19),l(-.242,-.512),l(-.198,-.207),l(-.124,-.228),l(-.663,-.241),l(-.505,-.027),l(-.654,-.127),l(-.745,-.355),l(-.548,-.441),l(-.959,-.612),l(-1.036,-.826),l(-.872,-.384),l(-.805,-.67),l(-.566,-.856),l(-.434,-1.043),l(-.347,-.443),l(-.505,-.457),l(-.483,-.243),l(-1.188,-.341),l(-.579,-.142),l(-.5,.044),l(-1.078,.647),l(-.46,.359),l(-.646,.173),l(-.303,.043),l(.146,-.469),l(-.062,-.281),l(-.849,.07),l(-.754,-.391),l(-.193,-.442),l(.315,-.371),l(.175,-.01),l(-.135,-.331),l(-.616,-.191),l(-.352,-.358),l(.437,-.186),l(.183,.111),l(.541,-.353),l(.199,-.272),l(-.43,-.192),l(-.025,-.292),l(-.532,-.344),l(.624,-.301),l(.599,.062),l(.627,-.204),l(.629,.168),l(.275,-.16),l(.349,-.432),l(-.103,-.212),l(.777,-.404),l(.016,.415),l(.534,.363),l(.311,.071),l(-.098,.182),l(.385,.312),l(.285,-.151),l(.018,-.535),l(.425,-.384),l(-.019,-.333),l(.371,-.081),l(.143,.354),l(.23,.142),l(.216,-.03),l(.071,-.122),l(.469,-.05),l(.244,.333),l(.228,-.415),l(-.244,-.131),l(.081,-.273),l(.283,-.091),l(.176,.162),l(.315,.051),l(.038,-.192),l(-.112,-.212),l(.126,-.309),l(.631,.171),l(.597,.034),l(.329,-.411),l(.366,-.096),l(.183,.083),l(.445,-.11),l(.301,.103),l(.856,-.227),l(.023,.363),l(.318,.096),l(.32,.391),l(1.311,.247),l(.894,.082),l(.478,.112),l(.116,.199),l(-.614,.303),l(.098,.151),l(.297,.002),l(.187,.185),l(-.367,.285),l(.336,.089),l(-.127,.361),l(.36,.11),l(.284,.198),l(-.056,.214),
N(430.73,96.731),l(1.04,.065),l(.179,.107),l(.612,-.009),l(.287,.152),l(.646,-.5),l(.566,-.107),l(.85,.08),l(.298,-.196),l(.89,.116),l(-.082,-.393),l(.693,-.157),l(.304,.59),l(.364,.333),l(-.035,-.009),l(-.1,-.073),l(-.145,-.036),l(-.172,0),l(-.145,.009),l(-.055,.063),l(0,.072),l(.019,.09),l(.009,.082),l(-.063,.009),l(-.136,-.009),l(-.108,-.036),l(-.091,.063),l(-.045,.082),l(-.081,.063),l(-.082,.045),l(-.081,.009),l(-.163,.036),l(-.117,.036),l(-.108,.036),l(-.055,.045),l(-.153,-.009),l(-.127,.072),l(-.063,.054),l(-.018,.082),l(.036,.072),l(.081,.054),l(.063,.055),l(.045,.045),l(.019,.063),l(.018,.09),l(-.036,.108),l(-.018,.063),l(-.046,.1),l(-.108,0),l(-.081,-.009),l(-.091,.027),l(-.108,.009),l(-.117,.054),l(-.091,.018),l(-.081,.027),l(-.1,.045),l(-.055,.063),l(-.036,.027),l(.055,.018),l(.063,.009),l(.026,.027),l(.037,.072),l(-.046,.063),l(-.027,.009),l(-.081,.027),l(-.009,.045),l(.045,.081),l(0,.072),l(.045,.1),l(-.054,.072),l(-.063,-.018),l(-.1,.045),l(-.117,.018),l(-.127,-.036),l(-.063,-.027),l(-.1,-.063),l(-.099,0),l(-.063,-.027),l(-.118,-.045),l(-.018,.045),l(-.027,.045),l(-.1,.027),l(-.136,0),l(-.054,-.045),l(-.072,-.063),l(-.127,-.018),l(-.019,-.09),l(-.026,-.018),l(-.063,-.054),l(-.055,-.027),l(-.018,-.054),l(-.01,-.054),l(-.036,-.009),l(-.063,.018),l(-.036,.054),l(-.009,.027),l(-.054,.063),l(-.019,.018),l(-.018,.081),l(-.063,.045),l(-.046,.018),l(-.062,.054),l(-.036,.009),l(-.254,0),l(-.108,-.027),l(-.108,.027),l(-.145,.009),l(-.1,-.009),l(-.1,-.036),l(-.045,-.019),l(-.055,0),l(0,.037),l(0,.036),l(-.045,.027),l(-.045,.018),l(-.136,-.009),l(-.027,-.036),l(-.108,.018),l(-.019,.018),l(-.136,.018),l(-.063,.018),l(-.126,.018),l(-.272,-.063),l(.428,-.077),l(.113,-.16),l(.056,-.214),l(-.284,-.198),l(-.36,-.11),l(.127,-.361),l(-.336,-.089),l(.367,-.285),l(-.187,-.185),l(-.297,-.002),l(-.098,-.151),l(.614,-.303),l(-.116,-.199),
N(439.573,104.709),l(-1.051,-.672),l(-.185,-.222),l(-.783,-.149),l(-.203,-.159),l(-.403,-.115),l(-.683,.177),l(-.326,-.486),l(-1.112,-.627),l(-.584,-.678),l(.277,.007),l(.608,.016),l(-.583,-.221),l(-.659,-.469),l(-.183,-.407),l(.086,-.452),l(-.289,-.336),l(-.646,-.418),l(-.378,-.126),l(-.258,.579),l(-.142,.116),l(.03,.15),l(-.284,.106),l(-.154,.248),l(-.213,.053),l(-.496,-.647),l(-.063,-.286),l(-.259,-.612),l(.065,-.012),l(.272,.063),l(.126,-.018),l(.063,-.018),l(.136,-.018),l(.019,-.018),l(.108,-.018),l(.027,.036),l(.136,.009),l(.045,-.018),l(.045,-.027),l(0,-.036),l(0,-.037),l(.055,0),l(.045,.019),l(.1,.036),l(.1,.009),l(.145,-.009),l(.108,-.027),l(.108,.027),l(.254,0),l(.036,-.009),l(.062,-.054),l(.046,-.018),l(.063,-.045),l(.018,-.081),l(.019,-.018),l(.054,-.063),l(.009,-.027),l(.036,-.054),l(.063,-.018),l(.036,.009),l(.01,.054),l(.018,.054),l(.055,.027),l(.063,.054),l(.026,.018),l(.019,.09),l(.127,.018),l(.072,.063),l(.054,.045),l(.136,0),l(.1,-.027),l(.027,-.045),l(.018,-.045),l(.118,.045),l(.063,.027),l(.099,0),l(.1,.063),l(.063,.027),l(.127,.036),l(.117,-.018),l(.1,-.045),l(.063,.018),l(.054,-.072),l(-.045,-.1),l(0,-.072),l(-.045,-.081),l(.009,-.045),l(.081,-.027),l(.027,-.009),l(.046,-.063),l(-.037,-.072),l(-.026,-.027),l(-.063,-.009),l(-.055,-.018),l(.036,-.027),l(.055,-.063),l(.1,-.045),l(.081,-.027),l(.091,-.018),l(.117,-.054),l(.108,-.009),l(.091,-.027),l(.081,.009),l(.108,0),l(.046,-.1),l(.018,-.063),l(.036,-.108),l(-.018,-.09),l(-.019,-.063),l(-.045,-.045),l(-.063,-.055),l(-.081,-.054),l(-.036,-.072),l(.018,-.082),l(.063,-.054),l(.127,-.072),l(.153,.009),l(.055,-.045),l(.108,-.036),l(.117,-.036),l(.163,-.036),l(.081,-.009),l(.082,-.045),l(.081,-.063),l(.045,-.082),l(.091,-.063),l(.108,.036),l(.136,.009),l(.063,-.009),l(-.009,-.082),l(-.019,-.09),l(0,-.072),l(.055,-.063),l(.145,-.009),l(.172,0),l(.145,.036),l(.1,.073),l(.035,.009),l(.215,.197),l(1.412,.612),l(1.116,.671),l(.58,.098),l(.668,-.047),l(.433,-.031),l(.589,-.203),l(.201,.142),l(.056,.089),l(.022,.112),l(-.022,.078),l(.045,.044),l(.011,.067),l(-.078,.056),l(-.011,.146),l(.078,.067),l(.145,-.034),l(.101,.034),l(.045,.089),l(-.078,.011),l(-.056,-.022),l(-.022,.078),l(.033,.1),l(-.045,.034),l(-.044,.022),l(.066,.111),l(.168,-.022),l(.033,.078),l(.123,.1),l(.122,0),l(.101,0),l(.09,.078),l(.122,.011),l(.134,0),l(.012,.078),l(-.033,.056),l(-.135,-.011),l(-.089,-.034),l(-.067,.022),l(-.078,-.011),l(-.066,-.045),l(-.056,-.011),l(-.045,.011),l(.033,.067),l(-.101,.089),l(-.078,0),l(0,.156),l(.045,.067),l(-.033,.078),l(.022,.078),l(.011,.078),l(-.089,.033),l(-.09,-.033),l(-.056,.067),l(.078,.089),l(-.078,.011),l(-.189,.022),l(-.201,-.022),l(-.145,-.123),l(.056,-.101),l(-.045,-.089),l(-.123,-.011),l(-.022,-.112),l(-.145,-.056),l(-.146,-.045),l(-.101,.089),l(-.1,-.011),l(-.156,-.078),l(-.067,-.022),l(-.146,0),l(-.156,-.045),l(-.111,.067),l(-.134,.045),l(-.134,-.045),l(-.111,-.067),l(-.112,0),l(-.122,.089),l(-.168,.078),l(-.156,-.067),l(-.268,-.089),l(-.179,.011),l(-.156,.011),l(-.189,-.056),l(-.168,-.011),l(-.156,-.089),l(-.089,.078),l(-.111,.022),l(-.057,-.056),l(-.234,-.078),l(-.156,-.056),l(-.134,-.045),l(-.089,-.011),l(-.134,.123),l(-.112,-.011),l(-.223,-.022),l(-.168,-.033),l(-.212,.022),l(-.101,.111),l(-.145,.145),l(-.123,.201),l(-.201,-.022),l(-.256,-.134),l(-.156,-.19),l(-.101,-.111),l(-.312,-.034),l(-.123,.044),l(-.089,.179),l(-.045,.167),l(.045,.134),l(0,.078),l(.033,.212),l(-.123,.067),l(.022,.089),l(.134,.078),l(.09,.089),l(.122,.034),l(.101,.033),l(.179,.179),l(.146,.234),l(.089,.134),l(.022,.123),l(.156,.111),l(-.078,.056),l(-.012,.1),l(.022,.146),l(.168,-.011),l(.089,.111),l(.056,.123),l(.112,.111),l(.167,.045),l(.167,.033),l(.369,.357),l(.021,.167),l(.078,.044),l(.213,.078),l(.379,.357),l(.224,.123),l(.223,.067),l(.101,.056),l(0,.112),l(.078,.279),l(.201,.078),l(.189,.167),l(.146,.112),l(.245,.123),l(.067,.212),l(-.284,.083),M(439.792,104.833),l(.132,-.118),l(.134,.011),l(.123,.034),l(.045,.078),l(.066,.089),l(.146,.089),l(.179,.078),l(.212,.011),l(.312,.257),l(.045,.067),l(.134,-.033),l(.123,.022),l(.089,.034),l(.062,.063),l(.005,.004),l(-.022,.089),l(.033,.078),l(.082,.072),l(.029,.092),l(-.002,.1),l(-.589,-.367),l(-.549,-.371),l(-.789,-.378),
N(451.009,101.725),l(-.328,.346),l(-.383,.374),l(-.18,.302),l(.056,.271),l(1.326,1.122),l(.028,.2),l(-.302,.302),l(-.762,.333),l(-.246,.301),l(-.008,.514),l(-.013,.208),l(-.058,-.017),l(-.072,.029),l(-.16,.022),l(-.145,.021),l(-.116,.022),l(-.058,.015),l(-.102,-.051),l(-.087,.043),l(-.088,.021),l(-.102,-.043),l(-.064,-.021),l(-.131,.116),l(-.087,.08),l(-.152,-.015),l(-.196,-.007),l(-.064,.007),l(-.175,-.043),l(-.152,.087),l(-.151,.102),l(-.109,.058),l(.059,.072),l(-.029,.058),l(-.116,0),l(-.094,-.109),l(-.131,-.058),l(-.087,-.073),l(-.08,.065),l(-.116,.058),l(-.246,.058),l(-.225,.058),l(-.088,.058),l(-.058,.167),l(.029,.13),l(-.029,.072),l(-.072,.087),l(-.188,0),l(-.14,-.049),l(-.018,-.109),l(-.733,-.866),l(-.382,-.369),l(-.058,-.004),l(.109,-.286),l(0,-.067),l(-.078,-.067),l(-.101,0),l(-.056,-.056),l(.022,-.089),l(.111,-.033),l(.146,.011),l(.167,.033),l(.057,-.033),l(.021,-.067),l(.09,-.044),l(.134,-.022),l(.089,-.011),l(-.011,-.089),l(-.101,-.101),l(-.167,-.067),l(-.134,-.045),l(-.057,-.044),l(-.111,.022),l(-.078,-.045),l(-.033,-.067),l(-.123,-.101),l(-.078,-.1),l(-.066,-.022),l(-.067,.044),l(-.078,-.011),l(-.101,-.056),l(-.279,-.078),l(-.078,-.022),l(-.056,-.033),l(-.167,-.134),l(-.101,-.146),l(-.111,-.111),l(-.168,-.078),l(-.156,-.101),l(-.223,-.056),l(0,-.101),l(.179,-.101),l(.089,-.111),l(.078,-.011),l(.067,.034),l(.078,.044),l(.1,.022),l(.045,-.022),l(.012,-.134),l(.011,-.19),l(-.134,-.145),l(-.179,-.19),l(-.212,-.134),l(-.101,-.145),l(.101,.022),l(.101,.011),l(.145,.056),l(.224,.044),l(.134,-.078),l(.089,-.056),l(.067,-.078),l(-.089,-.044),l(-.135,-.022),l(-.089,-.089),l(-.123,-.078),l(-.156,-.089),l(-.033,-.101),l(-.045,-.1),l(-.212,.011),l(-.167,-.056),l(-.078,-.1),l(-.022,-.134),l(.078,-.067),l(0,-.089),l(-.033,-.1),l(.056,-.056),l(.066,-.078),l(.156,-.156),l(.156,-.223),l(.034,-.167),l(.056,-.1),l(-.022,-.067),l(-.123,-.022),l(-.179,-.011),l(-.156,0),l(-.212,.112),l(-.078,-.089),l(.056,-.067),l(.09,.033),l(.089,-.033),l(-.011,-.078),l(-.022,-.078),l(.033,-.078),l(-.045,-.067),l(0,-.156),l(.078,0),l(.101,-.089),l(-.033,-.067),l(.045,-.011),l(.056,.011),l(.066,.045),l(.078,.011),l(.067,-.022),l(.089,.034),l(.135,.011),l(.033,-.056),l(-.012,-.078),l(-.134,0),l(-.122,-.011),l(-.09,-.078),l(-.101,0),l(-.122,0),l(-.123,-.1),l(-.033,-.078),l(-.168,.022),l(-.066,-.111),l(.044,-.022),l(.045,-.034),l(-.033,-.1),l(.022,-.078),l(.056,.022),l(.078,-.011),l(-.045,-.089),l(-.101,-.034),l(-.145,.034),l(-.078,-.067),l(.011,-.146),l(.078,-.056),l(-.011,-.067),l(-.045,-.044),l(.022,-.078),l(-.022,-.112),l(-.056,-.089),l(-.201,-.142),l(1.535,-.529),l(.889,-.077),l(.907,.067),l(.054,.309),l(.569,.178),l(.19,.237),l(.202,.036),l(-.075,.356),l(.104,.119),l(-.058,.088),l(.712,.471),l(.555,.141),l(.306,.118),l(.069,.142),l(-.19,.127),l(-.124,.146),l(.183,.059),l(.239,.083),l(-.271,.071),l(-.178,.094),l(.052,.165),l(.245,.036),l(.234,0),l(.02,.189),l(.594,.059),l(.194,.139),l(.414,.239),l(.147,-.118),l(.215,-.283),l(.253,-.13),l(.625,.248),l(.114,.13),l(-.351,-.012),l(-.32,.201),l(.146,.33),l(.418,.186),
N(551.198,117.997),l(-.351,-.48),l(-.236,-.126),l(-1.217,-.05),l(-.646,-.011),l(-.096,-.016),l(.091,-.726),l(-.062,-.503),l(.157,-.251),l(.062,-.22),l(-.503,-.094),l(-.534,-.283),l(-.566,-.189),l(-.471,.063),l(-.378,-.251),l(-1.132,-.597),l(-.565,-.22),l(-.943,-.597),l(-.314,.063),l(-1.006,-.503),l(-.377,-.44),l(-1.194,-.597),l(-1.384,-.975),l(0,-.283),l(-.188,-.44),l(-.283,-.188),l(-.408,-.597),l(-.126,-.566),l(-.22,-.377),l(-.881,-.251),l(-.188,.157),l(-.439,.063),l(-.535,-.126),l(-.439,.032),l(-.503,.094),l(-.314,-.157),l(-.691,-.314),l(.094,-.22),l(.157,-.188),l(-.188,-.22),l(.031,-.188),l(.188,-.157),l(-.439,-.283),l(0,-.22),l(-.032,-.22),l(-.251,-.22),l(-.534,-.094),l(-.692,-.095),l(-.22,-.314),l(-.346,-.032),l(-.629,-.377),l(-.472,-.095),l(-.188,.063),l(-.565,.157),l(.251,.251),l(.188,.377),l(-.597,-.283),l(-.283,0),l(-.126,.126),l(-.22,.346),l(-.283,.126),l(-.629,0),l(-.503,.251),l(-.503,.409),l(-.062,.628),l(.314,.409),l(-.126,.314),l(-1.383,.032),l(-1.03,-.063),l(.056,-8.174),l(5.658,-1.289),l(5.722,2.986),l(2.012,1.666),l(2.578,-.346),l(2.767,.188),l(1.1,-.409),l(.724,.723),l(.597,.22),l(.66,1.006),l(.66,-.314),l(-.031,1.038),l(-.188,.409),l(.031,.754),l(1.006,0),l(.221,.817),l(.346,1.069),l(.503,.063),l(.691,-.032),l(1.006,-.094),l(.346,0),l(.44,.314),l(.062,.283),l(-.062,.283),l(.44,.346),l(.66,0),l(.125,-.188),l(-.157,-.409),l(.504,-.44),l(.439,-.188),l(.221,-.472),l(.282,-.188),l(.943,-.377),l(.755,-.189),l(.534,-.471),l(.346,-.283),l(.22,-.063),l(.283,.126),l(.377,-.377),l(.322,-.031),l(.349,-.126),l(.441,.246),l(-.368,.172),l(-.368,.171),l(-.221,.049),l(-.073,.196),l(-.295,.049),l(-.294,.172),l(-.196,.147),l(-.441,.295),l(-.172,.098),l(-.024,.123),l(.294,.049),l(.295,.074),l(.146,.123),l(.418,-.147),l(.098,.221),l(.172,.221),l(.368,.27),l(.589,0),l(.393,0),l(.049,-.393),l(.221,.049),l(.196,-.196),l(.024,-.245),l(.196,.098),l(.196,.172),l(.172,.294),l(.049,.147),l(.393,.024),l(.147,-.024),l(.073,.246),l(.025,.098),l(.343,-.025),l(.319,.147),l(.245,.196),l(.516,.074),l(.466,.024),l(.172,.123),l(-.49,.221),l(-.197,.147),l(-.221,.147),l(-.49,-.024),l(-.245,-.049),l(.049,.171),l(0,.147),l(-.319,0),l(-.172,.049),l(-.343,.196),l(-.221,.196),l(-.271,.049),l(-.221,.196),l(-.245,-.147),l(-.319,-.098),l(-.294,-.098),l(-.221,.025),l(-.246,.073),l(-.318,-.073),l(-.042,.098),l(-.345,-.005),l(-.409,.031),l(-.188,-.283),l(-.251,-.063),l(-.126,-.188),l(.251,-.126),l(.409,-.346),l(.188,-.22),l(-.252,-.251),l(-.439,-.377),l(-.221,.251),l(-.471,.346),l(-.692,.188),l(-.22,.157),l(-.252,-.22),l(-.22,-.157),l(-.346,0),l(.031,.22),l(-.283,.314),l(.189,.314),l(-.032,.346),l(-.062,.126),l(-.472,-.095),l(-.565,.095),l(-.503,.094),l(.251,.125),l(.534,-.031),l(.126,.094),l(-.251,.063),l(-.188,.063),l(-.032,.346),l(-.188,0),l(-.251,.157),l(-.063,.409),l(-.282,.188),l(-1.069,-.094),l(-.629,-.126),l(-.472,.283),l(-.125,.471),l(.251,.283),l(.346,.188),l(.157,.157),l(.44,.032),l(.346,0),l(.126,.22),l(-.126,.22),l(-.031,.472),l(.126,.409),l(.471,.314),l(.126,.283),l(-.157,.22),l(-.503,.346),l(-.283,.503),l(-.377,.377),l(.063,.377),l(-.375,.843),
N(439.792,104.833),l(-.113,-.054),l(-.105,-.07),l(.284,-.083),l(-.067,-.212),l(-.245,-.123),l(-.146,-.112),l(-.189,-.167),l(-.201,-.078),l(-.078,-.279),l(0,-.112),l(-.101,-.056),l(-.223,-.067),l(-.224,-.123),l(-.379,-.357),l(-.213,-.078),l(-.078,-.044),l(-.021,-.167),l(-.369,-.357),l(-.167,-.033),l(-.167,-.045),l(-.112,-.111),l(-.056,-.123),l(-.089,-.111),l(-.168,.011),l(-.022,-.146),l(.012,-.1),l(.078,-.056),l(-.156,-.111),l(-.022,-.123),l(-.089,-.134),l(-.146,-.234),l(-.179,-.179),l(-.101,-.033),l(-.122,-.034),l(-.09,-.089),l(-.134,-.078),l(-.022,-.089),l(.123,-.067),l(-.033,-.212),l(0,-.078),l(-.045,-.134),l(.045,-.167),l(.089,-.179),l(.123,-.044),l(.312,.034),l(.101,.111),l(.156,.19),l(.256,.134),l(.201,.022),l(.123,-.201),l(.145,-.145),l(.101,-.111),l(.212,-.022),l(.168,.033),l(.223,.022),l(.112,.011),l(.134,-.123),l(.089,.011),l(.134,.045),l(.156,.056),l(.234,.078),l(.057,.056),l(.111,-.022),l(.089,-.078),l(.156,.089),l(.168,.011),l(.189,.056),l(.156,-.011),l(.179,-.011),l(.268,.089),l(.156,.067),l(.168,-.078),l(.122,-.089),l(.112,0),l(.111,.067),l(.134,.045),l(.134,-.045),l(.111,-.067),l(.156,.045),l(.146,0),l(.067,.022),l(.156,.078),l(.1,.011),l(.101,-.089),l(.146,.045),l(.145,.056),l(.022,.112),l(.123,.011),l(.045,.089),l(-.056,.101),l(.145,.123),l(.201,.022),l(.189,-.022),l(.078,-.011),l(.212,-.112),l(.156,0),l(.179,.011),l(.123,.022),l(.022,.067),l(-.056,.1),l(-.034,.167),l(-.156,.223),l(-.156,.156),l(-.066,.078),l(-.056,.056),l(.033,.1),l(0,.089),l(-.078,.067),l(.022,.134),l(.078,.1),l(.167,.056),l(.212,-.011),l(.045,.1),l(.033,.101),l(.156,.089),l(.123,.078),l(.089,.089),l(.135,.022),l(.089,.044),l(-.067,.078),l(-.089,.056),l(-.134,.078),l(-.224,-.044),l(-.145,-.056),l(-.101,-.011),l(-.101,-.022),l(.101,.145),l(.212,.134),l(.179,.19),l(.134,.145),l(-.011,.19),l(-.012,.134),l(-.045,.022),l(-.1,-.022),l(-.078,-.044),l(-.067,-.034),l(-.078,.011),l(-.089,.111),l(-.179,.101),l(-.056,-.033),l(-.156,.056),l(-.112,-.022),l(-.066,-.044),l(-.112,.033),l(-.078,.056),l(.012,.078),l(.089,.1),l(.123,.167),l(.056,.101),l(-.056,.101),l(-.111,0),l(-.09,-.056),l(-.056,-.089),l(-.056,-.044),l(-.123,-.011),l(-.122,.056),l(-.168,.078),l(-.045,.101),l(-.044,.089),l(-.112,.101),l(.034,.089),l(.011,.1),L(442,104.458),l(-.134,.011),l(-.111,.022),l(-.101,.089),l(-.012,.134),l(.012,.112),l(.011,.145),l(.012,.044),l(.066,.112),l(.078,.089),l(.045,.101),l(-.09,.089),l(-.183,.108),l(-.062,-.063),l(-.089,-.034),l(-.123,-.022),l(-.134,.033),l(-.045,-.067),l(-.312,-.257),l(-.212,-.011),l(-.179,-.078),l(-.146,-.089),l(-.066,-.089),l(-.045,-.078),l(-.123,-.034),l(-.134,-.011),l(-.132,.118),
N(450.198,105.998),l(.013,-.208),l(.008,-.514),l(.246,-.301),l(.762,-.333),l(.302,-.302),l(-.028,-.2),l(-1.326,-1.122),l(-.056,-.271),l(.18,-.302),l(.383,-.374),l(.328,-.346),l(.392,.204),l(.352,.106),l(-.234,.318),l(.048,.189),l(.266,-.023),l(.771,-.189),l(.506,.002),l(1.151,.395),l(.34,-.031),l(.69,-.261),l(.3,.013),l(1.385,.35),l(.38,-.059),l(1.904,-.771),l(.618,-.218),l(.562,.04),l(.671,.369),l(.295,.042),l(.514,.226),l(1.346,.336),l(.671,.12),l(-.066,.335),l(-.077,.258),l(-.261,.086),l(-.313,-.028),l(-.339,.129),l(-.327,.73),l(-.039,.586),l(-.075,.143),l(-.404,.115),l(-.338,.372),l(-.017,.257),l(.252,-.036),l(.255,.224),l(.033,.154),l(.391,.375),l(.01,.223),l(-1.333,-.005),l(-.527,-.111),l(-.497,.045),l(-.629,.374),l(-.498,.445),l(-.363,-.026),l(-.344,.216),l(.097,.327),l(-.086,.257),l(-1.117,.277),l(-.388,.031),l(-.619,-.21),l(-1.473,-.505),l(-.584,.06),l(-.799,.261),l(-1.855,.195),l(-.09,.029),l(-.047,-.199),l(.104,-.3),l(.006,-.499),l(-.225,-.469),l(-.358,-.383),l(-.666,-.296),l(-.134,-.213),l(.007,-.106),
N(381.009,107),l(-.121,-.278),l(.138,-.4),l(.343,-.5),l(-.358,-.471),l(-.304,-.428),l(-.514,-.07),l(-.164,-.1),l(-.053,-.329),l(.163,-.243),l(.409,-.272),l(.365,-.101),l(.563,-.03),l(.634,-.03),l(.133,-.172),l(.068,-.415),l(.535,-.273),l(.763,.042),l(1.078,.37),l(.763,.07),l(.756,-.087),l(.577,-.173),l(.508,-.144),l(.354,-.001),l(.629,.285),l(.694,.156),l(.939,.084),l(1.538,.04),l(.583,.027),l(.957,.141),l(.491,-.158),l(.419,-.229),l(.531,.027),l(.891,.47),l(.67,-.016),l(.335,.062),l(.472,.243),l(.469,-.03),l(.058,.122),l(-.205,.243),l(.094,.106),l(.15,.03),l(.112,-.106),l(1.088,.334),l(.15,-.061),l(.507,.395),l(.056,-.076),l(.262,.03),l(.131,-.076),l(.431,.152),l(.028,.038),l(.084,.114),l(.767,-.03),l(.037,.122),l(.337,-.061),l(.542,.015),l(-.017,-.319),l(.355,0),l(1.252,.304),l(.091,.213),l(.035,.289),l(.187,.076),l(.374,-.076),l(.206,-.03),l(.335,.091),l(.036,.152),l(.261,.015),l(.395,-.167),l(.427,.197),l(.485,.015),l(.039,-.136),l(.75,-.137),l(.334,.091),l(-.001,.088),l(-.001,.463),l(.156,.1),l(-.062,.485),l(-1.112,.528),l(-.95,.385),l(-.267,.328),l(-1.046,.198),l(-.664,.116),l(-.96,.301),l(-.323,.326),l(-.053,.2),l(.261,.128),l(-.088,.157),l(-.628,.143),l(-.594,.783),l(-.886,.787),l(-.096,.192),l(-.18,.361),l(-.245,.45),l(.353,.827),l(.072,.111),l(.084,.13),l(.648,.295),l(.103,.185),l(-.621,.327),l(-.215,.105),l(-.515,.252),l(-.286,.479),l(-.224,.085),l(-.461,.926),l(.155,.322),l(-.257,.099),l(-.992,.049),l(-.581,.242),l(-.425,.327),l(-.274,.757),l(-.663,.496),l(-.258,-.213),l(-.599,.028),l(-.305,.27),l(-.342,0),l(-.121,-.113),l(-3.282,.042),l(-.69,.524),l(-1.021,.17),l(-.35,.382),l(-.028,.283),l(-.083,.085),l(-.073,-.212),l(-.068,-.014),l(.005,.241),l(-.389,.127),l(-.421,-.142),l(-.788,-.467),l(-.224,-.382),l(.036,-.262),l(-.345,-.113),l(-.125,-.213),l(.175,-.163),l(-.468,-.51),l(-.702,-.284),L(385,117.498),l(-.484,-.135),l(-.586,.039),l(.008,-.018),l(.304,-.951),l(.242,-.37),l(.884,-.643),l(-.408,-.31),l(-.812,-.123),l(.17,-.455),l(.506,-.655),l(.347,-.371),l(-.163,-.198),l(-.455,-.551),l(-.488,-.494),l(.288,-.129),l(.482,-.045),l(.458,-.229),l(.043,-.199),l(-.057,-.938),l(.132,-.983),l(-.072,-.456),l(.051,-.442),l(.084,-.072),l(1.234,-.506),l(.288,-.216),l(-.062,-.242),l(-.842,-.495),l(-.15,-.242),l(-.272,-.227),l(-.335,-.055),l(-.531,.26),L(382.981,107),l(-.531,-.439),l(-.55,.188),L(381.009,107),
N(489.685,103.693),l(.112,-.309),l(.26,-.166),l(.284,.047),l(.07,.047),l(.402,.023),l(.449,.023),l(.283,.095),l(.284,.142),l(.188,.094),l(.189,.047),l(.331,0),l(.213,0),l(.212,.166),l(.261,.095),l(.307,.071),l(.355,.047),l(.307,0),l(.426,-.095),l(.544,0),l(.401,.166),l(.189,0),l(.283,-.047),l(.354,.166),l(.095,.142),l(.284,.213),l(.52,.118),l(.354,.071),l(.236,.118),l(.308,.119),l(-.142,.118),l(-.048,.118),l(.261,.118),l(.212,.071),l(.261,-.118),l(.283,0),l(.166,-.166),l(.094,-.095),l(.213,-.071),l(.354,0),l(.261,.071),l(.188,.142),l(.142,-.166),l(.095,-.071),l(.118,0),l(.236,.118),l(.143,.094),l(.212,0),l(.189,.118),l(.213,.166),l(.378,0),l(.354,.024),l(.118,.142),l(-.118,.189),l(-.118,.307),l(.354,.284),l(.284,.166),l(.26,.094),l(.284,.047),l(.236,-.023),l(.236,.071),l(.126,.189),l(-.268,.189),l(-.143,.142),l(-.095,.071),l(.143,.26),l(.213,.307),l(.614,.166),l(.118,.213),l(-.095,.331),l(-.236,.095),l(-.236,.047),l(-.26,-.189),l(-.143,-.071),l(-.188,-.023),l(-.284,.047),l(-.638,-.189),l(-.189,-.213),l(-.331,-.189),l(-.473,-.024),l(-.236,0),l(-.418,.308),l(-.291,.094),l(-.378,.047),l(-.591,.095),l(-.592,-.047),l(-.401,.118),l(-.426,.023),l(-.308,.095),l(-.307,-.024),l(-.377,.108),l(-.031,-.028),l(-1.326,-1.018),l(-.41,-.041),l(-.761,.36),l(-.226,.072),l(-.491,-.068),l(-1.212,-.082),l(.083,-.065),l(.322,-.585),l(.032,-.143),l(-.064,-.728),l(-.331,-1.084),l(-.206,-.399),l(-.639,-.513),l(-.341,-.128),l(-.916,-.155),l(-.679,-.271),l(-.341,-.243),
N(443.617,107.095),l(-.065,-.035),l(-.435,-.156),l(-.017,-.15),l(-.501,-.485),l(-.848,-.3),l(-.033,-.021),l(.002,-.1),l(-.029,-.092),l(-.082,-.072),l(-.033,-.078),l(.022,-.089),l(-.005,-.004),l(.183,-.108),l(.09,-.089),l(-.045,-.101),l(-.078,-.089),l(-.066,-.112),l(-.012,-.044),l(-.011,-.145),l(-.012,-.112),l(.012,-.134),l(.101,-.089),l(.111,-.022),l(.134,-.011),l(.056,-.056),l(-.011,-.1),l(-.034,-.089),l(.112,-.101),l(.044,-.089),l(.045,-.101),l(.168,-.078),l(.122,-.056),l(.123,.011),l(.056,.044),l(.056,.089),l(.09,.056),l(.111,0),l(.056,-.101),l(-.056,-.101),l(-.123,-.167),l(-.089,-.1),l(-.012,-.078),l(.078,-.056),l(.112,-.033),l(.066,.044),l(.112,.022),l(.156,-.056),l(.056,.033),l(0,.101),l(.223,.056),l(.156,.101),l(.168,.078),l(.111,.111),l(.101,.146),l(.167,.134),l(.056,.033),l(.078,.022),l(.279,.078),l(.101,.056),l(.078,.011),l(.067,-.044),l(.066,.022),l(.078,.1),l(.123,.101),l(.033,.067),l(.078,.045),l(.111,-.022),l(.057,.044),l(.134,.045),l(.167,.067),l(.101,.101),l(.011,.089),l(-.089,.011),l(-.134,.022),l(-.09,.044),l(-.021,.067),l(-.057,.033),l(-.167,-.033),l(-.146,-.011),l(-.111,.033),l(-.022,.089),l(.056,.056),l(.101,0),l(.078,.067),l(0,.067),l(-.109,.286),l(-.361,-.022),l(-.727,-.11),l(-.273,.273),l(-.279,.515),l(.133,.427),l(-.002,.342),
N(558.52,110.652),l(.042,-.098),l(.318,.073),l(.246,-.073),l(.221,-.025),l(.294,.098),l(.319,.098),l(.245,.147),l(.221,-.196),l(.271,-.049),l(.221,-.196),l(.343,-.196),l(.172,-.049),l(.319,0),l(0,-.147),l(-.049,-.171),l(.245,.049),l(.49,.024),l(.221,-.147),l(.197,-.147),l(.49,-.221),l(-.172,-.123),l(-.466,-.024),l(-.516,-.074),l(-.245,-.196),l(-.319,-.147),l(-.343,.025),l(-.025,-.098),l(-.073,-.246),l(-.147,.024),l(-.393,-.024),l(-.049,-.147),l(-.172,-.294),l(-.196,-.172),l(-.196,-.098),l(-.024,.245),l(-.196,.196),l(-.221,-.049),l(-.049,.393),l(-.393,0),l(-.589,0),l(-.368,-.27),l(-.172,-.221),l(-.098,-.221),l(-.418,.147),l(-.146,-.123),l(-.295,-.074),l(-.294,-.049),l(.024,-.123),l(.172,-.098),l(.441,-.295),l(.196,-.147),l(.294,-.172),l(.295,-.049),l(.073,-.196),l(.221,-.049),l(.368,-.171),l(.368,-.172),l(-.441,-.246),l(-.349,.126),l(-.044,-.273),l(.393,-.442),l(.318,-.368),l(.736,-.123),l(.663,-.098),l(.883,.147),l(.883,.245),l(.688,.196),l(.81,.123),l(.344,.123),l(-.024,-.442),l(.245,-.736),l(.466,-.368),l(.688,-.123),l(.589,.074),l(.761,.27),l(.735,.246),l(.908,.196),l(.54,.098),l(.441,-.27),l(.858,-.024),l(.761,0),l(.785,-.147),l(.712,.221),l(.662,.098),l(1.35,.024),l(.662,-.074),l(.981,.246),l(.564,-.049),l(.147,.344),l(.27,.147),l(.196,.27),l(.663,0),l(.466,.098),l(.41,.375),l(.031,.194),l(-.051,.157),l(-.325,.187),l(-.97,.219),l(-1.338,.349),l(-.445,.145),l(-.405,.301),l(-.638,.701),l(-.646,.345),l(-.478,.102),l(-.459,.017),l(-1.248,-.235),l(-.238,.03),l(-.467,.472),l(-.463,.784),l(-.268,.243),l(-.885,.132),l(-.507,.145),l(-.344,-.055),l(-.183,-.567),l(-.06,-.071),l(-.359,.03),l(-1.737,.734),l(-1.422,.704),l(-.274,.186),l(-.129,.213),l(-.139,.739),l(-.196,-.073),l(-.344,.098),l(-.344,.171),l(-.539,0),l(-.663,-.073),l(-.834,.221),l(-.172,.147),l(-.196,0),l(-.172,-.319),l(-.368,.024),l(-.318,.172),l(-.074,-.221),l(-.049,-.172),l(-.122,.024),l(-.319,-.123),l(-.049,-.147),l(-.221,-.024),l(-.442,.123),l(-.343,.049),l(.024,.221),l(-.295,.049),l(-.393,-.074),l(-.073,-.196),l(-.147,-.123),l(-.368,-.098),l(-.49,.147),l(-.196,-.073),l(-.688,.024),l(-.564,0),l(-.589,.024),l(-.122,-.098),l(-.049,-.147),l(-.099,-.27),l(.099,-.245),l(.196,-.196),l(.098,.221),l(.196,-.074),l(-.049,-.196),l(.098,-.27),l(.123,0),l(.981,-.196),l(.515,.147),l(.516,.196),l(.099,.172),l(.196,0),l(.024,-.246),l(.441,-.196),l(.302,-.147),
N(685.343,114.455),l(-.571,.678),l(-.309,.115),l(-.511,-.096),l(-.579,-.068),l(-.595,-.011),l(-.315,.157),l(-.633,.738),l(-.283,.256),l(-.235,.171),l(-.268,-.206),l(-.35,.34),l(-.319,.199),l(-.373,-.608),l(-.398,-.112),l(-.649,.78),l(-.195,-.382),l(-.232,-.254),l(-.683,-.367),l(-.169,-.453),l(.095,-.312),l(.429,-.411),l(.754,-.229),l(.056,-.269),l(-.591,-.282),l(.407,-.879),l(.189,-.34),l(-.199,-.269),l(-.632,-.296),l(-.139,0),l(-.381,.029),l(-.312,.143),l(-.234,-.07),l(-.52,-.368),l(-.167,-.233),l(.379,-.528),l(.415,-.442),l(.52,-.329),l(1.533,-.604),l(1.032,-.545),l(.636,-.543),l(.686,-1.027),l(.386,-.13),l(.448,-.017),l(.273,.396),l(.493,.253),l(.508,.153),l(.975,-.048),l(.527,-.159),l(-.046,-.113),l(-.508,-.765),l(.025,-.342),l(.273,-.243),l(.392,-.059),l(.333,.126),l(.452,.054),l(.538,-.017),l(.62,-.259),l(.955,-.532),l(.23,-.713),l(.383,-.358),l(.253,-.129),l(.247,-.001),l(.579,.68),l(.298,.439),l(.167,.393),l(-1.356,.923),l(-.408,.457),l(-.112,.414),l(.09,.427),l(-.154,.456),l(-.187,.868),l(-.668,.115),l(-.36,.229),l(-.497,.385),l(-.766,.641),l(-.468,.214),l(-.678,.03),l(-.577,.199),l(-.265,.228),l(-.248,.312),l(-.364,.893),l(.284,.326),l(1.225,.847),l(.419,.354),
N(536.625,121.017),l(-.078,-.028),l(-.15,-.692),l(-.01,-.565),l(-.038,-.848),l(-.185,-.211),l(-.787,.075),l(-.696,-.01),l(-.655,-.506),l(-1.803,-1.362),l(-.597,-.336),l(-.66,-.167),l(-.5,-.054),l(-.788,-.066),l(-.822,-.335),l(-.708,-.251),l(-.402,-.437),l(-1.055,-.107),l(-.519,-.054),l(-.343,.129),l(-.517,.343),l(-.333,.03),l(-.78,-.038),l(-.609,.032),l(-.413,.144),l(-.476,.328),l(-.621,.654),l(-.466,.3),l(-.562,.13),l(-.441,-.025),l(-.066,-.376),l(-.128,-.681),l(-.106,-.447),l(.128,-.298),l(0,-.383),l(0,-.532),l(.106,-.191),l(.106,-.298),l(.085,-.234),l(-.085,-.212),l(-.256,-.128),l(-.319,-.191),l(-.213,-.255),l(-.042,-.149),l(-.171,0),l(-.191,-.042),l(-.361,-.106),l(-.191,.192),l(-.086,-.234),l(.086,-.106),l(.148,-.255),l(.128,.106),l(.383,-.042),l(.426,.085),l(.128,.021),l(.043,-.128),l(-.319,-.213),l(-.256,-.021),l(-.085,-.277),l(.17,-.255),l(.213,-.191),l(-.404,-.042),l(-.319,.085),l(-.383,0),l(-.319,-.085),l(-.128,.149),l(-.17,-.255),l(-.149,-.298),l(0,-.34),l(-.042,-.298),l(.17,-.213),l(.106,-.319),l(.043,-.255),l(.105,-.277),l(.086,-.234),l(.213,.34),l(.063,.128),l(.17,.17),l(.405,-.085),l(.383,.128),l(.106,-.149),l(-.021,-.149),l(.106,0),l(.148,.021),l(.064,.319),l(.106,.191),l(.298,-.021),l(.298,-.063),l(.256,-.106),l(.233,.085),l(.192,.064),l(.085,-.128),l(-.149,-.191),l(-.042,-.213),l(.191,-.042),l(.106,.149),l(.233,.085),l(.256,-.085),l(.213,-.064),l(.021,-.234),l(-.171,-.341),l(-.34,-.234),l(-.532,-.319),l(-.426,-.213),l(-.063,-.319),l(-.043,-.34),l(-.213,-.17),l(0,-.213),l(0,-.213),l(-.085,-.127),l(-.554,-.064),l(-.617,.085),l(-.426,.021),l(-.446,.127),l(-.192,.277),l(-.085,.298),l(.128,.192),l(-.063,.276),l(-.086,.405),l(.064,.234),l(.021,.298),l(-.256,-.553),l(-.361,-.319),l(.042,-.17),l(-.063,-.191),l(-.274,-.143),l(.529,-.453),l(.937,-.532),l(1.277,-.298),l(.979,-.085),l(.512,.234),l(.681,.383),l(.617,.383),l(.256,.511),l(.638,.703),l(.447,.255),l(.489,-.043),l(.341,-.106),l(.158,.014),l(1.03,.063),l(1.383,-.032),l(.126,-.314),l(-.314,-.409),l(.062,-.628),l(.503,-.409),l(.503,-.251),l(.629,0),l(.283,-.126),l(.22,-.346),l(.126,-.126),l(.283,0),l(.597,.283),l(-.188,-.377),l(-.251,-.251),l(.565,-.157),l(.188,-.063),l(.472,.095),l(.629,.377),l(.346,.032),l(.22,.314),l(.692,.095),l(.534,.094),l(.251,.22),l(.032,.22),l(0,.22),l(.439,.283),l(-.188,.157),l(-.031,.188),l(.188,.22),l(-.157,.188),l(-.094,.22),l(.691,.314),l(.314,.157),l(.503,-.094),l(.439,-.032),l(.535,.126),l(.439,-.063),l(.188,-.157),l(.881,.251),l(.22,.377),l(.126,.566),l(.408,.597),l(.283,.188),l(.188,.44),l(0,.283),l(1.384,.975),l(1.194,.597),l(.377,.44),l(1.006,.503),l(.314,-.063),l(.943,.597),l(.565,.22),l(1.132,.597),l(.378,.251),l(.471,-.063),l(.566,.189),l(.534,.283),l(.503,.094),l(-.062,.22),l(-.157,.251),l(.062,.503),l(-.091,.726),l(-1.454,-.244),l(-.565,-.294),l(-.445,.356),l(-.417,.2),l(-1.135,.205),l(-.432,.809),l(-.203,.991),l(-.103,.128),l(-.508,.243),l(-1.985,.689),l(-.568,.159),l(-.119,.199),l(-.001,.466),l(-.22,.199),l(-.636,.3),l(-.534,.031),l(-.573,-.082),l(-.999,-.348),l(-.937,-.193),l(-.193,-.112),
N(445.294,112.196),l(-.07,-.115),l(-.138,-.469),l(-.5,-.452),l(-.966,-.541),l(.024,-.141),l(.23,.062),l(.023,-.237),l(-.345,-.414),l(.418,-.616),l(-.182,-.22),l(.188,-.563),l(-.251,-.282),l(.182,-.396),l(.268,-.079),l(-.027,-.45),l(-.331,-.081),l(-.2,-.107),l(.002,-.342),l(-.133,-.427),l(.279,-.515),l(.273,-.273),l(.727,.11),l(.361,.022),l(.058,.004),l(.382,.369),l(.733,.866),l(.018,.109),l(.035,.218),l(-.132,.429),l(.074,.641),l(.298,.668),l(.722,.608),l(-.09,.029),l(-.449,.842),l(-.402,.386),l(-.496,.472),l(-.583,.884),
N(451.512,108.463),l(-.507,.16),l(-.532,.245),l(-.622,-.054),l(-.361,-.041),l(-.365,.159),l(-.395,.429),l(-.606,.146),l(-.809,.076),l(-.722,-.608),l(-.298,-.668),l(-.074,-.641),l(.132,-.429),l(-.035,-.218),l(.14,.049),l(.188,0),l(.072,-.087),l(.029,-.072),l(-.029,-.13),l(.058,-.167),l(.088,-.058),l(.225,-.058),l(.246,-.058),l(.116,-.058),l(.08,-.065),l(.087,.073),l(.131,.058),l(.094,.109),l(.116,0),l(.029,-.058),l(-.059,-.072),l(.109,-.058),l(.151,-.102),l(.152,-.087),l(.175,.043),l(.064,-.007),l(.196,.007),l(.152,.015),l(.087,-.08),l(.131,-.116),l(.064,.021),l(.102,.043),l(.088,-.021),l(.087,-.043),l(.102,.051),l(.058,-.015),l(.116,-.022),l(.145,-.021),l(.16,-.022),l(.072,-.029),l(.058,.017),l(-.007,.106),l(.134,.213),l(.666,.296),l(.358,.383),l(.225,.469),l(-.006,.499),l(-.104,.3),l(.047,.199),
N(383.93,117.402),l(-.249,.101),l(-.517,.291),l(-.439,.052),l(-.548,-.178),l(-.58,0),l(-.28,-.073),l(-.719,.292),l(-.058,-.177),l(.389,-1.012),l(-.021,-.856),l(-.182,-.115),l(.244,-.542),l(-.054,-.397),l(.13,-.114),l(-.144,-.141),l(-.375,.085),l(-.476,.097),l(-.108,-.449),l(.48,-.052),l(.283,-.22),l(-.042,-.17),l(-.178,-.226),l(-.3,.417),l(-.413,.136),l(-.357,-.042),l(-.059,-.188),l(.198,-.397),l(.138,-.616),l(-.039,-.303),l(.258,-.114),l(.403,-.503),l(.45,-1.098),l(-.12,-.115),l(.612,-1.783),l(-.35,-.924),l(-.007,-.42),l(-.146,-.378),l(.255,-.271),l(.891,-.251),l(.55,-.188),l(.531,.439),l(1.822,.047),l(.531,-.26),l(.335,.055),l(.272,.227),l(.15,.242),l(.842,.495),l(.062,.242),l(-.288,.216),l(-1.234,.506),l(-.084,.072),l(-.051,.442),l(.072,.456),l(-.132,.983),l(.057,.938),l(-.043,.199),l(-.458,.229),l(-.482,.045),l(-.288,.129),l(.488,.494),l(.455,.551),l(.163,.198),l(-.347,.371),l(-.506,.655),l(-.17,.455),l(.812,.123),l(.408,.31),l(-.884,.643),l(-.242,.37),l(-.304,.951),l(-.008,.018),
N(500.121,117.572),l(-.407,-.016),l(-.433,.388),l(-.164,.126),l(-.318,-.105),l(-.102,-.269),l(.03,-.259),l(-.274,-.151),l(-.366,-.082),l(-.244,.234),l(-.343,-.023),l(-.811,-.153),l(-.364,.032),l(-.304,-.16),l(-.437,.094),l(-.266,.143),l(-.23,.043),l(-.064,-.245),l(-.207,-.023),l(-.24,.292),l(-.693,.304),l(-1.185,.224),l(-.711,-.039),l(-.747,-.123),l(-.439,.073),l(-1.498,.673),l(-.567,.13),l(-1.104,.176),l(-.556,-.153),l(-1.532,-.444),l(-.278,.03),l(-.929,.373),l(-.746,.075),l(-.575,-.025),l(-.777,-.166),l(-.222,.001),l(-.142,-.035),l(-.055,.319),l(.102,.452),l(.243,.423),l(-.627,.127),l(-.156,.374),l(-.2,.169),l(-.171,-.041),l(-.114,.127),l(-.39,-.125),l(-.311,.001),l(-.245,-.459),l(-.119,-.093),l(.097,-.175),l(.242,-.197),l(.617,-.403),l(.021,-.175),l(-.049,-.134),l(-.279,-.28),l(-.146,-.053),l(-.487,.368),l(-.23,.041),l(-.137,.064),l(.092,.041),l(-.118,.216),l(-.172,.023),l(-.063,-.047),l(-.076,.088),l(-.297,.058),l(-.332,-.222),l(-.447,-.198),l(-.461,-.157),l(-.395,.046),l(-.849,.548),l(-.337,.286),l(.006,.204),l(-.141,.046),l(-.122,.07),l(-.005,.082),l(-.179,-.169),l(-.604,.206),l(-.689,.185),l(-.594,-.013),l(-.587,-.07),l(-.678,-.267),l(-.963,-.819),l(-1.181,-.479),l(-1.034,-.182),l(-.692,.072),l(-.119,.255),l(-.097,.609),l(-.053,.411),l(-.173,.156),l(-.256,0),l(-.253,-.155),l(-1.12,.243),l(-.423,-.027),l(-.386,-.183),l(-.657,-1.159),l(-.42,.354),l(-.764,-.451),l(-.451,.057),l(-.562,.412),l(-.227,-.382),l(.066,-.127),l(.242,-.17),l(-.116,-.17),l(-.989,-.012),l(-.545,-.013),l(-.088,-.269),l(.571,-.199),l(-.074,-.241),l(-.284,-.198),l(-.454,-.07),l(-.084,-.297),l(.041,-.34),l(.087,-.284),l(-.089,-.255),l(-.396,-.126),l(-.627,-.353),l(-.371,.086),l(-.265,-.084),l(-.004,-.255),l(.171,-.501),l(.131,.059),l(.478,.311),l(.567,-.271),l(-.396,-.283),l(.021,-.124),l(-.296,-.128),l(.03,-.128),l(.571,-.159),l(.152,-.113),l(-.068,-.142),l(-.149,-.088),l(-.337,-.035),l(.01,-.187),l(.18,-.07),l(-.163,-.164),l(-.198,-.117),l(-.009,-.152),l(-.227,-.012),l(.263,-.181),l(.296,-.275),l(.161,-.035),l(.07,-.16),l(-.341,-.042),l(-.573,.12),l(-.905,.164),l(-.166,-.035),l(.046,-.33),l(.127,-.125),l(-.003,-.199),l(-.029,-.286),l(.13,-.264),l(.299,.012),l(.184,-.41),l(.175,-.023),l(.63,-.422),l(.514,.012),l(.133,-.129),l(.479,-.047),l(.128,.211),l(.268,.102),l(.169,.028),l(.529,.022),l(.147,-.129),l(-.067,-.129),l(-.269,-.129),l(.286,-.094),l(.324,.036),l(.117,.082),l(-.219,.223),l(.213,-.026),l(1.053,-.073),l(.619,.042),l(.379,.046),l(.279,.047),l(.155,-.176),l(-.086,-.094),l(-.468,-.035),l(-.212,-.118),l(.275,-.212),l(1.386,-.151),l(.417,-.012),l(.377,-.117),l(-.442,-.012),l(-.592,.023),l(-.215,0),l(-.068,-.146),l(-.611,-.382),l(.325,-.528),l(.926,.14),l(1.244,.048),l(.264,-.117),l(1.086,.321),l(1.051,-.031),l(.414,-.243),l(-.041,-.27),l(.624,-.244),l(.455,-.214),l(1.218,-.573),l(.598,-.215),l(1.039,-.23),l(.889,-.073),l(.758,.07),l(.905,.126),l(.798,.041),l(.753,-.372),l(.216,.527),l(.416,.298),l(.278,.099),l(.592,.013),l(.622,-.144),l(.453,.74),l(.492,.255),l(.574,-.172),l(.391,.056),l(.968,.582),l(1.265,.04),l(1.094,.197),l(.749,-.001),l(1.084,-.272),l(.514,-.044),l(.651,.141),l(.764,.098),l(.787,-.016),l(.554,-.144),l(1.518,-.573),l(.424,-.335),l(1.212,.082),l(.491,.068),l(.226,-.072),l(.761,-.36),l(.41,.041),l(1.326,1.018),l(.031,.028),l(.795,.722),l(.026,.199),l(-.421,.813),l(.033,.412),l(.284,.211),l(1.413,.12),l(.492,.451),l(-.072,.211),l(-.409,-.023),l(-.231,.141),l(-.009,.433),l(-.584,.267),l(-.039,.27),l(.264,.67),l(-.122,.375),l(.224,.492),l(.09,.117),l(.106,-.105),l(.288,.203),l(.039,.207),l(-.229,.281),l(-.287,.535),l(-.06,.128),l(.213,.14),l(.424,.111),l(-.145,.245),l(.099,.421),l(.42,.374),l(.275,.035),l(.023,.308),M(462.617,106.804),l(.241,.211),l(-.019,.287),l(.115,.285),l(.077,.071),l(.593,.355),l(.819,.241),l(.605,.155),l(.152,.121),L(464.943,109),l(-.304,.166),l(-.515,-.072),l(-.94,-.246),l(-.326,.07),l(-.209,.152),l(-1.019,-.012),l(-.357,.384),l(-.109,.273),l(-.833,.316),l(-.612,.282),l(-.222,.258),l(-.307,.152),l(-.268,.293),l(-.255,.082),l(.164,-.258),l(.019,-.141),l(-.062,-.176),l(.584,-.293),l(.22,-.141),l(-.226,-.191),l(-.082,.015),l(-.653,-.056),l(-.229,-.148),l(.326,-.546),l(.387,-.558),l(.678,-.631),l(-.127,-.227),l(-.427,-.197),l(-.105,0),l(.498,-.445),l(.629,-.374),l(.497,-.045),l(.527,.111),l(1.333,.005),
N(509.077,114.955),l(-.72,-.317),l(-.268,.016),l(-.356,-.433),l(-.374,-.105),l(-.13,-.363),l(.532,-.27),l(.095,-.222),l(-.43,-.176),l(-.027,-.188),l(.63,-.129),l(.094,-.155),l(-.061,-.113),l(-.487,-.21),l(-.351,-.281),l(-.306,-.166),l(-.456,.234),l(-1.058,.492),l(-.374,.445),l(-.642,.188),l(-.254,.255),l(-.014,-.027),l(.094,-.118),l(-.094,-.213),l(-.189,-.071),l(.26,-.095),l(.166,-.047),l(-.261,-.189),l(-.236,-.236),l(.236,-.118),l(.095,-.189),l(-.283,-.047),l(-.354,-.024),l(-.284,-.118),l(-.213,-.212),l(-.236,-.024),l(-.26,-.354),l(-.283,-.142),l(-.048,-.094),l(.166,0),l(.378,0),l(.165,-.236),l(0,-.236),l(-.213,-.024),l(-.188,-.142),l(-.544,-.331),l(-.283,-.354),l(.047,-.284),l(.402,-.142),l(-.119,-.236),l(-.212,-.166),l(-.426,-.071),l(-.284,-.095),l(.071,-.094),l(.071,-.118),l(-.284,-.095),l(-.087,-.212),l(.418,-.308),l(.236,0),l(.473,.024),l(.331,.189),l(.189,.213),l(.638,.189),l(.284,-.047),l(.188,.023),l(.143,.071),l(.26,.189),l(.236,-.047),l(.236,-.095),l(.095,-.331),l(-.118,-.213),l(-.614,-.166),l(-.213,-.307),l(-.143,-.26),l(.095,-.071),l(.143,-.142),l(.268,-.189),l(.229,-.023),l(.023,.166),l(.213,-.047),l(.189,0),l(.142,.189),l(.473,.284),l(.095,.118),l(.118,0),l(.283,.284),l(0,.308),l(.591,.094),l(.449,.142),l(.379,-.047),l(.165,-.213),l(.308,-.331),l(.283,-.094),l(.496,-.284),l(.292,-.449),l(.465,.331),l(.236,.378),l(.26,.189),l(.284,.307),l(.095,.52),l(.142,.236),l(.283,.26),l(.284,.165),l(0,.166),l(.449,.236),l(.473,-.047),l(.378,.071),l(.284,.166),l(.236,.189),l(.095,.189),l(0,.142),l(-.355,-.142),l(-.401,-.047),l(-.213,0),l(-.26,.047),l(-.142,.118),l(-.402,.071),l(-.213,.142),l(-.047,.189),l(-.023,.473),l(-.118,.26),l(-.095,.236),l(-.095,.378),l(.213,.236),l(-.023,.189),l(-.237,-.071),l(-.094,.095),l(-.071,.331),l(-.071,.26),l(-.118,-.047),l(-.094,-.236),l(-.143,-.095),l(-.165,.095),l(-.047,.307),l(.07,.166),l(-.118,.118),l(-.118,.095),l(.095,.26),l(-.363,.91),M(499.844,111.738),l(.709,.061),l(.142,-.047),l(.26,-.071),l(.236,.236),l(.071,.166),l(.378,.142),l(.213,.071),l(.308,-.118),l(.52,0),l(-.071,.213),l(.024,.236),l(.118,.023),l(.331,.166),l(-.071,.236),l(.421,.763),l(-.009,.001),l(-.253,-.133),l(-.416,.038),l(-.512,-.025),l(-.421,-.125),l(-.335,-.211),l(-.294,-.402),l(-.551,-.223),l(-.281,-.417),l(-.265,-.381),l(-.252,-.197),
N(455.452,122.442),l(.049,-.209),l(-.057,-.128),l(-.812,-.256),l(-.691,-.006),l(-.506,-.116),l(-.484,.017),l(-.121,-.046),l(-.103,-.093),l(.139,-.56),l(.315,-.005),l(-.005,-.088),l(-.009,-.122),l(.069,-.07),l(.083,.157),l(.021,.146),l(.303,.021),l(.172,.055),l(.184,-.076),l(-.014,-.082),l(.108,-.029),l(.157,.105),l(-.037,.093),l(-.099,.006),l(-.04,.053),l(.088,.023),l(.144,.035),l(.094,.046),l(.021,.128),l(.353,.041),l(.846,-.122),l(.509,.016),l(.035,.13),l(.192,.035),l(.608,.064),l(.307,.051),l(.358,-.121),l(.09,.05),l(-.101,.312),l(.163,.11),l(.105,0),l(.325,-.169),l(.286,-.058),l(.078,.052),l(.154,-.07),l(.232,-.146),l(-.083,.187),l(.015,.186),l(-.183,.268),l(-.582,-.046),l(-.349,.081),l(-.335,-.017),l(-1.994,.169),M(445.294,112.196),l(.583,-.884),l(.496,-.472),l(.402,-.386),l(.449,-.842),l(.09,-.029),l(.809,-.076),l(.606,-.146),l(.395,-.429),l(.365,-.159),l(.361,.041),l(.622,.054),l(.532,-.245),l(.507,-.16),l(.09,-.029),l(1.855,-.195),l(.799,-.261),l(.584,-.06),l(1.473,.505),l(.619,.21),l(.388,-.031),l(1.117,-.277),l(.086,-.257),l(-.097,-.327),l(.344,-.216),l(.363,.026),l(.105,0),l(.427,.197),l(.127,.227),l(-.678,.631),l(-.387,.558),l(-.326,.546),l(-.062,-.407),l(-.794,-.056),l(-.743,-.041),l(-.566,-.125),l(-.062,-.144),l(-.459,.186),l(-.248,.123),l(-.403,.012),l(-.031,-.247),l(-.335,.029),l(-.301,.314),l(-.431,.186),l(-.31,.03),l(-.306,-.159),l(-.252,.07),l(-.004,.133),l(.169,.185),l(.169,.34),l(.308,.059),l(.826,.609),l(-.166,.07),l(-.369,-.258),l(-.015,-.105),l(-.276,-.082),l(-.331,-.105),l(-.116,.099),l(-.211,.007),l(.069,.129),l(-.016,.129),l(.338,.164),l(.145,-.012),l(.114,.234),l(-.03,.129),l(-.245,.023),l(-.445,-.457),l(-.341,-.141),l(-.207,-.059),l(-.128,-.012),l(.003,.094),l(-.075,.035),l(.138,.164),l(.102,.105),l(.154,.141),l(.193,.059),l(.153,.035),l(.103,.094),l(-.093,.058),l(-.494,-.046),l(-.253,-.035),l(.035,-.176),l(-.137,-.293),l(-.164,-.188),l(-.401,-.108),l(-.472,-.373),l(.258,-.118),l(.025,-.136),l(-.053,-.122),l(-.182,-.035),l(-.153,.199),l(-.465,.176),l(.245,.224),l(-.25,.371),l(-.05,.249),l(.13,.121),l(.065,.172),l(.311,.338),l(.133,.036),l(.131,.479),l(.579,.421),l(.359,.467),l(-.172,.14),l(-.237,.082),l(.106,-.187),l(-.121,-.187),l(-.142,-.128),l(-.139,-.035),l(-.151,-.047),l(-.29,.175),l(.102,.188),l(.153,.081),l(.08,.316),l(-.193,.187),l(-.652,.141),l(.248,.046),l(.27,.14),l(.391,.058),l(.188,.222),l(.257,-.012),l(.155,.012),l(.048,.126),l(.367,.269),l(.306,.014),l(.138,.292),l(.282,.012),l(.27,0),l(.348,.303),l(.015,.128),l(-.193,.082),l(.238,.782),l(-.153,.175),l(-.185,0),l(-.226,-.385),l(-.222,-.047),l(-.207,-.278),l(-.101,-.142),l(-.17,0),l(-.496,.14),l(-.479,.105),l(-.184,.128),l(.315,.093),l(.013,.188),l(.007,.291),l(.229,.117),l(.153,-.026),l(.225,-.079),l(-.021,.198),l(.235,.175),l(-.519,.093),l(.002,.117),l(-.169,.062),l(-.309,-.086),l(.121,-.21),l(-.186,-.086),l(-.508,-.056),l(-.158,-.092),l(-.008,.206),l(.194,.453),l(.193,.17),l(-.045,.163),l(.209,.204),l(.213,.96),l(-.688,-.31),l(-.331,.071),l(-.298,.439),l(-.442,-.735),l(-.46,-.367),l(-.452,.44),l(-.428,-.353),l(-.127,-.297),l(.212,-.425),l(-.028,-.241),l(-.215,-.269),l(-.491,-.424),l(-.167,-.226),l(.017,-.17),l(.471,-.61),l(.609,.098),l(.425,-.298),l(.202,.042),l(1.668,.663),l(.337,-.1),l(.483,-.355),l(-.266,-.049),l(-.27,-.056),l(-1.204,-.493),l(-1.127,-.083),l(-.367,.058),l(-.66,.058),l(-.427,.143),l(-.89,-1.118),l(.269,-.1),l(.253,.056),l(.218,-.114),l(.122,-.185),l(-.339,-.24),l(-.235,.114),l(-.496,-.042),l(-1.035,-.721),l(-.199,-.325),
N(504.136,113.458),l(-.327,.328),l(-.377,.03),l(-.421,-.763),l(.071,-.236),l(-.331,-.166),l(-.118,-.023),l(-.024,-.236),l(.071,-.213),l(-.52,0),l(-.308,.118),l(-.213,-.071),l(-.378,-.142),l(-.071,-.166),l(-.236,-.236),l(-.26,.071),l(-.142,.047),l(-.709,-.061),l(-.492,-.451),l(-1.413,-.12),l(-.284,-.211),l(-.033,-.412),l(.421,-.813),l(-.026,-.199),l(-.795,-.722),l(.377,-.108),l(.307,.024),l(.308,-.095),l(.426,-.023),l(.401,-.118),l(.592,.047),l(.591,-.095),l(.378,-.047),l(.291,-.094),l(.087,.212),l(.284,.095),l(-.071,.118),l(-.071,.094),l(.284,.095),l(.426,.071),l(.212,.166),l(.119,.236),l(-.402,.142),l(-.047,.284),l(.283,.354),l(.544,.331),l(.188,.142),l(.213,.024),l(0,.236),l(-.165,.236),l(-.378,0),l(-.166,0),l(.048,.094),l(.283,.142),l(.26,.354),l(.236,.024),l(.213,.212),l(.284,.118),l(.354,.024),l(.283,.047),l(-.095,.189),l(-.236,.118),l(.236,.236),l(.261,.189),l(-.166,.047),l(-.26,.095),l(.189,.071),l(.094,.213),l(-.094,.118),l(.014,.027),
N(566.651,117.4),l(-.565,-.153),l(-.496,-.054),l(-.264,-.151),l(-.564,.227),l(-.974,.147),l(-.137,-.059),l(.129,-.176),l(-.198,-.077),l(-.678,.03),l(-.739,.315),l(-.592,.486),l(-.589,.064),l(-.745,.495),l(-.351,.03),l(-.368,-.026),l(-.128,-.084),l(-.164,-.409),l(-.199,-.521),l(.185,-.444),l(.099,-.775),l(.029,-.255),l(-.17,-.187),l(-.484,.093),l(.156,-.597),l(-.576,-.45),l(-.153,-.056),l(-.384,.016),l(-.286,.162),l(-.134,.363),l(-.435,.428),l(-.049,.425),l(.006,.255),l(-.208,.228),l(-.442,.158),l(-.133,-.013),l(-.587,-.152),l(-.292,.058),l(-.073,.185),l(.007,.311),l(-.3,.313),l(-.21,.128),l(-.381,.016),l(-.63,-.237),l(-.325,.001),l(-.581,.286),l(-.58,.343),l(-.485,.144),l(-.245,-.041),l(-.129,-.141),l(-.04,-.055),l(.375,-.843),l(-.063,-.377),l(.377,-.377),l(.283,-.503),l(.503,-.346),l(.157,-.22),l(-.126,-.283),l(-.471,-.314),l(-.126,-.409),l(.031,-.472),l(.126,-.22),l(-.126,-.22),l(-.346,0),l(-.44,-.032),l(-.157,-.157),l(-.346,-.188),l(-.251,-.283),l(.125,-.471),l(.472,-.283),l(.629,.126),l(1.069,.094),l(.282,-.188),l(.063,-.409),l(.251,-.157),l(.188,0),l(.032,-.346),l(.188,-.063),l(.251,-.063),l(-.126,-.094),l(-.534,.031),l(-.251,-.125),l(.503,-.094),l(.565,-.095),l(.472,.095),l(.062,-.126),l(.032,-.346),l(-.189,-.314),l(.283,-.314),l(-.031,-.22),l(.346,0),l(.22,.157),l(.252,.22),l(.22,-.157),l(.692,-.188),l(.471,-.346),l(.221,-.251),l(.439,.377),l(.252,.251),l(-.188,.22),l(-.409,.346),l(-.251,.126),l(.126,.188),l(.251,.063),l(.188,.283),l(.409,-.031),l(.345,.005),l(-.302,.147),l(-.441,.196),l(-.024,.246),l(-.196,0),l(-.099,-.172),l(-.516,-.196),l(-.515,-.147),l(-.981,.196),l(-.123,0),l(-.098,.27),l(.049,.196),l(-.196,.074),l(-.098,-.221),l(-.196,.196),l(-.099,.245),l(.099,.27),l(.049,.147),l(.122,.098),l(.589,-.024),l(.564,0),l(.688,-.024),l(.196,.073),l(.49,-.147),l(.368,.098),l(.147,.123),l(.073,.196),l(.393,.074),l(.295,-.049),l(-.024,-.221),l(.343,-.049),l(.442,-.123),l(.221,.024),l(.049,.147),l(.319,.123),l(.122,-.024),l(.049,.172),l(.074,.221),l(.318,-.172),l(.368,-.024),l(.172,.319),l(.196,0),l(.172,-.147),l(.834,-.221),l(.663,.073),l(.539,0),l(.344,-.171),l(.344,-.098),l(.196,.073),l(-.011,.069),l(.023,1.031),l(-.207,.223),l(.077,.305),l(.325,.394),l(.463,-.045),l(.229,-.162),l(.22,.06),l(.692,.039),l(.273,.154),l(.295,.494),l(-.009,.284),l(.028,.246),l(.152,.012),l(.049,.123),l(-.126,.428),l(.245,.237),l(-.152,.36),l(.2,.163),l(-.181,.185),l(-.08,.249),l(-.354,.136),
N(500.121,117.572),l(-.023,-.308),l(-.275,-.035),l(-.42,-.374),l(-.099,-.421),l(.145,-.245),l(-.424,-.111),l(-.213,-.14),l(.06,-.128),l(.287,-.535),l(.229,-.281),l(-.039,-.207),l(-.288,-.203),l(-.106,.105),l(-.09,-.117),l(-.224,-.492),l(.122,-.375),l(-.264,-.67),l(.039,-.27),l(.584,-.267),l(.009,-.433),l(.231,-.141),l(.409,.023),l(.072,-.211),l(.252,.197),l(.265,.381),l(.281,.417),l(.551,.223),l(.294,.402),l(.335,.211),l(.421,.125),l(.512,.025),l(.416,-.038),l(.253,.133),l(.009,-.001),l(.377,-.03),l(.327,-.328),l(.254,-.255),l(.642,-.188),l(.374,-.445),l(1.058,-.492),l(.456,-.234),l(.306,.166),l(.351,.281),l(.487,.21),l(.061,.113),l(-.094,.155),l(-.63,.129),l(.027,.188),l(.43,.176),l(-.095,.222),l(-.532,.27),l(.13,.363),l(.374,.105),l(.356,.433),l(.268,-.016),l(.72,.317),l(.015,.007),l(-.05,.707),l(-.143,.581),l(.205,.48),l(.494,.252),l(.925,.235),l(.827,.052),l(.424,.097),l(.162,.282),l(.312,.451),l(.687,.463),l(1.902,.513),l(.841,.052),l(.438,-.059),l(1.354,-.262),l(1.192,-.148),l(1.469,-.079),l(.41,-.229),l(.185,-.354),l(-.131,-.905),l(.015,0),l(.441,.025),l(.562,-.13),l(.466,-.3),l(.621,-.654),l(.476,-.328),l(.413,-.144),l(.609,-.032),l(.78,.038),l(.333,-.03),l(.517,-.343),l(.343,-.129),l(.519,.054),l(1.055,.107),l(.402,.437),l(.708,.251),l(.822,.335),l(.788,.066),l(.5,.054),l(.66,.167),l(.597,.336),l(1.803,1.362),l(.655,.506),l(.696,.01),l(.787,-.075),l(.185,.211),l(.038,.848),l(.01,.565),l(.15,.692),l(.078,.028),l(-.145,.241),l(-.084,.339),l(-.246,.807),l(-.49,1.272),l(-.222,.297),l(-.596,.384),l(-.016,.141),l(.119,.663),l(.096,.098),l(.738,.235),l(.026,.183),l(-.661,.935),l(-.034,.155),l(.254,1.085),l(.167,1.283),l(.143,.775),l(.191,.21),l(.209,.041),l(1.198,.275),l(.401,.167),l(.144,.366),l(.046,.437),l(-.425,.553),l(-.853,.795),l(-.853,1.034),l(.802,1.083),l(.71,1.068),l(.353,.464),l(.695,.391),l(1.144,.388),l(.409,.224),l(.168,.38),l(.111,1.34),l(.185,.394),l(.652,.053),l(.186,.281),l(-.036,.974),l(-.188,.255),l(-.209,.072),l(-1,.077),l(-.697,.258),l(-.794,.47),l(-.285,.383),l(-.31,.792),l(-.049,.354),l(-.182,.954),l(-.502,.028),l(-1.079,-.153),l(-.236,-.197),l(-.605,-.253),l(-.403,-.056),l(-1.43,.003),l(-.783,-.041),l(-.602,.072),l(-.475,-.38),l(-.163,-.126),l(-.835,-.026),l(-.576,.001),l(-.465,.014),l(-.212,-.239),l(-.756,-.125),l(-.305,-.183),l(-.162,-.014),l(-.021,-.5),l(-.295,-.128),l(-.103,-.514),l(-.292,-.349),l(-.013,-.639),l(-.309,-.493),l(-.237,.012),l(-.035,-.181),l(-.526,-.126),l(-.807,-.013),l(-.374,.017),l(-.209,.222),l(-.329,.018),l(-.517,.075),l(-.188,.364),l(-.538,.138),l(-.383,.443),l(-.368,.283),l(-.253,.043),l(-1.292,-.689),l(-.958,-.104),l(-.562,-.359),l(-1.088,-.317),l(-.247,-.301),l(-.324,-.282),l(-.497,-.592),l(-.997,-.436),l(-.584,-.083),l(-.194,-.028),l(-.58,-.465),l(-.596,-1.058),l(-.635,-1.114),l(-.209,-.268),l(.005,-.593),l(-.767,-.761),l(-.506,-.719),l(-.921,.143),l(-.46,-.042),l(-.13,-.126),l(-.291,-.056),l(-.191,-.268),l(-.029,-.565),l(-.448,.1),l(-.166,.099),l(-.32,.678),l(-.195,.184),l(-.355,.012),l(-.014,-.12),l(-.351,-.224),l(-.686,-.546),l(.064,-.212),l(-.007,-.395),l(-.164,-.465),l(-.215,-.013),l(-.551,.003),l(-.034,-.325),l(.055,-.579),l(.197,-.622),l(.014,-.508),l(-.112,-.239),l(-.29,-.28),l(-.774,-.603),l(-.436,-.209),l(-1.242,-.925),l(-.533,-.025),l(-.321,.115),L(503,127.106),l(.033,-.819),l(-1.02,-.954),l(-.312,-.351),l(-.002,-.184),l(.133,-.875),l(.235,-.763),l(1.142,-.98),l(-.422,-.761),l(.013,-.254),l(.468,-.596),l(-1.067,-.107),l(-.761,-.208),l(-.065,-.198),l(-.563,-1.086),l(-.69,-1.397),
N(535.734,133.791),l(.853,-1.034),l(.853,-.795),l(.425,-.553),l(-.046,-.437),l(-.144,-.366),l(-.401,-.167),l(-1.198,-.275),l(-.209,-.041),l(-.191,-.21),l(-.143,-.775),l(-.167,-1.283),l(-.254,-1.085),l(.034,-.155),l(.661,-.935),l(-.026,-.183),l(-.738,-.235),l(-.096,-.098),l(-.119,-.663),l(.016,-.141),l(.596,-.384),l(.222,-.297),l(.49,-1.272),l(.246,-.807),l(.084,-.339),l(.145,-.241),l(.193,.112),l(.937,.193),l(.999,.348),l(.573,.082),l(.534,-.031),l(.636,-.3),l(.22,-.199),l(.001,-.466),l(.119,-.199),l(.568,-.159),l(1.985,-.689),l(.508,-.243),l(.103,-.128),l(.203,-.991),l(.432,-.809),l(1.135,-.205),l(.417,-.2),l(.445,-.356),l(.565,.294),l(1.454,.244),l(.096,.016),l(.646,.011),l(1.217,.05),l(.236,.126),l(.351,.48),l(.04,.055),l(.129,.141),l(.245,.041),l(.485,-.144),l(.58,-.343),l(.581,-.286),l(.325,-.001),l(.63,.237),l(.381,-.016),l(.21,-.128),l(.3,-.313),l(-.007,-.311),l(.073,-.185),l(.292,-.058),l(.587,.152),l(.133,.013),l(.442,-.158),l(.208,-.228),l(-.006,-.255),l(.049,-.425),l(.435,-.428),l(.134,-.363),l(.286,-.162),l(.384,-.016),l(.153,.056),l(.576,.45),l(-.156,.597),l(.484,-.093),l(.17,.187),l(-.029,.255),l(-.099,.775),l(-.185,.444),l(.199,.521),l(.164,.409),l(.128,.084),l(.368,.026),l(.351,-.03),l(.745,-.495),l(.589,-.064),l(.592,-.486),l(.739,-.315),l(.678,-.03),l(.198,.077),l(-.129,.176),l(.137,.059),l(.974,-.147),l(.564,-.227),l(.264,.151),l(.496,.054),l(.565,.153),l(-.192,.145),l(-.574,-.059),l(.01,.269),l(.236,.012),l(.048,.088),l(-.148,.142),l(-.358,.004),l(-.455,.297),l(-.332,-.005),l(-.338,.179),l(-.647,-.144),l(-1.345,.012),l(-1.148,.152),l(-.53,.292),l(-.272,.19),l(-.559,.395),l(-.246,-.023),l(-.258,.214),l(-.464,.413),l(.01,.32),l(.411,.271),l(.01,.336),l(.232,.171),l(-.119,.483),l(.198,.477),l(-.324,.426),l(-.524,.355),l(-.4,.341),l(-.13,.283),l(.223,.478),l(.033,.31),l(-.289,.255),l(-.513,.215),l(-.698,-.039),l(-.997,-.122),l(-.355,.129),l(.35,.336),l(.365,.407),l(.129,.281),l(.088,.437),l(-.199,.255),l(-.315,.115),l(-.513,.031),l(-.416,.115),l(-.292,.228),l(-.224,.424),l(-.288,.834),l(-.139,1.214),l(-.021,.084),l(-.34,.383),l(-.237,.086),l(-1.001,-.375),l(-.562,-.025),l(-.559,.243),l(-.362,.271),l(-.321,.693),l(-.254,.086),l(-.516,-.082),l(-.644,-.039),l(-.283,.072),l(-.597,.441),l(-.412,.369),l(-.188,.34),l(-.232,.876),l(-.099,.903),l(-.069,.184),l(-.247,.156),l(-1.066,.274),l(-1.183,.19),l(-.964,.175),l(-1.234,.12),l(-1.005,-.135),l(-.349,.002),l(-1.187,.218),l(-.742,-.024),l(-.541,-.039),l(-.854,-.235),l(-1.069,-.248),l(-.63,-.194),l(-.887,-.32),
N(486.696,126.295),l(5.257,-2.711),l(.589,-2.701),l(-.024,-.467),l(-.187,-.508),l(.009,-.255),l(.23,-.355),l(.31,-.214),l(.866,-.174),l(.457,-.371),l(.944,-.883),l(-.059,-.24),l(.23,-.043),l(.266,-.143),l(.437,-.094),l(.304,.16),l(.364,-.032),l(.811,.153),l(.343,.023),l(.244,-.234),l(.366,.082),l(.274,.151),l(-.03,.259),l(.102,.269),l(.318,.105),l(.164,-.126),l(.433,-.388),l(.407,.016),l(.69,1.397),l(.563,1.086),l(.065,.198),l(.761,.208),l(1.067,.107),l(-.468,.596),l(-.013,.254),l(.422,.761),l(-1.142,.98),l(-.235,.763),l(-.133,.875),l(.002,.184),l(.312,.351),l(1.02,.954),L(503,127.106),l(.075,.155),l(.321,-.115),l(.533,.025),l(1.242,.925),l(.436,.209),l(.774,.603),l(.29,.28),l(.112,.239),l(-.014,.508),l(-.197,.622),l(-.055,.579),l(.034,.325),l(.551,-.003),l(.215,.013),l(.164,.465),l(.007,.395),l(-.064,.212),l(.686,.546),l(.351,.224),l(.014,.12),l(-.096,.003),l(-.664,.101),l(-.408,-.056),l(-.157,.057),l(-.103,.127),l(-1.271,.044),l(-.518,.13),l(-.343,.693),l(-.463,.609),l(-.521,.568),l(-4.048,-.132),l(-1.557,-.697),l(-.812,-.277),l(-.118,-.253),l(-.047,-.818),l(.118,-.396),l(-.135,-.366),l(-.973,.048),l(-.141,-.07),l(-.399,-.633),l(-.258,-.196),l(-2.44,-1.101),l(-1.14,-.473),l(-2.034,-.934),l(-.757,-.222),l(-1.129,-.459),l(-.093,-.056),l(-.093,-.056),l(-.311,-.69),l(-.87,-1.632),
N(479.916,127.377),l(-.082,-.085),l(.047,-.122),l(-.021,-.183),l(-.201,-.128),l(-.183,-.346),l(.398,-.209),l(.041,-.099),l(.526,-.396),l(-.048,-.058),l(-.223,-.099),l(.077,-.151),l(.298,-.25),l(.599,-.006),l(-.14,-.146),l(-.035,-.046),l(.078,-.111),l(.177,-.163),l(.169,-.116),l(.299,-.239),l(-.068,-.058),l(.023,-.163),l(-.09,-.047),l(-.031,-.221),l(-.241,-.157),l(-.222,-.058),l(.204,-.204),l(-.125,-.052),l(-.053,-.116),l(-.12,.058),l(-.335,.052),l(-.388,-.023),l(-.225,-.564),l(.129,-.593),l(.072,-.064),l(-.1,-.507),l(-.42,-.326),l(.126,-.093),l(.036,-.152),l(.117,-.128),l(-.093,-.222),l(.107,-.012),l(.259,-.32),l(-.061,-.112),l(.311,-.001),l(.39,.125),l(.114,-.127),l(.171,.041),l(.2,-.169),l(.156,-.374),l(.627,-.127),l(-.243,-.423),l(-.102,-.452),l(.055,-.319),l(.142,.035),l(.222,-.001),l(.777,.166),l(.575,.025),l(.746,-.075),l(.929,-.373),l(.278,-.03),l(1.532,.444),l(.556,.153),l(1.104,-.176),l(.567,-.13),l(1.498,-.673),l(.439,-.073),l(.747,.123),l(.711,.039),l(1.185,-.224),l(.693,-.304),l(.24,-.292),l(.207,.023),l(.064,.245),l(.059,.24),l(-.944,.883),l(-.457,.371),l(-.866,.174),l(-.31,.214),l(-.23,.355),l(-.009,.255),l(.187,.508),l(.024,.467),l(-.589,2.701),l(-5.257,2.711),l(-.161,.071),l(-2.96,1.541),l(-1.139,.656),l(-.253,.016),l(-.365,-.167),l(-1.902,-1.034),
N(426.068,126.434),l(-.093,.981),l(.064,.564),l(-.093,.269),l(-.802,.428),l(-.579,.314),l(-1.473,1.138),l(-.126,.354),l(.274,.973),l(-.147,.537),l(-.155,.227),l(-.864,.598),l(-.22,.143),l(-.564,-1.536),l(-.699,-2.242),l(-.323,-.464),l(-.363,-.252),l(-.432,-.181),l(-.484,-.831),l(-.225,-.465),l(-.363,-.28),l(-.452,-.097),l(-.336,-.774),l(-.301,-.888),l(.112,-.509),l(1,-.853),l(.414,-.355),l(.163,-.411),l(.048,-.537),l(-.052,-.594),l(-.026,-.892),l(-.012,-1.429),l(.114,-.439),l(.685,-.627),l(.012,-.184),l(.508,-.185),l(.633,-.455),l(.591,-.228),l(.703,-.016),l(.643,.183),l(.247,.212),l(.059,.241),l(.25,.538),l(.27,.084),l(.417,-.171),l(.584,-.44),l(.401,-.17),l(.034,.354),l(-.265,.567),l(-.638,.511),l(-.275,.468),l(.005,.283),l(.202,.438),l(.508,.466),l(.351,.127),l(.303,.848),l(-.094,.212),l(-.541,.764),l(-.59,.34),l(-1.017,.92),l(-.216,.339),l(.287,.451),l(.587,.55),l(.528,.295),l(.284,.056),l(.396,-.227),l(.316,.084),l(.244,.635),l(.582,.239),
N(381.402,139.704),l(-.027,-.876),l(.069,-2.006),l(.037,-.382),l(.686,-.314),l(1.512,-.998),l(.963,-.542),l(1.265,.078),l(.397,-.059),l(.181,-.693),l(.864,-.033),l(.777,-.174),l(.527,-.229),l(.524,-.356),l(.484,-.652),l(1.109,-.332),l(1.52,-.701),l(.129,-.227),l(-.296,-.62),l(-.025,-.396),l(.079,-.227),l(.265,-.114),l(1.186,-.12),l(.381,-.186),l(.309,-.553),l(1.022,.022),l(.67,-.018),l(1.826,.004),l(.34,-1.033),l(-.07,-.211),l(-.507,-.322),L(397,126.646),l(-.158,-.465),l(.016,-1.271),l(.022,-.833),l(-.165,-.889),l(-.189,-.211),l(-.563,-.279),l(-.259,-.508),l(.351,0),l(.66,-.143),l(.541,-.256),l(.369,-.566),l(.405,-.312),l(.509,-.086),l(.407,-.157),l(.679,-.27),l(.324,.226),l(.176,.017),l(.249,.024),l(.238,-.142),l(.407,-.51),l(.613,-.426),l(.682,-.355),l(.614,-.171),l(1.16,-.116),l(1.587,-.06),l(.513,-.072),l(.634,-.312),l(.578,.211),l(.564,-.072),l(.585,-.313),l(.343,-.1),l(.939,.012),l(.513,-.015),l(.307,.056),l(.221,.042),l(.322,.113),l(.816,.168),l(.529,-.015),l(.772,-.171),l(.705,-.2),l(.612,-.554),l(.994,.508),l(.339,.099),l(.312,-.143),l(.314,-.241),l(.228,-.156),l(.528,.042),l(.388,.197),l(.162,.269),l(.269,.126),l(.516,-.086),l(1.093,-.158),l(-.012,.184),l(-.685,.627),l(-.114,.439),l(.012,1.429),l(.026,.892),l(.052,.594),l(-.048,.537),l(-.163,.411),l(-.414,.355),l(-1,.853),l(-.112,.509),l(.301,.888),l(.336,.774),l(.452,.097),l(.363,.28),l(.225,.465),l(.484,.831),l(.432,.181),l(.363,.252),l(.323,.464),l(.699,2.242),l(.564,1.536),l(-.204,.156),l(-.241,.383),l(.88,1.605),l(.147,.833),l(.052,.691),l(-.1,.862),l(.101,.748),l(-.16,.622),l(-.158,.495),l(.457,1.156),l(-.061,.664),l(-.086,.17),l(-.666,.47),l(-.249,.128),l(-.152,.283),l(1.272,1.702),l(.249,.917),l(.562,.873),l(.244,.154),l(.544,-.201),l(.702,.165),l(1.028,.347),l(.178,.168),l(.86,1.506),l(.098,.07),l(-.265,.186),l(-1.632,.843),l(-4.012,2.241),l(-1.607,.956),l(-2.308,1.454),l(-.834,.655),l(-3.084,2.617),l(-1.82,.364),l(-1.672,.321),l(-2.176,.408),l(-.146,-.564),l(.161,-.679),l(-.099,-.522),l(-.277,-.352),l(-.309,-.111),l(-.748,-.024),l(-.375,-.167),l(-.588,-.562),l(-.47,.314),l(-.229,-.027),l(-1.111,-1.039),l(-.393,-.28),l(-.082,-.183),l(.096,-.396),l(-.181,-.253),l(-2.472,-1.469),l(-.397,-.253),l(-1.292,-.824),l(-1.924,-1.26),l(-3.283,-2.241),l(-.811,-.575),l(-2.054,-1.344),l(-.895,-.531),l(-.1,-.084),l(-1.414,-.91),l(-4.12,-2.42),l(-2.829,-1.509),
N(395.704,122.189),l(.259,.508),l(.563,.279),l(.189,.211),l(.165,.889),l(-.022,.833),l(-.016,1.271),l(.158,.465),l(.598,.788),l(.507,.322),l(.07,.211),l(-.34,1.033),l(-1.826,-.004),l(-.67,.018),l(-1.022,-.022),l(-.309,.553),l(-.381,.186),l(-1.186,.12),l(-.265,.114),l(-.079,.227),l(.025,.396),l(.296,.62),l(-.129,.227),l(-1.52,.701),l(-1.109,.332),l(-.484,.652),l(-.524,.356),l(-.527,.229),l(-.777,.174),l(-.864,.033),l(-.181,.693),l(-.397,.059),l(-1.265,-.078),l(-.963,.542),l(-1.512,.998),l(-.686,.314),l(-.037,.382),l(-.069,2.006),l(-1.42,.008),l(-1.718,-.004),l(-2.677,.001),l(-2.511,0),l(-1.635,.04),l(.141,-.28),l(.431,-.411),l(.427,-.085),l(1.296,-.285),l(1.143,-.455),l(.453,-.312),l(1.147,-.85),l(1.149,-.878),l(1.043,-1.104),l(.46,-.693),l(.133,-.509),l(-.05,-.494),l(-.427,-.776),l(-.09,-.678),l(.099,-.508),l(.396,-.636),l(.706,-.863),l(.211,-.65),l(-.063,-.367),l(.071,-.353),l(1.285,-1.203),l(.724,-.481),l(.916,-.327),l(1.266,-.469),l(.73,-.397),l(.558,-.552),l(.537,-.736),l(.466,-.905),l(.829,-1.925),l(.269,-.128),l(.54,-.171),l(.19,.127),l(.684,.848),l(.138,.099),l(1.148,.507),l(.661,-.001),l(.595,.042),l(1.304,-.074),l(.522,-.228),l(.437,-.27),l(.398,.551),l(.256,.099),l(.798,.097),l(.361,0),
N(480.248,123.437),l(.388,.023),l(.335,-.052),l(.12,-.058),l(.053,.116),l(.125,.052),l(-.204,.204),l(.222,.058),l(.241,.157),l(.031,.221),l(.09,.047),l(-.023,.163),l(.068,.058),l(-.299,.239),l(-.169,.116),l(-.177,.163),l(-.078,.111),l(.035,.046),l(.14,.146),l(-.599,.006),l(-.298,.25),l(-.077,.151),l(.223,.099),l(.048,.058),l(-.526,.396),l(-.041,.099),l(-.398,.209),l(-.07,-.023),l(-.088,.041),l(-.067,.193),l(-.009,.167),l(-.355,.07),l(-.07,-.099),l(-.151,-.022),l(-.372,.051),l(.26,-.291),l(.097,-.361),l(.169,-.227),l(.328,-.681),l(-.017,-.232),l(.181,0),l(.138,-.192),l(.072,-.32),l(.018,-.32),l(.409,-.431),l(.232,-.07),l(.116,-.174),l(-.048,-.157),
N(184.444,142.729),l(-.367,.82),l(-.518,.821),l(-.186,.763),l(-.179,1.159),l(.017,1.851),l(-.133,1.187),l(-.016,1.13),l(.564,1.737),l(.275,.805),l(.624,.945),l(.76,.903),l(.191,.452),l(.481,.521),l(.529,.974),l(.729,1.228),l(.375,.296),l(.677,.069),l(.436,-.015),l(.577,.154),l(.593,.451),l(.503,.508),l(.773,.069),l(1.016,-.242),l(1.55,-.456),l(1.396,-.3),l(.803,-.157),l(-.02,.542),l(.838,.223),l(.264,-.286),l(.293,-.199),l(-.104,-.247),l(-.393,-.175),l(1.073,-.62),l(.633,-.62),l(.086,-.827),l(.498,-.429),l(-.094,-.477),l(.092,-1.145),l(.254,-.699),l(.625,-.334),l(.164,-.043),l(.757,-.198),l(.701,-.1),l(1.088,-.229),l(1.016,-.37),l(.594,-.058),l(.499,.056),l(1.139,.181),l(.502,-.194),l(.378,.093),l(.62,.507),l(.047,.297),l(-.079,.424),l(-.298,.382),l(-.541,.496),l(-.433,.425),l(-.317,.445),l(-.02,.7),l(-.254,.297),l(-.188,.354),l(.155,.155),l(.337,-.138),l(-.101,.652),l(-.262,1.196),L(205.356,159),l(-.062,.24),l(-.34,-.534),l(-.167,-.452),l(-.072,-.155),l(-.386,.34),l(-.02,.549),l(-.437,.016),l(-.178,.447),l(-.599,.857),l(-.386,-.27),l(-.278,.095),l(.025,.329),l(-2.332,-.006),l(-1.792,-.005),l(-.04,1.24),l(-.999,.032),l(.396,.223),l(.495,.541),l(.624,.231),l(.359,.69),l(.532,.223),l(-.211,.683),l(-1.762,-.007),l(-1.06,.007),l(-1.076,1.812),l(.305,.397),l(-.207,.238),l(.054,.553),l(.044,.454),l(-.704,-.555),l(-.952,-.888),l(-.956,-.761),l(-1.069,-.859),l(-.534,-.352),l(-.053,-.071),l(-.639,-.252),l(-1.048,-.21),l(-.657,.044),l(-.817,.397),l(-1.1,.567),l(-.756,.256),l(-.931,-.069),l(-.724,-.21),l(-.48,-.197),l(-1.305,-.195),l(-.588,-.267),l(-.644,-.422),l(-.935,-.521),l(-.785,-.267),l(-1.711,-.392),l(-.963,-.365),l(-.722,-.366),l(-1.074,-.436),l(-.592,-.352),l(-1.123,-1),l(-.207,-.07),l(-.606,.058),l(-.689,-.14),l(-1.835,-.575),l(-.565,-.536),l(-.503,-.634),l(-.495,-.395),l(-1.049,-.577),l(-.619,-.267),l(-.5,-.494),l(-.742,-.987),l(-.363,-.55),l(-.038,-.113),l(.15,-.155),l(.504,-.086),l(.18,-.17),l(.047,-.184),l(-.331,-.367),l(.457,-.679),l(.041,-.381),l(-.172,-.466),l(-.744,-.959),l(.121,-.297),l(.146,-.17),l(-.07,-.268),l(-.665,-.62),l(-1.495,-1.777),l(-.546,-.493),l(-.963,-1.058),l(-.474,-.522),l(-.815,-.578),l(-.322,-.197),l(-.158,-.268),l(-.058,-.48),l(-.144,-.183),l(-.329,-.197),l(-.609,-.197),l(-.408,-.31),l(-.366,-.522),l(-.271,-.028),l(-.414,.114),l(-.238,-.155),l(-.163,-.367),l(-.005,-.325),l(.459,-.736),l(-.126,-.339),l(-.751,-.62),l(-.439,.255),l(-.375,-.621),l(-.118,-.353),l(-.359,-.211),l(-.61,-.168),l(-.319,-.296),l(-.125,-.254),l(.05,-.381),l(.084,-.269),l(-.185,-.226),l(-.561,-.21),l(-.46,-.098),l(-.46,-.253),l(-.935,-.86),l(-.478,-.706),l(-.281,-.551),l(-.646,-.832),l(-.736,-1.073),l(-.184,-.423),l(-.38,-.678),l(-.242,-.338),l(-.152,-.452),l(.042,-.509),l(.032,-.311),l(-.56,-.239),l(-.795,-.196),l(-.06,-.452),l(-.128,-.155),l(-.458,-.183),l(-.289,.326),l(-.251,.043),l(-1.43,-.647),l(-.285,1.004),l(-.045,.438),l(.033,.084),l(.265,.339),l(.264,.296),l(.028,1.046),l(.088,.509),l(.51,.677),l(.143,.169),l(.643,.267),l(.601,.536),l(.525,.663),l(.602,1.214),l(.44,.282),l(.328,.042),l(.237,.169),l(.325,1.398),l(.102,.169),l(.246,.155),l(.497,.056),l(.133,.056),l(.215,.438),l(.161,.65),l(.445,.79),l(.49,-.071),l(.223,-.142),l(.245,.452),l(.344,1.469),l(.531,1.059),l(.649,1.2),l(.069,.593),l(-.014,.522),l(.26,.353),l(.378,.154),l(.389,-.17),l(.234,-.198),l(.588,.804),l(.258,.579),l(.464,.253),l(.281,.014),l(.133,.311),l(-.196,.537),l(-.136,.127),l(-.691,.595),l(-.254,-.042),l(-.251,-.409),l(-.24,-.734),l(-.617,-.578),l(-.625,-.309),l(-.516,-.479),l(-.834,-.507),l(-1.143,-.986),l(-.416,-.451),l(-.162,-.269),l(.216,-.989),l(-.035,-.254),l(-.488,-1.002),l(-.238,-.381),l(-.327,-.282),l(-.44,-.098),l(-.5,-.31),l(-.675,-.677),l(-.305,.142),l(-.363,-.056),l(-1.262,-.746),l(-.722,-.31),l(-.896,-.973),l(-.139,-.127),l(-.246,-.254),l(.679,.15),l(.599,.013),l(.588,-.284),l(.244,-.326),l(.093,-.636),l(-.01,-.184),l(-.458,-.635),l(-.466,-.452),l(-1.1,-.888),l(-.986,-.493),l(-.402,-.338),l(-.203,-.522),l(-.272,-.649),l(-.091,-.155),l(-.447,-.126),l(-.15,-.353),l(-.026,-.594),l(-.203,-.395),l(-.623,-.734),l(-.434,-.706),l(-.003,-.254),l(.212,-.382),l(-.777,-.62),l(-.254,-.325),l(-.22,-.485),l(.34,-.017),l(2.367,-.155),l(2.381,-.084),l(.316,.31),l(.267,.154),l(1.186,.39),l(2.811,.933),l(3.516,1.112),l(.338,.055),l(1.662,.019),l(1.544,.02),l(.966,.037),l(1.867,-.011),l(.213,-.101),l(.096,-.892),l(1.858,.003),l(1.892,.046),l(.209,.112),l(.631,.662),l(.766,.632),l(.837,.519),l(.708,.491),l(.179,.226),l(.284,.678),l(.318,.847),l(.445,.549),l(1.092,.659),l(1.104,.503),l(.337,.069),l(.501,.011),l(.416,-.158),l(.283,-.37),l(.418,-.413),l(.576,-.541),l(.468,-.201),l(.643,-.018),l(.475,.082),l(.783,.321),l(.412,.252),l(.363,.366),l(.663,1.029),l(.744,1.227),l(.845,1.042),l(.657,.576),l(.268,.253),l(.078,.467),l(.332,.932),l(.336,.592),l(.375,.365),l(.921,.32),l(1.029,.56),l(.264,.069),l(.416,-.116),l(.296,-.001),l(.816,.377),l(.347,.119),
N(507.047,133.665),l(.055,.197),l(.134,.691),l(-.336,-.028),l(-.513,.513),l(.421,.194),l(.418,-.206),l(.306,.021),l(.698,1.84),l(-.644,.044),l(-1.07,-.05),l(-.185,-.239),l(-.334,-.619),l(-.408,-.054),l(-1.657,-.259),l(.521,-.568),l(.463,-.609),l(.343,-.693),l(.518,-.13),l(1.271,-.044),
N(606.155,150.953),l(.595,.152),l(.255,.14),l(.25,-.129),l(.273,-.368),l(.015,-.678),l(-.152,-.93),l(.228,-.185),l(.401,-.144),l(.191,-.354),l(-.146,-1.594),l(.133,-.283),l(.811,.32),l(.391,.11),l(.309,.013),l(.17,-.128),l(1.148,-2.25),l(0,-.324),l(-.192,-.408),l(.045,-.212),l(.938,-1.134),l(.136,-.382),l(-.057,-.761),l(.197,-.354),l(1.446,-.883),l(.719,-.512),l(.312,-.129),l(.558,.082),l(.853,.221),l(.295,-.058),l(-.184,-.718),l(.072,-.283),l(.596,-.582),l(.112,-.24),l(.018,-.508),l(.001,-.127),l(.306,-.34),l(.277,-.044),l(.504,.279),l(.397,.435),l(.243,.901),l(.217,.309),l(.287,.041),l(.504,-.031),l(.146,.14),l(.195,1.649),l(.02,.875),l(-.353,.862),l(-.429,.722),l(-.611,.525),l(-.487,.271),l(-.191,.198),l(-.617,.85),l(.075,.465),l(.163,.705),l(-.224,.58),l(0,.268),l(.216,.069),l(.312,-.086),l(.819,-.442),l(.771,-.089),l(.479,-.017),l(.156,.126),l(.277,1.762),l(.202,.324),l(.554,-.074),l(.521,.096),l(.033,.268),l(-.729,1.584),l(.117,.352),l(.228,.098),l(.507,-.003),l(.481,-.045),l(.291,.379),l(.341,.746),l(.378,.266),l(.246,.083),l(.647,-.159),l(.628,-.413),l(.111,.38),l(.153,.239),l(-.502,.355),l(-.53,.61),l(-.442,.581),l(-.582,.455),l(-.193,.185),l(-.08,.085),l(-.158,.071),l(-.645,.06),l(-.436,.172),l(-.528,.342),l(-.394,.595),l(-1.078,.316),l(-.62,.018),l(-.474,-.082),l(-.362,.411),l(-.143,.368),l(-.036,.819),l(-.114,.509),l(.064,.409),l(-.086,.24),l(-.163,.001),l(-.588,.131),l(.739,.884),l(.069,.183),l(.112,.875),l(.254,.14),l(1.091,.953),l(.148,.324),l(.646,1.041),l(.163,.338),l(-.194,.241),l(-.451,.229),l(-.128,.226),l(.231,1.185),l(-.171,.198),l(-.812,.428),l(.178,.38),l(.6,1.436),l(.54,.477),l(.606,.604),l(.203,.479),l(.088,.663),l(-.086,.636),l(.006,.254),l(.488,1.183),l(.586,1.225),l(-.077,.297),l(-1.011,1.559),l(-1.01,1.7),l(-.098,.374),l(-.359,-.181),l(-.075,-.805),l(.461,-.665),l(.174,-.495),l(.122,-.777),l(.287,-.466),l(-.512,-.027),l(-.104,-.084),l(-.004,-.282),l(.195,-.509),l(-.177,-1.524),l(-.246,-.832),l(-.639,-1.185),l(-.488,-1.312),l(-.347,-.846),l(-.179,-.875),l(-.174,-1.736),l(-.117,-.677),l(-.034,-.564),l(-.051,-.212),l(-.344,-.084),l(-.148,-.098),l(-.304,-.917),l(-.516,-.677),l(-.226,-.225),l(-.247,.029),l(-.081,.988),l(-.158,.424),l(-.43,.41),l(-.59,.284),l(-1.089,.511),l(-.359,.622),l(-.298,.297),l(-.196,.142),l(-.237,-.282),l(-.007,-.438),l(-.212,.015),l(-.338,.354),l(-.321,-.013),l(-.166,-.211),l(.147,-.495),l(-.001,-.113),l(-.621,.171),l(-.276,.127),l(-.247,.283),l(-.355,-.126),l(-.002,-.466),l(.553,-1.54),l(.162,-.791),l(.001,-.889),l(-.101,-1.059),l(-.384,-.973),l(-.431,-1.072),l(-.196,-.296),l(-.281,.537),l(-.32,-.126),l(-.526,-.366),l(.482,-.17),l(.312,-.015),l(-.149,-.479),l(-.054,-.268),l(-.684,-.775),l(-.182,-.183),l(-.19,-.028),l(-.407,.1),l(-.38,-.267),l(.086,-.438),l(-.026,-.141),l(-.209,-.112),l(-.365,.043),l(-.577,-.465),l(-.504,-.606),l(-.117,-.244),l(.252,-.341),l(.801,-.527),l(-.194,-1.607),
N(605.297,153.429),l(-.126,-.264),l(-.269,-.55),l(-.223,-1.213),l(-.611,-1.41),l(-.357,-.395),l(-.73,.354),l(-.393,0),l(-.034,-.084),l(-.242,-.211),l(-.356,-.592),l(-.124,-.042),l(-.152,.127),l(-.026,.537),l(.374,.79),l(-.006,.424),l(-.143,.169),l(-.455,.086),l(-.235,.537),l(-.261,.1),l(-.255,-.437),l(-.311,-.395),l(-.073,-.057),l(-.163,.669),l(-.28,.249),l(-.203,.043),l(-.271,-.536),l(-.495,.636),l(-.359,-.265),l(-.147,-.532),l(-.402,-1.775),l(-.325,-1.409),l(-.352,-.45),l(-.04,-.254),l(.505,-.765),l(.029,-.269),l(-.193,-.21),l(-1.042,-.431),l(-.339,-.323),l(.548,-.61),l(.4,-.299),l(.502,-.13),l(.382,-.101),l(.047,-.155),l(-.126,-.112),l(-1.224,-.938),l(-.494,-.237),l(-.083,-.155),l(.124,-.283),l(.555,-.525),l(.234,-.171),l(1.252,.303),l(.339,.266),l(.372,.266),l(.489,-.06),l(.417,.054),l(.129,.324),l(.053,.479),l(.079,.719),l(.095,.099),l(.537,.109),l(.547,.053),l(.916,-.062),l(.559,-.003),l(2.473,.198),l(.111,.098),l(.057,.127),l(-.012,.79),l(-.159,.34),l(-.938,.767),l(-.498,.13),l(-.651,.356),l(-.131,.283),l(.009,.522),l(.001,.381),l(.23,.281),l(.249,.267),l(.529,.448),l(.224,-.354),l(.395,-1.159),l(.281,-.115),l(.4,-.044),l(.064,.578),l(.627,2.479),l(.037,.466),l(.194,1.607),l(-.801,.527),l(-.252,.341),
N(627.408,186.411),l(-.086,.337),l(-.495,.35),l(-.11,.575),l(-.644,.089),l(-.05,-.478),l(-.309,-.163),l(-.279,.28),l(-.244,.394),l(-.204,-.083),l(-.118,-.239),l(.213,-.398),l(-.041,-.21),l(-.055,-.226),l(-.261,-.238),l(-.447,-.119),l(-.106,-.466),l(-.571,.013),l(-.448,.17),l(.013,-.104),l(.128,-.297),l(-.15,-.183),l(-.411,.212),l(-.301,-.07),l(-.38,-.38),l(-.116,-.508),l(.064,-.282),l(-.151,-.438),l(-.229,-.169),l(-.388,.043),l(-.39,-.719),l(-.209,-.508),l(-.3,-.324),l(-.311,-.155),l(-.456,-.395),l(-.343,.1),l(-.218,.142),l(-.216,-.381),l(-.04,-.607),l(.163,-.749),l(.559,-1.738),l(.29,-.848),l(-.087,-.044),l(.098,-.374),l(1.01,-1.7),l(1.011,-1.559),l(.077,-.297),l(-.586,-1.225),l(-.488,-1.183),l(-.006,-.254),l(.086,-.636),l(-.088,-.663),l(-.203,-.479),l(-.606,-.604),l(-.54,-.477),l(-.6,-1.436),l(-.178,-.38),l(.812,-.428),l(.171,-.198),l(-.231,-1.185),l(.128,-.226),l(.451,-.229),l(.194,-.241),l(-.163,-.338),l(-.646,-1.041),l(-.148,-.324),l(-1.091,-.953),l(-.254,-.14),l(-.112,-.875),l(-.069,-.183),l(-.739,-.884),l(.588,-.131),l(.163,-.001),l(.086,-.24),l(-.064,-.409),l(.114,-.509),l(.036,-.819),l(.143,-.368),l(.362,-.411),l(.474,.082),l(.62,-.018),l(1.078,-.316),l(.394,-.595),l(.528,-.342),l(.436,-.172),l(.645,-.06),l(.158,-.071),l(.08,-.085),l(.541,.166),l(.295,.182),l(.118,.168),l(.01,.423),l(-.106,.805),l(.066,.367),l(.186,.154),l(.423,-.003),l(.489,-.2),l(.414,-.045),l(.045,.113),l(.249,1.311),l(-.085,.41),l(-.528,1.569),l(-.117,.438),l(-.027,.494),l(.145,.324),l(.481,.138),l(.37,-.411),l(1.173,-1.178),l(.346,-.03),l(.835,.348),l(.59,.265),l(.223,-.072),l(.543,-.257),l(.2,-.538),l(.286,-.453),l(.403,.012),l(.893,.192),l(.266,.153),l(.052,.282),l(.285,.535),l(.688,.659),l(.435,.632),l(.058,1.524),l(.107,.366),l(.255,.464),l(.979,1.279),l(.419,.703),l(.157,.507),l(.002,.945),l(-.121,.438),l(-.808,.64),l(-.301,-.167),l(-.599,-.109),l(-.575,-.039),l(-.558,.074),l(-.798,-.066),l(-1.172,.091),l(-.383,.101),l(-.521,.441),l(-.92,1.233),l(-.146,.297),l(-.076,.382),l(.026,.635),l(.219,.648),l(.487,.717),l(.16,.479),l(-.146,.176),l(-.026,-.063),l(-.286,-.183),l(-.458,-.084),l(-.9,-.887),l(-.434,-.154),l(-.304,-.014),l(-.572,.227),l(-.391,-.112),l(-.29,-.141),l(-.337,-.014),l(0,-.282),l(.19,-1.243),l(-.107,-.184),l(-.719,-.055),l(-.248,-.084),l(-.521,.043),l(-.443,.212),l(-.244,.297),l(.207,.593),l(-.103,.339),l(-.318,.707),l(.083,.579),l(.054,.41),l(-.293,.664),l(-.583,1.187),l(-.7,1.682),l(-.255,1.314),l(.104,1.171),l(.172,.296),l(.229,.169),l(.55,-.072),l(.396,-.142),l(.252,.07),l(.135,.353),l(.009,.325),l(-.08,.466),l(.141,.282),l(.178,.211),l(.271,-.094),l(.17,.46),l(.209,.974),l(-.032,.254),l(.127,.737),l(.434,.871),l(.167,.155),l(.801,.281),l(.539,.112),l(.467,-.058),l(.294,.197),l(.266,.612),l(.664,.544),l(.212,.145),
N(204.31,158.989),l(-.175,.412),l(.612,-.173),l(.026,.429),l(-.419,1.241),l(.178,.269),l(-.237,.795),l(.189,.318),l(-.092,.397),l(-.358,.875),l(-.3,.35),l(-.36,.032),l(-.054,.286),l(-.388,.238),l(0,.286),l(-.69,.016),l(.215,-4.297),l(-.025,-.329),l(.278,-.095),l(.386,.27),l(.599,-.857),l(.178,-.447),l(.437,-.016),
N(200.276,169.481),l(-.151,-.056),l(-.928,-.342),l(-.614,.032),l(-.766,-.032),l(-.608,-.239),l(-.909,-.656),l(-.513,-.419),l(-.044,-.454),l(-.054,-.553),l(.207,-.238),l(-.305,-.397),l(1.076,-1.812),l(1.06,-.007),l(1.762,.007),l(.211,-.683),l(-.532,-.223),l(-.359,-.69),l(-.624,-.231),l(-.495,-.541),l(-.396,-.223),l(.999,-.032),l(.04,-1.24),l(1.792,.005),l(2.332,.006),l(-.215,4.297),l(.69,-.016),l(.303,.095),l(.311,.302),l(.14,-.191),l(-.066,-.381),l(.336,.157),l(.458,.367),l(-1.507,1.208),l(-.499,.238),l(-.177,.493),l(.162,.604),l(-.438,.302),l(-.467,.048),l(-.043,.254),l(.164,.159),l(-.351,.111),l(-.184,.302),l(-.22,-.016),l(-.565,.461),l(-.012,.223),
N(204.413,165.093),l(.312,-.03),l(.612,-.27),l(.639,-.058),l(.743,.126),l(.478,.069),l(1.443,.04),l(.699,-.228),l(.379,-.199),l(.567,.267),l(.788,-.03),l(.763,-.101),l(.63,-.001),l(.5,.126),l(.564,.253),l(-.038,.353),l(-.102,.226),l(.228,.282),l(.787,.238),l(.557,.069),l(.244,.524),l(-1.425,.486),l(-.424,.229),l(-.248,.086),l(-.463,-.097),l(-.328,-.182),l(-.259,-.013),l(-.294,.242),l(-.503,.794),l(-1.207,.997),l(-.725,-.42),l(-.513,.583),l(-.882,.034),l(-.005,.961),l(-.293,.412),l(-.29,.143),l(-1.001,.125),l(-.311,-.661),l(-.025,-.085),l(-.478,-.3),l(.085,-.731),l(-.128,-.175),l(-.272,0),l(-.541,-.276),l(-.433,.34),l(-.365,-.016),l(-.066,-.271),l(-.565,-.35),l(-.409,-.08),l(-.208,-.418),l(-.677,-.17),l(.438,-.302),l(-.162,-.604),l(.177,-.493),l(.499,-.238),l(1.507,-1.208),
N(205.532,170.085),l(.035,.076),l(-.203,.057),l(.01,.265),l(-.237,.334),l(-.68,-.046),l(-.853,-.139),l(-1.697,-.505),l(-1.305,-.435),l(-.325,-.21),l(.012,-.223),l(.565,-.461),l(.22,.016),l(.184,-.302),l(.351,-.111),l(-.164,-.159),l(.043,-.254),l(.467,-.048),l(.677,.17),l(.208,.418),l(.409,.08),l(.565,.35),l(.066,.271),l(.365,.016),l(.433,-.34),l(.541,.276),l(.272,0),l(.128,.175),l(-.085,.731),
N(242.38,173.617),l(-.128,-.105),l(-.84,.171),l(-.534,.156),l(-.414,.2),l(-.056,.288),l(.048,.497),l(-.129,.396),l(-.227,-.027),l(-.381,.059),l(-.99,1.758),l(-.172,.722),l(-.241,.722),l(-.709,1.191),l(.402,.025),l(.234,-.1),l(.384,-.017),l(.31,.606),l(.855,1.45),l(.103,.395),l(-.226,1.132),l(.099,.353),l(.401,.309),l(.429,.548),l(.397,.252),l(.496,-.017),l(1.163,-.12),l(1.167,-.05),l(.521,.181),l(.64,.321),l(.188,.253),l(.847,.998),l(.554,.576),l(.144,0),l(.522,-.13),l(.76,-.174),l(1.99,-.224),l(.644,.081),l(-.409,.525),l(-.085,1.004),l(-.379,.511),l(-.147,.326),l(.026,.254),l(.035,.438),l(.048,.367),l(.162,.804),l(.447,.789),l(.256,.437),l(.486,.647),l(.121,.282),l(-.731,.612),l(-.479,.526),l(.51,.491),l(.797,1.182),l(-.52,.286),l(-.834,.57),l(-.412,.158),l(-.463,.017),l(-2.812,-.082),l(-.64,-.024),l(-.042,.325),l(-.013,1.031),l(.178,.154),l(.896,.122),l(.177,.084),l(.293,.408),l(.052,.367),l(-.384,-.04),l(-.417,-.11),l(-.687,.032),l(-.493,.187),l(-.111,.085),l(-.001,1.071),l(0,.554),l(.192,.197),l(.688,.363),l(.192,.183),l(-.031,.777),l(.399,.562),l(.031,.212),l(-.326,1.428),l(-.706,4.411),l(-.073,.382),l(-.133,.198),l(-.156,-.14),l(-.575,-.703),l(-.237,-.126),l(-.161,.058),l(-.448,.031),l(1.155,-1.956),l(.035,-.198),l(-.127,-.069),l(-1.299,-.84),l(-.509,-.209),l(-.708,.442),l(-.397,-.182),l(-.523,-.421),l(-.452,.427),l(-.337,.157),l(-.496,.031),l(-1.038,-.008),l(-.573,-.152),l(-.092,-.281),l(.004,-.396),l(-.173,-.296),l(-.479,-.039),l(-.366,-.14),l(-.078,-.282),l(-.251,-.761),l(-.988,-.672),l(-.526,-.364),l(-.208,-.62),l(-.208,-.324),l(-.513,-.435),l(-.897,-.418),l(-.927,-.107),l(-.081,-.112),l(-.269,-.162),l(-.197,-.118),l(-.709,-.631),l(-.128,-.056),l(-.89,.401),l(-.67,.061),l(-.977,-.277),l(-.355,-.309),l(-.166,-.493),l(-.227,-.225),l(-1.432,-.656),l(-1.496,-.803),l(.033,-.068),l(-.117,-.311),l(-.181,-.282),l(.108,-.212),l(.509,-.114),l(.465,.112),l(.186,-.325),l(-.348,-.564),l(.086,-.424),l(.314,-.227),l(.878,-.058),l(.193,.042),l(.41,-.227),l(.445,-.679),l(.45,-.961),l(.651,-1.061),l(-.122,-.268),l(-.56,-.408),l(-.071,-.184),l(.306,-.721),l(.089,-.523),l(-.149,-.861),l(-.371,-.86),l(.085,-.254),l(.49,-.143),l(.135,-.212),l(-.088,-.198),l(-.565,-.479),l(-.042,-.226),l(.103,-.198),l(.242,-.326),l(.036,-.254),l(-.173,-.282),l(-.739,-.719),l(-.364,-.396),l(.256,-.753),l(.228,-.082),l(-.045,-.45),l(.19,.082),l(.085,.307),l(.584,-.409),l(.094,-.43),l(.322,-.062),l(-.509,-1.038),l(-.228,-.149),l(-.084,-.327),l(.142,.075),l(.42,.338),l(.397,.507),l(.22,.508),l(.235,.197),l(.199,-.17),l(.147,-.241),l(-.332,-.776),l(.02,-.212),l(.176,-.297),l(.445,-.34),l(.399,-.297),l(.501,-.736),l(.327,-.156),l(.684,-.101),l(.217,-.382),l(-.104,-.381),l(.174,-.777),l(.067,-.65),l(.207,-.48),l(.498,-.439),l(.429,-.283),l(.592,-.242),l(.113,0),l(.374,.206),l(.22,.443),l(.281,-.34),l(.031,-.438),l(.199,-.551),l(.22,-.071),l(.267,.126),l(.855,.041),l(.562,-.001),l(.623,-.27),l(.237,-.254),l(.476,-.298),l(.848,-.256),l(.435,-.396),l(.278,-.551),l(.333,-.255),l(.469,-.17),l(.58,.013),l(.526,.338),l(.155,.126),l(.155,.339),l(-.285,.332),
N(408.6,174.04),l(-.062,.777),l(.164,.762),l(.388,.718),l(-.316,.962),l(-.19,.566),l(-.223,.298),l(-.656,.414),l(-.095,.34),l(.116,.592),l(-.078,.368),l(-.433,.13),l(-.257,.03),l(-.237,.397),l(.002,.381),l(.003,.48),l(-.012,.876),l(-.09,.989),l(.217,1.439),l(-.121,1.188),l(.006,.234),l(-.333,.015),l(-1.232,.144),l(-.669,.052),l(-.106,-.205),l(-.295,-1.072),l(.188,-.708),l(.026,-.833),l(-.036,-.537),l(-.135,-.974),l(-.006,-.862),l(-.035,-.522),l(.013,-.579),l(-.442,-1.311),l(-.164,-.691),l(-.403,-.323),l(-.468,-.294),l(-.18,-.395),l(.141,-.594),l(.046,-.424),l(.062,-.142),l(.24,-.157),l(.366,-.553),l(.415,-.271),l(.418,-.045),l(.739,.095),l(.337,-.158),l(.415,-.468),l(.237,-.764),l(-.131,-.367),l(.577,-.3),l(.321,-.073),l(.339,.28),l(.727,.589),l(.902,.503),
N(394.266,178.814),l(.191,-.17),l(-.02,-.41),l(-.261,-1.934),l(.125,-.34),l(.271,-.157),l(2.119,-.041),l(.867,.037),l(1.429,.006),l(.976,-.458),l(.161,.032),l(.595,.119),l(-.25,.849),l(.05,.254),l(.633,.915),l(.244,.451),l(-.188,.721),l(.02,.396),l(.265,1.114),l(.181,.592),l(.503,.788),l(.032,.155),l(-.286,.242),l(-.174,.382),l(.01,1.314),l(-.011,.72),l(.021,.551),l(.18,.479),l(.468,.577),l(.752,.608),l(-.503,.682),l(-.304,.099),l(-.593,-.013),l(-.992,.144),l(-.463,.185),l(-.188,.098),l(-.898,.469),l(-1.263,.398),l(-.942,.412),l(-.958,.567),l(-.578,-.324),l(-.945,-.436),l(-.074,-.124),l(-.066,-.741),l(-.554,-1.155),l(-.263,-.747),l(-.103,-.706),l(.327,-1.005),l(.437,-1.274),l(.521,-.851),l(.203,-.595),l(-.334,-1.438),l(-.189,-1.285),l(-.178,-.154),
N(400.72,175.499),l(1.013,.163),l(.611,.166),l(.29,.041),l(-.046,.424),l(-.141,.594),l(.18,.395),l(.468,.294),l(.403,.323),l(.164,.691),l(.442,1.311),l(-.013,.579),l(.035,.522),l(.006,.862),l(.135,.974),l(.036,.537),l(-.026,.833),l(-.188,.708),l(.295,1.072),l(.106,.205),l(-.452,.035),l(-.479,.128),l(-.368,.212),l(-.023,.04),l(-.752,-.608),l(-.468,-.577),l(-.18,-.479),l(-.021,-.551),l(.011,-.72),l(-.01,-1.314),l(.174,-.382),l(.286,-.242),l(-.032,-.155),l(-.503,-.788),l(-.181,-.592),l(-.265,-1.114),l(-.02,-.396),l(.188,-.721),l(-.244,-.451),l(-.633,-.915),l(-.05,-.254),l(.25,-.849),
N(383.772,190.418),l(.041,-.919),l(.105,-.565),l(.247,-.849),l(.059,-.452),l(-.131,-.282),l(-1.264,-1.334),l(-.592,.032),l(-.369,-.097),l(-.194,-.183),l(-.05,-.183),l(.501,-.865),l(.059,-.438),l(-.119,-.55),l(.062,-.17),l(.047,-.099),l(.602,-.554),l(.188,-.354),l(-.179,-.21),l(-.296,-.549),l(.03,-.127),l(.158,-.199),l(.304,-.03),l(.548,.223),l(.304,.012),l(.19,-.143),l(-.051,-.226),l(-.648,-.561),l(-.309,-.351),l(.332,-.37),l(.125,-.283),l(-.197,-.31),l(-.695,-.405),l(-.214,-.409),l(.264,-.623),l(.379,-.397),l(.522,-.54),l(.352,-.059),l(.566,.321),l(.455,.436),l(.35,-.228),l(.362,-.469),l(.571,-.483),l(.239,-.114),l(.257,.041),l(.147,.211),l(.004,.297),l(.117,.381),l(.148,.239),l(.352,-.059),l(.604,-.399),l(.159,-.1),l(.259,.168),l(.545,-.003),l(.308,.252),l(.15,.465),l(.52,.562),l(.452,.223),l(.354,.083),l(.368,-.115),l(.446,-.257),l(.608,-.159),l(.769,-.075),l(.644,.166),l(.63,.434),l(.178,.154),l(.189,1.285),l(.334,1.438),l(-.203,.595),l(-.521,.851),l(-.437,1.274),l(-.327,1.005),l(.103,.706),l(.263,.747),l(.554,1.155),l(.066,.741),l(-.119,-.201),l(-.289,-.197),l(-.208,.015),l(-.143,.24),l(-.096,.042),l(-.48,-.027),l(-.705,-.167),l(-.608,-.083),l(-2.352,.062),l(-1.279,.243),l(-.575,.199),l(-1.07,.369),l(-1.739,.781),l(-.701,.425),l(-.256,-.013),l(-.075,-.032),
N(627.408,186.411),l(.035,.024),l(.523,.098),l(1.061,1.198),l(.693,.916),l(.506,.762),l(.081,.579),l(-.023,.805),l(-.134,.862),l(.07,1.073),l(-.07,.636),l(.097,.494),l(.196,.381),l(.53,.493),l(.338,.536),l(.705,1.608),l(.062,.127),l(-.366,-.069),l(-.895,-.055),l(-.401,.142),l(-.175,-.07),l(-.521,-.437),l(-.885,-.605),l(-.6,-.337),l(-1.231,-.675),l(-1.02,-.732),l(-.217,-.254),l(-.16,-.988),l(-.438,-.691),l(-.895,-.817),l(-.195,-.663),l(.039,-.494),l(.03,-.283),l(-.107,-.409),l(-.399,-.634),l(-.347,-1.849),l(-.188,-.72),l(.043,-.362),l(.448,-.17),l(.571,-.013),l(.106,.466),l(.447,.119),l(.261,.238),l(.055,.226),l(.041,.21),l(-.213,.398),l(.118,.239),l(.204,.083),l(.244,-.394),l(.279,-.28),l(.309,.163),l(.05,.478),l(.644,-.089),l(.11,-.575),l(.495,-.35),l(.086,-.337),M(643.95,196.042),l(.081,.044),l(.375,.408),l(.397,.141),l(.861,.083),l(.413,.168),l(.761,.436),l(.335,.042),l(.337,-.1),l(-.503,-.535),l(.169,-.551),l(.365,-.608),l(.528,-1.258),l(.584,-.27),l(1.481,-.342),l(1.018,-.299),l(.428,-.326),l(.524,-1.021),l(.523,-.323),l(.87,-1.117),l(.22,-.212),l(.244,-.147),l(.112,-.068),l(.084,.126),l(.062,.37),l(.234,-.012),l(.111,.259),l(.309,.271),l(.383,-.271),l(1.234,-.42),l(-.025,-.086),l(-.197,-.197),l(.013,-.247),l(.024,-.111),l(-.148,-.444),l(-.11,-.174),l(.167,-.042),l(.188,.143),l(.085,-.016),l(.449,-.084),l(.161,-.283),l(-.036,-.24),l(-.478,-.366),l(.197,-.396),l(.436,-.071),l(.511,.041),l(.154,-.605),l(.408,-.313),l(.284,-.48),l(.531,-.58),l(.498,-1.032),l(.075,-.17),l(.322,.465),l(.33,.098),l(.315,-.424),l(.305,.494),l(.351,.282),l(.402,.211),l(.075,.338),l(-.182,.354),l(-.234,.452),l(.037,.198),l(.631,-.128),l(.472,-.128),l(.115,.226),l(-.349,.495),l(.742,-.1),l(.357,-.085),l(.269,.056),l(1.035,.662),l(.345,.14),l(.1,.24),l(-.158,.269),l(-.201,.155),l(-.44,.143),l(-.594,.029),l(-.683,-.083),l(-.355,.311),l(.096,.254),l(.888,.69),l(-.161,.311),l(-.458,.199),l(-.646,.1),l(-.518,.114),l(-.067,.15),l(-.182,-.09),l(-.753,-.292),l(-.446,-.04),l(-.624,.018),l(-.651,-.081),l(-.748,-.081),l(-.464,.017),l(-.247,.157),l(-.381,.638),l(-.119,.565),l(.106,.988),l(-.22,.383),l(-.646,.244),l(-.218,.34),l(.076,.748),l(-.928,1.785),l(-.387,.299),l(-.864,.175),l(-.465,.172),l(-.467,.356),l(-.287,.03),l(-.559,-.152),l(-.524,-.223),l(-.557,-.251),l(-.431,-.11),l(-.479,.074),l(-.531,.441),l(-.403,.525),l(-.528,.342),l(-.399,.172),l(-.543,-.11),l(-.526,-.223),l(-.255,.001),l(-.928,.416),l(-.446,-.28),l(-.304,-.083),l(-1,-.983),l(-.253,-.295),l(-.288,-.792),
N(274.556,195.884),l(.06,-.212),l(-.332,-.563),l(-.49,-1.127),l(-.246,-.832),l(-.185,-.295),l(-.561,-.067),l(-.532,-.675),l(-.571,-.831),l(.328,-.694),l(.095,-.467),l(-.078,-.777),l(.169,-.17),l(1.131,-.091),l(.183,-.27),l(.082,-.862),l(.142,-.496),l(.015,-.339),l(.326,-.312),l(.382,-.057),l(1.392,.463),l(.465,.042),l(.083,-.41),l(.141,-.085),l(.337,.027),l(.833,.012),l(.863,-.03),l(.723,.069),l(.63,.182),l(.999,.427),l(-.647,.876),l(-.391,.751),l(-.137,.594),l(.094,.381),l(.134,.635),l(.086,.664),l(.521,.844),l(.029,.438),l(-.424,1.472),l(-.489,.963),l(-1.05,-.488),l(-.319,.001),l(-.534,.385),l(-.398,.059),l(-.418,-.139),l(-.642,-.124),l(-.172,.156),l(-.2,.326),l(.611,1.014),l(-.528,-.054),l(-1.108,-.276),l(-.4,-.04),
N(285.859,190.719),l(.015,.422),l(-1.102,1.646),l(-.427,.765),l(-.439,.992),l(-.464,.681),l(-.299,.214),l(-.56,-.025),l(-1.11,-.389),l(-.882,.613),l(-.225,-.069),l(-.649,-.505),l(.489,-.963),l(.424,-1.472),l(-.029,-.438),l(-.521,-.844),l(-.086,-.664),l(-.134,-.635),l(-.094,-.381),l(.137,-.594),l(.391,-.751),l(.647,-.876),l(.218,.093),l(1.033,.294),l(.55,.196),l(.799,.549),l(1.264,1.084),l(.545,.564),l(.317,.465),l(.193,.028),
N(429.505,210.684),l(-.695,-.533),l(-.351,.13),l(-.68,.513),l(-.536,.414),l(-.112,-.177),l(-.392,-.86),l(-1.381,-1.344),l(.184,-.295),l(.413,-.229),l(.803,.307),l(.343,-.681),l(-.052,-.296),l(-.274,-.253),l(-.39,-.521),l(-.116,-.366),l(.058,-.495),l(.127,-.1),l(.909,-.146),l(.604,-.243),l(.125,-.213),l(.167,-.807),l(.174,-.185),l(.239,-.029),l(.193,.14),l(.341,.479),l(.405,.521),l(.386,.195),l(.287,-.016),l(.188,-.228),l(.362,-.482),l(.29,.253),l(.167,.578),l(.146,.112),l(.304,.068),l(.255,-.114),l(.184,-.68),l(.243,-1.089),l(.131,-1.229),l(.229,-1.047),l(-.114,-.338),l(-.161,-.127),l(-.384,-.082),l(-.528,-.208),l(-.242,-.31),l(-.132,-.437),l(.008,-.109),l(.021,-.3),l(.157,-.284),l(.492,-.398),l(.556,-.441),l(.094,-.354),l(-.389,-.902),l(-.369,-.322),l(-.592,-.067),l(-.939,.5),l(-.463,-.025),l(-.146,-.253),l(-.068,-.734),l(.077,-.679),l(.396,-.468),l(.56,.109),l(.863,.023),l(.878,-.076),l(.271,.055),l(.479,.04),l(.56,.124),l(.576,.194),l(.864,.334),l(.863,.292),l(.271,-.086),l(-.1,-.861),l(.159,-.185),l(.303,-.312),l(.365,-.497),l(.158,-.523),l(.222,-1.287),l(.255,-.228),l(.479,-.102),l(.975,-.175),l(.367,.054),l(.624,.138),l(.895,.093),l(.751,-.287),l(.128,.197),l(-.031,.156),l(-.398,1.203),l(-.558,.837),l(-.349,.821),l(-.094,.551),l(-.156,.764),l(-.196,2.021),l(-.254,1.342),l(-.115,.61),l(-.169,.708),l(-.139,.523),l(-.459,.427),l(-.525,.229),l(-.809,.599),l(-.41,.454),l(-.47,.836),l(-.343,.751),l(-.193,1.159),l(-.074,.396),l(.122,.72),l(-.086,.706),l(-1.025,.938),l(-.364,.229),l(-.931,.811),l(-.554,.399),l(-.57,.328),l(-.147,-.211),l(-.042,-.664),l(-.054,-.424),l(-1.495,.532),l(-.327,.581),l(-.443,.271),l(-.177,-.013),l(-.484,-.336),
N(425.506,195.522),l(.045,-.495),l(.88,.093),l(1.773,.088),l(.831,.038),l(1.022,.149),l(-.396,.468),l(-.077,.679),l(.068,.734),l(.146,.253),l(.463,.025),l(.939,-.5),l(.592,.067),l(.369,.322),l(.389,.902),l(-.094,.354),l(-.556,.441),l(-.492,.398),l(-.157,.284),l(-.021,.3),l(-.008,.109),l(.132,.437),l(.242,.31),l(.528,.208),l(.384,.082),l(.161,.127),l(.114,.338),l(-.229,1.047),l(-.131,1.229),l(-.243,1.089),l(-.184,.68),l(-.255,.114),l(-.304,-.068),l(-.146,-.112),l(-.167,-.578),l(-.29,-.253),l(-.362,.482),l(-.188,.228),l(-.287,.016),l(-.386,-.195),l(-.405,-.521),l(-.341,-.479),l(-.193,-.14),l(-.239,.029),l(-.174,.185),l(-.167,.807),l(-.125,.213),l(-.604,.243),l(-.909,.146),l(-.127,.1),l(-.058,.495),l(.116,.366),l(.39,.521),l(.274,.253),l(.052,.296),l(-.343,.681),l(-.803,-.307),l(-.413,.229),l(-.184,.295),l(-.038,-.037),l(-.563,-.493),l(-.532,-.55),l(-.259,-.466),l(-1.318,-1.169),l(.286,-.312),l(-.369,-.281),l(-.528,-.056),l(-.918,-1.438),l(.382,-.297),l(.111,-.1),l(-.321,-.395),l(-.464,-.14),l(-.29,-.564),l(-.369,-.451),l(.319,-.17),l(.541,-.411),l(.223,-.396),l(.291,-.976),l(.089,-.295),l(.415,.07),l(.495,.013),l(-.064,-.211),l(-.56,-.352),l(-.561,-.451),l(.208,-.042),l(.271,-.128),l(.142,-.617),l(.83,-.043),l(.927,.008),l(1.245,.021),l(.575,-.032),l(-.001,-.155),l(-.02,-.551),l(-.026,-1.836),
N(422.536,195.513),l(1.005,-.007),l(1.965,.017),l(.026,1.836),l(.02,.551),l(.001,.155),l(-.575,.032),l(-1.245,-.021),l(-.927,-.008),l(-.83,.043),l(.033,-.146),l(-.049,-.297),l(-.144,-.084),l(-.416,-.098),l(.287,-.467),l(.447,-.523),l(.335,-.58),l(.066,-.403),M(419.636,193.273),l(-.484,-.049),l(-.049,-.218),l(.049,-.291),l(.242,-.097),l(.024,-.146),l(0,-.291),l(.17,-.097),l(.169,-.121),l(.219,.048),l(.218,.048),l(.097,.194),l(-.193,.169),l(-.146,.243),l(-.17,.339),l(-.146,.267),
N(222.291,207.801),l(.188,-.126),l(.264,-.312),l(.585,-1.061),l(.038,-.269),l(-.209,-.733),l(.058,-.391),l(-.478,.617),l(-.732,.623),l(-.333,-.098),l(-.601,-.324),l(-.408,-.408),l(.389,-.283),l(.1,-.24),l(-.167,-.579),l(.005,-.438),l(.133,-.466),l(-.109,-.282),l(-.362,-.649),l(.193,-.17),l(.48,-.198),l(.721,-.454),l(-.319,-.395),l(0,-.226),l(.175,-.354),l(.497,-.462),l(.157,-.146),l(.14,-.848),l(-.116,-.452),l(-.082,-.184),l(.11,-.226),l(.686,-.101),l(.891,-.341),l(.396,-.241),l(.474,-.382),l(.09,-.186),l(1.496,.803),l(1.432,.656),l(.227,.225),l(.166,.493),l(.355,.309),l(.977,.277),l(.67,-.061),l(.89,-.401),l(.128,.056),l(.709,.631),l(.197,.118),l(.269,.162),l(.081,.112),l(.387,.76),l(.321,.789),l(-.08,.255),l(-.352,.384),l(-.547,1.147),l(-.533,.779),l(-.71,.725),l(-1.001,.755),l(-.336,.087),l(-1.028,.303),l(-.901,.358),l(-.809,.499),l(-.59,.653),l(-.284,.51),l(-.987,2.506),l(-.267,.312),l(-.242,.072),l(-.398,-.068),l(-.398,-.491),l(-.191,-.479),l(-.312,-.252),l(-.815,.005),l(-.444,-.11),l(-.105,-.197),l(-.097,-.494),l(.233,-.34),l(.029,-.495),l(.005,-.569),
N(245.934,224.314),l(1.109,1.843),l(.922,1.646),l(.08,.24),l(-.437,.736),l(-.15,.523),l(-.143,.848),l(.057,.522),l(.236,.902),l(-.156,.34),l(-.221,.34),l(-.532,.582),l(-.102,.452),l(.347,.845),l(-.21,.368),l(-.159,.34),l(.022,.48),l(.604,1.168),l(.015,.522),l(-.285,.439),l(-.723,.61),l(-.12,.227),l(.049,.48),l(.132,.295),l(.018,.142),l(-.586,.187),l(-.15,.199),l(-.228,.933),l(-.259,.298),l(-.852,.275),l(-.201,-.517),l(-.289,-.31),l(-1.422,-.618),l(-.313,-.239),l(-.233,-.678),l(-.315,-.38),l(-.559,-.225),l(-.504,-.281),l(-.489,-.254),l(-.616,-.309),l(-.873,-.464),l(-.673,-.366),l(-.866,-.379),l(-.838,-.337),l(-1.271,-.845),l(-1.354,-.985),l(-1.232,-1.099),l(-.594,-.705),l(-.42,-.677),l(.008,-.438),l(0,-.903),l(-.269,-.606),l(-.781,-1.043),l(-1.389,-2.778),l(-.285,-.268),l(-.467,-.211),l(-.074,-.085),l(.055,-.536),l(-.02,-.396),l(-.149,-.396),l(-1.208,-2.199),l(-.997,-1.961),l(-.688,-1.27),l(-1.365,-1.917),l(-.272,-.353),l(-.598,-.973),l(-.462,-.423),l(-.75,-.437),l(-.914,-.365),l(-.61,-.365),l(.119,-.17),l(.181,-.113),l(.609,-.029),l(.144,-.41),l(-.118,-.282),l(-.592,-.874),l(-.353,-.437),l(-.258,-.72),l(.01,-.24),l(.244,-.523),l(.582,-.622),l(1.02,-.878),l(.47,-.198),l(.317,-.214),l(-.005,.569),l(-.029,.495),l(-.233,.34),l(.097,.494),l(.105,.197),l(.444,.11),l(.815,-.005),l(.312,.252),l(.191,.479),l(.398,.491),l(.398,.068),l(.242,-.072),l(.267,-.312),l(.987,-2.506),l(.284,-.51),l(.59,-.653),l(.809,-.499),l(.901,-.358),l(1.028,-.303),l(.336,-.087),l(1.001,-.755),l(.71,-.725),l(.533,-.779),l(.547,-1.147),l(.352,-.384),l(.08,-.255),l(-.321,-.789),l(-.387,-.76),l(.927,.107),l(.897,.418),l(.513,.435),l(.208,.324),l(.208,.62),l(.526,.364),l(.988,.672),l(.251,.761),l(.078,.282),l(.366,.14),l(.479,.039),l(.173,.296),l(-.004,.396),l(.092,.281),l(.573,.152),l(1.038,.008),l(.496,-.031),l(.337,-.157),l(.452,-.427),l(.523,.421),l(.397,.182),l(.708,-.442),l(.509,.209),l(1.299,.84),l(.127,.069),l(-.035,.198),l(-1.155,1.956),l(.448,-.031),l(.161,-.058),l(.237,.126),l(.575,.703),l(.156,.14),l(.136,.324),l(-.341,.186),l(-.793,-.235),l(-.493,-.096),l(-.322,.072),l(-.604,.441),l(-.371,.115),l(-.669,-.066),l(-1.895,.773),l(-.701,.442),l(-.372,.172),l(-.599,1.415),l(-.319,.511),l(-.021,.155),l(.277,.86),l(.012,.112),l(-.625,.498),l(-.62,.328),l(-.349,.342),l(-.247,.622),l(.106,.564),l(.619,.957),l(1.333,2.166),l(.106,.127),l(-.247,.495),l(-.208,.312),l(1.085,.12),l(.415,.04),l(.312,.182),l(.241,.323),l(.096,.663),l(1.843,.032),l(.762,-.499),l(.648,-.484),l(.326,-.114),l(-.059,1.511),l(-.098,1.173),l(.108,.353),l(.317,.337),l(.285,.068),l(.358,-.072),l(.786,-.259),l(.42,-.045),
N(279.288,257.295),l(-.063,-.423),l(.027,-.777),l(.222,-.819),l(.298,-.835),l(.321,-.75),l(-.019,-.141),l(-.491,-.336),l(-.234,-.112),l(-1.29,.445),l(-.224,-.055),l(-.254,-.563),l(-.487,-2.524),l(-.121,-.437),l(-.843,-.404),l(-.724,-.278),l(-.115,.001),l(-.709,.413),l(-.346,.03),l(-.925,-.221),l(-.818,-.15),l(-.372,-.04),l(.006,-.72),l(.086,-.721),l(.132,-.862),l(-.104,-.959),l(-.521,-.872),l(-.084,-.663),l(-.253,-.408),l(.421,-.666),l(.38,-.765),l(.238,-.834),l(.185,-1.173),l(-.022,-.494),l(-.307,-.774),l(-.316,-.479),l(-.73,-.362),l(-.436,-.407),l(-.067,-.563),l(.261,-.835),l(-.042,-.296),l(-.693,-.024),l(-1.615,-.019),l(-.5,-.012),l(-.967,-.036),l(-.153,-.112),l(-.249,-.944),l(-.138,-2.032),l(-.03,-.706),l(-.203,-1.029),l(.038,-.565),l(-.085,-.169),l(-.403,-.237),l(-.537,-.166),l(-.636,-.123),l(-1.148,.077),l(-.22,-.084),l(-.398,-.308),l(-.385,-.774),l(-.096,-.014),l(-.882,-.037),l(-.3,-.098),l(-.75,-.603),l(-.688,-.307),l(-.676,-.25),l(-.355,.03),l(-.787,-.023),l(-.316,-.097),l(-1.1,-.939),l(-.813,-.928),l(-.335,-.591),l(-.141,-.635),l(-.036,-.818),l(.064,-.622),l(.079,-.621),l(-.045,-.748),l(-1.283,-.021),l(-.934,.076),l(-.36,.158),l(-.874,.485),l(-1.471,1.109),l(-.415,.243),l(-.48,-.025),l(-.336,-.026),l(-.946,.824),l(-.355,.03),l(-1.122,-.304),l(-.939,-.136),l(-.42,.045),l(-.786,.259),l(-.358,.072),l(-.285,-.068),l(-.317,-.337),l(-.108,-.353),l(.098,-1.173),l(.059,-1.511),l(-.326,.114),l(-.648,.484),l(-.762,.499),l(-1.843,-.032),l(-.096,-.663),l(-.241,-.323),l(-.312,-.182),l(-.415,-.04),l(-1.085,-.12),l(.208,-.312),l(.247,-.495),l(-.106,-.127),l(-1.333,-2.166),l(-.619,-.957),l(-.106,-.564),l(.247,-.622),l(.349,-.342),l(.62,-.328),l(.625,-.498),l(-.012,-.112),l(-.277,-.86),l(.021,-.155),l(.319,-.511),l(.599,-1.415),l(.372,-.172),l(.701,-.442),l(1.895,-.773),l(.669,.066),l(.371,-.115),l(.604,-.441),l(.322,-.072),l(.493,.096),l(.793,.235),l(.341,-.186),l(-.136,-.324),l(.133,-.198),l(.073,-.382),l(.706,-4.411),l(.326,-1.428),l(-.031,-.212),l(-.399,-.562),l(.031,-.777),l(-.192,-.183),l(-.688,-.363),l(-.192,-.197),l(0,-.554),l(.001,-1.071),l(.111,-.085),l(.493,-.187),l(.687,-.032),l(.417,.11),l(.384,.04),l(-.052,-.367),l(-.293,-.408),l(-.177,-.084),l(-.896,-.122),l(-.178,-.154),l(.013,-1.031),l(.042,-.325),l(.64,.024),l(2.812,.082),l(.463,-.017),l(.412,-.158),l(.834,-.57),l(.52,-.286),l(.148,.168),l(.138,.437),l(.161,.861),l(.088,.452),l(.199,.437),l(.432,.054),l(.694,.546),l(.482,.223),l(.414,-.073),l(.757,-.697),l(.083,.183),l(.186,.776),l(.271,-.016),l(.645,-.739),l(.74,-.654),l(.554,-.286),l(.652,-.173),l(.235,-.213),l(.259,-.666),l(.203,-.199),l(.652,-.131),l(.569,-.272),l(.265,-.27),l(-.15,-.253),l(-.434,-.125),l(-.96,-.051),l(-.166,-.239),l(-.079,-.55),l(-.302,-1.524),l(-.391,-.69),l(-.616,-.688),l(.041,-.184),l(.159,-.029),l(.309,.125),l(.896,.461),l(.385,.04),l(1.149,-.035),l(.344,.224),l(.628,.618),l(.348,-.115),l(.232,-1.117),l(.284,-.115),l(.465,.054),l(.557,-.074),l(.807,-.23),l(1.74,-.9),l(.592,-.385),l(.163,-.326),l(-.103,-.169),l(.375,-.257),l(.302,-.058),l(.516,.124),l(.26,.111),l(.04,.212),l(-.452,1.09),l(.304,-.001),l(.533,.138),l(.435,.958),l(-.179,.368),l(-.547,1.416),l(-.213,.962),l(.156,.465),l(.281,.394),l(.167,.31),l(-.072,.354),l(.008,.396),l(.15,.296),l(1.103,.897),l(.613,.392),l(.686,-.075),l(.694,-.513),l(.505,-.314),l(1,-.331),l(.934,-.429),l(.943,.022),l(.4,.04),l(1.108,.276),l(.528,.054),l(-.611,-1.014),l(.2,-.326),l(.172,-.156),l(.642,.124),l(.418,.139),l(.398,-.059),l(.534,-.385),l(.319,-.001),l(1.05,.488),l(.649,.505),l(.225,.069),l(.882,-.613),l(1.11,.389),l(.56,.025),l(.299,-.214),l(.464,-.681),l(.439,-.992),l(.427,-.765),l(1.102,-1.646),l(-.015,-.422),l(.409,-.241),l(.276,.141),l(.235,.423),l(.164,.791),l(.414,1.34),l(.108,.607),l(.472,1.383),l(.296,.55),l(.324,.324),l(.978,.21),l(.196,.338),l(.038,.551),l(-.045,.254),l(-.524,.354),l(-.933,1.414),l(-.238,.325),l(-.51,.411),l(-.41,.231),l(-.244,.138),l(-.798,.778),l(-.544,.947),l(-.419,1.018),l(-.402,.453),l(.271,.112),l(.512,-.072),l(.497,-.198),l(1.202,-.709),l(.112,-.028),l(.299,.889),l(.442,.818),l(.255,.112),l(.287,.07),l(1.135,-.031),l(.592,-.058),l(.737,-.298),l(-.277,.679),l(-.017,.584),l(.448,-.557),l(1.254,-1.006),l(.289,-.156),l(.306,-.382),l(.499,-.933),l(.272,-.396),l(.256,-.099),l(1.006,-.003),l(.352,-.198),l(.175,0),l(.687,.549),l(.654,.267),l(.32,-.028),l(.814,.28),l(1.069,.45),l(.334,.281),l(.269,.593),l(.08,.028),l(.176,-.015),l(.402,-.354),l(.319,.042),l(.302,.254),l(.538,.789),l(.205,.396),l(-.13,.254),l(-.308,.41),l(-.116,.424),l(.091,.466),l(.171,.396),l(.825,-.821),l(.369,-.156),l(.609,-.156),l(.995,-.454),l(.224,-.028),l(.367,.069),l(.764,.38),l(.907,.436),l(.462,.098),l(1.117,.167),l(1.118,.083),l(.464,-.058),l(.48,-.029),l(.577,-.171),l(.416,-.016),l(1.131,.351),l(.731,.408),l(.762,.479),l(.586,.437),l(1.595,1.395),l(.742,.662),l(.821,.605),l(.41,.338),l(.477,.196),l(.734,.168),l(1.247,.097),l(.912,.04),l(.445,.197),l(.265,.465),l(.087,.607),l(.592,2.004),l(.268,1.143),l(.062,.988),l(-.076,.579),l(-.179,.904),l(-.243,.848),l(-.559,1.301),l(-.518,.849),l(-1.347,1.175),l(-1.388,1.288),l(-.44,.198),l(-.354,.043),l(-.39,.637),l(-.094,.396),l(-.012,.353),l(-.504,1.074),l(-.6,.976),l(-.8,1.104),l(-.266,.212),l(-.194,.015),l(-.079,-.423),l(-.278,-.296),l(-.367,-.084),l(-.064,.79),l(-.538,1.64),l(-.049,.734),l(-.077,.607),l(.318,2.738),l(.078,.988),l(-.577,2.543),l(-.039,.663),l(.14,.649),l(.043,.085),l(-.759,.495),l(-.404,.51),l(-.261,.791),l(-.04,.367),l(.245,1.468),l(-.106,.367),l(-.214,.283),l(-.676,.608),l(-.752,1.498),l(-1.01,1.4),l(-.201,.537),l(-.055,.311),l(.144,.945),l(-1.203,.37),l(-.544,.283),l(-.355,.368),l(-.084,.466),l(.021,.367),l(-.401,.114),l(-.864,-.041),l(-.979,.172),l(-.654,.001),l(-.764,-.055),l(-.465,-.112),l(-.922,.072),l(-.736,.002),l(-.214,.607),l(-.295,.198),l(-.795,.312),l(-.481,.453),l(-.21,.354),l(-.747,-.267),l(-.35,.071),l(-.563,.255),l(-1.864,1.232),l(-.528,.396),l(-.725,.383),l(-.616,.438),l(-.532,.679),l(-.486,.241),l(-.567,.072),l(-.278,-.014),l(.006,.24),l(.336,.225),l(.12,.536),l(-.111,.537),l(-.099,.282),l(-.282,.156),l(-.084,.155),l(.384,.648),l(.036,1.186),l(.05,1.045),l(-.057,.311),l(-.11,.594),l(-.198,.621),l(-.464,.735),l(-.566,.495),l(-.788,.524),l(-.866,1.046),l(-.208,.396),l(-.476,1.145),l(-.499,.933),l(-.75,1.004),l(-.69,.623),l(-.801,.78),l(.321,-.808),l(.436,-.594),l(.629,-.566),l(.605,-1.158),l(-.06,-.254),l(-.356,.142),l(-.397,-.014),l(-.633,-.21),l(-.075,.155),l(.002,.297),l(-.401,1.215),l(-.349,.48),l(-.661,.438),l(-.317,.283),l(-.225,.424),l(-.013,.354),l(-.448,1.709),l(-.481,.763),l(-.787,.934),l(-1.076,.979),l(-.101,-.313),l(-.258,-.746),l(.103,-.269),l(.634,-.766),l(.017,-.269),l(-.333,-.379),l(-.163,-.027),l(-.131,-.197),l(-.853,-1.109),l(-.474,-.435),l(-.999,-.587),l(-.55,-.194),l(-.617,-.194),l(-.432,-.576),l(-.365,-.393),l(-.693,.427),l(-.27,.016),l(-.232,-.38),l(-.59,-.814),l(-.379,-.407),l(-.47,-.364),l(-.266,-.098),l(-.25,.101),l(-1.042,.246),l(-.55,.003),l(.214,-.27),l(.833,-.88),l(1.805,-1.816),l(1.435,-1.363),l(1.633,-1.448),l(.348,-.242),l(1.754,-.744),l(.521,-.313),l(.161,-.467),l(.094,-1.638),l(-.517,-1.154),l(-.206,-.196),l(-.462,.017),l(-.957,.161),M(288.966,203.943),l(-.558,-.125),l(-.301,-.536),l(-.078,-.382),l(.16,-.197),l(-.094,-.636),l(.048,-.381),l(.208,-1.018),l(.176,-.099),l(.479,-.058),l(.879,.097),l(1.007,.11),l(.479,-.199),l(.368,.028),l(.479,.168),l(.479,.083),l(.319,.155),l(-.335,.538),l(-.193,.946),l(-.257,.494),l(-.289,.312),l(-.561,.326),l(-.464,.171),l(-.527,.015),l(-.783,.016),l(-.641,.171),
N(732.92,214.323),l(-.164,-.24),l(-.225,-.197),l(-.379,-.126),l(-.416,.198),l(-.399,-.38),l(-.287,-.184),l(-.659,-.238),l(-.243,-.239),l(.156,-.255),l(.29,.027),l(.731,-.058),l(.538,.126),l(.743,.083),l(.523,-.058),l(.258,-.185),l(.232,-.509),l(.056,.099),l(.351,.395),l(.286,.184),l(.241,.014),l(.961,-.2),l(.366,-.227),l(.361,-.722),l(.241,-.212),l(.653,-.029),l(.263,-.128),l(.04,-.282),l(-.064,-.565),l(-.043,-.536),l(.495,.196),l(.404,.056),l(.324,-.354),l(.318,.578),l(.077,.353),l(-.196,.495),l(-.099,.184),l(-.509,.044),l(-.159,.226),l(.061,.17),l(.437,.479),l(-.308,.354),l(-.264,.113),l(-.742,-.083),l(-.416,.001),l(-.091,.269),l(-.408,.495),l(-.275,.156),l(-.973,.426),l(-.484,.143),l(-.798,.029),l(-.807,.115),M(713.795,220.696),l(.031,-3.438),l(-.046,-.805),l(-.431,-1.368),l(.44,-.822),l(-.169,-7.966),l(2.581,.802),l(.85,.337),l(1.04,.295),l(1.254,.378),l(.848,.507),l(.613,.323),l(.597,.084),l(.38,-.058),l(.26,.508),l(.274,.254),l(.635,.352),l(.687,.395),l(.779,.718),l(-.3,.947),l(.033,.226),l(.305,.226),l(.665,.111),l(1.887,.787),l(.354,.027),l(.72,.183),l(.181,.254),l(.413,.535),l(.211,.579),l(-.166,.113),l(-1.114,.073),l(-.563,.156),l(-.098,.155),l(.047,.339),l(.589,.987),l(.5,.521),l(1.464,1),l(.218,.847),l(.725,1.044),l(.288,.141),l(.304,-.015),l(.712,-.086),l(.338,.013),l(.087,.198),l(-.354,.551),l(.218,.212),l(.401,.141),l(.423,.041),l(.63,.168),l(.096,.127),l(-.031,.142),l(-.648,.213),l(.287,.24),l(1.064,.28),l(.538,.295),l(.235,.763),l(-.064,.226),l(-1.094,-.012),l(-.215,-.154),l(-.146,-.466),l(-.126,-.099),l(-1.011,-.111),l(-1.063,-.266),l(-.644,-.126),l(-.752,.016),l(-.774,-.026),l(-.573,-.211),l(-.494,-.352),l(-.223,-.522),l(-.24,-.268),l(-.726,-.31),l(-.472,-.338),l(-.135,-.197),l(-1.089,-1.608),l(-.613,-.817),l(-.454,-.056),l(-1.524,-.336),l(-.671,-.31),l(-.55,-.055),l(-.415,.185),l(-.394,.071),l(-.78,-.45),l(.282,.762),l(-.027,.212),l(-.249,.071),l(-.382,-.126),l(-.311,.1),l(.296,.395),l(-.116,.113),l(-1.037,.045),l(-1.125,-.182),l(-.478,.029),l(.237,.127),l(.24,.154),l(.642,.169),l(.662,.352),l(.404,.338),l(.219,.395),l(-.411,.199),l(-.739,.425),l(-.458,.213),l(-.668,-.097),l(-1.801,-.039),l(-1.219,-.092),
N(726.605,297.247),l(-.479,-.229),l(-1.179,-.471),l(-.543,-.371),l(-.508,-.715),l(-.477,-.558),l(-.216,-.414),l(.264,-.044),l(.169,.1),l(.421,.171),l(.129,-.143),l(-.209,-.387),l(-.703,-.699),l(-.617,-.713),l(-.149,-.257),l(-.375,-.956),l(-.008,-.67),l(.177,-.044),l(1.004,.312),l(1.476,.354),l(1.089,.369),l(.797,-.03),l(.463,-.144),l(.382,-.115),l(.373,-.058),l(.684,.027),l(.306,-.301),l(.716,-.244),l(.475,.385),l(-.009,.1),l(.128,.8),l(-.009,.686),l(-.751,1.503),l(-.124,.758),l(-.245,.315),l(-.943,.26),l(-.553,.388),l(-.49,.689),l(-.189,.272),l(-.274,.072),M(716.883,224.344),l(.682,.394),l(.233,.509),l(.047,.649),l(.118,.678),l(.256,.197),l(.42,.013),l(.102,.24),l(-.45,.919),l(.715,.338),l(.175,.282),l(.147,.593),l(.08,1.3),l(.144,.621),l(.456,1.157),l(.293,.268),l(.422,.014),l(.328,-.312),l(.384,-.185),l(.32,.663),l(.363,.127),l(.563,.408),l(.385,.154),l(.144,.155),l(.002,.41),l(.083,.96),l(.275,.776),l(-.046,1.06),l(.279,.24),l(.93,1.325),l(.276,.706),l(.055,.777),l(-.209,.876),l(.403,.649),l(.275,.833),l(.204,.353),l(1.395,.803),l(.285,.154),l(.744,.111),l(.402,.649),l(.843,.535),l(.483,.169),l(1.141,.068),l(.117,.197),L(731,245.42),l(-.273,.565),l(.309,.424),l(.879,.479),l(.22,.564),l(.469,1.342),l(.211,.748),l(.112,.396),l(.252,.311),l(.771,.352),l(-.021,-.127),l(-.141,-.777),l(.913,.507),l(.567,.154),l(.184,.127),l(.136,.296),l(.106,1.752),l(.884,.762),l(.573,.323),l(.604,.154),l(.287,.296),l(.244,.579),l(.229,.424),l(.545,.168),l(.176,.297),l(.007,.269),l(.19,.536),l(.106,.113),l(.506,.126),l(.156,.112),l(.162,.354),l(.366,1.327),l(.026,.876),l(.013,.862),l(-.132,.41),l(-.181,.325),l(.778,1.271),l(.223,.48),l(.181,.833),l(.034,.749),l(-.293,.708),l(-.353,1.668),l(-.585,1.755),l(.137,.791),l(-.065,.806),l(-.306,.778),l(-.661,.977),l(-.203,.665),l(-.598,.821),l(-.45,.185),l(-.465,.1),l(-.423,.468),l(-.466,.68),l(-.328,1.527),l(-.477,.638),l(-.34,.495),l(.014,.65),l(-.208,.539),l(-.331,.312),l(-.601,.341),l(-.27,.326),l(-.3,1.021),l(-.169,1.049),l(-.079,.937),l(.021,.666),l(-.283,.64),l(-.322,.354),l(-.463,.3),l(-.754,.101),l(-1.158,.087),l(-.82,.03),l(-.527,.157),l(-.516,.299),l(-1.529,.94),l(-.443,.129),l(-.214,.284),l(-.346,.071),l(-.528,.059),l(-.286,-.014),l(.295,.368),l(.209,.27),l(-1.315,-.665),l(-.885,-.353),l(.003,-.469),l(-.073,-.156),l(-.56,-.467),l(-.628,-.368),l(-.421,-.014),l(-.485,.172),l(-.335,.242),l(.748,.467),l(-.97,.243),l(-.929,.428),l(-.953,.442),l(-.222,.028),l(-.604,-.226),l(-.886,-.438),l(-.67,-.226),l(-1.086,-.311),l(-.51,-.041),l(-.239,.156),l(-.044,.113),l(-.716,-.169),l(-.751,-.353),l(-.522,-.298),l(-.896,-.82),l(-.526,-.34),l(-.422,-.879),l(.09,-1.035),l(-.082,-.411),l(-.184,-.495),l(-.664,-.736),l(-.141,-.523),l(-.029,-.425),l(-.534,-.014),l(-.786,.398),l(-.597,.114),l(-.34,.058),l(-.178,-.07),l(-.167,-.17),l(.517,-.454),l(.233,-.567),l(.073,-.821),l(-.253,-.324),l(-.536,-.593),l(-.247,-.353),l(-.485,.735),l(-.443,1.431),l(-.19,.113),l(-.796,.002),l(-.199,.156),l(-.196,.015),l(-.255,.028),l(.198,-.396),l(.081,-.396),l(.079,-.1),l(.634,.041),l(.242,-.142),l(.126,-.255),l(-.105,-1.004),l(.454,-.835),l(.328,-.453),l(.091,-.396),l(.018,-.409),l(.151,-.128),l(.245,-.015),l(.218,-.354),l(-.052,-.227),l(-.323,-.494),l(-.338,-.494),l(-.107,.707),l(-.288,.255),l(-.518,.299),l(-.311,.467),l(-.086,.155),l(-.189,.467),l(-.281,.326),l(-.747,.242),l(-.735,.481),l(-.653,.567),l(-.36,.693),l(-.514,.808),l(-.41,-.339),l(-.38,-1.328),l(-.263,-.579),l(-.19,-.325),l(-.688,-.79),l(-.297,-.734),l(-.176,-.212),l(-.704,.072),l(-.235,-.099),l(-.139,-.24),l(-.085,-.269),l(.334,-.34),l(-.047,-.297),l(-.346,-.395),l(-.543,-.494),l(-.266,-.098),l(-.83,.157),l(-.486,-.07),l(-.95,-.549),l(-.274,-.014),l(-.438,.17),l(-.433,-.027),l(-.421,-.183),l(-.662,-.521),l(-.921,-.437),l(-.218,.001),l(-.723,.213),l(-1.282,.088),l(-.669,.001),l(-1.764,.061),l(-.611,.129),l(-.656,.213),l(-.989,.44),l(-.972,.256),l(-1.039,.257),l(-1.503,.088),l(-.794,-.013),l(-.383,.044),l(-.927,.284),l(-.993,.469),l(-.773,.397),l(-.538,.143),l(-.431,.085),l(-.361,.199),l(-.615,.693),l(-.774,1.02),l(-.588,.284),l(-.766,-.013),l(-.547,-.013),l(-.927,.143),l(-.4,.185),l(-.663,-.395),l(-.294,-.084),l(-.734,.016),l(-1.572,.173),l(-.938,.157),l(-.459,-.041),l(-.672,.044),l(-.398,.227),l(-.583,.793),l(-.344,.128),l(-.958,-.125),l(-.158,.057),l(-.57,.708),l(-.465,.368),l(-.919,.271),l(-.586,.086),l(-1.516,-.082),l(-.638,-.055),l(-.688,-.197),l(-.633,-.366),l(-.778,-.677),l(-.74,-.353),l(-.374,-.041),l(-.151,-.07),l(-.19,-1.229),l(.055,-.255),l(.489,.112),l(.45,-.086),l(.332,-.425),l(.197,-.467),l(.267,-1.357),l(-.043,-1.215),l(-.156,-.622),l(-.258,-.593),l(-1.117,-1.906),l(-.208,-.635),l(-.144,-.834),l(.027,-.989),l(-.16,-.692),l(-.467,-1.072),l(-.663,-.945),l(-.603,-.734),l(-.214,-.254),l(.128,-.904),l(-.215,-.536),l(-.733,-1.115),l(-.972,-1.018),l(-.273,-.583),l(.126,-.233),l(.188,.187),l(.152,.443),l(.183,.163),l(.235,.35),l(.327,.188),l(.354,.023),l(-.348,-1.144),l(-.437,-.396),l(-.226,-.326),l(.08,-.304),l(.748,.84),l(.495,.979),l(.477,.065),l(-.099,-.555),l(.289,-.039),l(.004,-.564),l(-.282,-.48),l(-1.03,-1.368),l(-.354,-.691),l(-.119,-.579),l(-.038,-.734),l(.355,-.595),l(.323,-.523),l(.21,-.664),l(-.083,-1.031),l(-.254,-.635),l(.033,-.368),l(.438,-.692),l(.109,-.325),l(.064,-.156),l(.271,.649),l(.011,.424),l(.105,.184),l(.35,.027),l(.171,-.113),l(.187,-.565),l(.141,-.48),l(.765,-.468),l(1.22,-.624),l(.484,-.326),l(.676,-.581),l(.585,-.467),l(.632,-.327),l(.79,-.114),l(.697,-.016),l(.7,-.002),l(.431,-.043),l(.352,-.185),l(.474,-.453),l(.494,-.128),l(.929,-.072),l(.279,-.143),l(.291,-.551),l(.158,-.1),l(.444,.027),l(.877,.224),l(.626,-.043),l(.911,-.299),l(1.084,-.469),l(.359,-.213),l(.716,-.665),l(.427,-.58),l(.29,-.622),l(.132,-.297),l(.41,-.369),l(.968,-.651),l(.079,-.17),l(-.067,-.409),l(-.242,-.805),l(-.016,-.495),l(1.063,-1.118),l(.387,-.692),l(.291,.169),l(.341,.437),l(.619,1.355),l(.262,.253),l(.177,-.579),l(.021,-.466),l(.436,.238),l(.272,.07),l(.189,-.607),l(-.06,-.142),l(-.563,-.238),l(-.175,-.24),l(.007,-.565),l(.044,-.112),l(.897,.04),l(.661,.253),l(.642,-.029),l(.334,-.029),l(.289,.074),l(-.699,-.455),l(-.431,-.141),l(.128,-.537),l(-.07,-.296),l(.135,-.509),l(.422,-.354),l(.165,-.07),l(.732,.394),l(.202,-.043),l(-.112,-.452),l(.11,-.48),l(.146,-.367),l(-.041,-.522),l(.358,-.171),l(.4,-.113),l(.813,.04),l(.529,-1.088),l(.371,-.298),l(.35,.169),l(.268,.451),l(.265,-.552),l(.222,-.227),l(.197,-.48),l(.695,.62),l(.513,.084),l(.293,.211),l(.331,.536),l(.632,.592),l(.122,.706),l(-.072,.594),l(.181,.197),l(.256,-.283),l(.462,-.679),l(.155,-.128),l(1.16,.082),l(.479,.155),l(.637,.492),l(.332,.141),l(.156,-.48),l(.302,-.297),l(.022,-.24),l(-.266,-.324),l(-.601,-.395),l(-.079,-.184),l(.008,-.24),l(.145,-.099),l(.604,-.538),l(.007,-.452),l(.191,-.213),l(.518,-.283),l(.268,-.241),l(.151,-.269),l(-.094,-.184),l(.003,-.296),l(.512,-.863),l(.121,-.057),l(.317,-.029),l(.397,-.029),l(.248,-.17),l(-.205,-.409),l(.377,-.396),l(.344,-.071),l(.793,.366),l(.616,-.072),l(1.291,-.088),l(.512,-.128),l(.232,-.17),l(.04,-.057),l(-.077,-.197),l(-.2,-.734),l(-.248,-.282),l(-.471,-.268),l(-.374,.086),l(-.244,-.141),l(.035,-.212),l(.367,-.143),l(.396,-.043),l(.617,.521),l(.255,.099),l(.34,-.1),l(.364,.31),l(.676,.465),l(.36,.154),l(1.297,.294),l(.591,.084),l(.413,-.143),l(.372,.014),l(.396,.606),l(.419,.112),l(.141,-.029),l(.562,-.438),l(.454,.027),l(.652,.38),l(.331,.479),l(.46,-.143),l(.122,-.791),l(.181,-.085),l(.455,.465),l(.337,.099),l(.152,.154),l(-.436,.411),l(-.126,.424),l(-.176,.212),l(-.011,.438),l(-.12,.255),l(-.513,.015),l(-.51,.228),l(-.396,.34),l(-.004,.551),l(.301,.353),l(-.187,.692),l(-.381,.58),l(-.559,.481),l(-.155,.48),l(.063,.17),l(.469,.437),l(1.038,.619),l(.81,.677),l(.508,.606),l(.246,.099),l(.349,-.114),l(.264,.027),l(.782,.352),l(.742,.465),l(.434,.451),l(.679,.535),l(.335,.127),l(.442,.027),l(.784,.182),l(.25,.184),l(.218,.621),l(.167,.169),l(.507,.31),l(.76,.423),l(.537,.154),l(.422,-.072),l(.414,-.17),l(.603,-.199),l(.208,-.156),l(.736,-1.344),l(.403,-1.131),l(.194,-1.314),l(.259,-.721),l(.43,-.679),l(-.131,-.424),l(-.409,-.621),l(.022,-.311),l(.236,-.637),l(.187,-.48),l(-.164,-.282),l(-.183,-.395),l(.088,-.692),l(.104,-1.004),l(.225,-.297),l(.329,-.156),l(.158,-.311),l(-.534,-.521),l(.033,-.198),l(.576,-.947),l(.312,-.934),l(.072,-.833),l(.191,-.241),l(.279,-.297),
N(270.934,276.123),l(.054,-.338),l(-.194,-.577),l(.011,-.522),l(.24,-.495),l(.48,-.524),l(.118,-.325),l(-.168,-.986),l(-.049,-.847),l(.103,-.522),l(.595,-2.359),l(.065,-.452),l(.443,-.524),l(.55,-.003),l(1.042,-.246),l(.25,-.101),l(.266,.098),l(.47,.364),l(.379,.407),l(.59,.814),l(.232,.38),l(.27,-.016),l(.693,-.427),l(.365,.393),l(.432,.576),l(.617,.194),l(.55,.194),l(.999,.587),l(.474,.435),l(.853,1.109),l(.131,.197),l(.163,.027),l(.333,.379),l(-.017,.269),l(-.634,.766),l(-.103,.269),l(.258,.746),l(.101,.313),l(-.059,.053),l(-.803,1.103),l(-.625,.552),l(-.775,.454),l(-.441,.156),l(-.818,.1),l(-.874,-.337),l(-.551,.044),l(-.551,.114),l(-.64,.283),l(-.38,-.042),l(-.846,-.676),l(-.637,-.252),l(-.76,-.154),l(-.469,.128),l(-.507,.072),l(-.327,-.127),l(-.548,-.563),l(-.354,-.159),
N(418.763,73.869),l(.391,-.499),l(.389,-.262),l(.283,.081),l(.663,-.062),l(.762,-.075),l(.324,-.137),l(.891,-.787),l(.979,-.2),l(.224,.025),l(.198,-.219),l(.175,.032),l(-.349,.531),l(.11,.106),l(.026,.481),l(-.288,.156),l(-.17,.368),l(-1.675,.069),l(-.376,-.106),l(-.428,.031),l(-.14,-.062),l(-.239,.081),l(-.275,.031),l(-.153,.417),l(-.249,.218),l(-.353,.118),l(-.08,.112),l(-.229,-.155),l(-.411,-.292),M(421.68,78.002),l(-1.839,.129),l(-.116,-.016),l(.064,-.404),l(-.19,-.638),l(-.174,.015),l(-.36,-.293),l(-.233,.184),l(-.398,-.172),l(.2,-.355),l(.434,-.293),l(-.007,-.181),l(-.445,-.541),l(.018,-.256),l(.131,-.498),l(.279,-.106),l(.318,.15),l(.495,.12),l(.43,-.574),l(.299,-.091),l(.296,.437),l(.391,-.046),l(.022,-.528),l(.107,-.363),l(1.032,-.017),l(.848,.089),l(.03,.544),l(.187,.301),l(1.138,.058),l(.14,.166),l(-.307,.604),l(-.565,.142),l(-.119,-.261),l(-.331,.031),l(-.263,.136),l(.121,.278),l(-.184,.414),l(-.312,.077),l(-.069,.244),l(-.635,.035),l(.157,.229),l(-.291,.094),l(-.191,.24),l(-.061,.285),l(.003,.21),l(-.215,.338),l(.166,.084),M(427.177,77.967),l(-.139,-.149),l(-.312,-.344),l(-.405,.031),l(-.665,-.059),l(-.123,-.329),l(-.285,-.66),l(.433,-.091),l(.603,-.467),l(.356,.495),l(.521,.179),l(.2,-.271),l(.078,-.586),l(.333,-.046),l(.459,.044),l(.056,.571),l(-.134,.36),l(-.144,.09),l(-.413,.286),l(.603,.299),l(-.285,.166),l(-.499,.39),l(-.238,.09),
N(417.259,94.301),l(-.135,-.233),l(.216,-.701),l(-.091,-.076),l(.075,-.295),l(.321,-.372),l(.054,-.358),l(.054,-.213),l(.954,-.806),l(-.605,-.193),l(-.479,.014),l(-.456,-.09),l(-.095,-.186),l(-.233,-.007),l(-.072,.048),l(-.689,.062),l(-.045,-.145),l(-.395,.055),l(-.337,-.277),l(-.428,-.319),l(-.074,-.353),l(.248,-.144),l(.044,-.288),l(-.466,-.096),l(-.41,-.312),l(-.062,-.301),l(.422,-.376),l(-.038,-.468),l(-.282,-.365),l(-.344,-.177),l(.165,-.278),l(-.143,-.217),l(-.182,-.037),l(.08,-.097),l(.235,-.133),l(.236,-.133),l(-.193,-.121),l(.201,-.275),l(.095,-.148),l(-.152,-.292),l(-.082,-.265),l(-.376,-.182),l(.07,-.182),l(.341,-.078),l(.175,-.092),l(.378,.134),l(.664,-.151),l(.32,-.152),l(.128,-.376),l(.412,-.207),l(.003,-.328),l(-.16,-.17),l(-.188,.061),l(-.44,-.134),l(.029,-.184),l(.113,-.181),l(.571,.036),l(.084,-.401),l(.345,-.361),l(-.151,-.438),l(.066,-.147),l(-.465,-.192),l(.126,-.43),l(.285,-.181),l(.371,-.028),l(1.12,-.062),l(.293,-.012),l(.095,.16),l(.195,.271),l(-.155,.158),l(.324,.113),l(.148,-.068),l(.042,-.192),l(-.159,-.204),l(.259,.012),l(.437,.169),l(-.163,-.362),l(.247,-.419),l(.687,.113),l(.614,-.091),l(-.596,-.17),l(-.084,-.227),l(.282,-.102),l(-.252,-.114),l(-.12,-.147),l(.166,-.08),l(.068,-.136),l(-.675,.08),l(-.06,-.182),l(.664,-.125),l(.218,-.193),l(-.464,-.42),l(-.324,-.341),l(.045,-.28),l(.116,.016),l(1.839,-.129),l(.254,.13),l(.565,.341),l(.271,.297),l(-.02,.228),l(-.252,.175),l(.445,-.05),l(.171,.216),l(.157,-.078),l(.283,.021),l(.235,.156),l(.45,.073),l(.866,-.121),l(.077,.208),l(-.07,.149),l(-.057,.125),l(-.665,.295),l(.316,.193),l(.649,-.136),l(.113,.182),l(.457,-.006),l(.349,-.391),l(1.059,-.136),l(.602,-.234),l(.757,-.266),l(.249,.113),l(.396,-.17),l(.184,.182),l(.085,.159),l(.634,.29),l(.182,.074),l(.526,-.12),l(.156,.12),l(.059,.34),l(.036,.227),l(.154,.102),l(.354,.125),l(.372,-.022),l(.028,.13),l(.201,.025),l(.319,.835),l(-.219,.52),l(-.391,.147),l(-.051,.328),l(.391,.102),l(.683,.429),l(-.217,.395),l(.094,.18),l(.312,.146),l(-.021,.304),l(.131,.102),l(-.118,.292),l(-.214,.124),l(-.007,.191),l(.325,.27),l(-.114,.258),l(.468,.188),l(.281,.485),l(-.435,.698),l(-.142,.115),l(-.344,-.072),l(-.031,-.278),l(-.308,-.121),l(-.436,.072),l(.282,.218),l(-.254,.084),l(-.284,.097),l(-.524,.048),l(-.124,.169),l(-.735,.024),l(-.112,.217),l(-.176,-.072),l(-.358,.061),l(-.097,.229),l(-.382,.012),l(-.078,.181),l(-.442,0),l(-.422,.201),l(-.293,-.033),l(-.26,.181),l(-.243,.168),l(.037,.056),l(.258,.378),l(.413,.098),l(-.155,.25),l(-.08,.406),l(.159,.085),l(.036,.233),l(.244,.173),l(.478,.265),l(.188,-.072),l(.573,.515),l(.431,.17),l(.184,.201),l(.219,-.084),l(.165,.18),l(.207,.036),l(.447,.633),l(-.682,.26),l(-.437,-.151),l(-.132,.027),l(-.039,.337),l(-.162,.172),l(-.968,.295),l(-.364,.227),l(.538,.571),l(-.197,.295),l(.334,.014),l(.056,.158),l(-.098,.343),l(-.082,.055),l(-.441,-.178),l(.049,-.165),l(-.146,-.117),l(-.564,.062),l(-.195,-.138),l(-.433,.035),l(-.092,.178),l(-1.25,.035),l(-.125,.171),l(-.319,.014),l(-.044,.13),L(425.4,94.7),l(-.594,.021),l(-.059,-.144),l(-.093,-.145),l(-.493,-.089),l(-.262,.055),l(-.237,-.041),l(.032,.274),l(-.452,.343),l(-.215,0),l(.078,-.195),l(-.26,-.039),l(.011,-.165),l(-.194,-.048),l(-.104,-.137),l(-.249,-.007),l(-.096,-.11),l(-.164,.137),l(-.368,-.014),l(-.664,-.261),l(-.852,-.007),l(-.149,-.089),l(-.199,.014),l(-.017,-.151),l(-.709,.199),l(.179,.199),l(-.354,.021),l(-.278,-.11),l(-.567,.158),l(-.271,-.096),l(-.272,.117),l(-.271,-.089),M(432.012,80.473),l(-.171,-.038),l(-.088,-.049),l(-.447,.08),l(-.111,-.264),l(.002,-.213),l(.647,.281),l(.168,.203),
N(450.734,91.05),l(-.831,-.33),l(-.424,-.101),l(-.104,-.216),l(-.703,-.186),l(-.129,-.13),l(-.561,.076),l(-.508,-.041),l(-.073,.137),l(-.373,.18),l(-.46,-.254),l(-.483,.046),l(-.168,-.056),l(-.558,.204),l(-.104,.177),l(-.149,.135),l(-.18,-.12),l(-.389,.083),l(-.003,-.204),l(.026,-.083),l(-.066,-.18),l(-.331,.025),l(-.073,-.169),l(-.194,-.24),l(-.261,.024),l(-.062,.112),l(-.193,-.016),l(-.183,.24),l(-.43,.048),l(-.03,-.228),l(-.285,-.041),l(-.105,-.331),l(-.382,-.096),l(-.188,-.208),l(.02,-.249),l(-.802,-.132),l(-.311,-.181),l(-.368,.161),l(-.293,-.013),l(-.013,-.221),l(.001,-.253),l(-.329,.084),l(.181,-.283),l(-.709,.005),l(-.258,-.121),l(-.509,-.193),l(-.286,-.024),l(-.003,.145),l(.282,.302),l(-.41,.12),l(-.22,.187),l(-.318,-.072),l(-.296,-.38),l(-.55,-.247),l(.224,-.211),l(.208,-.024),l(.099,-.121),l(-.199,-.181),l(-.257,-.024),l(-.061,.066),l(-.466,.066),l(.005,-.169),l(-.278,.037),l(-.132,-.181),l(-.568,-.054),l(-.201,-.025),l(-.363,-.163),l(-.093,-.26),l(-.211,-.091),l(-.361,.018),l(-.063,.084),l(.062,.073),l(-.024,.151),l(-.375,0),l(.435,-.698),l(-.281,-.485),l(-.468,-.188),l(.114,-.258),l(-.325,-.27),l(.007,-.191),l(.214,-.124),l(.118,-.292),l(-.131,-.102),l(.021,-.304),l(-.312,-.146),l(-.094,-.18),l(.217,-.395),l(-.683,-.429),l(-.391,-.102),l(.051,-.328),l(.391,-.147),l(.219,-.52),l(-.319,-.835),l(.34,.043),l(.23,.125),l(-.093,-.193),l(.156,-.153),l(-.019,-.147),l(-.166,-.13),l(-.021,-.129),l(-.012,-.075),l(.93,-.154),l(.431,-.051),l(.516,-.152),l(1.304,-.128),l(.48,-.158),l(.797,-.479),l(1.117,-.298),l(1.515,-.303),l(1.382,-.086),l(1.067,.417),l(-.882,-.294),l(-.054,.147),l(.256,.172),l(.132,.466),l(.355,.135),l(.648,.061),l(.645,-.11),l(1.063,-.409),l(.054,.004),l(-.978,.417),l(-.19,.11),l(-.004,.123),l(.218,.012),l(.286,-.123),l(.613,-.208),l(.543,-.253),l(.842,.006),l(2.246,.115),l(2.96,-.101),l(.641,-.021),l(.04,.014),l(.679,.243),l(.284,.487),l(.099,.186),l(.016,.029),l(.09,.171),l(.16,.302),l(.615,1.5),l(.172,.502),l(-.023,.236),l(-.263,.208),l(-.44,.03),l(-.571,.244),l(-.291,.328),l(-.128,.292),l(.289,.012),l(.421,.146),l(.149,.176),l(.218,.146),l(.013,.25),l(-.315,.752),l(.126,.137),l(.161,.175),l(-.074,.242),l(.816,.835),l(.316,.193),l(-.298,.048),l(-.085,.133),l(.328,.302),l(-.009,.314),l(-.255,.24),l(-.429,.013),l(-.286,.181),l(-.599,.398),l(-1.509,1.218),l(-.082,.306),l(.044,.552),l(.349,.383),l(-.653,-.018),M(431.844,80.27),l(.232,.024),l(.069,.208),l(-.134,-.029),l(-.168,-.203),M(432.739,80.361),l(-.03,.129),l(-.278,-.024),l(-.191,.03),l(-.046,-.208),l(.174,-.012),l(.266,0),l(.106,.085),
N(416.488,81.945),l(.151,.438),l(-.345,.361),l(-.084,.401),l(-.571,-.036),l(-.113,.181),l(-.029,.184),l(.44,.134),l(.188,-.061),l(.16,.17),l(-.003,.328),l(-.412,.207),l(-.128,.376),l(-.32,.152),l(-.664,.151),l(-.378,-.134),l(-.175,.092),l(-.341,.078),l(-.07,.182),l(.376,.182),l(.082,.265),l(.152,.292),l(-.095,.148),l(-.201,.275),l(.193,.121),l(-.236,.133),l(-.235,.133),l(-.08,.097),l(.182,.037),l(.143,.217),l(-.165,.278),l(-.672,.024),l(-.001,-.338),l(.172,-.097),l(.11,-.423),l(-.754,-.375),l(-.535,.109),l(-.292,-.375),l(-.228,-.061),l(-.173,.121),l(-.313,-.242),l(-.267,.182),l(-.307,0),l(-.307,-.012),l(.025,.157),l(-.52,.034),l(-.407,-.042),l(-.477,-.098),l(-.07,-.162),l(-.496,-.264),l(.795,-.472),l(.858,-.621),l(.273,-.354),l(.563,-1.167),l(.173,-.104),l(.644,-.12),l(.367,.251),l(.136,.268),l(-.28,.203),l(-.228,-.056),l(.066,.496),l(-.191,.124),l(1.163,.225),l(.225,-.236),l(.406,-.113),l(.134,-.417),l(-.458,-.022),l(-.123,-.124),l(-.02,-.203),l(.236,-.158),l(-.171,-.023),l(-.558,-.067),l(.072,-.328),l(-.034,-.13),l(-.023,-.034),l(.128,-.283),l(.572,-.198),l(.709,-.238),l(.654,.03),l(1.089,-.151),l(.245,.275),l(.329,.045),l(.076,.181),l(.259,0),
N(431.57,91.965),l(-.447,-.633),l(-.207,-.036),l(-.165,-.18),l(-.219,.084),L(430.349,91),l(-.431,-.17),l(-.573,-.515),l(-.188,.072),l(-.478,-.265),l(-.244,-.173),l(-.036,-.233),l(-.159,-.085),l(.08,-.406),l(.155,-.25),l(-.413,-.098),l(-.258,-.378),l(-.037,-.056),l(.243,-.168),l(.26,-.181),l(.293,.033),l(.422,-.201),l(.442,0),l(.078,-.181),l(.382,-.012),l(.097,-.229),l(.358,-.061),l(.176,.072),l(.112,-.217),l(.735,-.024),l(.124,-.169),l(.524,-.048),l(.284,-.097),l(.254,-.084),l(-.282,-.218),l(.436,-.072),l(.308,.121),l(.031,.278),l(.344,.072),l(.142,-.115),l(.375,0),l(.024,-.151),l(-.062,-.073),l(.063,-.084),l(.361,-.018),l(.211,.091),l(.093,.26),l(.363,.163),l(.201,.025),l(.568,.054),l(.132,.181),l(.278,-.037),l(-.005,.169),l(.466,-.066),l(.061,-.066),l(.257,.024),l(.199,.181),l(-.099,.121),l(-.208,.024),l(-.224,.211),l(.55,.247),l(.296,.38),l(.318,.072),l(.22,-.187),l(.41,-.12),l(-.282,-.302),l(.003,-.145),l(.286,.024),l(.509,.193),l(.258,.121),l(.709,-.005),l(-.181,.283),l(.329,-.084),l(-.001,.253),l(.013,.221),l(.293,.013),l(.368,-.161),l(.311,.181),l(.802,.132),l(-.02,.249),l(.188,.208),l(.382,.096),l(.105,.331),l(-.071,-.012),l(-.065,.066),l(-.066,.04),l(-.105,-.026),L(442,89.998),l(-.119,.013),l(-.065,.04),l(-.132,.066),l(-.053,.079),l(-.118,.092),l(-.119,.053),l(-.132,.079),l(-.105,.013),l(-.118,.013),l(-.053,.092),l(-.026,.092),l(-.026,.132),l(-.053,.079),l(-.053,.105),l(-.145,.066),l(-.105,.04),l(-.092,-.026),l(-.079,.079),l(-.04,.092),l(-.053,.079),l(-.039,0),l(-.105,.026),l(-.066,.026),l(-.079,.053),l(-.118,.053),l(-.132,0),l(-.145,.04),l(-.093,.026),l(-.065,-.026),l(-.065,-.026),l(-.093,0),l(-.065,.026),l(-.158,0),l(-.132,-.053),l(-.092,-.053),l(-.093,.026),l(-.171,.053),l(-.026,.04),l(-.146,.119),l(-.092,.066),l(-.014,.131),l(-.065,.105),l(-.039,.044),l(-.055,-.095),l(-.545,-.2),l(-1.332,.181),l(-1.019,-.227),l(-1.374,-.341),l(-.746,.773),l(-.598,.163),l(-.483,-.099),l(-.354,-.129),l(-.145,-.014),
N(421.683,94.397),l(.368,.014),l(.164,-.137),l(.096,.11),l(.249,.007),l(.104,.137),l(.194,.048),l(-.011,.165),l(.26,.039),l(-.078,.195),l(.215,0),l(.452,-.343),l(-.032,-.274),l(.237,.041),l(.262,-.055),l(.493,.089),l(.093,.145),l(.059,.144),L(425.4,94.7),l(.377,-.103),l(.044,-.13),l(.319,-.014),l(.125,-.171),l(1.25,-.035),l(.092,-.178),l(.433,-.035),l(.195,.138),l(.564,-.062),l(.146,.117),l(-.049,.165),l(.441,.178),l(.082,-.055),l(.098,-.343),l(-.056,-.158),l(-.334,-.014),l(.197,-.295),l(-.538,-.571),l(.364,-.227),l(.968,-.295),l(.162,-.172),l(.039,-.337),l(.132,-.027),l(.437,.151),l(.682,-.26),l(.145,.014),l(.354,.129),l(.483,.099),l(.598,-.163),l(.746,-.773),l(1.374,.341),l(1.019,.227),l(1.332,-.181),l(.545,.2),l(.055,.095),l(.053,.093),l(-.097,.581),l(.155,.26),l(.761,.547),l(-.636,.291),l(-.019,.367),l(-.701,.054),l(-.164,-.134),l(-.325,0),l(-.223,.197),l(.452,.063),l(.136,.196),l(-.157,.206),l(-.409,.062),l(-.04,.375),l(.204,.188),l(-.154,.294),l(-.346,.299),l(-.693,.157),l(.082,.393),l(-.89,-.116),l(-.298,.196),l(-.85,-.08),l(-.566,.107),l(-.646,.5),l(-.287,-.152),l(-.612,.009),l(-.179,-.107),l(-1.04,-.065),l(-.478,-.112),l(-.894,-.082),l(-1.311,-.247),l(-.32,-.391),l(-.318,-.096),l(-.023,-.363),l(-.856,.227),l(-.301,-.103),l(-.445,.11),l(-.183,-.083),l(-.366,.096),l(-.329,.411),l(-.597,-.034),l(-.631,-.171),l(.029,-.171),l(-.215,-.117),l(-.579,.332),l(-.55,-.242),l(-.008,-.144),l(-.622,-.062),l(.09,-.192),l(-.214,-.288),l(.266,-.274),l(-.193,-.336),
N(431.763,171.063),l(-.067,.354),l(.091,.72),l(.108,.508),l(.225,.168),l(.562,.11),l(.144,.183),l(.077,.353),l(-.089,1.116),l(-.146,.227),l(-.274,.171),l(-.885,.217),l(-.291,.256),l(-.664,1.275),l(-.503,1.203),l(-.243,1.004),l(-.354,.129),l(-.369,.03),l(-.129,.354),l(-.146,1.229),l(-.192,.312),l(-.385,.045),l(-.257,.284),l(-.417,.836),l(-.944,2.223),l(-.304,.624),l(-.352,.496),l(-.368,.355),l(-.239,.114),l(-.145,-.056),l(-.722,-.97),l(-.145,-.14),l(-1.104,-.05),l(-.272,.03),l(-1.31,1.265),l(-.941,.839),l(-.495,.526),l(.02,.974),l(-.189,.552),l(-.376,.686),l(-.188,-.119),l(-.224,-.042),l(-.176,-.127),l(-.145,.212),l(.144,.296),l(-.063,.127),l(-.353,.198),l(-.56,.03),l(-.977,.101),l(-.607,-.267),l(-.288,.043),l(-.271,.368),l(-.177,.113),l(-.432,-.07),l(-1.247,-.011),l(-.528,-.225),l(-.543,-.451),l(-.416,-.72),l(-.192,-.649),l(.048,-.254),l(.208,-.254),l(-.144,-.296),l(-.513,-.069),l(-.128,-.254),l(-.464,-.55),l(-.561,-.465),l(-.608,-.253),l(-.641,-.253),l(-.272,-.31),l(-.513,.072),l(-.24,.297),l(-.336,.071),l(-.881,.044),l(-.659,.03),l(-.006,-.234),l(.121,-1.188),l(-.217,-1.439),l(.09,-.989),l(.012,-.876),l(-.003,-.48),l(-.002,-.381),l(.237,-.397),l(.257,-.03),l(.433,-.13),l(.078,-.368),l(-.116,-.592),l(.095,-.34),l(.656,-.414),l(.223,-.298),l(.19,-.566),l(.316,-.962),l(-.388,-.718),l(-.164,-.762),l(.062,-.777),l(.092,-.961),l(.158,-.849),l(.353,-.482),l(.687,-1.614),l(.676,-.4),l(1.064,-.188),l(1.174,-.108),l(1.111,.121),l(.821,.277),l(1.095,1.223),l(.209,.098),l(.37,-.002),l(1.337,-.544),l(.467,-.116),l(.354,.083),l(1.173,.742),l(.965,.277),l(.934,-.005),l(.273,-.059),l(.629,-.399),l(.403,-.327),l(.774,-.287),l(.628,-.103),l(.709,-.047),l(.531,.04),l(.884,.221),l(.724,.193),l(.609,.208),l(.259,-.058),l(.761,-.697),l(.453,-.299),l(.437,-.2),l(.951,-.034),l(.173,.394),l(.575,.52),l(.351,.407),
N(425.506,195.522),l(-1.965,-.017),l(-1.005,.007),l(.029,-.176),l(-.208,-.536),l(.271,-.989),l(-.159,-.72),l(-.191,-.522),l(-.399,-.649),l(.433,-.396),l(-.287,-.367),l(-.24,-.056),l(-.576,.058),l(-.559,-.268),l(-.176,-.324),l(-.063,-.537),l(-.111,-.211),l(-.527,-.14),l(-.101,-.064),l(.376,-.686),l(.189,-.552),l(-.02,-.974),l(.495,-.526),l(.941,-.839),l(1.31,-1.265),l(.272,-.03),l(1.104,.05),l(.145,.14),l(.722,.97),l(.145,.056),l(.239,-.114),l(.368,-.355),l(.352,-.496),l(.304,-.624),l(.944,-2.223),l(.417,-.836),l(.257,-.284),l(.385,-.045),l(.192,-.312),l(.146,-1.229),l(.129,-.354),l(.369,-.03),l(.354,-.129),l(.243,-1.004),l(.503,-1.203),l(.664,-1.275),l(.291,-.256),l(.885,-.217),l(.274,-.171),l(.146,-.227),l(.089,-1.116),l(-.077,-.353),l(-.144,-.183),l(-.562,-.11),l(-.225,-.168),l(-.108,-.508),l(-.091,-.72),l(.067,-.354),l(.627,.109),l(.208,.083),l(.923,1.238),l(.395,.887),l(.119,1.2),l(-.134,.651),l(.169,1.228),l(.205,.578),l(.381,.633),l(.208,.21),l(.047,.127),l(-.225,.143),l(-.674,.032),l(-1.187,-.191),l(-.481,-.082),l(-.24,.1),l(-.29,.312),l(-.323,.539),l(1.088,1.067),l(1.343,1.179),l(.638,1.07),l(.382,1.057),l(.208,.183),l(-.208,.114),l(-.354,.327),l(-.866,1.743),l(-.4,.511),l(-.528,.399),l(-.144,.198),l(-.064,.424),l(.112,.776),l(.273,1.185),l(.207,.592),l(.4,.661),l(.432,.605),l(.064,.791),l(.112,.324),l(1.217,1.236),l(.498,.802),l(.194,.804),l(.209,.451),l(-.159,.185),l(.1,.861),l(-.271,.086),l(-.863,-.292),l(-.864,-.334),l(-.576,-.194),l(-.56,-.124),l(-.479,-.04),l(-.271,-.055),l(-.878,.076),l(-.863,-.023),l(-.56,-.109),l(-1.022,-.149),l(-.831,-.038),l(-1.773,-.088),l(-.88,-.093),l(-.045,.495),
N(551.793,147.278),l(-.788,-.111),l(-.458,-.253),l(-.379,-.367),l(-.248,-1.101),l(-.112,-.141),l(-.342,-.141),l(-.662,-.083),l(-.105,-.07),l(-.014,-.268),l(.116,-.466),l(-.178,-.451),l(-.418,-.38),l(-.294,-.013),l(-1.181,.412),l(-1.229,.087),l(-.81,.143),l(-.947,.073),l(-.415,-.083),l(-.263,-.226),l(-.135,-.197),l(-.909,.143),l(-.548,.382),l(-.856,.016),l(-1.264,-.011),l(-.691,.128),l(-.723,.115),l(-.541,.03),l(.182,-.954),l(.049,-.354),l(.31,-.792),l(.285,-.383),l(.794,-.47),l(.697,-.258),l(1,-.077),l(.209,-.072),l(.188,-.255),l(.036,-.974),l(-.186,-.281),l(-.652,-.053),l(-.185,-.394),l(-.111,-1.34),l(-.168,-.38),l(-.409,-.224),l(-1.144,-.388),l(-.695,-.391),l(-.353,-.464),l(-.71,-1.068),l(-.802,-1.083),l(.887,.32),l(.63,.194),l(1.069,.248),l(.854,.235),l(.541,.039),l(.742,.024),l(1.187,-.218),l(.349,-.002),l(1.005,.135),l(1.234,-.12),l(.964,-.175),l(1.183,-.19),l(1.066,-.274),l(.247,-.156),l(.069,-.184),l(.099,-.903),l(.232,-.876),l(.188,-.34),l(.412,-.369),l(.597,-.441),l(.283,-.072),l(.644,.039),l(.516,.082),l(.254,-.086),l(.321,-.693),l(.362,-.271),l(.559,-.243),l(.562,.025),l(1.001,.375),l(.237,-.086),l(.34,-.383),l(.021,-.084),l(.139,-1.214),l(.288,-.834),l(.224,-.424),l(.292,-.228),l(.416,-.115),l(.513,-.031),l(.315,-.115),l(.199,-.255),l(-.088,-.437),l(-.129,-.281),L(556.193,125),l(-.35,-.336),l(.355,-.129),l(.997,.122),l(.698,.039),l(.513,-.215),l(.289,-.255),l(-.033,-.31),l(-.223,-.478),l(.13,-.283),l(.4,-.341),l(.524,-.355),l(.324,-.426),l(-.198,-.477),l(.119,-.483),l(-.232,-.171),l(-.01,-.336),l(-.411,-.271),l(-.01,-.32),l(.464,-.413),l(.258,-.214),l(.246,.023),l(.559,-.395),l(.272,-.19),l(.53,-.292),l(1.148,-.152),l(1.345,-.012),l(.647,.144),l(.338,-.179),l(.332,.005),l(.455,-.297),l(.358,-.004),l(.148,-.142),l(.313,.14),l(.105,.112),l(.281,-.21),l(.296,.047),l(.554,.117),l(.004,.456),l(.282,-.128),l(.625,-.009),l(.373,.323),l(.213,.247),l(.007,.501),l(-.312,.516),l(.301,.07),l(.198,.218),l(.252,.281),l(.52,-.196),l(.239,0),l(.104,.199),l(.178,.09),l(.565,.436),l(1.337,.104),l(.305,.111),l(.147,.126),l(-.207,.084),l(-.688,.37),l(-.411,.232),l(-.155,.43),l(-.071,.479),l(-.234,.116),l(-.125,-.179),l(-.621,-.102),l(-.438,.132),l(-.271,.298),l(-.262,-.116),l(-.557,.265),l(-.928,-.149),l(-.568,-.138),l(-1.708,-.325),l(-.894,.265),l(-.38,.611),l(.09,.166),l(.336,0),l(.047,.314),l(-.202,.149),l(.101,.199),l(.598,-.017),l(-.002,.347),l(-.384,.099),l(-.139,.413),l(.389,.232),l(-.116,.479),l(-.215,.132),l(.089,.248),l(.606,.298),l(-.003,.532),l(.782,-.003),l(-.039,.43),l(.188,.248),l(.702,-.05),l(.668,.377),l(.012,.211),l(-.2,.255),l(-.504,.2),l(-.643,.196),l(-.517,.248),l(.032,.366),l(.188,.377),l(-.237,.977),l(-1.512,1.503),l(.261,.38),l(-.358,.281),l(-.609,.133),l(-.353,.467),l(-.509,1.216),l(-.478,.547),l(-1.193,.496),l(-.177,.364),l(-.277,.481),l(-.563,.61),l(-.076,.38),l(-.71,.259),l(-.734,-.011),l(-.895,.314),l(-.361,-.094),l(-.158,-.518),l(-.207,-.132),l(-.404,.083),l(-.535,.463),l(-.144,.446),l(-.979,.893),l(-.186,.543),l(-.079,.269),l(.116,.38),l(.541,.163),l(.504,.085),l(.425,.014),l(-.114,.689),l(-.154,.735),l(.412,.411),l(.33,.099),l(.537,-.099),l(.112,.441),l(.216,.507),l(.654,1.333),l(-.232,.149),l(.241,.463),l(-.317,.066),l(-.15,.248),l(-.55,.083),l(-.145,-.335),l(-.183,-.062),l(-.78,.215),l(-.2,.331),l(-.735,-.099),l(-.229,-.149),l(-.835,-.021),l(-.835,-.009),l(-.259,-.052),l(.015,.728),l(-.866,.017),l(-.296,.431),l(-.37,.036),
N(606.155,150.953),l(-.037,-.466),l(-.627,-2.479),l(-.064,-.578),l(-.4,.044),l(-.281,.115),l(-.395,1.159),l(-.224,.354),l(-.529,-.448),l(-.249,-.267),l(-.23,-.281),l(-.001,-.381),l(-.009,-.522),l(.131,-.283),l(.651,-.356),l(.498,-.13),l(.938,-.767),l(.159,-.34),l(.012,-.79),l(-.057,-.127),l(-.111,-.098),l(-2.473,-.198),l(-.559,.003),l(-.916,.062),l(-.547,-.053),l(-.537,-.109),l(-.095,-.099),l(-.079,-.719),l(-.053,-.479),l(-.129,-.324),l(-.417,-.054),l(-.489,.06),l(-.372,-.266),l(-.339,-.266),l(-1.252,-.303),l(-.234,.171),l(-.555,.525),l(-.124,.283),l(.083,.155),l(.494,.237),l(1.224,.938),l(.126,.112),l(-.047,.155),l(-.382,.101),l(-.502,.13),l(-.4,.299),l(-.548,.61),l(.339,.323),l(1.042,.431),l(.193,.21),l(-.029,.269),l(-.505,.765),l(.04,.254),l(.352,.45),l(.325,1.409),l(.402,1.775),l(.147,.532),l(-.172,.322),l(.068,.183),l(-.321,.071),l(-.35,-.056),l(-.148,-.706),l(-.198,-.084),l(-.253,.354),l(-.171,.354),l(-.172,.057),l(-.115,-.099),l(-.28,-.592),l(-.152,-.169),l(-.412,.537),l(-.504,.298),l(-.992,.397),l(-.571,.213),l(-.264,.226),l(-.05,.113),l(.106,.579),l(.183,.409),l(-.336,.495),l(-.305,.332),l(-.013,.257),l(-.548,.415),l(-.593,.467),l(-.467,.185),l(-.432,.057),l(-.746,.206),l(-.591,.362),l(-.459,.58),l(-.551,.552),l(-.88,1.061),l(-.611,.552),l(-.673,.276),l(-.675,.829),l(-.676,.467),l(-.728,.368),l(-.452,.241),l(-.427,.312),l(-.192,.509),l(-.073,.466),l(-.341,.41),l(-.649,.298),l(-.428,.058),l(-.506,-.098),l(-.258,.269),l(-.366,.887),l(-.277,.23),l(-.505,-.253),l(-.614,.142),l(-.354,.283),l(-.304,.565),l(-.165,.48),l(-.005,.508),l(.166,1.539),l(.018,.805),l(-.208,.495),l(.227,.324),l(.315,.423),l(-.015,.508),l(-.199,.607),l(-.669,1.611),l(-.341,.834),l(-.13,.636),l(.047,.649),l(.21,1.764),l(-.081,.24),l(-.643,.001),l(-.433,-.013),l(-.186,.142),l(-.334,.961),l(-.324,.594),l(.025,.127),l(.493,.352),l(-.805,.327),l(-.306,.015),l(-.77,.284),l(-.295,.41),l(-.101,.692),l(-.157,.255),l(-.367,.283),l(-.526,.255),l(-.099,.057),l(-.066,.042),l(-.231,.156),l(-.145,0),l(-.174,-.056),l(-1.417,-1.451),l(-.092,-.395),l(-.276,-.522),l(-.34,-1.397),l(-.689,-1.792),l(-.94,-1.933),l(-.979,-1.508),l(-.554,-1.722),l(-.507,-1.792),l(-.738,-1.636),l(-.82,-1.42),l(-.424,-.737),l(-.598,-1.439),l(-.363,-1.157),l(-.767,-3.274),l(-.469,-2.695),l(-.157,-1.566),l(-.051,-.24),l(.232,-.565),l(.546,-.834),l(.007,-.311),l(-.404,-.281),l(-.367,-.437),l(-.113,-.635),l(-.108,-.917),l(.065,-.622),l(-.837,.03),l(-.19,.212),l(-.235,.424),l(.009,.183),l(.276,.254),l(.074,.183),l(-.073,.438),l(-.301,.438),l(-.503,.368),l(-.812,.369),l(-.504,.114),l(-.617,.255),l(-.377,.015),l(-.861,-.281),l(-.572,-.38),l(-1.018,-1),l(-1.391,-1.268),l(-.516,-.705),l(.267,-.043),l(1.062,.125),l(.615,-.086),l(.443,-.142),l(.461,-.283),l(.521,-.608),l(-.067,-.24),l(-.156,.071),l(-.587,.114),l(-.847,-.026),l(-.607,-.112),l(-.632,-.132),l(-.5,-.218),l(-.203,-.07),l(-.929,-.661),l(-.668,-.775),l(-.057,-.197),l(.37,-.036),l(.296,-.431),l(.866,-.017),l(-.015,-.728),l(.259,.052),l(.835,.009),l(.835,.021),l(.229,.149),l(.735,.099),l(.2,-.331),l(.78,-.215),l(.183,.062),l(.145,.335),l(.55,-.083),l(.15,-.248),l(.317,-.066),l(-.241,-.463),l(.232,-.149),l(-.654,-1.333),l(-.216,-.507),l(-.112,-.441),L(557,143.058),l(-.33,-.099),l(-.412,-.411),l(.154,-.735),l(.114,-.689),l(-.425,-.014),l(-.504,-.085),l(-.541,-.163),l(-.116,-.38),l(.079,-.269),l(.186,-.543),l(.979,-.893),l(.144,-.446),l(.535,-.463),l(.404,-.083),l(.207,.132),l(.158,.518),l(.361,.094),l(.895,-.314),l(.734,.011),l(.71,-.259),l(.076,-.38),l(.563,-.61),l(.277,-.481),l(.177,-.364),l(1.193,-.496),l(.478,-.547),l(.509,-1.216),l(.353,-.467),l(.609,-.133),l(.358,-.281),l(-.261,-.38),l(1.512,-1.503),l(.237,-.977),l(-.188,-.377),l(-.032,-.366),l(.517,-.248),l(.643,-.196),l(.504,-.2),l(.2,-.255),l(-.012,-.211),l(-.668,-.377),l(-.702,.05),l(-.188,-.248),l(.039,-.43),l(-.782,.003),l(.003,-.532),l(-.606,-.298),l(-.089,-.248),l(.215,-.132),l(.116,-.479),l(-.389,-.232),l(.139,-.413),l(.384,-.099),l(.002,-.347),l(-.598,.017),l(-.101,-.199),l(.202,-.149),l(-.047,-.314),l(-.336,0),l(-.09,-.166),l(.38,-.611),l(.894,-.265),l(1.708,.325),l(.568,.138),l(.928,.149),l(.557,-.265),l(.262,.116),l(.271,-.298),l(.438,-.132),l(.621,.102),l(.125,.179),l(.234,-.116),l(.071,-.479),l(.155,-.43),l(.411,-.232),l(.688,-.37),l(.207,-.084),l(.502,-.152),l(0,.515),l(.441,1.03),l(.221,.515),l(.81,.11),l(.441,.405),l(.221,.258),l(-.331,.221),l(-.184,.184),l(.073,.589),l(.037,.552),l(.294,.221),l(.718,.096),l(.092,.078),l(.044,.182),l(.68,.099),l(-.104,.414),l(.367,.694),l(-.578,.364),l(-.376,.281),l(-.368,.049),l(-.337,-.264),l(-.033,-.364),l(-.785,.198),l(.157,.694),l(.579,.595),l(-.104,.446),l(.272,.364),l(-.215,.215),l(.099,.43),l(.198,.066),l(.477,-.314),l(.383,.248),l(.772,.843),l(.363,-.116),l(1.078,.579),l(-.116,.364),l(.756,.248),l(.154,-.066),l(.859,.596),l(-1.07,.909),l(-.281,.116),l(.008,.364),l(-.221,.265),l(.04,.396),l(-.309,.397),l(-.218,.43),l(.039,.248),l(.63,.38),l(.466,-.083),l(.665,.479),l(.704,.149),l(.305,.529),l(1.242,.678),l(.231,-.166),l(1.027,.595),l(.538,-.066),l(.182,.397),l(.835,.166),l(.304,.198),l(.15,-.066),l(.087,-.215),l(.503,0),l(.482,.265),l(.582,-.347),l(.494,.298),l(.643,.066),l(.142,.231),l(-.101,.446),l(.663,.149),l(.286,.281),l(.618,.265),l(.584,-.281),l(.313,.066),l(-.034,.331),l(.312,.248),l(.379,-.231),l(.721,.148),l(.847,.364),l(.606,-.297),l(.268,.364),l(.399,.116),l(.357,-.132),l(.271,.083),l(.687,-.132),l(.336,.05),l(.311,-.694),l(-.429,-.827),l(.07,-.876),l(.318,-.761),l(-.037,-.022),l(.345,-.129),l(.471,-.102),l(.231,.069),l(.139,.183),l(-.052,.861),l(.212,.662),l(-.092,.113),l(.235,.493),l(.637,.18),l(.559,.081),l(.869,.214),l(.085,.021),l(.544,-.074),l(.531,-.313),l(.301,.055),l(.335,.125),l(1.238,.063),l(1.036,-.062),l(.624,-.06),l(.217,-.58),l(-.017,-.282),l(-.258,-.238),l(-.313,-.069),l(-.326,-.294),l(-.042,-.24),l(.07,-.156),l(.189,-.1),l(.784,-.033),l(.714,-.216),l(.397,-.27),l(1.123,-1.107),l(.543,-.37),l(.829,-.258),l(1.105,-.726),l(.546,-.299),l(.355,-.087),l(.286,.167),l(.975,.319),l(.377,-.044),l(1.377,-.84),l(.455,.392),l(.716,.715),l(.046,.38),l(-.354,.454),l(-.138,.269),l(.102,.056),l(.3,.055),l(.657,.081),l(.73,.179),l(.624,.081),l(-.018,.508),l(-.112,.24),l(-.596,.582),l(-.072,.283),l(.184,.718),l(-.295,.058),l(-.853,-.221),l(-.558,-.082),l(-.312,.129),l(-.719,.512),l(-1.446,.883),l(-.197,.354),l(.057,.761),l(-.136,.382),l(-.938,1.134),l(-.045,.212),l(.192,.408),l(0,.324),l(-1.148,2.25),l(-.17,.128),l(-.309,-.013),l(-.391,-.11),l(-.811,-.32),l(-.133,.283),l(.146,1.594),l(-.191,.354),l(-.401,.144),l(-.228,.185),l(.152,.93),l(-.015,.678),l(-.273,.368),l(-.25,.129),l(-.255,-.14),l(-.595,-.152),
N(478.516,135.173),l(.052,-.292),l(-.049,-.169),l(-.197,-.107),l(.107,-.175),l(.292,-.919),l(-.015,-.818),l(.517,-1.09),l(.3,-.891),l(-.004,-.409),l(.133,-.283),l(.07,-.749),l(.033,-.847),l(.062,-.174),l(.026,-.278),l(-.065,-.411),l(.037,-.119),l(.102,-.063),l(1.902,1.034),l(.365,.167),l(.253,-.016),l(1.139,-.656),l(2.96,-1.541),l(.161,-.071),l(.87,1.632),l(.311,.69),l(.093,.056),l(-.46,.44),l(-.257,.171),l(-.97,.26),l(-2.586,.622),l(-.646,.229),l(1.146,1.32),l(.698,.885),l(-.765,.724),l(-.456,.37),l(-.24,.072),l(-1.249,.332),l(-.462,.61),l(-.975,.782),l(-2.079,-.299),l(-.154,-.017),
N(456.028,151.46),l(-.021,1.003),l(.033,3.078),l(-.088,.17),l(-1.561,-.019),l(-.52,-.011),l(-.073,1.13),l(-1.981,-.963),l(-5.577,-2.792),l(-4.941,-2.372),l(-5.231,-2.554),l(-.41,.059),l(-1.818,.858),l(-1.519,.729),l(-.231,.157),l(-1.192,-.911),l(-.258,-.182),l(-1.008,-.333),l(-1.646,-.442),l(-.832,-.137),l(-.098,-.07),l(-.86,-1.506),l(-.178,-.168),l(-1.028,-.347),l(-.702,-.165),l(-.544,.201),l(-.244,-.154),l(-.562,-.873),l(-.249,-.917),l(-1.272,-1.702),l(.152,-.283),l(.249,-.128),l(.666,-.47),l(.086,-.17),l(.061,-.664),l(-.457,-1.156),l(.158,-.495),l(.16,-.622),l(-.101,-.748),l(.1,-.862),l(-.052,-.691),l(-.147,-.833),l(-.88,-1.605),l(.241,-.383),l(.204,-.156),l(.22,-.143),l(.864,-.598),l(.155,-.227),l(.147,-.537),l(-.274,-.973),l(.126,-.354),l(1.473,-1.138),l(.579,-.314),l(.802,-.428),l(.093,-.269),l(-.064,-.564),l(.093,-.981),l(1.436,.59),l(.995,.309),l(.521,.013),l(.863,-.129),l(.604,.027),l(1.552,.223),l(.614,.479),l(.794,.224),l(.486,-.001),l(.342,.197),l(.173,.226),l(.26,.819),l(.39,.564),l(.688,.591),l(.378,.126),l(.678,.14),l(1.031,.083),l(.447,.07),l(.973,.224),l(.639,.224),l(.552,.281),l(1.289,.788),l(.84,.464),l(.465,.013),l(.441,-.128),l(.758,-.411),l(.706,-.623),l(.3,-.523),l(0,-.254),l(-.276,-.621),l(-.112,-.579),l(.044,-.41),l(.237,-.537),l(.661,-.58),l(.333,-.198),l(.554,-.241),l(.644,-.298),l(1.376,-.413),l(1.205,.054),l(.728,.154),l(.844,.365),l(.188,.169),l(.043,.508),l(.281,.253),l(.301,.014),l(.945,.125),l(.712,.309),l(.45,.027),l(1.286,.04),l(.302,.197),l(.068,.381),l(.276,.296),l(-.099,.208),l(-.369,.228),l(-.21,.34),l(.354,1.283),l(-.231,.425),l(-.322,.553),l(-.056,.311),l(.185,.945),l(.388,.916),l(.042,.367),l(-.015,.988),l(-.019,3.869),l(-.016,1.468),l(-.008,2.048),l(-.001,.692),l(.045,2.81),l(-.021,1.342),l(.011,2.612),
N(478.212,134.714),l(-.834,-1.746),l(-.796,-1.944),l(-.124,-.289),l(.109,-.066),l(.679,-.851),l(.219,-.438),l(.183,-.507),l(.171,-.566),l(.188,-.822),l(.116,.018),l(.137,-.093),l(.006,-.204),l(.028,-.315),l(.372,-.051),l(.151,.022),l(.07,.099),l(.355,-.07),l(.009,-.167),l(.067,-.193),l(.088,-.041),l(.07,.023),l(.183,.346),l(.201,.128),l(.021,.183),l(-.047,.122),l(.082,.085),l(-.102,.063),l(-.037,.119),l(.065,.411),l(-.026,.278),l(-.062,.174),l(-.033,.847),l(-.07,.749),l(-.133,.283),l(.004,.409),l(-.3,.891),l(-.517,1.09),l(.015,.818),l(-.292,.919),l(-.107,.175),l(-.067,.068),l(-.042,.042),
N(495.751,163.817),l(-.03,-.184),l(-.112,-.537),l(-.508,-.945),l(-.73,-.987),l(-.438,-.493),l(-.846,-.69),l(-.51,-.875),l(-.814,-1.876),l(-.474,-.889),l(-.28,-.409),l(-.794,-.507),l(-1.271,-.689),l(-.527,-.634),l(-.8,-1.17),l(-.081,-.96),l(-.061,-.776),l(-.002,-.89),l(-.104,-.381),l(-.312,-.663),l(-.944,-1.65),l(-.357,-.494),l(-.758,-.62),l(-.459,-.225),l(-.499,-.126),l(-.308,-.282),l(-.483,-.578),l(.149,-.692),l(-.111,-.437),l(-.474,-.818),l(-.747,-1.072),l(-.793,-.902),l(-1.069,-1.494),l(-.525,-.931),l(-.352,-.479),l(-.722,-.761),l(-.524,-.056),l(-.248,0),l(.077,-.296),l(.193,-.283),l(.311,-1.314),l(.104,-.583),l(.154,.017),l(2.079,.299),l(.975,-.782),l(.462,-.61),l(1.249,-.332),l(.24,-.072),l(.456,-.37),l(.765,-.724),l(-.698,-.885),l(-1.146,-1.32),l(.646,-.229),l(2.586,-.622),l(.97,-.26),l(.257,-.171),l(.46,-.44),l(.093,.056),l(1.129,.459),l(.757,.222),l(2.034,.934),l(1.14,.473),l(2.44,1.101),l(.258,.196),l(.399,.633),l(.141,.07),l(.973,-.048),l(.135,.366),l(-.118,.396),l(.047,.818),l(.118,.253),l(.812,.277),l(1.557,.697),l(4.048,.132),l(1.657,.259),l(.408,.054),l(.334,.619),l(.185,.239),l(1.07,.05),l(.644,-.044),l(.043,.121),l(.277,.648),l(.365,.494),l(.178,.663),l(.052,.113),l(.615,-.029),l(.248,.126),l(-.204,.237),l(.194,.187),l(.184,.282),l(.234,.067),l(.234,.27),l(.886,.168),l(.423,.437),l(-.07,.28),l(-.235,.035),l(-.111,.25),l(.316,.381),l(-.188,.593),l(-.122,.198),l(.165,.268),l(.302,.666),l(.149,-.117),l(.372,.282),l(.105,.616),l(.422,.696),l(-.028,.423),l(.222,.268),l(.16,.197),l(.287,.084),l(.136,-.007),l(.336,.083),l(1.043,2.198),l(.548,1.154),l(.261,.902),l(3.362,.375),l(3.387,.446),l(.839,.108),l(.584,-.469),l(.152,-.057),l(.581,.914),l(.155,1.453),l(-5.346,2.982),l(-2.35,1.213),l(-1.691,.815),l(-.169,.085),l(-1.148,.346),l(-3.097,1.035),l(-4.618,1.566),l(-.484,.229),l(-.041,.127),l(-.383,.397),l(-1.907,2.271),l(-2.042,2.667),l(-1.302,-2.703),l(-1.211,-2.45),l(-.452,-.012),l(-.715,.047),l(-.446,-.125),l(-.671,-.151),l(-.216,.1),l(-.174,.185),l(-.11,.495),l(.041,.678),l(-.113,.565),l(-.692,.563),
N(476.458,130.735),l(.124,.289),l(.796,1.944),l(.834,1.746),l(-.38,.381),l(-.479,1.145),l(-.334,1.413),l(-.171,.593),l(-.18,.156),l(-.407,-.07),l(-.448,-.521),l(-.782,-.676),l(-.386,-.494),l(-.338,-.988),l(-.521,-.45),l(-.289,-.621),l(-.17,-.479),l(-.198,-.353),l(-.466,.17),l(-.267,.523),l(.604,1.34),l(.131,.381),l(.634,.86),l(.933,1.042),l(.473,1.199),l(.526,.973),l(.277,.818),l(.391,.465),l(.912,1.735),l(1.072,1.904),l(.428,.705),l(.586,.549),l(.451,.352),l(.151,.183),l(-.241,.17),l(-.285,.1),l(-.043,.155),l(.238,1.087),l(.252,.467),l(.127,.238),l(.812,.591),l(.397,.168),l(.406,.521),l(.416,.38),l(.311,.56),l(-10.382,-.006),l(-2.138,-.001),l(-2.774,.002),l(-2.513,.015),l(-2.268,-.029),l(-1.664,.01),l(-1.241,.007),l(-1.614,-.019),l(-.914,.005),l(-.819,.089),l(-.011,-2.612),l(.021,-1.342),l(-.045,-2.81),l(.001,-.692),l(.008,-2.048),l(.016,-1.468),l(.019,-3.869),l(.015,-.988),l(-.042,-.367),l(-.388,-.916),l(-.185,-.945),l(.056,-.311),l(.322,-.553),l(.231,-.425),l(-.354,-1.283),l(.21,-.34),l(.369,-.228),l(.099,-.208),l(.337,.168),l(.553,-.015),l(.628,-.1),l(.786,-.001),l(1.513,.293),l(.587,.115),l(.779,.122),l(.721,.154),l(.348,.409),l(.4,0),l(.928,.083),l(.998,.394),l(.628,.069),l(.245,-.127),l(.72,-.538),l(.925,-.397),l(.837,-.186),l(.78,-.27),l(.375,-.072),l(.346,.056),l(.535,-.001),l(.723,.126),l(.202,.465),l(.596,.366),l(.518,-.156),l(.64,.267),l(.382,.027),l(.561,-.401),l(.241,.179),l(.277,.056),l(.674,.13),l(.338,-.062),l(.46,-.165),l(.51,-.308),
N(580.625,132.873),l(.24,.43),l(.299,.05),l(.276,-.314),l(.134,-.513),l(.275,.066),l(.186,-.182),l(1.079,.199),l(.132,.612),l(.867,.264),l(.726,.595),l(.472,.215),l(.15,-.132),l(.454,.281),l(.657,.794),l(.158,-.166),l(.71,-.116),l(.289,.166),l(.178,.38),l(-.069,.281),l(1.451,.893),l(.333,-.248),l(.326,.017),l(-.175,.396),l(.014,.265),l(.935,.066),l(.365,-.066),l(.54,.496),l(.141,.463),l(.237,-.099),l(-.01,-.364),l(.685,.38),l(.271,-.083),l(.08,-.331),l(.407,0),l(.63,.281),l(.319,.364),l(.849,-.066),l(.341,.116),l(.339,-.281),l(.655,.159),l(.037,.022),l(-.318,.761),l(-.07,.876),l(.429,.827),l(-.311,.694),l(-.336,-.05),l(-.687,.132),l(-.271,-.083),l(-.357,.132),l(-.399,-.116),l(-.268,-.364),l(-.606,.297),l(-.847,-.364),l(-.721,-.148),l(-.379,.231),l(-.312,-.248),l(.034,-.331),l(-.313,-.066),l(-.584,.281),l(-.618,-.265),l(-.286,-.281),l(-.663,-.149),l(.101,-.446),l(-.142,-.231),l(-.643,-.066),l(-.494,-.298),l(-.582,.347),l(-.482,-.265),l(-.503,0),l(-.087,.215),l(-.15,.066),l(-.304,-.198),l(-.835,-.166),l(-.182,-.397),l(-.538,.066),l(-1.027,-.595),l(-.231,.166),l(-1.242,-.678),l(-.305,-.529),l(-.704,-.149),l(-.665,-.479),l(-.466,.083),l(-.63,-.38),l(-.039,-.248),l(.218,-.43),l(.309,-.397),l(-.04,-.396),l(.221,-.265),l(-.008,-.364),l(.281,-.116),l(1.07,-.909),
N(374.125,167.166),l(-1.41,-.924),l(-.661,-.604),l(-.537,-.788),l(-.292,-.662),l(-.15,-.183),l(-.312,-.154),l(-.567,-.053),l(-.655,-.307),l(-.695,-.561),l(-.604,-.194),l(-.567,-.025),l(-1.209,.12),l(-1.821,.194),l(-.523,.417),l(.06,-.502),l(.563,-1.301),l(.188,-.819),l(.13,-1.13),l(-.162,-1.101),l(-.3,-.791),l(-.624,-.747),l(.267,-.283),l(.182,-.424),l(.067,-.975),l(-.065,-.537),l(-.174,-.353),l(-.808,-.817),l(-.297,-.112),l(-.393,.438),l(-.055,-.197),l(-.013,-.381),l(.08,-.689),l(.474,.013),l(5.055,.056),l(2.396,.014),l(.732,-.033),l(.212,.027),l(-.051,-1.102),l(-.164,-1.539),l(.01,-.707),l(.249,-.383),l(.575,-.427),l(.726,-.315),l(.809,-.287),l(.144,-.128),l(.099,-2.6),l(.07,-2.261),l(.047,-.509),l(.557,-.074),l(6.005,.022),l(.56,.011),l(.104,-.396),l(-.002,-.65),l(.03,-1.752),l(2.829,1.509),l(4.12,2.42),l(1.414,.91),l(-.523,.13),l(-3.231,.089),l(.049,.776),l(.908,7.962),l(.19,1.468),l(.178,1.736),l(.325,2.753),l(.202,2.386),l(.186,1.468),l(.724,.787),l(-.379,1.613),l(-6.457,.01),l(-1.953,.026),l(-.945,.344),l(-.387,.031),l(-.485,-.054),l(-.713,-.137),l(-.535,-.124),l(-.06,.212),l(.055,.296),l(-.107,.269),l(-.454,-.082),l(-.214,-.168),l(-.568,-.83),l(-.261,-.111),l(-.402,.073),l(-.252,.256),l(-.181,.552),l(-.018,.607),l(-.332,.284),
N(476.114,191.139),l(-.563,.54),l(-.626,.314),l(-.367,.016),l(-.303,-.196),l(-.303,-.097),l(-.88,.132),l(-.881,.33),l(-.911,.048),l(-.942,-.234),l(-.495,-.011),l(-.464,.087),l(-.496,.229),l(-1.288,-1.32),l(-1.032,-.926),l(-.207,-.083),l(-.258,.157),l(-.436,.582),l(-.16,.1),l(-.684,-.631),l(-.384,-.012),l(-.529,.37),l(-.258,.242),l(-.352,.016),l(-.366,-.195),l(-.525,-.477),l(-.348,-.493),l(-.795,-.772),l(-.143,-.239),l(-.031,-.07),l(.083,-.679),l(-.157,-.352),l(-.558,-.477),l(-.814,-.165),l(-.367,-.224),l(-.285,-.436),l(-.059,-.72),l(-.206,-.366),l(-.207,-.168),l(-.717,-.434),l(-.558,-.378),l(-.445,-.351),l(-.173,-.395),l(.148,-.481),l(-.223,-.267),l(-.351,-.196),l(-.799,-.235),l(-.797,-.447),l(-.223,-.225),l(-.252,-.493),l(-.207,-.126),l(-.272,.001),l(-.802,.019),l(-.158,-.211),l(-.01,-.664),l(.416,-1.472),l(-.122,-.536),l(-.347,-.549),l(-1.342,-1.673),l(.15,-.425),l(-.026,-.367),l(-.266,-.465),l(-.444,-.407),l(-.155,-.295),l(-.137,-.522),l(-.221,-1.228),l(-.141,-.225),l(-.338,-.012),l(-.517,.088),l(-.219,-.352),l(.316,-.609),l(.542,-.596),l(.087,-.34),l(-.342,-.662),l(.053,-.24),l(.718,-.428),l(.149,-.212),l(-.131,-.677),l(.122,-.438),l(.583,-.809),l(.417,-1.245),l(.229,-.143),l(1.245,-.05),l(.839,.009),l(.04,-.283),l(-.031,-1.229),l(-.036,-1.002),l(.038,-.749),l(-.085,-2.5),l(.036,-.636),l(.016,-.946),l(.02,-1.045),l(.073,-1.13),l(.52,.011),l(1.561,.019),l(.088,-.17),l(-.033,-3.078),l(.021,-1.003),l(.819,-.089),l(.914,-.005),l(1.614,.019),l(1.241,-.007),l(1.664,-.01),l(2.268,.029),l(2.513,-.015),l(2.774,-.002),l(2.138,.001),l(10.382,.006),l(.229,.414),l(.499,1.115),l(.281,3.501),l(.319,1.637),l(.182,.211),l(.625,.394),l(.595,.366),l(.617,.507),l(.491,.197),l(.254,.223),l(-.238,.199),l(-.277,.327),l(-.306,.566),l(-.369,.242),l(-.511,.172),l(-.427,.116),l(-.153,.142),l(-.235,.496),l(-.348,.171),l(-.73,.033),l(-.204,.552),l(-.038,.452),l(-.202,.862),l(-.242,.722),l(-.541,1.302),l(-.068,.495),l(.092,.903),l(-.013,.679),l(-.001,.083),l(-.148,.947),l(-.398,1.231),l(-.214,1.061),l(-1.04,.331),l(-.414,.37),l(-.693,1.134),l(-.154,.34),l(-.191,1.088),l(-.141,1.074),l(-.197,.185),l(-.274,.044),l(-.431,-.096),l(-.259,.072),l(-.163,.114),l(-.187,1.103),l(-.115,.933),l(-.2,1.272),l(.039,.522),l(-.229,1.159),l(-.469,.299),l(-.288,-.012),l(-.928,-.122),l(-.321,.03),l(-.188,.806),l(-.054,.466),l(.094,.141),l(.479,.11),l(.734,.123),l(.334,.167),l(.805,.913),l(1.06,1.067),l(.751,1.464),l(.345,.732),l(.348,.421),l(.462,.28),l(.415,.097),l(.269,.309),l(.117,.988),l(-.034,.17),l(-.018,.141),l(-.079,-.028),l(-.464,.017),l(-1.009,.133),l(-.832,.005),l(-.671,-.052),l(-.291,.327),l(-.678,.795),
N(518.402,163.079),l(-.282,.097),l(-.538,.27),l(-.656,.566),l(-.265,.297),l(-.166,.508),l(-.062,.41),l(-.41,.326),l(-1.418,.652),l(-2.27,.641),l(-1.285,.412),l(-.843,.312),l(-.356,.297),l(-.473,.622),l(-.436,.269),l(-.506,.114),l(-.593,-.069),l(-.521,.072),l(-.83,.439),l(-.65,.396),l(-.956,.397),l(-.752,.199),l(-1.16,.003),l(-.562,-.013),l(-.297,.128),l(-.386,.312),l(-.272,.297),l(-.45,.312),l(-.511,.241),l(-.389,.043),l(-.239,-.042),l(-.535,.411),l(-.839,.058),l(-.494,-.112),l(-.623,-.437),l(-.17,-.155),l(-.317,-.437),l(-.084,-.254),l(.18,-.721),l(-.081,-.635),l(-.312,-.507),l(-.341,-1.171),l(-.572,-1.919),l(-.072,-.438),l(.268,-.707),l(-.124,-.748),l(.692,-.563),l(.113,-.565),l(-.041,-.678),l(.11,-.495),l(.174,-.185),l(.216,-.1),l(.671,.151),l(.446,.125),l(.715,-.047),l(.452,.012),l(1.211,2.45),l(1.302,2.703),l(2.042,-2.667),l(1.907,-2.271),l(.383,-.397),l(.041,-.127),l(.484,-.229),l(4.618,-1.566),l(3.097,-1.035),l(1.148,-.346),l(.169,-.085),l(.092,.663),l(.226,.634),l(.604,.971),l(.933,1.364),l(.127,.253),l(-.006,.296),l(.483,.689),l(.241,.306),
N(494.64,172.627),l(-.261,-.166),l(-.476,-.633),l(-.475,-.159),l(-.437,-.911),l(-1.267,-.792),l(-.277,-.594),l(-.673,-.673),l(-.594,-.119),l(-.871,-.554),l(-.555,.079),l(-.158,-.158),l(-.237,.04),l(-.277,-.198),l(-.356,.159),l(-.476,.079),l(-.277,-.436),l(-.158,.237),l(-.436,.198),l(-.792,.079),l(-.554,-.594),l(-.238,0),l(-.396,-.317),l(-.832,1.663),l(-.436,-.871),l(-.475,.079),l(-.277,.356),l(-.396,-.08),l(-.349,.041),l(.013,-.679),l(-.092,-.903),l(.068,-.495),l(.541,-1.302),l(.242,-.722),l(.202,-.862),l(.038,-.452),l(.204,-.552),l(.73,-.033),l(.348,-.171),l(.235,-.496),l(.153,-.142),l(.427,-.116),l(.511,-.172),l(.369,-.242),l(.306,-.566),l(.277,-.327),l(.238,-.199),l(.098,.129),l(.718,2.102),l(.442,1.623),l(.689,1.919),l(.618,.832),l(.205,-.212),l(-.072,-.479),l(.093,-.226),l(.31,.253),l(.4,.677),l(.384,.395),l(.534,-.043),l(.242,.014),l(1.338,1.282),l(.809,.916),l(.124,.099),l(.706,.055),l(.618,.874),l(.021,.24),l(-.025,.198),l(.118,.212),l(.507,.182),l(.915,.869),l(-.075,.094),l(-.529,.78),l(-.331,-.182),l(-.396,-.125),l(-.214,.114),l(-.055,.085),
N(370.147,172.035),l(-2.301,-.043),l(-1.045,.006),l(-.505,.384),l(-.51,.187),l(-.74,-.024),l(-.819,.047),l(-.463,.139),l(-.009,-.003),l(-.278,-.226),l(-.169,-.409),l(.104,-.424),l(-.095,-.55),l(-.018,-.198),l(.001,-.046),l(1.695,.014),l(0,-.434),l(.155,0),l(.341,-.016),l(.186,-.077),l(.248,.062),l(.294,-.046),l(.124,-.093),l(.016,-.263),l(.077,-.078),l(.14,-.016),l(.155,.155),l(.232,.124),l(.356,.108),l(.046,.108),l(.139,.047),l(.217,-.031),l(.263,.108),l(.186,.17),l(.434,0),l(.186,-.108),l(.263,-.108),l(.279,0),l(.108,-.124),l(.016,-.124),l(-.155,-.217),l(-.202,-.077),l(-.201,.031),l(-.294,.093),l(-.108,.093),l(-.248,.062),l(-.279,-.186),l(-.031,-.186),l(-.186,-.108),l(-.17,-.015),l(-.186,.124),l(-.139,-.108),l(-.108,-.217),l(-.155,-.108),l(-.201,.031),l(-.17,-.062),l(-.387,.17),l(-.108,-.108),l(-.155,.046),l(-.202,.124),l(-.093,.294),l(-1.664,0),l(-.007,-.067),l(-.028,-.269),l(-.377,-.268),l(-.068,-.155),l(-.057,-.367),l(-.386,-.635),l(-.399,-.494),l(-.379,-.31),l(-.472,-.183),l(.54,-.34),l(.723,-.75),l(.588,-1.004),l(.334,-.82),l(.099,-.826),l(.523,-.417),l(1.821,-.194),l(1.209,-.12),l(.567,.025),l(.604,.194),l(.695,.561),l(.655,.307),l(.567,.053),l(.312,.154),l(.15,.183),l(.292,.662),l(.537,.788),l(.661,.604),l(1.41,.924),l(-.506,.399),l(-.057,.339),l(.251,1.1),l(.144,.663),l(.22,.479),l(.181,.197),l(.554,.322),l(.265,.337),l(.082,.833),l(-.004,.565),l(-.062,.142),l(-.146,-.042),l(-.963,.091),l(-.658,.074),l(-.725,-.081),l(-.503,-.209),l(-.795,-.32),l(-1.255,-.021),
N(495.973,175.881),l(-.363,.807),l(.083,.409),l(.428,.732),l(.587,.844),l(.732,.801),l(.596,.547),l(.634,.321),l(.54,.209),l(4.26,1.443),l(1.447,.472),l(1.875,-.04),l(.236,.154),l(-4.087,4.205),l(-1.562,1.69),l(-.813,.909),l(-.8,.004),l(-1.693,-.046),l(-.626,.088),l(-.562,.215),l(-.388,.214),l(-.502,.497),l(-.294,.426),l(-.337,.115),l(-1.216,.078),l(-.305,.101),l(-.453,.511),l(-1.103,-.106),l(-.461,-.181),l(-.46,-.336),l(-.271,-.098),l(-.852,.358),l(-.675,.343),l(-.258,.199),l(-.71,.753),l(-.16,.114),l(-.847,-.094),l(-.67,-.193),l(-1.373,-.133),l(-.335,-.041),l(-2.353,-1.525),l(-.604,-.293),l(-.749,-.193),l(-1.054,-.149),l(-.319,-.069),l(.018,-.141),l(.034,-.17),l(-.117,-.988),l(-.269,-.309),l(-.415,-.097),l(-.462,-.28),l(-.348,-.421),l(-.345,-.732),l(-.751,-1.464),l(-1.06,-1.067),l(-.805,-.913),l(-.334,-.167),l(-.734,-.123),l(-.479,-.11),l(-.094,-.141),l(.054,-.466),l(.188,-.806),l(.321,-.03),l(.928,.122),l(.288,.012),l(.469,-.299),l(.229,-1.159),l(-.039,-.522),l(.2,-1.272),l(.115,-.933),l(.187,-1.103),l(.163,-.114),l(.259,-.072),l(.431,.096),l(.274,-.044),l(.197,-.185),l(.141,-1.074),l(.191,-1.088),l(.154,-.34),l(.693,-1.134),l(.414,-.37),l(1.04,-.331),l(.214,-1.061),l(.398,-1.231),l(.148,-.947),l(.001,-.083),l(.349,-.041),l(.396,.08),l(.277,-.356),l(.475,-.079),l(.436,.871),l(.832,-1.663),l(.396,.317),l(.238,0),l(.554,.594),l(.792,-.079),l(.436,-.198),l(.158,-.237),l(.277,.436),l(.476,-.079),l(.356,-.159),l(.277,.198),l(.237,-.04),l(.158,.158),l(.555,-.079),l(.871,.554),l(.594,.119),l(.673,.673),l(.277,.594),l(1.267,.792),l(.437,.911),l(.475,.159),l(.476,.633),l(.261,.166),l(-.594,.921),l(-.488,.61),l(-.105,.254),l(-.029,.396),l(.202,1.157),l(.5,-.074),l(.892,-.246),l(.4,.04),l(.556,.195),
N(364.011,169.929),l(1.664,0),l(.093,-.294),l(.202,-.124),l(.155,-.046),l(.108,.108),l(.387,-.17),l(.17,.062),l(.201,-.031),l(.155,.108),l(.108,.217),l(.139,.108),l(.186,-.124),l(.17,.015),l(.186,.108),l(.031,.186),l(.279,.186),l(.248,-.062),l(.108,-.093),l(.294,-.093),l(.201,-.031),l(.202,.077),l(.155,.217),l(-.016,.124),l(-.108,.124),l(-.279,0),l(-.263,.108),l(-.186,.108),l(-.434,0),l(-.186,-.17),l(-.263,-.108),l(-.217,.031),l(-.139,-.047),l(-.046,-.108),l(-.356,-.108),l(-.232,-.124),l(-.155,-.155),l(-.14,.016),l(-.077,.078),l(-.016,.263),l(-.124,.093),l(-.294,.046),l(-.248,-.062),l(-.186,.077),l(-.341,.016),l(-.155,0),l(0,.434),l(-1.695,-.014),l(.019,-.477),l(.173,-.198),l(.434,-.058),l(.093,-.155),l(-.006,-.059),
N(495.973,175.881),l(-.556,-.195),l(-.4,-.04),l(-.892,.246),l(-.5,.074),l(-.202,-1.157),l(.029,-.396),l(.105,-.254),l(.488,-.61),l(.594,-.921),l(.055,-.085),l(.214,-.114),l(.396,.125),l(.331,.182),l(.529,-.78),l(.075,-.094),l(.627,.596),l(.285,.465),l(.036,.282),l(-.118,.113),l(-.361,.185),l(-.438,.1),l(-.56,.312),l(-.566,.467),l(.253,.127),l(.645,-.058),l(.321,.013),l(.434,.124),l(-.114,.26),l(-.37,.468),l(-.34,.567),
N(363.763,172.732),l(.463,-.139),l(.819,-.047),l(.74,.024),l(.51,-.187),l(.505,-.384),l(1.045,-.006),l(2.301,.043),l(-.111,.792),l(.115,.847),l(-.186,.312),l(-.333,.186),l(-.513,.031),l(-.401,.017),l(-.381,.186),l(-.789,.64),l(-.321,.372),l(-.047,-.126),l(-.192,0),l(-.501,-.14),l(-.165,-.254),l(.121,-.41),l(.33,-.438),l(.253,-.212),l(-.131,-.141),l(-.372,-.112),l(-.498,.015),l(-.415,.17),l(-.161,0),l(-.616,-.281),l(-.36,-.296),l(-.069,-.24),l(-.323,-.084),l(-.316,-.137),
N(383.005,177.596),l(-.379,.397),l(-.264,.623),l(.214,.409),l(.695,.405),l(.197,.31),l(-.125,.283),l(-.332,.37),l(.309,.351),l(.648,.561),l(.051,.226),l(-.19,.143),l(-.304,-.012),l(-.548,-.223),l(-.304,.03),l(-.158,.199),l(-.03,.127),l(.296,.549),l(.179,.21),l(-.188,.354),l(-.602,.554),l(-.047,.099),l(-.339,-.224),l(-.337,-.097),l(-.143,.086),l(-.756,.922),l(-.321,-.026),l(-.404,-.322),l(-.277,-.323),l(.044,-.283),l(-.009,-.65),l(-.22,-.846),l(-.165,-.366),l(-.338,-.097),l(-.528,.046),l(-.367,.143),l(-.252,.242),l(-.193,.376),l(-.26,-.656),l(-.165,-1.369),l(-.252,-.761),l(-.475,-.619),l(-.456,-.421),l(-.42,-.224),l(-.466,-.04),l(-1.137,.148),l(-.594,-.039),l(-.238,.157),l(-.643,.866),l(-1.088,1.235),l(.051,-.392),l(-.312,-.55),l(-.764,-.775),l(-.122,-.649),l(-.84,-.366),l(-.908,-.563),l(-.277,-.296),l(.09,-.396),l(-.053,-.311),l(-.547,-.041),l(-.323,-.098),l(-.115,-.155),l(.059,-.311),l(-.038,-.1),l(.321,-.372),l(.789,-.64),l(.381,-.186),l(.401,-.017),l(.513,-.031),l(.333,-.186),l(.186,-.312),l(-.115,-.847),l(.111,-.792),l(1.255,.021),l(.795,.32),l(.503,.209),l(.725,.081),l(.658,-.074),l(.963,-.091),l(.146,.042),l(.113,.028),l(.18,.183),l(.882,.715),l(.536,.265),l(.252,-.256),l(.475,-.413),l(.338,.026),l(.356,.153),l(.565,.152),l(.43,-.243),l(.3,-.327),l(.684,-.428),l(.323,.055),l(.246,.281),l(.022,.339),l(.271,.832),l(.265,.451),l(.474,.478),l(.349,.718),l(.194,1.143),l(.559,.901),
N(266.015,188.956),l(.103,.169),l(-.163,.326),l(-.592,.385),l(-1.74,.9),l(-.807,.23),l(-.557,.074),l(-.465,-.054),l(-.284,.115),l(-.232,1.117),l(-.348,.115),l(-.628,-.618),l(-.344,-.224),l(-1.149,.035),l(-.385,-.04),l(-.896,-.461),l(-.309,-.125),l(-.159,.029),l(-.041,.184),l(.616,.688),l(.391,.69),l(.302,1.524),l(.079,.55),l(.166,.239),l(.96,.051),l(.434,.125),l(.15,.253),l(-.265,.27),l(-.569,.272),l(-.652,.131),l(-.203,.199),l(-.259,.666),l(-.235,.213),l(-.652,.173),l(-.554,.286),l(-.74,.654),l(-.645,.739),l(-.271,.016),l(-.186,-.776),l(-.083,-.183),l(-.757,.697),l(-.414,.073),l(-.482,-.223),l(-.694,-.546),l(-.432,-.054),l(-.199,-.437),l(-.088,-.452),l(-.161,-.861),l(-.138,-.437),l(-.148,-.168),l(-.797,-1.182),l(-.51,-.491),l(.479,-.526),l(.731,-.612),l(-.121,-.282),l(-.486,-.647),l(-.256,-.437),l(-.447,-.789),l(-.162,-.804),l(-.048,-.367),l(-.035,-.438),l(-.026,-.254),l(.147,-.326),l(.379,-.511),l(.085,-1.004),l(.409,-.525),l(-.644,-.081),l(-1.99,.224),l(-.76,.174),l(-.522,.13),l(-.144,0),l(-.554,-.576),l(-.847,-.998),l(-.188,-.253),l(-.64,-.321),l(-.521,-.181),l(-1.167,.05),l(-1.163,.12),l(-.496,.017),l(-.397,-.252),l(-.429,-.548),l(-.401,-.309),l(-.099,-.353),l(.226,-1.132),l(-.103,-.395),l(-.855,-1.45),l(-.31,-.606),l(-.384,.017),l(-.234,.1),l(-.402,-.025),l(.709,-1.191),l(.241,-.722),l(.172,-.722),l(.99,-1.758),l(.381,-.059),l(.227,.027),l(.129,-.396),l(-.048,-.497),l(.056,-.288),l(.414,-.2),l(.534,-.156),l(.84,-.171),l(.128,.105),l(-.9,.151),l(-.731,.312),l(-.145,.212),l(.19,.607),l(.142,.407),l(.224,.126),l(-.043,.145),l(.153,.579),l(-.135,.367),l(-.327,.364),l(-.348,.824),l(-.137,.368),l(.253,.479),l(.288,.253),l(.25,.72),l(.341,.353),l(.523,-.114),l(.184,-.156),l(.419,-.255),l(.12,-.142),l(.066,-.523),l(-.167,-.649),l(-.21,-.282),l(-.438,-.804),l(-.136,-.135),l(-.118,-.395),l(-.247,-.18),l(.239,-.099),l(.095,-.251),l(-.204,-.144),l(1,-.379),l(1.085,-.327),l(.998,-.272),l(.086,-.225),l(.69,-.086),l(.143,-.008),l(-.042,-.157),l(-.055,-.198),l(-.125,-.036),l(-.039,-.108),l(-.128,-.072),l(-.226,.071),l(-.156,.027),l(-.229,-.012),l(-.315,-.55),l(.109,-.254),l(.337,-.213),l(.367,-.043),l(.09,.112),l(.14,.368),l(.186,.162),l(-.001,.148),l(.026,.193),l(.068,.09),l(.004,.198),l(.253,.258),l(.329,-.02),l(.699,.111),l(.455,.07),l(.593,.196),l(.323,.254),l(.393,.564),l(.156,.635),l(.358,.324),l(.359,.084),l(1.02,-.129),l(.928,-.059),l(.59,-.058),l(.799,-.059),l(.714,.125),l(.4,.479),l(.267,.169),l(.578,.253),l(.49,.14),l(1.094,.04),l(.382,-.057),l(.388,-.227),l(1.042,-.807),l(.47,-.185),l(.453,.042),l(.959,-.073),l(1.152,-.073),l(.919,.055),l(.248,.112),l(-.056,.141),l(-.294,.185),l(-.854,-.041),l(-.433,.015),l(-.083,.212),l(.059,.184),l(.593,.253),l(.609,.535),l(.195,.649),l(.246,-.523),l(.185,-.142),l(.415,.253),l(.483,.027),l(.374,.098),l(.258,.338),l(.918,.394),l(.464,.295),l(-.729,.496),l(-.161,.65),l(-.214,.226),l(-1.055,.417),l(.5,.064),l(.598,.098),l(.368,-.029),l(.33,-.142),l(.929,-.03),l(.725,.083),l(.84,.274),l(.095,.296),l(-.061,.41),l(-1.655,1.239),l(-.101,.255),l(.074,.212),l(.62,.604),l(.141,.282),l(-.308,.299),l(-.41,.144),l(-1.032,.19),l(-.061,.452),l(.008,.58),l(-.395,.539),l(-.071,.212),l(.324,.521),l(.732,.745),l(.503,.647),
N(493.044,204.258),l(-1.223,-1.771),l(-.027,-.932),l(-.03,-1.43),l(-.042,-2.045),l(-.003,-1.017),l(0,-.438),l(.016,-.848),l(.004,-1.215),l(.002,-.508),l(1.649,-2.467),l(.453,-.511),l(.305,-.101),l(1.216,-.078),l(.337,-.115),l(.294,-.426),l(.502,-.497),l(.388,-.214),l(.562,-.215),l(.626,-.088),l(1.693,.046),l(.8,-.004),l(.813,-.909),l(1.562,-1.69),l(4.087,-4.205),l(-.236,-.154),l(-1.875,.04),l(-1.447,-.472),l(-4.26,-1.443),l(-.54,-.209),l(-.634,-.321),l(-.596,-.547),l(-.732,-.801),l(-.587,-.844),l(-.428,-.732),l(-.083,-.409),l(.363,-.807),l(.34,-.567),l(.37,-.468),l(.114,-.26),l(.154,.044),l(.935,1.142),l(.586,.62),l(.243,.381),l(.265,.211),l(.372,-.071),l(.417,-.001),l(.465,.027),l(.372,-.071),l(.572,-.27),l(.836,-.425),l(.585,-.157),l(.397,.098),l(.76,.267),l(.549,-.072),l(.56,-.326),l(.779,-.566),l(.247,-.127),l(.447,.041),l(.479,.098),l(.419,-.043),l(1.195,-.482),l(.288,.027),l(.682,.196),l(.74,-.03),l(.764,-.185),l(.964,-.327),l(.9,-.666),l(.47,-.382),l(.604,.154),l(.391,.211),l(.08,.014),l(.147,.268),l(-.414,.919),l(.021,.564),l(.132,.621),l(-.165,.452),l(-.375,.509),l(-.028,.678),l(-.047,.833),l(-.163,.509),l(-1.264,2.262),l(-.842,.792),l(-.122,.311),l(.102,.353),l(-.893,1.569),l(-.834,1.272),l(-.214,.947),l(-.351,.636),l(-.712,1.117),l(-.874,1.188),l(-1.159,1.498),l(-.384,.439),l(-2.274,2.504),l(-1.82,1.557),l(-2.164,1.121),l(-.593,.382),l(-1.28,1.09),l(-1.74,1.755),l(-.06,.061),l(-1.055,1.1),l(-1.235,1.569),l(-.615,.835),l(.1,.353),l(-.094,.276),
N(264.768,176.039),l(-.128,.225),l(-.115,.067),l(-.029,.135),l(.039,.25),l(-.058,.086),l(.125,.376),l(-.039,.424),l(-.453,.154),l(-.135,-.01),l(-.144,.039),l(-.482,-.039),l(-.192,.039),l(-.087,-.048),l(-.356,0),l(-.02,-.058),l(.039,-.067),l(.202,-.029),l(.222,-.135),l(.019,-.087),l(.106,.02),l(.154,.01),l(.135,-.145),l(-.096,-.279),l(.048,-.125),l(.029,-.183),l(-.067,-.125),l(-.097,-.135),l(-.279,-.048),l(.116,-.096),l(.164,-.019),l(.231,-.029),l(.115,-.087),l(.385,.02),l(.106,-.039),l(.299,-.067),l(.244,.006),
N(654.075,190.187),l(.206,-.125),l(.63,-.114),l(.656,-.938),l(.241,-.07),l(-.069,.268),l(.122,.087),l(.187,-.046),l(.11,.174),l(.148,.444),l(-.024,.111),l(-.013,.247),l(.197,.197),l(.025,.086),l(-1.234,.42),l(-.383,.271),l(-.309,-.271),l(-.111,-.259),l(-.234,.012),l(-.062,-.37),l(-.084,-.126),
N(493.044,204.258),l(-.602,.389),l(-.557,.171),l(-.385,-.112),l(-.086,.777),l(-.282,.367),l(-.67,.115),l(-.394,.382),l(-.088,.48),l(.006,.353),l(-.356,.622),l(-.964,1.358),l(.092,.536),l(-.337,.65),l(-.25,.255),l(-.334,.1),l(-.084,.152),l(-1.067,-.807),l(-2.427,-1.752),l(-.07,-.239),l(.116,-.552),l(-.137,-.381),l(-3.553,-1.984),l(-4.663,-2.568),l(-1.448,.033),l(1.144,-2.479),l(.105,-.229),l(.656,-.835),l(.985,-.938),l(.477,-.525),l(.43,-.695),l(.143,-.566),l(-.048,-.664),l(-.223,-.606),l(-.224,-.352),l(-.732,-1.069),l(-.174,-.465),l(-.027,-.861),l(-.126,-.226),l(-.477,-.463),l(-.3,-.493),l(.678,-.795),l(.291,-.327),l(.671,.052),l(.832,-.005),l(1.009,-.133),l(.464,-.017),l(.079,.028),l(.319,.069),l(1.054,.149),l(.749,.193),l(.604,.293),l(2.353,1.525),l(.335,.041),l(1.373,.133),l(.67,.193),l(.847,.094),l(.16,-.114),l(.71,-.753),l(.258,-.199),l(.675,-.343),l(.852,-.358),l(.271,.098),l(.46,.336),l(.461,.181),l(1.103,.106),l(-1.649,2.467),l(-.002,.508),l(-.004,1.215),l(-.016,.848),l(0,.438),l(.003,1.017),l(.042,2.045),l(.03,1.43),l(.027,.932),l(1.223,1.771),
N(466.196,203.275),l(.188,-.298),l(.076,-.27),l(-.057,-.748),l(.025,-.734),l(-.021,-.593),l(.107,-.507),l(.217,-1.02),l(.395,-.681),l(.255,-.284),l(1.241,-.996),l(1.195,-1.066),l(.191,-.453),l(-.111,-.31),l(-.271,-.182),l(-.479,-.04),l(-.191,-.027),l(-.128,-.253),l(.26,-1.88),l(.018,-.424),l(-.159,-.183),l(-.063,-.028),l(.496,-.229),l(.464,-.087),l(.495,.011),l(.942,.234),l(.911,-.048),l(.881,-.33),l(.88,-.132),l(.303,.097),l(.303,.196),l(.367,-.016),l(.626,-.314),l(.563,-.54),l(.3,.493),l(.477,.463),l(.126,.226),l(.027,.861),l(.174,.465),l(.732,1.069),l(.224,.352),l(.223,.606),l(.048,.664),l(-.143,.566),l(-.43,.695),l(-.477,.525),l(-.985,.938),l(-.656,.835),l(-.105,.229),l(-1.144,2.479),l(-4.659,0),l(-1.277,.05),l(-.319,.017),l(-.554,.398),l(-.458,.427),l(-.431,.045),l(-.546,-.223),l(-.064,-.042),
N(713.621,206.298),l(.169,7.966),l(-.44,.822),l(.431,1.368),l(.046,.805),l(-.031,3.438),l(-.515,-.512),l(-.927,-.888),l(-.716,-.902),l(-.406,-.056),l(-.776,.101),l(-.739,.143),l(-.434,-.013),l(.091,-.382),l(.435,-.65),l(.006,-.283),l(-.561,-.521),l(-.565,-.775),l(.028,-.226),l(.442,.111),l(.236,-.042),l(.135,-.113),l(-.467,-.409),l(-.595,-.408),l(-.287,-.381),l(-.275,-.648),l(-1.053,-1.693),l(-.508,-.394),l(-.467,-.282),l(-.604,-.196),l(-1.983,-.603),l(-1.26,-.379),l(-.613,-.069),l(-.705,-.238),l(-.63,-.323),l(.072,-.34),l(-.098,-.268),l(-.193,-.028),l(-.617,.101),l(-.389,-.07),l(-.412,-.196),l(-.408,-.395),l(-.209,-.579),l(.133,-.494),l(-.155,-.226),l(-.187,.113),l(-.234,.396),l(-.122,.664),l(-.251,.608),l(-.334,.269),l(-.696,.354),l(-.155,-.169),l(-.331,-.677),l(.022,-.155),l(.384,-.27),l(-.152,-.424),l(-.173,-.239),l(-.564,-.395),l(-.707,-.394),l(-.338,-.056),l(-.059,-.212),l(.038,-.226),l(.413,-.044),l(.388,.084),l(.603,.239),l(.158,-.029),l(.368,-.34),l(.525,-.41),l(.146,.056),l(.3,.269),l(1.021,-.045),l(.139,-.128),l(.09,-.522),l(-.063,-.409),l(-.238,.028),l(-.345,.199),l(-.604,.071),l(-.656,-.041),l(-.766,.044),l(-1.026,-.082),l(-.411,-.31),l(-.135,-.197),l(-.148,-.664),l(-.202,-.338),l(-.42,-.155),l(-1.249,-.124),l(.265,-.297),l(.058,-.255),l(.004,-.593),l(.463,-.029),l(.92,-.411),l(.49,-.383),l(.444,-.283),l(.352,.027),l(.4,.069),l(1.494,.646),l(.515,.169),l(.913,.153),l(.382,.705),l(.138,.396),l(-.283,.749),l(-.067,.381),l(.221,.381),l(.115,.494),l(.115,.48),l(.215,.521),l(.186,.197),l(.197,.127),l(.226,-.65),l(.085,.113),l(.087,.141),l(.309,1.073),l(.169,.169),l(.234,.183),l(.294,.112),l(.354,.056),l(.58,-.198),l(.504,-.439),l(1.192,-1.853),l(.352,-.015),l(1.078,-.215),l(.378,-.142),l(.045,-.085),l(.014,-.509),l(.219,-.17),l(1.1,-.609),l(.335,-.043),l(1.732,.759),l(2.129,.941),l(1.54,.52),l(1.299,.404),M(691.208,208.707),l(-.388,-.069),l(-.693,-.38),l(-.852,-.647),l(-.295,-.141),l(-.414,.028),l(-.059,.1),l(.024,.452),l(-.206,.028),l(-1.014,-.407),l(-.258,-.353),l(-.582,.199),l(-.289,.269),l(-.326,.185),l(-.186,-.184),l(-.312,-.451),l(-.245,-.451),l(.246,-.198),l(.303,-.029),l(.274,.056),l(1.104,.04),l(.574,.31),l(.319,-.015),l(.544,-.326),l(.414,-.015),l(.534,.126),l(.857,.21),l(.499,.395),l(.293,.395),l(.179,.621),l(-.049,.254),M(682.045,208.699),l(-.419,-.056),l(-.715,-.493),l(-.232,-.451),l(.146,-.283),l(.603,-.1),l(.766,-.044),l(.246,.126),l(.256,.311),l(.313,.197),l(.108,.226),l(-.067,.226),l(-.125,.057),l(-.879,.285),M(707.635,219.095),l(-1.11,-.209),l(.589,-1.032),l(.56,-.708),l(.407,-.269),l(.427,-.072),l(.527,.338),l(.198,.24),l(-.11,.184),l(-.324,.637),l(-.256,.17),l(-.638,.693),l(-.27,.028),M(673.797,218.703),l(-.562,.257),l(.034,.233),l(-.886,.326),l(-.582,.274),l(-.339,-.041),l(-.453,.325),l(-.504,-.069),l(-.427,-.112),l(-.378,.255),l(-.3,.058),l(-.358,-.07),l(-.58,-.196),l(-1.046,-.04),l(-.316,.043),l(-.211,-.564),l(.027,-.24),l(.383,-.198),l(.672,-.199),l(.528,-.016),l(1.142,.407),l(.445,.324),l(.338,.013),l(.326,-.297),l(.464,-.016),l(.429,-.071),l(.414,.187),l(.467,-.116),l(-.072,-.222),l(.421,-.187),l(.404,-.233),l(.094,-.151),l(-.076,-.117),l(-.184,.023),l(.116,-.198),l(.16,.012),l(.22,.094),l(.177,.221),l(.013,.304),M(662.661,219.065),l(-.312,-.099),l(-.203,-.127),l(-.062,-.169),l(.03,-.212),l(.256,-.198),l(.315,-.036),l(.17,.092),l(.053,.212),l(.182,.098),l(.305,-.145),l(.34,.105),l(.104,.151),l(-.012,.451),l(.183,-.148),l(.163,-.304),l(.318,-.029),l(.229,.226),l(.021,.424),l(.181,-.036),l(.062,.104),l(-.025,.397),l(-.316,-.211),l(-.311,-.058),l(-.141,.058),l(.072,.155),l(-.852,.157),l(-.143,-.091),l(.097,-.268),l(-.085,-.059),l(-.308,.269),l(-.229,.256),l(-.296,-.046),l(-.63,.225),l(-.624,.199),l(-.357,-.051),l(-.31,.123),l(-.392,-.07),l(-.103,-.07),l(-.202,-.123),l(-.063,-.279),l(.143,-.261),l(-.08,-.253),l(.193,-.115),l(.23,-.113),l(.233,-.156),l(.224,.07),l(.61,.013),l(.4,.104),l(.089,.28),l(.291,.109),l(.294,.056),l(.189,-.259),l(.29,-.012),l(.051,-.187),l(-.263,-.15),M(656.294,219.602),l(-.393,-.282),l(-.855,-.449),l(-.118,-.269),l(.417,-.001),l(.514,-.185),l(.462,-.029),l(.925,.521),l(-.338,.17),l(-.232,.1),l(-.381,.425),M(631.053,200.125),l(-.061,.225),l(-.413,.439),l(-.204,.41),l(-.381,.354),l(.164,.353),l(.162,.169),l(.806,.493),l(.832,.055),l(.241,.112),l(.151,.381),l(.128,.763),l(-.007,.409),l(.267,.423),l(.212,.127),l(.544,.041),l(-.45,.933),l(.151,.212),l(.703,-.453),l(.824,.252),l(.177,.042),l(.265,.254),l(.144,.438),l(.698,.676),l(-.515,1.979),l(-.04,.452),l(.23,.946),l(-.021,.438),l(.021,.664),l(-.002,.268),l(-.149,1.06),l(-.087,.156),l(-.107,.07),l(-.367,-.253),l(-.381,-.522),l(-.261,-.084),l(-.262,.481),l(-.081,.268),l(-1.043,-.619),l(-.219,.086),l(.394,.747),l(-.163,.213),l(-.204,-.197),l(-1.343,-1.424),l(-.775,-.761),l(-1.011,-.859),l(-1.348,-.958),l(-.391,-.451),l(-.199,-.493),l(-.191,-.339),l(-1.003,-.633),l(-.697,-.677),l(-1.186,-1.509),l(-.074,-.353),l(.039,-.339),l(-.324,-.875),l(-.841,-1.467),l(-.667,-1.044),l(-.612,-.775),l(-.369,-.301),l(-.287,-.234),l(-.64,-.295),l(-.254,-.748),l(-.688,-1.806),l(.067,-.24),l(-.107,-.311),l(-.157,-.197),l(-.662,-.507),l(-.711,-.394),l(-.539,-.21),l(-.317,-.099),l(-.119,-.353),l(-.077,-.734),l(-.18,-.409),l(-.386,-.479),l(-.818,-.831),l(-.368,-.423),l(-.725,.128),l(-.613,-.676),l(-.646,-.606),l(-.593,-.69),l(-.562,-.945),l(-.229,-.635),l(-.032,-.367),l(.057,-.198),l(.149,-.113),l(.401,-.043),l(.364,.098),l(.25,.126),l(.632,.563),l(.361,.155),l(.922,.153),l(.335,.027),l(.548,-.1),l(.454,-.142),l(.4,-.015),l(.323,.31),l(.919,1.156),l(.513,.31),l(.058,.155),l(-.12,.537),l(1.066,.916),l(.749,.493),l(1.175,.689),l(.678,.323),l(.139,.169),l(.03,.593),l(-.02,.155),l(.573,.055),l(.745,.944),l(.612,.55),l(.271,-.015),l(.004,-.198),l(-.123,-.226),l(.069,-.24),l(.507,.21),l(.479,.804),l(.441,.38),l(.446,.056),l(.429,.197),l(.314,.366),l(.28,.734),l(.316,.437),l(.431,.268),l(.511,.126),l(.767,.083),l(.431,.154),l(.494,.38),l(.576,.606),l(-.019,.071),M(684.201,200.125),l(-.007,-.172),l(-.414,-1.058),l(.18,-.551),l(-.078,-.141),l(-.141,-.296),l(.036,-.325),l(.286,-.89),l(.514,-.82),l(.263,.367),l(.152,.353),l(-.054,.283),l(-.246,.396),l(-.361,.763),l(.061,.325),l(.19,.141),l(.097,-.141),l(.436,-.411),l(.135,-.522),l(.179,-.142),l(.806,-.412),l(.141,.141),l(-.052,.254),l(.104,.55),l(-.354,.212),l(-.467,.354),l(-.162,.311),l(.159,.099),l(.446,.126),l(.398,.211),l(-.016,.141),l(.159,.353),l(-.688,-.154),l(-.431,-.154),l(-.367,-.042),l(-.304,.156),l(-.08,.438),l(.049,.258),l(.131,.688),l(.341,.62),l(.405,.438),l(.196,.282),l(-.156,.212),l(-.26,-.211),l(-.664,-.648),l(-.55,-.733),l(-.002,-.396),l(-.011,-.251),M(637.361,207.144),l(-.863,-.394),l(-.377,-.239),l(-.205,-.367),l(-.045,-.367),l(-.156,-.395),l(-.507,-.395),l(-.291,-.099),l(-.446,.029),l(-.116,-.141),l(.271,-.65),l(.234,-.24),l(.509,.55),l(.148,-.467),l(.313,-.269),l(.072,.395),l(.312,.89),l(.648,.817),l(.698,.31),l(-.265,.184),l(-.118,.283),l(.183,.564),M(634.321,215.345),l(-.091,-.187),l(.316,-.023),l(.402,.093),l(.369,-.129),l(.068,-.524),l(.018,-.14),l(.309,.057),l(-.043,-.5),l(.222,-.235),l(.093,-.277),l(.202,.121),l(.631,.112),l(.474,-.047),l(.237,.443),l(.524,-.089),l(.158,-.297),l(.022,-.244),l(.259,.116),l(.618,.168),l(.411,.438),l(.338,-.046),l(.204,.271),l(.446,-.029),l(.453,-.185),l(.302,.211),l(.369,.522),l(.179,.521),l(.884,.041),l(.462,.188),l(.49,-.077),l(1.435,.124),l(.479,-.029),l(.34,-.17),l(.213,-.65),l(.271,-.269),l(.447,-.015),l(.223,.211),l(.289,.494),l(.633,.125),l(.53,.027),l(.774,.083),l(.796,.153),l(.289,.24),l(.293,.288),l(-.08,.445),l(.275,.466),l(.119,.099),l(.877,.352),l(.422,.069),l(.658,.013),l(.45,-.185),l(.415,-.015),l(.628,.238),l(.048,.197),l(-.255,.425),l(-.152,.494),l(.578,.776),l(-.499,-.211),l(-.802,-.196),l(-.599,-.253),l(-.891,-.309),l(-.528,.001),l(-.589,.256),l(-.348,.057),l(-.714,-.098),l(-1.454,-.138),l(-1.47,-.138),l(-.805,-.253),l(-.839,-.479),l(-1.099,-.336),l(-1.125,-.267),l(-.948,-.04),l(-.556,.298),l(-.445,.043),l(-.957,-.153),l(-.805,-.492),l(-.357,-.07),l(-1.606,-.066),l(-.363,-.155),l(.055,-.141),l(.448,-.468),l(-.402,-.267),l(-.551,-.099),l(-.506,-.14),l(-.307,-.027),l(-1.261,-.121),M(675.004,223.092),l(.249,-.494),l(.023,-.537),l(.113,-.312),l(.674,-.481),l(1.447,-.624),l(.662,-.454),l(.36,-.607),l(.466,-.157),l(1.578,-.102),l(.91,-.214),l(.541,-.044),l(.869,-.143),l(.118,.07),l(.099,.197),l(-.237,.212),l(-.36,.256),l(-1.609,.61),l(-1.369,.44),l(-.713,.256),l(-.606,.354),l(-1.09,.963),l(-.653,.481),l(-.439,.086),l(-.552,.228),l(-.48,.015),M(667.866,223.149),l(-.217,-.069),l(-.917,-.605),l(-.8,-.45),l(-.347,-.099),l(-.493,-.126),l(-.292,-.197),l(.108,-.212),l(.371,-.142),l(.992,-.03),l(.502,-.114),l(.35,.296),l(1.147,.746),l(.265,.381),l(-.125,.325),l(-.246,.24),l(-.299,.057),M(661.819,191.241),l(-.041,.09),l(.319,.691),l(-.23,.142),l(-.546,.043),l(-.579,.086),l(.198,.226),l(.115,.296),l(-.169,.226),l(.216,.211),l(.235,.112),l(.546,.832),l(.536,.747),l(.043,.198),l(-.338,.721),l(.075,.226),l(.406,.465),l(.743,.45),l(.6,.493),l(.551,.761),l(-.465,.17),l(-.75,-.026),l(-.797,-.238),l(-.337,.1),l(-.387,.467),l(-.354,.918),l(-.08,.476),l(-.046,.272),l(.132,.649),l(.116,.424),l(-.133,.848),l(-.256,0),l(-.466,-.154),l(-1.037,.963),l(-.433,.65),l(-.751,.608),l(.443,.381),l(.06,.396),l(.17,.296),l(-.685,.058),l(.452,.578),l(.009,.212),l(-.103,.227),l(-.547,.665),l(-.206,.396),l(-.127,.354),l(-.529,.594),l(-1.294,.61),l(-.607,.284),l(-.292,.198),l(-.194,-.311),l(.024,-.424),l(-.33,-.804),l(-.306,-.381),l(-.265,-.184),l(-.286,.029),l(-.503,.523),l(-.302,.029),l(-.328,-.508),l(-.313,-.197),l(-.437,-.112),l(-.387,-.451),l(-.342,-.154),l(-.35,.806),l(-.135,.198),l(-.381,.058),l(-.356,-.112),l(-.442,.128),l(-.318,.354),l(-.364,.071),l(-.059,-.551),l(.034,-.311),l(-.314,-1.03),l(-.336,.396),l(-1.42,.44),l(-.321,-.408),l(-.639,.015),l(-.281,.156),l(-.303,.029),l(-.058,-.649),l(-.022,-.65),l(-.267,-1.411),l(-.012,-.48),l(-.352,-.747),l(-.406,-.409),l(-.79,-.422),l(-.146,-.141),l(.555,-.354),l(-.531,-.38),l(-.258,-.296),l(.188,-.735),l(-.074,-.128),l(-.278,-.478),l(-.352,-.296),l(.065,-.466),l(-.125,-.593),l(.182,-.65),l(.133,-.353),l(.424,-.58),l(.303,-.806),l(.318,.028),l(.204,.11),l(.288,.792),l(.253,.295),l(1,.983),l(.304,.083),l(.446,.28),l(.928,-.416),l(.255,-.001),l(.526,.223),l(.543,.11),l(.399,-.172),l(.528,-.342),l(.403,-.525),l(.531,-.441),l(.479,-.074),l(.431,.11),l(.557,.251),l(.524,.223),l(.559,.152),l(.287,-.03),l(.467,-.356),l(.465,-.172),l(.864,-.175),l(.387,-.299),l(.928,-1.785),l(-.076,-.748),l(.218,-.34),l(.646,-.244),l(.22,-.383),l(-.106,-.988),l(.119,-.565),l(.381,-.638),l(.247,-.157),l(.464,-.017),l(.748,.081),l(.651,.081),l(.624,-.018),l(.446,.04),l(.753,.292),l(.182,.09),M(666.561,200.125),l(.012,-.049),l(.48,-1.188),l(.434,-.41),l(.289,-.142),l(.429,.338),l(.29,-.311),l(.162,-.325),l(.293,-.481),l(.496,-.058),l(.605,.14),l(.729,.535),l(.447,.027),l(.863,-.044),l(.478,.168),l(.749,.267),l(.577,-.227),l(1.853,.081),l(.72,-.128),l(.627,-.354),l(.211,-.283),l(-.156,-.268),l(.196,-.283),l(.388,-.241),l(.295,-.41),l(.289,-.057),l(.075,.24),l(-.073,.537),l(-.117,.311),l(-.081,.127),l(-.082,.127),l(-.969,1.259),l(-.416,.396),l(-.464,.1),l(-1.23,.229),l(-.495,-.069),l(-.591,-.422),l(-1.149,-.068),l(-1.151,.059),l(-.878,-.041),l(-1.039,.045),l(-.575,-.083),l(-.671,.029),l(-.415,.1),l(-.433,.368),l(-.259,.461),l(-.154,.274),l(-.187,.721),l(.068,.48),l(.263,.494),l(.194,.183),l(.403,.226),l(.259,.196),l(.221,.607),l(.179,.154),l(.226,.042),l(.815,.026),l(.249,-.269),l(.652,-.976),l(.385,.056),l(.307,.183),l(.496,.041),l(.363,-.227),l(.669,-.156),l(.62,-.143),l(.268,-.298),l(.271,-.057),l(.466,.196),l(.131,.212),l(-.083,.734),l(-.469,-.267),l(-.544,-.042),l(-.361,.298),l(-.389,.523),l(-.438,.425),l(-1.059,.439),l(-.214,.325),l(-.143,.029),l(-.241,-.042),l(-.468,-.126),l(-.03,.056),l(.025,.312),l(.212,.126),l(.676,.578),l(.467,.521),l(.854,1.24),l(-.097,.325),l(-.156,.679),l(.102,.409),l(.447,.535),l(.555,.438),l(.062,.226),l(-.045,.282),l(-.436,-.056),l(-.652,.059),l(-.412,.297),l(-.224,.692),l(-.498,-.026),l(-.461,-.183),l(-.107,-.17),l(.052,-.649),l(.204,-.58),l(-.978,-.845),l(-.417,-.31),l(-.174,-.269),l(.036,-.24),l(.284,-.396),l(.116,-.579),l(-.165,-.494),l(-.737,-.055),l(-.503,.213),l(-.494,.396),l(.16,.353),l(.143,.932),l(-.068,.509),l(-.236,1.145),l(.363,.903),l(-.01,.311),l(-.377,.636),l(-.019,.227),l(.275,.564),l(-.726,.171),l(-.513,.241),l(-.476,.071),l(-.245,-.324),l(-.16,-.522),l(.156,-.325),l(.181,-.466),l(.069,-.876),l(.06,-1.073),l(-.125,-.509),l(.029,-.339),l(-.213,-.395),l(-.311,-.127),l(-.391,.171),l(-.574,.029),l(.011,-.41),l(-.25,-1.284),l(.131,-.311),l(.491,-.524),l(.469,-.777),l(.161,-.48),l(-.089,-.918),l(-.006,-.254),l(.087,-.452),l(.339,-.721),l(.447,-.058),l(-.043,-.861),l(.254,-1.053),
N(341.05,41.069),l(2.084,.272),l(.344,.361),l(-.869,.174),l(-.541,.139),l(-1.678,.106),l(-1.159,.037),l(-.689,.156),l(-.372,.224),l(-.308,.6),l(-.361,.376),l(1.05,.39),l(.971,.168),l(2.117,.064),l(.601,-.001),l(1.775,-.242),l(1.93,-.038),l(.866,.135),l(.933,.219),l(.417,.135),l(.284,-.018),l(1.001,-.002),l(1.277,.032),l(.615,.05),l(-1.277,.626),l(-1.583,.457),l(-1.976,.523),l(-.556,-.016),l(-.695,-.116),l(-.951,.671),l(-1.061,.503),l(-1.246,.452),l(-1.125,.296),l(-.211,.056),l(-2.212,.054),l(-.525,.134),l(-.502,.001),l(-.982,.201),l(-.665,.167),l(-.528,.051),l(-.946,-.413),l(-.375,.05),l(-.69,.913),l(-.958,.118),l(-.631,-.065),l(-.743,-.197),l(-.622,-.463),l(-.854,-.43),l(-.647,-.215),l(-.109,0),l(.008,.2),l(.707,1.043),l(-.192,.249),l(-.319,.017),l(-.69,.249),l(-.84,.249),l(-.573,.38),l(-1,.906),l(-.657,.657),l(-1.051,.851),l(-.776,.262),l(-1.034,.083),l(-1.023,-.275),l(-.148,.554),l(-.438,.569),l(-.783,.277),l(-.992,-.095),l(-.616,.05),l(-1.18,.439),l(.942,-1.723),l(-.121,.017),l(-.795,-.015),l(-1.055,-.177),l(.26,.423),l(-.026,.455),l(-.386,.407),l(-.794,.39),l(-1.16,.164),l(-.973,.002),l(-1.255,.083),l(.467,.403),l(.212,.403),l(-.09,.387),l(-.379,.097),l(-.321,-.063),l(-.47,.033),l(-1.792,-.157),l(.517,.32),l(.765,.462),l(.295,.351),l(-.01,.224),l(-.26,.176),l(-1.197,.034),l(-1.051,.129),l(.844,.413),l(.47,.126),l(.448,.222),l(.389,.333),l(-.554,.461),l(-.285,.111),l(-.599,-.094),l(-.478,.096),l(.345,.474),l(-.009,.127),L(308.501,60),l(-.486,-.125),l(-.583,-.062),l(.026,.158),l(.255,.457),l(-.101,.347),l(-.288,0),l(-.656,-.093),l(-.089,-.016),l(-.979,.112),l(-1.081,.018),l(.682,.487),l(1.108,.391),l(.331,.204),l(-.077,1.035),l(-.382,.938),l(-.427,.094),l(-.815,-.061),l(.489,.591),l(-.016,.498),l(.156,.233),l(-.068,.373),l(-.316,.062),l(-.495,-.03),l(-.771,.079),l(.762,.386),l(.427,.603),l(-.117,.447),l(-.287,.031),l(-.967,-.26),l(-1.052,-.508),l(-.498,.294),l(-.425,.602),l(-.635,-.599),l(.158,-.573),l(-.387,-.201),l(-1.124,-.184),l(-.577,-.309),l(.04,-.187),l(.253,-.249),l(.066,-.218),l(-.325,-.28),l(-.366,-.186),l(-.668,.359),l(-.276,.016),l(-.3,.141),l(-.444,-.046),l(-.98,.064),l(-.417,.017),l(-.571,.296),l(-.476,.28),l(-.426,-.403),l(-.104,-.357),l(-.222,-.217),l(-.513,-.233),l(-.817,-.232),l(-.772,-.389),l(-.517,-.781),l(.07,-.737),l(-.199,-.156),l(-.434,-.094),l(-.467,.048),l(-.97,-.266),l(-.108,-.094),l(-.138,-.236),l(.14,-.457),l(.459,-.395),l(.071,-.269),l(-.258,-.062),l(-.551,-.031),l(-.542,-.094),l(-.278,-.221),l(-.058,-.633),l(-.458,-.126),l(-.616,.049),l(-.589,-.57),l(.023,-.191),l(.198,-.254),l(.618,-.367),l(1.22,-.337),l(.405,-.304),l(.476,-.128),l(.051,-.383),l(-.277,-.287),l(-.473,.097),l(-.921,.082),l(-.493,.097),l(-.635,.416),l(-.538,.129),l(-.63,.304),l(-.339,-.318),l(.038,-.623),l(-.114,-.784),l(-.206,-.451),l(.015,-.355),l(-.243,-.323),l(-.504,.082),l(-.271,-.032),l(-.666,-.355),l(-.594,-.485),l(-.013,-.357),l(.842,-.538),l(.265,.019),l(-.556,-.189),l(-1.083,.064),l(-.103,-.284),l(.383,-.176),l(.677,-.03),l(.586,-.052),l(.456,-.087),l(.322,-.672),l(-1.208,-.047),l(-.572,.05),l(-.362,-.032),l(-.29,-.163),l(-.116,-.197),l(.223,-.28),l(.218,-.008),l(.18,-.16),l(.427,-.055),l(-.375,-.188),l(-.552,.073),l(-.22,-.248),l(.057,-.188),l(.073,-.132),l(.259,0),l(.309,-.099),l(.827,-.25),l(1.218,.081),l(.854,.163),l(.776,.032),l(.378,.131),l(.927,.146),l(1.027,.097),l(-.031,-.363),l(.299,-.545),l(-.298,-.182),l(-1.02,-.263),l(-1.356,-.312),l(-.903,-.164),l(-1.592,-.33),l(-.354,-.116),l(.336,-.35),l(.788,-.001),l(1.462,.363),l(1.034,.048),l(.463,-.067),l(.114,-.067),l(.088,-.6),l(.088,-.301),l(.595,-.034),l(.528,.116),l(.227,-.101),l(-.027,-.351),l(-.195,-.184),l(-.891,-.317),l(.162,-.437),l(.528,-.455),l(-.258,-.286),l(-1.21,-.167),l(-1.154,.002),l(-1.178,-.286),l(-1.649,-.49),l(-.78,-.101),l(-.903,-.05),l(-.76,-.34),l(-.811,-.477),l(.156,-.035),l(.323,-.155),l(.605,-.001),l(.572,-.019),l(2.085,.305),l(.716,.033),l(1.249,.306),l(1.451,.458),l(.729,.169),l(.056,-.307),l(-.311,-.426),l(-.86,-.546),l(-.172,-.446),l(-.603,-.446),l(-.485,-.051),l(-.677,-.24),l(.361,-.277),l(.542,-.139),L(285.644,41),l(-.704,-.241),l(-1.101,-.015),l(-.625,-.086),l(-1.132,-.327),l(-.88,.608),l(-.324,.156),l(-.274,.294),l(-.875,.243),l(-1.402,-.066),l(-1.031,-.343),l(-.306,-.242),l(-.027,-.294),l(.438,-.313),l(.293,-.645),l(-.152,-1.259),l(.582,-.054),l(.691,.192),l(.372,-.124),l(.151,-.334),l(-.383,-.369),l(-.933,-.545),l(-.452,-.141),l(-.946,-.796),l(-.895,-.925),l(-1.105,-1.289),l(-.578,-.485),l(-1.855,-.379),l(-.667,-.255),l(-.291,-.202),l(-.052,-.701),l(-.904,-.406),l(-.962,-.109),l(-1.589,-.165),l(-1.928,-.425),l(-1.903,-.333),l(-2.133,-.183),l(-.997,-.054),l(-1.632,-.035),l(-.785,.189),l(-1.043,.096),l(-.806,.188),l(-1.419,.152),l(-1.228,-.166),l(-1.46,-.296),l(.319,.747),l(-.051,.093),l(-1.051,-.017),l(-1.294,-.184),l(-3.168,-.611),l(1.538,-.566),l(.463,-.114),l(-.092,-.226),l(-.423,-.169),l(-1.067,-.017),l(-2.21,-.015),l(-.812,-.074),l(-.629,-.018),l(-1.238,-.434),l(-.87,-.208),l(.587,-.306),l(1.257,-.041),l(3.036,.147),l(2.025,.034),l(1.343,.017),l(2.117,-.157),l(1.055,-.212),l(.292,-.096),l(.054,-.345),l(-.627,-.287),l(-.82,-.21),l(-1.217,.156),l(-1.11,.252),l(-1.31,.021),l(-1.138,-.113),l(-.753,.078),l(-.879,.098),l(-.68,-.056),l(-.857,-.19),l(-.664,-.365),l(-.816,-.191),l(-.662,-.057),l(-.726,.059),l(-.486,-.076),l(-1.416,-.481),l(-.044,-.35),l(.36,-.45),l(.81,-.119),l(1.235,-.1),l(1.517,-.14),l(2.074,-.161),l(1.29,-.081),l(.951,-.396),l(1.089,-.259),l(.843,-.081),l(2.478,-.005),l(1.101,-.101),l(1.942,.036),l(.402,-.139),l(.31,-.199),l(.609,-.16),l(.202,-.658),l(.276,-.501),l(.116,-.101),l(-.89,-.228),l(-1.947,-.039),l(-1.155,.194),l(-.959,-.125),l(-1.243,-.383),l(.595,-.781),l(1.38,-.332),l(2.845,-.359),l(1.407,-.225),l(1.962,-.249),l(2.112,-.162),l(1.163,.087),l(1.213,-.07),l(1.319,-.07),l(.345,-.181),l(.011,-.226),l(-.357,-.753),l(-.022,-.208),l(.522,-.14),l(1.886,-.05),l(1.526,.205),l(2.141,.41),l(1.296,.226),l(.802,.181),l(.823,-.275),l(-1.657,-.525),l(-.697,-.509),l(.167,-.047),l(2.2,-.122),l(1.166,-.12),l(1.854,-.216),l(2.52,-.195),l(.73,.069),l(1.064,.116),l(.232,1.738),l(.913,-.162),l(.539,-.322),l(.432,-1),l(1.003,.021),l(2.004,.323),l(1.858,.414),l(1.529,.25),l(.205,-.3),l(-.644,-.3),l(-.816,-.537),l(-.894,-.4),l(.295,-.287),l(.742,.022),l(1.758,.02),l(1.136,.212),l(2.754,.373),l(1.284,.279),l(2.109,.322),l(1.878,.274),l(1.872,.204),l(.8,-.209),l(.816,-1.483),l(-.326,-.191),l(-1.292,-.334),l(-1.176,-.533),l(.708,-.247),l(2.404,-.005),l(2.962,-.328),l(1.329,-.077),l(1.527,.17),l(2.221,.488),l(1.567,.167),l(2.005,.142),l(.3,-.761),l(-.3,-.472),l(2.646,-.206),l(2.021,-.08),l(2.589,.095),l(1.989,.146),l(1.886,-.18),l(2.367,-.207),l(2.043,-.005),l(1.859,.223),l(1.825,-.055),l(1.315,.072),l(.619,.099),l(.55,-.102),l(1.946,.146),l(1.707,.046),l(1.673,.096),l(2.438,.761),l(1.368,.241),l(1.345,-.076),l(1.118,.168),l(2.594,.237),l(.445,.408),l(-.304,.12),l(-.492,.192),l(-1.683,.146),l(-2.303,.124),l(-1.152,.121),l(-1.233,.05),l(-1.469,-.068),l(-2.831,-.064),l(-2.22,-.066),l(-1.389,.168),l(-1.614,.027),l(-1.933,.027),l(-1.16,.026),l(-1.485,.168),l(-.444,.118),l(-1.322,.213),l(-.335,.464),l(.743,.251),l(2.551,-.281),l(1.367,-.072),l(3.912,.038),l(2.223,-.12),l(2.331,-.005),l(.997,-.025),l(.93,.067),l(1.77,.434),l(.671,.09),l(1.087,-.186),l(1.663,-.21),l(1.536,-.281),l(1.964,-.144),l(.59,.462),l(-.566,.482),l(-2.316,.639),l(-.973,.338),l(-1.281,.734),l(.12,.307),l(.319,.152),l(.796,-.089),l(.477,-.044),l(1.616,-.553),l(1.766,-.537),l(1.413,-.385),l(1.706,-.32),l(.775,-.207),l(1.662,-.163),l(1.618,.111),l(1.391,.065),l(1.497,-.3),l(.703,-.324),l(1.129,-.234),l(2.148,-.004),l(1.672,.112),l(1.097,.044),l(1.197,.136),l(1.135,.228),l(1.107,.112),l(.316,.25),l(-.181,.273),l(-1.97,.252),l(-1.491,.138),l(-1.245,.494),l(-.557,.289),l(-1.604,.355),l(-1.57,.548),l(-1.063,.089),l(-.918,-.042),l(-1.592,.047),l(-2.213,-.039),l(-1.491,.198),l(-.731,.217),l(-.495,.535),l(.166,.322),l(1.949,-.305),l(1.581,-.046),l(1.856,.101),l(.003,.42),l(-.743,.241),l(-2.388,.124),l(-.463,.14),l(-.213,.199),l(-.156,.595),l(-.471,.71),l(-.678,.158),l(-1.06,-.077),l(-.742,.041),l(-.837,.9),l(-.987,1.087),l(-.15,.347),l(.454,.307),l(.403,.095),l(.602,-.481),l(.743,-.368),l(.856,-.041),l(2.345,.266),l(.353,.096),l(.262,.288),l(-.059,.211),l(-1.234,-.074),l(-.673,-.018),l(-.512,.097),l(-.136,.191),l(.29,.286),l(1.756,.188),l(.557,.132),l(1.802,-.137),l(.526,.208),l(.214,.323),l(-.049,.436),l(-.256,.133),l(-1.835,-.186),l(-1.653,-.054),l(-.781,-.074),l(-1.295,.078),l(-1.382,.475),l(-.823,-.13),l(-.49,-.15),l(-1.06,.04),l(-.283,.377),l(1.393,.599),l(1.187,.222),l(1.298,.128),l(1.665,.072),l(.696,.148),l(.551,.482),l(.272,.444),l(.014,.554),l(-.434,.405),l(-.384,.074),l(-1.292,-.181),l(-.82,-.109),l(-.372,.111),l(.023,.55),l(.118,.236),l(.426,.162),l(.618,.089),l(.723,.215),l(.914,.142),l(.752,.16),l(.383,.376),l(-.338,.233),l(-.832,.145),l(-.647,.126),l(-1.747,-.032),l(-1.176,-.087),l(-1.624,-.086),l(-.592,.448),l(.551,.195),l(1.396,.051),l(1.052,.158),l(.724,.248),l(.088,.319),l(-.035,.549),l(-.13,-.005),l(-1.092,-.045),l(-1.247,.108),l(-.596,.266),l(-1.246,.02),l(-1.225,-.139),l(-1.497,-.404),l(-.922,-.478),l(-.373,-.07),l(-1.094,.286),L(345,36.811),l(-1.084,.09),l(-.589,.178),l(-1.451,-.033),l(-.913,-.087),l(-.969,.143),l(-.395,.125),l(-.174,.283),l(.006,.141),l(.354,.527),l(.71,.245),l(1.284,.05),l(1.515,.26),l(1.567,-.056),l(1.323,.54),l(.758,.226),l(.482,.226),l(1.196,.329),l(1.252,.38),l(.376,.276),l(.483,.898),l(.892,-.208),l(.278,-.139),l(.397,.207),l(.298,.43),l(.071,.344),l(.198,1.164),l(-.169,.205),l(-.371,.12),l(-.541,-.101),l(-.546,-.119),l(-.917,.002),l(-1.041,.036),l(-1.488,-.27),l(-.637,-.409),l(-.415,-.634),l(-.354,-.274),l(-1.17,-.566),l(-.84,-.292),l(-.748,-.137),l(-1.095,-.084),l(-.521,.14),l(-.962,.105),M(351.365,40.026),l(-1.527,-.537),l(-.96,-.225),l(-.712,-.156),l(-.159,-.069),l(-.314,-.419),l(1.483,-.038),l(.893,.139),l(1.064,.26),l(.819,.296),l(.162,.488),l(-.215,.209),l(-.533,.053),M(281.574,46.135),l(-.568,-.133),l(-.707,-.318),l(-.801,-.183),l(-.197,-.101),l(-.25,-.218),l(-.08,-.844),l(.287,-.34),l(.368,-.018),l(.646,.135),l(1.157,.066),l(1.287,.27),l(.748,.269),l(.595,.1),l(.777,.217),l(.603,.335),l(-.144,.202),l(-.112,.034),l(-.543,.051),l(-.774,.035),l(-.77,.186),l(-1.009,.153),l(-.511,.102),
N(105.98,81.688),l(-.952,-.826),l(-.198,-.342),l(-.024,-.476),l(.095,-.104),l(.408,.044),l(.312,-.045),l(.781,.177),l(.658,-.076),l(.28,.119),l(.138,.163),l(-.234,.224),l(-.173,.565),l(-.028,.312),l(-.581,.075),l(-.483,.19),M(125.24,92.375),l(-1.312,-.288),l(-1.345,-.434),l(-.218,-.174),l(.061,-.189),l(.376,-.466),l(-1.023,.002),l(-.413,.248),l(-.299,-.072),l(-.416,-.188),l(.166,-.452),l(-.487,-.334),l(-.269,-.014),l(-.735,-.086),l(-.226,-.262),l(.317,-.292),l(-.976,-.524),l(-.556,.118),l(-.386,-.102),l(-.852,-.511),l(-1.277,-.863),l(-.219,-.235),l(.02,-.117),l(.962,-.12),l(.337,.043),l(1.979,.598),l(.981,.204),l(1.772,.202),l(.385,.263),l(.618,.526),l(.426,.642),l(.433,.422),l(.362,.189),l(1.587,.536),l(.316,.203),l(.48,.756),l(.116,.407),l(-.279,.349),l(-.407,.016),M(271.379,92.089),l(-1.202,-.23),l(.641,-.743),l(.358,-.161),l(.279,.058),l(.292,0),l(.355,-.263),l(-.697,-.653),l(.079,-.219),L(272,89.003),l(1.121,-1.35),l(1.454,-1.31),l(.725,-.442),l(.496,-.192),l(1.315,-.194),l(.198,.073),l(.11,.221),l(-.299,.221),l(-.582,.03),l(-.242,.133),l(.349,.44),l(-.755,.78),l(-1.226,1.438),l(-.271,.526),l(.113,.291),l(.11,0),l(.428,-.176),l(.483,-.555),l(.458,-.191),l(1.115,.305),l(-.896,.687),l(.261,.203),l(.229,.072),l(1.423,.565),l(.758,-.03),l(.325,-.408),l(.309,-.059),l(.718,.057),l(.826,.202),l(.616,.231),l(-.297,.292),l(-.373,.233),l(-.708,.467),l(.339,.333),l(.477,.362),l(.26,.014),l(.417,-.161),l(.464,-.132),l(.278,.116),l(.02,.16),l(-.254,.262),l(-.404,.248),l(-.892,.104),L(280.84,93),l(.273,.362),l(.124,.405),l(.28,.231),l(.183,-.203),l(.309,-.262),l(.527,.159),l(-.099,.449),l(.149,.275),l(.716,.028),l(.085,-.015),l(.015,.203),l(-.168,.304),l(-.25,.652),l(-.34,.651),l(-.222,-.072),l(-.71,-.128),l(-.301,-.144),l(-.042,-.651),l(-.601,.406),l(-.374,.015),l(-.095,-.274),l(.497,-.652),l(.011,-.333),l(-.421,-.478),l(-.279,-.072),l(-.388,.392),l(-.423,.291),l(-.365,.146),l(-.435,.204),l(-.552,.536),l(-.496,.334),l(-.881,-.042),l(-.222,-.217),l(.165,-.145),l(1.229,-.408),l(.466,-.522),l(.632,-.363),l(-.699,-.129),l(-.601,-.057),l(-.322,.464),l(-.412,.015),l(-.13,-.159),l(.04,-.493),l(-.757,.016),l(-.148,.29),l(-.41,.218),l(-1.052,.045),l(-.709,-.057),l(-1.139,-.186),l(-1.012,-.085),l(-1.355,.061),l(-1.014,.147),l(-.145,-.188),l(-.215,-.463),l(.187,-.175),l(.561,-.334),l(.734,-.408),l(.502,-.161),l(.636,-.335),M(265.435,98.655),l(-.469,-.057),l(-.497,-.273),l(-.356,-.562),l(.062,-.635),l(.742,-.738),l(.932,-1.043),l(.816,.432),l(-.375,.435),l(-.112,.462),l(-.233,.333),l(-.262,.116),l(-.58,.319),l(-.244,.448),l(.522,.244),l(.168,-.029),l(.279,-.26),l(.42,-.362),l(.617,-.319),l(.309,.057),l(.495,.461),l(-.177,.347),l(-.246,.159),l(-1.134,.42),l(-.682,.044),M(211.34,59.677),l(-.68,-.046),l(.068,-.872),l(-.375,-.333),l(-.958,.161),l(-2.375,.29),l(.107,-.461),l(.56,-.303),l(1.644,-.561),l(-.302,-.478),l(-.102,-.415),l(.106,-.417),l(.398,-.835),l(.434,-.566),l(.254,-.648),l(.331,-.471),l(1.11,.566),l(-.312,.518),l(.791,.386),l(.527,.047),l(.402,-.469),l(.67,.112),l(.806,.289),l(.917,.514),l(.582,.255),l(2.168,.492),l(.442,.271),l(.176,.255),l(-.09,.925),l(.539,.047),l(.57,-.065),l(.934,.046),l(.701,.142),l(1.019,.427),l(-.419,.096),l(-.269,.127),l(-.46,.271),l(-.949,-.046),l(-.623,-.125),l(-1.328,-.125),l(-.438,-.126),L(217.259,58),l(-.528,-.301),l(-1.017,-.237),l(-.528,.017),l(-.203,.271),l(.174,.588),l(-.126,.096),l(-1.314,.161),l(-.673,.493),l(-.588,.302),l(-1.116,.287),M(200.125,19.1),l(-.862,-.015),l(-1.085,-.195),l(-.308,-.664),l(.819,-.304),l(.77,-.072),l(.666,-.024),l(3.475,-.125),l(1.263,-.12),l(1.374,-.026),l(1.714,.324),l(.397,-.094),l(.397,-.377),l(1.303,-.287),l(1.759,-.099),l(1.975,.209),l(.746,-.001),l(2.562,.137),l(2.621,.324),l(1.424,.09),l(1.461,.161),l(.448,-.165),l(-1.433,-.42),l(-1.67,-.352),l(-.816,-.429),l(.293,-.242),l(1.361,-.148),l(1.101,-.246),l(1.431,-.101),l(2.382,-.201),l(1.666,.119),l(1.944,.191),l(1.009,.265),l(1.19,.456),l(.354,.047),l(.273,-.362),l(-.959,-.508),l(-.828,-.292),l(.499,-.248),l(1.45,.121),l(1.832,.168),l(1.653,.07),l(1.639,.46),l(.378,.023),l(.062,-.195),l(-.301,-.539),l(1.781,-.004),l(1.408,.046),l(.832,.269),l(.831,.34),l(.618,-.001),l(-.044,-.268),l(-.331,-.467),l(1.075,-.077),l(3.691,.386),l(2.726,.288),l(1.937,-.077),l(2.987,.018),l(.967,.047),l(.757,.12),l(.126,0),l(1.419,.094),l(1.089,.191),l(.744,.095),l(1.685,.044),l(1.357,.357),l(-.385,.358),l(-1.237,.121),l(-1.206,.356),l(-1.849,.191),l(-.978,-.045),l(-2.191,-.159),l(-2.284,.005),l(-.776,.142),l(-1.915,.168),l(-.597,.465),l(.75,.366),l(.761,.044),l(1.03,-.048),l(1.705,-.279),l(.79,.021),l(.808,.434),l(-.168,.114),l(-1.246,.139),l(-1.38,.207),l(-1.174,.295),l(-2.098,.518),l(-1.316,.224),l(-1.19,.355),l(-.924,.286),l(-2.252,.005),l(.65,.906),l(-.449,.193),l(-2.297,.455),l(-.768,-.019),l(-1.587,-.037),l(-1.462,-.218),l(-2.386,-.164),l(-.66,.33),l(2.591,.695),l(-.662,.141),l(-.967,-.038),l(-1.297,.022),l(-1.068,.022),l(-2.58,-.214),l(-2.009,.063),l(-.134,.66),l(1.257,-.105),l(1.065,.018),l(2.312,.292),l(.557,.157),l(.12,.67),l(-.33,.197),l(-1.031,.12),l(-.515,.705),l(-1.073,.021),l(-.448,-.058),l(-.402,.176),l(.297,.253),l(.759,.25),l(-.328,.136),l(-1.615,.08),l(-.867,-.037),l(-1.71,-.171),l(-.422,.078),l(.41,.791),l(-.08,.231),l(-.649,.289),l(-.767,.155),l(-1.52,-.112),l(-2.039,-.111),l(-1.43,-.227),l(-1.008,.079),l(-1.219,.5),l(1.031,.112),l(.368,.057),l(2.154,.11),l(1.759,.13),l(1.534,.168),l(2.001,.034),l(.66,.34),l(.045,.359),l(-.907,.398),l(-2.685,.268),l(-.927,.115),l(-1.054,.227),l(-1.115,.077),l(-.467,-.28),l(-.797,-.638),l(-.56,.039),l(-.631,.001),l(-1.453,-.318),l(-.001,.17),l(.331,.508),l(-1.477,-.016),l(-1.5,-.129),l(-.875,-.319),l(-1.033,-.471),l(-.388,.058),l(.527,.717),l(-.24,.17),l(-.821,.133),l(-1.72,-.109),l(-2.276,-.033),l(-.972,-.073),l(-1.382,-.394),l(-.642,-.131),l(-.282,.453),l(-.619,.152),l(-1.843,-.316),l(.161,-.586),l(.219,-.228),l(1.525,-.117),l(.61,-.249),l(.961,-.173),l(1.179,.036),l(.499,-.172),l(-1.073,-.4),l(-1.043,-.651),l(.052,-.154),l(.479,-.117),l(1.316,.036),l(1.743,.093),l(.888,.21),l(1.108,.517),l(1.35,.323),l(1.085,.093),l(1.667,-.022),l(.829,-.136),l(.086,-.268),l(.514,-.304),l(-3.019,.001),l(-1.025,-.171),l(-.156,-.85),l(.211,-.154),l(-1.74,-.153),l(-1.963,-.152),l(-.274,0),l(-.631,.114),l(.204,-.758),l(1.159,-.551),l(1.104,-.16),l(1.837,-.003),l(1.164,.037),l(1.37,.076),l(2.023,.311),l(1.342,.115),l(.486,-.158),l(1.132,-.041),l(-3.399,-.802),l(-1.742,-.313),l(-3.555,-1.27),l(-.406,.242),l(-1.398,-.878),l(.025,-.258),l(.313,-.108),l(1.747,.104),l(1.905,-.004),l(2.019,.06),l(1.6,.382),l(2.535,.784),l(1.448,-.043),l(.833,.095),l(-1.387,-.555),l(-2.015,-.317),l(1.208,-.743),l(1.456,-.329),l(1.731,-.025),l(1.529,-.222),l(2.042,-.07),l(1.157,-.112),l(1.414,-.051),l(-1.778,-.479),l(-1.425,-.153),l(-2.501,.027),l(-1.243,.248),l(-1.305,.158),l(-1.425,.202),l(-1.447,.047),l(-.586,.067),l(-1.532,-.438),l(-.214,.111),l(-.543,.156),l(-2.16,-.018),l(-1.58,.365),l(.311,-.828),l(.98,-.292),l(.007,-.202),l(-.606,-.247),l(-1.375,-.156),l(-1.39,.003),l(-4.189,.505),l(-2.031,.672),l(-.408,-.11),l(-.569,-.251),l(.395,-.133),l(.678,-.023),l(-.117,-.316),l(-.698,-.398),l(-1.216,-.056),l(-.216,-.003),M(200.125,20.844),l(.899,-.096),l(.832,.196),l(.339,.5),l(.511,.495),l(.427,.063),l(1.141,.041),l(-.081,-.236),l(.056,-.411),l(.438,-.109),l(.718,.194),l(.718,.322),l(.374,.3),l(-.066,.171),l(.056,.826),l(.764,.442),l(.953,-.017),l(1.276,-.074),l(1.646,.504),l(-1.123,-.264),l(-1.528,.34),l(-1.599,.221),l(-.83,.377),l(-.287,.197),l(-.265,.315),l(-.448,.021),l(-1.493,-.41),l(-.656,.335),l(.465,.43),l(-.029,.235),l(-.412,.196),l(-.392,.04),l(-1.086,-.31),l(-.944,-.311),l(-.26,.645),l(-.117,.068),l(-.083,.049),l(-.888,.041),l(-1.74,-.094),l(-1.458,-.153),l(-.888,-.154),l(-.494,.021),l(-3.115,-1.31),l(-.191,-.276),l(1.971,-.241),l(3.32,.093),l(.889,.097),l(1.573,.1),l(-2.485,-.693),l(-3.019,-.213),l(-1.103,.122),l(-1.43,-.017),l(-.597,.18),l(-1.008,.022),l(-.606,-.198),l(-1.066,-.517),l(-1.425,-.479),l(-.341,-.355),l(1.971,.124),l(2.278,-.175),l(-1.255,-.249),l(-.756,-.351),l(.38,-.305),l(.729,-.132),l(.769,-.023),l(.921,.042),l(.156,-.219),l(-1.799,-.793),l(1.053,-.114),l(1.213,-.182),l(1.13,.087),l(.584,-.046),l(.145,-.18),l(-.514,-.475),l(1.362,.134),l(.941,.066),l(.83,.202),l(1.589,.869),l(.653,.264),l(.772,.24),l(.674,-.001),l(.36,-.039),M(179.067,27.216),l(-1.156,-.056),l(-.604,-.173),l(-.926,-.638),l(-.621,-.193),l(-3.102,-.091),l(-1.487,.081),l(-.622,.001),l(-1.444,-.056),l(-.767,-.154),l(-1.019,-.37),l(-.161,-.234),l(.335,-.138),l(.802,-.001),l(1.687,.232),l(.867,-.021),l(-.031,-.235),l(-.252,-.275),l(-1.344,-.49),l(-.579,-.098),l(-1.075,-.077),l(-1.392,-.196),l(.065,-.397),l(2.246,-.124),l(2.392,.155),l(.77,.376),l(.999,.453),l(1.979,.193),l(2.189,.114),l(1.178,.233),l(.604,.254),l(1.123,.721),l(.581,.446),l(.168,.426),l(-.481,.194),l(-.919,.137),M(185.907,26.758),l(-1.078,-.037),L(184,26.529),l(-1.029,-.484),l(-1.144,-.76),l(-.03,-.216),l(.239,-.099),l(2.296,-.044),l(1.816,.311),l(3.101,.542),l(-.047,.351),l(-.254,.331),l(-.436,.04),l(-1.563,.177),l(-1.043,.08),M(156.886,26.865),l(-1.573,.646),l(-.558,.27),l(-1.85,.042),l(-1.019,.079),l(-1.898,-.15),l(-.577,-.114),l(-.302,-.423),l(.334,-.291),l(1.365,-.177),l(.899,.056),l(2.351,-.102),l(.496,0),l(2.331,.163),M(132.902,31.305),l(-.53,-.186),l(-.95,-.466),l(-.424,-.112),l(-.33,.057),l(-.56,.207),l(-1.269,.059),l(-.786,-.279),l(-.283,-.319),l(.23,-.264),l(1.13,-.097),l(.503,-.133),l(.771,-.134),l(.977,-.399),l(.848,-.211),l(.726,-.172),l(.548,-.344),l(1.083,-.231),l(1.277,-.079),l(2.532,-.158),l(1.68,.016),l(.888,-.29),l(1.038,-.079),l(1.503,.438),l(-.756,.097),l(-.852,.231),l(-.22,.268),l(.12,.266),l(.469,.474),l(-.777,.001),l(-.912,.115),l(-.918,.662),l(-1,-.017),l(-.867,-.981),l(-.694,-.15),l(-.379,.02),l(-.229,.285),l(-.588,.342),l(-.63,.623),l(-.595,.151),l(-.284,.375),l(-.705,.356),l(-.787,.058),M(191.827,30.313),l(-1.266,-.054),l(-2.278,-.165),l(-.426,.058),l(-.332,-.094),l(-.896,-.489),l(-1.185,-.414),l(.192,-.229),l(2.433,-.042),l(1.542,.263),l(1.472,.054),l(.171,0),l(.89,.358),l(-.179,.246),l(.123,.32),l(-.263,.188),M(144.688,31.739),l(-2.222,-.395),l(-.325,-.674),l(.503,-.057),l(.595,-.17),l(.945,-.096),l(.953,-.133),l(1.279,-.059),l(.522,.187),l(.65,.374),l(.659,.186),l(1.55,-.209),l(.617,.149),l(1.624,.762),l(1.016,.351),l(.897,.036),l(.96,-.058),l(1.418,.09),l(.591,-.02),l(1.116,-.169),l(.092,-.297),l(-.557,-.559),l(-.941,-.391),l(-1.347,-.354),l(.96,-.322),l(.524,-.379),l(.569,-.152),l(1.097,-.116),l(.507,.17),l(.773,.678),l(-.017,.413),l(.518,.654),l(.565,.111),l(.9,.036),l(1.805,.406),l(-.334,-.465),l(.151,-.28),l(.409,-.076),l(1.495,.24),l(.932,.39),l(-.292,.409),l(.039,.5),l(-.358,.461),l(-.573,.277),l(-.755,.111),l(-.782,.001),l(-1.682,.095),l(-1.156,-.071),l(-1.757,-.18),l(-.622,-.017),l(-1.129,.277),l(-1.132,.202),l(-.76,.182),l(-.977,.254),l(-1.625,.292),l(-1.338,.2),L(149.23,34.5),l(-.748,-.07),l(-1.445,-.286),l(-.276,-.378),l(.648,-.128),l(1.219,-.038),l(.738,-.146),l(.852,-.075),l(1.166,-.057),l(.622,.017),l(1.09,-.149),l(.483,-.553),l(-2.768,-.087),l(-.925,-.054),l(-1.564,.28),l(-1.625,.168),l(-1.292,.04),l(-.795,.093),l(-1.681,-.347),l(-.479,.167),l(-.92,.075),l(-.979,-.127),l(-.854,-.33),l(.023,-.111),l(.863,-.427),l(1.098,-.058),l(2.047,-.022),l(.96,-.159),M(178.479,33.234),l(-.984,-.219),l(-.193,-.294),l(.764,-.389),l(.433,-.112),l(.088,-.167),l(-.447,-.333),l(-1.161,-.054),l(-2.13,.227),l(-.939,.076),l(-.331,.019),l(-.854,-.276),l(.039,-.335),l(.739,-.02),l(.542,-.244),l(.587,-.057),l(-.466,-.598),l(.176,-.245),l(.132,-.226),l(.49,.018),l(.859,.224),l(1.942,.746),l(.426,.186),l(.46,-.094),l(-.101,-.243),l(-.959,-.486),l(-.371,-.131),l(-.407,-.357),l(.436,-.095),l(.956,-.059),l(.713,.131),l(1.033,.262),l(.572,.168),l(.27,.018),l(.162,-.452),l(.478,-.133),l(.73,.112),l(.717,.168),l(.327,.168),l(.367,.75),l(-.034,.616),l(-.247,.242),l(-.831,.335),l(-.017,.352),l(.35,.625),l(-.361,.147),l(-1.648,-.089),l(-.862,.112),l(-1.446,.003),M(200.125,30.572),l(-.895,.045),l(-.853,.17),l(-.37,.467),l(1.133,.054),l(.984,-.038),l(.046,-.001),l(.847,.11),l(.463,.129),l(.498,.463),l(.727,.424),l(.621,.091),l(.213,-.074),l(.043,-.314),l(.286,-.056),l(1.075,-.002),l(.883,-.187),l(.766,.11),l(.835,.239),l(.665,.257),l(.976,.053),l(.775,-.463),l(1.393,-.281),l(1.704,-.114),l(1.951,-.246),l(1.533,.053),l(2.59,.014),l(.381,.037),l(.79,.314),l(.911,.239),l(1.418,.146),l(.653,.128),l(.21,.037),l(.361,.166),l(.181,.257),l(-.4,.148),l(-1.833,.407),l(-.135,.255),l(.469,.666),l(-2.486,.076),l(-.592,.02),l(-.651,.091),l(-.768,-.053),l(-.846,-.16),l(-.405,-.125),l(-.306,-.667),l(-.833,-.218),l(-.366,.129),l(.072,.723),l(-.536,.127),l(-.747,-.053),l(-.91,.109),l(-.728,-.017),l(-.495,.001),l(-1.342,-.213),l(-.593,-.197),l(-.495,-.017),l(-.209,.433),l(-1.801,.111),l(-.831,.074),l(-1.453,-.069),l(-.404,-.251),l(-.144,-.686),l(-1.237,.129),l(-.389,.181),l(-.326,.325),l(-.955,.2),l(-1.011,-.034),l(-.112,-.027),l(-.704,-.169),l(-1.186,-.575),l(-.675,.489),l(-1.131,-.07),l(-.666,-.688),l(-.442,-.717),l(.587,-.481),l(.019,-.371),l(-.292,-.316),l(-1.249,-.651),l(-.617,-.299),l(-.047,-.338),l(.636,-.133),l(1.226,-.078),l(2.472,-.023),l(.763,.093),l(1.118,.261),l(.188,.04),l(.872,.184),l(-.613,.189),l(-.259,.013),M(128.19,41.985),l(-.926,-.016),l(-1.059,-.102),l(-.362,-.466),l(-.549,-.467),l(-.432,-.259),l(-1.123,-.363),l(-1.36,-.067),l(-.951,-.138),l(-.469,-.19),l(-.168,-.174),l(.537,-.106),l(.589,-.298),l(.481,-.211),l(.08,-.386),l(-.437,-.809),l(.552,-.001),l(.468,-.177),l(.307,-.372),l(1.104,-.533),l(.526,-.588),l(-.121,-.32),l(-.271,-.16),l(-1.229,-.677),l(-.375,-.448),l(.869,-.001),l(.823,-.056),l(1.455,.051),l(.97,.016),l(1.515,-.092),l(1.284,-.146),l(1.242,-.074),l(.495,.125),l(3.242,.801),l(.918,.088),l(.708,-.055),l(1.316,-.127),l(1.223,.016),l(.771,.07),l(1.35,.373),l(2.389,.815),l(-.242,.143),l(-.432,.036),l(-.26,.072),l(-1.609,.322),l(-1.073,.144),l(-1.829,.428),l(-1.069,.319),l(-1.604,.725),l(-1.025,.563),l(-.549,.089),l(-.974,.124),l(.066,.924),l(-.271,.504),l(-.662,.278),l(-1.215,.124),l(-1.213,-.067),l(-.521,.485),l(-.898,.312),M(190.483,39.666),l(-1.146,-.208),l(-.146,-.524),l(-.941,-.806),l(-.207,-.582),l(.058,-.389),l(.27,-.657),l(.377,-.321),l(1.256,.033),l(-.089,-.16),l(-.416,-.266),l(-.185,-.286),l(.211,-.09),l(.234,-.072),l(2.154,-.058),l(1.215,.087),l(1.464,.248),l(1.282,.051),l(1.316,-.146),l(1.051,.016),l(.694,.105),l(.639,.213),l(-.007,.089),l(-.224,.179),l(-.824,.428),l(-.874,.746),l(-1.513,.92),l(-1.386,.073),l(-2.379,-.154),l(-1.269,.055),l(1.392,.717),l(-.188,.315),l(-.855,.369),l(-.964,.072),M(181.204,41.523),l(-.491,-.085),l(-1.101,-.552),l(-.952,-.641),l(-1.014,-.468),l(-.978,-.225),l(-1.438,-.12),l(-.55,-.174),l(-2.255,-1.066),l(.866,-.654),l(.653,.14),l(1.032,.474),l(1.063,.227),l(.46,.052),l(.615,-.283),l(.908,-.619),l(.415,-.036),l(.018,-.212),l(-1.062,-.565),l(-1.068,-.424),l(-.177,-.231),l(.132,-.107),l(1.683,.086),l(.711,-.215),l(.42,0),l(.996,.39),l(.56,.035),l(.58,-.055),l(.435,-.25),l(1.232,-.127),l(1.354,.069),l(.912,.23),l(-.324,.268),l(-.58,.125),l(-.323,.338),l(-1.55,.375),l(-.392,.16),l(-.069,.194),l(.253,.247),l(.506,.105),l(.692,-.089),l(1.08,.174),l(.868,.245),l(.391,.017),l(.564,.262),l(.186,.438),l(-.681,.352),l(-.156,.35),l(-.271,.68),l(-.457,.366),l(-.508,.14),l(-.658,.019),l(-.582,-.103),l(-.773,-.346),l(-.653,-.103),l(.013,.208),l(1.054,.553),l(-.817,.399),l(-.77,.036),M(243.524,60.394),l(-.234,-.208),l(-1.199,-.235),l(-.673,-.331),l(-.154,-.269),l(.346,-.064),l(.616,-.461),l(-1.378,-.521),l(-1.132,-.125),l(-.76,-.349),l(-.929,-.731),l(-.035,-.511),l(-1.115,-.062),l(-1.311,-.366),l(-.675,-.031),l(.284,.767),l(-.155,.096),l(-.409,-.015),l(-1.704,-.332),l(-.309,.033),l(-.325,.304),l(-.441,.288),l(-1.312,.082),l(-1.349,-.173),l(-1.343,-.189),l(-.813,-.254),l(-.052,-.319),l(.196,-.4),l(.382,-.354),l(1.066,-.163),l(.192,-.178),l(-.128,-.516),l(.206,-.033),l(1.357,.11),l(1.408,.175),l(.517,.144),l(.962,.626),l(.051,-.386),l(-.154,-.193),l(.077,-.194),l(.585,-.033),l(.977,-.099),l(.652,-.163),l(.649,-.114),l(.515,.063),l(.785,.031),l(.166,-.275),l(-1.138,-.825),l(-.773,-.356),l(-.119,-.228),l(.167,-.163),l(.586,-.066),l(.72,-.246),l(1.409,-.591),l(.361,-.541),l(.771,-.46),l(.493,-.379),l(-.109,-.593),l(-.899,-.841),l(-.407,-.496),l(-.541,-.364),l(-.414,.001),l(-1.258,-.33),l(-1.041,-.481),l(-.244,-.467),l(-.527,-.384),l(-.442,.202),l(-.551,.202),l(-.825,-.015),l(-.293,.117),l(-.62,.018),l(-1.255,.169),l(-.214,-.667),l(1.032,-.052),l(1.23,-.103),l(.163,-.269),l(-1.604,-.618),l(-1.552,-.67),l(-.879,-.015),l(-.567,-.185),l(-.169,-.542),l(-.677,-.339),l(-.45,-.05),l(-.918,-.306),l(-.687,-.341),l(-.385,-.119),l(-.611,.155),l(-.81,-.187),l(-1.177,-.238),l(-.489,-.085),l(-.379,.138),l(.529,.307),l(.453,.05),l(2.838,.712),l(.438,.271),l(.069,.306),l(-.505,.221),l(-.669,.069),l(-.541,-.033),l(-.757,-.049),l(-.818,-.252),l(-1.153,-.27),l(-.667,-.066),l(-.323,.17),l(.044,.204),l(.426,.236),l(.259,.438),l(-1.703,-.553),l(-.47,-.05),l(-.396,.119),l(-.63,.153),l(-.767,-.218),l(-.693,-.117),l(-.859,.12),l(-1.474,-.184),l(-1.995,-.167),l(-1.321,.037),l(-1.146,-.032),l(-.862,-.186),l(-.003,-.597),l(-.363,-.153),l(-.904,-.049),l(-.396,.342),l(-.623,.086),l(-1.214,-.049),l(-1.076,-.168),l(-1.303,-.477),l(-.415,-.376),l(.123,-.275),l(.868,-.07),l(1.131,.067),l(1.212,.101),l(.879,-.019),l(.312,-.19),l(-.934,-.463),l(-.8,-.275),l(-.905,-.102),l(-1.106,-.119),l(-.752,.036),l(-.539,-.017),l(-1.249,-.223),l(.114,-.416),l(.292,-.557),l(.34,-.14),l(.646,-.054),l(.081,-.227),l(-1.082,-.4),l(-.044,-.175),l(.449,-.79),l(1.197,-.919),l(.565,-.284),l(.918,-.321),l(.74,-.374),l(.423,-.037),l(.37,-.178),l(.698,-.001),l(.481,-.125),l(.71,-.09),l(1.436,-.109),l(1.348,.033),l(.857,.194),l(-.92,.393),l(-.815,.48),l(-1.394,.639),l(-.43,.529),l(.169,.369),l(1.256,.541),l(-.444,.298),l(-.076,.402),l(.257,.313),l(.862,.554),l(1.559,.621),l(-.096,.121),l(-1.272,.331),l(-.072,.31),l(.959,.033),l(1.504,.101),l(.654,-.639),l(-.103,-.415),l(-.343,-.277),l(-.724,-.103),l(-.422,-.138),l(-.884,-.538),l(.101,-.157),l(.506,-.245),l(.473,-.193),l(1.001,.12),l(.837,-.071),l(-1.204,-.47),l(-.703,-.034),l(-.793,-.279),l(-.056,-.193),l(.053,-.545),l(.886,-.319),l(1.207,.086),l(1.509,-.056),l(-.939,-.281),l(-1.233,-.351),l(.793,-.303),l(1.288,-.198),l(1.044,-.126),l(1.688,-.323),l(1.114,.016),l(.642,.052),l(.833,.141),l(.782,.478),l(1.536,.97),l(.058,.141),l(-.583,.687),l(-.709,.632),l(.038,.733),l(.364,.086),l(.65,.033),l(1.088,-.315),l(.284,-.455),l(.595,-.088),l(.791,.034),l(.454,.174),l(-.006,.262),l(.16,.47),l(.875,.189),l(.196,-.122),l(-.204,-.854),l(.218,-.123),l(.456,-.474),l(1.038,-.265),l(.98,-.054),l(.748,.034),l(.98,.174),l(1.172,.138),l(1.151,-.09),l(.688,.139),l(.327,.262),l(.621,.331),l(.574,.191),L(235.438,40),l(0,.191),l(-.531,.088),l(-.484,.279),l(-.818,.262),l(-.148,.225),l(.45,.259),l(.427,.068),l(.897,-.417),l(.652,-.174),l(.502,.051),l(.476,.242),l(.365,.466),l(.516,.413),l(.342,-.242),l(1.304,-.798),l(1.935,.256),l(.915,.361),l(-.051,.069),l(-.638,.346),l(-.708,.517),l(1.167,-.054),l(.455,-.173),l(1.078,-.105),l(.033,.704),l(.797,.324),l(.523,-.069),l(.831,-.207),l(1.316,-.088),l(.816,.221),l(.566,.273),l(-.162,.154),l(-.461,.223),l(-1.87,.43),l(-.238,.272),l(.523,.253),l(.456,-.068),l(.747,-.171),l(1.235,-.122),l(.406,-.29),l(.361,-.103),l(.479,.067),l(.51,.187),l(.544,.339),l(.636,.522),l(-1.019,.002),l(-1.2,.053),l(-.424,.135),l(.059,.269),l(.372,.134),l(1.333,.065),l(.938,.183),l(.543,.217),l(.233,.301),l(-.37,.034),l(-.748,.001),l(-1.011,-.082),l(-.875,-.216),l(-.824,-.065),l(-.316,.185),l(1.23,.583),l(-.216,.201),l(-1.552,.12),l(.245,.283),l(.437,.166),l(.551,.032),l(1.331,.364),l(1.312,.347),l(.247,.182),l(.039,.282),l(.351,.38),l(.75,-.217),l(.536,.049),l(1.413,.295),l(.298,-.067),l(.649,-.15),l(.61,.032),l(.752,.379),l(.862,.477),l(.376,.346),l(-.685,.1),l(-.801,.117),l(-.027,.444),l(.795,-.001),l(1.405,-.052),l(.51,-.132),l(.895,.048),l(-.386,.559),l(.918,.179),l(.514,-.001),l(.943,-.379),l(.685,.343),l(1.089,.407),l(.194,.098),l(-.275,.229),l(-.254,.099),l(-.103,.326),l(-.819,.05),l(-.718,-.21),l(-.247,-.048),l(-.794,.213),l(.968,.454),l(.279,.162),l(.057,.276),l(-1.057,.197),l(-.356,.228),l(-.312,.292),l(-.372,-.113),l(-.819,-.583),l(-.29,1.103),l(.354,.903),l(-.419,.065),l(-.677,-.257),l(-.751,-.176),l(-.205,-.177),l(-.018,-.243),l(-.315,-.274),l(-.93,.276),l(-.743,-.613),l(.051,-.292),l(.27,-.374),l(-.304,-.129),l(-.224,-.016),l(-.992,-.08),l(-.718,-.292),l(-1.17,-.617),l(-.769,-.292),l(-.762,-.048),l(-.452,.23),l(-.645,.083),L(250,52.592),l(.281,.179),l(1.05,.682),l(-.321,.114),l(-.686,.05),l(-.359,-.259),L(249.277,53),l(-.646,-.21),l(.275,.488),l(.859,.972),l(.604,.015),l(.587,.08),l(.5,.581),l(.612,.805),l(.513,.432),l(.615,-.321),l(.285,.047),l(.592,.399),l(.585,.271),l(1.38,.396),l(-.634,.113),l(-.213,.208),l(.254,.19),l(.568,.286),l(.962,.444),l(.324,.237),l(.242,.682),l(-.112,.428),l(-1.302,-1.155),l(-.554,-.237),l(-.027,.238),l(.118,.27),l(1.055,1.281),l(-.01,.3),l(-.926,-.125),l(.053,.205),l(.432,.409),l(.378,.519),l(-.563,-.172),l(-.615,-.313),l(-.889,-.693),l(-.145,-.031),l(-.719,.064),l(-.91,-.188),l(-1.44,-.662),l(-.319,-.285),l(-1.062,-.665),l(.187,.777),l(-1.22,-.473),l(-.567,-.158),l(-.872,-.03),l(.095,.222),l(.799,.696),l(.853,.426),l(1.842,.645),l(1.296,.644),l(.774,.549),l(.442,.486),l(.429,.689),l(-1.833,-.341),l(-1.524,-.421),l(-1.251,-.28),l(-1.444,-.107),l(-1.092,-.25),l(-.898,-.644),l(-1.146,-.14),l(-.638,-.204),l(-.635,-.141),l(-.058,.145),M(146.194,38.698),l(.818,-.037),l(.78,-.125),l(1.138,-.548),l(.895,-.019),l(1.723,.243),l(.939,.262),l(-.188,.877),l(.515,-.071),l(.66,-.019),l(.792,-.229),l(.599,-.141),l(.758,.016),l(.334,-.071),l(-.989,-.965),l(.156,-.036),l(1.38,.138),l(1.208,.245),l(.675,.245),l(.259,.245),l(.194,.508),l(.965,1.063),l(.638,.346),l(1.045,-.315),l(.14,-.261),l(-1.243,-1.361),l(-.439,-1.321),l(.228,-.354),l(1.91,.262),l(1.775,.156),l(2.031,.719),l(.36,.175),l(.3,.316),l(.16,.701),l(.511,.645),l(.352,.26),l(.856,.606),l(.048,.19),l(-.178,.243),l(-.333,.605),l(.179,.31),l(.224,.12),l(1.4,.649),l(.509,.171),l(1.151,.254),l(1.513,.1),l(2.056,.576),l(1.012,.39),l(.364,.793),l(-.168,.101),l(-1.071,-.082),l(-.811,-.234),l(-.945,-.234),l(-.551,.169),l(-.665,.204),l(-1.021,.036),l(-.256,.118),l(.208,.689),l(1.087,-.069),l(.614,-.152),l(.676,-.119),l(.876,.536),l(-.01,.235),l(-.526,.151),l(-.517,.252),l(-.583,.102),l(-1.417,.12),l(-1.049,-.015),l(-1.194,-.082),l(-1.594,-.248),l(-2.278,-.499),l(-.553,-.217),l(-.436,-.335),l(-.482,-.033),l(-.581,.102),l(-.402,.37),l(-1.114,.505),l(-1.055,.019),l(-1.411,.103),l(-1.253,.42),l(-2.753,.356),l(-1.42,.019),l(-1.205,.086),l(-1.984,-.063),l(-.483,.101),l(-.916,-.015),l(-1,-.282),l(-.061,-.468),l(.198,-.101),l(.002,-.302),l(-.395,-.2),l(-.462,-.1),l(-3.146,-.112),l(-1.258,-.115),l(-.864,-.167),l(-.801,-.2),l(-.753,-.504),l(-1.274,-.554),l(.303,-.069),l(.531,-.222),l(1.572,-.054),l(.603,-.188),l(.558,.016),l(.91,-.019),l(.904,-.087),l(1.716,.031),l(.935,-.002),l(2.14,.047),l(1.09,-.002),l(1.711,-.038),l(.415,-.154),l(-.681,-.221),l(-2.312,-.492),l(-1.942,-.202),l(-4.059,-.061),l(-1.569,-.014),l(-1.694,.055),l(-.955,.053),l(-.604,.001),l(-1.651,-.529),l(.011,-.207),l(.28,-.069),l(.823,-.053),l(1.315,-.209),l(.996,.032),l(1.78,-.141),l(.931,-.105),l(.5,-.277),l(-.392,-.346),l(-2.023,.073),l(-1.578,.159),l(-.393,-.051),l(-.554,-.189),l(-.677,-.346),l(-.65,-.19),l(-.692,.054),l(-.709,-.242),l(-.039,-.279),l(1.304,-.981),l(2.62,-.848),l(.909,-.143),l(.373,-.177),l(1.297,-.267),l(1.324,-.162),l(.701,-.267),l(1.113,-.091),l(1.026,.246),l(-.07,.212),l(-.548,.354),l(-.021,.81),M(251.273,99.526),l(-.188,.153),l(-.16,-.291),l(.192,-.077),l(-.02,-.256),l(.143,-.069),l(-.042,-.154),l(-.224,0),l(-.606,-.231),l(.077,-.229),l(-.31,-2.819),l(-.174,-.274),l(-.488,-.288),l(-.771,-.025),l(-.41,.176),l(-.381,-.085),l(-.505,-.36),l(-.273,-.085),l(-.632,.526),l(-.514,.626),l(-1.139,2.22),l(-1.139,1.45),l(-1.161,-.124),l(-.402,.06),l(-.363,.435),l(-.174,.375),l(-1.093,-.095),l(-1.855,-.004),l(-2.508,-.029),l(-1.76,.009),l(-.968,.523),l(-.534,.305),l(-1.754,.814),l(-.545,.164),l(-.146,.434),l(-.163,.512),l(-.44,.275),l(-1.156,.197),l(-1.305,-.138),l(-1.123,-.01),l(-.93,.091),l(-.47,.203),l(-.162,.375),l(.018,.319),l(.16,.471),l(.047,.362),l(-.875,.427),l(-1.464,.452),l(-.944,.163),l(-.919,.062),l(-.88,.262),l(-.939,.478),l(-.925,.506),l(-.524,.117),l(-.573,-.068),l(-.497,-.169),l(-.371,-.427),l(-.012,-.33),l(.044,-.218),l(.707,-.525),l(.414,-.294),l(.264,-.433),l(.294,-.544),l(.377,-.576),l(.028,-.746),l(-.054,-.545),l(-.876,-3.16),l(-2.529,-1.05),l(-.26,-.33),l(.11,-.318),l(-.307,-.235),l(-.916,-.181),l(-.184,-.294),l(-.178,-.135),l(-.628,.024),l(-.46,-.465),l(-.101,-.429),l(-2.15,-1.061),l(-3.975,-1.576),l(-.977,-.386),l(-.797,-.227),l(-.805,.189),l(-1.469,.592),l(-.707,-.074),l(-.542,.049),l(-.196,-.144),l(-.156,-.115),l(-.474,-.041),l(-.855,.083),l(-.197,-.116),l(-.028,-.282),l(-.373,.075),l(-.412,.191),l(-.219,.06),l(-.573,.141),l(-.506,-.098),l(-.064,-.185),l(-.469,-.086),l(-.241,-.271),l(-.502,-.013),l(-.16,.247),l(-.338,-.48),l(-.271,.012),l(-.02,-.185),l(-1.425,-.208),l(-.518,.076),l(-.833,-.451),l(-.468,-.46),l(-.279,-.371),l(-.896,-.748),l(-.501,.036),l(.131,.347),l(.387,.588),l(-.68,-.003),l(-2.687,.029),l(-2.798,-.029),l(-1.348,.007),l(-2.105,-.003),l(-2.915,.016),l(-2.781,-.029),l(-2.131,.012),l(-2.935,-.014),l(-.601,.003),l(-4.84,-.018),l(-3.617,.004),l(-.875,.005),l(-3.821,-.023),l(-1.089,.035),l(-4.13,-.021),l(-.74,-.011),l(-5.117,.028),l(-1.687,-.006),l(-2.87,.001),l(-3.938,-.008),l(-4.588,.025),l(-1.335,-.022),l(-2.579,-.001),l(-.194,-.013),l(-.187,-.151),l(-.509,-.305),l(-.071,-.437),l(.074,-.346),l(-.708,.25),l(-.373,-.029),l(-.331,-.305),l(-.162,-.496),l(-.125,-.189),l(-.385,.088),l(-.23,.205),l(-.483,.059),l(-.721,-.495),l(-.119,-.425),l(-.201,-.821),l(-1.051,.104),l(-1.01,-.277),l(-.487,-.087),l(-.173,-.087),l(-.143,-.396),l(-.438,-.352),l(-.591,.222),l(-1.236,.046),l(-.461,-.117),l(-.383,-.249),l(-.106,-.25),l(.257,-.648),l(.458,-.222),l(-.227,-.294),l(-1.24,-.086),l(.617,-.518),l(.398,-.281),l(.547,-.149),l(.605,-.508),l(-.874,.006),l(-.621,.149),l(-.362,-.043),L(116,83.422),l(-.039,-.978),l(-.789,.002),l(-1.015,-1.066),l(.132,-.238),l(.034,-.53),l(-.547,.056),l(-.83,.492),l(-1.266,-.934),l(-.384,-.521),l(-.204,-.402),l(-.068,-.432),l(.419,-.404),l(.161,-.254),l(.436,-.3),l(-.358,-.689),l(-.393,-.777),l(.163,-.788),l(-.402,-.255),l(-2.025,-.763),l(-.98,-.314),l(-.189,-.029),l(-.512,-.393),l(-1.67,-1.882),l(-1.769,-1.768),l(-.814,-.58),l(-2.048,-1.175),l(-.35,-.322),l(-.371,-.492),l(-.316,-.199),l(-.832,-.073),l(-.495,.126),l(-.731,.498),l(-1.225,.67),l(-.848,.205),l(-.238,.325),l(-.945,-.673),l(-2.162,-1.318),l(-.348,-.292),l(-.173,-.387),l(-.332,-.388),l(-.739,-.059),l(-2.424,.122),l(-.84,-.074),l(-.196,-.279),l(-.089,-1.046),l(-.026,-2.167),l(.043,-4.334),l(.026,-2.183),l(-.129,-2.796),l(-.052,-2.335),l(-.039,-2.259),l(.003,-2.855),l(-.102,-.483),l(.71,.024),l(.9,-.086),l(.964,.116),l(2.012,.451),l(1.601,.518),l(1.214,.266),l(1.04,.115),l(.731,.032),l(1.619,.164),l(.888,.232),l(.429,.149),l(.254,-.034),l(-.452,-.601),l(-.357,-.2),l(-.345,-.15),l(-.064,-.419),l(1.344,-.423),l(.745,.066),l(.578,-.068),l(.15,-.102),l(1.736,.148),l(.771,-.001),l(1.125,-.373),l(.309,-.186),l(.442,0),l(.656,-.221),l(.759,-.069),l(.866,-.086),l(.734,-.086),l(.469,-.239),l(.392,-.188),l(.771,-.104),l(1.045,-.002),l(.872,.123),l(-.445,.404),l(-.352,.119),l(-1.101,.137),l(-1.092,.373),l(-1.244,.171),l(-1.22,.271),l(-.699,.522),l(-1.767,.255),l(-.681,.487),l(.846,.266),l(1.441,.748),l(-.219,-.55),l(.168,-.351),l(1.196,-.253),l(.39,-.235),l(.726,-.421),l(1.727,-.053),l(.96,-.372),l(1.158,-.389),l(2.066,-.173),l(.643,-.338),l(.921,-.272),l(.821,-.189),l(.476,-.239),l(-.178,-.272),l(-.702,-.392),l(-.655,-.444),l(.899,.101),l(.764,.272),l(.701,.306),l(.412,.324),l(.376,.476),l(.449,.523),l(.393,.235),l(1.246,.486),l(.186,.067),l(1.154,.216),l(.394,-.018),l(.199,-.151),l(-.511,-.639),l(.07,-.27),l(.548,-.035),l(.334,-.136),l(.627,-.103),l(.383,.354),l(.059,.421),l(-.205,.287),l(.833,.133),l(.938,-.069),l(1.136,-.457),l(.536,-.49),l(.479,-.069),l(1.131,.015),l(1.536,.267),l(1.745,.435),l(1.396,.334),l(2.095,.349),l(1.024,.216),l(.619,.066),l(1.572,.282),l(1.121,.065),l(1.144,.148),l(1.096,.032),l(1.4,-.086),l(.899,.099),l(1.008,.282),l(.982,.349),l(.434,.249),l(.191,.333),l(-.524,.134),l(-.935,-.032),l(-.566,.051),l(-.849,.135),l(-.354,.714),l(3.323,.358),l(1.726,.079),l(1.749,.014),l(.868,-.068),l(.738,-.051),l(.94,-.167),l(.895,-.118),l(.938,-.101),l(.886,.032),l(1.432,.477),l(1.452,.179),l(.42,.115),l(1.225,.443),l(-.013,.312),l(-.504,.083),l(-.35,.247),l(.305,.147),l(1.823,.979),l(-.162,-.392),l(-.024,-.312),l(.456,-.05),l(.617,-.132),l(-.062,-.181),l(-.972,-.656),l(-.128,-.198),l(-.145,-.445),l(.121,-.745),l(.35,-.034),l(1.944,-.136),l(.928,-.151),l(.207,-.299),l(.459,-.217),l(.613,-.035),l(1.098,.281),l(1.528,.279),l(.968,.064),l(.969,-.102),l(.612,.414),l(.248,.082),l(.962,.213),l(1.211,.13),l(.678,.081),l(1.146,-.002),l(.879,-.2),l(1.755,-.02),l(1.876,.029),l(1.07,-.052),l(1.18,-.267),l(.959,.478),l(.95,.296),l(.522,-.018),l(.243,-.314),l(-.017,-.513),l(-.666,-.231),l(-.732,-.131),l(-1.377,-.064),l(.089,-.449),l(1.193,-.085),l(.575,.065),l(.804,.214),l(.871,.198),l(.858,.048),l(.498,.198),l(.088,.183),l(-.095,.132),l(-.287,.86),l(.179,.51),l(.304,.164),l(.177,.065),l(.792,.097),l(.951,.311),l(-.071,-.559),l(-.466,-.989),l(.137,-.48),l(.258,-.266),l(.712,.015),l(.811,-.035),l(1.229,-.85),l(.492,-.051),l(.479,-.001),l(.517,-.151),l(.033,-.133),l(-.15,-.367),l(-.375,-.35),l(-.307,.001),l(-.81,.185),l(-.988,-.082),l(.535,-.52),l(.806,-.069),l(.435,-.168),l(.572,-.001),l(.739,.4),l(.464,.167),l(.065,-.268),l(-.081,-.956),l(-.744,.069),l(-.897,-.032),l(-.68,-.116),l(-.859,-.318),l(-.725,.085),l(-1.245,-.183),l(-.861,-.234),l(-.956,-.218),l(-.657,-.338),l(-.092,-.136),l(-.022,-.324),l(.33,-.137),l(.842,-.463),l(-.486,-.221),l(-1.188,-.375),l(.09,-.207),l(.58,-.604),l(.593,-.294),l(.387,-.035),l(1.032,.257),l(.139,-.035),l(.173,-.346),l(-.709,-.362),l(-.201,-.277),l(.23,-.035),l(.551,-.331),l(.367,-.035),l(1.841,-.021),l(.559,.086),l(.728,.189),l(1.26,.449),l(.432,.328),l(.195,.38),l(-.246,.603),l(1.261,.53),l(.809,.495),l(1.134,.493),l(-.377,.341),l(-.985,.036),l(-.474,.273),l(-.416,.557),l(.471,.067),l(1.071,.233),l(.805,.049),l(.387,-.136),l(.597,-.001),l(1.477,.351),l(-.335,.353),l(-.563,.219),l(.092,.151),l(.796,.467),l(.358,.601),l(.025,.833),l(.303,-.063),l(.021,-.004),l(.411,-.067),l(.608,-.367),l(.655,-1.137),l(.668,-.42),l(.523,.016),l(.731,.284),l(1.064,.55),l(.473,.383),l(.209,.45),l(-.159,.433),l(-.336,.034),l(-.796,-.098),l(-.202,.299),l(-.043,.415),l(.35,.396),l(1.146,.659),l(.61,.493),l(.463,.279),l(.595,-.166),l(.896,-.167),l(.369,-.132),l(.208,-.66),l(.764,-.398),l(.599,-.416),l(.249,-.664),l(.363,-.75),l(.237,-.184),l(1.394,.081),l(.329,-.067),l(.134,-.518),l(-.985,-.333),l(-.918,-.35),l(.088,-.891),l(.595,-.271),l(.787,.032),l(.42,-.068),l(.571,.016),l(3.459,.616),l(1.325,.669),l(.506,-.001),l(.553,-.068),l(.454,.201),l(.244,1.036),l(-.474,.268),l(-.431,.101),l(-.243,-.05),l(-.718,-.532),l(-.263,0),l(-.799,.269),l(.123,.316),l(.309,.515),l(.699,.729),l(.855,.528),l(1.108,.576),l(.024,.313),l(-.478,.642),l(-.439,.181),l(-1.407,.772),l(-.674,.083),l(-1.123,.509),l(-.763,-.276),l(-1.654,-.962),l(-.586,-.262),l(-.497,-.048),l(-.684,.281),l(1.364,.521),l(1.483,.896),l(-.708,.067),l(-.691,-.081),l(-1.288,.084),l(-.375,-.129),l(-.596,-.62),l(-1.147,-.014),l(-1.857,.118),l(-.253,.229),l(.614,.244),l(1.311,.421),l(-.159,.195),l(-.611,.327),l(-2.045,1.106),l(-.657,.179),l(-.527,.001),l(-.859,-.241),l(-.816,-.484),l(-.225,-.081),l(-1.189,-.225),l(-.736,-.259),l(-.598,-.112),l(-.947,.014),l(-.289,.004),l(-1.214,.174),l(1.503,.278),l(1.136,.21),l(1.751,.774),l(1.629,.433),l(1.233,.126),l(1.02,.031),l(-.618,1.091),l(-1.237,.705),l(-.856,.432),l(-.728,.161),l(-.829,.049),l(-.928,-.126),l(-1.062,-.38),l(-.048,.351),l(-.025,.287),l(.321,.572),l(-.02,.159),l(-.741,.031),l(-.058,.002),l(-1.365,-.108),l(-1.649,-.41),l(-.884,-.078),l(-2.962,-.322),l(2.146,.864),l(1.576,.156),l(1.367,.267),l(.562,.205),l(.33,.268),l(-.011,.19),l(-.642,.333),l(-1.106,.207),l(-1.429,-.076),l(-.511,-.062),l(-.367,.269),l(1.254,.423),l(-.469,.426),l(-1.06,.316),l(-1.454,.662),l(-.421,.252),l(.218,.704),l(-.313,.235),l(-.909,.205),l(-.31,.282),l(-.529,.64),l(-.276,.296),l(-.241,.669),l(-.274,.543),l(-.323,.666),l(.056,.416),l(-.161,.554),l(.123,.875),l(.136,.536),l(.598,.366),l(.25,.015),l(.257,.091),l(.664,.014),l(1.164,-.094),l(.276,.045),l(.367,.29),l(.413,.763),l(.813,1.157),l(.22,.668),l(-.132,.91),l(.673,.014),l(1.874,-.428),l(1.261,-.033),l(.723,.074),l(.535,.157),l(1.062,.311),l(2.129,.435),l(1.896,.903),l(.993,.933),l(3.5,.67),l(.644,.225),l(.982,.403),l(.986,.253),l(.553,.104),l(.702,-.091),l(.453,.044),l(.828,-.077),l(1.245,.163),l(1.407,.207),l(.401,.194),l(-.297,.702),l(-.142,.85),l(.154,.283),l(.307,.342),l(.07,.416),l(-.115,1.025),l(-.309,.593),l(.022,.208),l(.604,.266),l(.481,.339),l(.264,.354),l(.046,.488),l(-.076,.354),l(.97,.116),l(.963,.47),l(.676,.588),l(.392,.588),l(.078,.162),l(.64,.014),l(.726,.41),l(.907,.601),l(-.349,-.66),l(-.22,-.279),l(.134,-.338),l(.573,-.414),l(.365,.176),l(.381,.456),l(.262,.353),l(.165,-.354),l(.107,-.545),l(-.215,-.456),l(.541,-.532),l(.139,-.546),l(-.183,-.517),l(-.337,-.458),l(-.261,-.754),l(-.004,-.548),l(-.205,-.593),l(-.218,-.43),l(.615,-.016),l(-.097,-.476),l(-.296,-.252),l(-.657,-.163),l(-.375,-.282),l(-.326,-.923),l(1.252,-.271),l(.872,-.241),l(.625,-.271),l(1.758,-.949),l(.629,-.302),l(1.043,-.935),l(.434,-.544),l(.237,-.665),l(.054,-.529),l(-.257,-1.045),l(-.246,-.531),l(-.239,-.319),l(-.938,-.729),l(-.467,-.274),l(-1.105,-.532),l(-.363,-.122),l(-.453,-.274),l(-.151,-.046),l(-.293,-.351),l(.08,-.107),l(.868,-.522),l(.553,-.875),l(.293,-.416),l(.25,-.092),l(.447,-.017),l(.295,-.277),l(-.106,-.523),l(-.18,-.355),l(-.316,-.402),l(-.048,-.202),l(.258,-.357),l(.005,-.264),l(-1.751,-.105),l(1.084,-.92),l(.503,-.704),l(.007,-.125),l(-.316,-.203),l(-.609,-.265),l(-.244,-.266),l(-.043,-.533),l(.305,-.425),l(.554,-.315),l(.57,-.19),l(.827,.062),l(1.781,.374),l(1.097,.234),l(.753,.077),l(1.44,.013),l(1.08,-.144),l(.86,-.222),l(.21,-.047),l(.179,-.063),l(.589,.078),l(.991,.407),l(.254,.125),l(.754,.454),l(.918,.375),l(.796,.437),l(-.294,.391),l(.406,.233),l(1.698,.496),l(1.958,.354),l(.725,-.033),l(.368,-.203),l(.339,.295),l(-.013,.404),l(-.577,.343),l(-.123,.45),l(.438,1.327),l(.136,.722),l(.23,.414),l(-.049,.353),l(-.248,.169),l(-.445,-.014),l(-.347,-.015),l(-.138,.674),l(.375,.274),l(1.137,-.415),l(.366,-.047),l(.781,-.047),l(.286,.015),l(.677,.32),l(.378,.351),l(.004,.259),l(-.081,.123),l(.277,.32),l(.516,-.184),l(.306,-.046),l(1.173,-.079),l(.636,-.184),l(.436,-.383),l(.333,-.551),l(.326,.015),l(.194,.122),l(.693,.717),l(.042,-.062),l(.108,-.764),l(.317,-.583),l(.475,-.262),l(.539,-.385),l(-.651,-.505),l(.008,-.308),l(.272,-.139),l(.98,-.094),l(.193,-.139),l(.512,-.665),l(.667,.37),l(.607,.599),l(.785,.506),l(.596,.797),l(1.045,.764),l(.264,.352),l(-.344,.291),l(.095,.335),l(.573,-.031),l(.365,.777),l(.182,.183),l(.324,.121),l(.743,.136),l(.281,.258),l(.133,.38),l(-.379,.092),l(-.416,.168),l(.411,.318),l(.397,.227),l(.77,.196),l(.279,.227),l(.034,.424),l(-.056,.076),l(-.409,.106),l(-.676,-.029),l(-.745,-.12),l(-.316,.061),l(.091,.166),l(.273,.181),l(.189,.241),l(.333,.513),l(.411,.226),l(.634,.029),l(.462,.18),l(.838,.496),l(.899,.435),l(.246,.33),l(-.035,.195),l(-.447,.781),l(.508,.059),l(.663,-.166),l(.786,-.077),l(.79,.164),l(.574,.194),l(1.162,.49),l(.981,.132),l(1.517,.295),l(-.184,.253),l(-.718,.21),l(-.736,.21),l(-.663,.046),l(-.834,.24),l(-.583,.402),l(-.65,.225),l(-1.032,.061),l(-.286,.075),l(-.324,.268),l(.029,.371),l(-.271,.535),l(1.175,-.343),l(.542,-.09),l(.649,-.105),l(1.201,-.774),l(1.251,-.478),l(1.146,-.106),l(.662,.237),l(.35,.341),l(-.398,.446),l(.036,.119),l(.307,.296),l(.616,-.224),l(.455,-.164),l(.655,.192),l(1.051,.487),l(.226,.251),l(.022,.178),l(-.299,.43),l(-.05,.355),l(-.406,.444),l(1.001,.929),l(-.365,.37),l(-.795,.282),l(-1.078,.621),l(-.662,.281),l(-1.097,.046),l(-.823,.119),l(-1.548,.077),l(-.433,.413),l(-.916,.795),l(-.686,.427),l(-.612,.294),l(-.938,.222),l(-1.494,.172),l(-1.845,.127),l(-1.452,-.07),l(-2.031,-.084),l(-.355,.03),l(-1.073,.075),l(-1.058,-.012),l(-1.873,-.099),l(-.917,-.027),l(-1.758,.106),l(-.547,.206),l(-.523,.294),l(-.537,.585),l(-.205,.554),l(-.287,.335),l(-.591,.19),l(-1.07,.104),l(-.537,.147),l(-1.098,.555),l(-.774,.54),l(-.794,.612),l(-.325,.363),l(-.33,.233),l(-.868,.843),l(-.485,.566),l(-.418,.276),l(-.46,.58),l(-.518,.968),l(.749,-.737),l(.375,-.131),l(.688,-.479),l(1.059,-.944),l(1.097,-.785),l(2.028,-.948),l(1.245,-.395),l(1.797,-.512),l(1.065,-.235),l(1.03,-.235),l(1.473,-.148),l(.922,.056),l(.895,.289),l(.509,.29),l(.136,.189),l(.144,.464),l(-.125,.218),l(-.326,.219),l(-1.059,.292),l(-.753,.452),l(-.581,.044),l(-.845,-.23),l(-.726,.045),l(-.645,.19),l(.279,.08),l(1.13,.229),l(.17,.122),l(.256,.444),l(.074,.095),l(1.299,-.485),l(-.028,.216),l(.479,-.148),l(.372,.162),l(-.36,.229),l(-.231,.256),l(.112,.27),l(-.163,.014),l(-.074,.229),l(-.91,.444),l(1.216,.013),l(.077,.188),l(-.187,.282),l(.091,.43),l(.118,-.081),l(.239,.134),l(-.063,.134),l(.048,.202),l(.351,.457),l(.009,.147),l(.824,.054),l(.154,.094),l(.04,-.067),l(.727,.147),l(-.315,.134),l(-.373,-.013),l(-.047,.134),l(.525,.147),l(.211,.241),l(.569,-.081),l(.135,.134),l(.212,-.014),l(.134,.174),l(.418,-.04),l(-.075,-.107),l(.843,.067),l(.241,.107),l(-.207,.201),l(.242,-.107),l(.26,.027),l(.245,-.013),l(.696,-.362),l(.303,-.081),l(.104,.362),l(.377,.161),l(.538,-.121),l(.488,.416),l(-.405,.254),l(.089,.107),l(.825,.027),l(.164,.174),l(-.521,.121),l(-.161,-.121),l(-.3,.134),l(.118,.094),l(-.515,0),l(-.23,-.04),l(.109,.161),l(-.45,.04),l(.056,.107),l(-.443,.014),l(-.128,.147),l(-.45,.04),l(-.368,.253),l(-.09,-.106),l(-.706,.28),l(-.046,.053),l(-.529,.133),l(-.119,-.267),l(-.274,.106),l(-.163,.267),l(-.188,-.187),l(-.068,.253),l(-.218,.08),l(-.094,.187),l(-.513,0),l(-.081,-.08),l(-.169,-.053),l(.032,-.347),l(-.242,.36),l(-.202,.12),l(-.131,-.253),l(-.354,.027),l(.043,.24),l(-.233,.04),l(.312,.08),l(.033,.213),l(-.103,.12),l(-.174,-.067),l(-.768,.453),l(.127,.16),l(-.235,.12),l(-.194,.053),l(.015,.213),l(-.161,-.12),l(.083,.173),l(-.217,.08),l(-.14,-.107),l(.096,.253),l(-.222,.066),l(-.146,-.08),l(-.148,0),l(-.064,.133),l(-.156,-.106),l(-.243,.227),l(-.086,.292),l(-.201,-.226),l(-.344,.133),l(-.154,-.187),l(-.349,-.479),l(-.138,.24),l(-.419,-.866),l(.456,-.773),l(.284,-.16),l(.035,-.12),l(-.35,.12),l(-.357,.267),l(-.076,-.106),l(.924,-.507),l(.125,.146),l(.195,-.093),l(-.258,-.107),l(1.103,-.52),l(1.109,-.562),l(.658,-.361),l(.336,.094),l(-.067,.428),l(.179,-.054),l(.258,.281),l(-.044,-.201),l(-.017,-.174),l(.632,-.214),l(.73,-.134),l(.192,.067),l(.202,-.081),l(-.152,-.094),l(-.653,-.053),l(-.595,.053),l(-.42,-.053),l(-.804,-.014),l(-.306,.027),l(-.251,.081),l(-.246,.094),l(.033,-.214),l(1.128,-.563),l(.054,-.201),l(.252,-.08),l(-.052,-.174),l(-.523,.281),l(.097,-.134),l(-.502,-.51),l(.309,.443),l(-.36,.482),l(-.328,.013),l(-1.974,.817),l(-.284,.08),l(-.362,-.201),l(-.227,-.067),l(.23,.201),l(-.788,.401),l(-.219,-.174),l(-1.019,-.054),l(-.124,.147),l(-.38,-.241),M(186.193,47.833),l(-.713,-.032),l(-.922,-.181),l(-.882,-.065),l(-1.25,-.314),l(-.973,-.182),l(-.604,-.049),l(-1.083,-.199),l(.43,-.335),l(1.542,-.405),l(.385,-.186),l(.115,-.673),l(.305,-.236),l(.831,-.069),l(.743,.184),l(1.436,.603),l(1.287,.4),l(.074,.285),l(.315,.284),l(1.094,.516),l(-.288,.117),l(-1.263,.486),l(-.578,.051),M(231.09,50.646),l(-1.319,-.03),l(-.449,-.147),l(-.232,-.247),l(-.173,-.478),l(.3,-.43),l(.708,-.664),l(.662,-.267),l(1.359,-.168),l(.911,.197),l(.79,.314),l(-.021,.464),l(-.039,.727),l(-.362,.265),l(-1.025,.348),l(-1.108,.117),
N(444.972,79.145),l(.47,-.218),l(.307,-.093),l(-.294,-.024),l(-.419,.061),l(-.15,-.135),l(-.125,.184),l(-.108,-.012),l(.066,-.491),l(.177,-.218),l(.41,.009),l(1.489,.062),l(.417,.014),l(.339,-.075),l(.121,-.253),l(-.175,-.288),l(.246,-.05),l(-.068,-.122),l(-.068,-.123),l(.353,-.096),l(.12,-.034),l(.051,.154),l(.086,.052),l(.24,0),l(.223,.12),l(.257,.069),l(.514,.068),l(.086,.103),l(.223,-.051),l(.445,0),l(.257,0),l(.223,-.017),l(.086,.137),l(.103,.103),l(.188,.034),l(.171,.069),l(.018,.137),l(.052,.12),l(-.224,.12),l(-.068,.154),l(-.068,.206),l(.018,.171),l(.034,.137),l(.029,.038),l(-2.96,.101),l(-2.246,-.115),l(-.842,-.006),M(717.633,81.109),l(.42,.443),l(.429,.62),l(.183,.457),l(.01,.767),l(-.244,.442),l(-.197,.78),l(-.002,.764),l(.29,.777),l(.592,.849),l(.65,1.446),l(.899,1.614),l(1.115,1.679),l(-1.26,-.677),l(-.832,-.39),l(-.99,-.056),l(-.268,.088),l(-.396,.204),l(-.462,1.045),l(-.266,1.101),l(-.082,.579),l(.277,.982),l(.183,.216),l(.659,.908),l(.54,.201),l(.463,.648),l(-.314,1.246),l(-.664,-1.258),l(-.866,-.301),l(-.224,.029),l(-.415,.303),l(-.311,.534),l(-.643,.907),l(-.422,-.5),l(-.19,-.929),l(.637,-1.146),l(-.395,-.884),l(.175,-.454),l(.502,-.63),l(-.131,-.723),l(-.196,-.376),l(-.27,-.55),l(-.062,-.235),l(.403,-.302),l(.284,-.915),l(.075,-.784),l(.005,-1.326),l(.15,-1.302),l(-.09,-.732),l(-.213,-.469),l(-.83,-.85),l(-.1,-.897),l(.114,-.192),l(.359,-.722),l(.065,-.738),l(-.336,-.457),l(.172,-.237),l(.374,-.03),l(.62,-.031),l(1.023,-.534),M(471.158,84.281),l(-.002,-.142),l(-.165,-.066),l(-.082,-.115),l(-.164,-.082),l(.033,-.099),l(-.033,-.23),l(-.033,-.164),l(.082,-.099),l(-.147,-.131),l(-.099,-.148),l(.132,-.066),l(0,-.165),l(-.296,-.164),l(-.279,-.263),l(-.017,-.164),l(.099,-.131),l(.131,-.165),l(.362,-.017),l(.328,.049),l(.197,.132),l(.51,.016),l(.525,-.099),l(.444,-.247),l(.049,-.065),l(.148,-.083),l(.296,0),l(.065,-.164),l(-.033,-.131),l(-.279,-.066),l(-.296,-.148),l(-.099,-.181),l(.082,-.017),l(.066,-.049),l(.032,-.065),l(-.263,-.066),l(-.361,-.099),l(-.378,-.066),l(-.361,.066),l(-.182,-.066),l(.066,-.181),l(.099,-.197),l(-.066,-.148),l(-.164,-.099),l(-.279,-.082),l(-.23,-.066),l(-.443,-.213),l(-.115,-.23),l(-.164,-.263),l(-.214,-.017),l(-.017,-.099),l(.066,-.131),l(.099,-.115),l(-.132,-.033),l(-.181,.049),l(-.082,-.115),l(-.132,-.181),l(-.345,-.049),l(.049,-.147),l(.033,-.165),l(.099,-.049),l(.115,-.082),l(0,-.083),l(.114,0),l(.066,-.131),l(-.05,-.164),l(-.147,-.099),l(-.197,-.247),l(.131,-.165),l(.033,-.164),l(0,-.083),l(.065,-.115),l(-.049,-.115),l(-.147,.033),l(-.165,-.033),l(-.147,-.099),l(-.099,-.099),l(-.279,-.099),l(-.132,-.131),l(-.542,-.115),l(-.247,.049),l(-.099,-.049),l(-.131,-.049),l(-.23,.083),l(-.147,.099),l(-.165,0),l(-.279,.016),l(-.214,.197),l(-.197,0),l(-.164,-.148),l(-.065,-.148),l(.017,-.099),l(.164,-.099),l(0,-.115),l(-.147,-.017),l(-.296,-.065),l(-.312,-.049),l(-.361,.049),l(-.214,.065),l(-.197,.033),l(-.082,-.148),l(-.132,-.148),l(-.312,-.033),l(-.181,-.016),l(-.197,.131),l(-.229,-.066),l(-.165,-.147),l(.061,-.042),l(.015,-.117),l(.044,-.087),l(-.088,-.233),l(.015,-.189),l(-.131,-.117),l(.059,-.087),l(-.16,-.043),l(-.146,-.102),l(-.029,-.16),l(-.131,-.058),l(-.116,-.102),l(.043,-.073),l(.059,-.087),l(-.073,-.044),l(-.087,-.014),l(-.131,-.073),l(-.146,.015),l(-.204,.059),l(.044,-.102),l(.102,-.073),l(.073,-.087),l(-.029,-.117),l(.072,-.131),l(-.131,-.087),l(.103,-.029),l(.087,-.015),l(.102,-.073),l(.015,-.087),l(.029,-.116),l(.015,-.087),l(-.204,-.058),l(-.087,-.073),l(-.204,-.087),l(-.232,-.073),l(0,-.117),l(.015,-.116),l(-.37,.004),l(-.081,-.106),l(.116,-.058),L(461.402,72),l(.029,-.117),l(.131,0),l(.087,-.116),l(.059,-.102),l(.16,-.058),l(.262,-.043),l(.175,-.073),l(-.059,-.059),l(-.175,-.043),l(-.043,-.146),l(-.015,-.087),l(0,-.073),l(-.088,-.073),l(-.203,-.087),l(-.175,-.233),l(0,-.175),l(.175,-.131),l(-.029,-.16),l(-.073,-.189),l(-.131,-.437),l(-.029,-.16),l(.088,-.16),l(.204,-.131),l(.319,-.131),l(.219,-.204),l(.175,-.277),l(.058,-.131),l(.088,-.043),l(.116,0),l(.189,0),l(.175,-.044),l(.043,-.174),l(-.16,-.131),l(-.145,-.053),l(-.089,-.13),l(-.17,-.038),l(.1,-.253),l(.339,-.038),l(.153,.165),l(.229,.063),l(.188,-.088),l(-.094,-.139),l(.301,-.154),l(.485,.199),l(.296,-.062),l(.312,-.338),l(.311,-.185),l(.75,.106),l(.781,.275),l(.439,0),l(.363,-.154),l(-.386,-.399),l(-.59,-.323),l(-.393,-.03),l(-1.204,.08),l(-.616,-.091),l(-.271,-.108),l(-.299,-.309),l(.258,-.434),l(-.065,-.201),l(-.199,.044),l(.174,-.285),l(1.946,-1.145),l(1.983,-1.195),l(1.385,-.758),l(.591,-.536),l(.43,-.536),l(.105,-.409),l(-.161,-.346),l(-.436,-.392),l(-.703,-.265),l(-1.357,-.499),l(-.439,-.33),l(.327,-.191),l(.542,-.415),l(.057,-.254),l(-.151,-.253),l(-1.286,-1.395),l(-.37,-.509),l(.029,-.37),l(.187,-.403),l(.44,-.535),l(.196,-.356),l(-.772,-1.195),l(-1.402,-1.394),l(.328,-.296),l(1.303,-.777),l(.421,-.364),l(-.543,-.392),l(-.964,-.506),l(-.872,-.194),l(-.563,-.212),l(-.116,-.529),l(.258,-.465),l(.024,-.283),l(.689,-.303),l(1.013,-.672),l(1.023,-.49),l(.77,-.121),l(.824,-.021),l(.514,-.204),l(.404,-.288),l(.617,-.051),l(1.002,-.254),l(.643,-.237),l(.01,.151),l(.255,.386),l(.358,.284),l(.543,.2),l(.919,.082),l(.602,.1),l(.078,.602),l(.695,-.319),l(.421,.049),l(1.083,.048),l(.875,.015),l(.522,.032),l(1.116,-.002),l(1.293,.281),l(2.728,.512),l(.984,.364),l(1.595,.86),l(.583,.214),l(1.48,.246),l(1.296,.212),l(2.018,.623),l(.328,.279),l(-.051,.444),l(.147,.295),l(.426,.294),l(.104,.294),l(-.24,.344),l(-.69,.491),l(-1.092,.54),l(-.816,.262),l(-1.75,.36),l(-.907,.083),l(-1.631,-.013),l(-1.391,-.192),l(-2.038,-.175),l(-1.63,-.192),l(-1.342,-.339),l(-2.256,-.485),l(-1.114,-.112),l(-.476,-.048),l(-.621,-.473),l(-.371,-.163),l(-.771,-.13),l(-.943,.117),l(.307,.163),l(.149,.065),l(.73,.538),l(.482,.146),l(1.109,.601),l(.832,.291),l(.921,.161),l(.634,.242),l(.405,.453),l(-.002,.405),l(-.276,.291),l(-.684,.195),l(.086,.113),l(.208,.531),l(.771,.943),l(.093,.494),l(.155,.207),l(.438,.174),l(1.203,.078),l(.872,.125),l(.499,.619),l(.401,.095),l(1.26,.077),l(.575,.126),l(.364,.079),l(.402,-.128),l(.785,-.097),l(.243,-.302),l(-.001,-.318),l(-.387,-.397),l(-.471,-.079),l(-.455,.096),l(-.447,-.031),l(-.589,-.206),l(-.952,-.795),l(.701,-.674),l(.484,-.001),l(1.116,.479),l(1.441,.333),l(2.09,.427),l(.952,.078),l(.834,-.146),l(.723,.174),l(.261,-.224),l(.05,-.415),l(-.214,-.239),l(-.858,-.656),l(-.348,-.628),l(.285,-.323),l(.19,-.049),l(1.432,-.423),l(1.495,-.359),l(.599,-.244),l(1.133,-.717),l(.172,-.049),l(.462,.064),l(1.829,.29),l(1.41,.533),l(.341,-.001),l(.052,-.065),l(.154,-.503),l(.581,-.767),l(-.048,-.653),l(-.317,-.408),l(-.847,-.163),l(-.3,-.229),l(1.139,-1.005),l(.101,-.247),l(-.205,-.594),l(-.771,-.512),l(.069,-.315),l(.353,-.051),l(1.458,.23),l(2.025,-.12),l(.631,.132),l(.664,.611),l(.616,.445),l(.433,.461),l(-1.045,.051),l(-1.559,.085),l(-.822,.215),l(-.492,.51),l(.191,.18),l(.952,.293),l(.732,.555),l(.804,.194),l(.723,.097),l(1.268,-.133),l(1.33,-.084),l(.301,-.164),l(.257,-.491),l(.291,-.591),l(.284,-.412),l(1.232,-.2),l(1.223,-.414),l(.988,-.216),l(1.924,-.483),l(1.429,-.251),l(1.537,-.318),l(.921,-.3),l(.205,.464),l(.278,.083),l(.571,-.117),l(.487,-.266),l(.148,-.465),l(.386,-.167),l(.718,-.135),l(.859,.065),l(-.18,.399),l(-.058,.597),l(-.858,.084),l(-.178,.149),l(.002,.215),l(.687,.197),l(.507,-.083),l(1.169,-.167),l(.436,-.001),l(.161,.198),l(.23,.049),l(.278,-.133),l(.264,-.216),l(.29,-.431),l(.464,-.183),l(.861,-.118),l(1.049,-.068),l(.768,.032),l(1.075,.23),l(.755,-.018),l(.36,-.083),l(.963,-.467),l(1,-.285),l(.803,-.052),l(.952,.182),l(.326,.166),l(-.631,.45),l(.129,.232),l(.217,.099),l(.632,.131),l(.579,-.018),l(.288,-.232),l(.074,-.398),l(.342,-.084),l(.962,.065),l(.543,-.184),l(.395,-.316),l(.115,-.417),l(-1.37,-1.033),l(.405,-.168),l(.66,-.37),l(.403,-.068),l(.609,.016),l(2.171,.063),l(1.272,.199),l(1.241,.149),l(1.135,.199),l(2.111,.515),l(1.071,.098),l(1.712,.414),l(1.02,.248),l(1.305,.53),l(1.455,.611),l(.864,.379),l(.376,.049),l(.229,-.1),l(1.145,-1.047),l(.236,-.3),l(-.927,.035),l(-.4,-.049),l(-.564,-.232),l(-.365,-.433),l(.027,-.652),l(-.727,-.283),l(-1.987,-.147),l(-.19,-.268),l(.064,-.168),l(.305,-.303),l(.693,-.255),l(.236,-.153),l(.085,-.187),l(-.052,-.833),l(-.251,-.238),l(-1.135,-.066),l(-.232,-.29),l(.328,-.532),l(.359,-.241),l(.391,-.035),l(1.482,-.416),l(1.098,-.485),l(.521,-.416),l(.581,-.608),l(.544,-1.22),l(.637,-.421),l(.374,.069),l(1.562,.155),l(1.613,-.125),l(1.605,-.091),l(.695,.069),l(1.066,-.055),l(.574,.122),l(.309,.279),l(-.018,.332),l(-.423,.836),l(-.348,.348),l(-1.334,.833),l(-.223,.345),l(.752,.342),l(.931,.667),l(.277,.342),l(.21,.818),l(-.174,.222),l(-.575,.375),l(.254,1.179),l(-.058,1.305),l(.263,.583),l(.45,.381),l(1.027,.264),l(.19,.166),l(-.001,.133),l(-.485,.481),l(-.417,.826),l(-.333,.33),l(-.784,.462),l(-1.232,.625),l(-.63,.198),l(-.55,.263),l(.321,.522),l(-.433,.115),L(558,52.195),l(-1.599,-.372),l(-.731,-.08),l(-.97,.034),l(-.601,.115),l(.195,.31),l(.583,.276),l(.738,.21),l(1.569,.208),l(1.133,.079),l(.613,-.05),l(1.188,.144),l(.922,-.034),l(.472,-.358),l(.303,-.358),l(1.352,-.328),l(1.166,-.492),l(.268,-.278),l(.386,-.606),l(.818,-.313),l(.864,-.626),l(.064,-.362),l(-.225,-.561),l(-.609,-.545),l(.244,-.548),l(.237,-.1),l(.677,-.151),l(1.38,-.152),l(1.757,-.003),l(.74,.231),l(.842,.463),l(.151,.778),l(-.34,1.023),l(.302,.279),l(.92,.212),l(1.298,.047),l(.864,-.149),l(.129,-.296),l(-.514,-.18),l(-.797,-.18),l(-.571,.034),l(-.457,-.098),l(.068,-.379),l(1.03,-.382),l(.065,-.249),l(-.218,-.148),l(-.166,-.331),l(-.441,-.763),l(-.511,-.266),l(-.836,-.098),l(-1.093,-.231),l(-.801,-.116),l(-1.288,-.165),l(-.91,.186),l(-.638,.101),l(-1.297,-.181),l(-.896,.019),l(-.015,-.267),l(-.564,-1.071),l(.305,-.657),l(.736,-.697),l(.282,-.46),l(-.134,-.221),l(-1.092,-1.042),l(-.949,-.514),l(-.12,-.189),l(.833,-.554),l(1.213,-.106),l(.998,-.262),l(.744,-.348),l(.172,-.226),l(.169,-.644),l(-.13,-.663),l(.23,.069),l(.64,.051),l(.466,.086),l(.108,.471),l(-.186,.54),l(-.636,.608),l(-.167,.554),l(.14,.448),l(.373,.274),l(.485,.274),l(1.384,.134),l(1.574,.169),l(1.632,.083),l(.819,.409),l(.321,.017),l(.799,-.036),l(-.527,-.89),l(-.521,-.274),l(-1.893,-.1),l(-.931,-.067),l(-.576,-.154),l(-.609,-.448),l(.275,-.329),l(1.374,-.054),l(.444,.172),l(1.145,.084),l(.747,-.157),l(-.09,-.728),l(.408,-.088),l(.84,-.105),l(1.278,-.02),l(1.067,.207),l(1.413,.379),l(1.088,.535),l(1.326,.343),l(.547,.085),l(1.822,.014),l(.727,-.174),l(.138,.345),l(-.781,.38),l(-.696,.259),l(-.248,.771),l(-.129,.972),l(.333,.136),l(.68,-.785),l(.387,-.292),l(.285,.051),l(.604,.528),l(-.088,.749),l(.743,-.205),l(.681,-.273),l(-.044,-.306),l(-.191,-.119),l(-.147,-.358),l(-.748,-.821),l(.188,-.223),l(.686,-.759),l(-.797,-.448),l(-.772,-.258),l(-.93,-.241),l(-.257,-.382),l(-.655,-.051),l(-.979,-.242),l(-1.34,-.207),l(-.307,-.296),l(.062,-.577),l(-.096,-.386),l(-.811,-.667),l(.081,-.247),l(.266,-.16),l(.484,-.125),l(2.31,-.11),l(2.54,-.022),l(2.125,-.128),l(1.421,-.162),l(.475,.317),l(.382,.052),l(.844,-.267),l(1.056,-.286),l(1.413,-.109),l(.589,.194),l(-.957,.338),l(-.451,.407),l(1.737,-.233),l(.521,-.107),l(.955,-.374),l(.27,-.284),l(-.334,-.444),l(-.326,-.177),l(-.925,-.266),l(-.365,-.303),l(-.002,-.232),l(.324,-.539),l(1.176,-.397),l(.966,-.22),l(3.028,-.903),l(.889,-.094),l(.248,-.036),l(.522,-.076),l(1.899,-.096),l(1.663,-.114),l(2.302,-.244),l(2.048,-.263),l(1.595,-.43),l(.855,-.243),l(1.763,.034),l(1.065,-.002),l(.383,.185),l(-.351,.409),l(1.504,.108),l(1.018,-.039),l(1.261,-.188),l(1.345,-.225),l(.95,-.039),l(.982,.166),l(.687,.073),l(.693,-.206),l(.12,-.335),l(-.133,-.167),l(.466,-.337),l(.942,-.077),l(.939,.036),l(1.243,-.377),l(-.618,-.506),l(.122,-.34),l(1.165,-.438),l(1.554,-.383),l(2.23,-.406),l(1.229,-.077),l(.993,.056),l(1.486,-.003),l(.86,.265),l(.045,.266),l(-1.528,.401),l(-.66,.342),l(.488,.15),l(1.83,-.117),l(1.588,.148),l(2.039,-.079),l(.177,.113),l(-.375,.283),l(-1.187,.453),l(-.296,.3),l(1.971,-.004),l(.833,-.02),l(.234,.093),l(1.052,-.545),l(1.366,-.002),l(1.771,-.097),l(.631,.13),l(1.35,-.021),l(1.954,.165),l(1.4,.259),l(1.181,.427),l(.52,.445),l(.726,-.001),l(.854,-.076),l(.422,.5),l(-1.354,.832),l(.241,.128),l(.896,.365),l(-2.329,.859),l(-1.035,.235),l(-1.166,.11),l(-3.404,1.061),l(-3.018,.965),l(-.793,.285),l(-2.388,.375),l(-2.35,.586),l(-2.065,1.126),l(.715,.017),l(1.081,-.247),l(.922,-.458),l(1.663,-.161),l(1.231,-.02),l(2.101,-.268),l(1.879,-.286),l(.879,-.107),l(1.004,-.284),l(-.094,-.389),l(-.492,-.123),l(-.034,-.071),l(.281,-.249),l(.581,-.214),l(.873,.211),l(.603,.389),l(.621,.052),l(.593,.193),l(.737,.052),l(.853,-.055),l(1.155,-.268),l(.499,.07),l(.192,.3),l(.009,.512),l(.522,.404),l(1.422,-.778),l(1.66,-.021),l(1.506,-.145),l(2.354,.014),l(1.919,.155),l(.854,.034),l(1.204,.033),l(-.271,.74),l(.354,.333),l(2.043,.154),l(.848,.121),l(.698,.069),l(1.035,.103),l(2.49,-.145),l(1.209,-.02),l(1.42,.348),l(1.405,-.932),l(-.161,-.352),l(-.038,-.229),l(-.034,-.105),l(1.806,-.48),l(.521,-.019),l(.802,.104),l(1.148,.298),l(.851,.281),l(1.711,.032),l(1.354,-.073),l(1.384,.033),l(1.323,.431),l(.409,.181),l(.058,.386),l(-.52,.088),l(-.268,.036),l(-1.905,.406),l(-2.438,.737),l(-.233,.227),l(.253,.069),l(1.033,.067),l(.957,.016),l(.659,.155),l(.659,.293),l(1.014,.396),l(.583,.172),l(.78,.481),l(1.27,.805),l(1.814,.801),l(1.351,.305),l(.612,-.018),l(.795,-.394),l(.843,-.72),l(1.093,-1.051),l(.601,-.329),l(.29,.017),l(.236,.465),l(.772,.308),l(1.346,.29),l(1.105,.135),l(.848,-.087),l(1.973,-.468),l(.778,-.07),l(.813,.067),l(1.196,.239),l(1.921,.734),l(.315,-.052),l(.186,-.069),l(.491,-.258),l(.221,-.258),l(-.137,-.051),l(.013,-.189),l(.726,-.312),l(.509,-.018),l(.5,.257),l(.575,.188),l(1.302,.032),l(.181,-.5),l(-.194,-.466),l(.15,-.363),l(.093,-.521),l(-1.131,.159),l(-.643,.001),l(-.179,-.104),l(.442,-.296),l(.318,-.087),l(.986,-.089),l(1.021,-.02),l(.832,-.141),l(1.566,-.648),l(.254,0),l(1.76,.241),l(1.561,.137),l(2.036,.188),l(.997,.068),l(.654,.103),l(2.307,.065),l(-1.732,.628),l(.865,.051),l(1.011,-.089),l(.335,.138),l(-.305,.381),l(-.926,.192),l(-.846,.261),l(-.177,.293),l(.664,.033),l(.52,-.122),l(.916,-.14),l(.978,-.33),l(1.62,-.799),l(2.766,.012),l(1.196,.067),l(.903,.172),l(.946,.137),l(.205,.19),l(.221,.104),l(-2.247,.59),l(.559,.137),l(1.674,.289),l(2.174,.202),l(.946,.204),l(.801,.375),l(.367,.427),l(.564,.357),l(.522,.152),l(1.459,-.037),l(1.364,-.105),l(1.138,-.139),l(2.518,-.329),l(2.208,-.107),l(3.008,.131),l(1.515,.134),l(.734,.118),l(1.168,.424),l(.655,.169),l(.525,.338),l(.361,.39),l(-.123,.491),l(-.286,.521),l(.509,.25),l(.764,.065),l(.835,.015),l(.643,.083),l(-.017,.685),l(.419,.416),l(.686,-.168),l(.545,-.435),l(1.211,-.387),l(.348,-.067),l(.35,.049),l(1.696,-.02),l(1.521,-.288),l(.736,.032),l(.588,.434),l(.707,.116),l(1.541,.014),l(2.176,.062),l(.869,-.118),l(1.378,-.504),l(.406,.2),l(.93,.533),l(.396,.216),l(1.095,.265),l(.875,.332),l(.282,.398),l(.612,.148),l(1.556,-.136),l(1.653,-.319),l(.16,-.25),l(-.248,-.333),l(-.805,-.833),l(-.833,-.115),l(.4,-.336),l(.479,-.571),l(1.89,.098),l(1.214,.082),l(1.135,.065),l(1.221,.166),l(.222,.318),l(1.396,-.153),l(2.084,-.054),l(2.304,.013),l(1.292,.148),l(.786,.199),l(1.185,.199),l(1.391,.098),l(.751,.182),l(1.302,.332),l(.747,.065),l(.703,.182),l(1.145,.505),l(0,2.126),l(0,2.222),l(0,2.222),l(0,1.292),l(0,.157),l(0,.576),l(0,.219),l(-1.083,.371),l(-.651,.03),l(-.645,.37),l(-.56,.065),l(-1.044,.065),l(-.355,-.079),l(-.928,-.052),l(-.118,-.343),l(-.271,-.211),l(-.501,.027),l(.241,-.185),l(-.938,.324),l(-.846,.02),l(-.337,-.211),l(-.478,-.079),l(.424,.501),l(-.569,.29),l(.32,.103),l(.942,.205),l(.634,-.36),l(.395,.041),l(.335,.079),l(0,.477),l(.248,.206),l(.76,.269),l(1.059,-.228),l(-.439,.322),l(.741,-.243),l(.065,.336),l(.247,.206),l(.187,.363),l(.068,.189),l(-.722,.522),l(.593,-.064),l(.349,.172),l(.473,.503),l(.501,.157),l(.145,.251),l(-.162,.456),l(.792,-.111),l(-.125,.393),l(.023,.25),l(-.43,.299),l(-.691,.205),l(-.635,-.046),l(-.448,-.14),l(-1.243,-.154),l(-.889,-.077),l(-.347,-.14),l(.123,-.267),l(-.493,-.046),l(-.304,.032),l(-.559,.55),l(-.069,.11),l(-3.06,.913),l(-1.155,.174),l(-.245,0),l(-.43,.203),l(-.219,.188),l(-.719,.22),l(-.991,.033),l(-.308,.11),l(-.48,.405),l(-.462,.203),l(-.946,.033),l(-.854,.622),l(-.24,.279),l(-1.67,.452),l(-.392,.449),l(-1.229,.25),l(-.406,.14),l(-.151,.293),l(.01,.292),l(-.473,.292),l(-.406,.016),l(-.586,-.306),l(-.183,-.262),l(-.169,-.37),l(-.67,-.308),l(-1.074,-.044),l(-1.021,.048),l(-1.159,.172),l(-1.301,.188),l(-.523,.217),l(-1.333,.756),l(-.536,.277),l(-.184,-.138),l(.575,-1.293),l(-.55,.094),l(-.392,-.097),l(-.811,.531),l(-.67,.186),l(-.401,.155),l(-.114,.506),l(-.66,.154),l(-.317,-.168),l(-.253,-.49),l(-.483,-.261),l(-1.024,.636),l(.261,-.204),l(-.557,.062),l(-.283,.092),l(-.628,.522),l(-.141,.261),l(.126,.229),l(.344,.152),l(-.932,.521),l(-.182,.199),l(.342,.167),l(-.647,.352),l(-.88,.55),l(-.626,.503),l(-.298,.35),l(-.01,.531),l(.421,.317),l(.477,.09),l(1.382,-.048),l(.562,.166),l(.11,.167),l(-.436,.394),l(-.752,.455),l(-.181,.302),l(.224,.512),l(.292,.452),l(.786,.089),l(.165,.391),l(-.014,.616),l(-.349,.361),l(-.528,.061),l(-.481,-.209),l(-.017,-.21),l(.388,-.527),l(-.444,-.014),l(-.454,.242),l(-1.014,.843),l(-.56,.675),l(-.237,.599),l(.321,.672),l(.647,.311),l(.154,.237),l(-.294,.387),l(-.688,.313),l(-.956,.031),l(-.664,-.088),l(-.344,.001),l(-.619,.179),l(-.837,.476),l(-.214,.149),l(-.525,.504),l(-.137,.341),l(.111,.281),l(.492,.398),l(.038,.221),l(-.056,.133),l(-.679,.238),l(-.604,.016),L(753.44,82.4),l(-.727,.296),l(-.065,.251),l(.067,.28),l(-.161,.854),l(-.293,.412),l(-.8,.78),l(-1.53,.971),l(-.854,.5),l(-.285,.103),l(-.295,-.614),l(-.198,-.821),l(-.25,-.69),l(-.064,-.794),l(-.351,-.75),l(-.305,-.383),l(-.214,-.915),l(-.514,-1.36),l(-.008,-.578),l(-.154,-.563),l(-.017,-.327),l(-.105,-.193),l(-.262,-.817),l(-.026,-.792),l(.116,-.808),l(.271,-1.396),l(.167,-.226),l(1.185,-.86),l(.716,-.424),l(.57,-.695),l(.14,-.227),l(-.085,-.318),l(-.139,-.166),l(1.632,-.367),l(1.001,-.305),l(.811,-.32),l(1.729,-.884),l(.641,-.412),l(.431,-.428),l(.14,-.335),l(1.784,-.889),l(.872,-.445),l(1.535,-.861),l(.368,-.293),l(.26,-.433),l(1.252,-.435),l(2.106,-.514),l(.257,-.434),l(.773,-.528),l(.086,-.233),l(-.568,-.216),l(.814,-.904),l(-.036,-.483),l(.183,-.391),l(.598,-.204),l(1.729,-.082),l(.513,-.063),l(-.485,-.328),l(-2.065,-.215),l(-.71,.095),l(-1.062,.174),l(-.777,.189),l(.042,.328),l(-.664,.923),l(.125,.202),l(-.04,.14),l(-.662,.11),l(-.479,.11),l(-1.555,.718),l(-1.979,1.042),l(-1.169,.342),l(-.249,-.062),l(.156,-.325),l(.352,-.465),l(-.933,-.076),l(-.16,-.263),l(.252,-.451),l(.442,-.467),l(.207,-.328),l(-.069,-.202),l(-.339,-.031),l(-1.136,.454),l(-.496,.032),l(-.277,-.358),l(-.589,-.17),l(-1.606,.144),l(-1.312,.111),l(-.956,.08),l(-.606,.157),l(-.894,.359),l(-.093,.436),l(.082,.186),l(-1.262,.53),l(-.408,.233),l(.149,.495),l(-1.294,.357),l(-1.019,.434),l(-.84,.479),l(-.496,.461),l(-.332,.46),l(.004,.383),l(.527,.213),l(1.269,.043),l(.278,.275),l(.062,.122),l(-1.152,.139),l(-1.028,.262),l(-1.045,-.059),l(-.698,-.136),l(-.382,.031),l(-.311,.107),l(-.721,.398),l(-.695,-.35),l(-1.112,.383),l(-.747,.139),l(-.487,-.09),l(-.284,-.137),l(.108,-.29),l(.748,-.124),l(.868,-.124),l(.164,-.046),l(-.741,-.64),L(736.444,68),l(-1.06,.017),l(-.854,.155),l(-.353,-.061),l(-.868,-.458),l(-.775,-.029),l(-.745,.047),l(-.704,.246),l(.042,.398),l(-.26,.229),l(-.477,.215),l(-.695,-.243),l(-.408,-.122),l(-1.26,.063),l(-.784,.093),l(-.651,-.075),l(-.887,-.136),l(-.563,.078),l(-.067,.122),l(-.147,.474),l(-.677,.017),l(-.311,-.137),l(-.038,-.382),l(-.203,-.259),l(-1.241,.094),l(-1.014,-.059),l(-1.257,.033),l(-1.158,.063),l(-.836,-.029),l(-.18,.016),l(-1.085,.292),l(-.964,.444),l(-.74,.474),l(-.536,.504),l(-.789,.245),l(-.904,.336),l(-.194,.152),l(-1.047,1.17),l(-1.634,.684),l(-.949,.471),l(-1.157,.711),l(-1.653,1.253),l(-.828,.572),l(-1.573,.873),l(-.893,.376),l(-1.889,.871),l(-.632,.388),l(-.203,.298),l(.018,.357),l(.428,.281),l(.485,.043),l(.918,.013),l(1.046,-.15),l(.656,.043),l(-.329,1.261),l(.016,.415),l(.303,.103),l(.63,-.09),l(.601,-.371),l(.761,.117),l(-.127,.148),L(705.293,81),l(-.112,.222),l(.373,.073),l(1.645,-.018),l(.566,-.238),l(.39,-.519),l(.017,-.638),l(.763,.014),l(.647,-.001),l(.726,.014),l(.951,.265),l(.658,.354),l(.486,.591),l(.847,.575),l(.426,.176),l(.506,.324),l(-.07,.148),l(-.581,.355),l(.453,.221),l(.13,.309),l(-.336,.723),l(.491,.117),l(.215,.235),l(-.291,.515),l(-.348,.397),l(-.532,.559),l(-.724,1.364),l(-.181,.688),l(.057,.219),l(.24,.701),l(-.188,.917),l(-.098,.741),l(-.403,1.408),l(-.146,.493),l(-1.928,1.538),l(-.371,.435),l(-.217,.65),l(-.587,.42),l(-.741,.579),l(-.241,.361),l(-.574,.981),l(-.587,.606),l(-.941,.778),l(-1.784,1.512),l(-.464,.474),l(-.235,.458),l(-.323,.33),l(-.758,.388),l(-.618,.416),l(-.574,.702),l(-.431,.458),l(-.875,.673),l(-.955,.487),l(-1.838,.475),l(-.798,.244),l(-.278,-.427),l(-.519,-.085),l(-.243,.043),l(-.337,-.185),l(-.337,-.513),l(-.663,.272),l(-.464,.101),l(.424,-.586),l(-.624,.173),l(-.506,.486),l(-.649,.543),l(-1.326,1.001),l(-.072,.049),l(-.167,-.393),l(-.298,-.439),l(.111,-.058),l(1.252,-.462),l(.511,-.43),l(.156,-.329),l(-.112,-.299),l(.097,-.128),l(.025,-.385),l(.006,-.613),l(-.062,-.656),l(-.332,-.897),l(.048,-.557),l(1.664,-.982),l(.396,.041),l(.685,.24),l(.679,.225),l(.547,.098),l(.47,-.347),l(.551,-.69),l(.329,-.432),l(.627,-1.08),l(.538,-1.066),l(.278,-.893),l(.291,-.707),l(.66,-.393),l(.566,-.407),l(-.017,-.504),l(-.116,-.389),l(-.064,-.259),l(-.246,-.114),l(-.902,.034),l(-1.181,.208),l(-1.357,.31),l(-.953,.308),l(-.604,.22),l(-1.657,.052),l(-.649,.018),l(-.68,.033),l(-.261,-.446),l(-.44,-1.283),l(-.297,-.866),l(-.205,-.144),l(-2.659,-.839),l(-1.523,-.253),l(-1.247,-.341),l(-.507,-.2),l(-.436,-.389),l(-.927,-1.903),l(-.94,-1.588),l(-1.087,-2.384),l(-.742,-.952),l(-.763,-.467),l(-.539,-.026),l(-1.386,.125),l(-.683,-.188),l(-1.037,-.481),l(-1.148,-.215),l(-.917,.049),l(-1.203,.109),l(-.836,.123),l(-1.854,.143),l(-.602,.136),l(-.478,.165),l(-1.193,.787),l(-.375,.282),l(-.119,.25),l(.822,-.078),l(.558,.026),l(.465,.306),l(.107,.249),l(-.167,.794),l(-1.371,.608),l(-.599,.545),l(-.667,.779),l(-.416,.543),l(-.422,.426),l(-.103,.249),l(.062,.146),l(.35,.348),l(.056,.306),l(-.123,.233),l(-.779,.339),l(-2.44,.752),l(-.438,.089),l(-.343,.016),l(-1.126,-.574),l(-.452,-.172),l(-.046,-.018),l(-.431,-.168),l(-.622,.018),l(-1.228,.297),l(-.86,-.169),l(-.34,-.129),l(-.751,-.506),l(-.74,-.156),l(-.609,.047),l(-.333,.002),l(-1.165,.487),l(-.755,.498),l(-.447,.394),l(-.604,.264),l(-.526,.163),l(-1.147,.136),l(-.867,.106),l(-.532,.075),l(-1.018,.063),l(-1.602,.11),l(-.739,-.039),l(-.984,-.082),l(-.905,-.241),l(-1.318,-.254),l(-.812,-.373),l(-1.132,-.313),l(-.623,-.331),l(-1.333,-.75),l(-.769,-.229),l(-1.423,-.022),l(-1.172,-.037),l(-.796,.077),l(-2.48,.538),l(-.673,-.113),l(-1.643,-.531),l(-.421,-.333),l(-.408,-.451),l(-.182,-.481),l(-.004,-.541),l(-.145,-.204),l(-.767,-.143),l(-.989,-.317),l(-.702,-.231),l(-1.748,-.328),l(-1.036,-.185),l(-1.028,-.098),l(-.84,-.201),l(-1.269,.96),l(-.905,.839),l(-.098,.293),l(.409,.86),l(.396,.304),l(.116,.204),l(-.163,.526),l(-.744,.572),l(-.31,.162),l(-.755,.28),l(-.562,.018),l(-.576,-.186),l(-.312,-.114),l(-.875,-.068),l(-.85,.004),l(-.719,-.083),l(-1.458,.008),l(-.699,-.113),l(-.393,-.406),l(-.694,-.755),l(-.831,-.083),l(-1.842,-.122),l(-.932,-.156),l(-.953,-.097),l(-.84,.18),l(-1.512,.476),l(-1.143,.341),l(-.787,.398),l(-.971,.692),l(-.017,.012),l(-.727,.381),l(-.603,.148),l(-1.387,.08),l(-.599,.207),l(-.799,.425),l(-.154,.044),l(-.244,.074),l(-.569,.003),l(-.228,.014),l(-.064,-.145),l(-.589,0),l(-.294,-.478),l(-.441,-.331),l(.073,-.331),l(-.625,.184),l(-.478,.368),l(-.993,-.074),l(-.882,-.073),l(-.662,-.699),l(-.588,-.552),l(-.956,-.147),l(-.331,-.625),l(-.772,-.588),l(-.698,-.441),l(-.993,.037),l(-.771,.221),l(-.993,.221),l(-.992,0),l(-.589,0),l(-.184,-.184),l(-.258,-.257),l(-.478,0),l(0,-.368),l(-.367,-.331),l(-.92,0),l(-.367,.515),l(-.331,.257),l(-.515,.257),l(-1.104,-1.434),l(-.846,-.882),l(-1.69,-2.133),l(-1.066,-1.029),l(-1.287,-.772),l(-.809,-.294),l(-1.104,-.588),l(.11,-.368),l(.515,-.11),l(0,-.441),l(-.809,.074),l(-.515,.22),l(-.772,.221),l(-.956,.515),l(-1.103,.257),l(-.772,.441),l(-.294,.294),l(-.552,-.184),l(-.441,-.037),l(-.771,.073),l(-.441,.11),l(-.331,-.184),l(.331,-.441),l(.441,-.184),l(.146,-.294),l(-.367,0),l(-.441,.221),l(-.478,-.11),l(-.405,-.294),l(-.478,-.037),l(-.184,.147),l(-.147,.147),l(-.367,-.221),l(-.295,-.368),l(-.294,-.11),l(-.331,.221),l(-.367,-.074),l(-.368,.147),l(-.44,-.11),l(-.295,.147),l(-.478,-.074),l(-.184,-.257),l(.33,-.037),l(-.073,-.331),l(.147,-.257),l(.11,-.331),l(-.515,-.22),l(-.147,-.221),l(.037,-.331),l(-.368,-.404),l(-.882,.037),l(-.625,.11),l(-.772,-.257),l(-.515,-.11),l(-.919,-.147),l(-.735,.037),l(-.11,.221),l(-.589,.184),l(-.515,.037),l(0,.294),l(-.367,.368),l(-.625,.074),l(-1.876,.073),l(-2.021,.405),l(-1.177,.037),l(-.625,.331),l(-.221,.331),l(-.331,-.073),l(-.588,.073),l(-1.545,.11),l(-.735,.11),l(-1.029,.037),l(-1.396,.405),l(-.368,.184),l(-.772,0),l(-.515,0),L(537.304,80),l(-.33,.074),l(-.185,.515),l(.074,.441),l(.294,.221),l(-.294,.074),l(0,.331),l(1.065,.11),l(.956,.294),l(-.11,.257),l(-.515,.073),l(-1.103,-.147),l(-.698,.184),l(-.662,.515),l(.146,.257),l(.441,.478),l(-.331,.294),l(-.588,.147),l(-.735,.368),l(-.467,.067),l(.164,.274),l(.239,0),l(.377,.137),l(-.068,.171),l(.377,.137),l(.651,.069),l(.274,.308),l(1.165,.171),l(.24,.24),l(-.138,.686),l(-.137,.309),l(-1.577,.411),l(-.959,-.034),l(-.343,-.343),l(-.24,0),l(-.171,.309),l(-.651,.343),l(-.411,-.171),l(-.754,-.137),l(-.926,-.309),l(-.274,-.548),l(-.754,-.103),l(-1.062,.103),l(-.137,.412),l(-.617,.068),l(-.651,-.411),l(-.65,-.035),l(-.823,-.068),l(-.514,.377),l(-.377,.343),l(-.274,.274),l(-.686,.171),l(-.411,-.24),l(-.686,-.137),l(-.582,-.548),l(-.72,-.068),l(.034,.24),l(.205,.48),l(-.239,.274),l(-.274,-.137),l(-.068,-.583),l(-.411,-.274),l(-.789,-.343),l(-.582,-.206),l(0,-.343),l(-.96,-.171),l(-.617,.069),l(-.788,-.035),l(-.411,-.514),l(-.411,-.069),l(-.617,.24),l(-.273,.137),l(-.651,.137),l(-.309,-.274),l(-.479,0),l(-.651,-.069),l(-.515,.309),l(-.548,.343),l(-.788,.377),l(-.549,.068),l(-.514,.171),l(-.309,.309),l(-.172,.24),L(509.58,87.5),l(-.479,.206),l(.068,.445),l(.171,.411),l(-.068,.446),l(-.411,.24),l(-.651,0),l(-.514,-.411),l(-.48,-.548),l(-.514,-.24),l(-.411,.069),l(-.103,.308),l(-.343,.549),l(-.823,.137),l(-.205,1.303),l(.343,.171),l(.239,.274),l(-.239,.206),l(-.446,.274),l(-.65,1.165),l(1.37,.343),l(.138,.377),l(-.068,.309),l(.514,.514),l(.103,-.343),l(.583,.206),l(.343,-.034),l(.514,.034),l(.515,.445),l(.479,.206),l(.343,.514),l(.96,1.131),l(-.138,.103),l(-.445,-.103),l(-.309,-.103),l(-.343,.103),l(.068,.308),l(.857,.377),l(.616,.19),l(-.167,.2),l(-.399,.28),l(-.38,.12),l(-.12,0),l(0,.14),l(0,.22),l(-.14,.08),l(-.3,-.2),l(-.34,.2),l(-.399,.26),l(-.64,.12),l(-.319,.08),l(-.26,-.08),l(-.181,-.08),l(-.1,.04),l(-.06,.16),l(.12,.26),l(-.221,.2),l(-.18,.3),l(-.18,.319),l(-.319,.42),l(-.18,.28),l(-.32,.16),l(-.34,.24),l(-.14,.32),l(.08,.2),l(.34,.2),l(.319,.04),l(.18,.3),l(.24,.04),l(.239,.34),l(.28,.419),l(-.06,.38),l(-.101,.2),l(.061,.16),l(.1,-.2),l(.1,-.34),l(.12,-.22),l(.16,-.02),l(-.141,.439),l(-.22,.36),l(.061,.4),l(.12,.1),l(-.16,.2),l(-.04,.4),l(.38,.24),l(.119,.1),l(.12,.52),l(.28,.06),l(.359,.42),l(.2,.28),l(.439,.419),l(.18,.36),l(.359,.06),l(.047,.146),l(-.292,.449),l(-.496,.284),l(-.283,.094),l(-.308,.331),l(-.165,.213),l(-.379,.047),l(-.449,-.142),l(-.591,-.094),l(0,-.308),l(-.283,-.284),l(-.118,0),l(-.095,-.118),l(-.473,-.284),l(-.142,-.189),H(504.5,0),l(-.213,.047),L(504.264,107),l(-.229,.023),l(-.126,-.189),l(-.236,-.071),l(-.236,.023),l(-.284,-.047),l(-.26,-.094),l(-.284,-.166),l(-.354,-.284),l(.118,-.307),l(.118,-.189),l(-.118,-.142),l(-.354,-.024),l(-.378,0),l(-.213,-.166),l(-.189,-.118),l(-.212,0),l(-.143,-.094),l(-.236,-.118),l(-.118,0),l(-.095,.071),l(-.142,.166),l(-.188,-.142),l(-.261,-.071),l(-.354,0),l(-.213,.071),l(-.094,.095),l(-.166,.166),l(-.283,0),l(-.261,.118),l(-.212,-.071),l(-.261,-.118),l(.048,-.118),l(.142,-.118),l(-.308,-.119),l(-.236,-.118),l(-.354,-.071),l(-.52,-.118),l(-.284,-.213),l(-.095,-.142),l(-.354,-.166),l(-.283,.047),l(-.189,0),l(-.401,-.166),l(-.544,0),l(-.426,.095),l(-.307,0),l(-.355,-.047),l(-.307,-.071),l(-.261,-.095),l(-.212,-.166),l(-.213,0),l(-.331,0),l(-.189,-.047),l(-.188,-.094),l(-.284,-.142),l(-.283,-.095),l(-.449,-.023),l(-.402,-.023),l(-.07,-.047),l(-.284,-.047),l(-.26,.166),l(-.112,.309),l(-1.421,-1.012),l(-1.188,-.842),l(-.817,-.385),l(-.62,-.084),l(-.373,-.157),l(-.509,-.5),l(-.236,-.057),l(-.338,.159),l(-.329,-.042),l(-.347,-.515),l(-.795,-.674),l(.595,-.188),l(.519,-.001),l(.445,-.073),l(.1,-.519),l(.359,-.476),L(485,97.85),l(.526,-.03),l(.516,-.131),l(-.432,-.532),l(-.654,-.273),l(-.474,-.36),l(.243,-.116),l(.367,-.03),l(.82,-.117),l(.715,-.348),l(1.244,-.436),l(-.196,-.375),l(-.076,-.058),l(-.799,.088),l(-1.312,.175),l(.012,-.126),l(.021,-.112),l(0,-.224),l(.09,-.514),l(.224,-.089),l(.357,-.022),l(.38,-.134),l(.223,-.179),l(.022,-.179),l(.269,0),l(.736,-.045),l(.805,.157),l(.335,-.134),l(0,-.156),l(.156,-.291),l(.156,-.491),l(-.066,-.067),l(-.09,-.201),l(-.045,-.179),l(-.044,-.134),l(-.179,-.067),l(-.156,-.067),l(.044,-.224),l(.045,-.179),l(.246,0),l(.312,0),l(.134,-.156),l(-.29,-.044),l(-.269,-.089),l(-.223,-.246),l(.312,-.044),l(.357,-.201),l(.156,-.067),l(.201,-.089),l(.045,-.224),l(-.09,-.179),l(-.111,-.089),l(.022,-.179),l(.089,-.111),l(-.156,-.089),l(-.201,.089),l(-.134,.044),l(-.269,0),l(-.357,-.156),l(-.111,-.224),l(-.469,-.022),l(-.291,-.089),l(-.201,-.179),l(-.357,.067),l(-.268,-.112),l(-.469,-.112),l(-.425,-.067),l(-.29,-.268),l(-.224,.067),l(-.045,.157),l(-.29,.134),l(-.224,-.112),l(-.179,-.179),l(-.402,-.044),l(-.022,-.134),l(-.201,-.179),l(0,-.134),l(-.268,-.179),l(-.111,-.156),l(-.357,.067),l(-.536,.134),l(-.269,0),l(-.312,.112),l(-.425,.112),l(-.179,-.156),l(-.179,-.022),l(-.201,.067),l(-.469,-.291),l(-.268,-.067),l(-.47,.067),l(-.268,.179),l(-.291,-.29),l(-.179,-.089),l(-.089,-.224),l(.089,-.179),l(-.089,-.246),l(-.224,-.268),l(0,-.357),l(-.402,0),l(0,-.312),l(-.38,-.022),l(-.514,.067),l(-.156,-.112),l(-.647,0),l(-.269,-.29),l(-.111,-.357),l(-.134,-.291),l(.312,-.134),l(.312,.022),l(0,-.268),l(-.312,-.156),l(-.246,-.156),l(-.134,-.201),l(-.246,-.335),l(-.312,-.134),l(-.201,-.268),l(-.514,.134),l(-.692,-.112),l(-.67,.223),l(-.536,.022),l(-.536,-.246),l(-.134,.268),l(-.179,.291),l(-.313,.156),l(-.469,-.022),l(-.357,-.089),M(527.156,37.071),l(-.59,-.14),l(-.955,-.21),l(-1.128,-.139),l(-.739,.054),l(-.959,.037),l(-.732,.143),l(-.411,-.105),l(-1.025,-.476),l(.737,-.303),l(1.21,-.429),l(.654,-.09),l(1.549,-.002),l(.135,-.357),l(-.728,-.338),l(.351,-.269),l(.419,-.144),l(.676,-.02),l(.852,-.181),l(-.25,-.161),l(-.526,-.233),l(1.539,-.895),l(.513,-.129),l(.226,.073),l(.892,.017),l(.981,-.535),l(.863,-.333),l(1.02,-.261),l(.975,-.15),l(1.305,-.113),l(1.274,.053),l(.738,-.15),l(.786,-.615),l(.273,.018),l(.873,-.132),l(1.722,.276),l(.471,-.038),l(1.93,-.321),l(.958,-.039),l(2.184,-.247),l(1.864,-.116),l(.771,-.564),l(.376,-.152),l(2.511,-.137),l(1.965,-.079),l(.471,.131),l(.442,.225),l(.154,.357),l(-.812,.47),l(-.541,.169),l(-1.346,.319),l(-2.609,.433),l(-4.329,.49),l(-2.187,.281),l(-2.122,.299),l(-1.842,.316),l(-2.102,.242),l(-.941,.203),l(-.288,.274),l(.644,.216),l(-.422,.217),l(-.943,.361),l(-.527,.037),l(-2.047,-.068),l(-.432,.18),l(-.119,.233),l(.621,.249),l(-.331,.233),l(-1.206,.448),l(-.402,-.142),l(-.752,-.087),l(-.592,.304),l(.877,.283),l(.052,.319),l(-1.094,.657),l(-.822,.284),M(517.491,38.443),l(1.041,-.37),l(.512,-.299),l(.428,-.212),l(1.426,-.021),l(1.316,-.249),l(.987,-.02),l(1.412,-.091),l(.551,.069),l(.988,.227),l(-.063,.176),l(-.463,.528),l(-.302,.158),l(-.697,.071),l(-.443,.228),l(-.233,.385),l(.006,.818),l(.445,1.039),l(.957,.826),l(.505,.308),l(.775,.307),l(1.162,.392),l(-.028,.282),l(-2.62,-.089),l(-.844,.053),l(-.917,.326),l(-.596,.086),l(-.676,-.494),l(-.382,-.034),l(-1.091,.088),l(-.673,-.102),l(-.031,-.359),l(1.347,-.362),l(.073,-.24),l(-.102,-.017),l(-.944,-.273),l(-1.442,-.411),l(-1.519,-.17),l(-.33,.156),l(-.624,.122),l(-.681,-.033),l(-.625,-.396),l(-.114,-.415),l(.229,-.312),l(.39,-.209),l(.344,-.036),l(.318,.104),l(.65,.016),l(.518,-.192),l(1.121,-.768),l(.243,-.35),l(-.322,0),l(-.981,-.243),M(.125,56.089),l(0,-.562),l(0,-.576),l(0,-.157),l(0,-1.292),V(0,51.28),l(0,-2.222),l(0,-2.12),l(2.917,.61),l(1.693,.598),l(.933,.181),l(3.819,.99),l(1.059,.395),l(.204,.149),l(.074,.214),l(.445,.429),l(.406,.789),l(-.209,.428),l(1.034,.8),l(.982,.26),l(-.02,-.18),l(.297,-.148),l(-.051,-.196),l(-.638,-.392),l(.016,-.542),l(.077,-.296),l(1.026,-.183),l(.984,.278),l(.573,.098),l(.767,.064),l(1.003,-.117),l(.933,.13),l(.93,.425),l(.694,.359),l(1.676,.684),l(.32,.081),l(.584,.179),l(.43,.211),l(.09,.13),l(-.343,.033),l(-1.026,-.096),l(-.364,.034),l(-.808,.798),l(-1.539,-.468),l(.138,.178),l(.438,.227),l(.465,.324),l(-1.177,-.111),l(-1.008,.05),l(-1.202,-.387),l(-.708,-.096),l(.135,.129),l(.289,.259),l(.084,0),l(.561,.259),l(.205,.307),l(.131,.453),l(-.056,.339),l(-.814,.05),l(-.805,.065),l(-.189,.161),l(.5,.865),l(-.115,.272),l(-1.04,-.078),l(-.397,.081),l(-1.193,-.174),l(-.264,-.352),l(-1.795,-.51),l(-.253,.273),L(9.85,55.79),l(-.276,-.161),l(-.265,-.403),l(.174,-.178),l(-.321,-.42),l(-.87,-.339),l(-.565,-.063),l(-.762,.034),l(-.858,.229),l(-1.343,.084),L(3.57,54.443),l(.059,-.325),l(-.155,-.325),l(-.618,-.487),L(1.958,53.43),l(-.45,.409),l(-.655,1.228),l(-.166,.715),l(-.562,.307),
N(449.401,22.792),l(-1.596,-.014),l(-2.019,-.016),l(-1.739,.063),l(-.764,.061),l(-1.972,-.316),l(.812,-.456),l(.826,-.172),l(.735,-.453),l(1.148,-.588),l(1.354,.691),l(.998,.105),l(1.116,-.088),l(.9,.084),l(.704,.341),l(.865,-.323),l(.53,-.454),l(.868,-.306),l(-.311,.823),l(.086,.32),l(.851,-.001),l(.991,-.495),l(1.061,-.261),l(.803,.128),l(.559,.472),l(.705,.041),l(2.007,-.111),l(1.543,.189),l(.551,.376),l(-.507,.201),l(-2.004,.622),l(-1.623,.38),l(-1.069,.062),l(-.976,.14),l(-1.324,.366),l(-6.271,-.097),l(-.033,-.377),l(1.492,-.26),l(.702,-.677),M(430.027,22.752),l(.068,.697),l(.252,.119),l(1.694,.155),l(.221,-.377),l(.13,-.418),l(.573,-.141),l(.523,-.041),l(.949,.477),l(1.192,.771),l(.798,.235),l(.568,-.218),l(-.222,-.296),l(-.46,-.356),l(-.327,-.477),l(-.04,-.22),l(.91,-.407),l(1.001,.103),l(.485,.18),l(1.278,.018),l(.586,.179),l(-.08,.419),l(-.169,.298),l(.104,.159),l(.549,.118),l(.743,-.338),l(.44,-.1),l(.662,.396),l(.678,.335),l(.785,.156),l(.948,.117),l(1.672,.429),l(.498,.234),l(-1.305,.277),l(-1.981,.218),l(-.696,.293),l(-.731,1.144),l(-.885,.885),l(-1.243,.117),l(-.766,.535),l(-.455,.589),l(-.029,.378),l(-.786,.209),l(-.556,-.018),l(-1.593,-.355),l(-1.883,-.507),l(-1.365,-.568),l(.651,-.364),l(1.565,-.041),l(1.788,-.137),l(.944,-.386),l(-.652,-.249),l(-1.822,.139),l(-1.566,.118),l(-1.694,.042),l(-.502,-.519),l(.959,-.06),l(1.371,-.215),l(2.149,-.314),l(1.547,-.45),l(-2.525,-.405),l(-.881,-.292),l(-.589,.138),l(-1.036,.646),l(-1.069,.293),l(-.562,.059),l(-1.236,-.172),l(-.338,-.174),l(-1.05,-.368),l(-.807,-.233),l(-.698,-.41),l(1.698,-.396),l(-.817,-.571),l(-1.359,.319),l(-.467,-.078),l(-.924,-.751),l(.812,-.36),l(.516,-.021),l(1.075,-.122),l(1.017,.038),l(.577,-.061),l(1.188,-.042),M(425.42,68.82),l(-.148,-.21),l(-.629,.132),l(-.134,-.026),l(-.249,-.237),l(-.239,-.343),l(.188,-.158),l(-.143,-.291),l(-.361,.185),l(-.062,.29),l(.113,.237),l(-.147,.105),l(-.339,.316),l(-.086,.185),l(-.521,.105),l(-.533,-.131),l(-.781,.342),l(.057,.131),l(-.502,.289),l(-.498,.263),l(-1.658,.813),L(418.697,71),l(-.274,.052),l(-.271,0),l(-2.111,.209),l(-.188,-.236),l(-.33,-.131),l(-.183,.209),L(414.976,71),l(.384,-.184),l(-.935,-.236),l(-.794,-.341),l(-.574,-.052),l(-.479,-.578),l(.292,-.368),l(-.126,-.21),l(.34,.026),l(.085,.316),l(.284,-.21),l(.667,.263),l(-.244,-.197),l(.127,-.145),l(.5,-.092),l(-.479,.026),l(-.245,.105),l(-.263,-.184),l(-.111,-.132),l(.579,-.276),l(.455,-.185),l(-.482,.066),l(-.317,-.132),l(.441,-.237),l(.083,-.237),l(-.661,.475),l(-.036,-.264),l(-.265,-.171),l(.005,.211),l(.076,.171),l(-.419,.158),l(-.41,0),l(.014,-.277),l(-.15,.264),l(-.235,-.079),l(-.2,-.448),l(.658,-.449),l(.08,.436),l(.068,-.317),l(.438,.158),l(.211,-.092),l(-.166,-.106),l(.674,-.079),l(.479,-.251),l(-.611,.159),l(-.48,0),l(-.335,-.159),l(.196,-.132),l(.387,-.146),l(.196,-.471),l(-.821,-.014),l(-.546,.094),l(-.406,-.309),l(.368,-.14),l(.643,-.404),l(-.212,-.186),l(-.445,.063),l(-.399,-.062),l(-.211,-.217),l(.284,-.482),l(.619,-.265),l(-.595,-.248),l(-.225,-.374),l(.272,-.188),l(-.089,-.687),l(.106,-.094),l(.594,-.063),l(.392,-.045),l(.455,.044),l(.082,-.11),l(-.255,-.134),l(-.425,-.118),l(-.228,-.17),l(.098,-.188),l(.211,-.125),l(.575,-.064),l(.511,-.346),l(.567,.109),l(.498,-.111),l(.179,-.55),l(.835,.093),l(.668,.125),l(.571,-.252),l(-.989,-.234),l(-.266,-.314),l(.236,-.143),l(1.151,.014),l(.851,-.08),l(.538,.219),l(.06,-.473),l(.477,-.27),l(.297,-.333),l(.78,-.175),l(.438,.189),l(.138,.079),l(.5,-.476),l(.869,-.413),l(.084,-.429),l(.437,-.398),l(1.497,-.735),l(.335,-.192),l(.235,-.048),l(.481,.175),l(.335,-.001),l(.319,-.224),l(-.225,-.223),l(.141,-.128),l(.488,-.224),l(.457,-.305),l(.481,-.483),l(.245,.064),l(.676,-.017),l(-.067,-.612),l(-.471,-.112),l(.434,-.405),l(.511,-.648),l(.841,.063),l(.047,-.341),l(.096,-.228),l(.954,-.116),l(-.396,-.357),l(-.327,-.097),l(-.193,-.146),l(.164,-.245),l(.313,-.246),l(.464,.048),l(.888,-.067),l(-.543,-.522),l(.249,-.082),l(.435,-.034),l(.707,-.263),l(.592,-.067),l(.308,-.208),l(-.358,-.064),l(-.105,-.187),l(.289,-.1),l(.616,-.33),l(.557,.032),l(.351,.098),l(.434,-.264),l(.369,-.031),l(.035,-.176),l(-.421,-.321),l(.627,-.232),l(.146,-.275),l(.336,.01),l(.359,.297),l(.397,.082),l(.526,-.381),l(-.281,-.656),l(.438,.065),l(.698,-.058),l(.207,-.174),l(-.604,-.315),l(.411,-.224),l(.816,-.251),l(.093,-.257),l(.261,-.194),l(.73,-.135),l(.074,.067),l(.274,-.051),l(.102,-.067),l(.492,-.67),l(.521,.25),l(.96,-.153),l(.411,.133),l(.265,.1),l(.646,.065),l(.536,-.419),l(.747,-.84),l(.286,-.085),l(.16,.168),l(-.178,.286),l(-.182,.587),l(.791,-.454),l(.403,-.572),l(.819,-.085),l(.688,-.439),l(.437,.117),l(.665,.353),l(.567,-.643),l(.318,-.272),l(.976,.1),l(1.019,.506),l(.197,-.152),l(.479,-.595),l(.709,-.444),l(.283,-.052),l(.562,.067),l(.338,-.308),l(.469,-.291),l(.619,-.189),l(1.2,-.173),l(.984,.015),l(-1.337,.755),l(-.24,.273),l(-.107,.646),l(.42,.084),l(.691,-.579),l(1.53,-.941),l(.764,-.275),l(.028,.257),l(-.004,.905),l(.704,-.172),l(.438,-.239),l(.855,-.874),l(.959,-.104),l(.586,-.001),l(.216,.154),l(-.383,.257),l(-.335,.257),l(.074,.239),l(-.319,.41),l(.921,.118),l(.221,-.443),l(.902,-.651),l(.421,.017),l(1.682,.561),l(.667,.135),l(.935,.015),l(.649,.237),l(.1,.272),l(-1.216,.393),l(-1.148,.036),l(-2.233,-.047),l(.193,.084),l(.585,.304),l(1.058,.284),l(.383,.302),l(.728,-.052),l(.679,-.102),l(.831,.032),l(.708,.25),l(-.404,.288),l(-.514,.204),l(-.824,.021),l(-.77,.121),l(-1.023,.49),l(-1.013,.672),l(-.689,.303),l(-.001,-.2),l(.096,-.367),l(.874,-.923),l(-.044,-.268),l(-.88,-.348),l(-.672,-.114),l(-1.125,-.431),l(-.556,.003),l(-.555,.07),l(-2.004,.095),l(-.865,.374),l(-.567,.422),l(-.26,.437),l(-.079,.501),l(-.188,.5),l(-1.25,.472),l(-.582,.368),l(-.31,-.148),l(-1.288,-.492),l(-1.657,.225),l(-1.411,-.042),l(-.536,-.13),l(-.861,-.595),l(-.994,-.612),l(-.486,-.082),l(-.355,.103),l(-1.012,.656),l(-.114,-.063),l(-.41,-.031),l(-.865,.038),l(-.281,1.066),l(-.164,.449),l(-.271,.25),l(-.323,-.015),l(-.67,-.129),l(-.972,-.144),l(-1.731,-.389),l(-.168,.183),l(-.021,.663),l(-.083,.199),l(-.318,.299),l(-.695,.004),l(-.871,-.095),l(-.279,-.015),l(-.465,.167),l(-1.484,1.176),l(.05,.213),l(.171,.507),l(-.188,.345),l(-.615,.346),l(-1.325,.919),l(-.687,.442),l(-.981,.021),l(-.121,.244),l(-.06,.971),l(-.32,.598),l(-.383,.469),l(-.574,.499),l(-.495,.545),l(.339,.125),l(.381,.269),l(.252,.587),l(-.17,.176),l(-.44,.177),l(-.733,.036),l(-.932,-.027),l(-.618,.114),l(-.613,.257),l(-.617,.479),l(-.389,.492),l(-.077,.664),l(-.349,1.093),l(.65,.729),l(-.335,1.171),l(.582,.39),l(.715,.186),l(.297,.243),l(-.432,.67),l(-.941,.16),l(.571,.735),l(.26,.427),l(-.249,.346),l(-.029,.532),l(-.769,.384),l(-.414,.013),l(-.117,.423),l(-.506,.224),l(.22,.831),l(-.324,.737),l(-.41,.013),l(-.15,-.342),l(-.293,-.132),
N(464.349,47.431),l(-.024,.283),l(-.258,.465),l(.116,.529),l(.563,.212),l(.872,.194),l(.964,.506),l(.543,.392),l(-.421,.364),l(-1.303,.777),l(-.328,.296),l(1.402,1.394),l(.772,1.195),l(-.196,.356),l(-.44,.535),l(-.187,.403),l(-.029,.37),l(.37,.509),l(1.286,1.395),l(.151,.253),l(-.057,.254),l(-.542,.415),l(-.327,.191),l(.439,.33),l(1.357,.499),l(.703,.265),l(.436,.392),l(.161,.346),l(-.105,.409),l(-.43,.536),l(-.591,.536),l(-1.385,.758),l(-1.983,1.195),l(-1.946,1.145),l(-.174,.285),l(-.935,.206),l(-1.195,.188),l(-.149,.181),l(-.506,-.217),l(-.518,.146),l(-.052,.134),l(-.688,-.07),l(-.193,-.108),l(.057,-.387),l(-.241,.527),l(-.268,.14),l(-.633,.047),l(-.328,.03),l(-.1,.267),l(-.589,-.326),l(-.29,.275),l(-.676,.064),l(-.34,.178),l(-.052,-.127),l(-.504,.108),l(-.504,.108),l(-.211,.266),l(-.311,-.152),l(-.672,.126),l(-.04,-.114),l(-.658,.215),l(-.547,.013),l(-.482,.025),l(-.487,-.253),l(-.223,-.274),l(.273,-.34),l(-.846,.017),l(-.517,.177),l(.065,-.382),l(-.446,.076),l(-.644,-.271),l(-.409,-.061),l(-.415,-.231),l(-.26,-.403),l(-.036,-.714),l(.158,-.374),l(.05,-.436),l(.09,-.234),l(-.347,-.483),l(-.431,-.375),l(.3,-.658),l(-.02,-.392),l(-.305,-.204),l(-.37,-.093),l(.062,-.299),l(.295,-.331),l(.637,-.285),l(.144,-.189),l(-.113,-.331),l(.382,-.143),l(.633,.125),l(.274,.063),l(.483,-.222),l(.303,-.427),l(.104,-.459),l(.207,-.27),l(.301,.316),l(.27,0),l(1.678,-1.114),l(1.142,-.654),l(.835,-.576),l(1.026,-.401),l(.874,.03),l(.06,-.304),l(-.13,-.144),l(-.357,-.16),l(.119,-.371),l(.146,-.387),l(-.329,-.274),l(-1.139,-.095),l(-.836,-.451),l(-.594,-.024),l(-.113,-.234),l(-.327,-.307),l(-.208,-.535),l(.5,-.8),l(-.028,-.392),l(-.405,-.685),l(-.507,-.637),l(.004,-.526),l(.062,-.413),l(-.77,-.558),l(-.508,-.229),l(-1.583,-.207),l(-1.085,-.292),l(-1.286,-.658),l(-.616,-.463),l(-.146,-.033),l(1.012,-.656),l(.355,-.103),l(.486,.082),l(.994,.612),l(.861,.595),l(.536,.13),l(1.411,.042),l(1.657,-.225),l(1.288,.492),l(.31,.148),l(.582,-.368),l(1.25,-.472),l(.188,-.5),l(.079,-.501),l(.26,-.437),l(.567,-.422),l(.865,-.374),l(2.004,-.095),l(.555,-.07),l(.556,-.003),l(1.125,.431),l(.672,.114),l(.88,.348),l(.044,.268),l(-.874,.923),l(-.096,.367),l(.001,.2),
N(453.795,53.873),l(-.23,-.004),l(-.975,.164),l(-.447,.098),l(-.902,-.387),l(-.339,-.178),l(-.347,.114),l(-.641,.374),l(-.542,.599),l(-.309,.146),l(-.658,.018),l(-.545,.355),l(.325,.241),l(.146,.192),l(-.355,.273),l(-.907,.401),l(.317,.271),l(.385,.159),l(.33,.302),l(-.749,.367),l(-.405,.43),l(-.368,.461),l(-1.591,.669),l(-.699,.286),l(-.456,-.205),l(-.326,.08),l(-.538,.539),l(-.646,.144),l(-.663,.348),l(-.217,.284),l(-.191,.142),l(-.746,.033),l(-.221,-.031),l(.151,.535),l(-.484,.425),L(439,61.33),l(.216,.533),l(.243,.25),l(-.244,.955),l(-.498,.063),l(-.217,.204),l(.189,.757),l(-.009,.544),l(.381,.444),l(-.287,.175),l(.926,.082),l(.225,.187),l(.499,-.082),l(.652,.594),l(.428,.314),l(.86,.163),l(.198,.406),l(.32,.139),l(.014,.335),l(-.391,0),l(-.508,.323),l(-.861,.3),l(-.492,.162),l(-.521,-.012),l(-.146,-.115),l(-.805,-.115),l(-.66,-.173),l(-.634,-.069),l(-.137,.104),l(-.446,-.115),l(-.257,.3),l(.819,-.069),l(.497,.265),l(.591,.046),l(.205,.208),l(.481,.069),l(.021,-.127),l(.616,.069),l(.258,-.196),l(.297,.011),l(.481,-.104),l(.226,.081),l(.026,-.15),l(.164,0),l(.214,.15),l(-.029,.081),l(-.722,.023),l(.219,.288),l(-.792,.265),l(-.168,.288),l(-.386,.08),l(-.089,-.092),l(.042,-.161),l(-.014,-.276),l(-.258,.023),l(-.091,.46),l(-.501,.333),l(-.248,.058),l(-.36,-.069),l(-.005,.218),l(-1.418,.035),l(.156,.458),l(.513,.258),l(.066,.609),l(-.109,.33),l(-.281,.051),l(-.308,-.064),l(.038,.429),l(.29,.081),l(-.126,.268),l(.24,.228),l(-.365,.364),l(-.222,.455),l(-.041,.56),l(-.766,1.043),l(-.58,.71),l(-.165,-.062),l(-.442,-.236),l(-.614,.193),l(-1.262,-.089),l(-.106,.311),l(-.252,-.083),l(-.518,.264),l(-.295,.517),l(.356,.336),l(-.376,.374),l(-.48,-.129),l(-.173,-.037),l(-1.158,.269),l(-1.11,-.116),l(-.001,-.142),l(.19,-.078),l(-.062,-.181),l(.281,-.297),l(-.638,-.53),l(-.413,-.479),l(-.22,-.272),l(.529,-.116),l(-.082,-.312),l(.421,.077),l(.147,-.245),l(-.19,-.234),l(-.285,.013),l(-.292,-.377),l(-.527,-.221),l(-.63,-.99),l(-.286,0),l(.011,-.408),l(-.256,-.364),l(-.348,-.298),l(.221,-.484),l(.206,-.341),l(-.418,-.154),l(-.405,.102),l(-.055,-.288),l(-.412,.051),l(-.18,-1.207),l(-.225,-.131),l(.311,-.355),l(.293,.132),l(.15,.342),l(.41,-.013),l(.324,-.737),l(-.22,-.831),l(.506,-.224),l(.117,-.423),l(.414,-.013),l(.769,-.384),l(.029,-.532),l(.249,-.346),l(-.26,-.427),l(-.571,-.735),l(.941,-.16),l(.432,-.67),l(-.297,-.243),l(-.715,-.186),l(-.582,-.39),l(.335,-1.171),l(-.65,-.729),l(.349,-1.093),l(.077,-.664),l(.389,-.492),l(.617,-.479),l(.613,-.257),l(.618,-.114),l(.932,.027),l(.733,-.036),l(.44,-.177),l(.17,-.176),l(-.252,-.587),l(-.381,-.269),l(-.339,-.125),l(.495,-.545),l(.574,-.499),l(.383,-.469),l(.32,-.598),l(.06,-.971),l(.121,-.244),l(.981,-.021),l(.687,-.442),l(1.325,-.919),l(.615,-.346),l(.188,-.345),l(-.171,-.507),l(-.05,-.213),l(1.484,-1.176),l(.465,-.167),l(.279,.015),l(.871,.095),l(.695,-.004),l(.318,-.299),l(.083,-.199),l(.021,-.663),l(.168,-.183),l(1.731,.389),l(.972,.144),l(.67,.129),l(.323,.015),l(.271,-.25),l(.164,-.449),l(.281,-1.066),l(.865,-.038),l(.41,.031),l(.114,.063),l(.146,.033),l(.616,.463),l(1.286,.658),l(1.085,.292),l(1.583,.207),l(.508,.229),l(.77,.558),l(-.062,.413),l(-.004,.526),l(.507,.637),l(.405,.685),l(.028,.392),l(-.5,.8),l(.208,.535),l(.327,.307),l(.113,.234),
N(238.107,361.753),l(.515,-.688),l(.859,0),l(1.202,-.515),l(-.171,-.858),l(-3.091,.344),l(-2.061,.515),l(-1.545,-.344),l(-.515,-.858),l(1.374,-.515),l(1.202,-.172),l(3.091,-.172),l(1.374,-.515),l(-.172,-1.03),l(.859,-.516),l(0,-1.374),l(-1.326,-1.054),l(.982,-.491),l(1.202,-.344),l(1.545,-.172),l(.858,.344),l(.858,.858),l(1.03,1.374),l(1.374,1.202),l(1.03,1.373),l(-.515,2.061),l(-1.545,.516),l(-1.545,.858),l(-3.434,.172),l(-3.435,0),M(172.686,360.379),l(3.091,-.687),l(3.262,0),l(5.495,0),l(2.919,1.202),l(-2.748,.687),l(-3.759,-.337),l(-5.169,-.35),l(-3.091,-.516),M(65.13,371.085),l(1.194,-.265),l(1.393,.133),l(.796,.464),l(-1.99,0),l(-1.393,-.332),M(277.944,379.954),l(.515,-1.202),l(2.404,-1.03),l(2.748,-.172),l(2.061,-.171),l(1.545,-.859),l(.343,-1.545),l(1.374,-.687),l(3.091,-.688),l(4.464,0),l(2.404,0),l(3.434,.688),l(.687,1.889),l(0,1.202),l(-2.061,1.201),l(-11.848,1.03),l(-11.161,.344),M(36.004,376.434),l(1.202,-.858),l(2.061,-.343),l(4.121,.515),l(4.293,1.374),l(-.887,.482),l(-2.719,.204),l(-4.293,-.515),l(-3.777,-.859),M(777.843,385.46),l(3.823,.391),l(.899,.029),l(.322,.234),l(1.202,.294),l(2.329,.088),l(2.126,-.003),l(5.218,.329),l(3.046,.348),l(1.144,-.059),l(.762,.029),l(1.411,.37),l(0,2.175),l(0,2.223),l(0,2.222),l(0,2.223),l(0,2.222),l(0,1.551),l(-.041,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.182,0),l(-.041,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.223,0),l(-2.182,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.223,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),l(-2.222,0),H(9.014,0),H(6.792,0),H(4.569,0),H(2.347,0),H(.125,0),l(0,-1.544),l(0,-2.222),l(0,-2.223),l(0,-2.222),l(0,-2.223),l(0,-2.223),l(3.941,.297),l(10.131,0),l(7.898,.516),l(6.868,.172),l(8.586,.858),l(6.353,.515),l(8.757,.172),l(4.808,-.172),l(6.525,-.172),l(2.404,.344),l(3.606,-.858),l(16.312,.344),l(4.638,-.013),l(1.143,-.467),l(-14.366,-.551),l(-9.616,-.688),l(-2.232,0),l(-3.091,-.172),l(-.858,-.171),l(-1.545,-.344),l(-.498,-.455),l(.155,-1.434),l(.687,-.858),l(1.889,-.688),l(-3.263,-.687),l(-2.232,-.344),l(-.953,-.503),l(1.589,-.521),l(-2.891,-.6),l(-3.074,-.208),l(-.104,-.261),l(2.857,-.312),l(2.748,0),l(6.525,.343),l(3.434,0),l(2.576,.344),l(4.636,-1.202),l(2.404,-.687),l(-2.748,-1.03),l(-3.778,-.858),l(-4.391,-.405),l(-2.649,-.625),l(-3.262,-.172),l(-2.919,0),l(-2.919,-.858),l(2.576,-.516),l(1.28,-.342),l(-1.28,-.517),l(-2.919,.516),H(52.66,0),l(-1.717,-.344),L(49.054,373),l(.343,-1.202),l(1.956,-.07),l(1.65,-.273),l(4.98,0),l(4.626,.493),l(3.272,.709),l(1.374,.172),l(4.465,-.858),l(4.089,.243),l(0,-.729),l(.066,-.597),l(-2.255,-.73),l(-2.93,-.075),l(-2.576,-.344),l(2.404,-.687),l(4.121,.171),l(1.717,-.343),l(3.091,-.516),l(3.09,-.343),l(5.667,-.688),l(4.465,-.343),l(3.949,-.516),l(4.464,-.515),l(2.748,.343),l(5.667,0),l(4.464,.258),l(4.121,-.515),l(7.898,.343),l(7.555,-.687),l(3.091,.172),l(1.545,-.688),l(1.545,.516),l(5.323,-.172),l(.121,-.87),l(1.758,-.293),l(1.433,.325),l(.586,.554),l(-.423,.813),l(2.364,.329),l(1.38,-.264),l(-.006,-.938),l(1.438,-.267),l(1.48,.267),l(.212,1.036),l(-1.009,.423),l(.521,.781),l(3.024,-.351),l(1.889,.343),l(3.434,.172),l(2.576,-.687),l(3.778,.086),l(4.868,.33),l(2.344,.013),l(1.449,.109),l(.693,-.53),l(-.611,-.285),l(-2.202,-.122),l(1.305,-.285),l(.041,-.408),l(-.367,-.245),l(-1.386,.123),l(-.693,.04),l(-.856,-.979),l(-2.178,-.337),l(-.676,-.193),l(-.182,-.665),l(4.056,.462),l(3.874,-.245),l(-1.224,-.489),l(-6.035,-.163),l(-.774,-.082),l(-.653,-.489),l(0,-.815),l(2.301,.105),l(.839,.67),l(5.301,-.204),l(7.253,.736),l(2.404,-.172),l(3.262,-.172),l(4.464,.172),l(3.263,.172),l(2.061,-.516),l(.687,-.687),l(1.202,0),l(.344,1.03),l(2.576,.343),l(2.404,-.343),l(.858,.515),l(3.435,.688),l(3.777,.343),l(2.061,.172),l(1.03,-.515),l(.687,-1.202),l(2.747,-.172),l(1.03,.515),l(1.717,.688),l(3.091,-.172),l(3.434,.258),l(4.121,-.344),l(4.979,-.516),l(5.495,-.858),l(3.091,-.515),l(1.202,-.688),l(0,-1.373),l(-1.374,-1.202),l(-.859,-1.545),l(-1.202,-.688),l(-.344,-1.03),l(1.202,-1.03),l(1.717,-.343),l(.858,-1.202),l(-.343,-.858),l(-.172,-1.03),l(-1.202,-.516),l(.344,-1.545),l(1.889,-.172),l(2.404,-1.374),l(1.545,-.515),l(.859,-.859),l(1.03,-.687),l(2.919,-1.202),l(3.606,-.515),l(2.404,-1.202),l(2.404,-.172),l(2.232,-1.03),l(1.545,-.343),l(.343,1.03),l(-1.374,.515),l(-1.03,.344),l(-1.202,.515),l(-.858,0),l(-1.202,0),l(-2.919,1.202),l(-1.03,.687),l(-1.717,1.374),l(-.172,1.202),l(-.687,.687),l(-1.374,-.344),l(-1.03,0),l(-1.202,.516),l(-1.202,.687),l(-1.03,.688),l(-.687,1.201),l(.515,.688),l(.687,.687),l(1.374,.344),l(1.545,0),l(.858,.515),l(.687,1.202),l(1.545,1.546),l(.687,.858),l(1.03,.687),l(.687,1.374),l(.858,1.373),l(.344,1.546),l(-.344,.858),l(-.858,1.717),l(-2.919,1.889),l(-1.202,.172),l(-1.03,.858),l(-1.717,1.03),l(-3.263,.344),l(-4.979,.858),l(-2.404,.344),l(-2.919,.687),l(-7.377,-.141),l(-4.556,-.316),l(-.773,-.401),l(-1.717,-.344),l(-1.717,-.343),l(-1.374,0),l(-.859,.515),l(.515,.858),l(2.061,.688),l(4.121,1.202),l(4.995,.04),l(1.202,.759),l(-3.278,.574),l(-5.667,-.343),l(-4.979,-.516),l(-3.097,-.285),l(-2.151,.253),l(.823,.696),l(1.164,.538),l(3.262,.172),l(2.232,0),l(1.374,.343),l(-.249,.402),l(-.782,.113),l(-2.232,.515),l(-5.151,-.171),l(-1.374,-.172),l(-2.232,-1.202),l(-2.404,0),l(.128,.917),l(2.62,1.144),l(1.03,.172),l(1.202,-.172),l(1.374,.344),l(2.404,0),l(4.98,-.516),l(3.09,.687),l(.385,.431),l(-.041,.6),l(-2.061,.172),l(-3.263,.172),l(-2.608,-.185),l(3.811,.871),l(3.656,-.238),l(1.324,.41),l(2.576,.687),l(6.869,.859),l(8.585,.858),l(10.646,1.373),l(6.525,.516),l(2.061,.858),l(.687,1.03),l(3.091,-.344),l(5.323,-1.545),l(6.525,-.687),l(2.455,-.066),l(6.474,-.105),l(9.788,-.344),l(1.889,.344),l(2.576,-1.202),l(8.414,-1.03),l(11.333,-.172),l(8.929,-.858),l(1.202,-.858),l(-1.202,-.516),l(-.271,-1.07),l(-1.184,-.338),l(-5.071,.035),l(-2.232,.172),l(-4.808,-.344),l(-3.091,0),l(0,-1.202),l(3.263,-1.545),l(3.949,-1.202),l(2.404,-.172),l(4.121,-1.03),l(9.444,-1.202),l(5.323,-.858),l(6.525,0),l(4.979,-.516),l(2.747,-2.061),l(6.039,-1.541),l(-1.23,-.52),l(-2.576,.516),l(-2.061,-.344),l(1.545,-1.03),l(1.545,-.343),l(2.48,-.249),l(.696,-.742),l(3.85,-.742),l(1.577,-.418),l(.603,-.557),l(-1.716,-.881),l(-.093,-.604),l(1.252,-.231),l(.464,.742),l(1.017,-.097),l(2.061,-.858),l(1.03,-.343),l(.858,.171),l(1.203,1.544),l(2.403,-.342),l(.242,-.91),l(.96,-.807),l(1.889,-.516),l(1.374,.516),l(-1.162,.574),l(-.139,.604),l(3.189,-.319),l(4.808,.258),l(3.263,-.172),l(1.03,.858),l(1.545,-.344),l(1.717,-.515),l(5.839,-.858),l(7.212,-1.03),l(4.292,-.858),l(2.061,0),l(2.061,1.373),l(1.718,.344),l(1.889,-.344),l(1.545,-.858),l(7.556,-.344),l(3.434,-.171),l(4.293,.171),l(6.697,.945),l(2.575,0),l(4.293,-.516),l(6.01,-.687),l(5.151,-.688),l(2.404,-.515),l(2.231,-.344),l(.615,-.959),l(1.148,-.835),l(1.671,-.095),l(.938,.965),l(1.294,.409),l(1.732,1.052),l(1.009,.139),l(1.009,-.661),l(1.322,-.174),l(.209,.522),l(-.835,.312),l(.661,.244),l(.8,.278),l(.383,-.383),l(.313,-.383),l(.312,.209),l(-.174,.348),l(0,.521),l(.592,-.174),l(1.913,-.557),l(.418,-1.704),l(5.102,-1.137),l(1.374,-.687),l(3.605,-.172),l(1.363,-.646),l(2.758,-.126),l(.21,-.27),l(-.165,-.297),l(.692,-.23),l(1.221,.165),l(.197,.593),l(.66,.231),l(2.165,-.536),l(1.265,-.223),l(-.726,-.297),l(-.561,-.264),l(.099,-.362),l(1.451,-.1),l(1.562,.215),l(.647,.28),l(.692,-.132),l(-.066,-.33),l(-.527,-.33),l(0,-.561),l(.297,-.23),l(.846,-.242),l(4.292,-.858),l(2.92,-.172),l(3.058,.115),l(2.296,1.076),l(1.316,.023),l(.741,.144),l(.023,.383),l(-.908,.096),l(-.168,.454),l(1.723,.216),l(4.892,.646),l(5.571,.453),l(1.546,.172),l(1.717,-.172),l(7.556,.688),l(5.323,0),l(.687,.687),l(.2,1.075),l(-.73,1.232),l(-.672,.439),l(-.425,1.113),l(-.73,.319),l(-.905,-.402),l(-.83,.402),l(-.73,.959),l(1.507,.457),l(.594,.045),l(.959,-.593),l(.411,.365),l(-.867,1.05),l(-1.215,.062),l(-1.717,1.374),l(0,.858),l(1.889,.688),l(2.919,0),l(1.718,-.859),l(1.889,-1.545),l(1.717,-1.717),l(1.374,-.688),l(4.121,-1.03),l(2.231,-.687),l(3.263,-.344),l(2.061,-1.03),l(1.03,-1.03),l(3.435,-1.03),l(2.403,-.687),l(2.061,-.687),l(2.061,-.172),l(6.182,-.687),l(3.778,.171),l(1.204,-.542),l(.169,-.659),l(.54,-.759),l(.49,-.101),l(.471,.776),l(.305,.775),l(4.892,-.35),l(5.838,0),l(4.979,-.172),l(3.091,.344),l(2.112,-.214),l(1.328,.085),l(1.018,.594),l(1.188,-.764),l(2.714,-1.046),l(1.866,-.226),l(.664,-.028),l(.594,-.028),l(.777,-.057),l(1.512,.311),l(1.166,-.172),l(3.606,.687),l(3.777,.344),l(1.03,0),l(1.064,.573),l(.745,.088),l(2.149,-.088),l(1.271,-.263),l(1.315,-.438),l(-.192,-.216),l(.28,-.53),l(1.447,-.131),l(.921,-.088),l(.786,.062),l(2.195,-.501),l(2.097,.501),l(.688,.687),l(.373,.435),l(1.842,-.131),l(.921,-.044),l(.985,.255),l(1.889,.688),l(2.919,.515),l(2.919,-.343),l(4.121,-.258),l(2.232,-.344),l(2.404,0),l(3.521,.315),l(.702,-.755),l(2.158,-.162),l(.863,1.133),l(4.909,.323),l(.917,-1.133),l(1.889,-.593),l(5.988,.013),l(.756,-.283),l(1.996,.108),l(-.432,-1.403),l(.054,-.809),l(1.232,-.36),l(.872,1.277),l(-.647,1.079),l(.805,.219),l(2.81,.482),l(5.262,.376),l(5.494,.344),l(2.278,.583),l(1.283,.14),l(1.396,-.167),l(2.204,.446),l(1.961,-.167),l(.719,.278),l(-.435,.431),l(-.151,.351),l(.293,.123),l(2.081,.331),l(1.078,.484),l(2.706,-.134),l(.377,.595),l(1.038,.227),l(4.808,.515),l(-.123,.536),l(.567,.236),l(2.695,-.095),l(3.214,.181),l(-.329,-.984),l(.71,-.095),l(.804,.426),l(.331,.709),l(1.135,.284),l(2.672,.519),l(2.576,-.343),l(4.017,.999),l(1.626,.495),l(1.672,.871),l(1.626,.023),l(.504,.187),l(.532,-.021),l(.754,-.047),l(.777,.047),l(.896,.589),l(.541,.118),l(.542,.07),l(.142,-.259),l(.471,0),l(1.484,-.048),l(1.416,.237),l(5.951,.535),l(.729,.516),l(1.733,.323),l(2.979,.944),l(.43,-.335),l(.551,.191),l(.454,.67),l(-.741,.215),l(-1.124,.167),l(-.216,.359),l(.168,.263),l(.55,-.048),l(-.024,.67),l(-.43,-.048),l(-.096,.287),l(-.312,.071),l(-.598,.622),l(-.526,.12),l(-.55,.287),l(-.168,.669),l(-1.603,.096),l(-1.339,-.239),l(-1.794,.359),l(-2.153,.425),l(-2.629,.764),l(1.271,1.103),l(-1.907,.212),l(-1.23,-.255),l(-.763,.212),l(-.043,.637),l(-2.374,.169),l(.136,.514),l(.924,.632),l(-.127,.763),l(-.382,.085),l(-.466,.467),l(.551,.466),l(.085,.764),l(-.764,.424),l(.637,.254),l(.763,0),l(.764,.255),l(.339,.509),l(.17,.721),l(1.284,-.187),l(.836,.907),l(2.035,.297),l(.339,.339),l(2.672,.552),l(-4.113,0),l(-2.799,.138),l(-2.332,.541),l(-1.823,-.085),l(-.806,.212),l(-1.611,.339),l(-1.326,-.32),l(-.546,.426),l(1.116,.529),l(-.503,.447),l(-.669,.195),l(-1.117,.753),l(-2.623,.642),l(.475,.391),l(2.205,-.111),l(.53,0),l(.809,.307),l(.168,.363),l(.499,.18),l(.422,.183),l(.111,.894),l(.209,.502),l(3.195,.279),l(2.874,.948),l(3.662,.801),l(5.151,1.202),l(1.456,.062),l(1.015,.17),l(-.146,.234),l(-1.67,.264),l(-.47,.264),l(1.173,.088),l(2.198,-.293),l(1.988,.166),
E(0,0)
};

#undef N
#undef M
#undef L
#undef l
#undef E
