; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=loop-versioning -S %s | FileCheck %s

; Callers should not call LoopVersioning on single-iteration loops, as it
; is very likely not profitable.
; LoopVersioning faithfully versions single-iteration loops when the stride
; is unknown.

define double @single_iteration_unknown_stride(i32 %x, ptr %y, i1 %cond) {
; CHECK-LABEL: define double @single_iteration_unknown_stride(
; CHECK-SAME: i32 [[X:%.*]], ptr [[Y:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br i1 [[COND]], label %[[NOLOOP_EXIT:.*]], label %[[LOOP_BODY_LVER_CHECK:.*]]
; CHECK:       [[LOOP_BODY_LVER_CHECK]]:
; CHECK-NEXT:    [[SEXT7:%.*]] = sext i32 [[X]] to i64
; CHECK-NEXT:    [[GEP8:%.*]] = getelementptr i8, ptr [[Y]], i64 8
; CHECK-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i32 [[X]], 1
; CHECK-NEXT:    br i1 [[IDENT_CHECK]], label %[[LOOP_BODY_PH_LVER_ORIG:.*]], label %[[LOOP_BODY_PH:.*]]
; CHECK:       [[LOOP_BODY_PH_LVER_ORIG]]:
; CHECK-NEXT:    br label %[[LOOP_BODY_LVER_ORIG:.*]]
; CHECK:       [[LOOP_BODY_LVER_ORIG]]:
; CHECK-NEXT:    [[PHI_LVER_ORIG:%.*]] = phi i64 [ 0, %[[LOOP_BODY_PH_LVER_ORIG]] ], [ [[ADD_LVER_ORIG:%.*]], %[[LOOP_BODY_LVER_ORIG]] ]
; CHECK-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[PHI_LVER_ORIG]], [[SEXT7]]
; CHECK-NEXT:    [[GEP10_LVER_ORIG:%.*]] = getelementptr double, ptr [[GEP8]], i64 [[MUL_LVER_ORIG]]
; CHECK-NEXT:    [[LOAD11_LVER_ORIG:%.*]] = load double, ptr [[GEP10_LVER_ORIG]], align 8
; CHECK-NEXT:    store double [[LOAD11_LVER_ORIG]], ptr [[Y]], align 8
; CHECK-NEXT:    [[ADD_LVER_ORIG]] = add i64 [[PHI_LVER_ORIG]], 1
; CHECK-NEXT:    [[ICMP_LVER_ORIG:%.*]] = icmp eq i64 [[PHI_LVER_ORIG]], 0
; CHECK-NEXT:    br i1 [[ICMP_LVER_ORIG]], label %[[LOOP_EXIT_LOOPEXIT:.*]], label %[[LOOP_BODY_LVER_ORIG]]
; CHECK:       [[LOOP_BODY_PH]]:
; CHECK-NEXT:    br label %[[LOOP_BODY:.*]]
; CHECK:       [[LOOP_BODY]]:
; CHECK-NEXT:    [[PHI:%.*]] = phi i64 [ 0, %[[LOOP_BODY_PH]] ], [ [[ADD:%.*]], %[[LOOP_BODY]] ]
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[PHI]], [[SEXT7]]
; CHECK-NEXT:    [[GEP10:%.*]] = getelementptr double, ptr [[GEP8]], i64 [[MUL]]
; CHECK-NEXT:    [[LOAD11:%.*]] = load double, ptr [[GEP10]], align 8
; CHECK-NEXT:    store double [[LOAD11]], ptr [[Y]], align 8
; CHECK-NEXT:    [[ADD]] = add i64 [[PHI]], 1
; CHECK-NEXT:    [[ICMP:%.*]] = icmp eq i64 [[PHI]], 0
; CHECK-NEXT:    br i1 [[ICMP]], label %[[LOOP_EXIT_LOOPEXIT1:.*]], label %[[LOOP_BODY]]
; CHECK:       [[NOLOOP_EXIT]]:
; CHECK-NEXT:    [[SEXT:%.*]] = sext i32 [[X]] to i64
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr double, ptr [[Y]], i64 [[SEXT]]
; CHECK-NEXT:    [[LOAD5:%.*]] = load double, ptr [[GEP]], align 8
; CHECK-NEXT:    ret double [[LOAD5]]
; CHECK:       [[LOOP_EXIT_LOOPEXIT]]:
; CHECK-NEXT:    br label %[[LOOP_EXIT:.*]]
; CHECK:       [[LOOP_EXIT_LOOPEXIT1]]:
; CHECK-NEXT:    br label %[[LOOP_EXIT]]
; CHECK:       [[LOOP_EXIT]]:
; CHECK-NEXT:    [[SEXT2:%.*]] = sext i32 [[X]] to i64
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr double, ptr [[Y]], i64 [[SEXT2]]
; CHECK-NEXT:    [[LOAD6:%.*]] = load double, ptr [[GEP2]], align 8
; CHECK-NEXT:    ret double [[LOAD6]]
;
entry:
  br i1 %cond, label %noloop.exit, label %loop.ph

loop.ph:                                          ; preds = %entry
  %sext7 = sext i32 %x to i64
  %gep8 = getelementptr i8, ptr %y, i64 8
  br label %loop.body

loop.body:                                        ; preds = %loop.body, %loop.ph
  %iv = phi i64 [ 0, %loop.ph ], [ %iv.next, %loop.body ]
  %mul = mul i64 %iv, %sext7
  %gep10 = getelementptr double, ptr %gep8, i64 %mul
  %load11 = load double, ptr %gep10, align 8
  store double %load11, ptr %y, align 8
  %iv.next = add i64 %iv, 1
  %icmp = icmp eq i64 %iv, 0
  br i1 %icmp, label %loop.exit, label %loop.body

noloop.exit:                                      ; preds = %entry
  %sext = sext i32 %x to i64
  %gep = getelementptr double, ptr %y, i64 %sext
  %load5 = load double, ptr %gep, align 8
  ret double %load5

loop.exit:                                        ; preds = %loop.body
  %sext2 = sext i32 %x to i64
  %gep2 = getelementptr double, ptr %y, i64 %sext2
  %load6 = load double, ptr %gep2, align 8
  ret double %load6
}
