; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=aggressive-instcombine -S | FileCheck %s

define i1 @remove_shift_nuw_ab(i8 %a, i8 %b, i8 %s) {
; CHECK-LABEL: @remove_shift_nuw_ab(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[T:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %t = shl nuw i8 %a, %s
  %or = or i8 %t, %b
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_nuw_ba(i8 %a, i8 %b, i8 %s) {
; CHECK-LABEL: @remove_shift_nuw_ba(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[B:%.*]], [[T:%.*]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %t = shl nuw i8 %a, %s
  %or = or i8 %b, %t
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_nsw(i8 %a, i8 %b, i8 %s) {
; CHECK-LABEL: @remove_shift_nsw(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[T:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %t = shl nsw i8 %a, %s
  %or = or i8 %t, %b
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_nuw_ne(i8 %a, i8 %b, i8 %s) {
; CHECK-LABEL: @remove_shift_nuw_ne(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[T:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %t = shl nuw i8 %a, %s
  %or = or i8 %t, %b
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_nsw_ne(i8 %a, i8 %b, i8 %s) {
; CHECK-LABEL: @remove_shift_nsw_ne(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[T:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %t = shl nsw i8 %a, %s
  %or = or i8 %t, %b
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_wraps(i8 %a, i8 %b, i8 %s) {
; CHECK-LABEL: @remove_shift_wraps(
; CHECK-NEXT:    [[T:%.*]] = shl i8 [[A:%.*]], [[S:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[T]], [[B:%.*]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %t = shl i8 %a, %s
  %or = or i8 %t, %b
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_chain_d(i8 %a, i8 %b, i8 %c, i8 %d, i8 %s) {
; CHECK-LABEL: @remove_shift_chain_d(
; CHECK-NEXT:    [[OR1:%.*]] = or i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[OR2:%.*]] = or i8 [[C:%.*]], [[DT:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[OR1]], [[OR2]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %dt = shl nuw i8 %d, %s
  %or1 = or i8 %a, %b
  %or2 = or i8 %c, %dt
  %or = or i8 %or1, %or2
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_chain_abcd(i8 %a, i8 %b, i8 %c, i8 %d, i8 %s) {
; CHECK-LABEL: @remove_shift_chain_abcd(
; CHECK-NEXT:    [[OR1:%.*]] = or i8 [[AT:%.*]], [[BT:%.*]]
; CHECK-NEXT:    [[OR2:%.*]] = or i8 [[CT:%.*]], [[DT:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[OR1]], [[OR2]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    ret i1 [[IC]]
;
  %at = shl nuw i8 %a, %s
  %bt = shl nuw i8 %b, 2
  %ct = shl nuw i8 %c, 1
  %dt = shl nuw i8 %d, %s
  %or1 = or i8 %at, %bt
  %or2 = or i8 %ct, %dt
  %or = or i8 %or1, %or2
  %ic = icmp eq i8 %or, 0
  ret i1 %ic
}

define i1 @remove_shift_chain_abcd_multiuse(i8 %a, i8 %b, i8 %c, i8 %d, i8 %s) {
; CHECK-LABEL: @remove_shift_chain_abcd_multiuse(
; CHECK-NEXT:    [[AT:%.*]] = shl nuw i8 [[A:%.*]], [[S:%.*]]
; CHECK-NEXT:    [[BT:%.*]] = shl nuw i8 [[B:%.*]], 2
; CHECK-NEXT:    [[CT:%.*]] = shl nuw i8 [[C:%.*]], 1
; CHECK-NEXT:    [[DT:%.*]] = shl nuw i8 [[D:%.*]], [[S]]
; CHECK-NEXT:    [[OR1:%.*]] = or i8 [[AT]], [[BT]]
; CHECK-NEXT:    [[OR2:%.*]] = or i8 [[CT]], [[DT]]
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[OR1]], [[OR2]]
; CHECK-NEXT:    [[IC:%.*]] = icmp eq i8 [[OR]], 0
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    ret i1 [[IC]]
;
  %at = shl nuw i8 %a, %s
  %bt = shl nuw i8 %b, 2
  %ct = shl nuw i8 %c, 1
  %dt = shl nuw i8 %d, %s
  %or1 = or i8 %at, %bt
  %or2 = or i8 %ct, %dt
  %or = or i8 %or1, %or2
  %ic = icmp eq i8 %or, 0
  call void @use(i8 %or)
  ret i1 %ic
}

declare void @use(i8)
