; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-macosx -mattr=+avx2 -enable-no-signed-zeros-fp-math | FileCheck %s

; Check that the ExeDepsFix pass correctly fixes the domain for broadcast instructions.
; <rdar://problem/16354675>

define <4 x float> @ExeDepsFix_broadcastss(<4 x float> %arg, <4 x float> %arg2) {
; CHECK-LABEL: ExeDepsFix_broadcastss:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vbroadcastss {{.*#+}} xmm2 = [NaN,NaN,NaN,NaN]
; CHECK-NEXT:    vandps %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <4 x float> %arg to <4 x i32>
  %and = and <4 x i32> %bitcast, <i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647>
  %floatcast = bitcast <4 x i32> %and to <4 x float>
  %max_is_x = fcmp oge <4 x float> %floatcast, %arg2
  %max = select <4 x i1> %max_is_x, <4 x float> %floatcast, <4 x float> %arg2
  ret <4 x float> %max
}

define <8 x float> @ExeDepsFix_broadcastss256(<8 x float> %arg, <8 x float> %arg2) {
; CHECK-LABEL: ExeDepsFix_broadcastss256:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vbroadcastss {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; CHECK-NEXT:    vandps %ymm2, %ymm0, %ymm0
; CHECK-NEXT:    vmaxps %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <8 x float> %arg to <8 x i32>
  %and = and <8 x i32> %bitcast, <i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647>
  %floatcast = bitcast <8 x i32> %and to <8 x float>
  %max_is_x = fcmp oge <8 x float> %floatcast, %arg2
  %max = select <8 x i1> %max_is_x, <8 x float> %floatcast, <8 x float> %arg2
  ret <8 x float> %max
}

define <4 x float> @ExeDepsFix_broadcastss_inreg(<4 x float> %arg, <4 x float> %arg2, i32 %broadcastvalue) {
; CHECK-LABEL: ExeDepsFix_broadcastss_inreg:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovd %edi, %xmm2
; CHECK-NEXT:    vpbroadcastd %xmm2, %xmm2
; CHECK-NEXT:    vpand %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <4 x float> %arg to <4 x i32>
  %in = insertelement <4 x i32> undef, i32 %broadcastvalue, i32 0
  %mask = shufflevector <4 x i32> %in, <4 x i32> undef, <4 x i32> zeroinitializer
  %and = and <4 x i32> %bitcast, %mask
  %floatcast = bitcast <4 x i32> %and to <4 x float>
  %max_is_x = fcmp oge <4 x float> %floatcast, %arg2
  %max = select <4 x i1> %max_is_x, <4 x float> %floatcast, <4 x float> %arg2
  ret <4 x float> %max
}

define <8 x float> @ExeDepsFix_broadcastss256_inreg(<8 x float> %arg, <8 x float> %arg2, i32 %broadcastvalue) {
; CHECK-LABEL: ExeDepsFix_broadcastss256_inreg:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovd %edi, %xmm2
; CHECK-NEXT:    vpbroadcastd %xmm2, %ymm2
; CHECK-NEXT:    vpand %ymm2, %ymm0, %ymm0
; CHECK-NEXT:    vmaxps %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <8 x float> %arg to <8 x i32>
  %in = insertelement <8 x i32> undef, i32 %broadcastvalue, i32 0
  %mask = shufflevector <8 x i32> %in, <8 x i32> undef, <8 x i32> zeroinitializer
  %and = and <8 x i32> %bitcast, %mask
  %floatcast = bitcast <8 x i32> %and to <8 x float>
  %max_is_x = fcmp oge <8 x float> %floatcast, %arg2
  %max = select <8 x i1> %max_is_x, <8 x float> %floatcast, <8 x float> %arg2
  ret <8 x float> %max
}

; In that case the broadcast is directly folded into vandpd.
define <2 x double> @ExeDepsFix_broadcastsd(<2 x double> %arg, <2 x double> %arg2) {
; CHECK-LABEL: ExeDepsFix_broadcastsd:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; CHECK-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <2 x double> %arg to <2 x i64>
  %and = and <2 x i64> %bitcast, <i64 2147483647, i64 2147483647>
  %floatcast = bitcast <2 x i64> %and to <2 x double>
  %max_is_x = fcmp oge <2 x double> %floatcast, %arg2
  %max = select <2 x i1> %max_is_x, <2 x double> %floatcast, <2 x double> %arg2
  ret <2 x double> %max
}

define <4 x double> @ExeDepsFix_broadcastsd256(<4 x double> %arg, <4 x double> %arg2) {
; CHECK-LABEL: ExeDepsFix_broadcastsd256:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [2147483647,2147483647,2147483647,2147483647]
; CHECK-NEXT:    vandpd %ymm2, %ymm0, %ymm0
; CHECK-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <4 x double> %arg to <4 x i64>
  %and = and <4 x i64> %bitcast, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %floatcast = bitcast <4 x i64> %and to <4 x double>
  %max_is_x = fcmp oge <4 x double> %floatcast, %arg2
  %max = select <4 x i1> %max_is_x, <4 x double> %floatcast, <4 x double> %arg2
  ret <4 x double> %max
}

; ExeDepsFix works top down, thus it coalesces vpunpcklqdq domain with
; vpand and there is nothing more you can do to match vmaxpd.
define <2 x double> @ExeDepsFix_broadcastsd_inreg(<2 x double> %arg, <2 x double> %arg2, i64 %broadcastvalue) {
; CHECK-LABEL: ExeDepsFix_broadcastsd_inreg:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovq %rdi, %xmm2
; CHECK-NEXT:    vpbroadcastq %xmm2, %xmm2
; CHECK-NEXT:    vpand %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <2 x double> %arg to <2 x i64>
  %in = insertelement <2 x i64> undef, i64 %broadcastvalue, i32 0
  %mask = shufflevector <2 x i64> %in, <2 x i64> undef, <2 x i32> zeroinitializer
  %and = and <2 x i64> %bitcast, %mask
  %floatcast = bitcast <2 x i64> %and to <2 x double>
  %max_is_x = fcmp oge <2 x double> %floatcast, %arg2
  %max = select <2 x i1> %max_is_x, <2 x double> %floatcast, <2 x double> %arg2
  ret <2 x double> %max
}

define <4 x double> @ExeDepsFix_broadcastsd256_inreg(<4 x double> %arg, <4 x double> %arg2, i64 %broadcastvalue) {
; CHECK-LABEL: ExeDepsFix_broadcastsd256_inreg:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovq %rdi, %xmm2
; CHECK-NEXT:    vpbroadcastq %xmm2, %ymm2
; CHECK-NEXT:    vpand %ymm2, %ymm0, %ymm0
; CHECK-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %bitcast = bitcast <4 x double> %arg to <4 x i64>
  %in = insertelement <4 x i64> undef, i64 %broadcastvalue, i32 0
  %mask = shufflevector <4 x i64> %in, <4 x i64> undef, <4 x i32> zeroinitializer
  %and = and <4 x i64> %bitcast, %mask
  %floatcast = bitcast <4 x i64> %and to <4 x double>
  %max_is_x = fcmp oge <4 x double> %floatcast, %arg2
  %max = select <4 x i1> %max_is_x, <4 x double> %floatcast, <4 x double> %arg2
  ret <4 x double> %max
}
