; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; FIXME-TRUE16. enable gisel
; XUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s
; XUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-FAKE16 %s

define i8 @test_vector_reduce_smax_v2i8(<2 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v2i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v2i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_smax_v2i8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_smax_v2i8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v2i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v2i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v2i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v2i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v2i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v2i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v2i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v2i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_smax_v3i8(<3 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v3i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    s_movk_i32 s4, 0xff80
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v1, v0, s4
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v3i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v3i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v1), v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, 0xff80, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v3i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v3i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    s_movk_i32 s0, 0xff80
; GFX9-SDAG-NEXT:    v_max3_i16 v0, v1, v0, s0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v3i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v0, v0, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v3i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_max3_i16 v0, v1, v0, 0xff80
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v3i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v3i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v3, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.l, v0.l, 0xff80
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v3i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v1, v0, 0xff80
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v3i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v3i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v3, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.l, v0.l, 0xff80
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v3i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v1, v0, 0xff80
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v3i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.smax.v3i8(<3 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_smax_v4i8(<4 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v4i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v4i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, s4, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, s4, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, s4, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, s4, v3
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, s4, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v4i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v3) dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v4i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v3) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v2, sext(v2), v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v3, sext(v3), v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, s4, v1
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, s4, v2
; GFX8-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v3, s4, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v4i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v3) dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX9-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX9-SDAG-NEXT:    v_max3_i16 v0, v0, v2, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v4i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v3) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v2, sext(v2), s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v3, sext(v3), s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_max_i16_e32 v1, s0, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-GISEL-NEXT:    v_max_i16_e32 v2, s0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v3, s0, v3
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_and_or_b32 v0, v0, v4, v1
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v3
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v4i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_max3_i16 v0, v0, v2, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v4i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v5, 8
; GFX10-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_max_i16 v4, v2, s4
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i16 v2, v1, s4
; GFX10-GISEL-NEXT:    v_max_i16 v4, v4, s4
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX10-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v4i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v1.l, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 8, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v1, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v0.l, v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v4i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v0, v2, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v4i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX11-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX11-GISEL-NEXT:    v_max_i16 v4, v2, s0
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_max_i16 v5, v1, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v2, v4, s0
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, 0xff, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 8, v4
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v4i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v1.l, v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 8, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v1, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v0.l, v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v4i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v0, v2, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v4i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX12-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_max_i16 v4, v2, s0
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_max_i16 v5, v1, s0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_max_i16 v2, v4, s0
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, 0xff, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 8, v4
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_smax_v8i8(<8 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v8i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v8i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v5, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v4
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v6, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v4
; GFX7-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v7, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v4
; GFX7-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, s4, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, s4, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, s4, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, s4, v3
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, s4, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v8i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v7) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v6) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v4) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v8i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v4) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v6) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v7) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, s4, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, s4, v1
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, s4, v2
; GFX8-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_e32 v3, s4, v3
; GFX8-GISEL-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v3, s4, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v8i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX9-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v7) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX9-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v6) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_max3_i16 v0, v0, v4, v2
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v8i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v4) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v6) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v7) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_max_i16_e32 v2, s0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v3, s0, v3
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_max_i16_e32 v1, s0, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-GISEL-NEXT:    v_max_i16_e32 v2, s0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v3, s0, v3
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_and_or_b32 v0, v0, v4, v1
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v3
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v8i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v3, v3, v7
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-SDAG-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX10-SDAG-NEXT:    v_bfe_i32 v3, v6, 0, 8
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-SDAG-NEXT:    v_max_i16 v2, v2, v3
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX10-SDAG-NEXT:    v_max3_i16 v0, v0, v4, v2
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v8i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v1, v1, v5
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, v7
; GFX10-GISEL-NEXT:    v_max_i16 v2, v2, v6
; GFX10-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v5, 8
; GFX10-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_max_i16 v4, v2, s4
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i16 v2, v1, s4
; GFX10-GISEL-NEXT:    v_max_i16 v4, v4, s4
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX10-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v8i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v8, v1, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v7, v5, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v8.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v1.l, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v1.l, v5.l, v3.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v6, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v5, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v4, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v4, 8, v6
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v4, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.l, v2.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v8i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v6, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v2, v2, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v0, v4, v2
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v8i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    v_max_i16 v1, v1, v5
; GFX11-GISEL-NEXT:    v_bfe_i32 v5, v6, 0, 8
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, v7
; GFX11-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX11-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-GISEL-NEXT:    v_max_i16 v2, v2, v5
; GFX11-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v4
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX11-GISEL-NEXT:    v_max_i16 v4, v2, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v5, v1, s0
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX11-GISEL-NEXT:    v_max_i16 v2, v4, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, 0xff, v5
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 8, v4
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX11-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v8i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v8, v1, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v7, v5, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v8.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v1.l, v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v1.l, v5.l, v3.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v6, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v5, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v4, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v4, 8, v6
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v4, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.l, v2.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v8i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v6, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v2, v2, v3
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v0, v4, v2
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v8i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    v_max_i16 v1, v1, v5
; GFX12-GISEL-NEXT:    v_bfe_i32 v5, v6, 0, 8
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, v7
; GFX12-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX12-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_max_i16 v2, v2, v5
; GFX12-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v4
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX12-GISEL-NEXT:    v_max_i16 v4, v2, s0
; GFX12-GISEL-NEXT:    v_max_i16 v5, v1, s0
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX12-GISEL-NEXT:    v_max_i16 v2, v4, s0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, 0xff, v5
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 8, v4
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX12-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_smax_v16i8(<16 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v16i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v14, v14, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v15, v15, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v13, v13, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v12, v12, 0, 8
; GFX7-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX7-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX7-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v16i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v9, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v10, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v11, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v12, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v4, v4, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v13, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v5, v5, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v14, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v6, v6, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v15, 0, 8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v7, v7, v8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, s4, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, s4, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, s4, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, s4, v3
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, s4, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v16i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v5, sext(v5), sext(v13) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v9) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v7, sext(v7), sext(v15) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v11) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v4, sext(v4), sext(v12) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v8) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v6, sext(v6), sext(v14) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v10) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    v_max_i16_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_max_i16_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_max_i16_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v16i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v8) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v9) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v10) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v11) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v4, sext(v4), sext(v12) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v5, sext(v5), sext(v13) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v6, sext(v6), sext(v14) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v7, sext(v7), sext(v15) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_max_i16_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, s4, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, s4, v1
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, s4, v2
; GFX8-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-GISEL-NEXT:    v_max_i16_e32 v3, s4, v3
; GFX8-GISEL-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v3, s4, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v16i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX9-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v7, sext(v7), sext(v15) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v5, sext(v5), sext(v13) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v9) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max3_i16 v3, v3, v11, v7
; GFX9-SDAG-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX9-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v6, sext(v6), sext(v14) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v4, sext(v4), sext(v12) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v8) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    v_max3_i16 v2, v2, v10, v6
; GFX9-SDAG-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_max3_i16 v0, v0, v4, v2
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v16i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v0, sext(v0), sext(v8) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v1, sext(v1), sext(v9) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v2, sext(v2), sext(v10) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v3, sext(v3), sext(v11) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v4, sext(v4), sext(v12) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v5, sext(v5), sext(v13) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v6, sext(v6), sext(v14) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v7, sext(v7), sext(v15) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_max_i16_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_max_i16_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_max_i16_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_max_i16_e32 v2, s0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v3, s0, v3
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_max_i16_e32 v1, s0, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-GISEL-NEXT:    v_max_i16_e32 v2, s0, v2
; GFX9-GISEL-NEXT:    v_max_i16_e32 v3, s0, v3
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-GISEL-NEXT:    v_and_or_b32 v0, v0, v4, v1
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v3
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v16i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_bfe_i32 v15, v15, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v13, v13, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v7, v7, v15
; GFX10-SDAG-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v5, v5, v13
; GFX10-SDAG-NEXT:    v_max_i16 v1, v1, v9
; GFX10-SDAG-NEXT:    v_max3_i16 v3, v3, v11, v7
; GFX10-SDAG-NEXT:    v_bfe_i32 v7, v14, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX10-SDAG-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX10-SDAG-NEXT:    v_bfe_i32 v3, v12, 0, 8
; GFX10-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v5, v6, v7
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-SDAG-NEXT:    v_max_i16 v3, v4, v3
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v8
; GFX10-SDAG-NEXT:    v_max3_i16 v2, v2, v10, v5
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX10-SDAG-NEXT:    v_max3_i16 v0, v0, v3, v2
; GFX10-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v16i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v8
; GFX10-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v1, v1, v9
; GFX10-GISEL-NEXT:    v_bfe_i32 v8, v10, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, v11
; GFX10-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v9, v13, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v10, v15, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v11, v14, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX10-GISEL-NEXT:    v_bfe_i32 v12, v12, 0, 8
; GFX10-GISEL-NEXT:    v_max_i16 v5, v5, v9
; GFX10-GISEL-NEXT:    v_max_i16 v7, v7, v10
; GFX10-GISEL-NEXT:    v_max_i16 v2, v2, v8
; GFX10-GISEL-NEXT:    v_max_i16 v6, v6, v11
; GFX10-GISEL-NEXT:    v_max_i16 v4, v4, v12
; GFX10-GISEL-NEXT:    v_max_i16 v1, v1, v5
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, v7
; GFX10-GISEL-NEXT:    s_sext_i32_i8 s4, s4
; GFX10-GISEL-NEXT:    v_max_i16 v2, v2, v6
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v5, 8
; GFX10-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, s4
; GFX10-GISEL-NEXT:    v_max_i16 v4, v2, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i16 v2, v1, s4
; GFX10-GISEL-NEXT:    v_max_i16 v3, v3, s4
; GFX10-GISEL-NEXT:    v_max_i16 v4, v4, s4
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshlrev_b32_sdwa v1, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX10-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v16i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v16, v2, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v15.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v9.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v15, v2, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v3, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v7, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v7, v14, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v14, v6, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v13.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v13, v0, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v4, v5, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v5, v6, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v6, v1, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v13.l
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v15.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v11.l
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.h, v2.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v1.h, v4.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v12.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.l, v6.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v6, v8, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v14.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v5, v17, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.h, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v4, v11, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v9.l
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.h, v2.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v16.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v7.l, 8, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v10.l
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v1.l, v1.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v6, 8, v7
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v5.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.h, v2.l, v3.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v6, 0, 8
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v0.l, v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v16i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v15, v15, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v13, v13, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v7, v7, v15
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v5, v5, v13
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v1, v1, v9
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v3, v3, v11, v7
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v7, v14, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v12, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v5, v6, v7
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v3, v4, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v8
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v2, v2, v10, v5
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v0, v3, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v16i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX11-GISEL-NEXT:    v_max_i16 v1, v1, v9
; GFX11-GISEL-NEXT:    v_bfe_i32 v9, v10, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v10, v11, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v11, v13, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v13, v15, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX11-GISEL-NEXT:    v_max_i16 v2, v2, v9
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, v10
; GFX11-GISEL-NEXT:    v_max_i16 v5, v5, v11
; GFX11-GISEL-NEXT:    v_max_i16 v7, v7, v13
; GFX11-GISEL-NEXT:    v_bfe_i32 v9, v14, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX11-GISEL-NEXT:    v_bfe_i32 v10, v12, 0, 8
; GFX11-GISEL-NEXT:    v_max_i16 v1, v1, v5
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, v7
; GFX11-GISEL-NEXT:    v_max_i16 v5, v6, v9
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v8
; GFX11-GISEL-NEXT:    v_max_i16 v4, v4, v10
; GFX11-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX11-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX11-GISEL-NEXT:    v_max_i16 v2, v2, v5
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v4, v1, s0
; GFX11-GISEL-NEXT:    v_max_i16 v5, v2, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-GISEL-NEXT:    v_max_i16 v4, v5, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 8, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v16i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v16, v2, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v15.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v9.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v15, v2, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v3, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v3, v7, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v7, v14, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v14, v6, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v13.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v13, v0, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v4, v5, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v5, v6, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v6, v1, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v6.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v13.l
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v15.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v11.l
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.h, v2.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v1.h, v4.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v12.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.l, v6.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v6, v8, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v14.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v5, v17, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v1.h, v0.h, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v4, v11, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v9.l
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.h, v2.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v16.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v7.l, 8, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v6.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v10.l
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v1.l, v1.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v6, 8, v7
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v5.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.h, v2.l, v3.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_bfe_i32 v2, v6, 0, 8
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_max3_i16 v0.l, v0.l, v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v16i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v15, v15, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v11, v11, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v13, v13, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v7, v7, v15
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v5, v5, v13
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v1, v1, v9
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v3, v3, v11, v7
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v7, v14, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v1, v1, v5, v3
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v3, v12, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v5, v6, v7
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v3, v4, v3
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v8
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v2, v2, v10, v5
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_max3_i16 v0, v0, v3, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v16i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX12-GISEL-NEXT:    v_max_i16 v1, v1, v9
; GFX12-GISEL-NEXT:    v_bfe_i32 v9, v10, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v10, v11, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v11, v13, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v13, v15, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX12-GISEL-NEXT:    v_max_i16 v2, v2, v9
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, v10
; GFX12-GISEL-NEXT:    v_max_i16 v5, v5, v11
; GFX12-GISEL-NEXT:    v_max_i16 v7, v7, v13
; GFX12-GISEL-NEXT:    v_bfe_i32 v9, v14, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX12-GISEL-NEXT:    v_bfe_i32 v10, v12, 0, 8
; GFX12-GISEL-NEXT:    v_max_i16 v1, v1, v5
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, v7
; GFX12-GISEL-NEXT:    v_max_i16 v5, v6, v9
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v8
; GFX12-GISEL-NEXT:    v_max_i16 v4, v4, v10
; GFX12-GISEL-NEXT:    s_sext_i32_i8 s0, s0
; GFX12-GISEL-NEXT:    v_max_i16 v1, v1, v3
; GFX12-GISEL-NEXT:    v_max_i16 v2, v2, v5
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v4
; GFX12-GISEL-NEXT:    v_max_i16 v4, v1, s0
; GFX12-GISEL-NEXT:    v_max_i16 v5, v2, s0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_max_i16 v3, v3, s0
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX12-GISEL-NEXT:    v_max_i16 v4, v5, s0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 8, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> %v)
  ret i8 %res
}

define i16 @test_vector_reduce_smax_v2i16(<2 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v2i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v2i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, 0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v2i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v2i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v1, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v2i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v2i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v2i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v2i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v2i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v2i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v2i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v2i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v2i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v2i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_smax_v3i16(<3 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v3i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-SDAG-NEXT:    v_or_b32_e32 v2, 0x80000000, v2
; GFX7-SDAG-NEXT:    v_ashrrev_i32_e32 v3, 16, v2
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v3
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v3i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v2, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_smax_v3i16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v3i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s0, 0x8000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, 0x5040100
; GFX9-SDAG-NEXT:    v_perm_b32 v1, s0, v1, v2
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v3i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v3i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_movk_i32 s4, 0x8000
; GFX10-SDAG-NEXT:    v_perm_b32 v1, s4, v1, 0x5040100
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v3i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v3i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0x8000
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v3i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_movk_i32 s0, 0x8000
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v1, s0, v1, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v3i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v3i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0x8000
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v3i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_movk_i32 s0, 0x8000
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-FAKE16-NEXT:    v_perm_b32 v1, s0, v1, 0x5040100
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v3i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.smax.v3i16(<3 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_smax_v4i16(<4 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v4i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v4i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v3, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, 0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v4i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v4i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v2, v0
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v4i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v4i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v4i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v4i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v4i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v4i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v4i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v4i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v4i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v4i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_smax_v8i16(<8 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v8i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v7, v7, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v6, v6, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v8i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v5, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v4
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v6, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v4
; GFX7-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v7, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, 0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v8i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v4, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v5, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_max_i16_e32 v2, v5, v4
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v8i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i16_e32 v4, v0, v2
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, v1, v3
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, v4, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v2, v0
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v8i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v8i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v8i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v8i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v8i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v8i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v8i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v8i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v8i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v8i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_smax_v16i16(<16 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v16i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_bfe_i32 v14, v14, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v6, v6, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v15, v15, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v7, v7, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v11, v11, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v10, v10, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v9, v9, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v13, v13, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v5, v5, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v8, v8, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v12, v12, 0, 16
; GFX7-SDAG-NEXT:    v_bfe_i32 v4, v4, 0, 16
; GFX7-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX7-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX7-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v16i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v8, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v9, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v10, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v11, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v4, v4, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v12, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v4, v4, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v5, v5, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v13, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v5, v5, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v6, v6, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v14, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v6, v6, v8
; GFX7-GISEL-NEXT:    v_bfe_i32 v7, v7, 0, 16
; GFX7-GISEL-NEXT:    v_bfe_i32 v8, v15, 0, 16
; GFX7-GISEL-NEXT:    v_max_i32_e32 v7, v7, v8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, 0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v16i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v8, v2, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v9, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v10, v3, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_sdwa v11, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_max_i16_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_max_i16_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_max_i16_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_max_i16_e32 v4, v11, v10
; GFX8-SDAG-NEXT:    v_max_i16_e32 v5, v9, v8
; GFX8-SDAG-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_max_i16_e32 v2, v5, v4
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v16i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i16_e32 v8, v0, v4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v4, v1, v5
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v5, v2, v6
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v2, v2, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v6, v3, v7
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v3, v3, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v5, v8, v5
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, v4, v6
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_max_i16_e32 v2, v5, v2
; GFX8-GISEL-NEXT:    v_max_i16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_max_i16_e32 v1, v2, v0
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-GISEL-NEXT:    v_max_i16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v16i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX9-SDAG-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX9-SDAG-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_max_i16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v16i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX9-GISEL-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX9-GISEL-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX9-GISEL-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v16i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX10-SDAG-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX10-SDAG-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX10-SDAG-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_max_i16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v16i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX10-GISEL-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX10-GISEL-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v16i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v16i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v16i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX11-GISEL-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX11-GISEL-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX11-GISEL-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_smax_v16i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_max_i16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_smax_v16i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_max_i16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v16i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX12-GISEL-NEXT:    v_pk_max_i16 v1, v1, v5
; GFX12-GISEL-NEXT:    v_pk_max_i16 v2, v2, v6
; GFX12-GISEL-NEXT:    v_pk_max_i16 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_max_i16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> %v)
  ret i16 %res
}


define i32 @test_vector_reduce_smax_v2i32(<2 x i32> %v) {
; GFX7-LABEL: test_vector_reduce_smax_v2i32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_smax_v2i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_smax_v2i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_smax_v2i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_smax_v2i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_smax_v2i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_smax_v3i32(<3 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v3i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v2
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v3i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v3i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v3i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v3i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v3i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v3i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v3i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v3i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v3i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v3i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_max3_i32 v0, v0, v1, v2
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v3i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.smax.v3i32(<3 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_smax_v4i32(<4 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v4i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v4i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v4i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v4i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v4i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v4i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v4i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v4i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v4i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v4i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v4i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_max3_i32 v0, v0, v2, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v4i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_smax_v8i32(<8 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v8i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v8i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v8i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX8-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX8-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v8i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v8i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX9-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX9-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v8i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v8i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX10-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX10-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v8i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v8i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX11-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v8i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v8i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX12-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v8i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_smax_v16i32(<16 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v16i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX7-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX7-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX7-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX7-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v16i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v10
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v11
; GFX7-GISEL-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX7-GISEL-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX7-GISEL-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX7-GISEL-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v16i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX8-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX8-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX8-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX8-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX8-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX8-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX8-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX8-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX8-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v16i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_max_i32_e32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_max_i32_e32 v3, v3, v11
; GFX8-GISEL-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX8-GISEL-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX8-GISEL-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX8-GISEL-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v16i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX9-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX9-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX9-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX9-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX9-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX9-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v16i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_max_i32_e32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_max_i32_e32 v3, v3, v11
; GFX9-GISEL-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v16i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX10-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX10-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX10-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX10-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX10-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX10-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX10-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX10-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX10-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX10-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v16i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX10-GISEL-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX10-GISEL-NEXT:    v_max_i32_e32 v2, v2, v10
; GFX10-GISEL-NEXT:    v_max_i32_e32 v3, v3, v11
; GFX10-GISEL-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX10-GISEL-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX10-GISEL-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX10-GISEL-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v16i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX11-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX11-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX11-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX11-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX11-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX11-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX11-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX11-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v16i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX11-GISEL-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX11-GISEL-NEXT:    v_max_i32_e32 v2, v2, v10
; GFX11-GISEL-NEXT:    v_max_i32_e32 v3, v3, v11
; GFX11-GISEL-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX11-GISEL-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX11-GISEL-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX11-GISEL-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v16i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX12-SDAG-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX12-SDAG-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX12-SDAG-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX12-SDAG-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX12-SDAG-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX12-SDAG-NEXT:    v_max3_i32 v3, v3, v11, v7
; GFX12-SDAG-NEXT:    v_max3_i32 v2, v2, v10, v6
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_max3_i32 v1, v1, v5, v3
; GFX12-SDAG-NEXT:    v_max3_i32 v0, v0, v4, v2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v16i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v8
; GFX12-GISEL-NEXT:    v_max_i32_e32 v1, v1, v9
; GFX12-GISEL-NEXT:    v_max_i32_e32 v2, v2, v10
; GFX12-GISEL-NEXT:    v_max_i32_e32 v3, v3, v11
; GFX12-GISEL-NEXT:    v_max_i32_e32 v4, v4, v12
; GFX12-GISEL-NEXT:    v_max_i32_e32 v5, v5, v13
; GFX12-GISEL-NEXT:    v_max_i32_e32 v6, v6, v14
; GFX12-GISEL-NEXT:    v_max_i32_e32 v7, v7, v15
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_max_i32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_max_i32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_max_i32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_max_i32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> %v)
  ret i32 %res
}

define i64 @test_vector_reduce_smax_v2i64(<2 x i64> %v) {
; GFX7-LABEL: test_vector_reduce_smax_v2i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_smax_v2i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_smax_v2i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_smax_v2i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_smax_v2i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_smax_v2i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_smax_v3i64(<3 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v3i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v3i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v3i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v3i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v3i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v3i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v3i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v3i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v3i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v1, v3, v1 :: v_dual_cndmask_b32 v0, v2, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v3i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v3i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v1, v3, v1 :: v_dual_cndmask_b32 v0, v2, v0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v3i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.smax.v3i64(<3 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_smax_v4i64(<4 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v4i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v4i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v4i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v4i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v4i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v4i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v4i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[0:1], v[4:5]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s4
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v4i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[6:7]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s4
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v4i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[0:1], v[4:5]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v3, v7, v3 :: v_dual_cndmask_b32 v2, v6, v2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s0
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v4i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[6:7]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s0
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v4i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v3, v7, v3 :: v_dual_cndmask_b32 v2, v6, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s0
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v4i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[6:7]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_smax_v8i64(<8 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v8i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[14:15]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[10:11]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v8i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[10:11]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[14:15]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v8i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[14:15]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[10:11]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v8i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[10:11]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[14:15]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v8i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[14:15]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[10:11]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v8i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[10:11]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[14:15]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[6:7]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v8i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[12:13]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[6:7], v[14:15]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s5, v[2:3], v[10:11]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v7, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v6, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s5
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s5
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[0:1], v[4:5]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s4
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v8i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[10:11]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s5, v[4:5], v[12:13]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[14:15]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[6:7]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s4
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v8i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[12:13]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[6:7], v[14:15]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s1, v[2:3], v[10:11]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v5, v13, v5 :: v_dual_cndmask_b32 v4, v12, v4
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v7, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v6, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s1
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s1
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v1, v9, v1 :: v_dual_cndmask_b32 v0, v8, v0
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[0:1], v[4:5]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v3, v7, v3 :: v_dual_cndmask_b32 v2, v6, v2
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v8i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[10:11]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[4:5], v[12:13]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v8, v0 :: v_dual_cndmask_b32 v1, v9, v1
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[14:15]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s1
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s1
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v6, v14, v6 :: v_dual_cndmask_b32 v7, v15, v7
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[6:7]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v8i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[12:13]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[6:7], v[14:15]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s1, v[2:3], v[10:11]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v5, v13, v5 :: v_dual_cndmask_b32 v4, v12, v4
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v7, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v6, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s1
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s1
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v1, v9, v1 :: v_dual_cndmask_b32 v0, v8, v0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v3, v7, v3 :: v_dual_cndmask_b32 v2, v6, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s0
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v8i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[10:11]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[4:5], v[12:13]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v8, v0 :: v_dual_cndmask_b32 v1, v9, v1
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[14:15]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s1
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s1
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v6, v14, v6 :: v_dual_cndmask_b32 v7, v15, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[6:7]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_smax_v16i64(<16 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_smax_v16i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[10:11], v[26:27]
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[12:13], v[28:29]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v11, v27, v11, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v10, v26, v10, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[18:19]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[22:23]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v7, v23, v7, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v6, v22, v6, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[8:9], v[24:25]
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e64 s[6:7], v[2:3], v[10:11]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v9, v25, v9, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v8, v24, v8, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[16:17]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s[6:7]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[20:21]
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[0:1], v[8:9]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v5, v21, v5, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v4, v20, v4, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, v1, s[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e64 v0, v8, v0, s[4:5]
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s[6:7]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[14:15], v[30:31]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v5, v31, v15, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v4, v30, v14, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[4:5]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX7-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_smax_v16i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[16:17]
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[10:11], v[26:27]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[18:19]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e64 v10, v26, v10, s[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[20:21]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e64 v11, v27, v11, s[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v4, v20, v4, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v5, v21, v5, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[22:23]
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[2:3], v[10:11]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v6, v22, v6, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v7, v23, v7, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[8:9], v[24:25]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v8, v24, v8, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v9, v25, v9, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[12:13], v[28:29]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v12, v28, v12, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v13, v29, v13, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e64 s[6:7], v[4:5], v[12:13]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s[6:7]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s[6:7]
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[14:15], v[30:31]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v4, v30, v14, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v5, v31, v15, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[4:5]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX7-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_smax_v16i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[10:11], v[26:27]
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[12:13], v[28:29]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v11, v27, v11, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v10, v26, v10, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[18:19]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[22:23]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v7, v23, v7, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v6, v22, v6, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[8:9], v[24:25]
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e64 s[6:7], v[2:3], v[10:11]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v9, v25, v9, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v8, v24, v8, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[16:17]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s[6:7]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[20:21]
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[0:1], v[8:9]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v5, v21, v5, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v4, v20, v4, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, v1, s[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e64 v0, v8, v0, s[4:5]
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s[6:7]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[14:15], v[30:31]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v5, v31, v15, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v4, v30, v14, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[4:5]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_smax_v16i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[16:17]
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[10:11], v[26:27]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[18:19]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e64 v10, v26, v10, s[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[20:21]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e64 v11, v27, v11, s[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v4, v20, v4, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v5, v21, v5, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[22:23]
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[2:3], v[10:11]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v6, v22, v6, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v7, v23, v7, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[8:9], v[24:25]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v8, v24, v8, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v9, v25, v9, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[12:13], v[28:29]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v12, v28, v12, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v13, v29, v13, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e64 s[6:7], v[4:5], v[12:13]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s[6:7]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s[6:7]
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[14:15], v[30:31]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v4, v30, v14, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v5, v31, v15, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[4:5]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_smax_v16i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    scratch_load_dword v31, off, s32
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[8:9], v[24:25]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[6:7], v[0:1], v[16:17]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[8:9], v[12:13], v[28:29]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[10:11], v[4:5], v[20:21]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[10:11], v[26:27]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[0:1], v[2:3], v[18:19]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s[4:5]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v1, v17, v1, s[6:7]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s[8:9]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s[10:11]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s[4:5]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, v16, v0, s[6:7]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s[8:9]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s[10:11]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v11, v27, v11, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s[0:1]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v10, v26, v10, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s[0:1]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[4:5], v[12:13]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[0:1], v[0:1], v[8:9]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[2:3], v[6:7], v[22:23]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, v1, s[0:1]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, v8, v0, s[0:1]
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v7, v23, v7, s[2:3]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v6, v22, v6, s[2:3]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e64 s[2:3], v[2:3], v[10:11]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[14:15], v[30:31]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v5, v31, v15, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v4, v30, v14, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[4:5]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s[2:3]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s[2:3]
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[4:5]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_nop 1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_smax_v16i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    scratch_load_dword v31, off, s32
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[16:17]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[2:3], v[4:5], v[20:21]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[6:7], v[8:9], v[24:25]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[10:11], v[12:13], v[28:29]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s[2:3]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s[6:7]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s[10:11]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s[2:3]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s[6:7]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s[10:11]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[8:9]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[2:3], v[4:5], v[12:13]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[0:1], v[2:3], v[18:19]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s[2:3]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s[2:3]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[4:5]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[4:5], v[6:7], v[22:23]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[8:9], v[10:11], v[26:27]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s[0:1]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v6, v22, v6, s[4:5]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v10, v26, v10, s[8:9]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s[0:1]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v7, v23, v7, s[4:5]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v11, v27, v11, s[8:9]
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e64 s[0:1], v[2:3], v[10:11]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[14:15], v[30:31]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v4, v30, v14, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v5, v31, v15, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[6:7], v[4:5]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s[0:1]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s[0:1]
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[2:3], v[4:5]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc, v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_smax_v16i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[10:11], v[26:27]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[18:19]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s5, v[6:7], v[22:23]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s6, v[8:9], v[24:25]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s7, v[0:1], v[16:17]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s8, v[12:13], v[28:29]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v11, v27, v11, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v10, v26, v10, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[20:21]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v7, v23, v7, s5
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s6
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v1, v17, v1, s7
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s8
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v5, v21, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v6, v22, v6, s5
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s8
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v4, v20, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s6
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, v16, v0, s7
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[12:13]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s6, v[0:1], v[8:9]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v5, v13, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v4, v12, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, v1, s6
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, v8, v0, s6
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[14:15], v[30:31]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v15, v31, v15, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v14, v30, v14, s4
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[10:11]
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s5, v[6:7], v[14:15]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s4
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[0:1], v[4:5]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v7, s5
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v6, s5
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s4
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s4
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_smax_v16i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[16:17]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[18:19]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s5, v[4:5], v[20:21]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[22:23]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s4
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[8:9], v[24:25]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v6, v22, v6, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v7, v23, v7, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[10:11], v[26:27]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s4
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s5, v[12:13], v[28:29]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v10, v26, v10, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v11, v27, v11, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s5, v[4:5], v[12:13]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s5
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s5
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[14:15], v[30:31]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v14, v30, v14, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v15, v31, v15, s4
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[10:11]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[14:15]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v6, v14, v6, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v7, v15, v7, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e64 s4, v[2:3], v[6:7]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s4
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s4
; GFX10-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_smax_v16i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[10:11], v[26:27]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[18:19]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s1, v[6:7], v[22:23]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s2, v[8:9], v[24:25]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s3, v[0:1], v[16:17]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[12:13], v[28:29]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v11, v27, v11 :: v_dual_cndmask_b32 v10, v26, v10
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s5, v[4:5], v[20:21]
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v7, v23, v7, s1
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s2
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v1, v17, v1, s3
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s4
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s5
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v6, v22, v6, s1
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s4
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s5
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s2
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, v16, v0, s3
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[10:11]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s2, v[0:1], v[8:9]
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, v1, s2
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, v8, v0, s2
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[14:15], v[30:31]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v15, v31, v15 :: v_dual_cndmask_b32 v14, v30, v14
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[12:13]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s1, v[6:7], v[14:15]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v5, v13, v5 :: v_dual_cndmask_b32 v4, v12, v4
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v7, s1
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v6, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[0:1], v[4:5]
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s0
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v3, v7, v3 :: v_dual_cndmask_b32 v2, v6, v2
; GFX11-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_smax_v16i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[16:17]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[18:19]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[4:5], v[20:21]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v16, v0 :: v_dual_cndmask_b32 v1, v17, v1
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[22:23]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s0
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[8:9], v[24:25]
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s1
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s1
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v6, v22, v6 :: v_dual_cndmask_b32 v7, v23, v7
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[10:11], v[26:27]
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s0
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[12:13], v[28:29]
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s0
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v10, v26, v10 :: v_dual_cndmask_b32 v11, v27, v11
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s1
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s1
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v8, v0 :: v_dual_cndmask_b32 v1, v9, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[4:5], v[12:13]
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s1
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s1
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[14:15], v[30:31]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v14, v30, v14, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v15, v31, v15, s0
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[10:11]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[14:15]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s0
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v6, v14, v6 :: v_dual_cndmask_b32 v7, v15, v7
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[6:7]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s0
; GFX11-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_smax_v16i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[10:11], v[26:27]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[18:19]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s1, v[6:7], v[22:23]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s2, v[8:9], v[24:25]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s3, v[0:1], v[16:17]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s4, v[12:13], v[28:29]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v11, v27, v11 :: v_dual_cndmask_b32 v10, v26, v10
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s5, v[4:5], v[20:21]
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v7, v23, v7, s1
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s2
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v1, v17, v1, s3
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s4
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s5
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v6, v22, v6, s1
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s4
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s5
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s2
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v0, v16, v0, s3
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[10:11]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s2, v[0:1], v[8:9]
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, v1, s2
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v0, v8, v0, s2
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x0
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[14:15], v[30:31]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v15, v31, v15 :: v_dual_cndmask_b32 v14, v30, v14
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[4:5], v[12:13]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s1, v[6:7], v[14:15]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v5, v13, v5 :: v_dual_cndmask_b32 v4, v12, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v7, s1
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v6, s1
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e64 s0, v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[2:3], v[6:7]
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s0
; GFX12-SDAG-NEXT:    v_cndmask_b32_e64 v0, v4, v0, s0
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v3, v7, v3 :: v_dual_cndmask_b32 v2, v6, v2
; GFX12-SDAG-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_smax_v16i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[16:17]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[18:19]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[4:5], v[20:21]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v16, v0 :: v_dual_cndmask_b32 v1, v17, v1
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[22:23]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v2, v18, v2, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[8:9], v[24:25]
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v4, v20, v4, s1
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v5, v21, v5, s1
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v6, v22, v6 :: v_dual_cndmask_b32 v7, v23, v7
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[10:11], v[26:27]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v8, v24, v8, s0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[12:13], v[28:29]
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v9, v25, v9, s0
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v10, v26, v10 :: v_dual_cndmask_b32 v11, v27, v11
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[8:9]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v12, v28, v12, s1
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v13, v29, v13, s1
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v8, v0 :: v_dual_cndmask_b32 v1, v9, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s1, v[4:5], v[12:13]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v4, v12, v4, s1
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v5, v13, v5, s1
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[14:15], v[30:31]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v14, v30, v14, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v15, v31, v15, s0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[10:11]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[6:7], v[14:15]
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v2, v10, v2, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v3, v11, v3, s0
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v6, v14, v6 :: v_dual_cndmask_b32 v7, v15, v7
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[4:5]
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e64 s0, v[2:3], v[6:7]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v4, v0 :: v_dual_cndmask_b32 v1, v5, v1
; GFX12-GISEL-NEXT:    s_wait_alu 0xf1ff
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s0
; GFX12-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s0
; GFX12-GISEL-NEXT:    v_cmp_gt_i64_e32 vcc_lo, v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_cndmask_b32 v1, v3, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> %v)
  ret i64 %res
}

declare i8 @llvm.vector.reduce.smax.v2i8(<2 x i8>)
declare i8 @llvm.vector.reduce.smax.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.smax.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.smax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smax.v16i8(<16 x i8>)

declare i16 @llvm.vector.reduce.smax.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.smax.v3i16(<3 x i16>)
declare i16 @llvm.vector.reduce.smax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smax.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.smax.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.smax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smax.v3i32(<3 x i32>)
declare i32 @llvm.vector.reduce.smax.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.smax.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.smax.v16i32(<16 x i32>)

declare i64 @llvm.vector.reduce.smax.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.smax.v3i64(<3 x i64>)
declare i64 @llvm.vector.reduce.smax.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.smax.v8i64(<8 x i64>)
declare i64 @llvm.vector.reduce.smax.v16i64(<16 x i64>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-GISEL-FAKE16: {{.*}}
; GFX12-GISEL-FAKE16: {{.*}}
