; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs
; RUN: opt < %s -passes='cgscc(coro-split),simplifycfg,early-cse,coro-cleanup' -S | FileCheck %s
target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.12.0"

define {ptr, ptr} @f(ptr %buffer, ptr %ptr) presplitcoroutine {
entry:
  %temp = alloca i32, align 4
  %id = call token @llvm.coro.id.retcon.once(i32 8, i32 8, ptr %buffer, ptr @prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  %oldvalue = load i32, ptr %ptr
  store i32 %oldvalue, ptr %temp
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(ptr %temp)
  br i1 %unwind, label %cleanup, label %cont

cont:
  %newvalue = load i32, ptr %temp
  store i32 %newvalue, ptr %ptr
  br label %cleanup

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}


define {ptr, ptr} @g(ptr %buffer, ptr %ptr, i8 %val) presplitcoroutine {
entry:
  %temp = alloca i32, align 4
  %id = call token @llvm.coro.id.retcon.once(i32 8, i32 8, ptr %buffer, ptr @prototype2, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  %oldvalue = load i32, ptr %ptr
  store i32 %oldvalue, ptr %temp
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(ptr %temp)
  br i1 %unwind, label %cleanup, label %cont

cont:
  %newvalue = load i32, ptr %temp
  store i32 %newvalue, ptr %ptr
  br label %cleanup

cleanup:
  %tok = call token (...) @llvm.coro.end.results(i8 %val)
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token %tok)
  unreachable
}


define {ptr, ptr} @h(ptr %buffer, ptr %ptr) presplitcoroutine {
entry:
  %temp = alloca i32, align 4
  %id = call token @llvm.coro.id.retcon.once(i32 8, i32 8, ptr %buffer, ptr @prototype3, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  %oldvalue = load i32, ptr %ptr
  store i32 %oldvalue, ptr %temp
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(ptr %temp)
  br i1 %unwind, label %cleanup, label %cont

cont:
  %newvalue = load i32, ptr %temp
  store i32 %newvalue, ptr %ptr
  br label %cleanup

cleanup:
  %tok = call token (...) @llvm.coro.end.results(ptr null, i32 123, ptr @deallocate)
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token %tok)
  unreachable
}


declare token @llvm.coro.id.retcon.once(i32, i32, ptr, ptr, ptr, ptr)
declare ptr @llvm.coro.begin(token, ptr)
declare i1 @llvm.coro.suspend.retcon.i1(...)
declare i1 @llvm.coro.end(ptr, i1, token)
declare token @llvm.coro.end.results(...)

declare void @prototype(ptr, i1 zeroext)
declare i8 @prototype2(ptr, i1 zeroext)
declare {ptr, i32, ptr} @prototype3(ptr, i1 zeroext)

declare noalias ptr @allocate(i32 %size)
declare fastcc void @deallocate(ptr %ptr)

declare void @print(i32)
; CHECK-LABEL: @f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @allocate(i32 16)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    [[TEMP:%.*]] = getelementptr inbounds [[F_FRAME:%.*]], ptr [[TMP0]], i32 0, i32 1
; CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[OLDVALUE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    store i32 [[OLDVALUE]], ptr [[TEMP]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, ptr } { ptr @f.resume.0, ptr poison }, ptr [[TEMP]], 1
; CHECK-NEXT:    ret { ptr, ptr } [[TMP1]]
;
;
; CHECK-LABEL: @f.resume.0(
; CHECK-NEXT:  entryresume.0:
; CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    [[TEMP:%.*]] = getelementptr inbounds [[F_FRAME:%.*]], ptr [[TMP2]], i32 0, i32 1
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[COROEND:%.*]], label [[CONT:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    [[PTR_RELOAD:%.*]] = load ptr, ptr [[TMP2]], align 8
; CHECK-NEXT:    [[NEWVALUE:%.*]] = load i32, ptr [[TEMP]], align 4
; CHECK-NEXT:    store i32 [[NEWVALUE]], ptr [[PTR_RELOAD]], align 4
; CHECK-NEXT:    br label [[COROEND]]
; CHECK:       CoroEnd:
; CHECK-NEXT:    call fastcc void @deallocate(ptr [[TMP2]])
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @g(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @allocate(i32 16)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    [[TEMP:%.*]] = getelementptr inbounds [[G_FRAME:%.*]], ptr [[TMP0]], i32 0, i32 1
; CHECK-NEXT:    [[VAL_SPILL_ADDR:%.*]] = getelementptr inbounds [[G_FRAME]], ptr [[TMP0]], i32 0, i32 2
; CHECK-NEXT:    store i8 [[VAL:%.*]], ptr [[VAL_SPILL_ADDR]], align 1
; CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[OLDVALUE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    store i32 [[OLDVALUE]], ptr [[TEMP]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, ptr } { ptr @g.resume.0, ptr poison }, ptr [[TEMP]], 1
; CHECK-NEXT:    ret { ptr, ptr } [[TMP1]]
;
;
; CHECK-LABEL: @g.resume.0(
; CHECK-NEXT:  entryresume.0:
; CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    [[TEMP:%.*]] = getelementptr inbounds [[G_FRAME:%.*]], ptr [[TMP2]], i32 0, i32 1
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[CLEANUP:%.*]], label [[CONT:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    [[PTR_RELOAD:%.*]] = load ptr, ptr [[TMP2]], align 8
; CHECK-NEXT:    [[NEWVALUE:%.*]] = load i32, ptr [[TEMP]], align 4
; CHECK-NEXT:    store i32 [[NEWVALUE]], ptr [[PTR_RELOAD]], align 4
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[VAL_RELOAD_ADDR:%.*]] = getelementptr inbounds [[G_FRAME]], ptr [[TMP2]], i32 0, i32 2
; CHECK-NEXT:    [[VAL_RELOAD:%.*]] = load i8, ptr [[VAL_RELOAD_ADDR]], align 1
; CHECK-NEXT:    call fastcc void @deallocate(ptr [[TMP2]])
; CHECK-NEXT:    ret i8 [[VAL_RELOAD]]
;
;
; CHECK-LABEL: @h(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @allocate(i32 16)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    [[TEMP:%.*]] = getelementptr inbounds [[H_FRAME:%.*]], ptr [[TMP0]], i32 0, i32 1
; CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[OLDVALUE:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    store i32 [[OLDVALUE]], ptr [[TEMP]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, ptr } { ptr @h.resume.0, ptr poison }, ptr [[TEMP]], 1
; CHECK-NEXT:    ret { ptr, ptr } [[TMP1]]
;
;
; CHECK-LABEL: @h.resume.0(
; CHECK-NEXT:  entryresume.0:
; CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    [[TEMP:%.*]] = getelementptr inbounds [[H_FRAME:%.*]], ptr [[TMP2]], i32 0, i32 1
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[COROEND:%.*]], label [[CONT:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    [[PTR_RELOAD:%.*]] = load ptr, ptr [[TMP2]], align 8
; CHECK-NEXT:    [[NEWVALUE:%.*]] = load i32, ptr [[TEMP]], align 4
; CHECK-NEXT:    store i32 [[NEWVALUE]], ptr [[PTR_RELOAD]], align 4
; CHECK-NEXT:    br label [[COROEND]]
; CHECK:       CoroEnd:
; CHECK-NEXT:    call fastcc void @deallocate(ptr [[TMP2]])
; CHECK-NEXT:    ret { ptr, i32, ptr } { ptr null, i32 123, ptr @deallocate }
;
