; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck %s

define float @freeze_fneg(float %input) nounwind {
; CHECK-LABEL: freeze_fneg:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fneg reassoc nsz arcp contract afn float %input
  %y = freeze float %x
  %z = fneg reassoc nsz arcp contract afn float %y
  ret float %z
}

define float @freeze_fadd(float %input) nounwind {
; CHECK-LABEL: freeze_fadd:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_add_f32_e32 v0, 2.0, v0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fadd reassoc nsz arcp contract afn float %input, 1.000000e+00
  %y = freeze float %x
  %z = fadd reassoc nsz arcp contract afn float %y, 1.000000e+00
  ret float %z
}

define <4 x float> @freeze_fadd_vec(<4 x float> %input) nounwind {
; CHECK-LABEL: freeze_fadd_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_dual_add_f32 v0, 0x40a00000, v0 :: v_dual_add_f32 v1, 0x40a00000, v1
; CHECK-NEXT:    v_dual_add_f32 v2, 0x40a00000, v2 :: v_dual_add_f32 v3, 0x40a00000, v3
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fadd reassoc nsz arcp contract afn <4 x float> %input, <float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00>
  %y = freeze <4 x float> %x
  %z = fadd reassoc nsz arcp contract afn <4 x float> %y, <float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00>
  ret <4 x float> %z
}

define float @freeze_fsub(float %input) nounwind {
; CHECK-LABEL: freeze_fsub:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_subrev_f32_e32 v0, 1.0, v0
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; CHECK-NEXT:    v_subrev_f32_e32 v0, 1.0, v0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fsub reassoc nsz arcp contract afn float %input, 1.000000e+00
  %y = freeze float %x
  %z = fsub reassoc nsz arcp contract afn float %y, 1.000000e+00
  ret float %z
}

define <4 x float> @freeze_fsub_vec(<4 x float> %input) nounwind {
; CHECK-LABEL: freeze_fsub_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_dual_add_f32 v0, 0xc0a00000, v0 :: v_dual_add_f32 v1, 0xc0a00000, v1
; CHECK-NEXT:    v_dual_add_f32 v2, 0xc0a00000, v2 :: v_dual_add_f32 v3, 0xc0a00000, v3
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fsub reassoc nsz arcp contract afn <4 x float> %input, <float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00>
  %y = freeze <4 x float> %x
  %z = fsub reassoc nsz arcp contract afn <4 x float> %y, <float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00>
  ret <4 x float> %z
}

define float @freeze_fmul(float %input) nounwind {
; CHECK-LABEL: freeze_fmul:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fmul reassoc nsz arcp contract afn float %input, 2.000000e+00
  %y = freeze float %x
  %z = fmul reassoc nsz arcp contract afn float %y, 2.000000e+00
  ret float %z
}

define <8 x float> @freeze_fmul_vec(<8 x float> %input) nounwind {
; CHECK-LABEL: freeze_fmul_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_dual_mul_f32 v0, 4.0, v0 :: v_dual_mul_f32 v1, 0x40c00000, v1
; CHECK-NEXT:    v_dual_mul_f32 v2, 0x40c00000, v2 :: v_dual_mul_f32 v3, 4.0, v3
; CHECK-NEXT:    v_dual_mul_f32 v4, 4.0, v4 :: v_dual_mul_f32 v5, 0x40c00000, v5
; CHECK-NEXT:    v_dual_mul_f32 v6, 0x40c00000, v6 :: v_dual_mul_f32 v7, 4.0, v7
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fmul reassoc nsz arcp contract afn <8 x float> %input, <float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00, float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00>
  %y = freeze <8 x float> %x
  %z = fmul reassoc nsz arcp contract afn <8 x float> %y, <float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00, float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00>
  ret <8 x float> %z
}

define float @freeze_fdiv(float %input) nounwind {
; CHECK-LABEL: freeze_fdiv:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mul_f32_e32 v0, 0x3e800000, v0
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fdiv reassoc nsz arcp contract afn float %input, 2.000000e+00
  %y = freeze float %x
  %z = fdiv reassoc nsz arcp contract afn float %y, 2.000000e+00
  ret float %z
}

define <8 x float> @freeze_fdiv_vec(<8 x float> %input) nounwind {
; CHECK-LABEL: freeze_fdiv_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_dual_mul_f32 v3, 0x3e800000, v3 :: v_dual_mul_f32 v4, 0x3e800000, v4
; CHECK-NEXT:    v_dual_mul_f32 v0, 0x3e800000, v0 :: v_dual_mul_f32 v7, 0x3e800000, v7
; CHECK-NEXT:    v_dual_mul_f32 v1, 0x3e2aaaab, v1 :: v_dual_mul_f32 v2, 0x3e2aaaab, v2
; CHECK-NEXT:    v_dual_mul_f32 v5, 0x3e2aaaab, v5 :: v_dual_mul_f32 v6, 0x3e2aaaab, v6
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = fdiv reassoc nsz arcp contract afn <8 x float> %input, <float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00, float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00>
  %y = freeze <8 x float> %x
  %z = fdiv reassoc nsz arcp contract afn <8 x float> %y, <float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00, float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00>
  ret <8 x float> %z
}

define float @freeze_frem(float %input) nounwind {
; CHECK-LABEL: freeze_frem:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mul_f32_e32 v1, 0.5, v0
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_trunc_f32_e32 v1, v1
; CHECK-NEXT:    v_fmac_f32_e32 v0, -2.0, v1
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_mul_f32_e32 v1, 0.5, v0
; CHECK-NEXT:    v_trunc_f32_e32 v1, v1
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; CHECK-NEXT:    v_fmac_f32_e32 v0, -2.0, v1
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = frem reassoc nsz arcp contract afn float %input, 2.000000e+00
  %y = freeze float %x
  %z = frem reassoc nsz arcp contract afn float %y, 2.000000e+00
  ret float %z
}

define <8 x float> @freeze_frem_vec(<8 x float> %input) nounwind {
; CHECK-LABEL: freeze_frem_vec:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_dual_mul_f32 v8, 0x3e800000, v4 :: v_dual_mul_f32 v9, 0x3e800000, v3
; CHECK-NEXT:    v_trunc_f32_e32 v11, v0
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_trunc_f32_e32 v8, v8
; CHECK-NEXT:    v_trunc_f32_e32 v9, v9
; CHECK-NEXT:    v_mul_f32_e32 v10, 0.5, v6
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_dual_sub_f32 v0, v0, v11 :: v_dual_mul_f32 v11, 0x3eaaaaab, v5
; CHECK-NEXT:    v_dual_fmac_f32 v4, -4.0, v8 :: v_dual_fmac_f32 v3, -4.0, v9
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; CHECK-NEXT:    v_trunc_f32_e32 v10, v10
; CHECK-NEXT:    v_trunc_f32_e32 v9, v7
; CHECK-NEXT:    v_dual_fmac_f32 v6, -2.0, v10 :: v_dual_sub_f32 v7, v7, v9
; CHECK-NEXT:    v_mul_f32_e32 v8, 0.5, v1
; CHECK-NEXT:    v_trunc_f32_e32 v9, v11
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_mul_f32_e32 v11, 0x3e800000, v7
; CHECK-NEXT:    v_trunc_f32_e32 v8, v8
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; CHECK-NEXT:    v_fmac_f32_e32 v1, -2.0, v8
; CHECK-NEXT:    v_fmac_f32_e32 v5, 0xc0400000, v9
; CHECK-NEXT:    v_mul_f32_e32 v10, 0x3eaaaaab, v2
; CHECK-NEXT:    v_mul_f32_e32 v12, 0x3e800000, v0
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; CHECK-NEXT:    v_trunc_f32_e32 v8, v10
; CHECK-NEXT:    v_trunc_f32_e32 v10, v12
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; CHECK-NEXT:    v_fmac_f32_e32 v2, 0xc0400000, v8
; CHECK-NEXT:    v_trunc_f32_e32 v8, v11
; CHECK-NEXT:    v_mul_f32_e32 v12, 0x3eaaaaab, v1
; CHECK-NEXT:    v_dual_fmac_f32 v0, -4.0, v10 :: v_dual_mul_f32 v11, 0.5, v5
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_fmac_f32_e32 v7, -4.0, v8
; CHECK-NEXT:    v_trunc_f32_e32 v9, v12
; CHECK-NEXT:    v_mul_f32_e32 v12, 0x3eaaaaab, v6
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; CHECK-NEXT:    v_fmac_f32_e32 v1, 0xc0400000, v9
; CHECK-NEXT:    v_trunc_f32_e32 v9, v11
; CHECK-NEXT:    v_trunc_f32_e32 v11, v3
; CHECK-NEXT:    v_dual_mul_f32 v10, 0.5, v2 :: v_dual_fmac_f32 v5, -2.0, v9
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; CHECK-NEXT:    v_sub_f32_e32 v3, v3, v11
; CHECK-NEXT:    v_trunc_f32_e32 v8, v10
; CHECK-NEXT:    v_trunc_f32_e32 v10, v12
; CHECK-NEXT:    v_trunc_f32_e32 v12, v4
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; CHECK-NEXT:    v_fmac_f32_e32 v2, -2.0, v8
; CHECK-NEXT:    v_fmac_f32_e32 v6, 0xc0400000, v10
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; CHECK-NEXT:    v_sub_f32_e32 v4, v4, v12
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %x = frem reassoc nsz arcp contract afn <8 x float> %input, <float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00, float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00>
  %y = freeze <8 x float> %x
  %z = frem reassoc nsz arcp contract afn <8 x float> %y, <float 4.000000e+00, float 3.000000e+00, float 2.000000e+00, float 1.000000e+00, float 1.000000e+00, float 2.000000e+00, float 3.000000e+00, float 4.000000e+00>
  ret <8 x float> %z
}
