; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-- -mcpu=verde -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,SI,SIVI,MUBUF %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx803 -mattr=-flat-for-global -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,VI,SIVI,MUBUF %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx900 -mattr=-flat-for-global -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,MUBUF,GFX9-MUBUF,GFX9_10-MUBUF %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx900 -filetype=obj -amdgpu-use-divergent-register-indexing < %s | llvm-readobj -r - | FileCheck --check-prefix=RELS %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1010 -mattr=-flat-for-global -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,MUBUF,GFX10_W32-MUBUF,GFX9_10-MUBUF %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1010 -mattr=-flat-for-global,+wavefrontsize64 -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,MUBUF,GFX10_W64-MUBUF,GFX9_10-MUBUF %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx900 -mattr=-flat-for-global,+enable-flat-scratch -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,FLATSCR,GFX9-FLATSCR %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1030 -mattr=-flat-for-global,+enable-flat-scratch -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,FLATSCR,GFX10-FLATSCR %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx900 -mattr=-flat-for-global,+enable-flat-scratch -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,FLATSCR,GFX9-FLATSCR-PAL %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1030 -mattr=-flat-for-global,+enable-flat-scratch -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,FLATSCR,GFX10-FLATSCR-PAL %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1100 -mattr=-flat-for-global,+enable-flat-scratch -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,GFX11-FLATSCR %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1100 -mattr=-flat-for-global,+enable-flat-scratch -amdgpu-use-divergent-register-indexing -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,GFX9PLUS,GFX11-FLATSCR %s

; RELS: R_AMDGPU_ABS32_LO SCRATCH_RSRC_DWORD0
; RELS: R_AMDGPU_ABS32_LO SCRATCH_RSRC_DWORD1

; This used to fail due to a v_add_i32 instruction with an illegal immediate
; operand that was created during Local Stack Slot Allocation. Test case derived
; from https://bugs.freedesktop.org/show_bug.cgi?id=96602

define amdgpu_ps float @ps_main(i32 %idx) {
; SI-LABEL: ps_main:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s7, 0xe8f000
; SI-NEXT:    s_add_u32 s4, s4, s0
; SI-NEXT:    s_addc_u32 s5, s5, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_main:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s7, 0xe80000
; VI-NEXT:    s_add_u32 s4, s4, s0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: ps_main:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX9-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s3, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX9-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: ps_main:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s3, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: ps_main:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s3, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: ps_main:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s2
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: ps_main:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s2
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: ps_main:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s0
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: ps_main:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s0
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s2, s2, s0
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: ps_main:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v23, v21 :: v_dual_mov_b32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v6, 0x3f5f2ee2 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e319356
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v11, 0xbe31934f :: v_dual_mov_b32 v4, v6
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v9, 0xb702e758 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, 0xb7043519 :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0x3efcd89c
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %r = fadd float %v1, %v2
  ret float %r
}

define amdgpu_vs float @vs_main(i32 %idx) {
; SI-LABEL: vs_main:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s7, 0xe8f000
; SI-NEXT:    s_add_u32 s4, s4, s0
; SI-NEXT:    s_addc_u32 s5, s5, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: vs_main:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s7, 0xe80000
; VI-NEXT:    s_add_u32 s4, s4, s0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: vs_main:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX9-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s3, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX9-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: vs_main:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s3, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: vs_main:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s3, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: vs_main:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s2
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: vs_main:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s2
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: vs_main:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s0
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: vs_main:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s0
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s2, s2, s0
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: vs_main:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v23, v21 :: v_dual_mov_b32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v6, 0x3f5f2ee2 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e319356
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v11, 0xbe31934f :: v_dual_mov_b32 v4, v6
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v9, 0xb702e758 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, 0xb7043519 :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0x3efcd89c
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %r = fadd float %v1, %v2
  ret float %r
}

define amdgpu_cs float @cs_main(i32 %idx) {
; SI-LABEL: cs_main:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s7, 0xe8f000
; SI-NEXT:    s_add_u32 s4, s4, s0
; SI-NEXT:    s_addc_u32 s5, s5, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: cs_main:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s7, 0xe80000
; VI-NEXT:    s_add_u32 s4, s4, s0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: cs_main:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX9-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s3, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX9-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: cs_main:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s3, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: cs_main:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s4, s0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s3, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s0, s0, s4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: cs_main:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s2
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: cs_main:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s2
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: cs_main:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x10
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s0
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: cs_main:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s0
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x10
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s2, s2, s0
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: cs_main:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v23, v21 :: v_dual_mov_b32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v6, 0x3f5f2ee2 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e319356
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v11, 0xbe31934f :: v_dual_mov_b32 v4, v6
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v9, 0xb702e758 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, 0xb7043519 :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0x3efcd89c
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %r = fadd float %v1, %v2
  ret float %r
}

define amdgpu_hs float @hs_main(i32 %idx) {
; SI-LABEL: hs_main:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s7, 0xe8f000
; SI-NEXT:    s_add_u32 s4, s4, s0
; SI-NEXT:    s_addc_u32 s5, s5, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: hs_main:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s7, 0xe80000
; VI-NEXT:    s_add_u32 s4, s4, s0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: hs_main:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s3, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s0, s0, s5
; GFX9-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: hs_main:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s3, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s0, s0, s5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: hs_main:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s3, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s0, s0, s5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: hs_main:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: hs_main:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: hs_main:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: hs_main:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: hs_main:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v23, v21 :: v_dual_mov_b32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v6, 0x3f5f2ee2 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e319356
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v11, 0xbe31934f :: v_dual_mov_b32 v4, v6
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v9, 0xb702e758 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, 0xb7043519 :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0x3efcd89c
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %r = fadd float %v1, %v2
  ret float %r
}

define amdgpu_gs float @gs_main(i32 %idx) {
; SI-LABEL: gs_main:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s7, 0xe8f000
; SI-NEXT:    s_add_u32 s4, s4, s0
; SI-NEXT:    s_addc_u32 s5, s5, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: gs_main:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s4, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s5, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s7, 0xe80000
; VI-NEXT:    s_add_u32 s4, s4, s0
; VI-NEXT:    s_addc_u32 s5, s5, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[4:7], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[4:7], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[4:7], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[4:7], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[4:7], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[4:7], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[4:7], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[4:7], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[4:7], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[4:7], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[4:7], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[4:7], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[4:7], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[4:7], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[4:7], 0 offen
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: gs_main:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s3, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s0, s0, s5
; GFX9-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[0:3], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: gs_main:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s3, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s0, s0, s5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: gs_main:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s0, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s1, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s3, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s0, s0, s5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s1, s1, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[0:3], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[0:3], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[0:3], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[0:3], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[0:3], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[0:3], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[0:3], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[0:3], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[0:3], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[0:3], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[0:3], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[0:3], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[0:3], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[0:3], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[0:3], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[0:3], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[0:3], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: gs_main:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: gs_main:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: gs_main:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: gs_main:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: gs_main:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v23, v21 :: v_dual_mov_b32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v6, 0x3f5f2ee2 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e319356
; GFX11-FLATSCR-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v11, 0xbe31934f :: v_dual_mov_b32 v4, v6
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v9, 0xb702e758 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, 0xb7043519 :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0x3efcd89c
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %r = fadd float %v1, %v2
  ret float %r
}

; Mesa GS and HS shaders have the preloaded scratch wave offset SGPR fixed at
; SGPR5, and the inreg implementation is used to reference it in the IR. The
; following tests confirm the shader and anything inserted after the return
; (i.e. SI_RETURN_TO_EPILOG) can access the scratch wave offset.
define amdgpu_hs <{i32, i32, i32, float}> @hs_ir_uses_scratch_offset(i32 inreg, i32 inreg, i32 inreg, i32 inreg, i32 inreg, i32 inreg %swo, i32 %idx) {
; SI-LABEL: hs_ir_uses_scratch_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s11, 0xe8f000
; SI-NEXT:    s_add_u32 s8, s8, s6
; SI-NEXT:    s_addc_u32 s9, s9, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen
; SI-NEXT:    s_mov_b32 s2, s5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: hs_ir_uses_scratch_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s11, 0xe80000
; VI-NEXT:    s_add_u32 s8, s8, s6
; VI-NEXT:    s_addc_u32 s9, s9, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen
; VI-NEXT:    s_mov_b32 s2, s5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: hs_ir_uses_scratch_offset:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s10, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s8, s8, s5
; GFX9-MUBUF-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, s5
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: hs_ir_uses_scratch_offset:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s10, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s8, s8, s5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s9, s9, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[8:11], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, s5
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: hs_ir_uses_scratch_offset:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s10, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s11, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s8, s8, s5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s9, s9, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[8:11], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, s5
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: hs_ir_uses_scratch_offset:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_mov_b32 s2, s7
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: hs_ir_uses_scratch_offset:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_mov_b32 s2, s7
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: hs_ir_uses_scratch_offset:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s5
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: hs_ir_uses_scratch_offset:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s5
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: hs_ir_uses_scratch_offset:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v0, 0xbeae29dc :: v_dual_mov_b32 v23, v21
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, v8 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v15, 0x3e319356 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe31934f
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v20, 0x3efcd89c :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_mov_b32 s2, s5
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %f = fadd float %v1, %v2
  %r1 = insertvalue <{i32, i32, i32, float}> poison, i32 %swo, 2
  %r2 = insertvalue <{i32, i32, i32, float}> %r1, float %f, 3
  ret <{i32, i32, i32, float}> %r2
}

define amdgpu_gs <{i32, i32, i32, float}> @gs_ir_uses_scratch_offset(i32 inreg, i32 inreg, i32 inreg, i32 inreg, i32 inreg, i32 inreg %swo, i32 %idx) {
; SI-LABEL: gs_ir_uses_scratch_offset:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s11, 0xe8f000
; SI-NEXT:    s_add_u32 s8, s8, s6
; SI-NEXT:    s_addc_u32 s9, s9, 0
; SI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; SI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; SI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; SI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:320
; SI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:316
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:312
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:308
; SI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:304
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:300
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:296
; SI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:292
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:288
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:284
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; SI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; SI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:280
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:276
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:272
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:264
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:260
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:256
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:252
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:236
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; SI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; SI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; SI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; SI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; SI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; SI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:268
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:248
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:240
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:232
; SI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:228
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:224
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; SI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; SI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; SI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:200
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x200, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:196
; SI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; SI-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; SI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:832
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:828
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:824
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:820
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; SI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; SI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:816
; SI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:812
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:808
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:804
; SI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:800
; SI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:796
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:792
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:788
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; SI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:784
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:780
; SI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; SI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:772
; SI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:764
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; SI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:760
; SI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:756
; SI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:752
; SI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:748
; SI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:744
; SI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:740
; SI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:736
; SI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:732
; SI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:728
; SI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:724
; SI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:720
; SI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:716
; SI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:712
; SI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:708
; SI-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen
; SI-NEXT:    s_mov_b32 s2, s5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v0, v0, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: gs_ir_uses_scratch_offset:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s11, 0xe80000
; VI-NEXT:    s_add_u32 s8, s8, s6
; VI-NEXT:    s_addc_u32 s9, s9, 0
; VI-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; VI-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; VI-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; VI-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; VI-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:320
; VI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:316
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:312
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:308
; VI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:304
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:300
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:296
; VI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:292
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:288
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:284
; VI-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; VI-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; VI-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:280
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:276
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:272
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:264
; VI-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:260
; VI-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:256
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:252
; VI-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; VI-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:236
; VI-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; VI-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; VI-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; VI-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; VI-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; VI-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; VI-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:268
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:248
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:240
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:232
; VI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:228
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:224
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; VI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; VI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; VI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:200
; VI-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x200, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:196
; VI-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; VI-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; VI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:832
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:828
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:824
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:820
; VI-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; VI-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; VI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:816
; VI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:812
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:808
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:804
; VI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:800
; VI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:796
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:792
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:788
; VI-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; VI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:784
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:780
; VI-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; VI-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:772
; VI-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:764
; VI-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; VI-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:760
; VI-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:756
; VI-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:752
; VI-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:748
; VI-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:744
; VI-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:740
; VI-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:736
; VI-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:732
; VI-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:728
; VI-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:724
; VI-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:720
; VI-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:716
; VI-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:712
; VI-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:708
; VI-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen
; VI-NEXT:    s_mov_b32 s2, s5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX9-MUBUF-LABEL: gs_ir_uses_scratch_offset:
; GFX9-MUBUF:       ; %bb.0:
; GFX9-MUBUF-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-MUBUF-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-MUBUF-NEXT:    s_mov_b32 s10, -1
; GFX9-MUBUF-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-MUBUF-NEXT:    s_add_u32 s8, s8, s5
; GFX9-MUBUF-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbf20e7f4
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f523be1
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v6, 0x3f638e37
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:320
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:316
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:312
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:308
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:304
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:300
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:296
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:292
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:288
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd8a3
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:284
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbeae29dc
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbe31934f
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:280
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:276
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:272
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:264
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:260
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:256
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e31934f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89c
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbe319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:252
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v9, 0x3e319356
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29dc
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:236
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3efcd89f
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf20e7f5
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v13, 0xbf3d349e
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX9-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:268
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:248
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:240
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:232
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:228
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:224
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:200
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f5
; GFX9-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:196
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f4
; GFX9-MUBUF-NEXT:    v_add_u32_e32 v1, 0x200, v0
; GFX9-MUBUF-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; GFX9-MUBUF-NEXT:    s_nop 0
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:832
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:828
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:824
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:820
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3703c499
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3f3d349c
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:816
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:812
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:808
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:804
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:800
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:796
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:792
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:788
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:784
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:780
; GFX9-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; GFX9-MUBUF-NEXT:    buffer_store_dword v6, off, s[8:11], 0 offset:772
; GFX9-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:764
; GFX9-MUBUF-NEXT:    v_mov_b32_e32 v5, 0xbf5f2ee2
; GFX9-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:760
; GFX9-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:756
; GFX9-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:752
; GFX9-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:748
; GFX9-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:744
; GFX9-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:740
; GFX9-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:736
; GFX9-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:732
; GFX9-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:728
; GFX9-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:724
; GFX9-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:720
; GFX9-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:716
; GFX9-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:712
; GFX9-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:708
; GFX9-MUBUF-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen
; GFX9-MUBUF-NEXT:    s_mov_b32 s2, s5
; GFX9-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX9-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W32-MUBUF-LABEL: gs_ir_uses_scratch_offset:
; GFX10_W32-MUBUF:       ; %bb.0:
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s10, -1
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W32-MUBUF-NEXT:    s_add_u32 s8, s8, s5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W32-MUBUF-NEXT:    s_addc_u32 s9, s9, 0
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:320
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:316
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:312
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:308
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:304
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:300
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:296
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:292
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:288
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:284
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:280
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:276
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:272
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:268
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:264
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:260
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:256
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:252
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W32-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:248
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:240
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:236
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:232
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W32-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:228
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:224
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:200
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:196
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W32-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:832
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:828
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:824
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:820
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:816
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:812
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:808
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:804
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:800
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:796
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:792
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:788
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:784
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:780
; GFX10_W32-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:772
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:764
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:760
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:756
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:752
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:748
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:744
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:740
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:736
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:732
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:728
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:724
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:720
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:716
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:712
; GFX10_W32-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:708
; GFX10_W32-MUBUF-NEXT:    buffer_load_dword v1, v6, s[8:11], 0 offen
; GFX10_W32-MUBUF-NEXT:    s_mov_b32 s2, s5
; GFX10_W32-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W32-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX10_W64-MUBUF-LABEL: gs_ir_uses_scratch_offset:
; GFX10_W64-MUBUF:       ; %bb.0:
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s10, -1
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v2, 0x3f3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v4, 0x3f5f2ee2
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s11, 0x31e16000
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v3, 0x3f523be1
; GFX10_W64-MUBUF-NEXT:    s_add_u32 s8, s8, s5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbefcd8a3
; GFX10_W64-MUBUF-NEXT:    s_addc_u32 s9, s9, 0
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v8, 0xbefcd89f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:320
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:316
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:312
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:308
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:304
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:300
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:296
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:292
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:288
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:284
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:280
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:276
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:272
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v1, 0xbe319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0xbe31934f
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0xb702e758
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3e31934f
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:268
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:264
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:260
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:256
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:252
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v7, 0x3e319356
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0x3eae29d8
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v11, 0x3eae29dc
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0x3efcd89c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v13, 0x3efcd89f
; GFX10_W64-MUBUF-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:248
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:244
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:240
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:236
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:232
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v10, 0xbf20e7f5
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v15, 0xbf5f2ee3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v12, 0xbf3d349e
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf523be3
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v16, 0xbf638e39
; GFX10_W64-MUBUF-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:228
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:224
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:220
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:216
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:212
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v17, 0x3f20e7f5
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:208
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:204
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f20e7f4
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:200
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:196
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v18, 0x3703c499
; GFX10_W64-MUBUF-NEXT:    v_add_nc_u32_e32 v6, 0x200, v0
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:832
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:828
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:824
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:820
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:816
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:812
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0x3f3d349c
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v19, 0xbf523be1
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:808
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:804
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:800
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:796
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:792
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:788
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:784
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:780
; GFX10_W64-MUBUF-NEXT:    v_mov_b32_e32 v14, 0xbf5f2ee2
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v15, off, s[8:11], 0 offset:776
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v5, off, s[8:11], 0 offset:772
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v16, off, s[8:11], 0 offset:768
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v4, off, s[8:11], 0 offset:764
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v14, off, s[8:11], 0 offset:760
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v3, off, s[8:11], 0 offset:756
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v19, off, s[8:11], 0 offset:752
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v2, off, s[8:11], 0 offset:748
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v12, off, s[8:11], 0 offset:744
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v17, off, s[8:11], 0 offset:740
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v13, off, s[8:11], 0 offset:736
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v11, off, s[8:11], 0 offset:732
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v7, off, s[8:11], 0 offset:728
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v18, off, s[8:11], 0 offset:724
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v1, off, s[8:11], 0 offset:720
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v9, off, s[8:11], 0 offset:716
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v8, off, s[8:11], 0 offset:712
; GFX10_W64-MUBUF-NEXT:    buffer_store_dword v10, off, s[8:11], 0 offset:708
; GFX10_W64-MUBUF-NEXT:    buffer_load_dword v1, v6, s[8:11], 0 offen
; GFX10_W64-MUBUF-NEXT:    s_mov_b32 s2, s5
; GFX10_W64-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-MUBUF-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10_W64-MUBUF-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-LABEL: gs_ir_uses_scratch_offset:
; GFX9-FLATSCR:       ; %bb.0:
; GFX9-FLATSCR-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-NEXT:    s_mov_b32 s2, s7
; GFX9-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-LABEL: gs_ir_uses_scratch_offset:
; GFX10-FLATSCR:       ; %bb.0:
; GFX10-FLATSCR-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-NEXT:    s_mov_b32 s2, s7
; GFX10-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-NEXT:    ; return to shader part epilog
;
; GFX9-FLATSCR-PAL-LABEL: gs_ir_uses_scratch_offset:
; GFX9-FLATSCR-PAL:       ; %bb.0:
; GFX9-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX9-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-FLATSCR-PAL-NEXT:    v_and_b32_e32 v23, 0x1fc, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbf20e7f4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX9-FLATSCR-PAL-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-FLATSCR-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:320
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], s0 offset:240
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0xbf3d349e
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0x3efcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89c
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0xb702e758
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xbeae29dc
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xb7043519
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, 0xbe31934f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbe319356
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:224
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf523be3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf5f2ee3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f638e37
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbefcd89f
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:256
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0xbf638e39
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f20e7f5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v21
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:304
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:208
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:192
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v18
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v4
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v13, v1, off
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[19:22], s0 offset:768
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0xbf523be1
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0x3f3d349c
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, v15
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], s0 offset:832
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:784
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, v5
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v17
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0x3703c499
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[18:21], s0 offset:752
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[7:10], s0 offset:736
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[3:6], s0 offset:816
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, v16
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v0
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[8:11], s0 offset:800
; GFX9-FLATSCR-PAL-NEXT:    v_add_u32_e32 v1, 0x200, v23
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], s0 offset:720
; GFX9-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[15:18], s0 offset:704
; GFX9-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v1, off
; GFX9-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s5
; GFX9-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v13, v0
; GFX9-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX10-FLATSCR-PAL-LABEL: gs_ir_uses_scratch_offset:
; GFX10-FLATSCR-PAL:       ; %bb.0:
; GFX10-FLATSCR-PAL-NEXT:    s_getpc_b64 s[0:1]
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s0, s8
; GFX10-FLATSCR-PAL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX10-FLATSCR-PAL-NEXT:    s_add_u32 s0, s0, s5
; GFX10-FLATSCR-PAL-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-FLATSCR-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xbf20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v9, 0xbeae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:320
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-FLATSCR-PAL-NEXT:    v_and_b32_e32 v0, 0x1fc, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v11, 0xbefcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0xbefcd8a3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v16, 0xbf3d349e
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v20, 0xbf5f2ee3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, 0xbf523be3
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[5:8], off offset:304
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[1:4], off offset:288
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[9:12], off offset:272
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v12, 0x3eae29dc
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v14, 0x3e319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, 0x3efcd89f
; GFX10-FLATSCR-PAL-NEXT:    v_add_nc_u32_e32 v39, 0x200, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v0
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, 0xb702e758
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, 0xb7043519
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, 0xbe31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, 0xbe319356
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v17, 0xbf20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v13, 0x3eae29d8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v15, 0x3e31934f
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, 0x3efcd89c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v21, 0xbf638e39
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v22, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v24, 0x3f20e7f5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v25, v16
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v23
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v4, 0x3f20e7f4
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v27, 0x3703c499
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v28, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v29, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v30, v18
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[12:15], off offset:240
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:224
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[20:23], off offset:208
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:192
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v17
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v31, 0xbf523be1
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, 0x3f3d349c
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v32, v7
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, v16
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v10, v35, off
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v35, v21
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v36, v5
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v37, v20
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v38, v6
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[4:7], off offset:832
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[27:30], off offset:816
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:800
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:784
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v33, 0xbf5f2ee2
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v34, v6
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v23, v18
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v26, v8
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v1, v27
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v2, v14
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v18, v11
; GFX10-FLATSCR-PAL-NEXT:    v_mov_b32_e32 v19, v9
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[35:38], off offset:768
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[31:34], off offset:752
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[23:26], off offset:736
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:720
; GFX10-FLATSCR-PAL-NEXT:    scratch_store_dwordx4 off, v[16:19], off offset:704
; GFX10-FLATSCR-PAL-NEXT:    scratch_load_dword v0, v39, off
; GFX10-FLATSCR-PAL-NEXT:    s_mov_b32 s2, s5
; GFX10-FLATSCR-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLATSCR-PAL-NEXT:    v_add_f32_e32 v0, v10, v0
; GFX10-FLATSCR-PAL-NEXT:    ; return to shader part epilog
;
; GFX11-FLATSCR-LABEL: gs_ir_uses_scratch_offset:
; GFX11-FLATSCR:       ; %bb.0:
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v1, 0xbf20e7f4 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v28, 0x3703c499
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, 0x3efcd89f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v21, 0xbf5f2ee3
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v8, 0x3f3d349e
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v7, 0x3f523be1
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v17, 0xbf3d349e
; GFX11-FLATSCR-NEXT:    v_and_b32_e32 v37, 0x1fc, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v0, 0xbeae29dc :: v_dual_mov_b32 v23, v21
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v6, 0x3f5f2ee2
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v5, 0x3f638e37
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:320
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, v8 :: v_dual_mov_b32 v3, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v6
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v24, 0xbf523be3
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[5:8], off offset:304
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:288
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v2, 0xbefcd89f :: v_dual_mov_b32 v27, v24
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v13, 0x3eae29dc :: v_dual_mov_b32 v34, v5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, 0xbefcd8a3
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v15, 0x3e319356 :: v_dual_mov_b32 v36, v6
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, 0xb702e758
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v10, 0xb7043519
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v11, 0xbe31934f
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v12, 0xbe319356 :: v_dual_mov_b32 v31, v19
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v18, 0xbf20e7f5
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v14, 0x3eae29d8
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v16, 0x3e31934f
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v22, 0xbf638e39
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v25, 0x3f20e7f5 :: v_dual_mov_b32 v26, v17
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v20, 0x3efcd89c :: v_dual_mov_b32 v29, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v30, v13
; GFX11-FLATSCR-NEXT:    s_clause 0x1
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:256
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x3f20e7f4
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v9, v18
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v33, v22
; GFX11-FLATSCR-NEXT:    s_clause 0x3
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[13:16], off offset:240
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:224
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[21:24], off offset:208
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:192
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v14, v37, off
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v32, 0x3f3d349c :: v_dual_mov_b32 v5, v15
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v20, v0
; GFX11-FLATSCR-NEXT:    s_clause 0x2
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[1:4], off offset:832
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[28:31], off offset:816
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[9:12], off offset:800
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v29, 0xbf523be1 :: v_dual_mov_b32 v30, v7
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v31, v17
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v4, v28
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v24, v19 :: v_dual_mov_b32 v35, v21
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:784
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v31, 0xbf5f2ee2 :: v_dual_mov_b32 v32, v6
; GFX11-FLATSCR-NEXT:    v_dual_mov_b32 v27, v8 :: v_dual_mov_b32 v6, v13
; GFX11-FLATSCR-NEXT:    v_mov_b32_e32 v19, v2
; GFX11-FLATSCR-NEXT:    s_clause 0x4
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[33:36], off offset:768
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[29:32], off offset:752
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[24:27], off offset:736
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[3:6], off offset:720
; GFX11-FLATSCR-NEXT:    scratch_store_b128 off, v[17:20], off offset:704
; GFX11-FLATSCR-NEXT:    scratch_load_b32 v0, v37, off offset:512
; GFX11-FLATSCR-NEXT:    s_mov_b32 s2, s5
; GFX11-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLATSCR-NEXT:    v_add_f32_e32 v0, v14, v0
; GFX11-FLATSCR-NEXT:    ; return to shader part epilog
  %v1 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0xBFEA477C60000000, float 0xBFEBE5DC60000000, float 0xBFEC71C720000000, float 0xBFEBE5DC60000000, float 0xBFEA477C60000000, float 0xBFE7A693C0000000, float 0xBFE41CFEA0000000, float 0x3FDF9B13E0000000, float 0x3FDF9B1380000000, float 0x3FD5C53B80000000, float 0x3FD5C53B00000000, float 0x3FC6326AC0000000, float 0x3FC63269E0000000, float 0xBEE05CEB00000000, float 0xBEE086A320000000, float 0xBFC63269E0000000, float 0xBFC6326AC0000000, float 0xBFD5C53B80000000, float 0xBFD5C53B80000000, float 0xBFDF9B13E0000000, float 0xBFDF9B1460000000, float 0xBFE41CFE80000000, float 0x3FE7A693C0000000, float 0x3FEA477C20000000, float 0x3FEBE5DC40000000, float 0x3FEC71C6E0000000, float 0x3FEBE5DC40000000, float 0x3FEA477C20000000, float 0x3FE7A693C0000000, float 0xBFE41CFE80000000>, i32 %idx
  %v2 = extractelement <81 x float> <float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFEA0000000, float 0xBFE7A693C0000000, float 0x3FE7A693C0000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFEBE5DC40000000, float 0x3FEBE5DC40000000, float 0xBFEC71C720000000, float 0x3FEC71C6E0000000, float 0xBFEBE5DC60000000, float 0x3FEBE5DC40000000, float 0xBFEA477C20000000, float 0x3FEA477C20000000, float 0xBFE7A693C0000000, float 0x3FE7A69380000000, float 0xBFE41CFEA0000000, float 0xBFDF9B13E0000000, float 0xBFD5C53B80000000, float 0xBFC6326AC0000000, float 0x3EE0789320000000, float 0x3FC6326AC0000000, float 0x3FD5C53B80000000, float 0x3FDF9B13E0000000, float 0x3FE41CFE80000000>, i32 %idx
  %f = fadd float %v1, %v2
  %r1 = insertvalue <{i32, i32, i32, float}> poison, i32 %swo, 2
  %r2 = insertvalue <{i32, i32, i32, float}> %r1, float %f, 3
  ret <{i32, i32, i32, float}> %r2
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; FLATSCR: {{.*}}
; GCN: {{.*}}
; GFX9PLUS: {{.*}}
; GFX9_10-MUBUF: {{.*}}
; MUBUF: {{.*}}
; SIVI: {{.*}}
