; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64-none-linux-gnu -enable-subreg-liveness -force-streaming -mattr=+sve2,+sme2 | FileCheck %s

;
; TBL2
;

define { <vscale x 16 x i8>, <vscale x 16 x i8> } @tbl2_b_tuple(i64 %stride, ptr %ptr, <vscale x 16 x i8> %a) {
; CHECK-LABEL: tbl2_b_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    ld1b { z3.b, z11.b }, pn8/z, [x1]
; CHECK-NEXT:    ld1b { z4.b, z12.b }, pn8/z, [x1, x0]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.b, { z3.b, z4.b }, z0.b
; CHECK-NEXT:    tbl z1.b, { z11.b, z12.b }, z0.b
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x2.nxv16i8(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %1, 0
  %3 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.aarch64.sve.ld1.pn.x2.nxv16i8(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %4, 0
  %6 = extractvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %4, 1
  %res1 = call <vscale x 16 x i8> @llvm.aarch64.sve.tbl2.nxv16i8(<vscale x 16 x i8> %2, <vscale x 16 x i8> %5, <vscale x 16 x i8> %a)
  %res2 = call <vscale x 16 x i8> @llvm.aarch64.sve.tbl2.nxv16i8(<vscale x 16 x i8> %3, <vscale x 16 x i8> %6, <vscale x 16 x i8> %a)
  %ins1 = insertvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } poison, <vscale x 16 x i8> %res1, 0
  %ins2 = insertvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %ins1, <vscale x 16 x i8> %res2, 1
  ret { <vscale x 16 x i8>, <vscale x 16 x i8> } %ins2
}

define { <vscale x 8 x i16>, <vscale x 8 x i16> } @tbl2_h_tuple(i64 %stride, ptr %ptr, <vscale x 8 x i16> %a) {
; CHECK-LABEL: tbl2_h_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1h { z3.h, z11.h }, pn8/z, [x1]
; CHECK-NEXT:    ld1h { z4.h, z12.h }, pn8/z, [x8]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.h, { z3.h, z4.h }, z0.h
; CHECK-NEXT:    tbl z1.h, { z11.h, z12.h }, z0.h
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x2.nxv8i16(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %1, 0
  %3 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld1.pn.x2.nxv8i16(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %4, 0
  %6 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %4, 1
  %res1 = call <vscale x 8 x i16> @llvm.aarch64.sve.tbl2.nxv8i16(<vscale x 8 x i16> %2, <vscale x 8 x i16> %5, <vscale x 8 x i16> %a)
  %res2 = call <vscale x 8 x i16> @llvm.aarch64.sve.tbl2.nxv8i16(<vscale x 8 x i16> %3, <vscale x 8 x i16> %6, <vscale x 8 x i16> %a)
  %ins1 = insertvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } poison, <vscale x 8 x i16> %res1, 0
  %ins2 = insertvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %ins1, <vscale x 8 x i16> %res2, 1
  ret { <vscale x 8 x i16>, <vscale x 8 x i16> } %ins2
}

define { <vscale x 4 x i32>, <vscale x 4 x i32> } @tbl2_s_tuple(i64 %stride, ptr %ptr, <vscale x 4 x i32> %a) {
; CHECK-LABEL: tbl2_s_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1w { z3.s, z11.s }, pn8/z, [x1]
; CHECK-NEXT:    ld1w { z4.s, z12.s }, pn8/z, [x8]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.s, { z3.s, z4.s }, z0.s
; CHECK-NEXT:    tbl z1.s, { z11.s, z12.s }, z0.s
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %1, 0
  %3 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %4, 0
  %6 = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %4, 1
  %res1 = call <vscale x 4 x i32> @llvm.aarch64.sve.tbl2.nxv4i32(<vscale x 4 x i32> %2, <vscale x 4 x i32> %5, <vscale x 4 x i32> %a)
  %res2 = call <vscale x 4 x i32> @llvm.aarch64.sve.tbl2.nxv4i32(<vscale x 4 x i32> %3, <vscale x 4 x i32> %6, <vscale x 4 x i32> %a)
  %ins1 = insertvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } poison, <vscale x 4 x i32> %res1, 0
  %ins2 = insertvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %ins1, <vscale x 4 x i32> %res2, 1
  ret { <vscale x 4 x i32>, <vscale x 4 x i32> } %ins2
}

define { <vscale x 2 x i64>, <vscale x 2 x i64> } @tbl2_d_tuple(i64 %stride, ptr %ptr, <vscale x 2 x i64> %a) {
; CHECK-LABEL: tbl2_d_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1d { z3.d, z11.d }, pn8/z, [x1]
; CHECK-NEXT:    ld1d { z4.d, z12.d }, pn8/z, [x8]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.d, { z3.d, z4.d }, z0.d
; CHECK-NEXT:    tbl z1.d, { z11.d, z12.d }, z0.d
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x2.nxv2i64(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %1, 0
  %3 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 2 x i64>, <vscale x 2 x i64> } @llvm.aarch64.sve.ld1.pn.x2.nxv2i64(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %4, 0
  %6 = extractvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %4, 1
  %res1 = call <vscale x 2 x i64> @llvm.aarch64.sve.tbl2.nxv2i64(<vscale x 2 x i64> %2, <vscale x 2 x i64> %5, <vscale x 2 x i64> %a)
  %res2 = call <vscale x 2 x i64> @llvm.aarch64.sve.tbl2.nxv2i64(<vscale x 2 x i64> %3, <vscale x 2 x i64> %6, <vscale x 2 x i64> %a)
  %ins1 = insertvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } poison, <vscale x 2 x i64> %res1, 0
  %ins2 = insertvalue { <vscale x 2 x i64>, <vscale x 2 x i64> } %ins1, <vscale x 2 x i64> %res2, 1
  ret { <vscale x 2 x i64>, <vscale x 2 x i64> } %ins2
}

define { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } @tbl2_bf16_tuple(i64 %stride, ptr %ptr, <vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: tbl2_bf16_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1h { z3.h, z11.h }, pn8/z, [x1]
; CHECK-NEXT:    ld1h { z4.h, z12.h }, pn8/z, [x8]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.h, { z3.h, z4.h }, z0.h
; CHECK-NEXT:    tbl z1.h, { z11.h, z12.h }, z0.h
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } @llvm.aarch64.sve.ld1.pn.x2.nxv8bf16(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } %1, 0
  %3 = extractvalue { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } @llvm.aarch64.sve.ld1.pn.x2.nxv8bf16(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } %4, 0
  %6 = extractvalue { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } %4, 1
  %res1 = call <vscale x 8 x bfloat> @llvm.aarch64.sve.tbl2.nxv8bf16(<vscale x 8 x bfloat> %2, <vscale x 8 x bfloat> %5, <vscale x 8 x i16> %a)
  %res2 = call <vscale x 8 x bfloat> @llvm.aarch64.sve.tbl2.nxv8bf16(<vscale x 8 x bfloat> %3, <vscale x 8 x bfloat> %6, <vscale x 8 x i16> %a)
  %ins1 = insertvalue { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } poison, <vscale x 8 x bfloat> %res1, 0
  %ins2 = insertvalue { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } %ins1, <vscale x 8 x bfloat> %res2, 1
  ret { <vscale x 8 x bfloat>, <vscale x 8 x bfloat> } %ins2
}

define { <vscale x 4 x float>, <vscale x 4 x float> } @tbl2_f32_tuple(i64 %stride, ptr %ptr, <vscale x 4 x i32> %a) {
; CHECK-LABEL: tbl2_f32_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1w { z3.s, z11.s }, pn8/z, [x1]
; CHECK-NEXT:    ld1w { z4.s, z12.s }, pn8/z, [x8]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.s, { z3.s, z4.s }, z0.s
; CHECK-NEXT:    tbl z1.s, { z11.s, z12.s }, z0.s
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.ld1.pn.x2.nxv4f32(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %1, 0
  %3 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.ld1.pn.x2.nxv4f32(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %4, 0
  %6 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %4, 1
  %res1 = call <vscale x 4 x float> @llvm.aarch64.sve.tbl2.nxv4f32(<vscale x 4 x float> %2, <vscale x 4 x float> %5, <vscale x 4 x i32> %a)
  %res2 = call <vscale x 4 x float> @llvm.aarch64.sve.tbl2.nxv4f32(<vscale x 4 x float> %3, <vscale x 4 x float> %6, <vscale x 4 x i32> %a)
  %ins1 = insertvalue { <vscale x 4 x float>, <vscale x 4 x float> } poison, <vscale x 4 x float> %res1, 0
  %ins2 = insertvalue { <vscale x 4 x float>, <vscale x 4 x float> } %ins1, <vscale x 4 x float> %res2, 1
  ret { <vscale x 4 x float>, <vscale x 4 x float> } %ins2
}

define { <vscale x 2 x double>, <vscale x 2 x double> } @tbl2_f64_tuple(i64 %stride, ptr %ptr, <vscale x 2 x i64> %a) {
; CHECK-LABEL: tbl2_f64_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z12, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4c, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d12 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1d { z3.d, z11.d }, pn8/z, [x1]
; CHECK-NEXT:    ld1d { z4.d, z12.d }, pn8/z, [x8]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    tbl z2.d, { z3.d, z4.d }, z0.d
; CHECK-NEXT:    tbl z1.d, { z11.d, z12.d }, z0.d
; CHECK-NEXT:    ldr z12, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z11, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  %1 = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.ld1.pn.x2.nxv2f64(target("aarch64.svcount") %0, ptr %ptr)
  %2 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %1, 0
  %3 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %1, 1
  %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
  %4 = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.ld1.pn.x2.nxv2f64(target("aarch64.svcount") %0, ptr %arrayidx2)
  %5 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %4, 0
  %6 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %4, 1
  %res1 = call <vscale x 2 x double> @llvm.aarch64.sve.tbl2.nxv2f64(<vscale x 2 x double> %2, <vscale x 2 x double> %5, <vscale x 2 x i64> %a)
  %res2 = call <vscale x 2 x double> @llvm.aarch64.sve.tbl2.nxv2f64(<vscale x 2 x double> %3, <vscale x 2 x double> %6, <vscale x 2 x i64> %a)
  %ins1 = insertvalue { <vscale x 2 x double>, <vscale x 2 x double> } poison, <vscale x 2 x double> %res1, 0
  %ins2 = insertvalue { <vscale x 2 x double>, <vscale x 2 x double> } %ins1, <vscale x 2 x double> %res2, 1
  ret { <vscale x 2 x double>, <vscale x 2 x double> } %ins2
}

declare <vscale x 16 x i8> @llvm.aarch64.sve.tbl2.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>)
declare <vscale x 8 x i16> @llvm.aarch64.sve.tbl2.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>)
declare <vscale x 4 x i32> @llvm.aarch64.sve.tbl2.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>)
declare <vscale x 2 x i64> @llvm.aarch64.sve.tbl2.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>)

declare <vscale x 8 x half> @llvm.aarch64.sve.tbl2.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x i16>)
declare <vscale x 4 x float> @llvm.aarch64.sve.tbl2.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x i32>)
declare <vscale x 2 x double> @llvm.aarch64.sve.tbl2.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x i64>)

declare <vscale x 8 x bfloat> @llvm.aarch64.sve.tbl2.nxv8bf16(<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x i16>)

; +bf16 is required for the bfloat version.
attributes #0 = { "target-features"="+sve2,+bf16" }
