; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefixes=COMPATIBLE,REALTIME,MEMTIME %s
; RUN: FileCheck -allow-empty --check-prefixes=WARN-REALTIME,WARN-MEMTIME %s < %t
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs < %s

; RUN: llc -enable-new-pm -mtriple=amdgcn -mcpu=gfx1030 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefixes=COMPATIBLE,REALTIME,MEMTIME %s
; RUN: FileCheck -allow-empty --check-prefixes=WARN-REALTIME,WARN-MEMTIME %s < %t
; RUN: llc -enable-new-pm -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs < %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx1102 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefixes=INCOMPATIBLE,NOREALTIME,NOMEMTIME %s
; RUN: FileCheck --check-prefixes=WARN-NOREALTIME,WARN-NOMEMTIME %s < %t
; RUN: llc -mtriple=amdgcn -mcpu=gfx1102 -verify-machineinstrs < %s

; RUN: llc -enable-new-pm -mtriple=amdgcn -mcpu=gfx1102 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefixes=INCOMPATIBLE,NOREALTIME,NOMEMTIME %s
; RUN: FileCheck --check-prefixes=WARN-NOREALTIME,WARN-NOMEMTIME %s < %t
; RUN: llc -enable-new-pm -mtriple=amdgcn -mcpu=gfx1102 -verify-machineinstrs < %s

; Note: This test checks the IR, but also has a run line to codegen the file just to check we
; do not crash when trying to select those functions.

; WARN-REALTIME-NOT: removing function 'needs_s_memrealtime':
; WARN-MEMTIME-NOT:  removing function 'needs_s_memtime':
; WARN-NOREALTIME:   removing function 'needs_s_memrealtime': +s-memrealtime is not supported on the current target
; WARN-NOMEMTIME:    removing function 'needs_s_memtime': +s-memtime-inst is not supported on the current target

; COMPATIBLE:       @GVRefs  {{.*}} [ptr @needs_s_memrealtime, ptr @needs_s_memtime]
; INCOMPATIBLE:     @GVRefs {{.*}} zeroinitializer
@GVRefs = internal global [2 x ptr] [
  ptr @needs_s_memrealtime,
  ptr @needs_s_memtime
]

; REALTIME:    @ConstantExpr0 = internal global i64 ptrtoint (ptr @needs_s_memrealtime to i64)
; NOREALTIME:  @ConstantExpr0 = internal global i64 0
@ConstantExpr0 = internal global i64 ptrtoint (ptr @needs_s_memrealtime to i64)

; MEMTIME:     @ConstantExpr1 = internal global i64 ptrtoint (ptr @needs_s_memtime to i64)
; NOMEMTIME:   @ConstantExpr1 = internal global i64 0
@ConstantExpr1 = internal global i64 ptrtoint (ptr @needs_s_memtime to i64)

; REALTIME:         define i64 @needs_s_memrealtime
; NOREALTIME-NOT:   define i64 @needs_s_memrealtime
define i64 @needs_s_memrealtime() #0 {
  %t = tail call i64 @llvm.amdgcn.s.memrealtime()
  ret i64 %t
}

; IR: define void @s_memrealtime_caller(
define i64 @s_memrealtime_caller() {
  %t = call i64 @needs_s_memrealtime()
  ; IR: ret i64 %t
  ret i64 %t
}

; MEMTIME:         define i64 @needs_s_memtime
; NOMEMTIME-NOT:   define i64 @needs_s_memtime
define i64 @needs_s_memtime() #1 {
  %t = tail call i64 @llvm.amdgcn.s.memtime()
  ret i64 %t
}

; IR: define void @s_memtime_caller(
define i64 @s_memtime_caller() {
  %t = call i64 @needs_s_memtime()
  ; IR: ret i64 %t
  ret i64 %t
}


declare i64 @llvm.amdgcn.s.memrealtime()
declare i64 @llvm.amdgcn.s.memtime()

attributes #0 = { "target-features"="+s-memrealtime"}
attributes #1 = { "target-features"="+s-memtime-inst"}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; COMPATIBLE: {{.*}}
; INCOMPATIBLE: {{.*}}
; MEMTIME: {{.*}}
; NOMEMTIME: {{.*}}
; NOREALTIME: {{.*}}
; REALTIME: {{.*}}
