; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+bf16,+sve    < %s | FileCheck %s
; RUN: llc -mattr=+bf16,+sve2p2 < %s | FileCheck %s -check-prefix CHECK-2p2

; RUN: llc -mattr=+bf16,+sme    -force-streaming < %s | FileCheck %s
; RUN: llc -mattr=+bf16,+sme2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2

target triple = "aarch64-linux"

define <vscale x 16 x i8> @test_svcls_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcls_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cls z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cls.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcls_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcls_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cls.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcls_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcls_s8_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, #0 // =0x0
; CHECK-NEXT:    cls z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cls.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svcls_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcls_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cls z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cls.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcls_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcls_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cls.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcls_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcls_s16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    cls z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cls.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcls_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcls_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cls z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cls.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcls_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcls_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cls.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcls_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcls_s32_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, #0 // =0x0
; CHECK-NEXT:    cls z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cls.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcls_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcls_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cls z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cls.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcls_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcls_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cls.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcls_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcls_s64_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, #0 // =0x0
; CHECK-NEXT:    cls z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cls z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cls.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svclz_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svclz_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    clz z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.clz.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svclz_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svclz_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.clz.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svclz_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svclz_s8_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, #0 // =0x0
; CHECK-NEXT:    clz z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.clz.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svclz_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svclz_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    clz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.clz.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svclz_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svclz_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.clz.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svclz_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svclz_s16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    clz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.clz.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svclz_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svclz_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    clz z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.clz.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svclz_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svclz_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.clz.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svclz_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svclz_s32_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, #0 // =0x0
; CHECK-NEXT:    clz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.clz.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svclz_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svclz_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    clz z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.clz.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svclz_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svclz_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.clz.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svclz_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svclz_s64_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, #0 // =0x0
; CHECK-NEXT:    clz z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    clz z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.clz.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svcnt_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnt_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnt.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcnt_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnt_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnt.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcnt_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnt_s8_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, #0 // =0x0
; CHECK-NEXT:    cnt z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnt.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svcnt_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnt_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnt_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnt_s16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcnt_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnt_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnt_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnt_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnt_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnt_s32_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, #0 // =0x0
; CHECK-NEXT:    cnt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcnt_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnt_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnt_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnt_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnt_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnt_s64_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, #0 // =0x0
; CHECK-NEXT:    cnt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 8 x i16> @test_svcnt_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcnt_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8f16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcnt_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8f16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcnt_f16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8f16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_bf16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x bfloat> %x) {
; CHECK-LABEL: test_svcnt_bf16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_bf16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8bf16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x bfloat> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_bf16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x bfloat> %x) {
; CHECK-LABEL: test_svcnt_bf16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_bf16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8bf16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x bfloat> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_bf16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x bfloat> %x) {
; CHECK-LABEL: test_svcnt_bf16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_bf16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8bf16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x bfloat> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcnt_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcnt_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4f32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnt_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcnt_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4f32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnt_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcnt_f32_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, #0 // =0x0
; CHECK-NEXT:    cnt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4f32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcnt_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcnt_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2f64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnt_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcnt_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2f64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnt_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcnt_f64_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, #0 // =0x0
; CHECK-NEXT:    cnt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2f64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svcnot_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnot_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnot z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnot.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcnot_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnot_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnot.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcnot_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnot_s8_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, #0 // =0x0
; CHECK-NEXT:    cnot z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnot.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svcnot_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnot_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnot z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnot.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnot_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnot_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnot.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnot_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnot_s16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    cnot z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnot.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcnot_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnot_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnot z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnot.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnot_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnot_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnot.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnot_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnot_s32_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, #0 // =0x0
; CHECK-NEXT:    cnot z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnot.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcnot_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnot_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnot z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnot.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnot_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnot_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnot.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnot_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnot_s64_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, #0 // =0x0
; CHECK-NEXT:    cnot z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    cnot z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnot.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svnot_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svnot_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    not z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.not.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svnot_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svnot_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.not.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svnot_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svnot_s8_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, #0 // =0x0
; CHECK-NEXT:    not z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.not.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svnot_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svnot_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    not z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.not.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svnot_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svnot_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.not.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svnot_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svnot_s16_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.h, #0 // =0x0
; CHECK-NEXT:    not z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.not.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svnot_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svnot_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    not z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.not.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svnot_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svnot_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.not.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svnot_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svnot_s32_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.s, #0 // =0x0
; CHECK-NEXT:    not z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.not.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svnot_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svnot_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    not z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.not.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svnot_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svnot_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.not.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svnot_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svnot_s64_z:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, #0 // =0x0
; CHECK-NEXT:    not z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    not z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.not.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svcls_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcls_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    cls z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cls.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcls_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svcls_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cls z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    cls z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cls.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svcls_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcls_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cls z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cls.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcls_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svcls_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cls z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cls z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cls.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcls_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcls_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cls z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cls.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcls_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svcls_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cls z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cls z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cls.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcls_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcls_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cls z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cls z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cls.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcls_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svcls_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cls z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcls_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cls z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cls.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svclz_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svclz_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    clz z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.clz.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svclz_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svclz_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    clz z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    clz z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.clz.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svclz_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svclz_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    clz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.clz.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svclz_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svclz_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    clz z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    clz z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.clz.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svclz_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svclz_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    clz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.clz.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svclz_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svclz_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    clz z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    clz z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.clz.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svclz_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svclz_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    clz z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    clz z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.clz.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svclz_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svclz_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    clz z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svclz_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    clz z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.clz.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svcnt_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnt_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    cnt z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnt.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcnt_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svcnt_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    cnt z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnt.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svcnt_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnt_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svcnt_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcnt_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnt_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnt_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svcnt_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcnt_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnt_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnt_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svcnt_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 8 x i16> @test_svcnt_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcnt_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8f16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_nxv8f16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svcnt_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8f16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_nxv8bf16_ptrue_u(double %z0, <vscale x 8 x bfloat> %x) {
; CHECK-LABEL: test_svcnt_nxv8bf16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv8bf16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8bf16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x bfloat> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnt_nxv8bf16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x bfloat> %y) {
; CHECK-LABEL: test_svcnt_nxv8bf16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv8bf16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnt z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnt.nxv8bf16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x bfloat> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcnt_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcnt_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4f32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnt_nxv4f32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svcnt_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cnt z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnt.nxv4f32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcnt_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcnt_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2f64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnt_nxv2f64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svcnt_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnt z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnt_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cnt z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnt.nxv2f64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svcnot_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svcnot_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    cnot z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnot.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svcnot_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svcnot_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnot z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    cnot z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.cnot.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svcnot_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcnot_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnot z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnot.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svcnot_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svcnot_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnot z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    cnot z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.cnot.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svcnot_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcnot_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cnot z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnot.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svcnot_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svcnot_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnot z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    cnot z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.cnot.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svcnot_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcnot_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    cnot z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cnot z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnot.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svcnot_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svcnot_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    cnot z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcnot_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    cnot z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.cnot.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svnot_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svnot_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    not z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.not.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svnot_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svnot_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    not z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    not z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.not.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svnot_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svnot_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    not z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.not.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svnot_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svnot_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    not z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    not z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.not.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svnot_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svnot_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    not z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.not.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svnot_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svnot_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    not z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    not z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.not.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svnot_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svnot_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    not z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    not z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.not.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svnot_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svnot_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    not z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svnot_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    not z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.not.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}
