# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=znver4 -instruction-tables < %s | FileCheck %s

kaddd             %k0, %k1, %k2
kaddq             %k0, %k1, %k2

kandd             %k0, %k1, %k2
kandq             %k0, %k1, %k2

kandnd            %k0, %k1, %k2
kandnq            %k0, %k1, %k2

kmovd             %k0, %k2
kmovd             (%rax), %k2
kmovd             %k0, (%rax)
kmovd             %eax, %k2
kmovd             %k0, %eax

kmovq             %k0, %k2
kmovq             (%rax), %k2
kmovq             %k0, (%rax)
kmovq             %rax, %k2
kmovq             %k0, %rax

knotd             %k0, %k2
knotq             %k0, %k2

kord              %k0, %k1, %k2
korq              %k0, %k1, %k2

kortestd          %k0, %k2
kortestq          %k0, %k2

kshiftld          $2, %k1, %k2
kshiftlq          $2, %k1, %k2

kshiftrd          $2, %k1, %k2
kshiftrq          $2, %k1, %k2

ktestd            %k0, %k2
ktestq            %k0, %k2

kunpckdq          %k0, %k1, %k2
kunpckwd          %k0, %k1, %k2

kxnord            %k0, %k1, %k2
kxnorq            %k0, %k1, %k2

kxord             %k0, %k1, %k2
kxorq             %k0, %k1, %k2

vdbpsadbw         $0, %zmm16, %zmm17, %zmm19
vdbpsadbw         $0, (%rax), %zmm17, %zmm19
vdbpsadbw         $0, %zmm16, %zmm17, %zmm19 {k1}
vdbpsadbw         $0, (%rax), %zmm17, %zmm19 {k1}
vdbpsadbw         $0, %zmm16, %zmm17, %zmm19 {z}{k1}
vdbpsadbw         $0, (%rax), %zmm17, %zmm19 {z}{k1}

vmovdqu8          %zmm16, %zmm19
vmovdqu8          (%rax), %zmm19
vmovdqu8          %zmm16, (%rax)
vmovdqu8          %zmm16, %zmm19 {k1}
vmovdqu8          (%rax), %zmm19 {k1}
vmovdqu8          %zmm16, (%rax) {k1}
vmovdqu8          %zmm16, %zmm19 {z}{k1}
vmovdqu8          (%rax), %zmm19 {z}{k1}

vmovdqu16         %zmm16, %zmm19
vmovdqu16         (%rax), %zmm19
vmovdqu16         %zmm16, (%rax)
vmovdqu16         %zmm16, %zmm19 {k1}
vmovdqu16         (%rax), %zmm19 {k1}
vmovdqu16         %zmm16, (%rax) {k1}
vmovdqu16         %zmm16, %zmm19 {z}{k1}
vmovdqu16         (%rax), %zmm19 {z}{k1}

vpabsb            %zmm16, %zmm19
vpabsb            (%rax), %zmm19
vpabsb            %zmm16, %zmm19 {k1}
vpabsb            (%rax), %zmm19 {k1}
vpabsb            %zmm16, %zmm19 {z}{k1}
vpabsb            (%rax), %zmm19 {z}{k1}

vpabsw            %zmm16, %zmm19
vpabsw            (%rax), %zmm19
vpabsw            %zmm16, %zmm19 {k1}
vpabsw            (%rax), %zmm19 {k1}
vpabsw            %zmm16, %zmm19 {z}{k1}
vpabsw            (%rax), %zmm19 {z}{k1}

vpackssdw         %zmm16, %zmm17, %zmm19
vpackssdw         (%rax), %zmm17, %zmm19
vpackssdw         %zmm16, %zmm17, %zmm19 {k1}
vpackssdw         (%rax), %zmm17, %zmm19 {k1}
vpackssdw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpackssdw         (%rax), %zmm17, %zmm19 {z}{k1}

vpacksswb         %zmm16, %zmm17, %zmm19
vpacksswb         (%rax), %zmm17, %zmm19
vpacksswb         %zmm16, %zmm17, %zmm19 {k1}
vpacksswb         (%rax), %zmm17, %zmm19 {k1}
vpacksswb         %zmm16, %zmm17, %zmm19 {z}{k1}
vpacksswb         (%rax), %zmm17, %zmm19 {z}{k1}

vpackusdw         %zmm16, %zmm17, %zmm19
vpackusdw         (%rax), %zmm17, %zmm19
vpackusdw         %zmm16, %zmm17, %zmm19 {k1}
vpackusdw         (%rax), %zmm17, %zmm19 {k1}
vpackusdw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpackusdw         (%rax), %zmm17, %zmm19 {z}{k1}

vpackuswb         %zmm16, %zmm17, %zmm19
vpackuswb         (%rax), %zmm17, %zmm19
vpackuswb         %zmm16, %zmm17, %zmm19 {k1}
vpackuswb         (%rax), %zmm17, %zmm19 {k1}
vpackuswb         %zmm16, %zmm17, %zmm19 {z}{k1}
vpackuswb         (%rax), %zmm17, %zmm19 {z}{k1}

vpaddb            %zmm16, %zmm17, %zmm19
vpaddb            (%rax), %zmm17, %zmm19
vpaddb            %zmm16, %zmm17, %zmm19 {k1}
vpaddb            (%rax), %zmm17, %zmm19 {k1}
vpaddb            %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddb            (%rax), %zmm17, %zmm19 {z}{k1}

vpaddsb           %zmm16, %zmm17, %zmm19
vpaddsb           (%rax), %zmm17, %zmm19
vpaddsb           %zmm16, %zmm17, %zmm19 {k1}
vpaddsb           (%rax), %zmm17, %zmm19 {k1}
vpaddsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpaddsw           %zmm16, %zmm17, %zmm19
vpaddsw           (%rax), %zmm17, %zmm19
vpaddsw           %zmm16, %zmm17, %zmm19 {k1}
vpaddsw           (%rax), %zmm17, %zmm19 {k1}
vpaddsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpaddusb          %zmm16, %zmm17, %zmm19
vpaddusb          (%rax), %zmm17, %zmm19
vpaddusb          %zmm16, %zmm17, %zmm19 {k1}
vpaddusb          (%rax), %zmm17, %zmm19 {k1}
vpaddusb          %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddusb          (%rax), %zmm17, %zmm19 {z}{k1}

vpaddusw          %zmm16, %zmm17, %zmm19
vpaddusw          (%rax), %zmm17, %zmm19
vpaddusw          %zmm16, %zmm17, %zmm19 {k1}
vpaddusw          (%rax), %zmm17, %zmm19 {k1}
vpaddusw          %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddusw          (%rax), %zmm17, %zmm19 {z}{k1}

vpaddw            %zmm16, %zmm17, %zmm19
vpaddw            (%rax), %zmm17, %zmm19
vpaddw            %zmm16, %zmm17, %zmm19 {k1}
vpaddw            (%rax), %zmm17, %zmm19 {k1}
vpaddw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddw            (%rax), %zmm17, %zmm19 {z}{k1}

vpalignr          $1, %zmm16, %zmm17, %zmm19
vpalignr          $1, (%rax), %zmm17, %zmm19
vpalignr          $1, %zmm16, %zmm17, %zmm19 {k1}
vpalignr          $1, (%rax), %zmm17, %zmm19 {k1}
vpalignr          $1, %zmm16, %zmm17, %zmm19 {z}{k1}
vpalignr          $1, (%rax), %zmm17, %zmm19 {z}{k1}

vpavgb            %zmm16, %zmm17, %zmm19
vpavgb            (%rax), %zmm17, %zmm19
vpavgb            %zmm16, %zmm17, %zmm19 {k1}
vpavgb            (%rax), %zmm17, %zmm19 {k1}
vpavgb            %zmm16, %zmm17, %zmm19 {z}{k1}
vpavgb            (%rax), %zmm17, %zmm19 {z}{k1}

vpavgw            %zmm16, %zmm17, %zmm19
vpavgw            (%rax), %zmm17, %zmm19
vpavgw            %zmm16, %zmm17, %zmm19 {k1}
vpavgw            (%rax), %zmm17, %zmm19 {k1}
vpavgw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpavgw            (%rax), %zmm17, %zmm19 {z}{k1}

vpblendmb         %zmm16, %zmm17, %zmm19
vpblendmb         (%rax), %zmm17, %zmm19
vpblendmb         %zmm16, %zmm17, %zmm19 {k1}
vpblendmb         (%rax), %zmm17, %zmm19 {k1}
vpblendmb         %zmm16, %zmm17, %zmm19 {z}{k1}
vpblendmb         (%rax), %zmm17, %zmm19 {z}{k1}

vpblendmw         %zmm16, %zmm17, %zmm19
vpblendmw         (%rax), %zmm17, %zmm19
vpblendmw         %zmm16, %zmm17, %zmm19 {k1}
vpblendmw         (%rax), %zmm17, %zmm19 {k1}
vpblendmw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpblendmw         (%rax), %zmm17, %zmm19 {z}{k1}

vpbroadcastb      %xmm16, %zmm19
vpbroadcastb      (%rax), %zmm19
vpbroadcastb      %eax, %zmm19
vpbroadcastb      %xmm16, %zmm19 {k1}
vpbroadcastb      (%rax), %zmm19 {k1}
vpbroadcastb      %eax, %zmm19 {k1}
vpbroadcastb      %xmm16, %zmm19 {z}{k1}
vpbroadcastb      (%rax), %zmm19 {z}{k1}
vpbroadcastb      %eax, %zmm19 {z}{k1}

vpbroadcastw      %xmm16, %zmm19
vpbroadcastw      (%rax), %zmm19
vpbroadcastw      %eax, %zmm19
vpbroadcastw      %xmm16, %zmm19 {k1}
vpbroadcastw      (%rax), %zmm19 {k1}
vpbroadcastw      %eax, %zmm19 {k1}
vpbroadcastw      %xmm16, %zmm19 {z}{k1}
vpbroadcastw      (%rax), %zmm19 {z}{k1}
vpbroadcastw      %eax, %zmm19 {z}{k1}

vpcmpb            $0, %zmm0, %zmm1, %k2
vpcmpb            $0, (%rax), %zmm1, %k2
vpcmpb            $0, %zmm0, %zmm1, %k2 {k3}
vpcmpb            $0, (%rax), %zmm1, %k2 {k3}

vpcmpeqb          %zmm0, %zmm1, %k2
vpcmpeqb          (%rax), %zmm1, %k2
vpcmpeqb          %zmm0, %zmm1, %k2 {k3}
vpcmpeqb          (%rax), %zmm1, %k2 {k3}

vpcmpeqw          %zmm0, %zmm1, %k2
vpcmpeqw          (%rax), %zmm1, %k2
vpcmpeqw          %zmm0, %zmm1, %k2 {k3}
vpcmpeqw          (%rax), %zmm1, %k2 {k3}

vpcmpgtb          %zmm0, %zmm1, %k2
vpcmpgtb          (%rax), %zmm1, %k2
vpcmpgtb          %zmm0, %zmm1, %k2 {k3}
vpcmpgtb          (%rax), %zmm1, %k2 {k3}

vpcmpgtw          %zmm0, %zmm1, %k2
vpcmpgtw          (%rax), %zmm1, %k2
vpcmpgtw          %zmm0, %zmm1, %k2 {k3}
vpcmpgtw          (%rax), %zmm1, %k2 {k3}

vpcmpub           $0, %zmm0, %zmm1, %k2
vpcmpub           $0, (%rax), %zmm1, %k2
vpcmpub           $0, %zmm0, %zmm1, %k2 {k3}
vpcmpub           $0, (%rax), %zmm1, %k2 {k3}

vpcmpuw           $0, %zmm0, %zmm1, %k2
vpcmpuw           $0, (%rax), %zmm1, %k2
vpcmpuw           $0, %zmm0, %zmm1, %k2 {k3}
vpcmpuw           $0, (%rax), %zmm1, %k2 {k3}

vpcmpw            $0, %zmm0, %zmm1, %k2
vpcmpw            $0, (%rax), %zmm1, %k2
vpcmpw            $0, %zmm0, %zmm1, %k2 {k3}
vpcmpw            $0, (%rax), %zmm1, %k2 {k3}

vpextrb           $0, %xmm16, %rax
vpextrb           $0, %xmm16, (%rax)

vpextrw           $0, %xmm16, %rax
vpextrw           $0, %xmm16, (%rax)

vpinsrb           $0, %rax, %xmm16, %xmm19
vpinsrb           $0, (%rax), %xmm16, %xmm19

vpinsrw           $0, %rax, %xmm16, %xmm19
vpinsrw           $0, (%rax), %xmm16, %xmm19

vpermw            %zmm16, %zmm17, %zmm19
vpermw            (%rax), %zmm17, %zmm19
vpermw            %zmm16, %zmm17, %zmm19 {k1}
vpermw            (%rax), %zmm17, %zmm19 {k1}
vpermw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpermw            (%rax), %zmm17, %zmm19 {z}{k1}

vpermi2w          %zmm16, %zmm17, %zmm19
vpermi2w          (%rax), %zmm17, %zmm19
vpermi2w          %zmm16, %zmm17, %zmm19 {k1}
vpermi2w          (%rax), %zmm17, %zmm19 {k1}
vpermi2w          %zmm16, %zmm17, %zmm19 {z}{k1}
vpermi2w          (%rax), %zmm17, %zmm19 {z}{k1}

vpermt2w          %zmm16, %zmm17, %zmm19
vpermt2w          (%rax), %zmm17, %zmm19
vpermt2w          %zmm16, %zmm17, %zmm19 {k1}
vpermt2w          (%rax), %zmm17, %zmm19 {k1}
vpermt2w          %zmm16, %zmm17, %zmm19 {z}{k1}
vpermt2w          (%rax), %zmm17, %zmm19 {z}{k1}

vpmaddubsw        %zmm16, %zmm17, %zmm19
vpmaddubsw        (%rax), %zmm17, %zmm19
vpmaddubsw        %zmm16, %zmm17, %zmm19 {k1}
vpmaddubsw        (%rax), %zmm17, %zmm19 {k1}
vpmaddubsw        %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaddubsw        (%rax), %zmm17, %zmm19 {z}{k1}

vpmaddwd          %zmm16, %zmm17, %zmm19
vpmaddwd          (%rax), %zmm17, %zmm19
vpmaddwd          %zmm16, %zmm17, %zmm19 {k1}
vpmaddwd          (%rax), %zmm17, %zmm19 {k1}
vpmaddwd          %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaddwd          (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxsb           %zmm16, %zmm17, %zmm19
vpmaxsb           (%rax), %zmm17, %zmm19
vpmaxsb           %zmm16, %zmm17, %zmm19 {k1}
vpmaxsb           (%rax), %zmm17, %zmm19 {k1}
vpmaxsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxsw           %zmm16, %zmm17, %zmm19
vpmaxsw           (%rax), %zmm17, %zmm19
vpmaxsw           %zmm16, %zmm17, %zmm19 {k1}
vpmaxsw           (%rax), %zmm17, %zmm19 {k1}
vpmaxsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxub           %zmm16, %zmm17, %zmm19
vpmaxub           (%rax), %zmm17, %zmm19
vpmaxub           %zmm16, %zmm17, %zmm19 {k1}
vpmaxub           (%rax), %zmm17, %zmm19 {k1}
vpmaxub           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxub           (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxuw           %zmm16, %zmm17, %zmm19
vpmaxuw           (%rax), %zmm17, %zmm19
vpmaxuw           %zmm16, %zmm17, %zmm19 {k1}
vpmaxuw           (%rax), %zmm17, %zmm19 {k1}
vpmaxuw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxuw           (%rax), %zmm17, %zmm19 {z}{k1}

vpminsb           %zmm16, %zmm17, %zmm19
vpminsb           (%rax), %zmm17, %zmm19
vpminsb           %zmm16, %zmm17, %zmm19 {k1}
vpminsb           (%rax), %zmm17, %zmm19 {k1}
vpminsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpminsw           %zmm16, %zmm17, %zmm19
vpminsw           (%rax), %zmm17, %zmm19
vpminsw           %zmm16, %zmm17, %zmm19 {k1}
vpminsw           (%rax), %zmm17, %zmm19 {k1}
vpminsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpminub           %zmm16, %zmm17, %zmm19
vpminub           (%rax), %zmm17, %zmm19
vpminub           %zmm16, %zmm17, %zmm19 {k1}
vpminub           (%rax), %zmm17, %zmm19 {k1}
vpminub           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminub           (%rax), %zmm17, %zmm19 {z}{k1}

vpminuw           %zmm16, %zmm17, %zmm19
vpminuw           (%rax), %zmm17, %zmm19
vpminuw           %zmm16, %zmm17, %zmm19 {k1}
vpminuw           (%rax), %zmm17, %zmm19 {k1}
vpminuw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminuw           (%rax), %zmm17, %zmm19 {z}{k1}

vpmovb2m          %zmm0, %k0
vpmovw2m          %zmm0, %k0

vpmovm2b          %k0, %zmm0
vpmovm2w          %k0, %zmm0

vpmovsxbw         %ymm16, %zmm19
vpmovsxbw         (%rax), %zmm19
vpmovsxbw         %ymm16, %zmm19 {k1}
vpmovsxbw         (%rax), %zmm19 {k1}
vpmovsxbw         %ymm16, %zmm19 {z}{k1}
vpmovsxbw         (%rax), %zmm19 {z}{k1}

vpmovswb          %zmm16, %ymm19
vpmovswb          %zmm16, (%rax)
vpmovswb          %zmm16, %ymm19 {k1}
vpmovswb          %zmm16, (%rax) {k1}
vpmovswb          %zmm16, %ymm19 {z}{k1}

vpmovuswb         %zmm16, %ymm19
vpmovuswb         %zmm16, (%rax)
vpmovuswb         %zmm16, %ymm19 {k1}
vpmovuswb         %zmm16, (%rax) {k1}
vpmovuswb         %zmm16, %ymm19 {z}{k1}

vpmovwb           %zmm16, %ymm19
vpmovwb           %zmm16, (%rax)
vpmovwb           %zmm16, %ymm19 {k1}
vpmovwb           %zmm16, (%rax) {k1}
vpmovwb           %zmm16, %ymm19 {z}{k1}

vpmovzxbw         %ymm16, %zmm19
vpmovzxbw         (%rax), %zmm19
vpmovzxbw         %ymm16, %zmm19 {k1}
vpmovzxbw         (%rax), %zmm19 {k1}
vpmovzxbw         %ymm16, %zmm19 {z}{k1}
vpmovzxbw         (%rax), %zmm19 {z}{k1}

vpmulhrsw         %zmm16, %zmm17, %zmm19
vpmulhrsw         (%rax), %zmm17, %zmm19
vpmulhrsw         %zmm16, %zmm17, %zmm19 {k1}
vpmulhrsw         (%rax), %zmm17, %zmm19 {k1}
vpmulhrsw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpmulhrsw         (%rax), %zmm17, %zmm19 {z}{k1}

vpmulhuw          %zmm16, %zmm17, %zmm19
vpmulhuw          (%rax), %zmm17, %zmm19
vpmulhuw          %zmm16, %zmm17, %zmm19 {k1}
vpmulhuw          (%rax), %zmm17, %zmm19 {k1}
vpmulhuw          %zmm16, %zmm17, %zmm19 {z}{k1}
vpmulhuw          (%rax), %zmm17, %zmm19 {z}{k1}

vpmulhw           %zmm16, %zmm17, %zmm19
vpmulhw           (%rax), %zmm17, %zmm19
vpmulhw           %zmm16, %zmm17, %zmm19 {k1}
vpmulhw           (%rax), %zmm17, %zmm19 {k1}
vpmulhw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmulhw           (%rax), %zmm17, %zmm19 {z}{k1}

vpmullw           %zmm16, %zmm17, %zmm19
vpmullw           (%rax), %zmm17, %zmm19
vpmullw           %zmm16, %zmm17, %zmm19 {k1}
vpmullw           (%rax), %zmm17, %zmm19 {k1}
vpmullw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmullw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsadbw           %zmm16, %zmm17, %zmm19
vpsadbw           (%rax), %zmm17, %zmm19

vpshufb           %zmm16, %zmm17, %zmm19
vpshufb           (%rax), %zmm17, %zmm19
vpshufb           %zmm16, %zmm17, %zmm19 {k1}
vpshufb           (%rax), %zmm17, %zmm19 {k1}
vpshufb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpshufb           (%rax), %zmm17, %zmm19 {z}{k1}

vpshufhw          $0, %zmm16, %zmm19
vpshufhw          $0, (%rax), %zmm19
vpshufhw          $0, %zmm16, %zmm19 {k1}
vpshufhw          $0, (%rax), %zmm19 {k1}
vpshufhw          $0, %zmm16, %zmm19 {z}{k1}
vpshufhw          $0, (%rax), %zmm19 {z}{k1}

vpshuflw          $0, %zmm16, %zmm19
vpshuflw          $0, (%rax), %zmm19
vpshuflw          $0, %zmm16, %zmm19 {k1}
vpshuflw          $0, (%rax), %zmm19 {k1}
vpshuflw          $0, %zmm16, %zmm19 {z}{k1}
vpshuflw          $0, (%rax), %zmm19 {z}{k1}

vpslldq           $1, %zmm16, %zmm19
vpslldq           $1, (%rax), %zmm19

vpsllvw           %zmm16, %zmm17, %zmm19
vpsllvw           (%rax), %zmm17, %zmm19
vpsllvw           %zmm16, %zmm17, %zmm19 {k1}
vpsllvw           (%rax), %zmm17, %zmm19 {k1}
vpsllvw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsllvw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsllw            $0, %zmm16, %zmm19
vpsllw            $0, (%rax), %zmm19
vpsllw            $0, %zmm16, %zmm19 {k1}
vpsllw            $0, (%rax), %zmm19 {k1}
vpsllw            $0, %zmm16, %zmm19 {z}{k1}
vpsllw            $0, (%rax), %zmm19 {z}{k1}

vpsllw            %xmm16, %zmm17, %zmm19
vpsllw            (%rax), %zmm17, %zmm19
vpsllw            %xmm16, %zmm17, %zmm19 {k1}
vpsllw            (%rax), %zmm17, %zmm19 {k1}
vpsllw            %xmm16, %zmm17, %zmm19 {z}{k1}
vpsllw            (%rax), %zmm17, %zmm19 {z}{k1}

vpsravw           %zmm16, %zmm17, %zmm19
vpsravw           (%rax), %zmm17, %zmm19
vpsravw           %zmm16, %zmm17, %zmm19 {k1}
vpsravw           (%rax), %zmm17, %zmm19 {k1}
vpsravw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsravw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsraw            $0, %zmm16, %zmm19
vpsraw            $0, (%rax), %zmm19
vpsraw            $0, %zmm16, %zmm19 {k1}
vpsraw            $0, (%rax), %zmm19 {k1}
vpsraw            $0, %zmm16, %zmm19 {z}{k1}
vpsraw            $0, (%rax), %zmm19 {z}{k1}

vpsraw            %xmm16, %zmm17, %zmm19
vpsraw            (%rax), %zmm17, %zmm19
vpsraw            %xmm16, %zmm17, %zmm19 {k1}
vpsraw            (%rax), %zmm17, %zmm19 {k1}
vpsraw            %xmm16, %zmm17, %zmm19 {z}{k1}
vpsraw            (%rax), %zmm17, %zmm19 {z}{k1}

vpsrldq           $1, %zmm16, %zmm19
vpsrldq           $1, (%rax), %zmm19

vpsrlvw           %zmm16, %zmm17, %zmm19
vpsrlvw           (%rax), %zmm17, %zmm19
vpsrlvw           %zmm16, %zmm17, %zmm19 {k1}
vpsrlvw           (%rax), %zmm17, %zmm19 {k1}
vpsrlvw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsrlvw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsrlw            $0, %zmm16, %zmm19
vpsrlw            $0, (%rax), %zmm19
vpsrlw            $0, %zmm16, %zmm19 {k1}
vpsrlw            $0, (%rax), %zmm19 {k1}
vpsrlw            $0, %zmm16, %zmm19 {z}{k1}
vpsrlw            $0, (%rax), %zmm19 {z}{k1}

vpsrlw            %xmm16, %zmm17, %zmm19
vpsrlw            (%rax), %zmm17, %zmm19
vpsrlw            %xmm16, %zmm17, %zmm19 {k1}
vpsrlw            (%rax), %zmm17, %zmm19 {k1}
vpsrlw            %xmm16, %zmm17, %zmm19 {z}{k1}
vpsrlw            (%rax), %zmm17, %zmm19 {z}{k1}

vpsubb            %zmm16, %zmm17, %zmm19
vpsubb            (%rax), %zmm17, %zmm19
vpsubb            %zmm16, %zmm17, %zmm19 {k1}
vpsubb            (%rax), %zmm17, %zmm19 {k1}
vpsubb            %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubb            (%rax), %zmm17, %zmm19 {z}{k1}

vpsubsb           %zmm16, %zmm17, %zmm19
vpsubsb           (%rax), %zmm17, %zmm19
vpsubsb           %zmm16, %zmm17, %zmm19 {k1}
vpsubsb           (%rax), %zmm17, %zmm19 {k1}
vpsubsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpsubsw           %zmm16, %zmm17, %zmm19
vpsubsw           (%rax), %zmm17, %zmm19
vpsubsw           %zmm16, %zmm17, %zmm19 {k1}
vpsubsw           (%rax), %zmm17, %zmm19 {k1}
vpsubsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsubusb          %zmm16, %zmm17, %zmm19
vpsubusb          (%rax), %zmm17, %zmm19
vpsubusb          %zmm16, %zmm17, %zmm19 {k1}
vpsubusb          (%rax), %zmm17, %zmm19 {k1}
vpsubusb          %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubusb          (%rax), %zmm17, %zmm19 {z}{k1}

vpsubusw          %zmm16, %zmm17, %zmm19
vpsubusw          (%rax), %zmm17, %zmm19
vpsubusw          %zmm16, %zmm17, %zmm19 {k1}
vpsubusw          (%rax), %zmm17, %zmm19 {k1}
vpsubusw          %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubusw          (%rax), %zmm17, %zmm19 {z}{k1}

vpsubw            %zmm16, %zmm17, %zmm19
vpsubw            (%rax), %zmm17, %zmm19
vpsubw            %zmm16, %zmm17, %zmm19 {k1}
vpsubw            (%rax), %zmm17, %zmm19 {k1}
vpsubw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubw            (%rax), %zmm17, %zmm19 {z}{k1}

vptestmb          %zmm0, %zmm1, %k2
vptestmb          (%rax), %zmm1, %k2
vptestmb          %zmm0, %zmm1, %k2 {k3}
vptestmb          (%rax), %zmm1, %k2 {k3}

vptestmw          %zmm0, %zmm1, %k2
vptestmw          (%rax), %zmm1, %k2
vptestmw          %zmm0, %zmm1, %k2 {k3}
vptestmw          (%rax), %zmm1, %k2 {k3}

vptestnmb         %zmm0, %zmm1, %k2
vptestnmb         (%rax), %zmm1, %k2
vptestnmb         %zmm0, %zmm1, %k2 {k3}
vptestnmb         (%rax), %zmm1, %k2 {k3}

vptestnmw         %zmm0, %zmm1, %k2
vptestnmw         (%rax), %zmm1, %k2
vptestnmw         %zmm0, %zmm1, %k2 {k3}
vptestnmw         (%rax), %zmm1, %k2 {k3}

vpunpckhbw        %zmm16, %zmm17, %zmm19
vpunpckhbw        (%rax), %zmm17, %zmm19
vpunpckhbw        %zmm16, %zmm17, %zmm19 {k1}
vpunpckhbw        (%rax), %zmm17, %zmm19 {k1}
vpunpckhbw        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpckhbw        (%rax), %zmm17, %zmm19 {z}{k1}

vpunpckhwd        %zmm16, %zmm17, %zmm19
vpunpckhwd        (%rax), %zmm17, %zmm19
vpunpckhwd        %zmm16, %zmm17, %zmm19 {k1}
vpunpckhwd        (%rax), %zmm17, %zmm19 {k1}
vpunpckhwd        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpckhwd        (%rax), %zmm17, %zmm19 {z}{k1}

vpunpcklbw        %zmm16, %zmm17, %zmm19
vpunpcklbw        (%rax), %zmm17, %zmm19
vpunpcklbw        %zmm16, %zmm17, %zmm19 {k1}
vpunpcklbw        (%rax), %zmm17, %zmm19 {k1}
vpunpcklbw        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpcklbw        (%rax), %zmm17, %zmm19 {z}{k1}

vpunpcklwd        %zmm16, %zmm17, %zmm19
vpunpcklwd        (%rax), %zmm17, %zmm19
vpunpcklwd        %zmm16, %zmm17, %zmm19 {k1}
vpunpcklwd        (%rax), %zmm17, %zmm19 {k1}
vpunpcklwd        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpcklwd        (%rax), %zmm17, %zmm19 {z}{k1}

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.50                        kaddd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kaddq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kandd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kandq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kandnd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kandnq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kmovd	%k0, %k2
# CHECK-NEXT:  1      5     0.33    *                   kmovd	(%rax), %k2
# CHECK-NEXT:  1      1     0.50           *            kmovd	%k0, (%rax)
# CHECK-NEXT:  1      1     0.50                        kmovd	%eax, %k2
# CHECK-NEXT:  1      1     0.50                        kmovd	%k0, %eax
# CHECK-NEXT:  1      1     0.50                        kmovq	%k0, %k2
# CHECK-NEXT:  1      5     0.33    *                   kmovq	(%rax), %k2
# CHECK-NEXT:  1      1     0.50           *            kmovq	%k0, (%rax)
# CHECK-NEXT:  1      1     0.50                        kmovq	%rax, %k2
# CHECK-NEXT:  1      1     0.50                        kmovq	%k0, %rax
# CHECK-NEXT:  1      1     0.50                        knotd	%k0, %k2
# CHECK-NEXT:  1      1     0.50                        knotq	%k0, %k2
# CHECK-NEXT:  1      1     0.50                        kord	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        korq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kortestd	%k0, %k2
# CHECK-NEXT:  1      1     0.50                        kortestq	%k0, %k2
# CHECK-NEXT:  1      1     0.50                        kshiftld	$2, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kshiftlq	$2, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kshiftrd	$2, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kshiftrq	$2, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        ktestd	%k0, %k2
# CHECK-NEXT:  1      1     0.50                        ktestq	%k0, %k2
# CHECK-NEXT:  1      1     0.50                        kunpckdq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kunpckwd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kxnord	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kxnorq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kxord	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.50                        kxorq	%k0, %k1, %k2
# CHECK-NEXT:  1      4     1.00                        vdbpsadbw	$0, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      11    1.00    *                   vdbpsadbw	$0, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      4     1.00                        vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      11    1.00    *                   vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      4     1.00                        vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      11    1.00    *                   vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      0     0.17                        vmovdqu8	%zmm16, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu8	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00           *            vmovdqu8	%zmm16, (%rax)
# CHECK-NEXT:  1      0     0.17                        vmovdqu8	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu8	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00           *            vmovdqu8	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      0     0.17                        vmovdqu8	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu8	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      0     0.17                        vmovdqu16	%zmm16, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu16	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00           *            vmovdqu16	%zmm16, (%rax)
# CHECK-NEXT:  1      0     0.17                        vmovdqu16	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu16	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00           *            vmovdqu16	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      0     0.17                        vmovdqu16	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu16	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpabsb	%zmm16, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpabsb	(%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpabsb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpabsb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpabsb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpabsb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpabsw	%zmm16, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpabsw	(%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpabsw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpabsw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpabsw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpabsw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpackssdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpackssdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpackssdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpackssdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpackssdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpackssdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpacksswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpacksswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpacksswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpacksswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpacksswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpacksswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpackusdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpackusdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpackusdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpackusdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpackusdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpackusdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpackuswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpackuswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpackuswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpackuswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpackuswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpackuswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpaddb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpaddb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpaddb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpaddsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpaddsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpaddsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpaddsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpaddsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpaddsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpaddusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpaddusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpaddusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpaddusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpaddusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpaddusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpaddw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpaddw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpaddw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpalignr	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpalignr	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpavgb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpavgb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpavgb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpavgb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpavgb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpavgb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpavgw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpavgw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpavgw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpavgw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpavgw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpavgw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpblendmb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpblendmb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpblendmb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpblendmb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpblendmb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpblendmb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpblendmw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpblendmw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpblendmw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpblendmw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpblendmw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpblendmw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%xmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpbroadcastb	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%eax, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpbroadcastb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%eax, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpbroadcastb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%xmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpbroadcastw	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%eax, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpbroadcastw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%eax, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpbroadcastw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.25                        vpcmpgtb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpgtb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.25                        vpcmpgtw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpgtw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpequb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpequb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpequb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpequb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpequw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpequw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpequw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpequw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      1     1.00                        vpextrb	$0, %xmm16, %eax
# CHECK-NEXT:  2      2     1.00           *            vpextrb	$0, %xmm16, (%rax)
# CHECK-NEXT:  2      1     1.00                        vpextrw	$0, %xmm16, %eax
# CHECK-NEXT:  2      2     1.00           *            vpextrw	$0, %xmm16, (%rax)
# CHECK-NEXT:  2      1     1.00                        vpinsrb	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  1      8     1.50    *                   vpinsrb	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  2      1     1.00                        vpinsrw	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  1      8     1.50    *                   vpinsrw	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  1      5     1.00                        vpermw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpermw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpermw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpermw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpermw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpermw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpermi2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpermi2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpermi2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpermi2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpermi2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpermi2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpermt2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpermt2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpermt2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpermt2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpermt2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpermt2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpmaddubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      10    1.00    *                   vpmaddubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      3     1.00                        vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      10    1.00    *                   vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      10    1.00    *                   vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpmaddwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      10    1.00    *                   vpmaddwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      3     1.00                        vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      10    1.00    *                   vpmaddwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      10    1.00    *                   vpmaddwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpmaxub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpmaxuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpmaxuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpminsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpminsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpminsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpminsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpminsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpminsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpminub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpminub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpminub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpminuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpminuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpminuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpmovb2m	%zmm0, %k0
# CHECK-NEXT:  1      1     1.00                        vpmovw2m	%zmm0, %k0
# CHECK-NEXT:  1      0     0.17                        vpmovm2b	%k0, %zmm0
# CHECK-NEXT:  1      0     0.17                        vpmovm2w	%k0, %zmm0
# CHECK-NEXT:  1      4     1.00                        vpmovsxbw	%ymm16, %zmm19
# CHECK-NEXT:  1      11    1.50    *                   vpmovsxbw	(%rax), %zmm19
# CHECK-NEXT:  1      4     1.00                        vpmovsxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  1      11    1.50    *                   vpmovsxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      4     1.00                        vpmovsxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      11    1.50    *                   vpmovsxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmovswb	%zmm16, %ymm19
# CHECK-NEXT:  1      11    1.50           *            vpmovswb	%zmm16, (%rax)
# CHECK-NEXT:  1      5     1.00                        vpmovswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  1      11    1.50           *            vpmovswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmovswb	%zmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmovuswb	%zmm16, %ymm19
# CHECK-NEXT:  1      11    1.50           *            vpmovuswb	%zmm16, (%rax)
# CHECK-NEXT:  1      5     1.00                        vpmovuswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  1      11    1.50           *            vpmovuswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmovuswb	%zmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmovwb	%zmm16, %ymm19
# CHECK-NEXT:  1      11    1.50           *            vpmovwb	%zmm16, (%rax)
# CHECK-NEXT:  1      5     1.00                        vpmovwb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  1      11    1.50           *            vpmovwb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmovwb	%zmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  1      4     1.00                        vpmovzxbw	%ymm16, %zmm19
# CHECK-NEXT:  1      11    1.50    *                   vpmovzxbw	(%rax), %zmm19
# CHECK-NEXT:  1      4     1.00                        vpmovzxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  1      11    1.50    *                   vpmovzxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      4     1.00                        vpmovzxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      11    1.50    *                   vpmovzxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpmulhrsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      10    1.00    *                   vpmulhrsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      3     1.00                        vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      10    1.00    *                   vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      10    1.00    *                   vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpmulhuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      10    1.00    *                   vpmulhuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      3     1.00                        vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      10    1.00    *                   vpmulhuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      10    1.00    *                   vpmulhuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpmulhw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      10    1.00    *                   vpmulhw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      3     1.00                        vpmulhw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      10    1.00    *                   vpmulhw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpmulhw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      10    1.00    *                   vpmulhw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                        vpmullw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      10    1.00    *                   vpmullw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      3     1.00                        vpmullw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      10    1.00    *                   vpmullw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpmullw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      10    1.00    *                   vpmullw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      4     1.00                        vpsadbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      11    1.00    *                   vpsadbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpshufb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpshufb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpshufb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpshufb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpshufb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpshufb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpshufhw	$0, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpshufhw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpshufhw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpshufhw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpshufhw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpshufhw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpshuflw	$0, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpshuflw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpshuflw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpshuflw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpshuflw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpshuflw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpslldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpslldq	$1, (%rax), %zmm19
# CHECK-NEXT:  2      1     1.00                        vpsllvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsllvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      1     1.00                        vpsllvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsllvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      1     1.00                        vpsllvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsllvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsllw	$0, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsllw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsllw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpsllw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpsllw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpsllw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      1     1.00                        vpsravw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsravw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      1     1.00                        vpsravw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsravw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      1     1.00                        vpsravw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsravw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsraw	$0, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsraw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsraw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpsraw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpsraw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpsraw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpsrldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsrldq	$1, (%rax), %zmm19
# CHECK-NEXT:  2      1     1.00                        vpsrlvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsrlvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      1     1.00                        vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsrlvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      1     1.00                        vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsrlvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsrlw	$0, %zmm16, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsrlw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsrlw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      2     1.00                        vpsrlw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      2     1.00                        vpsrlw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      2     1.00                        vpsrlw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.25                        vpsubb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpsubb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpsubb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpsubb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpsubsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpsubsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpsubsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpsubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpsubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpsubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpsubusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpsubusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpsubusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpsubusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpsubusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpsubusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.25                        vpsubw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     0.50    *                   vpsubw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     0.50    *                   vpsubw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     0.50    *                   vpsubw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vptestmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vptestmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      5     2.50                        vptestmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vptestmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vptestmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vptestmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      5     2.50                        vptestmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vptestmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vptestnmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vptestnmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      5     2.50                        vptestnmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vptestnmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vptestnmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  1      8     0.50    *                   vptestnmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      5     2.50                        vptestnmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      8     0.50    *                   vptestnmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     1.00                        vpunpckhbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpunpckhbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpunpckhwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpunpckhwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpunpcklbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpunpcklbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpunpcklwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  1      8     1.00    *                   vpunpcklwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      8     1.00    *                   vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      8     1.00    *                   vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1} {z}

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn4AGU0
# CHECK-NEXT: [1]   - Zn4AGU1
# CHECK-NEXT: [2]   - Zn4AGU2
# CHECK-NEXT: [3]   - Zn4ALU0
# CHECK-NEXT: [4]   - Zn4ALU1
# CHECK-NEXT: [5]   - Zn4ALU2
# CHECK-NEXT: [6]   - Zn4ALU3
# CHECK-NEXT: [7]   - Zn4BRU1
# CHECK-NEXT: [8]   - Zn4FP0
# CHECK-NEXT: [9]   - Zn4FP1
# CHECK-NEXT: [10]  - Zn4FP2
# CHECK-NEXT: [11]  - Zn4FP3
# CHECK-NEXT: [12.0] - Zn4FP45
# CHECK-NEXT: [12.1] - Zn4FP45
# CHECK-NEXT: [13]  - Zn4FPSt
# CHECK-NEXT: [14.0] - Zn4LSU
# CHECK-NEXT: [14.1] - Zn4LSU
# CHECK-NEXT: [14.2] - Zn4LSU
# CHECK-NEXT: [15.0] - Zn4Load
# CHECK-NEXT: [15.1] - Zn4Load
# CHECK-NEXT: [15.2] - Zn4Load
# CHECK-NEXT: [16.0] - Zn4Store
# CHECK-NEXT: [16.1] - Zn4Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT: 0.67   0.67   0.67   2.00   2.00   2.00   2.00    -     177.50 303.00 268.50 161.00 123.00 123.00 6.00   77.33  77.33  77.33  75.33  75.33  75.33  3.00   3.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kaddd	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kaddq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kandd	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kandq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kandnd	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kandnq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kmovd	%k0, %k2
# CHECK-NEXT: 0.33   0.33   0.33    -      -      -      -      -      -      -      -      -      -      -      -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     kmovd	(%rax), %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -     kmovd	%k0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -     kmovd	%eax, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kmovd	%k0, %eax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kmovq	%k0, %k2
# CHECK-NEXT: 0.33   0.33   0.33    -      -      -      -      -      -      -      -      -      -      -      -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     kmovq	(%rax), %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -     kmovq	%k0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -     kmovq	%rax, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kmovq	%k0, %rax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     knotd	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     knotq	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kord	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     korq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kortestd	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kortestq	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -     kshiftld	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -     kshiftlq	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -     kshiftrd	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -     kshiftrq	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     ktestd	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     ktestq	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kunpckdq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kunpckwd	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kxnord	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kxnorq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kxord	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     kxorq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00    -      -      -      -      -      -      -      -      -      -      -     vdbpsadbw	$0, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vdbpsadbw	$0, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00    -      -      -      -      -      -      -      -      -      -      -     vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00    -      -      -      -      -      -      -      -      -      -      -     vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vmovdqu8	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vmovdqu8	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   0.33   0.33   0.33    -      -      -     0.50   0.50   vmovdqu8	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vmovdqu8	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vmovdqu8	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   0.33   0.33   0.33    -      -      -     0.50   0.50   vmovdqu8	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vmovdqu8	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vmovdqu8	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vmovdqu16	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vmovdqu16	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   0.33   0.33   0.33    -      -      -     0.50   0.50   vmovdqu16	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vmovdqu16	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vmovdqu16	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   0.33   0.33   0.33    -      -      -     0.50   0.50   vmovdqu16	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vmovdqu16	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vmovdqu16	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpabsb	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpabsb	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpabsb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpabsb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpabsb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpabsb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpabsw	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpabsw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpabsw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpabsw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpabsw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpabsw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackssdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackssdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackssdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackssdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackssdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackssdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpacksswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpacksswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpacksswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpacksswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpacksswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpacksswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackusdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackusdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackusdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackusdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackusdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackusdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackuswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackuswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackuswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackuswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpackuswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpackuswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpaddw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpaddw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpalignr	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpalignr	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpavgb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpavgb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpavgb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpavgb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpavgb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpavgb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpavgw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpavgw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpavgw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpavgw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpavgw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpavgw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpblendmb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpblendmb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpblendmb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpblendmb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpblendmb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpblendmb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpblendmw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpblendmw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpblendmw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpblendmw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpblendmw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpblendmw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastb	%xmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpbroadcastb	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastb	%eax, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastb	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpbroadcastb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastb	%eax, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastb	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpbroadcastb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastb	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastw	%xmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpbroadcastw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastw	%eax, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastw	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpbroadcastw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastw	%eax, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastw	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpbroadcastw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpbroadcastw	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     vpcmpgtb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpgtb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpgtb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpgtb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     vpcmpgtw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpgtw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpgtw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpgtw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpequb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpequb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpequb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpequb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpequw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpequw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpequw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpequw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -     vpextrb	$0, %xmm16, %eax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   0.33   0.33   0.33    -      -      -     0.50   0.50   vpextrb	$0, %xmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -     vpextrw	$0, %xmm16, %eax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   0.33   0.33   0.33    -      -      -     0.50   0.50   vpextrw	$0, %xmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -     vpinsrb	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpinsrb	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -     vpinsrw	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpinsrw	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermi2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermi2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermi2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermi2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermi2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermi2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermt2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermt2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermt2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermt2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpermt2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpermt2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmaddubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaddubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmaddwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaddwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaddwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaddwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmaxuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpminuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpminuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     1.00   1.00   1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vpmovb2m	%zmm0, %k0
# CHECK-NEXT:  -      -      -     1.00   1.00   1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vpmovw2m	%zmm0, %k0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vpmovm2b	%k0, %zmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     vpmovm2w	%k0, %zmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovsxbw	%ymm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovsxbw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovsxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovsxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovsxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovsxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovswb	%zmm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovswb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovswb	%zmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovuswb	%zmm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovuswb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovuswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovuswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovuswb	%zmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovwb	%zmm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovwb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovwb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovwb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovwb	%zmm16, %ymm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovzxbw	%ymm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovzxbw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovzxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovzxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpmovzxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.50   1.50    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmovzxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhrsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhrsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmulhw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmulhw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmullw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmullw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmullw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmullw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vpmullw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -     1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpmullw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00    -      -      -      -      -      -      -      -      -      -      -     vpsadbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsadbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpshufb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshufb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpshufb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshufb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpshufb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshufb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpshufhw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshufhw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpshufhw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshufhw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpshufhw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshufhw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpshuflw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshuflw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpshuflw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshuflw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpshuflw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpshuflw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpslldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpslldq	$1, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsllvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsllvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsllvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsllw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsllw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsllw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsllw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsllw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsllw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsllw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsravw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsravw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsravw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsravw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsravw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsravw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsraw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsraw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsraw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsraw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsraw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsraw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsraw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsraw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsraw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsraw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsraw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsraw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrldq	$1, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsrlvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrlw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrlw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrlw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrlw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrlw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vpsrlw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsrlw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     vpsubb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -      -      -      -      -      -      -      -      -      -     vpsubw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vpsubw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpsubw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vptestmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vptestmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vptestmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vptestmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vptestnmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestnmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vptestnmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestnmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -      -      -      -      -      -      -      -      -      -      -     vptestnmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestnmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.50   2.50    -      -      -      -      -      -      -      -      -      -      -      -      -     vptestnmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vptestnmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpckhbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpckhbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpckhwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpckhwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpcklbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpcklbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpcklwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpcklwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -      -      -      -      -      -      -      -      -      -      -      -     vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     0.50   0.50    -     0.33   0.33   0.33   0.33   0.33   0.33    -      -     vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1} {z}
